(ns njord.kernel
  (:require [langohr.basic :as basic]
            [langohr.channel :as channel]
            [langohr.queue :as queue]
            [langohr.consumers :as consumers]
            [njord.common :refer [uuid4]])
  (:gen-class))

(def ^:private futures (atom {}))

(def ^:private queue (delay (format "njord-kernel-%s" (uuid4))))

(def ^:private running (atom false))

(defn- on-msg [chan {:keys [headers delivery-tag]} body]
  (let [etag (str (get headers "etag"))]
    (when (contains? @futures etag)
      ((get @futures etag) (new String ^bytes body))
      (swap! futures dissoc etag)))
  (basic/ack chan delivery-tag))

(defn- queue-declare [conn]
  (doto (channel/open conn)
    (queue/declare @queue {:durable false :exclusive true})
    (consumers/subscribe @queue on-msg)))

(defn add-promise [etag prom]
  (swap! futures assoc etag prom))

(defn get-queue []
  @queue)

(defn start [conn]
  (when-not @running
    (reset! running true)
    (queue-declare conn)))
