(ns njord.http.common
  (:import java.security.MessageDigest
           java.util.UUID
           javax.xml.bind.DatatypeConverter)
  (:require [clojure.string :refer [lower-case]])
  (:gen-class))

(defmacro thread-call [& body]
  `(.start (Thread. (fn [] (list ~@body)))))

(defn sha1-digest [data]
  (.digest (MessageDigest/getInstance "sha1") data))

(defn sha1 [data]
  (-> data .getBytes sha1-digest DatatypeConverter/printHexBinary lower-case))

(defn uuid4 []
  (str (UUID/randomUUID)))
