(ns legio-fx.i18n
  (:require [clojure.data :refer [diff]])
  (:import [java.util Locale ResourceBundle])
  (:gen-class))

(def bundles (atom nil))

(defn language->locale [lang country]
  (if country
    (new Locale lang country)
    (new Locale lang)))

(defn set-bundle [^String name lang & [country]]
  (let [locale (language->locale lang country)
        data {:res (ResourceBundle/getBundle name ^Locale locale)
              :lang lang
              :country country}]
    (swap! bundles assoc name data)
    data))

(defn get-bundle* [name]
  (if-let [bundle (get bundles name)]
    bundle
    (let [locale (Locale/getDefault)]
      (set-bundle name (.getLanguage locale) (.getCountry locale)))))

(defn get-bundle [name]
  (:res (get-bundle* name)))

(defn get-string [name key]
  (.getString ^ResourceBundle (:res (get-bundle* name)) key))

(defn add-listener [key cb]
  (->> (fn [key ref old-val new-val]
         (let [[_ changed _] (diff old-val new-val)]
           (if changed
             (doseq [[name data] changed]
               (cb key name (:lang data) (:country data))))))
       (add-watch bundles key)))
