(ns legio-fx.gui.table
  (:refer-clojure :exclude [sort])
  (:require [legio-fx.concurrent :refer [fx-run]])
  (:import javafx.beans.value.ChangeListener
           javafx.event.EventHandler
           javafx.scene.input.MouseEvent
           javafx.scene.control.cell.PropertyValueFactory
           javafx.scene.control.Label
           javafx.scene.control.SelectionMode
           javafx.scene.control.TableColumn
           javafx.scene.control.TableColumn$SortType
           javafx.scene.control.TableView)
  (:gen-class))

(def select-types
  {:single SelectionMode/SINGLE
   :multi SelectionMode/MULTIPLE})

(def sort-directions
  {:asc TableColumn$SortType/ASCENDING
   :desc TableColumn$SortType/DESCENDING})

(defn on-row-click [^TableView tv handler & [clicks]]
  (let [clicks (or clicks 1)]
    (.setOnMousePressed tv (proxy [EventHandler] []
                             (handle [^MouseEvent e]
                               (if (and (.isPrimaryButtonDown e) (= (.getClickCount e) clicks))
                                 (if-let [selected (-> tv .getSelectionModel .getSelectedItem)]
                                   (handler selected))))))))

(defn on-item-selected [^TableView tv handler]
  (.addListener
   (.selectedItemProperty (.getSelectionModel tv))
   (proxy [ChangeListener] []
     (changed [ob old-val new-val] (handler old-val new-val)))))

(defn set-selection-mode [^TableView tv mode]
  (.setSelectionMode (.getSelectionModel tv) (get select-types mode)))

(defn add-column [^TableView tv title prop-name]
  (let [col (new TableColumn title)]
    (.setCellValueFactory col (new PropertyValueFactory prop-name))
    (-> tv .getColumns (.add col))
    col))

(defn clear-columns [^TableView tv]
  (-> tv .getColumns .clear))

(defn set-sort-direction [^TableColumn col dir]
  (.setSortType col (get sort-directions dir)))

(defn add-sort-order [^TableView tv col]
  (.add (.getSortOrder tv) col))

(defn link-view [^TableView tv ol]
  (fx-run (.setItems tv ol)))

(defn get-items [^TableView tv]
  ( .getItems tv))

(defn set-placeholder [^TableView tv text]
  (fx-run (.setPlaceholder tv (new Label text))))

(defn get-selections [tv]
  (.toArray (.getSelectedItems (.getSelectionModel ^TableView tv))))

(defn sort [^TableView tv]
  (.sort tv))
