(ns augustus.pools
  (:import [java.util.concurrent Executors ExecutorService ThreadFactory])
  (:gen-class))

(defn- factory-set-name [^Thread t]
  (.setName t (str "augustus-thread-" (.getId t))))

(defn- factory []
  (proxy [ThreadFactory] []
    (newThread [r]
      (doto (new Thread ^Runnable r)
        factory-set-name))))

(def ^ExecutorService main-pool (Executors/newCachedThreadPool (factory)))

(def ^ExecutorService sched-pool (Executors/newSingleThreadScheduledExecutor (factory)))

(defn shutdown []
  (.shutdown main-pool)
  (.shutdown sched-pool))
