(ns augustus.async
  (:require [augustus.future :as future]
            [augustus.pools :as pools])
  (:gen-class))

(defn execute* [f]
  (.execute pools/main-pool f))

(defmacro execute [& body]
  `(execute* (fn [] (list ~@body))))

(defn add-callback [f & args]
  (execute (apply f args)))

(defn submit* [f]
  (let [fut (future/new-future)]
    (execute* #(try
                 (future/set-result fut (f))
                 (catch Exception ex
                   (future/set-exception fut ex))))
    fut))

(defmacro submit [& body]
  `(submit* (fn [] (last (list ~@body)))))

(defn call [f & args]
  (submit (apply f args)))
