(ns augustus.timed
  (:require [augustus.async :as async]
            [augustus.future :as future]
            [augustus.pools :as pools])
  (:import java.lang.Runnable
           [java.util.concurrent ScheduledExecutorService TimeUnit])
  (:gen-class))

(def default-unit TimeUnit/MILLISECONDS)

(defn schedule* [^Long t ^Runnable f]
  (.schedule ^ScheduledExecutorService pools/sched-pool f t ^TimeUnit default-unit)
  nil)

(defn add-timeout [t f & args]
  (schedule* t (fn [] (apply f args))))

(defmacro execute-after [t & body]
  `(schedule* ~t (fn [] (async/execute* (list ~@body)))))

(defn submit-after* [t f]
  (let [fut (future/new-future)]
    (schedule* t (fn []
                   (async/execute
                    (try
                      (future/set-result fut (f))
                      (catch Exception ex
                        (future/set-exception fut ex))))))
    fut))

(defmacro submit-after [t & body]
  `(submit-after* ~t (fn [] (last (list ~@body)))))

(defn call-after [t f & args]
  (submit-after t (apply f args)))

(defn add-delay-coroutine* [^Long t ^Runnable callback]
  (.scheduleWithFixedDelay ^ScheduledExecutorService pools/sched-pool callback t t ^TimeUnit default-unit))

(defn add-rate-coroutine* [^Long t ^Runnable callback]
  (.scheduleAtFixedRate ^ScheduledExecutorService pools/sched-pool callback t t ^TimeUnit default-unit))

(defmacro add-delay-coroutine [t & body]
  `(add-delay-coroutine* ~t (fn [] (list ~@body))))

(defmacro add-rate-coroutine [t & body]
  `(add-rate-coroutine* ~t (fn [] (list ~@body))))
