/*
 * Decompiled with CFR 0.152.
 */
package br.com.gencrawler.crawler.build;

import br.com.gencrawler.crawler.build.CrawlerBuilder;
import br.com.gencrawler.crawler.core.SimpleExtractor;

public class SimpleExtractorBuilder
implements CrawlerBuilder {
    private final SimpleExtractor extractor = new SimpleExtractor();
    private String initialPage;
    private String paginator;
    private String finderProduct;
    private String match;

    public SimpleExtractorBuilder setInitial(String page) {
        this.initialPage = page;
        return this;
    }

    public SimpleExtractorBuilder setPaginator(String paginator) {
        this.paginator = paginator;
        return this;
    }

    @Override
    public SimpleExtractorBuilder setFinder(String product) {
        this.finderProduct = product;
        return this;
    }

    @Override
    public SimpleExtractorBuilder setMatch(String match) {
        this.match = match;
        return this;
    }

    @Override
    public void verify() {
        if (this.initialPage == null || this.paginator == null || this.finderProduct == null || this.match == null || this.initialPage.equals("") || this.paginator.equals("") || this.finderProduct.equals("") || this.match.equals("")) {
            throw new RuntimeException("Peat all data");
        }
    }

    @Override
    public SimpleExtractor build() {
        this.verify();
        this.extractor.runPagesLinks(this.initialPage, this.paginator);
        this.extractor.runItem(this.finderProduct, this.match, this.initialPage);
        return this.extractor;
    }
}

