# Small Clojure Interpreter

[![CircleCI](https://circleci.com/gh/borkdude/sci/tree/master.svg?style=shield)](https://circleci.com/gh/borkdude/sci/tree/master)
[![Clojars Project](https://img.shields.io/clojars/v/borkdude/sci.svg)](https://clojars.org/borkdude/sci)
[![cljdoc badge](https://cljdoc.org/badge/borkdude/sci)](https://cljdoc.org/d/borkdude/sci/CURRENT)

A tiny implementation of Clojure in Clojure.

## Rationale

Sometimes `eval` is not an option but you still want to have the ability to execute a subset of Clojure.

This might come in handy in:

- ClojureScript compiled with `:advanced`
- GraalVM binaries

By default `sci` only enables access to the data-centric pure functions in
Clojure, but more functions can be enabled using `:bindings`.

## Status

Experimental. Breaking changes are expected to happen at this phase. This
library aims to be compatible with advanced ClojureScript and GraalVM native
binaries. It is used as the interpreter for
[babashka](https://github.com/borkdude/babashka).

## Installation

``` shellsession
[borkdude/sci "0.0.1"]
```

## Usage

``` clojure
(require '[sci.core :as sci])
(sci/eval-string "(inc 1)") => ;; 2
(sci/eval-string "(inc x)" {:bindings {'x 2}} ;;=> 3
```

Anonymous functions literals are allowed with currently up to three positional
arguments.

``` clojure
(sci/eval-string "(#(+ %1 %2 %3) 1 2 3)") => ;; 6
```

Currently, only the special forms/macros `if`, `when`, `and`, `or`, `->` and
`->>` are supported.

## Test

Run all tests:

    script/test

This will run tests on the JVM, Node.js and using a GraalVM binary.

Test the native version:

    SCI_TEST_ENV=native script/test

## Build

You will need leiningen and GraalVM.

    script/compile

## License

Copyright © 2019 Michiel Borkent

Distributed under the EPL License, same as Clojure. See LICENSE.
