(ns naw.core
  {:no-doc true}
  (:require [#?(:clj clojure.test
                :cljs cljs.test) :refer [report
                                         #?(:clj *report-counters*)
                                         #?(:cljs get-current-env)]]))

(defonce state (atom {}))

(defn assertion-count []
  (let [rc #?(:clj @*report-counters*
              :cljs (:report-counters (get-current-env)))]
    (+ (get rc :pass 0)
       (get rc :fail 0)
       (get rc :error 0))))

(let [old-method (get-method report #?(:clj :begin-test-var
                                       :cljs [::default :begin-test-var]))]
  (defmethod report #?(:clj :begin-test-var
                       :cljs [::default :begin-test-var]) [m]
    (let [ret (when old-method (old-method m))]
      (swap! state assoc (-> m :var meta :name) (assertion-count))
      ret)))

(let [old-method (get-method report #?(:clj :end-test-var
                                       :cljs [::default :end-test-var]))]
  (defmethod report #?(:clj :end-test-var
                       :cljs [::default :end-test-var]) [m]
    (let [test-name (-> m :var meta :name)
          ret (when old-method (old-method m))
          ac (assertion-count)]
      (when (= ac (get @state test-name))
        (#?@(:clj [binding [*out* *err*]]
             :cljs [binding [*print-fn* *print-err-fn*]]))
        (println "WARNING: no assertions made in test" test-name))
      ret)))
