(ns naw.core
  (:require [clojure.test :refer [report *report-counters*]]))

(def state (atom 0))

(defn assertion-count []
  (let [rc @*report-counters*]
    (+ (get rc :pass 0)
       (get rc :fail 0)
       (get rc :error 0))))

(let [old-method (get-method report :begin-test-var)]
  (defmethod report :begin-test-var [m]
    (when old-method (old-method m))
    (reset! state (assertion-count))))

(let [old-method (get-method report :end-test-var)]
  (defmethod report :end-test-var [m]
    (when old-method (old-method m))
    (let [ac (assertion-count)]
      (when (= ac @state)
        (binding [*out* *err*]
          (println "WARNING: no assertions made in test" (-> m :var meta :name)))))))
