/*
 * Decompiled with CFR 0.152.
 */
package boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileLock;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.DatatypeConverter;
import org.projectodd.shimdandy.ClojureRuntimeShim;

public class App {
    private static File aetherfile = null;
    private static File[] podjars = null;
    private static File[] corejars = null;
    private static File[] workerjars = null;
    private static String cljversion = null;
    private static String cljname = null;
    private static String bootversion = null;
    private static String localrepo = null;
    private static String appversion = null;
    private static String channel = "RELEASE";
    private static String booturl = "http://boot-clj.com";
    private static String githuburl = "https://api.github.com/repos/boot-clj/boot/releases";
    private static ClojureRuntimeShim aethershim = null;
    private static HashMap<String, File[]> depsCache = null;
    private static final File homedir = new File(System.getProperty("user.home"));
    private static final File workdir = new File(System.getProperty("user.dir"));
    private static final String aetherjar = "aether.uber.jar";
    private static final AtomicLong counter = new AtomicLong(0L);
    private static final ExecutorService ex = Executors.newCachedThreadPool();
    private static final WeakHashMap<ClojureRuntimeShim, Object> pods = new WeakHashMap();
    private static final ConcurrentHashMap<String, String> stash = new ConcurrentHashMap();

    public static String getVersion() {
        return appversion;
    }

    public static String getBootVersion() {
        return bootversion;
    }

    public static String getClojureName() {
        return cljname;
    }

    public static WeakHashMap<ClojureRuntimeShim, Object> getPods() {
        return pods;
    }

    public static String getStash(String key) throws Exception {
        String ret = stash.get(key);
        stash.remove(key);
        return ret;
    }

    public static String setStash(String value) throws Exception {
        String key = UUID.randomUUID().toString();
        stash.put(key, value);
        return key;
    }

    private static long nextId() {
        return counter.addAndGet(1L);
    }

    public static File getBootDir() throws Exception {
        return App.bootdir();
    }

    public static boolean isWindows() throws Exception {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    }

    public static File mkFile(File parent, String ... kids) throws Exception {
        File ret = parent;
        for (String k : kids) {
            ret = new File(ret, k);
        }
        return ret;
    }

    public static void mkParents(File f) throws Exception {
        File ff = f.getCanonicalFile().getParentFile();
        if (!ff.exists()) {
            ff.mkdirs();
        }
    }

    public static ClassLoader tccl() throws Exception {
        return Thread.currentThread().getContextClassLoader();
    }

    public static InputStream resource(String path) throws Exception {
        return App.tccl().getResourceAsStream(path);
    }

    public static Properties propertiesResource(String path) throws Exception {
        Properties p = new Properties();
        try (InputStream is = App.resource(path);){
            p.load(is);
        }
        return p;
    }

    public static File bootdir() throws Exception {
        File h = new File(System.getProperty("user.home"));
        String a = System.getProperty("BOOT_HOME");
        String b = System.getenv("BOOT_HOME");
        String c = new File(h, ".boot").getCanonicalPath();
        return new File(a != null ? a : (b != null ? b : c));
    }

    public static String md5hash(String data) throws Exception {
        MessageDigest algo = MessageDigest.getInstance("MD5");
        return DatatypeConverter.printHexBinary((byte[])algo.digest(data.getBytes()));
    }

    public static File projectDir() throws Exception {
        for (File f = workdir; f != null; f = f.getParentFile()) {
            File tmp = new File(f, ".git");
            if (!tmp.exists() || !tmp.isDirectory()) continue;
            return f;
        }
        return null;
    }

    public static HashMap<String, String> properties2map(Properties p) throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            m.put((String)e.getKey(), (String)e.getValue());
        }
        return m;
    }

    public static Properties map2properties(HashMap<String, String> m) throws Exception {
        Properties p = new Properties();
        for (Map.Entry<String, String> e : m.entrySet()) {
            p.setProperty(e.getKey(), e.getValue());
        }
        return p;
    }

    public static HashMap<String, File> propertiesFiles() throws Exception {
        HashMap<String, File> ret = new HashMap<String, File>();
        String[] names = new String[]{"boot", "project", "cwd"};
        File[] dirs = new File[]{App.bootdir(), App.projectDir(), workdir};
        for (int i = 0; i < dirs.length; ++i) {
            ret.put(names[i], new File(dirs[i], "boot.properties"));
        }
        return ret;
    }

    public static Properties mergeProperties() throws Exception {
        Properties p = new Properties();
        HashMap<String, File> fs = App.propertiesFiles();
        for (String k : new String[]{"boot", "project", "cwd"}) {
            try (FileInputStream is = new FileInputStream(fs.get(k));){
                p.load(is);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return p;
    }

    public static void setDefaultProperty(Properties p, String k, String dfl) throws Exception {
        if (p.getProperty(k) == null) {
            p.setProperty(k, dfl);
        }
    }

    public static HashMap<String, String> config() throws Exception {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.putAll(App.properties2map(App.mergeProperties()));
        ret.remove("BOOT_HOME");
        ret.putAll(System.getenv());
        ret.putAll(App.properties2map(System.getProperties()));
        Iterator i = ret.keySet().iterator();
        while (i.hasNext()) {
            String k = (String)i.next();
            if (k.startsWith("BOOT_")) continue;
            i.remove();
        }
        return ret;
    }

    public static String config(String k) throws Exception {
        return App.config().get(k);
    }

    public static String config(String k, String dfl) throws Exception {
        String v = App.config(k);
        if (v != null) {
            return v;
        }
        System.setProperty(k, dfl);
        return dfl;
    }

    private static String jarVersion(File f, String prefix) throws Exception {
        String n = f.getName();
        if (!n.startsWith(prefix)) {
            return null;
        }
        return n.substring(prefix.length()).replaceAll(".jar$", "");
    }

    private static Properties writeProps(File f) throws Exception {
        App.mkParents(f);
        ClojureRuntimeShim a = App.aetherShim();
        Properties p = new Properties();
        String c = cljversion;
        String n = cljname;
        String t = null;
        try (File[] is2 = new FileInputStream(f);){
            p.load((InputStream)is2);
        }
        catch (FileNotFoundException is2) {
            // empty catch block
        }
        if (bootversion == null) {
            for (File x : App.resolveDepJars(a, "boot", channel, n, c)) {
                t = App.jarVersion(x, "boot-");
                if (null == t) continue;
                bootversion = t;
            }
        }
        p.setProperty("BOOT_VERSION", bootversion);
        App.setDefaultProperty(p, "BOOT_CLOJURE_NAME", n);
        App.setDefaultProperty(p, "BOOT_CLOJURE_VERSION", c);
        try (FileOutputStream os = new FileOutputStream(f);){
            p.store(os, booturl);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Properties readProps(File f, boolean create) throws Exception {
        App.mkParents(f);
        FileLock lock = null;
        Properties p = new Properties();
        if (!App.isWindows() && f.exists()) {
            lock = new RandomAccessFile(f, "rw").getChannel().lock();
        }
        try {
            Properties properties;
            Serializable serializable;
            FileInputStream is;
            block22: {
                block23: {
                    is = new FileInputStream(f);
                    serializable = null;
                    p.load(is);
                    if (p.getProperty("BOOT_CLOJURE_VERSION") == null || p.getProperty("BOOT_VERSION") == null) {
                        throw new Exception("missing info");
                    }
                    properties = p;
                    if (is == null) break block22;
                    if (serializable == null) break block23;
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)serializable).addSuppressed(throwable);
                    }
                    break block22;
                }
                is.close();
            }
            return properties;
            catch (Throwable throwable) {
                try {
                    try {
                        serializable = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (is != null) {
                            if (serializable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)serializable).addSuppressed(throwable3);
                                }
                            } else {
                                is.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable e) {
                    if (!create) {
                        serializable = null;
                        return serializable;
                    }
                    serializable = App.writeProps(f);
                    return serializable;
                }
            }
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    private static HashMap<String, File[]> seedCache() throws Exception {
        if (depsCache != null) {
            return depsCache;
        }
        ClojureRuntimeShim a = App.aetherShim();
        HashMap<String, File[]> cache = new HashMap<String, File[]>();
        cache.put("boot/pod", App.resolveDepJars(a, "boot/pod"));
        cache.put("boot/core", App.resolveDepJars(a, "boot/core"));
        cache.put("boot/worker", App.resolveDepJars(a, "boot/worker"));
        depsCache = cache;
        return depsCache;
    }

    private static Object validateCache(File f, Object cache) throws Exception {
        Iterator iterator = ((HashMap)cache).values().iterator();
        while (iterator.hasNext()) {
            File[] fs;
            for (File d : fs = (File[])iterator.next()) {
                if (d.exists() && f.lastModified() >= d.lastModified()) continue;
                throw new Exception("dep jar doesn't exist");
            }
        }
        return cache;
    }

    private static Object writeCache(File f, Object m) throws Exception {
        App.mkParents(f);
        try (FileOutputStream os = new FileOutputStream(f);
             ObjectOutputStream oos = new ObjectOutputStream(os);){
            oos.writeObject(m);
        }
        return m;
    }

    /*
     * Exception decompiling
     */
    private static Object readCache(File f) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ClojureRuntimeShim newShim(String name, Object data, File[] jarFiles) throws Exception {
        File[] hooks;
        URL[] urls = new URL[jarFiles.length];
        for (int i = 0; i < jarFiles.length; ++i) {
            urls[i] = jarFiles[i].toURI().toURL();
        }
        URLClassLoader cl = new URLClassLoader(urls, App.class.getClassLoader());
        ClojureRuntimeShim rt = ClojureRuntimeShim.newRuntime((ClassLoader)cl);
        rt.setName(name != null ? name : "anonymous");
        for (File hook : hooks = new File[]{new File(App.bootdir(), "boot-shim.clj"), new File("boot-shim.clj")}) {
            if (!hook.exists()) continue;
            rt.invoke("clojure.core/load-file", (Object)hook.getPath());
        }
        rt.require(new String[]{"boot.pod"});
        rt.invoke("boot.pod/seal-app-classloader");
        rt.invoke("boot.pod/set-data!", data);
        rt.invoke("boot.pod/set-pods!", pods);
        rt.invoke("boot.pod/set-this-pod!", new WeakReference<ClojureRuntimeShim>(rt));
        pods.put(rt, new Object());
        return rt;
    }

    public static ClojureRuntimeShim newPod(String name, Object data) throws Exception {
        return App.newShim(name, data, podjars);
    }

    public static ClojureRuntimeShim newPod(String name, Object data, File[] jarFiles) throws Exception {
        int i;
        File[] files = new File[jarFiles.length + podjars.length];
        for (i = 0; i < podjars.length; ++i) {
            files[i] = podjars[i];
        }
        for (i = 0; i < jarFiles.length; ++i) {
            files[i + App.podjars.length] = jarFiles[i];
        }
        return App.newShim(name, data, files);
    }

    private static ClojureRuntimeShim aetherShim() throws Exception {
        if (aethershim == null) {
            App.ensureResourceFile(aetherjar, aetherfile);
            aethershim = App.newShim("aether", null, new File[]{aetherfile});
        }
        return aethershim;
    }

    public static void extractResource(String resource, File outfile) throws Exception {
        App.mkParents(outfile);
        int n = 0;
        byte[] buf = new byte[4096];
        try (InputStream in = App.resource(resource);
             FileOutputStream out = new FileOutputStream(outfile);){
            while ((n = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, n);
            }
        }
    }

    public static void ensureResourceFile(String r, File f) throws Exception {
        if (!f.exists()) {
            App.extractResource(r, f);
        }
    }

    public static File[] resolveDepJars(ClojureRuntimeShim shim, String sym) {
        return App.resolveDepJars(shim, sym, bootversion, cljname, cljversion);
    }

    public static File[] resolveDepJars(ClojureRuntimeShim shim, String sym, String bootversion, String cljname, String cljversion) {
        shim.require(new String[]{"boot.aether"});
        if (localrepo != null) {
            shim.invoke("boot.aether/set-local-repo!", (Object)localrepo);
        }
        shim.invoke("boot.aether/update-always!");
        return (File[])shim.invoke("boot.aether/resolve-dependency-jars", (Object)sym, (Object)bootversion, (Object)cljname, (Object)cljversion);
    }

    public static Future<ClojureRuntimeShim> newShimFuture(final String name, final Object data, final File[] jars) throws Exception {
        return ex.submit(new Callable(){

            public ClojureRuntimeShim call() throws Exception {
                return App.newShim(name, data, jars);
            }
        });
    }

    public static Future<ClojureRuntimeShim> newCore(Object data) throws Exception {
        return App.newShimFuture("core", data, corejars);
    }

    public static Future<ClojureRuntimeShim> newWorker() throws Exception {
        return App.newShimFuture("worker", null, workerjars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int runBoot(Future<ClojureRuntimeShim> core, Future<ClojureRuntimeShim> worker, String[] args) throws Exception {
        Iterator iterator;
        int n;
        ConcurrentLinkedQueue hooks = new ConcurrentLinkedQueue();
        try {
            if (localrepo != null) {
                worker.get().require(new String[]{"boot.aether"});
                worker.get().invoke("boot.aether/set-local-repo!", (Object)localrepo);
            }
            core.get().require(new String[]{"boot.main"});
            core.get().invoke("boot.main/-main", (Object)App.nextId(), (Object)worker.get(), hooks, (Object)args);
            n = -1;
            iterator = hooks.iterator();
        }
        catch (Throwable t) {
            try {
                int n2 = t instanceof Exit ? Integer.parseInt(t.getMessage()) : -2;
                return n2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                for (Runnable h : hooks) {
                    h.run();
                }
                try {
                    core.get().close();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        while (iterator.hasNext()) {
            Runnable h = (Runnable)iterator.next();
            h.run();
        }
        try {
            core.get().close();
            return n;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return n;
    }

    public static String readVersion() throws Exception {
        Properties p = new Properties();
        try (InputStream in = App.resource("boot/base/version.properties");){
            p.load(in);
        }
        return p.getProperty("version");
    }

    public static void printVersion() throws Exception {
        Properties p = new Properties();
        p.setProperty("BOOT_VERSION", App.config("BOOT_VERSION"));
        p.setProperty("BOOT_CLOJURE_NAME", App.config("BOOT_CLOJURE_NAME"));
        p.setProperty("BOOT_CLOJURE_VERSION", App.config("BOOT_CLOJURE_VERSION"));
        p.store(System.out, booturl);
    }

    public static void updateBoot(File bootprops, String chan) throws Exception {
        bootversion = null;
        channel = chan;
        Properties p = App.writeProps(bootprops);
        p.store(System.out, booturl);
    }

    public static void main(String[] args) throws Exception {
        if (System.getProperty("user.name").equals("root") && !App.config("BOOT_AS_ROOT", "no").equals("yes")) {
            throw new Exception("refusing to run as root (set BOOT_AS_ROOT=yes to force)");
        }
        bootversion = appversion = App.readVersion();
        File cachehome = App.mkFile(App.bootdir(), "cache");
        File bootprops = App.mkFile(App.bootdir(), "boot.properties");
        File jardir = App.mkFile(cachehome, "lib", appversion);
        File bootcache = App.mkFile(cachehome, "cache", "boot");
        localrepo = App.config("BOOT_LOCAL_REPO");
        cljversion = App.config("BOOT_CLOJURE_VERSION", "1.7.0");
        cljname = App.config("BOOT_CLOJURE_NAME", "org.clojure/clojure");
        aetherfile = App.mkFile(cachehome, "lib", appversion, aetherjar);
        App.readProps(bootprops, true);
        if (args.length > 0 && (args[0].equals("-u") || args[0].equals("--update"))) {
            App.updateBoot(bootprops, "RELEASE");
            System.exit(0);
        }
        if (args.length > 0 && (args[0].equals("-U") || args[0].equals("--update-snapshot"))) {
            App.updateBoot(bootprops, "(0,)");
            System.exit(0);
        }
        if (args.length > 0 && (args[0].equals("-V") || args[0].equals("--version"))) {
            App.printVersion();
            System.exit(0);
        }
        String repo = localrepo == null ? "default" : App.md5hash(new File(localrepo).getCanonicalFile().getPath());
        File cachefile = App.mkFile(bootcache, repo, cljversion, bootversion, "deps.cache");
        HashMap cache = (HashMap)App.readCache(cachefile);
        podjars = (File[])cache.get("boot/pod");
        corejars = (File[])cache.get("boot/core");
        workerjars = (File[])cache.get("boot/worker");
        Thread shutdown = new Thread(){

            @Override
            public void run() {
                ex.shutdown();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdown);
        System.exit(App.runBoot(App.newCore(null), App.newWorker(), args));
    }

    public static class Exit
    extends Exception {
        public Exit(String m) {
            super(m);
        }

        public Exit(String m, Throwable c) {
            super(m, c);
        }
    }
}

