/*
 * Decompiled with CFR 0.152.
 */
package boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.projectodd.shimdandy.ClojureRuntimeShim;

public class App {
    private static File[] podjars = null;
    private static File[] corejars = null;
    private static File[] workerjars = null;
    private static File bootdir = null;
    private static File aetherfile = null;
    private static HashMap<String, File[]> depsCache = null;
    private static String cljversion = "1.6.0";
    private static final String appversion = "2.0.0";
    private static final String apprelease = "r1";
    private static final String depversion = "2.0.0-SNAPSHOT";
    private static final String aetherjar = "aether-2.0.0-SNAPSHOT.uber.jar";
    private static final AtomicLong counter = new AtomicLong(0L);
    private static final ExecutorService ex = Executors.newCachedThreadPool();

    private static long getNextId() {
        return counter.addAndGet(1L);
    }

    public static File getBootDir() {
        return bootdir;
    }

    public static String getVersion() {
        return appversion;
    }

    public static String getRelease() {
        return apprelease;
    }

    private static FileLock getLock(File f) throws Exception {
        File lockfile = new File(f.getPath() + ".lock");
        return new RandomAccessFile(lockfile, "rw").getChannel().lock();
    }

    private static HashMap<String, File[]> seedCache() throws Exception {
        if (depsCache != null) {
            return depsCache;
        }
        App.ensureResourceFile(aetherjar, aetherfile);
        ClojureRuntimeShim a = App.newShim(new File[]{aetherfile});
        HashMap<String, File[]> cache = new HashMap<String, File[]>();
        cache.put("boot/pod", App.resolveDepJars(a, "boot/pod"));
        cache.put("boot/core", App.resolveDepJars(a, "boot/core"));
        cache.put("boot/worker", App.resolveDepJars(a, "boot/worker"));
        depsCache = cache;
        return depsCache;
    }

    private static Object validateCache(Object cache) throws Exception {
        Iterator i$ = ((HashMap)cache).values().iterator();
        while (i$.hasNext()) {
            File[] fs;
            for (File f : fs = (File[])i$.next()) {
                if (f.exists()) continue;
                throw new Exception("dep jar doesn't exist");
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object writeCache(File f, Object m) throws Exception {
        try (FileOutputStream file = new FileOutputStream(f);){
            new ObjectOutputStream(file).writeObject(m);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object readCache(File f) throws Exception {
        FileLock lock = App.getLock(f);
        try {
            long max = 64800000L;
            long age = System.currentTimeMillis() - f.lastModified();
            if (age > max) {
                throw new Exception("cache age exceeds TTL");
            }
            Object object = App.validateCache(new ObjectInputStream(new FileInputStream(f)).readObject());
            return object;
        }
        catch (Throwable e) {
            System.err.println("checking for boot updates...");
            Object object = App.writeCache(f, App.seedCache());
            return object;
        }
        finally {
            lock.release();
        }
    }

    public static ClojureRuntimeShim newShim(File[] jarFiles) throws Exception {
        URL[] urls = new URL[jarFiles.length];
        for (int i = 0; i < jarFiles.length; ++i) {
            urls[i] = jarFiles[i].toURI().toURL();
        }
        URLClassLoader cl = new URLClassLoader(urls, App.class.getClassLoader());
        ClojureRuntimeShim rt = ClojureRuntimeShim.newRuntime((ClassLoader)cl);
        rt.require(new String[]{"boot.pod"});
        rt.invoke("boot.pod/seal-app-classloader");
        return rt;
    }

    public static ClojureRuntimeShim newPod() throws Exception {
        return App.newShim(podjars);
    }

    public static ClojureRuntimeShim newPod(File[] jarFiles) throws Exception {
        int i;
        File[] files = new File[jarFiles.length + podjars.length];
        for (i = 0; i < podjars.length; ++i) {
            files[i] = podjars[i];
        }
        for (i = 0; i < jarFiles.length; ++i) {
            files[i + App.podjars.length] = jarFiles[i];
        }
        return App.newShim(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractResource(String resource, File outfile) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream in = cl.getResourceAsStream(resource);
        FileOutputStream out = new FileOutputStream(outfile);
        int n = 0;
        byte[] buf = new byte[4096];
        try {
            while ((n = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, n);
            }
        }
        finally {
            in.close();
            ((OutputStream)out).close();
        }
    }

    public static void ensureResourceFile(String r, File f) throws Exception {
        if (!f.exists()) {
            App.extractResource(r, f);
        }
    }

    public static File[] resolveDepJars(ClojureRuntimeShim shim, String sym) {
        shim.require(new String[]{"boot.aether"});
        return (File[])shim.invoke("boot.aether/resolve-dependency-jars", (Object)sym, (Object)depversion, (Object)cljversion);
    }

    public static Future<ClojureRuntimeShim> newShimFuture(File[] jars) throws Exception {
        final File[] j = jars;
        return ex.submit(new Callable(){

            public ClojureRuntimeShim call() throws Exception {
                return App.newShim(j);
            }
        });
    }

    public static Future<ClojureRuntimeShim> newCore() throws Exception {
        return App.newShimFuture(corejars);
    }

    public static Future<ClojureRuntimeShim> newWorker() throws Exception {
        return App.newShimFuture(workerjars);
    }

    public static int runBoot(Future<ClojureRuntimeShim> core, Future<ClojureRuntimeShim> worker, String[] args) throws Exception {
        Future<ClojureRuntimeShim> c = core;
        Future<ClojureRuntimeShim> w = worker;
        ConcurrentLinkedQueue hooks = new ConcurrentLinkedQueue();
        try {
            c.get().require(new String[]{"boot.main"});
            c.get().invoke("boot.main/-main", (Object)App.getNextId(), (Object)w.get(), hooks, (Object)args);
            return -1;
        }
        catch (Throwable t) {
            for (Runnable h : hooks) {
                h.run();
            }
            return t instanceof Exit ? Integer.parseInt(t.getMessage()) : -2;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && (args[0].equals("-V") || args[0].equals("--version"))) {
            System.err.println("2.0.0-r1");
            System.exit(0);
        }
        String bhome = System.getenv("BOOT_HOME");
        String homed = System.getProperty("user.home");
        String clj_v = System.getenv("BOOT_CLOJURE_VERSION");
        if (clj_v != null) {
            cljversion = clj_v;
        }
        bootdir = bhome != null ? new File(bhome) : new File(new File(homed), ".boot");
        File jardir = new File(new File(bootdir, "lib"), apprelease);
        aetherfile = new File(jardir, aetherjar);
        File cachedir = new File(new File(bootdir, "cache"), cljversion);
        File cachefile = new File(cachedir, "deps.cache");
        jardir.mkdirs();
        cachedir.mkdirs();
        HashMap cache = (HashMap)App.readCache(cachefile);
        podjars = (File[])cache.get("boot/pod");
        corejars = (File[])cache.get("boot/core");
        workerjars = (File[])cache.get("boot/worker");
        Thread shutdown = new Thread(){

            @Override
            public void run() {
                ex.shutdown();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdown);
        System.exit(App.runBoot(App.newCore(), App.newWorker(), args));
    }

    public static class Exit
    extends Exception {
        public Exit(String m) {
            super(m);
        }

        public Exit(String m, Throwable c) {
            super(m, c);
        }
    }
}

