(ns bones.http.service
  (:require [com.stuartsierra.component :as component]
            ;; [aleph.http :as aleph] ;; loading bug
            [bidi.ring :refer [make-handler]]))

(defprotocol DevInfo
  (devinfo [cmp]))

(defrecord Server [conf routes]
  DevInfo
  (devinfo [cmp]
    {"listening on port: " (aleph.netty/port (:server cmp))})
  component/Lifecycle
  (start [cmp]
    (component/stop cmp) ;; always restart to avoid port taken error
    (let [config (get-in cmp [:conf :bones.http/service])
          app (get-in cmp [:routes])]
      (assoc cmp :server (aleph.http/start-server (make-handler (:routes app))
                                                  {:port (or (:port config) 3000)
                                                   :raw-stream? true}))))
  (stop [cmp]
    (when-let [server (:server cmp)]
      (.close server))
    ;; dissoc looses type
    (assoc cmp :server nil)))
