// Compiled by ClojureScript 1.9.229 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
re_frame.fx.register = cljs.core.partial.call(null,re_frame.registrar.register_handler,re_frame.fx.kind);
/**
 * An interceptor which actions a `context's` (side) `:effects`.
 * 
 *   For each key in the `:effects` map, call the `effects handler` previously
 *   registered using `reg-fx`.
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 *   call the registered effects handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
var seq__43057 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__43058 = null;
var count__43059 = (0);
var i__43060 = (0);
while(true){
if((i__43060 < count__43059)){
var vec__43061 = cljs.core._nth.call(null,chunk__43058,i__43060);
var effect_k = cljs.core.nth.call(null,vec__43061,(0),null);
var value = cljs.core.nth.call(null,vec__43061,(1),null);
var temp__4655__auto___43067 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_k,true);
if(cljs.core.truth_(temp__4655__auto___43067)){
var effect_fn_43068 = temp__4655__auto___43067;
effect_fn_43068.call(null,value);
} else {
}

var G__43069 = seq__43057;
var G__43070 = chunk__43058;
var G__43071 = count__43059;
var G__43072 = (i__43060 + (1));
seq__43057 = G__43069;
chunk__43058 = G__43070;
count__43059 = G__43071;
i__43060 = G__43072;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__43057);
if(temp__4657__auto__){
var seq__43057__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__43057__$1)){
var c__42260__auto__ = cljs.core.chunk_first.call(null,seq__43057__$1);
var G__43073 = cljs.core.chunk_rest.call(null,seq__43057__$1);
var G__43074 = c__42260__auto__;
var G__43075 = cljs.core.count.call(null,c__42260__auto__);
var G__43076 = (0);
seq__43057 = G__43073;
chunk__43058 = G__43074;
count__43059 = G__43075;
i__43060 = G__43076;
continue;
} else {
var vec__43064 = cljs.core.first.call(null,seq__43057__$1);
var effect_k = cljs.core.nth.call(null,vec__43064,(0),null);
var value = cljs.core.nth.call(null,vec__43064,(1),null);
var temp__4655__auto___43077 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_k,true);
if(cljs.core.truth_(temp__4655__auto___43077)){
var effect_fn_43078 = temp__4655__auto___43077;
effect_fn_43078.call(null,value);
} else {
}

var G__43079 = cljs.core.next.call(null,seq__43057__$1);
var G__43080 = null;
var G__43081 = (0);
var G__43082 = (0);
seq__43057 = G__43079;
chunk__43058 = G__43080;
count__43059 = G__43081;
i__43060 = G__43082;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.register.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__43083 = cljs.core.seq.call(null,value);
var chunk__43084 = null;
var count__43085 = (0);
var i__43086 = (0);
while(true){
if((i__43086 < count__43085)){
var map__43087 = cljs.core._nth.call(null,chunk__43084,i__43086);
var map__43087__$1 = ((((!((map__43087 == null)))?((((map__43087.cljs$lang$protocol_mask$partition0$ & (64))) || (map__43087.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43087):map__43087);
var effect = map__43087__$1;
var ms = cljs.core.get.call(null,map__43087__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__43087__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__43083,chunk__43084,count__43085,i__43086,map__43087,map__43087__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__43083,chunk__43084,count__43085,i__43086,map__43087,map__43087__$1,effect,ms,dispatch))
,ms);
}

var G__43091 = seq__43083;
var G__43092 = chunk__43084;
var G__43093 = count__43085;
var G__43094 = (i__43086 + (1));
seq__43083 = G__43091;
chunk__43084 = G__43092;
count__43085 = G__43093;
i__43086 = G__43094;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__43083);
if(temp__4657__auto__){
var seq__43083__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__43083__$1)){
var c__42260__auto__ = cljs.core.chunk_first.call(null,seq__43083__$1);
var G__43095 = cljs.core.chunk_rest.call(null,seq__43083__$1);
var G__43096 = c__42260__auto__;
var G__43097 = cljs.core.count.call(null,c__42260__auto__);
var G__43098 = (0);
seq__43083 = G__43095;
chunk__43084 = G__43096;
count__43085 = G__43097;
i__43086 = G__43098;
continue;
} else {
var map__43089 = cljs.core.first.call(null,seq__43083__$1);
var map__43089__$1 = ((((!((map__43089 == null)))?((((map__43089.cljs$lang$protocol_mask$partition0$ & (64))) || (map__43089.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43089):map__43089);
var effect = map__43089__$1;
var ms = cljs.core.get.call(null,map__43089__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__43089__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__43083,chunk__43084,count__43085,i__43086,map__43089,map__43089__$1,effect,ms,dispatch,seq__43083__$1,temp__4657__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__43083,chunk__43084,count__43085,i__43086,map__43089,map__43089__$1,effect,ms,dispatch,seq__43083__$1,temp__4657__auto__))
,ms);
}

var G__43099 = cljs.core.next.call(null,seq__43083__$1);
var G__43100 = null;
var G__43101 = (0);
var G__43102 = (0);
seq__43083 = G__43099;
chunk__43084 = G__43100;
count__43085 = G__43101;
i__43086 = G__43102;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.register.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.register.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
}

var seq__43103 = cljs.core.seq.call(null,value);
var chunk__43104 = null;
var count__43105 = (0);
var i__43106 = (0);
while(true){
if((i__43106 < count__43105)){
var event = cljs.core._nth.call(null,chunk__43104,i__43106);
re_frame.router.dispatch.call(null,event);

var G__43107 = seq__43103;
var G__43108 = chunk__43104;
var G__43109 = count__43105;
var G__43110 = (i__43106 + (1));
seq__43103 = G__43107;
chunk__43104 = G__43108;
count__43105 = G__43109;
i__43106 = G__43110;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__43103);
if(temp__4657__auto__){
var seq__43103__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__43103__$1)){
var c__42260__auto__ = cljs.core.chunk_first.call(null,seq__43103__$1);
var G__43111 = cljs.core.chunk_rest.call(null,seq__43103__$1);
var G__43112 = c__42260__auto__;
var G__43113 = cljs.core.count.call(null,c__42260__auto__);
var G__43114 = (0);
seq__43103 = G__43111;
chunk__43104 = G__43112;
count__43105 = G__43113;
i__43106 = G__43114;
continue;
} else {
var event = cljs.core.first.call(null,seq__43103__$1);
re_frame.router.dispatch.call(null,event);

var G__43115 = cljs.core.next.call(null,seq__43103__$1);
var G__43116 = null;
var G__43117 = (0);
var G__43118 = (0);
seq__43103 = G__43115;
chunk__43104 = G__43116;
count__43105 = G__43117;
i__43106 = G__43118;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.register.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__43119 = cljs.core.seq.call(null,((cljs.core.sequential_QMARK_.call(null,value))?value:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [value], null)));
var chunk__43120 = null;
var count__43121 = (0);
var i__43122 = (0);
while(true){
if((i__43122 < count__43121)){
var event = cljs.core._nth.call(null,chunk__43120,i__43122);
clear_event.call(null,event);

var G__43123 = seq__43119;
var G__43124 = chunk__43120;
var G__43125 = count__43121;
var G__43126 = (i__43122 + (1));
seq__43119 = G__43123;
chunk__43120 = G__43124;
count__43121 = G__43125;
i__43122 = G__43126;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__43119);
if(temp__4657__auto__){
var seq__43119__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__43119__$1)){
var c__42260__auto__ = cljs.core.chunk_first.call(null,seq__43119__$1);
var G__43127 = cljs.core.chunk_rest.call(null,seq__43119__$1);
var G__43128 = c__42260__auto__;
var G__43129 = cljs.core.count.call(null,c__42260__auto__);
var G__43130 = (0);
seq__43119 = G__43127;
chunk__43120 = G__43128;
count__43121 = G__43129;
i__43122 = G__43130;
continue;
} else {
var event = cljs.core.first.call(null,seq__43119__$1);
clear_event.call(null,event);

var G__43131 = cljs.core.next.call(null,seq__43119__$1);
var G__43132 = null;
var G__43133 = (0);
var G__43134 = (0);
seq__43119 = G__43131;
chunk__43120 = G__43132;
count__43121 = G__43133;
i__43122 = G__43134;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
}));
re_frame.fx.register.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
}));

//# sourceMappingURL=fx.js.map?rel=1483320641479