// Compiled by ClojureScript 1.9.229 {}
goog.provide('re_frame.events');
goog.require('cljs.core');
goog.require('re_frame.db');
goog.require('re_frame.utils');
goog.require('re_frame.interop');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.interceptor');
goog.require('re_frame.trace');
re_frame.events.kind = new cljs.core.Keyword(null,"event","event",301435442);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.events.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * `interceptors` might have nested collections, and contain nil elements.
 *   return a flat collection, with all nils removed.
 *   This function is 9/10 about giving good error messages
 */
re_frame.events.flatten_and_remove_nils = (function re_frame$events$flatten_and_remove_nils(id,interceptors){
var make_chain = (function (p1__42913_SHARP_){
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,p1__42913_SHARP_));
});
if(!(re_frame.interop.debug_enabled_QMARK_)){
return make_chain.call(null,interceptors);
} else {
if(cljs.core.coll_QMARK_.call(null,interceptors)){
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("re-frame: when registering "),cljs.core.str(id),cljs.core.str(", expected a collection of interceptors, got:")].join(''),interceptors);
}

var chain = make_chain.call(null,interceptors);
if(cljs.core.empty_QMARK_.call(null,chain)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("re-frame: when registering"),cljs.core.str(id),cljs.core.str(", given an empty interceptor chain")].join(''));
} else {
}

var temp__4657__auto___42914 = cljs.core.first.call(null,cljs.core.remove.call(null,re_frame.interceptor.interceptor_QMARK_,chain));
if(cljs.core.truth_(temp__4657__auto___42914)){
var not_i_42915 = temp__4657__auto___42914;
if(cljs.core.fn_QMARK_.call(null,not_i_42915)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("re-frame: when registering "),cljs.core.str(id),cljs.core.str(", got a function instead of an interceptor. Did you provide old style middleware by mistake? Got:")].join(''),not_i_42915);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("re-frame: when registering "),cljs.core.str(id),cljs.core.str(", expected interceptors, but got:")].join(''),not_i_42915);
}
} else {
}

return chain;
}
});
/**
 * Associate the given event `id` with the given collection of `interceptors`.
 * 
 * `interceptors` may contain nested collections and there may be nils
 * at any level,so process this structure into a simple, nil-less vector
 * before registration.
 * 
 * An `event handler` will likely be at the end of the chain (wrapped in an interceptor).
 */
re_frame.events.register = (function re_frame$events$register(id,interceptors){
return re_frame.registrar.register_handler.call(null,re_frame.events.kind,id,re_frame.events.flatten_and_remove_nils.call(null,id,interceptors));
});
re_frame.events._STAR_handling_STAR_ = null;
/**
 * Given an event vector, look up the associated intercepter chain, and execute it.
 */
re_frame.events.handle = (function re_frame$events$handle(event_v){
var event_id = re_frame.utils.first_in_vector.call(null,event_v);
var temp__4655__auto__ = re_frame.registrar.get_handler.call(null,re_frame.events.kind,event_id,true);
if(cljs.core.truth_(temp__4655__auto__)){
var interceptors = temp__4655__auto__;
if(cljs.core.truth_(re_frame.events._STAR_handling_STAR_)){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("re-frame: while handling \""),cljs.core.str(re_frame.events._STAR_handling_STAR_),cljs.core.str("\", dispatch-sync was called for \""),cljs.core.str(event_v),cljs.core.str("\". You can't call dispatch-sync within an event handler.")].join(''));
} else {
var _STAR_handling_STAR_42930 = re_frame.events._STAR_handling_STAR_;
re_frame.events._STAR_handling_STAR_ = event_v;

try{if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_42931 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"operation","operation",-1267664310),event_id,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),re_frame.events.kind,new cljs.core.Keyword(null,"tags","tags",1771418977),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),event_v], null)], null));

try{try{return re_frame.interceptor.execute.call(null,event_v,interceptors);
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__42888__auto___42944 = re_frame.interop.now.call(null);
var duration__42889__auto___42945 = (end__42888__auto___42944 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__42932_42946 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__42933_42947 = null;
var count__42934_42948 = (0);
var i__42935_42949 = (0);
while(true){
if((i__42935_42949 < count__42934_42948)){
var vec__42936_42950 = cljs.core._nth.call(null,chunk__42933_42947,i__42935_42949);
var k__42890__auto___42951 = cljs.core.nth.call(null,vec__42936_42950,(0),null);
var cb__42891__auto___42952 = cljs.core.nth.call(null,vec__42936_42950,(1),null);
try{cb__42891__auto___42952.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__42889__auto___42945,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e42939){if((e42939 instanceof java.lang.Exception)){
var e__42892__auto___42953 = e42939;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__42890__auto___42951,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__42892__auto___42953);
} else {
throw e42939;

}
}
var G__42954 = seq__42932_42946;
var G__42955 = chunk__42933_42947;
var G__42956 = count__42934_42948;
var G__42957 = (i__42935_42949 + (1));
seq__42932_42946 = G__42954;
chunk__42933_42947 = G__42955;
count__42934_42948 = G__42956;
i__42935_42949 = G__42957;
continue;
} else {
var temp__4657__auto___42958 = cljs.core.seq.call(null,seq__42932_42946);
if(temp__4657__auto___42958){
var seq__42932_42959__$1 = temp__4657__auto___42958;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42932_42959__$1)){
var c__42260__auto___42960 = cljs.core.chunk_first.call(null,seq__42932_42959__$1);
var G__42961 = cljs.core.chunk_rest.call(null,seq__42932_42959__$1);
var G__42962 = c__42260__auto___42960;
var G__42963 = cljs.core.count.call(null,c__42260__auto___42960);
var G__42964 = (0);
seq__42932_42946 = G__42961;
chunk__42933_42947 = G__42962;
count__42934_42948 = G__42963;
i__42935_42949 = G__42964;
continue;
} else {
var vec__42940_42965 = cljs.core.first.call(null,seq__42932_42959__$1);
var k__42890__auto___42966 = cljs.core.nth.call(null,vec__42940_42965,(0),null);
var cb__42891__auto___42967 = cljs.core.nth.call(null,vec__42940_42965,(1),null);
try{cb__42891__auto___42967.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__42889__auto___42945,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e42943){if((e42943 instanceof java.lang.Exception)){
var e__42892__auto___42968 = e42943;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__42890__auto___42966,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__42892__auto___42968);
} else {
throw e42943;

}
}
var G__42969 = cljs.core.next.call(null,seq__42932_42959__$1);
var G__42970 = null;
var G__42971 = (0);
var G__42972 = (0);
seq__42932_42946 = G__42969;
chunk__42933_42947 = G__42970;
count__42934_42948 = G__42971;
i__42935_42949 = G__42972;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_42931;
}} else {
return re_frame.interceptor.execute.call(null,event_v,interceptors);
}
}finally {re_frame.events._STAR_handling_STAR_ = _STAR_handling_STAR_42930;
}}
} else {
return null;
}
});

//# sourceMappingURL=events.js.map?rel=1483320641181