// Compiled by ClojureScript 1.9.229 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__41444__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__41444__auto__){
return or__41444__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__41444__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__41444__auto__)){
return or__41444__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__48720_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__48720_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__48725 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__48726 = null;
var count__48727 = (0);
var i__48728 = (0);
while(true){
if((i__48728 < count__48727)){
var n = cljs.core._nth.call(null,chunk__48726,i__48728);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__48729 = seq__48725;
var G__48730 = chunk__48726;
var G__48731 = count__48727;
var G__48732 = (i__48728 + (1));
seq__48725 = G__48729;
chunk__48726 = G__48730;
count__48727 = G__48731;
i__48728 = G__48732;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__48725);
if(temp__4657__auto__){
var seq__48725__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48725__$1)){
var c__42255__auto__ = cljs.core.chunk_first.call(null,seq__48725__$1);
var G__48733 = cljs.core.chunk_rest.call(null,seq__48725__$1);
var G__48734 = c__42255__auto__;
var G__48735 = cljs.core.count.call(null,c__42255__auto__);
var G__48736 = (0);
seq__48725 = G__48733;
chunk__48726 = G__48734;
count__48727 = G__48735;
i__48728 = G__48736;
continue;
} else {
var n = cljs.core.first.call(null,seq__48725__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__48737 = cljs.core.next.call(null,seq__48725__$1);
var G__48738 = null;
var G__48739 = (0);
var G__48740 = (0);
seq__48725 = G__48737;
chunk__48726 = G__48738;
count__48727 = G__48739;
i__48728 = G__48740;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__48791_48802 = cljs.core.seq.call(null,deps);
var chunk__48792_48803 = null;
var count__48793_48804 = (0);
var i__48794_48805 = (0);
while(true){
if((i__48794_48805 < count__48793_48804)){
var dep_48806 = cljs.core._nth.call(null,chunk__48792_48803,i__48794_48805);
topo_sort_helper_STAR_.call(null,dep_48806,(depth + (1)),state);

var G__48807 = seq__48791_48802;
var G__48808 = chunk__48792_48803;
var G__48809 = count__48793_48804;
var G__48810 = (i__48794_48805 + (1));
seq__48791_48802 = G__48807;
chunk__48792_48803 = G__48808;
count__48793_48804 = G__48809;
i__48794_48805 = G__48810;
continue;
} else {
var temp__4657__auto___48811 = cljs.core.seq.call(null,seq__48791_48802);
if(temp__4657__auto___48811){
var seq__48791_48812__$1 = temp__4657__auto___48811;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48791_48812__$1)){
var c__42255__auto___48813 = cljs.core.chunk_first.call(null,seq__48791_48812__$1);
var G__48814 = cljs.core.chunk_rest.call(null,seq__48791_48812__$1);
var G__48815 = c__42255__auto___48813;
var G__48816 = cljs.core.count.call(null,c__42255__auto___48813);
var G__48817 = (0);
seq__48791_48802 = G__48814;
chunk__48792_48803 = G__48815;
count__48793_48804 = G__48816;
i__48794_48805 = G__48817;
continue;
} else {
var dep_48818 = cljs.core.first.call(null,seq__48791_48812__$1);
topo_sort_helper_STAR_.call(null,dep_48818,(depth + (1)),state);

var G__48819 = cljs.core.next.call(null,seq__48791_48812__$1);
var G__48820 = null;
var G__48821 = (0);
var G__48822 = (0);
seq__48791_48802 = G__48819;
chunk__48792_48803 = G__48820;
count__48793_48804 = G__48821;
i__48794_48805 = G__48822;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__48795){
var vec__48799 = p__48795;
var seq__48800 = cljs.core.seq.call(null,vec__48799);
var first__48801 = cljs.core.first.call(null,seq__48800);
var seq__48800__$1 = cljs.core.next.call(null,seq__48800);
var x = first__48801;
var xs = seq__48800__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__48799,seq__48800,first__48801,seq__48800__$1,x,xs,get_deps__$1){
return (function (p1__48741_SHARP_){
return clojure.set.difference.call(null,p1__48741_SHARP_,x);
});})(vec__48799,seq__48800,first__48801,seq__48800__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__48835 = cljs.core.seq.call(null,provides);
var chunk__48836 = null;
var count__48837 = (0);
var i__48838 = (0);
while(true){
if((i__48838 < count__48837)){
var prov = cljs.core._nth.call(null,chunk__48836,i__48838);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__48839_48847 = cljs.core.seq.call(null,requires);
var chunk__48840_48848 = null;
var count__48841_48849 = (0);
var i__48842_48850 = (0);
while(true){
if((i__48842_48850 < count__48841_48849)){
var req_48851 = cljs.core._nth.call(null,chunk__48840_48848,i__48842_48850);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_48851,prov);

var G__48852 = seq__48839_48847;
var G__48853 = chunk__48840_48848;
var G__48854 = count__48841_48849;
var G__48855 = (i__48842_48850 + (1));
seq__48839_48847 = G__48852;
chunk__48840_48848 = G__48853;
count__48841_48849 = G__48854;
i__48842_48850 = G__48855;
continue;
} else {
var temp__4657__auto___48856 = cljs.core.seq.call(null,seq__48839_48847);
if(temp__4657__auto___48856){
var seq__48839_48857__$1 = temp__4657__auto___48856;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48839_48857__$1)){
var c__42255__auto___48858 = cljs.core.chunk_first.call(null,seq__48839_48857__$1);
var G__48859 = cljs.core.chunk_rest.call(null,seq__48839_48857__$1);
var G__48860 = c__42255__auto___48858;
var G__48861 = cljs.core.count.call(null,c__42255__auto___48858);
var G__48862 = (0);
seq__48839_48847 = G__48859;
chunk__48840_48848 = G__48860;
count__48841_48849 = G__48861;
i__48842_48850 = G__48862;
continue;
} else {
var req_48863 = cljs.core.first.call(null,seq__48839_48857__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_48863,prov);

var G__48864 = cljs.core.next.call(null,seq__48839_48857__$1);
var G__48865 = null;
var G__48866 = (0);
var G__48867 = (0);
seq__48839_48847 = G__48864;
chunk__48840_48848 = G__48865;
count__48841_48849 = G__48866;
i__48842_48850 = G__48867;
continue;
}
} else {
}
}
break;
}

var G__48868 = seq__48835;
var G__48869 = chunk__48836;
var G__48870 = count__48837;
var G__48871 = (i__48838 + (1));
seq__48835 = G__48868;
chunk__48836 = G__48869;
count__48837 = G__48870;
i__48838 = G__48871;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__48835);
if(temp__4657__auto__){
var seq__48835__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48835__$1)){
var c__42255__auto__ = cljs.core.chunk_first.call(null,seq__48835__$1);
var G__48872 = cljs.core.chunk_rest.call(null,seq__48835__$1);
var G__48873 = c__42255__auto__;
var G__48874 = cljs.core.count.call(null,c__42255__auto__);
var G__48875 = (0);
seq__48835 = G__48872;
chunk__48836 = G__48873;
count__48837 = G__48874;
i__48838 = G__48875;
continue;
} else {
var prov = cljs.core.first.call(null,seq__48835__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__48843_48876 = cljs.core.seq.call(null,requires);
var chunk__48844_48877 = null;
var count__48845_48878 = (0);
var i__48846_48879 = (0);
while(true){
if((i__48846_48879 < count__48845_48878)){
var req_48880 = cljs.core._nth.call(null,chunk__48844_48877,i__48846_48879);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_48880,prov);

var G__48881 = seq__48843_48876;
var G__48882 = chunk__48844_48877;
var G__48883 = count__48845_48878;
var G__48884 = (i__48846_48879 + (1));
seq__48843_48876 = G__48881;
chunk__48844_48877 = G__48882;
count__48845_48878 = G__48883;
i__48846_48879 = G__48884;
continue;
} else {
var temp__4657__auto___48885__$1 = cljs.core.seq.call(null,seq__48843_48876);
if(temp__4657__auto___48885__$1){
var seq__48843_48886__$1 = temp__4657__auto___48885__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48843_48886__$1)){
var c__42255__auto___48887 = cljs.core.chunk_first.call(null,seq__48843_48886__$1);
var G__48888 = cljs.core.chunk_rest.call(null,seq__48843_48886__$1);
var G__48889 = c__42255__auto___48887;
var G__48890 = cljs.core.count.call(null,c__42255__auto___48887);
var G__48891 = (0);
seq__48843_48876 = G__48888;
chunk__48844_48877 = G__48889;
count__48845_48878 = G__48890;
i__48846_48879 = G__48891;
continue;
} else {
var req_48892 = cljs.core.first.call(null,seq__48843_48886__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_48892,prov);

var G__48893 = cljs.core.next.call(null,seq__48843_48886__$1);
var G__48894 = null;
var G__48895 = (0);
var G__48896 = (0);
seq__48843_48876 = G__48893;
chunk__48844_48877 = G__48894;
count__48845_48878 = G__48895;
i__48846_48879 = G__48896;
continue;
}
} else {
}
}
break;
}

var G__48897 = cljs.core.next.call(null,seq__48835__$1);
var G__48898 = null;
var G__48899 = (0);
var G__48900 = (0);
seq__48835 = G__48897;
chunk__48836 = G__48898;
count__48837 = G__48899;
i__48838 = G__48900;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__48905_48909 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__48906_48910 = null;
var count__48907_48911 = (0);
var i__48908_48912 = (0);
while(true){
if((i__48908_48912 < count__48907_48911)){
var ns_48913 = cljs.core._nth.call(null,chunk__48906_48910,i__48908_48912);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_48913);

var G__48914 = seq__48905_48909;
var G__48915 = chunk__48906_48910;
var G__48916 = count__48907_48911;
var G__48917 = (i__48908_48912 + (1));
seq__48905_48909 = G__48914;
chunk__48906_48910 = G__48915;
count__48907_48911 = G__48916;
i__48908_48912 = G__48917;
continue;
} else {
var temp__4657__auto___48918 = cljs.core.seq.call(null,seq__48905_48909);
if(temp__4657__auto___48918){
var seq__48905_48919__$1 = temp__4657__auto___48918;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48905_48919__$1)){
var c__42255__auto___48920 = cljs.core.chunk_first.call(null,seq__48905_48919__$1);
var G__48921 = cljs.core.chunk_rest.call(null,seq__48905_48919__$1);
var G__48922 = c__42255__auto___48920;
var G__48923 = cljs.core.count.call(null,c__42255__auto___48920);
var G__48924 = (0);
seq__48905_48909 = G__48921;
chunk__48906_48910 = G__48922;
count__48907_48911 = G__48923;
i__48908_48912 = G__48924;
continue;
} else {
var ns_48925 = cljs.core.first.call(null,seq__48905_48919__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_48925);

var G__48926 = cljs.core.next.call(null,seq__48905_48919__$1);
var G__48927 = null;
var G__48928 = (0);
var G__48929 = (0);
seq__48905_48909 = G__48926;
chunk__48906_48910 = G__48927;
count__48907_48911 = G__48928;
i__48908_48912 = G__48929;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__41444__auto__ = goog.require__;
if(cljs.core.truth_(or__41444__auto__)){
return or__41444__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__48930__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__48930 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__48931__i = 0, G__48931__a = new Array(arguments.length -  0);
while (G__48931__i < G__48931__a.length) {G__48931__a[G__48931__i] = arguments[G__48931__i + 0]; ++G__48931__i;}
  args = new cljs.core.IndexedSeq(G__48931__a,0);
} 
return G__48930__delegate.call(this,args);};
G__48930.cljs$lang$maxFixedArity = 0;
G__48930.cljs$lang$applyTo = (function (arglist__48932){
var args = cljs.core.seq(arglist__48932);
return G__48930__delegate(args);
});
G__48930.cljs$core$IFn$_invoke$arity$variadic = G__48930__delegate;
return G__48930;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__48934 = cljs.core._EQ_;
var expr__48935 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__48934.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__48935))){
var path_parts = ((function (pred__48934,expr__48935){
return (function (p1__48933_SHARP_){
return clojure.string.split.call(null,p1__48933_SHARP_,/[\/\\]/);
});})(pred__48934,expr__48935))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__48934,expr__48935){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e48937){if((e48937 instanceof Error)){
var e = e48937;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e48937;

}
}})());
});
;})(path_parts,sep,root,pred__48934,expr__48935))
} else {
if(cljs.core.truth_(pred__48934.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__48935))){
return ((function (pred__48934,expr__48935){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__48934,expr__48935){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__48934,expr__48935))
);

return deferred.addErrback(((function (deferred,pred__48934,expr__48935){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__48934,expr__48935))
);
});
;})(pred__48934,expr__48935))
} else {
return ((function (pred__48934,expr__48935){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__48934,expr__48935))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__48938,callback){
var map__48941 = p__48938;
var map__48941__$1 = ((((!((map__48941 == null)))?((((map__48941.cljs$lang$protocol_mask$partition0$ & (64))) || (map__48941.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48941):map__48941);
var file_msg = map__48941__$1;
var request_url = cljs.core.get.call(null,map__48941__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__48941,map__48941__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__48941,map__48941__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__45865__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto__){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto__){
return (function (state_48965){
var state_val_48966 = (state_48965[(1)]);
if((state_val_48966 === (7))){
var inst_48961 = (state_48965[(2)]);
var state_48965__$1 = state_48965;
var statearr_48967_48987 = state_48965__$1;
(statearr_48967_48987[(2)] = inst_48961);

(statearr_48967_48987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48966 === (1))){
var state_48965__$1 = state_48965;
var statearr_48968_48988 = state_48965__$1;
(statearr_48968_48988[(2)] = null);

(statearr_48968_48988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48966 === (4))){
var inst_48945 = (state_48965[(7)]);
var inst_48945__$1 = (state_48965[(2)]);
var state_48965__$1 = (function (){var statearr_48969 = state_48965;
(statearr_48969[(7)] = inst_48945__$1);

return statearr_48969;
})();
if(cljs.core.truth_(inst_48945__$1)){
var statearr_48970_48989 = state_48965__$1;
(statearr_48970_48989[(1)] = (5));

} else {
var statearr_48971_48990 = state_48965__$1;
(statearr_48971_48990[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48966 === (6))){
var state_48965__$1 = state_48965;
var statearr_48972_48991 = state_48965__$1;
(statearr_48972_48991[(2)] = null);

(statearr_48972_48991[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48966 === (3))){
var inst_48963 = (state_48965[(2)]);
var state_48965__$1 = state_48965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48965__$1,inst_48963);
} else {
if((state_val_48966 === (2))){
var state_48965__$1 = state_48965;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48965__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_48966 === (11))){
var inst_48957 = (state_48965[(2)]);
var state_48965__$1 = (function (){var statearr_48973 = state_48965;
(statearr_48973[(8)] = inst_48957);

return statearr_48973;
})();
var statearr_48974_48992 = state_48965__$1;
(statearr_48974_48992[(2)] = null);

(statearr_48974_48992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48966 === (9))){
var inst_48951 = (state_48965[(9)]);
var inst_48949 = (state_48965[(10)]);
var inst_48953 = inst_48951.call(null,inst_48949);
var state_48965__$1 = state_48965;
var statearr_48975_48993 = state_48965__$1;
(statearr_48975_48993[(2)] = inst_48953);

(statearr_48975_48993[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48966 === (5))){
var inst_48945 = (state_48965[(7)]);
var inst_48947 = figwheel.client.file_reloading.blocking_load.call(null,inst_48945);
var state_48965__$1 = state_48965;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48965__$1,(8),inst_48947);
} else {
if((state_val_48966 === (10))){
var inst_48949 = (state_48965[(10)]);
var inst_48955 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_48949);
var state_48965__$1 = state_48965;
var statearr_48976_48994 = state_48965__$1;
(statearr_48976_48994[(2)] = inst_48955);

(statearr_48976_48994[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48966 === (8))){
var inst_48951 = (state_48965[(9)]);
var inst_48945 = (state_48965[(7)]);
var inst_48949 = (state_48965[(2)]);
var inst_48950 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_48951__$1 = cljs.core.get.call(null,inst_48950,inst_48945);
var state_48965__$1 = (function (){var statearr_48977 = state_48965;
(statearr_48977[(9)] = inst_48951__$1);

(statearr_48977[(10)] = inst_48949);

return statearr_48977;
})();
if(cljs.core.truth_(inst_48951__$1)){
var statearr_48978_48995 = state_48965__$1;
(statearr_48978_48995[(1)] = (9));

} else {
var statearr_48979_48996 = state_48965__$1;
(statearr_48979_48996[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto__))
;
return ((function (switch__45753__auto__,c__45865__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__45754__auto__ = null;
var figwheel$client$file_reloading$state_machine__45754__auto____0 = (function (){
var statearr_48983 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48983[(0)] = figwheel$client$file_reloading$state_machine__45754__auto__);

(statearr_48983[(1)] = (1));

return statearr_48983;
});
var figwheel$client$file_reloading$state_machine__45754__auto____1 = (function (state_48965){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_48965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e48984){if((e48984 instanceof Object)){
var ex__45757__auto__ = e48984;
var statearr_48985_48997 = state_48965;
(statearr_48985_48997[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48965);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48984;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48998 = state_48965;
state_48965 = G__48998;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__45754__auto__ = function(state_48965){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__45754__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__45754__auto____1.call(this,state_48965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__45754__auto____0;
figwheel$client$file_reloading$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__45754__auto____1;
return figwheel$client$file_reloading$state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto__))
})();
var state__45867__auto__ = (function (){var statearr_48986 = f__45866__auto__.call(null);
(statearr_48986[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto__);

return statearr_48986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto__))
);

return c__45865__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__48999,callback){
var map__49002 = p__48999;
var map__49002__$1 = ((((!((map__49002 == null)))?((((map__49002.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49002.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49002):map__49002);
var file_msg = map__49002__$1;
var namespace = cljs.core.get.call(null,map__49002__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__49002,map__49002__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__49002,map__49002__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__49004){
var map__49007 = p__49004;
var map__49007__$1 = ((((!((map__49007 == null)))?((((map__49007.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49007.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49007):map__49007);
var file_msg = map__49007__$1;
var namespace = cljs.core.get.call(null,map__49007__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__41432__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__41432__auto__){
var or__41444__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__41444__auto__)){
return or__41444__auto__;
} else {
var or__41444__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__41444__auto____$1)){
return or__41444__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__41432__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__49009,callback){
var map__49012 = p__49009;
var map__49012__$1 = ((((!((map__49012 == null)))?((((map__49012.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49012.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49012):map__49012);
var file_msg = map__49012__$1;
var request_url = cljs.core.get.call(null,map__49012__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__49012__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__45865__auto___49116 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto___49116,out){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto___49116,out){
return (function (state_49098){
var state_val_49099 = (state_49098[(1)]);
if((state_val_49099 === (1))){
var inst_49072 = cljs.core.seq.call(null,files);
var inst_49073 = cljs.core.first.call(null,inst_49072);
var inst_49074 = cljs.core.next.call(null,inst_49072);
var inst_49075 = files;
var state_49098__$1 = (function (){var statearr_49100 = state_49098;
(statearr_49100[(7)] = inst_49074);

(statearr_49100[(8)] = inst_49073);

(statearr_49100[(9)] = inst_49075);

return statearr_49100;
})();
var statearr_49101_49117 = state_49098__$1;
(statearr_49101_49117[(2)] = null);

(statearr_49101_49117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49099 === (2))){
var inst_49081 = (state_49098[(10)]);
var inst_49075 = (state_49098[(9)]);
var inst_49080 = cljs.core.seq.call(null,inst_49075);
var inst_49081__$1 = cljs.core.first.call(null,inst_49080);
var inst_49082 = cljs.core.next.call(null,inst_49080);
var inst_49083 = (inst_49081__$1 == null);
var inst_49084 = cljs.core.not.call(null,inst_49083);
var state_49098__$1 = (function (){var statearr_49102 = state_49098;
(statearr_49102[(10)] = inst_49081__$1);

(statearr_49102[(11)] = inst_49082);

return statearr_49102;
})();
if(inst_49084){
var statearr_49103_49118 = state_49098__$1;
(statearr_49103_49118[(1)] = (4));

} else {
var statearr_49104_49119 = state_49098__$1;
(statearr_49104_49119[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49099 === (3))){
var inst_49096 = (state_49098[(2)]);
var state_49098__$1 = state_49098;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49098__$1,inst_49096);
} else {
if((state_val_49099 === (4))){
var inst_49081 = (state_49098[(10)]);
var inst_49086 = figwheel.client.file_reloading.reload_js_file.call(null,inst_49081);
var state_49098__$1 = state_49098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49098__$1,(7),inst_49086);
} else {
if((state_val_49099 === (5))){
var inst_49092 = cljs.core.async.close_BANG_.call(null,out);
var state_49098__$1 = state_49098;
var statearr_49105_49120 = state_49098__$1;
(statearr_49105_49120[(2)] = inst_49092);

(statearr_49105_49120[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49099 === (6))){
var inst_49094 = (state_49098[(2)]);
var state_49098__$1 = state_49098;
var statearr_49106_49121 = state_49098__$1;
(statearr_49106_49121[(2)] = inst_49094);

(statearr_49106_49121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49099 === (7))){
var inst_49082 = (state_49098[(11)]);
var inst_49088 = (state_49098[(2)]);
var inst_49089 = cljs.core.async.put_BANG_.call(null,out,inst_49088);
var inst_49075 = inst_49082;
var state_49098__$1 = (function (){var statearr_49107 = state_49098;
(statearr_49107[(12)] = inst_49089);

(statearr_49107[(9)] = inst_49075);

return statearr_49107;
})();
var statearr_49108_49122 = state_49098__$1;
(statearr_49108_49122[(2)] = null);

(statearr_49108_49122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__45865__auto___49116,out))
;
return ((function (switch__45753__auto__,c__45865__auto___49116,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__45754__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__45754__auto____0 = (function (){
var statearr_49112 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49112[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__45754__auto__);

(statearr_49112[(1)] = (1));

return statearr_49112;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__45754__auto____1 = (function (state_49098){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_49098);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e49113){if((e49113 instanceof Object)){
var ex__45757__auto__ = e49113;
var statearr_49114_49123 = state_49098;
(statearr_49114_49123[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49098);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49113;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49124 = state_49098;
state_49098 = G__49124;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__45754__auto__ = function(state_49098){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__45754__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__45754__auto____1.call(this,state_49098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__45754__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__45754__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto___49116,out))
})();
var state__45867__auto__ = (function (){var statearr_49115 = f__45866__auto__.call(null);
(statearr_49115[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___49116);

return statearr_49115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto___49116,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__49125,opts){
var map__49129 = p__49125;
var map__49129__$1 = ((((!((map__49129 == null)))?((((map__49129.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49129.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49129):map__49129);
var eval_body__$1 = cljs.core.get.call(null,map__49129__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__49129__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__41432__auto__ = eval_body__$1;
if(cljs.core.truth_(and__41432__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__41432__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e49131){var e = e49131;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__49132_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__49132_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__49141){
var vec__49142 = p__49141;
var k = cljs.core.nth.call(null,vec__49142,(0),null);
var v = cljs.core.nth.call(null,vec__49142,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__49145){
var vec__49146 = p__49145;
var k = cljs.core.nth.call(null,vec__49146,(0),null);
var v = cljs.core.nth.call(null,vec__49146,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__49152,p__49153){
var map__49400 = p__49152;
var map__49400__$1 = ((((!((map__49400 == null)))?((((map__49400.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49400.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49400):map__49400);
var opts = map__49400__$1;
var before_jsload = cljs.core.get.call(null,map__49400__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__49400__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__49400__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__49401 = p__49153;
var map__49401__$1 = ((((!((map__49401 == null)))?((((map__49401.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49401.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49401):map__49401);
var msg = map__49401__$1;
var files = cljs.core.get.call(null,map__49401__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__49401__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__49401__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__45865__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_49554){
var state_val_49555 = (state_49554[(1)]);
if((state_val_49555 === (7))){
var inst_49417 = (state_49554[(7)]);
var inst_49415 = (state_49554[(8)]);
var inst_49416 = (state_49554[(9)]);
var inst_49418 = (state_49554[(10)]);
var inst_49423 = cljs.core._nth.call(null,inst_49416,inst_49418);
var inst_49424 = figwheel.client.file_reloading.eval_body.call(null,inst_49423,opts);
var inst_49425 = (inst_49418 + (1));
var tmp49556 = inst_49417;
var tmp49557 = inst_49415;
var tmp49558 = inst_49416;
var inst_49415__$1 = tmp49557;
var inst_49416__$1 = tmp49558;
var inst_49417__$1 = tmp49556;
var inst_49418__$1 = inst_49425;
var state_49554__$1 = (function (){var statearr_49559 = state_49554;
(statearr_49559[(7)] = inst_49417__$1);

(statearr_49559[(11)] = inst_49424);

(statearr_49559[(8)] = inst_49415__$1);

(statearr_49559[(9)] = inst_49416__$1);

(statearr_49559[(10)] = inst_49418__$1);

return statearr_49559;
})();
var statearr_49560_49646 = state_49554__$1;
(statearr_49560_49646[(2)] = null);

(statearr_49560_49646[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (20))){
var inst_49458 = (state_49554[(12)]);
var inst_49466 = figwheel.client.file_reloading.sort_files.call(null,inst_49458);
var state_49554__$1 = state_49554;
var statearr_49561_49647 = state_49554__$1;
(statearr_49561_49647[(2)] = inst_49466);

(statearr_49561_49647[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (27))){
var state_49554__$1 = state_49554;
var statearr_49562_49648 = state_49554__$1;
(statearr_49562_49648[(2)] = null);

(statearr_49562_49648[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (1))){
var inst_49407 = (state_49554[(13)]);
var inst_49404 = before_jsload.call(null,files);
var inst_49405 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_49406 = (function (){return ((function (inst_49407,inst_49404,inst_49405,state_val_49555,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__49149_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__49149_SHARP_);
});
;})(inst_49407,inst_49404,inst_49405,state_val_49555,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_49407__$1 = cljs.core.filter.call(null,inst_49406,files);
var inst_49408 = cljs.core.not_empty.call(null,inst_49407__$1);
var state_49554__$1 = (function (){var statearr_49563 = state_49554;
(statearr_49563[(14)] = inst_49404);

(statearr_49563[(13)] = inst_49407__$1);

(statearr_49563[(15)] = inst_49405);

return statearr_49563;
})();
if(cljs.core.truth_(inst_49408)){
var statearr_49564_49649 = state_49554__$1;
(statearr_49564_49649[(1)] = (2));

} else {
var statearr_49565_49650 = state_49554__$1;
(statearr_49565_49650[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (24))){
var state_49554__$1 = state_49554;
var statearr_49566_49651 = state_49554__$1;
(statearr_49566_49651[(2)] = null);

(statearr_49566_49651[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (39))){
var inst_49508 = (state_49554[(16)]);
var state_49554__$1 = state_49554;
var statearr_49567_49652 = state_49554__$1;
(statearr_49567_49652[(2)] = inst_49508);

(statearr_49567_49652[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (46))){
var inst_49549 = (state_49554[(2)]);
var state_49554__$1 = state_49554;
var statearr_49568_49653 = state_49554__$1;
(statearr_49568_49653[(2)] = inst_49549);

(statearr_49568_49653[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (4))){
var inst_49452 = (state_49554[(2)]);
var inst_49453 = cljs.core.List.EMPTY;
var inst_49454 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_49453);
var inst_49455 = (function (){return ((function (inst_49452,inst_49453,inst_49454,state_val_49555,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__49150_SHARP_){
var and__41432__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__49150_SHARP_);
if(cljs.core.truth_(and__41432__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__49150_SHARP_));
} else {
return and__41432__auto__;
}
});
;})(inst_49452,inst_49453,inst_49454,state_val_49555,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_49456 = cljs.core.filter.call(null,inst_49455,files);
var inst_49457 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_49458 = cljs.core.concat.call(null,inst_49456,inst_49457);
var state_49554__$1 = (function (){var statearr_49569 = state_49554;
(statearr_49569[(17)] = inst_49454);

(statearr_49569[(12)] = inst_49458);

(statearr_49569[(18)] = inst_49452);

return statearr_49569;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_49570_49654 = state_49554__$1;
(statearr_49570_49654[(1)] = (16));

} else {
var statearr_49571_49655 = state_49554__$1;
(statearr_49571_49655[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (15))){
var inst_49442 = (state_49554[(2)]);
var state_49554__$1 = state_49554;
var statearr_49572_49656 = state_49554__$1;
(statearr_49572_49656[(2)] = inst_49442);

(statearr_49572_49656[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (21))){
var inst_49468 = (state_49554[(19)]);
var inst_49468__$1 = (state_49554[(2)]);
var inst_49469 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_49468__$1);
var state_49554__$1 = (function (){var statearr_49573 = state_49554;
(statearr_49573[(19)] = inst_49468__$1);

return statearr_49573;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49554__$1,(22),inst_49469);
} else {
if((state_val_49555 === (31))){
var inst_49552 = (state_49554[(2)]);
var state_49554__$1 = state_49554;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49554__$1,inst_49552);
} else {
if((state_val_49555 === (32))){
var inst_49508 = (state_49554[(16)]);
var inst_49513 = inst_49508.cljs$lang$protocol_mask$partition0$;
var inst_49514 = (inst_49513 & (64));
var inst_49515 = inst_49508.cljs$core$ISeq$;
var inst_49516 = (inst_49514) || (inst_49515);
var state_49554__$1 = state_49554;
if(cljs.core.truth_(inst_49516)){
var statearr_49574_49657 = state_49554__$1;
(statearr_49574_49657[(1)] = (35));

} else {
var statearr_49575_49658 = state_49554__$1;
(statearr_49575_49658[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (40))){
var inst_49529 = (state_49554[(20)]);
var inst_49528 = (state_49554[(2)]);
var inst_49529__$1 = cljs.core.get.call(null,inst_49528,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_49530 = cljs.core.get.call(null,inst_49528,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_49531 = cljs.core.not_empty.call(null,inst_49529__$1);
var state_49554__$1 = (function (){var statearr_49576 = state_49554;
(statearr_49576[(21)] = inst_49530);

(statearr_49576[(20)] = inst_49529__$1);

return statearr_49576;
})();
if(cljs.core.truth_(inst_49531)){
var statearr_49577_49659 = state_49554__$1;
(statearr_49577_49659[(1)] = (41));

} else {
var statearr_49578_49660 = state_49554__$1;
(statearr_49578_49660[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (33))){
var state_49554__$1 = state_49554;
var statearr_49579_49661 = state_49554__$1;
(statearr_49579_49661[(2)] = false);

(statearr_49579_49661[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (13))){
var inst_49428 = (state_49554[(22)]);
var inst_49432 = cljs.core.chunk_first.call(null,inst_49428);
var inst_49433 = cljs.core.chunk_rest.call(null,inst_49428);
var inst_49434 = cljs.core.count.call(null,inst_49432);
var inst_49415 = inst_49433;
var inst_49416 = inst_49432;
var inst_49417 = inst_49434;
var inst_49418 = (0);
var state_49554__$1 = (function (){var statearr_49580 = state_49554;
(statearr_49580[(7)] = inst_49417);

(statearr_49580[(8)] = inst_49415);

(statearr_49580[(9)] = inst_49416);

(statearr_49580[(10)] = inst_49418);

return statearr_49580;
})();
var statearr_49581_49662 = state_49554__$1;
(statearr_49581_49662[(2)] = null);

(statearr_49581_49662[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (22))){
var inst_49468 = (state_49554[(19)]);
var inst_49471 = (state_49554[(23)]);
var inst_49476 = (state_49554[(24)]);
var inst_49472 = (state_49554[(25)]);
var inst_49471__$1 = (state_49554[(2)]);
var inst_49472__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_49471__$1);
var inst_49473 = (function (){var all_files = inst_49468;
var res_SINGLEQUOTE_ = inst_49471__$1;
var res = inst_49472__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_49468,inst_49471,inst_49476,inst_49472,inst_49471__$1,inst_49472__$1,state_val_49555,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__49151_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__49151_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_49468,inst_49471,inst_49476,inst_49472,inst_49471__$1,inst_49472__$1,state_val_49555,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_49474 = cljs.core.filter.call(null,inst_49473,inst_49471__$1);
var inst_49475 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_49476__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_49475);
var inst_49477 = cljs.core.not_empty.call(null,inst_49476__$1);
var state_49554__$1 = (function (){var statearr_49582 = state_49554;
(statearr_49582[(23)] = inst_49471__$1);

(statearr_49582[(24)] = inst_49476__$1);

(statearr_49582[(26)] = inst_49474);

(statearr_49582[(25)] = inst_49472__$1);

return statearr_49582;
})();
if(cljs.core.truth_(inst_49477)){
var statearr_49583_49663 = state_49554__$1;
(statearr_49583_49663[(1)] = (23));

} else {
var statearr_49584_49664 = state_49554__$1;
(statearr_49584_49664[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (36))){
var state_49554__$1 = state_49554;
var statearr_49585_49665 = state_49554__$1;
(statearr_49585_49665[(2)] = false);

(statearr_49585_49665[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (41))){
var inst_49529 = (state_49554[(20)]);
var inst_49533 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_49534 = cljs.core.map.call(null,inst_49533,inst_49529);
var inst_49535 = cljs.core.pr_str.call(null,inst_49534);
var inst_49536 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_49535)].join('');
var inst_49537 = figwheel.client.utils.log.call(null,inst_49536);
var state_49554__$1 = state_49554;
var statearr_49586_49666 = state_49554__$1;
(statearr_49586_49666[(2)] = inst_49537);

(statearr_49586_49666[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (43))){
var inst_49530 = (state_49554[(21)]);
var inst_49540 = (state_49554[(2)]);
var inst_49541 = cljs.core.not_empty.call(null,inst_49530);
var state_49554__$1 = (function (){var statearr_49587 = state_49554;
(statearr_49587[(27)] = inst_49540);

return statearr_49587;
})();
if(cljs.core.truth_(inst_49541)){
var statearr_49588_49667 = state_49554__$1;
(statearr_49588_49667[(1)] = (44));

} else {
var statearr_49589_49668 = state_49554__$1;
(statearr_49589_49668[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (29))){
var inst_49508 = (state_49554[(16)]);
var inst_49468 = (state_49554[(19)]);
var inst_49471 = (state_49554[(23)]);
var inst_49476 = (state_49554[(24)]);
var inst_49474 = (state_49554[(26)]);
var inst_49472 = (state_49554[(25)]);
var inst_49504 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_49507 = (function (){var all_files = inst_49468;
var res_SINGLEQUOTE_ = inst_49471;
var res = inst_49472;
var files_not_loaded = inst_49474;
var dependencies_that_loaded = inst_49476;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_49508,inst_49468,inst_49471,inst_49476,inst_49474,inst_49472,inst_49504,state_val_49555,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__49506){
var map__49590 = p__49506;
var map__49590__$1 = ((((!((map__49590 == null)))?((((map__49590.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49590.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49590):map__49590);
var namespace = cljs.core.get.call(null,map__49590__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_49508,inst_49468,inst_49471,inst_49476,inst_49474,inst_49472,inst_49504,state_val_49555,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_49508__$1 = cljs.core.group_by.call(null,inst_49507,inst_49474);
var inst_49510 = (inst_49508__$1 == null);
var inst_49511 = cljs.core.not.call(null,inst_49510);
var state_49554__$1 = (function (){var statearr_49592 = state_49554;
(statearr_49592[(16)] = inst_49508__$1);

(statearr_49592[(28)] = inst_49504);

return statearr_49592;
})();
if(inst_49511){
var statearr_49593_49669 = state_49554__$1;
(statearr_49593_49669[(1)] = (32));

} else {
var statearr_49594_49670 = state_49554__$1;
(statearr_49594_49670[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (44))){
var inst_49530 = (state_49554[(21)]);
var inst_49543 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_49530);
var inst_49544 = cljs.core.pr_str.call(null,inst_49543);
var inst_49545 = [cljs.core.str("not required: "),cljs.core.str(inst_49544)].join('');
var inst_49546 = figwheel.client.utils.log.call(null,inst_49545);
var state_49554__$1 = state_49554;
var statearr_49595_49671 = state_49554__$1;
(statearr_49595_49671[(2)] = inst_49546);

(statearr_49595_49671[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (6))){
var inst_49449 = (state_49554[(2)]);
var state_49554__$1 = state_49554;
var statearr_49596_49672 = state_49554__$1;
(statearr_49596_49672[(2)] = inst_49449);

(statearr_49596_49672[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (28))){
var inst_49474 = (state_49554[(26)]);
var inst_49501 = (state_49554[(2)]);
var inst_49502 = cljs.core.not_empty.call(null,inst_49474);
var state_49554__$1 = (function (){var statearr_49597 = state_49554;
(statearr_49597[(29)] = inst_49501);

return statearr_49597;
})();
if(cljs.core.truth_(inst_49502)){
var statearr_49598_49673 = state_49554__$1;
(statearr_49598_49673[(1)] = (29));

} else {
var statearr_49599_49674 = state_49554__$1;
(statearr_49599_49674[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (25))){
var inst_49472 = (state_49554[(25)]);
var inst_49488 = (state_49554[(2)]);
var inst_49489 = cljs.core.not_empty.call(null,inst_49472);
var state_49554__$1 = (function (){var statearr_49600 = state_49554;
(statearr_49600[(30)] = inst_49488);

return statearr_49600;
})();
if(cljs.core.truth_(inst_49489)){
var statearr_49601_49675 = state_49554__$1;
(statearr_49601_49675[(1)] = (26));

} else {
var statearr_49602_49676 = state_49554__$1;
(statearr_49602_49676[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (34))){
var inst_49523 = (state_49554[(2)]);
var state_49554__$1 = state_49554;
if(cljs.core.truth_(inst_49523)){
var statearr_49603_49677 = state_49554__$1;
(statearr_49603_49677[(1)] = (38));

} else {
var statearr_49604_49678 = state_49554__$1;
(statearr_49604_49678[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (17))){
var state_49554__$1 = state_49554;
var statearr_49605_49679 = state_49554__$1;
(statearr_49605_49679[(2)] = recompile_dependents);

(statearr_49605_49679[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (3))){
var state_49554__$1 = state_49554;
var statearr_49606_49680 = state_49554__$1;
(statearr_49606_49680[(2)] = null);

(statearr_49606_49680[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (12))){
var inst_49445 = (state_49554[(2)]);
var state_49554__$1 = state_49554;
var statearr_49607_49681 = state_49554__$1;
(statearr_49607_49681[(2)] = inst_49445);

(statearr_49607_49681[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (2))){
var inst_49407 = (state_49554[(13)]);
var inst_49414 = cljs.core.seq.call(null,inst_49407);
var inst_49415 = inst_49414;
var inst_49416 = null;
var inst_49417 = (0);
var inst_49418 = (0);
var state_49554__$1 = (function (){var statearr_49608 = state_49554;
(statearr_49608[(7)] = inst_49417);

(statearr_49608[(8)] = inst_49415);

(statearr_49608[(9)] = inst_49416);

(statearr_49608[(10)] = inst_49418);

return statearr_49608;
})();
var statearr_49609_49682 = state_49554__$1;
(statearr_49609_49682[(2)] = null);

(statearr_49609_49682[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (23))){
var inst_49468 = (state_49554[(19)]);
var inst_49471 = (state_49554[(23)]);
var inst_49476 = (state_49554[(24)]);
var inst_49474 = (state_49554[(26)]);
var inst_49472 = (state_49554[(25)]);
var inst_49479 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_49481 = (function (){var all_files = inst_49468;
var res_SINGLEQUOTE_ = inst_49471;
var res = inst_49472;
var files_not_loaded = inst_49474;
var dependencies_that_loaded = inst_49476;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_49468,inst_49471,inst_49476,inst_49474,inst_49472,inst_49479,state_val_49555,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__49480){
var map__49610 = p__49480;
var map__49610__$1 = ((((!((map__49610 == null)))?((((map__49610.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49610.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49610):map__49610);
var request_url = cljs.core.get.call(null,map__49610__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_49468,inst_49471,inst_49476,inst_49474,inst_49472,inst_49479,state_val_49555,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_49482 = cljs.core.reverse.call(null,inst_49476);
var inst_49483 = cljs.core.map.call(null,inst_49481,inst_49482);
var inst_49484 = cljs.core.pr_str.call(null,inst_49483);
var inst_49485 = figwheel.client.utils.log.call(null,inst_49484);
var state_49554__$1 = (function (){var statearr_49612 = state_49554;
(statearr_49612[(31)] = inst_49479);

return statearr_49612;
})();
var statearr_49613_49683 = state_49554__$1;
(statearr_49613_49683[(2)] = inst_49485);

(statearr_49613_49683[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (35))){
var state_49554__$1 = state_49554;
var statearr_49614_49684 = state_49554__$1;
(statearr_49614_49684[(2)] = true);

(statearr_49614_49684[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (19))){
var inst_49458 = (state_49554[(12)]);
var inst_49464 = figwheel.client.file_reloading.expand_files.call(null,inst_49458);
var state_49554__$1 = state_49554;
var statearr_49615_49685 = state_49554__$1;
(statearr_49615_49685[(2)] = inst_49464);

(statearr_49615_49685[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (11))){
var state_49554__$1 = state_49554;
var statearr_49616_49686 = state_49554__$1;
(statearr_49616_49686[(2)] = null);

(statearr_49616_49686[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (9))){
var inst_49447 = (state_49554[(2)]);
var state_49554__$1 = state_49554;
var statearr_49617_49687 = state_49554__$1;
(statearr_49617_49687[(2)] = inst_49447);

(statearr_49617_49687[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (5))){
var inst_49417 = (state_49554[(7)]);
var inst_49418 = (state_49554[(10)]);
var inst_49420 = (inst_49418 < inst_49417);
var inst_49421 = inst_49420;
var state_49554__$1 = state_49554;
if(cljs.core.truth_(inst_49421)){
var statearr_49618_49688 = state_49554__$1;
(statearr_49618_49688[(1)] = (7));

} else {
var statearr_49619_49689 = state_49554__$1;
(statearr_49619_49689[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (14))){
var inst_49428 = (state_49554[(22)]);
var inst_49437 = cljs.core.first.call(null,inst_49428);
var inst_49438 = figwheel.client.file_reloading.eval_body.call(null,inst_49437,opts);
var inst_49439 = cljs.core.next.call(null,inst_49428);
var inst_49415 = inst_49439;
var inst_49416 = null;
var inst_49417 = (0);
var inst_49418 = (0);
var state_49554__$1 = (function (){var statearr_49620 = state_49554;
(statearr_49620[(7)] = inst_49417);

(statearr_49620[(32)] = inst_49438);

(statearr_49620[(8)] = inst_49415);

(statearr_49620[(9)] = inst_49416);

(statearr_49620[(10)] = inst_49418);

return statearr_49620;
})();
var statearr_49621_49690 = state_49554__$1;
(statearr_49621_49690[(2)] = null);

(statearr_49621_49690[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (45))){
var state_49554__$1 = state_49554;
var statearr_49622_49691 = state_49554__$1;
(statearr_49622_49691[(2)] = null);

(statearr_49622_49691[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (26))){
var inst_49468 = (state_49554[(19)]);
var inst_49471 = (state_49554[(23)]);
var inst_49476 = (state_49554[(24)]);
var inst_49474 = (state_49554[(26)]);
var inst_49472 = (state_49554[(25)]);
var inst_49491 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_49493 = (function (){var all_files = inst_49468;
var res_SINGLEQUOTE_ = inst_49471;
var res = inst_49472;
var files_not_loaded = inst_49474;
var dependencies_that_loaded = inst_49476;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_49468,inst_49471,inst_49476,inst_49474,inst_49472,inst_49491,state_val_49555,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__49492){
var map__49623 = p__49492;
var map__49623__$1 = ((((!((map__49623 == null)))?((((map__49623.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49623.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49623):map__49623);
var namespace = cljs.core.get.call(null,map__49623__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__49623__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_49468,inst_49471,inst_49476,inst_49474,inst_49472,inst_49491,state_val_49555,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_49494 = cljs.core.map.call(null,inst_49493,inst_49472);
var inst_49495 = cljs.core.pr_str.call(null,inst_49494);
var inst_49496 = figwheel.client.utils.log.call(null,inst_49495);
var inst_49497 = (function (){var all_files = inst_49468;
var res_SINGLEQUOTE_ = inst_49471;
var res = inst_49472;
var files_not_loaded = inst_49474;
var dependencies_that_loaded = inst_49476;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_49468,inst_49471,inst_49476,inst_49474,inst_49472,inst_49491,inst_49493,inst_49494,inst_49495,inst_49496,state_val_49555,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_49468,inst_49471,inst_49476,inst_49474,inst_49472,inst_49491,inst_49493,inst_49494,inst_49495,inst_49496,state_val_49555,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_49498 = setTimeout(inst_49497,(10));
var state_49554__$1 = (function (){var statearr_49625 = state_49554;
(statearr_49625[(33)] = inst_49496);

(statearr_49625[(34)] = inst_49491);

return statearr_49625;
})();
var statearr_49626_49692 = state_49554__$1;
(statearr_49626_49692[(2)] = inst_49498);

(statearr_49626_49692[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (16))){
var state_49554__$1 = state_49554;
var statearr_49627_49693 = state_49554__$1;
(statearr_49627_49693[(2)] = reload_dependents);

(statearr_49627_49693[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (38))){
var inst_49508 = (state_49554[(16)]);
var inst_49525 = cljs.core.apply.call(null,cljs.core.hash_map,inst_49508);
var state_49554__$1 = state_49554;
var statearr_49628_49694 = state_49554__$1;
(statearr_49628_49694[(2)] = inst_49525);

(statearr_49628_49694[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (30))){
var state_49554__$1 = state_49554;
var statearr_49629_49695 = state_49554__$1;
(statearr_49629_49695[(2)] = null);

(statearr_49629_49695[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (10))){
var inst_49428 = (state_49554[(22)]);
var inst_49430 = cljs.core.chunked_seq_QMARK_.call(null,inst_49428);
var state_49554__$1 = state_49554;
if(inst_49430){
var statearr_49630_49696 = state_49554__$1;
(statearr_49630_49696[(1)] = (13));

} else {
var statearr_49631_49697 = state_49554__$1;
(statearr_49631_49697[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (18))){
var inst_49462 = (state_49554[(2)]);
var state_49554__$1 = state_49554;
if(cljs.core.truth_(inst_49462)){
var statearr_49632_49698 = state_49554__$1;
(statearr_49632_49698[(1)] = (19));

} else {
var statearr_49633_49699 = state_49554__$1;
(statearr_49633_49699[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (42))){
var state_49554__$1 = state_49554;
var statearr_49634_49700 = state_49554__$1;
(statearr_49634_49700[(2)] = null);

(statearr_49634_49700[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (37))){
var inst_49520 = (state_49554[(2)]);
var state_49554__$1 = state_49554;
var statearr_49635_49701 = state_49554__$1;
(statearr_49635_49701[(2)] = inst_49520);

(statearr_49635_49701[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49555 === (8))){
var inst_49415 = (state_49554[(8)]);
var inst_49428 = (state_49554[(22)]);
var inst_49428__$1 = cljs.core.seq.call(null,inst_49415);
var state_49554__$1 = (function (){var statearr_49636 = state_49554;
(statearr_49636[(22)] = inst_49428__$1);

return statearr_49636;
})();
if(inst_49428__$1){
var statearr_49637_49702 = state_49554__$1;
(statearr_49637_49702[(1)] = (10));

} else {
var statearr_49638_49703 = state_49554__$1;
(statearr_49638_49703[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__45753__auto__,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__45754__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__45754__auto____0 = (function (){
var statearr_49642 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49642[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__45754__auto__);

(statearr_49642[(1)] = (1));

return statearr_49642;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__45754__auto____1 = (function (state_49554){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_49554);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e49643){if((e49643 instanceof Object)){
var ex__45757__auto__ = e49643;
var statearr_49644_49704 = state_49554;
(statearr_49644_49704[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49554);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49643;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49705 = state_49554;
state_49554 = G__49705;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__45754__auto__ = function(state_49554){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__45754__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__45754__auto____1.call(this,state_49554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__45754__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__45754__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__45867__auto__ = (function (){var statearr_49645 = f__45866__auto__.call(null);
(statearr_49645[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto__);

return statearr_49645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto__,map__49400,map__49400__$1,opts,before_jsload,on_jsload,reload_dependents,map__49401,map__49401__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__45865__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__49708,link){
var map__49711 = p__49708;
var map__49711__$1 = ((((!((map__49711 == null)))?((((map__49711.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49711.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49711):map__49711);
var file = cljs.core.get.call(null,map__49711__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__49711,map__49711__$1,file){
return (function (p1__49706_SHARP_,p2__49707_SHARP_){
if(cljs.core._EQ_.call(null,p1__49706_SHARP_,p2__49707_SHARP_)){
return p1__49706_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__49711,map__49711__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__49717){
var map__49718 = p__49717;
var map__49718__$1 = ((((!((map__49718 == null)))?((((map__49718.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49718.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49718):map__49718);
var match_length = cljs.core.get.call(null,map__49718__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__49718__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__49713_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__49713_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args49720 = [];
var len__42519__auto___49723 = arguments.length;
var i__42520__auto___49724 = (0);
while(true){
if((i__42520__auto___49724 < len__42519__auto___49723)){
args49720.push((arguments[i__42520__auto___49724]));

var G__49725 = (i__42520__auto___49724 + (1));
i__42520__auto___49724 = G__49725;
continue;
} else {
}
break;
}

var G__49722 = args49720.length;
switch (G__49722) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args49720.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__49727_SHARP_,p2__49728_SHARP_){
return cljs.core.assoc.call(null,p1__49727_SHARP_,cljs.core.get.call(null,p2__49728_SHARP_,key),p2__49728_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__49729){
var map__49732 = p__49729;
var map__49732__$1 = ((((!((map__49732 == null)))?((((map__49732.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49732.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49732):map__49732);
var f_data = map__49732__$1;
var file = cljs.core.get.call(null,map__49732__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4657__auto__)){
var link = temp__4657__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__49734,files_msg){
var map__49741 = p__49734;
var map__49741__$1 = ((((!((map__49741 == null)))?((((map__49741.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49741.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49741):map__49741);
var opts = map__49741__$1;
var on_cssload = cljs.core.get.call(null,map__49741__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__49743_49747 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__49744_49748 = null;
var count__49745_49749 = (0);
var i__49746_49750 = (0);
while(true){
if((i__49746_49750 < count__49745_49749)){
var f_49751 = cljs.core._nth.call(null,chunk__49744_49748,i__49746_49750);
figwheel.client.file_reloading.reload_css_file.call(null,f_49751);

var G__49752 = seq__49743_49747;
var G__49753 = chunk__49744_49748;
var G__49754 = count__49745_49749;
var G__49755 = (i__49746_49750 + (1));
seq__49743_49747 = G__49752;
chunk__49744_49748 = G__49753;
count__49745_49749 = G__49754;
i__49746_49750 = G__49755;
continue;
} else {
var temp__4657__auto___49756 = cljs.core.seq.call(null,seq__49743_49747);
if(temp__4657__auto___49756){
var seq__49743_49757__$1 = temp__4657__auto___49756;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__49743_49757__$1)){
var c__42255__auto___49758 = cljs.core.chunk_first.call(null,seq__49743_49757__$1);
var G__49759 = cljs.core.chunk_rest.call(null,seq__49743_49757__$1);
var G__49760 = c__42255__auto___49758;
var G__49761 = cljs.core.count.call(null,c__42255__auto___49758);
var G__49762 = (0);
seq__49743_49747 = G__49759;
chunk__49744_49748 = G__49760;
count__49745_49749 = G__49761;
i__49746_49750 = G__49762;
continue;
} else {
var f_49763 = cljs.core.first.call(null,seq__49743_49757__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_49763);

var G__49764 = cljs.core.next.call(null,seq__49743_49757__$1);
var G__49765 = null;
var G__49766 = (0);
var G__49767 = (0);
seq__49743_49747 = G__49764;
chunk__49744_49748 = G__49765;
count__49745_49749 = G__49766;
i__49746_49750 = G__49767;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__49741,map__49741__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__49741,map__49741__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1482290837965