// Compiled by ClojureScript 1.9.229 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args45910 = [];
var len__42519__auto___45916 = arguments.length;
var i__42520__auto___45917 = (0);
while(true){
if((i__42520__auto___45917 < len__42519__auto___45916)){
args45910.push((arguments[i__42520__auto___45917]));

var G__45918 = (i__42520__auto___45917 + (1));
i__42520__auto___45917 = G__45918;
continue;
} else {
}
break;
}

var G__45912 = args45910.length;
switch (G__45912) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args45910.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async45913 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45913 = (function (f,blockable,meta45914){
this.f = f;
this.blockable = blockable;
this.meta45914 = meta45914;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async45913.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45915,meta45914__$1){
var self__ = this;
var _45915__$1 = this;
return (new cljs.core.async.t_cljs$core$async45913(self__.f,self__.blockable,meta45914__$1));
});

cljs.core.async.t_cljs$core$async45913.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45915){
var self__ = this;
var _45915__$1 = this;
return self__.meta45914;
});

cljs.core.async.t_cljs$core$async45913.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async45913.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async45913.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async45913.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async45913.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta45914","meta45914",-568385967,null)], null);
});

cljs.core.async.t_cljs$core$async45913.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async45913.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45913";

cljs.core.async.t_cljs$core$async45913.cljs$lang$ctorPrWriter = (function (this__42050__auto__,writer__42051__auto__,opt__42052__auto__){
return cljs.core._write.call(null,writer__42051__auto__,"cljs.core.async/t_cljs$core$async45913");
});

cljs.core.async.__GT_t_cljs$core$async45913 = (function cljs$core$async$__GT_t_cljs$core$async45913(f__$1,blockable__$1,meta45914){
return (new cljs.core.async.t_cljs$core$async45913(f__$1,blockable__$1,meta45914));
});

}

return (new cljs.core.async.t_cljs$core$async45913(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args45922 = [];
var len__42519__auto___45925 = arguments.length;
var i__42520__auto___45926 = (0);
while(true){
if((i__42520__auto___45926 < len__42519__auto___45925)){
args45922.push((arguments[i__42520__auto___45926]));

var G__45927 = (i__42520__auto___45926 + (1));
i__42520__auto___45926 = G__45927;
continue;
} else {
}
break;
}

var G__45924 = args45922.length;
switch (G__45924) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args45922.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args45929 = [];
var len__42519__auto___45932 = arguments.length;
var i__42520__auto___45933 = (0);
while(true){
if((i__42520__auto___45933 < len__42519__auto___45932)){
args45929.push((arguments[i__42520__auto___45933]));

var G__45934 = (i__42520__auto___45933 + (1));
i__42520__auto___45933 = G__45934;
continue;
} else {
}
break;
}

var G__45931 = args45929.length;
switch (G__45931) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args45929.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args45936 = [];
var len__42519__auto___45939 = arguments.length;
var i__42520__auto___45940 = (0);
while(true){
if((i__42520__auto___45940 < len__42519__auto___45939)){
args45936.push((arguments[i__42520__auto___45940]));

var G__45941 = (i__42520__auto___45940 + (1));
i__42520__auto___45940 = G__45941;
continue;
} else {
}
break;
}

var G__45938 = args45936.length;
switch (G__45938) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args45936.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_45943 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_45943);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_45943,ret){
return (function (){
return fn1.call(null,val_45943);
});})(val_45943,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args45944 = [];
var len__42519__auto___45947 = arguments.length;
var i__42520__auto___45948 = (0);
while(true){
if((i__42520__auto___45948 < len__42519__auto___45947)){
args45944.push((arguments[i__42520__auto___45948]));

var G__45949 = (i__42520__auto___45948 + (1));
i__42520__auto___45948 = G__45949;
continue;
} else {
}
break;
}

var G__45946 = args45944.length;
switch (G__45946) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args45944.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__42359__auto___45951 = n;
var x_45952 = (0);
while(true){
if((x_45952 < n__42359__auto___45951)){
(a[x_45952] = (0));

var G__45953 = (x_45952 + (1));
x_45952 = G__45953;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__45954 = (i + (1));
i = G__45954;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async45958 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45958 = (function (alt_flag,flag,meta45959){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta45959 = meta45959;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async45958.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_45960,meta45959__$1){
var self__ = this;
var _45960__$1 = this;
return (new cljs.core.async.t_cljs$core$async45958(self__.alt_flag,self__.flag,meta45959__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async45958.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_45960){
var self__ = this;
var _45960__$1 = this;
return self__.meta45959;
});})(flag))
;

cljs.core.async.t_cljs$core$async45958.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async45958.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async45958.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async45958.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async45958.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta45959","meta45959",1131095549,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async45958.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async45958.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45958";

cljs.core.async.t_cljs$core$async45958.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__42050__auto__,writer__42051__auto__,opt__42052__auto__){
return cljs.core._write.call(null,writer__42051__auto__,"cljs.core.async/t_cljs$core$async45958");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async45958 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async45958(alt_flag__$1,flag__$1,meta45959){
return (new cljs.core.async.t_cljs$core$async45958(alt_flag__$1,flag__$1,meta45959));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async45958(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async45964 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45964 = (function (alt_handler,flag,cb,meta45965){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta45965 = meta45965;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async45964.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45966,meta45965__$1){
var self__ = this;
var _45966__$1 = this;
return (new cljs.core.async.t_cljs$core$async45964(self__.alt_handler,self__.flag,self__.cb,meta45965__$1));
});

cljs.core.async.t_cljs$core$async45964.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45966){
var self__ = this;
var _45966__$1 = this;
return self__.meta45965;
});

cljs.core.async.t_cljs$core$async45964.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async45964.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async45964.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async45964.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async45964.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta45965","meta45965",-118719170,null)], null);
});

cljs.core.async.t_cljs$core$async45964.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async45964.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45964";

cljs.core.async.t_cljs$core$async45964.cljs$lang$ctorPrWriter = (function (this__42050__auto__,writer__42051__auto__,opt__42052__auto__){
return cljs.core._write.call(null,writer__42051__auto__,"cljs.core.async/t_cljs$core$async45964");
});

cljs.core.async.__GT_t_cljs$core$async45964 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async45964(alt_handler__$1,flag__$1,cb__$1,meta45965){
return (new cljs.core.async.t_cljs$core$async45964(alt_handler__$1,flag__$1,cb__$1,meta45965));
});

}

return (new cljs.core.async.t_cljs$core$async45964(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__45967_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__45967_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__45968_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__45968_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__41444__auto__ = wport;
if(cljs.core.truth_(or__41444__auto__)){
return or__41444__auto__;
} else {
return port;
}
})()], null));
} else {
var G__45969 = (i + (1));
i = G__45969;
continue;
}
} else {
return null;
}
break;
}
})();
var or__41444__auto__ = ret;
if(cljs.core.truth_(or__41444__auto__)){
return or__41444__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__41432__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__41432__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__41432__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__42526__auto__ = [];
var len__42519__auto___45975 = arguments.length;
var i__42520__auto___45976 = (0);
while(true){
if((i__42520__auto___45976 < len__42519__auto___45975)){
args__42526__auto__.push((arguments[i__42520__auto___45976]));

var G__45977 = (i__42520__auto___45976 + (1));
i__42520__auto___45976 = G__45977;
continue;
} else {
}
break;
}

var argseq__42527__auto__ = ((((1) < args__42526__auto__.length))?(new cljs.core.IndexedSeq(args__42526__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__42527__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__45972){
var map__45973 = p__45972;
var map__45973__$1 = ((((!((map__45973 == null)))?((((map__45973.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45973.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45973):map__45973);
var opts = map__45973__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq45970){
var G__45971 = cljs.core.first.call(null,seq45970);
var seq45970__$1 = cljs.core.next.call(null,seq45970);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__45971,seq45970__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args45978 = [];
var len__42519__auto___46028 = arguments.length;
var i__42520__auto___46029 = (0);
while(true){
if((i__42520__auto___46029 < len__42519__auto___46028)){
args45978.push((arguments[i__42520__auto___46029]));

var G__46030 = (i__42520__auto___46029 + (1));
i__42520__auto___46029 = G__46030;
continue;
} else {
}
break;
}

var G__45980 = args45978.length;
switch (G__45980) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args45978.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__45865__auto___46032 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto___46032){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto___46032){
return (function (state_46004){
var state_val_46005 = (state_46004[(1)]);
if((state_val_46005 === (7))){
var inst_46000 = (state_46004[(2)]);
var state_46004__$1 = state_46004;
var statearr_46006_46033 = state_46004__$1;
(statearr_46006_46033[(2)] = inst_46000);

(statearr_46006_46033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46005 === (1))){
var state_46004__$1 = state_46004;
var statearr_46007_46034 = state_46004__$1;
(statearr_46007_46034[(2)] = null);

(statearr_46007_46034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46005 === (4))){
var inst_45983 = (state_46004[(7)]);
var inst_45983__$1 = (state_46004[(2)]);
var inst_45984 = (inst_45983__$1 == null);
var state_46004__$1 = (function (){var statearr_46008 = state_46004;
(statearr_46008[(7)] = inst_45983__$1);

return statearr_46008;
})();
if(cljs.core.truth_(inst_45984)){
var statearr_46009_46035 = state_46004__$1;
(statearr_46009_46035[(1)] = (5));

} else {
var statearr_46010_46036 = state_46004__$1;
(statearr_46010_46036[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46005 === (13))){
var state_46004__$1 = state_46004;
var statearr_46011_46037 = state_46004__$1;
(statearr_46011_46037[(2)] = null);

(statearr_46011_46037[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46005 === (6))){
var inst_45983 = (state_46004[(7)]);
var state_46004__$1 = state_46004;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46004__$1,(11),to,inst_45983);
} else {
if((state_val_46005 === (3))){
var inst_46002 = (state_46004[(2)]);
var state_46004__$1 = state_46004;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46004__$1,inst_46002);
} else {
if((state_val_46005 === (12))){
var state_46004__$1 = state_46004;
var statearr_46012_46038 = state_46004__$1;
(statearr_46012_46038[(2)] = null);

(statearr_46012_46038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46005 === (2))){
var state_46004__$1 = state_46004;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46004__$1,(4),from);
} else {
if((state_val_46005 === (11))){
var inst_45993 = (state_46004[(2)]);
var state_46004__$1 = state_46004;
if(cljs.core.truth_(inst_45993)){
var statearr_46013_46039 = state_46004__$1;
(statearr_46013_46039[(1)] = (12));

} else {
var statearr_46014_46040 = state_46004__$1;
(statearr_46014_46040[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46005 === (9))){
var state_46004__$1 = state_46004;
var statearr_46015_46041 = state_46004__$1;
(statearr_46015_46041[(2)] = null);

(statearr_46015_46041[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46005 === (5))){
var state_46004__$1 = state_46004;
if(cljs.core.truth_(close_QMARK_)){
var statearr_46016_46042 = state_46004__$1;
(statearr_46016_46042[(1)] = (8));

} else {
var statearr_46017_46043 = state_46004__$1;
(statearr_46017_46043[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46005 === (14))){
var inst_45998 = (state_46004[(2)]);
var state_46004__$1 = state_46004;
var statearr_46018_46044 = state_46004__$1;
(statearr_46018_46044[(2)] = inst_45998);

(statearr_46018_46044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46005 === (10))){
var inst_45990 = (state_46004[(2)]);
var state_46004__$1 = state_46004;
var statearr_46019_46045 = state_46004__$1;
(statearr_46019_46045[(2)] = inst_45990);

(statearr_46019_46045[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46005 === (8))){
var inst_45987 = cljs.core.async.close_BANG_.call(null,to);
var state_46004__$1 = state_46004;
var statearr_46020_46046 = state_46004__$1;
(statearr_46020_46046[(2)] = inst_45987);

(statearr_46020_46046[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto___46032))
;
return ((function (switch__45753__auto__,c__45865__auto___46032){
return (function() {
var cljs$core$async$state_machine__45754__auto__ = null;
var cljs$core$async$state_machine__45754__auto____0 = (function (){
var statearr_46024 = [null,null,null,null,null,null,null,null];
(statearr_46024[(0)] = cljs$core$async$state_machine__45754__auto__);

(statearr_46024[(1)] = (1));

return statearr_46024;
});
var cljs$core$async$state_machine__45754__auto____1 = (function (state_46004){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_46004);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e46025){if((e46025 instanceof Object)){
var ex__45757__auto__ = e46025;
var statearr_46026_46047 = state_46004;
(statearr_46026_46047[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46004);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46025;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46048 = state_46004;
state_46004 = G__46048;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$state_machine__45754__auto__ = function(state_46004){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45754__auto____1.call(this,state_46004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45754__auto____0;
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45754__auto____1;
return cljs$core$async$state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto___46032))
})();
var state__45867__auto__ = (function (){var statearr_46027 = f__45866__auto__.call(null);
(statearr_46027[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___46032);

return statearr_46027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto___46032))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__46236){
var vec__46237 = p__46236;
var v = cljs.core.nth.call(null,vec__46237,(0),null);
var p = cljs.core.nth.call(null,vec__46237,(1),null);
var job = vec__46237;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__45865__auto___46423 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto___46423,res,vec__46237,v,p,job,jobs,results){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto___46423,res,vec__46237,v,p,job,jobs,results){
return (function (state_46244){
var state_val_46245 = (state_46244[(1)]);
if((state_val_46245 === (1))){
var state_46244__$1 = state_46244;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46244__$1,(2),res,v);
} else {
if((state_val_46245 === (2))){
var inst_46241 = (state_46244[(2)]);
var inst_46242 = cljs.core.async.close_BANG_.call(null,res);
var state_46244__$1 = (function (){var statearr_46246 = state_46244;
(statearr_46246[(7)] = inst_46241);

return statearr_46246;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46244__$1,inst_46242);
} else {
return null;
}
}
});})(c__45865__auto___46423,res,vec__46237,v,p,job,jobs,results))
;
return ((function (switch__45753__auto__,c__45865__auto___46423,res,vec__46237,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____0 = (function (){
var statearr_46250 = [null,null,null,null,null,null,null,null];
(statearr_46250[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__);

(statearr_46250[(1)] = (1));

return statearr_46250;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____1 = (function (state_46244){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_46244);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e46251){if((e46251 instanceof Object)){
var ex__45757__auto__ = e46251;
var statearr_46252_46424 = state_46244;
(statearr_46252_46424[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46244);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46251;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46425 = state_46244;
state_46244 = G__46425;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__ = function(state_46244){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____1.call(this,state_46244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto___46423,res,vec__46237,v,p,job,jobs,results))
})();
var state__45867__auto__ = (function (){var statearr_46253 = f__45866__auto__.call(null);
(statearr_46253[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___46423);

return statearr_46253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto___46423,res,vec__46237,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__46254){
var vec__46255 = p__46254;
var v = cljs.core.nth.call(null,vec__46255,(0),null);
var p = cljs.core.nth.call(null,vec__46255,(1),null);
var job = vec__46255;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__42359__auto___46426 = n;
var __46427 = (0);
while(true){
if((__46427 < n__42359__auto___46426)){
var G__46258_46428 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__46258_46428) {
case "compute":
var c__45865__auto___46430 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__46427,c__45865__auto___46430,G__46258_46428,n__42359__auto___46426,jobs,results,process,async){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (__46427,c__45865__auto___46430,G__46258_46428,n__42359__auto___46426,jobs,results,process,async){
return (function (state_46271){
var state_val_46272 = (state_46271[(1)]);
if((state_val_46272 === (1))){
var state_46271__$1 = state_46271;
var statearr_46273_46431 = state_46271__$1;
(statearr_46273_46431[(2)] = null);

(statearr_46273_46431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46272 === (2))){
var state_46271__$1 = state_46271;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46271__$1,(4),jobs);
} else {
if((state_val_46272 === (3))){
var inst_46269 = (state_46271[(2)]);
var state_46271__$1 = state_46271;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46271__$1,inst_46269);
} else {
if((state_val_46272 === (4))){
var inst_46261 = (state_46271[(2)]);
var inst_46262 = process.call(null,inst_46261);
var state_46271__$1 = state_46271;
if(cljs.core.truth_(inst_46262)){
var statearr_46274_46432 = state_46271__$1;
(statearr_46274_46432[(1)] = (5));

} else {
var statearr_46275_46433 = state_46271__$1;
(statearr_46275_46433[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46272 === (5))){
var state_46271__$1 = state_46271;
var statearr_46276_46434 = state_46271__$1;
(statearr_46276_46434[(2)] = null);

(statearr_46276_46434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46272 === (6))){
var state_46271__$1 = state_46271;
var statearr_46277_46435 = state_46271__$1;
(statearr_46277_46435[(2)] = null);

(statearr_46277_46435[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46272 === (7))){
var inst_46267 = (state_46271[(2)]);
var state_46271__$1 = state_46271;
var statearr_46278_46436 = state_46271__$1;
(statearr_46278_46436[(2)] = inst_46267);

(statearr_46278_46436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46427,c__45865__auto___46430,G__46258_46428,n__42359__auto___46426,jobs,results,process,async))
;
return ((function (__46427,switch__45753__auto__,c__45865__auto___46430,G__46258_46428,n__42359__auto___46426,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____0 = (function (){
var statearr_46282 = [null,null,null,null,null,null,null];
(statearr_46282[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__);

(statearr_46282[(1)] = (1));

return statearr_46282;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____1 = (function (state_46271){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_46271);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e46283){if((e46283 instanceof Object)){
var ex__45757__auto__ = e46283;
var statearr_46284_46437 = state_46271;
(statearr_46284_46437[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46271);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46283;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46438 = state_46271;
state_46271 = G__46438;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__ = function(state_46271){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____1.call(this,state_46271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__;
})()
;})(__46427,switch__45753__auto__,c__45865__auto___46430,G__46258_46428,n__42359__auto___46426,jobs,results,process,async))
})();
var state__45867__auto__ = (function (){var statearr_46285 = f__45866__auto__.call(null);
(statearr_46285[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___46430);

return statearr_46285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(__46427,c__45865__auto___46430,G__46258_46428,n__42359__auto___46426,jobs,results,process,async))
);


break;
case "async":
var c__45865__auto___46439 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__46427,c__45865__auto___46439,G__46258_46428,n__42359__auto___46426,jobs,results,process,async){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (__46427,c__45865__auto___46439,G__46258_46428,n__42359__auto___46426,jobs,results,process,async){
return (function (state_46298){
var state_val_46299 = (state_46298[(1)]);
if((state_val_46299 === (1))){
var state_46298__$1 = state_46298;
var statearr_46300_46440 = state_46298__$1;
(statearr_46300_46440[(2)] = null);

(statearr_46300_46440[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46299 === (2))){
var state_46298__$1 = state_46298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46298__$1,(4),jobs);
} else {
if((state_val_46299 === (3))){
var inst_46296 = (state_46298[(2)]);
var state_46298__$1 = state_46298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46298__$1,inst_46296);
} else {
if((state_val_46299 === (4))){
var inst_46288 = (state_46298[(2)]);
var inst_46289 = async.call(null,inst_46288);
var state_46298__$1 = state_46298;
if(cljs.core.truth_(inst_46289)){
var statearr_46301_46441 = state_46298__$1;
(statearr_46301_46441[(1)] = (5));

} else {
var statearr_46302_46442 = state_46298__$1;
(statearr_46302_46442[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46299 === (5))){
var state_46298__$1 = state_46298;
var statearr_46303_46443 = state_46298__$1;
(statearr_46303_46443[(2)] = null);

(statearr_46303_46443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46299 === (6))){
var state_46298__$1 = state_46298;
var statearr_46304_46444 = state_46298__$1;
(statearr_46304_46444[(2)] = null);

(statearr_46304_46444[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46299 === (7))){
var inst_46294 = (state_46298[(2)]);
var state_46298__$1 = state_46298;
var statearr_46305_46445 = state_46298__$1;
(statearr_46305_46445[(2)] = inst_46294);

(statearr_46305_46445[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46427,c__45865__auto___46439,G__46258_46428,n__42359__auto___46426,jobs,results,process,async))
;
return ((function (__46427,switch__45753__auto__,c__45865__auto___46439,G__46258_46428,n__42359__auto___46426,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____0 = (function (){
var statearr_46309 = [null,null,null,null,null,null,null];
(statearr_46309[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__);

(statearr_46309[(1)] = (1));

return statearr_46309;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____1 = (function (state_46298){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_46298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e46310){if((e46310 instanceof Object)){
var ex__45757__auto__ = e46310;
var statearr_46311_46446 = state_46298;
(statearr_46311_46446[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46310;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46447 = state_46298;
state_46298 = G__46447;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__ = function(state_46298){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____1.call(this,state_46298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__;
})()
;})(__46427,switch__45753__auto__,c__45865__auto___46439,G__46258_46428,n__42359__auto___46426,jobs,results,process,async))
})();
var state__45867__auto__ = (function (){var statearr_46312 = f__45866__auto__.call(null);
(statearr_46312[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___46439);

return statearr_46312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(__46427,c__45865__auto___46439,G__46258_46428,n__42359__auto___46426,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__46448 = (__46427 + (1));
__46427 = G__46448;
continue;
} else {
}
break;
}

var c__45865__auto___46449 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto___46449,jobs,results,process,async){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto___46449,jobs,results,process,async){
return (function (state_46334){
var state_val_46335 = (state_46334[(1)]);
if((state_val_46335 === (1))){
var state_46334__$1 = state_46334;
var statearr_46336_46450 = state_46334__$1;
(statearr_46336_46450[(2)] = null);

(statearr_46336_46450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46335 === (2))){
var state_46334__$1 = state_46334;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46334__$1,(4),from);
} else {
if((state_val_46335 === (3))){
var inst_46332 = (state_46334[(2)]);
var state_46334__$1 = state_46334;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46334__$1,inst_46332);
} else {
if((state_val_46335 === (4))){
var inst_46315 = (state_46334[(7)]);
var inst_46315__$1 = (state_46334[(2)]);
var inst_46316 = (inst_46315__$1 == null);
var state_46334__$1 = (function (){var statearr_46337 = state_46334;
(statearr_46337[(7)] = inst_46315__$1);

return statearr_46337;
})();
if(cljs.core.truth_(inst_46316)){
var statearr_46338_46451 = state_46334__$1;
(statearr_46338_46451[(1)] = (5));

} else {
var statearr_46339_46452 = state_46334__$1;
(statearr_46339_46452[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46335 === (5))){
var inst_46318 = cljs.core.async.close_BANG_.call(null,jobs);
var state_46334__$1 = state_46334;
var statearr_46340_46453 = state_46334__$1;
(statearr_46340_46453[(2)] = inst_46318);

(statearr_46340_46453[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46335 === (6))){
var inst_46315 = (state_46334[(7)]);
var inst_46320 = (state_46334[(8)]);
var inst_46320__$1 = cljs.core.async.chan.call(null,(1));
var inst_46321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46322 = [inst_46315,inst_46320__$1];
var inst_46323 = (new cljs.core.PersistentVector(null,2,(5),inst_46321,inst_46322,null));
var state_46334__$1 = (function (){var statearr_46341 = state_46334;
(statearr_46341[(8)] = inst_46320__$1);

return statearr_46341;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46334__$1,(8),jobs,inst_46323);
} else {
if((state_val_46335 === (7))){
var inst_46330 = (state_46334[(2)]);
var state_46334__$1 = state_46334;
var statearr_46342_46454 = state_46334__$1;
(statearr_46342_46454[(2)] = inst_46330);

(statearr_46342_46454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46335 === (8))){
var inst_46320 = (state_46334[(8)]);
var inst_46325 = (state_46334[(2)]);
var state_46334__$1 = (function (){var statearr_46343 = state_46334;
(statearr_46343[(9)] = inst_46325);

return statearr_46343;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46334__$1,(9),results,inst_46320);
} else {
if((state_val_46335 === (9))){
var inst_46327 = (state_46334[(2)]);
var state_46334__$1 = (function (){var statearr_46344 = state_46334;
(statearr_46344[(10)] = inst_46327);

return statearr_46344;
})();
var statearr_46345_46455 = state_46334__$1;
(statearr_46345_46455[(2)] = null);

(statearr_46345_46455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__45865__auto___46449,jobs,results,process,async))
;
return ((function (switch__45753__auto__,c__45865__auto___46449,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____0 = (function (){
var statearr_46349 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46349[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__);

(statearr_46349[(1)] = (1));

return statearr_46349;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____1 = (function (state_46334){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_46334);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e46350){if((e46350 instanceof Object)){
var ex__45757__auto__ = e46350;
var statearr_46351_46456 = state_46334;
(statearr_46351_46456[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46334);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46350;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46457 = state_46334;
state_46334 = G__46457;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__ = function(state_46334){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____1.call(this,state_46334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto___46449,jobs,results,process,async))
})();
var state__45867__auto__ = (function (){var statearr_46352 = f__45866__auto__.call(null);
(statearr_46352[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___46449);

return statearr_46352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto___46449,jobs,results,process,async))
);


var c__45865__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto__,jobs,results,process,async){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto__,jobs,results,process,async){
return (function (state_46390){
var state_val_46391 = (state_46390[(1)]);
if((state_val_46391 === (7))){
var inst_46386 = (state_46390[(2)]);
var state_46390__$1 = state_46390;
var statearr_46392_46458 = state_46390__$1;
(statearr_46392_46458[(2)] = inst_46386);

(statearr_46392_46458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46391 === (20))){
var state_46390__$1 = state_46390;
var statearr_46393_46459 = state_46390__$1;
(statearr_46393_46459[(2)] = null);

(statearr_46393_46459[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46391 === (1))){
var state_46390__$1 = state_46390;
var statearr_46394_46460 = state_46390__$1;
(statearr_46394_46460[(2)] = null);

(statearr_46394_46460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46391 === (4))){
var inst_46355 = (state_46390[(7)]);
var inst_46355__$1 = (state_46390[(2)]);
var inst_46356 = (inst_46355__$1 == null);
var state_46390__$1 = (function (){var statearr_46395 = state_46390;
(statearr_46395[(7)] = inst_46355__$1);

return statearr_46395;
})();
if(cljs.core.truth_(inst_46356)){
var statearr_46396_46461 = state_46390__$1;
(statearr_46396_46461[(1)] = (5));

} else {
var statearr_46397_46462 = state_46390__$1;
(statearr_46397_46462[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46391 === (15))){
var inst_46368 = (state_46390[(8)]);
var state_46390__$1 = state_46390;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46390__$1,(18),to,inst_46368);
} else {
if((state_val_46391 === (21))){
var inst_46381 = (state_46390[(2)]);
var state_46390__$1 = state_46390;
var statearr_46398_46463 = state_46390__$1;
(statearr_46398_46463[(2)] = inst_46381);

(statearr_46398_46463[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46391 === (13))){
var inst_46383 = (state_46390[(2)]);
var state_46390__$1 = (function (){var statearr_46399 = state_46390;
(statearr_46399[(9)] = inst_46383);

return statearr_46399;
})();
var statearr_46400_46464 = state_46390__$1;
(statearr_46400_46464[(2)] = null);

(statearr_46400_46464[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46391 === (6))){
var inst_46355 = (state_46390[(7)]);
var state_46390__$1 = state_46390;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46390__$1,(11),inst_46355);
} else {
if((state_val_46391 === (17))){
var inst_46376 = (state_46390[(2)]);
var state_46390__$1 = state_46390;
if(cljs.core.truth_(inst_46376)){
var statearr_46401_46465 = state_46390__$1;
(statearr_46401_46465[(1)] = (19));

} else {
var statearr_46402_46466 = state_46390__$1;
(statearr_46402_46466[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46391 === (3))){
var inst_46388 = (state_46390[(2)]);
var state_46390__$1 = state_46390;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46390__$1,inst_46388);
} else {
if((state_val_46391 === (12))){
var inst_46365 = (state_46390[(10)]);
var state_46390__$1 = state_46390;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46390__$1,(14),inst_46365);
} else {
if((state_val_46391 === (2))){
var state_46390__$1 = state_46390;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46390__$1,(4),results);
} else {
if((state_val_46391 === (19))){
var state_46390__$1 = state_46390;
var statearr_46403_46467 = state_46390__$1;
(statearr_46403_46467[(2)] = null);

(statearr_46403_46467[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46391 === (11))){
var inst_46365 = (state_46390[(2)]);
var state_46390__$1 = (function (){var statearr_46404 = state_46390;
(statearr_46404[(10)] = inst_46365);

return statearr_46404;
})();
var statearr_46405_46468 = state_46390__$1;
(statearr_46405_46468[(2)] = null);

(statearr_46405_46468[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46391 === (9))){
var state_46390__$1 = state_46390;
var statearr_46406_46469 = state_46390__$1;
(statearr_46406_46469[(2)] = null);

(statearr_46406_46469[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46391 === (5))){
var state_46390__$1 = state_46390;
if(cljs.core.truth_(close_QMARK_)){
var statearr_46407_46470 = state_46390__$1;
(statearr_46407_46470[(1)] = (8));

} else {
var statearr_46408_46471 = state_46390__$1;
(statearr_46408_46471[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46391 === (14))){
var inst_46368 = (state_46390[(8)]);
var inst_46370 = (state_46390[(11)]);
var inst_46368__$1 = (state_46390[(2)]);
var inst_46369 = (inst_46368__$1 == null);
var inst_46370__$1 = cljs.core.not.call(null,inst_46369);
var state_46390__$1 = (function (){var statearr_46409 = state_46390;
(statearr_46409[(8)] = inst_46368__$1);

(statearr_46409[(11)] = inst_46370__$1);

return statearr_46409;
})();
if(inst_46370__$1){
var statearr_46410_46472 = state_46390__$1;
(statearr_46410_46472[(1)] = (15));

} else {
var statearr_46411_46473 = state_46390__$1;
(statearr_46411_46473[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46391 === (16))){
var inst_46370 = (state_46390[(11)]);
var state_46390__$1 = state_46390;
var statearr_46412_46474 = state_46390__$1;
(statearr_46412_46474[(2)] = inst_46370);

(statearr_46412_46474[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46391 === (10))){
var inst_46362 = (state_46390[(2)]);
var state_46390__$1 = state_46390;
var statearr_46413_46475 = state_46390__$1;
(statearr_46413_46475[(2)] = inst_46362);

(statearr_46413_46475[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46391 === (18))){
var inst_46373 = (state_46390[(2)]);
var state_46390__$1 = state_46390;
var statearr_46414_46476 = state_46390__$1;
(statearr_46414_46476[(2)] = inst_46373);

(statearr_46414_46476[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46391 === (8))){
var inst_46359 = cljs.core.async.close_BANG_.call(null,to);
var state_46390__$1 = state_46390;
var statearr_46415_46477 = state_46390__$1;
(statearr_46415_46477[(2)] = inst_46359);

(statearr_46415_46477[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto__,jobs,results,process,async))
;
return ((function (switch__45753__auto__,c__45865__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____0 = (function (){
var statearr_46419 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46419[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__);

(statearr_46419[(1)] = (1));

return statearr_46419;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____1 = (function (state_46390){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_46390);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e46420){if((e46420 instanceof Object)){
var ex__45757__auto__ = e46420;
var statearr_46421_46478 = state_46390;
(statearr_46421_46478[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46390);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46420;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46479 = state_46390;
state_46390 = G__46479;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__ = function(state_46390){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____1.call(this,state_46390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45754__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto__,jobs,results,process,async))
})();
var state__45867__auto__ = (function (){var statearr_46422 = f__45866__auto__.call(null);
(statearr_46422[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto__);

return statearr_46422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto__,jobs,results,process,async))
);

return c__45865__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args46480 = [];
var len__42519__auto___46483 = arguments.length;
var i__42520__auto___46484 = (0);
while(true){
if((i__42520__auto___46484 < len__42519__auto___46483)){
args46480.push((arguments[i__42520__auto___46484]));

var G__46485 = (i__42520__auto___46484 + (1));
i__42520__auto___46484 = G__46485;
continue;
} else {
}
break;
}

var G__46482 = args46480.length;
switch (G__46482) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args46480.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args46487 = [];
var len__42519__auto___46490 = arguments.length;
var i__42520__auto___46491 = (0);
while(true){
if((i__42520__auto___46491 < len__42519__auto___46490)){
args46487.push((arguments[i__42520__auto___46491]));

var G__46492 = (i__42520__auto___46491 + (1));
i__42520__auto___46491 = G__46492;
continue;
} else {
}
break;
}

var G__46489 = args46487.length;
switch (G__46489) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args46487.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args46494 = [];
var len__42519__auto___46547 = arguments.length;
var i__42520__auto___46548 = (0);
while(true){
if((i__42520__auto___46548 < len__42519__auto___46547)){
args46494.push((arguments[i__42520__auto___46548]));

var G__46549 = (i__42520__auto___46548 + (1));
i__42520__auto___46548 = G__46549;
continue;
} else {
}
break;
}

var G__46496 = args46494.length;
switch (G__46496) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args46494.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__45865__auto___46551 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto___46551,tc,fc){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto___46551,tc,fc){
return (function (state_46522){
var state_val_46523 = (state_46522[(1)]);
if((state_val_46523 === (7))){
var inst_46518 = (state_46522[(2)]);
var state_46522__$1 = state_46522;
var statearr_46524_46552 = state_46522__$1;
(statearr_46524_46552[(2)] = inst_46518);

(statearr_46524_46552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46523 === (1))){
var state_46522__$1 = state_46522;
var statearr_46525_46553 = state_46522__$1;
(statearr_46525_46553[(2)] = null);

(statearr_46525_46553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46523 === (4))){
var inst_46499 = (state_46522[(7)]);
var inst_46499__$1 = (state_46522[(2)]);
var inst_46500 = (inst_46499__$1 == null);
var state_46522__$1 = (function (){var statearr_46526 = state_46522;
(statearr_46526[(7)] = inst_46499__$1);

return statearr_46526;
})();
if(cljs.core.truth_(inst_46500)){
var statearr_46527_46554 = state_46522__$1;
(statearr_46527_46554[(1)] = (5));

} else {
var statearr_46528_46555 = state_46522__$1;
(statearr_46528_46555[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46523 === (13))){
var state_46522__$1 = state_46522;
var statearr_46529_46556 = state_46522__$1;
(statearr_46529_46556[(2)] = null);

(statearr_46529_46556[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46523 === (6))){
var inst_46499 = (state_46522[(7)]);
var inst_46505 = p.call(null,inst_46499);
var state_46522__$1 = state_46522;
if(cljs.core.truth_(inst_46505)){
var statearr_46530_46557 = state_46522__$1;
(statearr_46530_46557[(1)] = (9));

} else {
var statearr_46531_46558 = state_46522__$1;
(statearr_46531_46558[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46523 === (3))){
var inst_46520 = (state_46522[(2)]);
var state_46522__$1 = state_46522;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46522__$1,inst_46520);
} else {
if((state_val_46523 === (12))){
var state_46522__$1 = state_46522;
var statearr_46532_46559 = state_46522__$1;
(statearr_46532_46559[(2)] = null);

(statearr_46532_46559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46523 === (2))){
var state_46522__$1 = state_46522;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46522__$1,(4),ch);
} else {
if((state_val_46523 === (11))){
var inst_46499 = (state_46522[(7)]);
var inst_46509 = (state_46522[(2)]);
var state_46522__$1 = state_46522;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46522__$1,(8),inst_46509,inst_46499);
} else {
if((state_val_46523 === (9))){
var state_46522__$1 = state_46522;
var statearr_46533_46560 = state_46522__$1;
(statearr_46533_46560[(2)] = tc);

(statearr_46533_46560[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46523 === (5))){
var inst_46502 = cljs.core.async.close_BANG_.call(null,tc);
var inst_46503 = cljs.core.async.close_BANG_.call(null,fc);
var state_46522__$1 = (function (){var statearr_46534 = state_46522;
(statearr_46534[(8)] = inst_46502);

return statearr_46534;
})();
var statearr_46535_46561 = state_46522__$1;
(statearr_46535_46561[(2)] = inst_46503);

(statearr_46535_46561[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46523 === (14))){
var inst_46516 = (state_46522[(2)]);
var state_46522__$1 = state_46522;
var statearr_46536_46562 = state_46522__$1;
(statearr_46536_46562[(2)] = inst_46516);

(statearr_46536_46562[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46523 === (10))){
var state_46522__$1 = state_46522;
var statearr_46537_46563 = state_46522__$1;
(statearr_46537_46563[(2)] = fc);

(statearr_46537_46563[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46523 === (8))){
var inst_46511 = (state_46522[(2)]);
var state_46522__$1 = state_46522;
if(cljs.core.truth_(inst_46511)){
var statearr_46538_46564 = state_46522__$1;
(statearr_46538_46564[(1)] = (12));

} else {
var statearr_46539_46565 = state_46522__$1;
(statearr_46539_46565[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto___46551,tc,fc))
;
return ((function (switch__45753__auto__,c__45865__auto___46551,tc,fc){
return (function() {
var cljs$core$async$state_machine__45754__auto__ = null;
var cljs$core$async$state_machine__45754__auto____0 = (function (){
var statearr_46543 = [null,null,null,null,null,null,null,null,null];
(statearr_46543[(0)] = cljs$core$async$state_machine__45754__auto__);

(statearr_46543[(1)] = (1));

return statearr_46543;
});
var cljs$core$async$state_machine__45754__auto____1 = (function (state_46522){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_46522);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e46544){if((e46544 instanceof Object)){
var ex__45757__auto__ = e46544;
var statearr_46545_46566 = state_46522;
(statearr_46545_46566[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46522);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46544;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46567 = state_46522;
state_46522 = G__46567;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$state_machine__45754__auto__ = function(state_46522){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45754__auto____1.call(this,state_46522);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45754__auto____0;
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45754__auto____1;
return cljs$core$async$state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto___46551,tc,fc))
})();
var state__45867__auto__ = (function (){var statearr_46546 = f__45866__auto__.call(null);
(statearr_46546[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___46551);

return statearr_46546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto___46551,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__45865__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto__){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto__){
return (function (state_46631){
var state_val_46632 = (state_46631[(1)]);
if((state_val_46632 === (7))){
var inst_46627 = (state_46631[(2)]);
var state_46631__$1 = state_46631;
var statearr_46633_46654 = state_46631__$1;
(statearr_46633_46654[(2)] = inst_46627);

(statearr_46633_46654[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46632 === (1))){
var inst_46611 = init;
var state_46631__$1 = (function (){var statearr_46634 = state_46631;
(statearr_46634[(7)] = inst_46611);

return statearr_46634;
})();
var statearr_46635_46655 = state_46631__$1;
(statearr_46635_46655[(2)] = null);

(statearr_46635_46655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46632 === (4))){
var inst_46614 = (state_46631[(8)]);
var inst_46614__$1 = (state_46631[(2)]);
var inst_46615 = (inst_46614__$1 == null);
var state_46631__$1 = (function (){var statearr_46636 = state_46631;
(statearr_46636[(8)] = inst_46614__$1);

return statearr_46636;
})();
if(cljs.core.truth_(inst_46615)){
var statearr_46637_46656 = state_46631__$1;
(statearr_46637_46656[(1)] = (5));

} else {
var statearr_46638_46657 = state_46631__$1;
(statearr_46638_46657[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46632 === (6))){
var inst_46614 = (state_46631[(8)]);
var inst_46618 = (state_46631[(9)]);
var inst_46611 = (state_46631[(7)]);
var inst_46618__$1 = f.call(null,inst_46611,inst_46614);
var inst_46619 = cljs.core.reduced_QMARK_.call(null,inst_46618__$1);
var state_46631__$1 = (function (){var statearr_46639 = state_46631;
(statearr_46639[(9)] = inst_46618__$1);

return statearr_46639;
})();
if(inst_46619){
var statearr_46640_46658 = state_46631__$1;
(statearr_46640_46658[(1)] = (8));

} else {
var statearr_46641_46659 = state_46631__$1;
(statearr_46641_46659[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46632 === (3))){
var inst_46629 = (state_46631[(2)]);
var state_46631__$1 = state_46631;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46631__$1,inst_46629);
} else {
if((state_val_46632 === (2))){
var state_46631__$1 = state_46631;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46631__$1,(4),ch);
} else {
if((state_val_46632 === (9))){
var inst_46618 = (state_46631[(9)]);
var inst_46611 = inst_46618;
var state_46631__$1 = (function (){var statearr_46642 = state_46631;
(statearr_46642[(7)] = inst_46611);

return statearr_46642;
})();
var statearr_46643_46660 = state_46631__$1;
(statearr_46643_46660[(2)] = null);

(statearr_46643_46660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46632 === (5))){
var inst_46611 = (state_46631[(7)]);
var state_46631__$1 = state_46631;
var statearr_46644_46661 = state_46631__$1;
(statearr_46644_46661[(2)] = inst_46611);

(statearr_46644_46661[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46632 === (10))){
var inst_46625 = (state_46631[(2)]);
var state_46631__$1 = state_46631;
var statearr_46645_46662 = state_46631__$1;
(statearr_46645_46662[(2)] = inst_46625);

(statearr_46645_46662[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46632 === (8))){
var inst_46618 = (state_46631[(9)]);
var inst_46621 = cljs.core.deref.call(null,inst_46618);
var state_46631__$1 = state_46631;
var statearr_46646_46663 = state_46631__$1;
(statearr_46646_46663[(2)] = inst_46621);

(statearr_46646_46663[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto__))
;
return ((function (switch__45753__auto__,c__45865__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__45754__auto__ = null;
var cljs$core$async$reduce_$_state_machine__45754__auto____0 = (function (){
var statearr_46650 = [null,null,null,null,null,null,null,null,null,null];
(statearr_46650[(0)] = cljs$core$async$reduce_$_state_machine__45754__auto__);

(statearr_46650[(1)] = (1));

return statearr_46650;
});
var cljs$core$async$reduce_$_state_machine__45754__auto____1 = (function (state_46631){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_46631);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e46651){if((e46651 instanceof Object)){
var ex__45757__auto__ = e46651;
var statearr_46652_46664 = state_46631;
(statearr_46652_46664[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46631);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46651;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46665 = state_46631;
state_46631 = G__46665;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__45754__auto__ = function(state_46631){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__45754__auto____1.call(this,state_46631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__45754__auto____0;
cljs$core$async$reduce_$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__45754__auto____1;
return cljs$core$async$reduce_$_state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto__))
})();
var state__45867__auto__ = (function (){var statearr_46653 = f__45866__auto__.call(null);
(statearr_46653[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto__);

return statearr_46653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto__))
);

return c__45865__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args46666 = [];
var len__42519__auto___46718 = arguments.length;
var i__42520__auto___46719 = (0);
while(true){
if((i__42520__auto___46719 < len__42519__auto___46718)){
args46666.push((arguments[i__42520__auto___46719]));

var G__46720 = (i__42520__auto___46719 + (1));
i__42520__auto___46719 = G__46720;
continue;
} else {
}
break;
}

var G__46668 = args46666.length;
switch (G__46668) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args46666.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__45865__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto__){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto__){
return (function (state_46693){
var state_val_46694 = (state_46693[(1)]);
if((state_val_46694 === (7))){
var inst_46675 = (state_46693[(2)]);
var state_46693__$1 = state_46693;
var statearr_46695_46722 = state_46693__$1;
(statearr_46695_46722[(2)] = inst_46675);

(statearr_46695_46722[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46694 === (1))){
var inst_46669 = cljs.core.seq.call(null,coll);
var inst_46670 = inst_46669;
var state_46693__$1 = (function (){var statearr_46696 = state_46693;
(statearr_46696[(7)] = inst_46670);

return statearr_46696;
})();
var statearr_46697_46723 = state_46693__$1;
(statearr_46697_46723[(2)] = null);

(statearr_46697_46723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46694 === (4))){
var inst_46670 = (state_46693[(7)]);
var inst_46673 = cljs.core.first.call(null,inst_46670);
var state_46693__$1 = state_46693;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46693__$1,(7),ch,inst_46673);
} else {
if((state_val_46694 === (13))){
var inst_46687 = (state_46693[(2)]);
var state_46693__$1 = state_46693;
var statearr_46698_46724 = state_46693__$1;
(statearr_46698_46724[(2)] = inst_46687);

(statearr_46698_46724[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46694 === (6))){
var inst_46678 = (state_46693[(2)]);
var state_46693__$1 = state_46693;
if(cljs.core.truth_(inst_46678)){
var statearr_46699_46725 = state_46693__$1;
(statearr_46699_46725[(1)] = (8));

} else {
var statearr_46700_46726 = state_46693__$1;
(statearr_46700_46726[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46694 === (3))){
var inst_46691 = (state_46693[(2)]);
var state_46693__$1 = state_46693;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46693__$1,inst_46691);
} else {
if((state_val_46694 === (12))){
var state_46693__$1 = state_46693;
var statearr_46701_46727 = state_46693__$1;
(statearr_46701_46727[(2)] = null);

(statearr_46701_46727[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46694 === (2))){
var inst_46670 = (state_46693[(7)]);
var state_46693__$1 = state_46693;
if(cljs.core.truth_(inst_46670)){
var statearr_46702_46728 = state_46693__$1;
(statearr_46702_46728[(1)] = (4));

} else {
var statearr_46703_46729 = state_46693__$1;
(statearr_46703_46729[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46694 === (11))){
var inst_46684 = cljs.core.async.close_BANG_.call(null,ch);
var state_46693__$1 = state_46693;
var statearr_46704_46730 = state_46693__$1;
(statearr_46704_46730[(2)] = inst_46684);

(statearr_46704_46730[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46694 === (9))){
var state_46693__$1 = state_46693;
if(cljs.core.truth_(close_QMARK_)){
var statearr_46705_46731 = state_46693__$1;
(statearr_46705_46731[(1)] = (11));

} else {
var statearr_46706_46732 = state_46693__$1;
(statearr_46706_46732[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46694 === (5))){
var inst_46670 = (state_46693[(7)]);
var state_46693__$1 = state_46693;
var statearr_46707_46733 = state_46693__$1;
(statearr_46707_46733[(2)] = inst_46670);

(statearr_46707_46733[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46694 === (10))){
var inst_46689 = (state_46693[(2)]);
var state_46693__$1 = state_46693;
var statearr_46708_46734 = state_46693__$1;
(statearr_46708_46734[(2)] = inst_46689);

(statearr_46708_46734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46694 === (8))){
var inst_46670 = (state_46693[(7)]);
var inst_46680 = cljs.core.next.call(null,inst_46670);
var inst_46670__$1 = inst_46680;
var state_46693__$1 = (function (){var statearr_46709 = state_46693;
(statearr_46709[(7)] = inst_46670__$1);

return statearr_46709;
})();
var statearr_46710_46735 = state_46693__$1;
(statearr_46710_46735[(2)] = null);

(statearr_46710_46735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto__))
;
return ((function (switch__45753__auto__,c__45865__auto__){
return (function() {
var cljs$core$async$state_machine__45754__auto__ = null;
var cljs$core$async$state_machine__45754__auto____0 = (function (){
var statearr_46714 = [null,null,null,null,null,null,null,null];
(statearr_46714[(0)] = cljs$core$async$state_machine__45754__auto__);

(statearr_46714[(1)] = (1));

return statearr_46714;
});
var cljs$core$async$state_machine__45754__auto____1 = (function (state_46693){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_46693);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e46715){if((e46715 instanceof Object)){
var ex__45757__auto__ = e46715;
var statearr_46716_46736 = state_46693;
(statearr_46716_46736[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46693);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46715;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46737 = state_46693;
state_46693 = G__46737;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$state_machine__45754__auto__ = function(state_46693){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45754__auto____1.call(this,state_46693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45754__auto____0;
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45754__auto____1;
return cljs$core$async$state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto__))
})();
var state__45867__auto__ = (function (){var statearr_46717 = f__45866__auto__.call(null);
(statearr_46717[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto__);

return statearr_46717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto__))
);

return c__45865__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__42107__auto__ = (((_ == null))?null:_);
var m__42108__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__42107__auto__)]);
if(!((m__42108__auto__ == null))){
return m__42108__auto__.call(null,_);
} else {
var m__42108__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__42108__auto____$1 == null))){
return m__42108__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__42107__auto__ = (((m == null))?null:m);
var m__42108__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__42107__auto__)]);
if(!((m__42108__auto__ == null))){
return m__42108__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__42108__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__42108__auto____$1 == null))){
return m__42108__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__42107__auto__ = (((m == null))?null:m);
var m__42108__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__42107__auto__)]);
if(!((m__42108__auto__ == null))){
return m__42108__auto__.call(null,m,ch);
} else {
var m__42108__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__42108__auto____$1 == null))){
return m__42108__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__42107__auto__ = (((m == null))?null:m);
var m__42108__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__42107__auto__)]);
if(!((m__42108__auto__ == null))){
return m__42108__auto__.call(null,m);
} else {
var m__42108__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__42108__auto____$1 == null))){
return m__42108__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async46963 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46963 = (function (mult,ch,cs,meta46964){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta46964 = meta46964;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async46963.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_46965,meta46964__$1){
var self__ = this;
var _46965__$1 = this;
return (new cljs.core.async.t_cljs$core$async46963(self__.mult,self__.ch,self__.cs,meta46964__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async46963.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_46965){
var self__ = this;
var _46965__$1 = this;
return self__.meta46964;
});})(cs))
;

cljs.core.async.t_cljs$core$async46963.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async46963.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async46963.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async46963.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async46963.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async46963.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async46963.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta46964","meta46964",-444734686,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async46963.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async46963.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46963";

cljs.core.async.t_cljs$core$async46963.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__42050__auto__,writer__42051__auto__,opt__42052__auto__){
return cljs.core._write.call(null,writer__42051__auto__,"cljs.core.async/t_cljs$core$async46963");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async46963 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async46963(mult__$1,ch__$1,cs__$1,meta46964){
return (new cljs.core.async.t_cljs$core$async46963(mult__$1,ch__$1,cs__$1,meta46964));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async46963(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__45865__auto___47188 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto___47188,cs,m,dchan,dctr,done){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto___47188,cs,m,dchan,dctr,done){
return (function (state_47100){
var state_val_47101 = (state_47100[(1)]);
if((state_val_47101 === (7))){
var inst_47096 = (state_47100[(2)]);
var state_47100__$1 = state_47100;
var statearr_47102_47189 = state_47100__$1;
(statearr_47102_47189[(2)] = inst_47096);

(statearr_47102_47189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (20))){
var inst_46999 = (state_47100[(7)]);
var inst_47011 = cljs.core.first.call(null,inst_46999);
var inst_47012 = cljs.core.nth.call(null,inst_47011,(0),null);
var inst_47013 = cljs.core.nth.call(null,inst_47011,(1),null);
var state_47100__$1 = (function (){var statearr_47103 = state_47100;
(statearr_47103[(8)] = inst_47012);

return statearr_47103;
})();
if(cljs.core.truth_(inst_47013)){
var statearr_47104_47190 = state_47100__$1;
(statearr_47104_47190[(1)] = (22));

} else {
var statearr_47105_47191 = state_47100__$1;
(statearr_47105_47191[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (27))){
var inst_47043 = (state_47100[(9)]);
var inst_47048 = (state_47100[(10)]);
var inst_47041 = (state_47100[(11)]);
var inst_46968 = (state_47100[(12)]);
var inst_47048__$1 = cljs.core._nth.call(null,inst_47041,inst_47043);
var inst_47049 = cljs.core.async.put_BANG_.call(null,inst_47048__$1,inst_46968,done);
var state_47100__$1 = (function (){var statearr_47106 = state_47100;
(statearr_47106[(10)] = inst_47048__$1);

return statearr_47106;
})();
if(cljs.core.truth_(inst_47049)){
var statearr_47107_47192 = state_47100__$1;
(statearr_47107_47192[(1)] = (30));

} else {
var statearr_47108_47193 = state_47100__$1;
(statearr_47108_47193[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (1))){
var state_47100__$1 = state_47100;
var statearr_47109_47194 = state_47100__$1;
(statearr_47109_47194[(2)] = null);

(statearr_47109_47194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (24))){
var inst_46999 = (state_47100[(7)]);
var inst_47018 = (state_47100[(2)]);
var inst_47019 = cljs.core.next.call(null,inst_46999);
var inst_46977 = inst_47019;
var inst_46978 = null;
var inst_46979 = (0);
var inst_46980 = (0);
var state_47100__$1 = (function (){var statearr_47110 = state_47100;
(statearr_47110[(13)] = inst_46977);

(statearr_47110[(14)] = inst_46978);

(statearr_47110[(15)] = inst_46979);

(statearr_47110[(16)] = inst_47018);

(statearr_47110[(17)] = inst_46980);

return statearr_47110;
})();
var statearr_47111_47195 = state_47100__$1;
(statearr_47111_47195[(2)] = null);

(statearr_47111_47195[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (39))){
var state_47100__$1 = state_47100;
var statearr_47115_47196 = state_47100__$1;
(statearr_47115_47196[(2)] = null);

(statearr_47115_47196[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (4))){
var inst_46968 = (state_47100[(12)]);
var inst_46968__$1 = (state_47100[(2)]);
var inst_46969 = (inst_46968__$1 == null);
var state_47100__$1 = (function (){var statearr_47116 = state_47100;
(statearr_47116[(12)] = inst_46968__$1);

return statearr_47116;
})();
if(cljs.core.truth_(inst_46969)){
var statearr_47117_47197 = state_47100__$1;
(statearr_47117_47197[(1)] = (5));

} else {
var statearr_47118_47198 = state_47100__$1;
(statearr_47118_47198[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (15))){
var inst_46977 = (state_47100[(13)]);
var inst_46978 = (state_47100[(14)]);
var inst_46979 = (state_47100[(15)]);
var inst_46980 = (state_47100[(17)]);
var inst_46995 = (state_47100[(2)]);
var inst_46996 = (inst_46980 + (1));
var tmp47112 = inst_46977;
var tmp47113 = inst_46978;
var tmp47114 = inst_46979;
var inst_46977__$1 = tmp47112;
var inst_46978__$1 = tmp47113;
var inst_46979__$1 = tmp47114;
var inst_46980__$1 = inst_46996;
var state_47100__$1 = (function (){var statearr_47119 = state_47100;
(statearr_47119[(13)] = inst_46977__$1);

(statearr_47119[(14)] = inst_46978__$1);

(statearr_47119[(15)] = inst_46979__$1);

(statearr_47119[(17)] = inst_46980__$1);

(statearr_47119[(18)] = inst_46995);

return statearr_47119;
})();
var statearr_47120_47199 = state_47100__$1;
(statearr_47120_47199[(2)] = null);

(statearr_47120_47199[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (21))){
var inst_47022 = (state_47100[(2)]);
var state_47100__$1 = state_47100;
var statearr_47124_47200 = state_47100__$1;
(statearr_47124_47200[(2)] = inst_47022);

(statearr_47124_47200[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (31))){
var inst_47048 = (state_47100[(10)]);
var inst_47052 = done.call(null,null);
var inst_47053 = cljs.core.async.untap_STAR_.call(null,m,inst_47048);
var state_47100__$1 = (function (){var statearr_47125 = state_47100;
(statearr_47125[(19)] = inst_47052);

return statearr_47125;
})();
var statearr_47126_47201 = state_47100__$1;
(statearr_47126_47201[(2)] = inst_47053);

(statearr_47126_47201[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (32))){
var inst_47043 = (state_47100[(9)]);
var inst_47041 = (state_47100[(11)]);
var inst_47040 = (state_47100[(20)]);
var inst_47042 = (state_47100[(21)]);
var inst_47055 = (state_47100[(2)]);
var inst_47056 = (inst_47043 + (1));
var tmp47121 = inst_47041;
var tmp47122 = inst_47040;
var tmp47123 = inst_47042;
var inst_47040__$1 = tmp47122;
var inst_47041__$1 = tmp47121;
var inst_47042__$1 = tmp47123;
var inst_47043__$1 = inst_47056;
var state_47100__$1 = (function (){var statearr_47127 = state_47100;
(statearr_47127[(9)] = inst_47043__$1);

(statearr_47127[(22)] = inst_47055);

(statearr_47127[(11)] = inst_47041__$1);

(statearr_47127[(20)] = inst_47040__$1);

(statearr_47127[(21)] = inst_47042__$1);

return statearr_47127;
})();
var statearr_47128_47202 = state_47100__$1;
(statearr_47128_47202[(2)] = null);

(statearr_47128_47202[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (40))){
var inst_47068 = (state_47100[(23)]);
var inst_47072 = done.call(null,null);
var inst_47073 = cljs.core.async.untap_STAR_.call(null,m,inst_47068);
var state_47100__$1 = (function (){var statearr_47129 = state_47100;
(statearr_47129[(24)] = inst_47072);

return statearr_47129;
})();
var statearr_47130_47203 = state_47100__$1;
(statearr_47130_47203[(2)] = inst_47073);

(statearr_47130_47203[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (33))){
var inst_47059 = (state_47100[(25)]);
var inst_47061 = cljs.core.chunked_seq_QMARK_.call(null,inst_47059);
var state_47100__$1 = state_47100;
if(inst_47061){
var statearr_47131_47204 = state_47100__$1;
(statearr_47131_47204[(1)] = (36));

} else {
var statearr_47132_47205 = state_47100__$1;
(statearr_47132_47205[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (13))){
var inst_46989 = (state_47100[(26)]);
var inst_46992 = cljs.core.async.close_BANG_.call(null,inst_46989);
var state_47100__$1 = state_47100;
var statearr_47133_47206 = state_47100__$1;
(statearr_47133_47206[(2)] = inst_46992);

(statearr_47133_47206[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (22))){
var inst_47012 = (state_47100[(8)]);
var inst_47015 = cljs.core.async.close_BANG_.call(null,inst_47012);
var state_47100__$1 = state_47100;
var statearr_47134_47207 = state_47100__$1;
(statearr_47134_47207[(2)] = inst_47015);

(statearr_47134_47207[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (36))){
var inst_47059 = (state_47100[(25)]);
var inst_47063 = cljs.core.chunk_first.call(null,inst_47059);
var inst_47064 = cljs.core.chunk_rest.call(null,inst_47059);
var inst_47065 = cljs.core.count.call(null,inst_47063);
var inst_47040 = inst_47064;
var inst_47041 = inst_47063;
var inst_47042 = inst_47065;
var inst_47043 = (0);
var state_47100__$1 = (function (){var statearr_47135 = state_47100;
(statearr_47135[(9)] = inst_47043);

(statearr_47135[(11)] = inst_47041);

(statearr_47135[(20)] = inst_47040);

(statearr_47135[(21)] = inst_47042);

return statearr_47135;
})();
var statearr_47136_47208 = state_47100__$1;
(statearr_47136_47208[(2)] = null);

(statearr_47136_47208[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (41))){
var inst_47059 = (state_47100[(25)]);
var inst_47075 = (state_47100[(2)]);
var inst_47076 = cljs.core.next.call(null,inst_47059);
var inst_47040 = inst_47076;
var inst_47041 = null;
var inst_47042 = (0);
var inst_47043 = (0);
var state_47100__$1 = (function (){var statearr_47137 = state_47100;
(statearr_47137[(9)] = inst_47043);

(statearr_47137[(11)] = inst_47041);

(statearr_47137[(20)] = inst_47040);

(statearr_47137[(21)] = inst_47042);

(statearr_47137[(27)] = inst_47075);

return statearr_47137;
})();
var statearr_47138_47209 = state_47100__$1;
(statearr_47138_47209[(2)] = null);

(statearr_47138_47209[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (43))){
var state_47100__$1 = state_47100;
var statearr_47139_47210 = state_47100__$1;
(statearr_47139_47210[(2)] = null);

(statearr_47139_47210[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (29))){
var inst_47084 = (state_47100[(2)]);
var state_47100__$1 = state_47100;
var statearr_47140_47211 = state_47100__$1;
(statearr_47140_47211[(2)] = inst_47084);

(statearr_47140_47211[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (44))){
var inst_47093 = (state_47100[(2)]);
var state_47100__$1 = (function (){var statearr_47141 = state_47100;
(statearr_47141[(28)] = inst_47093);

return statearr_47141;
})();
var statearr_47142_47212 = state_47100__$1;
(statearr_47142_47212[(2)] = null);

(statearr_47142_47212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (6))){
var inst_47032 = (state_47100[(29)]);
var inst_47031 = cljs.core.deref.call(null,cs);
var inst_47032__$1 = cljs.core.keys.call(null,inst_47031);
var inst_47033 = cljs.core.count.call(null,inst_47032__$1);
var inst_47034 = cljs.core.reset_BANG_.call(null,dctr,inst_47033);
var inst_47039 = cljs.core.seq.call(null,inst_47032__$1);
var inst_47040 = inst_47039;
var inst_47041 = null;
var inst_47042 = (0);
var inst_47043 = (0);
var state_47100__$1 = (function (){var statearr_47143 = state_47100;
(statearr_47143[(9)] = inst_47043);

(statearr_47143[(29)] = inst_47032__$1);

(statearr_47143[(30)] = inst_47034);

(statearr_47143[(11)] = inst_47041);

(statearr_47143[(20)] = inst_47040);

(statearr_47143[(21)] = inst_47042);

return statearr_47143;
})();
var statearr_47144_47213 = state_47100__$1;
(statearr_47144_47213[(2)] = null);

(statearr_47144_47213[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (28))){
var inst_47059 = (state_47100[(25)]);
var inst_47040 = (state_47100[(20)]);
var inst_47059__$1 = cljs.core.seq.call(null,inst_47040);
var state_47100__$1 = (function (){var statearr_47145 = state_47100;
(statearr_47145[(25)] = inst_47059__$1);

return statearr_47145;
})();
if(inst_47059__$1){
var statearr_47146_47214 = state_47100__$1;
(statearr_47146_47214[(1)] = (33));

} else {
var statearr_47147_47215 = state_47100__$1;
(statearr_47147_47215[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (25))){
var inst_47043 = (state_47100[(9)]);
var inst_47042 = (state_47100[(21)]);
var inst_47045 = (inst_47043 < inst_47042);
var inst_47046 = inst_47045;
var state_47100__$1 = state_47100;
if(cljs.core.truth_(inst_47046)){
var statearr_47148_47216 = state_47100__$1;
(statearr_47148_47216[(1)] = (27));

} else {
var statearr_47149_47217 = state_47100__$1;
(statearr_47149_47217[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (34))){
var state_47100__$1 = state_47100;
var statearr_47150_47218 = state_47100__$1;
(statearr_47150_47218[(2)] = null);

(statearr_47150_47218[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (17))){
var state_47100__$1 = state_47100;
var statearr_47151_47219 = state_47100__$1;
(statearr_47151_47219[(2)] = null);

(statearr_47151_47219[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (3))){
var inst_47098 = (state_47100[(2)]);
var state_47100__$1 = state_47100;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47100__$1,inst_47098);
} else {
if((state_val_47101 === (12))){
var inst_47027 = (state_47100[(2)]);
var state_47100__$1 = state_47100;
var statearr_47152_47220 = state_47100__$1;
(statearr_47152_47220[(2)] = inst_47027);

(statearr_47152_47220[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (2))){
var state_47100__$1 = state_47100;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47100__$1,(4),ch);
} else {
if((state_val_47101 === (23))){
var state_47100__$1 = state_47100;
var statearr_47153_47221 = state_47100__$1;
(statearr_47153_47221[(2)] = null);

(statearr_47153_47221[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (35))){
var inst_47082 = (state_47100[(2)]);
var state_47100__$1 = state_47100;
var statearr_47154_47222 = state_47100__$1;
(statearr_47154_47222[(2)] = inst_47082);

(statearr_47154_47222[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (19))){
var inst_46999 = (state_47100[(7)]);
var inst_47003 = cljs.core.chunk_first.call(null,inst_46999);
var inst_47004 = cljs.core.chunk_rest.call(null,inst_46999);
var inst_47005 = cljs.core.count.call(null,inst_47003);
var inst_46977 = inst_47004;
var inst_46978 = inst_47003;
var inst_46979 = inst_47005;
var inst_46980 = (0);
var state_47100__$1 = (function (){var statearr_47155 = state_47100;
(statearr_47155[(13)] = inst_46977);

(statearr_47155[(14)] = inst_46978);

(statearr_47155[(15)] = inst_46979);

(statearr_47155[(17)] = inst_46980);

return statearr_47155;
})();
var statearr_47156_47223 = state_47100__$1;
(statearr_47156_47223[(2)] = null);

(statearr_47156_47223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (11))){
var inst_46977 = (state_47100[(13)]);
var inst_46999 = (state_47100[(7)]);
var inst_46999__$1 = cljs.core.seq.call(null,inst_46977);
var state_47100__$1 = (function (){var statearr_47157 = state_47100;
(statearr_47157[(7)] = inst_46999__$1);

return statearr_47157;
})();
if(inst_46999__$1){
var statearr_47158_47224 = state_47100__$1;
(statearr_47158_47224[(1)] = (16));

} else {
var statearr_47159_47225 = state_47100__$1;
(statearr_47159_47225[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (9))){
var inst_47029 = (state_47100[(2)]);
var state_47100__$1 = state_47100;
var statearr_47160_47226 = state_47100__$1;
(statearr_47160_47226[(2)] = inst_47029);

(statearr_47160_47226[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (5))){
var inst_46975 = cljs.core.deref.call(null,cs);
var inst_46976 = cljs.core.seq.call(null,inst_46975);
var inst_46977 = inst_46976;
var inst_46978 = null;
var inst_46979 = (0);
var inst_46980 = (0);
var state_47100__$1 = (function (){var statearr_47161 = state_47100;
(statearr_47161[(13)] = inst_46977);

(statearr_47161[(14)] = inst_46978);

(statearr_47161[(15)] = inst_46979);

(statearr_47161[(17)] = inst_46980);

return statearr_47161;
})();
var statearr_47162_47227 = state_47100__$1;
(statearr_47162_47227[(2)] = null);

(statearr_47162_47227[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (14))){
var state_47100__$1 = state_47100;
var statearr_47163_47228 = state_47100__$1;
(statearr_47163_47228[(2)] = null);

(statearr_47163_47228[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (45))){
var inst_47090 = (state_47100[(2)]);
var state_47100__$1 = state_47100;
var statearr_47164_47229 = state_47100__$1;
(statearr_47164_47229[(2)] = inst_47090);

(statearr_47164_47229[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (26))){
var inst_47032 = (state_47100[(29)]);
var inst_47086 = (state_47100[(2)]);
var inst_47087 = cljs.core.seq.call(null,inst_47032);
var state_47100__$1 = (function (){var statearr_47165 = state_47100;
(statearr_47165[(31)] = inst_47086);

return statearr_47165;
})();
if(inst_47087){
var statearr_47166_47230 = state_47100__$1;
(statearr_47166_47230[(1)] = (42));

} else {
var statearr_47167_47231 = state_47100__$1;
(statearr_47167_47231[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (16))){
var inst_46999 = (state_47100[(7)]);
var inst_47001 = cljs.core.chunked_seq_QMARK_.call(null,inst_46999);
var state_47100__$1 = state_47100;
if(inst_47001){
var statearr_47168_47232 = state_47100__$1;
(statearr_47168_47232[(1)] = (19));

} else {
var statearr_47169_47233 = state_47100__$1;
(statearr_47169_47233[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (38))){
var inst_47079 = (state_47100[(2)]);
var state_47100__$1 = state_47100;
var statearr_47170_47234 = state_47100__$1;
(statearr_47170_47234[(2)] = inst_47079);

(statearr_47170_47234[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (30))){
var state_47100__$1 = state_47100;
var statearr_47171_47235 = state_47100__$1;
(statearr_47171_47235[(2)] = null);

(statearr_47171_47235[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (10))){
var inst_46978 = (state_47100[(14)]);
var inst_46980 = (state_47100[(17)]);
var inst_46988 = cljs.core._nth.call(null,inst_46978,inst_46980);
var inst_46989 = cljs.core.nth.call(null,inst_46988,(0),null);
var inst_46990 = cljs.core.nth.call(null,inst_46988,(1),null);
var state_47100__$1 = (function (){var statearr_47172 = state_47100;
(statearr_47172[(26)] = inst_46989);

return statearr_47172;
})();
if(cljs.core.truth_(inst_46990)){
var statearr_47173_47236 = state_47100__$1;
(statearr_47173_47236[(1)] = (13));

} else {
var statearr_47174_47237 = state_47100__$1;
(statearr_47174_47237[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (18))){
var inst_47025 = (state_47100[(2)]);
var state_47100__$1 = state_47100;
var statearr_47175_47238 = state_47100__$1;
(statearr_47175_47238[(2)] = inst_47025);

(statearr_47175_47238[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (42))){
var state_47100__$1 = state_47100;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47100__$1,(45),dchan);
} else {
if((state_val_47101 === (37))){
var inst_47059 = (state_47100[(25)]);
var inst_47068 = (state_47100[(23)]);
var inst_46968 = (state_47100[(12)]);
var inst_47068__$1 = cljs.core.first.call(null,inst_47059);
var inst_47069 = cljs.core.async.put_BANG_.call(null,inst_47068__$1,inst_46968,done);
var state_47100__$1 = (function (){var statearr_47176 = state_47100;
(statearr_47176[(23)] = inst_47068__$1);

return statearr_47176;
})();
if(cljs.core.truth_(inst_47069)){
var statearr_47177_47239 = state_47100__$1;
(statearr_47177_47239[(1)] = (39));

} else {
var statearr_47178_47240 = state_47100__$1;
(statearr_47178_47240[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47101 === (8))){
var inst_46979 = (state_47100[(15)]);
var inst_46980 = (state_47100[(17)]);
var inst_46982 = (inst_46980 < inst_46979);
var inst_46983 = inst_46982;
var state_47100__$1 = state_47100;
if(cljs.core.truth_(inst_46983)){
var statearr_47179_47241 = state_47100__$1;
(statearr_47179_47241[(1)] = (10));

} else {
var statearr_47180_47242 = state_47100__$1;
(statearr_47180_47242[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto___47188,cs,m,dchan,dctr,done))
;
return ((function (switch__45753__auto__,c__45865__auto___47188,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__45754__auto__ = null;
var cljs$core$async$mult_$_state_machine__45754__auto____0 = (function (){
var statearr_47184 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47184[(0)] = cljs$core$async$mult_$_state_machine__45754__auto__);

(statearr_47184[(1)] = (1));

return statearr_47184;
});
var cljs$core$async$mult_$_state_machine__45754__auto____1 = (function (state_47100){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_47100);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e47185){if((e47185 instanceof Object)){
var ex__45757__auto__ = e47185;
var statearr_47186_47243 = state_47100;
(statearr_47186_47243[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47100);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47185;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47244 = state_47100;
state_47100 = G__47244;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__45754__auto__ = function(state_47100){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__45754__auto____1.call(this,state_47100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__45754__auto____0;
cljs$core$async$mult_$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__45754__auto____1;
return cljs$core$async$mult_$_state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto___47188,cs,m,dchan,dctr,done))
})();
var state__45867__auto__ = (function (){var statearr_47187 = f__45866__auto__.call(null);
(statearr_47187[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___47188);

return statearr_47187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto___47188,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args47245 = [];
var len__42519__auto___47248 = arguments.length;
var i__42520__auto___47249 = (0);
while(true){
if((i__42520__auto___47249 < len__42519__auto___47248)){
args47245.push((arguments[i__42520__auto___47249]));

var G__47250 = (i__42520__auto___47249 + (1));
i__42520__auto___47249 = G__47250;
continue;
} else {
}
break;
}

var G__47247 = args47245.length;
switch (G__47247) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args47245.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__42107__auto__ = (((m == null))?null:m);
var m__42108__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__42107__auto__)]);
if(!((m__42108__auto__ == null))){
return m__42108__auto__.call(null,m,ch);
} else {
var m__42108__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__42108__auto____$1 == null))){
return m__42108__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__42107__auto__ = (((m == null))?null:m);
var m__42108__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__42107__auto__)]);
if(!((m__42108__auto__ == null))){
return m__42108__auto__.call(null,m,ch);
} else {
var m__42108__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__42108__auto____$1 == null))){
return m__42108__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__42107__auto__ = (((m == null))?null:m);
var m__42108__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__42107__auto__)]);
if(!((m__42108__auto__ == null))){
return m__42108__auto__.call(null,m);
} else {
var m__42108__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__42108__auto____$1 == null))){
return m__42108__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__42107__auto__ = (((m == null))?null:m);
var m__42108__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__42107__auto__)]);
if(!((m__42108__auto__ == null))){
return m__42108__auto__.call(null,m,state_map);
} else {
var m__42108__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__42108__auto____$1 == null))){
return m__42108__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__42107__auto__ = (((m == null))?null:m);
var m__42108__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__42107__auto__)]);
if(!((m__42108__auto__ == null))){
return m__42108__auto__.call(null,m,mode);
} else {
var m__42108__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__42108__auto____$1 == null))){
return m__42108__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__42526__auto__ = [];
var len__42519__auto___47262 = arguments.length;
var i__42520__auto___47263 = (0);
while(true){
if((i__42520__auto___47263 < len__42519__auto___47262)){
args__42526__auto__.push((arguments[i__42520__auto___47263]));

var G__47264 = (i__42520__auto___47263 + (1));
i__42520__auto___47263 = G__47264;
continue;
} else {
}
break;
}

var argseq__42527__auto__ = ((((3) < args__42526__auto__.length))?(new cljs.core.IndexedSeq(args__42526__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__42527__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__47256){
var map__47257 = p__47256;
var map__47257__$1 = ((((!((map__47257 == null)))?((((map__47257.cljs$lang$protocol_mask$partition0$ & (64))) || (map__47257.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47257):map__47257);
var opts = map__47257__$1;
var statearr_47259_47265 = state;
(statearr_47259_47265[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__47257,map__47257__$1,opts){
return (function (val){
var statearr_47260_47266 = state;
(statearr_47260_47266[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__47257,map__47257__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_47261_47267 = state;
(statearr_47261_47267[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq47252){
var G__47253 = cljs.core.first.call(null,seq47252);
var seq47252__$1 = cljs.core.next.call(null,seq47252);
var G__47254 = cljs.core.first.call(null,seq47252__$1);
var seq47252__$2 = cljs.core.next.call(null,seq47252__$1);
var G__47255 = cljs.core.first.call(null,seq47252__$2);
var seq47252__$3 = cljs.core.next.call(null,seq47252__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__47253,G__47254,G__47255,seq47252__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async47433 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47433 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta47434){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta47434 = meta47434;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async47433.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_47435,meta47434__$1){
var self__ = this;
var _47435__$1 = this;
return (new cljs.core.async.t_cljs$core$async47433(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta47434__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47433.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_47435){
var self__ = this;
var _47435__$1 = this;
return self__.meta47434;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47433.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async47433.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47433.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async47433.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47433.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47433.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47433.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47433.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47433.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta47434","meta47434",-982915577,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47433.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async47433.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47433";

cljs.core.async.t_cljs$core$async47433.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__42050__auto__,writer__42051__auto__,opt__42052__auto__){
return cljs.core._write.call(null,writer__42051__auto__,"cljs.core.async/t_cljs$core$async47433");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async47433 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async47433(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta47434){
return (new cljs.core.async.t_cljs$core$async47433(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta47434));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async47433(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__45865__auto___47598 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto___47598,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto___47598,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_47535){
var state_val_47536 = (state_47535[(1)]);
if((state_val_47536 === (7))){
var inst_47451 = (state_47535[(2)]);
var state_47535__$1 = state_47535;
var statearr_47537_47599 = state_47535__$1;
(statearr_47537_47599[(2)] = inst_47451);

(statearr_47537_47599[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (20))){
var inst_47463 = (state_47535[(7)]);
var state_47535__$1 = state_47535;
var statearr_47538_47600 = state_47535__$1;
(statearr_47538_47600[(2)] = inst_47463);

(statearr_47538_47600[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (27))){
var state_47535__$1 = state_47535;
var statearr_47539_47601 = state_47535__$1;
(statearr_47539_47601[(2)] = null);

(statearr_47539_47601[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (1))){
var inst_47439 = (state_47535[(8)]);
var inst_47439__$1 = calc_state.call(null);
var inst_47441 = (inst_47439__$1 == null);
var inst_47442 = cljs.core.not.call(null,inst_47441);
var state_47535__$1 = (function (){var statearr_47540 = state_47535;
(statearr_47540[(8)] = inst_47439__$1);

return statearr_47540;
})();
if(inst_47442){
var statearr_47541_47602 = state_47535__$1;
(statearr_47541_47602[(1)] = (2));

} else {
var statearr_47542_47603 = state_47535__$1;
(statearr_47542_47603[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (24))){
var inst_47486 = (state_47535[(9)]);
var inst_47509 = (state_47535[(10)]);
var inst_47495 = (state_47535[(11)]);
var inst_47509__$1 = inst_47486.call(null,inst_47495);
var state_47535__$1 = (function (){var statearr_47543 = state_47535;
(statearr_47543[(10)] = inst_47509__$1);

return statearr_47543;
})();
if(cljs.core.truth_(inst_47509__$1)){
var statearr_47544_47604 = state_47535__$1;
(statearr_47544_47604[(1)] = (29));

} else {
var statearr_47545_47605 = state_47535__$1;
(statearr_47545_47605[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (4))){
var inst_47454 = (state_47535[(2)]);
var state_47535__$1 = state_47535;
if(cljs.core.truth_(inst_47454)){
var statearr_47546_47606 = state_47535__$1;
(statearr_47546_47606[(1)] = (8));

} else {
var statearr_47547_47607 = state_47535__$1;
(statearr_47547_47607[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (15))){
var inst_47480 = (state_47535[(2)]);
var state_47535__$1 = state_47535;
if(cljs.core.truth_(inst_47480)){
var statearr_47548_47608 = state_47535__$1;
(statearr_47548_47608[(1)] = (19));

} else {
var statearr_47549_47609 = state_47535__$1;
(statearr_47549_47609[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (21))){
var inst_47485 = (state_47535[(12)]);
var inst_47485__$1 = (state_47535[(2)]);
var inst_47486 = cljs.core.get.call(null,inst_47485__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_47487 = cljs.core.get.call(null,inst_47485__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_47488 = cljs.core.get.call(null,inst_47485__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_47535__$1 = (function (){var statearr_47550 = state_47535;
(statearr_47550[(12)] = inst_47485__$1);

(statearr_47550[(9)] = inst_47486);

(statearr_47550[(13)] = inst_47487);

return statearr_47550;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_47535__$1,(22),inst_47488);
} else {
if((state_val_47536 === (31))){
var inst_47517 = (state_47535[(2)]);
var state_47535__$1 = state_47535;
if(cljs.core.truth_(inst_47517)){
var statearr_47551_47610 = state_47535__$1;
(statearr_47551_47610[(1)] = (32));

} else {
var statearr_47552_47611 = state_47535__$1;
(statearr_47552_47611[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (32))){
var inst_47494 = (state_47535[(14)]);
var state_47535__$1 = state_47535;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47535__$1,(35),out,inst_47494);
} else {
if((state_val_47536 === (33))){
var inst_47485 = (state_47535[(12)]);
var inst_47463 = inst_47485;
var state_47535__$1 = (function (){var statearr_47553 = state_47535;
(statearr_47553[(7)] = inst_47463);

return statearr_47553;
})();
var statearr_47554_47612 = state_47535__$1;
(statearr_47554_47612[(2)] = null);

(statearr_47554_47612[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (13))){
var inst_47463 = (state_47535[(7)]);
var inst_47470 = inst_47463.cljs$lang$protocol_mask$partition0$;
var inst_47471 = (inst_47470 & (64));
var inst_47472 = inst_47463.cljs$core$ISeq$;
var inst_47473 = (inst_47471) || (inst_47472);
var state_47535__$1 = state_47535;
if(cljs.core.truth_(inst_47473)){
var statearr_47555_47613 = state_47535__$1;
(statearr_47555_47613[(1)] = (16));

} else {
var statearr_47556_47614 = state_47535__$1;
(statearr_47556_47614[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (22))){
var inst_47495 = (state_47535[(11)]);
var inst_47494 = (state_47535[(14)]);
var inst_47493 = (state_47535[(2)]);
var inst_47494__$1 = cljs.core.nth.call(null,inst_47493,(0),null);
var inst_47495__$1 = cljs.core.nth.call(null,inst_47493,(1),null);
var inst_47496 = (inst_47494__$1 == null);
var inst_47497 = cljs.core._EQ_.call(null,inst_47495__$1,change);
var inst_47498 = (inst_47496) || (inst_47497);
var state_47535__$1 = (function (){var statearr_47557 = state_47535;
(statearr_47557[(11)] = inst_47495__$1);

(statearr_47557[(14)] = inst_47494__$1);

return statearr_47557;
})();
if(cljs.core.truth_(inst_47498)){
var statearr_47558_47615 = state_47535__$1;
(statearr_47558_47615[(1)] = (23));

} else {
var statearr_47559_47616 = state_47535__$1;
(statearr_47559_47616[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (36))){
var inst_47485 = (state_47535[(12)]);
var inst_47463 = inst_47485;
var state_47535__$1 = (function (){var statearr_47560 = state_47535;
(statearr_47560[(7)] = inst_47463);

return statearr_47560;
})();
var statearr_47561_47617 = state_47535__$1;
(statearr_47561_47617[(2)] = null);

(statearr_47561_47617[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (29))){
var inst_47509 = (state_47535[(10)]);
var state_47535__$1 = state_47535;
var statearr_47562_47618 = state_47535__$1;
(statearr_47562_47618[(2)] = inst_47509);

(statearr_47562_47618[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (6))){
var state_47535__$1 = state_47535;
var statearr_47563_47619 = state_47535__$1;
(statearr_47563_47619[(2)] = false);

(statearr_47563_47619[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (28))){
var inst_47505 = (state_47535[(2)]);
var inst_47506 = calc_state.call(null);
var inst_47463 = inst_47506;
var state_47535__$1 = (function (){var statearr_47564 = state_47535;
(statearr_47564[(7)] = inst_47463);

(statearr_47564[(15)] = inst_47505);

return statearr_47564;
})();
var statearr_47565_47620 = state_47535__$1;
(statearr_47565_47620[(2)] = null);

(statearr_47565_47620[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (25))){
var inst_47531 = (state_47535[(2)]);
var state_47535__$1 = state_47535;
var statearr_47566_47621 = state_47535__$1;
(statearr_47566_47621[(2)] = inst_47531);

(statearr_47566_47621[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (34))){
var inst_47529 = (state_47535[(2)]);
var state_47535__$1 = state_47535;
var statearr_47567_47622 = state_47535__$1;
(statearr_47567_47622[(2)] = inst_47529);

(statearr_47567_47622[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (17))){
var state_47535__$1 = state_47535;
var statearr_47568_47623 = state_47535__$1;
(statearr_47568_47623[(2)] = false);

(statearr_47568_47623[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (3))){
var state_47535__$1 = state_47535;
var statearr_47569_47624 = state_47535__$1;
(statearr_47569_47624[(2)] = false);

(statearr_47569_47624[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (12))){
var inst_47533 = (state_47535[(2)]);
var state_47535__$1 = state_47535;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47535__$1,inst_47533);
} else {
if((state_val_47536 === (2))){
var inst_47439 = (state_47535[(8)]);
var inst_47444 = inst_47439.cljs$lang$protocol_mask$partition0$;
var inst_47445 = (inst_47444 & (64));
var inst_47446 = inst_47439.cljs$core$ISeq$;
var inst_47447 = (inst_47445) || (inst_47446);
var state_47535__$1 = state_47535;
if(cljs.core.truth_(inst_47447)){
var statearr_47570_47625 = state_47535__$1;
(statearr_47570_47625[(1)] = (5));

} else {
var statearr_47571_47626 = state_47535__$1;
(statearr_47571_47626[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (23))){
var inst_47494 = (state_47535[(14)]);
var inst_47500 = (inst_47494 == null);
var state_47535__$1 = state_47535;
if(cljs.core.truth_(inst_47500)){
var statearr_47572_47627 = state_47535__$1;
(statearr_47572_47627[(1)] = (26));

} else {
var statearr_47573_47628 = state_47535__$1;
(statearr_47573_47628[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (35))){
var inst_47520 = (state_47535[(2)]);
var state_47535__$1 = state_47535;
if(cljs.core.truth_(inst_47520)){
var statearr_47574_47629 = state_47535__$1;
(statearr_47574_47629[(1)] = (36));

} else {
var statearr_47575_47630 = state_47535__$1;
(statearr_47575_47630[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (19))){
var inst_47463 = (state_47535[(7)]);
var inst_47482 = cljs.core.apply.call(null,cljs.core.hash_map,inst_47463);
var state_47535__$1 = state_47535;
var statearr_47576_47631 = state_47535__$1;
(statearr_47576_47631[(2)] = inst_47482);

(statearr_47576_47631[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (11))){
var inst_47463 = (state_47535[(7)]);
var inst_47467 = (inst_47463 == null);
var inst_47468 = cljs.core.not.call(null,inst_47467);
var state_47535__$1 = state_47535;
if(inst_47468){
var statearr_47577_47632 = state_47535__$1;
(statearr_47577_47632[(1)] = (13));

} else {
var statearr_47578_47633 = state_47535__$1;
(statearr_47578_47633[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (9))){
var inst_47439 = (state_47535[(8)]);
var state_47535__$1 = state_47535;
var statearr_47579_47634 = state_47535__$1;
(statearr_47579_47634[(2)] = inst_47439);

(statearr_47579_47634[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (5))){
var state_47535__$1 = state_47535;
var statearr_47580_47635 = state_47535__$1;
(statearr_47580_47635[(2)] = true);

(statearr_47580_47635[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (14))){
var state_47535__$1 = state_47535;
var statearr_47581_47636 = state_47535__$1;
(statearr_47581_47636[(2)] = false);

(statearr_47581_47636[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (26))){
var inst_47495 = (state_47535[(11)]);
var inst_47502 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_47495);
var state_47535__$1 = state_47535;
var statearr_47582_47637 = state_47535__$1;
(statearr_47582_47637[(2)] = inst_47502);

(statearr_47582_47637[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (16))){
var state_47535__$1 = state_47535;
var statearr_47583_47638 = state_47535__$1;
(statearr_47583_47638[(2)] = true);

(statearr_47583_47638[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (38))){
var inst_47525 = (state_47535[(2)]);
var state_47535__$1 = state_47535;
var statearr_47584_47639 = state_47535__$1;
(statearr_47584_47639[(2)] = inst_47525);

(statearr_47584_47639[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (30))){
var inst_47486 = (state_47535[(9)]);
var inst_47487 = (state_47535[(13)]);
var inst_47495 = (state_47535[(11)]);
var inst_47512 = cljs.core.empty_QMARK_.call(null,inst_47486);
var inst_47513 = inst_47487.call(null,inst_47495);
var inst_47514 = cljs.core.not.call(null,inst_47513);
var inst_47515 = (inst_47512) && (inst_47514);
var state_47535__$1 = state_47535;
var statearr_47585_47640 = state_47535__$1;
(statearr_47585_47640[(2)] = inst_47515);

(statearr_47585_47640[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (10))){
var inst_47439 = (state_47535[(8)]);
var inst_47459 = (state_47535[(2)]);
var inst_47460 = cljs.core.get.call(null,inst_47459,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_47461 = cljs.core.get.call(null,inst_47459,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_47462 = cljs.core.get.call(null,inst_47459,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_47463 = inst_47439;
var state_47535__$1 = (function (){var statearr_47586 = state_47535;
(statearr_47586[(16)] = inst_47460);

(statearr_47586[(7)] = inst_47463);

(statearr_47586[(17)] = inst_47462);

(statearr_47586[(18)] = inst_47461);

return statearr_47586;
})();
var statearr_47587_47641 = state_47535__$1;
(statearr_47587_47641[(2)] = null);

(statearr_47587_47641[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (18))){
var inst_47477 = (state_47535[(2)]);
var state_47535__$1 = state_47535;
var statearr_47588_47642 = state_47535__$1;
(statearr_47588_47642[(2)] = inst_47477);

(statearr_47588_47642[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (37))){
var state_47535__$1 = state_47535;
var statearr_47589_47643 = state_47535__$1;
(statearr_47589_47643[(2)] = null);

(statearr_47589_47643[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47536 === (8))){
var inst_47439 = (state_47535[(8)]);
var inst_47456 = cljs.core.apply.call(null,cljs.core.hash_map,inst_47439);
var state_47535__$1 = state_47535;
var statearr_47590_47644 = state_47535__$1;
(statearr_47590_47644[(2)] = inst_47456);

(statearr_47590_47644[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto___47598,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__45753__auto__,c__45865__auto___47598,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__45754__auto__ = null;
var cljs$core$async$mix_$_state_machine__45754__auto____0 = (function (){
var statearr_47594 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47594[(0)] = cljs$core$async$mix_$_state_machine__45754__auto__);

(statearr_47594[(1)] = (1));

return statearr_47594;
});
var cljs$core$async$mix_$_state_machine__45754__auto____1 = (function (state_47535){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_47535);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e47595){if((e47595 instanceof Object)){
var ex__45757__auto__ = e47595;
var statearr_47596_47645 = state_47535;
(statearr_47596_47645[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47535);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47595;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47646 = state_47535;
state_47535 = G__47646;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__45754__auto__ = function(state_47535){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__45754__auto____1.call(this,state_47535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__45754__auto____0;
cljs$core$async$mix_$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__45754__auto____1;
return cljs$core$async$mix_$_state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto___47598,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__45867__auto__ = (function (){var statearr_47597 = f__45866__auto__.call(null);
(statearr_47597[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___47598);

return statearr_47597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto___47598,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__42107__auto__ = (((p == null))?null:p);
var m__42108__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__42107__auto__)]);
if(!((m__42108__auto__ == null))){
return m__42108__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__42108__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__42108__auto____$1 == null))){
return m__42108__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__42107__auto__ = (((p == null))?null:p);
var m__42108__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__42107__auto__)]);
if(!((m__42108__auto__ == null))){
return m__42108__auto__.call(null,p,v,ch);
} else {
var m__42108__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__42108__auto____$1 == null))){
return m__42108__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args47647 = [];
var len__42519__auto___47650 = arguments.length;
var i__42520__auto___47651 = (0);
while(true){
if((i__42520__auto___47651 < len__42519__auto___47650)){
args47647.push((arguments[i__42520__auto___47651]));

var G__47652 = (i__42520__auto___47651 + (1));
i__42520__auto___47651 = G__47652;
continue;
} else {
}
break;
}

var G__47649 = args47647.length;
switch (G__47649) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args47647.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__42107__auto__ = (((p == null))?null:p);
var m__42108__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__42107__auto__)]);
if(!((m__42108__auto__ == null))){
return m__42108__auto__.call(null,p);
} else {
var m__42108__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__42108__auto____$1 == null))){
return m__42108__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__42107__auto__ = (((p == null))?null:p);
var m__42108__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__42107__auto__)]);
if(!((m__42108__auto__ == null))){
return m__42108__auto__.call(null,p,v);
} else {
var m__42108__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__42108__auto____$1 == null))){
return m__42108__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args47655 = [];
var len__42519__auto___47780 = arguments.length;
var i__42520__auto___47781 = (0);
while(true){
if((i__42520__auto___47781 < len__42519__auto___47780)){
args47655.push((arguments[i__42520__auto___47781]));

var G__47782 = (i__42520__auto___47781 + (1));
i__42520__auto___47781 = G__47782;
continue;
} else {
}
break;
}

var G__47657 = args47655.length;
switch (G__47657) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args47655.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__41444__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__41444__auto__)){
return or__41444__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__41444__auto__,mults){
return (function (p1__47654_SHARP_){
if(cljs.core.truth_(p1__47654_SHARP_.call(null,topic))){
return p1__47654_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__47654_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__41444__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async47658 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47658 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta47659){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta47659 = meta47659;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async47658.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_47660,meta47659__$1){
var self__ = this;
var _47660__$1 = this;
return (new cljs.core.async.t_cljs$core$async47658(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta47659__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async47658.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_47660){
var self__ = this;
var _47660__$1 = this;
return self__.meta47659;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async47658.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async47658.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async47658.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async47658.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async47658.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async47658.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async47658.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async47658.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta47659","meta47659",195443154,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async47658.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async47658.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47658";

cljs.core.async.t_cljs$core$async47658.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__42050__auto__,writer__42051__auto__,opt__42052__auto__){
return cljs.core._write.call(null,writer__42051__auto__,"cljs.core.async/t_cljs$core$async47658");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async47658 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async47658(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta47659){
return (new cljs.core.async.t_cljs$core$async47658(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta47659));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async47658(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__45865__auto___47784 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto___47784,mults,ensure_mult,p){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto___47784,mults,ensure_mult,p){
return (function (state_47732){
var state_val_47733 = (state_47732[(1)]);
if((state_val_47733 === (7))){
var inst_47728 = (state_47732[(2)]);
var state_47732__$1 = state_47732;
var statearr_47734_47785 = state_47732__$1;
(statearr_47734_47785[(2)] = inst_47728);

(statearr_47734_47785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (20))){
var state_47732__$1 = state_47732;
var statearr_47735_47786 = state_47732__$1;
(statearr_47735_47786[(2)] = null);

(statearr_47735_47786[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (1))){
var state_47732__$1 = state_47732;
var statearr_47736_47787 = state_47732__$1;
(statearr_47736_47787[(2)] = null);

(statearr_47736_47787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (24))){
var inst_47711 = (state_47732[(7)]);
var inst_47720 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_47711);
var state_47732__$1 = state_47732;
var statearr_47737_47788 = state_47732__$1;
(statearr_47737_47788[(2)] = inst_47720);

(statearr_47737_47788[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (4))){
var inst_47663 = (state_47732[(8)]);
var inst_47663__$1 = (state_47732[(2)]);
var inst_47664 = (inst_47663__$1 == null);
var state_47732__$1 = (function (){var statearr_47738 = state_47732;
(statearr_47738[(8)] = inst_47663__$1);

return statearr_47738;
})();
if(cljs.core.truth_(inst_47664)){
var statearr_47739_47789 = state_47732__$1;
(statearr_47739_47789[(1)] = (5));

} else {
var statearr_47740_47790 = state_47732__$1;
(statearr_47740_47790[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (15))){
var inst_47705 = (state_47732[(2)]);
var state_47732__$1 = state_47732;
var statearr_47741_47791 = state_47732__$1;
(statearr_47741_47791[(2)] = inst_47705);

(statearr_47741_47791[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (21))){
var inst_47725 = (state_47732[(2)]);
var state_47732__$1 = (function (){var statearr_47742 = state_47732;
(statearr_47742[(9)] = inst_47725);

return statearr_47742;
})();
var statearr_47743_47792 = state_47732__$1;
(statearr_47743_47792[(2)] = null);

(statearr_47743_47792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (13))){
var inst_47687 = (state_47732[(10)]);
var inst_47689 = cljs.core.chunked_seq_QMARK_.call(null,inst_47687);
var state_47732__$1 = state_47732;
if(inst_47689){
var statearr_47744_47793 = state_47732__$1;
(statearr_47744_47793[(1)] = (16));

} else {
var statearr_47745_47794 = state_47732__$1;
(statearr_47745_47794[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (22))){
var inst_47717 = (state_47732[(2)]);
var state_47732__$1 = state_47732;
if(cljs.core.truth_(inst_47717)){
var statearr_47746_47795 = state_47732__$1;
(statearr_47746_47795[(1)] = (23));

} else {
var statearr_47747_47796 = state_47732__$1;
(statearr_47747_47796[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (6))){
var inst_47711 = (state_47732[(7)]);
var inst_47663 = (state_47732[(8)]);
var inst_47713 = (state_47732[(11)]);
var inst_47711__$1 = topic_fn.call(null,inst_47663);
var inst_47712 = cljs.core.deref.call(null,mults);
var inst_47713__$1 = cljs.core.get.call(null,inst_47712,inst_47711__$1);
var state_47732__$1 = (function (){var statearr_47748 = state_47732;
(statearr_47748[(7)] = inst_47711__$1);

(statearr_47748[(11)] = inst_47713__$1);

return statearr_47748;
})();
if(cljs.core.truth_(inst_47713__$1)){
var statearr_47749_47797 = state_47732__$1;
(statearr_47749_47797[(1)] = (19));

} else {
var statearr_47750_47798 = state_47732__$1;
(statearr_47750_47798[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (25))){
var inst_47722 = (state_47732[(2)]);
var state_47732__$1 = state_47732;
var statearr_47751_47799 = state_47732__$1;
(statearr_47751_47799[(2)] = inst_47722);

(statearr_47751_47799[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (17))){
var inst_47687 = (state_47732[(10)]);
var inst_47696 = cljs.core.first.call(null,inst_47687);
var inst_47697 = cljs.core.async.muxch_STAR_.call(null,inst_47696);
var inst_47698 = cljs.core.async.close_BANG_.call(null,inst_47697);
var inst_47699 = cljs.core.next.call(null,inst_47687);
var inst_47673 = inst_47699;
var inst_47674 = null;
var inst_47675 = (0);
var inst_47676 = (0);
var state_47732__$1 = (function (){var statearr_47752 = state_47732;
(statearr_47752[(12)] = inst_47674);

(statearr_47752[(13)] = inst_47676);

(statearr_47752[(14)] = inst_47698);

(statearr_47752[(15)] = inst_47675);

(statearr_47752[(16)] = inst_47673);

return statearr_47752;
})();
var statearr_47753_47800 = state_47732__$1;
(statearr_47753_47800[(2)] = null);

(statearr_47753_47800[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (3))){
var inst_47730 = (state_47732[(2)]);
var state_47732__$1 = state_47732;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47732__$1,inst_47730);
} else {
if((state_val_47733 === (12))){
var inst_47707 = (state_47732[(2)]);
var state_47732__$1 = state_47732;
var statearr_47754_47801 = state_47732__$1;
(statearr_47754_47801[(2)] = inst_47707);

(statearr_47754_47801[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (2))){
var state_47732__$1 = state_47732;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47732__$1,(4),ch);
} else {
if((state_val_47733 === (23))){
var state_47732__$1 = state_47732;
var statearr_47755_47802 = state_47732__$1;
(statearr_47755_47802[(2)] = null);

(statearr_47755_47802[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (19))){
var inst_47663 = (state_47732[(8)]);
var inst_47713 = (state_47732[(11)]);
var inst_47715 = cljs.core.async.muxch_STAR_.call(null,inst_47713);
var state_47732__$1 = state_47732;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47732__$1,(22),inst_47715,inst_47663);
} else {
if((state_val_47733 === (11))){
var inst_47687 = (state_47732[(10)]);
var inst_47673 = (state_47732[(16)]);
var inst_47687__$1 = cljs.core.seq.call(null,inst_47673);
var state_47732__$1 = (function (){var statearr_47756 = state_47732;
(statearr_47756[(10)] = inst_47687__$1);

return statearr_47756;
})();
if(inst_47687__$1){
var statearr_47757_47803 = state_47732__$1;
(statearr_47757_47803[(1)] = (13));

} else {
var statearr_47758_47804 = state_47732__$1;
(statearr_47758_47804[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (9))){
var inst_47709 = (state_47732[(2)]);
var state_47732__$1 = state_47732;
var statearr_47759_47805 = state_47732__$1;
(statearr_47759_47805[(2)] = inst_47709);

(statearr_47759_47805[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (5))){
var inst_47670 = cljs.core.deref.call(null,mults);
var inst_47671 = cljs.core.vals.call(null,inst_47670);
var inst_47672 = cljs.core.seq.call(null,inst_47671);
var inst_47673 = inst_47672;
var inst_47674 = null;
var inst_47675 = (0);
var inst_47676 = (0);
var state_47732__$1 = (function (){var statearr_47760 = state_47732;
(statearr_47760[(12)] = inst_47674);

(statearr_47760[(13)] = inst_47676);

(statearr_47760[(15)] = inst_47675);

(statearr_47760[(16)] = inst_47673);

return statearr_47760;
})();
var statearr_47761_47806 = state_47732__$1;
(statearr_47761_47806[(2)] = null);

(statearr_47761_47806[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (14))){
var state_47732__$1 = state_47732;
var statearr_47765_47807 = state_47732__$1;
(statearr_47765_47807[(2)] = null);

(statearr_47765_47807[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (16))){
var inst_47687 = (state_47732[(10)]);
var inst_47691 = cljs.core.chunk_first.call(null,inst_47687);
var inst_47692 = cljs.core.chunk_rest.call(null,inst_47687);
var inst_47693 = cljs.core.count.call(null,inst_47691);
var inst_47673 = inst_47692;
var inst_47674 = inst_47691;
var inst_47675 = inst_47693;
var inst_47676 = (0);
var state_47732__$1 = (function (){var statearr_47766 = state_47732;
(statearr_47766[(12)] = inst_47674);

(statearr_47766[(13)] = inst_47676);

(statearr_47766[(15)] = inst_47675);

(statearr_47766[(16)] = inst_47673);

return statearr_47766;
})();
var statearr_47767_47808 = state_47732__$1;
(statearr_47767_47808[(2)] = null);

(statearr_47767_47808[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (10))){
var inst_47674 = (state_47732[(12)]);
var inst_47676 = (state_47732[(13)]);
var inst_47675 = (state_47732[(15)]);
var inst_47673 = (state_47732[(16)]);
var inst_47681 = cljs.core._nth.call(null,inst_47674,inst_47676);
var inst_47682 = cljs.core.async.muxch_STAR_.call(null,inst_47681);
var inst_47683 = cljs.core.async.close_BANG_.call(null,inst_47682);
var inst_47684 = (inst_47676 + (1));
var tmp47762 = inst_47674;
var tmp47763 = inst_47675;
var tmp47764 = inst_47673;
var inst_47673__$1 = tmp47764;
var inst_47674__$1 = tmp47762;
var inst_47675__$1 = tmp47763;
var inst_47676__$1 = inst_47684;
var state_47732__$1 = (function (){var statearr_47768 = state_47732;
(statearr_47768[(12)] = inst_47674__$1);

(statearr_47768[(13)] = inst_47676__$1);

(statearr_47768[(15)] = inst_47675__$1);

(statearr_47768[(16)] = inst_47673__$1);

(statearr_47768[(17)] = inst_47683);

return statearr_47768;
})();
var statearr_47769_47809 = state_47732__$1;
(statearr_47769_47809[(2)] = null);

(statearr_47769_47809[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (18))){
var inst_47702 = (state_47732[(2)]);
var state_47732__$1 = state_47732;
var statearr_47770_47810 = state_47732__$1;
(statearr_47770_47810[(2)] = inst_47702);

(statearr_47770_47810[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47733 === (8))){
var inst_47676 = (state_47732[(13)]);
var inst_47675 = (state_47732[(15)]);
var inst_47678 = (inst_47676 < inst_47675);
var inst_47679 = inst_47678;
var state_47732__$1 = state_47732;
if(cljs.core.truth_(inst_47679)){
var statearr_47771_47811 = state_47732__$1;
(statearr_47771_47811[(1)] = (10));

} else {
var statearr_47772_47812 = state_47732__$1;
(statearr_47772_47812[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto___47784,mults,ensure_mult,p))
;
return ((function (switch__45753__auto__,c__45865__auto___47784,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__45754__auto__ = null;
var cljs$core$async$state_machine__45754__auto____0 = (function (){
var statearr_47776 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47776[(0)] = cljs$core$async$state_machine__45754__auto__);

(statearr_47776[(1)] = (1));

return statearr_47776;
});
var cljs$core$async$state_machine__45754__auto____1 = (function (state_47732){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_47732);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e47777){if((e47777 instanceof Object)){
var ex__45757__auto__ = e47777;
var statearr_47778_47813 = state_47732;
(statearr_47778_47813[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47732);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47777;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47814 = state_47732;
state_47732 = G__47814;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$state_machine__45754__auto__ = function(state_47732){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45754__auto____1.call(this,state_47732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45754__auto____0;
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45754__auto____1;
return cljs$core$async$state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto___47784,mults,ensure_mult,p))
})();
var state__45867__auto__ = (function (){var statearr_47779 = f__45866__auto__.call(null);
(statearr_47779[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___47784);

return statearr_47779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto___47784,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args47815 = [];
var len__42519__auto___47818 = arguments.length;
var i__42520__auto___47819 = (0);
while(true){
if((i__42520__auto___47819 < len__42519__auto___47818)){
args47815.push((arguments[i__42520__auto___47819]));

var G__47820 = (i__42520__auto___47819 + (1));
i__42520__auto___47819 = G__47820;
continue;
} else {
}
break;
}

var G__47817 = args47815.length;
switch (G__47817) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args47815.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args47822 = [];
var len__42519__auto___47825 = arguments.length;
var i__42520__auto___47826 = (0);
while(true){
if((i__42520__auto___47826 < len__42519__auto___47825)){
args47822.push((arguments[i__42520__auto___47826]));

var G__47827 = (i__42520__auto___47826 + (1));
i__42520__auto___47826 = G__47827;
continue;
} else {
}
break;
}

var G__47824 = args47822.length;
switch (G__47824) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args47822.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args47829 = [];
var len__42519__auto___47900 = arguments.length;
var i__42520__auto___47901 = (0);
while(true){
if((i__42520__auto___47901 < len__42519__auto___47900)){
args47829.push((arguments[i__42520__auto___47901]));

var G__47902 = (i__42520__auto___47901 + (1));
i__42520__auto___47901 = G__47902;
continue;
} else {
}
break;
}

var G__47831 = args47829.length;
switch (G__47831) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args47829.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__45865__auto___47904 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto___47904,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto___47904,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_47870){
var state_val_47871 = (state_47870[(1)]);
if((state_val_47871 === (7))){
var state_47870__$1 = state_47870;
var statearr_47872_47905 = state_47870__$1;
(statearr_47872_47905[(2)] = null);

(statearr_47872_47905[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47871 === (1))){
var state_47870__$1 = state_47870;
var statearr_47873_47906 = state_47870__$1;
(statearr_47873_47906[(2)] = null);

(statearr_47873_47906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47871 === (4))){
var inst_47834 = (state_47870[(7)]);
var inst_47836 = (inst_47834 < cnt);
var state_47870__$1 = state_47870;
if(cljs.core.truth_(inst_47836)){
var statearr_47874_47907 = state_47870__$1;
(statearr_47874_47907[(1)] = (6));

} else {
var statearr_47875_47908 = state_47870__$1;
(statearr_47875_47908[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47871 === (15))){
var inst_47866 = (state_47870[(2)]);
var state_47870__$1 = state_47870;
var statearr_47876_47909 = state_47870__$1;
(statearr_47876_47909[(2)] = inst_47866);

(statearr_47876_47909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47871 === (13))){
var inst_47859 = cljs.core.async.close_BANG_.call(null,out);
var state_47870__$1 = state_47870;
var statearr_47877_47910 = state_47870__$1;
(statearr_47877_47910[(2)] = inst_47859);

(statearr_47877_47910[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47871 === (6))){
var state_47870__$1 = state_47870;
var statearr_47878_47911 = state_47870__$1;
(statearr_47878_47911[(2)] = null);

(statearr_47878_47911[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47871 === (3))){
var inst_47868 = (state_47870[(2)]);
var state_47870__$1 = state_47870;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47870__$1,inst_47868);
} else {
if((state_val_47871 === (12))){
var inst_47856 = (state_47870[(8)]);
var inst_47856__$1 = (state_47870[(2)]);
var inst_47857 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_47856__$1);
var state_47870__$1 = (function (){var statearr_47879 = state_47870;
(statearr_47879[(8)] = inst_47856__$1);

return statearr_47879;
})();
if(cljs.core.truth_(inst_47857)){
var statearr_47880_47912 = state_47870__$1;
(statearr_47880_47912[(1)] = (13));

} else {
var statearr_47881_47913 = state_47870__$1;
(statearr_47881_47913[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47871 === (2))){
var inst_47833 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_47834 = (0);
var state_47870__$1 = (function (){var statearr_47882 = state_47870;
(statearr_47882[(7)] = inst_47834);

(statearr_47882[(9)] = inst_47833);

return statearr_47882;
})();
var statearr_47883_47914 = state_47870__$1;
(statearr_47883_47914[(2)] = null);

(statearr_47883_47914[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47871 === (11))){
var inst_47834 = (state_47870[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_47870,(10),Object,null,(9));
var inst_47843 = chs__$1.call(null,inst_47834);
var inst_47844 = done.call(null,inst_47834);
var inst_47845 = cljs.core.async.take_BANG_.call(null,inst_47843,inst_47844);
var state_47870__$1 = state_47870;
var statearr_47884_47915 = state_47870__$1;
(statearr_47884_47915[(2)] = inst_47845);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47870__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47871 === (9))){
var inst_47834 = (state_47870[(7)]);
var inst_47847 = (state_47870[(2)]);
var inst_47848 = (inst_47834 + (1));
var inst_47834__$1 = inst_47848;
var state_47870__$1 = (function (){var statearr_47885 = state_47870;
(statearr_47885[(7)] = inst_47834__$1);

(statearr_47885[(10)] = inst_47847);

return statearr_47885;
})();
var statearr_47886_47916 = state_47870__$1;
(statearr_47886_47916[(2)] = null);

(statearr_47886_47916[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47871 === (5))){
var inst_47854 = (state_47870[(2)]);
var state_47870__$1 = (function (){var statearr_47887 = state_47870;
(statearr_47887[(11)] = inst_47854);

return statearr_47887;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47870__$1,(12),dchan);
} else {
if((state_val_47871 === (14))){
var inst_47856 = (state_47870[(8)]);
var inst_47861 = cljs.core.apply.call(null,f,inst_47856);
var state_47870__$1 = state_47870;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47870__$1,(16),out,inst_47861);
} else {
if((state_val_47871 === (16))){
var inst_47863 = (state_47870[(2)]);
var state_47870__$1 = (function (){var statearr_47888 = state_47870;
(statearr_47888[(12)] = inst_47863);

return statearr_47888;
})();
var statearr_47889_47917 = state_47870__$1;
(statearr_47889_47917[(2)] = null);

(statearr_47889_47917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47871 === (10))){
var inst_47838 = (state_47870[(2)]);
var inst_47839 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_47870__$1 = (function (){var statearr_47890 = state_47870;
(statearr_47890[(13)] = inst_47838);

return statearr_47890;
})();
var statearr_47891_47918 = state_47870__$1;
(statearr_47891_47918[(2)] = inst_47839);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47870__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47871 === (8))){
var inst_47852 = (state_47870[(2)]);
var state_47870__$1 = state_47870;
var statearr_47892_47919 = state_47870__$1;
(statearr_47892_47919[(2)] = inst_47852);

(statearr_47892_47919[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto___47904,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__45753__auto__,c__45865__auto___47904,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__45754__auto__ = null;
var cljs$core$async$state_machine__45754__auto____0 = (function (){
var statearr_47896 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47896[(0)] = cljs$core$async$state_machine__45754__auto__);

(statearr_47896[(1)] = (1));

return statearr_47896;
});
var cljs$core$async$state_machine__45754__auto____1 = (function (state_47870){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_47870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e47897){if((e47897 instanceof Object)){
var ex__45757__auto__ = e47897;
var statearr_47898_47920 = state_47870;
(statearr_47898_47920[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47870);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47897;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47921 = state_47870;
state_47870 = G__47921;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$state_machine__45754__auto__ = function(state_47870){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45754__auto____1.call(this,state_47870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45754__auto____0;
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45754__auto____1;
return cljs$core$async$state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto___47904,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__45867__auto__ = (function (){var statearr_47899 = f__45866__auto__.call(null);
(statearr_47899[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___47904);

return statearr_47899;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto___47904,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args47923 = [];
var len__42519__auto___47981 = arguments.length;
var i__42520__auto___47982 = (0);
while(true){
if((i__42520__auto___47982 < len__42519__auto___47981)){
args47923.push((arguments[i__42520__auto___47982]));

var G__47983 = (i__42520__auto___47982 + (1));
i__42520__auto___47982 = G__47983;
continue;
} else {
}
break;
}

var G__47925 = args47923.length;
switch (G__47925) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args47923.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__45865__auto___47985 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto___47985,out){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto___47985,out){
return (function (state_47957){
var state_val_47958 = (state_47957[(1)]);
if((state_val_47958 === (7))){
var inst_47937 = (state_47957[(7)]);
var inst_47936 = (state_47957[(8)]);
var inst_47936__$1 = (state_47957[(2)]);
var inst_47937__$1 = cljs.core.nth.call(null,inst_47936__$1,(0),null);
var inst_47938 = cljs.core.nth.call(null,inst_47936__$1,(1),null);
var inst_47939 = (inst_47937__$1 == null);
var state_47957__$1 = (function (){var statearr_47959 = state_47957;
(statearr_47959[(7)] = inst_47937__$1);

(statearr_47959[(8)] = inst_47936__$1);

(statearr_47959[(9)] = inst_47938);

return statearr_47959;
})();
if(cljs.core.truth_(inst_47939)){
var statearr_47960_47986 = state_47957__$1;
(statearr_47960_47986[(1)] = (8));

} else {
var statearr_47961_47987 = state_47957__$1;
(statearr_47961_47987[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47958 === (1))){
var inst_47926 = cljs.core.vec.call(null,chs);
var inst_47927 = inst_47926;
var state_47957__$1 = (function (){var statearr_47962 = state_47957;
(statearr_47962[(10)] = inst_47927);

return statearr_47962;
})();
var statearr_47963_47988 = state_47957__$1;
(statearr_47963_47988[(2)] = null);

(statearr_47963_47988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47958 === (4))){
var inst_47927 = (state_47957[(10)]);
var state_47957__$1 = state_47957;
return cljs.core.async.ioc_alts_BANG_.call(null,state_47957__$1,(7),inst_47927);
} else {
if((state_val_47958 === (6))){
var inst_47953 = (state_47957[(2)]);
var state_47957__$1 = state_47957;
var statearr_47964_47989 = state_47957__$1;
(statearr_47964_47989[(2)] = inst_47953);

(statearr_47964_47989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47958 === (3))){
var inst_47955 = (state_47957[(2)]);
var state_47957__$1 = state_47957;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47957__$1,inst_47955);
} else {
if((state_val_47958 === (2))){
var inst_47927 = (state_47957[(10)]);
var inst_47929 = cljs.core.count.call(null,inst_47927);
var inst_47930 = (inst_47929 > (0));
var state_47957__$1 = state_47957;
if(cljs.core.truth_(inst_47930)){
var statearr_47966_47990 = state_47957__$1;
(statearr_47966_47990[(1)] = (4));

} else {
var statearr_47967_47991 = state_47957__$1;
(statearr_47967_47991[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47958 === (11))){
var inst_47927 = (state_47957[(10)]);
var inst_47946 = (state_47957[(2)]);
var tmp47965 = inst_47927;
var inst_47927__$1 = tmp47965;
var state_47957__$1 = (function (){var statearr_47968 = state_47957;
(statearr_47968[(11)] = inst_47946);

(statearr_47968[(10)] = inst_47927__$1);

return statearr_47968;
})();
var statearr_47969_47992 = state_47957__$1;
(statearr_47969_47992[(2)] = null);

(statearr_47969_47992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47958 === (9))){
var inst_47937 = (state_47957[(7)]);
var state_47957__$1 = state_47957;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47957__$1,(11),out,inst_47937);
} else {
if((state_val_47958 === (5))){
var inst_47951 = cljs.core.async.close_BANG_.call(null,out);
var state_47957__$1 = state_47957;
var statearr_47970_47993 = state_47957__$1;
(statearr_47970_47993[(2)] = inst_47951);

(statearr_47970_47993[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47958 === (10))){
var inst_47949 = (state_47957[(2)]);
var state_47957__$1 = state_47957;
var statearr_47971_47994 = state_47957__$1;
(statearr_47971_47994[(2)] = inst_47949);

(statearr_47971_47994[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47958 === (8))){
var inst_47937 = (state_47957[(7)]);
var inst_47927 = (state_47957[(10)]);
var inst_47936 = (state_47957[(8)]);
var inst_47938 = (state_47957[(9)]);
var inst_47941 = (function (){var cs = inst_47927;
var vec__47932 = inst_47936;
var v = inst_47937;
var c = inst_47938;
return ((function (cs,vec__47932,v,c,inst_47937,inst_47927,inst_47936,inst_47938,state_val_47958,c__45865__auto___47985,out){
return (function (p1__47922_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__47922_SHARP_);
});
;})(cs,vec__47932,v,c,inst_47937,inst_47927,inst_47936,inst_47938,state_val_47958,c__45865__auto___47985,out))
})();
var inst_47942 = cljs.core.filterv.call(null,inst_47941,inst_47927);
var inst_47927__$1 = inst_47942;
var state_47957__$1 = (function (){var statearr_47972 = state_47957;
(statearr_47972[(10)] = inst_47927__$1);

return statearr_47972;
})();
var statearr_47973_47995 = state_47957__$1;
(statearr_47973_47995[(2)] = null);

(statearr_47973_47995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto___47985,out))
;
return ((function (switch__45753__auto__,c__45865__auto___47985,out){
return (function() {
var cljs$core$async$state_machine__45754__auto__ = null;
var cljs$core$async$state_machine__45754__auto____0 = (function (){
var statearr_47977 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47977[(0)] = cljs$core$async$state_machine__45754__auto__);

(statearr_47977[(1)] = (1));

return statearr_47977;
});
var cljs$core$async$state_machine__45754__auto____1 = (function (state_47957){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_47957);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e47978){if((e47978 instanceof Object)){
var ex__45757__auto__ = e47978;
var statearr_47979_47996 = state_47957;
(statearr_47979_47996[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47957);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47978;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47997 = state_47957;
state_47957 = G__47997;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$state_machine__45754__auto__ = function(state_47957){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45754__auto____1.call(this,state_47957);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45754__auto____0;
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45754__auto____1;
return cljs$core$async$state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto___47985,out))
})();
var state__45867__auto__ = (function (){var statearr_47980 = f__45866__auto__.call(null);
(statearr_47980[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___47985);

return statearr_47980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto___47985,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args47998 = [];
var len__42519__auto___48047 = arguments.length;
var i__42520__auto___48048 = (0);
while(true){
if((i__42520__auto___48048 < len__42519__auto___48047)){
args47998.push((arguments[i__42520__auto___48048]));

var G__48049 = (i__42520__auto___48048 + (1));
i__42520__auto___48048 = G__48049;
continue;
} else {
}
break;
}

var G__48000 = args47998.length;
switch (G__48000) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args47998.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__45865__auto___48051 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto___48051,out){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto___48051,out){
return (function (state_48024){
var state_val_48025 = (state_48024[(1)]);
if((state_val_48025 === (7))){
var inst_48006 = (state_48024[(7)]);
var inst_48006__$1 = (state_48024[(2)]);
var inst_48007 = (inst_48006__$1 == null);
var inst_48008 = cljs.core.not.call(null,inst_48007);
var state_48024__$1 = (function (){var statearr_48026 = state_48024;
(statearr_48026[(7)] = inst_48006__$1);

return statearr_48026;
})();
if(inst_48008){
var statearr_48027_48052 = state_48024__$1;
(statearr_48027_48052[(1)] = (8));

} else {
var statearr_48028_48053 = state_48024__$1;
(statearr_48028_48053[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48025 === (1))){
var inst_48001 = (0);
var state_48024__$1 = (function (){var statearr_48029 = state_48024;
(statearr_48029[(8)] = inst_48001);

return statearr_48029;
})();
var statearr_48030_48054 = state_48024__$1;
(statearr_48030_48054[(2)] = null);

(statearr_48030_48054[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48025 === (4))){
var state_48024__$1 = state_48024;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48024__$1,(7),ch);
} else {
if((state_val_48025 === (6))){
var inst_48019 = (state_48024[(2)]);
var state_48024__$1 = state_48024;
var statearr_48031_48055 = state_48024__$1;
(statearr_48031_48055[(2)] = inst_48019);

(statearr_48031_48055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48025 === (3))){
var inst_48021 = (state_48024[(2)]);
var inst_48022 = cljs.core.async.close_BANG_.call(null,out);
var state_48024__$1 = (function (){var statearr_48032 = state_48024;
(statearr_48032[(9)] = inst_48021);

return statearr_48032;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48024__$1,inst_48022);
} else {
if((state_val_48025 === (2))){
var inst_48001 = (state_48024[(8)]);
var inst_48003 = (inst_48001 < n);
var state_48024__$1 = state_48024;
if(cljs.core.truth_(inst_48003)){
var statearr_48033_48056 = state_48024__$1;
(statearr_48033_48056[(1)] = (4));

} else {
var statearr_48034_48057 = state_48024__$1;
(statearr_48034_48057[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48025 === (11))){
var inst_48001 = (state_48024[(8)]);
var inst_48011 = (state_48024[(2)]);
var inst_48012 = (inst_48001 + (1));
var inst_48001__$1 = inst_48012;
var state_48024__$1 = (function (){var statearr_48035 = state_48024;
(statearr_48035[(8)] = inst_48001__$1);

(statearr_48035[(10)] = inst_48011);

return statearr_48035;
})();
var statearr_48036_48058 = state_48024__$1;
(statearr_48036_48058[(2)] = null);

(statearr_48036_48058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48025 === (9))){
var state_48024__$1 = state_48024;
var statearr_48037_48059 = state_48024__$1;
(statearr_48037_48059[(2)] = null);

(statearr_48037_48059[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48025 === (5))){
var state_48024__$1 = state_48024;
var statearr_48038_48060 = state_48024__$1;
(statearr_48038_48060[(2)] = null);

(statearr_48038_48060[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48025 === (10))){
var inst_48016 = (state_48024[(2)]);
var state_48024__$1 = state_48024;
var statearr_48039_48061 = state_48024__$1;
(statearr_48039_48061[(2)] = inst_48016);

(statearr_48039_48061[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48025 === (8))){
var inst_48006 = (state_48024[(7)]);
var state_48024__$1 = state_48024;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48024__$1,(11),out,inst_48006);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto___48051,out))
;
return ((function (switch__45753__auto__,c__45865__auto___48051,out){
return (function() {
var cljs$core$async$state_machine__45754__auto__ = null;
var cljs$core$async$state_machine__45754__auto____0 = (function (){
var statearr_48043 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48043[(0)] = cljs$core$async$state_machine__45754__auto__);

(statearr_48043[(1)] = (1));

return statearr_48043;
});
var cljs$core$async$state_machine__45754__auto____1 = (function (state_48024){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_48024);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e48044){if((e48044 instanceof Object)){
var ex__45757__auto__ = e48044;
var statearr_48045_48062 = state_48024;
(statearr_48045_48062[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48024);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48044;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48063 = state_48024;
state_48024 = G__48063;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$state_machine__45754__auto__ = function(state_48024){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45754__auto____1.call(this,state_48024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45754__auto____0;
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45754__auto____1;
return cljs$core$async$state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto___48051,out))
})();
var state__45867__auto__ = (function (){var statearr_48046 = f__45866__auto__.call(null);
(statearr_48046[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___48051);

return statearr_48046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto___48051,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async48071 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48071 = (function (map_LT_,f,ch,meta48072){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta48072 = meta48072;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48071.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48073,meta48072__$1){
var self__ = this;
var _48073__$1 = this;
return (new cljs.core.async.t_cljs$core$async48071(self__.map_LT_,self__.f,self__.ch,meta48072__$1));
});

cljs.core.async.t_cljs$core$async48071.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48073){
var self__ = this;
var _48073__$1 = this;
return self__.meta48072;
});

cljs.core.async.t_cljs$core$async48071.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async48071.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async48071.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async48071.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async48071.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async48074 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48074 = (function (map_LT_,f,ch,meta48072,_,fn1,meta48075){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta48072 = meta48072;
this._ = _;
this.fn1 = fn1;
this.meta48075 = meta48075;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48074.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_48076,meta48075__$1){
var self__ = this;
var _48076__$1 = this;
return (new cljs.core.async.t_cljs$core$async48074(self__.map_LT_,self__.f,self__.ch,self__.meta48072,self__._,self__.fn1,meta48075__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async48074.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_48076){
var self__ = this;
var _48076__$1 = this;
return self__.meta48075;
});})(___$1))
;

cljs.core.async.t_cljs$core$async48074.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async48074.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async48074.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async48074.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__48064_SHARP_){
return f1.call(null,(((p1__48064_SHARP_ == null))?null:self__.f.call(null,p1__48064_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async48074.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48072","meta48072",1805660798,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async48071","cljs.core.async/t_cljs$core$async48071",1837005134,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta48075","meta48075",1029864480,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async48074.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48074.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48074";

cljs.core.async.t_cljs$core$async48074.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__42050__auto__,writer__42051__auto__,opt__42052__auto__){
return cljs.core._write.call(null,writer__42051__auto__,"cljs.core.async/t_cljs$core$async48074");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async48074 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48074(map_LT___$1,f__$1,ch__$1,meta48072__$1,___$2,fn1__$1,meta48075){
return (new cljs.core.async.t_cljs$core$async48074(map_LT___$1,f__$1,ch__$1,meta48072__$1,___$2,fn1__$1,meta48075));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async48074(self__.map_LT_,self__.f,self__.ch,self__.meta48072,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__41432__auto__ = ret;
if(cljs.core.truth_(and__41432__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__41432__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async48071.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async48071.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async48071.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48072","meta48072",1805660798,null)], null);
});

cljs.core.async.t_cljs$core$async48071.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48071.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48071";

cljs.core.async.t_cljs$core$async48071.cljs$lang$ctorPrWriter = (function (this__42050__auto__,writer__42051__auto__,opt__42052__auto__){
return cljs.core._write.call(null,writer__42051__auto__,"cljs.core.async/t_cljs$core$async48071");
});

cljs.core.async.__GT_t_cljs$core$async48071 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48071(map_LT___$1,f__$1,ch__$1,meta48072){
return (new cljs.core.async.t_cljs$core$async48071(map_LT___$1,f__$1,ch__$1,meta48072));
});

}

return (new cljs.core.async.t_cljs$core$async48071(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async48080 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48080 = (function (map_GT_,f,ch,meta48081){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta48081 = meta48081;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48080.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48082,meta48081__$1){
var self__ = this;
var _48082__$1 = this;
return (new cljs.core.async.t_cljs$core$async48080(self__.map_GT_,self__.f,self__.ch,meta48081__$1));
});

cljs.core.async.t_cljs$core$async48080.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48082){
var self__ = this;
var _48082__$1 = this;
return self__.meta48081;
});

cljs.core.async.t_cljs$core$async48080.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async48080.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async48080.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async48080.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async48080.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async48080.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async48080.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48081","meta48081",-720706160,null)], null);
});

cljs.core.async.t_cljs$core$async48080.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48080.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48080";

cljs.core.async.t_cljs$core$async48080.cljs$lang$ctorPrWriter = (function (this__42050__auto__,writer__42051__auto__,opt__42052__auto__){
return cljs.core._write.call(null,writer__42051__auto__,"cljs.core.async/t_cljs$core$async48080");
});

cljs.core.async.__GT_t_cljs$core$async48080 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async48080(map_GT___$1,f__$1,ch__$1,meta48081){
return (new cljs.core.async.t_cljs$core$async48080(map_GT___$1,f__$1,ch__$1,meta48081));
});

}

return (new cljs.core.async.t_cljs$core$async48080(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async48086 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48086 = (function (filter_GT_,p,ch,meta48087){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta48087 = meta48087;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48086.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48088,meta48087__$1){
var self__ = this;
var _48088__$1 = this;
return (new cljs.core.async.t_cljs$core$async48086(self__.filter_GT_,self__.p,self__.ch,meta48087__$1));
});

cljs.core.async.t_cljs$core$async48086.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48088){
var self__ = this;
var _48088__$1 = this;
return self__.meta48087;
});

cljs.core.async.t_cljs$core$async48086.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async48086.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async48086.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async48086.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async48086.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async48086.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async48086.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async48086.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48087","meta48087",494888497,null)], null);
});

cljs.core.async.t_cljs$core$async48086.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48086.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48086";

cljs.core.async.t_cljs$core$async48086.cljs$lang$ctorPrWriter = (function (this__42050__auto__,writer__42051__auto__,opt__42052__auto__){
return cljs.core._write.call(null,writer__42051__auto__,"cljs.core.async/t_cljs$core$async48086");
});

cljs.core.async.__GT_t_cljs$core$async48086 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async48086(filter_GT___$1,p__$1,ch__$1,meta48087){
return (new cljs.core.async.t_cljs$core$async48086(filter_GT___$1,p__$1,ch__$1,meta48087));
});

}

return (new cljs.core.async.t_cljs$core$async48086(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args48089 = [];
var len__42519__auto___48133 = arguments.length;
var i__42520__auto___48134 = (0);
while(true){
if((i__42520__auto___48134 < len__42519__auto___48133)){
args48089.push((arguments[i__42520__auto___48134]));

var G__48135 = (i__42520__auto___48134 + (1));
i__42520__auto___48134 = G__48135;
continue;
} else {
}
break;
}

var G__48091 = args48089.length;
switch (G__48091) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48089.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__45865__auto___48137 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto___48137,out){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto___48137,out){
return (function (state_48112){
var state_val_48113 = (state_48112[(1)]);
if((state_val_48113 === (7))){
var inst_48108 = (state_48112[(2)]);
var state_48112__$1 = state_48112;
var statearr_48114_48138 = state_48112__$1;
(statearr_48114_48138[(2)] = inst_48108);

(statearr_48114_48138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48113 === (1))){
var state_48112__$1 = state_48112;
var statearr_48115_48139 = state_48112__$1;
(statearr_48115_48139[(2)] = null);

(statearr_48115_48139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48113 === (4))){
var inst_48094 = (state_48112[(7)]);
var inst_48094__$1 = (state_48112[(2)]);
var inst_48095 = (inst_48094__$1 == null);
var state_48112__$1 = (function (){var statearr_48116 = state_48112;
(statearr_48116[(7)] = inst_48094__$1);

return statearr_48116;
})();
if(cljs.core.truth_(inst_48095)){
var statearr_48117_48140 = state_48112__$1;
(statearr_48117_48140[(1)] = (5));

} else {
var statearr_48118_48141 = state_48112__$1;
(statearr_48118_48141[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48113 === (6))){
var inst_48094 = (state_48112[(7)]);
var inst_48099 = p.call(null,inst_48094);
var state_48112__$1 = state_48112;
if(cljs.core.truth_(inst_48099)){
var statearr_48119_48142 = state_48112__$1;
(statearr_48119_48142[(1)] = (8));

} else {
var statearr_48120_48143 = state_48112__$1;
(statearr_48120_48143[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48113 === (3))){
var inst_48110 = (state_48112[(2)]);
var state_48112__$1 = state_48112;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48112__$1,inst_48110);
} else {
if((state_val_48113 === (2))){
var state_48112__$1 = state_48112;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48112__$1,(4),ch);
} else {
if((state_val_48113 === (11))){
var inst_48102 = (state_48112[(2)]);
var state_48112__$1 = state_48112;
var statearr_48121_48144 = state_48112__$1;
(statearr_48121_48144[(2)] = inst_48102);

(statearr_48121_48144[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48113 === (9))){
var state_48112__$1 = state_48112;
var statearr_48122_48145 = state_48112__$1;
(statearr_48122_48145[(2)] = null);

(statearr_48122_48145[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48113 === (5))){
var inst_48097 = cljs.core.async.close_BANG_.call(null,out);
var state_48112__$1 = state_48112;
var statearr_48123_48146 = state_48112__$1;
(statearr_48123_48146[(2)] = inst_48097);

(statearr_48123_48146[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48113 === (10))){
var inst_48105 = (state_48112[(2)]);
var state_48112__$1 = (function (){var statearr_48124 = state_48112;
(statearr_48124[(8)] = inst_48105);

return statearr_48124;
})();
var statearr_48125_48147 = state_48112__$1;
(statearr_48125_48147[(2)] = null);

(statearr_48125_48147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48113 === (8))){
var inst_48094 = (state_48112[(7)]);
var state_48112__$1 = state_48112;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48112__$1,(11),out,inst_48094);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto___48137,out))
;
return ((function (switch__45753__auto__,c__45865__auto___48137,out){
return (function() {
var cljs$core$async$state_machine__45754__auto__ = null;
var cljs$core$async$state_machine__45754__auto____0 = (function (){
var statearr_48129 = [null,null,null,null,null,null,null,null,null];
(statearr_48129[(0)] = cljs$core$async$state_machine__45754__auto__);

(statearr_48129[(1)] = (1));

return statearr_48129;
});
var cljs$core$async$state_machine__45754__auto____1 = (function (state_48112){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_48112);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e48130){if((e48130 instanceof Object)){
var ex__45757__auto__ = e48130;
var statearr_48131_48148 = state_48112;
(statearr_48131_48148[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48112);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48130;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48149 = state_48112;
state_48112 = G__48149;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$state_machine__45754__auto__ = function(state_48112){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45754__auto____1.call(this,state_48112);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45754__auto____0;
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45754__auto____1;
return cljs$core$async$state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto___48137,out))
})();
var state__45867__auto__ = (function (){var statearr_48132 = f__45866__auto__.call(null);
(statearr_48132[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___48137);

return statearr_48132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto___48137,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args48150 = [];
var len__42519__auto___48153 = arguments.length;
var i__42520__auto___48154 = (0);
while(true){
if((i__42520__auto___48154 < len__42519__auto___48153)){
args48150.push((arguments[i__42520__auto___48154]));

var G__48155 = (i__42520__auto___48154 + (1));
i__42520__auto___48154 = G__48155;
continue;
} else {
}
break;
}

var G__48152 = args48150.length;
switch (G__48152) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48150.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__45865__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto__){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto__){
return (function (state_48322){
var state_val_48323 = (state_48322[(1)]);
if((state_val_48323 === (7))){
var inst_48318 = (state_48322[(2)]);
var state_48322__$1 = state_48322;
var statearr_48324_48365 = state_48322__$1;
(statearr_48324_48365[(2)] = inst_48318);

(statearr_48324_48365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (20))){
var inst_48288 = (state_48322[(7)]);
var inst_48299 = (state_48322[(2)]);
var inst_48300 = cljs.core.next.call(null,inst_48288);
var inst_48274 = inst_48300;
var inst_48275 = null;
var inst_48276 = (0);
var inst_48277 = (0);
var state_48322__$1 = (function (){var statearr_48325 = state_48322;
(statearr_48325[(8)] = inst_48275);

(statearr_48325[(9)] = inst_48274);

(statearr_48325[(10)] = inst_48277);

(statearr_48325[(11)] = inst_48276);

(statearr_48325[(12)] = inst_48299);

return statearr_48325;
})();
var statearr_48326_48366 = state_48322__$1;
(statearr_48326_48366[(2)] = null);

(statearr_48326_48366[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (1))){
var state_48322__$1 = state_48322;
var statearr_48327_48367 = state_48322__$1;
(statearr_48327_48367[(2)] = null);

(statearr_48327_48367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (4))){
var inst_48263 = (state_48322[(13)]);
var inst_48263__$1 = (state_48322[(2)]);
var inst_48264 = (inst_48263__$1 == null);
var state_48322__$1 = (function (){var statearr_48328 = state_48322;
(statearr_48328[(13)] = inst_48263__$1);

return statearr_48328;
})();
if(cljs.core.truth_(inst_48264)){
var statearr_48329_48368 = state_48322__$1;
(statearr_48329_48368[(1)] = (5));

} else {
var statearr_48330_48369 = state_48322__$1;
(statearr_48330_48369[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (15))){
var state_48322__$1 = state_48322;
var statearr_48334_48370 = state_48322__$1;
(statearr_48334_48370[(2)] = null);

(statearr_48334_48370[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (21))){
var state_48322__$1 = state_48322;
var statearr_48335_48371 = state_48322__$1;
(statearr_48335_48371[(2)] = null);

(statearr_48335_48371[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (13))){
var inst_48275 = (state_48322[(8)]);
var inst_48274 = (state_48322[(9)]);
var inst_48277 = (state_48322[(10)]);
var inst_48276 = (state_48322[(11)]);
var inst_48284 = (state_48322[(2)]);
var inst_48285 = (inst_48277 + (1));
var tmp48331 = inst_48275;
var tmp48332 = inst_48274;
var tmp48333 = inst_48276;
var inst_48274__$1 = tmp48332;
var inst_48275__$1 = tmp48331;
var inst_48276__$1 = tmp48333;
var inst_48277__$1 = inst_48285;
var state_48322__$1 = (function (){var statearr_48336 = state_48322;
(statearr_48336[(8)] = inst_48275__$1);

(statearr_48336[(9)] = inst_48274__$1);

(statearr_48336[(14)] = inst_48284);

(statearr_48336[(10)] = inst_48277__$1);

(statearr_48336[(11)] = inst_48276__$1);

return statearr_48336;
})();
var statearr_48337_48372 = state_48322__$1;
(statearr_48337_48372[(2)] = null);

(statearr_48337_48372[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (22))){
var state_48322__$1 = state_48322;
var statearr_48338_48373 = state_48322__$1;
(statearr_48338_48373[(2)] = null);

(statearr_48338_48373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (6))){
var inst_48263 = (state_48322[(13)]);
var inst_48272 = f.call(null,inst_48263);
var inst_48273 = cljs.core.seq.call(null,inst_48272);
var inst_48274 = inst_48273;
var inst_48275 = null;
var inst_48276 = (0);
var inst_48277 = (0);
var state_48322__$1 = (function (){var statearr_48339 = state_48322;
(statearr_48339[(8)] = inst_48275);

(statearr_48339[(9)] = inst_48274);

(statearr_48339[(10)] = inst_48277);

(statearr_48339[(11)] = inst_48276);

return statearr_48339;
})();
var statearr_48340_48374 = state_48322__$1;
(statearr_48340_48374[(2)] = null);

(statearr_48340_48374[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (17))){
var inst_48288 = (state_48322[(7)]);
var inst_48292 = cljs.core.chunk_first.call(null,inst_48288);
var inst_48293 = cljs.core.chunk_rest.call(null,inst_48288);
var inst_48294 = cljs.core.count.call(null,inst_48292);
var inst_48274 = inst_48293;
var inst_48275 = inst_48292;
var inst_48276 = inst_48294;
var inst_48277 = (0);
var state_48322__$1 = (function (){var statearr_48341 = state_48322;
(statearr_48341[(8)] = inst_48275);

(statearr_48341[(9)] = inst_48274);

(statearr_48341[(10)] = inst_48277);

(statearr_48341[(11)] = inst_48276);

return statearr_48341;
})();
var statearr_48342_48375 = state_48322__$1;
(statearr_48342_48375[(2)] = null);

(statearr_48342_48375[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (3))){
var inst_48320 = (state_48322[(2)]);
var state_48322__$1 = state_48322;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48322__$1,inst_48320);
} else {
if((state_val_48323 === (12))){
var inst_48308 = (state_48322[(2)]);
var state_48322__$1 = state_48322;
var statearr_48343_48376 = state_48322__$1;
(statearr_48343_48376[(2)] = inst_48308);

(statearr_48343_48376[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (2))){
var state_48322__$1 = state_48322;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48322__$1,(4),in$);
} else {
if((state_val_48323 === (23))){
var inst_48316 = (state_48322[(2)]);
var state_48322__$1 = state_48322;
var statearr_48344_48377 = state_48322__$1;
(statearr_48344_48377[(2)] = inst_48316);

(statearr_48344_48377[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (19))){
var inst_48303 = (state_48322[(2)]);
var state_48322__$1 = state_48322;
var statearr_48345_48378 = state_48322__$1;
(statearr_48345_48378[(2)] = inst_48303);

(statearr_48345_48378[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (11))){
var inst_48274 = (state_48322[(9)]);
var inst_48288 = (state_48322[(7)]);
var inst_48288__$1 = cljs.core.seq.call(null,inst_48274);
var state_48322__$1 = (function (){var statearr_48346 = state_48322;
(statearr_48346[(7)] = inst_48288__$1);

return statearr_48346;
})();
if(inst_48288__$1){
var statearr_48347_48379 = state_48322__$1;
(statearr_48347_48379[(1)] = (14));

} else {
var statearr_48348_48380 = state_48322__$1;
(statearr_48348_48380[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (9))){
var inst_48310 = (state_48322[(2)]);
var inst_48311 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_48322__$1 = (function (){var statearr_48349 = state_48322;
(statearr_48349[(15)] = inst_48310);

return statearr_48349;
})();
if(cljs.core.truth_(inst_48311)){
var statearr_48350_48381 = state_48322__$1;
(statearr_48350_48381[(1)] = (21));

} else {
var statearr_48351_48382 = state_48322__$1;
(statearr_48351_48382[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (5))){
var inst_48266 = cljs.core.async.close_BANG_.call(null,out);
var state_48322__$1 = state_48322;
var statearr_48352_48383 = state_48322__$1;
(statearr_48352_48383[(2)] = inst_48266);

(statearr_48352_48383[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (14))){
var inst_48288 = (state_48322[(7)]);
var inst_48290 = cljs.core.chunked_seq_QMARK_.call(null,inst_48288);
var state_48322__$1 = state_48322;
if(inst_48290){
var statearr_48353_48384 = state_48322__$1;
(statearr_48353_48384[(1)] = (17));

} else {
var statearr_48354_48385 = state_48322__$1;
(statearr_48354_48385[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (16))){
var inst_48306 = (state_48322[(2)]);
var state_48322__$1 = state_48322;
var statearr_48355_48386 = state_48322__$1;
(statearr_48355_48386[(2)] = inst_48306);

(statearr_48355_48386[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48323 === (10))){
var inst_48275 = (state_48322[(8)]);
var inst_48277 = (state_48322[(10)]);
var inst_48282 = cljs.core._nth.call(null,inst_48275,inst_48277);
var state_48322__$1 = state_48322;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48322__$1,(13),out,inst_48282);
} else {
if((state_val_48323 === (18))){
var inst_48288 = (state_48322[(7)]);
var inst_48297 = cljs.core.first.call(null,inst_48288);
var state_48322__$1 = state_48322;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48322__$1,(20),out,inst_48297);
} else {
if((state_val_48323 === (8))){
var inst_48277 = (state_48322[(10)]);
var inst_48276 = (state_48322[(11)]);
var inst_48279 = (inst_48277 < inst_48276);
var inst_48280 = inst_48279;
var state_48322__$1 = state_48322;
if(cljs.core.truth_(inst_48280)){
var statearr_48356_48387 = state_48322__$1;
(statearr_48356_48387[(1)] = (10));

} else {
var statearr_48357_48388 = state_48322__$1;
(statearr_48357_48388[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto__))
;
return ((function (switch__45753__auto__,c__45865__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__45754__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__45754__auto____0 = (function (){
var statearr_48361 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48361[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__45754__auto__);

(statearr_48361[(1)] = (1));

return statearr_48361;
});
var cljs$core$async$mapcat_STAR__$_state_machine__45754__auto____1 = (function (state_48322){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_48322);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e48362){if((e48362 instanceof Object)){
var ex__45757__auto__ = e48362;
var statearr_48363_48389 = state_48322;
(statearr_48363_48389[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48322);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48362;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48390 = state_48322;
state_48322 = G__48390;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__45754__auto__ = function(state_48322){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__45754__auto____1.call(this,state_48322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__45754__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__45754__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto__))
})();
var state__45867__auto__ = (function (){var statearr_48364 = f__45866__auto__.call(null);
(statearr_48364[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto__);

return statearr_48364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto__))
);

return c__45865__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args48391 = [];
var len__42519__auto___48394 = arguments.length;
var i__42520__auto___48395 = (0);
while(true){
if((i__42520__auto___48395 < len__42519__auto___48394)){
args48391.push((arguments[i__42520__auto___48395]));

var G__48396 = (i__42520__auto___48395 + (1));
i__42520__auto___48395 = G__48396;
continue;
} else {
}
break;
}

var G__48393 = args48391.length;
switch (G__48393) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48391.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args48398 = [];
var len__42519__auto___48401 = arguments.length;
var i__42520__auto___48402 = (0);
while(true){
if((i__42520__auto___48402 < len__42519__auto___48401)){
args48398.push((arguments[i__42520__auto___48402]));

var G__48403 = (i__42520__auto___48402 + (1));
i__42520__auto___48402 = G__48403;
continue;
} else {
}
break;
}

var G__48400 = args48398.length;
switch (G__48400) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48398.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args48405 = [];
var len__42519__auto___48456 = arguments.length;
var i__42520__auto___48457 = (0);
while(true){
if((i__42520__auto___48457 < len__42519__auto___48456)){
args48405.push((arguments[i__42520__auto___48457]));

var G__48458 = (i__42520__auto___48457 + (1));
i__42520__auto___48457 = G__48458;
continue;
} else {
}
break;
}

var G__48407 = args48405.length;
switch (G__48407) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48405.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__45865__auto___48460 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto___48460,out){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto___48460,out){
return (function (state_48431){
var state_val_48432 = (state_48431[(1)]);
if((state_val_48432 === (7))){
var inst_48426 = (state_48431[(2)]);
var state_48431__$1 = state_48431;
var statearr_48433_48461 = state_48431__$1;
(statearr_48433_48461[(2)] = inst_48426);

(statearr_48433_48461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48432 === (1))){
var inst_48408 = null;
var state_48431__$1 = (function (){var statearr_48434 = state_48431;
(statearr_48434[(7)] = inst_48408);

return statearr_48434;
})();
var statearr_48435_48462 = state_48431__$1;
(statearr_48435_48462[(2)] = null);

(statearr_48435_48462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48432 === (4))){
var inst_48411 = (state_48431[(8)]);
var inst_48411__$1 = (state_48431[(2)]);
var inst_48412 = (inst_48411__$1 == null);
var inst_48413 = cljs.core.not.call(null,inst_48412);
var state_48431__$1 = (function (){var statearr_48436 = state_48431;
(statearr_48436[(8)] = inst_48411__$1);

return statearr_48436;
})();
if(inst_48413){
var statearr_48437_48463 = state_48431__$1;
(statearr_48437_48463[(1)] = (5));

} else {
var statearr_48438_48464 = state_48431__$1;
(statearr_48438_48464[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48432 === (6))){
var state_48431__$1 = state_48431;
var statearr_48439_48465 = state_48431__$1;
(statearr_48439_48465[(2)] = null);

(statearr_48439_48465[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48432 === (3))){
var inst_48428 = (state_48431[(2)]);
var inst_48429 = cljs.core.async.close_BANG_.call(null,out);
var state_48431__$1 = (function (){var statearr_48440 = state_48431;
(statearr_48440[(9)] = inst_48428);

return statearr_48440;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48431__$1,inst_48429);
} else {
if((state_val_48432 === (2))){
var state_48431__$1 = state_48431;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48431__$1,(4),ch);
} else {
if((state_val_48432 === (11))){
var inst_48411 = (state_48431[(8)]);
var inst_48420 = (state_48431[(2)]);
var inst_48408 = inst_48411;
var state_48431__$1 = (function (){var statearr_48441 = state_48431;
(statearr_48441[(10)] = inst_48420);

(statearr_48441[(7)] = inst_48408);

return statearr_48441;
})();
var statearr_48442_48466 = state_48431__$1;
(statearr_48442_48466[(2)] = null);

(statearr_48442_48466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48432 === (9))){
var inst_48411 = (state_48431[(8)]);
var state_48431__$1 = state_48431;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48431__$1,(11),out,inst_48411);
} else {
if((state_val_48432 === (5))){
var inst_48408 = (state_48431[(7)]);
var inst_48411 = (state_48431[(8)]);
var inst_48415 = cljs.core._EQ_.call(null,inst_48411,inst_48408);
var state_48431__$1 = state_48431;
if(inst_48415){
var statearr_48444_48467 = state_48431__$1;
(statearr_48444_48467[(1)] = (8));

} else {
var statearr_48445_48468 = state_48431__$1;
(statearr_48445_48468[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48432 === (10))){
var inst_48423 = (state_48431[(2)]);
var state_48431__$1 = state_48431;
var statearr_48446_48469 = state_48431__$1;
(statearr_48446_48469[(2)] = inst_48423);

(statearr_48446_48469[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48432 === (8))){
var inst_48408 = (state_48431[(7)]);
var tmp48443 = inst_48408;
var inst_48408__$1 = tmp48443;
var state_48431__$1 = (function (){var statearr_48447 = state_48431;
(statearr_48447[(7)] = inst_48408__$1);

return statearr_48447;
})();
var statearr_48448_48470 = state_48431__$1;
(statearr_48448_48470[(2)] = null);

(statearr_48448_48470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto___48460,out))
;
return ((function (switch__45753__auto__,c__45865__auto___48460,out){
return (function() {
var cljs$core$async$state_machine__45754__auto__ = null;
var cljs$core$async$state_machine__45754__auto____0 = (function (){
var statearr_48452 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48452[(0)] = cljs$core$async$state_machine__45754__auto__);

(statearr_48452[(1)] = (1));

return statearr_48452;
});
var cljs$core$async$state_machine__45754__auto____1 = (function (state_48431){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_48431);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e48453){if((e48453 instanceof Object)){
var ex__45757__auto__ = e48453;
var statearr_48454_48471 = state_48431;
(statearr_48454_48471[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48431);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48453;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48472 = state_48431;
state_48431 = G__48472;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$state_machine__45754__auto__ = function(state_48431){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45754__auto____1.call(this,state_48431);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45754__auto____0;
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45754__auto____1;
return cljs$core$async$state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto___48460,out))
})();
var state__45867__auto__ = (function (){var statearr_48455 = f__45866__auto__.call(null);
(statearr_48455[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___48460);

return statearr_48455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto___48460,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args48473 = [];
var len__42519__auto___48543 = arguments.length;
var i__42520__auto___48544 = (0);
while(true){
if((i__42520__auto___48544 < len__42519__auto___48543)){
args48473.push((arguments[i__42520__auto___48544]));

var G__48545 = (i__42520__auto___48544 + (1));
i__42520__auto___48544 = G__48545;
continue;
} else {
}
break;
}

var G__48475 = args48473.length;
switch (G__48475) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48473.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__45865__auto___48547 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto___48547,out){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto___48547,out){
return (function (state_48513){
var state_val_48514 = (state_48513[(1)]);
if((state_val_48514 === (7))){
var inst_48509 = (state_48513[(2)]);
var state_48513__$1 = state_48513;
var statearr_48515_48548 = state_48513__$1;
(statearr_48515_48548[(2)] = inst_48509);

(statearr_48515_48548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48514 === (1))){
var inst_48476 = (new Array(n));
var inst_48477 = inst_48476;
var inst_48478 = (0);
var state_48513__$1 = (function (){var statearr_48516 = state_48513;
(statearr_48516[(7)] = inst_48478);

(statearr_48516[(8)] = inst_48477);

return statearr_48516;
})();
var statearr_48517_48549 = state_48513__$1;
(statearr_48517_48549[(2)] = null);

(statearr_48517_48549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48514 === (4))){
var inst_48481 = (state_48513[(9)]);
var inst_48481__$1 = (state_48513[(2)]);
var inst_48482 = (inst_48481__$1 == null);
var inst_48483 = cljs.core.not.call(null,inst_48482);
var state_48513__$1 = (function (){var statearr_48518 = state_48513;
(statearr_48518[(9)] = inst_48481__$1);

return statearr_48518;
})();
if(inst_48483){
var statearr_48519_48550 = state_48513__$1;
(statearr_48519_48550[(1)] = (5));

} else {
var statearr_48520_48551 = state_48513__$1;
(statearr_48520_48551[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48514 === (15))){
var inst_48503 = (state_48513[(2)]);
var state_48513__$1 = state_48513;
var statearr_48521_48552 = state_48513__$1;
(statearr_48521_48552[(2)] = inst_48503);

(statearr_48521_48552[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48514 === (13))){
var state_48513__$1 = state_48513;
var statearr_48522_48553 = state_48513__$1;
(statearr_48522_48553[(2)] = null);

(statearr_48522_48553[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48514 === (6))){
var inst_48478 = (state_48513[(7)]);
var inst_48499 = (inst_48478 > (0));
var state_48513__$1 = state_48513;
if(cljs.core.truth_(inst_48499)){
var statearr_48523_48554 = state_48513__$1;
(statearr_48523_48554[(1)] = (12));

} else {
var statearr_48524_48555 = state_48513__$1;
(statearr_48524_48555[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48514 === (3))){
var inst_48511 = (state_48513[(2)]);
var state_48513__$1 = state_48513;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48513__$1,inst_48511);
} else {
if((state_val_48514 === (12))){
var inst_48477 = (state_48513[(8)]);
var inst_48501 = cljs.core.vec.call(null,inst_48477);
var state_48513__$1 = state_48513;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48513__$1,(15),out,inst_48501);
} else {
if((state_val_48514 === (2))){
var state_48513__$1 = state_48513;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48513__$1,(4),ch);
} else {
if((state_val_48514 === (11))){
var inst_48493 = (state_48513[(2)]);
var inst_48494 = (new Array(n));
var inst_48477 = inst_48494;
var inst_48478 = (0);
var state_48513__$1 = (function (){var statearr_48525 = state_48513;
(statearr_48525[(7)] = inst_48478);

(statearr_48525[(10)] = inst_48493);

(statearr_48525[(8)] = inst_48477);

return statearr_48525;
})();
var statearr_48526_48556 = state_48513__$1;
(statearr_48526_48556[(2)] = null);

(statearr_48526_48556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48514 === (9))){
var inst_48477 = (state_48513[(8)]);
var inst_48491 = cljs.core.vec.call(null,inst_48477);
var state_48513__$1 = state_48513;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48513__$1,(11),out,inst_48491);
} else {
if((state_val_48514 === (5))){
var inst_48478 = (state_48513[(7)]);
var inst_48486 = (state_48513[(11)]);
var inst_48481 = (state_48513[(9)]);
var inst_48477 = (state_48513[(8)]);
var inst_48485 = (inst_48477[inst_48478] = inst_48481);
var inst_48486__$1 = (inst_48478 + (1));
var inst_48487 = (inst_48486__$1 < n);
var state_48513__$1 = (function (){var statearr_48527 = state_48513;
(statearr_48527[(11)] = inst_48486__$1);

(statearr_48527[(12)] = inst_48485);

return statearr_48527;
})();
if(cljs.core.truth_(inst_48487)){
var statearr_48528_48557 = state_48513__$1;
(statearr_48528_48557[(1)] = (8));

} else {
var statearr_48529_48558 = state_48513__$1;
(statearr_48529_48558[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48514 === (14))){
var inst_48506 = (state_48513[(2)]);
var inst_48507 = cljs.core.async.close_BANG_.call(null,out);
var state_48513__$1 = (function (){var statearr_48531 = state_48513;
(statearr_48531[(13)] = inst_48506);

return statearr_48531;
})();
var statearr_48532_48559 = state_48513__$1;
(statearr_48532_48559[(2)] = inst_48507);

(statearr_48532_48559[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48514 === (10))){
var inst_48497 = (state_48513[(2)]);
var state_48513__$1 = state_48513;
var statearr_48533_48560 = state_48513__$1;
(statearr_48533_48560[(2)] = inst_48497);

(statearr_48533_48560[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48514 === (8))){
var inst_48486 = (state_48513[(11)]);
var inst_48477 = (state_48513[(8)]);
var tmp48530 = inst_48477;
var inst_48477__$1 = tmp48530;
var inst_48478 = inst_48486;
var state_48513__$1 = (function (){var statearr_48534 = state_48513;
(statearr_48534[(7)] = inst_48478);

(statearr_48534[(8)] = inst_48477__$1);

return statearr_48534;
})();
var statearr_48535_48561 = state_48513__$1;
(statearr_48535_48561[(2)] = null);

(statearr_48535_48561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto___48547,out))
;
return ((function (switch__45753__auto__,c__45865__auto___48547,out){
return (function() {
var cljs$core$async$state_machine__45754__auto__ = null;
var cljs$core$async$state_machine__45754__auto____0 = (function (){
var statearr_48539 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48539[(0)] = cljs$core$async$state_machine__45754__auto__);

(statearr_48539[(1)] = (1));

return statearr_48539;
});
var cljs$core$async$state_machine__45754__auto____1 = (function (state_48513){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_48513);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e48540){if((e48540 instanceof Object)){
var ex__45757__auto__ = e48540;
var statearr_48541_48562 = state_48513;
(statearr_48541_48562[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48513);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48540;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48563 = state_48513;
state_48513 = G__48563;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$state_machine__45754__auto__ = function(state_48513){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45754__auto____1.call(this,state_48513);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45754__auto____0;
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45754__auto____1;
return cljs$core$async$state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto___48547,out))
})();
var state__45867__auto__ = (function (){var statearr_48542 = f__45866__auto__.call(null);
(statearr_48542[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___48547);

return statearr_48542;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto___48547,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args48564 = [];
var len__42519__auto___48638 = arguments.length;
var i__42520__auto___48639 = (0);
while(true){
if((i__42520__auto___48639 < len__42519__auto___48638)){
args48564.push((arguments[i__42520__auto___48639]));

var G__48640 = (i__42520__auto___48639 + (1));
i__42520__auto___48639 = G__48640;
continue;
} else {
}
break;
}

var G__48566 = args48564.length;
switch (G__48566) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48564.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__45865__auto___48642 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45865__auto___48642,out){
return (function (){
var f__45866__auto__ = (function (){var switch__45753__auto__ = ((function (c__45865__auto___48642,out){
return (function (state_48608){
var state_val_48609 = (state_48608[(1)]);
if((state_val_48609 === (7))){
var inst_48604 = (state_48608[(2)]);
var state_48608__$1 = state_48608;
var statearr_48610_48643 = state_48608__$1;
(statearr_48610_48643[(2)] = inst_48604);

(statearr_48610_48643[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48609 === (1))){
var inst_48567 = [];
var inst_48568 = inst_48567;
var inst_48569 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_48608__$1 = (function (){var statearr_48611 = state_48608;
(statearr_48611[(7)] = inst_48569);

(statearr_48611[(8)] = inst_48568);

return statearr_48611;
})();
var statearr_48612_48644 = state_48608__$1;
(statearr_48612_48644[(2)] = null);

(statearr_48612_48644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48609 === (4))){
var inst_48572 = (state_48608[(9)]);
var inst_48572__$1 = (state_48608[(2)]);
var inst_48573 = (inst_48572__$1 == null);
var inst_48574 = cljs.core.not.call(null,inst_48573);
var state_48608__$1 = (function (){var statearr_48613 = state_48608;
(statearr_48613[(9)] = inst_48572__$1);

return statearr_48613;
})();
if(inst_48574){
var statearr_48614_48645 = state_48608__$1;
(statearr_48614_48645[(1)] = (5));

} else {
var statearr_48615_48646 = state_48608__$1;
(statearr_48615_48646[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48609 === (15))){
var inst_48598 = (state_48608[(2)]);
var state_48608__$1 = state_48608;
var statearr_48616_48647 = state_48608__$1;
(statearr_48616_48647[(2)] = inst_48598);

(statearr_48616_48647[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48609 === (13))){
var state_48608__$1 = state_48608;
var statearr_48617_48648 = state_48608__$1;
(statearr_48617_48648[(2)] = null);

(statearr_48617_48648[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48609 === (6))){
var inst_48568 = (state_48608[(8)]);
var inst_48593 = inst_48568.length;
var inst_48594 = (inst_48593 > (0));
var state_48608__$1 = state_48608;
if(cljs.core.truth_(inst_48594)){
var statearr_48618_48649 = state_48608__$1;
(statearr_48618_48649[(1)] = (12));

} else {
var statearr_48619_48650 = state_48608__$1;
(statearr_48619_48650[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48609 === (3))){
var inst_48606 = (state_48608[(2)]);
var state_48608__$1 = state_48608;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48608__$1,inst_48606);
} else {
if((state_val_48609 === (12))){
var inst_48568 = (state_48608[(8)]);
var inst_48596 = cljs.core.vec.call(null,inst_48568);
var state_48608__$1 = state_48608;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48608__$1,(15),out,inst_48596);
} else {
if((state_val_48609 === (2))){
var state_48608__$1 = state_48608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48608__$1,(4),ch);
} else {
if((state_val_48609 === (11))){
var inst_48572 = (state_48608[(9)]);
var inst_48576 = (state_48608[(10)]);
var inst_48586 = (state_48608[(2)]);
var inst_48587 = [];
var inst_48588 = inst_48587.push(inst_48572);
var inst_48568 = inst_48587;
var inst_48569 = inst_48576;
var state_48608__$1 = (function (){var statearr_48620 = state_48608;
(statearr_48620[(7)] = inst_48569);

(statearr_48620[(11)] = inst_48588);

(statearr_48620[(12)] = inst_48586);

(statearr_48620[(8)] = inst_48568);

return statearr_48620;
})();
var statearr_48621_48651 = state_48608__$1;
(statearr_48621_48651[(2)] = null);

(statearr_48621_48651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48609 === (9))){
var inst_48568 = (state_48608[(8)]);
var inst_48584 = cljs.core.vec.call(null,inst_48568);
var state_48608__$1 = state_48608;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48608__$1,(11),out,inst_48584);
} else {
if((state_val_48609 === (5))){
var inst_48569 = (state_48608[(7)]);
var inst_48572 = (state_48608[(9)]);
var inst_48576 = (state_48608[(10)]);
var inst_48576__$1 = f.call(null,inst_48572);
var inst_48577 = cljs.core._EQ_.call(null,inst_48576__$1,inst_48569);
var inst_48578 = cljs.core.keyword_identical_QMARK_.call(null,inst_48569,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_48579 = (inst_48577) || (inst_48578);
var state_48608__$1 = (function (){var statearr_48622 = state_48608;
(statearr_48622[(10)] = inst_48576__$1);

return statearr_48622;
})();
if(cljs.core.truth_(inst_48579)){
var statearr_48623_48652 = state_48608__$1;
(statearr_48623_48652[(1)] = (8));

} else {
var statearr_48624_48653 = state_48608__$1;
(statearr_48624_48653[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48609 === (14))){
var inst_48601 = (state_48608[(2)]);
var inst_48602 = cljs.core.async.close_BANG_.call(null,out);
var state_48608__$1 = (function (){var statearr_48626 = state_48608;
(statearr_48626[(13)] = inst_48601);

return statearr_48626;
})();
var statearr_48627_48654 = state_48608__$1;
(statearr_48627_48654[(2)] = inst_48602);

(statearr_48627_48654[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48609 === (10))){
var inst_48591 = (state_48608[(2)]);
var state_48608__$1 = state_48608;
var statearr_48628_48655 = state_48608__$1;
(statearr_48628_48655[(2)] = inst_48591);

(statearr_48628_48655[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48609 === (8))){
var inst_48572 = (state_48608[(9)]);
var inst_48568 = (state_48608[(8)]);
var inst_48576 = (state_48608[(10)]);
var inst_48581 = inst_48568.push(inst_48572);
var tmp48625 = inst_48568;
var inst_48568__$1 = tmp48625;
var inst_48569 = inst_48576;
var state_48608__$1 = (function (){var statearr_48629 = state_48608;
(statearr_48629[(7)] = inst_48569);

(statearr_48629[(8)] = inst_48568__$1);

(statearr_48629[(14)] = inst_48581);

return statearr_48629;
})();
var statearr_48630_48656 = state_48608__$1;
(statearr_48630_48656[(2)] = null);

(statearr_48630_48656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45865__auto___48642,out))
;
return ((function (switch__45753__auto__,c__45865__auto___48642,out){
return (function() {
var cljs$core$async$state_machine__45754__auto__ = null;
var cljs$core$async$state_machine__45754__auto____0 = (function (){
var statearr_48634 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48634[(0)] = cljs$core$async$state_machine__45754__auto__);

(statearr_48634[(1)] = (1));

return statearr_48634;
});
var cljs$core$async$state_machine__45754__auto____1 = (function (state_48608){
while(true){
var ret_value__45755__auto__ = (function (){try{while(true){
var result__45756__auto__ = switch__45753__auto__.call(null,state_48608);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45756__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45756__auto__;
}
break;
}
}catch (e48635){if((e48635 instanceof Object)){
var ex__45757__auto__ = e48635;
var statearr_48636_48657 = state_48608;
(statearr_48636_48657[(5)] = ex__45757__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48608);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48635;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45755__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48658 = state_48608;
state_48608 = G__48658;
continue;
} else {
return ret_value__45755__auto__;
}
break;
}
});
cljs$core$async$state_machine__45754__auto__ = function(state_48608){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45754__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45754__auto____1.call(this,state_48608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45754__auto____0;
cljs$core$async$state_machine__45754__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45754__auto____1;
return cljs$core$async$state_machine__45754__auto__;
})()
;})(switch__45753__auto__,c__45865__auto___48642,out))
})();
var state__45867__auto__ = (function (){var statearr_48637 = f__45866__auto__.call(null);
(statearr_48637[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__45865__auto___48642);

return statearr_48637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45867__auto__);
});})(c__45865__auto___48642,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1482290837164