// Compiled by ClojureScript 1.9.229 {}
goog.provide('bones.editable.request');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('re_frame.core');
goog.require('bones.editable.protocols');
goog.require('bones.editable.helpers');
goog.require('cljs.spec');
bones.editable.request.debug = (cljs.core.truth_(goog.DEBUG)?re_frame.core.debug:null);
bones.editable.request.client_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
bones.editable.request.client_cofx = (function bones$editable$request$client_cofx(cofx,_){
return cljs.core.assoc.call(null,cofx,new cljs.core.Keyword(null,"client","client",-1323448117),cljs.core.deref.call(null,bones.editable.request.client_atom));
});
/**
 * sets the :client co-effect as a convenience.
 *   the client will have functions called on it from
 *   bones.editable.protocols/Client. alternatively, the :client co-effect can be
 *   registered with:
 *  (reg-cofx :client #(assoc % :client my-client))
 */
bones.editable.request.set_client = (function bones$editable$request$set_client(client){
if(((!((client == null)))?(((false) || (client.bones$editable$protocols$Client$))?true:(((!client.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,bones.editable.protocols.Client,client):false)):cljs.core.native_satisfies_QMARK_.call(null,bones.editable.protocols.Client,client))){
cljs.core.reset_BANG_.call(null,bones.editable.request.client_atom,client);

return re_frame.core.reg_cofx.call(null,new cljs.core.Keyword(null,"client","client",-1323448117),bones.editable.request.client_cofx);
} else {
throw cljs.core.ex_info.call(null,"client does not satisfy bones.editable.protocols/Client",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"client","client",-1323448117),cljs.core.type.call(null,client)], null));
}
});
bones.editable.request.interceptors = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bones.editable.request.debug,re_frame.core.inject_cofx.call(null,new cljs.core.Keyword(null,"client","client",-1323448117))], null);
/**
 * call the client
 */
bones.editable.request.login_effect = (function bones$editable$request$login_effect(p__46849){
var map__46852 = p__46849;
var map__46852__$1 = ((((!((map__46852 == null)))?((((map__46852.cljs$lang$protocol_mask$partition0$ & (64))) || (map__46852.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46852):map__46852);
var client = cljs.core.get.call(null,map__46852__$1,new cljs.core.Keyword(null,"client","client",-1323448117));
var args = cljs.core.get.call(null,map__46852__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var tap = cljs.core.get.call(null,map__46852__$1,new cljs.core.Keyword(null,"tap","tap",-1086702463));
return bones.editable.protocols.login.call(null,client,args,tap);
});
re_frame.core.reg_fx.call(null,new cljs.core.Keyword("request","login","request/login",1176102846),bones.editable.request.login_effect);
/**
 * call the client
 */
bones.editable.request.command_effect = (function bones$editable$request$command_effect(p__46854){
var map__46857 = p__46854;
var map__46857__$1 = ((((!((map__46857 == null)))?((((map__46857.cljs$lang$protocol_mask$partition0$ & (64))) || (map__46857.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46857):map__46857);
var client = cljs.core.get.call(null,map__46857__$1,new cljs.core.Keyword(null,"client","client",-1323448117));
var command = cljs.core.get.call(null,map__46857__$1,new cljs.core.Keyword(null,"command","command",-894540724));
var args = cljs.core.get.call(null,map__46857__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var tap = cljs.core.get.call(null,map__46857__$1,new cljs.core.Keyword(null,"tap","tap",-1086702463));
return bones.editable.protocols.command.call(null,client,command,args,tap);
});
re_frame.core.reg_fx.call(null,new cljs.core.Keyword("request","command","request/command",-1914744355),bones.editable.request.command_effect);
/**
 * call the client
 */
bones.editable.request.query_effect = (function bones$editable$request$query_effect(p__46859){
var map__46862 = p__46859;
var map__46862__$1 = ((((!((map__46862 == null)))?((((map__46862.cljs$lang$protocol_mask$partition0$ & (64))) || (map__46862.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46862):map__46862);
var client = cljs.core.get.call(null,map__46862__$1,new cljs.core.Keyword(null,"client","client",-1323448117));
var args = cljs.core.get.call(null,map__46862__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var tap = cljs.core.get.call(null,map__46862__$1,new cljs.core.Keyword(null,"tap","tap",-1086702463));
return bones.editable.protocols.query.call(null,client,args,tap);
});
re_frame.core.reg_fx.call(null,new cljs.core.Keyword("request","query","request/query",-192804273),bones.editable.request.query_effect);
/**
 * call the client
 */
bones.editable.request.logout_effect = (function bones$editable$request$logout_effect(p__46864){
var map__46867 = p__46864;
var map__46867__$1 = ((((!((map__46867 == null)))?((((map__46867.cljs$lang$protocol_mask$partition0$ & (64))) || (map__46867.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46867):map__46867);
var client = cljs.core.get.call(null,map__46867__$1,new cljs.core.Keyword(null,"client","client",-1323448117));
var tap = cljs.core.get.call(null,map__46867__$1,new cljs.core.Keyword(null,"tap","tap",-1086702463));
return bones.editable.protocols.logout.call(null,client,tap);
});
re_frame.core.reg_fx.call(null,new cljs.core.Keyword("request","logout","request/logout",-1893963392),bones.editable.request.logout_effect);
bones.editable.request.conform_BANG_ = (function bones$editable$request$conform_BANG_(spec,args){
var conformed = cljs.spec.conform.call(null,spec,args);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("cljs.spec","invalid","cljs.spec/invalid",551677537),conformed)){
throw cljs.core.ex_info.call(null,"conform! failed",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"args","args",1315556576),args,new cljs.core.Keyword(null,"explain-data","explain-data",-1124944340),cljs.spec.explain_data.call(null,spec,args)], null));
} else {
return conformed;
}
});
/**
 * merge data from three sources:
 * - data sent in the options of the event
 * - data from the inputs of the thing
 * - data form the defaults of the thing
 *   conditionally, merging can be prevented with the :solo option
 *   In the case below, the resolved args would be only `{:x true}'
 *   (dispatch [X E-TYPE ID {:args {:x true}}])
 *   or
 *   (dispatch [X command args])
 *   In this next case, all data will come from the inputs in the db
 *   (dispatch [X E-TYPE ID])
 */
bones.editable.request.resolve_args = (function bones$editable$request$resolve_args(cofx,event_vec){
var db = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(cofx);
var vec__46873 = event_vec;
var event_name = cljs.core.nth.call(null,vec__46873,(0),null);
var e_type = cljs.core.nth.call(null,vec__46873,(1),null);
var identifier = cljs.core.nth.call(null,vec__46873,(2),null);
var opts = cljs.core.nth.call(null,vec__46873,(3),null);
var _ = (((cljs.core.map_QMARK_.call(null,identifier)) && (cljs.core.map_QMARK_.call(null,opts)))?(function(){throw cljs.core.ex_info.call(null,"identifier and opts can not both be maps",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"identifier","identifier",-805503498),identifier,new cljs.core.Keyword(null,"opts","opts",155075701),opts], null))})():null);
var args = ((cljs.core.map_QMARK_.call(null,identifier))?identifier:new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(opts));
var merge_opt = new cljs.core.Keyword(null,"merge","merge",-1804319409).cljs$core$IFn$_invoke$arity$1(opts);
var merger = ((cljs.core.coll_QMARK_.call(null,merge_opt))?merge_opt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [merge_opt], null));
var spec = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"editable","editable",1930280326),e_type,new cljs.core.Keyword(null,"_meta","_meta",937543236),new cljs.core.Keyword(null,"spec","spec",347520401)], null));
var defaults = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"editable","editable",1930280326),e_type,new cljs.core.Keyword(null,"_meta","_meta",937543236),new cljs.core.Keyword(null,"defaults","defaults",976027214)], null));
var inputs = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"editable","editable",1930280326),e_type,identifier,new cljs.core.Keyword(null,"inputs","inputs",865803858)], null));
var G__46876 = (function (){var or__41455__auto__ = args;
if(cljs.core.truth_(or__41455__auto__)){
return or__41455__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var G__46876__$1 = (cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"inputs","inputs",865803858),null], null), null),merger))?cljs.core.merge.call(null,inputs,G__46876):G__46876);
var G__46876__$2 = ((cljs.core.empty_QMARK_.call(null,args))?cljs.core.merge.call(null,inputs,G__46876__$1):G__46876__$1);
var G__46876__$3 = (cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"defaults","defaults",976027214),null], null), null),merger))?cljs.core.merge.call(null,defaults,G__46876__$2):G__46876__$2);
if(cljs.core.truth_(spec)){
return bones.editable.request.conform_BANG_.call(null,spec,G__46876__$3);
} else {
return G__46876__$3;
}
});
/**
 * dispatch :request/login to call the client
 */
bones.editable.request.login_handler = (function bones$editable$request$login_handler(cofx,event_vec){
var scope = bones.editable.helpers.e_scope.call(null,event_vec);
try{var args = bones.editable.request.resolve_args.call(null,cofx,event_vec);
var tap = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"args","args",1315556576),args,new cljs.core.Keyword(null,"e-scope","e-scope",1550069797),scope], null);
var pending_event_vec = cljs.core.into.call(null,scope,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"pending","pending",-220036727),true], null));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),pending_event_vec,new cljs.core.Keyword("request","login","request/login",1176102846),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"args","args",1315556576),args,new cljs.core.Keyword(null,"tap","tap",-1086702463),tap,new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"client","client",-1323448117).cljs$core$IFn$_invoke$arity$1(cofx)], null)], null);
}catch (e46878){if((e46878 instanceof Error)){
var e = e46878;
var temp__4655__auto__ = new cljs.core.Keyword(null,"explain-data","explain-data",-1124944340).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,e));
if(cljs.core.truth_(temp__4655__auto__)){
var spec_error = temp__4655__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),cljs.core.into.call(null,scope,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"explain-data","explain-data",-1124944340),spec_error], null)], null))], null);
} else {
throw e;
}
} else {
throw e46878;

}
}});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("request","login","request/login",1176102846),bones.editable.request.interceptors,bones.editable.request.login_handler);
/**
 * dispatch :request/command to call the client
 */
bones.editable.request.command_handler = (function bones$editable$request$command_handler(cofx,event_vec){
var vec__46883 = event_vec;
var event_name = cljs.core.nth.call(null,vec__46883,(0),null);
var e_type = cljs.core.nth.call(null,vec__46883,(1),null);
var identifier = cljs.core.nth.call(null,vec__46883,(2),null);
var opts = cljs.core.nth.call(null,vec__46883,(3),null);
var cmd = e_type;
var e_type__$1 = (cljs.core.truth_(cljs.core.namespace.call(null,e_type))?cljs.core.keyword.call(null,cljs.core.namespace.call(null,e_type)):e_type);
var new_event_vec = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_name,e_type__$1,identifier,opts], null);
var scope = bones.editable.helpers.e_scope.call(null,new_event_vec);
try{var args = bones.editable.request.resolve_args.call(null,cofx,new_event_vec);
var tap = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",-894540724),cmd,new cljs.core.Keyword(null,"args","args",1315556576),args,new cljs.core.Keyword(null,"e-scope","e-scope",1550069797),scope], null);
var pending_event_vec = cljs.core.into.call(null,scope,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"pending","pending",-220036727),true], null));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("request","command","request/command",-1914744355),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"command","command",-894540724),cmd,new cljs.core.Keyword(null,"args","args",1315556576),args,new cljs.core.Keyword(null,"tap","tap",-1086702463),tap,new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"client","client",-1323448117).cljs$core$IFn$_invoke$arity$1(cofx)], null)], null);
}catch (e46886){if((e46886 instanceof Error)){
var e = e46886;
var temp__4655__auto__ = new cljs.core.Keyword(null,"explain-data","explain-data",-1124944340).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,e));
if(cljs.core.truth_(temp__4655__auto__)){
var spec_error = temp__4655__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),cljs.core.into.call(null,scope,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"explain-data","explain-data",-1124944340),spec_error], null)], null))], null);
} else {
throw e;
}
} else {
throw e46886;

}
}});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("request","command","request/command",-1914744355),bones.editable.request.interceptors,bones.editable.request.command_handler);
/**
 * simple query using args given in event
 */
bones.editable.request.short_query_handler = (function bones$editable$request$short_query_handler(cofx,event_vec){
var vec__46890 = event_vec;
var event_name = cljs.core.nth.call(null,vec__46890,(0),null);
var args = cljs.core.nth.call(null,vec__46890,(1),null);
var tap = cljs.core.nth.call(null,vec__46890,(2),null);
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("request","query","request/query",-192804273),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"args","args",1315556576),args,new cljs.core.Keyword(null,"tap","tap",-1086702463),tap,new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"client","client",-1323448117).cljs$core$IFn$_invoke$arity$1(cofx)], null)], null);
});
/**
 * builds args from three sources see `resolve-args'
 */
bones.editable.request.long_query_handler = (function bones$editable$request$long_query_handler(cofx,event_vec){
var vec__46896 = event_vec;
var event_name = cljs.core.nth.call(null,vec__46896,(0),null);
var e_type = cljs.core.nth.call(null,vec__46896,(1),null);
var identifier = cljs.core.nth.call(null,vec__46896,(2),null);
var opts = cljs.core.nth.call(null,vec__46896,(3),null);
var query = e_type;
var e_type__$1 = (cljs.core.truth_(cljs.core.namespace.call(null,e_type))?cljs.core.keyword.call(null,cljs.core.namespace.call(null,e_type)):e_type);
var new_event_vec = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_name,e_type__$1,identifier,opts], null);
var args = bones.editable.request.resolve_args.call(null,cofx,new_event_vec);
var scope = bones.editable.helpers.e_scope.call(null,new_event_vec);
var tap = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"args","args",1315556576),args,new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"e-scope","e-scope",1550069797),scope], null);
var pending_event_vec = cljs.core.into.call(null,scope,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"pending","pending",-220036727),true], null));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),pending_event_vec,new cljs.core.Keyword("request","query","request/query",-192804273),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"args","args",1315556576),args,new cljs.core.Keyword(null,"tap","tap",-1086702463),tap,new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"client","client",-1323448117).cljs$core$IFn$_invoke$arity$1(cofx)], null)], null);
});
/**
 *  dispatch :request/query effect to call call
 *   args may be resolved from `resolve-args' or sent as an event arg.
 * a map as event arg will short-circuit some logic for a simpler interface
 */
bones.editable.request.query_handler = (function bones$editable$request$query_handler(cofx,event_vec){
var scope = bones.editable.helpers.e_scope.call(null,event_vec);
try{var vec__46904 = event_vec;
var event_name = cljs.core.nth.call(null,vec__46904,(0),null);
var e_type = cljs.core.nth.call(null,vec__46904,(1),null);
var identifier = cljs.core.nth.call(null,vec__46904,(2),null);
var opts = cljs.core.nth.call(null,vec__46904,(3),null);
if(!(cljs.core.map_QMARK_.call(null,e_type))){
if(cljs.core.map_QMARK_.call(null,identifier)){
throw cljs.core.ex_info.call(null,"non-standard event-vec, we have a problem",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event-vec","event-vec",1454724071),event_vec], null));
} else {
return bones.editable.request.long_query_handler.call(null,cofx,event_vec);
}
} else {
return bones.editable.request.short_query_handler.call(null,cofx,event_vec);
}
}catch (e46903){if((e46903 instanceof Error)){
var e = e46903;
var temp__4655__auto__ = new cljs.core.Keyword(null,"explain-data","explain-data",-1124944340).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,e));
if(cljs.core.truth_(temp__4655__auto__)){
var spec_error = temp__4655__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),cljs.core.into.call(null,scope,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"explain-data","explain-data",-1124944340),spec_error], null)], null))], null);
} else {
throw e;
}
} else {
throw e46903;

}
}});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("request","query","request/query",-192804273),bones.editable.request.interceptors,bones.editable.request.query_handler);
/**
 * dispatch :request/logout effect to call client
 */
bones.editable.request.logout_handler = (function bones$editable$request$logout_handler(cofx,event_vec){
var vec__46910 = event_vec;
var _ = cljs.core.nth.call(null,vec__46910,(0),null);
var tap = cljs.core.nth.call(null,vec__46910,(1),null);
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("request","logout","request/logout",-1893963392),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tap","tap",-1086702463),tap,new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"client","client",-1323448117).cljs$core$IFn$_invoke$arity$1(cofx)], null)], null);
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("request","logout","request/logout",-1893963392),bones.editable.request.interceptors,bones.editable.request.logout_handler);

//# sourceMappingURL=request.js.map?rel=1485399587356