// Compiled by ClojureScript 1.9.229 {}
goog.provide('bones.editable');
goog.require('cljs.core');
goog.require('bones.editable.subs');
goog.require('bones.editable.protocols');
goog.require('bones.editable.response');
goog.require('bones.editable.request');
goog.require('bones.editable.forms');
goog.require('bones.editable.helpers');
goog.require('cljs.reader');
goog.require('re_frame.core');
/**
 * update the editable thing in the db,
 * the attribute is second to last in the event vector,
 * the value is last
 */
bones.editable.editable_update = (function bones$editable$editable_update(db,p__46915){
var vec__46919 = p__46915;
var seq__46920 = cljs.core.seq.call(null,vec__46919);
var first__46921 = cljs.core.first.call(null,seq__46920);
var seq__46920__$1 = cljs.core.next.call(null,seq__46920);
var channel = first__46921;
var first__46921__$1 = cljs.core.first.call(null,seq__46920__$1);
var seq__46920__$2 = cljs.core.next.call(null,seq__46920__$1);
var form_type = first__46921__$1;
var first__46921__$2 = cljs.core.first.call(null,seq__46920__$2);
var seq__46920__$3 = cljs.core.next.call(null,seq__46920__$2);
var id = first__46921__$2;
var args = seq__46920__$3;
return cljs.core.assoc_in.call(null,db,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"editable","editable",1930280326),form_type,id], null),cljs.core.butlast.call(null,args)),cljs.core.last.call(null,args));
});
/**
 * update the db multiple times if a vector of events are given
 */
bones.editable.editable_update_multi = (function bones$editable$editable_update_multi(db,p__46922){
var vec__46926 = p__46922;
var seq__46927 = cljs.core.seq.call(null,vec__46926);
var first__46928 = cljs.core.first.call(null,seq__46927);
var seq__46927__$1 = cljs.core.next.call(null,seq__46927);
var channel = first__46928;
var events = seq__46927__$1;
if(cljs.core.iterable_QMARK_.call(null,cljs.core.first.call(null,events))){
return cljs.core.reduce.call(null,bones.editable.editable_update,db,events);
} else {
return bones.editable.editable_update.call(null,db,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [channel], null),events));
}
});
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword(null,"editable","editable",1930280326),cljs.core.PersistentVector.EMPTY,bones.editable.editable_update_multi);
bones.editable.parse_int = bones.editable.helpers.parse_int;
bones.editable.form = bones.editable.forms.form;
bones.editable.detect_controls = bones.editable.forms.detect_controls;
bones.editable.input = bones.editable.forms.input;
bones.editable.checkbox = bones.editable.forms.checkbox;
bones.editable.Client = bones.editable.protocols.Client;
bones.editable.login = bones.editable.protocols.login;
bones.editable.logout = bones.editable.protocols.logout;
bones.editable.command = bones.editable.protocols.command;
bones.editable.query = bones.editable.protocols.query;
bones.editable.handler = bones.editable.response.handler;

//# sourceMappingURL=editable.js.map?rel=1485399587403