// Compiled by ClojureScript 1.9.229 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('reagent.impl.util');
goog.require('reagent.interop');
goog.require('reagent.ratom');
goog.require('reagent.impl.template');
goog.require('reagent.impl.batching');
goog.require('cljsjs.react.dom');
goog.require('reagent.debug');
if(typeof reagent.dom.imported !== 'undefined'){
} else {
reagent.dom.imported = null;
}
reagent.dom.module = (function reagent$dom$module(){
if(cljs.core.some_QMARK_.call(null,reagent.dom.imported)){
return reagent.dom.imported;
} else {
if(typeof ReactDOM !== 'undefined'){
return reagent.dom.imported = ReactDOM;
} else {
if(typeof require !== 'undefined'){
var or__41444__auto__ = reagent.dom.imported = require("react-dom");
if(cljs.core.truth_(or__41444__auto__)){
return or__41444__auto__;
} else {
throw (new Error("require('react-dom') failed"));
}
} else {
throw (new Error("js/ReactDOM is missing"));

}
}
}
});
if(typeof reagent.dom.roots !== 'undefined'){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return (reagent.dom.module.call(null)["unmountComponentAtNode"])(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR_44557 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = true;

try{return (reagent.dom.module.call(null)["render"])(comp.call(null),container,((function (_STAR_always_update_STAR_44557){
return (function (){
var _STAR_always_update_STAR_44558 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = false;

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp,container], null));

reagent.impl.batching.flush_after_render.call(null);

if(cljs.core.some_QMARK_.call(null,callback)){
return callback.call(null);
} else {
return null;
}
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_44558;
}});})(_STAR_always_update_STAR_44557))
);
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_44557;
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element. The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var args44559 = [];
var len__42519__auto___44562 = arguments.length;
var i__42520__auto___44563 = (0);
while(true){
if((i__42520__auto___44563 < len__42519__auto___44562)){
args44559.push((arguments[i__42520__auto___44563]));

var G__44564 = (i__42520__auto___44563 + (1));
i__42520__auto___44563 = G__44564;
continue;
} else {
}
break;
}

var G__44561 = args44559.length;
switch (G__44561) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args44559.length)].join('')));

}
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,null);
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback){
reagent.ratom.flush_BANG_.call(null);

var f = (function (){
return reagent.impl.template.as_element.call(null,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});
return reagent.dom.render_comp.call(null,f,container,callback);
});

reagent.dom.render.cljs$lang$maxFixedArity = 3;

reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return (reagent.dom.module.call(null)["findDOMNode"])(this$);
});
reagent.impl.template.find_dom_node = reagent.dom.dom_node;
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_.call(null);

var seq__44570_44574 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,reagent.dom.roots)));
var chunk__44571_44575 = null;
var count__44572_44576 = (0);
var i__44573_44577 = (0);
while(true){
if((i__44573_44577 < count__44572_44576)){
var v_44578 = cljs.core._nth.call(null,chunk__44571_44575,i__44573_44577);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_44578);

var G__44579 = seq__44570_44574;
var G__44580 = chunk__44571_44575;
var G__44581 = count__44572_44576;
var G__44582 = (i__44573_44577 + (1));
seq__44570_44574 = G__44579;
chunk__44571_44575 = G__44580;
count__44572_44576 = G__44581;
i__44573_44577 = G__44582;
continue;
} else {
var temp__4657__auto___44583 = cljs.core.seq.call(null,seq__44570_44574);
if(temp__4657__auto___44583){
var seq__44570_44584__$1 = temp__4657__auto___44583;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44570_44584__$1)){
var c__42255__auto___44585 = cljs.core.chunk_first.call(null,seq__44570_44584__$1);
var G__44586 = cljs.core.chunk_rest.call(null,seq__44570_44584__$1);
var G__44587 = c__42255__auto___44585;
var G__44588 = cljs.core.count.call(null,c__42255__auto___44585);
var G__44589 = (0);
seq__44570_44574 = G__44586;
chunk__44571_44575 = G__44587;
count__44572_44576 = G__44588;
i__44573_44577 = G__44589;
continue;
} else {
var v_44590 = cljs.core.first.call(null,seq__44570_44584__$1);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_44590);

var G__44591 = cljs.core.next.call(null,seq__44570_44584__$1);
var G__44592 = null;
var G__44593 = (0);
var G__44594 = (0);
seq__44570_44574 = G__44591;
chunk__44571_44575 = G__44592;
count__44572_44576 = G__44593;
i__44573_44577 = G__44594;
continue;
}
} else {
}
}
break;
}

return "Updated";
});

//# sourceMappingURL=dom.js.map?rel=1482290834169