// Compiled by ClojureScript 1.9.229 {}
goog.provide('day8.re_frame.test');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('cljs.test');
goog.require('re_frame.core');
goog.require('re_frame.registrar');
goog.require('re_frame.db');
/**
 * Dequeue an item from a persistent queue which is stored as the value in
 *   queue-atom. Returns the item, and updates the atom with the new queue
 *   value. If the queue is empty, does not alter it and returns nil.
 */
day8.re_frame.test.dequeue_BANG_ = (function day8$re_frame$test$dequeue_BANG_(queue_atom){
while(true){
var queue = cljs.core.deref.call(null,queue_atom);
if(cljs.core.seq.call(null,queue)){
if(cljs.core.truth_(cljs.core.compare_and_set_BANG_.call(null,queue_atom,queue,cljs.core.pop.call(null,queue)))){
return cljs.core.peek.call(null,queue);
} else {
var G__47061 = queue_atom;
queue_atom = G__47061;
continue;
}
} else {
return null;
}
break;
}
});
day8.re_frame.test._STAR_test_timeout_STAR_ = (5000);
/**
 * `*test-context*` is used to communicate internal details of the test between
 *   `run-test-async*` and `wait-for*`. It is dynamically bound so that it doesn't
 *   need to appear as a lexical argument to a `wait-for` block, since we don't
 *   want it to be visible when you're writing tests.  But care must be taken to
 *   pass it around lexically across callbacks, since ClojureScript doesn't have
 *   `bound-fn`.
 */
day8.re_frame.test._STAR_test_context_STAR_ = null;
day8.re_frame.test.run_test_async_STAR_ = (function day8$re_frame$test$run_test_async_STAR_(f){
var test_context = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"wait-for-depth","wait-for-depth",-1366777331),(0),new cljs.core.Keyword(null,"max-wait-for-depth","max-wait-for-depth",639503457),cljs.core.atom.call(null,(0)),new cljs.core.Keyword(null,"now-waiting-for","now-waiting-for",322402761),cljs.core.atom.call(null,null)], null);
if(typeof day8.re_frame.test.t_day8$re_frame$test47069 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.test.IAsyncTest}
 * @implements {cljs.core.IWithMeta}
*/
day8.re_frame.test.t_day8$re_frame$test47069 = (function (run_test_async_STAR_,f,test_context,meta47070){
this.run_test_async_STAR_ = run_test_async_STAR_;
this.f = f;
this.test_context = test_context;
this.meta47070 = meta47070;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
day8.re_frame.test.t_day8$re_frame$test47069.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (test_context){
return (function (_47071,meta47070__$1){
var self__ = this;
var _47071__$1 = this;
return (new day8.re_frame.test.t_day8$re_frame$test47069(self__.run_test_async_STAR_,self__.f,self__.test_context,meta47070__$1));
});})(test_context))
;

day8.re_frame.test.t_day8$re_frame$test47069.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (test_context){
return (function (_47071){
var self__ = this;
var _47071__$1 = this;
return self__.meta47070;
});})(test_context))
;

day8.re_frame.test.t_day8$re_frame$test47069.prototype.cljs$test$IAsyncTest$ = true;

day8.re_frame.test.t_day8$re_frame$test47069.prototype.call = ((function (test_context){
return (function (self__,done){
var self__ = this;
var self____$1 = this;
var ___44422__auto__ = self____$1;
var restore_fn = re_frame.core.make_restore_fn.call(null);
var _STAR_test_context_STAR_47073 = day8.re_frame.test._STAR_test_context_STAR_;
day8.re_frame.test._STAR_test_context_STAR_ = cljs.core.assoc.call(null,self__.test_context,new cljs.core.Keyword(null,"done","done",-889844188),((function (_STAR_test_context_STAR_47073,restore_fn,___44422__auto__,self____$1,test_context){
return (function (){
restore_fn.call(null);

return done.call(null);
});})(_STAR_test_context_STAR_47073,restore_fn,___44422__auto__,self____$1,test_context))
);

try{return self__.f.call(null);
}finally {day8.re_frame.test._STAR_test_context_STAR_ = _STAR_test_context_STAR_47073;
}});})(test_context))
;

day8.re_frame.test.t_day8$re_frame$test47069.prototype.apply = ((function (test_context){
return (function (self__,args47072){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args47072)));
});})(test_context))
;

day8.re_frame.test.t_day8$re_frame$test47069.prototype.cljs$core$IFn$_invoke$arity$1 = ((function (test_context){
return (function (done){
var self__ = this;
var ___44422__auto__ = this;
var restore_fn = re_frame.core.make_restore_fn.call(null);
var _STAR_test_context_STAR_47074 = day8.re_frame.test._STAR_test_context_STAR_;
day8.re_frame.test._STAR_test_context_STAR_ = cljs.core.assoc.call(null,self__.test_context,new cljs.core.Keyword(null,"done","done",-889844188),((function (_STAR_test_context_STAR_47074,restore_fn,___44422__auto__,test_context){
return (function (){
restore_fn.call(null);

return done.call(null);
});})(_STAR_test_context_STAR_47074,restore_fn,___44422__auto__,test_context))
);

try{return self__.f.call(null);
}finally {day8.re_frame.test._STAR_test_context_STAR_ = _STAR_test_context_STAR_47074;
}});})(test_context))
;

day8.re_frame.test.t_day8$re_frame$test47069.getBasis = ((function (test_context){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"run-test-async*","run-test-async*",1085254048,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"test-context","test-context",-2049932830,null),new cljs.core.Symbol(null,"meta47070","meta47070",1091777910,null)], null);
});})(test_context))
;

day8.re_frame.test.t_day8$re_frame$test47069.cljs$lang$type = true;

day8.re_frame.test.t_day8$re_frame$test47069.cljs$lang$ctorStr = "day8.re-frame.test/t_day8$re_frame$test47069";

day8.re_frame.test.t_day8$re_frame$test47069.cljs$lang$ctorPrWriter = ((function (test_context){
return (function (this__42056__auto__,writer__42057__auto__,opt__42058__auto__){
return cljs.core._write.call(null,writer__42057__auto__,"day8.re-frame.test/t_day8$re_frame$test47069");
});})(test_context))
;

day8.re_frame.test.__GT_t_day8$re_frame$test47069 = ((function (test_context){
return (function day8$re_frame$test$run_test_async_STAR__$___GT_t_day8$re_frame$test47069(run_test_async_STAR___$1,f__$1,test_context__$1,meta47070){
return (new day8.re_frame.test.t_day8$re_frame$test47069(run_test_async_STAR___$1,f__$1,test_context__$1,meta47070));
});})(test_context))
;

}

return (new day8.re_frame.test.t_day8$re_frame$test47069(day8$re_frame$test$run_test_async_STAR_,f,test_context,null));
});
/**
 * Run `body` as an async re-frame test. The async nature means you'll need to
 *   use `wait-for` any time you want to make any assertions that should be true
 *   *after* an event has been handled.  It's assumed that there will be at least
 *   one `wait-for` in the body of your test (otherwise you don't need this macro
 *   at all).
 * 
 *   Note: unlike regular ClojureScript `cljs.test/async` tests, `wait-for` takes
 *   care of calling `(done)` for you: you don't need to do anything specific to
 *   handle the fact that your test is asynchronous, other than make sure that all
 *   your assertions happen with `wait-for` blocks.
 * 
 *   This macro will automatically clean up any changes to re-frame state made
 *   within the test body, as per `with-temp-re-frame-state` (except that the way
 *   it's done here *does* work for async tests, whereas that macro used by itself
 *   doesn't).
 */
day8.re_frame.test.run_test_async = (function day8$re_frame$test$run_test_async(var_args){
var args__42532__auto__ = [];
var len__42525__auto___47078 = arguments.length;
var i__42526__auto___47079 = (0);
while(true){
if((i__42526__auto___47079 < len__42525__auto___47078)){
args__42532__auto__.push((arguments[i__42526__auto___47079]));

var G__47080 = (i__42526__auto___47079 + (1));
i__42526__auto___47079 = G__47080;
continue;
} else {
}
break;
}

var argseq__42533__auto__ = ((((2) < args__42532__auto__.length))?(new cljs.core.IndexedSeq(args__42532__auto__.slice((2)),(0),null)):null);
return day8.re_frame.test.run_test_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__42533__auto__);
});

day8.re_frame.test.run_test_async.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("day8.re-frame.test","run-test-async*","day8.re-frame.test/run-test-async*",-694638677,null)),(function (){var x__42284__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),(function (){var x__42284__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__42284__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__42284__auto__);
})())));
});

day8.re_frame.test.run_test_async.cljs$lang$maxFixedArity = (2);

day8.re_frame.test.run_test_async.cljs$lang$applyTo = (function (seq47075){
var G__47076 = cljs.core.first.call(null,seq47075);
var seq47075__$1 = cljs.core.next.call(null,seq47075);
var G__47077 = cljs.core.first.call(null,seq47075__$1);
var seq47075__$2 = cljs.core.next.call(null,seq47075__$1);
return day8.re_frame.test.run_test_async.cljs$core$IFn$_invoke$arity$variadic(G__47076,G__47077,seq47075__$2);
});


day8.re_frame.test.run_test_async.cljs$lang$macro = true;
/**
 * Interprets the acceptable input values for `wait-for`'s `ok-ids` and
 *   `failure-ids` params to produce a predicate function on an event.  See
 *   `wait-for` for details.
 */
day8.re_frame.test.as_callback_pred = (function day8$re_frame$test$as_callback_pred(callback_pred){
if(cljs.core.truth_(callback_pred)){
if((cljs.core.set_QMARK_.call(null,callback_pred)) || (cljs.core.vector_QMARK_.call(null,callback_pred))){
return (function (event){
return cljs.core.some.call(null,(function (pred){
return pred.call(null,event);
}),cljs.core.map.call(null,day8$re_frame$test$as_callback_pred,cljs.core.seq.call(null,callback_pred)));
});
} else {
if(cljs.core.fn_QMARK_.call(null,callback_pred)){
return callback_pred;
} else {
if((callback_pred instanceof cljs.core.Keyword)){
return (function (p__47085){
var vec__47086 = p__47085;
var event_id = cljs.core.nth.call(null,vec__47086,(0),null);
var _ = cljs.core.nth.call(null,vec__47086,(1),null);
return cljs.core._EQ_.call(null,callback_pred,event_id);
});
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str(cljs.core.pr_str.call(null,callback_pred)),cljs.core.str(" isn't an event predicate")].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"callback-pred","callback-pred",90867475),callback_pred], null));

}
}
}
} else {
return null;
}
});
/**
 * This function is an implementation detail: in your async tests (within a
 *   `run-test-async`), you should use the `wait-for` macro instead.  (For
 *   synchronous tests within `run-test-sync`, you don't need this capability at
 *   all.)
 * 
 *   Installs `callback` as a re-frame post-event callback handler, called as soon
 *   as any event matching `ok-ids` is handled.  Aborts the test as a failure if
 *   any event matching `failure-ids` is handled.
 * 
 *   Since this is intended for use in asynchronous tests: it will return
 *   immediately after installing the callback -- it doesn't *actually* wait.
 * 
 *   Note that `wait-for*` tracks whether, during your callback, you call
 *   `wait-for*` again.  If you *don't*, then, given the way asynchronous tests
 *   work, your test must necessarily be finished.  So `wait-for*` will
 *   call `(done)` for you.
 */
day8.re_frame.test.wait_for_STAR_ = (function day8$re_frame$test$wait_for_STAR_(ok_ids,failure_ids,callback){
var map__47093 = cljs.core.update.call(null,day8.re_frame.test._STAR_test_context_STAR_,new cljs.core.Keyword(null,"wait-for-depth","wait-for-depth",-1366777331),cljs.core.inc);
var map__47093__$1 = ((((!((map__47093 == null)))?((((map__47093.cljs$lang$protocol_mask$partition0$ & (64))) || (map__47093.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47093):map__47093);
var test_context = map__47093__$1;
var done = cljs.core.get.call(null,map__47093__$1,new cljs.core.Keyword(null,"done","done",-889844188));
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"max-wait-for-depth","max-wait-for-depth",639503457).cljs$core$IFn$_invoke$arity$1(test_context),cljs.core.inc);

var ok_pred = day8.re_frame.test.as_callback_pred.call(null,ok_ids);
var fail_pred = day8.re_frame.test.as_callback_pred.call(null,failure_ids);
var cb_id = cljs.core.gensym.call(null,"wait-for-cb-fn");
re_frame.core.add_post_event_callback.call(null,cb_id,((function (ok_pred,fail_pred,cb_id,map__47093,map__47093__$1,test_context,done){
return (function (event,_){
if(cljs.core.truth_((function (){var and__41437__auto__ = fail_pred;
if(cljs.core.truth_(and__41437__auto__)){
return cljs.core.not.call(null,(function (){try{var values__44354__auto__ = (function (){var x__42284__auto__ = fail_pred.call(null,event);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__42284__auto__);
})();
var result__44355__auto__ = cljs.core.apply.call(null,cljs.core.not,values__44354__auto__);
if(cljs.core.truth_(result__44355__auto__)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"fail-pred","fail-pred",518790579,null),new cljs.core.Symbol(null,"event","event",1941966969,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core.not,values__44354__auto__),new cljs.core.Keyword(null,"message","message",-406056002),"Received failure event"], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"fail-pred","fail-pred",518790579,null),new cljs.core.Symbol(null,"event","event",1941966969,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core._conj.call(null,(function (){var x__42284__auto__ = cljs.core.cons.call(null,new cljs.core.Symbol(null,"not","not",1044554643,null),values__44354__auto__);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__42284__auto__);
})(),new cljs.core.Symbol(null,"not","not",1044554643,null)),new cljs.core.Keyword(null,"message","message",-406056002),"Received failure event"], null));
}

return result__44355__auto__;
}catch (e47095){var t__44392__auto__ = e47095;
return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"fail-pred","fail-pred",518790579,null),new cljs.core.Symbol(null,"event","event",1941966969,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__44392__auto__,new cljs.core.Keyword(null,"message","message",-406056002),"Received failure event"], null));
}})());
} else {
return and__41437__auto__;
}
})())){
re_frame.core.remove_post_event_callback.call(null,cb_id);

cljs.core.reset_BANG_.call(null,new cljs.core.Keyword(null,"now-waiting-for","now-waiting-for",322402761).cljs$core$IFn$_invoke$arity$1(test_context),null);

return done.call(null);
} else {
if(cljs.core.truth_(ok_pred.call(null,event))){
re_frame.core.remove_post_event_callback.call(null,cb_id);

cljs.core.reset_BANG_.call(null,new cljs.core.Keyword(null,"now-waiting-for","now-waiting-for",322402761).cljs$core$IFn$_invoke$arity$1(test_context),null);

var _STAR_test_context_STAR_47096_47097 = day8.re_frame.test._STAR_test_context_STAR_;
day8.re_frame.test._STAR_test_context_STAR_ = test_context;

try{callback.call(null,event);
}finally {day8.re_frame.test._STAR_test_context_STAR_ = _STAR_test_context_STAR_47096_47097;
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"wait-for-depth","wait-for-depth",-1366777331).cljs$core$IFn$_invoke$arity$1(test_context),cljs.core.deref.call(null,new cljs.core.Keyword(null,"max-wait-for-depth","max-wait-for-depth",639503457).cljs$core$IFn$_invoke$arity$1(test_context)))){
return done.call(null);
} else {
return null;
}
} else {
return null;

}
}
});})(ok_pred,fail_pred,cb_id,map__47093,map__47093__$1,test_context,done))
);

return cljs.core.reset_BANG_.call(null,new cljs.core.Keyword(null,"now-waiting-for","now-waiting-for",322402761).cljs$core$IFn$_invoke$arity$1(test_context),ok_ids);
});
/**
 * Execute `body` once an event identified by the predicate(s) `ids` has been handled.
 * 
 *   `ids` and `failure-ids` are means to identify an event. Normally, each would
 *   be a simple keyword or a set of keywords.  If an event with event-id of (or
 *   in) `ids` is handled, the test will continue by executing the body. If an
 *   event with an event-id of (or in) `failure-ids` is handled, the test will
 *   abort and fail.
 * 
 *   IMPORTANT NOTE: due to the way async tests in re-frame work, code you want
 *   executed after the event you're waiting for has to happen in the `body` of the
 *   `wait-for` (in an implicit callback), not just lexically after the the
 *   `wait-for` call. In practice, this means `wait-for` must always be in a tail
 *   position.
 * 
 *   Eg:
 *    (run-test-async
 *      (dispatch [:get-user 2])
 *      (wait-for [#{:got-user} #{:no-such-user :system-unavailable} event]
 *        (is (= (:username @(subscribe [:user])) "johnny")))
 *      ;; Don't put code here, it will run *before* the event you're waiting
 *      ;; for.
 *      )
 * 
 *   Acceptable inputs for `ids` and `failure-ids` are:
 *  - `:some-event-id` => matches an event with that ID
 * 
 *  - `#{:some-event-id :other-event-id}` => matches an event with any of the
 *                                           given IDs
 * 
 *  - `[:some-event-id :other-event-id]` => ditto (checks in order)
 * 
 *  - `(fn [event] ,,,) => uses the function as a predicate
 * 
 *  - `[(fn [event] ,,,) (fn [event] ,,,)]` => tries each predicate in turn,
 *                                             matching an event which matches
 *                                             at least one predicate
 * 
 *  - `#{:some-event-id (fn [event] ,,,)}` => tries each
 * 
 *   Note that because we're liberal about whether you supply `failure-ids` and/or
 *   `event-sym`, if you do choose to supply only one, and you want that one to be
 *   `event-sym`, you can't supply it as a destructuring form (because we can't
 *   disambiguate that from a vector of `failure-ids`).  You can just supply `nil`
 *   as `failure-ids` in this case, and then you'll be able to destructure.
 */
day8.re_frame.test.wait_for = (function day8$re_frame$test$wait_for(var_args){
var args__42532__auto__ = [];
var len__42525__auto___47110 = arguments.length;
var i__42526__auto___47111 = (0);
while(true){
if((i__42526__auto___47111 < len__42525__auto___47110)){
args__42532__auto__.push((arguments[i__42526__auto___47111]));

var G__47112 = (i__42526__auto___47111 + (1));
i__42526__auto___47111 = G__47112;
continue;
} else {
}
break;
}

var argseq__42533__auto__ = ((((3) < args__42532__auto__.length))?(new cljs.core.IndexedSeq(args__42532__auto__.slice((3)),(0),null)):null);
return day8.re_frame.test.wait_for.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__42533__auto__);
});

day8.re_frame.test.wait_for.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,p__47102,body){
var vec__47103 = p__47102;
var ids = cljs.core.nth.call(null,vec__47103,(0),null);
var failure_ids = cljs.core.nth.call(null,vec__47103,(1),null);
var event_sym = cljs.core.nth.call(null,vec__47103,(2),null);
var argv = vec__47103;
var vec__47106 = (function (){var G__47109 = cljs.core.count.call(null,argv);
switch (G__47109) {
case (3):
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [failure_ids,event_sym], null);

break;
case (2):
if((cljs.core.second.call(null,argv) instanceof cljs.core.Symbol)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.second.call(null,argv)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.second.call(null,argv),cljs.core.gensym.call(null,"event")], null);
}

break;
case (1):
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.gensym.call(null,"event")], null);

break;
case (0):
throw cljs.core.ex_info.call(null,"wait-for needs to know what to wait for!",cljs.core.PersistentArrayMap.EMPTY);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(cljs.core.count.call(null,argv))].join('')));

}
})();
var failure_ids__$1 = cljs.core.nth.call(null,vec__47106,(0),null);
var event_sym__$1 = cljs.core.nth.call(null,vec__47106,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("day8.re-frame.test","wait-for*","day8.re-frame.test/wait-for*",526325482,null)),(function (){var x__42284__auto__ = ids;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__42284__auto__);
})(),(function (){var x__42284__auto__ = failure_ids__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__42284__auto__);
})(),(function (){var x__42284__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),(function (){var x__42284__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__42284__auto__ = event_sym__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__42284__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__42284__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__42284__auto__);
})())));
});

day8.re_frame.test.wait_for.cljs$lang$maxFixedArity = (3);

day8.re_frame.test.wait_for.cljs$lang$applyTo = (function (seq47098){
var G__47099 = cljs.core.first.call(null,seq47098);
var seq47098__$1 = cljs.core.next.call(null,seq47098);
var G__47100 = cljs.core.first.call(null,seq47098__$1);
var seq47098__$2 = cljs.core.next.call(null,seq47098__$1);
var G__47101 = cljs.core.first.call(null,seq47098__$2);
var seq47098__$3 = cljs.core.next.call(null,seq47098__$2);
return day8.re_frame.test.wait_for.cljs$core$IFn$_invoke$arity$variadic(G__47099,G__47100,G__47101,seq47098__$3);
});


day8.re_frame.test.wait_for.cljs$lang$macro = true;
day8.re_frame.test._STAR_handling_STAR_ = false;
day8.re_frame.test.run_test_sync_STAR_ = (function day8$re_frame$test$run_test_sync_STAR_(f){
var restore_fn__45304__auto__ = re_frame.core.make_restore_fn.call(null);
try{var my_queue = cljs.core.atom.call(null,re_frame.interop.empty_queue);
var dispatch47116 = re_frame.core.dispatch;
re_frame.core.dispatch = ((function (dispatch47116,my_queue,restore_fn__45304__auto__){
return (function (argv){
cljs.core.swap_BANG_.call(null,my_queue,cljs.core.conj,argv);

if(cljs.core.truth_(day8.re_frame.test._STAR_handling_STAR_)){
return null;
} else {
var _STAR_handling_STAR_47117 = day8.re_frame.test._STAR_handling_STAR_;
day8.re_frame.test._STAR_handling_STAR_ = true;

try{while(true){
var temp__4657__auto__ = day8.re_frame.test.dequeue_BANG_.call(null,my_queue);
if(cljs.core.truth_(temp__4657__auto__)){
var queue_head = temp__4657__auto__;
re_frame.core.dispatch_sync.call(null,queue_head);

continue;
} else {
return null;
}
break;
}
}finally {day8.re_frame.test._STAR_handling_STAR_ = _STAR_handling_STAR_47117;
}}
});})(dispatch47116,my_queue,restore_fn__45304__auto__))
;

try{return f.call(null);
}finally {re_frame.core.dispatch = dispatch47116;
}}finally {restore_fn__45304__auto__.call(null);
}});
/**
 * Execute `body` as a test, where each `dispatch` call is executed
 *   synchronously (via `dispatch-sync`), and any subsequent dispatches which are
 *   caused by that dispatch are also fully handled/executed prior to control flow
 *   returning to your test.
 * 
 *   Think of it kind of as though every `dispatch` in your app had been magically
 *   turned into `dispatch-sync`, and re-frame had lifted the restriction that says
 *   you can't call `dispatch-sync` from within an event handler.
 * 
 *   Note that this is *not* achieved with blocking.  It relies on you not doing
 *   anything asynchronous (such as an actual AJAX call or `js/setTimeout`)
 *   directly in your event handlers.  In a real app running in the real browser,
 *   of course that won't apply, so this might seem useless at first.  But if
 *   you're a well-behaved re-framer, all of your asynchronous stuff (which is by
 *   definition side-effecty) will happen in effectful event handlers installed
 *   with `reg-fx`.  Which works very nicely: in your tests, install an alternative
 *   version of those effectful event handlers which behaves synchronously.  For
 *   maximum coolness, you might want to consider running your tests on the JVM and
 *   installing a `reg-fx` handler which actually invokes your JVM Clojure
 *   server-side Ring handler where your in-browser code would make an AJAX call.
 */
day8.re_frame.test.run_test_sync = (function day8$re_frame$test$run_test_sync(var_args){
var args__42532__auto__ = [];
var len__42525__auto___47121 = arguments.length;
var i__42526__auto___47122 = (0);
while(true){
if((i__42526__auto___47122 < len__42525__auto___47121)){
args__42532__auto__.push((arguments[i__42526__auto___47122]));

var G__47123 = (i__42526__auto___47122 + (1));
i__42526__auto___47122 = G__47123;
continue;
} else {
}
break;
}

var argseq__42533__auto__ = ((((2) < args__42532__auto__.length))?(new cljs.core.IndexedSeq(args__42532__auto__.slice((2)),(0),null)):null);
return day8.re_frame.test.run_test_sync.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__42533__auto__);
});

day8.re_frame.test.run_test_sync.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("day8.re-frame.test","run-test-sync*","day8.re-frame.test/run-test-sync*",1693776500,null)),(function (){var x__42284__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),(function (){var x__42284__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__42284__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__42284__auto__);
})())));
});

day8.re_frame.test.run_test_sync.cljs$lang$maxFixedArity = (2);

day8.re_frame.test.run_test_sync.cljs$lang$applyTo = (function (seq47118){
var G__47119 = cljs.core.first.call(null,seq47118);
var seq47118__$1 = cljs.core.next.call(null,seq47118);
var G__47120 = cljs.core.first.call(null,seq47118__$1);
var seq47118__$2 = cljs.core.next.call(null,seq47118__$1);
return day8.re_frame.test.run_test_sync.cljs$core$IFn$_invoke$arity$variadic(G__47119,G__47120,seq47118__$2);
});


day8.re_frame.test.run_test_sync.cljs$lang$macro = true;

//# sourceMappingURL=test.js.map?rel=1485060687786