// Compiled by ClojureScript 1.9.229 {}
goog.provide('bones.editable.local_storage');
goog.require('cljs.core');
goog.require('bones.editable.protocols');
goog.require('cljs.reader');
goog.require('re_frame.core');
bones.editable.local_storage.local_key = (function bones$editable$local_storage$local_key(prefix,form_type){
return [cljs.core.str(cljs.core.name.call(null,prefix)),cljs.core.str("-"),cljs.core.str(cljs.core.name.call(null,form_type))].join('');
});
bones.editable.local_storage.local_get_item = (function bones$editable$local_storage$local_get_item(prefix,form_type){
var temp__4655__auto__ = localStorage.getItem(bones.editable.local_storage.local_key.call(null,prefix,form_type));
if(cljs.core.truth_(temp__4655__auto__)){
var result = temp__4655__auto__;
return cljs.reader.read_string.call(null,result);
} else {
return null;
}
});
bones.editable.local_storage.local_set_item = (function bones$editable$local_storage$local_set_item(prefix,form_type,value){
return localStorage.setItem(bones.editable.local_storage.local_key.call(null,prefix,form_type),cljs.core.pr_str.call(null,value));
});
if(typeof bones.editable.local_storage.take_action !== 'undefined'){
} else {
bones.editable.local_storage.take_action = (function (){var method_table__42380__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__42381__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__42382__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__42383__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__42384__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"bones.editable.local-storage","take-action"),cljs.core.identity,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__42384__auto__,method_table__42380__auto__,prefer_table__42381__auto__,method_cache__42382__auto__,cached_hierarchy__42383__auto__));
})();
}
cljs.core._add_method.call(null,bones.editable.local_storage.take_action,"new",(function (action,args,things){
return cljs.core.assoc.call(null,things,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(args),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"inputs","inputs",865803858),args], null));
}));
cljs.core._add_method.call(null,bones.editable.local_storage.take_action,"delete",(function (action,args,things){
return cljs.core.dissoc.call(null,things,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(args));
}));
cljs.core._add_method.call(null,bones.editable.local_storage.take_action,"update",(function (action,args,things){
return cljs.core.update_in.call(null,things,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(args),new cljs.core.Keyword(null,"inputs","inputs",865803858)], null),cljs.core.merge,args);
}));
cljs.core._add_method.call(null,bones.editable.local_storage.take_action,"delete-many",(function (action,args,things){
return cljs.core.reduce.call(null,cljs.core.dissoc,things,new cljs.core.Keyword(null,"ids","ids",-998535796).cljs$core$IFn$_invoke$arity$1(args));
}));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {bones.editable.protocols.Client}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
bones.editable.local_storage.LocalStorage = (function (prefix,__meta,__extmap,__hash){
this.prefix = prefix;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
bones.editable.local_storage.LocalStorage.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__42077__auto__,k__42078__auto__){
var self__ = this;
var this__42077__auto____$1 = this;
return cljs.core._lookup.call(null,this__42077__auto____$1,k__42078__auto__,null);
});

bones.editable.local_storage.LocalStorage.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__42079__auto__,k43506,else__42080__auto__){
var self__ = this;
var this__42079__auto____$1 = this;
var G__43508 = (((k43506 instanceof cljs.core.Keyword))?k43506.fqn:null);
switch (G__43508) {
case "prefix":
return self__.prefix;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k43506,else__42080__auto__);

}
});

bones.editable.local_storage.LocalStorage.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__42091__auto__,writer__42092__auto__,opts__42093__auto__){
var self__ = this;
var this__42091__auto____$1 = this;
var pr_pair__42094__auto__ = ((function (this__42091__auto____$1){
return (function (keyval__42095__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__42092__auto__,cljs.core.pr_writer,""," ","",opts__42093__auto__,keyval__42095__auto__);
});})(this__42091__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__42092__auto__,pr_pair__42094__auto__,"#bones.editable.local-storage.LocalStorage{",", ","}",opts__42093__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"prefix","prefix",-265908465),self__.prefix],null))], null),self__.__extmap));
});

bones.editable.local_storage.LocalStorage.prototype.cljs$core$IIterable$ = true;

bones.editable.local_storage.LocalStorage.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__43505){
var self__ = this;
var G__43505__$1 = this;
return (new cljs.core.RecordIter((0),G__43505__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"prefix","prefix",-265908465)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

bones.editable.local_storage.LocalStorage.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__42075__auto__){
var self__ = this;
var this__42075__auto____$1 = this;
return self__.__meta;
});

bones.editable.local_storage.LocalStorage.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__42071__auto__){
var self__ = this;
var this__42071__auto____$1 = this;
return (new bones.editable.local_storage.LocalStorage(self__.prefix,self__.__meta,self__.__extmap,self__.__hash));
});

bones.editable.local_storage.LocalStorage.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__42081__auto__){
var self__ = this;
var this__42081__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

bones.editable.local_storage.LocalStorage.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__42072__auto__){
var self__ = this;
var this__42072__auto____$1 = this;
var h__41890__auto__ = self__.__hash;
if(!((h__41890__auto__ == null))){
return h__41890__auto__;
} else {
var h__41890__auto____$1 = cljs.core.hash_imap.call(null,this__42072__auto____$1);
self__.__hash = h__41890__auto____$1;

return h__41890__auto____$1;
}
});

bones.editable.local_storage.LocalStorage.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__42073__auto__,other__42074__auto__){
var self__ = this;
var this__42073__auto____$1 = this;
if(cljs.core.truth_((function (){var and__41443__auto__ = other__42074__auto__;
if(cljs.core.truth_(and__41443__auto__)){
var and__41443__auto____$1 = (this__42073__auto____$1.constructor === other__42074__auto__.constructor);
if(and__41443__auto____$1){
return cljs.core.equiv_map.call(null,this__42073__auto____$1,other__42074__auto__);
} else {
return and__41443__auto____$1;
}
} else {
return and__41443__auto__;
}
})())){
return true;
} else {
return false;
}
});

bones.editable.local_storage.LocalStorage.prototype.bones$editable$protocols$Client$ = true;

bones.editable.local_storage.LocalStorage.prototype.bones$editable$protocols$Client$login$arity$3 = (function (client,args,tap){
var self__ = this;
var client__$1 = this;
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("response","login","response/login",395412016),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fake","fake",-904846741),true], null),(200),tap], null));
});

bones.editable.local_storage.LocalStorage.prototype.bones$editable$protocols$Client$logout$arity$2 = (function (client,tap){
var self__ = this;
var client__$1 = this;
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("response","logout","response/logout",-121338070),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fake","fake",-904846741),true], null),(200),tap], null));
});

bones.editable.local_storage.LocalStorage.prototype.bones$editable$protocols$Client$command$arity$4 = (function (client,cmd,args,tap){
var self__ = this;
var client__$1 = this;
try{var cmdspace = (function (){var or__41455__auto__ = cljs.core.namespace.call(null,cmd);
if(cljs.core.truth_(or__41455__auto__)){
return or__41455__auto__;
} else {
return new cljs.core.Keyword(null,"e-type","e-type",1927823487).cljs$core$IFn$_invoke$arity$1(tap);
}
})();
var action = cljs.core.name.call(null,cmd);
var many_QMARK_ = (!(cljs.core.map_QMARK_.call(null,args))) && (cljs.core.iterable_QMARK_.call(null,args));
if(cljs.core.truth_((function (){var and__41443__auto__ = cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["delete",null,"update",null], null), null),action);
if(cljs.core.truth_(and__41443__auto__)){
return (new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(args) == null);
} else {
return and__41443__auto__;
}
})())){
throw (new Error([cljs.core.str("no :id present in args: "),cljs.core.str(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"command","command",-894540724),cmd,new cljs.core.Keyword(null,"args","args",1315556576),args], null))].join('')));
} else {
if((many_QMARK_) && (!(cljs.core.every_QMARK_.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),args)))){
throw (new Error([cljs.core.str("at least one thing missing an :id in: "),cljs.core.str(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"command","command",-894540724),cmd,new cljs.core.Keyword(null,"args","args",1315556576),args], null))].join('')));
} else {
var things = bones.editable.local_storage.local_get_item.call(null,self__.prefix,cmdspace);
var args_with_id = ((cljs.core._EQ_.call(null,"new",action))?cljs.core.update.call(null,args,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.fnil.call(null,cljs.core.identity,cljs.core.random_uuid.call(null))):args);
var response_args = args_with_id;
bones.editable.local_storage.local_set_item.call(null,self__.prefix,cmdspace,bones.editable.local_storage.take_action.call(null,action,args_with_id,things));

return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("response","command","response/command",-1636337525),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"args","args",1315556576),response_args,new cljs.core.Keyword(null,"command","command",-894540724),cmd], null),(200),tap], null));

}
}
}catch (e43509){if((e43509 instanceof Error)){
var e = e43509;
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("response","command","response/command",-1636337525),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"errors","errors",-908790718),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),e.message], null)], null),(401),tap], null));
} else {
throw e43509;

}
}});

bones.editable.local_storage.LocalStorage.prototype.bones$editable$protocols$Client$query$arity$3 = (function (client,args,tap){
var self__ = this;
var client__$1 = this;
var map__43510 = args;
var map__43510__$1 = ((((!((map__43510 == null)))?((((map__43510.cljs$lang$protocol_mask$partition0$ & (64))) || (map__43510.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43510):map__43510);
var e_type = cljs.core.get.call(null,map__43510__$1,new cljs.core.Keyword(null,"e-type","e-type",1927823487));
if(cljs.core.truth_(e_type)){
var things = bones.editable.local_storage.local_get_item.call(null,self__.prefix,e_type);
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("response","query","response/query",-2032538503),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"results","results",-1134170113),things], null),(200),tap], null));
} else {
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("response","query","response/query",-2032538503),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),":e-type is nil"], null),(401),tap], null));
}
});

bones.editable.local_storage.LocalStorage.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__42086__auto__,k__42087__auto__){
var self__ = this;
var this__42086__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"prefix","prefix",-265908465),null], null), null),k__42087__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__42086__auto____$1),self__.__meta),k__42087__auto__);
} else {
return (new bones.editable.local_storage.LocalStorage(self__.prefix,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__42087__auto__)),null));
}
});

bones.editable.local_storage.LocalStorage.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__42084__auto__,k__42085__auto__,G__43505){
var self__ = this;
var this__42084__auto____$1 = this;
var pred__43512 = cljs.core.keyword_identical_QMARK_;
var expr__43513 = k__42085__auto__;
if(cljs.core.truth_(pred__43512.call(null,new cljs.core.Keyword(null,"prefix","prefix",-265908465),expr__43513))){
return (new bones.editable.local_storage.LocalStorage(G__43505,self__.__meta,self__.__extmap,null));
} else {
return (new bones.editable.local_storage.LocalStorage(self__.prefix,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__42085__auto__,G__43505),null));
}
});

bones.editable.local_storage.LocalStorage.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__42089__auto__){
var self__ = this;
var this__42089__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"prefix","prefix",-265908465),self__.prefix],null))], null),self__.__extmap));
});

bones.editable.local_storage.LocalStorage.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__42076__auto__,G__43505){
var self__ = this;
var this__42076__auto____$1 = this;
return (new bones.editable.local_storage.LocalStorage(self__.prefix,G__43505,self__.__extmap,self__.__hash));
});

bones.editable.local_storage.LocalStorage.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__42082__auto__,entry__42083__auto__){
var self__ = this;
var this__42082__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__42083__auto__)){
return cljs.core._assoc.call(null,this__42082__auto____$1,cljs.core._nth.call(null,entry__42083__auto__,(0)),cljs.core._nth.call(null,entry__42083__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__42082__auto____$1,entry__42083__auto__);
}
});

bones.editable.local_storage.LocalStorage.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"prefix","prefix",1374623062,null)], null);
});

bones.editable.local_storage.LocalStorage.cljs$lang$type = true;

bones.editable.local_storage.LocalStorage.cljs$lang$ctorPrSeq = (function (this__42111__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"bones.editable.local-storage/LocalStorage");
});

bones.editable.local_storage.LocalStorage.cljs$lang$ctorPrWriter = (function (this__42111__auto__,writer__42112__auto__){
return cljs.core._write.call(null,writer__42112__auto__,"bones.editable.local-storage/LocalStorage");
});

bones.editable.local_storage.__GT_LocalStorage = (function bones$editable$local_storage$__GT_LocalStorage(prefix){
return (new bones.editable.local_storage.LocalStorage(prefix,null,null,null));
});

bones.editable.local_storage.map__GT_LocalStorage = (function bones$editable$local_storage$map__GT_LocalStorage(G__43507){
return (new bones.editable.local_storage.LocalStorage(new cljs.core.Keyword(null,"prefix","prefix",-265908465).cljs$core$IFn$_invoke$arity$1(G__43507),null,cljs.core.dissoc.call(null,G__43507,new cljs.core.Keyword(null,"prefix","prefix",-265908465)),null));
});


//# sourceMappingURL=local_storage.js.map?rel=1485315381215