(ns bones.client.handlers
  (:require [bones.client :as client]))

(defn request-query-handler [db [params tap]]
  (let [c (:client @(:sys db))]
    (client/query c params tap))
  db)

(defn request-command-handler [db [command args tap]]
  (let [c (:client @(:sys db))]
    (client/command c command args tap))
  db)

(defn request-login-handler [db [fields tap]]
  (let [c (:client @(:sys db))]
    (client/login c fields tap))
  db)

(defn request-logout-handler [db [tap]]
  (let [c (:client @(:sys db))]
    (client/logout c tap))
  db)

(def request-handlers [[:request/query request-query-handler]
                       [:request/command request-command-handler]
                       [:request/login request-login-handler]
                       [:request/logout request-logout-handler]])
