(ns blueprints.clj.graphson
  (:refer-clojure :exclude [read])
  (:import (com.tinkerpop.blueprints.util.io.graphson GraphSONMode
                                                      GraphSONReader
                                                      GraphSONWriter)
           java.util.Set)
  (:require [blueprints.clj :as $]))

;; [Utils]
(defn ^:private ^GraphSONMode ->mode [kw]
  (case kw
    :compact  GraphSONMode/COMPACT
    :extended GraphSONMode/EXTENDED
    :normal   GraphSONMode/NORMAL))

;; [Interface]
(defn read ""
  [source]
  (.inputGraph (GraphSONReader. $/*db*) source))

(defn write! ""
  [target {:keys [vertex-prop-keys edge-prop-keys mode]}]
  {:pre [(->mode mode)]}
  (.outputGraph (GraphSONWriter. $/*db*) target
                ^Set (or vertex-prop-keys #{})
                ^Set (or edge-prop-keys #{})
                (->mode mode)))
