(ns blueprints.clj.graphml
  (:refer-clojure :exclude [read])
  (:import (com.tinkerpop.blueprints Graph)
           (com.tinkerpop.blueprints.util.io.graphml GraphMLReader
                                                     GraphMLWriter
                                                     GraphMigrator))
  (:require [blueprints.clj :as $])
  (:use clojure.template))

;; [Interface]
(defn migrate! ""
  [^Graph from ^Graph to]
  (GraphMigrator/migrateGraph from to))

(defn read ""
  [source {:keys [^String edge-id-key ^String edge-label-key ^String vertex-id-key]}]
  (let [reader (GraphMLReader. $/*db*)]
    (do-template [<val> <method>]
      (when <val> (<method> reader <val>))
      edge-id-key    .setEdgeIdKey
      edge-label-key .setEdgeLabelKey
      vertex-id-key  .setVertexIdKey)
    (.inputGraph reader source)))

(defn write! ""
  [target {:keys [edge-key-types edge-label-key normalize vertex-key-types xml-schema-location]}]
  (let [writer (GraphMLWriter. $/*db*)]
    (do-template [<val> <method>]
      (when <val> (<method> writer <val>))
      edge-key-types      .setEdgeKeyTypes
      edge-label-key      .setEdgeLabelKey
      normalize           .setNormalize
      vertex-key-types    .setVertexKeyTypes
      xml-schema-location .setXmlSchemaLocation)
    (.outputGraph writer target)))
