/*
 * Decompiled with CFR 0.152.
 */
package net.partow;

public class GeneralHashFunctionLibrary {
    static final long MASK = Long.MAX_VALUE;
    public static final byte[] BIT_MASKS = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};

    public static final long[] indexes(String string, int n, int n2) {
        long[] lArray = new long[n2];
        lArray[0] = (GeneralHashFunctionLibrary.APHash(string) & Long.MAX_VALUE) % (long)n;
        if (n2 == 1) {
            return lArray;
        }
        lArray[1] = (GeneralHashFunctionLibrary.BKDRHash(string) & Long.MAX_VALUE) % (long)n;
        if (n2 == 2) {
            return lArray;
        }
        lArray[2] = (GeneralHashFunctionLibrary.BPHash(string) & Long.MAX_VALUE) % (long)n;
        if (n2 == 3) {
            return lArray;
        }
        lArray[3] = (GeneralHashFunctionLibrary.DEKHash(string) & Long.MAX_VALUE) % (long)n;
        if (n2 == 4) {
            return lArray;
        }
        lArray[4] = (GeneralHashFunctionLibrary.DJBHash(string) & Long.MAX_VALUE) % (long)n;
        if (n2 == 5) {
            return lArray;
        }
        throw new RuntimeException("k > 5 not supported yet");
    }

    public static boolean isBitSet(byte[] byArray, long l) {
        int n = byArray.length - 1 - (int)(l / 8L);
        byte by = BIT_MASKS[(int)(l % 8L)];
        return (byArray[n] & by) == by;
    }

    public static boolean contains(byte[] byArray, String string, int n, int n2) {
        long[] lArray = GeneralHashFunctionLibrary.indexes(string, n, n2);
        for (int i = 0; i < lArray.length; ++i) {
            if (GeneralHashFunctionLibrary.isBitSet(byArray, lArray[i])) continue;
            return false;
        }
        return true;
    }

    public static long RSHash(String string) {
        int n = 378551;
        int n2 = 63689;
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l = l * (long)n2 + (long)string.charAt(i);
            n2 *= n;
        }
        return l;
    }

    public static long JSHash(String string) {
        long l = 1315423911L;
        for (int i = 0; i < string.length(); ++i) {
            l ^= (l << 5) + (long)string.charAt(i) + (l >> 2);
        }
        return l;
    }

    public static long PJWHash(String string) {
        long l = 32L;
        long l2 = l * 3L / 4L;
        long l3 = l / 8L;
        long l4 = -1L << (int)(l - l3);
        long l5 = 0L;
        long l6 = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l6 = (l5 = (l5 << (int)l3) + (long)string.charAt(i)) & l4;
            if (l6 == 0L) continue;
            l5 = (l5 ^ l6 >> (int)l2) & (l4 ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return l5;
    }

    public static long ELFHash(String string) {
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l2 = (l = (l << 4) + (long)string.charAt(i)) & 0xF0000000L;
            if (l2 != 0L) {
                l ^= l2 >> 24;
            }
            l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return l;
    }

    public static long BKDRHash(String string) {
        long l = 131L;
        long l2 = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l2 = l2 * l + (long)string.charAt(i);
        }
        return l2;
    }

    public static long SDBMHash(String string) {
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l = (long)string.charAt(i) + (l << 6) + (l << 16) - l;
        }
        return l;
    }

    public static long DJBHash(String string) {
        long l = 5381L;
        for (int i = 0; i < string.length(); ++i) {
            l = (l << 5) + l + (long)string.charAt(i);
        }
        return l;
    }

    public static long DEKHash(String string) {
        long l = string.length();
        for (int i = 0; i < string.length(); ++i) {
            l = l << 5 ^ l >> 27 ^ (long)string.charAt(i);
        }
        return l;
    }

    public static long BPHash(String string) {
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l = l << 7 ^ (long)string.charAt(i);
        }
        return l;
    }

    public static long FNVHash(String string) {
        long l = -2128831035L;
        long l2 = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l2 *= l;
            l2 ^= (long)string.charAt(i);
        }
        return l2;
    }

    public static long APHash(String string) {
        long l = -1431655766L;
        for (int i = 0; i < string.length(); ++i) {
            if ((i & 1) == 0) {
                l ^= l << 7 ^ (long)string.charAt(i) * (l >> 3);
                continue;
            }
            l ^= (l << 11) + (long)string.charAt(i) ^ l >> 5 ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return l;
    }
}

