/*
 *
 * Wijmo Library 2.2.0
 * http://wijmo.com/
 *
 * Copyright(c) GrapeCity, Inc.  All rights reserved.
 * 
 * Dual licensed under the Wijmo Commercial or GNU GPL Version 3 licenses.
 * licensing@wijmo.com
 * http://wijmo.com/license
 *
 *
 **/
/**
 * Cookie plugin
 *
 * Copyright (c) 2006 Klaus Hartl (stilbuero.de)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 */

/**
 * Create a cookie with the given name and value and other optional parameters.
 *
 * @example $.cookie('the_cookie', 'the_value');
 * @desc Set the value of a cookie.
 * @example $.cookie('the_cookie', 'the_value', { expires: 7, path: '/', domain: 'jquery.com', secure: true });
 * @desc Create a cookie with all available options.
 * @example $.cookie('the_cookie', 'the_value');
 * @desc Create a session cookie.
 * @example $.cookie('the_cookie', null);
 * @desc Delete a cookie by passing null as value. Keep in mind that you have to use the same path and domain
 *       used when the cookie was set.
 *
 * @param String name The name of the cookie.
 * @param String value The value of the cookie.
 * @param Object options An object literal containing key/value pairs to provide optional cookie attributes.
 * @option Number|Date expires Either an integer specifying the expiration date from now on in days or a Date object.
 *                             If a negative value is specified (e.g. a date in the past), the cookie will be deleted.
 *                             If set to null or omitted, the cookie will be a session cookie and will not be retained
 *                             when the the browser exits.
 * @option String path The value of the path atribute of the cookie (default: path of page that created the cookie).
 * @option String domain The value of the domain attribute of the cookie (default: domain of page that created the cookie).
 * @option Boolean secure If true, the secure attribute of the cookie will be set and the cookie transmission will
 *                        require a secure protocol (like HTTPS).
 * @type undefined
 *
 * @name $.cookie
 * @cat Plugins/Cookie
 * @author Klaus Hartl/klaus.hartl@stilbuero.de
 */

/**
 * Get the value of a cookie with the given name.
 *
 * @example $.cookie('the_cookie');
 * @desc Get the value of a cookie.
 *
 * @param String name The name of the cookie.
 * @return The value of the cookie.
 * @type String
 *
 * @name $.cookie
 * @cat Plugins/Cookie
 * @author Klaus Hartl/klaus.hartl@stilbuero.de
 */
jQuery.cookie = function(name, value, options) {
    if (typeof value != 'undefined') { // name and value given, set cookie
        options = options || {};
        if (value === null) {
            value = '';
            options.expires = -1;
        }
        var expires = '';
        if (options.expires && (typeof options.expires == 'number' || options.expires.toUTCString)) {
            var date;
            if (typeof options.expires == 'number') {
                date = new Date();
                date.setTime(date.getTime() + (options.expires * 24 * 60 * 60 * 1000));
            } else {
                date = options.expires;
            }
            expires = '; expires=' + date.toUTCString(); // use expires attribute, max-age is not supported by IE
        }
        // CAUTION: Needed to parenthesize options.path and options.domain
        // in the following expressions, otherwise they evaluate to undefined
        // in the packed version for some reason...
        var path = options.path ? '; path=' + (options.path) : '';
        var domain = options.domain ? '; domain=' + (options.domain) : '';
        var secure = options.secure ? '; secure' : '';
        document.cookie = [name, '=', encodeURIComponent(value), expires, path, domain, secure].join('');
    } else { // only name given, get cookie
        var cookieValue = null;
        if (document.cookie && document.cookie != '') {
            var cookies = document.cookie.split(';');
            for (var i = 0; i < cookies.length; i++) {
                var cookie = jQuery.trim(cookies[i]);
                // Does this cookie string begin with the name we want?
                if (cookie.substring(0, name.length + 1) == (name + '=')) {
                    cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                    break;
                }
            }
        }
        return cookieValue;
    }
};
// ┌─────────────────────────────────────────────────────────────────────┐ \\
// │ Raphaël 2.0.1 - JavaScript Vector Library                           │ \\
// ├─────────────────────────────────────────────────────────────────────┤ \\
// │ Copyright (c) 2008-2011 Dmitry Baranovskiy (http://raphaeljs.com)   │ \\
// │ Copyright (c) 2008-2011 Sencha Labs (http://sencha.com)             │ \\
// │ Licensed under the MIT (http://raphaeljs.com/license.html) license. │ \\
// └─────────────────────────────────────────────────────────────────────┘ \\
(function(a){var b="0.4.0",c="hasOwnProperty",d=/[\.\/]/,e="*",f=function(){},g=function(a,b){return a-b},h,i,j={n:{}},k=function(a,b){var c=j,d=i,e=Array.prototype.slice.call(arguments,2),f=k.listeners(a),l=0,m=!1,n,o=[],p={},q=[],r=[];h=a,i=0;for(var s=0,t=f.length;s<t;s++)"zIndex"in f[s]&&(o.push(f[s].zIndex),f[s].zIndex<0&&(p[f[s].zIndex]=f[s]));o.sort(g);while(o[l]<0){n=p[o[l++]],q.push(n.apply(b,e));if(i){i=d;return q}}for(s=0;s<t;s++){n=f[s];if("zIndex"in n)if(n.zIndex==o[l]){q.push(n.apply(b,e));if(i){i=d;return q}do{l++,n=p[o[l]],n&&q.push(n.apply(b,e));if(i){i=d;return q}}while(n)}else p[n.zIndex]=n;else{q.push(n.apply(b,e));if(i){i=d;return q}}}i=d;return q.length?q:null};k.listeners=function(a){var b=a.split(d),c=j,f,g,h,i,k,l,m,n,o=[c],p=[];for(i=0,k=b.length;i<k;i++){n=[];for(l=0,m=o.length;l<m;l++){c=o[l].n,g=[c[b[i]],c[e]],h=2;while(h--)f=g[h],f&&(n.push(f),p=p.concat(f.f||[]))}o=n}return p},k.on=function(a,b){var c=a.split(d),e=j;for(var g=0,h=c.length;g<h;g++)e=e.n,!e[c[g]]&&(e[c[g]]={n:{}}),e=e[c[g]];e.f=e.f||[];for(g=0,h=e.f.length;g<h;g++)if(e.f[g]==b)return f;e.f.push(b);return function(a){+a==+a&&(b.zIndex=+a)}},k.stop=function(){i=1},k.nt=function(a){if(a)return(new RegExp("(?:\\.|\\/|^)"+a+"(?:\\.|\\/|$)")).test(h);return h},k.unbind=function(a,b){var f=a.split(d),g,h,i,k,l,m,n,o=[j];for(k=0,l=f.length;k<l;k++)for(m=0;m<o.length;m+=i.length-2){i=[m,1],g=o[m].n;if(f[k]!=e)g[f[k]]&&i.push(g[f[k]]);else for(h in g)g[c](h)&&i.push(g[h]);o.splice.apply(o,i)}for(k=0,l=o.length;k<l;k++){g=o[k];while(g.n){if(b){if(g.f){for(m=0,n=g.f.length;m<n;m++)if(g.f[m]==b){g.f.splice(m,1);break}!g.f.length&&delete g.f}for(h in g.n)if(g.n[c](h)&&g.n[h].f){var p=g.n[h].f;for(m=0,n=p.length;m<n;m++)if(p[m]==b){p.splice(m,1);break}!p.length&&delete g.n[h].f}}else{delete g.f;for(h in g.n)g.n[c](h)&&g.n[h].f&&delete g.n[h].f}g=g.n}}},k.once=function(a,b){var c=function(){b.apply(this,arguments),k.unbind(a,c)};return k.on(a,c)},k.version=b,k.toString=function(){return"You are running Eve "+b},typeof module!="undefined"&&module.exports?module.exports=k:a.eve=k})(this),function(){function cr(b,d,e,f,h,i){e=Q(e);var j,k,l,m=[],o,p,q,t=b.ms,u={},v={},w={};if(f)for(y=0,z=cl.length;y<z;y++){var x=cl[y];if(x.el.id==d.id&&x.anim==b){x.percent!=e?(cl.splice(y,1),l=1):k=x,d.attr(x.totalOrigin);break}}else f=+v;for(var y=0,z=b.percents.length;y<z;y++){if(b.percents[y]==e||b.percents[y]>f*b.top){e=b.percents[y],p=b.percents[y-1]||0,t=t/b.top*(e-p),o=b.percents[y+1],j=b.anim[e];break}f&&d.attr(b.anim[b.percents[y]])}if(!!j){if(!k){for(var A in j)if(j[g](A))if(U[g](A)||d.paper.customAttributes[g](A)){u[A]=d.attr(A),u[A]==null&&(u[A]=T[A]),v[A]=j[A];switch(U[A]){case C:w[A]=(v[A]-u[A])/t;break;case"colour":u[A]=a.getRGB(u[A]);var B=a.getRGB(v[A]);w[A]={r:(B.r-u[A].r)/t,g:(B.g-u[A].g)/t,b:(B.b-u[A].b)/t};break;case"path":var D=bG(u[A],v[A]),E=D[1];u[A]=D[0],w[A]=[];for(y=0,z=u[A].length;y<z;y++){w[A][y]=[0];for(var F=1,G=u[A][y].length;F<G;F++)w[A][y][F]=(E[y][F]-u[A][y][F])/t}break;case"transform":var H=d._,I=bP(H[A],v[A]);if(I){u[A]=I.from,v[A]=I.to,w[A]=[],w[A].real=!0;for(y=0,z=u[A].length;y<z;y++){w[A][y]=[u[A][y][0]];for(F=1,G=u[A][y].length;F<G;F++)w[A][y][F]=(v[A][y][F]-u[A][y][F])/t}}else{var J=d.matrix||new bQ,K={_:{transform:H.transform},getBBox:function(){return d.getBBox(1)}};u[A]=[J.a,J.b,J.c,J.d,J.e,J.f],bN(K,v[A]),v[A]=K._.transform,w[A]=[(K.matrix.a-J.a)/t,(K.matrix.b-J.b)/t,(K.matrix.c-J.c)/t,(K.matrix.d-J.d)/t,(K.matrix.e-J.e)/t,(K.matrix.e-J.f)/t]}break;case"csv":var L=r(j[A])[s](c),M=r(u[A])[s](c);if(A=="clip-rect"){u[A]=M,w[A]=[],y=M.length;while(y--)w[A][y]=(L[y]-u[A][y])/t}v[A]=L;break;default:L=[][n](j[A]),M=[][n](u[A]),w[A]=[],y=d.paper.customAttributes[A].length;while(y--)w[A][y]=((L[y]||0)-(M[y]||0))/t}}var O=j.easing,P=a.easing_formulas[O];if(!P){P=r(O).match(N);if(P&&P.length==5){var R=P;P=function(a){return cp(a,+R[1],+R[2],+R[3],+R[4],t)}}else P=be}q=j.start||b.start||+(new Date),x={anim:b,percent:e,timestamp:q,start:q+(b.del||0),status:0,initstatus:f||0,stop:!1,ms:t,easing:P,from:u,diff:w,to:v,el:d,callback:j.callback,prev:p,next:o,repeat:i||b.times,origin:d.attr(),totalOrigin:h},cl.push(x);if(f&&!k&&!l){x.stop=!0,x.start=new Date-t*f;if(cl.length==1)return cn()}l&&(x.start=new Date-x.ms*f),cl.length==1&&cm(cn)}else k.initstatus=f,k.start=new Date-k.ms*f;eve("anim.start."+d.id,d,b)}}function cq(a,b){var c=[],d={};this.ms=b,this.times=1;if(a){for(var e in a)a[g](e)&&(d[Q(e)]=a[e],c.push(Q(e)));c.sort(bc)}this.anim=d,this.top=c[c.length-1],this.percents=c}function cp(a,b,c,d,e,f){function o(a,b){var c,d,e,f,j,k;for(e=a,k=0;k<8;k++){f=m(e)-a;if(z(f)<b)return e;j=(3*i*e+2*h)*e+g;if(z(j)<1e-6)break;e=e-f/j}c=0,d=1,e=a;if(e<c)return c;if(e>d)return d;while(c<d){f=m(e);if(z(f-a)<b)return e;a>f?c=e:d=e,e=(d-c)/2+c}return e}function n(a,b){var c=o(a,b);return((l*c+k)*c+j)*c}function m(a){return((i*a+h)*a+g)*a}var g=3*b,h=3*(d-b)-g,i=1-g-h,j=3*c,k=3*(e-c)-j,l=1-j-k;return n(a,1/(200*f))}function cd(){return this.x+q+this.y+q+this.width+" × "+this.height}function cc(){return this.x+q+this.y}function bQ(a,b,c,d,e,f){a!=null?(this.a=+a,this.b=+b,this.c=+c,this.d=+d,this.e=+e,this.f=+f):(this.a=1,this.b=0,this.c=0,this.d=1,this.e=0,this.f=0)}function bw(a){var b=[];for(var c=0,d=a.length;d-2>c;c+=2){var e=[{x:+a[c],y:+a[c+1]},{x:+a[c],y:+a[c+1]},{x:+a[c+2],y:+a[c+3]},{x:+a[c+4],y:+a[c+5]}];d-4==c?(e[0]={x:+a[c-2],y:+a[c-1]},e[3]=e[2]):c&&(e[0]={x:+a[c-2],y:+a[c-1]}),b.push(["C",(-e[0].x+6*e[1].x+e[2].x)/6,(-e[0].y+6*e[1].y+e[2].y)/6,(e[1].x+6*e[2].x-e[3].x)/6,(e[1].y+6*e[2].y-e[3].y)/6,e[2].x,e[2].y])}return b}function bv(){return this.hex}function bt(a,b,c){function d(){var e=Array.prototype.slice.call(arguments,0),f=e.join("␀"),h=d.cache=d.cache||{},i=d.count=d.count||[];if(h[g](f)){bs(i,f);return c?c(h[f]):h[f]}i.length>=1e3&&delete h[i.shift()],i.push(f),h[f]=a[m](b,e);return c?c(h[f]):h[f]}return d}function bs(a,b){for(var c=0,d=a.length;c<d;c++)if(a[c]===b)return a.push(a.splice(c,1)[0])}function a(c){if(a.is(c,"function"))return b?c():eve.on("DOMload",c);if(a.is(c,E))return a._engine.create[m](a,c.splice(0,3+a.is(c[0],C))).add(c);var d=Array.prototype.slice.call(arguments,0);if(a.is(d[d.length-1],"function")){var e=d.pop();return b?e.call(a._engine.create[m](a,d)):eve.on("DOMload",function(){e.call(a._engine.create[m](a,d))})}return a._engine.create[m](a,arguments)}a.version="2.0.1",a.eve=eve;var b,c=/[, ]+/,d={circle:1,rect:1,path:1,ellipse:1,text:1,image:1},e=/\{(\d+)\}/g,f="prototype",g="hasOwnProperty",h={doc:document,win:window},i={was:Object.prototype[g].call(h.win,"Raphael"),is:h.win.Raphael},j=function(){this.ca=this.customAttributes={}},k,l="appendChild",m="apply",n="concat",o="createTouch"in h.doc,p="",q=" ",r=String,s="split",t="click dblclick mousedown mousemove mouseout mouseover mouseup touchstart touchmove touchend touchcancel"[s](q),u={mousedown:"touchstart",mousemove:"touchmove",mouseup:"touchend"},v=r.prototype.toLowerCase,w=Math,x=w.max,y=w.min,z=w.abs,A=w.pow,B=w.PI,C="number",D="string",E="array",F="toString",G="fill",H=Object.prototype.toString,I={},J="push",K=a._ISURL=/^url\(['"]?([^\)]+?)['"]?\)$/i,L=/^\s*((#[a-f\d]{6})|(#[a-f\d]{3})|rgba?\(\s*([\d\.]+%?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+%?(?:\s*,\s*[\d\.]+%?)?)\s*\)|hsba?\(\s*([\d\.]+(?:deg|\xb0|%)?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+(?:%?\s*,\s*[\d\.]+)?)%?\s*\)|hsla?\(\s*([\d\.]+(?:deg|\xb0|%)?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+(?:%?\s*,\s*[\d\.]+)?)%?\s*\))\s*$/i,M={NaN:1,Infinity:1,"-Infinity":1},N=/^(?:cubic-)?bezier\(([^,]+),([^,]+),([^,]+),([^\)]+)\)/,O=w.round,P="setAttribute",Q=parseFloat,R=parseInt,S=r.prototype.toUpperCase,T=a._availableAttrs={"arrow-end":"none","arrow-start":"none",blur:0,"clip-rect":"0 0 1e9 1e9",cursor:"default",cx:0,cy:0,fill:"#fff","fill-opacity":1,font:'10px "Arial"',"font-family":'"Arial"',"font-size":"10","font-style":"normal","font-weight":400,gradient:0,height:0,href:"http://raphaeljs.com/","letter-spacing":0,opacity:1,path:"M0,0",r:0,rx:0,ry:0,src:"",stroke:"#000","stroke-dasharray":"","stroke-linecap":"butt","stroke-linejoin":"butt","stroke-miterlimit":0,"stroke-opacity":1,"stroke-width":1,target:"_blank","text-anchor":"middle",title:"Raphael",transform:"",width:0,x:0,y:0},U=a._availableAnimAttrs={blur:C,"clip-rect":"csv",cx:C,cy:C,fill:"colour","fill-opacity":C,"font-size":C,height:C,opacity:C,path:"path",r:C,rx:C,ry:C,stroke:"colour","stroke-opacity":C,"stroke-width":C,transform:"transform",width:C,x:C,y:C},V=/\s*,\s*/,W={hs:1,rg:1},X=/,?([achlmqrstvxz]),?/gi,Y=/([achlmrqstvz])[\s,]*((-?\d*\.?\d*(?:e[\-+]?\d+)?\s*,?\s*)+)/ig,Z=/([rstm])[\s,]*((-?\d*\.?\d*(?:e[\-+]?\d+)?\s*,?\s*)+)/ig,$=/(-?\d*\.?\d*(?:e[\-+]?\d+)?)\s*,?\s*/ig,_=a._radial_gradient=/^r(?:\(([^,]+?)\s*,\s*([^\)]+?)\))?/,ba={},bb=function(a,b){return a.key-b.key},bc=function(a,b){return Q(a)-Q(b)},bd=function(){},be=function(a){return a},bf=a._rectPath=function(a,b,c,d,e){if(e)return[["M",a+e,b],["l",c-e*2,0],["a",e,e,0,0,1,e,e],["l",0,d-e*2],["a",e,e,0,0,1,-e,e],["l",e*2-c,0],["a",e,e,0,0,1,-e,-e],["l",0,e*2-d],["a",e,e,0,0,1,e,-e],["z"]];return[["M",a,b],["l",c,0],["l",0,d],["l",-c,0],["z"]]},bg=function(a,b,c,d){d==null&&(d=c);return[["M",a,b],["m",0,-d],["a",c,d,0,1,1,0,2*d],["a",c,d,0,1,1,0,-2*d],["z"]]},bh=a._getPath={path:function(a){return a.attr("path")},circle:function(a){var b=a.attrs;return bg(b.cx,b.cy,b.r)},ellipse:function(a){var b=a.attrs;return bg(b.cx,b.cy,b.rx,b.ry)},rect:function(a){var b=a.attrs;return bf(b.x,b.y,b.width,b.height,b.r)},image:function(a){var b=a.attrs;return bf(b.x,b.y,b.width,b.height)},text:function(a){var b=a._getBBox();return bf(b.x,b.y,b.width,b.height)}},bi=a.mapPath=function(a,b){if(!b)return a;var c,d,e,f,g,h,i;a=bG(a);for(e=0,g=a.length;e<g;e++){i=a[e];for(f=1,h=i.length;f<h;f+=2)c=b.x(i[f],i[f+1]),d=b.y(i[f],i[f+1]),i[f]=c,i[f+1]=d}return a};a._g=h,a.type=h.win.SVGAngle||h.doc.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1")?"SVG":"VML";if(a.type=="VML"){var bj=h.doc.createElement("div"),bk;bj.innerHTML='<v:shape adj="1"/>',bk=bj.firstChild,bk.style.behavior="url(#default#VML)";if(!bk||typeof bk.adj!="object")return a.type=p;bj=null}a.svg=!(a.vml=a.type=="VML"),a._Paper=j,a.fn=k=j.prototype=a.prototype,a._id=0,a._oid=0,a.is=function(a,b){b=v.call(b);if(b=="finite")return!M[g](+a);if(b=="array")return a instanceof Array;return b=="null"&&a===null||b==typeof a&&a!==null||b=="object"&&a===Object(a)||b=="array"&&Array.isArray&&Array.isArray(a)||H.call(a).slice(8,-1).toLowerCase()==b},a.angle=function(b,c,d,e,f,g){if(f==null){var h=b-d,i=c-e;if(!h&&!i)return 0;return(180+w.atan2(-i,-h)*180/B+360)%360}return a.angle(b,c,f,g)-a.angle(d,e,f,g)},a.rad=function(a){return a%360*B/180},a.deg=function(a){return a*180/B%360},a.snapTo=function(b,c,d){d=a.is(d,"finite")?d:10;if(a.is(b,E)){var e=b.length;while(e--)if(z(b[e]-c)<=d)return b[e]}else{b=+b;var f=c%b;if(f<d)return c-f;if(f>b-d)return c-f+b}return c};var bl=a.createUUID=function(a,b){return function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(a,b).toUpperCase()}}(/[xy]/g,function(a){var b=w.random()*16|0,c=a=="x"?b:b&3|8;return c.toString(16)});a.setWindow=function(b){eve("setWindow",a,h.win,b),h.win=b,h.doc=h.win.document,a._engine.initWin&&a._engine.initWin(h.win)};var bm=function(b){if(a.vml){var c=/^\s+|\s+$/g,d;try{var e=new ActiveXObject("htmlfile");e.write("<body>"),e.close(),d=e.body}catch(f){d=createPopup().document.body}var g=d.createTextRange();bm=bt(function(a){try{d.style.color=r(a).replace(c,p);var b=g.queryCommandValue("ForeColor");b=(b&255)<<16|b&65280|(b&16711680)>>>16;return"#"+("000000"+b.toString(16)).slice(-6)}catch(e){return"none"}})}else{var i=h.doc.createElement("i");i.title="Raphaël Colour Picker",i.style.display="none",h.doc.body.appendChild(i),bm=bt(function(a){i.style.color=a;return h.doc.defaultView.getComputedStyle(i,p).getPropertyValue("color")})}return bm(b)},bn=function(){return"hsb("+[this.h,this.s,this.b]+")"},bo=function(){return"hsl("+[this.h,this.s,this.l]+")"},bp=function(){return this.hex},bq=function(b,c,d){c==null&&a.is(b,"object")&&"r"in b&&"g"in b&&"b"in b&&(d=b.b,c=b.g,b=b.r);if(c==null&&a.is(b,D)){var e=a.getRGB(b);b=e.r,c=e.g,d=e.b}if(b>1||c>1||d>1)b/=255,c/=255,d/=255;return[b,c,d]},br=function(b,c,d,e){b*=255,c*=255,d*=255;var f={r:b,g:c,b:d,hex:a.rgb(b,c,d),toString:bp};a.is(e,"finite")&&(f.opacity=e);return f};a.color=function(b){var c;a.is(b,"object")&&"h"in b&&"s"in b&&"b"in b?(c=a.hsb2rgb(b),b.r=c.r,b.g=c.g,b.b=c.b,b.hex=c.hex):a.is(b,"object")&&"h"in b&&"s"in b&&"l"in b?(c=a.hsl2rgb(b),b.r=c.r,b.g=c.g,b.b=c.b,b.hex=c.hex):(a.is(b,"string")&&(b=a.getRGB(b)),a.is(b,"object")&&"r"in b&&"g"in b&&"b"in b?(c=a.rgb2hsl(b),b.h=c.h,b.s=c.s,b.l=c.l,c=a.rgb2hsb(b),b.v=c.b):(b={hex:"none"},b.r=b.g=b.b=b.h=b.s=b.v=b.l=-1)),b.toString=bp;return b},a.hsb2rgb=function(a,b,c,d){this.is(a,"object")&&"h"in a&&"s"in a&&"b"in a&&(c=a.b,b=a.s,a=a.h,d=a.o),a*=360;var e,f,g,h,i;a=a%360/60,i=c*b,h=i*(1-z(a%2-1)),e=f=g=c-i,a=~~a,e+=[i,h,0,0,h,i][a],f+=[h,i,i,h,0,0][a],g+=[0,0,h,i,i,h][a];return br(e,f,g,d)},a.hsl2rgb=function(a,b,c,d){this.is(a,"object")&&"h"in a&&"s"in a&&"l"in a&&(c=a.l,b=a.s,a=a.h);if(a>1||b>1||c>1)a/=360,b/=100,c/=100;a*=360;var e,f,g,h,i;a=a%360/60,i=2*b*(c<.5?c:1-c),h=i*(1-z(a%2-1)),e=f=g=c-i/2,a=~~a,e+=[i,h,0,0,h,i][a],f+=[h,i,i,h,0,0][a],g+=[0,0,h,i,i,h][a];return br(e,f,g,d)},a.rgb2hsb=function(a,b,c){c=bq(a,b,c),a=c[0],b=c[1],c=c[2];var d,e,f,g;f=x(a,b,c),g=f-y(a,b,c),d=g==0?null:f==a?(b-c)/g:f==b?(c-a)/g+2:(a-b)/g+4,d=(d+360)%6*60/360,e=g==0?0:g/f;return{h:d,s:e,b:f,toString:bn}},a.rgb2hsl=function(a,b,c){c=bq(a,b,c),a=c[0],b=c[1],c=c[2];var d,e,f,g,h,i;g=x(a,b,c),h=y(a,b,c),i=g-h,d=i==0?null:g==a?(b-c)/i:g==b?(c-a)/i+2:(a-b)/i+4,d=(d+360)%6*60/360,f=(g+h)/2,e=i==0?0:f<.5?i/(2*f):i/(2-2*f);return{h:d,s:e,l:f,toString:bo}},a._path2string=function(){return this.join(",").replace(X,"$1")};var bu=a._preload=function(a,b){var c=h.doc.createElement("img");c.style.cssText="position:absolute;left:-9999em;top:-9999em",c.onload=function(){b.call(this),this.onload=null,h.doc.body.removeChild(this)},c.onerror=function(){h.doc.body.removeChild(this)},h.doc.body.appendChild(c),c.src=a};a.getRGB=bt(function(b){if(!b||!!((b=r(b)).indexOf("-")+1))return{r:-1,g:-1,b:-1,hex:"none",error:1,toString:bv};if(b=="none")return{r:-1,g:-1,b:-1,hex:"none",toString:bv};!W[g](b.toLowerCase().substring(0,2))&&b.charAt()!="#"&&(b=bm(b));var c,d,e,f,h,i,j,k=b.match(L);if(k){k[2]&&(f=R(k[2].substring(5),16),e=R(k[2].substring(3,5),16),d=R(k[2].substring(1,3),16)),k[3]&&(f=R((i=k[3].charAt(3))+i,16),e=R((i=k[3].charAt(2))+i,16),d=R((i=k[3].charAt(1))+i,16)),k[4]&&(j=k[4][s](V),d=Q(j[0]),j[0].slice(-1)=="%"&&(d*=2.55),e=Q(j[1]),j[1].slice(-1)=="%"&&(e*=2.55),f=Q(j[2]),j[2].slice(-1)=="%"&&(f*=2.55),k[1].toLowerCase().slice(0,4)=="rgba"&&(h=Q(j[3])),j[3]&&j[3].slice(-1)=="%"&&(h/=100));if(k[5]){j=k[5][s](V),d=Q(j[0]),j[0].slice(-1)=="%"&&(d*=2.55),e=Q(j[1]),j[1].slice(-1)=="%"&&(e*=2.55),f=Q(j[2]),j[2].slice(-1)=="%"&&(f*=2.55),(j[0].slice(-3)=="deg"||j[0].slice(-1)=="°")&&(d/=360),k[1].toLowerCase().slice(0,4)=="hsba"&&(h=Q(j[3])),j[3]&&j[3].slice(-1)=="%"&&(h/=100);return a.hsb2rgb(d,e,f,h)}if(k[6]){j=k[6][s](V),d=Q(j[0]),j[0].slice(-1)=="%"&&(d*=2.55),e=Q(j[1]),j[1].slice(-1)=="%"&&(e*=2.55),f=Q(j[2]),j[2].slice(-1)=="%"&&(f*=2.55),(j[0].slice(-3)=="deg"||j[0].slice(-1)=="°")&&(d/=360),k[1].toLowerCase().slice(0,4)=="hsla"&&(h=Q(j[3])),j[3]&&j[3].slice(-1)=="%"&&(h/=100);return a.hsl2rgb(d,e,f,h)}k={r:d,g:e,b:f,toString:bv},k.hex="#"+(16777216|f|e<<8|d<<16).toString(16).slice(1),a.is(h,"finite")&&(k.opacity=h);return k}return{r:-1,g:-1,b:-1,hex:"none",error:1,toString:bv}},a),a.hsb=bt(function(b,c,d){return a.hsb2rgb(b,c,d).hex}),a.hsl=bt(function(b,c,d){return a.hsl2rgb(b,c,d).hex}),a.rgb=bt(function(a,b,c){return"#"+(16777216|c|b<<8|a<<16).toString(16).slice(1)}),a.getColor=function(a){var b=this.getColor.start=this.getColor.start||{h:0,s:1,b:a||.75},c=this.hsb2rgb(b.h,b.s,b.b);b.h+=.075,b.h>1&&(b.h=0,b.s-=.2,b.s<=0&&(this.getColor.start={h:0,s:1,b:b.b}));return c.hex},a.getColor.reset=function(){delete this.start},a.parsePathString=bt(function(b){if(!b)return null;var c={a:7,c:6,h:1,l:2,m:2,r:4,q:4,s:4,t:2,v:1,z:0},d=[];a.is(b,E)&&a.is(b[0],E)&&(d=by(b)),d.length||r(b).replace(Y,function(a,b,e){var f=[],g=b.toLowerCase();e.replace($,function(a,b){b&&f.push(+b)}),g=="m"&&f.length>2&&(d.push([b][n](f.splice(0,2))),g="l",b=b=="m"?"l":"L");if(g=="r")d.push([b][n](f));else while(f.length>=c[g]){d.push([b][n](f.splice(0,c[g])));if(!c[g])break}}),d.toString=a._path2string;return d}),a.parseTransformString=bt(function(b){if(!b)return null;var c={r:3,s:4,t:2,m:6},d=[];a.is(b,E)&&a.is(b[0],E)&&(d=by(b)),d.length||r(b).replace(Z,function(a,b,c){var e=[],f=v.call(b);c.replace($,function(a,b){b&&e.push(+b)}),d.push([b][n](e))}),d.toString=a._path2string;return d}),a.findDotsAtSegment=function(a,b,c,d,e,f,g,h,i){var j=1-i,k=A(j,3),l=A(j,2),m=i*i,n=m*i,o=k*a+l*3*i*c+j*3*i*i*e+n*g,p=k*b+l*3*i*d+j*3*i*i*f+n*h,q=a+2*i*(c-a)+m*(e-2*c+a),r=b+2*i*(d-b)+m*(f-2*d+b),s=c+2*i*(e-c)+m*(g-2*e+c),t=d+2*i*(f-d)+m*(h-2*f+d),u=j*a+i*c,v=j*b+i*d,x=j*e+i*g,y=j*f+i*h,z=90-w.atan2(q-s,r-t)*180/B;(q>s||r<t)&&(z+=180);return{x:o,y:p,m:{x:q,y:r},n:{x:s,y:t},start:{x:u,y:v},end:{x:x,y:y},alpha:z}},a._removedFactory=function(a){return function(){throw new Error("Raphaël: you are calling to method “"+a+"” of removed object")}};var bx=bt(function(a){if(!a)return{x:0,y:0,width:0,height:0};a=bG(a);var b=0,c=0,d=[],e=[],f;for(var g=0,h=a.length;g<h;g++){f=a[g];if(f[0]=="M")b=f[1],c=f[2],d.push(b),e.push(c);else{var i=bF(b,c,f[1],f[2],f[3],f[4],f[5],f[6]);d=d[n](i.min.x,i.max.x),e=e[n](i.min.y,i.max.y),b=f[5],c=f[6]}}var j=y[m](0,d),k=y[m](0,e);return{x:j,y:k,width:x[m](0,d)-j,height:x[m](0,e)-k}},null,function(a){return{x:a.x,y:a.y,width:a.width,height:a.height}}),by=function(b){var c=[];if(!a.is(b,E)||!a.is(b&&b[0],E))b=a.parsePathString(b);for(var d=0,e=b.length;d<e;d++){c[d]=[];for(var f=0,g=b[d].length;f<g;f++)c[d][f]=b[d][f]}c.toString=a._path2string;return c},bz=a._pathToRelative=bt(function(b){if(!a.is(b,E)||!a.is(b&&b[0],E))b=a.parsePathString(b);var c=[],d=0,e=0,f=0,g=0,h=0;b[0][0]=="M"&&(d=b[0][1],e=b[0][2],f=d,g=e,h++,c.push(["M",d,e]));for(var i=h,j=b.length;i<j;i++){var k=c[i]=[],l=b[i];if(l[0]!=v.call(l[0])){k[0]=v.call(l[0]);switch(k[0]){case"a":k[1]=l[1],k[2]=l[2],k[3]=l[3],k[4]=l[4],k[5]=l[5],k[6]=+(l[6]-d).toFixed(3),k[7]=+(l[7]-e).toFixed(3);break;case"v":k[1]=+(l[1]-e).toFixed(3);break;case"m":f=l[1],g=l[2];default:for(var m=1,n=l.length;m<n;m++)k[m]=+(l[m]-(m%2?d:e)).toFixed(3)}}else{k=c[i]=[],l[0]=="m"&&(f=l[1]+d,g=l[2]+e);for(var o=0,p=l.length;o<p;o++)c[i][o]=l[o]}var q=c[i].length;switch(c[i][0]){case"z":d=f,e=g;break;case"h":d+=+c[i][q-1];break;case"v":e+=+c[i][q-1];break;default:d+=+c[i][q-2],e+=+c[i][q-1]}}c.toString=a._path2string;return c},0,by),bA=a._pathToAbsolute=bt(function(b){if(!a.is(b,E)||!a.is(b&&b[0],E))b=a.parsePathString(b);if(!b||!b.length)return[["M",0,0]];var c=[],d=0,e=0,f=0,g=0,h=0;b[0][0]=="M"&&(d=+b[0][1],e=+b[0][2],f=d,g=e,h++,c[0]=["M",d,e]);for(var i,j,k=h,l=b.length;k<l;k++){c.push(i=[]),j=b[k];if(j[0]!=S.call(j[0])){i[0]=S.call(j[0]);switch(i[0]){case"A":i[1]=j[1],i[2]=j[2],i[3]=j[3],i[4]=j[4],i[5]=j[5],i[6]=+(j[6]+d),i[7]=+(j[7]+e);break;case"V":i[1]=+j[1]+e;break;case"H":i[1]=+j[1]+d;break;case"R":var m=[d,e][n](j.slice(1));for(var o=2,p=m.length;o<p;o++)m[o]=+m[o]+d,m[++o]=+m[o]+e;c.pop(),c=c[n](bw(m));break;case"M":f=+j[1]+d,g=+j[2]+e;default:for(o=1,p=j.length;o<p;o++)i[o]=+j[o]+(o%2?d:e)}}else if(j[0]=="R")m=[d,e][n](j.slice(1)),c.pop(),c=c[n](bw(m)),i=["R"][n](j.slice(-2));else for(var q=0,r=j.length;q<r;q++)i[q]=j[q];switch(i[0]){case"Z":d=f,e=g;break;case"H":d=i[1];break;case"V":e=i[1];break;case"M":f=i[i.length-2],g=i[i.length-1];default:d=i[i.length-2],e=i[i.length-1]}}c.toString=a._path2string;return c},null,by),bB=function(a,b,c,d){return[a,b,c,d,c,d]},bC=function(a,b,c,d,e,f){var g=1/3,h=2/3;return[g*a+h*c,g*b+h*d,g*e+h*c,g*f+h*d,e,f]},bD=function(a,b,c,d,e,f,g,h,i,j){var k=B*120/180,l=B/180*(+e||0),m=[],o,p=bt(function(a,b,c){var d=a*w.cos(c)-b*w.sin(c),e=a*w.sin(c)+b*w.cos(c);return{x:d,y:e}});if(!j){o=p(a,b,-l),a=o.x,b=o.y,o=p(h,i,-l),h=o.x,i=o.y;var q=w.cos(B/180*e),r=w.sin(B/180*e),t=(a-h)/2,u=(b-i)/2,v=t*t/(c*c)+u*u/(d*d);v>1&&(v=w.sqrt(v),c=v*c,d=v*d);var x=c*c,y=d*d,A=(f==g?-1:1)*w.sqrt(z((x*y-x*u*u-y*t*t)/(x*u*u+y*t*t))),C=A*c*u/d+(a+h)/2,D=A*-d*t/c+(b+i)/2,E=w.asin(((b-D)/d).toFixed(9)),F=w.asin(((i-D)/d).toFixed(9));E=a<C?B-E:E,F=h<C?B-F:F,E<0&&(E=B*2+E),F<0&&(F=B*2+F),g&&E>F&&(E=E-B*2),!g&&F>E&&(F=F-B*2)}else E=j[0],F=j[1],C=j[2],D=j[3];var G=F-E;if(z(G)>k){var H=F,I=h,J=i;F=E+k*(g&&F>E?1:-1),h=C+c*w.cos(F),i=D+d*w.sin(F),m=bD(h,i,c,d,e,0,g,I,J,[F,H,C,D])}G=F-E;var K=w.cos(E),L=w.sin(E),M=w.cos(F),N=w.sin(F),O=w.tan(G/4),P=4/3*c*O,Q=4/3*d*O,R=[a,b],S=[a+P*L,b-Q*K],T=[h+P*N,i-Q*M],U=[h,i];S[0]=2*R[0]-S[0],S[1]=2*R[1]-S[1];if(j)return[S,T,U][n](m);m=[S,T,U][n](m).join()[s](",");var V=[];for(var W=0,X=m.length;W<X;W++)V[W]=W%2?p(m[W-1],m[W],l).y:p(m[W],m[W+1],l).x;return V},bE=function(a,b,c,d,e,f,g,h,i){var j=1-i;return{x:A(j,3)*a+A(j,2)*3*i*c+j*3*i*i*e+A(i,3)*g,y:A(j,3)*b+A(j,2)*3*i*d+j*3*i*i*f+A(i,3)*h}},bF=bt(function(a,b,c,d,e,f,g,h){var i=e-2*c+a-(g-2*e+c),j=2*(c-a)-2*(e-c),k=a-c,l=(-j+w.sqrt(j*j-4*i*k))/2/i,n=(-j-w.sqrt(j*j-4*i*k))/2/i,o=[b,h],p=[a,g],q;z(l)>"1e12"&&(l=.5),z(n)>"1e12"&&(n=.5),l>0&&l<1&&(q=bE(a,b,c,d,e,f,g,h,l),p.push(q.x),o.push(q.y)),n>0&&n<1&&(q=bE(a,b,c,d,e,f,g,h,n),p.push(q.x),o.push(q.y)),i=f-2*d+b-(h-2*f+d),j=2*(d-b)-2*(f-d),k=b-d,l=(-j+w.sqrt(j*j-4*i*k))/2/i,n=(-j-w.sqrt(j*j-4*i*k))/2/i,z(l)>"1e12"&&(l=.5),z(n)>"1e12"&&(n=.5),l>0&&l<1&&(q=bE(a,b,c,d,e,f,g,h,l),p.push(q.x),o.push(q.y)),n>0&&n<1&&(q=bE(a,b,c,d,e,f,g,h,n),p.push(q.x),o.push(q.y));return{min:{x:y[m](0,p),y:y[m](0,o)},max:{x:x[m](0,p),y:x[m](0,o)}}}),bG=a._path2curve=bt(function(a,b){var c=bA(a),d=b&&bA(b),e={x:0,y:0,bx:0,by:0,X:0,Y:0,qx:null,qy:null},f={x:0,y:0,bx:0,by:0,X:0,Y:0,qx:null,qy:null},g=function(a,b){var c,d;if(!a)return["C",b.x,b.y,b.x,b.y,b.x,b.y];!(a[0]in{T:1,Q:1})&&(b.qx=b.qy=null);switch(a[0]){case"M":b.X=a[1],b.Y=a[2];break;case"A":a=["C"][n](bD[m](0,[b.x,b.y][n](a.slice(1))));break;case"S":c=b.x+(b.x-(b.bx||b.x)),d=b.y+(b.y-(b.by||b.y)),a=["C",c,d][n](a.slice(1));break;case"T":b.qx=b.x+(b.x-(b.qx||b.x)),b.qy=b.y+(b.y-(b.qy||b.y)),a=["C"][n](bC(b.x,b.y,b.qx,b.qy,a[1],a[2]));break;case"Q":b.qx=a[1],b.qy=a[2],a=["C"][n](bC(b.x,b.y,a[1],a[2],a[3],a[4]));break;case"L":a=["C"][n](bB(b.x,b.y,a[1],a[2]));break;case"H":a=["C"][n](bB(b.x,b.y,a[1],b.y));break;case"V":a=["C"][n](bB(b.x,b.y,b.x,a[1]));break;case"Z":a=["C"][n](bB(b.x,b.y,b.X,b.Y))}return a},h=function(a,b){if(a[b].length>7){a[b].shift();var e=a[b];while(e.length)a.splice(b++,0,["C"][n](e.splice(0,6)));a.splice(b,1),k=x(c.length,d&&d.length||0)}},i=function(a,b,e,f,g){a&&b&&a[g][0]=="M"&&b[g][0]!="M"&&(b.splice(g,0,["M",f.x,f.y]),e.bx=0,e.by=0,e.x=a[g][1],e.y=a[g][2],k=x(c.length,d&&d.length||0))};for(var j=0,k=x(c.length,d&&d.length||0);j<k;j++){c[j]=g(c[j],e),h(c,j),d&&(d[j]=g(d[j],f)),d&&h(d,j),i(c,d,e,f,j),i(d,c,f,e,j);var l=c[j],o=d&&d[j],p=l.length,q=d&&o.length;e.x=l[p-2],e.y=l[p-1],e.bx=Q(l[p-4])||e.x,e.by=Q(l[p-3])||e.y,f.bx=d&&(Q(o[q-4])||f.x),f.by=d&&(Q(o[q-3])||f.y),f.x=d&&o[q-2],f.y=d&&o[q-1]}return d?[c,d]:c},null,by),bH=a._parseDots=bt(function(b){var c=[];for(var d=0,e=b.length;d<e;d++){var f={},g=b[d].match(/^([^:]*):?([\d\.]*)/);f.color=a.getRGB(g[1]);if(f.color.error)return null;f.color=f.color.hex,g[2]&&(f.offset=g[2]+"%"),c.push(f)}for(d=1,e=c.length-1;d<e;d++)if(!c[d].offset){var h=Q(c[d-1].offset||0),i=0;for(var j=d+1;j<e;j++)if(c[j].offset){i=c[j].offset;break}i||(i=100,j=e),i=Q(i);var k=(i-h)/(j-d+1);for(;d<j;d++)h+=k,c[d].offset=h+"%"}return c}),bI=a._tear=function(a,b){a==b.top&&(b.top=a.prev),a==b.bottom&&(b.bottom=a.next),a.next&&(a.next.prev=a.prev),a.prev&&(a.prev.next=a.next)},bJ=a._tofront=function(a,b){b.top!==a&&(bI(a,b),a.next=null,a.prev=b.top,b.top.next=a,b.top=a)},bK=a._toback=function(a,b){b.bottom!==a&&(bI(a,b),a.next=b.bottom,a.prev=null,b.bottom.prev=a,b.bottom=a)},bL=a._insertafter=function(a,b,c){bI(a,c),b==c.top&&(c.top=a),b.next&&(b.next.prev=a),a.next=b.next,a.prev=b,b.next=a},bM=a._insertbefore=function(a,b,c){bI(a,c),b==c.bottom&&(c.bottom=a),b.prev&&(b.prev.next=a),a.prev=b.prev,b.prev=a,a.next=b},bN=a._extractTransform=function(b,c){if(c==null)return b._.transform;c=r(c).replace(/\.{3}|\u2026/g,b._.transform||p);var d=a.parseTransformString(c),e=0,f=0,g=0,h=1,i=1,j=b._,k=new bQ;j.transform=d||[];if(d)for(var l=0,m=d.length;l<m;l++){var n=d[l],o=n.length,q=r(n[0]).toLowerCase(),s=n[0]!=q,t=s?k.invert():0,u,v,w,x,y;q=="t"&&o==3?s?(u=t.x(0,0),v=t.y(0,0),w=t.x(n[1],n[2]),x=t.y(n[1],n[2]),k.translate(w-u,x-v)):k.translate(n[1],n[2]):q=="r"?o==2?(y=y||b.getBBox(1),k.rotate(n[1],y.x+y.width/2,y.y+y.height/2),e+=n[1]):o==4&&(s?(w=t.x(n[2],n[3]),x=t.y(n[2],n[3]),k.rotate(n[1],w,x)):k.rotate(n[1],n[2],n[3]),e+=n[1]):q=="s"?o==2||o==3?(y=y||b.getBBox(1),k.scale(n[1],n[o-1],y.x+y.width/2,y.y+y.height/2),h*=n[1],i*=n[o-1]):o==5&&(s?(w=t.x(n[3],n[4]),x=t.y(n[3],n[4]),k.scale(n[1],n[2],w,x)):k.scale(n[1],n[2],n[3],n[4]),h*=n[1],i*=n[2]):q=="m"&&o==7&&k.add(n[1],n[2],n[3],n[4],n[5],n[6]),j.dirtyT=1,b.matrix=k}b.matrix=k,j.sx=h,j.sy=i,j.deg=e,j.dx=f=k.e,j.dy=g=k.f,h==1&&i==1&&!e&&j.bbox?(j.bbox.x+=+f,j.bbox.y+=+g):j.dirtyT=1},bO=function(a){var b=a[0];switch(b.toLowerCase()){case"t":return[b,0,0];case"m":return[b,1,0,0,1,0,0];case"r":return a.length==4?[b,0,a[2],a[3]]:[b,0];case"s":return a.length==5?[b,1,1,a[3],a[4]]:a.length==3?[b,1,1]:[b,1]}},bP=a._equaliseTransform=function(b,c){c=r(c).replace(/\.{3}|\u2026/g,b),b=a.parseTransformString(b)||[],c=a.parseTransformString(c)||[];var d=x(b.length,c.length),e=[],f=[],g=0,h,i,j,k;for(;g<d;g++){j=b[g]||bO(c[g]),k=c[g]||bO(j);if(j[0]!=k[0]||j[0].toLowerCase()=="r"&&(j[2]!=k[2]||j[3]!=k[3])||j[0].toLowerCase()=="s"&&(j[3]!=k[3]||j[4]!=k[4]))return;e[g]=[],f[g]=[];for(h=0,i=x(j.length,k.length);h<i;h++)h in j&&(e[g][h]=j[h]),h in k&&(f[g][h]=k[h])}return{from:e,to:f}};a._getContainer=function(b,c,d,e){var f;f=e==null&&!a.is(b,"object")?h.doc.getElementById(b):b;if(f!=null){if(f.tagName)return c==null?{container:f,width:f.style.pixelWidth||f.offsetWidth,height:f.style.pixelHeight||f.offsetHeight}:{container:f,width:c,height:d};return{container:1,x:b,y:c,width:d,height:e}}},a.pathToRelative=bz,a._engine={},a.path2curve=bG,a.matrix=function(a,b,c,d,e,f){return new bQ(a,b,c,d,e,f)},function(b){function d(a){var b=w.sqrt(c(a));a[0]&&(a[0]/=b),a[1]&&(a[1]/=b)}function c(a){return a[0]*a[0]+a[1]*a[1]}b.add=function(a,b,c,d,e,f){var g=[[],[],[]],h=[[this.a,this.c,this.e],[this.b,this.d,this.f],[0,0,1]],i=[[a,c,e],[b,d,f],[0,0,1]],j,k,l,m;a&&a instanceof bQ&&(i=[[a.a,a.c,a.e],[a.b,a.d,a.f],[0,0,1]]);for(j=0;j<3;j++)for(k=0;k<3;k++){m=0;for(l=0;l<3;l++)m+=h[j][l]*i[l][k];g[j][k]=m}this.a=g[0][0],this.b=g[1][0],this.c=g[0][1],this.d=g[1][1],this.e=g[0][2],this.f=g[1][2]},b.invert=function(){var a=this,b=a.a*a.d-a.b*a.c;return new bQ(a.d/b,-a.b/b,-a.c/b,a.a/b,(a.c*a.f-a.d*a.e)/b,(a.b*a.e-a.a*a.f)/b)},b.clone=function(){return new bQ(this.a,this.b,this.c,this.d,this.e,this.f)},b.translate=function(a,b){this.add(1,0,0,1,a,b)},b.scale=function(a,b,c,d){b==null&&(b=a),(c||d)&&this.add(1,0,0,1,c,d),this.add(a,0,0,b,0,0),(c||d)&&this.add(1,0,0,1,-c,-d)},b.rotate=function(b,c,d){b=a.rad(b),c=c||0,d=d||0;var e=+w.cos(b).toFixed(9),f=+w.sin(b).toFixed(9);this.add(e,f,-f,e,c,d),this.add(1,0,0,1,-c,-d)},b.x=function(a,b){return a*this.a+b*this.c+this.e},b.y=function(a,b){return a*this.b+b*this.d+this.f},b.get=function(a){return+this[r.fromCharCode(97+a)].toFixed(4)},b.toString=function(){return a.svg?"matrix("+[this.get(0),this.get(1),this.get(2),this.get(3),this.get(4),this.get(5)].join()+")":[this.get(0),this.get(2),this.get(1),this.get(3),0,0].join()},b.toFilter=function(){return"progid:DXImageTransform.Microsoft.Matrix(M11="+this.get(0)+", M12="+this.get(2)+", M21="+this.get(1)+", M22="+this.get(3)+", Dx="+this.get(4)+", Dy="+this.get(5)+", sizingmethod='auto expand')"},b.offset=function(){return[this.e.toFixed(4),this.f.toFixed(4)]},b.split=function(){var b={};b.dx=this.e,b.dy=this.f;var e=[[this.a,this.c],[this.b,this.d]];b.scalex=w.sqrt(c(e[0])),d(e[0]),b.shear=e[0][0]*e[1][0]+e[0][1]*e[1][1],e[1]=[e[1][0]-e[0][0]*b.shear,e[1][1]-e[0][1]*b.shear],b.scaley=w.sqrt(c(e[1])),d(e[1]),b.shear/=b.scaley;var f=-e[0][1],g=e[1][1];g<0?(b.rotate=a.deg(w.acos(g)),f<0&&(b.rotate=360-b.rotate)):b.rotate=a.deg(w.asin(f)),b.isSimple=!+b.shear.toFixed(9)&&(b.scalex.toFixed(9)==b.scaley.toFixed(9)||!b.rotate),b.isSuperSimple=!+b.shear.toFixed(9)&&b.scalex.toFixed(9)==b.scaley.toFixed(9)&&!b.rotate,b.noRotation=!+b.shear.toFixed(9)&&!b.rotate;return b},b.toTransformString=function(a){var b=a||this[s]();if(b.isSimple){b.scalex=+b.scalex.toFixed(4),b.scaley=+b.scaley.toFixed(4),b.rotate=+b.rotate.toFixed(4);return(b.dx&&b.dy?"t"+[b.dx,b.dy]:p)+(b.scalex!=1||b.scaley!=1?"s"+[b.scalex,b.scaley,0,0]:p)+(b.rotate?"r"+[b.rotate,0,0]:p)}return"m"+[this.get(0),this.get(1),this.get(2),this.get(3),this.get(4),this.get(5)]}}(bQ.prototype);var bR=navigator.userAgent.match(/Version\/(.*?)\s/)||navigator.userAgent.match(/Chrome\/(\d+)/);navigator.vendor=="Apple Computer, Inc."&&(bR&&bR[1]<4||navigator.platform.slice(0,2)=="iP")||navigator.vendor=="Google Inc."&&bR&&bR[1]<8?k.safari=function(){var a=this.rect(-99,-99,this.width+99,this.height+99).attr({stroke:"none"});setTimeout(function(){a.remove()})}:k.safari=bd;var bS=function(){this.returnValue=!1},bT=function(){return this.originalEvent.preventDefault()},bU=function(){this.cancelBubble=!0},bV=function(){return this.originalEvent.stopPropagation()},bW=function(){if(h.doc.addEventListener)return function(a,b,c,d){var e=o&&u[b]?u[b]:b,f=function(e){var f=h.doc.documentElement.scrollTop||h.doc.body.scrollTop,i=h.doc.documentElement.scrollLeft||h.doc.body.scrollLeft,j=e.clientX+i,k=e.clientY+f;if(o&&u[g](b))for(var l=0,m=e.targetTouches&&e.targetTouches.length;l<m;l++)if(e.targetTouches[l].target==a){var n=e;e=e.targetTouches[l],e.originalEvent=n,e.preventDefault=bT,e.stopPropagation=bV;break}return c.call(d,e,j,k)};a.addEventListener(e,f,!1);return function(){a.removeEventListener(e,f,!1);return!0}};if(h.doc.attachEvent)return function(a,b,c,d){var e=function(a){a=a||h.win.event;var b=h.doc.documentElement.scrollTop||h.doc.body.scrollTop,e=h.doc.documentElement.scrollLeft||h.doc.body.scrollLeft,f=a.clientX+e,g=a.clientY+b;a.preventDefault=a.preventDefault||bS,a.stopPropagation=a.stopPropagation||bU;return c.call(d,a,f,g)};a.attachEvent("on"+b,e);var f=function(){a.detachEvent("on"+b,e);return!0};return f}}(),bX=[],bY=function(a){var b=a.clientX,c=a.clientY,d=h.doc.documentElement.scrollTop||h.doc.body.scrollTop,e=h.doc.documentElement.scrollLeft||h.doc.body.scrollLeft,f,g=bX.length;while(g--){f=bX[g];if(o){var i=a.touches.length,j;while(i--){j=a.touches[i];if(j.identifier==f.el._drag.id){b=j.clientX,c=j.clientY,(a.originalEvent?a.originalEvent:a).preventDefault();break}}}else a.preventDefault();var k=f.el.node,l,m=k.nextSibling,n=k.parentNode,p=k.style.display;h.win.opera&&n.removeChild(k),k.style.display="none",l=f.el.paper.getElementByPoint(b,c),k.style.display=p,h.win.opera&&(m?n.insertBefore(k,m):n.appendChild(k)),l&&eve("drag.over."+f.el.id,f.el,l),b+=e,c+=d,eve("drag.move."+f.el.id,f.move_scope||f.el,b-f.el._drag.x,c-f.el._drag.y,b,c,a)}},bZ=function(b){a.unmousemove(bY).unmouseup(bZ);var c=bX.length,d;while(c--)d=bX[c],d.el._drag={},eve("drag.end."+d.el.id,d.end_scope||d.start_scope||d.move_scope||d.el,b);bX=[]},b$=a.el={};for(var b_=t.length;b_--;)(function(b){a[b]=b$[b]=function(c,d){a.is(c,"function")&&(this.events=this.events||[],this.events.push({name:b,f:c,unbind:bW(this.shape||this.node||h.doc,b,c,d||this)}));return this},a["un"+b]=b$["un"+b]=function(a){var c=this.events,d=c.length;while(d--)if(c[d].name==b&&c[d].f==a){c[d].unbind(),c.splice(d,1),!c.length&&delete this.events;return this}return this}})(t[b_]);b$.data=function(b,c){var d=ba[this.id]=ba[this.id]||{};if(arguments.length==1){if(a.is(b,"object")){for(var e in b)b[g](e)&&this.data(e,b[e]);return this}eve("data.get."+this.id,this,d[b],b);return d[b]}d[b]=c,eve("data.set."+this.id,this,c,b);return this},b$.removeData=function(a){a==null?ba[this.id]={}:ba[this.id]&&delete ba[this.id][a];return this},b$.hover=function(a,b,c,d){return this.mouseover(a,c).mouseout(b,d||c)},b$.unhover=function(a,b){return this.unmouseover(a).unmouseout(b)};var ca=[];b$.drag=function(b,c,d,e,f,g){function i(i){(i.originalEvent||i).preventDefault();var j=h.doc.documentElement.scrollTop||h.doc.body.scrollTop,k=h.doc.documentElement.scrollLeft||h.doc.body.scrollLeft;this._drag.x=i.clientX+k,this._drag.y=i.clientY+j,this._drag.id=i.identifier,!bX.length&&a.mousemove(bY).mouseup(bZ),bX.push({el:this,move_scope:e,start_scope:f,end_scope:g}),c&&eve.on("drag.start."+this.id,c),b&&eve.on("drag.move."+this.id,b),d&&eve.on("drag.end."+this.id,d),eve("drag.start."+this.id,f||e||this,i.clientX+k,i.clientY+j,i)}this._drag={},ca.push({el:this,start:i}),this.mousedown(i);return this},b$.onDragOver=function(a){a?eve.on("drag.over."+this.id,a):eve.unbind("drag.over."+this.id)},b$.undrag=function(){var b=ca.length;while(b--)ca[b].el==this&&(this.unmousedown(ca[b].start),ca.splice(b,1),eve.unbind("drag.*."+this.id));!ca.length&&a.unmousemove(bY).unmouseup(bZ)},k.circle=function(b,c,d){var e=a._engine.circle(this,b||0,c||0,d||0);this.__set__&&this.__set__.push(e);return e},k.rect=function(b,c,d,e,f){var g=a._engine.rect(this,b||0,c||0,d||0,e||0,f||0);this.__set__&&this.__set__.push(g);return g},k.ellipse=function(b,c,d,e){var f=a._engine.ellipse(this,b||0,c||0,d||0,e||0);this.__set__&&this.__set__.push(f);return f},k.path=function(b){b&&!a.is(b,D)&&!a.is(b[0],E)&&(b+=p);var c=a._engine.path(a.format[m](a,arguments),this);this.__set__&&this.__set__.push(c);return c},k.image=function(b,c,d,e,f){var g=a._engine.image(this,b||"about:blank",c||0,d||0,e||0,f||0);this.__set__&&this.__set__.push(g);return g},k.text=function(b,c,d){var e=a._engine.text(this,b||0,c||0,r(d));this.__set__&&this.__set__.push(e);return e},k.set=function(b){!a.is(b,"array")&&(b=Array.prototype.splice.call(arguments,0,arguments.length));var c=new cs(b);this.__set__&&this.__set__.push(c);return c},k.setStart=function(a){this.__set__=a||this.set()},k.setFinish=function(a){var b=this.__set__;delete this.__set__;return b},k.setSize=function(b,c){return a._engine.setSize.call(this,b,c)},k.setViewBox=function(b,c,d,e,f){return a._engine.setViewBox.call(this,b,c,d,e,f)},k.top=k.bottom=null,k.raphael=a;var cb=function(a){var b=a.getBoundingClientRect(),c=a.ownerDocument,d=c.body,e=c.documentElement,f=e.clientTop||d.clientTop||0,g=e.clientLeft||d.clientLeft||0,i=b.top+(h.win.pageYOffset||e.scrollTop||d.scrollTop)-f,j=b.left+(h.win.pageXOffset||e.scrollLeft||d.scrollLeft)-g;return{y:i,x:j}};k.getElementByPoint=function(a,b){var c=this,d=c.canvas,e=h.doc.elementFromPoint(a,b);if(h.win.opera&&e.tagName=="svg"){var f=cb(d),g=d.createSVGRect();g.x=a-f.x,g.y=b-f.y,g.width=g.height=1;var i=d.getIntersectionList(g,null);i.length&&(e=i[i.length-1])}if(!e)return null;while(e.parentNode&&e!=d.parentNode&&!e.raphael)e=e.parentNode;e==c.canvas.parentNode&&(e=d),e=e&&e.raphael?c.getById(e.raphaelid):null;return e},k.getById=function(a){var b=this.bottom;while(b){if(b.id==a)return b;b=b.next}return null},k.forEach=function(a,b){var c=this.bottom;while(c){if(a.call(b,c)===!1)return this;c=c.next}return this},b$.getBBox=function(a){if(this.removed)return{};var b=this._;if(a){if(b.dirty||!b.bboxwt)this.realPath=bh[this.type](this),b.bboxwt=bx(this.realPath),b.bboxwt.toString=cd,b.dirty=0;return b.bboxwt}if(b.dirty||b.dirtyT||!b.bbox){if(b.dirty||!this.realPath)b.bboxwt=0,this.realPath=bh[this.type](this);b.bbox=bx(bi(this.realPath,this.matrix)),b.bbox.toString=cd,b.dirty=b.dirtyT=0}return b.bbox},b$.clone=function(){if(this.removed)return null;var a=this.paper[this.type]().attr(this.attr());this.__set__&&this.__set__.push(a);return a},b$.glow=function(a){if(this.type=="text")return null;a=a||{};var b={width:(a.width||10)+(+this.attr("stroke-width")||1),fill:a.fill||!1,opacity:a.opacity||.5,offsetx:a.offsetx||0,offsety:a.offsety||0,color:a.color||"#000"},c=b.width/2,d=this.paper,e=d.set(),f=this.realPath||bh[this.type](this);f=this.matrix?bi(f,this.matrix):f;for(var g=1;g<c+1;g++)e.push(d.path(f).attr({stroke:b.color,fill:b.fill?b.color:"none","stroke-linejoin":"round","stroke-linecap":"round","stroke-width":+(b.width/c*g).toFixed(3),opacity:+(b.opacity/c).toFixed(3)}));return e.insertBefore(this).translate(b.offsetx,b.offsety)};var ce={},cf=function(b,c,d,e,f,g,h,i,j){var k=0,l=100,m=[b,c,d,e,f,g,h,i].join(),n=ce[m],o,p;!n&&(ce[m]=n={data:[]}),n.timer&&clearTimeout(n.timer),n.timer=setTimeout(function(){delete ce[m]},2e3);if(j!=null&&!n.precision){var q=cf(b,c,d,e,f,g,h,i);n.precision=~~q*10,n.data=[]}l=n.precision||l;for(var r=0;r<l+1;r++){n.data[r*l]?p=n.data[r*l]:(p=a.findDotsAtSegment(b,c,d,e,f,g,h,i,r/l),n.data[r*l]=p),r&&(k+=A(A(o.x-p.x,2)+A(o.y-p.y,2),.5));if(j!=null&&k>=j)return p;o=p}if(j==null)return k},cg=function(b,c){return function(d,e,f){d=bG(d);var g,h,i,j,k="",l={},m,n=0;for(var o=0,p=d.length;o<p;o++){i=d[o];if(i[0]=="M")g=+i[1],h=+i[2];else{j=cf(g,h,i[1],i[2],i[3],i[4],i[5],i[6]);if(n+j>e){if(c&&!l.start){m=cf(g,h,i[1],i[2],i[3],i[4],i[5],i[6],e-n),k+=["C"+m.start.x,m.start.y,m.m.x,m.m.y,m.x,m.y];if(f)return k;l.start=k,k=["M"+m.x,m.y+"C"+m.n.x,m.n.y,m.end.x,m.end.y,i[5],i[6]].join(),n+=j,g=+i[5],h=+i[6];continue}if(!b&&!c){m=cf(g,h,i[1],i[2],i[3],i[4],i[5],i[6],e-n);return{x:m.x,y:m.y,alpha:m.alpha}}}n+=j,g=+i[5],h=+i[6]}k+=i.shift()+i}l.end=k,m=b?n:c?l:a.findDotsAtSegment(g,h,i[0],i[1],i[2],i[3],i[4],i[5],1),m.alpha&&(m={x:m.x,y:m.y,alpha:m.alpha});return m}},ch=cg(1),ci=cg(),cj=cg(0,1);a.getTotalLength=ch,a.getPointAtLength=ci,a.getSubpath=function(a,b,c){if(this.getTotalLength(a)-c<1e-6)return cj(a,b).end;var d=cj(a,c,1);return b?cj(d,b).end:d},b$.getTotalLength=function(){if(this.type=="path"){if(this.node.getTotalLength)return this.node.getTotalLength();return ch(this.attrs.path)}},b$.getPointAtLength=function(a){if(this.type=="path")return ci(this.attrs.path,a)},b$.getSubpath=function(b,c){if(this.type=="path")return a.getSubpath(this.attrs.path,b,c)};var ck=a.easing_formulas={linear:function(a){return a},"<":function(a){return A(a,1.7)},">":function(a){return A(a,.48)},"<>":function(a){var b=.48-a/1.04,c=w.sqrt(.1734+b*b),d=c-b,e=A(z(d),1/3)*(d<0?-1:1),f=-c-b,g=A(z(f),1/3)*(f<0?-1:1),h=e+g+.5;return(1-h)*3*h*h+h*h*h},backIn:function(a){var b=1.70158;return a*a*((b+1)*a-b)},backOut:function(a){a=a-1;var b=1.70158;return a*a*((b+1)*a+b)+1},elastic:function(a){if(a==!!a)return a;return A(2,-10*a)*w.sin((a-.075)*2*B/.3)+1},bounce:function(a){var b=7.5625,c=2.75,d;a<1/c?d=b*a*a:a<2/c?(a-=1.5/c,d=b*a*a+.75):a<2.5/c?(a-=2.25/c,d=b*a*a+.9375):(a-=2.625/c,d=b*a*a+.984375);return d}};ck.easeIn=ck["ease-in"]=ck["<"],ck.easeOut=ck["ease-out"]=ck[">"],ck.easeInOut=ck["ease-in-out"]=ck["<>"],ck["back-in"]=ck.backIn,ck["back-out"]=ck.backOut;var cl=[],cm=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(a){setTimeout(a,16)},cn=function(){var b=+(new Date),c=0;for(;c<cl.length;c++){var d=cl[c];if(d.el.removed||d.paused)continue;var e=b-d.start,f=d.ms,h=d.easing,i=d.from,j=d.diff,k=d.to,l=d.t,m=d.el,o={},p,r={},s;d.initstatus?(e=(d.initstatus*d.anim.top-d.prev)/(d.percent-d.prev)*f,d.status=d.initstatus,delete d.initstatus,d.stop&&cl.splice(c--,1)):d.status=(d.prev+(d.percent-d.prev)*(e/f))/d.anim.top;if(e<0)continue;if(e<f){var t=h(e/f);for(var u in i)if(i[g](u)){switch(U[u]){case C:p=+i[u]+t*f*j[u];break;case"colour":p="rgb("+[co(O(i[u].r+t*f*j[u].r)),co(O(i[u].g+t*f*j[u].g)),co(O(i[u].b+t*f*j[u].b))].join(",")+")";break;case"path":p=[];for(var v=0,w=i[u].length;v<w;v++){p[v]=[i[u][v][0]];for(var x=1,y=i[u][v].length;x<y;x++)p[v][x]=+i[u][v][x]+t*f*j[u][v][x];p[v]=p[v].join(q)}p=p.join(q);break;case"transform":if(j[u].real){p=[];for(v=0,w=i[u].length;v<w;v++){p[v]=[i[u][v][0]];for(x=1,y=i[u][v].length;x<y;x++)p[v][x]=i[u][v][x]+t*f*j[u][v][x]}}else{var z=function(a){return+i[u][a]+t*f*j[u][a]};p=[["m",z(0),z(1),z(2),z(3),z(4),z(5)]]}break;case"csv":if(u=="clip-rect"){p=[],v=4;while(v--)p[v]=+i[u][v]+t*f*j[u][v]}break;default:var A=[][n](i[u]);p=[],v=m.paper.customAttributes[u].length;while(v--)p[v]=+A[v]+t*f*j[u][v]}o[u]=p}m.attr(o),function(a,b,c){setTimeout(function(){eve("anim.frame."+a,b,c)})}(m.id,m,d.anim)}else{(function(b,c,d){setTimeout(function(){eve("anim.frame."+c.id,c,d),eve("anim.finish."+c.id,c,d),a.is(b,"function")&&b.call(c)})})(d.callback,m,d.anim),m.attr(k),cl.splice(c--,1);if(d.repeat>1&&!d.next){for(s in k)k[g](s)&&(r[s]=d.totalOrigin[s]);d.el.attr(r),cr(d.anim,d.el,d.anim.percents[0],null,d.totalOrigin,d.repeat-1)}d.next&&!d.stop&&cr(d.anim,d.el,d.next,null,d.totalOrigin,d.repeat)}}a.svg&&m&&m.paper&&m.paper.safari(),cl.length&&cm(cn)},co=function(a){return a>255?255:a<0?0:a};b$.animateWith=function(b,c,d,e,f,g){var h=d?a.animation(d,e,f,g):c,i=b.status(c);return this.animate(h).status(h,i*c.ms/h.ms)},b$.onAnimation=function(a){a?eve.on("anim.frame."+this.id,a):eve.unbind("anim.frame."+this.id);return this},cq.prototype.delay=function(a){var b=new cq(this.anim,this.ms);b.times=this.times,b.del=+a||0;return b},cq.prototype.repeat=function(a){var b=new cq(this.anim,this.ms);b.del=this.del,b.times=w.floor(x(a,0))||1;return b},a.animation=function(b,c,d,e){if(b instanceof cq)return b;if(a.is(d,"function")||!d)e=e||d||null,d=null;b=Object(b),c=+c||0;var f={},h,i;for(i in b)b[g](i)&&Q(i)!=i&&Q(i)+"%"!=i&&(h=!0,f[i]=b[i]);if(!h)return new cq(b,c);d&&(f.easing=d),e&&(f.callback=e);return new cq({100:f},c)},b$.animate=function(b,c,d,e){var f=this;if(f.removed){e&&e.call(f);return f}var g=b instanceof cq?b:a.animation(b,c,d,e);cr(g,f,g.percents[0],null,f.attr());return f},b$.setTime=function(a,b){a&&b!=null&&this.status(a,y(b,a.ms)/a.ms);return this},b$.status=function(a,b){var c=[],d=0,e,f;if(b!=null){cr(a,this,-1,y(b,1));return this}e=cl.length;for(;d<e;d++){f=cl[d];if(f.el.id==this.id&&(!a||f.anim==a)){if(a)return f.status;c.push({anim:f.anim,status:f.status})}}if(a)return 0;return c},b$.pause=function(a){for(var b=0;b<cl.length;b++)cl[b].el.id==this.id&&(!a||cl[b].anim==a)&&eve("anim.pause."+this.id,this,cl[b].anim)!==!1&&(cl[b].paused=!0);return this},b$.resume=function(a){for(var b=0;b<cl.length;b++)if(cl[b].el.id==this.id&&(!a||cl[b].anim==a)){var c=cl[b];eve("anim.resume."+this.id,this,c.anim)!==!1&&(delete c.paused,this.status(c.anim,c.status))}return this},b$.stop=function(a){for(var b=0;b<cl.length;b++)cl[b].el.id==this.id&&(!a||cl[b].anim==a)&&eve("anim.stop."+this.id,this,cl[b].anim)!==!1&&cl.splice(b--,1);return this},b$.toString=function(){return"Raphaël’s object"};var cs=function(a){this.items=[],this.length=0,this.type="set";if(a)for(var b=0,c=a.length;b<c;b++)a[b]&&(a[b].constructor==b$.constructor||a[b].constructor==cs)&&(this[this.items.length]=this.items[this.items.length]=a[b],this.length++)},ct=cs.prototype;ct.push=function(){var a,b;for(var c=0,d=arguments.length;c<d;c++)a=arguments[c],a&&(a.constructor==b$.constructor||a.constructor==cs)&&(b=this.items.length,this[b]=this.items[b]=a,this.length++);return this},ct.pop=function(){this.length&&delete this[this.length--];return this.items.pop()},ct.forEach=function(a,b){for(var c=0,d=this.items.length;c<d;c++)if(a.call(b,this.items[c],c)===!1)return this;return this};for(var cu in b$)b$[g](cu)&&(ct[cu]=function(a){return function(){var b=arguments;return this.forEach(function(c){c[a][m](c,b)})}}(cu));ct.attr=function(b,c){if(b&&a.is(b,E)&&a.is(b[0],"object"))for(var d=0,e=b.length;d<e;d++)this.items[d].attr(b[d]);else for(var f=0,g=this.items.length;f<g;f++)this.items[f].attr(b,c);return this},ct.clear=function(){while(this.length)this.pop()},ct.splice=function(a,b,c){a=a<0?x(this.length+a,0):a,b=x(0,y(this.length-a,b));var d=[],e=[],f=[],g;for(g=2;g<arguments.length;g++)f.push(arguments[g]);for(g=0;g<b;g++)e.push(this[a+g]);for(;g<this.length-a;g++)d.push(this[a+g]);var h=f.length;for(g=0;g<h+d.length;g++)this.items[a+g]=this[a+g]=g<h?f[g]:d[g-h];g=this.items.length=this.length-=b-h;while(this[g])delete this[g++];return new cs(e)},ct.exclude=function(a){for(var b=0,c=this.length;b<c;b++)if(this[b]==a){this.splice(b,1);return!0}},ct.animate=function(b,c,d,e){(a.is(d,"function")||!d)&&(e=d||null);var f=this.items.length,g=f,h,i=this,j;if(!f)return this;e&&(j=function(){!--f&&e.call(i)}),d=a.is(d,D)?d:j;var k=a.animation(b,c,d,j);h=this.items[--g].animate(k);while(g--)this.items[g]&&!this.items[g].removed&&this.items[g].animateWith(h,k);return this},ct.insertAfter=function(a){var b=this.items.length;while(b--)this.items[b].insertAfter(a);return this},ct.getBBox=function(){var a=[],b=[],c=[],d=[];for(var e=this.items.length;e--;)if(!this.items[e].removed){var f=this.items[e].getBBox();a.push(f.x),b.push(f.y),c.push(f.x+f.width),d.push(f.y+f.height)}a=y[m](0,a),b=y[m](0,b);return{x:a,y:b,width:x[m](0,c)-a,height:x[m](0,d)-b}},ct.clone=function(a){a=new cs;for(var b=0,c=this.items.length;b<c;b++)a.push(this.items[b].clone());return a},ct.toString=function(){return"Raphaël‘s set"},a.registerFont=function(a){if(!a.face)return a;this.fonts=this.fonts||{};var b={w:a.w,face:{},glyphs:{}},c=a.face["font-family"];for(var d in a.face)a.face[g](d)&&(b.face[d]=a.face[d]);this.fonts[c]?this.fonts[c].push(b):this.fonts[c]=[b];if(!a.svg){b.face["units-per-em"]=R(a.face["units-per-em"],10);for(var e in a.glyphs)if(a.glyphs[g](e)){var f=a.glyphs[e];b.glyphs[e]={w:f.w,k:{},d:f.d&&"M"+f.d.replace(/[mlcxtrv]/g,function(a){return{l:"L",c:"C",x:"z",t:"m",r:"l",v:"c"}[a]||"M"})+"z"};if(f.k)for(var h in f.k)f[g](h)&&(b.glyphs[e].k[h]=f.k[h])}}return a},k.getFont=function(b,c,d,e){e=e||"normal",d=d||"normal",c=+c||{normal:400,bold:700,lighter:300,bolder:800}[c]||400;if(!!a.fonts){var f=a.fonts[b];if(!f){var h=new RegExp("(^|\\s)"+b.replace(/[^\w\d\s+!~.:_-]/g,p)+"(\\s|$)","i");for(var i in a.fonts)if(a.fonts[g](i)&&h.test(i)){f=a.fonts[i];break}}var j;if(f)for(var k=0,l=f.length;k<l;k++){j=f[k];if(j.face["font-weight"]==c&&(j.face["font-style"]==d||!j.face["font-style"])&&j.face["font-stretch"]==e)break}return j}},k.print=function(b,d,e,f,g,h,i){h=h||"middle",i=x(y(i||0,1),-1);var j=this.set(),k=r(e)[s](p),l=0,m=p,n;a.is(f,e)&&(f=this.getFont(f));if(f){n=(g||16)/f.face["units-per-em"];var o=f.face.bbox[s](c),q=+o[0],t=+o[1]+(h=="baseline"?o[3]-o[1]+ +f.face.descent:(o[3]-o[1])/2);for(var u=0,v=k.length;u<v;u++){var w=u&&f.glyphs[k[u-1]]||{},z=f.glyphs[k[u]];l+=u?(w.w||f.w)+(w.k&&w.k[k[u]]||0)+f.w*i:0,z&&z.d&&j.push(this.path(z.d).attr({fill:"#000",stroke:"none",transform:[["t",l*n,0]]}))}j.transform(["...s",n,n,q,t,"t",(b-q)/n,(d-t)/n])}return j},k.add=function(b){if(a.is(b,"array")){var c=this.set(),e=0,f=b.length,h;for(;e<f;e++)h=b[e]||{},d[g](h.type)&&c.push(this[h.type]().attr(h))}return c},a.format=function(b,c){var d=a.is(c,E)?[0][n](c):arguments;b&&a.is(b,D)&&d.length-1&&(b=b.replace(e,function(a,b){return d[++b]==null?p:d[b]}));return b||p},a.fullfill=function(){var a=/\{([^\}]+)\}/g,b=/(?:(?:^|\.)(.+?)(?=\[|\.|$|\()|\[('|")(.+?)\2\])(\(\))?/g,c=function(a,c,d){var e=d;c.replace(b,function(a,b,c,d,f){b=b||d,e&&(b in e&&(e=e[b]),typeof e=="function"&&f&&(e=e()))}),e=(e==null||e==d?a:e)+"";return e};return function(b,d){return String(b).replace(a,function(a,b){return c(a,b,d)})}}(),a.ninja=function(){i.was?h.win.Raphael=i.is:delete Raphael;return a},a.st=ct,function(b,c,d){function e(){/in/.test(b.readyState)?setTimeout(e,9):a.eve("DOMload")}b.readyState==null&&b.addEventListener&&(b.addEventListener(c,d=function(){b.removeEventListener(c,d,!1),b.readyState="complete"},!1),b.readyState="loading"),e()}(document,"DOMContentLoaded"),i.was?h.win.Raphael=a:Raphael=a,eve.on("DOMload",function(){b=!0})}(),window.Raphael.svg&&function(a){var b="hasOwnProperty",c=String,d=parseFloat,e=parseInt,f=Math,g=f.max,h=f.abs,i=f.pow,j=/[, ]+/,k=a.eve,l="",m=" ",n="http://www.w3.org/1999/xlink",o={block:"M5,0 0,2.5 5,5z",classic:"M5,0 0,2.5 5,5 3.5,3 3.5,2z",diamond:"M2.5,0 5,2.5 2.5,5 0,2.5z",open:"M6,1 1,3.5 6,6",oval:"M2.5,0A2.5,2.5,0,0,1,2.5,5 2.5,2.5,0,0,1,2.5,0z"},p={};a.toString=function(){return"Your browser supports SVG.\nYou are running Raphaël "+this.version};var q=function(d,e){if(e){typeof d=="string"&&(d=q(d));for(var f in e)e[b](f)&&(f.substring(0,6)=="xlink:"?d.setAttributeNS(n,f.substring(6),c(e[f])):d.setAttribute(f,c(e[f])))}else d=a._g.doc.createElementNS("http://www.w3.org/2000/svg",d),d.style&&(d.style.webkitTapHighlightColor="rgba(0,0,0,0)");return d},r=function(b,e){var j="linear",k=b.id+e,m=.5,n=.5,o=b.node,p=b.paper,r=o.style,s=a._g.doc.getElementById(k);if(!s){e=c(e).replace(a._radial_gradient,function(a,b,c){j="radial";if(b&&c){m=d(b),n=d(c);var e=(n>.5)*2-1;i(m-.5,2)+i(n-.5,2)>.25&&(n=f.sqrt(.25-i(m-.5,2))*e+.5)&&n!=.5&&(n=n.toFixed(5)-1e-5*e)}return l}),e=e.split(/\s*\-\s*/);if(j=="linear"){var t=e.shift();t=-d(t);if(isNaN(t))return null;var u=[0,0,f.cos(a.rad(t)),f.sin(a.rad(t))],v=1/(g(h(u[2]),h(u[3]))||1);u[2]*=v,u[3]*=v,u[2]<0&&(u[0]=-u[2],u[2]=0),u[3]<0&&(u[1]=-u[3],u[3]=0)}var w=a._parseDots(e);if(!w)return null;k=k.replace(/[\(\)\s,\xb0#]/g,"_"),b.gradient&&k!=b.gradient.id&&(p.defs.removeChild(b.gradient),delete b.gradient);if(!b.gradient){s=q(j+"Gradient",{id:k}),b.gradient=s,q(s,j=="radial"?{fx:m,fy:n}:{x1:u[0],y1:u[1],x2:u[2],y2:u[3],gradientTransform:b.matrix.invert()}),p.defs.appendChild(s);for(var x=0,y=w.length;x<y;x++)s.appendChild(q("stop",{offset:w[x].offset?w[x].offset:x?"100%":"0%","stop-color":w[x].color||"#fff"}))}}q(o,{fill:"url(#"+k+")",opacity:1,"fill-opacity":1}),r.fill=l,r.opacity=1,r.fillOpacity=1;return 1},s=function(a){var b=a.getBBox(1);q(a.pattern,{patternTransform:a.matrix.invert()+" translate("+b.x+","+b.y+")"})},t=function(d,e,f){if(d.type=="path"){var g=c(e).toLowerCase().split("-"),h=d.paper,i=f?"end":"start",j=d.node,k=d.attrs,l=k["stroke-width"],n=g.length,r="classic",s,t,u,v,w,x=3,y=3,z=5;while(n--)switch(g[n]){case"block":case"classic":case"oval":case"diamond":case"open":case"none":r=g[n];break;case"wide":y=5;break;case"narrow":y=2;break;case"long":x=5;break;case"short":x=2}r=="open"?(x+=2,y+=2,z+=2,u=1,v=f?4:1,w={fill:"none",stroke:k.stroke}):(v=u=x/2,w={fill:k.stroke,stroke:"none"}),d._.arrows?f?(d._.arrows.endPath&&p[d._.arrows.endPath]--,d._.arrows.endMarker&&p[d._.arrows.endMarker]--):(d._.arrows.startPath&&p[d._.arrows.startPath]--,d._.arrows.startMarker&&p[d._.arrows.startMarker]--):d._.arrows={};if(r!="none"){var A="raphael-marker-"+r,B="raphael-marker-"+i+r+x+y;a._g.doc.getElementById(A)?p[A]++:(h.defs.appendChild(q(q("path"),{"stroke-linecap":"round",d:o[r],id:A})),p[A]=1);var C=a._g.doc.getElementById(B),D;C?(p[B]++,D=C.getElementsByTagName("use")[0]):(C=q(q("marker"),{id:B,markerHeight:y,markerWidth:x,orient:"auto",refX:v,refY:y/2}),D=q(q("use"),{"xlink:href":"#"+A,transform:(f?" rotate(180 "+x/2+" "+y/2+") ":m)+"scale("+x/z+","+y/z+")","stroke-width":1/((x/z+y/z)/2)}),C.appendChild(D),h.defs.appendChild(C),p[B]=1),q(D,w);var E=u*(r!="diamond"&&r!="oval");f?(s=d._.arrows.startdx*l||0,t=a.getTotalLength(k.path)-E*l):(s=E*l,t=a.getTotalLength(k.path)-(d._.arrows.enddx*l||0)),w={},w["marker-"+i]="url(#"+B+")";if(t||s)w.d=Raphael.getSubpath(k.path,s,t);q(j,w),d._.arrows[i+"Path"]=A,d._.arrows[i+"Marker"]=B,d._.arrows[i+"dx"]=E,d._.arrows[i+"Type"]=r,d._.arrows[i+"String"]=e}else f?(s=d._.arrows.startdx*l||0,t=a.getTotalLength(k.path)-s):(s=0,t=a.getTotalLength(k.path)-(d._.arrows.enddx*l||0)),d._.arrows[i+"Path"]&&q(j,{d:Raphael.getSubpath(k.path,s,t)}),delete d._.arrows[i+"Path"],delete d._.arrows[i+"Marker"],delete d._.arrows[i+"dx"],delete d._.arrows[i+"Type"],delete d._.arrows[i+"String"];for(w in p)if(p[b](w)&&!p[w]){var F=a._g.doc.getElementById(w);F&&F.parentNode.removeChild(F)}}},u={"":[0],none:[0],"-":[3,1],".":[1,1],"-.":[3,1,1,1],"-..":[3,1,1,1,1,1],". ":[1,3],"- ":[4,3],"--":[8,3],"- .":[4,3,1,3],"--.":[8,3,1,3],"--..":[8,3,1,3,1,3]},v=function(a,b,d){b=u[c(b).toLowerCase()];if(b){var e=a.attrs["stroke-width"]||"1",f={round:e,square:e,butt:0}[a.attrs["stroke-linecap"]||d["stroke-linecap"]]||0,g=[],h=b.length;while(h--)g[h]=b[h]*e+(h%2?1:-1)*f;q(a.node,{"stroke-dasharray":g.join(",")})}},w=function(d,f){var i=d.node,k=d.attrs,m=i.style.visibility;i.style.visibility="hidden";for(var o in f)if(f[b](o)){if(!a._availableAttrs[b](o))continue;var p=f[o];k[o]=p;switch(o){case"blur":d.blur(p);break;case"href":case"title":case"target":var u=i.parentNode;if(u.tagName.toLowerCase()!="a"){var w=q("a");u.insertBefore(w,i),w.appendChild(i),u=w}o=="target"&&p=="blank"?u.setAttributeNS(n,"show","new"):u.setAttributeNS(n,o,p);break;case"cursor":i.style.cursor=p;break;case"transform":d.transform(p);break;case"arrow-start":t(d,p);break;case"arrow-end":t(d,p,1);break;case"clip-rect":var x=c(p).split(j);if(x.length==4){d.clip&&d.clip.parentNode.parentNode.removeChild(d.clip.parentNode);var z=q("clipPath"),A=q("rect");z.id=a.createUUID(),q(A,{x:x[0],y:x[1],width:x[2],height:x[3]}),z.appendChild(A),d.paper.defs.appendChild(z),q(i,{"clip-path":"url(#"+z.id+")"}),d.clip=A}if(!p){var B=i.getAttribute("clip-path");if(B){var C=a._g.doc.getElementById(B.replace(/(^url\(#|\)$)/g,l));C&&C.parentNode.removeChild(C),q(i,{"clip-path":l}),delete d.clip}}break;case"path":d.type=="path"&&(q(i,{d:p?k.path=a._pathToAbsolute(p):"M0,0"}),d._.dirty=1,d._.arrows&&("startString"in d._.arrows&&t(d,d._.arrows.startString),"endString"in d._.arrows&&t(d,d._.arrows.endString,1)));break;case"width":i.setAttribute(o,p),d._.dirty=1;if(k.fx)o="x",p=k.x;else break;case"x":k.fx&&(p=-k.x-(k.width||0));case"rx":if(o=="rx"&&d.type=="rect")break;case"cx":i.setAttribute(o,p),d.pattern&&s(d),d._.dirty=1;break;case"height":i.setAttribute(o,p),d._.dirty=1;if(k.fy)o="y",p=k.y;else break;case"y":k.fy&&(p=-k.y-(k.height||0));case"ry":if(o=="ry"&&d.type=="rect")break;case"cy":i.setAttribute(o,p),d.pattern&&s(d),d._.dirty=1;break;case"r":d.type=="rect"?q(i,{rx:p,ry:p}):i.setAttribute(o,p),d._.dirty=1;break;case"src":d.type=="image"&&i.setAttributeNS(n,"href",p);break;case"stroke-width":if(d._.sx!=1||d._.sy!=1)p/=g(h(d._.sx),h(d._.sy))||1;d.paper._vbSize&&(p*=d.paper._vbSize),i.setAttribute(o,p),k["stroke-dasharray"]&&v(d,k["stroke-dasharray"],f),d._.arrows&&("startString"in d._.arrows&&t(d,d._.arrows.startString),"endString"in d._.arrows&&t(d,d._.arrows.endString,1));break;case"stroke-dasharray":v(d,p,f);break;case"fill":var D=c(p).match(a._ISURL);if(D){z=q("pattern");var F=q("image");z.id=a.createUUID(),q(z,{x:0,y:0,patternUnits:"userSpaceOnUse",height:1,width:1}),q(F,{x:0,y:0,"xlink:href":D[1]}),z.appendChild(F),function(b){a._preload(D[1],function(){var a=this.offsetWidth,c=this.offsetHeight;q(b,{width:a,height:c}),q(F,{width:a,height:c}),d.paper.safari()})}(z),d.paper.defs.appendChild(z),i.style.fill="url(#"+z.id+")",q(i,{fill:"url(#"+z.id+")"}),d.pattern=z,d.pattern&&s(d);break}var G=a.getRGB(p);if(!G.error)delete f.gradient,delete k.gradient,!a.is(k.opacity,"undefined")&&a.is(f.opacity,"undefined")&&q(i,{opacity:k.opacity}),!a.is(k["fill-opacity"],"undefined")&&a.is(f["fill-opacity"],"undefined")&&q(i,{"fill-opacity":k["fill-opacity"]});else if((d.type=="circle"||d.type=="ellipse"||c(p).charAt()!="r")&&r(d,p)){if("opacity"in k||"fill-opacity"in k){var H=a._g.doc.getElementById(i.getAttribute("fill").replace(/^url\(#|\)$/g,l));if(H){var I=H.getElementsByTagName("stop");q(I[I.length-1],{"stop-opacity":("opacity"in k?k.opacity:1)*("fill-opacity"in k?k["fill-opacity"]:1)})}}k.gradient=p,k.fill="none";break}G[b]("opacity")&&q(i,{"fill-opacity":G.opacity>1?G.opacity/100:G.opacity});case"stroke":G=a.getRGB(p),i.setAttribute(o,G.hex),o=="stroke"&&G[b]("opacity")&&q(i,{"stroke-opacity":G.opacity>1?G.opacity/100:G.opacity}),o=="stroke"&&d._.arrows&&("startString"in d._.arrows&&t(d,d._.arrows.startString),"endString"in d._.arrows&&t(d,d._.arrows.endString,1));break;case"gradient":(d.type=="circle"||d.type=="ellipse"||c(p).charAt()!="r")&&r(d,p);break;case"opacity":k.gradient&&!k[b]("stroke-opacity")&&q(i,{"stroke-opacity":p>1?p/100:p});case"fill-opacity":if(k.gradient){H=a._g.doc.getElementById(i.getAttribute("fill").replace(/^url\(#|\)$/g,l)),H&&(I=H.getElementsByTagName("stop"),q(I[I.length-1],{"stop-opacity":p}));break};default:o=="font-size"&&(p=e(p,10)+"px");var J=o.replace(/(\-.)/g,function(a){return a.substring(1).toUpperCase()});i.style[J]=p,d._.dirty=1,i.setAttribute(o,p)}}y(d,f),i.style.visibility=m},x=1.2,y=function(d,f){if(d.type=="text"&&!!(f[b]("text")||f[b]("font")||f[b]("font-size")||f[b]("x")||f[b]("y"))){var g=d.attrs,h=d.node,i=h.firstChild?e(a._g.doc.defaultView.getComputedStyle(h.firstChild,l).getPropertyValue("font-size"),10):10;if(f[b]("text")){g.text=f.text;while(h.firstChild)h.removeChild(h.firstChild);var j=c(f.text).split("\n"),k=[],m;for(var n=0,o=j.length;n<o;n++)m=q("tspan"),n&&q(m,{dy:i*x,x:g.x}),m.appendChild(a._g.doc.createTextNode(j[n])),h.appendChild(m),k[n]=m}else{k=h.getElementsByTagName("tspan");for(n=0,o=k.length;n<o;n++)n?q(k[n],{dy:i*x,x:g.x}):q(k[0],{dy:0})}q(h,{x:g.x,y:g.y}),d._.dirty=1;var p=d._getBBox(),r=g.y-(p.y+p.height/2);r&&a.is(r,"finite")&&q(k[0],{dy:r})}},z=function(b,c){var d=0,e=0;this[0]=this.node=b,b.raphael=!0,this.id=a._oid++,b.raphaelid=this.id,this.matrix=a.matrix(),this.realPath=null,this.paper=c,this.attrs=this.attrs||{},this._={transform:[],sx:1,sy:1,deg:0,dx:0,dy:0,dirty:1},!c.bottom&&(c.bottom=this),this.prev=c.top,c.top&&(c.top.next=this),c.top=this,this.next=null},A=a.el;z.prototype=A,A.constructor=z,a._engine.path=function(a,b){var c=q("path");b.canvas&&b.canvas.appendChild(c);var d=new z(c,b);d.type="path",w(d,{fill:"none",stroke:"#000",path:a});return d},A.rotate=function(a,b,e){if(this.removed)return this;a=c(a).split(j),a.length-1&&(b=d(a[1]),e=d(a[2])),a=d(a[0]),e==null&&(b=e);if(b==null||e==null){var f=this.getBBox(1);b=f.x+f.width/2,e=f.y+f.height/2}this.transform(this._.transform.concat([["r",a,b,e]]));return this},A.scale=function(a,b,e,f){if(this.removed)return this;a=c(a).split(j),a.length-1&&(b=d(a[1]),e=d(a[2]),f=d(a[3])),a=d(a[0]),b==null&&(b=a),f==null&&(e=f);if(e==null||f==null)var g=this.getBBox(1);e=e==null?g.x+g.width/2:e,f=f==null?g.y+g.height/2:f,this.transform(this._.transform.concat([["s",a,b,e,f]]));return this},A.translate=function(a,b){if(this.removed)return this;a=c(a).split(j),a.length-1&&(b=d(a[1])),a=d(a[0])||0,b=+b||0,this.transform(this._.transform.concat([["t",a,b]]));return this},A.transform=function(c){var d=this._;if(c==null)return d.transform;a._extractTransform(this,c),this.clip&&q(this.clip,{transform:this.matrix.invert()}),this.pattern&&s(this),this.node&&q(this.node,{transform:this.matrix});if(d.sx!=1||d.sy!=1){var e=this.attrs[b]("stroke-width")?this.attrs["stroke-width"]:1;this.attr({"stroke-width":e})}return this},A.hide=function(){!this.removed&&this.paper.safari(this.node.style.display="none");return this},A.show=function(){!this.removed&&this.paper.safari(this.node.style.display="");return this},A.remove=function(){if(!this.removed){var b=this.paper;b.__set__&&b.__set__.exclude(this),k.unbind("*.*."+this.id),this.gradient&&b.defs.removeChild(this.gradient),a._tear(this,b),this.node.parentNode.removeChild(this.node);for(var c in this)this[c]=typeof this[c]=="function"?a._removedFactory(c):null;this.removed=!0}},A._getBBox=function(){if(this.node.style.display=="none"){this.show();var a=!0}var b={};try{b=this.node.getBBox()}catch(c){}finally{b=b||{}}a&&this.hide();return b},A.attr=function(c,d){if(this.removed)return this;if(c==null){var e={};for(var f in this.attrs)this.attrs[b](f)&&(e[f]=this.attrs[f]);e.gradient&&e.fill=="none"&&(e.fill=e.gradient)&&delete e.gradient,e.transform=this._.transform;return e}if(d==null&&a.is(c,"string")){if(c=="fill"&&this.attrs.fill=="none"&&this.attrs.gradient)return this.attrs.gradient;if(c=="transform")return this._.transform;var g=c.split(j),h={};for(var i=0,l=g.length;i<l;i++)c=g[i],c in this.attrs?h[c]=this.attrs[c]:a.is(this.paper.customAttributes[c],"function")?h[c]=this.paper.customAttributes[c].def:h[c]=a._availableAttrs[c];return l-1?h:h[g[0]]}if(d==null&&a.is(c,"array")){h={};for(i=0,l=c.length;i<l;i++)h[c[i]]=this.attr(c[i]);return h}if(d!=null){var m={};m[c]=d}else c!=null&&a.is(c,"object")&&(m=c);for(var n in m)k("attr."+n+"."+this.id,this,m[n]);for(n in this.paper.customAttributes)if(this.paper.customAttributes[b](n)&&m[b](n)&&a.is(this.paper.customAttributes[n],"function")){var o=this.paper.customAttributes[n].apply(this,[].concat(m[n]));this.attrs[n]=m[n];for(var p in o)o[b](p)&&(m[p]=o[p])}w(this,m);return this},A.toFront=function(){if(this.removed)return this;this.node.parentNode.tagName.toLowerCase()=="a"?this.node.parentNode.parentNode.appendChild(this.node.parentNode):this.node.parentNode.appendChild(this.node);var b=this.paper;b.top!=this&&a._tofront(this,b);return this},A.toBack=function(){if(this.removed)return this;var b=this.node.parentNode;b.tagName.toLowerCase()=="a"?b.parentNode.insertBefore(this.node.parentNode,this.node.parentNode.parentNode.firstChild):b.firstChild!=this.node&&b.insertBefore(this.node,this.node.parentNode.firstChild),a._toback(this,this.paper);var c=this.paper;return this},A.insertAfter=function(b){if(this.removed)return this;var c=b.node||b[b.length-1].node;c.nextSibling?c.parentNode.insertBefore(this.node,c.nextSibling):c.parentNode.appendChild(this.node),a._insertafter(this,b,this.paper);return this},A.insertBefore=function(b){if(this.removed)return this;var c=b.node||b[0].node;c.parentNode.insertBefore(this.node,c),a._insertbefore(this,b,this.paper);return this},A.blur=function(b){var c=this;if(+b!==0){var d=q("filter"),e=q("feGaussianBlur");c.attrs.blur=b,d.id=a.createUUID(),q(e,{stdDeviation:+b||1.5}),d.appendChild(e),c.paper.defs.appendChild(d),c._blur=d,q(c.node,{filter:"url(#"+d.id+")"})}else c._blur&&(c._blur.parentNode.removeChild(c._blur),delete c._blur,delete c.attrs.blur),c.node.removeAttribute("filter")},a._engine.circle=function(a,b,c,d){var e=q("circle");a.canvas&&a.canvas.appendChild(e);var f=new z(e,a);f.attrs={cx:b,cy:c,r:d,fill:"none",stroke:"#000"},f.type="circle",q(e,f.attrs);return f},a._engine.rect=function(a,b,c,d,e,f){var g=q("rect");a.canvas&&a.canvas.appendChild(g);var h=new z(g,a);h.attrs={x:b,y:c,width:d,height:e,r:f||0,rx:f||0,ry:f||0,fill:"none",stroke:"#000"},h.type="rect",q(g,h.attrs);return h},a._engine.ellipse=function(a,b,c,d,e){var f=q("ellipse");a.canvas&&a.canvas.appendChild(f);var g=new z(f,a);g.attrs={cx:b,cy:c,rx:d,ry:e,fill:"none",stroke:"#000"},g.type="ellipse",q(f,g.attrs);return g},a._engine.image=function(a,b,c,d,e,f){var g=q("image");q(g,{x:c,y:d,width:e,height:f,preserveAspectRatio:"none"}),g.setAttributeNS(n,"href",b),a.canvas&&a.canvas.appendChild(g);var h=new z(g,a);h.attrs={x:c,y:d,width:e,height:f,src:b},h.type="image";return h},a._engine.text=function(b,c,d,e){var f=q("text");b.canvas&&b.canvas.appendChild(f);var g=new z(f,b);g.attrs={x:c,y:d,"text-anchor":"middle",text:e,font:a._availableAttrs.font,stroke:"none",fill:"#000"},g.type="text",w(g,g.attrs);return g},a._engine.setSize=function(a,b){this.width=a||this.width,this.height=b||this.height,this.canvas.setAttribute("width",this.width),this.canvas.setAttribute("height",this.height),this._viewBox&&this.setViewBox.apply(this,this._viewBox);return this},a._engine.create=function(){var b=a._getContainer.apply(0,arguments),c=b&&b.container,d=b.x,e=b.y,f=b.width,g=b.height;if(!c)throw new Error("SVG container not found.");var h=q("svg"),i="overflow:hidden;",j;d=d||0,e=e||0,f=f||512,g=g||342,q(h,{height:g,version:1.1,width:f,xmlns:"http://www.w3.org/2000/svg"}),c==1?(h.style.cssText=i+"position:absolute;left:"+d+"px;top:"+e+"px",a._g.doc.body.appendChild(h),j=1):(h.style.cssText=i+"position:relative",c.firstChild?c.insertBefore(h,c.firstChild):c.appendChild(h)),c=new a._Paper,c.width=f,c.height=g,c.canvas=h,c.clear(),c._left=c._top=0,j&&(c.renderfix=function(){}),c.renderfix();return c},a._engine.setViewBox=function(a,b,c,d,e){k("setViewBox",this,this._viewBox,[a,b,c,d,e]);var f=g(c/this.width,d/this.height),h=this.top,i=e?"meet":"xMinYMin",j,l;a==null?(this._vbSize&&(f=1),delete this._vbSize,j="0 0 "+this.width+m+this.height):(this._vbSize=f,j=a+m+b+m+c+m+d),q(this.canvas,{viewBox:j,preserveAspectRatio:i});while(f&&h)l="stroke-width"in h.attrs?h.attrs["stroke-width"]:1,h.attr({"stroke-width":l}),h._.dirty=1,h._.dirtyT=1,h=h.prev;this._viewBox=[a,b,c,d,!!e];return this},a.prototype.renderfix=function(){var a=this.canvas,b=a.style,c=a.getScreenCTM()||a.createSVGMatrix(),d=-c.e%1,e=-c.f%1;if(d||e)d&&(this._left=(this._left+d)%1,b.left=this._left+"px"),e&&(this._top=(this._top+e)%1,b.top=this._top+"px")},a.prototype.clear=function(){a.eve("clear",this);var b=this.canvas;while(b.firstChild)b.removeChild(b.firstChild);this.bottom=this.top=null,(this.desc=q("desc")).appendChild(a._g.doc.createTextNode("Created with Raphaël "+a.version)),b.appendChild(this.desc),b.appendChild(this.defs=q("defs"))},a.prototype.remove=function(){k("remove",this),this.canvas.parentNode&&this.canvas.parentNode.removeChild(this.canvas);for(var b in this)this[b]=typeof this[b]=="function"?a._removedFactory(b):null};var B=a.st;for(var C in A)A[b](C)&&!B[b](C)&&(B[C]=function(a){return function(){var b=arguments;return this.forEach(function(c){c[a].apply(c,b)})}}(C))}(window.Raphael),window.Raphael.vml&&function(a){var b="hasOwnProperty",c=String,d=parseFloat,e=Math,f=e.round,g=e.max,h=e.min,i=e.abs,j="fill",k=/[, ]+/,l=a.eve,m=" progid:DXImageTransform.Microsoft",n=" ",o="",p={M:"m",L:"l",C:"c",Z:"x",m:"t",l:"r",c:"v",z:"x"},q=/([clmz]),?([^clmz]*)/gi,r=/ progid:\S+Blur\([^\)]+\)/g,s=/-?[^,\s-]+/g,t="position:absolute;left:0;top:0;width:1px;height:1px",u=21600,v={path:1,rect:1,image:1},w={circle:1,ellipse:1},x=function(b){var d=/[ahqstv]/ig,e=a._pathToAbsolute;c(b).match(d)&&(e=a._path2curve),d=/[clmz]/g;if(e==a._pathToAbsolute&&!c(b).match(d)){var g=c(b).replace(q,function(a,b,c){var d=[],e=b.toLowerCase()=="m",g=p[b];c.replace(s,function(a){e&&d.length==2&&(g+=d+p[b=="m"?"l":"L"],d=[]),d.push(f(a*u))});return g+d});return g}var h=e(b),i,j;g=[];for(var k=0,l=h.length;k<l;k++){i=h[k],j=h[k][0].toLowerCase(),j=="z"&&(j="x");for(var m=1,r=i.length;m<r;m++)j+=f(i[m]*u)+(m!=r-1?",":o);g.push(j)}return g.join(n)},y=function(b,c,d){var e=a.matrix();e.rotate(-b,.5,.5);return{dx:e.x(c,d),dy:e.y(c,d)}},z=function(a,b,c,d,e,f){var g=a._,h=a.matrix,k=g.fillpos,l=a.node,m=l.style,o=1,p="",q,r=u/b,s=u/c;m.visibility="hidden";if(!!b&&!!c){l.coordsize=i(r)+n+i(s),m.rotation=f*(b*c<0?-1:1);if(f){var t=y(f,d,e);d=t.dx,e=t.dy}b<0&&(p+="x"),c<0&&(p+=" y")&&(o=-1),m.flip=p,l.coordorigin=d*-r+n+e*-s;if(k||g.fillsize){var v=l.getElementsByTagName(j);v=v&&v[0],l.removeChild(v),k&&(t=y(f,h.x(k[0],k[1]),h.y(k[0],k[1])),v.position=t.dx*o+n+t.dy*o),g.fillsize&&(v.size=g.fillsize[0]*i(b)+n+g.fillsize[1]*i(c)),l.appendChild(v)}m.visibility="visible"}};a.toString=function(){return"Your browser doesn’t support SVG. Falling down to VML.\nYou are running Raphaël "+this.version};var A=function(a,b,d){var e=c(b).toLowerCase().split("-"),f=d?"end":"start",g=e.length,h="classic",i="medium",j="medium";while(g--)switch(e[g]){case"block":case"classic":case"oval":case"diamond":case"open":case"none":h=e[g];break;case"wide":case"narrow":j=e[g];break;case"long":case"short":i=e[g]}var k=a.node.getElementsByTagName("stroke")[0];k[f+"arrow"]=h,k[f+"arrowlength"]=i,k[f+"arrowwidth"]=j},B=function(e,i){e.attrs=e.attrs||{};var l=e.node,m=e.attrs,p=l.style,q,r=v[e.type]&&(i.x!=m.x||i.y!=m.y||i.width!=m.width||i.height!=m.height||i.cx!=m.cx||i.cy!=m.cy||i.rx!=m.rx||i.ry!=m.ry||i.r!=m.r),s=w[e.type]&&(m.cx!=i.cx||m.cy!=i.cy||m.r!=i.r||m.rx!=i.rx||m.ry!=i.ry),t=e;for(var y in i)i[b](y)&&(m[y]=i[y]);r&&(m.path=a._getPath[e.type](e),e._.dirty=1),i.href&&(l.href=i.href),i.title&&(l.title=i.title),i.target&&(l.target=i.target),i.cursor&&(p.cursor=i.cursor),"blur"in i&&e.blur(i.blur);if(i.path&&e.type=="path"||r)l.path=x(~c(m.path).toLowerCase().indexOf("r")?a._pathToAbsolute(m.path):m.path),e.type=="image"&&(e._.fillpos=[m.x,m.y],e._.fillsize=[m.width,m.height],z(e,1,1,0,0,0));"transform"in i&&e.transform(i.transform);if(s){var B=+m.cx,D=+m.cy,E=+m.rx||+m.r||0,G=+m.ry||+m.r||0;l.path=a.format("ar{0},{1},{2},{3},{4},{1},{4},{1}x",f((B-E)*u),f((D-G)*u),f((B+E)*u),f((D+G)*u),f(B*u))}if("clip-rect"in i){var H=c(i["clip-rect"]).split(k);if(H.length==4){H[2]=+H[2]+ +H[0],H[3]=+H[3]+ +H[1];var I=l.clipRect||a._g.doc.createElement("div"),J=I.style;J.clip=a.format("rect({1}px {2}px {3}px {0}px)",H),l.clipRect||(J.position="absolute",J.top=0,J.left=0,J.width=e.paper.width+"px",J.height=e.paper.height+"px",l.parentNode.insertBefore(I,l),I.appendChild(l),l.clipRect=I)}i["clip-rect"]||l.clipRect&&(l.clipRect.style.clip="auto")}if(e.textpath){var K=e.textpath.style;i.font&&(K.font=i.font),i["font-family"]&&(K.fontFamily='"'+i["font-family"].split(",")[0].replace(/^['"]+|['"]+$/g,o)+'"'),i["font-size"]&&(K.fontSize=i["font-size"]),i["font-weight"]&&(K.fontWeight=i["font-weight"]),i["font-style"]&&(K.fontStyle=i["font-style"])}"arrow-start"in i&&A(t,i["arrow-start"]),"arrow-end"in i&&A(t,i["arrow-end"],1);if(i.opacity!=null||i["stroke-width"]!=null||i.fill!=null||i.src!=null||i.stroke!=null||i["stroke-width"]!=null||i["stroke-opacity"]!=null||i["fill-opacity"]!=null||i["stroke-dasharray"]!=null||i["stroke-miterlimit"]!=null||i["stroke-linejoin"]!=null||i["stroke-linecap"]!=null){var L=l.getElementsByTagName(j),M=!1;L=L&&L[0],!L&&(M=L=F(j)),e.type=="image"&&i.src&&(L.src=i.src),i.fill&&(L.on=!0);if(L.on==null||i.fill=="none"||i.fill===null)L.on=!1;if(L.on&&i.fill){var N=c(i.fill).match(a._ISURL);if(N){L.parentNode==l&&l.removeChild(L),L.rotate=!0,L.src=N[1],L.type="tile";var O=e.getBBox(1);L.position=O.x+n+O.y,e._.fillpos=[O.x,O.y],a._preload(N[1],function(){e._.fillsize=[this.offsetWidth,this.offsetHeight]})}else L.color=a.getRGB(i.fill).hex,L.src=o,L.type="solid",a.getRGB(i.fill).error&&(t.type in{circle:1,ellipse:1}||c(i.fill).charAt()!="r")&&C(t,i.fill,L)&&(m.fill="none",m.gradient=i.fill,L.rotate=!1)}if("fill-opacity"in i||"opacity"in i){var P=((+m["fill-opacity"]+1||2)-1)*((+m.opacity+1||2)-1)*((+a.getRGB(i.fill).o+1||2)-1);P=h(g(P,0),1),L.opacity=P,L.src&&(L.color="none")}l.appendChild(L);var Q=l.getElementsByTagName("stroke")&&l.getElementsByTagName("stroke")[0],T=!1;!Q&&(T=Q=F("stroke"));if(i.stroke&&i.stroke!="none"||i["stroke-width"]||i["stroke-opacity"]!=null||i["stroke-dasharray"]||i["stroke-miterlimit"]||i["stroke-linejoin"]||i["stroke-linecap"])Q.on=!0;(i.stroke=="none"||i.stroke===null||Q.on==null||i.stroke==0||i["stroke-width"]==0)&&(Q.on=!1);var U=a.getRGB(i.stroke);Q.on&&i.stroke&&(Q.color=U.hex),P=((+m["stroke-opacity"]+1||2)-1)*((+m.opacity+1||2)-1)*((+U.o+1||2)-1);var V=(d(i["stroke-width"])||1)*.75;P=h(g(P,0),1),i["stroke-width"]==null&&(V=m["stroke-width"]),i["stroke-width"]&&(Q.weight=V),V&&V<1&&(P*=V)&&(Q.weight=1),Q.opacity=P,i["stroke-linejoin"]&&(Q.joinstyle=i["stroke-linejoin"]||"miter"),Q.miterlimit=i["stroke-miterlimit"]||8,i["stroke-linecap"]&&(Q.endcap=i["stroke-linecap"]=="butt"?"flat":i["stroke-linecap"]=="square"?"square":"round");if(i["stroke-dasharray"]){var W={"-":"shortdash",".":"shortdot","-.":"shortdashdot","-..":"shortdashdotdot",". ":"dot","- ":"dash","--":"longdash","- .":"dashdot","--.":"longdashdot","--..":"longdashdotdot"};Q.dashstyle=W[b](i["stroke-dasharray"])?W[i["stroke-dasharray"]]:o}T&&l.appendChild(Q)}if(t.type=="text"){t.paper.canvas.style.display=o;var X=t.paper.span,Y=100,Z=m.font&&m.font.match(/\d+(?:\.\d*)?(?=px)/);p=X.style,m.font&&(p.font=m.font),m["font-family"]&&(p.fontFamily=m["font-family"]),m["font-weight"]&&(p.fontWeight=m["font-weight"]),m["font-style"]&&(p.fontStyle=m["font-style"]),Z=d(m["font-size"]||Z&&Z[0])||10,p.fontSize=Z*Y+"px",t.textpath.string&&(X.innerHTML=c(t.textpath.string).replace(/</g,"&#60;").replace(/&/g,"&#38;").replace(/\n/g,"<br>"));var $=X.getBoundingClientRect();t.W=m.w=($.right-$.left)/Y,t.H=m.h=($.bottom-$.top)/Y,t.X=m.x,t.Y=m.y+t.H/2,("x"in i||"y"in i)&&(t.path.v=a.format("m{0},{1}l{2},{1}",f(m.x*u),f(m.y*u),f(m.x*u)+1));var _=["x","y","text","font","font-family","font-weight","font-style","font-size"];for(var ba=0,bb=_.length;ba<bb;ba++)if(_[ba]in i){t._.dirty=1;break}switch(m["text-anchor"]){case"start":t.textpath.style["v-text-align"]="left",t.bbx=t.W/2;break;case"end":t.textpath.style["v-text-align"]="right",t.bbx=-t.W/2;break;default:t.textpath.style["v-text-align"]="center",t.bbx=0}t.textpath.style["v-text-kern"]=!0}},C=function(b,f,g){b.attrs=b.attrs||{};var h=b.attrs,i=Math.pow,j,k,l="linear",m=".5 .5";b.attrs.gradient=f,f=c(f).replace(a._radial_gradient,function(a,b,c){l="radial",b&&c&&(b=d(b),c=d(c),i(b-.5,2)+i(c-.5,2)>.25&&(c=e.sqrt(.25-i(b-.5,2))*((c>.5)*2-1)+.5),m=b+n+c);return o}),f=f.split(/\s*\-\s*/);if(l=="linear"){var p=f.shift();p=-d(p);if(isNaN(p))return null}var q=a._parseDots(f);if(!q)return null;b=b.shape||b.node;if(q.length){b.removeChild(g),g.on=!0,g.method="none",g.color=q[0].color,g.color2=q[q.length-1].color;var r=[];for(var s=0,t=q.length;s<t;s++)q[s].offset&&r.push(q[s].offset+n+q[s].color);g.colors=r.length?r.join():"0% "+g.color,l=="radial"?(g.type="gradientTitle",g.focus="100%",g.focussize="0 0",g.focusposition=m,g.angle=0):(g.type="gradient",g.angle=(270-p)%360),b.appendChild(g)}return 1},D=function(b,c){this[0]=this.node=b,b.raphael=!0,this.id=a._oid++,b.raphaelid=this.id,this.X=0,this.Y=0,this.attrs={},this.paper=c,this.matrix=a.matrix(),this._={transform:[],sx:1,sy:1,dx:0,dy:0,deg:0,dirty:1,dirtyT:1},!c.bottom&&(c.bottom=this),this.prev=c.top,c.top&&(c.top.next=this),c.top=this,this.next=null},E=a.el;D.prototype=E,E.constructor=D,E.transform=function(b){if(b==null)return this._.transform;var d=this.paper._viewBoxShift,e=d?"s"+[d.scale,d.scale]+"-1-1t"+[d.dx,d.dy]:o,f;d&&(f=b=c(b).replace(/\.{3}|\u2026/g,this._.transform||o)),a._extractTransform(this,e+b);var g=this.matrix.clone(),h=this.skew,i=this.node,j,k=~c(this.attrs.fill).indexOf("-"),l=!c(this.attrs.fill).indexOf("url(");g.translate(-0.5,-0.5);if(l||k||this.type=="image"){h.matrix="1 0 0 1",h.offset="0 0",j=g.split();if(k&&j.noRotation||!j.isSimple){i.style.filter=g.toFilter();var m=this.getBBox(),p=this.getBBox(1),q=m.x-p.x,r=m.y-p.y;i.coordorigin=q*-u+n+r*-u,z(this,1,1,q,r,0)}else i.style.filter=o,z(this,j.scalex,j.scaley,j.dx,j.dy,j.rotate)}else i.style.filter=o,h.matrix=c(g),h.offset=g.offset();f&&(this._.transform=f);return this},E.rotate=function(a,b,e){if(this.removed)return this;if(a!=null){a=c(a).split(k),a.length-1&&(b=d(a[1]),e=d(a[2])),a=d(a[0]),e==null&&(b=e);if(b==null||e==null){var f=this.getBBox(1);b=f.x+f.width/2,e=f.y+f.height/2}this._.dirtyT=1,this.transform(this._.transform.concat([["r",a,b,e]]));return this}},E.translate=function(a,b){if(this.removed)return this;a=c(a).split(k),a.length-1&&(b=d(a[1])),a=d(a[0])||0,b=+b||0,this._.bbox&&(this._.bbox.x+=a,this._.bbox.y+=b),this.transform(this._.transform.concat([["t",a,b]]));return this},E.scale=function(a,b,e,f){if(this.removed)return this;a=c(a).split(k),a.length-1&&(b=d(a[1]),e=d(a[2]),f=d(a[3]),isNaN(e)&&(e=null),isNaN(f)&&(f=null)),a=d(a[0]),b==null&&(b=a),f==null&&(e=f);if(e==null||f==null)var g=this.getBBox(1);e=e==null?g.x+g.width/2:e,f=f==null?g.y+g.height/2:f,this.transform(this._.transform.concat([["s",a,b,e,f]])),this._.dirtyT=1;return this},E.hide=function(){!this.removed&&(this.node.style.display="none");return this},E.show=function(){!this.removed&&(this.node.style.display=o);return this},E._getBBox=function(){if(this.removed)return{};return{x:this.X+(this.bbx||0)-this.W/2,y:this.Y-this.H,width:this.W,height:this.H}},E.remove=function(){if(!this.removed){this.paper.__set__&&this.paper.__set__.exclude(this),a.eve.unbind("*.*."+this.id),a._tear(this,this.paper),this.node.parentNode.removeChild(this.node),this.shape&&this.shape.parentNode.removeChild(this.shape);for(var b in this)this[b]=typeof this[b]=="function"?a._removedFactory(b):null;this.removed=!0}},E.attr=function(c,d){if(this.removed)return this;if(c==null){var e={};for(var f in this.attrs)this.attrs[b](f)&&(e[f]=this.attrs[f]);e.gradient&&e.fill=="none"&&(e.fill=e.gradient)&&delete e.gradient,e.transform=this._.transform;return e}if(d==null&&a.is(c,"string")){if(c==j&&this.attrs.fill=="none"&&this.attrs.gradient)return this.attrs.gradient;var g=c.split(k),h={};for(var i=0,m=g.length;i<m;i++)c=g[i],c in this.attrs?h[c]=this.attrs[c]:a.is(this.paper.customAttributes[c],"function")?h[c]=this.paper.customAttributes[c].def:h[c]=a._availableAttrs[c];return m-1?h:h[g[0]]}if(this.attrs&&d==null&&a.is(c,"array")){h={};for(i=0,m=c.length;i<m;i++)h[c[i]]=this.attr(c[i]);return h}var n;d!=null&&(n={},n[c]=d),d==null&&a.is(c,"object")&&(n=c);for(var o in n)l("attr."+o+"."+this.id,this,n[o]);if(n){for(o in this.paper.customAttributes)if(this.paper.customAttributes[b](o)&&n[b](o)&&a.is(this.paper.customAttributes[o],"function")){var p=this.paper.customAttributes[o].apply(this,[].concat(n[o]));this.attrs[o]=n[o];for(var q in p)p[b](q)&&(n[q]=p[q])}n.text&&this.type=="text"&&(this.textpath.string=n.text),B(this,n)}return this},E.toFront=function(){!this.removed&&this.node.parentNode.appendChild(this.node),this.paper&&this.paper.top!=this&&a._tofront(this,this.paper);return this},E.toBack=function(){if(this.removed)return this;this.node.parentNode.firstChild!=this.node&&(this.node.parentNode.insertBefore(this.node,this.node.parentNode.firstChild),a._toback(this,this.paper));return this},E.insertAfter=function(b){if(this.removed)return this;b.constructor==a.st.constructor&&(b=b[b.length-1]),b.node.nextSibling?b.node.parentNode.insertBefore(this.node,b.node.nextSibling):b.node.parentNode.appendChild(this.node),a._insertafter(this,b,this.paper);return this},E.insertBefore=function(b){if(this.removed)return this;b.constructor==a.st.constructor&&(b=b[0]),b.node.parentNode.insertBefore(this.node,b.node),a._insertbefore(this,b,this.paper);return this},E.blur=function(b){var c=this.node.runtimeStyle,d=c.filter;d=d.replace(r,o),+b!==0?(this.attrs.blur=b,c.filter=d+n+m+".Blur(pixelradius="+(+b||1.5)+")",c.margin=a.format("-{0}px 0 0 -{0}px",f(+b||1.5))):(c.filter=d,c.margin=0,delete this.attrs.blur)},a._engine.path=function(a,b){var c=F("shape");c.style.cssText=t,c.coordsize=u+n+u,c.coordorigin=b.coordorigin;var d=new D(c,b),e={fill:"none",stroke:"#000"};a&&(e.path=a),d.type="path",d.path=[],d.Path=o,B(d,e),b.canvas.appendChild(c);var f=F("skew");f.on=!0,c.appendChild(f),d.skew=f,d.transform(o);return d},a._engine.rect=function(b,c,d,e,f,g){var h=a._rectPath(c,d,e,f,g),i=b.path(h),j=i.attrs;i.X=j.x=c,i.Y=j.y=d,i.W=j.width=e,i.H=j.height=f,j.r=g,j.path=h,i.type="rect";return i},a._engine.ellipse=function(a,b,c,d,e){var f=a.path(),g=f.attrs;f.X=b-d,f.Y=c-e,f.W=d*2,f.H=e*2,f.type="ellipse",B(f,{cx:b,cy:c,rx:d,ry:e});return f},a._engine.circle=function(a,b,c,d){var e=a.path(),f=e.attrs;e.X=b-d,e.Y=c-d,e.W=e.H=d*2,e.type="circle",B(e,{cx:b,cy:c,r:d});return e},a._engine.image=function(b,c,d,e,f,g){var h=a._rectPath(d,e,f,g),i=b.path(h).attr({stroke:"none"}),k=i.attrs,l=i.node,m=l.getElementsByTagName(j)[0];k.src=c,i.X=k.x=d,i.Y=k.y=e,i.W=k.width=f,i.H=k.height=g,k.path=h,i.type="image",m.parentNode==l&&l.removeChild(m),m.rotate=!0,m.src=c,m.type="tile",i._.fillpos=[d,e],i._.fillsize=[f,g],l.appendChild(m),z(i,1,1,0,0,0);return i},a._engine.text=function(b,d,e,g){var h=F("shape"),i=F("path"),j=F("textpath");d=d||0,e=e||0,g=g||"",i.v=a.format("m{0},{1}l{2},{1}",f(d*u),f(e*u),f(d*u)+1),i.textpathok=!0,j.string=c(g),j.on=!0,h.style.cssText=t,h.coordsize=u+n+u,h.coordorigin="0 0";var k=new D(h,b),l={fill:"#000",stroke:"none",font:a._availableAttrs.font,text:g};k.shape=h,k.path=i,k.textpath=j,k.type="text",k.attrs.text=c(g),k.attrs.x=d,k.attrs.y=e,k.attrs.w=1,k.attrs.h=1,B(k,l),h.appendChild(j),h.appendChild(i),b.canvas.appendChild(h);var m=F("skew");m.on=!0,h.appendChild(m),k.skew=m,k.transform(o);return k},a._engine.setSize=function(b,c){var d=this.canvas.style;this.width=b,this.height=c,b==+b&&(b+="px"),c==+c&&(c+="px"),d.width=b,d.height=c,d.clip="rect(0 "+b+" "+c+" 0)",this._viewBox&&a._engine.setViewBox.apply(this,this._viewBox);return this},a._engine.setViewBox=function(b,c,d,e,f){a.eve("setViewBox",this,this._viewBox,[b,c,d,e,f]);var h=this.width,i=this.height,j=1/g(d/h,e/i),k,l;f&&(k=i/e,l=h/d,d*k<h&&(b-=(h-d*k)/2/k),e*l<i&&(c-=(i-e*l)/2/l)),this._viewBox=[b,c,d,e,!!f],this._viewBoxShift={dx:-b,dy:-c,scale:j},this.forEach(function(a){a.transform("...")});return this};var F;a._engine.initWin=function(a){var b=a.document;b.createStyleSheet().addRule(".rvml","behavior:url(#default#VML)");try{!b.namespaces.rvml&&b.namespaces.add("rvml","urn:schemas-microsoft-com:vml"),F=function(a){return b.createElement("<rvml:"+a+' class="rvml">')}}catch(c){F=function(a){return b.createElement("<"+a+' xmlns="urn:schemas-microsoft.com:vml" class="rvml">')}}},a._engine.initWin(a._g.win),a._engine.create=function(){var b=a._getContainer.apply(0,arguments),c=b.container,d=b.height,e,f=b.width,g=b.x,h=b.y;if(!c)throw new Error("VML container not found.");var i=new a._Paper,j=i.canvas=a._g.doc.createElement("div"),k=j.style;g=g||0,h=h||0,f=f||512,d=d||342,i.width=f,i.height=d,f==+f&&(f+="px"),d==+d&&(d+="px"),i.coordsize=u*1e3+n+u*1e3,i.coordorigin="0 0",i.span=a._g.doc.createElement("span"),i.span.style.cssText="position:absolute;left:-9999em;top:-9999em;padding:0;margin:0;line-height:1;",j.appendChild(i.span),k.cssText=a.format("top:0;left:0;width:{0};height:{1};display:inline-block;position:relative;clip:rect(0 {0} {1} 0);overflow:hidden",f,d),c==1?(a._g.doc.body.appendChild(j),k.left=g+"px",k.top=h+"px",k.position="absolute"):c.firstChild?c.insertBefore(j,c.firstChild):c.appendChild(j),i.renderfix=function(){};return i},a.prototype.clear=function(){a.eve("clear",this),this.canvas.innerHTML=o,this.span=a._g.doc.createElement("span"),this.span.style.cssText="position:absolute;left:-9999em;top:-9999em;padding:0;margin:0;line-height:1;display:inline;",this.canvas.appendChild(this.span),this.bottom=this.top=null},a.prototype.remove=function(){a.eve("remove",this),this.canvas.parentNode.removeChild(this.canvas);for(var b in this)this[b]=typeof this[b]=="function"?a._removedFactory(b):null;return!0};var G=a.st;for(var H in E)E[b](H)&&!G[b](H)&&(G[H]=function(a){return function(){var b=arguments;return this.forEach(function(c){c[a].apply(c,b)})}}(H))}(window.Raphael);
(function(a){"use strict";a.widget("wijmo.wijpager",{options:{firstPageClass:"ui-icon-seek-first",firstPageText:"First",lastPageClass:"ui-icon-seek-end",lastPageText:"Last",mode:"numeric",nextPageClass:"ui-icon-seek-next",nextPageText:"Next",pageButtonCount:10,previousPageClass:"ui-icon-seek-prev",previousPageText:"Previous",pageCount:1,pageIndex:0,pageIndexChanging:null,pageIndexChanged:null},_create:function(){if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);this.element.addClass("ui-widget wijmo-wijpager ui-helper-clearfix");this.options.disabled&&this.disable();this._refresh()},_init:function(){},destroy:function(){this.element.removeClass("ui-widget wijmo-wijpager ui-helper-clearfix");this.$ul.remove();a.Widget.prototype.destroy.apply(this,arguments)},_setOption:function(){a.Widget.prototype._setOption.apply(this,arguments);this._refresh()},_refresh:function(){this._validate();this.$ul&&this.$ul.remove();this.element.append(this.$ul=a('<ul class="ui-list ui-corner-all ui-widget-content ui-helper-clearfix" role="tablist"></ul>'));switch((this.options.mode||"").toLowerCase()){case"nextprevious":this._createNextPrev(false);break;case"nextpreviousfirstlast":this._createNextPrev(true);break;case"numeric":this._createNumeric(false);break;case"numericfirstlast":this._createNumeric(true)}},_validate:function(){var a=this.options;if(isNaN(a.pageCount)||a.pageCount<1)a.pageCount=1;if(isNaN(a.pageIndex)||a.pageIndex<0)a.pageIndex=0;else if(a.pageIndex>=a.pageCount)a.pageIndex=a.pageCount-1;if(isNaN(a.pageButtonCount)||a.pageButtonCount<1)a.pageButtonCount=1},_createNextPrev:function(b){var a=this.options;b&&a.pageIndex&&this.$ul.append(this._createPagerItem(false,a.firstPageText,1,a.firstPageClass));a.pageIndex&&this.$ul.append(this._createPagerItem(false,a.previousPageText,a.pageIndex,a.previousPageClass));a.pageIndex+1<a.pageCount&&this.$ul.append(this._createPagerItem(false,a.nextPageText,a.pageIndex+2,a.nextPageClass));b&&a.pageIndex+1<a.pageCount&&this.$ul.append(this._createPagerItem(false,a.lastPageText,a.pageCount,a.lastPageClass))},_createNumeric:function(e){var a=this.options,f=a.pageIndex+1,c=1,b=Math.min(a.pageCount,a.pageButtonCount),d;if(f>b){c=Math.floor(a.pageIndex/a.pageButtonCount)*a.pageButtonCount+1;b=c+a.pageButtonCount-1;b=Math.min(b,a.pageCount);if(b-c+1<a.pageButtonCount)c=Math.max(1,b-a.pageButtonCount+1)}if(c!==1){e&&this.$ul.append(this._createPagerItem(false,a.firstPageText,1,a.firstPageClass));this.$ul.append(this._createPagerItem(false,"...",c-1,""))}for(d=c;d<=b;d++)this.$ul.append(this._createPagerItem(d===f,d.toString(),d,""));if(a.pageCount>b){this.$ul.append(this._createPagerItem(false,"...",b+1,""));e&&this.$ul.append(this._createPagerItem(false,a.lastPageText,a.pageCount,a.lastPageClass))}},_createPagerItem:function(f,d,h,e){var b,g=this,c=a("<li />").addClass("ui-page ui-corner-all").attr({role:"tab","aria-label":d,title:d});if(f)c.addClass("ui-state-active").attr("aria-selected","true");else c.addClass("ui-state-default").hover(function(){!g.options.disabled&&a(this).removeClass("ui-state-default").addClass("ui-state-hover")},function(){!g.options.disabled&&a(this).removeClass("ui-state-hover").addClass("ui-state-default")}).bind("click."+this.widgetName,{newPageIndex:h-1},a.proxy(this._onClick,this));if(f)b=a("<span />");else b=e?a("<span />").addClass("ui-icon "+e):a("<a/>").attr("href","#");b.text(d);c.append(b);return c},_onClick:function(b){if(this.options.disabled)return false;var a={newPageIndex:b.data.newPageIndex,handled:false};if(this._trigger("pageIndexChanging",null,a)!==false)if(this.options.pageIndex!==a.newPageIndex){this.options.pageIndex=a.newPageIndex;!a.handled&&this._refresh();this._trigger("pageIndexChanged",null,{newPageIndex:a.newPageIndex})}return false}})})(jQuery);
(function(a){"use strict";a.fn.extend({wijtextselection:function(){var c,e,g=this[0],d=this.val();if(arguments.length===0){var b,i,f,h;if(a.browser.msie&&a.browser.version<9)try{var k=document.selection;if(g.tagName.toLowerCase()!="textarea"){b=k.createRange().duplicate();b.moveEnd("character",d.length);f=b.text===""?d.length:d.lastIndexOf(b.text);b=k.createRange().duplicate();b.moveStart("character",-d.length);h=b.text.length}else{b=k.createRange();i=b.duplicate();i.moveToElementText(g);i.setEndPoint("EndToEnd",b);f=i.text.length-b.text.length,h=f+b.text.length}}catch(h){}else{f=g.selectionStart;h=g.selectionEnd}var m=d.substring(f,h);return{start:f,end:h,text:m,replace:function(a){return d.substring(0,f)+a+d.substring(h,d.length)}}}else if(arguments.length===1){if(typeof arguments[0]==="object"&&typeof arguments[0].start==="number"&&typeof arguments[0].end==="number"){c=arguments[0].start;e=arguments[0].end}else if(typeof arguments[0]==="string"){if((c=d.indexOf(arguments[0]))>-1)e=c+arguments[0].length}else if(Object.prototype.toString.call(arguments[0])==="[object RegExp]"){var l=arguments[0].exec(d);if(l!=null){c=l.index;e=c+l[0].length}}}else if(arguments.length===2)if(typeof arguments[0]==="number"&&typeof arguments[1]==="number"){c=arguments[0];e=arguments[1]}if(typeof c==="undefined"){c=0;e=d.length}if(a.browser.msie){var j=g.createTextRange();j.collapse(true);j.moveStart("character",c);j.moveEnd("character",e-c);j.select()}else{g.selectionStart=c;g.selectionEnd=e}}})})(jQuery);
(function(a){"use strict";var c,b,d;c=function(b){var a=this;a.data={};a.reader=null;a.proxy=null;a.items=[];a.loading=null;a.loaded=null;a._constructor(b)};window.wijdatasource=c;a.extend(c.prototype,{_constructor:function(b){a.extend(this,b)},load:function(c,e){var b=this,d=b.proxy;if(a.isFunction(b.loading))if(b.loading(b,c)===false)return;if(d)d.request(b,b.loaded,c);else{(b.items.length===0||e)&&this.read();a.isFunction(b.loaded)&&b.loaded(b,c)}},read:function(){var a=this,b=a.data;if(b&&a.reader)a.reader.read(a);else a.items=a.data}});b=function(b){a.isFunction(window.wijmoASPNetParseOptions)&&wijmoASPNetParseOptions(b);if(a.isArray(b))this.fields=b};window.wijarrayreader=b;a.extend(b.prototype,{read:function(b){if(a.isArray(b.data))b.items=this._map(b.data);else b.items=[]},_map:function(d){var c=this,b=[];if(c.fields===undefined||c.fields.length===0){a.extend(true,b,d);return b}else a.each(d,function(f,d){var e={};a.each(c.fields,function(g,b){if(b.mapping&&typeof b.mapping&&window[b.mapping])b.mapping=window[b.mapping];if(a.isFunction(b.mapping)){e[b.name]=b.mapping(d);return true}var f=b.mapping!==undefined?b.mapping:b.name,c=d[f];if(c===undefined)if(b.defaultValue!==undefined)c=b.defaultValue;else c=d;e[b.name]=c});b.push(e)});return b}});d=function(b){this.options=b;a.isFunction(window.wijmoASPNetParseOptions)&&wijmoASPNetParseOptions(b)};window.wijhttpproxy=d;a.extend(d.prototype,{request:function(d,e,f){var g=this,b=a.extend({},this.options),c=b.success;b.success=function(h){a.isFunction(c)&&c(h);g._complete(h,d,e,b,f)};a.ajax(b)},_complete:function(e,b,c,d,f){b.data=d.key!==undefined?e[d.key]:e;b.read();a.isFunction(c)&&c(b,f)}})})(jQuery);
(function(a){"use strict";var h="wijmo-wijcombobox-input",c="ui-state-hover",d="ui-state-active",b="ui-state-focus",f="ui-corner-left",e="ui-corner-right",i="<div class='wijmo-wijcombobox-trigger ui-state-default ui-corner-right'><span class='ui-icon ui-icon-triangle-1-s'></span></div>",g="<label class='wijmo-wijcombobox-label ui-widget-content'></label>";a.widget("wijmo.wijcombobox",{options:{data:null,labelText:null,minLength:4,delay:300,showingAnimation:null,hidingAnimation:null,showTrigger:true,triggerPosition:"right",dropdownHeight:300,dropdownWidth:"auto",selectOnItemFocus:false,autoFilter:true,autoComplete:true,highlightMatching:true,dropDownListPosition:{},columns:[],selectionMode:"single",multipleSelectionSeparator:",",forceSelectionText:false,select:null,isEditable:true,selectedIndex:-1,selectedValue:null,open:null,close:null,selectElementWidthFix:6,search:null,changed:null,listOptions:null},_create:function(){var b=this;b.selectedItem=null;b.selectedItems=[];if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);b._createDOMElements();b._bindInputEvents();b._initDropDownList();b.repaint();b._checkSelectIndex();if(b._usingRemoteData()&&b.options.data)b.originalDataSourceLoaded=b.options.data.loaded;b.element.is(":hidden")&&b.element.wijAddVisibilityObserver&&b.element.wijAddVisibilityObserver(function(){b.repaint();b.element.wijRemoveVisibilityObserver&&b.element.wijRemoveVisibilityObserver()},"wijcombobox")},_checkSelectIndex:function(){var c=this,d,b=c.options;b.selectedIndex===-1&&b.selectedValue&&a.each(b.data,function(a){if(b.data[a].value===b.selectedValue){c.options.selectedIndex=a;return false}});d=b.selectedIndex;!c._usingRemoteData()&&(d>=0||a.isArray(d))&&c.search(null,"checkindex")},repaint:function(){var b=this.options,a=this;if(a.element.is(":visible")||a._comboDiv||a._select!==undefined&&a._input.is(":visible")){a._showTrigger();if(b.disabledState){var c=b.disabled;a.disable();b.disabled=c}b.disabled&&a.disable();return true}return false},_bindInputEvents:function(){var c=this,e,f,g,d;e=c._input;f=c.options;e.bind("keydown.wijcombobox",function(b){if(f.disabledState===true||f.disabled)return;g=b.keyCode;d=a.ui.keyCode;switch(g){case d.UP:c._move("previous",b);b.preventDefault();break;case d.DOWN:c._move("next",b);b.preventDefault();break;case d.ENTER:if(c.menu.active){b.preventDefault();f.selectionMode==="multiple"&&c.menu&&c.menu.items&&c.menu.items.length===1&&a.each(c.selectedItems,function(b,a){if(a!==c.menu.items[0])a.selected=false});c.menu.select(b)}b.preventDefault();break;case d.TAB:e.trigger("wijcomboblur");if(!c.menu.active||f.selectionMode==="multiple"&&d.TAB===g)return;c.menu.select(b);var h=e.val().length;c._selectText(h,h,e);break;case d.ESCAPE:c.close(b);break;case d.LEFT:case d.RIGHT:case d.SHIFT:case d.CONTROL:case d.HOME:case d.END:case d.DELETE:case d.PAGE_UP:case d.PAGE_DOWN:break;case 18:e.trigger("wijcomboblur");break;default:window.clearTimeout(c.searching);if(f.isEditable===false){if(c._cacheKey===undefined)c._cacheKey="";c._cacheKey+=String.fromCharCode(g)}c.searching=window.setTimeout(function(){var a;if(f.isEditable===false){a=c._cacheKey;c._cacheKey=undefined}else a=e.val();c.search(a,b)},f.delay)}}).bind("wijcomboblur.wijcombobox",function(a){window.clearTimeout(c.searching);c._addInputFocus(false,b);c.closing=window.setTimeout(function(){c.close(a,true)},150)}).bind("focus.wijcombobox",function(){c._addInputFocus(true,b)}).bind("blur.wijcombobox",function(){!c.menu.element.is(":visible")&&e.trigger("wijcomboblur");c._change()})},_addInputFocus:function(f,e){var c=this,d,b,a;d=c._input.parent();b=f?"addClass":"removeClass";a=c._triggerArrow;d[b](e);a!==undefined&&a[b](e)},_renderColumnsHeader:function(c){var b=a("<ul class='wijmo-wijcombobox-rowheader'></ul>");a.each(this.options.columns,function(e,c){var d=a("<li class='wijmo-wijcombobox-cell ui-widget-header'></li>");d.html(c.name);c.width!==undefined&&d.width(c.width);d.appendTo(b)});c.append(b)},_hasSameValueText:function(a,b){return a.label===b.label&&a.value===b.value},_initDropDownList:function(){var b=this,g,d,c,f,e;g=b.element[0].ownerDocument;if(!b._comboDiv)d=a("<div class='wijmo-wijcombobox-list'></div>");else d=b._oriList;c=b.options;if(c.columns.length>0){d.addClass("wijmo-wijcombobox-multicolumn");f=a("<div class='wijmo-wijsuperpanel-header ui-state-default'></div>");b._renderColumnsHeader(f);d.append(f)}e={keepHightlightOnMouseLeave:true,selectionMode:c.selectionMode,addHoverItemClass:c.columns.length===0,focus:function(e,d){var a=d;c.selectOnItemFocus&&b.menu.select(null,{notCloseAfterSelected:true});if(c.columns.length>0){a.element.prev().addClass("wijmo-wijcombobox-active-prev");a.element.find(".wijmo-wijcombobox-row>.wijmo-wijcombobox-cell").addClass("ui-state-hover")}},selected:function(i,f){window.clearTimeout(b.closing);var j=c.selectionMode,d,e,h,g;d=f.item;if(b._trigger("select",i,d))if(j==="single"){if(!b._usingRemoteData()){e=a.inArray(d,b.items);if(e===undefined)e=f.selectedIndex;if(e!==c.selectedIndex){b._input.val(d.label);g=b.selectedItem;if(g!==null)g.selected=false;b.selectedItem=d;h=c.selectedIndex;c.selectedIndex=e;c.selectedValue=b.selectedItem.value;if(b._select!==undefined){b._select[0].selectedIndex=c.selectedIndex;b._select.trigger("change")}b._trigger("changed",null,{oldItem:g,selectedItem:b.selectedItem,newIndex:c.selectedIndex,oldIndex:h})}else b.selectedItem&&b._input.val()!==b.selectedItem.label&&b._input.val(d.label)}else if(b.selectedItem===null||!b._hasSameValueText(d,b.selectedItem)){b._input.val(d.label);b.selectedItem=d;b._trigger("changed",null,{selectedItem:d})}}else if(!b._usingRemoteData()){b.selectedItems=f.selectedItems;b._selectedItemsToInputVal(b.selectedItems);b._trigger("changed",null,{selectedItem:d,selectedItems:b.selectedItems})}if((f.data===undefined||!f.data.notCloseAfterSelected)&&j==="single"){b.close(i);b._input.focus()}},blur:function(d,b){var a=b.element;if(c.columns.length>0&&a){a.find(".wijmo-wijcombobox-row>.wijmo-wijcombobox-cell").removeClass("ui-state-hover");a.prev().removeClass("wijmo-wijcombobox-active-prev")}},itemRendering:function(g,f){var d=f,e;e="";if(d.isSeparator)e+=" wijmo-wijcombobox-separator";if(d.selected)e+=" wijmo-wijcombobox-selecteditem";e.length>0&&d.element.addClass(e);if(b._keypress&&c.isEditable&&c.columns.length===0&&c.highlightMatching&&a.trim(b._input.val()).length>0&&d.label)d.text=d.label.replace(new RegExp("(?![^&;]+;)(?!<[^<>]*)("+b._escapeRegex(b._input.val())+")(?![^<>]*>)(?![^&;]+;)","gi"),"<span class='ui-priority-primary'>$1</span>");else d.text=undefined},itemRendered:function(g,f){var b=f,d,e;if(b.cells===undefined)return;d=b.element;d.empty();e=a("<ul class='wijmo-wijcombobox-row'></ul>");a.each(b.cells,function(d,f){var b=a("<li class='wijmo-wijcombobox-cell ui-state-default'></li>");if(c.columns&&c.columns.length>d)typeof c.columns[d].width!=="undefined"&&b.width(c.columns[d].width);b.append(f);b.attr("title",f);e.append(b)});d.append(e)},superPanelOptions:{resized:function(){var d=b.menu,a=d.element;c.dropdownWidth=a.outerWidth();c.dropdownHeight=a.outerHeight();b._positionList();b.menu.refreshSuperPanel()}}};e=a.extend(true,e,c.listOptions);b.menu=d.appendTo("body",g).wijlist(e).zIndex(b._input.zIndex()+1).css({top:0,left:0}).hide().data("wijlist");b._menuUL=b.menu.ul},_getSelectedItemsText:function(e){var b="",c,d;c=this;d=c.options.multipleSelectionSeparator;c.selectedItems=e;a.each(e,function(c,a){if(a)b+=a.label+d});if(b.length>0)b=b.substr(0,b.lastIndexOf(d));return b},_selectedItemsToInputVal:function(b){var a=this;a._input.val(a._getSelectedItemsText(b))},_createDOMElements:function(){var b=this,e,d,f,g;g=a("<div class='wijmo-wijcombobox-wrapper ui-state-default ui-corner-all'></div>");d=b.element;if(d.is("select")){e=a("<div role='combobox' class='wijmo-wijcombobox ui-widget ui-helper-clearfix'></div>");e.append(g);b._comboElement=e;b._select=d;d.addClass("ui-widget");f=b._input=a("<input role='textbox' aria-autocomplete='list' aria-haspopup='true' />").insertAfter(d);if(!b.options.data)b.options.data=b._convertSelectOptions()}else if(d.is("div")&&a(d.children()[0]).is("input[type='text']")&&a(d.children()[1]).is("div")){b._comboElement=b._comboDiv=e=d;b._oriList=a(d.children()[1]);f=b._input=a(d.children()[0]);g.prependTo(e).append(f);d.addClass("wijmo-wijcombobox ui-widget ui-helper-clearfix");d.attr("role","combobox")}else{e=a("<div role='combobox' class='wijmo-wijcombobox ui-widget ui-helper-clearfix'></div>");e.append(g);b._comboElement=e;f=b._input=d}if(!b._comboDiv){e.insertBefore(f);b.element.is(":visible")&&f.width(f.width());e.children(".wijmo-wijcombobox-wrapper").append(f)}f.attr({autocomplete:"off",role:"textbox","aria-wijcombobox":"list","aria-haspopup":"true"}).addClass(h);b._oldWidth=d.css("width");if(b.options.isEditable===false){f.attr("readonly","readonly");g.bind("click",function(){if(b.options.disabledState===true||b.options.disabled)return;b._triggerClick()})}e.bind("mouseenter",function(){if(b.options.disabledState===true||b.options.disabled)return;b._addInputFocus(true,c)}).bind("mouseleave",function(){b._addInputFocus(false,c)})},_convertSelectOptions:function(){var d=[],b,c;b=this;c=b._select.get(0).options;a.each(c,function(b,a){d.push({label:a.text,value:a.value})});b.options.selectedIndex=b._select[0].selectedIndex;return d},getComboElement:function(){return this._comboElement},_showTrigger:function(){var h=this,k,j,q,p,r,t=0,b,l,o,m,s,n;k=h.options;j=h._input;q=j.parent();p=h._comboElement;b=h._triggerArrow;l=h._label;if(h._select!==undefined){if(!a.browser.msie)t=h._select.width();else{r=h._select.clone();h._select.after(r);t=r.width();r.remove()}j.width(t+(k.data.length>20?k.selectElementWidthFix:0));h._select.hide()}j.css("margin-left","");j.css("margin-right","");p.width(q[0].offsetWidth);if(k.labelText!==null){l=h._label=a(g);q.append(l.html(k.labelText))}else if(l!==undefined){l.remove();h._label=undefined}if(k.showTrigger){j.removeClass("ui-corner-all");if(b===undefined){b=h._triggerArrow=a(i);p.append(b);b.bind("mouseover.triggerevent",h,function(d){if(k.disabledState===true||k.disabled)return;var b=a(d.currentTarget);b.addClass(c)}).bind("mousedown.triggerevent",h,function(c){if(k.disabledState===true||k.disabled)return;var b=a(c.currentTarget);b.addClass(d)}).bind("mouseup.triggerevent",h,function(c){var b=a(c.currentTarget);b.removeClass(d)}).bind("click.triggerevent",h,function(){if(k.disabledState===true||k.disabled)return;h._triggerClick()})}if(k.triggerPosition==="right"){b.css({left:"",right:"0px"});b.removeClass(f);b.addClass(e)}else{b.css({right:"",left:"0px"});b.removeClass(e);b.addClass(f)}b.setOutHeight(p.innerHeight());o=b.find("span");o.css("margin-left",(b.innerWidth()-o[0].offsetWidth)/2);o.css("margin-top",(b.innerHeight()-o[0].offsetHeight)/2)}else{if(b!==undefined){b.unbind(".triggerevent");b.remove();h._triggerArrow=undefined}j.removeClass("ui-corner-left");j.removeClass("ui-corner-right");j.addClass("ui-corner-all")}m=s=n=0;if(l!==undefined)s+=l[0].offsetWidth;if(b!==undefined)n=b[0].offsetWidth;m=s+n;j.setOutWidth(q.innerWidth()-m);m=m===0?"":m;if(k.triggerPosition==="right"){j.css("margin-left","");j.css("margin-right",m);if(l!==undefined){l.css("left","");l.css("right",n)}}else{j.css("margin-right","");j.css("margin-left",m);if(l!==undefined){l.css("right","");l.css("left",n)}}},_triggerClick:function(c){var a=this,b="";window.clearTimeout(a.closing);if(a.menu.element.is(":visible"))a.close();else{if(a._usingRemoteData())b=a._input.val();a.search(b,c)}},destroy:function(){var b=this,c=b.element;b.options.isEditable===false&&c.removeAttr("readonly");if(b._select!==undefined){b._select.removeClass("ui-widget");b._select.show();b._input.remove()}else if(b._comboDiv){b._comboDiv.removeClass("wijmo-wijcombobox ui-widget ui-helper-clearfix");b._comboDiv.removeAttr("role");b._input.insertBefore(b._comboDiv);b._comboDiv.children(".wijmo-wijcombobox-wrapper").remove()}else{c.css("width",b._oldWidth);c.removeClass(h);c.removeAttr("autocomplete").removeAttr("role").removeAttr("aria-wijcombobox").removeAttr("aria-haspopup");c.insertBefore(b._comboElement);c.css("padding","")}b._comboElement.remove();b.menu.destroy();b.menu.element.remove();a.Widget.prototype.destroy.call(b)},_setOption:function(h,f){var b=this,l,d,c,m,e=b._label,j,k=0,i=b.options;l=b._comboElement;d=b.element;m=d.parent();if(b._triggerArrow)k=b._triggerArrow.outerWidth();a.Widget.prototype._setOption.apply(b,arguments);if(h==="disabled")if(f){l.addClass("wijmo-wijcombobox-disabled ui-state-disabled");d.attr("disabled","disabled");b._comboDiv&&b._input.addClass("wijmo-wijcombobox-disabled ui-state-disabled").attr("disabled","disabled");b._triggerArrow&&b._triggerArrow.unbind("click.triggerevent");b.close()}else{l.removeClass("wijmo-wijcombobox-disabled ui-state-disabled");d.removeAttr("disabled");b._comboDiv&&b._input.removeClass("wijmo-wijcombobox-disabled ui-state-disabled").removeAttr("disabled");b._triggerArrow&&b._triggerArrow.bind("click.triggerevent",b,function(){if(i.disabledState===true)return;b._triggerClick()})}else if(h==="labelText"){if(i.labelText!==null){e=b._label=a(g);b._input.parent().append(e.html(i.labelText));if(b._triggerArrow!==undefined)j=b._triggerArrow[0].offsetWidth;if(i.triggerPosition==="right"){if(e!==undefined){e.css("left","");e.css("right",j)}}else if(e!==undefined){e.css("right","");e.css("left",j)}b.repaint()}else if(e!==undefined){e.remove();b._label=undefined}}else if(h==="showTrigger"){b._showTrigger();!i.showTrigger&&b.element.is("select")&&d.width(d.width()+k)}else if(h==="triggerPosition"){d.width(d.width()+k);b._showTrigger()}else if(h==="selectionMode")b.menu._setOption("selectionMode",f);else if(h==="isEditable")if(f){d.removeAttr("readonly");a(".wijmo-wijcombobox-wrapper",b._comboElement[0]).bind("click",function(){b._triggerClick()})}else{d.attr("readonly","readonly");a(".wijmo-wijcombobox-wrapper",b._comboElement[0]).unbind("click")}else if(h==="data"){b.selectedItem=null;b.options.selectedIndex=-1;b.options.selectedValue=null;b._input.val("")}else if(h==="selectedIndex")if(f>-1){if(b.selectedItem!==null)b.selectedItem.selected=false;c=b.items;if(!c)c=b.options.data;if(c&&c[f]!==null){b.selectedItem=c[f];b.selectedItem.selected=true;b._input.val(b.selectedItem.label);i.selectedValue=b.selectedItem.value}}else(f<=-1||!f)&&b._clearSelection();else if(h==="selectedValue")if(f){if(b.selectedItem!==null)b.selectedItem.selected=false;c=b.items;if(!c)c=b.options.data;a.each(c,function(a){if(c[a].value===f){b.selectedItem=c[a];b.selectedItem.selected=true;b._input.val(b.selectedItem.label);b.options.selectedIndex=a;return false}})}else b._clearSelection()},search:function(g,d){var b=this,f,c,e;f=b.options;c=f.data;window.clearTimeout(b.closing);e={value:g,e:d,self:b};if(c!==null||b._comboDiv){if(d!=="checkindex")if(b._trigger("search",d,{datasrc:c,term:e})===false)return;if(a.isArray(c)||b._comboDiv){b._hideShowArrow(false);b._onListLoaded(c,e)}else{if(b._usingRemoteData()&&d!==undefined&&g.length<f.minLength)return;b._hideShowArrow(false);c.loaded=function(c,a){b._onListLoaded(c,a);b.originalDataSourceLoaded&&b.originalDataSourceLoaded(c,a)};c.load(e)}}},_clearSelection:function(){var b=this,c=b.options;if(c.selectionMode==="single"){if(b.selectedItem!==null)b.selectedItem.selected=false;b.selectedItem=null}else if(b.selectedItems){a.each(b.selectedItems,function(b,a){if(a.selected)a.selected=false});b.selectedItem=null;b.selectedItems=null}c.selectedValue=null;b._input.val("")},_usingRemoteData:function(){var b=this.options.data,c=false;if(!a.isArray(b)&&b!==null&&b.proxy!==null)c=true;return c},_hideShowArrow:function(d){var c=this,b,a;b=c.element;a=c._triggerArrow;a!==undefined&&a[d?"show":"hide"]();b[d?"removeClass":"addClass"]("wijmo-wijcombobox-loading")},_onListLoaded:function(g,h){var c=h.self,k,i,j,d,f,e;k=c._input;i=c.options;j=h.value;if(g===null)d=null;else d=a.isArray(g)?g:g.items;c.items=d;if(h.e==="checkindex"){f=i.selectedIndex;if(i.selectionMode==="multiple"&&a.isArray(f)){a.each(f,function(e,b){var a=d[b];a.selected=true;c.selectedItems.push(a)});c._selectedItemsToInputVal(c.selectedItems)}else{d[f].selected=true;c.selectedItem=d[f];k.val(c.selectedItem.label)}c._hideShowArrow(true);return}if(!c._usingRemoteData()&&d){c._filter(d,j);e=a.grep(d,function(a){return!i.autoFilter||a.match})}else{c._topHit=null;e=d}if(e&&e.length>0||c._comboDiv){c._openlist(e,h,j);c._trigger("open");c._addInputFocus(true,b)}else c.close(null,true);c._hideShowArrow(true)},close:function(h,g){var e=this,d,c,f;d=e.menu;e._dropDownHeight=d.element.outerHeight();e._dropDownWidth=d.element.outerWidth();window.clearTimeout(e.closing);if(d.element.is(":visible")&&!d.element.is(":animated")&&!d.element.parent().is(":animated")){e._trigger("close",h);d.deactivate();c=e.options.hidingAnimation;if(c&&(c.effect==="size"||c.animated==="size"))c.options=a.extend({to:{width:0,height:0}},c.options);f=d.element.attr("style");if(g!==true&&c)d.element.hide(c.effect||c.animated,c.options,c.speed||c.duration,function(){d.element.removeAttr("style").attr("style",f).hide();c.callback&&c.callback.apply(this,arguments)});else d.element.hide();e._addInputFocus(false,b);a(document).unbind("click",e.closeOnClick)}},_change:function(){var a=this,f,g,e,c,h,b,d;f=a.options;g=f.forceSelectionText;e=f.selectionMode;c=a._input;h=c.val();b=a.selectedItem;d=a.selectedItems;if(g)if(e==="single")if(b!==null)b.label!==h&&c.val(b.label);else c.val("");if(e==="multiple"){if(!a.selectedItems||a.selectedItems.length===0)d=[b];a._selectedItemsToInputVal(d)}},_openlist:function(s,p,g){var b=p.self,f=p.e,i,h,c,e,o,r=2,l=0,k,j,q,d,m,n;i=b._keypress=!!f;e=b.options;c=b.menu.element;c.zIndex(b.element.zIndex()+100);if(b._comboDiv){if(!b.listHasCreated){b.menu.setTemplateItems(e.data);b.menu.renderList();b.listHasCreated=true}if(g!==null&&g!==undefined)b._topHit=b.menu.filterTemplateItems(g)}else{b.menu.setItems(s);b.menu.renderList()}b.menu.element.show();if(e.dropdownWidth==="auto")h=b._comboElement.outerWidth();else h=e.dropdownWidth;o=c.css("padding");c.css("padding","0px");c.setOutWidth(h);c.css("padding",o);k=e.dropdownHeight;if(c.children(".wijmo-wijsuperpanel-header"))l=c.children(".wijmo-wijsuperpanel-header").outerHeight()||0;q=Math.min(b._menuUL.outerHeight()+r+l,k);c.setOutHeight(q);b.menu.refreshSuperPanel();b._positionList();!i&&b.selectedItem!==undefined&&b.menu.activate(null,b.selectedItem,true);if(i&&f.keyCode!==a.ui.keyCode.BACKSPACE)if(e.isEditable)b._runAutoComplete();else b.menu.activate(null,b._topHit,true);else{d=b.options.showingAnimation;if(e.showingAnimation!==null&&!(f!==undefined&&f.keyCode===a.ui.keyCode.BACKSPACE)){b.menu.element.hide();n={from:{width:0,height:0},to:{width:b._dropDownWidth||c.outerWidth(),height:b._dropDownHeight||c.outerHeight()}};if(d&&(d.effect==="size"||d.animated==="size"))d.options=a.extend(n,d.options);m=c.attr("style");c.show(d.effect||d.animated,d.options,d.speed||d.duration,function(){c.removeAttr("style").attr("style",m).show();d.callback&&d.callback.apply(this,arguments);a.browser.msie&&c.css("filter","")})}}if(!b.hasOwnProperty("closeOnClick")){j=b.closeOnClick;b.closeOnClick=function(a){return j(a)}}a(document).bind("mouseup",b,b.closeOnClick)},closeOnClick:function(c){var b=c.data,d=c.target;if(!a.contains(b._comboElement[0],d)&&!a.contains(b.menu.element[0],d)){b.close();a(".wijmo-wijcombobox-wrapper",b._comboElement[0]).removeClass("ui-state-hover").removeClass("ui-state-focus");a(".wijmo-wijcombobox-trigger",b._comboElement[0]).removeClass("ui-state-hover").removeClass("ui-state-focus")}},_positionList:function(){var c=this,d,b;d=c.options.dropDownListPosition;b={my:"left top",at:"left bottom",of:c._comboElement,collision:"none"};b=a.extend(b,d);c.menu.element.position(b)},_runAutoComplete:function(){var a=this,c,b,e,d,f,g;c=a._input;b=a._topHit;if(!a.options.autoComplete||b===null)return;a.menu.activate(null,b,true);e=c.val();d=b.label;c.val(d);f=e.length;g=d.length;a._selectText(f,g,c)},_selectText:function(d,e,c){var f=c.val(),a=c.get(0),b;if(f.length>0)if(a.setSelectionRange!==undefined)a.setSelectionRange(d,e);else if(a.createTextRange!==undefined){b=a.createTextRange();b.moveStart("character",d);b.moveEnd("character",e-f.length);b.select()}},_move:function(a,b){if(!this.menu.element.is(":visible")){this.search("",b);return}if(this.menu.first()&&/^previous/.test(a)||this.menu.last()&&/^next/.test(a))return;this.menu[a](b)},_escapeRegex:function(a){return a===undefined?a:a.replace(/([\^\$\(\)\[\]\{\}\*\.\+\?\|\\])/gi,"\\$1")},_filter:function(c,f){var d=this._escapeRegex(f),e,b=null;if(!c)return null;e=new RegExp(d,"i");a.each(c,function(f,a){if(d===undefined||d.length===0){a.match=true;return}var c=e.exec(a.label);if(c===null)a.match=false;else{if(b===null&&c.index===0)b=a;a.match=c.index>=0}});this._topHit=b;return c}})})(jQuery);
(function(a){"use strict";window.wijinputcore={options:{culture:"",invalidClass:"ui-state-error",nullText:"",showNullText:false,hideEnter:false,disableUserInput:false,buttonAlign:"right",showTrigger:false,showSpinner:false,comboItems:undefined,comboWidth:undefined,comboHeight:undefined,initializing:null,initialized:null,triggerMouseDown:null,triggerMouseUp:null,textChanged:null,invalidInput:null},_create:function(){var b=this,e=b.element.width(),d,c;if(b.element[0].tagName.toLowerCase()!=="input")throw"Target element is not a INPUT";if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);b.element.is(":hidden")&&b.element.wijAddVisibilityObserver&&b.element.wijAddVisibilityObserver(function(){b.destroy();b._create();b.element.wijRemoveVisibilityObserver&&b.element.wijRemoveVisibilityObserver()},"wijinput");b.element.data("widgetName",this.widgetName);a.effects.save(b.element,["width","height"]);b.element.wrap("<div class='wijmo-wijinput ui-widget ui-helper-clearfix ui-state-default ui-corner-all'><span class='wijmo-wijinput-wrapper'></span></div>");b.element.addClass("wijmo-wijinput-input ui-corner-all").attr({role:"textbox","aria-multiline":false});b.wrapper=b.element.parent();b.outerDiv=b.wrapper.parent();b.outerDiv.width(e);if(b.options.showTrigger){b.triggerBtn=a("<div class='wijmo-wijinput-trigger ui-state-default'><span class='ui-icon ui-icon-triangle-1-s'></span></div>").addClass(b.options.buttonAlign==="left"?"ui-corner-left":"ui-corner-right").attr("role","button").appendTo(b.outerDiv);b.element.attr({role:"combobox","aria-expanded":false})}if(b.options.showSpinner){b.spinner=a("<div class='wijmo-wijinput-spinner wijmo-wijinput-button'></div>");b.spinUp=a("<div class='ui-state-default wijmo-wijinput-spinup'><span class='ui-icon ui-icon-triangle-1-n'></span></div>").attr("role","button");b.spinDown=a("<div class='ui-state-default wijmo-wijinput-spindown'><span class='ui-icon ui-icon-triangle-1-s'></span></div>").attr("role","button");if(!b.options.showTrigger){b.spinUp.addClass(b.options.buttonAlign==="left"?"ui-corner-tl":"ui-corner-tr");b.spinDown.addClass(b.options.buttonAlign==="left"?"ui-corner-bl":"ui-corner-br")}b.spinner.append(b.spinUp).append(b.spinDown).appendTo(b.outerDiv);b.element.attr("role","spinner")}if(b.options.showTrigger&&b.options.showSpinner)b.outerDiv.addClass(b.options.buttonAlign==="left"?"ui-input-spinner-trigger-left":"ui-input-spinner-trigger-right");else{b.options.showTrigger&&b.outerDiv.addClass(b.options.buttonAlign==="left"?"ui-input-trigger-left":"ui-input-trigger-right");b.options.showSpinner&&b.outerDiv.addClass(b.options.buttonAlign==="left"?"ui-input-spinner-left":"ui-input-spinner-right")}d=b.element.leftBorderWidth()+b.element.rightBorderWidth();b.element.width(b.outerDiv.width()-d);b._initialize();if(b.element.width()>=b.wrapper.width()){c=parseFloat(b.element.css("padding-left").replace(/px/,""),10)||0;c+=parseFloat(b.element.css("padding-right").replace(/px/,""),10)||0;b.element.width(b.element.width()-c)}},_createTextProvider:function(){return undefined},_beginUpdate:function(){},_endUpdate:function(){},_onTriggerClicked:function(){},_initialize:function(){this.element.data("initializing",true);this._trigger("initializing");this.element.data("preText",this.element.val());this.element.data("elementValue",this.element.val());this.element.data("errorstate",false);this.element.data("breakSpinner",true);this.element.data("prevCursorPos",-1);this.element.data("simulating",false);this._createTextProvider();this._beginUpdate();var c=this.options,b=this,g,d=function(a){return(!a.which?a.button:a.which)===1},e=function(c){if(b.options.disabled)return;if(!d(c))return;b._trySetFocus();b.element.data("breakSpinner",false);b._addState("active",a(this));b._doSpin(a(c.currentTarget).hasClass("wijmo-wijinput-spinup"),true)},f=function(c){if(b.options.disabled)return;if(!d(c))return;b._stopSpin();b._removeState("active",a(this))};this.triggerBtn&&!c.disabledState&&this.triggerBtn.bind({mouseover:function(){if(b.options.disabled)return;b._addState("hover",a(this))},mouseout:function(){if(b.options.disabled)return;b._removeState("hover",a(this))},mousedown:function(c){if(b.options.disabled)return;if(!d(c))return;b._addState("active",a(this));b._trigger("triggerMouseDown")},click:function(c){if(b.options.disabled)return;b._stopEvent(c);b._stopSpin();b._removeState("active",a(this));b._trigger("triggerMouseUp");b._onTriggerClicked();b._trySetFocus()}});this.spinUp&&!c.disabledState&&this.spinUp.bind({mouseover:function(){if(b.options.disabled)return;b._addState("hover",a(this))},mouseout:function(){if(b.options.disabled)return;b._removeState("hover",a(this));b._removeState("active",a(this));b._stopSpin()},mousedown:e,mouseup:f});this.spinDown&&!c.disabledState&&this.spinDown.bind({mouseover:function(){if(b.options.disabled)return;b._addState("hover",a(this))},mouseout:function(){if(b.options.disabled)return;b._removeState("hover",a(this));b._removeState("active",a(this));b._stopSpin()},mousedown:e,mouseup:f});this.element.bind({"focus.wijinput":a.proxy(this._onFocus,this),"blur.wijinput":a.proxy(this._onBlur,this),"mouseup.wijinput":a.proxy(this._onMouseUp,this),"keypress.wijinput":a.proxy(this._onKeyPress,this),"keydown.wijinput":a.proxy(this._onKeyDown,this),"keyup.wijinput":a.proxy(this._onKeyUp,this),"change.wijinput":a.proxy(this._onChange,this),"paste.wijinput":a.proxy(this._onPaste,this),"drop.wijinput":a.proxy(this._onDrop,this)});this.element.bind("propertychange.wijinput input.wijinput",a.proxy(this._onInput,this));this.element.data("initializing",false);this._resetData();this._endUpdate();this._updateText();if(this.options.disabledState){g=c.disabled;this.disable();c.disabled=g}this.options.disabled&&this.disable();this.element.data("initialized",true);this._trigger("initialized")},_init:function(){},_setOption:function(c,b){a.Widget.prototype._setOption.apply(this,arguments);switch(c){case"buttonAlign":case"showTrigger":case"showSpinner":this._destroy();this._create();break;case"showNullText":this._updateText();break;case"disabled":this.element.attr("disabled",b);this.element[b?"addClass":"removeClass"](this.namespace+"-state-disabled");this.triggerBtn!==undefined&&this.triggerBtn[b?"addClass":"removeClass"](this.namespace+"-state-disabled");this.spinup!==undefined&&this.spinup[b?"addClass":"removeClass"](this.namespace+"-state-disabled");this.spindown!==undefined&&this.spindown[b?"addClass":"removeClass"](this.namespace+"-state-disabled")}},destroy:function(){a.Widget.prototype.destroy.apply(this,arguments);this._destroy()},_destroy:function(){this.wrapper=undefined;this.outerDiv=undefined;this.element.unbind(".wijinput");this.element.removeData("errorstate").removeData("breakSpinner").removeData("prevCursorPos").removeData("simulating").removeData("isPassword").removeClass("wijmo-wijinput-input").removeAttr("role").removeAttr("aria-valuemin").removeAttr("aria-valuemax").removeAttr("aria-valuenow").removeAttr("aria-expanded");this.element.parent().replaceWith(this.element);this.element.parent().replaceWith(this.element);a.effects.restore(this.element,["width","height"])},widget:function(){return this.outerDiv},_getCulture:function(a){return Globalize.findClosestCulture(a||this.options.culture)},_addState:function(b,a){a.is(":not(.ui-state-disabled)")&&a.addClass("ui-state-"+b)},_removeState:function(a,b){b.removeClass("ui-state-"+a)},_isInitialized:function(){return!this.element.data("initializing")},_setData:function(a){this.setText(a)},_resetData:function(){},_validateData:function(){},getText:function(){return!this._isInitialized()?this.element.val():this._textProvider.toString(true,false,false)},setText:function(a){if(!this._isInitialized())this.element.val(a);else{this._textProvider.set(a);this._updateText()}},getPostValue:function(){return!this._isInitialized()?this.element.val():this._textProvider.toString(true,false,true)},selectText:function(a,b){if(this.element.is(":disabled"))return;this.element.wijtextselection(a,b)},focus:function(){if(this.element.is(":disabled"))return;this.element.get(0).focus()},isFocused:function(){return this.outerDiv.hasClass("ui-state-focus")},_raiseTextChanged:function(){var a=this.element.val(),b=this.element.data("preText");if(!!this.element.data("initialized")&&b!==a){this._trigger("textChanged",null,{text:a});this.element.data("changed",true)}this.element.data("preText",a)},_raiseDataChanged:function(){},_allowEdit:function(){return!(this.element.attr("readOnly")&&this.element.is(":disabled"))},_updateText:function(a){if(!this._isInitialized())return;a=!!a;var b=this.element.wijtextselection(),c=this.options;if(this.isDeleteAll&&c.showNullText){this.isDeleteAll=false;c.date=null;this.element.val(c.nullText)}else{this.element.val(this._textProvider.toString());this.options.text=this._textProvider.toString(true,false,false)}if(this.element.is(":disabled"))return;a&&this.selectText(b.start,b.end);this.element.data("prevCursorPos",b.start);this._raiseTextChanged();this._raiseDataChanged()},_trySetFocus:function(){if(!this.isFocused())try{!this.options.disableUserInput&&this.element.focus()}catch(a){}},_deleteSelText:function(c){if(!this._allowEdit())return;var a=this.element.wijtextselection(),b;c=!!c;if(c)if(a.end===a.start)if(a.end>=1){a.end=a.end-1;a.start=a.start-1}else return;else a.end=a.end-1;else a.end=a.end-1;if(a.end<a.start)a.end=a.start;b=new wijInputResult;this._textProvider.removeAt(a.start,a.end,b);this._updateText();this.selectText(b.testPosition,b.testPosition)},_fireIvalidInputEvent:function(c){var a=this,b;if(a._trigger("invalidInput",null,{widget:a,"char":c})===true)return;if(!a.element.data("errorstate")){b=a.options.invalidClass||"ui-state-error";a.element.data("errorstate",true);window.setTimeout(function(){a.outerDiv.removeClass(b);a.element.data("errorstate",false)},100);a.outerDiv.addClass(b)}},_onInput:function(){if(!this._isSimulating()||!this.element.data("ime"))return;this._simulate()},_keyDownPreview:function(){return false},_beforeSimulate:function(a){if(!this.element.data("lastSelection")){this.element.data("lastSelection",this.element.wijtextselection());this.element.data("lastValue",this.element.val())}this.element.data("ime",a);this.element.data("simulating",true)},_isSimulating:function(){return this.element.data("simulating")},_simulate:function(f){var a=this,b=null,e,c,d;if(typeof f==="string")b=f;else{e=this.element.wijtextselection();c=this.element.data("lastSelection").start;d=e.end;if(d>=c)b=this.element.val().substring(c,d)}b&&window.setTimeout(function(){if(!a.element.data("lastValue"))return;a.element.val(a.element.data("lastValue"));var e=a.element.data("lastSelection"),c,d;a.element.wijtextselection(e);a.element.data("batchKeyPress",true);a.element.data("simulating",false);c=jQuery.Event("keypress");c.ctrlKey=c.altKey=false;for(d=0;d<b.length;d++){c.which=c.charCode=c.keyCode=b.charCodeAt(d);a._onKeyPress(c)}a.element.data("batchKeyPress",false);a._endSimulate()},1)},_endSimulate:function(){this.element.removeData("ime");this.element.removeData("lastSelection");this.element.removeData("lastValue")},_onKeyDown:function(b){this.element.data("prevCursorPos",-1);if(!this._isInitialized()||this._textProvider&&!!this._textProvider.noMask)return;var c=this._getKeyCode(b);if(c===229){this._beforeSimulate(true);return}this._endSimulate();if(this.options.disableUserInput){this._stopEvent(b);return}if(this._keyDownPreview(b)){this._stopEvent(b);return}switch(c){case a.ui.keyCode.UP:this._doSpin(true,false);this._stopEvent(b);return;case a.ui.keyCode.DOWN:this._doSpin(false,false);this._stopEvent(b);return}if(b.ctrlKey)switch(c){case a.ui.keyCode.INSERT:case 67:return}if(b.ctrlKey||b.altKey)return;switch(c){case 112:case 113:case 114:case 115:case 116:case 117:case a.ui.keyCode.TAB:case a.ui.keyCode.CAPSLOCK:case a.ui.keyCode.END:case a.ui.keyCode.HOME:case a.ui.keyCode.CTRL:case a.ui.keyCode.SHIFT:return;case a.ui.keyCode.BACKSPACE:this._deleteSelText(true);this._stopEvent(b);return;case a.ui.keyCode.DELETE:this._deleteSelText(false);this._stopEvent(b);return;case a.ui.keyCode.ENTER:if(!this.options.hideEnter)return;break;case a.ui.keyCode.ESCAPE:this._stopEvent(b);window.setTimeout(a.proxy(this._resetData,this),1);return;case a.ui.keyCode.PAGE_UP:case a.ui.keyCode.PAGE_DOWN:case a.ui.keyCode.ALT:this._stopEvent(b);return}},_onKeyUp:function(b){if(this._isSimulating()||this._textProvider&&!!this._textProvider.noMask)return;var c=this._getKeyCode(b);if(!this._isInitialized())return;if(c===a.ui.keyCode.ENTER)return;if(c===a.ui.keyCode.ESCAPE)return;if(this.options.disableUserInput){this._raiseTextChanged();this._raiseDataChanged();return}this._stopEvent(b)},_getKeyCode:function(a){var b=window.navigator.userAgent;return(b.indexOf("iPod")!==-1||b.indexOf("iPhone")!==-1)&&a.which===127?8:a.keyCode||a.which},_keyPressPreview:function(){return false},_onKeyPress:function(b){if(this._isSimulating()||this._textProvider&&!!this._textProvider.noMask)return;this.element.data("prevCursorPos",-1);if(this.options.disableUserInput)return;if(!this._allowEdit())return;if(b.ctrlKey&&b.keyCode===119){this._onPaste(b);return}if(b.which===0)return;var d=b.keyCode||b.which,c,f,e,g;if(d===a.ui.keyCode.BACKSPACE){this._stopEvent(b);return}if(b.ctrlKey||b.altKey)if(d!==a.ui.keyCode.SPACE)return;if(this._keyPressPreview(b))return;if(d===a.ui.keyCode.ENTER&&!this.options.hideEnter)return true;c=this.element.wijtextselection();f=String.fromCharCode(d);c.start<c.end&&this._textProvider.removeAt(c.start,c.end-1,new wijInputResult,true);e=new wijInputResult;g=this._textProvider.insertAt(f,c.start,e);if(g){this._updateText();this.selectText(e.testPosition+1,e.testPosition+1)}else this._fireIvalidInputEvent(f);!this.element.data("batchKeyPress")&&this._stopEvent(b)},_isNullText:function(a){a=a||this.element.val();return this.options.showNullText&&a===this.options.nullText},_doFocus:function(){var d=this.element.wijtextselection(),b=d.start,c;this._updateText();c=this.element.val();if(c.length===b)b=0;!a.browser.safari&&this.selectText(b,b)},_afterFocused:function(){this._isNullText()&&this._doFocus()},_onFocus:function(){if(this.options.disableUserInput)return;this._addState("focus",this.outerDiv);if(!this.element.data("breakSpinner"))return;if(!this._isInitialized())return;if(!this._allowEdit())return;!this.element.data("focusNotCalledFirstTime")&&this.element.data("focusNotCalledFirstTime",+new Date);this._afterFocused()},_onBlur:function(){if(this.options.disableUserInput)return;if(this._isComboListVisible())return;var c=this.isFocused(),b,a=this;this._removeState("focus",this.outerDiv);if(!this.element.data("breakSpinner")){this.element.get(0).focus();b=this.element.data("prevCursorPos");b!==undefined&&b!==-1&&this.selectText(b,b);return}if(!this._isInitialized())return;if(!c)return;this.element.data("value",this.element.val());window.setTimeout(function(){a._onChange();a._updateText();a._validateData();!a._popupVisible()&&!!a.element.data("changed")&&a._trigger("change");a.element.data("changed",false)},100)},_popupVisible:function(){return this._isComboListVisible()},_onMouseUp:function(){if(!this._isInitialized())return;if(this.element.is(":disabled"))return;var a=this.element.wijtextselection();this.element.data("prevCursorPos",a.start)},_onChange:function(){if(!this.element)return;var a=this.element.val(),b=this.getText();b!==a&&this.setText(a)},_onPaste:function(){if(this._textProvider&&!!this._textProvider.noMask)return;this._beforeSimulate();var a=this;window.setTimeout(function(){a._simulate()},1)},_onDrop:function(a){this._beforeSimulate();if(a.originalEvent&&a.originalEvent.dataTransfer){var b=a.originalEvent.dataTransfer.getData("Text");b&&this._simulate(b)}},_stopEvent:function(a){a.stopPropagation();a.preventDefault()},_calcSpinInterval:function(){this._repeatingCount++;return this._repeatingCount>10?50:this._repeatingCount>4?100:this._repeatingCount>2?200:400},_doSpin:function(){},_stopSpin:function(){this.element.data("breakSpinner",true);this._repeatingCount=0},_hasComboItems:function(){return!!this.options.comboItems&&this.options.comboItems.length},_isComboListVisible:function(){return!this._comboDiv?false:this._comboDiv.wijpopup("isVisible")},_popupComboList:function(){if(!this._hasComboItems())return;if(!this._allowEdit())return;if(this._isComboListVisible()){this._comboDiv.wijpopup("hide");return}var b=this,c;if(this._comboDiv===undefined){this._comboDiv=a("<div></div>").appendTo(document.body).width(this.element.width()).height(this.options.comboHeight||180).css("position","absolute");c=this._normalize(this.options.comboItems);this._comboDiv.wijlist({autoSize:true,maxItemsCount:5,selected:function(c,a){b._setData(a.item.value);b._comboDiv.wijpopup("hide");b._trySetFocus()}});this._comboDiv.wijlist("setItems",c);this._comboDiv.wijlist("renderList");this._comboDiv.wijlist("refreshSuperPanel")}this._comboDiv.wijpopup({autoHide:true});this.outerDiv.attr("aria-expanded",true);this._comboDiv.wijpopup("show",{of:this.outerDiv,offset:"0 4",hidden:function(){b.outerDiv.attr("aria-expanded",false)}})},_normalize:function(b){return b.length&&b[0].label&&b[0].value?b:a.map(b,function(b){return typeof b==="string"?{label:b,value:b}:a.extend({label:b.label||b.value,value:b.value||b.label},b)})}};window.wijInputResult=function(){this.alphanumericCharacterExpected=-2;this.asciiCharacterExpected=-1;this.digitExpected=-3;this.invalidInput=-51;this.letterExpected=-4;this.nonEditPosition=-54;this.positionOutOfRange=-55;this.promptCharNotAllowed=-52;this.signedDigitExpected=-5;this.unavailableEditPosition=-53;this.testPosition=-1};window.wijInputResult.prototype={characterEscaped:1,noEffect:2,sideEffect:3,success:4,unknown:0,hint:0,clone:function(){var a=new wijInputResult;a.hint=this.hint;a.testPosition=this.testPosition;return a}}})(jQuery);
(function(b){"use strict";var z,a,c,y,i,j,k,l,m,n,d,e,h,w,x,o,p,q,r,f,g,s,t,u,v;b.widget("wijmo.wijinputdate",b.extend(true,{},wijinputcore,{options:{date:null,minDate:null,maxDate:null,dateFormat:"d",startYear:1950,smartInputMode:true,activeField:0,keyDelay:800,autoNextField:true,calendar:"default",popupPosition:{offset:"0 4"},dateChanged:null},_createTextProvider:function(){this._textProvider=new z(this,this.options.dateFormat)},_strToDate:function(a){return this._textProvider.parseDate(a)},_beginUpdate:function(){var a=this.options,c,b=null;if(a.minDate)if(typeof a.minDate==="string")a.minDate=this._strToDate(a.minDate);if(a.maxDate)if(typeof a.maxDate==="string")a.maxDate=this._strToDate(a.maxDate);if(!a.date){if(!!this.element.data("elementValue"))c=this.element.data("elementValue")}else if(typeof a.date==="string")c=a.date;else b=a.date;if(c)b=this._strToDate(c);this._safeSetDate(b);this.element.data({defaultDate:b===null?b:new Date(a.date.getTime()),preDate:b===null?b:new Date(a.date.getTime())});this._resetTimeStamp();a.showTrigger&&!this._hasComboItems()&&this._initCalendar();this.element.addClass("wijmo-wijinput-date").attr({"aria-valuemin":new Date(1900,1,1),"aria-valuemax":new Date(2099,1,1),"aria-valuenow":a.date})},_endUpdate:function(){var a=this;this.element.click(function(){a._highLightCursor()});this.element.mousewheel(function(c,b){a._doSpin(b>0,false)})},_onTriggerClicked:function(){if(this._hasComboItems())this._popupComboList();else this._popupOrHideCalendar()},_isValidDate:function(a,c){var b=this.options;if(a===undefined)return false;if(isNaN(a))return false;if(a.getFullYear()<1||a.getFullYear()>9999)return false;if(c){if(b.minDate)if(a<b.minDate)return false;if(b.maxDate)if(a>b.maxDate)return false}return true},_checkRange:function(a){var b=this.options;if(!!a){if(b.minDate&&a<b.minDate)a=new Date(Math.max(b.minDate,a));if(b.maxDate&&a>b.maxDate)a=new Date(Math.min(b.maxDate,a))}return a},_safeSetDate:function(a){var c=this.options,b=a;a=this._checkRange(a);if(isNaN(a))a=b;c.date=a;return true},_safeGetDate:function(){var b=this.options,a=b.date;if(!a)a=new Date;a=this._checkRange(a);return a},_setOption:function(d,a){b.Widget.prototype._setOption.apply(this,arguments);wijinputcore._setOption.apply(this,arguments);switch(d){case"date":if(!!a){if(typeof a==="string")a=this._strToDate(a);else if(typeof a==="object")a=new Date(a.getTime());else a=new Date(a);if(isNaN(a))a=new Date}this._safeSetDate(a);this._updateText();this._highLightField();break;case"dateFormat":case"culture":this._textProvider._setFormat(this.options.dateFormat);this._updateText();var c=this.element.data("calendar",c);c&&c.wijcalendar("option",d,a);break;case"activeField":a=Math.min(a,this._textProvider.getFieldCount()-1);a=Math.max(a,0);this.options.activeField=a;this._highLightField();this._resetTimeStamp();break;case"nextTooltip":case"prevTooltip":case"titleFormat":case"toolTipFormat":var c=this.element.data("calendar",c);c&&c.wijcalendar("option",d,a)}},_setData:function(a){this.option("date",a)},_resetData:function(){var a=this.element.data("defaultDate");if(a===undefined||a===null){a=this.element.data("elementValue");if(a!==undefined&&a!==null&&a!=="")this.setText(a);else this._setData(null)}else this._setData(a)},_resetTimeStamp:function(){this.element.data("cursorPos",0);this.element.data("timeStamp",new Date("1900/1/1"))},getPostValue:function(){if(!this._isInitialized())return this.element.val();if(this.options.showNullText&&this.isDateNull())return"";var a=this._textProvider.toString();return a===this.options.nullText?"":a},_highLightField:function(a){if(a===undefined)a=this.options.activeField;if(this.isFocused()){var b=this._textProvider.getFieldRange(a);b&&this.element.wijtextselection(b)}},_highLightCursor:function(a){if(this._isNullText())return;if(a===undefined)a=Math.max(0,this.element.wijtextselection().start);var b=this._textProvider.getCursorField(a);if(b<0)return;this._setOption("activeField",b)},_toNextField:function(){this._setOption("activeField",this.options.activeField+1)},_toPrevField:function(){this._setOption("activeField",this.options.activeField-1)},_toFirstField:function(){this._setOption("activeField",0)},_toLastField:function(){this._setOption("activeField",this._textProvider.getFieldCount())},_clearField:function(a){if(a===undefined)a=this.options.activeField;var b=this._textProvider.getFieldRange(a),c,d=this;if(b){c=new wijInputResult;this._textProvider.removeAt(b.start,b.end,c);this._updateText();window.setTimeout(function(){d._highLightField()},1)}},_doSpin:function(c,a){c=!!c;a=!!a;if(!this._allowEdit())return;if(a&&this.element.data("breakSpinner"))return;if(this._textProvider[c?"incEnumPart":"decEnumPart"]()){this._updateText();this._highLightField()}a&&!this.element.data("breakSpinner")&&window.setTimeout(b.proxy(function(){this._doSpin(c,true)},this),this._calcSpinInterval())},_onChange:function(){},_afterFocused:function(){this._isNullText()&&this._doFocus();var a=this,b=function(){a._highLightCursor();a._resetTimeStamp()};window.setTimeout(b,10)},_keyDownPreview:function(a){var d=a.keyCode||a.which,c;switch(d){case b.ui.keyCode.LEFT:this._toPrevField();return true;case b.ui.keyCode.RIGHT:this._toNextField();return true;case b.ui.keyCode.TAB:case b.ui.keyCode.SPACE:case 188:case 190:case 110:case 191:if(a.shiftKey){if(this.options.activeField>0){this._toPrevField();return true}}else if(this.options.activeField<this._textProvider.getFieldCount()-1){this._toNextField();return true}break;case b.ui.keyCode.HOME:if(a.ctrlKey)this._setOption("date",new Date);else this._toFirstField();return true;case b.ui.keyCode.END:if(a.ctrlKey)this._setOption("date",new Date("1970/1/1"));else this._toLastField();return true;case b.ui.keyCode.DELETE:if(this._allowEdit()){c=this.element.wijtextselection();if(c.end-c.start===this.element.val().length){this.isDeleteAll=true;this._setOption("date",new Date("1970/1/1"))}else this._clearField();return true}}return false},_autoMoveToNextField:function(a,b){if(!this.options.autoNextField)return;this._textProvider.needToMove(this.options.activeField,a,b)&&this._toNextField()},_keyPressPreview:function(c){var d=c.keyCode||c.which,g,e,i,a,h,f,j,k,l;if(d===b.ui.keyCode.ENTER){if(this.isDateNull())this.options.date=new Date;return false}g=this._textProvider.getFieldRange(this.options.activeField);if(g){if(d===b.ui.keyCode.TAB)return true;if(d===b.ui.keyCode.SPACE){this._stopEvent(c);return true}e=String.fromCharCode(d);i=this._textProvider.isFieldSep(e,this.options.activeField);if(i){this._toNextField();this._stopEvent(c);return true}a=this.element.data("cursorPos");h=new Date;j=this.element.data("timeStamp");this.element.data("timeStamp",h);f=h.getTime()-j.getTime()>this.options.keyDelay;if(f)a=0;k=g.start+a;this.element.data("cursorPos",++a);l=this._textProvider.addToField(e,this.options.activeField,k,!f);if(l){this._updateText();this._autoMoveToNextField(a,e);this._highLightField()}else{this._resetTimeStamp();this._fireIvalidInputEvent()}this._stopEvent(c);return true}return false},_raiseDataChanged:function(){var a=this.options.date,b=this.element.data("preDate");this.element.data("preDate",!a?null:new Date(a.getTime()));if(!b&&a||b&&!a||b&&a&&b.getTime()!==a.getTime()){this._syncCalendar();this.element.attr("aria-valuenow",a);this._trigger("dateChanged",null,{date:a})}},isDateNull:function(){return this.options.date===null||this.options.date===undefined},_isMinDate:function(a){return a.getFullYear()===1&&a.getMonth()===0&&a.getDate()===1},_initCalendar:function(){var d=this,c=d.options,a=c.calendar,e;if(a===undefined||a===null)return;if(typeof a==="boolean"||a==="default"){a=b("<div/>");a.appendTo(document.body)}e=b(a);if(e.length!==1)return;d.element.data("calendar",e);e.wijcalendar({popupMode:true,culture:c.culture,nextTooltip:c.nextTooltip||"Next",prevTooltip:c.prevTooltip||"Previous",titleFormat:c.titleFormat||"MMMM yyyy",toolTipFormat:c.toolTipFormat||"dddd, MMMM dd, yyyy",selectedDatesChanged:function(){var a=b(this).wijcalendar("getSelectedDate");b(this).wijcalendar("close");!!a&&d.option("date",a);d._trySetFocus()}});d._syncCalendar()},_syncCalendar:function(){var a=this.element.data("calendar"),c,b;if(!a)return;c=this.options;b=this._safeGetDate();if(this._isMinDate(b))b=new Date;a.wijcalendar("option","displayDate",b);c.minDate&&a.wijcalendar("option","minDate",c.minDate);c.maxDate&&a.wijcalendar("option","maxDate",c.maxDate);a.wijcalendar("unSelectAll");a.wijcalendar("selectDate",b);a.wijcalendar("refresh")},_popupOrHideCalendar:function(){if(!this._allowEdit())return;var a=this.element.data("calendar");if(!a)return;if(a.wijcalendar("isPopupShowing")){a.wijcalendar("hide");this._trySetFocus();return}this._syncCalendar();a.wijcalendar("popup",b.extend({},this.options.popupPosition,{of:this.outerDiv}))},_isCalendarVisible:function(){if(!this._allowEdit())return false;var a=this.element.data("calendar");return!a?false:a.wijcalendar("isPopupShowing")},_popupVisible:function(){return this._hasComboItems()?this._isComboListVisible():this._isCalendarVisible()}}));z=function(b,a){this.inputWidget=b;this.descriptors=new Array(0);this.desPostions=new Array(0);this.fields=new Array(0);this._setFormat(a)};z.prototype={descriptors:undefined,desPostions:undefined,maskPartsCount:0,pattern:"M/d/yyyy",initialize:function(){},getFieldCount:function(){return this.fields.length},getFieldRange:function(b){var a=this.fields[b];return{start:a.startIndex,end:a.startIndex+a.getText().length}},getCursorField:function(a){a=Math.min(a,this.desPostions.length-1);a=Math.max(a,0);var c=this.desPostions[a].desc,d;if(c.type===-1){d=b.inArray(c,this.descriptors);if(d>0&&this.descriptors[d-1].type!==-1)c=this.descriptors[d-1];else return-1}return b.inArray(c,this.fields)},needToMove:function(c,d,e){if(!this.inputWidget._isValidDate(this.inputWidget._safeGetDate(),true))return false;var b=this.fields[c],a;if(d===b.maxLen)return true;a=e*1;if(isNaN(a))return false;switch(b.type){case 20:case 25:case 45:case 46:return a>1;case 47:case 48:return a>2;case 30:case 31:return a>3;case 50:case 51:case 60:case 61:return a>6}return false},_getCulture:function(){return this.inputWidget._getCulture()},_isDigitString:function(a){a=b.trim(a);if(a.length===0)return true;var c=a.charAt(0),d,e;if(c==="+"||c==="-"){a=a.substr(1);a=b.trim(a)}if(a.length===0)return true;try{d=parseFloat(a);e=d.toString();return e===a}catch(f){return false}},_setFormat:function(h){this.descriptors=[];var a="",d="",f=false,g=false,e,c;this.pattern=this._parseFormatToPattern(h);for(e=0;e<this.pattern.length;e++){c=this.pattern.charAt(e);if(g){this.descriptors.push(this.createDescriptor(-1,c));a="";g=false;continue}if(c==="\\"){g=true;if(a.length>0){!this.handlePattern(a)&&this.descriptors.push(this.createDescriptor(-1,d));a=""}continue}if(c==="'"){if(f){f=false;a=""}else{f=true;if(a.length>0){!this.handlePattern(a)&&this.descriptors.push(this.createDescriptor(-1,d));a=""}}continue}if(f){this.descriptors.push(this.createDescriptor(-1,c));a="";continue}if(!e)d=c;if(d!==c&&a.length>0){!this.handlePattern(a)&&this.descriptors.push(this.createDescriptor(-1,d));a=""}a+=c;d=c}if(a.length>0)!this.handlePattern(a)&&this.descriptors.push(this.createDescriptor(-1,d));this.fields=b.grep(this.descriptors,function(a){return a.type!==-1})},_parseFormatToPattern:function(c){var a=this.inputWidget._getCulture().calendars.standard,b=a.patterns.d;if(c.length<=1)switch(c){case"":case"d":b=a.patterns.d;break;case"D":b=a.patterns.D;break;case"f":b=a.patterns.D+" "+a.patterns.t;break;case"F":b=a.patterns.D+" "+a.patterns.T;break;case"g":b=a.patterns.d+" "+a.patterns.t;break;case"G":b=a.patterns.d+" "+a.patterns.T;break;case"m":b=a.patterns.M;break;case"M":b=a.patterns.M;break;case"s":b=a.patterns.S;break;case"t":b=a.patterns.t;break;case"T":b=a.patterns.T;break;case"u":b=a.patterns.S;break;case"U":b=a.patterns.D+" "+a.patterns.T;break;case"y":b=a.patterns.Y;break;case"Y":b=a.patterns.Y}else b=c;return b},getDate:function(){return!!this.inputWidget?new Date(this.inputWidget._safeGetDate().getTime()):undefined},setDate:function(a){this.inputWidget&&this.inputWidget._setData(a)},_internalSetDate:function(e){if(this.inputWidget){var c=this,a=this.inputWidget.options,d=this.inputWidget.element,f=!!d.data("typing"),b;if(f){a.date=e;b=function(){var f=new Date,e=d.data("timeStamp");if(f.getTime()-e.getTime()>a.keyDelay){c.inputWidget._safeSetDate(a.date);c.inputWidget._updateText();c.inputWidget._highLightField()}else window.setTimeout(b,a.keyDelay)};window.setTimeout(b,a.keyDelay)}else this.inputWidget._safeSetDate(e)}},daysInMonth:function(a,c){a=a-1;var b=new Date(c,++a,1,-1).getDate();return b},setYear:function(a,d,i){try{if(d&&d.isfullreset){d.offset=1;a="1970"}if(typeof a==="string")if(!this._isDigitString(a))return false;a=a*1;var h=this.inputWidget.options,e=1,f=9999,c,b,g;if(i){if(h.minDate)e=Math.max(e,h.minDate.getFullYear());if(h.maxDate)f=Math.min(f,h.maxDate.getFullYear())}if(d&&d.isreset)a=e;if(a<e)a=e;if(a>f)a=f;c=this.getDate();b=new Date(c.getTime());b.setFullYear(a);if(this._isValidDate(b)){g=this.daysInMonth(this.getMonth(),this.getYear());if(g===c.getDate()){b=new Date(c.getTime());b.setDate(1);b.setFullYear(a);g=this.daysInMonth(b.getMonth()+1,b.getFullYear());b.setDate(g);if(this._isValidDate(b)){this._internalSetDate(b);return true}else return false}c.setFullYear(a);this._internalSetDate(c);return true}else{if(d&&d.isreset){c.setFullYear(1);this._internalSetDate(c);return true}return false}}catch(j){return false}},getYear:function(){try{var a=this.getDate().getFullYear();a=""+a+"";while(a.length<4)a="0"+a;return""+a+""}catch(b){alert("getYear() failed")}return""},setMonth:function(b,e,c){try{if(c&&c.isfullreset)b="1";b=b*1;var f=this.getDate(),d,a;if(typeof e!=="undefined"&&!e)if(b>12||b<1)if(c&&c.isreset)b=1;else return false;d=this.daysInMonth(this.getMonth(),this.getYear());if(d===this.getDate().getDate()){a=new Date(f.getTime());a.setDate(1);a.setMonth(b-1);d=this.daysInMonth(a.getMonth()+1,a.getFullYear());a.setDate(d);if(this._isValidDate(a)){this._internalSetDate(a);return true}else return false}else{a=new Date(f.getTime());a.setMonth(b-1);if(this._isValidDate(a)){this._internalSetDate(a);return true}else return false}}catch(g){return false}},getMonth:function(){return this.getDate().getMonth()+1},setDayOfMonth:function(b,c,a){try{if(a&&a.isfullreset)return this.setDayOfMonth(1,c);var f=this.getDate(),e,d;b=b*1;if(typeof c!=="undefined"&&!c){e=this.daysInMonth(this.getMonth(),this.getYear());if(b>e||b<1)return a&&a.isreset?this.setDayOfMonth(1,c,a):false}d=new Date(f.getTime());d.setDate(b);if(this._isValidDate(d)){this._internalSetDate(d);return true}else return false}catch(g){return false}},getDayOfMonth:function(){return this.getDate().getDate()},setHours:function(a,c){try{a=a*1;if(typeof c!=="undefined"&&!c)if(a>24)return false;var b=new Date(this.getDate().getTime());b.setHours(a);if(this._isValidDate(b)){this._internalSetDate(b);return true}else return false}catch(d){return false}},getHours:function(){return this.getDate().getHours()},setMinutes:function(a,c){try{a=a*1;if(typeof c!=="undefined"&&!c)if(a>60)return false;var b=new Date(this.getDate().getTime());b.setMinutes(a);if(this._isValidDate(b)){this._internalSetDate(b);return true}else return false}catch(d){return false}},getMinutes:function(){return this.getDate().getMinutes()},setSeconds:function(a,c){try{a=a*1;if(typeof c!=="undefined"&&!c)if(a>60)return false;var b=new Date(this.getDate().getTime());b.setSeconds(a);if(this._isValidDate(b)){this._internalSetDate(b);return true}else return false}catch(d){return false}},getSeconds:function(){return this.getDate().getSeconds()},setDayOfWeek:function(a){try{a=a*1;var b=a-this.getDayOfWeek()*1;return this.setDayOfMonth(this.getDayOfMonth()*1+b*1,true)}catch(c){return false}},getDayOfWeek:function(){return this.getDate().getDay()+1},handlePattern:function(c){var a=new RegExp("y{3,4}"),b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(10));return true}a=new RegExp("y{2,2}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(2));return true}a=new RegExp("y{1,1}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(1));return true}a=new RegExp("d{4,4}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(101));return true}a=new RegExp("d{3,3}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(100));return true}a=new RegExp("d{2,2}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(30));return true}a=new RegExp("d{1,1}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(31));return true}a=new RegExp("M{4,4}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(27));return true}a=new RegExp("M{3,3}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(26));return true}a=new RegExp("M{2,2}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(20));return true}a=new RegExp("M{1,1}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(25));return true}a=new RegExp("h{2,2}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(46));return true}a=new RegExp("h{1,1}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(45));return true}a=new RegExp("H{2,2}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(48));return true}a=new RegExp("H{1,1}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(47));return true}a=new RegExp("m{2,2}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(50));return true}a=new RegExp("m{1,1}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(51));return true}a=new RegExp("s{2,2}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(60));return true}a=new RegExp("s{1,1}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(61));return true}a=new RegExp("t{2,2}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(251));return true}a=new RegExp("t{1,1}");b=a.test(c);if(b){this.descriptors.push(this.createDescriptor(250));return true}return false},createDescriptor:function(z,c){var a=null,b=this.maskPartsCount++;switch(z){case-1:a=new y(this,b);a.liternal=c;break;case 20:a=new i(this,b);break;case 25:a=new j(this,b);break;case 26:a=new k(this,b);break;case 27:a=new l(this,b);break;case 30:a=new m(this,b);break;case 31:a=new n(this,b);break;case 100:a=new d(this,b);break;case 101:a=new e(this,b);break;case 10:a=new h(this,b);break;case 1:a=new w(this,b);break;case 2:a=new x(this,b);break;case 45:a=new o(this,b);break;case 46:a=new p(this,b);break;case 47:a=new q(this,b);break;case 48:a=new r(this,b);break;case 250:a=new f(this,b);break;case 251:a=new g(this,b);break;case 50:a=new s(this,b);break;case 51:a=new t(this,b);break;case 60:a=new u(this,b);break;case 61:a=new v(this,b)}return a},toString:function(){if(this.inputWidget.options.showNullText&&!this.inputWidget.isFocused()&&this.inputWidget.isDateNull())return this.inputWidget.options.nullText;var e="",f=0,b,c,d,a;this.desPostions=new Array(0);for(b=0;b<this.descriptors.length;b++){this.descriptors[b].startIndex=e.length;c=""||this.descriptors[b].getText();e+=c;for(d=0;d<c.length;d++){a={};a.desc=this.descriptors[b];a.pos=d;a.text=c;a.length=c.length;this.desPostions.push(a);f++;if(this.desPostions.length!==f)throw"Fatal Error !!!!!!!!!!!!!!!";}}return e},parseDate:function(b){var a;if(this.pattern==="dddd"||this.pattern==="ddd"||typeof b==="object")try{a=new Date(b);if(isNaN(a))a=new Date}catch(c){a=new Date}else{a=Globalize.parseDate(b,this.pattern,this._getCulture());if(!a)a=this._tryParseDate(b,this.pattern);if(!a)a=new Date}return a},"set":function(a){this._internalSetDate(new Date(this.parseDate(a)));return true},haveEnumParts:function(){return false},removeLiterals:function(a){a=""+a+"";a=a.replace(new RegExp("\\s","g"),"");a=a.replace(new RegExp("[+]","g"),"");a=a.replace(new RegExp("[.]","g"),"");a=a.replace(new RegExp("[:]","g"),"");a=a.replace(new RegExp("[-]","g"),"");a=a.replace(new RegExp("[()=]","g"),"");return a},getFirstDelimiterPos:function(b,d){var c=0,a=0,e,f;while(c<d.length&&a<b.length){e=d.charAt(c);f=b.charAt(a);if(e===f)a++;else return a-1;c++}return b.length-1},findAlikeArrayItemIndex:function(d,f){for(var c=-1,e=99999,b,a=0;a<d.length;a++){b=d[a].toLowerCase().indexOf(f.toLowerCase());if(b!==-1&&b<e){e=b;c=a}}return c},_isValidDate:function(a){return this.inputWidget._isValidDate(a)},isFieldSep:function(d,c){var b=c++,a;if(b<this.descriptors.length){a=this.descriptors[b];return a.type!==-1?false:d===a.text}return false},getPositionType:function(b){var a=this.desPostions[b];return a.desc.type},addToField:function(a,f,h,g){var b=this.fields[f],e,c,d;if(b.type===10)return this.insertAt(a,h);e=g?b.getText()+a:a;c={val:a,pos:0,offset:0,isreset:false};this.inputWidget.element.data("typing",true);d=b.setText(e,a.length===1?false:true,c);this.inputWidget.element.data("typing",false);return d},insertAt:function(c,j,b){if(!b)b=new wijInputResult;b.testPosition=-1;var a,q,d,f,m,i,p,e,h,o,n,k,l,s,t,g,r;if(c.length===1){a=this.desPostions[j];if(a&&a.desc.type===-1)if(a.text===c){b.testPosition=j;b.hint=b.characterEscaped;return true}}q=c;d=j;c=this.removeLiterals(c);f=c;m=false;p=false;if(d>0&&f.length===1){d--;j=d;a=this.desPostions[d];m=true;if(a&&(a.desc.type===-1||a.desc.getText().length!==1)){j++;d++;m=false}}i=false;while(f.length>0&&d<this.desPostions.length){a=this.desPostions[d];if(a.desc.type===-1){d=d+a.length;continue}if(a.desc.needAdjustInsertPos()){e=f.substr(0,a.length-a.pos);e=a.text.slice(0,a.pos)+e+a.text.slice(a.pos+e.length,a.length);if(m)e=a.text+e;if(p)e=e+a.text;o=a.desc.getText().length;k="";try{if(c.length===1)if(!a.pos)k=c;else if(a.pos>0)k=e.substring(0,a.pos+1)}catch(u){}if(o===1&&e.length>1&&c.length===1)if(a.desc.type===31||a.desc.type===25)this._disableSmartInputMode=true;h={val:c,pos:a.pos,offset:0,isreset:false};i=a.desc.setText(e,c.length===1?false:true,h);this._disableSmartInputMode=false;if(!i&&typeof k!=="undefined"&&k.length>0&&(a.desc.type===26||a.desc.type===27||a.desc.type===100||a.desc.type===101||a.desc.type===250||a.desc.type===251))i=a.desc.setText(k,c.length===1?false:true,h);if(i){b.hint=b.success;b.testPosition=d+h.offset;if(c.length===1){l=a.desc.getText().length;n=a.pos;if(a.pos>l-1)n=l;s=l-o;if(s>0&&a.pos===o-1)n=l-1;t=this.toString();b.testPosition=a.desc.startIndex+n+h.offset}f=f.slice(a.length-a.pos,f.length)}else{b.hint=b.invalidInput;if(b.testPosition!==-1)b.testPosition=j;if(a.desc.type!==-1&&c.length===1)return false}d=d+a.length}else{g=this.getFirstDelimiterPos(f,q);if(g<0)g=0;e=f.substring(0,g+1);h={val:c,pos:a.pos,offset:0,isreset:false};i=a.desc.setText(e,c.length===1?false:true,h);if(i){b.hint=b.success;b.testPosition=d+h.offset;f=f.slice(g+1,f.length)}else{b.hint=b.invalidInput;if(b.testPosition!==-1)b.testPosition=j}if(g<0)g=0;r=g+1;d=d+r}}return i},removeAt:function(b,e,c){try{var a=this.desPostions[b],d,g,f,h,i=this.inputWidget,k=i.element,j=k.val().length;if(j===e+1&&b===0)i.isDeleteAll=true;if(a.desc.needAdjustInsertPos()){d="0";g=b;a.text=a.desc.getText();d=a.text.slice(0,a.pos)+d+a.text.slice(a.pos+d.length,a.length);f={val:d,pos:a.pos,offset:0,isreset:true,isfullreset:false};if(e-b+1>=a.length){f.isfullreset=true;b=b+a.length;g=b}h=a.desc.setText(d,false,f);if(h){c.hint=c.success;c.testPosition=g}else{c.hint=c.invalidInput;if(c.testPosition===-1)c.testPosition=b}}b<e&&this.removeAt(b+1,e,c);return true}catch(l){return false}},incEnumPart:function(){var a=this.fields[this.inputWidget.options.activeField];a&&a.inc();return true},decEnumPart:function(){var a=this.fields[this.inputWidget.options.activeField];a&&a.dec();return true},setValue:function(a){this.setDate(new Date(a instanceof Date?a.getTime():a));return true},getValue:function(){return this.getDate()},_disableSmartInputMode:false,_isSmartInputMode:function(){return this._disableSmartInputMode?false:this.inputWidget?this.inputWidget.options.smartInputMode:true},_getInt:function(g,e,d,f){for(var a,c=f;c>=d;c--){a=g.substring(e,e+c);if(a.length<d)return null;if(b.wij.charValidator.isDigit(a))return a}return null},_tryParseDate:function(e,a){var g=this._getCulture().calendars,d,c,f,b;a=a||g.standard.patterns.d;if(a){if(a.indexOf("MMM")===-1&&a.indexOf("MMMM")===-1)a=a.replace("MM","M");a=a.replace("dd","d");a=a.replace("tt","a")}d=a.replace("yyyy","yy");c=g.standard["/"];f=[a,d,a.replace(new RegExp(c,"g"),"-"),d.replace(new RegExp(c,"g"),"-"),a.replace(new RegExp(c,"g"),"."),d.replace(new RegExp(c,"g"),".")];b=Globalize.parseDate(e,f,this._getCulture());if(b)return b;b=new Date(e);return b.toString()!=="Invalid Date"&&e&&e!==""?b:0},paddingZero:function(c,b){var a=""+c+"";while(a.length<b)a="0"+a;return a},_formatDate:function(a,f,d){if(!a.valueOf())return"&nbsp;";var b=this,c=this.inputWidget._getCulture().calendars.standard,e=f.replace(new RegExp("yyyy|MMMM|MMM|MM|M|mm|m|dddd|ddd|dd|d|hh|h|HH|H|ss|s|tt|t|a/p","gi"),function(f){var e;switch(f){case"yyyy":return a.getFullYear();case"MMMM":return d.dateTimeFormat.monthNames[a.getMonth()];case"MMM":return d.dateTimeFormat.abbreviatedMonthNames[a.getMonth()];case"MM":return b.paddingZero(a.getMonth()+1,2);case"M":return b.paddingZero(a.getMonth()+1,1);case"mm":return b.paddingZero(a.getMinutes(),2);case"m":return b.paddingZero(a.getMinutes(),1);case"dddd":return d.dateTimeFormat.dayNames[a.getDay()];case"ddd":return d.dateTimeFormat.abbreviatedDayNames[a.getDay()];case"dd":return b.paddingZero(a.getDate(),2);case"d":return b.paddingZero(a.getDate(),1);case"hh":e=a.getHours()%12;return b.paddingZero(e?e:12,2);case"h":e=a.getHours()%12;return b.paddingZero(e?e:12,1);case"HH":return b.paddingZero(a.getHours(),2);case"H":return b.paddingZero(a.getHours(),1);case"ss":return b.paddingZero(a.getSeconds(),2);case"s":return b.paddingZero(a.getSeconds(),1);case"tt":return a.getHours()<12?c.AM[0]:c.PM[0];case"t":return a.getHours()<12?c.AM[0].length>0?c.AM[0].charAt(0):"":c.PM[0].length>0?c.PM[0].charAt(0):"";case"a/p":return a.getHours()<12?"a":"p"}return"N"});return e}};a=function(d,c,a,b){this._txtProvider=d;this.id=c;this.type=a;this.startIndex=0;this.maxLen=b||2};a.prototype={_txtProvider:null,id:0,type:0,name:null,startIndex:0,maxLen:2,getText:function(){return null},setText:function(){return false},inc:function(){},dec:function(){},needAdjustInsertPos:function(){return true},reachMaxLen:function(){var a=this.getText();do if(a.charAt(0)==="0")a=a.slice(1);else break;while(a.length>0);return a.length>=this.maxLen}};c=function(c,b){for(var a in b.prototype)if(!c.prototype[a])c.prototype[a]=b.prototype[a]};y=function(b,d){c(y,a);a.apply(this,[b,d,-1,100])};y.prototype={liternal:"",getText:function(){return this.liternal}};i=function(b,d){c(i,a);a.apply(this,[b,d,20]);this.name="Two-digit month"};i.prototype={getText:function(){var a=""+this._txtProvider.getMonth()+"";return a.length===1?"0"+a:a},setText:function(c,a,b){return this._txtProvider.setMonth(c,a,b)},inc:function(){this._txtProvider.setMonth(this._txtProvider.getMonth()*1+1,true)},dec:function(){this._txtProvider.setMonth(this._txtProvider.getMonth()*1-1,true)}};j=function(b,d){c(j,a);a.apply(this,[b,d,25]);this.name="month"};j.prototype={getText:function(){return""+this._txtProvider.getMonth()+""},setText:function(c,a,b){return this._txtProvider.setMonth(c,a,b)},inc:function(){this._txtProvider.setMonth(this._txtProvider.getMonth()*1+1,true)},dec:function(){this._txtProvider.setMonth(this._txtProvider.getMonth()*1-1,true)}};k=function(b,d){c(k,a);a.apply(this,[b,d,26,100]);this.name="AbbreviatedMonthNames"};k.prototype={getText:function(){var b=this._txtProvider.getMonth(),a=this._txtProvider._getCulture();return a.calendars.standard.months.namesAbbr[b-1]},setText:function(d,b,c){var a=-1,e=this.inputWidget._getCulture().calendars.standard;a=this._txtProvider.findAlikeArrayItemIndex(e.months.namesAbbr,d);return a===-1?false:this._txtProvider.setMonth(a+1,b,c)},inc:function(){this._txtProvider.setMonth(this._txtProvider.getMonth()*1+1,true)},dec:function(){this._txtProvider.setMonth(this._txtProvider.getMonth()*1-1,true)}};l=function(b,d){c(l,a);a.apply(this,[b,d,27,100]);this.name="MonthNames"};l.prototype={getText:function(){var b=this._txtProvider.getMonth(),a=this._txtProvider._getCulture();return a.calendars.standard.months.names[b-1]},setText:function(e,d,b){var a=-1,c;if(b&&b.isfullreset)a=1;else{c=this._txtProvider._getCulture();a=this._txtProvider.findAlikeArrayItemIndex(c.calendars.standard.months.names,e);if(a===-1)return false}return this._txtProvider.setMonth(a+1,d,b)},inc:function(){this._txtProvider.setMonth(this._txtProvider.getMonth()*1+1,true)},dec:function(){this._txtProvider.setMonth(this._txtProvider.getMonth()*1-1,true)}};m=function(b,d){c(m,a);a.apply(this,[b,d,30]);this.name="Two-digit day of month"};m.prototype={getText:function(){var a=this._txtProvider.getDayOfMonth();if(a<10)a="0"+a;return""+a+""},setText:function(c,a,b){return this._txtProvider.setDayOfMonth(c,a,b)},inc:function(){this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth()*1+1,true)},dec:function(){this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth()*1-1,true)}};n=function(b,d){c(n,a);a.apply(this,[b,d,31]);this.name="Day of month"};n.prototype={getText:function(){var a=this._txtProvider.getDayOfMonth();return""+a+""},setText:function(c,a,b){return this._txtProvider.setDayOfMonth(c,a,b)},inc:function(){this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth()*1+1,true)},dec:function(){this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth()*1-1,true)}};d=function(b,e){c(d,a);a.apply(this,[b,e,100,100]);this.name="AbbreviatedDayNames"};d.prototype={getText:function(){var b=this._txtProvider.getDayOfWeek(),a=this._txtProvider._getCulture();return a.calendars.standard.days.namesShort[b-1]},setText:function(c){var a=-1,b=this._txtProvider._getCulture();a=this._txtProvider.findAlikeArrayItemIndex(b.calendars.standard.days.namesShort,c);return a===-1?false:this._txtProvider.setDayOfWeek(a+1)},inc:function(){this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth()*1+1,true)},dec:function(){this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth()*1-1,true)},needAdjustInsertPos:function(){return false}};e=function(b,d){c(e,a);a.apply(this,[b,d,101,100]);this.name="DayNames"};e.prototype={getText:function(){var b=this._txtProvider.getDayOfWeek(),a=this._txtProvider._getCulture();return a.calendars.standard.days.names[b-1]},setText:function(c){var a=-1,b=this._txtProvider._getCulture();a=this._txtProvider.findAlikeArrayItemIndex(b.calendars.standard.days.names,c);return a===-1?false:this._txtProvider.setDayOfWeek(a+1)},inc:function(){this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth()*1+1,true)},dec:function(){this._txtProvider.setDayOfMonth(this._txtProvider.getDayOfMonth()*1-1,true)},needAdjustInsertPos:function(){return false}};h=function(b,d){c(h,a);a.apply(this,[b,d,10,4]);this.name="Four-digit year"};h.prototype={getText:function(){return this._txtProvider.getYear()},setText:function(j,k,a){if(this._txtProvider._isSmartInputMode()&&a){var b=2e3,e,i,c,f,d,g,h;if(this._txtProvider.inputWidget.options.startYear)b=this._txtProvider.inputWidget.options.startYear;e=b+100-1;b=this._txtProvider.paddingZero(b,4);e=this._txtProvider.paddingZero(e,4);if(a.pos===0||a.pos===1){i=new Date;c=this._txtProvider.paddingZero(this._txtProvider.getYear(),4);if(c.charAt(0)==="0"&&c.charAt(1)==="0"&&a.pos<=1){f=a.val*1;d="00";if(f>=5)d=b.slice(0,2);else d=e.slice(0,2);g=a.val+c.slice(3,4);h=d+g;a.offset=2-a.pos;this._txtProvider.setYear(h,a);return true}}}return this._txtProvider.setYear(j,a)},inc:function(){this._txtProvider.setYear(this._txtProvider.getYear()*1+1,null,true)},dec:function(){this._txtProvider.setYear(this._txtProvider.getYear()*1-1,null,true)}};w=function(b,d){c(w,a);a.apply(this,[b,d,1]);this.name="One-digit year"};w.prototype={getText:function(){var a=this._txtProvider.getYear();a=""+a+"";if(a.length===4)a=a.charAt(2)+a.charAt(3);if(a.charAt(0)==="0")a=a.charAt(1);return a},setText:function(a,i,h){a=a+"";while(a.length<2)a="0"+a;var b=this._txtProvider.getYear(),f,c,e,d,g;b=""+b+"";if(a==="00"){f=this._txtProvider.getMonth();c=this._txtProvider.getDayOfMonth();e=this._txtProvider.getHours();d=this._txtProvider.getMinutes();g=this._txtProvider.getSeconds();if(f===1&&c===1&&!e&&!d&&!g){b="0001";a="01"}}if(b.length>=2)b=b.charAt(0)+b.charAt(1)+a.charAt(0)+a.charAt(1);return this._txtProvider.setYear(b,h)},inc:function(){this._txtProvider.setYear(this._txtProvider.getYear()*1+1,null,true)},dec:function(){this._txtProvider.setYear(this._txtProvider.getYear()*1-1,null,true)}};x=function(b,d){c(x,a);a.apply(this,[b,d,2]);this.name="Two-digit year"};x.prototype={getText:function(){var a=this._txtProvider.getYear();a=""+a+"";if(a.length===4)a=a.charAt(2)+a.charAt(3);return a},setText:function(a,j,i){a=a+"";while(a.length<2)a="0"+a;var b=this._txtProvider.getYear(),g,d,f,e,h,c;b=""+b+"";if(a==="00"){g=this._txtProvider.getMonth();d=this._txtProvider.getDayOfMonth();f=this._txtProvider.getHours();e=this._txtProvider.getMinutes();h=this._txtProvider.getSeconds();if(g===1&&d===1&&!f&&!e&&!h){b="0001";a="01"}}if(b.length>=2)b=b.charAt(0)+b.charAt(1)+a.charAt(0)+a.charAt(1);c=this._txtProvider.setYear(b,i);return c},inc:function(){this._txtProvider.setYear(this._txtProvider.getYear()*1+1,null,true)},dec:function(){this._txtProvider.setYear(this._txtProvider.getYear()*1-1,null,true)}};o=function(b,d){c(o,a);a.apply(this,[b,d,45]);this.name="h"};o.prototype={getText:function(){var a=this._txtProvider.getHours();if(a>12)a=a-12;else if(a===0)a=12;return""+a+""},setText:function(a,b){var c=this._txtProvider.getHours();if(c>12)a=a*1+12;return this._txtProvider.setHours(a,b)},inc:function(){this._txtProvider.setHours(this._txtProvider.getHours()*1+1,true)},dec:function(){this._txtProvider.setHours(this._txtProvider.getHours()*1-1,true)}};p=function(b,d){c(p,a);a.apply(this,[b,d,46]);this.name="hh"};p.prototype={getText:function(){var a=this._txtProvider.getHours();if(a>12)a=a-12;else if(a===0)a="12";if(a<10)a="0"+a;return""+a+""},setText:function(a,b){var c=this._txtProvider.getHours();if(c>12)a=a*1+12;return this._txtProvider.setHours(a,b)},inc:function(){this._txtProvider.setHours(this._txtProvider.getHours()*1+1,true)},dec:function(){this._txtProvider.setHours(this._txtProvider.getHours()*1-1,true)}};q=function(b,d){c(q,a);a.apply(this,[b,d,47]);this.name="H"};q.prototype={getText:function(){var a=this._txtProvider.getHours();return""+a+""},setText:function(b,a){return this._txtProvider.setHours(b,a)},inc:function(){this._txtProvider.setHours(this._txtProvider.getHours()*1+1,true)},dec:function(){this._txtProvider.setHours(this._txtProvider.getHours()*1-1,true)}};r=function(b,d){c(r,a);a.apply(this,[b,d,48]);this.name="HH"};r.prototype={getText:function(){var a=this._txtProvider.getHours();if(a<10)a="0"+a;return""+a+""},setText:function(b,a){return this._txtProvider.setHours(b,a)},inc:function(){this._txtProvider.setHours(this._txtProvider.getHours()*1+1,true)},dec:function(){this._txtProvider.setHours(this._txtProvider.getHours()*1-1,true)}};f=function(b,d){c(f,a);a.apply(this,[b,d,250]);this.name="t"};f.prototype={getText:function(){var c=this._txtProvider.getHours(),a="",b=this._txtProvider._getCulture();if(c<12)a=b.calendars.standard.AM[0];else a=b.calendars.standard.PM[0];if(a.length<=0)a=" ";return a.charAt(0)},setText:function(b){var a;if(b.toLowerCase().indexOf("a")>=0){a=this._txtProvider.getHours()*1%12;this._txtProvider.setHours(a,true)}else if(b.toLowerCase().indexOf("p")>=0){a=this._txtProvider.getHours()*1%12+12;this._txtProvider.setHours(a,true)}},inc:function(){var a=(this._txtProvider.getHours()*1+12)%24;this._txtProvider.setHours(a,true)},dec:function(){var a=(this._txtProvider.getHours()*1+12)%24;this._txtProvider.setHours(a,true)}};g=function(b,d){c(g,a);a.apply(this,[b,d,251]);this.name="tt"};g.prototype={getText:function(){var c=this._txtProvider.getHours(),a="",b=this._txtProvider._getCulture();if(c<12)a=b.calendars.standard.AM[0];else a=b.calendars.standard.PM[0];if(a.length<=0)a=" ";return a},setText:function(b){var a;if(b.toLowerCase().indexOf("a")>=0){a=this._txtProvider.getHours()*1%12;this._txtProvider.setHours(a,true)}else if(b.toLowerCase().indexOf("p")>=0){a=this._txtProvider.getHours()*1%12+12;this._txtProvider.setHours(a,true)}return true},inc:function(){var a=(this._txtProvider.getHours()*1+12)%24;this._txtProvider.setHours(a,true)},dec:function(){var a=(this._txtProvider.getHours()*1+12)%24;this._txtProvider.setHours(a,true)}};s=function(b,d){c(s,a);a.apply(this,[b,d,50]);this.name="mm"};s.prototype={getText:function(){var a=this._txtProvider.getMinutes();if(a<10)a="0"+a;return""+a+""},setText:function(b,c,a){if(a&&a.isfullreset)b="0";return this._txtProvider.setMinutes(b,c)},inc:function(){this._txtProvider.setMinutes(this._txtProvider.getMinutes()*1+1,true)},dec:function(){this._txtProvider.setMinutes(this._txtProvider.getMinutes()*1-1,true)}};t=function(b,d){c(t,a);a.apply(this,[b,d,51]);this.name="m"};t.prototype={getText:function(){var a=this._txtProvider.getMinutes();return""+a+""},setText:function(b,c,a){if(a&&a.isfullreset)b="0";return this._txtProvider.setMinutes(b,c)},inc:function(){this._txtProvider.setMinutes(this._txtProvider.getMinutes()*1+12,true)},dec:function(){this._txtProvider.setMinutes(this._txtProvider.getMinutes()*1-12,true)}};u=function(b,d){c(u,a);a.apply(this,[b,d,60]);this.name="ss"};u.prototype={getText:function(){var a=this._txtProvider.getSeconds();if(a<10)a="0"+a;return""+a+""},setText:function(b,c,a){if(a&&a.isfullreset)b="0";return this._txtProvider.setSeconds(b,c)},inc:function(){this._txtProvider.setSeconds(this._txtProvider.getSeconds()*1+12,true)},dec:function(){this._txtProvider.setSeconds(this._txtProvider.getSeconds()*1-12,true)}};v=function(b,d){c(v,a);a.apply(this,[b,d,61]);this.name="s"};v.prototype={getText:function(){var a=this._txtProvider.getSeconds();return""+a+""},setText:function(b,c,a){if(a&&a.isfullreset)b="0";return this._txtProvider.setSeconds(b,c)},inc:function(){this._txtProvider.setSeconds(this._txtProvider.getSeconds()*1+12,true)},dec:function(){this._txtProvider.setSeconds(this._txtProvider.getSeconds()*1-12,true)}}})(jQuery);
(function(b){"use strict";var a={editOptional:1,editRequired:2,separator:4,literal:8},c,d;b.widget("wijmo.wijinputmask",b.extend(true,{},wijinputcore,{options:{text:null,mask:"",promptChar:"_",hidePromptOnLeave:false,resetOnPrompt:true,allowPromptAsInput:false,passwordChar:"",resetOnSpace:true,skipLiterals:true},_createTextProvider:function(){this._textProvider=new c(this,this.options.mask,false)},_beginUpdate:function(){this.element.addClass("wijmo-wijinput-mask");this.element.data("isPassword",this.options.passwordChar.length>0&&this.element.attr("type")!=="password");this.element.data("defaultText",this.options.text)},_onTriggerClicked:function(){this._popupComboList()},_setOption:function(d,a){b.Widget.prototype._setOption.apply(this,arguments);wijinputcore._setOption.apply(this,arguments);switch(d){case"text":this.setText(a);break;case"mask":case"culture":if(typeof a==="undefined"||a.length<=0)return;var c=this.getText();this._textProvider.mask=a;this._textProvider.initialMask=a;this._textProvider.initialize();this._textProvider.set(c);this._updateText();break;case"promptChar":if(!!this._textProvider){this._textProvider.updatePromptChar();this._updateText()}break;case"hidePromptOnLeave":case"resetOnPrompt":this._updateText();break;case"passwordChar":this.element.data("isPassword",(a+"").length>0);this._updateText()}},_resetData:function(){var a=this.element.data("defaultText");if(a===undefined||a===null)a=this.element.data("elementValue");if(a===undefined||a===null)a="";this.setText(a)},_isPassword:function(){return!!this.element.data("isPassword")},_getTextWithPrompts:function(){return!this._isInitialized()?this.element.val():this._textProvider.toString(true,true,false)},_getTextWithLiterals:function(){return!this._isInitialized()?this.element.val():this._textProvider.toString(true,false,true)},_getTextWithPromptAndLiterals:function(){return!this._isInitialized()?this.element.val():this._textProvider.toString(true,true,true)},_onChange:function(){if(!this.element)return;var b=this.element.val(),a=this.getText();if(a!==b){a=this._getTextWithPrompts();if(a!==b){a=this._getTextWithPromptAndLiterals();a!==b&&this.setText(b)}}},_afterFocused:function(){(this._isNullText()||!!this.options.hidePromptOnLeave)&&this._doFocus()}}));c=function(c,b,a){this.inputWidget=c;this.mask=b;this.asciiOnly=a;this.descriptors=[];this.noMask=false;this.initialize()};c.prototype={inputWidget:undefined,noMask:false,mask:"",testString:"",assignedCharCount:0,requiredCharCount:0,asciiOnly:false,initialize:function(){this.noMask=!this.mask||this.mask.length<=0;if(this.noMask)return;this.testString="";this.assignedCharCount=0;this.requiredCharCount=0;this.descriptors=new Array(0);for(var i="none",m=false,o=0,l,b,c=a.literal,e="",g,n,f,j,h=this.inputWidget._getCulture(),k=0;k<this.mask.length;k++){b=false;g=this.mask.charAt(k);if(m){m=false;b=true}if(!b){f=g;if(f<="C"){switch(f){case"#":case"9":case"?":case"C":g=this.getPromtChar();c=a.editOptional;b=true;break;case"$":e=h.numberFormat.currency.symbol;c=a.separator;b=true;break;case"%":case"-":case";":case"=":case"@":case"B":c=a.literal;b=true;break;case"&":case"0":case"A":g=this.getPromtChar();c=a.editRequired;b=true;break;case",":e=h.numberFormat[","];c=a.separator;b=true;break;case".":e=h.numberFormat["."];c=a.separator;b=true;break;case"/":e=h.calendars.standard["/"];c=a.separator;b=true;break;case":":e=h.calendars.standard[":"];c=a.separator;b=true;break;case"<":i="lower";continue;case">":i="upper";continue}if(!b){c=a.literal;b=true}}if(!b){if(f<="\\"){switch(f){case"L":g=this.getPromtChar();c=a.editRequired;b=true;break;case"\\":m=true;c=a.literal;continue}if(!b){c=a.literal;b=true}}if(!b){if(f==="a"){g=this.getPromtChar();c=a.editOptional;b=true}if(!b){if(f!=="|"){c=a.literal;b=true}if(!b){i="none";continue}}}}}if(b){j=new d(k,c);if(this.isEditDesc(j))j.caseConversion=i;if(c!==a.separator)e=g;for(l=0;l<e.length;l++){n=e.charAt(l);this.testString=this.testString+n;this.descriptors[this.descriptors.length]=j;o++}}}this.testString.Capacity=this.testString.length},getAllowPromptAsInput:function(){return!!this.inputWidget?this.inputWidget.options.allowPromptAsInput:false},getPasswordChar:function(){return!!this.inputWidget?this.inputWidget.options.passwordChar:"*"},isPassword:function(){return!!this.inputWidget?this.inputWidget._isPassword():false},getResetOnPrompt:function(){return!!this.inputWidget?this.inputWidget.options.resetOnPrompt:true},getResetOnSpace:function(){return!!this.inputWidget?this.inputWidget.options.resetOnSpace:true},getSkipLiterals:function(){return!!this.inputWidget?this.inputWidget.options.skipLiterals:true},getHidePromptOnLeave:function(){return!!this.inputWidget?this.inputWidget.options.hidePromptOnLeave:false},_trueOR:function(a,b){return(a>>>1|b>>>1)*2+(a&1|b&1)},setValue:function(){return false},getValue:function(){return null},getPromtChar:function(){return!!this.inputWidget?this.inputWidget.options.promptChar:"_"},updatePromptChar:function(){if(this.noMask)return;for(var c,d=0;d<this.descriptors.length;d++){c=this.descriptors[d];if(c.charType===a.editOptional||c.charType===a.editRequired)if(!c.isAssigned)this.testString=b.wij.charValidator.setChar(this.testString,this.getPromtChar(),d)}},resetChar:function(c){var d=this.descriptors[c];if(this.isEditPos(c)&&d.isAssigned){d.isAssigned=false;this.testString=b.wij.charValidator.setChar(this.testString,this.getPromtChar(),c);this.assignedCharCount--;if(d.charType===a.editRequired)this.requiredCharCount--}},getAdjustedPos:function(a){if(this.noMask){if(a>=this.testString.length)a=this.testString.length-1}else if(a>=this.descriptors.length)a=a-1;return Math.max(0,a)},incEnumPart:function(){return!this.noMask},decEnumPart:function(){return!this.noMask},findNonEditPositionInRange:function(c,d,b){return this.findPositionInRange(c,d,b,this._trueOR(a.literal,a.separator))},findPositionInRange:function(a,b,e,f){a=Math.max(0,a);b=Math.min(b,this.testString.length-1);if(a<=b)while(a<=b){var c=e?a++:b--,d=this.descriptors[c];if((d.charType&4294967295&f&4294967295)===d.charType)return c}return-1},findAssignedEditPositionInRange:function(c,d,b){return this.assignedCharCount===0?-1:this.findEditPositionInRange(c,d,b,a.editRequired)},findEditPositionInRange:function(c,d,f,g){do{var b,e;b=this.findPositionInRange(c,d,f,this._trueOR(a.editRequired,a.editOptional));if(b===-1)break;e=this.descriptors[b];switch(g){case a.editOptional:if(!e.isAssigned)return b;break;case a.editRequired:if(e.isAssigned)return b;break;default:return b}if(f)c++;else d--}while(c<=d);return-1},findAssignedEditPositionFrom:function(d,c){if(!this.assignedCharCount)return-1;var a,b;if(c){a=d;b=this.testString.length-1}else{a=0;b=d}return this.findAssignedEditPositionInRange(a,b,c)},findEditPositionFrom:function(d,c){var a,b;if(c){a=d;b=this.testString.length-1}else{a=0;b=d}return this.findEditPositionInRange(a,b,c,0)},setChar:function(c,e,d){e=e<0?0:e;if(!d)d=this.descriptors[e];if(this.testEscapeChar(c,e,d))this.resetChar(e);else{if(b.wij.charValidator.isLetter(c))if(b.wij.charValidator.isUpper(c)){if(d.caseConversion==="lower")c=c.toLowerCase()}else if(d.caseConversion==="upper")c=c.toUpperCase();this.testString=b.wij.charValidator.setChar(this.testString,c,e);if(!d.isAssigned){d.isAssigned=true;this.assignedCharCount++;if(d.charType===a.editRequired)this.requiredCharCount++}}},internalInsertAt:function(h,e,a,k){if(h.length===0){a.testPosition=e;a.hint=a.noEffect;return true}if(!this._testString(h,e,a))return false;var b=this.findEditPositionFrom(e,true),g=this.findAssignedEditPositionInRange(b,a.testPosition,true)!==-1,l=this.findAssignedEditPositionFrom(this.testString.length-1,false),c,d,f,j,i;if(g&&a.testPosition===this.testString.length-1){a.hint=a.unavailableEditPosition;a.testPosition=this.testString.length;return false}c=this.findEditPositionFrom(a.testPosition+1,true);if(g){d=new wijInputResult;d.hint=d.unknown;f=true;while(f){f=false;if(c===-1){a.hint=a.unavailableEditPosition;a.testPosition=this.testString.length;return false}j=this.descriptors[b];if(j.isAssigned&&!this.testChar(this.testString.charAt(b),c,d)){a.hint=d.hint;a.testPosition=c;return false}if(b!==l){b=this.findEditPositionFrom(b+1,true);c=this.findEditPositionFrom(c+1,true);f=true;continue}}if(d.hint>a.hint)a.hint=d.hint}if(!k){if(g)while(b>=e){i=this.descriptors[b];if(i.isAssigned)this.setChar(this.testString.charAt(b),c);else this.resetChar(c);c=this.findEditPositionFrom(c-1,false);b=this.findEditPositionFrom(b-1,false)}this.setString(h,e)}return true},insertAt:function(c,a,b){if(b===undefined)b=new wijInputResult;if(c===undefined)throw"InsertAt: input";if(this.noMask){this.testString=this.testString.substring(0,a)+c+this.testString.substring(a,this.testString.length);b.testPosition=a+c.length-1;return true}if(a>=0&&a<this.testString.length)return this.internalInsertAt(c,a,b,false);b.testPosition=a;b.hint=b.positionOutOfRange;return false},clear:function(a){if(this.noMask){this.testString="";a.hint=a.success;return}if(!this.assignedCharCount)a.hint=a.noEffect;else{a.hint=a.success;for(var b=0;b<this.testString.length;b++)this.resetChar(b)}},isLiteral:function(b){return!b?false:b.charType!==a.literal?b.charType===a.separator:true},testEscapeChar:function(b,a,c){a=a<0?0:a;if(!c)c=this.descriptors[a];return this.isLiteral(c)?this.getSkipLiterals()?b===this.testString.charAt(a):false:(!this.getResetOnPrompt()||b!==this.getPromtChar())&&(!this.getResetOnSpace()||b!==" ")?false:true},testChar:function(c,e,a){if(!b.wij.charValidator.isPrintableChar(c)){a.hint=a.invalidInput;return false}var d=this.descriptors[e];if(!d)return false;if(this.isLiteral(d)){if(this.getSkipLiterals()&&c===this.testString.charAt(e)){a.hint=a.characterEscaped;return true}a.hint=a.nonEditPosition;return false}if(c===this.getPromtChar()){if(this.getResetOnPrompt()){if(this.isEditDesc(d)&&d.isAssigned)a.hint=a.sideEffect;else a.hint=a.characterEscaped;return true}if(!this.getAllowPromptAsInput()){a.hint=a.promptCharNotAllowed;return false}}if(c===" "&&this.getResetOnSpace()){if(this.isEditDesc(d)&&d.isAssigned)a.hint=a.sideEffect;else a.hint=a.characterEscaped;return true}switch(this.mask.charAt(d.maskPosition)){case"L":if(!b.wij.charValidator.isLetter(c)){a.hint=a.letterExpected;return false}if(!b.wij.charValidator.isAsciiLetter(c)&&this.asciiOnly){a.hint=a.asciiCharacterExpected;return false}break;case"a":if(!b.wij.charValidator.isAlphanumeric(c)&&c!==" "){a.hint=a.alphanumericCharacterExpected;return false}if(!b.wij.charValidator.isAciiAlphanumeric(c)&&this.asciiOnly){a.hint=a.asciiCharacterExpected;return false}break;case"?":if(!b.wij.charValidator.isLetter(c)&&c!==" "){a.hint=a.letterExpected;return false}if(b.wij.charValidator.isAsciiLetter(c)||!this.asciiOnly)break;a.hint=a.asciiCharacterExpected;return false;case"A":if(!b.wij.charValidator.isAlphanumeric(c)){a.hint=a.alphanumericCharacterExpected;return false}if(b.wij.charValidator.isAciiAlphanumeric(c)||!this.asciiOnly)break;a.hint=a.asciiCharacterExpected;return false;case"C":if(!b.wij.charValidator.isAscii(c)&&this.asciiOnly&&c!==" "){a.hint=a.asciiCharacterExpected;return false}break;case"9":if(!b.wij.charValidator.isDigit(c)&&c!==" "){a.hint=a.digitExpected;return false}break;case"#":if(!b.wij.charValidator.isDigit(c)&&c!=="-"&&c!=="+"&&c!==" "){a.hint=a.digitExpected;return false}break;case"&":if(!b.wij.charValidator.isAscii(c)&&this.asciiOnly){a.hint=a.asciiCharacterExpected;return false}break;case"0":if(!b.wij.charValidator.isDigit(c)){a.hint=a.digitExpected;return false}}if(c===this.testString.charAt(e)&&d.isAssigned)a.hint=a.noEffect;else a.hint=a.success;return true},_testString:function(d,f,a){a.hint=a.unknown;a.testPosition=f;if(d.length){var b=new wijInputResult,c,e;b.testPosition=a.testPosition;b.hint=a.hint;for(c=0;c<d.length;c++){e=d.charAt(c);if(a.testPosition>this.testString.length){a.hint=a.unavailableEditPosition;return false}if(!this.testEscapeChar(e,a.testPosition)){a.testPosition=this.findEditPositionFrom(a.testPosition,true);if(a.testPosition===-1){a.testPosition=this.testString.length;a.hint=a.unavailableEditPosition;return false}}if(!this.testChar(e,a.testPosition,b)){a.hint=b.hint;return false}if(b.hint>a.hint)a.hint=b.hint;a.testPosition+=1;if(a.testPosition===this.testString.length)break}a.testPosition-=1}return true},"set":function(b,a){if(a===undefined)a=new wijInputResult;if(b===undefined)throw"SetFromPos: input parameter is null or undefined.";a.hint=a.unknown;a.testPosition=0;if(!b.length){this.clear(a);return true}if(this.noMask){this.testString=b;return true}if(!this.testSetString(b,a.testPosition,a))return false;var c=this.findAssignedEditPositionFrom(a.testPosition+1,true);c!==-1&&this.resetString(c,this.testString.length-1);return true},resetString:function(a,b){if(this.noMask){this.testString="";return}a=this.findAssignedEditPositionFrom(a,true);if(a!==-1){b=this.findAssignedEditPositionFrom(b,false);while(a<=b){a=this.findAssignedEditPositionFrom(a,true);this.resetChar(a);a++}}},setString:function(d,a){for(var b,c=0;c<d.length;c++){b=d.charAt(c);if(!this.testEscapeChar(b,a))a=this.findEditPositionFrom(a,true);if(a<0||a>=this.testString.length)return;this.setChar(b,a);a++}},testSetString:function(a,b,c){if(a.length>this.testString.length)a=a.substring(0,this.testString.length);if(this._testString(a,b,c)){this.setString(a,b);return true}return false},toString:function(f,i,h,d,e){var k=this.inputWidget.options.text||"",o,n,l,p,c,q,j,g,m;k=b.trim(k);if(this.inputWidget.options.showNullText&&!this.inputWidget.isFocused()&&(k===""||k===this.inputWidget.options.nullText))return this.inputWidget.options.nullText;f=f===undefined?!this.isPassword():f;i=i===undefined?this.getHidePromptOnLeave()?this.inputWidget.isFocused():true:i;h=h===undefined?true:h;if(this.noMask){if(!f){o="";for(n=0;n<this.testString.length;n++)o+=this.getPasswordChar();return o}return this.testString}d=d===undefined?0:d;e=e===undefined?this.testString.length:e;if(e<=0)return"";if(d<0)d=0;if(d>=this.testString.length)return"";l=this.testString.length-d;if(e>l)e=l;if((!this.isPassword()||f)&&i&&h){p=this.testString.substring(d,e-d);return p}c="";q=d+e-1;for(j=d;j<=q;j++){g=this.testString.charAt(j);m=this.descriptors[j];switch(m.charType){case a.editOptional:case a.editRequired:if(!m.isAssigned)break;if(!this.isPassword()||f){c=c+g;continue}c=c+this.getPasswordChar();continue;case a.editRequired|a.editOptional:c=c+g;continue;case a.separator:case a.literal:if(!h)continue;c=c+g;continue;default:c=c+g;continue}if(i){c=c+g;continue}c=c+" ";continue}return c},isEditDesc:function(b){return this.noMask?true:b.charType!==a.editRequired?b.charType===a.editOptional:true},isEditPos:function(a){if(this.noMask)return true;if(a<0||a>=this.testString.length)return false;var b=this.descriptors[a];return this.isEditDesc(b)},internalRemoveAt:function(d,e,c,p){if(this.noMask){try{this.testString=this.testString.substring(0,d)+this.testString.substring(e+1,this.testString.length);c.testPosition=d}catch(q){}return true}var m=new wijInputResult,j,i,b,l,a,n,g,o,f,k,h=this.findAssignedEditPositionFrom(this.testString.length-1,false);b=this.findEditPositionInRange(d,e,true,0);c.hint=c.noEffect;if(b===-1||b>h){c.testPosition=d;return true}c.testPosition=d;l=e<h;if(this.findAssignedEditPositionInRange(d,e,true)!==-1)c.hint=c.success;if(l){a=this.findEditPositionFrom(e+1,true);n=a;d=b;g=true;while(g){g=false;j=this.testString.charAt(a);o=this.descriptors[a];if((j!==this.getPromtChar()||o.isAssigned)&&!this.testChar(j,b,m)){c.hint=m.hint;c.testPosition=b;return false}if(a!==h){a=this.findEditPositionFrom(a+1,true);b=this.findEditPositionFrom(b+1,true);g=true;continue}}if(c.sideEffect>c.hint)c.hint=c.sideEffect;if(p)return true;a=n;b=d;f=true;while(f){f=false;i=this.testString.charAt(a);k=this.descriptors[a];if(i===this.getPromtChar()&&!k.isAssigned)this.resetChar(b);else{this.setChar(i,b);this.resetChar(a)}if(a!==h){a=this.findEditPositionFrom(a+1,true);b=this.findEditPositionFrom(b+1,true);f=true;continue}}d=b+1}d<=e&&this.resetString(d,e);return true},removeAt:function(c,b,a){if(typeof b==="undefined")b=c;if(!a)a=new wijInputResult;if(b>=this.testString.length){a.testPosition=b;a.hint=a.positionOutOfRange;return false}if(c>=0&&c<=b)return this.internalRemoveAt(c,b,a,false);a.testPosition=c;a.hint=a.positionOutOfRange;return false}};d=function(b,a){this.caseConversion="none";this.maskPosition=b;this.charType=a};d.prototype={isAssigned:false,maskPosition:0}})(jQuery);
(function(a){"use strict";var c,b;a.widget("wijmo.wijinputnumber",a.extend(true,{},wijinputcore,{options:{type:"numeric",value:null,minValue:-1e9,maxValue:1e9,showGroup:false,decimalPlaces:2,increment:1,valueChanged:null,valueBoundsExceeded:null},_createTextProvider:function(){this._textProvider=new c(this,this.options.type)},_beginUpdate:function(){var a=this.options;this.element.addClass("wijmo-wijinput-numeric");this.element.data({defaultValue:a.value,preValue:a.value}).attr({"aria-valuemin":a.minValue,"aria-valuemax":a.maxValue,"aria-valuenow":a.value||0})},_onTriggerClicked:function(){this._popupComboList()},_setOption:function(c,b){a.Widget.prototype._setOption.apply(this,arguments);wijinputcore._setOption.apply(this,arguments);switch(c){case"minValue":this.element.attr("aria-valuemin",b);this._updateText();break;case"maxValue":this.element.attr("aria-valuemax",b);this._updateText();break;case"value":this.setValue(b);this._updateText();break;case"showGroup":case"decimalPlaces":case"culture":this._textProvider.updateStringFormat();this._updateText()}},_setData:function(a){this.setValue(a)},_resetData:function(){var a=this.element.data("defaultValue");if(a===undefined||a===null){a=this.element.data("elementValue");if(a===undefined||a===null&&a==="")a=0}this.setValue(a)},_validateData:function(){!this._textProvider.checkAndRepairBounds(true,false)&&this._updateText()},_raiseDataChanged:function(){var a=this.options.value,b=this.element.data("preValue");this.element.data("preValue",a);if(b!==a){this.element.attr("aria-valuenow",a);this._trigger("valueChanged",null,{value:a})}},getValue:function(){var a=this._textProvider.getValue();if(a===undefined||a===null)a=this.getText();return a},setValue:function(a,b){try{b=!!b;if(typeof a==="boolean")a=a?"1":"0";else if(typeof a==="string")a=this._textProvider.tryParseValue(a);if(this._textProvider.setValue(a))this._updateText();else if(b){var c="",d;c=this.getText();this.setText(a);a=a.trim();d=this.getText().trim();d!==a&&this.setText(c)}else this.setText(a);return true}catch(e){return false}},isValueNull:function(){try{return this._textProvider.isValueNull()}catch(a){return true}},getPostValue:function(){if(!this._isInitialized())return this.element.val();if(this.options.showNullText&&this.isValueNull())return"0";var a=this.options.value?this.options.value:0;if(this.options.type==="percent")a=(a/100).toFixed(10);return a.toString()},_updateText:function(){if(!this._isInitialized())return;this.options.value=this._textProvider.getValue();wijinputcore._updateText.apply(this,arguments);!this._textProvider.checkAndRepairBounds(false,false)&&this._trigger("valueBoundsExceeded")},_doSpin:function(e,c){e=!!e;c=!!c;if(!this._allowEdit())return;if(c&&this.element.data("breakSpinner"))return;var d=this.element.wijtextselection(),b=new wijInputResult;if(this.element.data("focusNotCalledFirstTime")!==-9&&+new Date-this.element.data("focusNotCalledFirstTime")<600){this.element.data("focusNotCalledFirstTime",-9);this.element.data("prevCursorPos",0)}if(this.element.data("prevCursorPos")===-1)this.element.data("prevCursorPos",d.start);else d.start=this.element.data("prevCursorPos");b.testPosition=d.start;this._textProvider[e?"incEnumPart":"decEnumPart"](d.start,b,this.options.increment);this._updateText();this.element.data("prevCursorPos",b.testPosition);this.selectText(b.testPosition,b.testPosition);c&&!this.element.data("breakSpinner")&&window.setTimeout(a.proxy(function(){this._doSpin(e,true)},this),this._calcSpinInterval())}}));c=function(a,c){this.inputWidget=a;this._type=c;this._stringFormat=new b(this._type,this.inputWidget.options.decimalPlaces,this.inputWidget.options.showGroup,this._getCulture());this._stringFormat._setValueFromJSFloat(this.getValue())};c.prototype={_type:"numeric",_stringFormat:null,_getCulture:function(){return this.inputWidget._getCulture()},getDecimalSeparator:function(){return this._getCulture().numberFormat["."]},tryParseValue:function(a){return this._stringFormat.tryParseValue(a)},toString:function(){return this.inputWidget.options.showNullText&&!this.inputWidget.isFocused()&&this.isValueNull()?this.inputWidget.options.nullText:this._stringFormat.getFormattedValue()},isValueNull:function(){var a=this.inputWidget.options,b=a.minValue;return null===a.value||undefined===a.value||b===a.value},"set":function(a,b){this.clear();this.insertAt(a,0,b);return true},clear:function(){this._stringFormat.clear()},checkAndRepairBounds:function(a,d){var c=true,b,e;if(typeof a==="undefined")a=false;b=this.inputWidget.options.minValue;e=this.inputWidget.options.maxValue;if(typeof d!=="undefined"&&d)return this._stringFormat.checkMinValue(b,false,true);if(!this._stringFormat.checkMinValue(b,a,false))c=false;if(!this._stringFormat.checkMaxValue(e,a))c=false;this.inputWidget.options.decimalPlaces>=0&&this._stringFormat.checkDigitsLimits(this.inputWidget.options.decimalPlaces);return c},countSubstring:function(c,b){var d=0,a=c.indexOf(b);while(a!==-1){d++;a=c.indexOf(b,a+1)}return d},getAdjustedPositionFromLeft:function(b){for(var e=this._stringFormat._currentText,c,d=0;d<e.length;d++){c=e.charAt(d);if(!a.wij.charValidator.isDigit(c)&&c!==","&&c!=="."||c==="0"){if(this._stringFormat.isZero()){if(b<d)b++}else if(b<=d)b++}else break}return b},getDecimalSeparatorPos:function(){var a=this._stringFormat._currentText;return a.indexOf(this.getDecimalSeparator())},insertAt:function(b,d,c){var i=this._getCulture().numberFormat,j,g,f,e,h,l,k,m;if(b===i["."])b=i["."];if(!c)c=new wijInputResult;if(b.length===1){if(b==="+"){this._stringFormat.setPositiveSign();this.checkAndRepairBounds(true,false);return true}if(b==="-"||b===")"||b==="("){this._stringFormat.invertSign();this.checkAndRepairBounds(true,false);c.testPosition=d;if(this._stringFormat.isNegative())c.testPosition=d;else c.testPosition=d-2;return true}if(!a.wij.charValidator.isDigit(b)){if(b==="."){j=this.getDecimalSeparatorPos();if(j>=0){c.testPosition=j;return true}}if(b!==","&&b!=="."&&b!==")"&&b!=="+"&&b!=="-"&&b!=="("&&b!==this.getDecimalSeparator())if(this._type==="percent"&&b===i.percent.symbol){c.testPosition=d;return true}else if(this._type==="currency"&&b===i.currency.symbol){c.testPosition=d;return true}else return false}}d=this.getAdjustedPositionFromLeft(d);g=d;f=this._stringFormat._currentText;if(g>f.length)g=f.length-1;e=f.substring(0,g);h=f.substring(g,f.length);if(this._stringFormat.isZero())h=h.replace(new RegExp("[0]"),"");c.testPosition=e.length+b.length-1;this._stringFormat.deFormatValue(e+b+h);try{if(b.length===1)if(this.inputWidget.options.showGroup){l=this._stringFormat._currentText.substring(0,e.length);if(this.countSubstring(l,this._stringFormat._groupSeparator)!==this.countSubstring(e,this._stringFormat._groupSeparator))c.testPosition=c.testPosition+1}else{k=e.charAt(e.length-1);m=this._stringFormat._currentText.charAt(c.testPosition-1);if(m!==k)c.testPosition=c.testPosition-1}}catch(n){}return true},removeAt:function(c,e,a,g){var h=this._getCulture().numberFormat,b,d,f;if(!a)a=new wijInputResult;g=!!g;a.testPosition=c;try{b=this._stringFormat._currentText;if(c===e&&b.substring(c,e+1)===this.getDecimalSeparator())return false;d=b.slice(0,c)+b.slice(e+1);if(d==="")d="0";this._stringFormat.deFormatValue(d);if(c===e&&this.inputWidget.options.showGroup)try{f=this._stringFormat._currentText.substring(0,c);if(this.countSubstring(f,this._stringFormat._groupSeparator)!==this.countSubstring(d,this._stringFormat._groupSeparator)){a.testPosition=a.testPosition-1;if(b.indexOf(h.currency.symbol)===a.testPosition||b.indexOf(h.percent.symbol)===a.testPosition)a.testPosition=a.testPosition+1}}catch(i){}return true}catch(j){}return true},incEnumPart:function(c,a,b){if(!a)a=new wijInputResult;this._stringFormat.increment(b);return this.checkAndRepairBounds(true,false)},decEnumPart:function(c,a,b){if(!a)a=new wijInputResult;this._stringFormat.decrement(b);return this.checkAndRepairBounds(true,false)},getValue:function(){return this._stringFormat.getJSFloatValue()},setValue:function(a){try{this._stringFormat._setValueFromJSFloat(a);this.checkAndRepairBounds(true,false);return true}catch(b){return false}},updateStringFormat:function(){var a="0";if(typeof this._stringFormat!=="undefined")a=this._stringFormat._currentValueInString;this._stringFormat=new b(this._type,this.inputWidget.options.decimalPlaces,this.inputWidget.options.showGroup,this._getCulture());this._stringFormat._currentValueInString=a}};b=function(d,a,c,b){this.type=d;this.digitsPlaces=a;this.showGroup=c;this.culture=b};b.prototype={_currentValueInString:"0",_currentText:"0",_groupSeparator:" ",type:"numeric",digitsPlaces:0,showGroup:false,culture:null,isNegtive:function(a){return a.indexOf("-")!==-1||a.indexOf("(")!==-1},stripValue:function(a){var b=this.culture.numberFormat,h=this.isNegtive(a),d,e,c,g,f;a=a.replace("(","");a=a.replace(")","");a=a.replace("-","");a=a.replace(b.percent.symbol,"");a=a.replace(b.currency.symbol,"");d=b[","];e=b["."];switch(this.type){case"percent":d=b.percent[","];e=b.percent["."];break;case"currency":d=b.currency[","];e=b.currency["."]}this._groupSeparator=d;c=new RegExp("["+d+"]","g");a=a.replace(c,"");c=new RegExp("["+e+"]","g");a=a.replace(c,".");c=new RegExp("[ ]","g");a=a.replace(c,"");try{g=new RegExp("([\\d\\.])+");f=g.exec(a);if(f)a=f[0];if(h)a="-"+a;return a}catch(i){}return null},tryParseValue:function(a){a=this.stripValue(a);if(a===null)return 0;try{a=parseFloat(a);if(isNaN(a))a=0}catch(b){a=0}return a},deFormatValue:function(a){a=this.stripValue(a);if(a===null)return;this._currentValueInString=a;this._currentText=this.formatValue(a)},formatValue:function(c){c=""+c+"";var a=this.culture.numberFormat,j=this.digitsPlaces,h=" ",e=".",f=2,i=this.isNegtive(c),d=new Array(3),g,b;d.push(3);g="n";switch(this.type){case"numeric":g=i?a.pattern[0]:"n";h=a[","];e=a["."];f=a.decimals;d=a.groupSizes;break;case"percent":g=a.percent.pattern[i?0:1];h=a.percent[","];e=a.percent["."];f=a.percent.decimals;d=a.percent.groupSizes;break;case"currency":g=a.currency.pattern[i?0:1];h=a.currency[","];e=a.currency["."];f=a.currency.decimals;d=a.currency.groupSizes}if(j!==-2)f=j;if(!this.showGroup)d=[0];c=c.replace(new RegExp("^[0]+"),"");b=this.formatDigit(c,h,e,f,d);b=b.replace(new RegExp("^[0]+"),"");if(b.indexOf(e)===0)b="0"+b;if(b==="")b="0";this._currentValueInString=c;this._currentText=this.applyFormatPattern(g,b,a.percent.symbol,a.currency.symbol);return this._currentText},getFormattedValue:function(){return this.formatValue(this._currentValueInString)},getJSFloatValue:function(){try{return this._currentValueInString===""?0:parseFloat(this._currentValueInString)}catch(a){return Number.NaN}},clear:function(){this._currentValueInString="0";this._currentText="0"},_setValueFromJSFloat:function(a){try{this._currentValueInString=""+a+"";this.formatValue(a);return true}catch(b){return false}},isZero:function(c){try{if(c===undefined)c=this._currentValueInString;var a=c.replace("-",""),b;a=a.replace("(","");a=a.replace(")","");if(!a.length)a="0";b=parseFloat(a);if(!isNaN(b)&&!b)return true}catch(d){}return false},setPositiveSign:function(){this._currentValueInString=this._currentValueInString.replace("-","");this._currentValueInString=this._currentValueInString.replace("(","");this._currentValueInString=this._currentValueInString.replace(")","")},isNegative:function(){return this._currentValueInString.indexOf("-")!==-1||this._currentValueInString.indexOf("(")!==-1},invertSign:function(){var a=this.isNegative();if(a)this.setPositiveSign();else this._currentValueInString=!this._currentValueInString.length?"0":"-"+this._currentValueInString;if(this.isZero())this._currentValueInString=a?"0":"-0";this.formatValue(this._currentValueInString)},increment:function(b){if(b===undefined)b=1;try{var a=this._currentValueInString.split(".");this._currentValueInString=a[0]*1+b+""+(a.length>1?"."+a[1]:"")}catch(c){}},decrement:function(b){if(b===undefined)b=1;try{var a=this._currentValueInString.split(".");this._currentValueInString=a[0]*1-b+""+(a.length>1?"."+a[1]:"")}catch(c){}},checkDigitsLimits:function(f){try{var a=this._currentValueInString.split("."),d,b,c,e;if(!a.length||a.length===1&&a[0]==="")return;d="";if(a.length>1)d=a[1];b="";for(c=0;c<f;c++){e="0";if(d.length>c)e=d.charAt(c);b=b+e}if(b.length>0)this._currentValueInString=a[0]+"."+b;else this._currentValueInString=a[0]}catch(g){}},checkMinValue:function(g,i,h){if(typeof h==="undefined")h=false;var e=true,a,b,c,d,f;try{a=this._currentValueInString.split(".");b=parseFloat(a[0]===""||a[0]==="-"?"0":a[0]);c=0;if(a.length>1&&parseFloat(a[1])>0)c=parseFloat("1."+a[1]);if(b<0||a[0]==="-")c=c*-1;g=""+g+"";a=g.split(".");d=parseFloat(a[0]);f=0;if(a.length>1&&parseFloat(a[1])>0)f=parseFloat("1."+a[1]);if(b>d)return true;if(b<d||h&&b===d&&c<=f)e=false;else if(b===d&&b<0&&c>f)e=false;else if(b===d&&b>=0&&c<f)e=false;if(!e&&i)this._currentValueInString=""+g+""}catch(j){}return e},checkMaxValue:function(g,h){var d=true,a,b,c,e,f;try{a=this._currentValueInString.split(".");b=parseFloat(a[0]===""||a[0]==="-"?"0":a[0]);c=0;if(a.length>1&&parseFloat(a[1])>0)c=parseFloat("1."+a[1]);if(b<0||a[0]==="-")c=c*-1;g=""+g+"";a=g.split(".");e=parseFloat(a[0]);f=0;if(a.length>1&&parseFloat(a[1])>0)f=parseFloat("1."+a[1]);if(b<e)return true;if(b>e)d=false;if(b===e&&b>=0&&c>f)d=false;if(b===e&&b<0&&c<f)d=false;if(!d&&h)this._currentValueInString=""+g+""}catch(i){}return d},applyFormatPattern:function(f,e,d,c){var a=f,b=new RegExp("[n]","g");a=a.replace(b,e);b=new RegExp("[%]","g");a=a.replace(b,d);b=new RegExp("[$]","g");a=a.replace(b,c);return a},formatDigit:function(l,k,h,j,i){var a=""+l+"",c,b,e,g,f,d;a=a.replace("-","");a=a.replace("(","");a=a.replace(")","");c=a.indexOf(h);if(c===-1)c=a.indexOf(".");if(c===-1)c=a.indexOf(",");if(c===-1)c=a.length;b="";e=0;g=0;for(d=a.length-1;d>=0;d--){f=a.charAt(d);if(d<c){b=f+b;g++;if(g===i[e]*1&&i[e]*1&&d){b=k+b;g=0;if(i.length-1>e)e++}}}if(j>0){b=b+h;for(d=0;d<j;d++){f="0";if(d+c+1<a.length)f=a.charAt(d+c+1);b=b+f}}if(j===-1)if(c<a.length-1){b=b+h;b=b+a.substr(c+1)}return b}}})(jQuery);
(function(a){"use strict";a.widget("wijmo.wijgrid",{options:{allowColMoving:false,allowColSizing:false,allowEditing:false,allowKeyboardNavigation:false,allowPaging:false,allowSorting:false,allowVirtualScrolling:false,alwaysParseData:true,cellStyleFormatter:undefined,columns:[],columnsAutogenerationMode:"merge",culture:"",customFilterOperators:[],data:null,ensureColumnsPxWidth:false,filterOperatorsSortMode:"alphabeticalCustomFirst",groupAreaCaption:"Drag a column here to group by that column.",groupIndent:10,highlightCurrentCell:false,loadingText:"Loading...",nullString:undefined,pageIndex:0,pageSize:10,pagerSettings:{mode:"numeric",pageButtonCount:10,position:"bottom"},readAttributesFromData:false,rowStyleFormatter:undefined,scrollMode:"none",selectionMode:"singleRow",showFilter:false,showFooter:false,showGroupArea:false,showRowHeader:false,staticColumnIndex:-1,staticRowIndex:-1,totalRows:-1,afterCellEdit:null,afterCellUpdate:null,beforeCellEdit:null,beforeCellUpdate:null,columnDragging:null,columnDragged:null,columnDropping:null,columnDropped:null,columnGrouping:null,columnGrouped:null,columnResizing:null,columnResized:null,columnUngrouping:null,columnUngrouped:null,currentCellChanging:null,currentCellChanged:null,filterOperatorsListShowing:null,filtering:null,filtered:null,groupAggregate:null,groupText:null,invalidCellValue:null,pageIndexChanging:null,pageIndexChanged:null,selectionChanged:null,sorting:null,sorted:null,ajaxError:null,dataLoading:null,dataLoaded:null,loading:null,loaded:null,rendering:null,rendered:null},_data$prefix:"wijgrid",_customSortOrder:1e3,_reverseKey:false,_pageSizeKey:10,_mergeWidgetsWithOptions:true,_ajaxError:function(b,a,c){this._trigger("ajaxError",null,{XMLHttpRequest:b,textStatus:a,errorThrown:c});this._deactivateSpinner()},_resetDataProperties:function(){this.options.pageIndex=0;var a=this._field("viewRenderBounds");a.start=a.end=0},_dataLoading:function(a){(!a||!a._wijgridMarker)&&this._loading();this._trigger("dataLoading")},_dataLoaded:function(a){this._trigger("dataLoaded");this.doRefresh(a);this._loaded()},_loading:function(){this._activateSpinner();this._trigger("loading")},_loaded:function(){this._deactivateSpinner();this._trigger("loaded")},ensureControl:function(d,b){var c=this._field("viewRenderBounds");this._loading();if(!a.isPlainObject(b))b={data:null,afterRefresh:null,beforeRefresh:null};b._wijgridMarker=true;if(this._initialized)this._convertWidgetsToOptions();else this._prepareColumnOptions(false);this._ownerise(true);this._field("allowVirtualScrolling",null);if(d===true){if(!b.virtualMode){c.start=c.end=0;b._scrollValue={type:"",hScrollValue:null,vScrollValue:null}}this._dataStore.load(b)}else{this.doRefresh(b);this._loaded()}},doRefresh:function(b){if(!a.isPlainObject(b))b={};var g,c,d,e=this,f=b&&b.virtualMode;if(!this._initialized)try{this._prepareColumnOptions(true)}catch(h){throw h;}finally{this._ownerise(true);this._initialized=true}else b&&a.isFunction(b.beforeRefresh)&&b.beforeRefresh.apply(this,[b]);if(!f){this._rebuildLeaves();c=this._dataStore.getDataSlice();a.each(this._field("leaves"),function(){this._totalsValue=c.totals?c.totals[this.dataKey]:undefined});this._setPageCount(c);this.sketchTable=[];if(c.data&&c.data.length){d=this._field("leaves");a.each(c.data,function(b,a){e.sketchTable.push(e._buildSketchRow(a,b,d))})}else if(c.emptyData){d=this._field("visibleLeaves");a.each(c.emptyData,function(b,a){e.sketchTable.push(e._buildSketchRowEmptyDataItem(a,d,b===c.emptyData.length-1))})}}this._onRendering(b);if(!f)this._refresh(b);else this._refreshVirtual(b);this._onRendered(b);b&&a.isFunction(b.afterRefresh)&&b.afterRefresh.apply(this,[b])},_buildSketchRow:function(c,h,f){var e,g,d,b=[];for(e=0,g=f.length;e<g;e++){d=f[e];if(a.wijmo.wijgrid.validDataKey(d.dataKey)){b.push({value:c.values[d.dataKey],__attr:c.attributes?c.attributes.cellsAttributes[d.dataKey]:{},__style:{}});b.originalRowIndex=c.originalRowIndex}}b.rowType=a.wijmo.wijgrid.rowType.data;if(h%2!==0)b.rowType|=a.wijmo.wijgrid.rowType.dataAlt;b.__style={};b.__attr=c.attributes?c.attributes.rowAttributes:{};return b},_buildSketchRowEmptyDataItem:function(e,h,g){var c,f,d=h.length,b=[];for(c=0,f=e.length;c<f;c++)b.push({html:e[c],__attr:{colSpan:d>0&&g?d:1},__style:{}});b.rowType=a.wijmo.wijgrid.rowType.emptyDataRow;b.__style={};b.__attr={};return b},getFilterOperatorsByDataType:function(b){var a=this.filterOperatorsCache.getByDataType(b||"string");this.filterOperatorsCache.sort(a,this.options.filterOperatorsSortMode);return a},setSize:function(d,c){var b=this._view(),f={type:"",hScrollValue:null,vScrollValue:null},h=this.outerDiv,g=this._field("frozener"),i=this._field("visibleLeaves"),e=[];if(b&&b.getScrollValue)f=b.getScrollValue();if(d||d===0){this._autoWidth=false;h.width(d)}if(c||c===0){this._autoHeight=false;h.height(c)}a.each(i,function(c){var e=b.getHeaderCell(c),d=b.getJoinedCols(c);a(e).css("width","");a.each(d,function(c,b){a(b).css("width","")})});a.each(this.columns(),function(){if(!this.options.isBand&&this.options.showFilter===true){this._setFilterEditorWidth(1);e.push(this)}});this._view().updateSplits(f);a.each(e,function(){this._setFilterEditorWidth(this._getFilterEditorWidth())});g&&g.refresh()},_prepareColumnOptions:function(g){a.wijmo.wijgrid.traverse(this.options.columns,function(b){b.isBand=a.isArray(b.columns)||b.clientType==="c1band";b._originalDataKey=b.dataKey;b._originalHeaderText=b.headerText});(new a.wijmo.wijgrid.bandProcessor)._getVisibleHeight(this.options.columns,true);var f=[],c,e=this._originalHeaderRowData(),d=this._originalFooterRowData(),b=(this.options.columnsAutogenerationMode||"").toLowerCase();if(g){c=this._dataStore.dataMode()===a.wijmo.wijgrid.dataMode.dom;b!=="none"&&new a.wijmo.wijgrid.columnsGenerator(this).generate(b,this._dataStore,this.options.columns)}a.wijmo.wijgrid.setTraverseIndex(this.options.columns);a.wijmo.wijgrid.traverse(this.options.columns,function(b){b.isBand=a.isArray(b.columns)||b.clientType==="c1band";a.wijmo.wijgrid.shallowMerge(b,a.wijmo.c1basefield.prototype.options);if(!b.isBand){a.wijmo.wijgrid.shallowMerge(b,a.wijmo.c1field.prototype.options);b.groupInfo=b.groupInfo||{};a.wijmo.wijgrid.shallowMerge(b.groupInfo,a.wijmo.c1field.prototype.options.groupInfo);if(!b.clientType)b.clientType="c1field"}else b.clientType="c1band";b.isLeaf&&!b.isBand&&f.push(b)});this._field("leaves",f);g&&a.each(f,function(h,f){var g=typeof f.dataKey==="number"?f.dataKey:h;if(b==="merge"||f.dynamic===true)if(f.headerText===undefined)if(c&&e&&g<e.length)f.headerText=a.trim(e[g]);else if(a.wijmo.wijgrid.validDataKey(f.dataKey))f.headerText=""+f.dataKey;if(c&&d&&g<d.length)f._footerTextDOM=a.trim(d[g])})},_rebuildLeaves:function(){var b=[],d=[],c;if(this.options.showRowHeader){c=a.wijmo.wijgrid.createDynamicField({clientType:"c1basefield",dataIndex:-1,travIdx:-1,parentVis:true,allowMoving:false,allowSizing:false,allowSort:false,isRowHeader:true});c.owner=this;b.push(c)}a.each(this.options.columns,function(c,a){b.push(a)});this._field("columnHeadersTable",(new a.wijmo.wijgrid.bandProcessor).generateSpanTable(b,d));this._field("leaves",d);this._onLeavesCreated()},_onLeavesCreated:function(){var d=this._field("leaves"),c=0,b=0,e=this;this._field("visibleLeaves",a.grep(d,function(d,f){d.leavesIdx=f;if(a.wijmo.wijgrid.validDataKey(d.dataKey))d.dataIndex=c++;else d.dataIndex=-1;if(!d.isBand){e._ensureDataParser(d);if(a.isFunction(d.dataParser))d.dataParser=new d.dataParser}if(d.parentVis){d.visLeavesIdx=b++;return true}return false}))},_create:function(){var d=this;if(!this.element.is("table"))throw"invalid markup";if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);a.isFunction(window.wijmoASPNetParseOptions)&&wijmoASPNetParseOptions(this.options);this.destroyed=false;var b=this.element[0].style.height,c=this.element[0].style.width;this._dataStore=new a.wijmo.wijgrid.dataStore(this);this._originalHtml=this.element.html();this.element.addClass("wijmo-wijgrid-root");this.element.wrap('<div class="ui-widget wijmo-wijgrid ui-widget-content ui-corner-all"></div>');this.outerDiv=this.element.parent();b&&this.outerDiv.css("height",this.element[0].style.height);if(b!==""&&b!=="auto")this._autoHeight=false;else this._autoHeight=true;c&&this.outerDiv.css("width",this.element[0].style.width);if(c!==""&&c!=="auto")this._autoWidth=false;else this._autoWidth=true;this.element.css({height:"",width:""});this.filterOperatorsCache=new a.wijmo.wijgrid.filterOperatorsCache;this._registerFilterOperator(a.wijmo.wijgrid.embeddedFilters);this.options.disabled&&this.disable();this.cellFormatter=new a.wijmo.wijgrid.cellFormatterHelper;this.rowStyleFormatter=new a.wijmo.wijgrid.rowStyleFormatterHelper(this);this.cellStyleFormatter=new a.wijmo.wijgrid.cellStyleFormatterHelper(this);this._field("viewRenderBounds",{start:0,end:0,scrollIndex:0});this.element.wijAddVisibilityObserver&&this.element.wijAddVisibilityObserver(function(){d.setSize()},"wijgrid")},_init:function(){this.$superPanelHeader=null;this.$topPagerDiv=null;this.$bottomPagerDiv=null;this.$groupArea=null;this.filterOperatorsCache.removeCustom();a.each(this.options.customFilterOperators,function(b,a){if(a)a.custom=true});this._registerFilterOperator(this.options.customFilterOperators);this._field("closestCulture",Globalize.findClosestCulture(this.options.culture)||Globalize.findClosestCulture("default"));if(!this.options.data){!this._field("thead")&&this._field("thead",a.wijmo.wijgrid.readTableSection(this.element,1));!this._field("tfoot")&&this._field("tfoot",a.wijmo.wijgrid.readTableSection(this.element,3))}this._initialized=this._initialized||false;this.ensureControl(true)},_setOption:function(c,b){var g=this["_preset_"+c],e=this.options[c],f,d;if(g!==undefined)b=g.apply(this,[b,e]);f=b!==e;a.Widget.prototype._setOption.apply(this,[c,b]);if(f){d=this["_postset_"+c];d!==undefined&&d.apply(this,[b,e])}},destroy:function(){var b,c=this;try{this._view().dispose();this._dataStore.dispose();this._detachEvents(true);(b=this._field("resizer"))&&b.dispose();(b=this._field("frozener"))&&b.dispose();a.wijmo.wijgrid.iterateChildrenWidgets(this.outerDiv,function(b,a){a!==c&&a.destroy()});(b=this._field("selectionui"))&&b.dispose();(b=this._field("dragndrop"))&&b.dispose();a.wijmo.wijgrid.remove$dataByPrefix(this.element,this._data$prefix);this.element.removeClass("wijmo-wijgrid-root");this.element.html(this._originalHtml);this.element.insertBefore(this.outerDiv);this.outerDiv.remove();a.Widget.prototype.destroy.apply(this,arguments)}finally{this.destroyed=true}},columns:function(){return this._field("columns")||[]},currentCell:function(c,d){var b,f=this._view(),e=this._rows();if(arguments.length===0){b=this._field("currentCell");!b&&this._field("currentCell",b=a.wijmo.wijgrid.cellInfo.prototype.outsideValue);return b}else{b=arguments.length===1?c._clone():new a.wijmo.wijgrid.cellInfo(c,d);if(!b.isEqual(a.wijmo.wijgrid.cellInfo.prototype.outsideValue)){if(!b._isValid())throw"invalid arguments";b._clip(this._getDataCellsRange());if(b.rowIndex()>=0)if(!(f._getRowInfo(e.item(b.rowIndex())).type&a.wijmo.wijgrid.rowType.data))return}b._setGridView(this);this._changeCurrentCell(b);return this._field("currentCell")}},data:function(){return this._dataStore.dataSource().items},selection:function(){var b=this._field("selection");!b&&this._field("selection",b=new a.wijmo.wijgrid.selection(this));return b},beginEdit:function(){return this._beginEditInternal(null)},endEdit:function(){return this._endEditInternal(null)},pageCount:function(){return this.options.allowPaging?this._field("pageCount")||1:1},_allowVirtualScrolling:function(){var a=this._field("allowVirtualScrolling");if(!a)a=this._field("allowVirtualScrolling",!this.options.allowPaging&&this.options.allowVirtualScrolling&&this.options.staticRowIndex<0&&this.options.scrollMode!=="none"&&!this._hasMerging());return a},_dragndrop:function(){var b=this._field("dragndrop");!b&&this._field("dragndrop",b=new a.wijmo.wijgrid.dragAndDropHelper(this));return b},_headerRows:function(){return this._view().headerRows()},_filterRow:function(){return this._view().filterRow()},_localizeFilterOperators:function(b){var c=this;a.each(b,function(d,a){if(a.name){var b=c.filterOperatorsCache.getByName(a.name);if(b)b.displayName=a.displayName}})},_rows:function(){return this._view().bodyRows()},_selectionui:function(){var b=this._field("selectionui");!b&&this._field("selectionui",b=new a.wijmo.wijgrid.selectionui(this));return b},_setPageCount:function(a){this._field("pageCount",Math.ceil(a.totalRows/this.options.pageSize)||1)},_registerFilterOperator:function(b){var d=this,c=b&&(a.isArray(b)||a.isPlainObject(b)&&!b.operator)?b:arguments;a.each(c,function(b,a){d.filterOperatorsCache.add(a)})},_postset_allowColMoving:function(c){var b=this;a.each(this.columns(),function(d,a){if(c)b._dragndrop().attach(a);else b._dragndrop().detach(a)});a.each(this._field("groupedWidgets"),function(d,a){if(c)b._dragndrop().attach(a);else b._dragndrop().detach(a)})},_postset_allowSorting:function(){this.ensureControl(false)},_postset_columns:function(){throw"read-only";},_postset_allowPaging:function(){this.ensureControl(true)},_postset_culture:function(){throw"read-only";},_postset_customFilterOperators:function(b){this.filterOperatorsCache.removeCustom();a.each(this.options.customFilterOperators,function(b,a){a.custom=true});this._registerFilterOperator(b)},_postset_data:function(){this._ownerise(false);a.wijmo.wijgrid.traverse(this.options.columns,function(b,c){if(b.dynamic){var d=a.inArray(b,c);d>=0&&c.splice(d,1)}else{b.dataKey=b._originalDataKey;b.headerText=b._originalHeaderText}});this._initialized=false;this._dataStore&&this._dataStore.dispose();this._dataStore=new a.wijmo.wijgrid.dataStore(this);this.ensureControl(true)},_postset_disabled:function(c){var d=this,b=this._view();a.wijmo.wijgrid.iterateChildrenWidgets(this.outerDiv,function(b,a){a!==d&&a.option("disabled",c)});b&&b.ensureDisabledState()},_postset_groupIndent:function(){this.ensureControl(false)},_postset_groupAreaCaption:function(b){var a=this._field("groupedColumns");this.$groupArea&&(!a||!a.length)&&this.$groupArea.html(b||"&nbsp;")},_postset_highlightCurrentCell:function(b){var a=this.currentCell();a&&a._isValid()&&this._highlightCellPosition(a,b)},_preset_pageIndex:function(a,d){if(isNaN(a))throw"out of range";var c=this.pageCount(),e=function(a){if(a>c-1)a=c-1;if(a<0)a=0;return a},b;a=e(a);if(this.options.allowPaging&&a!==d){b={newPageIndex:a};if(!this._onPageIndexChanging(b))a=d;else a=e(b.newPageIndex)}return a},_postset_pageIndex:function(b){if(this.options.allowPaging){var a={newPageIndex:b};if(this._customPagingEnabled()){this._convertWidgetsToOptions();this._onPageIndexChanged(a)}else this.ensureControl(true,{afterRefresh:function(){this._onPageIndexChanged(a)}})}},_preset_pageSize:function(a){if(isNaN(a))throw"out of range";if(a<=0)a=1;return a},_postset_pageSize:function(){this._resetDataProperties();this.options.allowPaging&&!this._customPagingEnabled()&&this.ensureControl(true)},_postset_pagerSettings:function(){this.ensureControl(false)},_postset_scrollMode:function(b,a){if(b==="none"||a==="none")this.ensureControl(false);else this._view().refreshPanel()},_postset_selectionMode:function(d){var c=this.selection(),b=this.currentCell();c.beginUpdate();c.clear();b&&b._isValid()&&c._selectRange(new a.wijmo.wijgrid.cellInfoRange(b,b),false,false,0,null);c.endUpdate();this._view().toggleDOMSelection(d==="none")},_postset_showFilter:function(){this.ensureControl(false)},_postset_showGroupArea:function(){this.ensureControl(false)},_postset_showRowHeader:function(){this.ensureControl(false)},_postset_staticRowIndex:function(){this.options.scrollMode!=="none"&&this.ensureControl(false)},_postset_staticColumnIndex:function(){this.options.scrollMode!=="none"&&this.ensureControl(false)},_postset_allowVirtualScrolling:function(){this.ensureControl(false)},_preset_allowVirtualScrolling:function(a){if(isNaN(a)||a<0)throw"out of range";return a},_activateSpinner:function(){var a=this.outerDiv.append('<div class="wijmo-wijgrid-overlay ui-widget-overlay"></div><span class="wijmo-wijgrid-loadingtext ui-widget-content ui-corner-all"><span class="ui-icon ui-icon-clock"></span>'+this.options.loadingText+"</span>").find("> .wijmo-wijgrid-loadingtext");a.position({my:"center",at:"center center",of:this.outerDiv,collision:"none"})},_customPagingEnabled:function(){return this.options.allowPaging&&this.options.totalRows>=0},_deactivateSpinner:function(){this.outerDiv.find("> .wijmo-wijgrid-overlay, > .wijmo-wijgrid-loadingtext").remove()},_columnWidgetsFactory:function(e,b){var c,d=b.clientType;if(!d&&b.isBand)d="c1band";b=a.extend({owner:this},b,{disabled:this.options.disabled});switch(d){case"c1basefield":c=e.c1basefield(b);break;case"c1band":c=e.c1band(b);break;default:c=e.c1field(b)}return c},_convertWidgetsToOptions:function(){if(this._initialized&&this._mergeWidgetsWithOptions){this._ownerise(false);this._widgetsToOptions();this._ownerise(true)}},_field:function(c,b){return a.wijmo.wijgrid.dataPrefix(this.element,this._data$prefix,c,b)},_removeField:function(b){var a=this._data$prefix+b;this.element.removeData(a)},_prepareFilterRequest:function(d){var b=this._field("leaves"),c;if(!b)return[];c=a.map(b,a.proxy(function(b){if(!b.isBand&&a.wijmo.wijgrid.validDataKey(b.dataKey)&&b.filterOperator){var f=a.extend(true,{},{foo:b.filterValue}).foo,e=a.extend(true,{},{foo:b.filterOperator}).foo,c=a.wijmo.wijgrid.filterHelper.verify(e,f,b.dataType,this.filterOperatorsCache);if(c)return d?[{column:b,filterOperator:c.filterOperator,filterValue:c.filterValue}]:[{dataKey:b.dataKey,filterOperator:c.filterOperator,filterValue:c.filterValue}]}return null},this));return c},_preparePageRequest:function(){return this.options.allowPaging?{pageIndex:this.options.pageIndex,pageSize:this.options.pageSize}:null},_prepareSortRequest:function(){var c=this._field("leaves"),b;if(!c||!this.options.allowSorting)return[];b=a.map(c,function(b){var c=null;if(!b.isBand&&b.allowSort&&a.wijmo.wijgrid.validDataKey(b.dataKey)){if(b.groupInfo&&b.groupInfo.position!=="none"&&b.sortDirection==="none")b.sortDirection="ascending";c=b.sortDirection==="ascending"||b.sortDirection==="descending"?[{dataKey:b.dataKey,sortDirection:b.sortDirection,sortOrder:b.sortOrder||0}]:null}return c});b.sort(function(a,b){return a.sortOrder-b.sortOrder});a.each(b,function(b,a){delete a.sortOrder});return b},_prepareTotalsRequest:function(d){var b=this._field("leaves"),c;if(!b||!this.options.showFooter)return[];c=a.map(b,function(b){return!b.isBand&&a.wijmo.wijgrid.validDataKey(b.dataKey)&&b.aggregate&&b.aggregate!=="none"?d?[{column:b,aggregate:b.aggregate}]:[{dataKey:b.dataKey,aggregate:b.aggregate}]:null});return c},_widgetsToOptions:function(){var b=a.wijmo.wijgrid.flatten(this.options.columns);a.each(this.columns(),function(e,c){delete c.options.columns;var d=b[c.options.travIdx];a.extend(true,d,c.options);d.filterValue=c.options.filterValue;d.filterOperator=c.options.filterOperator})},_recreateColumnWidgets:function(){a.each(this.columns(),function(b,a){a.destroy()});var h=[],f=this._headerRows(),b,d,i,c,g,j,e;if(f&&f.length()){b=[];a.wijmo.wijgrid.traverse(this.options.columns,function(a){a.parentVis&&b.push(a)});for(d=0,i=b.length;d<i;d++){c=b[d];g=f.item(c.thY);j=(new a.wijmo.wijgrid.rowAccessor).getCell(g,c.thX);e=this._columnWidgetsFactory(a(j),c);h.push(e.data(e.data(a.wijmo.c1basefield.prototype._data$prefix+"widgetName")))}}this._field("columns",h)},_ownerise:function(b){if(b){var c=this;a.wijmo.wijgrid.traverse(this.options.columns,function(d){d.owner=c;var a,b,e;if(a=d.groupInfo){a.owner=d;if(a.expandInfo)for(b=0,e=a.expandInfo.length;b<e;b++)a.expandInfo[b].owner=a}})}else a.wijmo.wijgrid.traverse(this.options.columns,function(c){delete c.owner;var a,b,d;if(a=c.groupInfo){delete a.owner;if(a.expandInfo)for(b=0,d=a.expandInfo.length;b<d;b++)delete a.expandInfo[b].owner}})},_ensureRenderBounds:function(a){var b=this._totalRowsCount();if(a.start<0)a.start=0;a.start=Math.min(a.start,b-1);if(a.end<0)a.end=0;a.end=Math.min(a.end,b-1);return a},_refresh:function(){(new a.wijmo.wijgrid.grouper).group(this,this.sketchTable,this._field("leaves"));(new a.wijmo.wijgrid.merger).merge(this.sketchTable,this._field("visibleLeaves"));var b=this._field("viewRenderBounds");this._ensureRenderBounds(b);if(this.options.scrollMode!=="none")this._field("view",new a.wijmo.wijgrid.fixedView(this,this._field("viewRenderBounds")));else this._field("view",new a.wijmo.wijgrid.flatView(this,this._field("viewRenderBounds")));this._render();this._ownerise(false);this._recreateColumnWidgets();this._ownerise(true);if(this.options.allowPaging){this.$topPagerDiv&&this.$topPagerDiv.wijpager(this._pagerSettings2PagerWidgetSettings()).css("zIndex",5);this.$bottomPagerDiv&&this.$bottomPagerDiv.wijpager(this._pagerSettings2PagerWidgetSettings()).css("zIndex",5)}},_refreshVirtual:function(j){var e=this._field("viewRenderBounds"),g=this._view(),h="none",c=this._ensureRenderBounds({start:j.scrollIndex,end:j.scrollIndex+this.options.pageSize-1}),i=function(b){return b.rowType&a.wijmo.wijgrid.rowType.data?b.originalRowIndex:-1},f,b,d;if(c.start>e.end||c.end<e.start)h="reset";else if(c.start>e.start)h="overlapBottom";else if(c.start<e.start)h="overlapTop";switch(h){case"reset":g._clearBody();for(b=c.start;b<=c.end;b++){d=this.sketchTable[b];g._insertBodyRow(d,-1,i(d),-1)}break;case"overlapBottom":f={start:c.start,end:e.end};for(b=0;b<f.start-e.start;b++)g._removeBodyRow(0,false);for(b=f.end+1;b<=c.end;b++){d=this.sketchTable[b];g._insertBodyRow(d,-1,i(d),-1)}break;case"overlapTop":f={start:e.start,end:c.end};for(b=0;b<e.end-c.end;b++)g._removeBodyRow(f.end-f.start+1,false);for(b=e.start-1;b>=c.start;b--){d=this.sketchTable[b];g._insertBodyRow(d,0,i(d),-1)}}j._newBounds=c},_needToCreatePagerItem:function(){return this.options.allowPaging},_render:function(){var d=this._view(),b=this.options,c;d.render();c=this.outerDiv;if(b.scrollMode!=="none")c=this.outerDiv.find("div.wijmo-wijgrid-scroller:first");this.$superPanelHeader=null;if(this.$topPagerDiv){this.$topPagerDiv.data("wijpager")&&this.$topPagerDiv.wijpager("destroy");this.$topPagerDiv.remove()}this.$topPagerDiv=null;if(this._needToCreatePagerItem()&&(b.pagerSettings.position==="top"||b.pagerSettings.position==="topAndBottom"))if(!this.$topPagerDiv){c.prepend(this.$superPanelHeader=a('<div class="wijmo-wijsuperpanel-header"></div>'));this.$superPanelHeader.prepend(this.$topPagerDiv=a('<div class="wijmo-wijgrid-header ui-widget-header ui-corner-top"></div>'))}if(b.showGroupArea)this._processGroupArea(c);else this.$groupArea=null;if(this.$bottomPagerDiv){this.$bottomPagerDiv.data("wijpager")&&this.$bottomPagerDiv.wijpager("destroy");this.$bottomPagerDiv.remove()}this.$bottomPagerDiv=null;if(this._needToCreatePagerItem()&&(b.pagerSettings.position==="bottom"||b.pagerSettings.position==="topAndBottom"))!this.$bottomPagerDiv&&c.append(this.$bottomPagerDiv=a('<div class="wijmo-wijgrid-footer wijmo-wijsuperpanel-footer ui-state-default ui-corner-bottom"></div>'))},_processGroupArea:function(e){var b=this,d=this._field("groupedColumns"),c=[];this.$groupArea=a('<div class="ui-widget-content ui-helper-clearfix"></div>');if(d.length>0)a.each(d,function(f,d){var e=a('<a href="#"></a>').appendTo(b.$groupArea);e.c1groupedfield(a.extend({owner:b},{allowMoving:d.allowMoving,allowSort:d.allowSort,dataIndex:d.dataIndex,headerText:d.headerText,isBand:d.isBand,isLeaf:d.isLeaf,linearIdx:d.linearIdx,parentIdx:d.parentIdx,sortDirection:d.sortDirection,travIdx:d.travIdx,groupedIndex:d.groupedIndex},{disabled:b.options.disabled}));c.push(e.data("c1groupedfield"))});else this.$groupArea.addClass("wijmo-wijgrid-group-area").html(this.options.groupAreaCaption||"&nbsp;");this._field("groupedWidgets",c);!this.$superPanelHeader&&e.prepend(this.$superPanelHeader=a('<div class="wijmo-wijsuperpanel-header"></div>'));this.$superPanelHeader.prepend(this.$groupArea);this._dragndrop().attachGroupArea(this.$groupArea)},_attachEvents:function(){var c=this._view(),d=c.focusableElement(),b=0;d.bind("keydown."+this.widgetName,a.proxy(this._onKeyDown,this));d.bind("keypress."+this.widgetName,a.proxy(this._onKeyPress,this));a.each(c.subTables(),a.proxy(function(d,c){var b=c.element();if(b){b.tHead&&a(b.tHead).bind("click."+this.widgetName,a.proxy(this._onClick,this));b.tBodies.length&&a(b.tBodies[0]).bind("click."+this.widgetName,a.proxy(this._onClick,this)).bind("dblclick."+this.widgetName,a.proxy(this._onDblClick,this)).bind("mousemove."+this.widgetName,a.proxy(this._onMouseMove,this)).bind("mouseout."+this.widgetName,a.proxy(this._onMouseOut,this))}},this));a(window).bind("resize."+this.widgetName,a.proxy(function(){var a=this;if(b>0){window.clearTimeout(b);b=0}if(b!==-1)b=window.setTimeout(function(){b=-1;try{!a.destroyed&&a._initialized&&a.element.parent().length&&a.setSize()}finally{b=0}},50)},this))},_detachEvents:function(){var b=this._view(),d=this,c;if(b){c=b.focusableElement();c.unbind("keydown."+this.widgetName);c.unbind("keypress."+this.widgetName);a.each(b.subTables(),function(){var b=this.element();if(b){b.tHead&&a(b.tHead).unbind("."+d.widgetName);b.tBodies.length&&a(b.tBodies[0]).unbind("."+d.widgetName)}})}a(window).unbind("resize."+this.widgetName)},_handleSort:function(b,f){var g=this.options.columns,e=b.travIdx,d,c;if(b&&this.options.allowSorting){d=b.sortDirection==="none"?"ascending":b.sortDirection==="ascending"?"descending":"ascending";c={column:b,sortDirection:d,sortCommand:b.dataKey+" "+(d==="ascending"?"asc":"desc")};if(this._onColumnSorting(c)){b.sortDirection=c.sortDirection;if(f)b.sortOrder=this._customSortOrder++;else{this._customSortOrder=1e3;a.each(this.columns(),function(b,a){a.options.sortOrder=0;if(a.options.travIdx!==e&&!(a.options.groupInfo&&a.options.groupInfo.position!=="none"))a.options.sortDirection="none"});a.wijmo.wijgrid.traverse(g,function(a){a.sortOrder=0;if(a.travIdx!==e&&!(a.groupInfo&&a.groupInfo.position!=="none"))a.sortDirection="none"})}c={column:b,sortDirection:b.sortDirection,sortCommand:b.dataKey+" "+(b.sortDirection==="ascending"?"asc":"desc")};if(this._customPagingEnabled()){this._convertWidgetsToOptions();this._onColumnSorted(c)}else this.ensureControl(true,{afterRefresh:function(){this._onColumnSorted(c)}})}}},_pagerSettings2PagerWidgetSettings:function(){return a.extend({},this.options.pagerSettings,{disabled:this.options.disabled,pageCount:this.pageCount(),pageIndex:this.options.pageIndex,pageIndexChanging:a.proxy(this._onPagerWidgetPageIndexChanging,this),pageIndexChanged:a.proxy(this._onPagerWidgetPageIndexChanged,this)})},_handleDragnDrop:function(i,j,d,e,f){var c=a.wijmo.wijgrid.getColumnByTravIdx(this.options.columns,i),b=a.wijmo.wijgrid.getColumnByTravIdx(this.options.columns,j),g=e?"groupArea":"columns",h=f?"groupArea":"columns";if(f)this._onColumnGrouping({drag:c.found,drop:b?b.found:null,dragSource:g,dropSource:h,at:d})&&this.ensureControl(true,{beforeRefresh:function(){if(!b)c.found.groupedIndex=0;else switch(d){case"left":c.found.groupedIndex=b.found.groupedIndex-.5;break;case"right":c.found.groupedIndex=b.found.groupedIndex+.5}!e&&a.extend(true,c.found,{groupInfo:{position:"header"}})},afterRefresh:function(){this._onColumnGrouped({drag:c.found,drop:b?b.found:null,dragSource:g,dropSource:h,at:d})}});else this._onColumnDropping({drag:c.found,drop:b.found,at:d})&&this.ensureControl(false,{beforeRefresh:function(){c.at.splice(c.found.linearIdx,1);switch(d){case"left":if(c.at===b.at&&c.found.linearIdx<b.found.linearIdx)b.at.splice(b.found.linearIdx-1,0,c.found);else b.at.splice(b.found.linearIdx,0,c.found);break;case"right":if(c.at===b.at&&c.found.linearIdx<b.found.linearIdx)b.at.splice(b.found.linearIdx,0,c.found);else b.at.splice(b.found.linearIdx+1,0,c.found);break;case"center":b.found.columns.push(c.found)}a.wijmo.wijgrid.setTraverseIndex(this.options.columns)},afterRefresh:function(){this._onColumnDropped({drag:c.found,drop:b.found,at:d})}})},_handleFilter:function(a,f,g){var d=this.filterOperatorsCache.getByName(f),b,e,c;if(d){if(d.arity>1){b=this._parse(a.options,g);e=b!==null&&(a.options.dataType==="string"||!isNaN(b))}else e=true;if(e){c={column:a.options,operator:d.name,value:b};if(this._onColumnFiltering(c)){a.options.filterValue=c.value;a.options.filterOperator=c.operator;this._resetDataProperties();if(this._customPagingEnabled()){this._convertWidgetsToOptions();this._onColumnFiltered({column:a.options})}else this.ensureControl(true,{afterRefresh:function(){this._onColumnFiltered({column:a.options})}})}}}},_handleUngroup:function(c){var b=a.wijmo.wijgrid.getColumnByTravIdx(this.options.columns,c);if(b&&b.found){b=b.found;this._onColumnUngrouping({column:b})&&this.ensureControl(false,{beforeRefresh:function(){delete b.groupedIndex;a.extend(true,b,{groupInfo:{position:"none"}})},afterRefresh:function(){this._onColumnUngrouped({column:b})}})}},_handleVirtualScrolling:function(c,b){this.ensureControl(true,{virtualMode:true,scrollIndex:c,afterRefresh:function(c){var d=this._field("viewRenderBounds");a.extend(d,c._newBounds);this._view()._adjustRowsHeights();b()}})},_onColumnDropping:function(a){return this._trigger("columnDropping",null,a)},_onColumnDropped:function(a){this._trigger("columnDropped",null,a)},_onColumnGrouping:function(a){return this._trigger("columnGrouping",null,a)},_onColumnGrouped:function(a){this._trigger("columnGrouped",null,a)},_onColumnUngrouping:function(a){return this._trigger("columnUngrouping",null,a)},_onColumnUngrouped:function(a){this._trigger("columnUngrouped",null,a)},_onColumnFiltering:function(a){return this._trigger("filtering",null,a)},_onColumnFiltered:function(a){this._trigger("filtered",null,a)},_onColumnSorting:function(a){return this._trigger("sorting",null,a)},_onColumnSorted:function(a){this._trigger("sorted",null,a)},_onCurrentCellChanged:function(){var b=this.options,a;a=this._field("currentCell");b.scrollMode!=="none"&&a&&!a.isEqual(a.outsideValue)&&this._view().scrollTo(a);this._trigger("currentCellChanged")},_onPageIndexChanging:function(a){return this._trigger("pageIndexChanging",null,a)},_onPageIndexChanged:function(a){this._trigger("pageIndexChanged",null,a)},_onPagerWidgetPageIndexChanging:function(b,a){a.handled=true},_onPagerWidgetPageIndexChanged:function(b,a){this._setOption("pageIndex",a.newPageIndex)},_onRendering:function(b){var a=this._view();this._rendered=false;if(b.virtualMode)this.selection().clear();else{if(a){if(a.getScrollValue&&!b._scrollValue)b._scrollValue=a.getScrollValue();a.dispose()}this._detachEvents(false);this.element.detach();this.element.empty();this.outerDiv.empty();this.outerDiv.append(this.element);this._field("selection",null);if(this._field("selectionui")){this._field("selectionui").dispose();this._field("selectionui",null)}this._field("resizer")&&this._field("resizer").dispose();this._field("frozener")&&this._field("frozener").dispose()}this._trigger("rendering")},_onRendered:function(f){var g=this._view(),b,d,c,e=[];this._rendered=true;g.focusableElement().attr("tabIndex",0);b=this.currentCell();if(b._isValid()&&(b=this.currentCell(b)))b._isEdit(false);else b=this.currentCell(this._getFirstDataRowCell(0));b=this.currentCell();if(b._isValid()){this.selection()._startNewTransaction(b);this.selection()._selectRange(new a.wijmo.wijgrid.cellInfoRange(b,b),false,false,0,null)}if(!f.virtualMode){this._attachEvents();this._selectionui();d=new a.wijmo.wijgrid.resizer(this);a.each(this.columns(),function(c,b){var a=b.options;a.visible&&a.parentVis&&a.isLeaf&&d.addElement(b)});this._field("resizer",d);g.updateSplits(f._scrollValue);if(this.options.scrollMode!=="none"){c=new a.wijmo.wijgrid.frozener(this);c.addVElement(this._getStaticIndex(false));c.addHElement(this._getStaticIndex(true));c.attachDivEvent();this._field("frozener",c)}a.each(this.columns(),function(c,a){if(!a.options.isBand&&a.options.showFilter===true){var b=a._getFilterEditorWidth();b!==undefined&&e.push({widget:a,width:b})}});a.each(e,function(b,a){a.widget._setFilterEditorWidth(a.width)})}this._trigger("rendered")},_onClick:function(b){if(!this._canInteract()||!b.target)return;if(a(b.target).is(".wijmo-wijgrid-grouptogglebtn")){this._onGroupBtnClick(b);return}var k=this._view(),j=this._getParentSubTable(b.target,["td","th"],k.subTables()),h,g,c,f=0,e,d,i;if(j){h=j[0];g=a(h).closest("tr");if(!(g.is(".wijmo-wijgrid-datarow")||g.is(".wijmo-wijgrid-headerrow")))return;if(!g.length)return;c=k.getAbsoluteCellInfo(h)._absToData(this._getDataToAbsOffset());if(c.cellIndex()<0||c.rowIndex()<0)if(c.rowIndex()>=0){c=new a.wijmo.wijgrid.cellInfo(0,c.rowIndex());f=2}else{c=this._getFirstDataRowCell(c.cellIndex());f=1}this._changeCurrentCell(c);e=this.currentCell();!e._isEdit()&&(i=e.tableCell())&&!a(b.target).is(":focus")&&a(i).focus();d=this.selection();(!b.shiftKey||!d._multipleRangesAllowed()&&this.options.selectionMode.toLowerCase()!=="singlerange")&&d._startNewTransaction(e);d.beginUpdate();if(b.shiftKey&&b.ctrlKey)d._clearRange(new a.wijmo.wijgrid.cellInfoRange(e,e),f);else d._selectRange(new a.wijmo.wijgrid.cellInfoRange(d._anchorCell(),e),b.ctrlKey,b.shiftKey,f,null);d.endUpdate()}},_onDblClick:function(a){this._beginEditInternal(a)},_onGroupBtnClick:function(e){if(!this._canInteract())return;var g=a(e.target).closest("tr"),f=new a.wijmo.wijgrid.groupHelper,c=f.getGroupInfo(g[0]),d,b;if(c){d=f.getColumnByGroupLevel(this._field("leaves"),c.level);if(d){b=d.groupInfo.expandInfo[c.index];if(b.isExpanded)b.collapse(e.shiftKey);else b.expand(e.shiftKey);this._view().ensureHeight()}}},_onKeyDown:function(b){if(!this._canInteract())return true;var d=b.target.tagName.toLowerCase(),g=false,f,h,e,c;if((d==="input"||d==="option"||d==="select"||d==="textarea")&&a(b.target).closest("tr.wijmo-wijgrid-datarow").length===0)return true;if(this.options.allowEditing)if((b.which===a.ui.keyCode.ESCAPE||b.which===113)&&this.currentCell()._isValid()&&this.currentCell()._isEdit()){this._endEditInternal(b);return false}else if(b.which===113){this._beginEditInternal(b);return false}if(!this.options.allowKeyboardNavigation||b.which===a.ui.keyCode.TAB)return true;switch(b.which){case a.ui.keyCode.LEFT:case a.ui.keyCode.RIGHT:case a.ui.keyCode.DOWN:case a.ui.keyCode.UP:case a.ui.keyCode.PAGE_DOWN:case a.ui.keyCode.PAGE_UP:case a.ui.keyCode.HOME:case a.ui.keyCode.END:case a.ui.keyCode.TAB:f=this._getNextCurrencyPos(this._getDataCellsRange(),this.currentCell(),b.keyCode,b.shiftKey);g=this._canMoveToAnotherCell(b.target,b.which)}if(g){this._changeCurrentCell(new a.wijmo.wijgrid.cellInfo(f.cellIndex,f.rowIndex));e=this.currentCell();c=this.selection();(!b.shiftKey||!c._multipleRangesAllowed()&&this.options.selectionMode.toLowerCase()!=="singlerange")&&c._startNewTransaction(e);c.beginUpdate();c._selectRange(new a.wijmo.wijgrid.cellInfoRange(c._anchorCell(),e),false,b.shiftKey,0,null);c.endUpdate();return false}return true},_onKeyPress:function(c){if(this._canInteract()&&this.options.allowEditing){var g=c.which,f=this.currentCell(),b,d,e;if(g&&f._isValid()&&!f._isEdit()){b=c.target.tagName.toLowerCase();if(b!=="input"&&b!=="option"&&b!=="select"&&b!=="textarea"){d=a(c.target).closest(".wijmo-wijgrid-table");if(d.length){e=a.map(this._view().subTables(),function(a){return a.element()});if(a.inArray(d[0],e)>=0)if(a.wij.charValidator.isPrintableChar(String.fromCharCode(g))){this._beginEditInternal(c);return false}}}}}},_onMouseMove:function(k){if(!this._canInteract())return;var e=this._view(),i=this._getParentSubTable(k.target,["td","th"],e.subTables()),h,f,g,b,d,c,j=a.wijmo.wijgrid.renderState;if(i){h=i[0];f=a(h).closest("tr");if(!f.length||f.is(".wijmo-wijgrid-foorow")||!(f.is(".wijmo-wijgrid-datarow")||f.is(".wijmo-wijgrid-headerrow")))return;g=e.getAbsoluteCellInfo(h)._absToData(this._getDataToAbsOffset());b=this._field("hoveredRow");if(b!==undefined&&g.rowIndex()!==b){d=this._rows().item(b);if(d){c=e._getRowInfo(d);e._changeRowRenderState(c,j.hovered,false);this.rowStyleFormatter.format(c)}}b=g.rowIndex();this._field("hoveredRow",b);if(b>=0){d=this._rows().item(b);if(d){c=e._getRowInfo(d);e._changeRowRenderState(c,j.hovered,true);this.rowStyleFormatter.format(c)}}}},_onMouseOut:function(f){if(!this._canInteract())return;if(a(f.relatedTarget).closest(".wijmo-wijgrid-data").length===0){var d=this._field("hoveredRow"),c,b,e=this._view();if(d>=0){c=this._rows().item(d);if(c){b=e._getRowInfo(c);e._changeRowRenderState(b,a.wijmo.wijgrid.renderState.hovered,false);this.rowStyleFormatter.format(b)}}}},_fieldResized:function(b,c,a){if(c<0)c=0;if(a<=0)a=1;if(this._trigger("columnResizing",null,{column:b.options,oldWidth:c,newWidth:a})!==false){b.option("width",a);this._trigger("columnResized",null,{column:b.options})}},_changeCurrentCell:function(c){var b=this.currentCell(),e=this._getDataCellsRange(),h,g,f=this.options.highlightCurrentCell,d;if(e._isValid()&&e._containsCellInfo(c)||c.isEqual(c.outsideValue))if(b.cellIndex()!==c.cellIndex()||b.rowIndex()!==c.rowIndex()){h={cellIndex:c.cellIndex(),rowIndex:c.rowIndex(),oldCellIndex:b.cellIndex(),oldRowIndex:b.rowIndex()};if(this._trigger("currentCellChanging",null,h)){g=false;if(!this.options.allowEditing||!b._isEdit()||(g=this._endEditInternal(null))){if(e._containsCellInfo(b)){f&&this._highlightCellPosition(b,false);(d=b.tableCell())&&a(d).removeAttr("tabIndex")}b=c._clone();b._setGridView(this);f&&this._highlightCellPosition(b,true);(d=b.tableCell())&&a(d).attr("tabIndex",0);this._field("currentCell",b);this._onCurrentCellChanged()}}}else{f&&this._highlightCellPosition(b,true);(d=b.tableCell())&&a(d).attr("tabIndex",0)}},_highlightCellPosition:function(d,i){if(d&&d._isValid()){var j=d._clone()._dataToAbs(this._getDataToAbsOffset()),g=j.cellIndex(),k=j.rowIndex(),h=a.wijmo.wijgrid.renderState,c=this._view(),b,e,f;b=c.getHeaderCell(g);if(b){e=c._getRowInfo(this._headerRows().item(d.column().thY));b=a(b);f=c._changeCellRenderState(b,h.current,i);this.cellStyleFormatter.format(b,g,d.column(),e,f)}b=c.getJoinedRows(k,0);if(b){e=c._getRowInfo(b);c._changeRowRenderState(e,h.current,i);this.rowStyleFormatter.format(e)}b=c.getCell(g,k);if(b){b=a(b);f=c._changeCellRenderState(b,h.current,i);this.cellStyleFormatter.format(b,g,d.column(),e,f)}}},_beginEditInternal:function(d){if(this._canInteract()&&this.options.allowEditing){var c=this.currentCell().column(),b;if(c&&!c.readOnly){b=(new a.wijmo.wijgrid.cellEditorHelper).currentCellEditStart(this,d);b;return b}}return false},_endEditInternal:function(c){if(this._canInteract()&&this.options.allowEditing){var b=(new a.wijmo.wijgrid.cellEditorHelper).currentCellEditEnd(this,c);b&&!this._allowVirtualScrolling()&&this._view().ensureHeight(this.currentCell().rowIndex());return b}return false},_onViewInsertEmptyRow:function(){return null},_onViewCreateEmptyCell:function(){return null},_onViewCellRendered:function(){},_onViewRowRendered:function(){},_ensureDataParser:function(b){switch(b.dataType){case undefined:case"string":if(!b.dataParser)b.dataParser=a.wijmo.wijgrid.embeddedParsers.stringParser;break;case"boolean":if(!b.dataParser)b.dataParser=a.wijmo.wijgrid.embeddedParsers.boolParser;break;case"number":if(!b.dataParser)b.dataParser=a.wijmo.wijgrid.embeddedParsers.numberParser;break;case"currency":if(!b.dataParser)b.dataParser=a.wijmo.wijgrid.embeddedParsers.currencyParser;break;case"datetime":if(!b.dataParser)b.dataParser=a.wijmo.wijgrid.embeddedParsers.dateTimeParser;break;default:throw a.wijmo.wijgrid.stringFormat('Unsupported dataType value: "{0}"',b.dataType);}},_parseDOM:function(a,b){return a.dataParser.parseDOM(b,this._field("closestCulture"),a.dataFormatString,this.options.nullString,true)},_parse:function(b,c){var a=b.dataParser.parse(c,this._field("closestCulture"),b.dataFormatString,this.options.nullString,true);switch(b.dataType){case"datetime":if(a!==null&&!(a instanceof Date))throw"invalid value.";break;case"number":case"currency":if(a!==null&&(typeof a!=="number"||isNaN(a)))throw"invalid value.";break;case"boolean":if(a!==null&&(typeof a!=="boolean"||isNaN(a)))throw"invalid value.";break;case"string":if(a!==null&&typeof a!=="string")throw"invalid value.";}return a},_toStr:function(a,b){return a.dataParser.toStr(b,this._field("closestCulture"),a.dataFormatString,this.options.nullString,true)},_funcOptions:function(){return["cellStyleFormatter","rowStyleFormatter","afterCellEdit","afterCellUpdate","beforeCellEdit","beforeCellUpdate","columnDragging","columnDragged","columnDropping","columnDropped","columnResizing","columnResized","columnGrouping","columnGrouped","columnUngrouping","columnUngrouped","currentCellChanging","currentCellChanged","filtering","filtered","filterOperatorsListShowing","groupAggregate","groupText","invalidCellValue","pageIndexChanging","pageIndexChanged","selectionChanged","sorting","sorted","ajaxError","dataLoading","dataLoaded","loading","loaded","rendering","rendered"]},_canInteract:function(){return!this.options.disabled},_canMoveToAnotherCell:function(d,c){var h=d.tagName.toLowerCase(),f,e,b,g;switch(h){case"input":if(a(d).hasClass("wijgridinput")){if(d.type==="text"){f=d.value.length;e=new a.wijmo.wijgrid.domSelection(d).getSelection();b=a.ui.keyCode;g=c===b.UP||c===b.DOWN||c===b.PAGE_DOWN||c===b.PAGE_UP||e.length===0&&(e.start===0&&(c===b.LEFT||c===b.HOME)||e.end>=f&&(c===b.RIGHT||c===b.END));return g}return true}return false;case"textarea":case"select":return false}return true},_getDataToAbsOffset:function(){var c=0,a=0,b=this._headerRows();if(this.options.showRowHeader)c++;if(b)a+=b.length();if(this._filterRow())a++;return{x:c,y:a}},_getDataCellsRange:function(){var d=0,e=0,b=this._field("visibleLeaves").length-1,c=this._rendered?this._rows().length()-1:this.sketchTable.length-1;if(this.options.showRowHeader)b--;if(b<0||c<0)d=e=b=c=-1;return new a.wijmo.wijgrid.cellInfoRange(new a.wijmo.wijgrid.cellInfo(d,e),new a.wijmo.wijgrid.cellInfo(b,c))},_getDataItem:function(a){return this.data()[a]},_getFirstDataRowCell:function(f){var b,e,c,g=this._view(),d=this._rows(),h=a.wijmo.wijgrid.rowType;for(b=0,e=d.length();b<e;b++){c=g._getRowInfo(d.item(b));if(c.type&h.data)return new a.wijmo.wijgrid.cellInfo(f,b)}return a.wijmo.wijgrid.cellInfo.prototype.outsideValue},_getNextCurrencyPos:function(b,f,h,g){var d=f.cellIndex(),c=f.rowIndex(),e;switch(h){case a.ui.keyCode.PAGE_UP:if(this._reverseKey&&c===b.topLeft().rowIndex())c=b.bottomRight().rowIndex();else{c-=this._pageSizeKey;if(c<(e=b.topLeft().rowIndex()))c=e}break;case a.ui.keyCode.PAGE_DOWN:if(this._reverseKey&&c===b.bottomRight().rowIndex())c=b.TopLeft().RowIndex();else{c+=this._pageSizeKey;if(c>(e=b.bottomRight().rowIndex()))c=e}break;case a.ui.keyCode.END:d=this._reverseKey&&d===b.bottomRight().cellIndex()?b.topLeft().cellIndex():b.bottomRight().cellIndex();break;case a.ui.keyCode.HOME:d=this._reverseKey&&d===b.topLeft().cellIndex()?b.bottomRight().cellIndex():b.topLeft().cellIndex();break;case a.ui.keyCode.LEFT:if(d>b.topLeft().cellIndex())d--;else if(this._reverseKey)d=b.bottomRight().cellIndex();break;case a.ui.keyCode.UP:if(c>b.topLeft().rowIndex())c--;else if(this._reverseKey)c=b.bottomRight().rowIndex();break;case a.ui.keyCode.RIGHT:if(d<b.bottomRight().cellIndex())d++;else if(this._reverseKey)d=b.topLeft().cellIndex();break;case a.ui.keyCode.ENTER:case a.ui.keyCode.DOWN:if(c<b.bottomRight().rowIndex())c++;else if(this._reverseKey)c=b.topLeft().rowIndex();break;case a.ui.keyCode.TAB:if(0)if(g){d--;if(d<b.topLeft().cellIndex()){d=b.bottomRight().cellIndex();c--;if(c<b.topLeft().rowIndex())c=b.bottomRight().rowIndex()}}else{d++;if(d>b.bottomRight().cellIndex()){d=b.topLeft().cellIndex();c++;if(c>b.bottomRight().rowIndex())c=b.topLeft().rowIndex()}}}return{cellIndex:d,rowIndex:c}},_getParentSubTable:function(b,g,h){for(var f=a.map(h,function(a){return a.element()}),c=null,d=null,e;b!==null&&c===null;b=b.parentNode){e=b.tagName?b.tagName.toLowerCase():undefined;if(a.inArray(e,g)>=0)d=b;else if(a.inArray(b,f)>=0)c=b}return d&&c?[d,c]:null},_getStaticIndex:function(c){var a,b=this._getDataCellsRange();if(this._hasSpannedCells())return-1;if(c)a=Math.min(this.options.staticRowIndex,b.bottomRight().rowIndex());else a=Math.min(this.options.staticColumnIndex,b.bottomRight().cellIndex());if(a<-1)a=-1;return a},_getRealStaticColumnIndex:function(g){var d,b,c=0,e=this._getStaticIndex(false),a,f;if(this.options.showRowHeader===true)c++;if(g)return c;a=e+c;if(e>=0){d=this._field("visibleLeaves");b=d.length;f=a;for(;a<b;a++)if(d[a].parentIdx===-1){if(a>f)a--;break}if(a>=b)a=b-1}return a},_getRealStaticRowIndex:function(b){var a=this._field("columnHeadersTable").length;if(this.options.showFilter)a++;return b?a:this._getStaticIndex(true)+a},_hasMerging:function(){var d=this._field("leaves"),a,e,c,b=false;for(a=0,e=d.length;a<e&&!b;a++){c=d[a];b|=c.parentVis&&c.rowMerge!=="none"}return b},_hasGrouping:function(){var d=this._field("leaves"),a,e,c,b=false;for(a=0,e=d.length;a<e&&!b;a++){c=d[a];b=c.groupInfo&&c.groupInfo.position!=="none"}return b},_hasSpannedCells:function(){return this._hasGrouping()||this._hasMerging()},_view:function(){return this._field("view")},_originalFooterRowData:function(){var a=this._field("tfoot");return a&&a.length?a[0]:null},_originalHeaderRowData:function(){var a=this._field("thead");return a&&a.length?a[0]:null},_totalRowsCount:function(){return this._dataStore.isDynamic()?this._dataStore.totalCount():this.sketchTable.length}})})(jQuery);(function(a){"use strict";a.widget("wijmo.c1basefield",{_data$prefix:"c1basefield",options:{allowMoving:true,allowSizing:true,cellFormatter:undefined,dataKey:undefined,ensurePxWidth:undefined,footerText:undefined,headerText:undefined,visible:true,width:undefined},_create:function(){var a=this.options.owner;this.element.addClass("ui-widget wijmo-c1basefield ui-state-default");this._field("owner",a);delete this.options.owner;this._field("widgetName",this.widgetName);this.options.disabled&&this.disable();a.options.allowColMoving&&a._dragndrop().attach(this)},_init:function(){this.element.wrapInner("<div class='wijmo-wijgrid-innercell'></div>");this._refreshHeaderCell()},destroy:function(){var b=this._owner();b&&b._dragndrop().detach(this);a.wijmo.wijgrid.remove$dataByPrefix(this.element,this._data$prefix);this.element.removeClass("ui-widget wijmo-c1basefield ui-state-default").html(this.element.find(".wijmo-wijgrid-headertext").contents())},_field:function(c,b){return a.wijmo.wijgrid.dataPrefix(this.element,this._data$prefix,c,b)},_removeField:function(b){var a=this._data$prefix+b;this.element.removeData(a)},_setOption:function(c,b,f){var h=this["_preset_"+c],e=this.options[c],g,d;if(h!==undefined)b=h.apply(this,[b,e,f]);g=b!==e;a.Widget.prototype._setOption.apply(this,[c,b]);if(g){d=this["_postset_"+c];d!==undefined&&d.apply(this,[b,e,f])}},_postset_allowMoving:function(b,c,a){this._invokeGroupedColumn("allowMoving",b,a)},_preset_clientType:function(){throw"read-only";},_postset_headerText:function(b,c,a){this._refreshHeaderCell();this._invokeGroupedColumn("headerText",b,a)},_postset_visible:function(){this._owner().ensureControl(false)},_postset_width:function(e){var c=this._owner()._view(),b=this.options.visLeavesIdx,d=a(c.getHeaderCell(b)).outerWidth();c.ensureWidth(b,e,d)},_invokeGroupedColumn:function(d,c,a){if(!a&&this.options.groupedIndex!==undefined){var b=this._owner()._field("groupedWidgets")[this.options.groupedIndex];b._setOption(d,c,true)}},_owner:function(){return this._field("owner")},_canSize:function(){return this.options.allowSizing&&this._owner().options.allowColSizing},_canDrag:function(){return this.options.allowMoving===true},_canDropTo:function(b){return a.wijmo.wijgrid.isChildOf(this._owner().options.columns,b,this)?false:true},_refreshHeaderCell:function(){var a=this.element.children(".wijmo-wijgrid-innercell").empty().html(this.options.headerText||"").wrapInner('<span class="wijmo-wijgrid-headertext" />')}})})(jQuery);(function(a){"use strict";a.widget("wijmo.c1field",a.wijmo.c1basefield,{options:{aggregate:"none",allowSort:true,dataType:"string",dataParser:undefined,dataFormatString:undefined,filterOperator:"nofilter",filterValue:undefined,groupInfo:{expandInfo:[],groupSingleRow:true,collapsedImageClass:"ui-icon-triangle-1-e",expandedImageClass:"ui-icon-triangle-1-se",position:"none",outlineMode:"startExpanded",headerText:undefined,footerText:undefined},readOnly:false,rowMerge:"none",showFilter:true,sortDirection:"none",valueRequired:false},_create:function(){a.wijmo.c1basefield.prototype._create.apply(this,arguments);this.element.addClass("ui-widget wijmo-c1field")},destroy:function(){this.element.find("*").unbind("."+this.widgetName);if(this.$filterEditor){this.$filterEditor.closest("td").find("*").unbind("."+this.widgetName);switch(this._getInputEditorType(this.options)){case"date":this.$filterEditor.data("wijinputdate")&&this.$filterEditor.wijinputdate("destroy");break;case"mask":this.$filterEditor.data("wijinputmask")&&this.$filterEditor.wijinputmask("destroy");break;case"numberCurrency":case"numberNumber":case"numberPercent":this.$filterEditor.data("wijinputnumber")&&this.$filterEditor.wijinputnumber("destroy")}this.$filterEditor=null}this.element.removeClass("ui-widget wijmo-c1field").find(".wijmo-wijgrid-headertext > span.ui-icon").remove();this._removeDropDownFilterList();a.wijmo.c1basefield.prototype.destroy.apply(this,arguments)},_init:function(){a.wijmo.c1basefield.prototype._init.apply(this,arguments);this.$filterEditor=null;var b=this._owner();this.filterRow=b._filterRow();b.options.showFilter&&this.options.showFilter&&this.options.dataIndex>=0&&this._prepareFilterCell()},_postset_aggregate:function(){this._owner().ensureControl(false)},_postset_allowSort:function(b,c,a){this._refreshHeaderCell();this._invokeGroupedColumn("allowSort",b,a)},_postset_dataType:function(){throw"read-only";},_postset_dataParser:function(){this._owner().ensureControl(false)},_postset_dataFormatString:function(){this._owner().ensureControl(false)},_postset_filterOperator:function(){this._owner().ensureControl(true)},_postset_filterValue:function(){this._owner().ensureControl(true)},_postset_groupInfo:function(){this._owner().ensureControl(true)},_postset_rowMerge:function(){this._owner().ensureControl(false)},_postset_showFilter:function(){this._owner().ensureControl(false)},_postset_sortDirection:function(){this.options.sortOrder=0;this._owner().ensureControl(true)},_postset_width:function(){this._setFilterEditorWidth(1);a.wijmo.c1basefield.prototype._postset_width.apply(this,arguments);this._setFilterEditorWidth(this._getFilterEditorWidth())},_canDropTo:function(b){return a.wijmo.c1basefield.prototype._canDropTo.apply(this,arguments)?this.options.groupedIndex!==undefined&&b instanceof a.wijmo.c1groupedfield?false:true:false},_canSort:function(){var a=this._owner();return a&&a.options.allowSorting&&this.options.allowSort&&this.options.dataIndex>=0},_refreshHeaderCell:function(){if(this._canSort()){var b,c=this.element.children(".wijmo-wijgrid-innercell").empty().html(this.options.headerText||"").wrapInner('<a class="wijmo-wijgrid-headertext" href="#" role="button" />');b=c.children("a").bind("click."+this.widgetName,this,this._onHrefClick);switch(this.options.sortDirection){case"ascending":b.append(a('<span class="ui-icon ui-icon-triangle-1-n">ascending</span>'));break;case"descending":b.append(a('<span class="ui-icon ui-icon-triangle-1-s">descending</span>'))}}else a.wijmo.c1basefield.prototype._refreshHeaderCell.apply(this,arguments)},_prepareFilterCell:function(){var g=this.options.visLeavesIdx,e=null,d=null,b,c,f=this,h;if(g>=0){e=this._owner();if(this.filterRow)d=a((new a.wijmo.wijgrid.rowAccessor).getCell(this.filterRow,g));else throw"exception";this.$filterEditor=d.find("input");d.bind(a.support.selectstart?"selectstart":"mousedown",function(a){a.stopPropagation()});b=e._parse(this.options,a.wijmo.wijgrid.filterHelper.getSingleValue(this.options.filterValue));if(b===null)switch(this.options.dataType){case"boolean":b=false;break;case"number":case"currency":case"datetime":b=0;break;default:b=""}c={culture:e.options.culture,disabled:e.options.disabled,decimalPlaces:function(b){var a=/^(n|p|c){1}(\d*)$/.exec(b);if(a)if(a[2])return parseInt(a[2],10);return 2}(this.options.dataFormatString)};switch(h=this._getInputEditorType(this.options)){case"date":this.$filterEditor.wijinputdate(a.extend(c,{date:b,dateFormat:this.options.dataFormatString||undefined}));break;case"mask":this.$filterEditor.wijinputmask({text:b+""});break;case"numberCurrency":this.$filterEditor.wijinputnumber(a.extend(c,{type:"currency",value:b}));break;case"numberNumber":this.$filterEditor.wijinputnumber(a.extend(c,{value:b}));break;case"numberPercent":this.$filterEditor.wijinputnumber(a.extend(c,{type:"percent",value:b*100}));break;default:throw a.wijmo.wijgrid.stringFormat('Unsupported editor type: "{0}"',h);}d.find(".wijmo-wijgrid-filter-trigger").attr({role:"button","aria-haspopup":"true"}).bind("mouseenter."+this.widgetName,function(){!f.options.disabled&&a(this).addClass("ui-state-hover")}).bind("mouseleave."+this.widgetName,function(){!f.options.disabled&&a(this).removeClass("ui-state-hover ui-state-active")}).bind("mouseup."+this.widgetName,this,function(){!f.options.disabled&&a(this).removeClass("ui-state-active")}).bind("mousedown."+this.widgetName,{column:this},this._onFilterBtnClick).bind("click."+this.widgetName,function(a){a.preventDefault()})}},_onFilterBtnClick:function(m){var b=m.data.column,j=8,c,k,g,d,f,i,e,h,l;if(b.options.disabled)return false;if(b.$dropDownFilterList){b._removeDropDownFilterList();return false}m.target.focus();c=b._owner();k=a.wijmo.wijgrid.filterHelper.getSingleOperatorName(b.options.filterOperator).toLowerCase();g=c.filterOperatorsCache.getByDataType(b.options.dataType);c.filterOperatorsCache.sort(g,c.options.filterOperatorsSortMode);d=a.extend(true,{},{operators:g,column:b.options});c._trigger("filterOperatorsListShowing",null,d);f=[];if(d.operators)for(i in d.operators)if(d.operators.hasOwnProperty(i)){e=d.operators[i];f.push({label:e.displayName||e.name,value:e.name,selected:e.name.toLowerCase()===k})}b.$dropDownFilterList=a('<div class="wijmo-wijgrid-filterlist"></div').appendTo(document.body).wijlist({autoSize:true,maxItemsCount:j,selected:function(f,e){var a,d;switch(d=b._getInputEditorType(b.options)){case"date":a=b.$filterEditor.wijinputdate("option","date")||new Date;break;case"mask":a=b.$filterEditor.wijinputmask("option","text");break;case"numberCurrency":case"numberNumber":case"numberPercent":a=b.$filterEditor.wijinputnumber("option","value");if(d==="numberPercent")a/=100}b._removeDropDownFilterList();c._handleFilter(b,e.item.value,a)}});b.$dropDownFilterList.wijlist("setItems",f).wijlist("renderList");h=b.$dropDownFilterList.width()|150;b.$dropDownFilterList.width(f.length>j?h+20:h).wijlist("refreshSuperPanel").position({of:a(this),my:"left top",at:"left bottom"});b.$dropDownFilterList.$button=a(this);l=b.$dropDownFilterList.eventGuid=+new Date;a(document).bind("mousedown."+b.widgetName+"."+l,{column:b},b._onDocMouseDown)},_onDocMouseDown:function(c){var b=a(c.target),e=b.parents(".wijmo-wijgrid-filterlist:first"),d=b.is(".wijmo-wijgrid-filter-trigger")?b:b.parents(".wijmo-wijgrid-filter-trigger:first");!(d.length&&d[0]===c.data.column.$dropDownFilterList.$button[0]||e.length&&e[0]===c.data.column.$dropDownFilterList[0])&&c.data.column._removeDropDownFilterList()},_onHrefClick:function(a){if(a.data.options.disabled)return false;a.data.options.allowSort&&a.data._owner()._handleSort(a.data.options,a.ctrlKey);return false},_removeDropDownFilterList:function(){if(this.$dropDownFilterList){var b=this.$dropDownFilterList.eventGuid;this.$dropDownFilterList.remove();this.$dropDownFilterList=null;a(document).unbind("mousedown."+this.widgetName+"."+b,this._onDocMouseDown)}},_getFilterEditorWidth:function(){if(this.$filterEditor){var b=this.$filterEditor.closest(".wijmo-wijgrid-filter"),a=b.width()-b.find(".wijmo-wijgrid-filter-trigger").width();if(!a||a<0)a=0;return a}return undefined},_setFilterEditorWidth:function(a){if(this.$filterEditor){a-=this.$filterEditor.leftBorderWidth()+this.$filterEditor.rightBorderWidth();if(a<0)a=0;switch(this._getInputEditorType(this.options)){case"date":this.$filterEditor.wijinputdate("widget").width(a);break;case"mask":this.$filterEditor.wijinputmask("widget").width(a);break;case"numberCurrency":case"numberNumber":case"numberPercent":this.$filterEditor.wijinputnumber("widget").width(a)}this.$filterEditor.setOutWidth(a)}},_getInputEditorType:function(a){switch(a.dataType){case"number":return a.dataFormatString&&a.dataFormatString.indexOf("p")===0?"numberPercent":"numberNumber";case"currency":return"numberCurrency";case"datetime":return"date";default:return"mask"}}})})(jQuery);(function(a){"use strict";a.widget("wijmo.c1groupedfield",{_data$prefix:"c1groupedfield",options:{allowMoving:true,allowSort:true,headerText:undefined,sortDirection:"none"},_create:function(){var a=this.options.owner;this.element.addClass("wijmo-wijgrid-group-button ui-state-default ui-corner-all");this._field("owner",a);delete this.options.owner;this.options.disabled&&this.disable();a.options.allowColMoving&&a._dragndrop().attach(this)},_init:function(){this._refreshHeaderCell()},destroy:function(){this.element.find("*").unbind("."+this.widgetName);var b=this._owner();b&&b._dragndrop().detach(this);a.wijmo.wijgrid.remove$dataByPrefix(this.element,this._data$prefix)},_field:function(c,b){return a.wijmo.wijgrid.dataPrefix(this.element,this._data$prefix,c,b)},_removeField:function(b){var a=this._data$prefix+b;this.element.removeData(a)},_setOption:function(c,b,f){var h=this["_preset_"+c],e=this.options[c],g,d;if(h!==undefined)b=h.apply(this,[b,e,f]);g=b!==e;a.Widget.prototype._setOption.apply(this,[c,b]);if(g){d=this["_postset_"+c];d!==undefined&&d.apply(this,[b,e,f])}},_postset_headerText:function(){this._refreshHeaderCell()},_postset_allowSort:function(){this._refreshHeaderCell()},_owner:function(){return this._field("owner")},_canSize:function(){return this.options.allowSizing&&this._owner().options.allowColSizing},_canDrag:function(){return this.options.allowMoving===true},_canDropTo:function(b){return!(b instanceof a.wijmo.c1groupedfield)?false:a.wijmo.wijgrid.isChildOf(this._owner().options.columns,b,this)?false:true},_canSort:function(){var a=this._owner();return a&&a.options.allowSorting&&this.options.allowSort&&this.options.dataIndex>=0},_refreshHeaderCell:function(){var b=a('<span class="wijmo-wijgrid-group-button-close ui-state-default ui-corner-all"><span class="ui-icon ui-icon-close"></span></span>').bind("click."+this.widgetName,this,this._onCloseClick);this.element.html(this.options.headerText||"").prepend(b).bind("click."+this.widgetName,this,this._onHrefClick);if(this._canSort())switch(this.options.sortDirection){case"ascending":this.element.append(a('<span class="wijmo-wijgrid-group-button-sort ui-icon ui-icon-triangle-1-n"></span>'));break;case"descending":this.element.append(a('<span class="wijmo-wijgrid-group-button-sort ui-icon ui-icon-triangle-1-s"></span>'))}},_onCloseClick:function(a){var b=a.data.options;!b.disabled&&a.data._owner()._handleUngroup(a.data.options.travIdx);return false},_onHrefClick:function(e){var d=e.data._owner(),c=e.data.options,b;if(!c.disabled&&c.allowSort){b=a.wijmo.wijgrid.search(d.columns(),function(a){return a.options.travIdx===c.travIdx});b=!b.found?a.wijmo.wijgrid.getColumnByTravIdx(d.options.columns,c.travIdx).found:b.found.options;b&&d._handleSort(b,e.ctrlKey)}return false}})})(jQuery);(function(a){"use strict";a.widget("wijmo.c1band",a.wijmo.c1basefield,{options:{columns:[]},_create:function(){a.wijmo.c1basefield.prototype._create.apply(this,arguments);this.element.addClass("ui-widget wijmo-c1band")},_canDropTo:function(b){return a.wijmo.c1basefield.prototype._canDropTo.apply(this,arguments)?!(b instanceof a.wijmo.c1groupedfield):false}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{bandProcessor:function(){var c,h,b,g,e,f,d;this.generateSpanTable=function(j,i){c=h=f=e=0;b=[];g=[];d=[];var a=this._generateSpanTable(j,i,true);return a};this._generateSpanTable=function(i,e,j){var d,f;c=this._getVisibleHeight(i,j);e=e||[];a.wijmo.wijgrid.traverse(i,function(a){a.isLeaf&&e.push(a);g.push(a)});h=e.length;for(d=0;d<c;d++){b[d]=[];for(f=0;f<h;f++)b[d][f]={column:null,colSpan:0,rowSpan:0}}this._setTableValues(i,0,0);return b};this._getVisibleHeight=function(b,g){var d,e,h,f,c=0;if(a.isArray(b))for(d=0,e=b.length;d<e;d++){f=this._getVisibleHeight(b[d],g);c=Math.max(c,f)}else{h=b.visible===undefined?true:b.visible;b.parentVis=h&&g;if(b.isBand){for(d=0,e=b.columns.length;d<e;d++){f=this._getVisibleHeight(b.columns[d],b.parentVis);c=Math.max(c,f)}if(!b.parentVis)return c;b.isLeaf=c===0;c++}else{b.isLeaf=true;if(b.parentVis)c=1}}return c};this._getVisibleParent=function(a){while(a){a=g[a.parentIdx];if(a&&(a.parentVis||a.parentVis===undefined))return a}return null};this._setTableValues=function(g,h,n){var i,l,m,j,o,k;if(a.isArray(g))for(i=0,l=g.length;i<l;i++)this._setTableValues(g[i],h,n);else{if(g.travIdx===undefined)throw"undefined travIdx";m=n+e;if(g.parentVis){j=m+f;b[h][j].column=g;d[g.travIdx]=j}if(g.isBand)for(i=0,l=g.columns.length;i<l;i++)this._setTableValues(g.columns[i],h+1,n);if(g.parentVis)if(e-m===0){b[h][d[g.travIdx]].rowSpan=c-h;e++}else b[h][d[g.travIdx]].colSpan=e-m;else if(!g.isBand&&c>0){k=this._getVisibleParent(g);o=k?k.isLeaf:false;if(o)f++;if(h>=c)h=c-1;j=n+e+f;b[h][j].column=g;if(!o){k&&d[k.travIdx]===j&&this._shiftTableElements(j,h);f++}}}};this._shiftTableElements=function(c,e){for(var a=0;a<e;a++){b[a][c+1]=b[a][c];b[a][c]={column:null,colSpan:0,rowSpan:0};if(b[a][c+1].column)d[b[a][c+1].column.travIdx]++}}},getAllLeaves:function(b){var a=[];this._getAllLeaves(b,a);return a},_getAllLeaves:function(d,e){var c,f,a,b;if(d)for(c=0,f=d.length;c<f;c++){a=d[c];if(a.options)a=a.options;b=a.columns;if(b&&b.length)this._getAllLeaves(b,e);else e.push(a)}},getColumnByTravIdx:function(b,d){var c,f,a,e=null;if(b&&d>=0)for(c=0,f=b.length;c<f&&!e;c++){a=b[c];if(a.options)a=a.options;if(a.travIdx===d)return{found:a,at:b};if(a.columns)e=this.getColumnByTravIdx(a.columns,d)}return e},isChildOf:function(d,a,b){if(a.options)a=a.options;if(b.options)b=b.options;if(b.isBand&&a.parentIdx>=0){if(a.parentIdx===b.travIdx)return true;if(a.parentIdx>b.travIdx)for(var c=this.flatten(d);;){a=c[a.parentIdx];if(a.travIdx===b.travIdx)return true;if(a.parentIdx===-1)break}}return false},getLeaves:function(b){var a=[];this._getLeaves(b,a);return a},_getLeaves:function(c,d){var b,e,a;if(c)for(b=0,e=c.length;b<e;b++){a=c[b];a.isLeaf&&d.push(a);a.columns&&this._getLeaves(a.columns,d)}},setTraverseIndex:function(a){return this._setTraverseIndex(a,0,-1)},_setTraverseIndex:function(d,b,f){var c,e,a;if(d)for(c=0,e=d.length;c<e;c++){a=d[c];if(a.options)a=a.options;a.linearIdx=c;a.travIdx=b++;a.parentIdx=f;if(a.columns)b=this._setTraverseIndex(a.columns,b,b-1)}return b},flatten:function(b){var a=[];this.traverse(b,function(b){a.push(b)});return a},traverse:function(c,e){var d,f,b;if(c&&a.isFunction(e))for(d=0;d<c.length;d++){b=c[d];if(b.options)b=b.options;f=c.length;e(b,c);if(c.length!==f){d--;continue}b.columns&&this.traverse(b.columns,e)}},getAriaHeaders:function(e,h){var b,g,c,d,f=[];for(b=0,g=e.length;b<g;b++){c=e[b];d="";do d+=escape(c.headerText)+" ";while(c=h[c.parentIdx]);f[b]=a.trim(d)}return f}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{getTableSection:function(a,b){if(a&&!a.nodeType)a=a[0];if(a)switch(b){case 1:return a.tHead;case 2:if(a.tBodies)return a.tBodies[0]||null;break;case 3:return a.tFoot;default:return a}return null},getTableSectionLength:function(a,b){if(a&&!a.nodeType)a=a[0];return a&&(b=this.getTableSection(a,b))?b.rows.length:0},getTableSectionRow:function(a,b,c){if(a&&!a.nodeType)a=a[0];return a&&(b=this.getTableSection(a,b))?b.rows[c]||null:null},readTableSection:function(c,g,h){var f,k,b,i,e,d,j=[],l=function(a){a=a.toLowerCase();return a==="rowspan"||a==="colspan"};if(c&&!c.nodeType)c=c[0];if(c&&(g=this.getTableSection(c,g)))for(f=0,k=g.rows.length;f<k;f++){e=g.rows[f];d=[];if(h){d.rowAttributes=a.wijmo.wijgrid.getAttributes(e);d.cellsAttributes=[]}for(b=0,i=e.cells.length;b<i;b++){d[b]=a.trim(e.cells[b].innerHTML);if(h)d.cellsAttributes[b]=a.wijmo.wijgrid.getAttributes(e.cells[b],l)}j[f]=d}return j}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{dataMode:{dom:1,statical:2,remoteStatical:4,dynamical:8},dataStore:function(c){var b=null,s=this,n=false,q=false,e=null,d=null,i,r=false,p=false,t=null,h=null,j=null,f=null;this.dataMode=function(){return m()};this.dispose=function(){if(b){b.reader=t;b.loading=h;b.loaded=j;if(b.proxy)b.proxy.options.error=f;q=true}};this.dataSource=function(){return b};this.getFieldNames=function(){g();var d=[],e,c;if(b.items&&b.items.length)c=b.items[0];else if(m()===a.wijmo.wijgrid.dataMode.dom&&b.header&&b.header.length)c=b.header[0];c&&a.each(c,function(a){d.push(!isNaN(a)?parseInt(a,10):a)});return d};this.wrapDataItem=function(b,f,e){var c,d={};if(e)if(b.rowAttributes||b.cellsAttributes){c={rowAttributes:b.rowAttributes,cellsAttributes:b.cellsAttributes};delete b.rowAttributes;delete b.cellsAttributes}else a.each(b,function(f,e){if(a.isArray(e)){d[f]=e[1];b[f]=e[0]}c={rowAttributes:{},cellsAttributes:d}});return{values:b,originalRowIndex:f,attributes:c}};this.getDataSlice=function(){g();if(!r){r=true;x(e)}if(!p){p=true;if(!this.isDynamic())i=y(e,b.emptyData);else i={data:e,totalRows:b.data.totalRows,totals:b.data.totals||{},emptyData:b.emptyData}}return i};this.load=function(e){if(!b)b=a.proxy(v,this)(c);if(this.isDynamic()&&c._customPagingEnabled())throw"Dynamic wijdatasource and custom paging cannot be used at the same time";if(this.isDynamic()&&c.options.allowVirtualScrolling)throw"Dynamic wijdatasource and virtual scrolling can not be used at the same time.";if(this.isDynamic()){e.data=w();if(b.proxy)b.proxy.options.data=a.extend(b.proxy.options.data,e.data);d=null;b.load(e,true)}else if(!n){d=null;b.load(e)}else{k(b,e);l(b,e)}};this.isLoaded=function(){return n};this.isDynamic=function(){return m()===a.wijmo.wijgrid.dataMode.dynamical};this.totalCount=function(){g();return this.isDynamic()?b.data?b.data.totalRows||0:0:b.items?b.items.length:0};this.updateValue=function(a,c,b){g();this.dataSource().items[a][c]=b};function v(d){var b=null,c=d.options.data;if(c===null)b=new wijdatasource({data:d.element,reader:new o(new u),loading:a.proxy(k,this),loaded:a.proxy(l,this)});else if(a.isArray(c))b=new wijdatasource({data:c,reader:new o(new wijarrayreader),loading:a.proxy(k,this),loaded:a.proxy(l,this)});else{b=c;t=b.reader;b.reader=new o(b.reader);h=b.loading;b.loading=a.proxy(function(){a.isFunction(h)&&h.apply(this,arguments);k.apply(this,arguments)},this);j=b.loaded;b.loaded=a.proxy(function(){a.isFunction(j)&&j.apply(this,arguments);l.apply(this,arguments)},this);if(b.proxy&&b.proxy.options){f=b.proxy.options.error;b.proxy.options.error=function(){z.apply(this,arguments);a.isFunction(f)&&f.apply(this,arguments)}}}return b}function k(b,a){if(q)return;if(s.isDynamic()||c.options.alwaysParseData)r=false;p=false;i=null;e=null;c._dataLoading(a)}function l(f,g){if(q)return;n=true;var b=!d&&c.options.readAttributesFromData;if(!d)d=[];e=[];a.each(f.items,function(c,f){var a=s.wrapDataItem(f,c,b);if(b)d.push(a.attributes);else a.attributes=d[c];e.push(a)});c._dataLoaded(g)}function g(){if(!n)throw"data is not loaded yet";}function z(){c._ajaxError.apply(c,arguments)}function m(){return!b.data||b.data.jquery?a.wijmo.wijgrid.dataMode.dom:b.dynamic===true?a.wijmo.wijgrid.dataMode.dynamical:a.wijmo.wijgrid.dataMode.statical}function x(d){if(d&&d.length){var g=[],j,f,k,h,e,i,b;a.wijmo.wijgrid.traverse(c.options.columns,function(b){a.wijmo.wijgrid.validDataKey(b.dataKey)&&g.push(b)});j=Math.min(g.length,s.getFieldNames().length);for(f=0,k=d.length;f<k;f++){h=d[f];for(e=0;e<j;e++){i=null;b=g[e];if(b&&b.dataParser){i=c._parse(b,h.values[b.dataKey]);h.values[b.dataKey]=i}}}}}function y(b,h){if(b&&b.length){var d=c._prepareFilterRequest(true),f=c._preparePageRequest(true),g=c._prepareSortRequest(true),e=c._prepareTotalsRequest(true),i=(new a.wijmo.wijgrid.dataHelper).getDataSlice(c,b,d,f,g,e);return i}return{data:[],totalRows:c._customPagingEnabled()?c.options.totalRows:0,totals:{},emptyData:h}}function w(){return{filtering:c._prepareFilterRequest(false),paging:c._preparePageRequest(false),sorting:c._prepareSortRequest(false),totals:c._prepareTotalsRequest(false)}}function o(b){this.read=function(c){c.items=null;b&&a.isFunction(b.read)&&b.read(c);if(!a.isArray(c.items)){c.items=[];if(a.isArray(c.data))c.items=c.data;else if(c.data&&a.isArray(c.data.rows))c.items=c.data.rows}if(m()===a.wijmo.wijgrid.dataMode.dynamical)if(!c.data||isNaN(c.data.totalRows))throw"totalRows value is missing";if(!c.items||!a.isArray(c.items))c.items=[]}}function u(){this.read=function(b){b.items=[];if(b&&b.data&&b.data.length){if(a.wijmo.wijgrid.getTableSectionLength(b.data,2)===1&&a(a.wijmo.wijgrid.getTableSectionRow(b.data,2,0)).hasClass("wijmo-wijgrid-emptydatarow"))b.emptyData=a.wijmo.wijgrid.readTableSection(b.data,2);else b.items=a.wijmo.wijgrid.readTableSection(b.data,2,c.options.readAttributesFromData);b.header=a.wijmo.wijgrid.readTableSection(b.data,1);b.data=null}else throw"invalid data source";}}},dataHelper:function(){this.getDataSlice=function(g,e,q,f,s,r){var j=g._customPagingEnabled(),m,h,p,l,i,n,t,k,o={};if(!j)e=b(e,q,g);!j&&a.proxy(c,this)(e,s);m=g._customPagingEnabled()?g.options.totalRows:e.length;o=d(e,r,g);if(f&&!j){k=Math.ceil(m/f.pageSize)||1;if(f.pageIndex>=k)f.pageIndex=k-1;h=Math.min(e.length-1,f.pageIndex*f.pageSize);if(h<0)h=0;p=Math.min(e.length,h+f.pageSize);l=[];for(i=h,t=0,n=0;i<p;i++,n++)l[n]=e[i];e=l}return{data:e,totalRows:m,totals:o}};function d(i,f){var b,c,e,j,g,d=[],h={};for(b=0,c=f.length;b<c;b++)d.push(new a.wijmo.wijgrid.tally);for(b=0,c=i.length;b<c;b++){g=i[b].values;for(e=0,j=d.length;e<j;e++)d[e].add(g[f[e].column.dataKey])}for(b=0,c=d.length;b<c;b++)h[f[b].column.dataKey]=d[b].getValueString(f[b].column);return h}function b(e,c,l){if(!e||!e.length||!c||!c.length)return e;a.each(c,function(c,b){if(!a.isArray(b.filterOperator))b.filterOperator=[b.filterOperator];if(!a.isArray(b.filterValue))b.filterValue=[b.filterValue];a.each(b.filterOperator,function(c,a){if(typeof a==="string")b.filterOperator[c]=a={name:a,condition:"or"};b.filterOperator[c].name=l.filterOperatorsCache.getByName(a.name)});a.each(b.filterValue,function(d,c){if(!a.isArray(c))b.filterValue[d]=l._parse(b.column,c);else a.each(c,function(d,a){c[d]=l._parse(b.column,a)})})});var h,i,b,o,m,j,p=[],n,g,q=c.length,d,f,k;for(h=0,o=e.length;h<o;h++){m=e[h];n=true;for(i=0;i<q;i++){d=c[i];j=m.values[d.column.dataKey];g=false;for(b=0;b<d.filterOperator.length;b++){f=d.filterOperator[b];k=d.filterValue[b];if(b>0&&f.condition==="and")g&=f.name.operator(j,k);else g|=f.name.operator(j,k)}n&=g}n&&p.push(m)}return p}function c(i,e){if(e.length){var b=[],d,h,c,a,f,g;b.push("var context = this;");b.push("this.sort = function(a, b)\n{\n");for(d=0,h=e.length;d<h;d++){c="arg"+d;a=e[d];f=typeof a.dataKey==="string"?'"'+a.dataKey+'"':a.dataKey;if(a.sortDirection==="ascending"||a.sortDirection==="descending")if(a.sortDirection==="ascending")b.push("var ",c," = context._sortAsc","(a.values[",f,"], b.values[",f,"]);\n");else b.push("var ",c," = context._sortDesc","(a.values[",f,"], b.values[",f,"]);\n");else b.push("var ",c," = context._sortDigitAsc","(a.originalRowIndex, b.originalRowIndex);\n");b.push("if (",c," === 0)\n");b.push("{\n")}g=e.length-1;if(g>=0){c="arg"+g;a=e[g];f=typeof a.dataKey==="string"?'"'+a.dataKey+'"':a.dataKey;if(a.sortDirection==="ascending"||a.sortDirection==="descending")if(a.sortDirection==="ascending")b.push("var ",c," = context._sortDigitAsc","(a.originalRowIndex, b.originalRowIndex);\n");else b.push("var ",c," = context._sortDigitDesc","(a.originalRowIndex, b.originalRowIndex);\n")}for(d=e.length-1;d>=0;d--){b.push("}\n");c="arg"+d;b.push("return ",c,";\n")}b.push("}");eval(b.join(""));i.sort(this.sort)}}this._sortAsc=function(a,b){if(a instanceof Date)a=a.getTime();if(b instanceof Date)b=b.getTime();return a===b?0:a===null?-1:b===null?1:a<b?-1:1};this._sortDesc=function(a,b){if(a instanceof Date)a=a.getTime();if(b instanceof Date)b=b.getTime();return a===b?0:a===null?1:b===null?-1:a<b?1:-1};this._sortDigitAsc=function(a,b){return a-b};this._sortDigitDesc=function(a,b){return b-a}}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{groupRange:function(f,h,i,g,e){this.value=-1;this.isExpanded=false;this.cr=new a.wijmo.wijgrid.cellRange(-1,-1);this.sum=-1;this.position="none";this.hasHeaderOrFooter=true;if(f!==undefined)this.isExpanded=f;if(h!==undefined)this.cr=h;if(i!==undefined)this.sum=i;if(g!==undefined)this.position=g;if(e!==undefined)this.hasHeaderOrFooter=e;this.isSubRange=function(a){return this.cr.r1>=a.cr.r1&&this.cr.r2<=a.cr.r2};this.toString=function(){return this.cr.r1+"-"+this.cr.r2};this._getHeaderImageClass=function(c){var b=this.owner;return b?c?b.expandedImageClass||a.wijmo.c1field.prototype.options.groupInfo.expandedImageClass:b.collapsedImageClass||a.wijmo.c1field.prototype.options.groupInfo.collapsedImageClass:null};this.collapse=function(){var b,g,e,c,d,f;if((b=this.owner)&&(g=b.owner)&&(e=g.owner)){c=new a.wijmo.wijgrid.groupHelper;d=e._field("leaves");if(c.isParentExpanded(d,this.cr,b.level))if(b.position!=="footer"&&b.outlineMode!=="none"){f=c.getGroupedColumnsCount(d);j(c,e._rows(),d,this,f,e._field("viewRenderBounds").start)}}};this.expand=function(i){var f,h,e,b,c,g;if((f=this.owner)&&(h=f.owner)&&(e=h.owner)){b=new a.wijmo.wijgrid.groupHelper;c=e._field("leaves");if(b.isParentExpanded(c,this.cr,f.level)){g=b.getGroupedColumnsCount(c);d(b,e._rows(),c,this,g,i,true,e._field("viewRenderBounds").start)}}};function j(n,f,p,d,m,e){var k=d.owner,j=d.cr.r1,o=d.cr.r2,a,l,i,g,h;switch(k.position){case"header":case"headerAndFooter":b(f.item(d.cr.r1-e),undefined,false);j++}for(a=j;a<=o;a++)b(f.item(a-e),false);d.isExpanded=false;c(f,d,e);for(a=k.level+1;a<=m;a++){i=n.getChildGroupRanges(p,d.cr,a-1);for(h=0,l=i.length;h<l;h++){g=i[h];g.isExpanded=false;switch(g.owner.position){case"header":case"headerAndFooter":b(f.item(g.cr.r1-e),undefined,false)}c(f,g,e)}}}function d(p,f,q,h,o,l,m,e){var s=h.owner,i=h.cr.r1,k=h.cr.r2,a,n,g,j,r;switch(s.position){case"header":b(f.item(i-e),true,m||l);i++;break;case"footer":b(f.item(k-e),true);k--;break;case"headerAndFooter":b(f.item(i-e),true,m||l);m&&b(f.item(k-e),true);i++;k--}if(m){h.isExpanded=true;c(f,h,e)}else return;if(h.owner.level===o)for(a=i;a<=k;a++)b(f.item(a-e),true);else{g=p.getChildGroupRanges(q,h.cr,h.owner.level);if(g.length&&i!==g[0].cr.r1)for(a=i;a<g[0].cr.r1;a++)b(f.item(a-e),true);if(l)for(a=0,n=g.length;a<n;a++){j=g[a];d(p,f,q,j,o,l,true,e)}else for(a=0,n=g.length;a<n;a++){j=g[a];r=j.owner.position==="footer"||j.owner.outlineMode==="none"?true:false;d(p,f,q,j,o,false,r,e)}}}function b(a,b,c){if(a){if(a[0]){if(b!==undefined){a[0].style.display=b?"":"none";a[0]["aria-hidden"]=b?"false":"true"}if(c!==undefined)a[0]["aria-expanded"]=c?"true":false}if(a[1]){if(b!==undefined){a[1].style.display=b?"":"none";a[1]["aria-hidden"]=b?"false":"true"}if(c!==undefined)a[1]["aria-expanded"]=c?"true":false}}}function c(f,b,e){if(b.owner.position!=="footer"){var c=null,d=f.item(b.cr.r1-e);if(d)if(d[0])c=a(d[0]).find("div.wijmo-wijgrid-grouptogglebtn:first-child");if(c&&c.length){c.toggleClass(b._getHeaderImageClass(!b.isExpanded),false);c.toggleClass(b._getHeaderImageClass(b.isExpanded),true)}}}},grouper:function(){this.group=function(i,k,e){this._grid=i;this._data=k;this._leaves=e;this._groupRowIdx=0;this._groupHelper=new a.wijmo.wijgrid.groupHelper;var h=1,c,f,b,d=[],g=false,j=0;for(c=0,f=e.length;c<f;c++){b=e[c];if(b.groupInfo){delete b.groupInfo.level;delete b.groupInfo.expandInfo}if(b.groupInfo&&b.groupInfo.position&&b.groupInfo.position!=="none"&&b.dataIndex>=0){if(b.groupedIndex===undefined)g=true}else if(b.groupedIndex!==undefined)delete b.groupedIndex}if(g)for(c=0,f=e.length;c<f;c++){b=e[c];if(b.groupInfo&&b.groupInfo.position&&b.groupInfo.position!=="none"&&b.dataIndex>=0){b.groupedIndex=j++;d.push(b)}}else{d=a.map(e,function(a){return a.groupedIndex!==undefined?a:null});d.sort(function(a,b){return a.groupedIndex-b.groupedIndex});a.each(d,function(a,b){b.groupedIndex=a})}i._field("groupedColumns",d);for(c=0,f=d.length;c<f;c++){b=d[c];this._groupRowIdx=0;if(b.groupInfo&&b.groupInfo.position&&b.groupInfo.position!=="none"&&b.dataIndex>=0){b.groupInfo.level=h;b.groupInfo.expandInfo=[];this._processRowGroup(b,h++)}}delete this._grid;delete this._data;delete this._leaves};this._processRowGroup=function(j,c){var k,b,i,o,m,d,h,e,g,f,n=0,l=true;a.each(this._leaves,function(b,a){if(a.parentVis){n=b;return false}});for(k=0;k<this._data.length;k++){if(!(this._data[k].rowType&a.wijmo.wijgrid.rowType.data))continue;b=this._getGroupCellRange(k,j,c);i=true;o=j.groupInfo.outlineMode==="startCollapsed";if(o||this._groupHelper.isParentCollapsed(this._leaves,b,c)){if(j.groupInfo.groupSingleRow===false&&b.r1===b.r2)continue;i=false}if(c&&this._grid.options.groupIndent)for(m=b.r1;m<=b.r2;m++)this._addIndent(this._data[m][n],c);l=!(j.groupInfo.groupSingleRow===false&&b.r1===b.r2);switch(j.groupInfo.position){case"header":d=this._addGroupRange(j.groupInfo,b,i,l);for(f=b.r1;f<=b.r2;f++){this._data[f].__attr["aria-level"]=c+1;if(!i){this._data[f].__style.display="none";this._data[f].__attr["aria-hidden"]=true}}if(!l)break;this._updateByGroupRange(d,c);h=this._groupHelper.isParentCollapsed(this._leaves,d.cr,c);e=this._buildGroupRow(d,b,true,h);this._data.splice(b.r1,0,e);e.__attr["arial-level"]=c;e.__attr["aria-expanded"]=i;if(h){e.__style.display="none";e.__attr["aria-hidden"]=true}k=b.r2+1;break;case"footer":d=this._addGroupRange(j.groupInfo,b,true,l);if(!l)break;this._updateByGroupRange(d,c);g=this._buildGroupRow(d,b,false,false);g.__attr["aria-level"]=c;this._data.splice(b.r2+1,0,g);k=b.r2+1;h=this._groupHelper.isParentCollapsed(this._leaves,d.cr,c);if(h){g.__style.display="none";g.__attr["aria-hidden"]=true}break;case"headerAndFooter":d=this._addGroupRange(j.groupInfo,b,i,l);for(f=b.r1;f<=b.r2;f++){this._data[f].__attr["aria-level"]=c+1;if(!i){this._data[f].__style.display="none";this._data[f].__attr["aria-hidden"]=true}}if(!l)break;this._updateByGroupRange(d,c);h=this._groupHelper.isParentCollapsed(this._leaves,d.cr,c);e=this._buildGroupRow(d,b,true,h);g=this._buildGroupRow(d,b,false,false);this._data.splice(b.r2+1,0,g);g.__attr["aria-level"]=c;if(h||!i){g.__style.display="none";g.__attr["aria-hidden"]=true}this._data.splice(b.r1,0,e);e.__attr["aria-level"]=c;e.__attr["aria-expanded"]=i;if(h){e.__style.display="none";e.__attr["aria-hidden"]=true}k=b.r2+2;break;default:throw a.wijmo.wijgrid.stringFormat('Unknown Position value: "{0}"',j.groupInfo.position);}this._groupRowIdx++}};this._buildGroupRow=function(n,l,f){var e=n.owner,c=e.owner,r=c.owner,h=[],j="",k="",d,g,b,p,q,i,o,m;h.__style={};h.__attr={};h.__attr.id=(f?"GH":"GF")+this._groupRowIdx+"-"+e.level;h.rowType=f?a.wijmo.wijgrid.rowType.groupHeader:a.wijmo.wijgrid.rowType.groupFooter;if(c.dataIndex>=0&&(d=this._data[l.r1][c.dataIndex].value)!==null)j=r._toStr(c,d);this._grid.options.showRowHeader&&h.push({html:"&nbsp;"});g={html:"",__attr:{},__style:{}};if(f&&e.outlineMode!=="none")if(n.isExpanded)g.html='<div class="ui-icon '+n._getHeaderImageClass(true)+' wijmo-wijgrid-grouptogglebtn">&nbsp;</div>';else g.html='<div class="ui-icon '+n._getHeaderImageClass(false)+' wijmo-wijgrid-grouptogglebtn">&nbsp;</div>';h.push(g);if(c.aggregate&&c.aggregate!=="none")k=this._getAggregate(l,c,c,f,j);b=f?e.headerText:e.footerText;if(b==="custom"){p={data:this._data,column:c,groupByColumn:e.owner,groupText:j,text:"",groupingStart:l.r1,groupingEnd:l.r2,isGroupHeader:f,aggregate:k};if(this._grid._trigger("groupText",null,p))b=p.text}else{if(b===undefined||b===null){if(f)b="{1}: {0}";if(k||k===0)b=b?b+" {2}":"{2}"}b=a.wijmo.wijgrid.stringFormat(b,j,c&&c.headerText?c.headerText:"",k.toString())}if(!b)b="&nbsp;";g.html+="<span>"+b+"</span>";this._addIndent(g,e.level-1);q=1;i=this._grid.options.showRowHeader?1:0;o=true;for(;i<this._leaves.length;i++){d=this._leaves[i];if(d.parentVis){if(o){o=false;continue}if(d.dynamic!==true&&d.aggregate&&d.aggregate!=="none")break;q++}}for(;i<this._leaves.length;i++){d=this._leaves[i];if(d.parentVis){m=this._getAggregate(l,d,e.owner,f,j);if(!m&&m!==0)m="&nbsp;";h.push({html:m.toString(),__attr:{groupInfo:{leafIndex:d.leavesIdx,purpose:a.wijmo.wijgrid.groupRowCellPurpose.aggregateCell}}})}}g.__attr.colSpan=q;g.__attr.groupInfo={leafIndex:c.leavesIdx,purpose:a.wijmo.wijgrid.groupRowCellPurpose.groupCell};return h};this._getAggregate=function(d,b,h,i,j){var c="",g,f,e;if(!b.aggregate||b.aggregate==="none")return c;if(b.aggregate==="custom"){g={data:this._data,column:b,groupByColumn:h,groupText:j,text:"",groupingStart:d.r1,groupingEnd:d.r2,isGroupHeader:i};if(this._grid._trigger("groupAggregate",null,g))c=g.text}else{f=new a.wijmo.wijgrid.tally;for(e=d.r1;e<=d.r2;e++)f.add(this._data[e][b.dataIndex].value);c=f.getValueString(b)}return c};this._getGroupCellRange=function(e,f,i){var j=f.leavesIdx,b=new a.wijmo.wijgrid.cellRange(e,j),g=this._groupHelper.getParentGroupRange(this._leaves,b,i),d,c,h;if(this._data[e].rowType&a.wijmo.wijgrid.rowType.data){d=this._data[e][f.dataIndex].value;if(d instanceof Date)d=d.getTime();for(b.r2=e,h=this._data.length-1;b.r2<h;b.r2++){if(!(this._data[b.r2+1].rowType&a.wijmo.wijgrid.rowType.data)||g&&b.r2+1>g.r2)break;c=this._data[b.r2+1][f.dataIndex].value;if(c instanceof Date)c=c.getTime();if(d!==c)break}}return b};this._addGroupRange=function(b,c,j,f){var d=null,g=this._groupHelper.getChildGroupIndex(c,b.expandInfo),i,h,k,e;if(g>=0&&g<b.expandInfo.length)d=b.expandInfo[g];else{i=new a.wijmo.wijgrid.cellRange(c.r1,c.r1,c.r2,c.r2);h=b.position==="footer"||!f?true:j&&b.outlineMode!=="startCollapsed";d=new a.wijmo.wijgrid.groupRange(h,i,-1,b.position,f);d.owner=b;b.expandInfo.push(d)}if(d&&f){k=c.r1;e=c.r2;if(b.position==="headerAndFooter")e+=2;if(b.position!=="headerAndFooter")e++;d.cr.r2=e}return d};this._updateByGroupRange=function(c,i){var d,h,b,g,e,a,f;for(d=0,h=this._leaves.length;d<h;d++){b=this._leaves[d].groupInfo;if(b&&b.level<i){g=b.expandInfo?b.expandInfo.length:0;for(e=0;e<g;e++){a=b.expandInfo[e];f=c.position==="headerAndFooter"?2:1;if(a.cr.r1>=c.cr.r1&&!(a.cr.r1===c.cr.r1&&a.position==="footer"))a.cr.r1+=f;if(a.cr.r2>=c.cr.r1)a.cr.r2+=f}}}};this._addIndent=function(c,b){var a;if(b>0&&(a=this._grid.options.groupIndent))c.__style.paddingLeft=a*b+"px"}}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{_getGroupInfoRegExp:/.*G([HF]){1}(\d+)-(\d+)$/,groupHelper:function(){this.getGroupInfo=function(d){if(d){var b=a.wijmo.wijgrid._getGroupInfoRegExp.exec(d.id),f,e,c;if(b){f=parseInt(b[3],10);e=parseInt(b[2],10);c=b[1]==="H";return{level:f,index:e,isHeader:c,toString:function(){return(this.isHeader?"GH":"GF")+this.index+"-"+this.level}}}}return null};this.getColumnByGroupLevel=function(c,e){var b,d,a;for(b=0,d=c.length;b<d;b++){a=c[b];if(a.groupInfo&&a.groupInfo.level===e)return a}return null};this.getGroupedColumnsCount=function(c){var d=0,b,e,a;for(b=0,e=c.length;b<e;b++){a=c[b].groupInfo;if(a&&(a.position==="header"||a.position==="headerAndFooter"||a.position==="footer"))d++}return d};this.getChildGroupIndex=function(f,e){var b=0,c=e.length-1,a,d;while(b<=c){a=(c-b>>1)+b;d=e[a].cr.r1-f.r1;if(d===0)return a;if(d<0)b=a+1;else c=a-1}return b};this.getParentGroupIndex=function(c,b){var a=this.getChildGroupIndex(c,b);if(a>0)a--;return a<b.length?a:-1};this.getChildGroupRanges=function(i,f,j){var g=[],a,c,b,h,e,d=this.getColumnByGroupLevel(i,j+1);if(d){a=d.groupInfo.expandInfo;e=this.getChildGroupIndex(f,a);for(b=e,h=a.length;b<h;b++){c=a[b];if(c.cr.r2<=f.r2)g.push(c);else break}}return g};this.getParentGroupRange=function(e,f,b){var c,a,d;if(b===undefined)b=65535;if(b-2>=0)for(c=e.length-1;c>=0;c--){a=e[c].groupInfo;if(!a||!a.expandInfo||a.level<0||a.level!==b-1)continue;d=this.getParentGroupIndex(f,a.expandInfo);if(d>=0)return a.expandInfo[d]}return null};this.isParentCollapsed=function(e,c,d){var b,a;if(d===1)return false;for(b=d;b>1;b--){a=this.getParentGroupRange(e,c,b);if(a&&!a.isExpanded)return true;c=a.cr}return false};this.isParentExpanded=function(e,c,d){var b,a;if(d===1)return true;for(b=d;b>1;b--){a=this.getParentGroupRange(e,c,b);if(a&&a.isExpanded)return true;c=a.cr}return false}}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{cellRange:function(b,a,d,c){switch(arguments.length){case 2:this.r1=this.r2=b;this.c1=this.c2=a;break;case 4:this.r1=b;this.r2=d;this.c1=a;this.c2=c;break;default:this.r1=0;this.r2=0;this.c1=0;this.c2=0}this.isSingleCell=function(){return this.r1===this.r2&&this.c1===this.c2}},merger:function(){this.merge=function(e,c){this.leaves=c;this.data=e;var b,d,a;for(b=0,d=c.length;b<d;b++){a=c[b];a.dataIndex>=0&&!a.isBand&&(a.rowMerge==="free"||a.rowMerge==="restricted")&&this.mergeColumn(a)}delete this.data;delete this.leaves};this.mergeColumn=function(f){var e=f.dataIndex,c,h,b,g,d;for(c=0,h=this.data.length;c<h;c++){if(!(this.data[c].rowType&a.wijmo.wijgrid.rowType.data))continue;b=this.getCellRange(c,f);if(b.r1!==b.r2){g=b.r2-b.r1+1;this.data[b.r1][e].__attr.rowSpan=g;for(d=b.r1+1;d<=b.r2;d++)this.data[d][e].visible=false}c=b.r2}};this.getCellRange=function(c,h){var d=h.dataIndex,b=new a.wijmo.wijgrid.cellRange(c,d),k=(this.data[c][d].value||"").toString(),j=this.data.length,e,g,f,i;for(b.r2=c;b.r2<j-1;b.r2++){e=this.data[b.r2+1];if(!(e.rowType&a.wijmo.wijgrid.rowType.data)||(e[d].value||"").toString()!==k)break}g=h.leavesIdx;if(g>0&&h.rowMerge==="restricted"){f=this.leaves[g-1];if(f.dataIndex>=0){i=this.getCellRange(c,f);b.r1=Math.max(b.r1,i.r1);b.r2=Math.min(b.r2,i.r2)}}return b}}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{rowType:{header:1,data:2,dataAlt:4,filter:8,groupHeader:16,groupFooter:32,footer:64,emptyDataRow:128,fooRow:65536},renderState:{none:0,rendering:1,current:2,hovered:4,selected:8},groupRowCellPurpose:{groupCell:0,aggregateCell:1},stringFormat:function(b){var a,c;if(!b)return"";for(a=1,c=arguments.length;a<c;a++)b=b.replace(new RegExp("\\{"+(a-1)+"\\}","gm"),arguments[a]);return b},validDataKey:function(a){return a&&!(a<0)||a===0},iterateChildrenWidgets:function(b,c){if(b&&c){if(b.nodeType)b=a(b);b.find(".ui-widget").each(function(b,d){a.each(a(d).data(),function(d,a){a.widgetName&&c(b,a)})})}},remove$dataByPrefix:function(c,d){var b=[];a.each(c.data(),function(a){a.indexOf(d)===0&&b.push(a)});a.each(b,function(b,a){c.removeData(a)})},domSelection:function(b){this.getSelection=function(){var a=0,c=0,d;if(b.selectionStart!==undefined){a=b.selectionStart;c=b.selectionEnd}else if(document.selection){d=document.selection.createRange().duplicate();c=d.text.length;a=Math.abs(d.moveStart("character",-b.value.length));c+=a}return{start:a,end:c,length:c-a}};this.setSelection=function(c){if(b.selectionStart!==undefined)b.setSelectionRange(c.start,c.end);else{var a=b.createTextRange();a.collapse(true);a.moveStart("character",c.start);a.moveEnd("character",c.end);a.select()}};this.toggleSelection=function(e){var c=a(b),d="onselectstart"in b;if(e)if(d)c.unbind(".wijgrid-disableSelection");else c.css({MozUserSelect:"",WebkitUserSelect:""});else if(d)c.bind("selectstart.wijgrid-disableSelection",function(a){a.preventDefault()});else c.css({MozUserSelect:"-moz-none",WebkitUserSelect:"none"})}},createDynamicField:function(b){return a.extend(true,{},a.wijmo.c1basefield.prototype.options,a.wijmo.c1field.prototype.options,{dynamic:true,isLeaf:true,isBand:false,parentIdx:-1},b)},bounds:function(d,e){if(d){var c=d.nodeType?a(d):d,b=c.offset();if(b)return e?{top:b.top,left:b.left,width:c[0].clientWidth||0,height:c[0].clientHeight||0}:{top:b.top,left:b.left,width:c.outerWidth(),height:c.outerHeight()}}return null},_getDOMText:function(b,c,f){if(c===undefined)c=3;if(b&&c!==0){if(!f&&b.nodeType===3)return b.nodeValue;if(b.nodeType===1){switch(b.type){case"button":case"text":case"textarea":case"select-one":return b.value;case"checkbox":return b.checked.toString()}var d="",g=0,e;while(e=b.childNodes[g++])d+=a.wijmo.wijgrid._getDOMText(e,c-1);return d}}return""},rowTypeFromCss:function(b){var c=/wijmo-wijgrid-(\S+)row/.exec(b.attr("class"));if(c)switch(c[1]){case"header":return a.wijmo.wijgrid.rowType.header;case"filter":return a.wijmo.wijgrid.rowType.filter;case"data":return b.hasClass("wijmo-wijgrid-alternatingrow")?a.wijmo.wijgrid.rowType.data|a.wijmo.wijgrid.rowType.dataAlt:a.wijmo.wijgrid.rowType.data;case"alternating":return a.wijmo.wijgrid.rowType.data|a.wijmo.wijgrid.rowType.dataAlt;case"groupheader":return a.wijmo.wijgrid.rowType.groupHeader;case"groupfooter":return a.wijmo.wijgrid.rowType.groupFooter}},dataPrefix:function(b,i,j,f){var e=b.jquery||a.isArray(b),d,g,h,c=i+j;if(arguments.length===3)return e?a.data(b[0],c):a.data(b,c);else{if(e){for(d=0,g=b.length;d<g;d++)h=a.data(b[d],c,f);return h}return a.data(b,c,f)}},shallowMerge:function(d,c){if(c&&d){var a,e,b;for(a in c)if(c.hasOwnProperty(a)){e=c[a];b=typeof e;if((b==="string"||b==="boolean"||b==="number")&&d[a]===undefined)d[a]=e}}},isCustomObject:function(a){return a&&typeof a==="object"&&!(a instanceof Date)},search:function(c,d){var b,e,f=a.isFunction(d);for(b in c)if(c.hasOwnProperty(b)){e=f?d(c[b]):c[b]===d;if(e===true)return{at:b,found:c[b]}}return{at:null,found:null}},getAttributes:function(c,e){if(c){var d,h,g=0,f={},a,b;for(d=0,h=c.attributes.length;d<h;d++){b=c.attributes[d].name;if(b&&(!e||!e(b))){a=c.getAttribute(b);if(b==="style")a=typeof a==="object"?a.cssText:a;if(!a&&b==="class")a=c.getAttribute("className");if(a&&typeof a!=="function"){f[b]=a;g++}}}if(g)return f}return null}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{embeddedParsers:{stringParser:{parseDOM:function(f,d,e,c,b){return this.parse(a.wijmo.wijgrid._getDOMText(f),d,e,c,b)},parse:function(a,d,e,c,b){switch(a){case null:return null;case c:if(b)return null;case undefined:case"&nbsp;":return"";default:return""+a}},toStr:function(a,d,e,c,b){return a===null&&b?c:""+a}},numberParser:{parseDOM:function(f,d,e,c,b){return this.parse(a.wijmo.wijgrid._getDOMText(f),d,e,c,b)},parse:function(a,d,f,c,b){var e=typeof a;return e==="number"?isNaN(a)?NaN:a:!a&&a!==0||a==="&nbsp;"||a===c&&b?null:Globalize.parseFloat(a,10,d.name)},toStr:function(a,d,e,c,b){return a===null&&b?c:Globalize.format(a,e||"n",d.name)}},currencyParser:{parseDOM:function(f,d,e,c,b){return this.parse(a.wijmo.wijgrid._getDOMText(f),d,e,c,b)},parse:function(a,b,f,e,d){var c=typeof a;if(c==="number")return isNaN(a)?NaN:a;if(!a&&a!==0||a==="&nbsp;"||a===e&&d)return null;if(c==="string")a=a.replace(b.numberFormat.currency.symbol,"");return Globalize.parseFloat(a,10,b.name)},toStr:function(a,d,e,c,b){return a===null&&b?c:Globalize.format(a,e||"c",d.name)}},dateTimeParser:{parseDOM:function(f,d,e,c,b){return this.parse(a.wijmo.wijgrid._getDOMText(f),d,e,c,b)},parse:function(a,f,g,e,d){var c,b;if(a instanceof Date)return a;if(!a||a==="&nbsp;"||a===e&&d)return null;c=/^\/Date\((\d+)\)\/$/.exec(a);if(c)return new Date(parseInt(c[1],10));b=Globalize.parseDate(a,g,f.name);if(b==null||isNaN(b)){b=Date.parse(a);b=isNaN(b)?NaN:new Date(b)}return b},toStr:function(a,d,e,c,b){return a===null&&b?c:Globalize.format(a,e||"d",d.name)}},boolParser:{parseDOM:function(f,d,e,c,b){return this.parse(a.wijmo.wijgrid._getDOMText(f),d,e,c,b)},parse:function(b,f,g,e,d){var c=typeof b;if(c==="boolean")return b;if(c==="string")b=a.trim(b);if(!b||b==="&nbsp;"||b===e&&d)return null;switch(b.toLowerCase()){case"true":return true;case"false":return false}return NaN},toStr:function(a,d,e,c,b){return a===null&&b?c:a?"true":"false"}}}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{filterOperatorsCache:function(){var b={};this.add=function(a){if(a&&a.name&&a.operator){var c=a.name.toLowerCase();if(!b[c])b[c]=a}};this.clear=function(){b.length=0};this.getByName=function(a){return b[a.toLowerCase()]};this.getByDataType=function(f){var e=[],d,c;for(d in b)if(b.hasOwnProperty(d)){c=b[d];a.inArray(f,c.applicableTo)>=0&&e.push(c)}return e};this.removeCustom=function(){var a;for(a in b)if(b[a].custom)delete b[a]};this.sort=function(a,b){switch(b.toLowerCase()){case"alphabetical":a.sort(e);break;case"alphabeticalcustomfirst":a.sort(d);break;case"alphabeticalembeddedFirst":a.sort(c)}return a};function e(c,d){var a=c.name.toLowerCase(),b=d.name.toLowerCase();if(a!==b){if(a==="nofilter")return-1;if(b==="nofilter")return 1}return a===b?0:a<b?-1:1}function c(c,d){var a=c.name.toLowerCase(),b=d.name.toLowerCase();if(a!==b){if(a==="nofilter")return-1;if(b==="nofilter")return 1}if(c.custom!==d.custom){if(c.custom)return 1;if(d.custom)return-1}return a===b?0:a<b?-1:1}function d(c,d){var a=c.name.toLowerCase(),b=d.name.toLowerCase();if(a!==b){if(a==="nofilter")return-1;if(b==="nofilter")return 1}if(c.custom!==d.custom){if(c.custom)return-1;if(d.custom)return 1}return a===b?0:a<b?-1:1}}});a.wijmo.wijgrid.embeddedFiltersImpl={_anyCmp:function(c,d,h){var e,g,b,f=false;if(!a.isArray(d))d=[d];if(!(g=d.length))return false;if(c instanceof Date)c=c.getTime();if(typeof c==="string")c=c.toLowerCase();for(e=0;e<g&&!f;e++){b=d[e];if(b instanceof Date)b=b.getTime();if(typeof b==="string")b=b.toLowerCase();f=h(c,b)}return f}};a.wijmo.wijgrid.embeddedFilters={nofilter:{name:"NoFilter",arity:1,applicableTo:["string","number","datetime","currency","boolean"],operator:function(){return true}},contains:{name:"Contains",arity:2,applicableTo:["string"],operator:function(c,b){return a.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(c,b,function(a,b){return a===b||(a?a.indexOf(b)>=0:false)})}},notcontain:{name:"NotContain",arity:2,applicableTo:["string"],operator:function(c,b){return!a.wijmo.wijgrid.embeddedFilters.contains.operator(c,b)}},beginswith:{name:"BeginsWith",arity:2,applicableTo:["string"],operator:function(c,b){return a.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(c,b,function(a,b){return a===b||(a?a.indexOf(b)===0:false)})}},endswith:{name:"EndsWith",arity:2,applicableTo:["string"],operator:function(c,b){return a.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(c,b,function(a,b){var c=a===b,d;if(!c&&a){d=a.lastIndexOf(b);if(d>=0)c=a.length-d===b.length}return c})}},equals:{name:"Equals",arity:2,applicableTo:["string","number","datetime","currency","boolean"],operator:function(c,b){return a.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(c,b,function(b,a){return b===a})}},notequal:{name:"NotEqual",arity:2,applicableTo:["string","number","datetime","currency","boolean"],operator:function(c,b){return a.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(c,b,function(b,a){return b!==a})}},greater:{name:"Greater",arity:2,applicableTo:["string","number","datetime","currency","boolean"],operator:function(c,b){return a.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(c,b,function(b,a){return b>a})}},less:{name:"Less",arity:2,applicableTo:["string","number","datetime","currency","boolean"],operator:function(c,b){return a.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(c,b,function(b,a){return b<a})}},greaterorequal:{name:"GreaterOrEqual",arity:2,applicableTo:["string","number","datetime","currency","boolean"],operator:function(c,b){return a.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(c,b,function(b,a){return b>=a})}},lessorequal:{name:"LessOrEqual",arity:2,applicableTo:["string","number","datetime","currency","boolean"],operator:function(c,b){return a.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(c,b,function(b,a){return b<=a})}},isempty:{name:"IsEmpty",arity:1,applicableTo:["string"],operator:function(b){return a.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(b,undefined,function(a){return!a&&a!==0&&a!==false})}},notisempty:{name:"NotIsEmpty",arity:1,applicableTo:["string"],operator:function(b){return a.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(b,undefined,function(a){return!!a||a===0||a===false})}},isnull:{name:"IsNull",arity:1,applicableTo:["string","number","datetime","currency","boolean"],operator:function(b){return a.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(b,undefined,function(a){return a===null})}},notisnull:{name:"NotIsNull",arity:1,applicableTo:["string","number","datetime","currency","boolean"],operator:function(b){return a.wijmo.wijgrid.embeddedFiltersImpl._anyCmp(b,undefined,function(a){return a!==null})}}}})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{filterHelper:{getSingleValue:function(b){if(a.isArray(b)){b=b[0];if(a.isArray(b))b=b[0]}return b},getSingleOperatorName:function(b){if(a.isArray(b))b=b[0];return b.name||b||""},verify:function(b,d,f,g){if(b)if(a.isArray(b)){var c,i,e=[],h=[];if(!a.isArray(d))d=[d];for(c=0,i=b.length;c<i;c++)if(this._verifySingleOp(b[c],d[c],f,g)){e.push({name:b[c].name||b[c],condition:b[c].condition||"or"});h.push(d?d[c]:undefined)}if(e.length)return{filterOperator:e,filterValue:h}}else if(this._verifySingleOp(b,d,f,g))return{filterOperator:b,filterValue:d};return null},_verifySingleOp:function(b,d,e,f){if(b&&(b=b.name||b)){var c;b=(b||"").toLowerCase();if(b!=="nofilter"&&(c=f.getByName(b)))if(a.inArray(e||"string",c.applicableTo)>=0)if(c.arity===1||c.arity>1&&this.getSingleValue(d)!==undefined)return true}return false}}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{htmlTableAccessor:function(e,i,h,f){var c=[],d=0,b=e;function g(){var f=[],e,h,n,k,g,a,m,j,l,i;for(h=0,n=b.rows.length;h<n;h++){e=[];c[h]=e;k=b.rows[h];for(g=0,a=0,m=k.cells.length;g<m;g++,a++){j=k.cells[g];for(;f[a]>1;a++){f[a]--;e[a]={cellIdx:-1,colIdx:-1}}if(!(f[a]>1))f[a]=j.rowSpan;e[a]={cellIdx:g,colIdx:-1};e[g].colIdx=a;l=j.colSpan;for(;l>1;l--)e[++a]={cellIdx:-1,colIdx:-1}}i=f.length;for(;a<i;a++){f[a]--;e[a]={cellIdx:-1,colIdx:-1}}d=Math.max(d,i)}}this.element=function(){return e};this.width=function(){return d};this.getCellIdx=function(a,b){return a<d?c[b][a].cellIdx:-1};this.getColumnIdx=function(a,e){if(typeof a!=="number"){var b=a;a=b.cellIndex;e=b.parentNode.rowIndex}return a<d?c[e][a].colIdx:-1};this.clearSection=function(d){var e,f,d=a.wijmo.wijgrid.getTableSection(b,d);switch(d){case 2:e=this.getSectionLength(0);f=e+this.getSectionLength(d)-1;break;case 3:e=this.getSectionLength(0)+this.getSectionLength(1);f=e+this.getSectionLength(d)-1;break;default:e=0;f=this.getSectionLength(d)-1}while(d.rows.length)d.deleteRow(0);c.splice(e,f-e+1)};this.getSectionLength=function(c){return a.wijmo.wijgrid.getTableSectionLength(b,c)};this.getSectionRow=function(c,d){return a.wijmo.wijgrid.getTableSectionRow(b,d,c)};this.forEachColumnCellNatural=function(c,g,h){var a,f,e,d;for(a=0,f=b.rows.length;a<f;a++){e=b.rows[a];if(c<e.cells.length){d=g(e.cells[c],c,h);if(d!==true)return d}}return true};this.forEachColumnCell=function(h,i,j){var a,f,g,d,e;for(a=0,f=c.length;a<f;a++){g=b.rows[a];d=this.getCellIdx(h,a);if(d>=0){e=i(g.cells[d],a,j);if(e!==true)return e}}return true};this.forEachRowCell=function(g,f,h){var e=b.rows[g],a,d,c;for(a=0,d=e.cells.length;a<d;a++){c=f(e.cells[a],a,h);if(c!==true)return c}return true};this.colGroupTag=function(){var a=b.getElementsByTagName("colgroup");return a&&a[0]||null};this.colTags=function(){var a=this.colGroupTag();return a&&a.getElementsByTagName("col")||[]};this.ensureTBody=function(){return b.tBodies&&b.tBodies[0]||b.appendChild(document.createElement("tbody"))};this.ensureTHead=function(){return b.tHead&&b.tHead[0]||b.createTHead()};this.ensureTFoot=function(){return b.tFoot&&b.tFoot[0]||b.createTFoot()};this.ensureColGroup=function(){var a=b.getElementsByTagName("colgroup");return a&&a[0]||b.appendChild(document.createElement("colgroup"))};this.appendCol=function(b){var a=this.ensureColGroup();return b&&a.appendChild(b)||a.appendChild(document.createElement("col"))};this.removeOffset=function(a){if(a>=0&&a<c.length){if(a<0||!a&&a!==0)a=c.length-1;c.splice(a,1)}};this.insertOffset=function(a){var e,b;if(d>0){e=[];for(b=0;b<d;b++)e.push({cellIdx:b,colIdx:b});if(a<0||!a&&a!==0)a=c.length;c.splice(a,0,e)}};f&&this.ensureColGroup();h&&this.ensureTBody();!i&&g()}})})(jQuery);(function(a){"use strict";a.wijmo.wijgrid.cellInfo=function(d,c,f){var e=false,b=f;this.cellIndex=function(a){if(arguments.length===0)return d;d=a};this.column=function(){if(b&&this._isValid()){var a=b._getDataToAbsOffset();return b._field("visibleLeaves")[d+a.x]}return null};this.container=function(){var c=this.tableCell(),b;if(c){b=a(c).children("div.wijmo-wijgrid-innercell");if(b)return b}return null};this.isEqual=function(a){return a&&a.rowIndex()===c&&a.cellIndex()===d};this.row=function(){var a=this._row();if(a!==null){a=b._view()._getRowInfo(a);return a}return null};this.rowIndex=function(a){if(arguments.length===0)return c;c=a};this.tableCell=function(){if(b&&this._isValid()){var a=b._getDataToAbsOffset();return b._view().getCell(d+a.x,c+a.y)}return null};this.value=function(e){var d,f;if(b&&this._isValid()){f=b._view()._getRowInfo(b._rows().item(c));if(f.type&a.wijmo.wijgrid.rowType.data){d=this.column();if(arguments.length===0)return f.data[d.dataKey];else{e=b._parse(d,e);if(e===null&&d.valueRequired||d.dataType&&d.dataType!=="string"&&isNaN(e))throw"invalid value";b._dataStore.updateValue(f.dataItemIndex,d.dataKey,e)}}}};this.toString=function(){return d+":"+c};this._absToData=function(a){d-=a.x;c-=a.y;return this};this._clip=function(e){var b=false,a;if(d<(a=e.topLeft().cellIndex())){b=true;d=a}if(d>(a=e.bottomRight().cellIndex())){b=true;d=a}if(c<(a=e.topLeft().rowIndex())){b=true;c=a}if(c>(a=e.bottomRight().rowIndex())){b=true;c=a}return b};this._clone=function(){return new a.wijmo.wijgrid.cellInfo(d,c)};this._dataToAbs=function(a){d+=a.x;c+=a.y;return this};this._row=function(){return b&&this._isValid()?b._rows().item(c):null};this._isValid=function(){return d>=0&&c>=0};this._isEdit=function(a){if(!arguments.length)return e;e=a};this._setGridView=function(a){b=a}};a.wijmo.wijgrid.cellInfo.prototype.outsideValue=new a.wijmo.wijgrid.cellInfo(-1,-1);a.wijmo.wijgrid.cellInfoRange=function(e,d){if(!e||!d)throw"invalid arguments";var b=e._clone(),c=d._clone();this.bottomRight=function(){return c};this.isEqual=function(a){return a&&b.isEqual(a.topLeft())&&c.isEqual(a.bottomRight())};this.topLeft=function(){return b};this.toString=function(){return b.toString()+" - "+c.toString()};this._isIntersect=function(a){var d,f,e,g;if(a){d=a.bottomRight().rowIndex()-a.topLeft().rowIndex()+1;f=c.rowIndex()-b.rowIndex()+1;if(a.topLeft().rowIndex()+d-b.rowIndex()<d+f){e=a.bottomRight().cellIndex()-a.topLeft().cellIndex()+1;g=c.cellIndex()-b.cellIndex()+1;return a.topLeft().cellIndex()+e-b.cellIndex()<e+g}}return false};this._isValid=function(){return b._isValid()&&c._isValid()};this._clip=function(a){return b._clip(a)|c._clip(a)};this._clone=function(){return new a.wijmo.wijgrid.cellInfoRange(b._clone(),c._clone())};this._containsCellInfo=function(a){return a&&a.cellIndex()>=b.cellIndex()&&a.cellIndex()<=c.cellIndex()&&a.rowIndex()>=b.rowIndex()&&a.rowIndex()<=c.rowIndex()};this._containsCellRange=function(a){return a&&this._containsCellInfo(a.topLeft())&&this._containsCellInfo(a.bottomRight())};this._extend=function(d,a){if(d===1){b.rowIndex(a.topLeft().rowIndex());c.rowIndex(a.bottomRight().rowIndex())}else if(d===2){b.cellIndex(a.topLeft().cellIndex());c.cellIndex(a.bottomRight().cellIndex())}return this};this._normalize=function(){var a=b.cellIndex(),e=b.rowIndex(),d=c.cellIndex(),f=c.rowIndex();b.cellIndex(Math.min(a,d));b.rowIndex(Math.min(e,f));c.cellIndex(Math.max(a,d));c.rowIndex(Math.max(e,f))}}})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{classFactory:function(f,g){var h="#fake#",i=/xyz/.test(function(){xyz})?/\b_base\b/:/.*/,e=f?f.prototype:function(){},c=f?new f(h):new e,a,b,d;for(a in g)if(g.hasOwnProperty(a)){b=g[a];if(e&&typeof b==="function"&&typeof e[a]==="function"&&i.test(b))c[a]=function(b,a){return function(){var d=this._base,c;this._base=e[b];c=a.apply(this,arguments);if(d!==undefined)this._base=d;else delete this._base;return c}}(a,b);else c[a]=b}d=function(a){a!==h&&this.ctor&&this.ctor.apply(this,arguments)};d.prototype=c;d.constructor=c;return d}})})(jQuery);(function(a){"use strict";a.wijmo.wijgrid.baseView=a.wijmo.wijgrid.classFactory(null,{ctor:function(a,b){if(!a)throw"'wijgrid' must be specified";this._rowHeaderSize=22;this._wijgrid=a;this._wijgrid.element.addClass("wijmo-wijgrid-table");this._bounds=b;this._bodyRowsAccessor=null;this._headerRowsAccessor=null;this._rowsAccessor=null},dispose:function(){this.toggleDOMSelection(true);this._wijgrid.element.removeClass("wijmo-wijgrid-table")},ensureDisabledState:function(){var b=this._wijgrid.widgetBaseClass+"-disabled ui-state-disabled",c=this._wijgrid.options.disabled;a.each(this.subTables(),function(f,e){if(e){var d=a(e.element());if(c)d.addClass(b).attr("aria-disabled",true);else d.removeClass(b).attr("aria-disabled",false)}})},ensureWidth:function(a,b){this._setColumnWidth(a,b)},ensureHeight:function(){},getVisibleAreaBounds:function(){throw"not implemented";},getFixedAreaVisibleBounds:function(){throw"not implemented";},render:function(){this._ensureRenderBounds();this._preRender();this._renderContent();this._postRender()},toggleDOMSelection:function(b){a.each(this.subTables(),function(d,c){new a.wijmo.wijgrid.domSelection(c.element()).toggleSelection(b)});new a.wijmo.wijgrid.domSelection(this._wijgrid.outerDiv).toggleSelection(b)},updateSplits:function(){throw"not implemented";},bodyRows:function(){if(!this._bodyRowsAccessor)this._bodyRowsAccessor=new a.wijmo.wijgrid.rowAccessor(this,2,0,0);return this._bodyRowsAccessor},filterRow:function(){if(this._wijgrid.options.showFilter){var b=new a.wijmo.wijgrid.rowAccessor(this,1,0,0);return b.item(b.length()-1)}return null},headerRows:function(){var b;if(!this._headerRowsAccessor){b=this._wijgrid.options.showFilter?1:0;this._headerRowsAccessor=new a.wijmo.wijgrid.rowAccessor(this,1,0,b)}return this._headerRowsAccessor},rows:function(){if(!this._rowsAccessor)this._rowsAccessor=new a.wijmo.wijgrid.rowAccessor(this,0,0,0);return this._rowsAccessor},focusableElement:function(){throw"not implemented";},forEachColumnCell:function(){throw"not implemented";},forEachRowCell:function(){throw"not implemented";},getAbsoluteCellInfo:function(){throw"not implemented";},getAbsoluteRowIndex:function(){throw"not implemented";},getCell:function(){throw"not implemented";},getColumnIndex:function(){throw"not implemented";},getHeaderCell:function(){throw"not implemented";},getJoinedCols:function(){throw"not implemented";},getJoinedRows:function(){throw"not implemented";},getJoinedTables:function(){throw"not implemented";},subTables:function(){throw"not implemented";},_getMappedScrollMode:function(){var c=this._wijgrid.options.scrollMode,b="auto",a="auto";switch(c){case"horizontal":b="hidden";a="visible";break;case"vertical":b="visible";a="hidden";break;case"both":b="visible";a="visible"}return{vScrollBarVisibility:b,hScrollBarVisibility:a}},_postRender:function(){this.ensureDisabledState()},_preRender:function(){throw"not implemented";},_ensureRenderBounds:function(){var a=this._wijgrid._getDataCellsRange();this._bounds.start=0;this._bounds.end=a.bottomRight().rowIndex()},_renderContent:function(){this._renderCOLS();this._renderHeader();this._wijgrid.options.showFilter&&this._renderFilter();this._renderBody();this._wijgrid.options.showFooter&&this._renderFooter()},_renderCOLS:function(){var c=this._wijgrid._field("visibleLeaves"),b,d,a,e;for(a=0,e=c.length;a<e;a++){b=c[a];d=this._createCol(b,a);this._appendCol(d,b,a)}},_renderHeader:function(){var f=a.wijmo.wijgrid.rowType,c=this._wijgrid._field("columnHeadersTable"),b,e,d;if(c&&(e=c.length))for(b=0;b<e;b++){d=this._insertEmptyRow(f.header,b,-1,-1,-1);this._renderRow(d,null,c[b])}},_renderFilter:function(){var b=this._insertEmptyRow(a.wijmo.wijgrid.rowType.filter,-1,-1,-1,-1);this._renderRow(b,this._wijgrid._field("visibleLeaves"),null)},_renderBody:function(){var j=a.wijmo.wijgrid.rowType,g=this._wijgrid._field("visibleLeaves"),i=this._wijgrid.sketchTable,h=-1,e=0,c,k,f,b,d;if(this._wijgrid._dataStore.isDynamic())e=this._wijgrid.options.pageIndex*this._wijgrid.options.pageSize;for(c=this._bounds.start;c<=this._bounds.end;c++){b=i[c];d=(b.rowType&j.data)!==0;f=this._insertEmptyRow(b.rowType,c,d?++h:-1,d?b.originalRowIndex:-1,d?e+b.originalRowIndex:-1);this._renderRow(f,g,b)}},_renderFooter:function(){var b=this._insertEmptyRow(a.wijmo.wijgrid.rowType.footer,-1,-1,-1,-1);this._renderRow(b,this._wijgrid._field("visibleLeaves"),null)},_insertEmptyRow:function(c,b,f,e,d){var h=this._wijgrid._onViewInsertEmptyRow.apply(this._wijgrid,arguments),g=this._insertRow(c,b,h);return this._createRowInfo(g,c,a.wijmo.wijgrid.renderState.rendering,b,f,e,d)},_createEmptyCell:function(c){var f=a.wijmo.wijgrid.rowType,b=this._wijgrid._onViewCreateEmptyCell.apply(this._wijgrid,arguments);return this._createCell(c.type,b)},_insertRow:function(){throw"not implemented";},_createCell:function(c,b){var d=a.wijmo.wijgrid.rowType;if(!b)b=c===d.header?"<th />":"<td />";return c!==d.filter?a(b).wrapInner('<div class="wijmo-wijgrid-innercell"></div>'):a(b)},_appendCell:function(){throw"not implemented";},_createCol:function(){throw"not implemented";},_appendCol:function(){throw"not implemented";},_renderRow:function(c,e,d){var b=a.wijmo.wijgrid.rowType,g,f;switch(c.type){case b.filter:this._renderFilterRow(c,e);break;case b.footer:this._renderFooterRow(c,e);break;case b.fooRow:this._renderFooRow(c,e);break;case b.header:this._renderHeaderRow(c,d);break;case b.data:case b.data|b.dataAlt:this._renderDataRow(c,e,d);g=d.__attr;f=d.__style;break;case b.emptyDataRow:case b.groupHeader:case b.groupFooter:this._renderSpannedRow(c,e,d);g=d.__attr;f=d.__style;break;default:throw"unknown rowType";}this._rowRendered(c,g,f)},_renderCell:function(b,f,g,h,d,j,i){var c=this._createEmptyCell(b,d.dataIndex,d),e=b.type===a.wijmo.wijgrid.rowType.filter?c:c.children("div");this._appendCell(b,f,c);if(h)e.html(g);else this._wijgrid.cellFormatter.format(e,d,g,b);this._cellRendered(b,c,f,d,j,i)},_renderDataRow:function(k,f,b){var d,j,c,a,e,h,g,i=false;for(d=0,j=f.length;d<j;d++){c=f[d];a=c.dataIndex;e=null;if(a>=0&&(!b[a]||b[a].visible===false))continue;if(c.dataParser)e=a>=0?this._wijgrid._toStr(c,b[a].value):null;else if(a>=0){e=b[a].html;i=true}h=a>=0?b[a].__attr:null;g=a>=0?b[a].__style:null;this._renderCell(k,d,e,i,c,h,g)}},_renderFilterRow:function(f,d){var b,e,c;for(b=0,e=d.length;b<e;b++){c=d[b];this._renderCell(f,b,a.wijmo.wijgrid.filterHelper.getSingleValue(c.filterValue),false,c)}},_renderFooterRow:function(d,b){var a,c;for(a=0,c=b.length;a<c;a++)this._renderCell(d,a,"",false,b[a])},_renderFooRow:function(d,b){var a,c;for(a=0,c=b.length;a<c;a++)this._renderCell(d,a,"&nbsp;",true,b[a])},_renderHeaderRow:function(c,d){var b,e,f=0,a;for(b=0,e=d.length;b<e;b++){a=d[b];if(a.column&&a.column.parentVis){a.column.thX=f++;a.column.thY=c.sectionRowIndex;this._renderCell(c,b,a.column.headerText,false,a.column,{colSpan:a.colSpan,rowSpan:a.rowSpan})}}},_renderSpannedRow:function(d,c,b){for(var f,e=Math.min(c.length,b.length),a=0;a<e;a++)this._renderCell(d,a,b[a].html,true,c[a],b[a].__attr,b[a].__style)},_cellRendered:function(d,b,c,e,g,f){this._wijgrid.cellStyleFormatter.format(b,c,e,d,a.wijmo.wijgrid.renderState.rendering,g,f);this._changeCellRenderState(b,a.wijmo.wijgrid.renderState.rendering,false);this._wijgrid._onViewCellRendered(d,b,c,e)},_rowRendered:function(b,d,c){this._wijgrid.rowStyleFormatter.format(b,d,c);b.state&=~a.wijmo.wijgrid.renderState.rendering;this._setRowInfo(b.$rows,b);this._wijgrid._onViewRowRendered(b)},_isBodyRow:function(){var b=a.wijmo.wijgrid.rowType,c=b.type;return c&b.data||c===b.groupHeader||c===b.groupFooter||c===b.emptyDataRow},_changeRowRenderState:function(a,b,c){if(c)a.state|=b;else a.state&=~b;this._setRowInfo(a.$rows,a)},_changeCellRenderState:function(d,b,g){var e=a.wijmo.wijgrid.dataPrefix,c=this._wijgrid._data$prefix,f=e(d,c,"renderState");if(g){b=f|b;e(d,c,"renderState",b)}else{b=f&~b;e(d,c,"renderState",b)}return b},_adjustWidthArray:function(j,k,d,n,c){var h=this._sumWidthArray(j),l=this._sumWidthArray(k),b=[],e,f=0,g,i,m=true;if(h<=d){a.extend(true,b,j);if(h===d||n)return b;else e=d-h}else{a.extend(true,b,k);if(l>=d)return b;else e=d-l}a.each(b,function(b,a){if(!a.real)f++});if(f!==0){if(c!==undefined&&c>-1&&c<b.length&&!b[c].real){b[c].width+=e;return b}g=Math.floor(e/f);i=e-g*f;a.each(b,function(b,a){if(!a.real){a.width+=g;if(m){a.width+=i;m=false}}})}return b},_getColumnWidth:function(m,k){var e,c,f,j,l,i,d,g,n,h,b,o;if(k){e=this._wijgrid._field("visibleLeaves")[m];if(e._realWidth!==undefined)c={width:e._realWidth,real:true};else if(e.isRowHeader)c={width:this._rowHeaderSize,real:true};else{f=0;j=this.getJoinedTables(true,m);l=j[2];for(i=0;i<2;i++){d=j[i];if(d!==null){g=d.element().rows;if(o=g.length){for(b=o-1,h=null;b>=0;b--)if(g[b].cells.length===d.width()){h=g[b];break}if(h){n=h.cells[l];f=Math.max(f,a(n).outerWidth())}}}}c={width:f,real:false}}k.push(c)}},_setColumnWidth:function(c,b){var e=this.getHeaderCell(c),d=this.getJoinedCols(c);if(b){a(e).setOutWidth(b);a.each(d,function(d,c){a(c).setOutWidth(b)})}},_setTableWidth:function(d,c,f,g){var e,b;a.each(d,function(b,a){a.css("table-layout","fixed").setOutWidth(c)});e=d[0].outerWidth();b=e-c;b!==0&&this._setColumnWidth(g,f-b)},_sumWidthArray:function(e,b,c){var d=0;a.each(e,function(a,e){if(b!==undefined&&c!==undefined&&(a<b||a>c))return true;d+=e.width});return d},_clearBody:function(){a.each(this.subTables(),function(b,a){a.clearSection(2)})},_removeBodyRow:function(d,j){var e=a.wijmo.wijgrid.rowType,g=this._wijgrid._rows(),f,i,b,k,h,c;if(d>=0&&d<(i=g.length())){if(j)for(f=0;f<i;f++){b=this._getRowInfo(g.item(f));cmp=b.sectionRowIndex-d;if(b.sectionRowIndex>d){b.sectionRowIndex--;if(b.type&e.data){if(b.type&e.dataAlt)b.type&=~e.dataAlt;else b.type|=e.dataAlt;b.dataItemIndex--;b.dataRowIndex--;b.virtualDataItemIndex--}this._setRowInfo(b.$rows,b)}}b=this._getRowInfo(g.item(d));h=this.getAbsoluteRowIndex(b.$rows[0]);b.$rows.remove();c=this.getJoinedTables(false,h);c[0]&&c[0].removeOffset(c[2]);c[1]&&c[1].removeOffset(c[2])}},_insertBodyRow:function(f,b,i,h){var j=this._wijgrid._field("visibleLeaves"),l=a.wijmo.wijgrid.rowType,n=this._wijgrid._view(),k=this._wijgrid._rows(),g=k.length(),o,m=(f.rowType&l.data)!==0,e,d,c;if(b<0||b>=g||!b&&b!==0)b=g;e=this._insertEmptyRow(f.rowType,b,-1,i,h);this._renderRow(e,j,f);d=this.getAbsoluteRowIndex(e.$rows[0]);c=this.getJoinedTables(false,d);c[0]&&c[0].insertOffset(d);c[1]&&c[1].insertOffset(d);return e},_findRowInfo:function(e){var d=this.bodyRows(),b=0,f=d.length(),c;if(a.isFunction(e))for(b=0;b<f;b++){c=this._getRowInfo(d.item(b));if(e(c)===true)return c}return null},_setRowInfo:function(g,b){var d="$rows"in b,c="data"in b,f,e;if(d){f=b.$rows;delete b.$rows}if(c){e=b.data;delete b.data}a.wijmo.wijgrid.dataPrefix(g,this._wijgrid._data$prefix,"rowInfo",b);if(d)b.$rows=f;if(c)b.data=e},_getRowInfo:function(c){var d=this._wijgrid,e=c[1]?a(c):a(c[0]),b=a.wijmo.wijgrid.dataPrefix(e,d._data$prefix,"rowInfo"),f;b.$rows=e;if(b.dataItemIndex>=0&&b.type&a.wijmo.wijgrid.rowType.data)b.data=d._getDataItem(b.dataItemIndex);return b},_createRowInfo:function(i,d,h,f,g,b,e){var j,c={type:d,state:h,sectionRowIndex:f,dataRowIndex:g,dataItemIndex:b,virtualDataItemIndex:e,$rows:a(i)};if(b>=0&&d&a.wijmo.wijgrid.rowType.data)c.data=this._wijgrid._getDataItem(b);return c}})})(jQuery);(function(a){"use strict";a.wijmo.wijgrid.flatView=a.wijmo.wijgrid.classFactory(a.wijmo.wijgrid.baseView,{ctor:function(b,a){this._base(b,a);this._dataTable=null;this._contentArea=null},dispose:function(){this._wijgrid.outerDiv.unbind("scroll",this._onScroll);this._base()},ensureWidth:function(e,b,c){var d=a(this._dataTable.element()),f=d.width()+b-c;this._base(e,b,c);this._setTableWidth([d],f,b,e)},getVisibleAreaBounds:function(){var b=a.wijmo.wijgrid.bounds(this._dataTable.element()),c;if(this._wijgrid.options.scrollMode==="none")return b;else{c=a.wijmo.wijgrid.bounds(this._wijgrid.outerDiv.find(".wijmo-wijgrid-split-area-se:first")[0]);return{top:b.top,left:b.left,width:Math.min(c.width,b.width),height:Math.min(c.height,b.height)}}},updateSplits:function(){var f=this,e=this._wijgrid,h=e.options,g=e.element,i=[],j=[],b=[],d=e._field("visibleLeaves"),l=e.outerDiv,k,c;g.css({"table-layout":"",width:""});a.each(d,function(d,b){var c,a=b.width;if(a||a===0){c=typeof a==="string"&&a.length>1&&a[a.length-1]==="%";if(c)a=l.width()*parseFloat(a)/100;else a=parseFloat(a);if(b.ensurePxWidth||b.ensurePxWidth===undefined&&h.ensureColumnsPxWidth)b._realWidth=a;f._setColumnWidth(d,a)}});a.each(d,function(a){f._getColumnWidth(a,i)});g.css("width","1px");a.each(d,function(a){f._getColumnWidth(a,j)});k=l.innerWidth();b=this._adjustWidthArray(i,j,k,h.ensureColumnsPxWidth,h.autoExpandColumnIndex);a.each(b,function(a,c){var b=d[a];if(b._realWidth!==undefined){delete b._realWidth;return}f._setColumnWidth(a,c.width)});c=b.length-1;c!==-1&&this._setTableWidth([g],this._sumWidthArray(b,0,c),b[c].width,c)},focusableElement:function(){return a(this._dataTable.element())},forEachColumnCell:function(a,b,c){return this._dataTable.forEachColumnCell(a,b,c)},forEachRowCell:function(b,a,c){return this._dataTable.forEachRowCell(b,a,c)},getAbsoluteCellInfo:function(b){return new a.wijmo.wijgrid.cellInfo(this.getColumnIndex(b),b.parentNode.rowIndex)},getAbsoluteRowIndex:function(a){return a.rowIndex},getCell:function(d,b){var c=this._dataTable.getCellIdx(d,b),a;if(c>=0){a=this.getJoinedRows(b,0);if(a[0])return a[0].cells[c]}return null},getColumnIndex:function(a){return this._dataTable.getColumnIdx(a)},getHeaderCell:function(d){var b=this._wijgrid._field("visibleLeaves")[d],c;return b&&(c=this._wijgrid._headerRows())?(new a.wijmo.wijgrid.rowAccessor).getCell(c.item(b.thY),b.thX):null},getJoinedCols:function(c){var b=a(this._dataTable.element()).find("> colgroup");if(b.length)if(c<b[0].childNodes.length)return[b[0].childNodes[c],null];return[null,null]},getJoinedRows:function(a,b){return[this._dataTable.getSectionRow(a,b),null]},getJoinedTables:function(b,a){return[this._dataTable,null,a]},subTables:function(){return[this._dataTable]},_preRender:function(){this._dataTable=new a.wijmo.wijgrid.htmlTableAccessor(this._wijgrid.element[0],true,true,true)},_postRender:function(){this._wijgrid.element.find("> tbody").addClass("ui-widget-content wijmo-wijgrid-data");this._dataTable=new a.wijmo.wijgrid.htmlTableAccessor(this._wijgrid.element[0]);this._wijgrid.element.attr({role:"grid",cellpadding:"0",border:"0",cellspacing:"0"}).css("border-collapse","separate");this._wijgrid.outerDiv.bind("scroll",{wijgrid:this._wijgrid},this._onScroll);this._base()},_insertRow:function(f,c,e){var d=a.wijmo.wijgrid.rowType,b;switch(f){case d.header:case d.filter:b=this._dataTable.ensureTHead();break;case d.footer:b=this._dataTable.ensureTFoot();break;default:b=this._dataTable.ensureTBody()}if(e)return[b.appendChild(e)];else{if(c>b.rows.length)c=-1;return[b.insertRow(c)]}},_rowRendered:function(a,d,c){var b=a.$rows[0];if(!b.cells.length&&this._isBodyRow(a))b.parentNode.removeChild(b);else this._base(a,d,c)},_appendCell:function(a,c,b){a.$rows.append(b)},_createCol:function(){return document.createElement("col")},_appendCol:function(a){this._dataTable.appendCol(a)},_onScroll:function(a){a.data.wijgrid.$superPanelHeader&&a.data.wijgrid.$superPanelHeader.css("left",a.target.scrollLeft);a.data.wijgrid.$bottomPagerDiv&&a.data.wijgrid.$bottomPagerDiv.css("left",a.target.scrollLeft)}})})(jQuery);(function(a){"use strict";a.wijmo.wijgrid.fixedView=a.wijmo.wijgrid.classFactory(a.wijmo.wijgrid.baseView,{ctor:function(b,c){this._base(b,c);this._verScrollBarSize=18;this._mouseWheelHandler=a.proxy(this._onMouseWheel,this);this._viewTables={};this._splitAreas={};this._scroller=null;this.element=b.element;this._allowVirtualScrolling=b._allowVirtualScrolling(),this._staticDataRowIndex=b._getStaticIndex(true);this._staticRowIndex=b._getRealStaticRowIndex();this._staticColumnIndex=b._getRealStaticColumnIndex();this._staticAllColumnIndex=this._staticColumnIndex===-1?-1:b._field("visibleLeaves")[this._staticColumnIndex].leavesIdx},dispose:function(){this._base();this._wijgrid.outerDiv.unbind("mousewheel",this._mouseWheelHandler)},ensureWidth:function(e,f,p){var h=this._wijgrid,c=h.options,g=this._staticColumnIndex,i=e<=g,b=a(this._viewTables.nw.element()),d=a(this._viewTables.ne.element()),n=a(this._viewTables.sw.element()),m=a(this._viewTables.se.element()),k=i?[b,n]:[d,m],l=(i?b.width():d.width())+f-p,o=h._field("frozener"),j=this.getScrollValue();this._destroySuperPanel();this._base(e,f);this._setTableWidth(k,l,f,e);try{if(g>=0)c.splitDistanceX=b[0].offsetWidth;else c.splitDistanceX=0}catch(q){}this._updateSplitAreaBounds(0);this._adjustRowsHeights();try{if(this._staticRowIndex>=0)c.splitDistanceY=Math.max(b[0].offsetHeight,d[0].offsetHeight);else c.splitDistanceY=0}catch(q){}this._updateSplitAreaBounds(1);this.refreshPanel(j);o.refresh()},ensureHeight:function(k){var b,d=this._wijgrid,e=d.options,h=a(this._viewTables.nw.element()),g=a(this._viewTables.ne.element()),i=a(this._viewTables.sw.element()),c=a(this._viewTables.se.element()),j=d._field("frozener"),f=this.getScrollValue();this._destroySuperPanel();if(arguments.length>0){b=this.getJoinedRows(k,2);this._setRowHeight(b,this._getRowHeight(b))}c.css("height","");c.height(Math.max(c.height(),i.height()));try{if(this._staticRowIndex>=0)e.splitDistanceY=Math.max(h[0].offsetHeight,g[0].offsetHeight);else e.splitDistanceY=0}catch(l){}this._updateSplitAreaBounds(1);this.refreshPanel(f);j.refresh()},getScrollValue:function(){var a=this._getSuperPanel();return a?{type:"fixed",hScrollValue:a.options.hScroller.scrollValue,vScrollValue:a.options.vScroller.scrollValue}:{type:"fixed",hScrollValue:null,vScrollValue:null}},getVisibleAreaBounds:function(){var b=a.wijmo.wijgrid.bounds(this._wijgrid.outerDiv.find(".wijmo-wijsuperpanel-contentwrapper:first"));if(!b)b=a.wijmo.wijgrid.bounds(this._wijgrid.outerDiv);return b},getFixedAreaVisibleBounds:function(){var b=this.getVisibleAreaBounds(),f=a.wijmo.wijgrid.bounds(this._splitAreas.ne),c=a.wijmo.wijgrid.bounds(this._splitAreas.nw),d=null,e=null;if(f.height||c.height)d={left:b.left,top:b.top,width:b.width,height:Math.min(f.height||c.height,b.height)};if(c.width)e={left:b.left,top:b.top,width:Math.min(c.width,b.width),height:b.height};return[d,e]},refreshPanel:function(d){var e=this,b=this._wijgrid,c=b.options,g=this._getGridWidth(c.scrollMode),f=this._getMappedScrollMode(),h=this._testNeedVBar(b.outerDiv,b.element,a(this._viewTables.ne.element()),c.scrollMode,b._autoHeight);this._scroller.width(g);this._splitAreas.ne.width(g-c.splitDistanceX-(h?this._verScrollBarSize:0));if(!this._scroller.data("wijsuperpanel")){if(this._allowVirtualScrolling)this.vsUI=new a.wijmo.wijgrid.virtualScrollerUI(b,this._splitAreas.se,c.splitDistanceY);this._scroller.wijsuperpanel({disabled:b.options.disabled,scroll:a.proxy(this._onScroll,this),bubbleScrollingEvent:true,customScrolling:this._allowVirtualScrolling,vScroller:{scrollBarVisibility:f.vScrollBarVisibility,scrollValue:d.type==="fixed"?d.vScrollValue:null},hScroller:{scrollBarVisibility:f.hScrollBarVisibility,scrollValue:d.type==="fixed"?d.hScrollValue:null},hScrollerActivating:function(f,d){var a;if(b._autoHeight){a=b.element.height()+c.splitDistanceY-d.contentLength;if(a>0){e._scroller.height(e._scroller.height()+a);e._scroller.wijsuperpanel("paintPanel");return false}}e._splitAreas.sw.height(d.contentLength-c.splitDistanceY)}});this._scroller.find(".wijmo-wijsuperpanel-contentwrapper:first").scroll(function(a){if(a.target.scrollLeft)a.target.scrollLeft=0;if(a.target.scrollTop)a.target.scrollTop=0;a.preventDefault()});this._allowVirtualScrolling&&this.vsUI.attach(this._scroller)}else this._scroller.wijsuperpanel("paintPanel");this._scroller.find(".wijmo-wijsuperpanel-hbarcontainer, .wijmo-wijsuperpanel-vbarcontainer").css("zIndex",5)},scrollTo:function(n){if(!n.tableCell())return;var u=this._wijgrid,v=u.options,m=this._getSuperPanel(),t=n.tableCell(),o=t.nodeType?a(t):t,l,s,d,f,k,i,r,b,c,j,h,e=null,g=null,x,p,w,q;if(m&&o.is(":visible")){l=m.getContentElement();s=l.parent();d=parseInt((l.css("left")+"").replace("px",""),10)*-1;f=parseInt((l.css("top")+"").replace("px",""),10)*-1;k=s.outerWidth()-v.splitDistanceX;i=s.outerHeight()-v.splitDistanceY;r=o.position();b=r.left;c=r.top;j=o.outerWidth();h=o.outerHeight();x=u._getStaticIndex(true);p=u._getStaticIndex(false);w=n.rowIndex();q=n.cellIndex();if(w<=x)if(q<=p){e=0;g=0}else{b+=d;if(b+j>d+k)d=e=b+j-k;if(b<d)e=b;g=0}else if(q<=p){c+=f;if(c+h>f+i)f=g=c+h-i;if(c<f)g=c;e=0}else{b-=v.splitDistanceX;if(c+h>f+i)f=g=c+h-i;if(b+j>d+k)d=e=b+j-k;if(c<f)g=c;if(b<d)e=b}e!==null&&m.hScrollTo(e);g!==null&&m.vScrollTo(g)}},updateSplits:function(q){var j=this._wijgrid,c=j.options,h,k=this,d=[],p=[],o=[],f=this._staticColumnIndex,b,r=c.scrollMode,l=j._field("visibleLeaves"),i=a(this._viewTables.se.element()),e=a(this._viewTables.ne.element()),m=a(this._viewTables.sw.element()),g=a(this._viewTables.nw.element()),n=j.outerDiv;this._destroySuperPanel();n.unbind("mousewheel",this._mouseWheelHandler);!i.find("tbody .wijmo-wijgrid-row:not(.wijmo-wijgrid-groupheaderrow):first").length&&j.element.css("width","100%");a.each([i,e,m,g],function(b,a){a.css({"table-layout":"",width:""})});a.each(l,function(e,b){var d,a=b.width;if(a||a===0){d=typeof a==="string"&&a.length>1&&a[a.length-1]==="%";if(d)a=n.width()*parseFloat(a)/100;else a=parseFloat(a);if(b.ensurePxWidth||b.ensurePxWidth===undefined&&c.ensureColumnsPxWidth)b._realWidth=a;k._setColumnWidth(e,a)}});a.each(l,function(a){k._getColumnWidth(a,o)});a.each([g,e,m,i],function(b,a){a.css({width:"1px"})});a.each(l,function(a){k._getColumnWidth(a,p)});h=n.innerWidth();d=this._adjustWidthArray(o,p,h,c.ensureColumnsPxWidth,c.autoExpandColumnIndex);a.each(d,function(a,c){var b=l[a];if(b._realWidth!==undefined){delete b._realWidth;return}k._setColumnWidth(a,c.width)});if(f>=0){b=f;this._setTableWidth([g,m],this._sumWidthArray(d,0,b),d[b].width,b)}try{if(f>=0)c.splitDistanceX=g[0].offsetWidth;else c.splitDistanceX=0}catch(s){}this._updateSplitAreaBounds(0);!c.ensureColumnsPxWidth&&e.parent().width(h-c.splitDistanceX);b=d.length-1;b!==-1&&this._setTableWidth([e,i],this._sumWidthArray(d,f+1,b),d[b].width,b);this._adjustRowsHeights();try{if(this._staticRowIndex>=0)c.splitDistanceY=Math.max(g[0].offsetHeight,e[0].offsetHeight);else c.splitDistanceY=0}catch(s){}this._updateSplitAreaBounds(1);if(!c.ensureColumnsPxWidth)if(this._testNeedVBar(j.outerDiv,i,e,r,j._autoHeight)){h-=this._verScrollBarSize;d=this._adjustWidthArray(o,p,h,c.ensureColumnsPxWidth,c.autoExpandColumnIndex);a.each(d,function(b,a){!a.real&&k._setColumnWidth(b,a.width)});if(f>=0){b=f;this._setTableWidth([g,m],this._sumWidthArray(d,0,b),d[b].width,b)}try{if(f>=0)c.splitDistanceX=g[0].offsetWidth;else c.splitDistanceX=0}catch(s){}this._updateSplitAreaBounds(0);e.parent().width(h-c.splitDistanceX);b=d.length-1;b!==-1&&this._setTableWidth([e,i],this._sumWidthArray(d,f+1,b),d[b].width,b);this._adjustRowsHeights();try{if(this._staticRowIndex>=0)c.splitDistanceY=Math.max(g[0].offsetHeight,e[0].offsetHeight);else c.splitDistanceY=0}catch(s){}this._updateSplitAreaBounds(1)}this.refreshPanel(q);n.bind("mousewheel",this._mouseWheelHandler)},_clearBody:function(){this._base();this.fooRow=null;this._createFooRow()},bodyRows:function(){var a=this._base();a&&this.fooRow&&!a._lengthAdjuster()&&a._lengthAdjuster(function(a){return a&&a[1]?-1:0});return a},focusableElement:function(){return this._wijgrid.outerDiv},forEachColumnCell:function(f,d,e){var b=this.getJoinedTables(true,f),c,a;if(b[0]!==null){c=b[2];a=b[0].forEachColumnCell(c,d,e);if(a!==true)return a;if(b[1]!==null){a=b[1].forEachColumnCell(c,d,e);if(a!==true)return a}}return true},forEachRowCell:function(h,f,g){var c=this.getJoinedTables(false,h),d=c[0],e=c[1],b,a;if(d!==null){b=c[2];if(b<d.element().rows.length){a=d.forEachRowCell(b,f,g);if(a!==true)return a}if(e!==null&&b<e.element().rows.length){a=e.forEachRowCell(b,f,g);if(a!==true)return a}}return true},getAbsoluteCellInfo:function(b){return new a.wijmo.wijgrid.cellInfo(this.getColumnIndex(b),this.getAbsoluteRowIndex(b.parentNode))},getAbsoluteRowIndex:function(b){var c=b.rowIndex,a=b.parentNode;while(a.tagName.toLowerCase()!=="table")a=a.parentNode;return a===this._viewTables.nw.element()||a===this._viewTables.ne.element()?c:c+this._staticRowIndex+1},getCell:function(g,h){var a=this.getJoinedTables(false,h),c,e,d,b,f;if(a[0]!==null){c=this.getJoinedTables(true,g);if(c[0]!==null){e=a[2];d=c[2];b=null;if(a[1]!==null)b=g===d?a[0]:a[1];else b=a[0];f=b.getCellIdx(d,e);if(f>=0)return b.element().rows[e].cells[f]}}return null},getColumnIndex:function(e){for(var a=null,b=null,d=false,c,a=e.parentNode;a.tagName.toLowerCase()!=="table";a=a.parentNode);if(a!==null){if(a===this._viewTables.nw.element())b=this._viewTables.nw;else if(a===this._viewTables.ne.element()){b=this._viewTables.ne;d=true}else if(a===this._viewTables.sw.element())b=this._viewTables.sw;else if(a===this._viewTables.se.element()){b=this._viewTables.se;d=true}if(b!==null){c=b.getColumnIdx(e);if(d)c+=this._staticColumnIndex+1;return c}}return-1},getHeaderCell:function(d){var b=this._wijgrid._field("visibleLeaves")[d],c;return b&&(c=this._wijgrid._headerRows())?(new a.wijmo.wijgrid.rowAccessor).getCell(c.item(b.thY),b.thX):null},getJoinedCols:function(d){var c=[],b=this.getJoinedTables(true,d),e=b[2];b.splice(b.length-1,1);a.each(b,function(d,b){c.push(b?a(b.element()).find("col")[e]:null)});return c},getJoinedRows:function(c,e){var f=null,g=null,a=null,d=null,l=this._staticRowIndex,b=this._staticColumnIndex,m=this._wijgrid._field("visibleLeaves").length-1,n=this._rowsCountRaw()-1,k=l===n,h=l<0,j=!k&&!h,i=0;if(k||j){if(b>=0&&b<m){a=this._viewTables.nw;d=this._viewTables.ne}else a=b<0?this._viewTables.ne:this._viewTables.nw;i=a.getSectionLength(e);if(c<i){f=a.getSectionRow(c,e);if(d!==null)g=d.getSectionRow(c,e)}}if(h||j&&f===null){if(!h)c-=i;if(b>=0&&b<m){a=this._viewTables.sw;d=this._viewTables.se}else a=b<0?this._viewTables.se:this._viewTables.sw;f=a.getSectionRow(c,e);if(d!==null)g=d.getSectionRow(c,e)}return f===null&&g===null?null:[f,g]},getJoinedTables:function(g,f){var a=null,b=null,c=f,h=this._wijgrid,e=this._staticRowIndex,d=this._staticColumnIndex;if(g){if(f<=d){a=this._viewTables.nw;b=this._viewTables.sw}else{a=this._viewTables.ne;b=this._viewTables.se;c=c-(d+1)}if(e<0)a=null;if(e===this._rowsCountRaw()-1)b=null}else{if(f<=e){a=this._viewTables.nw;b=this._viewTables.ne}else{a=this._viewTables.sw;b=this._viewTables.se;c=c-(e+1)}if(d<0)a=null;if(d===h._field("leaves").length-1)b=null}if(a===null){a=b;b=null}return[a,b,c]},subTables:function(){return[this._viewTables.nw,this._viewTables.ne,this._viewTables.sw,this._viewTables.se]},_getGridWidth:function(e){var b=this._wijgrid,c=b.element.outerWidth(true)+b.options.splitDistanceX,d=b.outerDiv.innerWidth();if(this._testNeedVBar(b.outerDiv,b.element,a(this._viewTables.ne.element()),e,b._autoHeight))c+=this._verScrollBarSize;if(c>d)c=d;return c},_getSuperPanel:function(){return this._scroller?this._scroller.data("wijsuperpanel"):null},_ensureRenderBounds:function(){var a=this._wijgrid._getDataCellsRange();if(this._wijgrid._allowVirtualScrolling())this._bounds.end=Math.min(this._bounds.start+this._wijgrid.options.pageSize-1,a.bottomRight().rowIndex());else this._base()},_renderContent:function(){this._base();this._createFooRow()},_createFooRow:function(){this.fooRow=this._insertEmptyRow(a.wijmo.wijgrid.rowType.fooRow,Number.MAX_VALUE,-1,-1,-1);this._renderRow(this.fooRow,this._wijgrid._field("visibleLeaves"),null)},_preRender:function(){var b=document.createDocumentFragment(),c=a.wijmo.wijgrid.htmlTableAccessor;this._wijgrid.outerDiv.wrapInner('<div class="wijmo-wijgrid-fixedview"><div class="wijmo-wijgrid-scroller"><div class="wijmo-wijgrid-split-area-se wijmo-wijgrid-content-area"></div></div></div>');this._scroller=this._wijgrid.outerDiv.find(".wijmo-wijgrid-scroller");this._scroller.after(this._splitAreas.nw=a('<div class="wijmo-wijgrid-split-area wijmo-wijgrid-split-area-nw" style="overflow:hidden;position:absolute;z-index:4;top:0px;left:0px;"></div>'));this._scroller.after(this._splitAreas.ne=a('<div class="wijmo-wijgrid-split-area wijmo-wijgrid-split-area-ne" style="overflow:hidden;position:absolute;z-index:4;top:0px;left:0px;"></div>'));this._scroller.after(this._splitAreas.sw=a('<div class="wijmo-wijgrid-split-area wijmo-wijgrid-split-area-sw" style="overflow:hidden;position:absolute;z-index:4;top:0px;left:0px;"></div>'));this._splitAreas.se=this._scroller.find(".wijmo-wijgrid-split-area-se:first");this._viewTables={nw:new c(b.appendChild(document.createElement("table")),true,true,true),ne:new c(b.appendChild(document.createElement("table")),true,true,true),sw:new c(b.appendChild(document.createElement("table")),true,true,true),se:new c(b.appendChild(this._wijgrid.element[0]),true,true,true)}},_postRender:function(){var c,d,e,f,b=a.wijmo.wijgrid.htmlTableAccessor;this._viewTables={nw:new b(c=this._viewTables.nw.element()),ne:new b(d=this._viewTables.ne.element()),sw:new b(e=this._viewTables.sw.element()),se:new b(f=this._viewTables.se.element())};this._splitAreas.nw.empty().append(c);this._splitAreas.ne.empty().append(d);this._splitAreas.sw.empty().append(e);this._splitAreas.se.empty().append(f);a.each(this._viewTables,function(c,b){a(b.element()).addClass("wijmo-wijgrid-table").attr({role:"grid",border:"0",cellpadding:"0",cellspacing:"0"}).css("border-collapse","separate").find("> tbody").addClass("ui-widget-content wijmo-wijgrid-data")});this._base()},_rowsCountRaw:function(){var b=this._viewTables.nw.element(),c=this._viewTables.ne.element(),d=this._viewTables.sw.element(),e=this._viewTables.se.element(),a;a=Math.max(b.rows.length,c.rows.length)+Math.max(d.rows.length,e.rows.length);return a},_createCol:function(){return[document.createElement("col"),document.createElement("col")]},_appendCol:function(a,c,b){if(b<=this._staticColumnIndex){this._viewTables.nw.appendCol(a[0]);this._viewTables.sw.appendCol(a[1])}else{this._viewTables.ne.appendCol(a[0]);this._viewTables.se.appendCol(a[1])}},_insertRow:function(h,e,f){var g=a.wijmo.wijgrid.rowType,d,c,b=this._viewTables;switch(h){case g.header:case g.filter:d=b.nw.ensureTHead();c=b.ne.ensureTHead();break;case g.footer:d=b.sw.ensureTFoot();c=b.se.ensureTFoot();break;default:if(e<=this._staticDataRowIndex){d=b.nw.ensureTBody();c=b.ne.ensureTBody()}else{e-=this._staticDataRowIndex+1;d=b.sw.ensureTBody();c=b.se.ensureTBody()}}return f?[d.appendChild(f),c.appendChild(f.cloneNode(false))]:[d.insertRow(e>d.rows.length?-1:e),c.insertRow(e>c.rows.length?-1:e)]},_rowRendered:function(c,e,d){var b=c.$rows[0],a=c.$rows[1];if(!b.cells.length&&this._isBodyRow(c)){b.parentNode.removeChild(b);b=null}if(!a.cells.length&&this._isBodyRow(c)){a.parentNode.removeChild(a);a=null}(b||a)&&this._base(c,e,d)},_appendCell:function(b,e,c){var d=b.type!==a.wijmo.wijgrid.rowType.header?this._staticColumnIndex:this._staticAllColumnIndex;if(e<=d)b.$rows[0].appendChild(c[0]);else b.$rows[1].appendChild(c[0])},_getRowHeight:function(b){if(b[0]&&b[1]){var e=[a(b[0]),a(b[1])],c,d;a.each(e,function(b,a){a.css("height","")});c=e[0].height();d=e[1].height();if(c>d)return c;else if(c<d)return d}return null},_setRowHeight:function(c,b){if(c[0]&&c[1]){var e=[a(c[0]),a(c[1])],d;if(b===null)return;b+=1;a.each(e,function(c,a){a.height(b);d=b-a.height();d&&a.height(b+d)})}},_adjustRowHeight:function(){var t=this._wijgrid,r=this._staticColumnIndex,s=t._field("visibleLeaves").length-1,b,d,k,g,m,h,n,i,o,j,p,f,a,q,c,e,l=[];if(r>-1&&r<s){b=this._staticRowIndex;d=this._rowsCountRaw()-1;k=this._viewTables;if(b>-1&&b<=d){g=k.ne.element();m=g.parentNode;h=k.nw.element();n=h.parentNode;c=h.rows;e=g.rows;f=c.length;for(a=0;a<f;a++)l.push(this._getRowHeight([c[a],e[a]]))}if(b>=-1&&b<d){i=k.se.element();o=i.parentNode;j=k.sw.element();p=j.parentNode;c=j.rows;e=i.rows;f=c.length;for(a=0;a<f;a++)l.push(this._getRowHeight([c[a],e[a]]))}if(b>-1&&b<=d){n.removeChild(h);m.removeChild(g)}if(b>=-1&&b<d){p.removeChild(j);o.removeChild(i)}if(b>-1&&b<=d){c=h.rows;e=g.rows;f=c.length;for(a=0,q=0;a<f;a++)this._setRowHeight([c[a],e[a]],l[q++])}if(b>=-1&&b<d){c=j.rows;e=i.rows;f=c.length;for(a=0;a<f;a++)this._setRowHeight([c[a],e[a]],l[q++])}if(b>-1&&b<=d){n.appendChild(h);m.appendChild(g)}if(b>=-1&&b<d){p.appendChild(j);o.appendChild(i)}}},_adjustRowsHeights:function(){var c=a(this._viewTables.sw.element()),b=a(this._viewTables.se.element()),d;b.css("height","");c.css("height","");this._adjustRowHeight();d=Math.max(b.height(),c.height());c.height(d);b.height(d)},_destroySuperPanel:function(){if(this._scroller.data("wijsuperpanel")){this.vsUI&&this.vsUI.dispose();this._scroller.wijsuperpanel("destroy")}},_onScroll:function(b,a){if(this._allowVirtualScrolling){if(a.dir==="h"){this._setFixedAreaPosition(this._getSuperPanel().getContentElement(),a.dir,a.position,a.animationOptions,false);this._setFixedAreaPosition(this._splitAreas.ne,a.dir,a.position,a.animationOptions,true)}}else this._setFixedAreaPosition(a.data==="h"?this._splitAreas.ne:this._splitAreas.sw,a.dir,a.position,a.animationOptions,true)},_onMouseWheel:function(b,f){var d,g=f>0?"top":"bottom",c=false,e;if(this._wijgrid._canInteract()){d=this.getFixedAreaVisibleBounds();a.each(d,function(e,d){if(d&&a.ui.isOver(b.pageY,b.pageX,d.top,d.left,d.height,d.width)){c=true;return false}});if(c&&this._scroller.data("wijsuperpanel")){e=this._scroller.wijsuperpanel("option","vScroller").scrollValue;this._scroller.wijsuperpanel("doScrolling",g);if(e!==this._scroller.wijsuperpanel("option","vScroller").scrollValue){b.stopPropagation();b.preventDefault()}}}},_setFixedAreaPosition:function(d,g,a,e,c){var f={},b;if(g==="h")b=c?"scrollLeft":"left";else b=c?"scrollTop":"top";if(!c)a=-a;if(e){f[b]=a;d.animate(f,e)}else if(c)d[0][b]=a;else d.css(b,a)},_testNeedVBar:function(h,i,n,d,k){var b,a=this._wijgrid,m=n.width()+a.options.splitDistanceX,f=i.height()+a.options.splitDistanceY,l=h.width(),j=h.height(),c,g=0,e=0;if(a.$superPanelHeader!==null)g=a.$superPanelHeader.outerHeight(true);if(a.$bottomPagerDiv!==null)e=a.$bottomPagerDiv.outerHeight(true);c=j-g-e;if(d==="both"||d==="vertical")b=true;else b=d==="auto"&&(f>c||!k&&m>l&&f>c-this._verScrollBarSize);return b},_updateSplitAreaBounds:function(e){var b=this._wijgrid,a=b.options,d,f,c=0,g=0;if(e===0||e===2){this._splitAreas.nw.width(a.splitDistanceX);this._splitAreas.sw.width(a.splitDistanceX);this._splitAreas.se.css("marginLeft",a.splitDistanceX);this._splitAreas.ne.css("marginLeft",a.splitDistanceX)}if(e===1||e===2){this._scroller.css("height","");this._splitAreas.se.css("marginTop",0);d=b.outerDiv.height();if(!b._autoHeight)this._scroller.height(d);else this._scroller.height(d+a.splitDistanceY);this._splitAreas.nw.height(a.splitDistanceY);this._splitAreas.ne.height(a.splitDistanceY);if(b.$superPanelHeader!==null)c=b.$superPanelHeader.outerHeight(true);if(b.$bottomPagerDiv!==null)g=b.$bottomPagerDiv.outerHeight(true);f=d-c-g;if(b.$superPanelHeader!==null){this._splitAreas.nw.css("top",c+"px");this._splitAreas.ne.css("top",c+"px")}if(!b._autoHeight)this._splitAreas.sw.height(f-a.splitDistanceY);else this._splitAreas.sw.height(f);this._splitAreas.sw.css("top",a.splitDistanceY+c);this._splitAreas.se.css("marginTop",a.splitDistanceY)}}})})(jQuery);(function(a){"use strict";a.wijmo.wijgrid.selection=function(b){var g=0,k,d=new a.wijmo.wijgrid.cellInfoOrderedCollection(b),c=new a.wijmo.wijgrid.cellInfoOrderedCollection(b),e=new a.wijmo.wijgrid.cellInfoOrderedCollection(b),f=new a.wijmo.wijgrid.cellInfoOrderedCollection(b),h=null,j=null,i={singlecell:[0,0,0],singlecolumn:[1,1,1],singlerow:[2,2,2],singlerange:[0,1,2],multicolumn:[1,1,1],multirow:[2,2,2],multirange:[0,1,2]};this.selectedCells=function(){return e};this.addColumns=function(b,a){if(!a&&a!==0)a=b;this.addRange(b,0,a,16777215)};this.addRange=function(c,f,e,g){if(!c&&arguments.length===1)throw"invalid argument";var d=arguments.length===4?new a.wijmo.wijgrid.cellInfoRange(new a.wijmo.wijgrid.cellInfo(c,f),new a.wijmo.wijgrid.cellInfo(e,g)):c._clone();d._normalize();if(!d._isValid())throw"invalid argument";this.beginUpdate();this._startNewTransaction(b._field("currentCell"));this._selectRange(d,false,true,0,null);this.endUpdate()};this.addRows=function(b,a){if(!a&&a!==0)a=b;this.addRange(0,b,16777215,a)};this.removeRange=function(c,f,e,g){if(!c&&arguments.length===1)throw"invalid argument";var d=arguments.length===4?new a.wijmo.wijgrid.cellInfoRange(new a.wijmo.wijgrid.cellInfo(c,f),new a.wijmo.wijgrid.cellInfo(e,g)):c._clone();d._normalize();if(!d._isValid())throw"invalid argument";this.beginUpdate();this._startNewTransaction(b._field("currentCell"));this._clearRange(d,0);this.endUpdate()};this.removeColumns=function(b,a){if(!a&&a!==0)a=b;this.removeRange(b,0,a,16777215)};this.removeRows=function(b,a){if(!a&&a!==0)a=b;this.removeRange(0,b,16777215,a)};this.addRows=function(b,a){if(!a&&a!==0)a=b;this.addRange(0,b,65535,a)};this.clear=function(){this.beginUpdate();c._clear();c._addFrom(e);this.endUpdate()};this.selectAll=function(){this.beginUpdate();this._selectRange(b._getDataCellsRange(),false,false,0,null);this.endUpdate()};this.beginUpdate=function(){g++};this.endUpdate=function(){if(g>0){g--;if(g===0){l();if(d.length()||c.length()){h!==null&&h.UnderlyingDataChanged();j!==null&&j.UnderlyingDataChanged();b._trigger("selectionChanged",null,{addedCells:d,removedCells:c})}d=new a.wijmo.wijgrid.cellInfoOrderedCollection(b);c._clear()}}};this._multipleRangesAllowed=function(){var a=b.options.selectionMode;return a&&((a=a.toLowerCase())==="multicolumn"||a==="multirow"||a==="multirange")};this._anchorCell=function(){return k};this._startNewTransaction=function(c){if(c){k=c._clone();f=new a.wijmo.wijgrid.cellInfoOrderedCollection(b)}};this._clearRange=function(g,l){var h=b.options.selectionMode.toLowerCase(),a,n,m,p,q,o,d,k,f,j=b._getDataCellsRange();if(g._isValid()&&h!=="none"&&e.length()>0){a=g._clone();a._normalize();a._clip(j);if(!g._isValid())return;a._extend(i[h][l],j);this.beginUpdate();for(d=0,k=e.length();d<k;d++){f=e.item(d);a._containsCellInfo(f)&&c._add(f)}this.endUpdate()}};this._selectRange=function(k,n,j,l,g){var e=b.options.selectionMode.toLowerCase(),d,h=b._getDataCellsRange();if(e!=="none"&&k._isValid()){d=k._clone();d._normalize();d._clip(h);if(!d._isValid())return;this.beginUpdate();if(!this._multipleRangesAllowed())this.clear();else if(n||j){if(j){c._clear();c._addFrom(f)}}else this.clear();switch(e){case"singlecell":case"singlecolumn":case"singlerow":d=g===null?new a.wijmo.wijgrid.cellInfoRange(d.topLeft(),d.topLeft()):new a.wijmo.wijgrid.cellInfoRange(g,g)}d._extend(i[e][l],h);m(d,true);this.endUpdate()}};function l(){var s=b._getDataToAbsOffset(),q=s.x,r=s.y,k=b._view(),h,l,g,j,i,p,t=a.wijmo.wijgrid.renderState,n,o,m=-1;for(h=0,l=c.length();h<l;h++){g=c.item(h);if(d.indexOf(g)<0){j=k.getCell(g.cellIndex()+q,g.rowIndex()+r);if(j){if(m!==g.rowIndex()){n=k._getRowInfo(g._row());m=g.rowIndex()}i=a(j);o=k._changeCellRenderState(i,t.selected,false);b.cellStyleFormatter.format(i,g.cellIndex(),g.column(),n,o)}e._remove(g);f._remove(g)}else{c._removeAt(h);h--;l--}}m=-1;for(h=0,l=d.length();h<l;h++){g=d.item(h);p=e.indexOf(g);if(p<0){j=k.getCell(g.cellIndex()+q,g.rowIndex()+r);if(j){if(m!==g.rowIndex()){n=k._getRowInfo(g._row());m=g.rowIndex()}i=a(j);o=k._changeCellRenderState(i,t.selected,true);b.cellStyleFormatter.format(i,g.cellIndex(),g.column(),n,o)}e._insertUnsafe(g,~p);f._add(g)}else{d._removeAt(h);h--;l--}}}function m(h,q){var l=h.topLeft().cellIndex(),n=h.topLeft().rowIndex(),m=h.bottomRight().cellIndex(),o=h.bottomRight().rowIndex(),i,e,f,g,p=b._view(),j,k;if(q){i=d.length();k=b._rows();for(e=n;e<=o;e++){j=p._getRowInfo(k.item(e));if(j.type&a.wijmo.wijgrid.rowType.data)for(f=l;f<=m;f++){g=new a.wijmo.wijgrid.cellInfo(f,e);if(i===0)d._appendUnsafe(g);else d._add(g)}}}else{i=c.length();for(e=n;e<=o;e++)for(f=l;f<=m;f++){g=new a.wijmo.wijgrid.cellInfo(f,e);if(i===0)c._appendUnsafe(g);else c._add(g)}}}};a.wijmo.wijgrid.cellInfoOrderedCollection=function(c){if(!c)throw"argument is null";var b=[];this.item=function(a){return b[a]};this.length=function(){return b.length};this.indexOf=function(e,h){if(arguments.length===1){h=e.rowIndex();e=e.cellIndex()}var d=0,g=b.length-1,c,f,a;while(d<=g){c=d+(g-d>>1);f=b[c];a=f.rowIndex()-h;if(a===0)a=f.cellIndex()-e;if(a<0)d=c+1;else if(a>0)g=c-1;else return c}return~d};this.toString=function(){var d="",a,c;for(a=0,c=b.length;a<c;a++)d+=b[a].toString()+"\n";return d};this._add=function(a){var d=this.indexOf(a);if(d<0){b.splice(~d,0,a);a._setGridView(c);return true}return false};this._addFrom=function(d){if(d){var e=d.length(),f=b.length,a;if(f===0){b.length=e;for(a=0;a<e;a++){b[a]=d.item(a);b[a]._setGridView(c)}}else for(a=0;a<e;a++)this._add(d.item(a))}};this._appendUnsafe=function(a){b[b.length]=a;a._setGridView(c)};this._insertUnsafe=function(c,a){b.splice(a,0,c)};this._clear=function(){b.length=0};this._remove=function(c){var a=this.indexOf(c);if(a>=0){b.splice(a,1);return true}return false};this._removeAt=function(a){b.splice(a,1)};this._getColumnsIndicies=function(){var e=[],d=b.length,c,a,f;if(d){c=[];for(a=0;a<d;a++)c[b[a].cellIndex()]=1;d=c.length;f=0;for(a=0;a<d;a++)if(c[a])e[f++]=a}return e};this._getSelectedRowsIndicies=function(){var f=[],d=b.length,c,a,e;if(d){c=[];for(a=0;a<d;a++)c[b[a].rowIndex()]=1;d=c.length;e=0;for(a=0;a<d;a++)if(c[a])f[e++]=a}return f};this._rectangulate=function(){var i=b.length,e=4294967295,g=4294967295,f=0,h=0,d,c;if(i){for(d=0;d<i;d++){c=b[d];e=Math.min(e,c.cellIndex());g=Math.min(g,c.rowIndex());f=Math.max(f,c.cellIndex());h=Math.max(h,c.rowIndex())}return new a.wijmo.wijgrid.cellInfoRange(new a.wijmo.wijgrid.cellInfo(e,g),new a.wijmo.wijgrid.cellInfo(f,h))}return null}}})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{selectionui:function(b){var q=10,u="{0}."+b.widgetName+".selectionui",d=new a.wijmo.wijgrid.cellInfoOrderedCollection(b),k,f,h,e,i=false,j=false,c=b._view(),t=b._field("visibleLeaves").length,r=c.focusableElement();r.bind(g("mousedown"),p);this.dispose=function(){r.unbind(g("mousedown"),p);l()};function p(e){if(!b._canInteract()||b.options.selectionMode.toLowerCase()==="none")return;var d=c.getVisibleAreaBounds(),g={x:e.pageX,y:e.pageY},i=e.target&&e.target.tagName!==undefined?e.target.tagName.toLowerCase():undefined,h=a(e.target);if((!i||h.is("td.wijgridtd, th.wijgridtd, div.wijmo-wijgrid-innercell"))&&g.x>d.left&&g.x<d.left+d.width&&g.y>d.top&&g.y<d.top+d.height){s();k=g;f=m(k)}}function n(C){if(!f||!f._isValid())return;var y={x:C.pageX,y:C.pageY},z,j,t,s,B,A,w,l,n,v,g,r,p,o,x,u=b._view(),E=b._rows(),D=a.wijmo.wijgrid.renderState;if(!i)i=Math.abs(k.x-y.x)>q||Math.abs(k.y-y.y)>q;if(i){z=m(y);if(!z._isValid())return;h=z;j=new a.wijmo.wijgrid.cellInfoRange(f,h);j._normalize();j._clip(b._getDataCellsRange());if(j._isValid()&&!j.isEqual(e)){t=b._getDataToAbsOffset();e=j;s=new a.wijmo.wijgrid.cellInfoOrderedCollection(b);B=j.bottomRight().rowIndex();A=j.bottomRight().cellIndex();for(w=j.topLeft().rowIndex();w<=B;w++){p=u._getRowInfo(E.item(w));if(p.type&a.wijmo.wijgrid.rowType.data)for(l=j.topLeft().cellIndex();l<=A;l++)s._appendUnsafe(new a.wijmo.wijgrid.cellInfo(l,w))}o=-1;for(n=0,v=d.length();n<v;n++){g=d.item(n);if(s.indexOf(g)<0){if(b.selection().selectedCells().indexOf(g)<0){l=c.getCell(g.cellIndex()+t.x,g.rowIndex()+t.y);if(l){if(o!==g.rowIndex()){p=u._getRowInfo(g._row());o=g.rowIndex()}r=a(l);x=u._changeCellRenderState(r,D.selected,false);b.cellStyleFormatter.format(r,g.cellIndex(),g.column(),p,x)}}d._removeAt(n);n--;v--}}o=-1;for(n=0,v=s.length();n<v;n++){g=s.item(n);if(d.indexOf(g)<0&&b.selection().selectedCells().indexOf(g)<0)if(d._add(g)){l=c.getCell(g.cellIndex()+t.x,g.rowIndex()+t.y);if(l){if(o!==g.rowIndex()){p=u._getRowInfo(g._row());o=g.rowIndex()}r=a(l);x=u._changeCellRenderState(r,D.selected,true);b.cellStyleFormatter.format(r,g.cellIndex(),g.column(),p,x)}}}}}}function o(k){l();if(i){i=false;if(e&&e._isValid()){b._changeCurrentCell(h);(!k.shiftKey||!b.selection()._multipleRangesAllowed()&&b.options.selectionMode.toLowerCase()!=="singleRange")&&b.selection()._startNewTransaction(f);b.selection().beginUpdate();b.selection()._selectRange(e,k.shiftKey,k.ctrlKey,0,h);b.selection().endUpdate();var n=b._view(),p=b._getDataToAbsOffset(),g,s,c,m,j,o=-1,q,r,t=a.wijmo.wijgrid.renderState;for(g=0,s=d.length();g<s;g++){c=d.item(g);if(b.selection().selectedCells().indexOf(c)<0){m=n.getCell(c.cellIndex()+p.x,c.rowIndex()+p.y);if(m!==null){if(o!==c.rowIndex()){q=n._getRowInfo(c._row());o=c.rowIndex()}j=a(m);r=n._changeCellRenderState(j,t.selected,false);b.cellStyleFormatter.format(j,c.cellIndex(),c.column(),q,r)}}}d._clear();f=h=e=null;return false}}}function s(){if(!j)try{c.toggleDOMSelection(false);a(document).bind(g("mousemove"),n).bind(g("mouseup"),o)}finally{j=true}}function l(){if(j)try{c.toggleDOMSelection(true);a(document).unbind(g("mousemove"),n).unbind(g("mouseup"),o)}finally{j=false}}function g(b){return a.wijmo.wijgrid.stringFormat(u,b)}function m(k){var f=0,g=t-1,d=0,m=-1,e,h=new a.wijmo.wijgrid.rowAccessor(c,2,0,0),i,j,l,n;while(f<=g){d=(g-f>>1)+f;e=a.wijmo.wijgrid.bounds(c.getHeaderCell(d));if(!e){j=h.item(0);e=a.wijmo.wijgrid.bounds(h.getCell(j,d))}if(!e)break;if(k.x<e.left)g=d-1;else if(k.x>e.left+e.width)f=d+1;else{m=d;break}}if(m===-1)return a.wijmo.wijgrid.cellInfo.prototype.outsideValue;h=new a.wijmo.wijgrid.rowAccessor(c,0,0,0);i=-1;f=0;g=h.length()-1;d=0;while(f<=g){d=(g-f>>1)+f;j=h.item(d);e=a.wijmo.wijgrid.bounds(h.getCell(j,0));if(k.y<e.top)g=d-1;else if(k.y>e.top+e.height)f=d+1;else{i=d;break}}if(i===-1)return a.wijmo.wijgrid.cellInfo.prototype.outsideValue;l=b._getDataToAbsOffset();n=new a.wijmo.wijgrid.cellInfo(m-l.x,i-l.y);n._clip(b._getDataCellsRange());return n}}})})(jQuery);(function(a){"use strict";a.wijmo.wijgrid.rowAccessor=function(f,e,h,g){var b=h,c=g,d;if(!b)b=0;if(!c)c=0;this.item=function(a){var c=this.length();return a<c?f.getJoinedRows(a+b,e):null};this.length=function(){var i=f.getJoinedTables(true,0),g=0,h;if(h=i[0])g=h.getSectionLength(e);if(h=i[1])g+=h.getSectionLength(e);g-=b+c;if(a.isFunction(d))g+=d(i);if(g<0)g=0;return g};this.iterateCells=function(d,e,j){if(d&&e){var i=0,b,h,a,c,f,g;for(b=0,h=d.length;b<h;b++){a=d[b];if(a)for(c=0,f=a.cells.length;c<f;c++){g=e(a.cells[c],i++,j);if(g!==true)return}}}};this.getCell=function(d,b){var a,c;if(d&&(a=d[0])){c=a.cells.length;if(b<c)return a.cells[b];b-=c;if(a=d[1]){c=a.cells.length;if(b<c)return a.cells[b]}}return null};this.cellsCount=function(b){var c=0,a;if(b&&(a=b[0])){c=a.cells.length;if(a=b[1])c+=a.cells.length}return c};this._offsetBottom=function(a){if(arguments.length)c=a;return c};this._offsetTop=function(a){if(arguments.length)b=a;return b};this._lengthAdjuster=function(a){if(arguments.length)d=a;return d}}})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{cellEditorHelper:function(){this.currentCellEditStart=function(e,k){var g=false,b=e.currentCell(),j=e._view(),d,h,f,i;if(b._isValid()&&!b._isEdit()&&b.column().dataIndex>=0){d=b._row();if(d&&d.length){i=j._getRowInfo(d).type;if(i&a.wijmo.wijgrid.rowType.data){h={cell:b,event:k,handled:false};if(g=e._trigger("beforeCellEdit",null,h))if(!h.handled)g=c(e,h);if(g){b._isEdit(true);if(e.options.showRowHeader){f=a(d[0].cells[0]).children("div.wijmo-wijgrid-innercell");if(f.length){f.empty();f.append(a("<div>&nbsp;</div>").addClass("ui-icon ui-icon-pencil"))}}}}}}return g};this.currentCellEditEnd=function(f,k){var c=f.currentCell(),g=false,o=f._view(),i,n,l,b,h,j,m;if(!c._isValid()||!c._isEdit())return;i=c._row();if(i&&i.length){n=o._getRowInfo(i).type;if(!(n&a.wijmo.wijgrid.rowType.data))return g;l=k&&k.which===a.ui.keyCode.ESCAPE;if(!k||!l){b={cell:c,value:undefined};if(g=f._trigger("beforeCellUpdate",null,b)){if(b.value===undefined)b.value=e(f,c);h=b.value;try{b.value=f._parse(c.column(),b.value);h=b.value}catch(p){b.value=h}j=c.value();if(b.cell.column().dataType==="datetime"){if(h instanceof Date)h=h.getTime();if(j instanceof Date)j=j.getTime()}if(h!==j){try{c.value(b.value)}catch(p){g=false;f._trigger("invalidCellValue",null,{cell:c,value:b.value})}g&&f._trigger("afterCellUpdate",null,{cell:c})}}}else g=true;if(g){b={cell:c,event:k,handled:false};f._trigger("afterCellEdit",null,b);a(f._view().focusableElement()).focus();if(!b.handled)g=d(f,b);g&&c._isEdit(false);f.options.showRowHeader&&a(i[0].cells[0]).children("div.wijmo-wijgrid-innercell").html("&nbsp;");window.setTimeout(function(){if(!f.destroyed){c=f.currentCell();b.cell.isEqual(c)&&(m=c.tableCell())&&a(m).focus()}},50)}}return g};function c(k,d){var j=d.cell.column(),h=false,f,g,c,i,e;if(j.dataIndex>=0){f=d.cell.value();h=true;try{g=d.cell.container();if(j.dataType==="boolean"){c=g.children("input");c.focus();if(d.event&&d.event.type==="keypress")c.one("keyup",function(b){if(b.which===a.ui.keyCode.SPACE){b.preventDefault();c[0].checked=!f}})}else{c=a("<input />").attr("type","text").addClass("wijgridinput wijmo-wijinput ui-state-focus").bind("keydown",k,b);c.bind(a.support.selectstart?"selectstart":"mousedown",function(a){a.stopPropagation()});if(d.event&&d.event.type==="keypress"&&d.event.which)c.val(String.fromCharCode(d.event.which));else switch(d.cell.column().dataType){case"currency":case"number":if(f!==null){c.val(f);break}default:c.val(k._toStr(d.cell.column(),f))}g.empty().append(c);i=c.val().length;new a.wijmo.wijgrid.domSelection(c[0]).setSelection({start:i,end:i});c.focus();a.browser.msie&&setTimeout(function(){c.focus()},0);if(a.browser.mozilla&&document.createEvent&&c[0].dispatchEvent){e=document.createEvent("KeyboardEvent");e.initKeyEvent("keypress",false,true,null,false,false,false,false,0,a.ui.keyCode.SPACE);c[0].dispatchEvent(e);e=document.createEvent("KeyboardEvent");e.initKeyEvent("keypress",false,true,null,false,false,false,false,a.ui.keyCode.BACKSPACE,0);c[0].dispatchEvent(e)}}}catch(l){alert(l.message);h=false}}return h}function d(c,b){var a=b.cell.column(),f=false,d,e,g,h,i;if(a.dataIndex>=0){f=true;i=c._view();try{d=b.cell.container();e=c._toStr(a,b.cell.value());h=i._getRowInfo(c._rows().item(b.cell.rowIndex()));if(a.dataType==="boolean"){g=d.children("input");if(e==="true")g.attr("checked","checked");else g.removeAttr("checked")}else c.cellFormatter.format(d,a,e,h)}catch(j){alert("defaultAfterCellEdit: "+j.message);f=false}}return f}function b(b){if(b.which===a.ui.keyCode.ENTER){var c=b.data;if(c){c._endEditInternal(b);return false}}}function e(d,c){var a=c.container().find(":input:first"),b=null;if(a.length)b=a.attr("type")==="checkbox"?a[0].checked:a.val();return b}}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{resizer:function(h){var i=[],t=10,s=1,v="{0}."+h.widgetName+".resizer",e=false,b=null,r,f=null,d=null,g=null;this.addElement=function(a){if(a&&a.element){a.element.bind(c("mousemove"),q).bind(c("mousedown"),p).bind(c("mouseout"),j);i.push(a)}};this.dispose=function(){a.each(i,function(b,a){a.element.unbind(c("mousemove"),q).unbind(c("mousedown"),p).unbind(c("mouseout"),j)});m()};this.inProgress=function(){return e};function q(c){if(!e){var a=o({x:c.pageX,y:c.pageY});if(a&&a._canSize()&&h._canInteract()){a.element.css("cursor","e-resize");b=a;c.stopPropagation()}else j(c)}}function j(){if(!e)if(b){b.element.css("cursor","");b=null}}function p(c){b=o({x:c.pageX,y:c.pageY});if(b&&b._canSize()&&h._canInteract())try{b.element.css("cursor","");r=document.body.style.cursor;document.body.style.cursor="e-resize";f=d=a.wijmo.wijgrid.bounds(b.element);g=a('<div class="wijmo-wijgrid-resizehandle ui-state-highlight">&nbsp;</div>');var i=h._view().getVisibleAreaBounds();g.css({left:c.pageX,top:f.top,height:i.height+i.top-f.top});a(document.body).append(g)}finally{u();e=true;c.stopPropagation()}}function k(a){var b=s*Math.round((a.pageX-d.left)/s);d={left:d.left+b,top:a.pageY};g.css("left",d.left)}function l(){try{document.body.style.cursor=r;g.remove();f!==d&&h._fieldResized(b,f.width,d.left-f.left)}finally{b=null;g=null;m();e=false}}function n(a){a.preventDefault()}function u(){if(!e){a(document).bind(c("mousemove"),k).bind(c("mouseup"),l);a(document.body).disableSelection();a.browser.msie&&a(document.body).bind("selectstart",n)}}function m(){if(e){a(document).unbind(c("mousemove"),k).unbind(c("mouseup"),l);a(document.body).enableSelection();a.browser.msie&&a(document.body).unbind("selectstart",n)}}function o(e){var c,f,d,b,g;for(c=0,f=i.length;c<f;c++){d=i[c];b=a.wijmo.wijgrid.bounds(d.element);g=a.ui.isOver(e.y,e.x,b.top,b.left+b.width-t,b.height,t);if(g)return d}return null}function c(b){return a.wijmo.wijgrid.stringFormat(v,b)}}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{frozener:function(b){var s,r,z,y,F="{0}."+b.widgetName+".frozener",d=false,x,f=null,e=null,h=null,g=null,n=a('<div class="wijmo-wijgrid-frozener-v ui-widget-header"></div>'),m=a('<div class="wijmo-wijgrid-frozener-h ui-widget-header"></div>'),k=null,j=null,c=b.outerDiv.find(".wijmo-wijgrid-fixedview"),l=10;this.refresh=function(){this.dispose();this.addVElement(b._getStaticIndex(false));this.addHElement(b._getStaticIndex(true));this.attachDivEvent()};this.attachDivEvent=function(){c.bind("mousemove",u).bind("mouseout",q).bind("mousedown",t)};this.addVElement=function(h){var e=a.wijmo.wijgrid.bounds(c.find(".wijmo-wijgrid-split-area-nw")),f=a.wijmo.wijgrid.bounds(c),d=b._view().getVisibleAreaBounds(),g=e.left+e.width;if(g<=d.left+d.width){n.css({left:g-f.left-1,top:e.top-f.top,width:"0px",height:d.height+d.top-e.top}).appendTo(c);s=b._getRealStaticColumnIndex(true);z=h}};this.addHElement=function(h){var e=a.wijmo.wijgrid.bounds(c.find(".wijmo-wijgrid-split-area-nw")),f=a.wijmo.wijgrid.bounds(c),d=b._view().getVisibleAreaBounds(),g=e.top+e.height;if(g<=d.top+d.height){m.css({left:e.left-f.left,top:g-f.top-1,width:d.width+d.left-e.left,height:"0px"}).appendTo(c);r=b._getRealStaticRowIndex(true);y=h}};this.dispose=function(){n.remove();m.remove();c.unbind("mousemove",u).unbind("mouseout",q).unbind("mousedown",t);v()};this.inProgress=function(){return d};function u(f){var e,h,g=b._view().getVisibleAreaBounds();if(!d)if(b._canInteract()&&a.ui.isOver(f.pageY,f.pageX,g.top,g.left,g.height,g.width)){e=a.wijmo.wijgrid.bounds(n);h=e.left+e.width/2;if(Math.abs(f.pageX-h)<l){c.css("cursor","pointer");return}e=a.wijmo.wijgrid.bounds(m);h=e.top+e.height/2;if(Math.abs(f.pageY-h)<l){c.css("cursor","pointer");return}q(f)}}function q(){!d&&c.css("cursor","")}function t(i){var o,q,t,p=b._view().getVisibleAreaBounds();if(b._canInteract()&&a.ui.isOver(i.pageY,i.pageX,p.top,p.left,p.height,p.width)){o=a.wijmo.wijgrid.bounds(n);q=o.left+o.width/2;if(Math.abs(i.pageX-q)<l){if(z===-1)f=h=-1;else f=h=b._getRealStaticColumnIndex()-s;k=a('<div class="wijmo-wijgrid-resizehandle ui-widget-header"></div>');i.data={bVertical:true};a(document.body).append(k)}else{o=a.wijmo.wijgrid.bounds(m);q=o.top+o.height/2;if(Math.abs(i.pageY-q)<l){if(y===-1)e=g=-1;else e=g=b._getRealStaticRowIndex()-r;j=a('<div class="wijmo-wijgrid-resizehandle ui-widget-header"></div>');i.data={bVertical:false};a(document.body).append(j)}}if(i.data){c.css("cursor","");x=document.body.style.cursor;document.body.style.cursor="pointer";B(i.data);d=true}}}function o(c){var a=b._view()._getSuperPanel();if(c.data.bVertical&&a.options.hScroller.scrollValue)a.hScrollTo(0);else!c.data.bVertical&&a.options.vScroller.scrollValue&&a.vScrollTo(0);G(c)}function p(a){try{document.body.style.cursor=x;if(a.data.bVertical){k.remove();f!==h&&b.option("staticColumnIndex",h)}else{j.remove();e!==g&&b.option("staticRowIndex",g)}}finally{if(a.data.bVertical)k=null;else j=null;v();d=false}}function w(a){a.preventDefault()}function B(b){if(!d){if(b.bVertical)a(document).bind(i("mousemove"),{bVertical:true},o).bind(i("mouseup"),{bVertical:true},p);else a(document).bind(i("mousemove"),{bVertical:false},o).bind(i("mouseup"),{bVertical:false},p);a(document.body).disableSelection();a.browser.msie&&a(document.body).bind("selectstart",w)}}function v(){if(d){a(document).unbind(i("mousemove"),o).unbind(i("mouseup"),p);a(document.body).enableSelection();a.browser.msie&&a(document.body).unbind("selectstart",w)}}function G(d){var i,c,p,t,q,u,v,w,o=b._view().getVisibleAreaBounds();if(d.data.bVertical){c=a.wijmo.wijgrid.bounds(n);p=c.left+c.width/2;if(Math.abs(d.pageX-p)<l){h=f;k.hide();return}i=D({x:d.pageX,y:d.pageY});if(i){c=a.wijmo.wijgrid.bounds(i.element);p=c.left+c.width/2;q=i.options.visLeavesIdx-s;u=A(q);t=d.pageX<p?u!==f:q===f;v=t?c.left:c.left+c.width;if(!a.ui.isOverAxis(v,o.left-1,o.width+2))return;h=t?u:q;k.show().css({left:v,top:c.top,width:3,height:o.height+o.top-c.top})}}else{c=a.wijmo.wijgrid.bounds(m);p=c.top+c.height/2;if(Math.abs(d.pageY-p)<l){g=e;j.hide();return}i=E({x:d.pageX,y:d.pageY});if(i){c=a.wijmo.wijgrid.bounds(i);p=c.top+c.height/2;q=b._view().getAbsoluteRowIndex(i)-r;u=C(q);t=d.pageY<p?u!==e:q===e;w=t?c.top:c.top+c.height;if(!a.ui.isOverAxis(w,o.top-1,o.height+2))return;g=t?u:q;j.show().css({left:c.left,top:w,width:o.width+o.left-c.left,height:3})}}}function A(a){return a>-1?a-1:-1}function C(a){return a>-1?a-1:-1}function D(i){for(var g=b.columns(),f=0,j=g.length,c,d,e,h;f<j;f++){c=g[f];d=c.options;if(d.visible&&d.parentVis&&d.isLeaf){e=a.wijmo.wijgrid.bounds(c.element);h=a.ui.isOverAxis(i.x,e.left,e.width);if(h)return c}}return null}function E(i){for(var f=b._rows(),h=f.length(),d=0,e,c,g;d<h;d++){e=f.item(d)[0];c=a.wijmo.wijgrid.bounds(a(e));g=a.ui.isOverAxis(i.y,c.top,c.height);if(g)return e}return null}function i(b){return a.wijmo.wijgrid.stringFormat(F,b)}}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{cellFormatterHelper:function(){this.format=function(j,c,g,i){if(i.type&a.wijmo.wijgrid.rowType.footer)if(c.aggregate&&c.aggregate!=="none")g=a.wijmo.wijgrid.stringFormat(c.footerText||"{0}",c._totalsValue||"");else g=c.footerText||c._footerTextDOM||"";var h=true,f=null,e={$container:j,column:c,formattedValue:g,row:i,afterDefaultCallback:null};if(a.isFunction(c.cellFormatter))h=!c.cellFormatter(e);if(h){switch(c.dataType){case"boolean":f=d;break;default:f=b}if(f){f(e);a.isFunction(e.afterDefaultCallback)&&e.afterDefaultCallback(e)}}};function b(b){switch(b.row.type){case a.wijmo.wijgrid.rowType.filter:c(b);break;default:b.$container.html(b.formattedValue?b.formattedValue:"&nbsp;")}}function d(c){var d,f,h="disabled='disabled'",e,g,i=a.wijmo.wijgrid.rowType;switch(c.row.type){case i.data:case i.data|i.dataAlt:d=c.column.owner;f=d.options.allowEditing&&c.column.readOnly!==true;if(f)h="";if(d._parse(c.column,c.row.data[c.column.dataKey])===true)c.$container.html("<input class='wijgridinput' type='checkbox' checked='checked' "+h+" />");else c.$container.html("<input class='wijgridinput' type='checkbox' "+h+" />");f&&c.$container.children("input").bind("mousedown",function(){e=c.$container.parent()[0];g=d.currentCell();g.tableCell()!==e&&d._onClick({target:e});!g._isEdit()&&d.beginEdit()}).bind("keydown",function(b){if(b.which===a.ui.keyCode.ENTER){d._endEditInternal(b);return false}});break;default:b(c)}}function c(a){a.$container.addClass("ui-widget ui-state-default");if(a.column.dataIndex>=0&&!a.column.isBand&&a.column.showFilter)a.$container.html('<div class="wijmo-wijgrid-filter ui-corner-all"><input type="text" class="wijmo-wijgrid-filter-input" style="width:1px" /><a class="wijmo-wijgrid-filter-trigger ui-corner-right ui-state-default" href="#"><span class="ui-icon ui-icon-triangle-1-s"></span></a></div>');else a.$container.html("&nbsp;")}}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{dragAndDropHelper:function(c){var i="scope_"+ +new Date,d=null,e=null,b=null,g=false,h,p='<div class="ui-widget wijmo-wijgrid ui-widget-content ui-corner-all"><table class="wijmo-wijgrid-root wijmo-wijgrid-table"><tr class="wijmo-wijgrid-headerrow"></tr></table></div>';this.attachGroupArea=function(e){var d;e.droppable({scope:i,tolerance:"pointer",greedy:true,accept:function(b){if(c.options.allowColMoving){d=f(b);if(d)return d instanceof a.wijmo.c1groupedfield&&d.options.groupedIndex===c._field("groupedColumns").length-1?false:!d.options.isBand&&(d.options.groupedIndex===undefined||d instanceof a.wijmo.c1groupedfield)}return false},drop:function(b,a){if(!l(b,a.draggable)&&(d=f(a.draggable)))g=true},over:function(){var a=c._field("groupedWidgets").length;h=a>0;b=a>0?c._field("groupedWidgets")[a-1]:e;e.data("thisDroppableWijField",b)},out:function(){if(b===e.data("thisDroppableWijField"))b=null}})};this.attach=function(d){var e,j;if(!d||!(e=d.element))return;e.draggable({helper:function(){return d instanceof a.wijmo.c1groupedfield?e.clone().addClass("wijmo-wijgrid-dnd-helper"):e.clone().wrap(p).width(e.width()).height(e.height()).closest(".wijmo-wijgrid").addClass("wijmo-wijgrid-dnd-helper")},appendTo:"body",scope:i,drag:function(c,f){m();if(b&&!l(c,e)){var a=b.element;if(!a)a=b;o(a,k(d,b,c,f))}},start:function(){if(c._canInteract()&&c.options.allowColMoving&&!c._field("resizer").inProgress()){var b=d.options,g=d.options.travIdx,e=d instanceof a.wijmo.c1groupedfield,f=e?"groupArea":"columns";if(e){b=a.wijmo.wijgrid.search(c.columns(),function(a){return a.options.travIdx===g});b=!b.found?a.wijmo.wijgrid.getColumnByTravIdx(c.options.columns,g).found:b.found.options}if(d._canDrag()&&c._trigger("columnDragging",null,{drag:b,dragSource:f})){c._trigger("columnDragged",null,{drag:b,dragSource:f});return true}}return false},stop:function(f,e){m();try{if(g)if(!b.element)c._handleDragnDrop(d.options.travIdx,-1,"left",d instanceof a.wijmo.c1groupedfield,true);else c._handleDragnDrop(d.options.travIdx,b.options.travIdx,k(d,b,f,e),d instanceof a.wijmo.c1groupedfield,b instanceof a.wijmo.c1groupedfield)}finally{b=null;g=false}}}).droppable({hoverClass:"ui-state-hover",scope:i,tolerance:"pointer",greedy:true,accept:function(a){if(c.options.allowColMoving)if(e[0]!==a[0]){j=f(a);if(j)return j._canDropTo(d)}return false},drop:function(b,a){if(j=f(a.draggable))g=true},over:function(){h=false;b=d;e.data("thisDroppableWijField",b)},out:function(){if(b===d.element.data("thisDroppableWijField"))b=null}})};this.detach=function(b){var a;if(b&&(a=b.element)){a.data("draggable")&&a.draggable("destroy");a.data("droppable")&&a.droppable("destroy")}};this.dispose=function(){if(e){e.remove();e=null}if(d){d.remove();d=null}};function f(b){var c=b.data(a.wijmo.c1basefield.prototype._data$prefix+"widgetName");return!c?b.data(a.wijmo.c1groupedfield.prototype._data$prefix):b.data(c)}function o(a,b){n().show().position({my:"center",at:b+" top",of:a});j().show().position({my:"center",at:b+" bottom",of:a})}function m(){n().hide();j().hide()}function n(){if(!e)e=a("<div />").addClass("wijmo-wijgrid-dnd-arrow-top").append(a("<span />").addClass("ui-icon ui-icon-arrowthick-1-s")).hide().appendTo(document.body);return e}function j(){if(!d)d=a("<div />").addClass("wijmo-wijgrid-dnd-arrow-bottom").append(a("<span />").addClass("ui-icon ui-icon-arrowthick-1-n")).hide().appendTo(document.body);return d}function l(c,d){var b=a.wijmo.wijgrid.bounds(d,false);return c.pageX>b.left&&c.pageX<b.left+b.width&&c.pageY>b.top&&c.pageY<b.top+b.height}function k(e,b,i){if(!b.element)return"left";if(h)return"right";var f=a.wijmo.wijgrid.bounds(b.element,false),j=f.width/6,g=f.left+f.width/2,d="right",c;if(i.pageX<g)d="left";if(b instanceof a.wijmo.c1groupedfield){if(e instanceof a.wijmo.c1groupedfield){c=b.options.groupedIndex-e.options.groupedIndex;if(Math.abs(c)===1)d=c<0?"left":"right"}return d}c=b.options.linearIdx-e.options.linearIdx;if(b.options.isBand&&e.options.parentIdx!==b.options.travIdx&&Math.abs(i.pageX-g)<j)return"center";if(e.options.parentIdx===b.options.parentIdx&&Math.abs(c)===1)d=c<0?"left":"right";return d}}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{cellStyleFormatterHelper:function(b){if(!b)throw"invalid arguments";this.format=function(q,l,i,m,j,h,p){var k=a.wijmo.wijgrid.renderState,o=a.wijmo.wijgrid.rowType,n=m.type,f,g=null;if(l===0&&b.options.showRowHeader)i=null;if(n===o.groupHeader||n===o.groupFooter){i=null;if(h&&(g=h.groupInfo)){i=b._field("leaves")[g.leafIndex];delete h.groupInfo}}f={$cell:q,state:j,row:m,column:i,_cellIndex:l,_purpose:g?g.purpose:undefined};if(j===k.rendering)c(f,h,p);else{e(f,j&k.current);d(f,j&k.selected)}a.isFunction(b.options.cellStyleFormatter)&&b.options.cellStyleFormatter(f)};function c(c,i,g){var f=a.wijmo.wijgrid.rowType,d,j,e=c.column,h=c.row.type;switch(h){case f.header:c.$cell.addClass("wijgridth");break;default:c.$cell.addClass("wijgridtd")}if(i)for(d in i)if(i.hasOwnProperty(d)){j=i[d];if((d==="colSpan"||d==="rowSpan")&&!(j>1))continue;if(d==="class")c.$cell.addClass(j);else c.$cell.attr(d,j)}if(g)for(d in g)if(g.hasOwnProperty(d)){if(d==="paddingLeft"){c.$cell.children(".wijmo-wijgrid-innercell").css(d,g[d]);continue}c.$cell.css(d,g[d])}if(c._cellIndex===0&&b.options.showRowHeader)c.$cell.attr({role:"rowheader",scope:"row"}).addClass("ui-state-default ui-widget-content wijmo-wijgrid-rowheader");else switch(h){case f.header:c.$cell.attr({role:"columnheader",scope:"col"});break;case f.footer:c.$cell.attr({role:"columnfooter",scope:"col"});break;default:c.$cell.attr("role","gridcell")}if(h&f.data)if(c._cellIndex>=0&&e&&e.dataParser){c.$cell.attr("headers",escape(e.headerText));e.readOnly&&c.$cell.attr("aria-readonly",true);e.dataIndex>=0&&c.$cell.addClass("wijdata-type-"+(e.dataType||"string"))}if(h===f.groupHeader||h===f.groupFooter)e&&c._purpose===a.wijmo.wijgrid.groupRowCellPurpose.aggregateCell&&c.$cell.addClass("wijdata-type-"+(e.dataType||"string"))}function e(b,d){var c=a.wijmo.wijgrid.rowType;if(d){b.$cell.addClass("ui-state-active");if(b.row.type===c.header)b.$cell.addClass("wijmo-wijgrid-current-headercell");else b.$cell.addClass("wijmo-wijgrid-current-cell")}else{b.$cell.removeClass("ui-state-active");if(b.row.type===c.header)b.$cell.removeClass("wijmo-wijgrid-current-headercell");else b.$cell.removeClass("wijmo-wijgrid-current-cell")}}function d(a,b){if(b)a.$cell.addClass("ui-state-highlight").attr("aria-selected","true");else a.$cell.removeClass("ui-state-highlight").removeAttr("aria-selected")}}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{rowStyleFormatterHelper:function(b){if(!b)throw"invalid arguments";this.format=function(j,l,k){var i=a.wijmo.wijgrid.renderState,m=a.wijmo.wijgrid.rowType,h=j.state,g=j;if(h===i.rendering)c(g,l,k);else{e(g,h&i.current);f(g,h&i.hovered);d(g,h&i.selected)}j.type!==m.fooRow&&a.isFunction(b.options.rowStyleFormatter)&&b.options.rowStyleFormatter(g)};function c(e,f,h){var b="wijmo-wijgrid-row ui-widget-content",g="wijmo-wijgrid-row ui-widget-content",c=a.wijmo.wijgrid.rowType,d;e.$rows.attr("role","row");if(f)for(d in f)if(f.hasOwnProperty(d))if(d==="class")e.$rows.addClass(f[d]);else e.$rows.attr(d,f[d]);if(h)for(d in h)h.hasOwnProperty(d)&&e.$rows.css(d,h[d]);switch(e.type&~c.dataAlt){case c.header:b="wijmo-wijgrid-headerrow";break;case c.data:b=g+" wijmo-wijgrid-datarow";if(e.type&c.dataAlt)b+=" wijmo-wijgrid-alternatingrow";break;case c.emptyDataRow:b=g+" wijmo-wijgrid-emptydatarow";break;case c.filter:b="wijmo-wijgrid-filterrow";break;case c.fooRow:b="wijmo-wijgrid-foorow";e.$rows.css({height:0,"font-size":0,visibility:"hidden"}).find(">td, >th").css({height:0,"border-top":0,"border-bottom":0}).find(">div.wijmo-wijgrid-innercell").css({"padding-top":0,"padding-bottom":0});break;case c.groupHeader:b=g+" wijmo-wijgrid-groupheaderrow";break;case c.groupFooter:b=g+" wijmo-wijgrid-groupfooterrow";break;case c.footer:b="wijmo-wijgrid-footerrow ui-state-highlight";break;default:throw a.wijmo.wijgrid.stringFormat("unknown rowType: {0}",e.row.type);}e.$rows.addClass(b)}function e(c,d){if(b.options.showRowHeader)if(d)a(c.$rows[0].cells[0]).addClass("ui-state-active wijmo-wijgrid-current-rowheadercell");else a(c.$rows[0].cells[0]).removeClass("ui-state-active wijmo-wijgrid-current-rowheadercell")}function f(a,b){if(b)a.$rows.addClass("ui-state-hover");else a.$rows.removeClass("ui-state-hover")}function d(b,a){a}}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{tally:function(){var j=0,l=0,a=0,b=0,k=0,h=0,i=0,d,c,g=0,f=0;this.add=function(e){if(e===null||e==="")return;var m,n=e instanceof Date?"datetime":typeof e;m=e.toString();if(b++===0)d=c=m;if(m<d)d=m;if(m>c)c=m;if(n==="number"){if(a++===0)i=h=e;j+=e;l+=e*e;if(e<i)i=e;if(e>h)h=e}else if(n==="datetime"){m=e.getTime();if(k++===0)g=f=m;if(m<g)g=m;if(m>f)f=m}};this.getValueString=function(h){var i=h.owner;if(a&&(h.dataType==="number"||h.dataType==="currency")){var j=e(h.aggregate);return i._toStr(h,j)}if(k&&h.dataType==="datetime")switch(h.aggregate){case"max":return i._toStr(h,new Date(f));case"min":return i._toStr(h,new Date(g));case"count":return b+""}if(b)switch(h.aggregate){case"max":return c;case"min":return d;case"count":return b+""}return""};function e(d){switch(d){case"average":return a===0?0:j/a;case"count":return b;case"max":return h;case"min":return i;case"sum":return j;case"std":return a<=1?0:Math.sqrt(e("var"));case"stdPop":return a<=1?0:Math.sqrt(e("varPop"));case"var":return a<=1?0:e("varPop")*a/(a-1);case"vapPop":if(a<=1)return 0;var c=j/a;return l/a-c*c}return 0}}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{columnsGenerator:function(){this.generate=function(f,b,e){switch(f){case"append":c(b,e);break;case"merge":d(b,e);break;default:throw a.wijmo.wijgrid.stringFormat('Unsupported value: "{0}"',f);}};function c(f,g){var c=f.getFieldNames(),a,e,d;for(a=0,e=c.length;a<e;a++){d=b(c[a]);g.push(d)}}function d(l,i){var g=[],h=l.getFieldNames(),d={},e,k,c,j,f;for(e=0,k=h.length;e<k;e++)d[j=h[e]]=j;a.wijmo.wijgrid.traverse(i,function(b){if(b.isLeaf&&!b.isBand){c=b.dataKey;if(a.wijmo.wijgrid.validDataKey(c)){if(d[c]!==undefined)delete d[c]}else c!==null&&g.push(b)}});if(g.length){e=0;for(c in d)if(d.hasOwnProperty(c)){f=g[e++];if(f){f.dataKey=d[c];delete d[c]}}}for(c in d)if(d.hasOwnProperty(c)){f=b(d[c]);i.push(f)}}function b(b){return a.wijmo.wijgrid.createDynamicField({dataKey:b})}}})})(jQuery);(function(a){"use strict";a.extend(a.wijmo.wijgrid,{virtualScrollerUI:function(d,o,n){var b=0,p=25,i=d._view(),q,g,c,f=d._totalRowsCount(),h=d.outerDiv.height()+f*20;o.height(h);i._splitAreas.sw.height(h);this.attach=function(b){g=b;q=b.find(".wijmo-wijsuperpanel-contentwrapper:first");c=b.data("wijsuperpanel");var d,e=c.getContentElement().height(),h=100/(f-1)*((e-b.height()+n)/e);d=c.options.vScroller;d.scrollSmallChange=h;c.option("vScroller",d);b.bind("wijsuperpanelscrolled.wijgrid",a.proxy(l,this));b.bind("wijsuperpanelscrolling.wijgrid",a.proxy(k,this))};this.dispose=function(){g.unbind(".wijgrid");e()};function e(){window.clearTimeout(b);b=0}function k(c,a){return a.dir!=="v"?void 0:b===-1?false:void 0}function l(g,a){if(a.dir!=="v")return;b>0&&e();if(b!==-1)b=window.setTimeout(function(){b=-1;var g=Math.round(a.newValue/c.options.vScroller.scrollSmallChange),h=i._bounds.start;if(g<0)g=0;if(g>=f)g=f-1;if(g!==h)d._handleVirtualScrolling(g,m);else{j();e()}},p)}function m(){j();e()}function j(){if(window.console){var a=d._view()._bounds;window.console.log("bounds: ["+a.start+", "+a.end+"], scrollTo: "+a.start)}}}})})(jQuery);
(function(){"use strict";if(!window.Raphael)return;$.extend({round:function(a,b){return!a?0:Globalize.parseFloat(a.toFixed(b),10,Globalize.culture("en"))},toOADate:function(b){var c=864e5,a=b-new Date(1900,0,1)+2*c;return a},fromOADate:function(a){var c=864e5,b=new Date(a-2*c+ +new Date(1900,0,1));return b},arrayClone:function(b){var a=[];$.each(b,function(c,b){a.push($.extend(true,{},b))});return a}});$.wijraphael={isSVGElem:function(a){var b="http://www.w3.org/2000/svg";return a.nodeType===1&&a.namespaceURI===b},addClass:function(b,a){a=a||"";$.each(b,function(){if($.wijraphael.isSVGElem(this)){var b=this;$.each(a.split(/\s+/),function(d,c){var a=b.className?b.className.baseVal:b.getAttribute("class");if($.inArray(c,a.split(/\s+/))===-1){a+=(a?" ":"")+c;if(b.className)b.className.baseVal=a;else b.setAttribute("class",a)}})}else $(this).addClass(a)})},clearRaphaelCache:function(){Raphael.path2curve.cache=null;Raphael.path2curve.count=null;Raphael.parseTransformString.cache=null;Raphael.parseTransformString.count=null;Raphael.parsePathString.cache=null;Raphael.parsePathString.count=null;Raphael._pathToAbsolute.cache=null;Raphael._pathToAbsolute.count=null},getPositionByAngle:function(e,f,c,d){var a={},b=Raphael.rad(d);a.x=e+c*Math.cos(-1*b);a.y=f+c*Math.sin(-1*b);return a},hasClass:function(a,b){if(!b||b.length===0)return false;if($.wijraphael.isSVGElem(a)){var d=a.className?a.className.baseVal:a.getAttribute("class"),c=false;$.each(d.split(/\s+/),function(d,a){if(a===b){c=true;return false}});return c}else return $(a).hasClass(b)},sector:function(b,c,a,d,e){var f=$.wijraphael.getPositionByAngle(b,c,a,d),g=$.wijraphael.getPositionByAngle(b,c,a,e);return["M",b,c,"L",f.x,f.y,"A",a,a,0,+(e-d>180),0,g.x,g.y,"z"]}};var a="[\\x20\\t\\r\\n\\f]",b=$.expr.filter.CLASS;$.expr.filter.CLASS=function(b,e){if(parseFloat($.fn.jquery)<1.8){var c=!($.wijraphael&&$.wijraphael.isSVGElem(b))?b.className:b.className?b.className.baseVal:b.getAttribute("class");return(" "+c+" ").indexOf(e)>-1}else{var d=new RegExp("(^|"+a+")"+b+"("+a+"|$)");return function(a){var b=!($.wijraphael&&$.wijraphael.isSVGElem(a))?a.className:a.className?a.className.baseVal:a.getAttribute("class");return d.test(b)}}};if(parseFloat($.fn.jquery)<1.8)$.expr.preFilter.CLASS=function(c,e,f,g,i,h){var b=0,a=null,d=null;c=" "+c[1].replace(/\\/g,"")+" ";if(h)return c;for(b=0,a={};a;b++){a=e[b];if(!a)try{a=e.item(b)}catch(j){}if(a){d=!($.wijraphael&&$.wijraphael.isSVGElem(a))?a.className:(a.className?a.className.baseVal:"")||a.getAttribute("class");if(i^(d&&(" "+d+" ").indexOf(c)>-1))!f&&g.push(a);else if(f)e[b]=false}}return false};Raphael.fn.tri=function(b,c,e){var g=b,j=c-e,a=Math.cos(Math.PI/6)*e,d=Math.tan(Math.PI/3)*a,h=b+a,k=c+d,i=b-a,l=c+d,f=["M",g,j,"L",h,k,"L",i,l,"z"];return this.path(f.concat(" "))};Raphael.fn.invertedTri=function(b,c,e){var g=b,j=c+e,a=Math.cos(Math.PI/6)*e,d=Math.tan(Math.PI/3)*a,h=b+a,k=c-d,i=b-a,l=c-d,f=["M",g,j,"L",h,k,"L",i,l,"z"];return this.path(f.concat(" "))};Raphael.fn.box=function(b,c,e){var a=Math.cos(Math.PI/4)*e,d=["M",b-a,c-a,"L",b+a,c-a,"L",b+a,c+a,"L",b-a,c+a,"z"];return this.path(d.concat(" "))};Raphael.fn.diamond=function(b,c,a){var d=["M",b,c-a,"L",b+a,c,"L",b,c+a,"L",b-a,c,"z"];return this.path(d.concat(" "))};Raphael.fn.cross=function(b,c,e){var a=Math.cos(Math.PI/4)*e,d=["M",b-a,c-a,"L",b+a,c+a,"M",b-a,c+a,"L",b+a,c-a];return this.path(d.concat(" "))};Raphael.fn.paintMarker=function(f,d,e,b){var c=this,a=null;if(!f)f="circle";switch(f){case"circle":a=c.circle(d,e,b);break;case"tri":a=c.tri(d,e,b);break;case"invertedTri":a=c.invertedTri(d,e,b);break;case"box":a=c.box(d,e,b);break;case"diamond":a=c.diamond(d,e,b);break;case"cross":a=c.cross(d,e,b)}return a};Raphael.prototype.htmlText=function(k,l,a,i,e,d){function h(b,a,d){var f=/<(b|strong)>/,e=/<(i|em)>/,c=/href=[\"\']([^\"\']+)[\"\']/,g=/<a/;d&&b.attr(d);f.test(a)&&b.attr("font-weight","bold");e.test(a)&&b.attr("font-style","italic");if(g.test(a))a.match(c)[1]&&b.attr("href",a.match(c)[1])}var j=a.toString().split(/<br\s?\/>|\\r/i),g=this,b=g.set(),c=0,f=0;e=e||3;d=d||5;$.each(j,function(m,k){var j=0,l=k.split("|||");k=k.replace(/<([A-Za-z]+(.|\n)*?)>/g,"|||<$1>").replace(/<\/([A-Za-z]*)>/g,"</$1>|||");$.each(l,function(o,l){var k=null,d=null,m=0,n=0;if(l!==""){k=l;k=$.trim(k.replace(/<(.|\n)*?>/g,""));a=g.text(0,0,k);h(a,l,i);d=a.wijGetBBox();m=d.width/2+c;n=-d.height/2+f;c=c+d.width+e;a.translate(m,n);b.push(a);if(j<d.height)j=d.height}});f+=j+d;c=j=0});f=0;b.transform(Raphael.format("...t{0},{1}",k-b.getBBox().x,l-b.getBBox().y));return b};Raphael.fn.line=function(a,b,c,d){return this.path(["M",a,b,"L",c,d])};Raphael.fn.roundRect=function(l,m,e,d,k,i,h,j){var a=[],c=[-1,1,1,1,1,-1,-1,-1],g=["v","h","v","h"],b=null,f=null;$.each([k,i,h,j],function(c,b){if(typeof b==="number")a=a.concat({x:b,y:b});else if(typeof b==="object")a=a.concat(b);else a=a.concat({x:0,y:0})});b=["M",l+a[0].x,m];f=[d-a[0].y-a[1].y,e-a[1].x-a[2].x,a[2].y+a[3].y-d,a[3].x+a[0].x-e];$.each(a,function(d,a){if(a.x&&a.y)b=b.concat("a",a.x,a.y,0,0,0,c[2*d]*a.x,c[2*d+1]*a.y);b=b.concat(g[d],f[d])});b.push("z");return this.path(b)};Raphael.fn.wrapText=function(n,o,i,g,m,f){var h=this,b=f.rotation,k=b?$.extend(true,{},f,{rotation:0}):f,j=o,d=h.set(),a=null,c=null,e=[];if(typeof i==="undefined")i="";function l(j,i,g){var b=null,f=null,a=j.toString().split(" "),e=[],c=[],d="";while(a.length){d+=" "+a[0];b=h.text(-1e3,-1e3,d);b.attr(g);f=b.wijGetBBox();if(f.width>i){if(c.length){e.push(c);d=a[0]}c=[a.shift()]}else c.push(a.shift());a.length===0&&e.push(c);b.wijRemove();b=null}return e}$.each(l(i,g,k),function(q,p){var l=p.join(" "),o=m||"near",c=h.text(n,j,l),f=0,i=0;c.attr(k);a=c.wijGetBBox();switch(o){case"near":f=g-a.width/2;break;case"center":f+=g/2;break;case"far":f+=a.width/2}if(b){i+=a.height/2/Math.abs(Math.sin(b));j+=a.height/Math.abs(Math.sin(b))}else{i+=a.height/2;j+=a.height}a.x+=f;a.y+=i;if(b)c.attr({x:c.attr("x")+f,y:c.attr("y")+i});else c.transform(Raphael.format("...T{0},{1}",f,i));d.push(c);e.push(a)});if(b){a=d.wijGetBBox();if(d.length>1){$.each(d,function(c,b){b.attr({y:b.attr("y")-a.height/2});e[c].y-=a.height/2});c={x:a.x+a.width/2,y:a.y+a.height/2};$.each(d,function(l,g){var f=Math,h=e[l],d={x:h.x+h.width/2,y:h.y+h.height/2},j=f.sqrt(f.pow(d.x-c.x,2)+f.pow(d.y-c.y,2)),a=0,i=null,k=null;g.attr({rotation:b});if(j===0)return true;i=g.wijGetBBox();a=Raphael.deg(f.asin(f.abs(d.y-c.y)/j));if(d.y>c.y)if(d.x>c.x)a-=360;else a=-1*(a+180);else if(d.x>c.x)a*=-1;else a=-1*(180-a);k=$.wijraphael.getPositionByAngle(c.x,c.y,j,-1*(b+a));g.attr({y:g.attr("y")+k.y-i.y-i.height/2})})}else d[0].transform(Raphael.format("...R{0}",b))}return d};Raphael.fn.getSVG=function(){function l(e,b){var a="<"+e+" ",c=null,d=false;$.each(b,function(b,c){if(b==="text"||b==="opacity"||b==="transform"||b==="path"||b==="w"||b==="h"||b==="translation")return true;if(c){if(b==="stroke"&&c===0)c="none";a+=b+"='"+c+"' "}});if(b.opacity){c=b.opacity;a+="opacity='"+c+"' style='opacity:"+c+";";d=true}if(b.transform&&b.transform.length>0){c=b.transform;if(d)a+="transform:"+c;else{a+="style='transform:"+c;d=true}}if(d)a+="'";if(b.text){c=b.text;a+="><tspan>"+c+"</tspan>"}else a+=">";a+="</"+e+">";return a}for(var g=this,j='<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="'+g.canvas.offsetWidth+'" height="'+g.canvas.offsetHeight+'"><desc>Created with Raphael</desc><defs></defs>',c="",h,f,d,e=0,k=0,b=0,i=0,a=g.bottom;a;a=a.next)if(a&&a.type)switch(a.type){case"path":for(e=0,k=a.attrs.path.length;e<k;e++){f=a.attrs.path[e];for(b=0,i=f.length;b<i;b++){d=f[b];if(b<1)c+=d;else if(b===i-1)c+=d;else c+=d+","}}if(c&&c.length>0)a.attrs.d=c.replace(/,/g," ");break;case"text":if(!a.attrs["text-anchor"])a.attrs["text-anchor"]="middle";break;case"image":h=a.transformations;a.attrs.transform=h?h.join(" "):"";break;case"ellipse":case"rect":j+=l(a.type,a.attrs)}j+="</svg>";return j};Raphael.el.wijRemove=function(){var a=this,b;if(a.removed)return;if(a.node.parentNode){b=$(a.node);a.stop().remove();b.remove()}};Raphael.st.wijRemove=function(){$.each(this,function(b,a){a.wijRemove&&!a.removed&&a.wijRemove()})};Raphael.el.wijGetBBox=function(){return this.getBBox()};Raphael.el.wijAnimate=function(a,g,b,f){if(!a||$.isEmptyObject(a))return;var e=this.shadow,d=0,c={easeInCubic:">",easeOutCubic:"<",easeInOutCubic:"<>",easeInBack:"backIn",easeOutBack:"backOut",easeOutElastic:"elastic",easeOutBounce:"bounce"};if(c[b])b=c[b];this.animate(a,g,b,f);c=null;if(e&&e.offset){d=e.offset;if(a.x)a.x+=d;if(a.y)a.y+=d;this.shadow.animate(a,g,b,f)}};Raphael.el.wijAttr=function(a,c){this.attr(a,c);if(this.shadow)if(typeof a==="object"){var b=$.extend(true,{},a);if(b.fill)delete b.fill;if(b.stroke)delete b.stroke;if(b["stroke-width"])delete b["stroke-width"];this.shadow.attr(b,c)}else if(typeof a==="string")switch(a){case"clip-rect":case"cx":case"cy":case"fill-opacity":case"font":case"font-family":case"font-size":case"font-weight":case"height":case"opacity":case"path":case"r":case"rotation":case"rx":case"ry":case"scale":case"stroke-dasharray":case"stroke-linecap":case"stroke-linejoin":case"stroke-miterlimit":case"stroke-opacity":case"stroke-width":case"translation":case"width":this.shadow.attr(a,c);break;case"x":this.shadow.attr(a,c);this.shadow.attr("transform","...t1,0");break;case"y":this.shadow.attr(a,c);this.shadow.attr("transform","...t0,1")}};Raphael.st.wijAttr=function(b,a){$.each(this.items,function(d,c){c.wijAttr(b,a)});return this};Raphael.st.wijAnimate=function(f,g,e,d){var a=0,c=0,b=null;for(a=0,c=this.items.length;a<c;a++){b=this.items[a];b.wijAnimate(f,g,e,d)}return this};Raphael.st.wijGetBBox=function(){for(var b=[],c=[],j=[],i=[],g=Math.max,h=Math.min,e="push",d="apply",a=null,f=0,f=this.items.length-1;f>=0;f--){a=this.items[f].wijGetBBox();b[e](a.x);c[e](a.y);j[e](a.x+a.width);i[e](a.y+a.height)}b=h[d](0,b);c=h[d](0,c);return{x:b,y:c,width:g[d](0,j)-b,height:g[d](0,i)-c}}})();
(function(a){"use strict";if(!window.Raphael)return;a.wijchart={getDiffAttrs:function(d,b){var c={};a.each(b,function(a){if(typeof d==="undefined")return true;else if(typeof d[a]==="undefined")c[a]=b[a];else if(d[a]!==b[a])c[a]=b[a]});return c},paintShadow:function(b,f,g){if(b.removed||a(b).parent().length===0)return;var c=b.clone(),d=f||1,e=g||"#cccccc";c.insertBefore(b);c.attr({transform:Raphael.format("...T{0},{1}",d,d),stroke:e,"stroke-width":d});c.toBack();c.offset=d;b.shadow=c},getScaling:function(b,d,e,c){var a=d-e;if(a===0)a=1;if(b)a=-a;return c/a},getTranslation:function(d,b,e,f,c){var a=0;if(d){a=b.y;a-=c*e}else{a=b.x;a-=c*f}return a},getXSortedPoints:function(e){var b=e.data.x,f=[].concat(b),g=[].concat(e.data.y),d=[],c=b;if(b===undefined||b.length===0)return;function h(a,b){return a-b}if(typeof b[0]==="number")c=[].concat(b).sort(h);a.each(c,function(c,b){a.each(f,function(e,a){if(b===a){if(typeof a!=="number")a=c;d.push({x:a,y:g[e]});f.splice(e,1);g.splice(e,1);return false}})});return d},sector:function(c,d,b,e,f){var g=a.wijraphael.getPositionByAngle(c,d,b,e),h=a.wijraphael.getPositionByAngle(c,d,b,f);return["M",c,d,"L",g.x,g.y,"A",b,b,0,+(f-e>180),0,h.x,h.y,"z"]},donut:function(e,f,c,b,g,h){var d=a.wijraphael.getPositionByAngle(e,f,c,g),l=a.wijraphael.getPositionByAngle(e,f,c,h),k=a.wijraphael.getPositionByAngle(e,f,b,g),j=a.wijraphael.getPositionByAngle(e,f,b,h),i=h-g>180;return["M",d.x,d.y,"A",c,c,0,+i,0,l.x,l.y,"L",j.x,j.y,"A",b,b,0,+i,1,k.x,k.y,"L",d.x,d.y,"z"]},getFirstValidListValue:function(c){var b;a.each(c,function(c,a){if(a===null)return true;else if(typeof a==="undefined")return true;else if(typeof a==="number"&&isNaN(a))return true;b=a;return false});return b},getLastValidListValue:function(b){var c=[].concat(b).reverse();return a.wijchart.getFirstValidListValue(c)},isHole:function(a,b){return a===null?true:typeof a==="undefined"?true:typeof a==="number"&&isNaN(a)?true:b===null?false:typeof a!=="undefined"?a-b===0?true:false:false}};var b={content:"",contentStyle:{},title:"",titleStyle:{},style:{fill:"white","fill-opacity":.5},closeBehavior:"auto",mouseTrailing:true,triggers:"hover",animated:"fade",showAnimated:null,hideAnimated:null,duration:500,showDuration:500,hideDuration:500,easing:null,showEasing:null,hideEasing:null,showDelay:150,hideDelay:150,relativeTo:"mouse",compass:"east",offsetX:0,offsetY:0,showCallout:true,calloutFilled:false,calloutFilledStyle:{fill:"black"},calloutLength:12,calloutOffset:0,calloutAnimation:{easing:null,duration:500},windowCollisionDetection:true,calloutSide:null,width:null,height:null,beforeShowing:null};Raphael.fn.closeBtn=function(c,d,b){var a=Math.cos(Math.PI/4)*b,f=this.set(),h=["M",c-a,d-a,"L",c+a,d+a,"M",c-a,d+a,"L",c+a,d-a],g=this.path(h.concat(" ")),e=null;g.attr({cursor:"pointer"});f.push(g);e=this.rect(c-b,d-b,b*2,b*2);e.attr({fill:"white","fill-opacity":0,cursor:"pointer",stroke:"none"});f.push(e);return f};Raphael.fn.tooltip=function(p,Y){var c=a.extend(true,{},b,Y),g=this,A=null,P=0,Q=0,f,h,i,e,d,y=null,x=null,n=null,m=5,l=null,u=g.tooltip.animations,t=c.calloutOffset,C=c.width,B=c.height,s=c.calloutLength/2,q=0,j=0,k=0,o,U=function(c,d){var a=c.getBBox(),b={x:0,y:0};switch(d.toLowerCase()){case"east":b.x=a.x+a.width;b.y=a.y+a.height/2;break;case"eastnorth":b.x=a.x+a.width;b.y=a.y;break;case"eastsouth":b.x=a.x+a.width;b.y=a.y+a.height;break;case"west":b.x=a.x;b.y=a.y+a.height/2;break;case"westnorth":b.x=a.x;b.y=a.y;break;case"westsouth":b.x=a.x;b.y=a.y+a.height;break;case"north":b.x=a.x+a.width/2;b.y=a.y;break;case"northeast":b.x=a.x+a.width;b.y=a.y;break;case"northwest":b.x=a.x;b.y=a.y;break;case"south":b.x=a.x+a.width/2;b.y=a.y+a.height;break;case"southeast":b.x=a.x+a.width;b.y=a.y+a.height;break;case"southwest":b.x=a.x;b.y=a.y+a.height}return b},G=function(a){if(a){window.clearTimeout(a);a=null}},z=function(g){if(l){var a,b,j;if(c.hideAnimated||c.animated){a=c.hideAnimated;if(!a)a=c.animated;if(a&&u[a]){j={animated:a,duration:c.hideDuration||c.duration,easing:c.hideEasing||c.easing,context:l,show:false};u[a](j)}}b=c.hideDuration;if(g)b=g;window.setTimeout(function(){var a,b;if(f){f.wijRemove();f=null}if(h){h.wijRemove();h=null}if(i){i.wijRemove();i=null}if(e){for(a=0,b=e.length;a<b;a++)e[a].unclick();e.wijRemove();e=null}if(d){d.wijRemove();d=null}n=null;l=null},b)}},L=function(){y&&G(y);x&&G(x)},v=function(){L();if(c.hideDelay)x=window.setTimeout(function(){z()},c.hideDelay);else z()},D=function(b){var a="";switch(b.toLowerCase()){case"east":a="right-middle";j=2;k=0;break;case"eastnorth":a="right-top";j=2;k=-2;break;case"eastsouth":a="right-bottom";j=2;k=2;break;case"west":a="left-middle";j=-2;k=0;break;case"westnorth":a="left-top";j=-2;k=-2;break;case"westsouth":a="left-bottom";j=-2;k=2;break;case"north":a="top-middle";j=0;k=-2;break;case"northeast":a="top-right";j=2;k=-2;break;case"northwest":a="top-left";j=-2;k=-2;break;case"south":a="bottom-middle";j=0;k=2;break;case"southeast":a="bottom-right";j=2;k=2;break;case"southwest":a="bottom-left";j=-2;k=2}return a},K=function(b,a){var d=[],e=c.compass;if(c.calloutSide)e=c.calloutSide;switch(e.toLowerCase()){case"east":case"eastsouth":case"eastnorth":d=["M",b.x+a,b.y+a,"l",-a,-a,"l",a,-a,"Z"];break;case"west":case"westsouth":case"westnorth":d=["M",b.x-a,b.y-a,"l",a,a,"l",-a,a,"Z"];break;case"north":case"northeast":case"northwest":d=["M",b.x-a,b.y-a,"l",a,a,"l",a,-a,"Z"];break;case"south":case"southeast":case"southwest":d=["M",b.x-a,b.y+a,"l",a,-a,"l",a,a,"Z"]}return d},M=function(e,d){if(a.isFunction(e)){var h=null,f,c={target:null,fmt:e},b;if(d&&d.target){b=d.target;if(!b.raphael||!b.raphaelid)b=b.parentNode;if(b.raphael&&b.raphaelid){f=g.getById(b.raphaelid);c.target=f}else c.target=d.target}h=a.proxy(c.fmt,c);return h().toString()}return e},H=function(a){if(c.calloutSide){var b=s||q;switch(c.calloutSide){case"south":case"north":if(a)d.animate({translation:-C/2+b+t+",0"},a);else d.translate(-C/2+b+t,0);break;case"east":case"west":if(a)d.animate({translation:"0,"+(-B/2+b+t)},a);else d.translate(0,-B/2+b+t)}}},V=/\{([^\}]+)\}/g,S=/(?:(?:^|\.)(.+?)(?=\[|\.|$|\()|\[('|")(.+?)\2\])(\(\))?/g,W=function(c,d,b){var a=b;d.replace(S,function(f,b,e,c,d){b=b||c;if(a){if(a[b]!=="string")a=a[b];if(typeof a==="function"&&d)a=a()}});a=(a===null||a===b?c:a).toString();return a},ab=function(b,a){return String(b).replace(V,function(b,c){return W(b,c,a)})},N=function(i,u,s,t,h){var o=u.split("-"),e=5,p=s.getBBox(),d=Math.round(p.width),b=Math.round(p.height),j=Math.round(p.x)-e,k=Math.round(p.y)-e,a=0,f=0,m=0,n=0,q=null,l=null,r=null;if(c.width)d=d>c.width?d:c.width;if(c.height)b=b>c.height?b:c.height;C=d;B=b;a=Math.min(b/4,d/4,t);if(h)h=Math.min(b/4,d/4,h);if(h){f=h;q={top:"M{x},{y}h{w4},{w4},{w4},{w4}a{r},{r},0,0,1,{r},{r}v{h4},{h4},{h4},{h4}a{r},{r},0,0,1,-{r},{r}l-{right},0-{offset},0,-{left},0a{r},{r},0,0,1-{r}-{r}v-{h4}-{h4}-{h4}-{h4}a{r},{r},0,0,1,{r}-{r}z",bottom:"M{x},{y}l{left},0,{offset},0,{right},0a{r},{r},0,0,1,{r},{r}v{h4},{h4},{h4},{h4}a{r},{r},0,0,1,-{r},{r}h-{w4}-{w4}-{w4}-{w4}a{r},{r},0,0,1-{r}-{r}v-{h4}-{h4}-{h4}-{h4}a{r},{r},0,0,1,{r}-{r}z",right:"M{x},{y}h{w4},{w4},{w4},{w4}a{r},{r},0,0,1,{r},{r}v{h4},{h4},{h4},{h4}a{r},{r},0,0,1,-{r},{r}h-{w4}-{w4}-{w4}-{w4}a{r},{r},0,0,1-{r}-{r}l0-{bottom},0-{offset},0-{top}a{r},{r},0,0,1,{r}-{r}z",left:"M{x},{y}h{w4},{w4},{w4},{w4}a{r},{r},0,0,1,{r},{r}l0,{top},0,{offset},0,{bottom}a{r},{r},0,0,1,-{r},{r}h-{w4}-{w4}-{w4}-{w4}a{r},{r},0,0,1-{r}-{r}v-{h4}-{h4}-{h4}-{h4}a{r},{r},0,0,1,{r}-{r}z"}}else q={top:"M{x},{y}h{w4},{w4},{w4},{w4}a{r},{r},0,0,1,{r},{r}v{h4},{h4},{h4},{h4}a{r},{r},0,0,1,-{r},{r}l-{right},0-{gap},{gap}-{gap}-{gap}-{left},0a{r},{r},0,0,1-{r}-{r}v-{h4}-{h4}-{h4}-{h4}a{r},{r},0,0,1,{r}-{r}z",bottom:"M{x},{y}l{left},0,{gap}-{gap},{gap},{gap},{right},0a{r},{r},0,0,1,{r},{r}v{h4},{h4},{h4},{h4}a{r},{r},0,0,1,-{r},{r}h-{w4}-{w4}-{w4}-{w4}a{r},{r},0,0,1-{r}-{r}v-{h4}-{h4}-{h4}-{h4}a{r},{r},0,0,1,{r}-{r}z",right:"M{x},{y}h{w4},{w4},{w4},{w4}a{r},{r},0,0,1,{r},{r}v{h4},{h4},{h4},{h4}a{r},{r},0,0,1,-{r},{r}h-{w4}-{w4}-{w4}-{w4}a{r},{r},0,0,1-{r}-{r}l0-{bottom}-{gap}-{gap},{gap}-{gap},0-{top}a{r},{r},0,0,1,{r}-{r}z",left:"M{x},{y}h{w4},{w4},{w4},{w4}a{r},{r},0,0,1,{r},{r}l0,{top},{gap},{gap}-{gap},{gap},0,{bottom}a{r},{r},0,0,1,-{r},{r}h-{w4}-{w4}-{w4}-{w4}a{r},{r},0,0,1-{r}-{r}v-{h4}-{h4}-{h4}-{h4}a{r},{r},0,0,1,{r}-{r}z"};l=([{x:j+e,y:k,w:d,w4:d/4,h4:b/4,left:0,right:d-a*2-f*2,top:0,bottom:b-a*2-f*2,r:e,h:b,gap:a,offset:f*2},{x:j+e,y:k,w:d,w4:d/4,h4:b/4,left:d/2-a-f,right:d/2-a-f,top:b/2-a-f,bottom:b/2-a-f,r:e,h:b,gap:a,offset:f*2},{x:j+e,y:k,w:d,w4:d/4,h4:b/4,right:0,left:d-a*2-f*2,bottom:0,top:b-a*2-f*2,r:e,h:b,gap:a,offset:f*2}])[o[1]==="middle"?1:(o[1]==="left"||o[1]==="top")*2];r=g.path(ab(q[o[0]],l));switch(o[0]){case"top":m=i.x-(j+e+l.left+a+h);n=i.y-(k+e+b+e+a+h);break;case"bottom":m=i.x-(j+e+l.left+a+h);n=i.y-(k-a-h);break;case"left":m=i.x-(j+e+d+e+a+h);n=i.y-(k+e+l.top+a+h);break;case"right":m=i.x-(j-a-f);n=i.y-(k+e+l.top+a+f)}r.translate(m,n);s.translate(m,n);return r},F=function(n,o,d,e,p,q){var c=n.getBBox(),f=0,b=o,h=c.x+p,i=c.y+q,m=g.width,l=g.height,j=d,k=e;if(g.raphael.vml){m=a(g.canvas).width();l=a(g.canvas).height()}if(h+d<0)if(b.toLowerCase().indexOf("west")===-1){if(h+c.width/2+c.width-d<=m){f++;b=b.toLowerCase()+"east";j=0-d}}else if(h+c.width+c.width-d<=m){f++;b=b.toLowerCase().replace("west","east");j=0-d}if(i+e<0)if(b.toLowerCase().indexOf("north")===-1){if(i+c.height/2+c.height-e<=l){f++;b=b.toLowerCase()+"south";k=0-e}}else if(i+c.height+c.height-e<=l){f++;b=b.toLowerCase().replace("north","south");k=0-e}if(h+c.width+d>m)if(b.toLowerCase().indexOf("east")===-1){if(h-c.width/2-d>=0){f++;b=b.toLowerCase()+"west";j=0-d}}else if(h-c.width-d>=0){f++;b=b.toLowerCase().replace("east","west");j=0-d}if(i+c.height+e>l)if(b.toLowerCase().indexOf("south")===-1){if(i-c.height/2-e>=0){f++;b=b.toLowerCase()+"north";k=0-e}}else if(i-c.height-e>=0){f++;b=b.toLowerCase().replace("south","north");k=0-e}return f?{compass:b,offsetX:j,offsetY:k}:false},w=function(E,A,z,M,I,J,L){var x,t,B,p=g.set(),C=null,r=null,P=null,Q=0,R=0,S=250,G=0,O=0,b,o={x:E.x,y:E.y},y=null;a.wijraphael.clearRaphaelCache();B=D(I);o.x+=J+j;o.y+=L+k;l=g.set();if(h){a.each(h,function(c,b){a(b.node).unbind(".Rtooltip")});h.wijRemove()}if(A&&A.length>0){h=g.htmlText(-1e3,-1e3,A,c.titleStyle);l.push(h);x=h.getBBox()}else x={left:-1e3,top:-1e3,width:0,height:0};if(f){a.each(f,function(c,b){a(b.node).unbind(".Rtooltip")});f.wijRemove()}if(z&&z.length>0){f=g.htmlText(-1e3,-1e3,z,c.contentStyle);l.push(f);t=f.getBBox()}else t={left:-1e3,top:-1e3,width:0,height:0};if(e){for(G=0,O=e.length;G<O;G++)e[G].unclick();e.wijRemove()}f&&f.transform(Raphael.format("T0,{0}",x.height/2+t.height/2));h&&h.transform(Raphael.format("T0,{0}",0));if(c.closeBehavior==="sticky"){e=g.closeBtn(-1e3,-1e3,m);l.push(e);if(c.width&&c.width>x.width+m*2&&c.width>t.width+m*2)e.transform(Raphael.format("T{0},{1}",c.width-m,m));else if(x.width>=t.width-m*2)e.transform(Raphael.format("T{0},{1}",x.width+m,m));else e.transform(Raphael.format("T{0},{1}",t.width-m,m));a.each(e,function(){this.click(function(a){v(a)})})}if(h){p.push(h);c.relatedElement&&h.insertBefore(c.relatedElement)}if(f){p.push(f);c.relatedElement&&f.insertBefore(c.relatedElement)}if(e){p.push(e);c.relatedElement&&e.insertBefore(c.relatedElement)}if(!c.showCallout)s=0;if(c.calloutSide||c.calloutFilled){s=0;q=c.calloutLength/2;if(c.calloutSide)B=D(c.calloutSide)}if(c.calloutSide&&p.length===0){f=g.htmlText(-1e3,-1e3," ");p.push(f);c.relatedElement&&f.insertBefore(c.relatedElement)}if(d){a(d.node).unbind(".Rtooltip");d.wijRemove()}if(i){a(i.node).unbind(".Rtooltip");i.wijRemove()}if(n){if(c.showCallout&&(c.calloutSide||c.calloutFilled)){C=K(n,q);d=g.path(C.concat(" "));c.relatedElement&&d.insertBefore(c.relatedElement);c.calloutFilled&&d.attr(c.calloutFilledStyle);c.calloutSide&&H(0)}i=N(n,B,p,s,q);c.relatedElement&&i.insertBefore(c.relatedElement);if(M){b=F(i,I,J,L,o.x-n.x,o.y-n.y);if(b){w(E,A,z,false,b.compass,b.offsetX,b.offsetY);return}}l.push(d);l.push(i);Q=o.x-n.x;R=o.y-n.y;y=Raphael.animation({transform:Raphael.format("...T{0},{1}",Q,R)},S);i&&i.animate(y);h&&h.animate(y);f&&f.animate(y);e&&e.animate(y);d&&d.animate(y)}else{if(c.showCallout&&(c.calloutSide||c.calloutFilled)){C=K(o,q);d=g.path(C.concat(" "));c.relatedElement&&d.insertBefore(c.relatedElement);c.calloutFilled&&d.attr(c.calloutFilledStyle);c.calloutSide&&H(0)}i=N(o,B,p,s,q);c.relatedElement&&i.insertBefore(c.relatedElement);if(M){b=F(i,I,J,L,0,0);if(b){w(E,A,z,false,b.compass,b.offsetX,b.offsetY);return}}l.push(d);l.push(i);if(c.showAnimated||c.animated){r=c.showAnimated;if(!r)r=c.animated;if(r&&u[r]){P={animated:r,duration:c.showDuration||c.duration,easing:c.showEasing||c.easing,context:l,show:true};u[r](P)}}}n=o;i.attr(c.style);if(c.relatedElement){h&&h.insertBefore(c.relatedElement);f&&f.insertBefore(c.relatedElement);e&&e.insertBefore(c.relatedElement)}else p.toFront()},J=function(k,d){var h=null,e=null,j=null,f=null,i,b;if(a.isFunction(c.beforeShowing)){j=null;f={target:null,options:c,fmt:c.beforeShowing};if(d&&d.target){b=d.target;if(!b.raphael||!b.raphaelid)b=b.parentNode;if(b.raphael&&b.raphaelid){i=g.getById(b.raphaelid);f.target=i}else{i=d.target;f.target=i}}j=a.proxy(f.fmt,f);j()}h=c.title;e=c.content;h=M(h,d);e=M(e,d);if(!h&&!e)return;w(k,h,e,c.windowCollisionDetection,c.compass,c.offsetX,c.offsetY)},R=function(a,b){L();if(c.showDelay)y=window.setTimeout(function(){J(a,b)},c.showDelay);else J(a,b)},r=function(e){A=a(g.canvas.parentNode).offset();P=A.left;Q=A.top;var h=c.relativeTo,d={x:0,y:0},f=null,b=e.target;switch(h){case"mouse":d.x=e.pageX-P;d.y=e.pageY-Q;break;case"element":if(!b.raphael||!b.raphaelid)b=b.parentNode;if(b.raphael&&b.raphaelid){f=g.getById(b.raphaelid);d=U(f,c.compass)}}R(d,e)},O=function(b){switch(c.triggers){case"hover":a(b.node).bind("mouseover.Rtooltip",function(a){r(a)}).bind("mouseout.Rtooltip",function(a){c.closeBehavior==="auto"&&v(a)});c.mouseTrailing&&c.relativeTo==="mouse"&&a(b.node).bind("mousemove.Rtooltip",function(a){r(a)});break;case"click":a(b.node).bind("click.Rtooltip",function(a){r(a)})}},I=function(a){var b,c;if(a)if(a.length)for(b=0,c=a.length;b<c;b++)O(a[b]);else O(a)},E=function(){if(o)switch(c.triggers){case"hover":o.live("mouseover.Rtooltip",function(a){r(a)}).live("mouseout.Rtooltip",function(a){c.closeBehavior==="auto"&&v(a)});c.mouseTrailing&&c.relativeTo==="mouse"&&o.live("mousemove.Rtooltip",function(a){r(a)});break;case"click":o.live("click.Rtooltip",function(a){r(a)})}},T=function(){var b,c;if(p)if(p.length)for(b=0,c=p.length;b<c;b++)a(p[b].node).unbind(".Rtooltip");else a(p.node).unbind(".Rtooltip");o&&o.die("Rtooltip").die(".Rtooltip")},X=function(){T();z(0)},Z=function(){this.hide=function(){v()};this.showAt=function(a){R(a)};this.resetCalloutOffset=function(e){var f=c.calloutOffset,a=c.calloutSide,b=c.calloutAnimation;if(d)if(a==="south"||a==="north")d.animate({translation:e-f+",0"},b.duration,b.easing);else(a==="east"||a==="west")&&d.animate({translation:"0,"+(e-f)},b.duration,b.easing);c.calloutOffset=e};this.destroy=function(){X()};this.getOptions=function(){return c};this.setTargets=function(a){I(a)};this.setSelector=function(a){o=a;E()};this.setOptions=function(b){c=a.extend(true,c,b)}};p&&I(p);o&&E(o);return new Z};Raphael.fn.tooltip.animations={fade:function(a){var b=a.context;if(a.show){b.attr({opacity:0});b.animate({opacity:1},a.duration,a.easing)}else b.animate({opacity:0},a.duration,a.easing)}}})(jQuery);(function(a){"use strict";a.widget("wijmo.wijchartcore",{options:{width:null,height:null,culture:"",seriesList:[],seriesStyles:[{stroke:"#00cc00",opacity:.9,"stroke-width":1},{stroke:"#0099cc",opacity:.9,"stroke-width":1},{stroke:"#0055cc",opacity:.9,"stroke-width":1},{stroke:"#2200cc",opacity:.9,"stroke-width":1},{stroke:"#8800cc",opacity:.9,"stroke-width":1},{stroke:"#d9007e",opacity:.9,"stroke-width":1},{stroke:"#ff0000",opacity:.9,"stroke-width":1},{stroke:"#ff6600",opacity:.9,"stroke-width":1},{stroke:"#ff9900",opacity:.9,"stroke-width":1},{stroke:"#ffcc00",opacity:.9,"stroke-width":1},{stroke:"#ffff00",opacity:.9,"stroke-width":1},{stroke:"#ace600",opacity:.9,"stroke-width":1}],seriesHoverStyles:[{opacity:1,"stroke-width":1.5},{opacity:1,"stroke-width":1.5},{opacity:1,"stroke-width":1.5},{opacity:1,"stroke-width":1.5},{opacity:1,"stroke-width":1.5},{opacity:1,"stroke-width":1.5},{opacity:1,"stroke-width":1.5},{opacity:1,"stroke-width":1.5},{opacity:1,"stroke-width":1.5},{opacity:1,"stroke-width":1.5},{opacity:1,"stroke-width":1.5},{opacity:1,"stroke-width":1.5}],marginTop:25,marginRight:25,marginBottom:25,marginLeft:25,textStyle:{fill:"#888","font-size":10,stroke:"none"},header:{text:"",style:{fill:"none",stroke:"none"},textStyle:{"font-size":18,fill:"#666",stroke:"none"},compass:"north",orientation:"horizontal",visible:true},footer:{text:"",style:{fill:"#fff",stroke:"none"},textStyle:{fill:"#000",stroke:"none"},compass:"south",orientation:"horizontal",visible:false},legend:{text:"",textMargin:{left:2,top:2,right:2,bottom:2},style:{fill:"none",stroke:"none"},textWidth:null,textStyle:{fill:"#333",stroke:"none"},titleStyle:{"font-weight":"bold",fill:"#000",stroke:"none"},compass:"east",orientation:"vertical",visible:true},axis:{x:{alignment:"center",style:{stroke:"#999999","stroke-width":.5},visible:true,textVisible:true,text:"",textStyle:{fill:"#888","font-size":15,"font-weight":"bold"},labels:{style:{fill:"#333","font-size":11},textAlign:"near",width:null},compass:"south",autoMin:true,autoMax:true,min:null,max:null,origin:null,autoMajor:true,autoMinor:true,unitMajor:null,unitMinor:null,gridMajor:{visible:false,style:{stroke:"#CACACA","stroke-dasharray":"- "}},gridMinor:{visible:false,style:{stroke:"#CACACA","stroke-dasharray":"- "}},tickMajor:{position:"none",style:{fill:"black"},factor:1},tickMinor:{position:"none",style:{fill:"black"},factor:1},annoMethod:"values",annoFormatString:"",valueLabels:[]},y:{alignment:"center",style:{stroke:"#999999","stroke-width":.5},visible:false,textVisible:true,text:"",textStyle:{fill:"#888","font-size":15,"font-weight":"bold"},labels:{style:{fill:"#333","font-size":11},textAlign:"center",width:null},compass:"west",autoMin:true,autoMax:true,min:null,max:null,origin:null,autoMajor:true,autoMinor:true,unitMajor:null,unitMinor:null,gridMajor:{visible:true,style:{stroke:"#999999","stroke-width":.5,"stroke-dasharray":"none"}},gridMinor:{visible:false,style:{stroke:"#CACACA","stroke-dasharray":"- "}},tickMajor:{position:"none",style:{fill:"black"},factor:1},tickMinor:{position:"none",style:{fill:"black"},factor:1},annoMethod:"values",annoFormatString:"",valueLabels:[]}},hint:{enable:true,content:null,contentStyle:{fill:"#d1d1d1","font-size":16},title:null,titleStyle:{fill:"#d1d1d1","font-size":16},style:{fill:"#000000","stroke-width":2},animated:"fade",showAnimated:"fade",hideAnimated:"fade",duration:120,showDuration:120,hideDuration:120,easing:"",showEasing:"",hideEasing:"",showDelay:0,hideDelay:150,compass:"north",offsetX:0,offsetY:0,showCallout:true,calloutFilled:false,calloutFilledStyle:{fill:"#000"}},showChartLabels:true,chartLabelStyle:{},chartLabelFormatString:"",disableDefaultTextStyle:false,shadow:true,dataSource:null,data:null,beforeSeriesChange:null,seriesChanged:null,beforePaint:null,painted:null},innerState:{},_setOption:function(d,f){var c=this,b=c.options,o=null,n=0,g=0,j=b.axis.x.tickMajor.factor,k=b.axis.x.tickMinor.factor,l,m,e,i,h;if(d==="dataSource"){c.seriesTransition=true;b.dataSource=f;if(c.seriesList)b.seriesList=a.arrayClone(c.seriesList);c._init()}if(d==="seriesList"){if(!f)f=[];o=a.Event("beforeserieschange");if(c._trigger("beforeSeriesChange",o,{oldSeriesList:b.seriesList,newSeriesList:f})===false)return false;b.seriesList=f;c.seriesList=a.arrayClone(f);c._trigger("seriesChanged",null,f);c.seriesTransition=true;c._init()}else if(a.isPlainObject(b[d])){if(d==="axis")if(a.isArray(b.axis.y))e=a.arrayClone(b.axis.y);else e=a.extend(true,{},b.axis.y);a.extend(true,b[d],f);if(d==="axis"){i=b.axis.y;if(b.axis.x.tickMajor.factor<0)b.axis.x.tickMajor.factor=j;if(b.axis.x.tickMinor.factor<0)b.axis.x.tickMinor.factor=k;if(!a.isArray(i)){if(a.isArray(e)){l=e[0].tickMajor.factor;m=e[0].tickMinor.factor}else{j=e.tickMajor.factor;k=e.tickMinor.factor}if(b.axis.y.tickMajor.factor<0)b.axis.y.tickMajor.factor=l;if(b.axis.y.tickMinor.factor<0)b.axis.y.tickMinor.factor=m}else{if(!a.isArray(e))e=[e];a.each(i,function(c,a){var b=e[c]||{};if(b.tickMajor&&a.tickMajor.factor)if(a.tickMajor.factor<0)a.tickMajor.factor=b.tickMajor.factor;if(b.tickMinor&&b.tickMinor.factor)if(a.tickMinor.factor<0)a.tickMinor.factor=b.tickMinor.factor})}}}else a.Widget.prototype._setOption.apply(c,arguments);d==="disabled"&&c._handleDisabledOption(f,c.chartElement);if(d==="seriesTransition"||d==="animation")return;n=b.seriesList.length;if(d==="seriesList"||d==="seriesStyles"||d==="seriesHoverStyles"){c.styles={style:[].concat(b.seriesStyles.slice(0,b.seriesStyles.length)),hoverStyles:[].concat(b.seriesHoverStyles.slice(0,b.seriesHoverStyles.length))};c._initStyles()}if(d==="seriesList"||d==="seriesHoverStyles"){h=b.seriesHoverStyles.length;for(g=h;g<n;g++)b.seriesHoverStyles[g]=b.seriesHoverStyles[g%h]}c.redraw()},_initStyles:function(){var b=this.options,g=b.seriesStyles,f=b.seriesHoverStyles,e,d,c,a;if(b.seriesList)d=b.seriesList.length||0;if(b.seriesStyles)e=b.seriesStyles.length||0;if(b.seriesHoverStyles)c=b.seriesHoverStyles.length||0;if(d>e&&e)for(a=e;a<d;a++)g[a]=g[a%e];if(d>c&&c)for(a=c;a<d;a++)f[a]=f[a%c]},_create:function(){var b=this,c=b.options,g=c.width||b.element.width(),f=c.height||b.element.height(),e=null,d;if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);b.updating=0;b.innerState={};b.element.is(":hidden")&&b.element.wijAddVisibilityObserver&&b.element.wijAddVisibilityObserver(function(){b.redraw();b.element.wijRemoveVisibilityObserver&&b.element.wijRemoveVisibilityObserver()},"wijchart");a.isFunction(window.wijmoASPNetParseOptions)&&wijmoASPNetParseOptions(c);b.styles={style:[].concat(c.seriesStyles.slice(0,c.seriesStyles.length)),hoverStyles:[].concat(c.seriesHoverStyles.slice(0,c.seriesHoverStyles.length))};b._initStyles();if(c.hint&&typeof c.hint.content==="string"&&window[c.hint.content])c.hint.content=window[c.hint.content];if(c.hint&&typeof c.hint.title==="string"&&window[c.hint.title])c.hint.title=window[c.hint.title];b.headerEles=[];b.footerEles=[];b.legendEles=[];b.axisEles=[];b.legends=[];b.legendIcons=[];b.legendDots=[];b.chartLabelEles=[];b.seriesEles=[];if(b.element.length>0){if(b.element.is("table")){b._parseTable();e=a("<div></div>");g&&e.css("width",g);f&&e.css("height",f);b.element.after(e);b.chartElement=e}else b.chartElement=b.element;b.chartElement.addClass("ui-widget");d=new Raphael(b.chartElement[0],g,f);b.canvas=d;c.disabled&&b.disable();d.customAttributes.rotation=function(a){this.transform("...R"+a)};d.customAttributes.scale=function(a){this.transform("...S"+a)};d.customAttributes.translation=function(a,b){this.transform(Raphael.format("...T{0},{1}",a,b))};b._bindLiveEvents()}},_getDefFill:function(){return["#00cc00","#0099cc","#0055cc","#2200cc","#8800cc","#d9007e","#ff0000","#ff6600","#ff9900","#ffcc00","#ffff00","#ace600"]},_getCulture:function(a){return Globalize.findClosestCulture(a||this.options.culture)},_handleDisabledOption:function(b,c){var a=this;if(b){if(!a.disabledDiv)a.disabledDiv=a._createDisabledDiv(c);a.disabledDiv.appendTo("body")}else if(a.disabledDiv){a.disabledDiv.remove();a.disabledDiv=null}},_createDisabledDiv:function(h){var d=this,e=d.options,b=h||d.element,c=b.offset(),g=e.width||b.outerWidth(),f=e.height||b.outerHeight();return a("<div></div>").addClass("ui-disabled").css({"z-index":"99999",position:"absolute",width:g,height:f,left:c.left,top:c.top})},_bindData:function(){var b=this,e=b.options,f=e.dataSource,g=e.seriesList,c=e.data,d;a.each(g,function(k,j){var a=j.data,h,i,g,e=j.dataSource||f;if(e&&a){h=a.x;i=a.y;g=a.y1;if(h&&h.bind)a.x=b._getBindData(e,h.bind);else if(c&&c.x&&c.x.bind){if(d===undefined)d=b._getBindData(e,c.x.bind);a.x=d}if(i&&i.bind)a.y=b._getBindData(e,i.bind);if(g&&g.bind)a.y1=b._getBindData(e,g.bind)}})},_getBindData:function(b,c){if(a.isArray(b)){var d=[];a.each(b,function(b,a){a&&a[c]!==undefined&&d.push(a[c])});return d}return null},_hanldSharedXData:function(){var e=this,c=e.options,d=c.seriesList,b=c.data;b&&a.each(d,function(e,d){var c=d.data;if(c.x===undefined||c.x===null&&a.isArray(b.x))c.x=b.x})},_init:function(){var b=this,c=b.options;if(!b.rendered)b.seriesList=a.arrayClone(c.seriesList);b._bindData();b._hanldSharedXData();a.each(c.seriesList,function(f,b){var d=b.data,e;if(typeof d==="undefined"||d===null){e=a.inArray(b,c.seriesList);c.seriesList.splice(e,1)}});!b.rendered&&b._paint();a.Widget.prototype._init.apply(b,arguments)},destroy:function(){var b=this;b._unbindLiveEvents();b._clearChartElement();b.chartElement.removeClass("ui-widget");a(".wijchart-canvas-object",b.chartElement[0]).die(b.widgetName).die("."+b.widgetName);b.element!==b.chartElement&&b.chartElement.remove();b.element.empty();if(b.styles)b.styles=null;if(b.disabledDiv){b.disabledDiv.remove();b.disabledDiv=null}a.Widget.prototype.destroy.apply(b,arguments)},getCanvas:function(){return this.canvas},addSeriesPoint:function(c,e,f){var b=this.options.seriesList,d=null,a=null;if(c>=b.length)return;d=b[c];a=d.data||[];a.x.push(e.x);a.y.push(e.y);if(f){a.x.shift();a.y.shift()}this._setOption("seriesList",b)},beginUpdate:function(){var a=this;a.updating++},endUpdate:function(){var a=this;a.updating--;a.redraw()},redraw:function(e){var a=this,d=a.options,c=0,b=0;if(a.updating>0)return;if(e&&a.rendered)return;c=d.width||a.element.width();b=d.height||a.element.height();if(c<1||b<1)return;a.canvas.setSize(c,b);a._paint()},_parseTable:function(){if(!this.element.is("table"))return;var d=this,e=d.element,b=d.options,c=a("caption",e),g=a("thead th",e),f=[],h=a("tbody tr",e);if(c.length){b.header=a.extend({visible:true,text:a.trim(a(c[0]).text())},b.header);if(c.length>1)b.footer=a.extend({visibel:true,text:a.trim(a(c[1]).text())},b.footer)}b.legend=a.extend({visible:true},b.legend);d._getSeriesFromTR(g,h,f);d.options.seriesList=f},_getSeriesFromTR:function(b,e,g){var c=[],f=null,d=null;b.length&&b.each(function(){f=a.trim(a(this).text());c.push(f)});e.length&&e.each(function(){var h=a("th",a(this)),f=a.trim(h.text()),b=[],e=a("td",a(this));e.length&&e.each(function(){var c=a(this);b.push(parseFloat(a.trim(c.text())))});d={label:f,legendEntry:true,data:{x:c,y:b}};g.push(d)})},_destroyRaphaelArray:function(c){if(!c)return;for(var f=c.length,e=0,b,d;f&&e<f;e++){b=c[e];if(b&&b[0]){d=a(b.node);d.unbind().removeData();b.wijRemove();d.remove();d=null}c[e]=null}},_clearChartElement:function(){var b=this,c=b.chartElement.data("fields");b._destroyRaphaelArray(b.headerEles);b._destroyRaphaelArray(b.footerEles);b._destroyRaphaelArray(b.legendEles);b._destroyRaphaelArray(b.legends);b._destroyRaphaelArray(b.legendIcons);b._destroyRaphaelArray(b.legendDots);b._destroyRaphaelArray(b.axisEles);b._destroyRaphaelArray(b.chartLabelEles);if(b.tooltip){b.tooltip.destroy();b.tooltip=null}if(c&&c.trackers){b._destroyRaphaelArray(c.trackers);c.trackers=null}b.headerEles=[];b.footerEles=[];b.legendEles=[];b.legends=[];b.legendIcons=[];b.legendDots=[];b.axisEles=[];b.chartLabelEles=[];if(c&&c.chartElements){a.each(c.chartElements,function(c,a){b._destroyRaphaelArray(a)});c.chartElements=null}if(c&&c.seriesEles)c.seriesEles=null;if(b.seriesEles)b.seriesEles=[];b.canvas.clear();b.innerState=null;b.axisInfo=null;b.seriesGroup=null;b.lastAxisOffset=null;b.innerState={}},_text:function(c,d,b){var a=this.canvas.text(c,d,b);if(this.options.disableDefaultTextStyle)a.node.style.cssText="";return a},_paint:function(){var b=this,c=b.options,a=b.element,f=a.css("display")==="none"||a.css("visibility")==="hidden",e={},d=null;if(f){e=a.css("left");d=a.css("position");a.css("left","-10000px");a.css("position","absolute");a.show()}if(a.is(":hidden")){if(f){a.css("left",e);a.css("position",d);a.hide()}return}b._clearChartElement();if(b._trigger("beforePaint")===false)return;b.canvasBounds={startX:0,endX:c.width||a.width(),startY:0,endY:c.height||a.height()};b._paintHeader();b._paintFooter();b._paintLegend();b._paintChartArea();b._paintTooltip();b._trigger("painted");b.rendered=true;if(b.styles){c.seriesStyles=b.styles.style;c.seriesHoverStyles=b.styles.hoverStyles}if(f){a.css("left",e);a.css("position",d);a.hide()}},_calculatePosition:function(g,f,e){var b={x:0,y:0},c=5,d=5,a=this.canvasBounds;switch(g){case"north":b.x=(a.endX-a.startX)/2;b.y=a.startY+e/2+d;a.startY=a.startY+d*2+e;break;case"south":b.x=(a.endX-a.startX)/2;b.y=a.endY-e/2-d;a.endY=a.endY-d*2-e;break;case"east":b.x=a.endX-f/2-c;b.y=(a.endY-a.startY)/2;a.endX=a.endX-c*2-f;break;case"west":b.x=a.startX+f/2+c;b.y=(a.endY-a.startY)/2;a.startX=a.startX+c*2+f}return b},_paintHeader:function(){var g=2,d=this,m=d.options,c=m.header,h=null,b=null,k=null,j=null,i=null,f=null,l=0,e=null;if(c.text&&c.text.length>0&&c.visible){h=c.compass;b=d._text(0,0,c.text);a.wijraphael.addClass(a(b.node),"wijchart-header-text");l=d._getRotationByCompass(h);k=a.extend(true,{},m.textStyle,c.textStyle);b.attr(k);b.transform("...R"+l);j=b.wijGetBBox();i=d._calculatePosition(h,j.width,j.height);b.transform(Raphael.format("...T{0},{1}",i.x,i.y));f=b.wijGetBBox();e=d.canvas.rect(f.x-g,f.y-g,f.width+2*g,f.height+2*g);a.wijraphael.addClass(a(e.node),"wijchart-header-container");e.attr(c.style);e.toBack();d.headerEles.push(b);d.headerEles.push(e)}},_paintFooter:function(){var g=2,d=this,m=d.options,c=m.footer,h=null,b=null,k=null,j=null,i=null,f=null,l=0,e=null;if(c.text&&c.text.length>0&&c.visible){h=c.compass;b=d._text(0,0,c.text);a.wijraphael.addClass(a(b.node),"wijchart-footer-text");l=d._getRotationByCompass(h);k=a.extend(true,{},m.textStyle,c.textStyle);b.attr(k);b.transform("...R"+l);j=b.wijGetBBox();i=d._calculatePosition(h,j.width,j.height);b.transform(Raphael.format("...T{0},{1}",i.x,i.y));f=b.wijGetBBox();e=d.canvas.rect(f.x-g,f.y-g,f.width+2*g,f.height+2*g);a.wijraphael.addClass(a(e.node),"wijchart-footer-container");e.attr(c.style);e.toBack();d.footerEles.push(b);d.footerEles.push(e)}},_getRotationByCompass:function(b){var a=0;if(b==="east")a=90;else if(b==="west")a=-90;return a},_paintLegend:function(){if(!this.options.legend.visible)return;var b=this,t=b.options,c=a.extend(true,{size:{width:22,height:10}},t.legend),g=2,L=t.seriesStyles,u=[].concat(t.seriesList),r=c.compass,y=c.orientation,i,J,f,e,v=b.canvasBounds,x=v.endX-v.startX,w=v.endY-v.startY,h=c.size.width,I=c.size.height,E,l=0,D=0,m=0,j=0,q=0,p=0,d=1,K=0,k=0,z=0,F=0,n=0,G,A,B,o,H=[],s=0,C=0;if(c.text&&c.text.length){i=b._text(0,0,c.text);a.wijraphael.addClass(a(i.node),"wijchart-legend-title");J=a.extend(true,{},t.textStyle,c.textStyle,c.titleStyle);i.attr(J);b.legendEles.push(i)}if(c.reversed)u=u.reverse();a.each(u,function(f,d){d=a.extend(true,{legendEntry:true,display:"show"},d);function e(e){var n=c.reversed?u.length-1-s:s,l=L[n],m=a.extend(true,{fill:"none",opacity:1,stroke:"black"},l),d,j,k,g=false,f=e.type,i;if(e.legendEntry&&e.display!=="exclude"){j=a.extend(true,{},t.textStyle,c.textStyle);if(c.textWidth)d=b.canvas.wrapText(0,0,e.label,c.textWidth,"far",j);else{d=b._text(0,0,e.label);d.attr(j)}a.wijraphael.addClass(a(d.node),"wijchart-legend-text wijchart-legend");b.legends.push(d);k=a.extend(m,{"stroke-width":1});i=b.canvas.rect(0,0,h,I);a.wijraphael.addClass(a(i.node),"wijchart-legend-icon wijchart-legend");i.attr(k);b.legendIcons.push(i);H.push(k);if(b.widgetName==="wijcompositechart")g=f==="line"||f==="spline"||f==="bezier"||f==="area";else g=b.widgetName==="wijlinechart";if(c.textWidth)a.each(d,function(c,b){if(e.visible===false&&!g){a(b.node).data("hidden",true).data("textOpacity",b.attr("opacity")||1);b.attr("opacity",.3)}a.wijraphael.addClass(a(b.node),"wijchart-legend-text wijchart-legend");a(b.node).data("legendIndex",C).data("index",s)});else{if(e.visible===false&&!g){a(d.node).data("hidden",true).data("textOpacity",d.attr("opacity")||1);d.attr("opacity",.3)}a.wijraphael.addClass(a(d.node),"wijchart-legend-text wijchart-legend");a(d.node).data("legendIndex",C).data("index",s)}C++}s++}if(d.type==="pie"&&d.legendEntry)a.each(d.data,function(c,b){b=a.extend({legendEntry:d.legendEntry},b);e(b)});else if(b._isPieChart())e(d);else{if(d.data.x===undefined&&d.data.xy===undefined||d.data.xy===undefined&&d.data.y===undefined)return true;e(d)}});f=b.legends.length;e=c.textMargin;if(i){E=i.wijGetBBox();l=E.height;D=E.width}a.each(b.legends,function(c,b){var a=b.wijGetBBox();if(a.width>m)m=a.width;if(a.height>j)j=a.height});if(r==="east"||r==="west"){if(y==="horizontal"){q=f*(m+h+g)+f*(e.left+e.right);if(q>x/2){d=Math.floor(x/2/m);if(d<1)d=1}else d=f}else if(y==="vertical"){p=j*f+l+f*(e.top+e.bottom);if(p>w)d=Math.ceil(p/w);else d=1}}else if(r==="south"||r==="north")if(y==="horizontal"){q=(m+h+g)*f+f*(e.left+e.right);if(q>x){d=Math.floor(f/q*x);if(d<1)d=1}else d=f}else if(y==="vertical"){p=j*f+l+f*(e.top+e.bottom);if(p>w/2){K=Math.floor(w-l)/2/j;d=Math.ceil(f/K)}else d=1}if(d===0)d=1;k=d*(m+h+g)+d*(e.left+e.right);z=j*Math.ceil(f/d)+l+Math.ceil(f/d)*(e.top+e.bottom);k=k>D?k:D;G=b._calculatePosition(r,k,z);A=G.x-k/2;B=G.y-z/2;o=b.canvas.rect(A-g,B-g,k+2*g,z+2*g);a.wijraphael.addClass(a(o.node),"wijchart-legend-container");o.attr(c.style);o.toBack();b.legendEles.push(o);i&&i.transform(Raphael.format("...T{0},{1}",A+k/2,B+l/2));F=l;a.each(b.legends,function(s,l){var i=l.wijGetBBox(),f=b.legendIcons[s],p=A+n*(h+m+g)+(n+1)*e.left+n*e.right,q=B+F+i.height/2+e.top+j/2-i.height/2,t=q-f.wijGetBBox().height/2,r,o,k=l;f.wijRemove();f=null;f=b.canvas.rect(p,t,h,I);if(c.textWidth)k=l[0];a(f.node).data("legendIndex",a(k.node).data("legendIndex")).data("index",a(k.node).data("index"));a.wijraphael.addClass(a(f.node),"wijchart-legend-icon wijchart-legend");b.legendIcons[s]=f;r=H[s];if(r){f.attr(r);if(a(k.node).data("hidden")===true){a(k.node).data("iconOpacity",f.attr("opacity")||1);f.attr("opacity",.3)}}if(c.textStyle["text-anchor"]==="start")p-=i.width/2;if(c.textWidth)l.transform(Raphael.format("...T{0},{1}",p+h+g,q-i.height/2));else l.transform(Raphael.format("...T{0},{1}",p+h+g+i.width/2,q));if(Raphael.vml){o=b.canvas.rect(p+h+g,q-i.height/2,i.width,i.height).attr({stroke:"none",fill:"#000000",opacity:.01});a.wijraphael.addClass(a(o.node),"wijchart-legend-textCover wijchart-legend");a(o.node).data("legendIndex",a(k.node).data("legendIndex"));a(o.node).data("index",a(k.node).data("index"));b.legendEles.push(o)}l.toFront();n++;if(n===d){n=0;F+=j+e.top+e.bottom}})},_hasAxes:function(){return this.widgetName==="wijpiechart"?false:true},_applyAxisText:function(i){var j=this,h=i.text,c=null,d=null,b=null,f=0,e=0,g=j.canvasBounds;if(h!==null&&h!==undefined&&h.length>0){d=j._text(-100,-100,h);b=a.extend(true,{},j.options.textStyle,i.textStyle);d.attr(b);c=d.wijGetBBox();if(b["margin-left"])e+=parseFloat(b["margin-left"]);if(b["margin-top"])f+=parseFloat(b["margin-top"]);if(b["margin-right"])e+=parseFloat(b["margin-right"]);if(b["margin-bottom"])f+=parseFloat(b["margin-bottom"]);switch(i.compass){case"north":g.startY+=c.height+f;break;case"south":g.endY-=c.height+f;break;case"east":g.endX-=c.height+e;break;case"west":g.startX+=c.height+e}d.wijRemove();d=null}return c},_isSeriesDataEmpty:function(){var c=this,b=c.options.seriesList;if(!b||b.length===0)return true;a.each(b,function(b,a){if(!a.data||(!a.data.x||!a.data.y)&&!a.data.xy)return true});return false},_paintTooltip:function(){var b=this,h=b.options,d=h.hint,i=!h.disabled&&d.enable,c=d,f,e,g=a.isFunction;if(i&&!b.tooltip){c=a.extend(true,{},d,{});f=d.title;e=d.content;if(g(f))c.title=function(){return b._getTooltipText(f,this.target)};if(g(e))c.content=function(){return b._getTooltipText(e,this.target)};c.beforeShowing=function(){b._onBeforeTooltipShowing(this)};b.tooltip=b.canvas.tooltip(null,c)}},_getTooltipText:function(d,c){var b=a(c.node).data("wijchartDataObj"),e={data:b,label:b.label,x:b.x,y:b.y,target:c,fmt:d};return a.proxy(d,e)()},_onBeforeTooltipShowing:function(b){var a=b.target,c=this.options.hint.style;if(a)b.options.style.stroke=c.stroke||a.attrs.stroke||a.attrs.fill},_paintChartArea:function(){var b=this,p=b.options,c=p.axis,l=2,n=null,k=null,h={},m=5,f=0,g=0,j=a.isArray(c.y),o=0,i,d,e;b._applyMargins();b.isMultiYAxis=j;if(b._isSeriesDataEmpty())return;j&&a.each(c.y,function(d,b){c.y[d]=a.extend(true,{alignment:"center",style:{stroke:"#999999","stroke-width":.5},visible:false,textVisible:true,text:"",textStyle:{fill:"#888","font-size":15,"font-weight":"bold"},labels:{style:{fill:"#333","font-size":11},textAlign:"center",width:null},compass:"west",autoMin:true,autoMax:true,min:null,max:null,origin:null,autoMajor:true,autoMinor:true,unitMajor:null,unitMinor:null,gridMajor:{visible:true,style:{stroke:"#999999","stroke-width":"0.5","stroke-dasharray":"none"}},gridMinor:{visible:false,style:{stroke:"#CACACA","stroke-dasharray":"- "}},tickMajor:{position:"none",style:{fill:"black"},factor:1},tickMinor:{position:"none",style:{fill:"black"},factor:1},annoMethod:"values",annoFormatString:"",valueLabels:[]},b)});if(b._hasAxes()){if(b.innerState.axisInfo){b.axisInfo=b.innerState.axisInfo;b.canvasBounds=b.innerState.canvasBounds}else{n=b._applyAxisText(c.x,{});b.axisInfo={x:{id:"x",tprec:0,isTime:false,offset:0,vOffset:0,max:0,min:0,majorTickRect:null,minorTickRect:null,annoFormatString:null,textBounds:n,axisTextOffset:l,autoMax:true,autoMin:true,autoMajor:true,autoMinor:true,annoMethod:c.x.annoMethod,valueLabels:c.x.valueLabels||[]},y:{}};if(j)a.each(c.y,function(c,a){k=b._applyAxisText(a,{});b.axisInfo.y[c.toString()]={id:"y"+c,tprec:0,isTime:false,offset:0,vOffset:0,max:0,min:0,majorTickRect:null,minorTickRect:null,annoFormatString:null,textBounds:k,axisTextOffset:l,autoMax:true,autoMin:true,autoMajor:true,autoMinor:true,annoMethod:a.annoMethod,valueLabels:a.valueLabels||[]}});else{k=b._applyAxisText(c.y,{});b.axisInfo.y["0"]={id:"y",tprec:0,isTime:false,offset:0,vOffset:0,max:0,min:0,majorTickRect:null,minorTickRect:null,annoFormatString:null,textBounds:k,axisTextOffset:l,autoMax:true,autoMin:true,autoMajor:true,autoMinor:true,annoMethod:c.y.annoMethod,valueLabels:c.y.valueLabels||[]}}b._getSeriesGroup();h=b._getDataExtreme(j);if(c.x.autoMin&&b.axisInfo.x.autoMin)c.x.min=h.txn;else if(c.x.min&&b._isDate(c.x.min))c.x.min=a.toOADate(c.x.min);if(c.x.autoMax&&b.axisInfo.x.autoMax)c.x.max=h.txx;else if(c.x.max&&b._isDate(c.x.max))c.x.max=a.toOADate(c.x.max);a.each(h.y,function(){o++});for(i=0;i<o;i++){d=c.y[i]||c.y;e=i.toString();if(d.autoMin&&b.axisInfo.y[e].autoMin)d.min=h.y[e].tyn;else if(d.min&&b._isDate(d.min))d.min=a.toOADate(d.min);if(d.autoMax&&b.axisInfo.y[e].autoMax)d.max=h.y[e].tyx;else if(d.max&&b._isDate(d.max))d.max=a.toOADate(d.max);do{g=b._autoPosition(b.axisInfo,c,"y",e);f=b._autoPosition(b.axisInfo,c,"x",e);if(g===b.axisInfo.y[e].offset&&f===b.axisInfo.x.offset){m=0;break}if(!isNaN(f)&&!isNaN(g)){if(g!==b.axisInfo.y[e].offset&&g!==0){b.axisInfo.y[e].offset=g;b.axisInfo.y[e].vOffset=f}if(f!==b.axisInfo.x.offset&&f!==0){b.axisInfo.x.offset=f;b.axisInfo.x.vOffset=g}}m--}while(m>0)}b._adjustPlotArea(c.x,b.axisInfo.x);b._adjustPlotArea(c.y,b.axisInfo.y,true);b.innerState.axisInfo=b.axisInfo;b.innerState.canvasBounds=b.canvasBounds}b._paintAxes();b._paintPlotArea()}else b._paintPlotArea()},_getSeriesGroup:function(){var c=this,d=c.options,b={};a.each(d.seriesList,function(c,a){if(a.yAxis)if(b[a.yAxis.toString()])b[a.yAxis.toString()].push(a);else b[a.yAxis.toString()]=[a];else if(b["0"])b["0"].push(a);else b["0"]=[a]});c.seriesGroup=b},_adjustPlotArea:function(e,d,f){var c=this.canvasBounds,g,b={east:Number.MIN_VALUE,west:Number.MIN_VALUE,south:Number.MIN_VALUE,north:Number.MIN_VALUE};if(f){a.each(d,function(a){g=a});a.each(d,function(f,a){var c=e[f]||e,d=c.compass;c.max=a.max;c.min=a.min;switch(d){case"north":b.north=Math.max(a.offset,b.north);break;case"south":b.south=Math.max(a.offset,b.south);break;case"east":b.east=Math.max(a.offset,b.east);break;case"west":b.west=Math.max(a.offset,b.west)}});if(b.north!==Number.MIN_VALUE)c.startY+=b.north;if(b.south!==Number.MIN_VALUE)c.endY-=b.south;if(b.east!==Number.MIN_VALUE)c.endX-=b.east;if(b.west!==Number.MIN_VALUE)c.startX+=b.west}else{e.max=d.max;e.min=d.min;switch(e.compass){case"north":c.startY+=d.offset;break;case"south":c.endY-=d.offset;break;case"east":c.endX-=d.offset;break;case"west":c.startX+=d.offset}}},_autoPosition:function(b,a,c,d){return this._autoPositionCartesianAxis(b,a,c,d)},_autoPositionCartesianAxis:function(m,g,p,i){var h=this,o=null,b,e,k,n,c,j,q,r,f=h.lastAxisOffset||{},d,l;if(p==="y"){b=m.y[i];e=g.y[i]||g.y;n=g.x;k=m.x}else{b=m.x;e=g.x;k=m.y[i];n=g.y[i]||g.y}c=e.compass;j=n.origin;q=k.max;r=k.min;if(j!==null&&h._isDate(j))j=a.toOADate(j);h._calculateParameters(b,e);o=h._getMaxExtents(b,e);switch(c){case"north":case"south":d=o.height;b.maxExtent=d;break;case"east":case"west":d=o.width;b.maxExtent=d}if(p==="y"&&f[c]){a.each(f[c],function(b,a){if(b!==i)l=a});if(l){b.preStartOffset=l;d+=l}}if(p==="y"){if(f[c]===undefined)f[c]={};f[c][i]=d+h._getAxisLabelBox(e).width;h.lastAxisOffset=f}return d},_getAxisLabelBox:function(d){var f=this,m=f.options,l=d.text,j=0,h=0,i=0,g=0,c,e,k=f._isVertical(d.compass),b=a.extend(true,{},m.textStyle,d.textStyle);if(b["margin-top"])j=parseFloat(b["margin-top"]);if(b["margin-left"])i=parseFloat(b["margin-left"]);if(b["margin-right"])h=parseFloat(b["margin-right"]);if(b["margin-bottom"])g=parseFloat(b["margin-bottom"]);c=f._text(0,0,l);c.attr(b);k&&c.transform("...R-90");e=c.wijGetBBox();c.wijRemove();c=null;return{width:e.width+i+h,height:e.height+g+j}},_getMaxExtents:function(b,f,o){var c=this,p=c.options,i=null,e={width:0,height:0},u=b.min,t=b.max,s=b.isTime,d=f.annoFormatString,r=p.is100Percent,l=0,q=f.compass,h=f.labels,g,m=false,n=c.canvasBounds,j,k;b.majorTickRect=c._getTickRect(b,f,true,true,o);b.minorTickRect=c._getTickRect(b,f,false,true,o);i=c._getMajorTickValues(b,f);if(!f.textVisible)return e;if(!d||d.length===0)d=b.annoFormatString;g=a.extend(true,{},p.textStyle,f.textStyle,h.style);k=g.transform;k&&k.length&&a.each(k,function(b,a){if(a[0].toLowerCase()==="r"){m=true;return false}});g=a.extend(true,g,b.textStyle);j=n.endX-n.startX-b.vOffset-b.axisTextOffset;if(i&&i.length){j=j/(i.length-1);a.each(i,function(o,f){var k,i,n;if(f<u||f>t)return true;if(b.annoMethod==="valueLabels"){if(f<0)return true;if(l>=b.valueLabels.length)return false;f=b.valueLabels[l];if(f.text)f=f.text;else if(typeof f.value!=="undefined"){f=f.value;if(d&&d.length)f=Globalize.format(f,d,c._getCulture())}}else if(b.annoMethod==="values")if(d&&d.length){if(s)f=a.fromOADate(f);f=Globalize.format(f,d,c._getCulture())}else if(r&&b.id==="y")f=Globalize.format(f,"p0",c._getCulture());if(h.width)k=c.canvas.wrapText(-100,-100,f,h.width,h.textAlign,g);else k=c._text(-100,-100,f).attr(g);i=k.wijGetBBox();if(!c._isVertical(q)&&!m&&b.annoMethod==="valueLabels")if(i.width>j){k.attr({transform:"r-45"});i=k.wijGetBBox();if(o===0){g.transform="r-45";b.textStyle={transform:"r-45"};n=k.clone();n.attr({transform:"r0"});i=n.wijGetBBox();if(Math.sqrt(2)*i.height>j){k.attr({transform:"r-90"});g.transform="r-90";b.textStyle={transform:"r-90"}}n.wijRemove();n=null;i=k.wijGetBBox()}}k.wijRemove();k=null;if(i.width>e.width)e.width=i.width;if(i.height>e.height)e.height=i.height;l++})}if(e.width<h.width)e.width=h.width;b.labelWidth=e.width;return e},_getMajorTickValues:function(c,e){var d=[],b=c.valueLabels;b&&b.length>0&&a.each(b,function(c,a){if(typeof a.text!=="undefined"||typeof a.value!=="undefined")return false;if(typeof a==="string")b[c]={text:a,gridLine:false};else b[c]={value:a,gridLine:false}});if(c.annoMethod==="valueLabels"&&b&&b.length>0&&typeof b[0].value!=="undefined"){d=this._getSortedDataValues(c,e);return d}d=this._getTickValues(c.max,c.min,e.unitMajor,c.tprec,!c.isTime,e.autoMajor);return d},_getSortedDataValues:function(d){var e=this,b=[],c=d.valueLabels;a.each(c,function(f,d){var c=d.value;if(e._isDate(c))b.push(a.toOADate(c));else if(typeof c==="number")b.push(c);else b.push(f)});return b},_getMinorTickValues:function(a,b){var c=[];c=this._getTickValues(a.max,a.min,b.unitMinor,a.tprec,!a.isTime,b.autoMinor);return c},_getTickValues:function(f,b,c,g,o,l){var p=this,i=[],n=b,e=0,h=0,m=0,k=0,d=0,j=0;try{if(c===0)i=[f,b];else{if(l){if(g+1<0)g=-1;else if(g+1>15)g=14;j=a.round(p._signedCeiling(b/c)*c,g+1);if(j<f)b=j;m=parseInt(a.round(f/c,5),10);k=parseInt(a.round(b/c,5),10);d=parseInt(m-k+1,10);if(d>1){h=k*c;if(h<b){d--;b+=c}h=b+(d-1)*c;if(h>f)d--}if(d<1){d=2;b=n;c=f-b}}else{d=parseInt((f-b)/c+1,10);if(d>1){h=b+(d-1)*c;if(h>f)d--}if(d<1){d=2;c=f-b}}for(e=0;e<d;e++)if(o)if(l)i[e]=a.round(b+e*c,g+1);else i[e]=b+e*c;else i[e]=b+e*c}}catch(q){}return i},_getTickRect:function(m,d,l,e){var c=d.compass,f=0,a=null,j=3,k=2,i=2,g=d.tickMajor.factor,h=d.tickMinor.factor,b={x:0,y:0,width:0,height:0};if(l){a=d.tickMajor.position;g=g>0?g:1;f=j*g}else{a=d.tickMinor.position;h=h>0?h:1;f=k*h}if(a==="none"||a==="inside"&&e)f=0;if(c==="east"||c==="west"){b={x:0,y:-1,width:f*i,height:i};if(c==="east"&&(a==="outside"||a==="cross"&&e)||c==="west"&&a==="inside")b.width+=2;else if(!e){if(a==="cross")b.width<<=1;b.width+=2}}else{b={x:-1,y:0,width:i,height:f*i};if(c==="south"&&(a==="outside"||a==="corss"&&e)||c==="north"&&a==="inside")b.height+=2;else if(!e){if(a==="cross")b.height<<=1;b.height+=2}}return b},_applyMargins:function(){var c=this,b=c.options,a=c.canvasBounds;a.startX+=b.marginLeft;a.endX-=b.marginRight;a.startY+=b.marginTop;a.endY-=b.marginBottom},_paintAxes:function(){var b=this,h=b.options.axis,g=b.axisInfo,c=h.x,e=h.y,f=g.x,i=g.y,d;d=b._paintAxis(c,f);a.each(i,function(g,f){var a=e[g]||e;a.origin!==null&&b._translateAxisIfNeeded(d,c.compass,a.origin,a.compass,f.max,f.min)});a.each(i,function(h,g){var a=e[h]||e;d=b._paintAxis(a,g);c.origin!==null&&b._translateAxisIfNeeded(d,a.compass,c.origin,c.compass,f.max,f.min)})},_translateAxisIfNeeded:function(g,h,l,i,e,f){var j=this,k=i==="west"||i==="east",b=j.canvasBounds,c=l,d;if(j._isDate(c))c=a.toOADate(c);if(!k){if(h==="west")d=(c-f)/(e-f)*(b.endX-b.startX);else d=(c-e)/(e-f)*(b.endX-b.startX);a.each(g,function(b,a){a.transform(Raphael.format("...T{0},{1}",d,0))})}else{if(h==="south")d=(f-c)/(e-f)*(b.endY-b.startY);else d=(e-c)/(e-f)*(b.endY-b.startY);a.each(g,function(b,a){a.transform(Raphael.format("...T{0},{1}",0,d))})}},_paintAxis:function(c,b){var e=this,B=e.options,d=e.canvasBounds,f={x:0,y:0},g={x:0,y:0},s=c.compass,k=2,q=true,o=null,p=[],u=[],v=[],m=b.max,n=b.min,I=c.unitMajor,J=c.unitMinor,G=c.tickMajor.position,H=c.tickMinor.position,A=b.maxExtent,C=c.tickMajor.style,D=c.tickMinor.style,x=b.majorTickRect,y=b.minorTickRect,w=b.axisTextOffset,E=c.gridMajor,F=c.gridMinor,j=c.labels,t=0,z=[],l=0,h=c.annoFormatString,r=null,i=[];x=e._getTickRect(b,c,true,false);y=e._getTickRect(b,c,false,false);if(!h||h.length===0)h=b.annoFormatString;p=e._getMajorTickValues(b,c);u=e._getMinorTickValues(b,c);v=e._resetMinorTickValues(u,p);switch(s){case"south":f.x=d.startX;f.y=d.endY;g.x=d.endX;g.y=d.endY;q=false;break;case"north":f.x=d.startX;f.y=d.startY-k;g.x=d.endX;g.y=d.startY-k;q=false;break;case"east":f.x=d.endX-k;if(b.preStartOffset)f.x+=b.preStartOffset;f.y=d.endY;g.x=d.endX-k;g.y=d.startY;break;case"west":f.x=d.startX;if(b.preStartOffset)f.x-=b.preStartOffset;f.y=d.endY;g.x=d.startX;g.y=d.startY}if(c.visible){o=e.canvas.line(f.x,f.y,g.x,g.y).attr(c.style);a.wijraphael.addClass(a(o.node),"wijchart-axis");e.axisEles.push(o);i.push(o)}a.each(p,function(D,k){var d=k,y=b.isTime,v=B.is100Percent,p,o,u=false,q={};if(k<n||k>m){l++;return true}if(b.annoMethod==="valueLabels"){if(l>=b.valueLabels.length)return false;d=b.valueLabels[l];u=d.gridLine;q=d.gridLineStyle;if(d.text)d=d.text;else if(typeof d.value!=="undefined"){d=d.value;if(h&&h.length)d=Globalize.format(d,h,e._getCulture())}}else if(b.annoMethod==="values")if(h&&h.length){if(y)d=a.fromOADate(k);d=Globalize.format(d,h,e._getCulture())}else if(v&&b.id==="y")d=Globalize.format(k,"p0",e._getCulture());r=a.extend(true,{},B.textStyle,c.textStyle,j.style,b.textStyle);p=e._paintMajorMinor(m,n,k,G,I,x,s,f,g,A,w,C,d,E,c.textVisible,r,j.textAlign,j.width?b.labelWidth:null,u,q);if(p){if(p.elements)i=i.concat(p.elements);o=p.textInfo}if(o){z.push(o);if(t<o.len)t=o.len}l++});!j.width&&a.each(z,function(d,c){var b=c.text,a=(c.len-t)/2;a=j.textAlign==="near"?a*-1:a;if(q)b.transform(Raphael.format("...T{0},{1}",a,0));else b.transform(Raphael.format("...T{0},{1}",0,a))});a.each(v,function(h,d){var a;if(d>n&&d<m){a=e._paintMajorMinor(m,n,d,H,J,y,s,f,g,A,w,D,null,F,c.textVisible,r,j.textAlign,j.width?b.labelWidth:null);if(a&&a.elements)i=i.concat(a.elements)}});c.text&&c.text.length>0&&i.push(e._paintAxisText(c,b));return i},_paintAxisText:function(d,f){if(!d.text||d.text.length===0)return;var j=this,z=d.text,p=d.compass,x=d.alignment,l=j.canvasBounds,m=l.startX,n=l.startY,q=l.endX,r=l.endY,h=m,i=n,c=f.textBounds,o=j._isVertical(p),k=f.axisTextOffset,s=f.majorTickRect,y=d.tickMajor.position,e=o?s.width:s.height,b=null,g=null,w=0,v=0,u=0,t=0;b=a.extend(true,{},j.options.textStyle,d.textStyle);if(b["margin-top"])w=parseFloat(b["margin-top"]);if(b["margin-left"])v=parseFloat(b["margin-left"]);if(b["margin-right"])u=parseFloat(b["margin-right"]);if(b["margin-bottom"])t=parseFloat(b["margin-bottom"]);if(y==="cross")e=e/2;else if(y==="inside")e=0;if(o){switch(x){case"near":i=r-c.width/2;break;case"center":i=(n+r)/2;break;case"far":i=n+c.width/2}if(p==="west")h=m-(f.offset+k+e+c.height/2+u);else h=q+f.offset+k+e+c.height/2+v}else{switch(x){case"near":h=m+c.width/2;break;case"center":h=(m+q)/2;break;case"far":h=q-c.width/2}if(p==="north")i=n-(f.offset+k+e+c.height/2+t);else i=r+f.offset+k+e+c.height/2+w}g=j._text(h,i,z);a.wijraphael.addClass(a(g.node),"wijchart-axis-text");j.axisEles.push(g);g.attr(b);o&&g.transform("...R-90");return g},_resetMinorTickValues:function(a,d){for(var b=0,c=0,f=null,e=null,b=a.length-1;b>=0;b--){f=a[b];for(c=d.length-1;c>=0;c--){e=d[c];f===e&&a.splice(b,1)}}return a},_paintMajorMinor:function(J,u,K,h,L,c,j,t,G,o,k,x,A,q,C,F,E,l,D,B){var f=this,e=t.x,b=t.y,m=-1,n=-1,s=true,g=f.canvasBounds,H=null,r=null,y=[],p=[],d=null,z={"stroke-width":2},i={text:null,len:0},w=null,I={},v=[];switch(j){case"south":if(h==="inside")b-=c.height;else if(h==="cross")b-=c.height/2;if(l)n=b+k+c.height;else n=b+k+c.height+o/2;s=false;break;case"west":if(h==="outside")e-=c.width;else if(h==="cross")e-=c.width/2;if(l)m=e-(k+o);else m=e-(k+o/2);break;case"north":if(h==="outside")b-=c.height;else if(h==="cross")b-=c.height/2;if(l)n=b-(k+o);else n=b-(k+o/2);s=false;break;case"east":if(h==="inside")e-=c.width;else if(h==="cross")e-=c.width/2;if(l)m=e+k+c.width;else m=e+k+c.width+o/2}if(s){b+=(K-u)/(J-u)*(G.y-t.y);p=["M",g.startX,b,"H",g.endX];if(q.visible)if(b!==g.startY&&j==="east"||b!==g.endY&&j==="west"){d=f.canvas.path(p.concat(" "));a.wijraphael.addClass(a(d.node),"wijchart-axis-gridline");d.attr(q.style);f.axisEles.push(d)}if(D)if(b!==g.startY&&j==="east"||b!==g.endY&&j==="west"){d=f.canvas.path(p.concat(" "));a.wijraphael.addClass(a(d.node),"wijchart-axis-gridline");d.attr(a.extend(true,q.style,B));f.axisEles.push(d)}n=b;if(h!=="none"){y=["M",e,b,"h",c.width];x["stroke-width"]=c.height}}else{e+=(K-u)/(J-u)*(G.x-t.x);p=["M",e,g.startY,"V",g.endY];if(q.visible)if(e!==g.startX&&j==="south"||e!==g.endX&&j==="north"){d=f.canvas.path(p.concat(" "));a.wijraphael.addClass(a(d.node),"wijchart-axis-gridline");d.attr(q.style);f.axisEles.push(d)}if(D)if(b!==g.startY&&j==="south"||b!==g.endY&&j==="north"){d=f.canvas.path(p.concat(" "));a.wijraphael.addClass(a(d.node),"wijchart-axis-gridline");d.attr(a.extend(true,{},q.style,B));f.axisEles.push(d)}if(l)m=e-l/2;else m=e;if(h!=="none"){y=["M",e,b,"v",c.height];x["stroke-width"]=c.width}}if(h!=="none"){r=f.canvas.path(y.concat(" "));a.wijraphael.addClass(a(r.node),"wijchart-axis-tick");z=a.extend(z,x);r.attr(z);f.axisEles.push(r);v.push(r)}if(A!==null&&C){if(l){i=f.canvas.wrapText(m,n,A.toString(),l,E,F);a.wijraphael.addClass(a(i.node),"wijchart-axis-label")}else{i=f._text(m,n,A.toString());a.wijraphael.addClass(a(i.node),"wijchart-axis-label");i.attr(F)}f.axisEles.push(i);v.push(i);!C&&i.hide();if(E!=="center"){w=i.getBBox();H={text:i,len:s?w.width:w.height}}}I={textInfo:H,elements:v};return I},_paintPlotArea:function(){},_paintChartLabels:function(){var c=this,b=c.options.chartLabels;b&&b.length&&a.each(b,function(e,b){var d;b=a.extend(true,{compass:"east",attachMethod:"coordinate",attachMethodData:{seriesIndex:-1,pointIndex:-1,x:-1,y:-1},offset:0,visible:false,text:"",connected:false},b);if(b.visible){d=c._getChartLabelPointPosition(b);if(typeof d.x!=="number"||typeof d.y!=="number")return false;c._setChartLabel(b,d)}})},_getChartLabelPointPosition:function(){},_setChartLabel:function(d,g,o,l){var c=this,n=d.compass,k=c.options,m=a.extend(true,{},k.textStyle,k.chartLabelStyle),e=c._text(0,0,d.text).attr(m),h=d.offset,i=0,j=0,b=null,f=null;a.wijraphael.addClass(a(e.node),"wijchart-label-text");c.chartLabelEles.push(e);b=c._getCompassTextPosition(n,e.wijGetBBox(),h,g,o);if(h&&d.connected){f=c.canvas.path("M"+g.x+" "+g.y+"L"+b.endPoint.x+" "+b.endPoint.y);a.wijraphael.addClass(a(f.node),"wijchart-label-connect");f.attr(l);c.chartLabelEles.push(f)}i=b.endPoint.x+b.offsetX;j=b.endPoint.y+b.offsetY;e.transform(Raphael.format("...T{0},{1}",i,j)).toFront()},_getCompassTextPosition:function(h,c,i,g,b){var d=0,e=0,f={x:0,y:0};switch(h.toLowerCase()){case"east":b=0;break;case"west":b=180;break;case"north":b=90;break;case"south":b=270;break;case"northeast":b=45;break;case"northwest":b=135;break;case"southeast":b=315;break;case"southwest":b=225}if(b>=0&&b<45/2||b>675/2&&b<360)d=c.width/2;else if(b>=45/2&&b<135/2){d=c.width/2;e=c.height/-2}else if(b>=135/2&&b<225/2)e=c.height/-2;else if(b>=225/2&&b<315/2){d=c.width/-2;e=c.height/-2}else if(b>=315/2&&b<405/2)d=c.width/-2;else if(b>=405/2&&b<495/2){d=c.width/-2;e=c.height/2}else if(b>=495/2&&b<585/2)e=c.height/2;else{d=c.width/2;e=c.height/2}f=a.wijraphael.getPositionByAngle(g.x,g.y,i,b);return{endPoint:f,offsetX:d,offsetY:e}},_mouseDown:function(b,a){this._trigger("mouseDown",b,a)},_mouseUp:function(b,a){this._trigger("mouseUp",b,a)},_mouseOver:function(b,a){this._trigger("mouseOver",b,a)},_mouseOut:function(b,a){this._trigger("mouseOut",b,a)},_mouseMove:function(b,a){this._trigger("mouseMove",b,a)},_click:function(b,a){this._trigger("click",b,a)},_mouseMoveInsidePlotArea:function(){},_mouseMoveOutsidePlotArea:function(){},_bindLiveEvents:function(){this._bindLegendEvents();this._bindCanvasEvents()},_bindCanvasEvents:function(){var a=this,b=a.chartElement;b.bind("mousemove",function(e){var f=b.offset(),d=a.canvasBounds,c={left:e.pageX-f.left,top:e.pageY-f.top},g=a.options.disabled;if(g)return;if(c.left>=d.startX&&c.left<=d.endX&&c.top>=d.startY&&c.top<=d.endY)a._mouseMoveInsidePlotArea(e,c);else a._mouseMoveOutsidePlotArea(e,c)})},_bindLegendEvents:function(){var b=this,d=b.chartElement,c=b.widgetName;a(".wijchart-legend",d[0]).live("click."+c,function(d){if(b.options.disabled)return;var c=a(d.target);if(c[0].tagName&&c[0].tagName==="tspan")c=c.parent();b._legendClick(c)})},_legendClick:function(j){if(typeof j.data("index")==="undefined")return;var c=this,k=c.options.legend,h=j.data("index"),l=j.data("legendIndex"),i=c.chartElement.data("fields"),m=c.seriesEles,g,f=c.legendIcons[l],e=c.legends[l],b=k.textWidth?a(e[0].node):a(e.node),n=h,d;if(i&&i.seriesEles)m=i.seriesEles;if(c.legendDots&&c.legendDots.length>h)d=c.legendDots[h];if(k.reversed)n=c.legends.length-1-h;g=m[n];if(g)if(!b.data("hidden")){c._hideSerieEles(g);if(!b.data("textOpacity"))if(k.textWidth)b.data("textOpacity",e[0].attr("opacity")||1);else b.data("textOpacity",e.attr("opacity")||1);!b.data("iconOpacity")&&b.data("iconOpacity",f.attr("opacity")||1);d&&!b.data("dotOpacity")&&b.data("dotOpacity",f.attr("opacity")||1);e.attr("opacity","0.3");f.attr("opacity","0.3");d&&d.attr("opacity","0.3");b.data("hidden",true)}else{c._showSerieEles(g);e.attr("opacity",b.data("textOpacity"));f.attr("opacity",b.data("iconOpacity"));d&&d.attr("opacity",b.data("dotOpacity"));b.data("hidden",false)}},_showSerieEles:function(){},_hideSerieEles:function(){},_unbindLiveEvents:function(){var d=this,c=this.chartElement,b=d.widgetName;a(".wijchart-legend",c[0]).die(b).die("."+b);c.unbind("mousemove")},_isBarChart:function(){return false},_isPieChart:function(){return false},_calculateParameters:function(c,g){var d=this,b=g.max,a=g.min,o=g.autoMax&&c.autoMax,m=g.autoMin&&c.autoMin,r=g.autoMajor&&c.autoMajor,s=g.autoMinor&&c.autoMinor,h=null,k=null,p=c.annoMethod==="valueLabels",e=0,i=0,j=0,f=0,l=0,n=c.isTime,q=d.options.adjustMinValue;if(o&&b!==Number.MIN_VALUE)if(c.id!=="x"&&d._isBarChart())if(b<0&&.5*(b-a)>-b)b=0;if(m&&a!==Number.MAX_VALUE)if(c.id!=="x"&&d._isBarChart())if(a>0&&.5*(b-a)>a)a=0;if(b===a){if(a!==0)a-=1;b+=1}f=b-a;if(n){h=g.annoFormatString;if(!h||h.length===0){h=d._getTimeDefaultFormat(b,a);c.annoFormatString=h}l=d._niceTimeUnit(0,h)}k=d._nicePrecision(f);c.tprec=k;if(o)if(n){i=d._roundTime(b,l,true);if(i<b)b=i+l;else b=i}else{i=d._precCeil(-k,b);if(typeof i==="number")b=i}if(m)if(n){j=d._roundTime(a,l,false);if(j>a)a=j-l;else a=j}else{j=d._precFloor(-k,a);if(typeof j==="number")a=j}c.max=b;c.min=a;c.annoFormatString=h;c.tinc=l;if(r||s){f=b-a;d._calculateMajorMinor(g,c);e=g.unitMajor;if(o&&e!==0&&!n&&!p){f=b-parseInt(b/e,10)*e;if(f!==0){b+=e-f;b=d._precCeil(-k,b)}}if(m&&e!==0&&!n&&!p){f=a-parseInt(a/e,10)*e;if(f!==0){if(f<0)f+=e;a-=Math.abs(f);a=d._precFloor(-k,a)}}if(m&&e!==0&&!p&&(typeof q==="undefined"||q===false)&&m&&a===g.min&&a-e>=0&&c.id==="y")a-=e}c.max=b;c.min=a},_roundTime:function(k,g,e){var c=this,d=g,f=a.fromOADate(k),b,h,j,i;if(d>0){b={year:f.getFullYear(),month:f.getMonth(),day:f.getDate(),hour:f.getHours(),minute:f.getMinutes(),second:f.getSeconds()};if(d<c._tmInc.minute){b.second=c._tround(b.second,d,e);return c._getTimeAsDouble(b)}b.second=0;if(d<c._tmInc.hour){d/=c._tmInc.minute;b.minute=c._tround(b.minute,d,e);return c._getTimeAsDouble(b)}b.minute=0;if(d<c._tmInc.day){d/=c._tmInc.hour;b.hour=c._tround(b.hour,d,e);return c._getTimeAsDouble(b)}b.hour=0;if(d<c._tmInc.month){d/=c._tmInc.day;b.day=c._tround(b.day,d,e);return c._getTimeAsDouble(b)}b.day=1;if(d<c._tmInc.year){d/=c._tmInc.month;b.month=c._tround(b.month,d,e);return c._getTimeAsDouble(b)}b.month=0;d/=c._tmInc.year;b.year=c._tround(b.year,d,e);return c._getTimeAsDouble(b)}else{h=f;j=h-d;i=parseInt(j/g,10)*g;if(e&&i!==j)i+=g;h=d+i;return h}},_tround:function(c,a,d){var b=parseInt(c/a*a,10);if(d&&b!==c)b+=parseInt(a,10);return b},_getTimeAsDouble:function(b){var e=0,d=0,c=null;if(b.day<1){d=-1-b.day;b.day=1}else if(b.day>28){d=b.day-28;b.day=28}if(b.month<0){e=-1-b.day;b.month=0}else if(b.month>11){e=b.month-11;b.month=11}c=new Date(b.year,b.month,b.day,b.hour,b.minute,b.second);c.setDate(c.getDate()+d);c.setMonth(c.getMonth()+e);return a.toOADate(c)},_getTimeDefaultFormat:function(d,e){var c=this,b=d-e,a="d";if(b>2*c._tmInc.year)a="yyyy";else if(b>c._tmInc.year)a="MMM yy";else if(b>3*c._tmInc.month)a="MMM";else if(b>2*c._tmInc.week)a="MMM d";else if(b>2*c._tmInc.day)a="ddd d";else if(b>c._tmInc.day)a="ddd H:mm";else if(b>c._tmInc.hour)a="H:mm";else if(b>=1e3)a="H:mm:ss";return a},_niceTimeUnit:function(c,b){var d=this,a=c;a=d._niceTimeSpan(a,b);return a},_niceTimeSpan:function(f,e){var a=this,c=a._manualTimeInc(e),d=0,b=0;d=Math.ceil(f);if(d===0)return a._timeSpanFromTmInc(c);b=1;if(c<a._tmInc.minute){if(d<a._tmInc.minute){b=a._getNiceInc([1,2,5,10,15,30],d,c);if(b!==0)return b}c=a._tmInc.minute}if(c<a._tmInc.hour){if(d<a._tmInc.hour){b=a._getNiceInc([1,2,5,10,15,30],d,c);if(b!==0)return b}c=a._tmInc.hour}if(c<a._tmInc.day){if(d<a._tmInc.day){b=a._getNiceInc([1,3,6,12],d,c);if(b!==0)return b}c=a._tmInc.day}if(c<a._tmInc.month){if(d<a._tmInc.month){b=a._getNiceInc([1,2,7,14],d,c);if(b!==0)return b}c=a._tmInc.month}if(c<a._tmInc.year){if(d<a._tmInc.year){b=a._getNiceInc([1,2,3,4,6],d,c);if(b!==0)return b}c=a._tmInc.year}b=100*a._tmInc.year;if(d<b){b=a._getNiceInc([1,2,5,10,20,50],d,c);if(b===0)b=100*a._tmInc.year}return b},_getNiceInc:function(c,f,d){for(var b=0,a=0,e=c.length,b=0;b<e;b++){a=c[b]*d;if(f<=a)return a}return 0},_timeSpanFromTmInc:function(a){var b=1e3,d=a,c=1;if(a!==this._tmInc.maxtime)if(a>this._tmInc.tickf1)b=a;else{a+=7;while(d>0){c*=10;d--}b=c}return b},_manualTimeInc:function(a){var c=this,b=c._tmInc.second;if(!a||a.length===0)return b;if(a.indexOf("s")>=0)b=c._tmInc.second;else if(a.indexOf("m")>=0)b=c._tmInc.minute;else if(a.indexOf("h")>=0||a.indexOf("H")>=0)b=c._tmInc.hour;else if(a.indexOf("d")>=0)b=c._tmInc.day;else if(a.indexOf("M")>=0)b=c._tmInc.month;else if(a.indexOf("y")>=0)b=c._tmInc.year;return b},_tmInc:{tickf7:-7e3,tickf6:-6e3,tickf5:-5e3,tickf4:-4e3,tickf3:-3e3,tickf2:-2e3,tickf1:-1,second:1e3,minute:6e4,hour:36e5,day:864e5,week:6048e5,month:26784e5,year:31536e6,maxtime:2147483647},_niceTickNumber:function(a){if(parseFloat(a)===0)return a;else if(a<0)a=-a;var e=Math.log(a)/Math.log(10),d=parseInt(this._signedFloor(e),10),c=a/Math.pow(10,d),b=10;if(c<=1)b=1;else if(c<=2)b=2;else if(c<=5)b=5;return b*Math.pow(10,d)},_niceNumber:function(c,d,e){if(parseFloat(c)===0)return c;else if(c<0)c=-c;var b=c/Math.pow(10,d),a=10;if(e){if(b<1.5)a=1;else if(b<3)a=2;else if(b<7)a=5}else if(b<=1)a=1;else if(b<=2)a=2;else if(b<=5)a=5;return a*Math.pow(10,d)},_nicePrecision:function(a){if(a<=0||typeof a!=="number")return 0;var c=Math.log(a)/Math.log(10),b=parseInt(this._signedFloor(c),10),d=a/Math.pow(10,b);if(d<3)b=-b+1;return b},_precCeil:function(d,c){var b=Math.pow(10,d),a=c/b;a=Math.ceil(a);return a*b},_precFloor:function(d,c){var b=Math.pow(10,d),a=c/b;a=Math.floor(a);return a*b},_signedCeiling:function(a){return a<0?Math.floor(a):Math.ceil(a)},_signedFloor:function(a){return a<0?Math.ceil(a):Math.floor(a)},_getDataExtreme:function(c){var b={txx:0,txn:0,tyx:0,tyn:0},a;a=this._getDataExtremes(b,c);if(a){if(a.txn>a.txx){a.txn=0;a.txx=1}return a}else{if(b.txn>b.txx){b.txn=0;b.txx=1}return b}},_getDataExtremes:function(b){var f=this,k=f.options,n=k.seriesList,p=k.stacked,o=k.is100Percent,d=k.axis,c=f.axisInfo,e=[],l=[],i=[],h,j={y:{}},g=d.x.valueLabels,m=c.x.annoMethod,r=c.y.annoMethod;if(!n||n.length===0)return b;f.seriesGroup&&a.each(f.seriesGroup,function(k,n){var g=[],m=parseInt(k,10);a.each(n,function(n,i){if(i.type==="pie")return true;i=a.extend(true,{display:"show"},i);var c=i.data,m=0,j=0,k=[].concat(c.xy),o=k.length,d,h;if(i.display==="exclude")return true;e=[].concat(c.x);g=[].concat(c.y);if(c.xy&&o){e=[];g=[];while(j<o){e[m]=k[j];g[m]=k[j+1];j+=2;m++;c.x=e;c.y=g}}else if(!c.x){e=[];a.each(g,function(a){e.push(a)});c.x=e}p&&n>0&&a.each(g,function(a){g[a]+=l[a]});l=g;d=f._getMinMaxValue(e);h=f._getMinMaxValue(g);if(n===0){b.txx=d.max;b.txn=d.min;b.tyx=h.max;b.tyn=h.min}else{if(b.txx<d.max)b.txx=d.max;if(b.txn>d.min)b.txn=d.min;if(b.tyx<h.max)b.tyx=h.max;if(b.tyn>h.min)b.tyn=h.min}n++});if(o){b.tyx=1;b.tyn=0}j.y[k]={tyx:b.tyx,tyn:b.tyn};j.txx=b.txx;j.txn=b.txn;b.tyx=0;b.tyn=0;if(g.length){h=a.wijchart.getFirstValidListValue(g);if(f._isDate(h))c.y[k].isTime=true;else if(typeof h==="undefined")return true;else if(typeof h!=="number"){a.each(g,function(e,c){var b=d.y.annoFormatString,a=c;if(b&&b.length>0)a=Globalize.format(a,b,f._getCulture());else a=a.toString();i.push({text:a,value:c,gridLine:false})});c.y[k].annoMethod="valueLabels";if(!d.y[m].valueLabels&&d.y[m].valueLabels.length===0)c.y[k].valueLabels=i;else c.y[k].valueLabels=d.y[m].valueLabels;d.x.max=g.length-1;d.x.min=0;d.y[m].unitMajor=1;d.x.unitMinor=.5;c.y[k].autoMax=false;c.y[k].autoMin=false;c.y[k].autoMajor=false;c.y[k].autoMinor=false}}});if(e.length){h=a.wijchart.getFirstValidListValue(e);if(m==="valueLabels"&&g&&g.length>0)c.x.valueLabels=g;if(f._isDate(h))c.x.isTime=true;else if(typeof h!=="number"){a.each(e,function(d,h){var e={},b,c;if(m==="valueLabels"&&g&&g.length&&d<g.length){b=g[d];c=typeof b;if(c==="string")b={text:b};else if(c==="number"||f._isDate(b))b={value:b}}e=a.extend({text:h,value:d,gridLine:false},b);i.push(e)});d.x.max=e.length-1;d.x.min=0;d.x.unitMajor=1;d.x.unitMinor=.5;c.x.annoMethod="valueLabels";c.x.valueLabels=i;c.x.autoMax=false;c.x.autoMin=false;c.x.autoMajor=false;c.x.autoMinor=false}}return j},_isDate:function(a){return!a?false:typeof a==="object"&&a.constructor===Date},_getMinMaxValue:function(c){var f=this,b={min:0,max:0},d=0,e;if(!c.length)return b;e=a.wijchart.getFirstValidListValue(c);if(typeof e!=="number")if(f._isDate(e)){b.min=e;b.max=e}else{b.min=0;b.max=c.length-1;return b}else{b.min=e;b.max=e}for(d=0;d<c.length;d++){if(c[d]===null||typeof c[d]==="undefined")continue;if(typeof c[d]==="number"&&isNaN(c[d]))continue;if(c[d]<b.min)b.min=c[d];else if(c[d]>b.max)b.max=c[d]}if(f._isDate(b.min)){b.min=a.toOADate(b.min);b.max=a.toOADate(b.max)}return b},_isVertical:function(a){return a==="west"||a==="east"},_calculateMajorMinor:function(f,d){var c=this,A=c.options,n=c.canvasBounds,y=f.autoMajor,z=f.autoMinor,p=d.max,q=d.min,v=d.isTime,x=d.tinc,r=d.annoFormatString,s=null,t=null,g=null,j=null,i=null,h=null,o=null,l=null,m=null,e=p-q,w=0,u=0,k=0,b=0;if(y){m=a.extend(true,{},A.textStyle,f.textStyle,f.labels.style);if(v){s=Globalize.format(a.fromOADate(p),r,c._getCulture());t=Globalize.format(a.fromOADate(q),r,c._getCulture());i=c._text(-1e3,-1e3,s).attr(m);h=c._text(-1e3,-1e3,t).attr(m);g=i.wijGetBBox();j=h.wijGetBBox();i.wijRemove();i=null;h.wijRemove();h=null}else{o=c._nicePrecision(e);l=o+1;if(l<0||l>15)l=0;i=c._text(-1e3,-1e3,a.round(p,l)).attr(m);h=c._text(-1e3,-1e3,a.round(q,l)).attr(m);g=i.wijGetBBox();j=h.wijGetBBox();i.wijRemove();i=null;h.wijRemove();h=null}if(g.width<j.width)g.width=j.width;if(g.height<j.height)g.height=j.height;if(!c._isVertical(f.compass)){w=n.endX-n.startX-d.vOffset-d.axisTextOffset;b=w/g.width;if(Number.POSITIVE_INFINITY===b)k=0;else k=parseInt(b,10)}else{u=n.endY-n.startY-d.vOffset-d.axisTextOffset;b=u/g.height;if(Number.POSITIVE_INFINITY===b)k=0;else k=parseInt(b,10)}b=e;if(k>0){e/=k;if(v)if(e<x)b=x;else b=c._niceTimeUnit(e,d.annoFormatString);else{d.tprec=c._nicePrecision(e);b=c._niceNumber(2*e,-o,true);if(b<e)b=c._niceNumber(e,-o+1,false);if(b<e)b=c._niceTickNumber(e)}}f.unitMajor=b}if(z&&f.unitMajor&&!isNaN(f.unitMajor))f.unitMinor=f.unitMajor/2}})})(jQuery);
(function(a){"use strict";a.widget("wijmo.wijbarchart",a.wijmo.wijchartcore,{options:{horizontal:true,stacked:false,is100Percent:false,clusterOverlap:0,clusterWidth:85,clusterRadius:0,clusterSpacing:0,animation:{enabled:true,duration:400,easing:">"},seriesTransition:{enabled:true,duration:400,easing:">"},mouseDown:null,mouseUp:null,mouseOver:null,mouseOut:null,mouseMove:null,click:null},_create:function(){var c=this,b=c.options,e=c._getDefFill(),d;if(b.horizontal){d=b.axis.y.compass||"south";b.axis.y.compass=b.axis.x.compass||"west";b.axis.x.compass=d}a.extend(true,{compass:"east"},b.hint);a.each(b.seriesStyles,function(b,a){if(!a.fill)a.fill=e[b]});e=null;a.wijmo.wijchartcore.prototype._create.apply(c,arguments);c.chartElement.addClass("wijmo-wijbarchart")},_setOption:function(c,b){c==="horizontal"&&a.extend(true,this.options.axis,{x:{compass:b?"west":"south"},y:{compass:b?"south":"west"}});a.wijmo.wijchartcore.prototype._setOption.apply(this,arguments)},destroy:function(){var e=this,c=e.chartElement,d=c.data("fields"),b=d&&d.bars;c.removeClass("wijmo-wijbarchart");a.wijmo.wijchartcore.prototype.destroy.apply(this,arguments);b&&b.length&&a.each(b,function(b,a){a=null});c.data("fields",null)},_clearChartElement:function(){var b=this,d=b.options,c=b.chartElement.data("fields");a.wijmo.wijchartcore.prototype._clearChartElement.apply(b,arguments);b.element.removeData("plotInfos");if(!d.seriesTransition.enabled)if(c&&c.aniBarsAttr)c.aniBarsAttr=null},_isBarChart:function(){return true},getBar:function(c){var a=this.chartElement,b=a.data("fields");return b.chartElements.bars[c]},_paintTooltip:function(){var c=this,d=c.chartElement,b=d.data("fields");a.wijmo.wijchartcore.prototype._paintTooltip.apply(this,arguments);if(c.tooltip)if(b&&b.trackers&&b.trackers.length){c.tooltip.setTargets(b.trackers);c.tooltip.setOptions({relatedElement:b.trackers[0]})}},_getTooltipText:function(e,d){var c=a(d.node),b,f;if(c.data("owner"))c=c.data("owner");b=c.data("wijchartDataObj");f={data:b,value:b.value,label:b.label,total:b.total,target:d,fmt:e,x:b.x,y:b.y};return a.proxy(e,f)()},_paintPlotArea:function(){var b=this,c=b.options;b.chartElement.wijbar({canvas:b.canvas,bounds:b.canvasBounds,tooltip:b.tooltip,widgetName:b.widgetName,horizontal:c.horizontal,stacked:c.stacked,axis:c.axis,seriesList:c.seriesList,seriesStyles:c.seriesStyles,seriesHoverStyles:c.seriesHoverStyles,seriesTransition:c.seriesTransition,showChartLabels:c.showChartLabels,textStyle:c.textStyle,chartLabelStyle:c.chartLabelStyle,chartLabelFormatString:c.chartLabelFormatString,shadow:c.shadow,disabled:c.disabled,clusterOverlap:c.clusterOverlap,clusterWidth:c.clusterWidth,clusterSpacing:c.clusterSpacing,is100Percent:c.is100Percent,clusterRadius:c.clusterRadius,animation:c.animation,culture:b._getCulture(),isYTime:b.axisInfo.y[0].isTime,isXTime:b.axisInfo.x.isTime,mouseDown:a.proxy(b._mouseDown,b),mouseUp:a.proxy(b._mouseUp,b),mouseOver:a.proxy(b._mouseOver,b),mouseOut:a.proxy(b._mouseOut,b),mouseMove:a.proxy(b._mouseMove,b),click:a.proxy(b._click,b)})},_showSerieEles:function(b){a.each(b,function(b,a){if(a&&a.bar){a.bar.show();a.bar.shadow&&a.bar.shadow.show();a.bar.tracker&&a.bar.tracker.show()}a&&a.dcl&&a.dcl.show();a&&a.animatedBar&&!a.animatedBar.removed&&a.animatedBar.show()})},_hideSerieEles:function(b){a.each(b,function(b,a){if(a&&a.bar){a.bar.hide();a.bar.shadow&&a.bar.shadow.hide();a.bar.tracker&&a.bar.tracker.hide()}a&&a.dcl&&a.dcl.hide();a&&a.animatedBar&&!a.animatedBar.removed&&a.animatedBar.hide()})},_calculateParameters:function(c,e){a.wijmo.wijchartcore.prototype._calculateParameters.apply(this,arguments);if(c.id==="x"){var d=e.unitMinor,b=this._getBarAdjustment(c);if(b===0)b=d;else if(d<b&&d!==0)b=Math.floor(b/d)*d;c.min-=b;c.max+=b;this._calculateMajorMinor(e,c)}},_getBarAdjustment:function(e){for(var a=0,h=this.options,g=e.max,b=e.min,d=h.seriesList,c=0,f=0,c=0;c<d.length&&d[c].data.x;c++){f=d[c].data.x.length;if(a<f)a=f}if(a>1)return(g-b)/a*h.clusterWidth*.0125;else if(a===1){if(b===0&&g===1){b=-1;e.min=b}return(g-b)*.0125}else return 0}});function b(c){var b=this;b.x=c;b.paSpec=[];b.stackValues=function(){var d=b.paSpec.length,c;if(d>1){c=b.paSpec[0];a.each(b.paSpec,function(b,a){if(b===0)return true;a.y+=c.y;c=a})}}}a.fn.extend({wijbar:function(c){var D=function(b,d,e){c.shadow&&a.wijchart.paintShadow(b,d,e)},u=a.wijraphael.addClass,E=a.wijchart.getScaling,A=a.wijchart.getTranslation,f=this,e=c.canvas,i=c.widgetName,d=c.horizontal,l=c.stacked,t=a.arrayClone(c.seriesList),v=t.length,C=[].concat(c.seriesStyles.slice(0,v)),z=[].concat(c.seriesHoverStyles.slice(0,v)),r=c.bounds,q=c.animation,I=q&&q.enabled,p={x:r.startX,y:r.startY},N=r.endX-p.x,L=r.endY-p.y,m=c.axis.x,x=c.axis.y,k=c.disabled,F=c.mouseDown,K=c.mouseUp,H=c.mouseOver,J=c.mouseOut,G=c.mouseMove,M=c.click,w=E(d,m.max,m.min,d?L:N),O=A(d,p,m.max,m.min,w),s,y,g=f.data("fields")||{},o=g.chartElements||{},j=g.aniBarsAttr,h,ab=c.isYTime,Z=c.isXTime,Y=c.culture;function W(d){for(var a=Number.MAX_VALUE,e=d.length,c,b=1;b<e;b++){c=d[b].x-d[b-1].x;if(c<a&&c>0)a=c}return a===Number.MAX_VALUE?2:a}function V(b){a.each(b,function(b,a){a.stackValues()});return b}function B(f){var c=[],d=a.wijchart.getXSortedPoints;function e(n,m){var h=d(m),l=m.length,f=null,o=0,e=0,g=0,k=true,i=0,j=false;if(h)o=h.length;if(c)g=c.length;if(h===undefined)return;a.each(h,function(d,a){if(k){k=false;i=a.x}else{if(i===a.x)j=true;else j=false;i=a.x}while(e<g&&c[e].x<a.x)e++;if(e<g)if(c[e].x!==a.x){f=new b(a.x,l);c.splice(e,0,f);g=c.length}else f=c[e];else{f=new b(a.x,l);c.push(f);g=c.length}f.paSpec.push({y:a.y,sIdx:n,pIdx:d,dupl:j})})}a.each(f,function(b,a){e(b,a)});return c}function n(a,c,b){return a<c?c:a>b?b:a}function R(c,d,e,f,g,b){a.each(b,function(j,a){var h=a.x,i=a.y,b=0;a.x=d*h+f;a.y=e*i+g;if(c){b=a.x;a.x=a.y;a.y=b}});return b}function P(b,n,m,l){var i=a.extend(true,{},c.textStyle,c.chartLabelStyle),h=d?{x:b.x+b.width,y:b.y+b.height/2}:{x:b.x+b.width/2,y:b.y},k=c.chartLabelFormatString,j,f,g=n;if(l)i=a.extend(true,i,l);if(m)g=a.fromOADate(n);if(k&&k.length)g=Globalize.format(g,c.chartLabelFormatString,Y);else if(!m)g=a.round(g,2);f=e.text(h.x,h.y,g).attr(i);u(a(f.node),"wijbarchart-label");j=f.getBBox();if(d)f.attr({x:h.x+j.width/2});else f.attr({y:h.y-j.height/2});return f}function X(i,r,Q,v,w,s,H,F,E,M,p,C,O,L,t){var N=c.is100Percent,z=v.min,y=v.max,B=w.min,A=w.max,T=v.scale,U=v.late,I=w.scale,K=w.late,x,b,G,f,u=null,g,J=s,o=s["stroke-width"],S=s.stroke,h,m,j,k,q=-1;if(t.origin!==null)q=I*t.origin+K;if(l)if(N){if(C>0)i.height=r/C;if(p||p===0){i.y=p/C;i.height-=i.y}}else{i.height=r;if(p||p===0){i.height-=p;i.y=p}}else if(p||p===0){i.x+=i.width*(1-M);i.height=r}b=[{x:i.x,y:i.y},{x:i.x+i.width,y:i.y+i.height}];G=(z<=b[0].x&&b[0].x<=y||z<=b[1].x&&b[1].x<=y)&&(B<=b[0].y&&b[0].y<=A||B<=b[1].y&&b[1].y<=A);b[0].x=n(b[0].x,z,y);b[0].y=n(b[0].y,B,A);b[1].x=n(b[1].x,z,y);b[1].y=n(b[1].y,B,A);b=R(d,T,I,U,K,b);if(b[0].x>b[1].x){x=b[0].x;b[0].x=b[1].x;b[1].x=x}if(b[0].y>b[1].y){x=b[0].y;b[0].y=b[1].y;b[1].y=x}f={x:b[0].x,y:b[0].y,width:b[1].x-b[0].x,height:b[1].y-b[0].y};if(G){if(f.width===0)f.width=.5;if(f.height===0)f.height=.5}if(c.showChartLabels)u=P(f,r,O,L);g=s.r?s.r:c.clusterRadius;if(g)J=a.extend(true,{},s,{r:0});if(S!=="none"&&o)o=parseInt(o,10);if(!o||isNaN(o))o=0;m=f.width-o;j=f.height-o;if(m<0)m=0;if(j<0)j=0;if(H){if(q===-1)if(d)q=E.x;else q=E.y+Q-o;if(g){if(d){if(r>t.origin)h=e.roundRect(f.x,f.y,m,j,0,0,g,g).hide();else h=e.roundRect(f.x,f.y,m,j,g,g,0,0).hide();k=e.rect(q,f.y,0,j)}else{if(r>t.origin)h=e.roundRect(f.x,f.y,m,j,g,0,0,g).hide();else h=e.roundRect(f.x,f.y,m,j,0,g,g,0).hide();k=e.rect(f.x,q,f.width,0)}D(k,F);k.wijAttr(J);k.bar=h}else{if(d)h=e.rect(q,f.y,0,j);else h=e.rect(f.x,q,f.width,0);k=h}if(u){u.attr({opacity:0});k.chartLabel=u}k.left=f.x;k.top=f.y;k.width=m;k.height=j;k.r=g}else if(g)if(d)if(r>t.origin)h=e.roundRect(f.x,f.y,m,j,0,0,g,g);else h=e.roundRect(f.x,f.y,m,j,g,g,0,0);else if(r>t.origin)h=e.roundRect(f.x,f.y,m,j,g,0,0,g);else h=e.roundRect(f.x,f.y,m,j,0,g,g,0);else h=e.rect(f.x,f.y,m,j);D(h,F);if(H&&g)h.shadow&&h.shadow.hide();h.wijAttr(s);return{rect:f,dcl:u,animatedBar:k,bar:h}}function T(i,J,F,K,v,C,p,q,n,w){var f=c.clusterOverlap/100,H=c.clusterWidth/100,t=1,G=c.clusterSpacing+t,o=i.length,b,g,k=[],D=[],r=[],j=[],z=[],h=[],m=e.set();if(n||w){a.each(i,function(d,c){var b=a.extend(true,{},c);b.data&&b.data.y&&b.data.y.length&&n&&a.each(b.data.y,function(d,c){b.data.y[d]=a.toOADate(c)});b.data&&b.data.x&&b.data.x.length&&w&&a.each(b.data.x,function(d,c){b.data.x[d]=a.toOADate(c)});z.push(b)});b=B(z)}else b=B(i);if(l)b=V(b);g=W(b)*H;if(o>1&&!l){f-=b.length*(o-1)*G/(d?p:C);g/=o*(1-f)+f}a.each(b,function(o,B){var e=B.paSpec,G=e.length,z,w,c,b;if(l)z=g;else z=g*(G*(1-f)+f);w={x:B.x-z/2,y:0,width:g,height:e[0].y};a.each(e,function(g,N){if(!j[g])j[g]=[];if(!h[g])h[g]=[];if(w.height===undefined)return true;var H=N.sIdx,L=J[H],z=i[H],l,M=z.yAxis||0,B=x[M]||x,G=v[M]||v;s=E(!d,B.max,B.min,d?C:p);y=A(!d,q,B.max,B.min,s);G.late=y;G.scale=s;b=X(w,N.y,p,K,G,L,I,t,q,f,g>0?e[g-1].y:null,e[e.length-1].y,n,z.textStyle,B);c=b.bar;l=c.clone().attr({opacity:.01,fill:"white","stroke-width":0,"fill-opacity":.01});if(z.visible===false){c.hide();b.dcl&&b.dcl.hide();l.hide();c.shadow&&c.shadow.hide()}u(a(c.node),"wijchart-canvas-object wijbarchart");a(c.node).data("wijchartDataObj",a.extend(false,{index:o,bar:c,type:"bar",style:L,hoverStyle:F[H],x:z.data.x[o],y:z.data.y[o]},z));a(l.node).data("owner",a(c.node));u(a(l.node),"wijbarchart bartracker");b.bar.tracker=l;m.push(l);D.push(c);b.animatedBar&&r.push(b.animatedBar);b.dcl&&k.push(b.dcl);j[g][o]=b.rect;h[g][o]=b;c=null;l=null})});a.each(k,function(b,a){a.toFront()});m.toFront();return{bars:D,animatedBars:r,rects:j,chartLabels:k,seriesEles:h,trackers:m}}function U(k){var e=c.seriesTransition,f,h,i=[],b;if(I){f=q.duration||2e3;h=q.easing||"linear";a.each(k,function(g,c){var k=d?{width:c.width,x:c.left}:{height:c.height,y:c.top};if(j&&e.enabled)if(j.length>g){b=a.wijchart.getDiffAttrs(j[g],c.attr());if(d){b.x=j[g].x;b.width=j[g].width}else{b.y=j[g].y;b.height=j[g].height}if(b.path)delete b.path;c.attr(b);f=e.duration;h=e.easing}i.push(a.extend(true,{},c.attr(),k));c.tracker&&c.tracker.hide();c.stop().wijAnimate(k,f,h,function(){var a=this,c=a.r,b=a;a.chartLabel&&a.chartLabel.wijAnimate({opacity:1},250);if(a.tracker){a.tracker.show();a.tracker.attr({width:a.width,height:a.height,x:a.attr("x"),y:a.attr("y")})}if(c){b=a.bar;b.show();b.shadow&&b.shadow.show();if(a.shadow){a.shadow.wijRemove();a.shadow=null}a.wijRemove();a=null}})});g.aniBarsAttr=i}}function S(){var b=a.isFunction;a(".wijbarchart",f[0]).live("mousedown."+i,function(e){if(k)return;if(b(F)){var c=a(e.target),d;if(c.data("owner"))c=c.data("owner");d=c.data("wijchartDataObj");F.call(f,e,d);d=null}}).live("mouseup."+i,function(e){if(k)return;if(b(K)){var c=a(e.target),d;if(c.data("owner"))c=c.data("owner");d=c.data("wijchartDataObj");K.call(f,e,d);d=null}}).live("mouseover."+i,function(e){if(k)return;if(b(H)){var c=a(e.target),d;if(c.data("owner"))c=c.data("owner");d=c.data("wijchartDataObj");H.call(f,e,d);d=null}}).live("mouseout."+i,function(g){if(k)return;var d=a(g.target),c,e;if(d.data("owner"))d=d.data("owner");c=d.data("wijchartDataObj");e=c.bar;if(!c.hoverStyle)e&&e.attr({opacity:"1"});else e.attr(c.style);b(J)&&J.call(f,g,c);c=null}).live("mousemove."+i,function(g){if(k)return;var d=a(g.target),c,e;if(d.data("owner"))d=d.data("owner");c=d.data("wijchartDataObj");e=c.bar;if(!c.hoverStyle)e&&e.attr({opacity:"0.8"});else e.attr(c.hoverStyle);b(G)&&G.call(f,g,c);c=null}).live("click."+i,function(e){if(k)return;if(b(M)){var c=a(e.target),d;if(c.data("owner"))c=c.data("owner");d=c.data("wijchartDataObj");M.call(f,e,d)}})}function Q(){a(".wijbarchart",f[0]).die(i).die("."+i)}Q();if(d&&!l){t.reverse();C.reverse();z.reverse()}if(v===0)return;h=T(t,C,z,{min:m.min,max:m.max,late:O,scale:w},x,N,L,p,ab,Z);f.data("plotInfos",{xscale:w,xlate:O,yscale:s,ylate:y,rects:h.rects});U(h.animatedBars);o.bars=h.bars;o.animatedBars=h.animatedBars;o.chartLabels=h.chartLabels;g.seriesEles=h.seriesEles;g.trackers=h.trackers;if(!g.chartElements)g.chartElements={};d&&!l&&g.seriesEles.reverse();a.extend(true,g.chartElements,o);f.data("fields",g);S()}})})(jQuery);
(function(a){"use strict";if(!window.Raphael)return;a.widget("wijmo.wijlinechart",a.wijmo.wijchartcore,{options:{stacked:false,hole:null,type:"line",animation:{enabled:true,direction:"horizontal",duration:2e3,easing:">"},seriesTransition:{enabled:true,duration:2e3,easing:">"},mouseDown:null,mouseUp:null,mouseOver:null,mouseOut:null,mouseMove:null,click:null},_create:function(){var b=this,c=b.options;a.wijmo.wijchartcore.prototype._create.apply(b,arguments);b.chartElement.addClass("wijmo-wijlinechart");c.type==="area"&&b.chartElement.addClass("wijmo-wijareachart")},destroy:function(){var b=this,c=b.options;b.chartElement.removeClass("wijmo-wijlinechart");c.type==="area"&&b.chartElement.removeClass("wijmo-wijareachart");a.wijmo.wijchartcore.prototype.destroy.apply(b,arguments);if(b.aniPathsAttr&&b.aniPathsAttr.length){a.each(b.aniPathsAttr,function(b,a){a=null});b.aniPathsAttr=null}},getLinePath:function(c){var d=this,b=d.chartElement.data("fields"),a,e;if(b&&b.chartElements){a=b.chartElements;if(a.paths&&a.paths.length)return a.paths[c]}return e},getLineMarkers:function(b){var e=this,d=e.options,c=e.chartElement.data("fields"),a,f;if(d.seriesList&&d.seriesList[b].markers&&d.seriesList[b].markers.visible)if(c&&c.chartElements){a=c.chartElements;if(a.markersSet&&a.markersSet.length)return a.markersSet[b]}return f},_showSerieEles:function(b){var d=this.options,c;b.markers&&a.each(b.markers,function(d,c){var b=a(c.node).data("wijchartDataObj");if(b&&b.lineSeries&&b.lineSeries.markers)if(!b.lineSeries.markers.visible)return true;c.show()});b.dcl&&a.each(b.dcl,function(b,a){d.showChartLabels&&a.show()});if(b.path){c=a(b.path.node).data("wijchartDataObj");if(c.visible){b.path.show();b.path.shadow&&b.path.shadow.show();b.path.area&&b.path.area.show();b.path.tracker&&b.path.tracker.show()}}},_hideSerieEles:function(b){b.markers&&a.each(b.markers,function(b,a){a.hide()});b.dcl&&a.each(b.dcl,function(b,a){a.hide()});if(b.path){b.path.hide();b.path.shadow&&b.path.shadow.hide();b.path.area&&b.path.area.hide();b.path.tracker&&b.path.tracker.hide()}},_paintLegend:function(){var d=this,l=d.options,b=0,n=0,k=0,i=null,m=l.seriesList,q=l.seriesStyles,c=null,j=null,e=null,o=0,p=0,g=null,h=null,f=null;a.extend(true,l,{legend:{size:{width:30,height:3}}});a.wijmo.wijchartcore.prototype._paintLegend.apply(d,arguments);if(l.legend.visible){if(d.legends.length&&d.legendIcons.length)for(b=0,n=d.legendIcons.length;b<n;b++){i=d.legendIcons[b];i.attr({fill:i.attr("stroke")})}if(!l.legend.reversed)for(b=0,n=m.length;b<n;b++){c=m[b];j=q[b];if(c.legendEntry&&c.display!=="exclude"){if(c.markers&&c.markers.visible){i=d.legendIcons[k];e=i.wijGetBBox();o=e.x+e.width/2;p=e.y+e.height/2;g=c.markerStyle;g=a.extend({fill:j.stroke,stroke:j.stroke,opacity:1},g);h=c.markers.type;if(!h)h="circle";f=d.canvas.paintMarker(h,o,p,3);a.wijraphael.addClass(a(f.node),"chart-legend-dot wijchart-legend");f.attr(g);a(f.node).data("index",b).data("legendIndex",k);d.legendDots.push(f)}k++}}else for(b=m.length-1;b>=0;b--){c=m[b];j=q[b];if(c.legendEntry&&c.display!=="exclude"){if(c.markers&&c.markers.visible){i=d.legendIcons[k];e=i.wijGetBBox();o=e.x+e.width/2;p=e.y+e.height/2;g=c.markerStyle;g=a.extend({fill:j.stroke,stroke:j.stroke,opacity:1},g);h=c.markers.type;if(!h)h="circle";f=d.canvas.paintMarker(h,o,p,3);a.wijraphael.addClass(a(f.node),"chart-legend-dot wijchart-canvas-object wijchart-legend");f.attr(g);a(f.node).data("index",b).data("legendIndex",k);d.legendDots.push(f)}k++}}}},_mouseDown:function(){a.wijmo.wijchartcore.prototype._mouseDown.apply(this,arguments)},_mouseUp:function(){a.wijmo.wijchartcore.prototype._mouseUp.apply(this,arguments)},_mouseOver:function(d,c){var b=this;if(!c||c.type!=="line")return;a.wijmo.wijchartcore.prototype._mouseOver.apply(this,arguments);if(c.path.removed)return;if(b.hoverLine!==c){b.isNewLine=true;if(b.hoverLine)if(!b.hoverLine.path.removed){b.hoverLine.path.wijAttr(b.hoverLine.lineStyle);if(b.hoverPoint&&!b.hoverPoint.isSymbol){b.hoverPoint.marker.wijAttr(b.hoverPoint.markerStyle);b.hoverPoint.marker.transform("s1")}}c.lineHoverStyle&&c.path.wijAttr(c.lineHoverStyle);b.hoverLine=c;b.hoverPoint=null;b.hoverVirtualPoint=null}},_mouseOut:function(){a.wijmo.wijchartcore.prototype._mouseOut.apply(this,arguments)},_mouseMove:function(){a.wijmo.wijchartcore.prototype._mouseMove.apply(this,arguments)},_click:function(){a.wijmo.wijchartcore.prototype._click.apply(this,arguments)},_mouseMoveInsidePlotArea:function(u,q){var b=this,f=b.tooltip,j=b.options.hint,e,h,c=0,l,d,m,n,t=null,g=null,k=null,s=j.title,r=j.content,p=a.isFunction(s),o=a.isFunction(r),i=0;if(f)k=f.getOptions();if(b.hoverLine){if(b.isNewLine){j.enable&&f&&f.hide();b.isNewLine=false}e=b.hoverLine.lineMarkers;h=b.hoverLine.virtualMarkers;c=-1;l={x:0,y:0};if(e&&e.length){a.each(e,function(f,b){if(b.removed)return true;var a=b.wijGetBBox(),e=a.x+a.width/2,d=Math.abs(e-q.left);if(f===0||d<i){i=d;c=f;l={x:e,y:a.y+a.height/2}}});if(b.hoverPoint&&b.hoverPoint.index===c)return;if(c>-1){if(e[c].removed)return;d=a(e[c].node).data("wijchartDataObj");if(d){if(b.hoverPoint&&!b.hoverPoint.isSymbol)if(!b.hoverPoint.removed){b.hoverPoint.marker.wijAttr(b.hoverPoint.markerStyle);b.hoverPoint.marker.transform("s1")}if(!d.isSymbol)!d.marker.removed&&d.marker.wijAttr(d.markerHoverStyle)}b.hoverPoint=d;b.hoverVirtualPoint=h[c]}}else{a.each(h,function(d,a){var b=Math.abs(a.x-q.left);if(d===0||b<i){i=b;c=d;l={x:a.x,y:a.y}}});if(b.hoverVirtualPoint&&b.hoverVirtualPoint.index===c)return;if(c>-1){b.hoverPoint=null;b.hoverVirtualPoint=h[c]}}if(f){g=b.hoverVirtualPoint;m=g.valX;n=g.valY;if(p||o){if(p)k.title=function(){var d={pointIndex:c,lineIndex:b.hoverLine.index,x:m,y:n,label:b.hoverLine.label,data:g,fmt:s},e=a.proxy(d.fmt,d),f=e();return f};if(o)k.content=function(){var d={pointIndex:c,lineIndex:b.hoverLine.index,x:m,y:n,label:b.hoverLine.label,data:g,fmt:r},f=a.proxy(d.fmt,d),e=f();return e}}t=a.extend({stroke:b.hoverLine.path.attr("stroke")},j.style);k.style.stroke=t.stroke;f.showAt(l)}}a.wijmo.wijchartcore.prototype._mouseMoveInsidePlotArea.apply(b,arguments)},_mouseMoveOutsidePlotArea:function(){var b=this;b._clearHoverState();a.wijmo.wijchartcore.prototype._mouseMoveOutsidePlotArea.apply(b,arguments)},_clearHoverState:function(){var a=this,b=a.tooltip,c=a.options.hint;c.enable&&b&&b.hide();if(a.hoverLine)if(!a.hoverLine.path.removed){a.hoverLine.path.wijAttr(a.hoverLine.lineStyle);if(a.hoverPoint&&!a.hoverPoint.isSymbol){a.hoverPoint.marker.wijAttr(a.hoverPoint.markerStyle);a.hoverPoint.marker.transform("s1")}}a.hoverLine=null;a.hoverPoint=null;a.hoverVirtualPoint=null},_paintPlotArea:function(){var b=this,c=b.options,d;if(!b.aniPathsAttr)b.aniPathsAttr=[];d={bounds:b.canvasBounds,widgetName:b.widgetName,canvas:b.canvas,tooltip:b.tooltip,stacked:c.stacked,hole:c.hole,type:c.type,axis:c.axis,animation:c.animation,seriesTransition:c.seriesTransition,seriesList:c.seriesList,seriesStyles:c.seriesStyles,seriesHoverStyles:c.seriesHoverStyles,showChartLabels:c.showChartLabels,chartLabelStyle:c.chartLabelStyle,chartLabelFormatString:c.chartLabelFormatString,isXTime:b.axisInfo.x.isTime,isYTime:b.axisInfo.y.isTime||b.axisInfo.y[0].isTime,disabled:c.disabled,culture:b._getCulture(),hint:c.hint,aniPathsAttr:b.aniPathsAttr,chartLabelEles:b.chartLabelEles,mouseDown:a.proxy(b._mouseDown,b),mouseUp:a.proxy(b._mouseUp,b),mouseOver:a.proxy(b._mouseOver,b),mouseOut:a.proxy(b._mouseOut,b),mouseMove:a.proxy(b._mouseMove,b),click:a.proxy(b._click,b)};b.chartElement.wijline(d)}})})(jQuery);(function(a){"use strict";if(!window.Raphael)return;a.wijchart._line=function(e,b){var f=this,p=b.bounds,n=b.widgetName,s=b.canvas,t=b.animation,q=b.seriesTransition,D=b.hint,B=b.tooltip,u=b.mouseDown,A=b.mouseUp,w=b.mouseOver,y=b.mouseOut,v=b.mouseMove,C=b.click,l=[],r=[],k=[],h=[],j=[],x=b.disabled,g=s.set(),d=b.aniPathsAttr,i=[],o,c=e.data("fields")||{},m=[],z=b.culture;f.render(b,i,d,h,j,l,g,r,k,m,z);(t.enabled||q.enabled)&&f.playAnimation(t,q,g,p,h,d);d.length=0;a.each(i,function(b,a){d.push(a)});f.unbindLiveEvents(e,n);f.bindLiveEvents(e,s,p,n,u,A,w,y,v,C,x,D,k,B);o={paths:h,shadowPaths:j,markersSet:l,animationSet:g,symbols:r};if(!c.chartElements)c.chartElements={};c.seriesEles=m;a.extend(true,c.chartElements,o);e.data("fields",c)};a.wijchart._line.prototype.playAnimation=function(g,b,i,j,h,c){var f=this,d=g.duration,e=g.easing;if(g.direction==="horizontal"){if(c&&c.length&&b.enabled){d=b.duration;e=b.easing}f.playHAnimation(d,e,i,j,h)}else a.each(h,function(g,a){if(typeof a==="undefined"||a===null)return true;if(c&&c.length&&b.enabled){d=b.duration;e=b.easing;f.playVAnimation(a,c,g,d,e)}else a.straight&&f.playVStraightAnimation(a,d,e)})};a.wijchart._line.prototype.playVAnimation=function(b,g,h,e,f){var c,d;b.shadow&&b.shadow.hide();b.tracker&&b.tracker.hide();c=g[h];d=a.wijchart.getDiffAttrs(c.path,b.attr());if(!a.isEmptyObject(d)){b.attr(c.path);b.wijAnimate(d,e,f,function(){b.shadow&&b.visible!==false&&b.shadow.show();b.tracker&&b.tracker.show()})}a.each(b.markers,function(g,b){var d=a.wijchart.getDiffAttrs(c.markers[g],b.attr());if(!a.isEmptyObject(d)){b.attr(c.markers[g]);b.wijAnimate(d,e,f)}});b.labels&&a.each(b.labels,function(h,d){var g=a.wijchart.getDiffAttrs(c.labels[h],d.attr()),b=c.labels[h];if(b&&b.text)delete b.text;if(!a.isEmptyObject(g)){d.attr(b);d.wijAnimate(g,e,f)}});if(b.area){d=a.wijchart.getDiffAttrs(c.area,b.area.attr());if(!a.isEmptyObject(d)){b.area.attr(c.area);b.area.wijAnimate(d,e,f)}}};a.wijchart._line.prototype.playVStraightAnimation=function(b,f,g){var d,e,c;b.shadow&&b.shadow.hide();b.tracker&&b.tracker.hide();d=b.straight;e=b.attr().path;b.attr({path:d});b.wijAnimate({path:e},f,g,function(){b.shadow&&b.visible!==false&&b.shadow.show();b.tracker&&b.tracker.show()});a.each(b.markers,function(c,a){if(a.straight){var b=a.attr().cy;a.attr({cy:a.straight});a.wijAnimate({cy:b},f,g)}});if(b.area){c=b.area;d=c.straight;e=c.attr().path;c.attr({path:d});c.wijAnimate({path:e},f,g)}};a.wijchart._line.prototype.playHAnimation=function(e,f,c,b,g){a.each(g,function(b,a){a.tracker&&a.tracker.hide()});var h=b.endX-b.startX+20,d=b.endY-b.startY+20;c.wijAttr("clip-rect",b.startX-10+" "+(b.startY-10)+" 0 "+d);c.wijAnimate({"clip-rect":b.startX-10+" "+(b.startY-10)+" "+h+" "+d},e,f,function(){this.tracker&&this.tracker.show();if(Raphael.vml){var b=null,d=null,c=this.node;if(c&&c.clipRect){b=this.attrs;delete b["clip-rect"];c.clipRect=null;d=a(c).parent();d.before(c);d.remove();this.attr(b);b.src&&b.src.length&&this.attr({src:b.src})}}})};a.wijchart._line.prototype.render=function(b,F,t,l,p,J,u,N,I,K,L){var s=this,w=b.bounds,k=b.canvas,q=b.stacked,P=b.hole,Q=b.type,O=b.axis,R=b.animation,M=b.seriesTransition,n=false,v=b.seriesList,A=b.seriesStyles,B=b.seriesHoverStyles,D=b.showChartLabels,C=b.chartLabelStyle,z=b.chartLabelFormatString,y=b.isXTime,h=b.isYTime,E=b.chartLabelEles,e,f,g,x,r,c,H=[],G=[],d,j,i,o,m;a.each(v,function(X,b){var Z=[],bb=[],cb=[],U,T,W,S,V,Y,ab=[];if(b.display==="exclude")return true;Y=A[X];b=a.extend(true,{display:"show",fitType:"line",markers:{visible:false,type:"circle"},visible:true},b);U=b.data;T=a.extend({stroke:"black",opacity:1,fill:"none","stroke-linejoin":"round","stroke-linecap":"round"},Y);S=b.markerStyle;S=a.extend({fill:T.stroke,stroke:T.stroke,opacity:1,width:3},S);W=B[X];V=a.extend(true,{},W,{transform:"s1.5","stroke-width":1},v.markerHoverStyle);r=[].concat(U.x);c=[].concat(U.y);i=k.set();j=[];x=b.fitType;o=false;if(b.markers.symbol&&b.markers.symbol.length)o=true;e=k.set();if(!t||t.length===0||R.enabled&&!M.enabled)n=true;if(n)if(c.length>0){f=a.wijchart.getFirstValidListValue(c);if(h)f=a.toOADate(f);g=a.wijchart.getLastValidListValue(c);if(h)g=a.toOADate(g)}m=s.processYValues(c,b.display,P,q,H);a.each(c,function(l,p){d=r[l];if(y)d=a.toOADate(d);p=c[l];if(m[l].isHole){if(b.display==="excludeHole")return true;if(!m[l].isValue)return true}if(h)p=a.toOADate(p);if(d===undefined)return false;j=s.renderPoint(w,k,cb,j,i,Z,u,e,bb,E,z,n,f,g,d,p,U.y[l],O,x,y,h,l,S,V,b,o,D,N,r,c,m,b.display,q,ab,L)});s.renderPath(k,w,b,l,p,I,W,S,V,i,J,u,j,F,cb,T,C,Z,bb,e,X,Q,G,q,ab);K.push({markers:i,path:l[l.length-1],shadowPath:p[p.length-1],dcl:e})});a.each(l,function(b,a){a.tracker&&a.tracker.toFront()})};a.wijchart._line.prototype.renderPath=function(t,g,d,D,I,J,x,G,E,l,K,z,b,A,h,e,F,w,y,n,i,M,B,L,H){var c,v,C,j,f,u,m,s,p,o,q,k,r;c=t.path(b.join(" "));c.straight=h.join(" ");a.wijchart.paintShadow(c);if(i===0){B.length=0;if(b.length>1){f=b[1];u=b[b.length-2]}else{f=g.startX;u=g.endX}a.merge(B,["L",f,g.endY,"L",u,g.endY])}m=t.path(b.join(" "));c.tracker=m;if(e["stroke-width"])s=10+parseFloat(e["stroke-width"]);else s=10;m.attr({"stroke-width":s,stroke:"#C0C0C0",opacity:.01});a.wijraphael.addClass(a(m.node),"wijchart-canvas-object wijlinechart linetracker");a(m.node).data("owner",a(c.node));if(M==="area"){if(e.fill&&e.fill!=="none"){v=e.fill;delete e.fill}else v=e.stroke;C=.5;c.wijAttr(e);if(b.length>1)f=b[1];else f=g.startX;if(L)if(i>0){o=Raphael.parsePathString(D[i-1].attr("path"));if(o.length>0){for(r=o.length-1;r>=0;r--){q=o[r];if(q.length===3){b.push("L");b.push(q[1]);b.push(q[2])}}b.push("Z")}}else{b.push("V");b.push(g.endY);b.push("H");b.push(f);b.push("Z")}else{k=Raphael.parsePathString(c.attr("path"));if(k.length>0){b=[];a.each(k,function(d,c){a.each(c,function(c,a){b.push(a)});if(c[0]==="M")f=c[1];if(d<k.length-1&&k[d+1][0]==="M"){b.push("V");b.push(g.endY);b.push("H");b.push(f);b.push("Z")}if(d===k.length-1){b.push("V");b.push(g.endY);b.push("H");b.push(f);b.push("Z")}})}}j=t.path(b.join(" "));a.wijraphael.addClass(a(j.node),"wijlinechart-area");j.wijAttr({fill:v,opacity:C,stroke:"none"});h.push("V");h.push(g.endY);h.push("H");h.push(f);h.push("Z");j.straight=h.join(" ");c.area=j;z.push(j);A.push({path:a.extend(true,{},c.attr()),area:a.extend(true,{},j.attr()),markers:w,labels:y})}else{c.wijAttr(e);A.push({path:a.extend(true,{},c.attr()),markers:w,labels:y})}c.markers=l;D.push(c);if(c.shadow)I[i]=c.shadow;z.push(c);J[i]={lineStyle:e,lineHoverStyle:x,markerStyle:G,markerHoverStyle:E};(!d.markers.visible||d.display==="hide")&&l.hide();if(!d.visible||d.display==="hide"){c.hide();c.shadow&&c.shadow.hide();c.area&&c.area.hide();c.visible=false}d.markers.style&&l.attr(d.markers.style);l.toFront();if(n.length){p=a.extend(true,{},F);if(d.textStyle)p=a.extend(true,p,d.textStyle);n.attr(p);n.toFront();c.labels=n}K[i]=l;d.index=i;d.type="line";d.path=c;d.lineMarkers=l;d.lineStyle=e;d.lineHoverStyle=x;d.virtualMarkers=H;a.wijraphael.addClass(a(c.node),"wijchart-canvas-object wijlinechart");a(c.node).data("wijchartDataObj",d)};a.wijchart._line.prototype.renderPoint=function(d,D,p,r,V,K,O,I,N,L,G,y,z,Q,n,u,Z,l,T,U,A,c,w,H,q,P,J,X,B,C,i,S,W,M,R){var t=this,ab=d.endX-d.startX,Y=d.endY-d.startY,j=l.x.min,m=l.y.min,E=l.x.max,bb=l.y.max,F=ab/(E-j),v=Y/(bb-m),s,e,o,f=0,g,h,b,k,x=q.markers.visible;if(isNaN(n)||typeof n==="string")o=c;else o=n;f=d.startX+(o-j)*F;g=d.endY-(u-m)*v;i[c].x=f;i[c].y=g;if(y){h=z+(Q-z)/(E-j)*(o-j);h=d.endY-(h-m)*v;p.push(i[c].idx?"L":"M");p.push(f);p.push(h)}if(!i[c].isHole)r=t.getPathArrByFitType(r,T,c,C.length,d,B,C,f,g,U,A,n,u,F,v,j,m,i,S,W);if(J){k=t.renderChartLabel(D,A,u,G,f,g,R);L.push(k);I.push(k);N.push(a.extend(true,{},k.attr()))}if(x){s=t.renderMarker(D,X,P,q.markers,c,f,g,w);e=s.dot;if(y)e.straight=h}b={};b.valX=B[c];b.valY=Z;b.index=c;b.type="marker";b.lineSeries=q;b.x=f;b.y=g;b.markerStyle=w;b.markerHoverStyle=H;if(x){b.marker=e;b.isSymbol=s.isSymbol;a(e.node).data("wijchartDataObj",b);V.push(e);K.push(a.extend(true,{},e.attr()));O.push(e)}M.push(b);return r};a.wijchart._line.prototype.processYValues=function(d,i,e,g,c){var h=[],b=0,f=0;a.each(d,function(k,l){if(!b)f=k;var j={isHole:false,isValue:true,idx:b,firstYIdx:f,x:0,y:0};b++;if(a.wijchart.isHole(l,e))if(g)d[k]=0;else{j.isHole=true;if(i==="excludeHole"){b--;j.idx=0}else{b=0;j.idx=0}if(!a.wijchart.isHole(e)&&l===e)j.isValue=true;else j.isValue=false}h.push(j);if(g&&k<c.length)d[k]+=c[k]});c.length=0;a.merge(c,d);return h};a.wijchart._line.prototype.renderMarker=function(h,n,l,c,m,j,k,d){var i,b=null,g=false,f,e;if(l){i=c.symbol;a.each(i,function(c,a){if(a.index===m){b=h.image(a.url,j-a.width/2,k-a.height/2,a.width,a.height);n.push(b);g=true;return false}})}if(b===null){f=c.type;e=d.width;b=h.paintMarker(f,j,k,e);c.visible&&b.attr(d)}a.wijraphael.addClass(a(b.node),"wijchart-canvas-object wijlinechart wijchart-canvas-marker");return{dot:b,isSymbol:g}};a.wijchart._line.prototype.renderChartLabel=function(i,h,f,d,j,k,g){var c,b,e;c=h?a.fromOADate(f):f;if(d&&d.length)c=Globalize.format(c,d,g);b=i.text(j,k,c);a.wijraphael.addClass(a(b.node),"wijlinechart-label");e=b.wijGetBBox();b.transform(Raphael.format("...T{0},{1}",0,-e.height));return b};a.wijchart._line.prototype.getAnchors=function(j,k,a,b,l,m){var n=(a-j)/2,o=(l-a)/2,c=Math.atan((a-j)/Math.abs(b-k)),d=Math.atan((l-a)/Math.abs(b-m)),e=0,f=0,h=0,g=0,i=0;c=k<b?Math.PI-c:c;d=m<b?Math.PI-d:d;e=Math.PI/2-(c+d)%(Math.PI*2)/2;f=n*Math.sin(e+c);h=n*Math.cos(e+c);g=o*Math.sin(e+d);i=o*Math.cos(e+d);return{x1:a-f,y1:b+h,x2:a+g,y2:b+i}};a.wijchart._line.prototype.getPathArrByFitType=function(b,n,c,h,q,C,D,d,e,A,B,w,I,x,H,v,F,g,z,u){var G=this,p=null,t=0,y=0,r=0,s=0,o=null,m=null,E=g[c],l=false,j=E.idx,f,i=c-1,k=c+1;if(z==="excludeHole"&&!u){if(c>0&&c<h-1){k=-1;i=-1;for(f=c+1;f<h;f++){l=true;if(g[f].isHole)continue;k=f;l=false;break}for(f=c-1;f>=0;f--){if(g[f].isHole)continue;i=f;break}if(i>-1){r=g[i].x;t=g[i].y}}}else{if(c<h-1)l=g[k].isHole;if(c>0&&c<h-1){r=g[i].x;t=g[i].y}}if(u)n="line";if(n==="line")b=b.concat([j?"L":"M",d,e]);else if(n==="spline")if(!j)if(c===h-1)b=b.concat(["M",d,e]);else if(l)b=b.concat(["M",d,e]);else b=b.concat(["M",d,e,"C",d,e]);else if(j&&c<h-1&&!l){p=D[k];if(B)p=a.toOADate(p);y=q.endY-(p-F)*H;if(isNaN(w)||typeof w==="string")s=q.startX+(k-v)*x;else{o=C[k];if(A)o=a.toOADate(o);s=q.startX+(o-v)*x}m=G.getAnchors(r,t,d,e,s,y);b=b.concat([m.x1,m.y1,d,e,m.x2,m.y2])}else b=b.concat([d,e,d,e]);else if(n==="bezier")if(!j)b=b.concat(["M",d,e]);else if(c<h-1&&g[c+1].isHole&&j%2===1||c===h-1&&j%2===1)b=b.concat(["Q",d,e,d,e]);else if(j%2===0)b=b.concat([d,e]);else b=b.concat(["Q",d,e]);return b};a.wijchart._line.prototype.bindLiveEvents=function(b,o,m,d,f,j,h,i,g,k,e){var c={element:b,mousedown:function(g){if(e)return;var c=a(g.target),d,h=null;if(c.data("owner"))c=c.data("owner");d=c.data("wijchartDataObj");if(c.hasClass("wijchart-canvas-marker")){h=d.lineSeries;if(!h.markers.visible)f.call(b,g,h);else f.call(b,g,d)}else f.call(b,g,d)},mouseup:function(f){if(e)return;var c=a(f.target),d,g=null;if(c.data("owner"))c=c.data("owner");d=c.data("wijchartDataObj");if(c.hasClass("wijchart-canvas-marker")){g=d.lineSeries;if(!g.markers.visible)j.call(b,f,g);else j.call(b,f,d)}else j.call(b,f,d)},mouseover:function(f){if(e)return;var c=a(f.target),d,g=null;if(c.data("owner"))c=c.data("owner");d=c.data("wijchartDataObj");if(c.hasClass("wijchart-canvas-marker")){g=d.lineSeries;if(!g.markers.visible)h.call(b,f,g);else h.call(b,f,d)}else h.call(b,f,d)},mouseout:function(f){if(e)return;var c=a(f.target),d,g=null;if(c.data("owner"))c=c.data("owner");d=c.data("wijchartDataObj");if(c.hasClass("wijchart-canvas-marker")){g=d.lineSeries;if(!g.markers.visible)i.call(b,f,g);else i.call(b,f,d)}else i.call(b,f,d)},mousemove:function(f){if(e)return;var c=a(f.target),d,h=null;if(c.data("owner"))c=c.data("owner");d=c.data("wijchartDataObj");if(c.hasClass("wijchart-canvas-marker")){h=d.lineSeries;if(!h.markers.visible)g.call(b,f,h);else g.call(b,f,d)}else g.call(b,f,d)},click:function(f){if(e)return;var c=a(f.target),d,g=null;if(c.data("owner"))c=c.data("owner");d=c.data("wijchartDataObj");if(c.hasClass("wijchart-canvas-marker")){g=d.lineSeries;if(!g.markers.visible)k.call(b,f,g);else k.call(b,f,d)}else k.call(b,f,d)}};a(".wijlinechart",b[0]).live("mousedown."+d,a.proxy(c.mousedown,c)).live("mouseup."+d,a.proxy(c.mouseup,c)).live("mouseover."+d,a.proxy(c.mouseover,c)).live("mouseout."+d,a.proxy(c.mouseout,c)).live("mousemove."+d,a.proxy(c.mousemove,c)).live("click."+d,a.proxy(c.click,c))};a.wijchart._line.prototype.unbindLiveEvents=function(c,b){a(".wijlinechart",c[0]).die(b).die("."+b)};a.fn.extend({wijline:function(b){new a.wijchart._line(this,b)}})})(jQuery);
(function(a){"use strict";a.widget("wijmo.wijpiechart",a.wijmo.wijchartcore,{options:{radius:null,innerRadius:0,chartLabelFormatter:null,labels:{style:{},formatString:"",formatter:null,connectorStyle:{},position:"inside",offset:10},animation:{enabled:true,duration:400,easing:">",offset:10},seriesTransition:{enabled:true,duration:1e3,easing:"bounce"},seriesList:[],mouseDown:null,mouseUp:null,mouseOver:null,mouseOut:null,mouseMove:null,click:null},_create:function(){var b=this,c=b._getDefFill();a.wijmo.wijchartcore.prototype._create.apply(b,arguments);b.chartElement.addClass("wijmo-wijpiechart");a.each(this.options.seriesStyles,function(b,a){if(!a.fill)a.fill=c[b]})},destroy:function(){var f=this,e=f.chartElement,b=e.data("fields"),c=b&&b.sectors,d=b&&b.labels;e.removeClass("wijmo-wijpiechart");a.wijmo.wijchartcore.prototype.destroy.apply(this,arguments);c&&c.length&&a.each(c,function(b,a){a=null});d&&d.length&&a.each(d,function(b,a){a=null});e.data("fields",null)},_isPieChart:function(){return true},getSector:function(b){var a=this.chartElement.data("fields");return a&&a.chartElements?a.chartElements.sectors[b]:null},_bindData:function(){var f=this,h=f.options,g=h.dataSource,e=h.data,i=[],c,d,b;if(g&&e){c=e.label;d=e.value;b=e.offset;if(c&&c.bind)c=f._getBindData(g,c.bind);if(d&&d.bind)d=f._getBindData(g,d.bind);if(b&&b.bind)b=f._getBindData(g,b.bind);if(c&&a.isArray(c)&&c.length&&d&&a.isArray(d)&&d.length){a.each(d,function(e,h){var g,f=0;if(e>=0&&e<c.length)g=c[e];if(b&&a.isArray(d)&&b.length&&e>=0&&e<b.length)f=typeof b[e]==="undefined"?0:b[e];i.push({data:h,label:g,offset:f,legendEntry:true})});h.seriesList=i}}},_getSeriesFromTR:function(i,e,h){var d=null,g=null,b=null,f=null,c=null;e.length&&e.each(function(){g=a("th",a(this));d=a.trim(g.text());b=a("td",a(this));if(b.length)f=parseFloat(a.trim(a(b[0]).text()));c={label:d,legendEntry:true,data:f};h.push(c)})},_showSerieEles:function(a){var b=this.options.showChartLabels;if(a.sector){a.sector.show();a.sector.shadow&&a.sector.shadow.show();a.sector.tracker&&a.sector.tracker.show()}a.label&&b&&a.label.show()},_hideSerieEles:function(a){if(a.sector){a.sector.hide();a.sector.shadow&&a.sector.shadow.hide();a.sector.tracker&&a.sector.tracker.hide()}a.label&&a.label.hide()},_hasAxes:function(){return false},_mouseDown:function(){a.wijmo.wijchartcore.prototype._mouseDown.apply(this,arguments)},_mouseUp:function(){a.wijmo.wijchartcore.prototype._mouseUp.apply(this,arguments)},_mouseOver:function(){a.wijmo.wijchartcore.prototype._mouseOver.apply(this,arguments)},_mouseOut:function(){a.wijmo.wijchartcore.prototype._mouseOut.apply(this,arguments)},_mouseMove:function(){a.wijmo.wijchartcore.prototype._mouseMove.apply(this,arguments)},_click:function(){a.wijmo.wijchartcore.prototype._click.apply(this,arguments)},_paintTooltip:function(){var c=this,d=c.chartElement,b=d.data("fields");a.wijmo.wijchartcore.prototype._paintTooltip.apply(this,arguments);if(c.tooltip&&b)if(b.trackers&&b.trackers.length){c.tooltip.setSelector(a(".wijchart-canvas-object",d[0]));c.tooltip.setOptions({relatedElement:b.trackers[0]})}},_paintPlotArea:function(){var b=this,c=b.options,d=b.canvasBounds,g=d.endX-d.startX,f=d.endY-d.startY,e=c.radius;if(!e)e=Math.min(g,f)/2;else{if(g<2*e)e=g/2;if(f<2*e)e=f/2}d.startX+=g/2-e;d.endX=d.startX+2*e;d.startY+=f/2-e;d.endY=d.startY+2*e;if(b.chartElement.data("fields"))b.chartElement.data("fields").seriesEles=null;b.chartElement.wijpie({canvas:b.canvas,tooltip:b.tooltip,bounds:d,radius:e,widgetName:b.widgetName,innerRadius:c.innerRadius,seriesList:c.seriesList,seriesStyles:c.seriesStyles,seriesHoverStyles:c.seriesHoverStyles,seriesTransition:c.seriesTransition,showChartLabels:c.showChartLabels,disabled:c.disabled,textStyle:c.textStyle,chartLabelStyle:c.chartLabelStyle,chartLabelFormatString:c.chartLabelFormatString,chartLabelFormatter:c.chartLabelFormatter,labels:c.labels,shadow:c.shadow,animation:c.animation,culture:b._getCulture(),mouseDown:a.proxy(b._mouseDown,b),mouseUp:a.proxy(b._mouseUp,b),mouseOver:a.proxy(b._mouseOver,b),mouseOut:a.proxy(b._mouseOut,b),mouseMove:a.proxy(b._mouseMove,b),click:a.proxy(b._click,b)})},_getTooltipText:function(e,d){var c=a(d.node),b,f;if(c.data("owner"))c=c.data("owner");b=c.data("wijchartDataObj");f={data:b,value:b.value,label:b.label,total:b.total,target:d,fmt:e};return a.proxy(e,f)()}})})(jQuery);(function(a){"use strict";a.fn.extend({wijpie:function(b){var D=function(c,d,e){b.shadow&&a.wijchart.paintShadow(c,d,e)},C=a.wijchart.getDiffAttrs,y=a.wijraphael.addClass,o=a.wijraphael.getPositionByAngle,c=this,O=b.bounds,i=b.widgetName,j=b.canvas,f=b.animation,H=b.seriesList,V=b.seriesStyles,Q=b.seriesHoverStyles,k=b.radius,r=b.innerRadius,l=b.seriesTransition,T=b.showChartLabels,W=b.textStyle,m=b.labels||{style:{},formatString:"",formatter:null,connectorStyle:{},position:"inside",offset:10},S=a.extend(true,{},W,b.chartLabelStyle,m.style),u=m.formatString||b.chartLabelFormatString,q=m.formatter||b.chartLabelFormatter,X=b.culture,n=b.disabled,I=b.mouseDown,M=b.mouseUp,K=b.mouseOver,L=b.mouseOut,J=b.mouseMove,P=b.click,N=b.tooltip,d=c.data("fields")||{},p=d.chartElements||{},v=d.aniSectorAttrs,w=d.aniLabelAttrs,E=[],F=[],A=[],g=[],x=[],e=0,t=0,Y=O.startX,Z=O.startY,G=[],B,h,s,z=j.set();function U(){var b={x:0,y:0},d=a.isFunction;N&&N.setTargets(x);a(".wijpiechart",c[0]).live("mousedown."+i,function(f){if(n)return;var b=a(f.target),e;if(b.data("owner"))b=b.data("owner");e=b.data("wijchartDataObj");if(!e)return;d(I)&&I.call(c,f,e)}).live("mouseup."+i,function(f){if(n)return;var b=a(f.target),e;if(b.data("owner"))b=b.data("owner");e=b.data("wijchartDataObj");if(!e)return;d(M)&&M.call(c,f,e)}).live("mouseover."+i,function(o){if(n)return;var k=a(o.target),h,m,p=f&&f.enabled,l,e,g,i,j;if(k.data("owner"))k=k.data("owner");h=k.data("wijchartDataObj");if(!h)return;m=h.pieID||"";l=h.index;e=c.data("fields").chartElements["sectors"+m][l];g=e.showAnimationTimer;i=e.hideAnimationTimer;j=e.explodeAnimationShowing;d(K)&&K.call(c,o,h);if(e.removed)return;e.wijAttr(h.hoverStyle);if(p){if(i){window.clearTimeout(i);i=null;e.hideAnimationTimer=i}if(g){window.clearTimeout(g);g=null;e.showAnimationTimer=null}if(j)return;g=window.setTimeout(function(){var a=f.duration,c=f.easing;if(e.removed)return;b=e.getOffset(f.offset||10);e.offset=b;e.shadow&&!e.shadow.removed&&e.shadow.hide();e.wijAnimate({transform:Raphael.format("t{0},{1}",b.x,b.y)},a,c);e.tracker&&!e.tracker.removed&&e.tracker.wijAnimate({transform:Raphael.format("t{0},{1}",b.x,b.y)},a,c);j=true;e.explodeAnimationShowing=j},150);e.showAnimationTimer=g}}).live("mouseout."+i,function(o){if(n)return;var k=a(o.target),g,m,p=f&&f.enabled,l,e,i,h,j;if(k.data("owner"))k=k.data("owner");g=k.data("wijchartDataObj");if(!g)return;m=g.pieID||"";l=g.index;e=c.data("fields").chartElements["sectors"+m][l];i=e.showAnimationTimer;h=e.hideAnimationTimer;j=e.explodeAnimationShowing;d(L)&&L.call(c,o,g);if(e.removed)return;if(g.style.segment)delete g.style.segment;e.wijAttr(g.style);if(p){if(h){window.clearTimeout(h);h=null;e.hideAnimationTimer=h}if(i){window.clearTimeout(i);i=null;e.showAnimationTimer=i}if(!j)return;h=window.setTimeout(function(){var a=f.duration,c=f.easing;b=e.offset;e.shadow&&!e.shadow.removed&&e.shadow.show();!e.removed&&e.wijAnimate({transform:"t0,0"},a,c);e.tracker&&!e.tracker.removed&&e.tracker.wijAnimate({transform:"t0,0"},a,c);e.shadow&&!e.shadow.removed&&e.shadow.wijAnimate({transform:"t0,0"},a,c);b={x:0,y:0};j=false;e.explodeAnimationShowing=j},150);e.hideAnimationTimer=h}}).live("mousemove."+i,function(f){if(n)return;var b=a(f.target),e;if(b.data("owner"))b=b.data("owner");e=b.data("wijchartDataObj");if(!e)return;d(J)&&J.call(c,f,e)}).live("click."+i,function(f){if(n)return;var b=a(f.target),e;if(b.data("owner"))b=b.data("owner");e=b.data("wijchartDataObj");if(!e)return;d(P)&&P.call(c,f,e)})}function R(){a(".wijpiechart",c[0]).die(i).die("."+i)}j.customAttributes.segment=function(h,i,d,b,g,f){var e=null,c=.01;if(b-d>360-c)b-=c;else if(b-d<c)b+=c;if(f)e=a.wijchart.donut(h,i,g,f,d,b);else e=a.wijchart.sector(h,i,g,d,b);return{path:e}};a.each(H,function(b,a){if(a&&typeof a.data==="number")t+=a.data});a.each(H,function(d,c){var J=a.extend({opacity:1,stroke:"gray","stroke-width":1},V[d]),L=360*c.data/t,H=Y+k,I=Z+k,P,b,f,p,i,O,n,K,U,R=m.position,W=m.connectorStyle,ab=m.offset,M,N;s=c.pieID;c=a.extend(true,{offset:0},c);if(c.offset){P=o(H,I,c.offset,e+L/2);H=P.x;I=P.y}B=[H,I,e,e+L,k,r].concat(" ");if(v&&l.enabled){J.segment=B;if(d<v.length)h=v[d];else{h=a.extend(true,{},J);h.segment=[H,I,0,360,k,r].concat(" ")}b=j.path().attr(h);J=C(h,J);!b.removed&&b.wijAnimate(J,l.duration,l.easing,function(){D(b);n&&!n.removed&&!b.removed&&n.attr({path:b.attr("path")});delete J.segment})}else{b=j.path().attr({segment:B});D(b);b.wijAttr(J)}b.angles={start:e,end:e+L};b.getOffset=function(c){var a=o(H,I,c,(b.angles.start+b.angles.end)/2);return{x:a.x-H,y:a.y-I}};b.center={x:H,y:I};b.radius=k;if(r)b.innerRadius=r;n=b.clone();if(a.browser.msie&&a.browser.version<9)n.attr({opacity:.01,fill:"white","stroke-width":0,"fill-opacity":.01});else n.attr({opacity:.01,fill:"white","fill-opacity":.01});y(a(n.node),"wijchart-canvas-object wijpiechart pietracker wijchart-tracker"+d);a(n.node).data("owner",a(b.node));b.tracker=n;z.push(n);y(a(b.node),"wijchart-canvas-object wijpiechart wijmo-wijpiechart-series-"+d);a(b.node).data("wijchartDataObj",c);if(T){if(R==="outside"){O=o(H,I,k,e+L/2);p=o(H,I,k+ab,e+L/2)}else p=o(H,I,c.offset+k*2/3,e+L/2);i=a.extend(true,{},i,S);if(c.textStyle)i=a.extend(true,i,c.textStyle);K=c.label;if(u&&u.length>0)K=Globalize.format(K,u,X);if(q&&a.isFunction(q)){U={index:d,value:c.data,y:c.data,total:t,chartLabel:K,chartLabelFormatter:q};K=a.proxy(q,U)()}if(w&&l.enabled)if(d<w.length){h=w[d];h.text=K;f=j.text(0,0,"").attr(h);i=C(h,i);i.x=p.x;i.y=p.y;f.wijAnimate(i,l.duration,l.easing)}else f=j.text(p.x,p.y,K).attr(i);else f=j.text(p.x,p.y,K).attr(i);if(R==="outside"){M=(e+L/2)%360;N=f.wijGetBBox();if(M>=90&&M<=270)f.transform(Raphael.format("...T{0},{1}",-N.width/2,0));else f.transform(Raphael.format("...T{0},{1}",N.width/2,0));j.path(Raphael.format("M{0} {1}L{2} {3}",O.x,O.y,p.x,p.y)).attr(W)}y(a(f.node),"wijchart-canvas-object wijpiechart");a(f.node).data("wijchartDataObj",c);x.push(f);g.push(f);F[d]=f.attr()}G.push({label:g[d],sector:b});if(c.visible===false){b.hide();g[d]&&g[d].hide();b.shadow&&b.shadow.hide();n.hide()}E[d]=b.attr();A.push(b);x.push(b);c.style=J;c.hoverStyle=Q[d];c.index=d;c.value=c.data;c.y=c.data;c.total=t;c.type="pie";e+=L});g&&g.length&&a.each(g,function(b,a){a.toFront()});p.sectors=A;if(s){p["sectors"+s]=A;p["labels"+s]=g}p.labels=g;if(!d.chartElements)d.chartElements={};z.toFront();a.extend(true,d.chartElements,p);d.aniSectorAttrs=E;d.aniLabelAttrs=F;d.seriesEles=G;d.trackers=z;c.data("fields",d);R();U()}})})(jQuery);
(function(a){"use strict";a.widget("wijmo.wijtree",{options:{allowDrag:false,allowDrop:false,allowEdit:false,allowSorting:true,allowTriState:true,autoCheckNodes:true,autoCollapse:false,disabled:false,expandCollapseHoverUsed:false,showCheckBoxes:false,showExpandCollapse:true,expandAnimation:{effect:"blind",easing:"easeOutExpo",duration:200},expandDelay:0,collapseAnimation:{effect:"blind",easing:"easeOutExpo",duration:200},collapseDelay:0,draggable:null,droppable:null,dropVisual:null,nodes:[],nodeBlur:null,nodeFocus:null,nodeClick:null,nodeCheckChanged:null,nodeCollapsed:null,nodeExpanded:null,nodeDragging:null,nodeDragStarted:null,nodeBeforeDropped:null,nodeDropped:null,nodeMouseOver:null,nodeMouseOut:null,nodeTextChanged:null,selectedNodeChanged:null,nodeExpanding:null,nodeCollapsing:null},_create:function(){if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);this._initState();this._createTree();this._attachEvent();this._attachNodeEvent()},_setOption:function(f,c){var b=this,e=false,d;switch(f){case"allowDrag":b._setAllowDrag(c);break;case"allowDrop":b._setAllowDrop(c);break;case"showCheckBoxes":b._setCheckBoxes(c);break;case"showExpandCollapse":if(b.options.showExpandCollapse!==c)e=true;break;case"disabled":if(c)b.widgetDom.addClass("ui-state-disabled");else b.widgetDom.removeClass("ui-state-disabled");d=b.element.find(":wijmo-wijtreecheck");d.length&&d.wijtreecheck("option","disabled",c)}a.Widget.prototype._setOption.apply(b,arguments);f==="nodes"&&b._createChildNodes();e===true&&b._setHitArea(c)},_initState:function(){var a=this;a._selectedNodes=[];a._checkedNodes=[];a._enabled=true;a._insertPosition="unKnown";a.nodeWidgetName="wijtreenode"},_createTree:function(){var b=this,c=b.options,e=[],d="wijmo-wijtree ui-widget ui-widget-content ui-helper-clearfix ui-corner-all";if(b.element.is("ul")){b.$nodes=b.element;b.element.wrap("<div></div>");b.widgetDom=b.element.parent()}else if(b.element.is("div")){b.widgetDom=b.element;b.$nodes=b.widgetDom.children("ul:eq(0)")}if(b.$nodes.length){b.widgetDom.addClass(d).attr({role:"tree","aria-multiselectable":true});b.$nodes.addClass("wijmo-wijtree-list ui-helper-reset");c.showExpandCollapse===false&&b.$nodes.addClass("wijmo-wijtree-allexpanded");e=b._createChildNodes();b.widgetDom.append(a("<div>").css("clear","both"))}c.disabled&&b.disable()},_createChildNodes:function(){var b=this,d={},c=[],f=b.$nodes,e=b.options.nodes,g=f.children("li");if(e.length){f.empty();a.each(e,function(e,g){var a=b._generateMarkup(g);f.append(a);d.nIndex=e;b._createNodeWidget(a,d);c.push(b._getNodeWidget(a))})}else g.each(function(){var g=a(this),f;b._createNodeWidget(g,d);f=b._getNodeWidget(g);c.push(f);e.push(f.options)});b._hasChildren=c.length>0;b._setField("nodes",c);b.nodes=c},_generateMarkup:function(b){var c,d,e=b.navigateUrl;if(!a.isPlainObject(b))return;c=a("<li></li>");d=a("<a>").attr("src",typeof e==="string"&&e?e:"#");d.appendTo(c);typeof b.text==="string"&&b.text&&a("<span>").html(b.text).appendTo(d);return c},_createNodeWidget:function(c,b){var e=this,d=e.nodeWidgetName;if(a.fn[d]){c.data("owner",this);if(!!b&&a.isPlainObject(b)){a.extend(b,{treeClass:this.widgetBaseClass});c[d](b)}else c[d]({treeClass:this.widgetBaseClass})}return c},_attachEvent:function(){var b=this;b.element.bind(a.browser.msie?"focusin.":"focus."+b.widgetName,a.proxy(b._onFocus,b)).bind("mouseover."+this.widgetName,a.proxy(b._onMouseOver,b));b.options.allowDrop&&b._attachDroppable()},_attachDroppable:function(){var b=this,d=b.options,e={accept:"li",scope:"tree"},f=function(a){d.showCheckBoxes&&d.allowTriState&&!a.element.is(":"+b.widgetBaseClass)&&a._getField("nodes").length>0&&a._getField("nodes")[0]._setParentCheckState()},c=d.droppable;a.extend(e,c);e.drop=function(p,e){var m=e.draggable,h=b._getNodeWidget(m),k,l,g,i,q,n,o,j=-1;if(b._trigger("nodeBeforeDropped",p,e)===false||!h||d.disabled){b._isDragging=false;return}k=h._dropTarget;l=h._insertPosition;if(k&&l!=="unKnown"){g=m.data("owner");if(g)o=m.index();if(l==="end"){j=k._getField("nodes").length;i=k}else if(l==="before"||l==="after"){i=k._getField("owner");q=i._getField("nodes");n=a.inArray(k,q);if(n!==-1)j=l==="before"?n:n+1}if(c&&a.isFunction(c.drop)){e.oldParent=g.element;e.newParent=i.element;e.oldIndex=o;e.newIndex=j;c.drop.call(b.element,p,e)}else{g&&g.remove(m);j!==-1&&i.add(m,j)}a("a:eq(0)",m).blur();h._tree._isDragging=false;h.options.selected&&h._setSelected(false);f(g);f(i);a.extend(e,{sourceParent:g?g.element:null,sIndex:o,targetParent:i.element,tIndex:j,widget:h});b._trigger("nodeDropped",p,e)}};b.widgetDom.droppable(e)},_attachNodeEvent:function(){this.element.bind("click."+this.widgetName,a.proxy(this._onClick,this)).bind("mouseout."+this.widgetName,a.proxy(this._onMouseOut,this)).bind("keydown."+this.widgetName,a.proxy(this._onKeyDown,this))},_onClick:function(b){this._callEvent(b,"_onClick");a.browser.webkit&&this.widgetDom.focus()},_onFocus:function(a){this._callEvent(a,"_onFocus")},_onKeyDown:function(a){this._callEvent(a,"_onKeyDown")},_onMouseOut:function(a){this._callEvent(a,"_onMouseOut")},_onMouseOver:function(a){this._callEvent(a,"_onMouseOver")},_callEvent:function(b,d){var c=b.target,a;if(c){a=this._getNodeWidgetByDom(c);if(a===null)return;a[d](b)}},_nodeSelector:function(){return":wijmo-wijtreenode"},getSelectedNodes:function(){return this._selectedNodes},getCheckedNodes:function(){var b=this,d=[],c=b.nodeWidgetName;a(b._nodeSelector(),b.element).each(function(){a(this)[c]("option","checked")&&a(this)[c]("option","checkState")!=="indeterminate"&&d.push(a(this))});return d},destroy:function(){var b=this,c=b.$nodes,d="wijmo-wijtree ui-widget ui-widget-content ui-helper-clearfix ui-corner-all";b.widgetDom.removeClass(d).removeAttr("role").removeAttr("aria-multiselectable");b.widgetDom.data("droppable")&&b.widgetDom.droppable("destroy");b.widgetDom.children("div[style]:last").remove();c.removeData("nodes").removeClass("wijmo-wijtree-list ui-helper-reset");c.children("li").each(function(){var c=b._getNodeWidget(a(this));c&&c.destroy()});a.Widget.prototype.destroy.apply(this)},add:function(b,f){var c=null,k={},d,g,e=this,h,i,l="<li><a href='{0}'>{1}</a></li>",j;if(typeof b==="string"){d=a(l.replace(/\{0\}/,"#").replace(/\{1\}/,b));e._createNodeWidget(d,k);c=d.data(d.data("widgetName"))}else if(b.jquery){!b.data("widgetName")&&e._createNodeWidget(b,k);c=b.data(b.data("widgetName"))}else if(b.nodeType){d=a(b);e._createNodeWidget(d,k);c=d.data(d.data("widgetName"))}else if(a.isPlainObject(b)){d=a(l.replace(/\{0\}/,b.url?b.url:"#").replace(/\{1\}/,b.text));e._createNodeWidget(d,b);c=d.data(d.data("widgetName"))}if(c===null)return;g=e._getField("nodes");if(!f||f>g.length)f=g.length;j=c._getField("nodes");c._tree=e;for(h=0;h<j.length;h++)j[h]._tree=e;c._setField("owner",this);i=g.length;if(i>0&&i!==f)c.element.get(0)!==g[f].element.get(0)&&c.element.insertBefore(g[f].element);else e.$nodes.append(c.element);e._changeCollection(f,c);c._initNodeClass()},remove:function(b){var a=-1,d,c;if(b.jquery)a=b.index();else if(typeof b==="number")a=b;c=this._getField("nodes");if(a<0||a>=c.length)return;d=c[a];d.element.detach();this._changeCollection(a)},_changeCollection:function(a,b){var c=this._getField("nodes"),d=this.options.nodes;if(b){c.splice(a,0,b);d.splice(a,0,b.options)}else{c.splice(a,1);d.splice(a,1)}},getNodes:function(){return this.nodes},findNodeByText:function(c){var b=a(".wijmo-wijtree-node a>span",this.$nodes).filter(function(){return a(this).text()===c});return b.length?this._getNodeWidgetByDom(b.get(0)):null},_setAllowDrag:function(f){var c=this,b,d=c._nodeSelector(),e=c.nodeWidgetName;if(f){b=c.element.find(d);b.each(function(){var b=a(this).data(e);if(!a(this).data("draggable")&&!b.$navigateUrl.data("events").mousedown)b.$navigateUrl.one("mousedown",b,b._onMouseDown)})}else{b=c.element.find(d+":ui-draggable");b.draggable("destroy")}},_setAllowDrop:function(a){if(a)!this.widgetDom.data("droppable")&&this._attachDroppable();else this.widgetDom.droppable&&this.widgetDom.droppable("destroy")},_setCheckBoxes:function(c){var b=this;b.$nodes.children("li").each(function(){var d=b._getNodeWidget(a(this));d!==null&&d._setCheckBoxes(c)})},_setHitArea:function(c){var b=this;b.$nodes[c?"addClass":"removeClass"]("wijmo-wijtree-allexpanded");b.$nodes.children("li").each(function(){var d=b._getNodeWidget(a(this));d!==null&&d._setHitArea(c)})},_getNodeWidget:function(a){return a.is(this._nodeSelector())?a.data(a.data("widgetName")):null},_getNodeWidgetByDom:function(b){var a=this._getNodeByDom(b);return this._getNodeWidget(a)},_getNodeByDom:function(b){return a(b).closest(this._nodeSelector())},_refreshNodesClass:function(){for(var b=this._getField("nodes"),a=0;a<b.length;a++)b[a]._initNodeClass()},_getField:function(a){return this.element.data(a)},_setField:function(b,a){return this.element.data(b,a)}})})(jQuery);(function(a){a.widget("wijmo.wijtreenode",{options:{accessKey:"",checked:false,collapsedIconClass:"",expanded:false,expandedIconClass:"",itemIconClass:"",navigateUrl:"",selected:false,text:"",toolTip:"",hasChildren:false,params:{},nodes:[]},_setOption:function(e,c){var b=this,d,f;switch(e){case"accessKey":b.$navigateUrl!==null&&b.$navigateUrl.attr("accesskey",c);break;case"checked":b._checkState=c?"checked":"unChecked";b._setChecked(c);break;case"collapsedIconClass":case"expandedIconClass":case"itemIconClass":b.options[e]=c;b._initNodeImg();break;case"expanded":b._setExpanded(c);break;case"selected":b._setSelected(c);break;case"text":b._setText(c);break;case"toolTip":b._setToolTip(c);break;case"navigateUrl":b._setNavigateUrlHref(c);break;case"disabled":if(b._isClosestDisabled()&&c===true)return;d=b.element.find(":wijmo-wijtreecheck");d.length&&d.wijtreecheck("option","disabled",c)}if(e==="nodes"){b.options.nodes.length=0;a.each(c,function(c,a){b.options.nodes.push(a)});b.options.nodes.concat();b._hasChildren=b._getChildren();b._createChildNodes(b.element);b._initNodeClass()}else a.Widget.prototype._setOption.apply(b,arguments)},_initState:function(){this._tree=null;this._dropTarget=null;this._checkState="unChecked";this._value=this._text=this._navigateUrl="";this._insertPosition="unKnown";this._hasNodes=false},_create:function(){var a=this,b=a.options;a._initState();a._createTreeNode();a._initNode();a.element.data("widgetName",a.widgetName);b.selected&&a._tree._selectedNodes.push(a);if(b.checked){a._checkState="checked";a.$checkBox&&a.$checkBox.wijtreecheck("option","checkState","check")}},_createTreeNode:function(){var e=this.element,f,d,b=this,c=b.options,g=[];this.$navigateUrl=e.children("a");if(b._tree===null)b._tree=b._getTree();if(!isNaN(c.nIndex)){ownerOpts=b._getOwner().options,d=ownerOpts.nodes[c.nIndex];if(d&&!d.nodes)d.nodes=[];a.extend(c,d);ownerOpts.nodes[c.nIndex]=c}else if(!c.nodes)c.nodes=[];b.$nodeBody=null;b.$checkBox=null;b.$hitArea=null;b.$nodes=null;b.$nodeImage=a("<span>");b.$nodeBody=a("<div>").attr({role:"treeitem","aria-expanded":false,"aria-checked":false,"aria-selected":false});if(b._tree.options.showCheckBoxes===true)b.$checkBox=a("<div>");if(b.$navigateUrl.length===0){b.$navigateUrl=e.children("div");b.$navigateUrl.addClass("wijmo-wijtree-template");b._isTemplate=true}if(b.$navigateUrl.length===0){b.$navigateUrl=a("<a>");b.$navigateUrl.attr("href","#")}if(!b._isTemplate){b.$text=b.$navigateUrl.find("span:eq(0)");if(b.$text.length===0){b.$navigateUrl.wrapInner("<span></span>");b.$text=b.$navigateUrl.find("span:eq(0)")}}b._hasChildren=b._getChildren();b.$inner=a("<span></span>").addClass("ui-helper-clearfix wijmo-wijtree-inner ui-corner-all");b._createChildNodes(e);b.$inner.append(b.$nodeImage);if(b.$checkBox!==null){b.$inner.append(b.$checkBox);b.$checkBox.wijtreecheck()}b.$inner.append(b.$navigateUrl);b.$nodeBody.append(b.$inner);e.prepend(b.$nodeBody)},_createChildNodes:function(c){var b=this,d=[];if(b._hasChildren){c.addClass("wijmo-wijtree-parent");b.$nodeBody.addClass("wijmo-wijtree-node wijmo-wijtree-header ui-state-default");b.$hitArea=a("<span>");b.$inner.prepend(b.$hitArea);b.$nodes=c.find("ul:eq(0)");d=b._createChildNode();b.$nodes.addClass("wijmo-wijtree-list ui-helper-reset wijmo-wijtree-child")}else{c.addClass("wijmo-wijtree-item");b.$nodeBody.addClass("wijmo-wijtree-node ui-state-default")}b._setField("nodes",d)},_createChildNode:function(){var b=this,d=b.options,e=[],c={};if(d.nodes&&d.nodes.length){if(b.$nodes&&b.$nodes.length)b.$nodes.empty();else b.$nodes=a("<ul>").appendTo(b.element);a.each(d.nodes,function(f,g){var a=b._generateMarkup(g);b.$nodes.append(a);a.data("owner",b);c.nIndex=f;c.treeClass=d.treeClass;a.wijtreenode(c);nodeWidget=b._getNodeWidget(a);nodeWidget._index=f;e.push(nodeWidget)})}else{if(!d.nodes)d.nodes=[];b.$nodes.children("li").each(function(h){var g=a(this),f;g.data("owner",b);c.cfli=true;c.nIndex=h;c.treeClass=d.treeClass;c.nodes=[];g.wijtreenode(c);f=b._getNodeWidget(g);f._index=h;e.push(f)})}return e},_generateMarkup:function(b){var c,d,e=b.navigateUrl;if(!a.isPlainObject(b))return;c=a("<li></li>");d=a("<a>").attr("src",typeof e==="string"&&e?e:"#");d.appendTo(c);typeof b.text==="string"&&b.text&&a("<span>").html(b.text).appendTo(d);return c},_initNode:function(){var a=this,b=a.options;if(!a._initialized){a._initialized=true;a._initNavigateUrl();if(!a._isTemplate&&a.$text){a._text=a.$text.html();b.text=a.$text.html()}a._hasChildren=a._getChildren();a._initNodesUL();a._initNodeClass();a._initNodeImg();a._initCheckBox();a.$navigateUrl.one("mousedown",a,a._onMouseDown)}},_initNodeClass:function(){var b=this,c=b.options,e,d="ui-icon "+(c.expanded?"ui-icon-triangle-1-se":"ui-icon-triangle-1-e");if(b._tree.options.showExpandCollapse)if(b._hasChildren||!!c.hasChildren){if(b.$hitArea!==null)b.$hitArea.removeClass("ui-icon ui-icon-triangle-1-se ui-icon-triangle-1-e").addClass(d);else{b.$hitArea=a("<span>").addClass(d).prependTo(b.$inner);b.element.removeClass("wijmo-wijtree-node ui-state-default ui-corner-all").addClass("wijmo-wijtree-parent")}if(b._hasChildren){e=c.expanded?"":"none";b.$nodes.css({display:e})}}else if(b.$hitArea){b.$hitArea.remove();b.$hitArea=null;b.element.removeClass("wijmo-wijtree-parent").addClass("wijmo-wijtree-node ui-state-default ui-corner-all")}c.selected&&b.$inner&&b.$inner.addClass("ui-state-active")},_initCheckBox:function(){var a=this,b=a.options;if(a.$checkBox&&b.checkState)switch(b.checkState){case"checked":a.$checkBox.wijtreecheck("option","checkState","check");break;case"indeterminate":a.$checkBox.wijtreecheck("option","checkState","triState");break;case"unChecked":a.$checkBox.wijtreecheck("option","checkState","unCheck");break;default:a.$checkBox.wijtreecheck("option","checkState","unCheck")}},_initNodesUL:function(){var a=this;if(a._tree.options.showExpandCollapse)a._hasChildren&&a.$nodes[a._expanded?"show":"hide"]()},_initNavigateUrl:function(){var a=this,b=a.$navigateUrl.attr("href");a.$navigateUrl.bind("blur."+a.widgetName,a,a._onBlur);if(!this._isTemplate){a._navigateUrl=!!b?b:"";a._setNavigateUrlHref(b)}},_applyIconClass:function(a,b){if(a.attr("expandediconclass")){b.expandedIconClass=a.attr("expandediconclass");a.removeAttr("expandediconclass")}if(a.attr("collapsediconclass")){b.collapsedIconClass=a.attr("collapsediconclass");a.removeAttr("collapsediconclass")}if(a.attr("itemiconclass")){b.itemIconClass=a.attr("itemiconclass");a.removeAttr("itemiconclass")}},_initNodeImg:function(){var b=this,c=b.options,d=b.element;if(b.$nodeImage===null||!b.$nodeImage.length)b.$nodeImage=a("<span>");b._applyIconClass(d,c);if(c.collapsedIconClass!==""&&c.expandedIconClass!==""){b.$nodeImage.removeClass().addClass("ui-icon").addClass(c.expanded?c.expandedIconClass:c.collapsedIconClass);!b._tree.options.showExpandCollapse&&b.$nodeImage.addClass(c.expandedIconClass);b.$nodeImage.insertBefore(b.$checkBox)}else if(c.itemIconClass!==""){b.$nodeImage.removeClass().addClass("ui-icon");b.$nodeImage.addClass(c.itemIconClass);b.$nodeImage.insertBefore(b.$checkBox)}},_setNavigateUrlHref:function(a){if(this.$navigateUrl){if(a===""||typeof a==="undefined")a="#";this.$navigateUrl.attr("href",a)}},_editNode:function(){this._tree._editMode=true;this.$navigateUrl.hide();if(!this.$editArea)this.$editArea=a('<input type="text">').wijtextbox();this.$editArea.val(this.$text.html());this.$editArea.insertBefore(this.$navigateUrl);this.$editArea.bind("blur",this,this._editionComplete);this.$editArea.focus()},_editionComplete:function(c){var a=c.data,b;a._tree._editMode=false;if(a.$editArea){b=a.$editArea.val();a.$editArea.remove()}a.$navigateUrl.show();a.$editArea=null;a._changeText(b)},_changeText:function(b){var a=this,c=a.options;if(a.$text!==null&&b!==""){a.$text.text(b);c.text=b;a._tree._trigger("nodeTextChanged",null,a)}},_expandCollapseItem:function(){var a=this,b=a.options;if(!a._tree.options.disabled&&!a._isClosestDisabled())(a._hasChildren||b.hasChildren)&&a._setExpanded(!b.expanded)},_expandNode:function(c){var a=this,b=a._tree.options,d=c?"nodeExpanding":"nodeCollapsing";if(a._tree._trigger(d,null,{node:this,params:this.options.params})===false)return;a.$nodeBody.attr("aria-expanded",c);a._expanded=c;a.options.expanded=c;if(!b.disabled&&!a._isClosestDisabled())if(c)if(b.expandDelay>0){if(typeof a._expandTimer!=="undefined")a._expandTimer=window.clearTimeout(a._expandTimer);a._expandTimer=window.setTimeout(function(){a._expandNodeVisually()},b.expandDelay)}else a._expandNodeVisually();else if(b.collapseDelay>0){a._collapseTimer=window.clearTimeout(a._collapseTimer);a._collapseTimer=window.setTimeout(function(){a._collapseNodeVisually()},b.collapseDelay)}else a._collapseNodeVisually()},_expandNodeVisually:function(){var b=this,d,c=b.options;if(b._tree.options.autoCollapse){d=b.element.siblings(":"+this.widgetBaseClass);a.each(d,function(c){var a=b._getNodeWidget(d[c]);a.options.expanded&&a._setExpanded(false)})}c.collapsedIconClass!==""&&c.expandedIconClass!==""&&b.$nodeImage.removeClass(c.collapsedIconClass).addClass(c.expandedIconClass);b._internalSetNodeClass(true);b._show()},_collapseNodeVisually:function(){var a=this;a.options.collapsedIconClass!==""&&a.options.expandedIconClass!==""&&a.$nodeImage.removeClass(a.options.expandedIconClass).addClass(a.options.collapsedIconClass);a._internalSetNodeClass(false);a._hide()},_internalSetNodeClass:function(a){this.$hitArea.removeClass("ui-icon ui-icon-triangle-1-se ui-icon-triangle-1-e").addClass("ui-icon "+(a?"ui-icon-triangle-1-se":"ui-icon-triangle-1-e"))},_show:function(){this._animation(true)},_hide:function(){this._animation(false)},_animation:function(d){var b=this,e=b.$nodes,h=d?"expandAnimation":"collapseAnimation",g=d?"nodeExpanded":"nodeCollapsed",f,c=b._tree.options[h];if(e)if(c){f=c.animated||c.effect;if(a.effects&&!!f)e[d?"show":"hide"](f,{easing:c.easing},c.duration,function(){b._tree._trigger(g,null,b)});else e[d?"show":"hide"](c.duration,function(){b._tree._trigger(g,null,b)})}else{e[d?"show":"hide"]();b._tree._trigger(g,null,b)}},_getBounds:function(a){var b=a.height(),e=a.width(),d=a.offset().top,c=a.offset().left;return{h:b,w:e,t:d,l:c}},_isMouseInsideRect:function(b,a){return b.x<a.l||b.x>=a.l+a.w?false:b.y<=a.t+1||b.y>=a.t+a.h?false:true},_getNodeByMouseOn:function(b){a("li").each(function(){var c=this._getBounds(a(this));if(a.ui.isOver(b.y,b.x,c.t,c.l,c.h,c.w))return a(this)});return null},_drowTemplate:function(b,e,d){var c="unKnown",f=d.is(".wijmo-wijtree-node")?d:d.children(".wijmo-wijtree-node"),a=this._getBounds(f);e.width(f.width());if(b.y>a.t&&b.y<a.t+a.h/2){e.offset({left:a.l,top:a.t});c="before"}else if(b.y>a.t+a.h/2&&b.y<a.t+a.h){e.offset({left:a.l,top:a.t+a.h});c="after"}return c},_beginDrag:function(i){var b=this,h=b.element,e,g=b._tree.options,d=g.draggable,f={cursor:"point",cursorAt:{top:15,left:-25},helper:function(){return a("<div>"+b.$navigateUrl.html()+"</div>").addClass("ui-widget-header ui-corner-all")},distance:a.browser.msie?1:10,handle:b.$navigateUrl,scope:"tree"},c=a("<div>").addClass("wijmo-wijtree-insertion ui-state-default");if(typeof g.dropVisual==="string"){e=a(g.dropVisual);c=e.length?e:c}else if(a.isFunction(g.dropVisual)){e=a(g.dropVisual.call());c=e.length?e:c}c.hide();a.extend(f,d);f.start=function(e,f){b._tree._isDragging=true;b._tree.widgetDom.prepend(c);b._tree._trigger("nodeDragStarted",e,b);if(d&&a.isFunction(d.start))d.start.call(b.element,e,f);else h.hide()};f.drag=function(e,h){var j=e.srcElement||e.originalEvent.target,g=a(j),f,i={x:e.pageX,y:e.pageY};c&&c.hide();if(g){f=b._getNodeWidget(g);if(f&&!f._tree.options.disabled){if(g.closest(".wijmo-wijtree-inner",b.element).length)b._insertPosition="end";else{c.show();b._insertPosition=b._drowTemplate(i,c,f.element)}b._dropTarget=f}}b._tree._trigger("nodeDragging",e,b);d&&a.isFunction(d.drag)&&d.drag.call(b.element,e,h)};f.stop=function(e,f){c.remove();b._dropTarget=null;b._insertPosition="unKnown";if(d&&a.isFunction(d.stop))d.stop.call(b.element,e,f);else{h.show();b._resetDrag()}};h.draggable(f).trigger(i);a.browser.mozilla&&b._setFocused(true)},_resetDrag:function(){var a=this,c,b;!a._tree.options.allowDrag&&a.element.data("draggable")&&a.element.draggable("destroy");c=a._getField("nodes");for(b=0;b<c.length;b++)c[b]._resetDrag()},_checkClick:function(){var a=this,b=a.options;if(!a._tree.options.disabled&&!a._isClosestDisabled()){if(b.checked&&a._checkState==="indeterminate"){a._checkState="checked";a._checkItem()}else{a._checkState=b.checked?"unChecked":"checked";a._setChecked(!b.checked)}a._tree._trigger("nodeCheckChanged",null,a)}},_checkItem:function(){var a=this,c=false,b=a._tree;if(b===null||!b.options.showCheckBoxes)return;if(b.options.autoCheckNodes&&a._checkState!=="indeterminate"){c=true;a._changeCheckState(a.options.checked)}b.options.allowTriState&&a._setParentCheckState();a[a.options.checked?"_checkNode":"_unCheckNode"](c)},_checkNode:function(e){var a=this,d=a.options,c=this._getField("nodes"),b;if(a._checkState==="checked"){a.$checkBox.wijtreecheck("option","checkState","check");d.checkState="checked"}else if(a._checkState==="indeterminate"){a.$checkBox.wijtreecheck("option","checkState","triState");d.checkState="indeterminate"}if(e)for(b=0;b<c.length;b++)c[b]._checkNode(true)},_unCheckNode:function(c){var b=this._getField("nodes"),d=this.options,a;this.$checkBox.wijtreecheck("option","checkState","unCheck");d.checkState="unChecked";if(c)for(a=0;a<b.length;a++)b[a]._unCheckNode(true)},_changeCheckState:function(b){var c=this._getField("nodes");a.each(c,function(c,a){a.options.checked=b;a.$nodeBody.attr("aria-checked",b);a._checkState=b?"checked":"unChecked";a._changeCheckState(b)})},_setParentCheckState:function(){var a=this._getOwner(),c,e=true,d=false,f=false,b,g=this;if(a.element.is(":"+g.options.treeClass))return;c=a._getField("nodes");for(b=0;b<c.length;b++){if(c[b]._checkState==="indeterminate")f=true;if(c[b].options.checked)d=true;else e=false;if(!e&&d)break}if(f){a._checkState="indeterminate";a._setChecked(true)}else if(d){if(e){a._checkState="checked";a._checkNode(false)}else a._checkState="indeterminate";a._setChecked(true)}else{a._checkState="unChecked";a._setChecked(false);a._unCheckNode(false)}a._setParentCheckState()},_onKeyDown:function(b){var d=a(b.target),c=this;d.closest(".wijmo-wijtree-inner",c.element).length>0&&c._keyAction(b)},_onClick:function(b){var d=a(b.target),c=this;if(d.closest(".wijmo-checkbox",c.element).length>0){c._checkClick(b);b.preventDefault();b.stopPropagation()}else if(c.$hitArea&&c.$hitArea[0]===d[0]){c._expandCollapseItem(b);b.preventDefault();b.stopPropagation()}else d.closest(".wijmo-wijtree-inner",c.element).length>0&&c._click(b)},_onMouseDown:function(c){var d=a(c.target),b=c.data;if(!b._tree.options.disabled&&b._tree.options.allowDrag)d.closest(".wijmo-wijtree-node",b.element).length>0&&b._beginDrag(c)},_onMouseOver:function(c){var e=a(c.target),b=this,d=a(c.relatedTarget);if(e.closest(".wijmo-wijtree-inner",b.element).length>0&&(this._tree._overNode!==b||d.is(":"+this.widgetBaseClass))){b._mouseOver(c);this._tree._overNode=b}b._mouseOverHitArea(c)},_onMouseOut:function(b){var f=a(b.target),c=this,e=a(b.relatedTarget),d=this._getNodeWidget(e);if(f.closest(".wijmo-wijtree-inner",c.element).length>0&&(this._tree._overNode!==d||e.is(":"+this.widgetBaseClass))){c._mouseOut(b);if(!d)this._tree._overNode=null}c._mouseOutHitArea(b)},_onFocus:function(d){var c=a(d.target),b=this;if(c.closest(".wijmo-wijtree-inner",b.element).length>0&&!b._tree.options.disabled&&!b._isClosestDisabled()&&!(c.hasClass("ui-icon-triangle-1-se")||c.hasClass("ui-icon-triangle-1-e"))&&!c.closest(".wijmo-checkbox",b.element).length){b._tree._focusNode&&b._tree._focusNode.$navigateUrl.blur();b._focused=true;b._tree._focusNode=this;b.$inner.addClass("ui-state-focus");b._tree._trigger("nodeFocus",d,b)}},_onBlur:function(c){var d=a(c.target),b=c.data;if(!b._tree.options.disabled&&!b._isClosestDisabled()){b._focused=false;d.closest(".wijmo-wijtree-inner",b.element).length>0&&b.$inner.removeClass("ui-state-focus");b._tree._trigger("nodeBlur",c,b)}},_click:function(d){var b=this,e=b.options,c=b._tree,f=b._navigateUrl;if(!c.options.disabled&&!b._isClosestDisabled()){if(!/^[#,\s]*$/.test(f))if(a.browser.msie&&/^7\.[\d]*/.test(a.browser.version)){if(f.indexOf(window.location.href)<0)return}else return;b._isClick=true;c._ctrlKey=d.ctrlKey;if(e.selected&&c._ctrlKey)b._setSelected(false);else if(e.selected&&!b._tree._editMode&&c.options.allowEdit&&!b._isTemplate)b._editNode();else b._setSelected(!e.selected);if(!b._isTemplate){d.preventDefault();d.stopPropagation()}}else b._setNavigateUrlHref("")},_selectNode:function(e,f){var b=this,d,c;if(!b._tree.options.disabled&&!b._isClosestDisabled()&&!b._tree._isDragging){d=b._tree._ctrlKey;if(d){c=a.inArray(b,b._tree._selectedNodes);if(c!==-1&&!e){b._tree._selectedNodes.splice(c,1);b.$inner.removeClass("ui-state-active")}}else{a.each(b._tree._selectedNodes,function(b,a){a.$inner.removeClass("ui-state-active");a.options.selected=false;a.$nodeBody.attr("aria-selected",false)});b._tree._selectedNodes=[]}if(e){c=a.inArray(b,b._tree._selectedNodes);c===-1&&this._tree._selectedNodes.push(b);b.$inner.addClass("ui-state-active")}else b.$inner.removeClass("ui-state-active");b._isClick&&b._tree._trigger("nodeClick",f,b);b._isClick=false;b._tree._ctrlKey=false;b._tree._trigger("selectedNodeChanged",f,b)}},_keyAction:function(c){var d=c.target,b=this;if(b._tree.options.disabled||b._isClosestDisabled())return;if(d){if(b._tree._editMode&&c.keyCode!==a.ui.keyCode.ENTER)return;switch(c.keyCode){case a.ui.keyCode.UP:b._moveUp();break;case a.ui.keyCode.DOWN:b._moveDown();break;case a.ui.keyCode.RIGHT:b._tree.options.showExpandCollapse&&b._moveRight();break;case a.ui.keyCode.LEFT:b._tree.options.showExpandCollapse&&b._moveLeft();break;case 83:!b._tree._editMode&&b._tree.options.allowSorting&&b.sortNodes();break;case 113:b._tree.options.allowEdit&&b._editNode();break;case 109:b._tree.options.showExpandCollapse&&this._expanded&&b._setExpanded(false);break;case 107:b._tree.options.showExpandCollapse&&!this._expanded&&b._setExpanded(true);break;case a.ui.keyCode.ENTER:if(b._tree._editMode){c.data=b;b._editionComplete(c)}break;case a.ui.keyCode.SPACE:if(b._tree.options.showCheckBoxes){b._checkState=b.options.checked?"unChecked":"checked";b._setChecked(!b.options.checked)}}b._customKeyDown(c.keyCode);if(!b._isTemplate&&c.keyCode!==a.ui.keyCode.ENTER){c.preventDefault();c.stopPropagation()}}},_customKeyDown:function(){},_prevNode:function(a){if(a.element.prev().length>0)return a.element.prev().data(this.widgetName)},_nextNode:function(a){if(a.element.next().length>0)return a.element.next().data(this.widgetName)},_getNextExpandedNode:function(c){var d=c,a=c._getField("nodes"),b;if(c._expanded&&a.length>0){b=a[a.length-1];if(b!==null)d=this._getNextExpandedNode(b)}return d},_getNextNode:function(b){var a=null,c=this;if(b.element.is(":"+c.options.treeClass))return null;a=c._nextNode(b);return a?a:c._getNextNode(b._getOwner())},_moveUp:function(){var b=this._getCurrentLevel(),a=this._prevNode(this);if(!a)b>0&&this._getOwner()._setFocused(true);else this._getNextExpandedNode(a)._setFocused(true)},_moveDown:function(){var c=this._getField("nodes"),b,d,a;if(this._expanded&&c.length>0)c[0]._setFocused(true);else{b=this._nextNode(this);if(b)b._setFocused(true);else{d=this._getOwner();a=this._getNextNode(d);a&&a._setFocused(true)}}},_moveLeft:function(){var a=this._getOwner();if(this._expanded)this._setExpanded(false);else a!==null&&!a.element.is(":"+this.options.treeClass)&&a._setFocused(true)},_moveRight:function(){if(this._hasChildren)if(!this._expanded)this._setExpanded(true);else{var a=this._getField("nodes")[0];a!==null&&a._setFocused(true)}},_mouseOver:function(c){var a=this,b=a._tree;if(!b.options.disabled&&!a._isClosestDisabled()&&!b._editMode){a._mouseOverNode();!b._isDragging&&b._trigger("nodeMouseOver",c,a)}},_mouseOut:function(c){var a=this,b=a._tree;if(!b.options.disabled&&!a._isClosestDisabled()&&!b._editMode){a._mouseOutNode();!b._isDragging&&b._trigger("nodeMouseOut",c,a)}},_mouseOverNode:function(){if(this.$inner!==null&&!this._isOverNode){this.$inner.addClass("ui-state-hover");this._isOverNode=true}},_mouseOutNode:function(){if(this.$inner!==null&&this._isOverNode){this.$inner.removeClass("ui-state-hover");this._isOverNode=false}},_mouseOverHitArea:function(c){var b,e,a=this,d=a._tree;if(!d.options.disabled&&!a._isClosestDisabled())if(d.options.expandCollapseHoverUsed)if(a._hasChildren&&!a._isOverHitArea){b=a._getBounds(a.element);e={x:c.pageX,y:c.pageY};if(a._isMouseInsideRect(e,b)){a._isOverHitArea=true;a._setExpanded(true)}}},_mouseOutHitArea:function(c){var e={x:c.pageX,y:c.pageY},b,a=this,d=a._tree;if(!d.options.disabled&&!a._isClosestDisabled())if(d.options.expandCollapseHoverUsed)if(a._hasChildren&&!!a._isOverHitArea){b=a._getBounds(a.element);if(!a._isMouseInsideRect(e,b)){a._isOverHitArea=false;a._setExpanded(false)}}else if(a._getOwner().element.is(":"+a.widgetBaseClass)){b=a._getBounds(a._getOwner().element);if(!a._isMouseInsideRect(e,b)){a._getOwner()._isOverHitArea=false;a._getOwner()._setExpanded(false)}}},destroy:function(){var b=this,c;b.element.data("draggable")&&b.element.draggable("destroy");b.$hitArea&&b.$hitArea.remove();b.$checkBox&&b.$checkBox.remove();b.$nodeImage&&b.$nodeImage.remove();b.$navigateUrl.unwrap().unwrap().removeClass("ui-state-default ui-state-active").unbind("mousedown").unbind("blur");c=this.element.find("ul:first").show();c.removeClass();c.children("li").each(function(){var c=b._getNodeWidget(a(this));c.destroy()});b.element.removeData("nodes").removeData("owner").removeData("widgetName").removeClass();a.Widget.prototype.destroy.apply(this)},add:function(c,f){var d=null,e,g,b=this,j,h,k="<li><a href='{0}'>{1}</a></li>",i;if(typeof c==="string"){e=a(k.replace(/\{0\}/,"#").replace(/\{1\}/,c));b._createNodeWidget(e);d=e.data(e.data("widgetName"))}else if(c.jquery){!c.data("widgetName")&&b._createNodeWidget(c);d=c.data(c.data("widgetName"))}else if(c.nodeType){e=a(c);b._createNodeWidget(e);d=e.data(e.data("widgetName"))}else if(a.isPlainObject(c)){e=a(k.replace(/\{0\}/,c.url?c.url:"#").replace(/\{1\}/,c.text));b._createNodeWidget(e,c);d=e.data(e.data("widgetName"))}if(d===null)return;g=b._getField("nodes");if(!f||f>g.length)if(f!==0)f=g.length;j=d._getField("nodes");d._tree=b._tree;for(h=0;h<j.length;h++)j[h]._tree=b._tree;d._setField("owner",b);i=g.length;if(!b.$nodes){b.$nodes=a("<ul></ul>").addClass("wijmo-wijtree-list ui-helper-reset wijmo-wijtree-child");b.element.append(b.$nodes)}if(i>0&&i!==f)d.element.get(0)!==g[f].element.get(0)&&d.element.insertBefore(g[f].element);else b.$nodes.append(d.element);b._changeCollection(f,d);b._collectionChanged("add");d._initNodeClass()},remove:function(b){var a=-1,c,e=this,d=this._getField("nodes");if(b.jquery)a=b.index();else if(typeof b==="number")a=b;if(a<0||a>=d.length)return;c=d[a];c.element.detach();e._changeCollection(a);e._collectionChanged("remove")},getNodes:function(){return this._getField("nodes")},_changeCollection:function(a,b){var c=this._getField("nodes"),d=this.options.nodes;if(b){c.splice(a,0,b);d.splice(a,0,b.options)}else{c.splice(a,1);d.splice(a,1)}},sortNodes:function(){var b=this._getField("nodes");this._sort();a.each(b,function(b,a){a._index=b;a._insertBefore(b)});this._refreshNodesClass()},check:function(a){this._setOption("checked",a)},select:function(a){this._setOption("selected",a)},getOwner:function(){var a=this._getOwner();return a&&a.element.is("li")?a:null},expand:function(){this._setOption("expanded",true)},collapse:function(){this._setOption("expanded",false)},_insertBefore:function(a){var b=this.element.parent().children("li");this.element.index()!==a&&this.element.insertBefore(b.eq(a))},_sort:function(){var a=this._getField("nodes");if(this._isSorted)if(!this._isDecsSort){a.sort(this._compare2NodeTextAcs);this._isDecsSort=true}else{a.sort(this._compare2NodeTextDesc);this._isDecsSort=false}else{a.sort(this._compare2NodeTextAcs);this._isSorted=true;this._isDecsSort=true}},_compare2NodeTextAcs:function(a,b){if(a!==null&&b!==null)return a._text.localeCompare(b._text)},_compare2NodeTextDesc:function(a,b){if(a!==null&&b!==null)return-1*a._text.localeCompare(b._text)},_collectionChanged:function(){this._hasChildren=this._getChildren();this._initNodeClass()},_refreshNodesClass:function(){for(var b=this._getField("nodes"),a=0;a<b.length;a++)b[a]._initNodeClass()},_setChecked:function(b){var a=this;if(a.options.checked===b&&a._checkState!=="indeterminate")return;a.options.checked=b;a.$nodeBody.attr("aria-checked",b);this._checkItem()},_isClosestDisabled:function(){var a=this;return a.element.closest(".wijmo-wijtree-disabled,.wijmo-wijtreenode-disabled",a._tree.element).length?true:false},_setExpanded:function(b){var a=this,c=a.options;if(a._expanded===b)return;(a._hasChildren||c.hasChildren)&&a._expandNode(b)},_setFocused:function(a){if(a){this.$navigateUrl.focus();this._setFocusNode()}else this.$navigateUrl.blur()},_setFocusNode:function(){this._tree._focusNode&&a.browser.webkit&&this._tree._focusNode.$navigateUrl.blur();this._focused=true;this._tree._focusNode=this;this.$inner.addClass("ui-state-focus");this._tree._trigger("nodeFocus",null,this)},_setToolTip:function(a){if(a.length)this.element.attr("title",a);else this.element.removeAttr("title")},_setText:function(a){if(this._text!==a&&a.length){this._text=a;this._changeText(a)}},_setSelected:function(a){var b=this,c=b.options;if(c.selected!==a){c.selected=a;b.$nodeBody.attr("aria-selected",a);b._selectNode(a);b._setFocused(a)}},_setCheckBoxes:function(c){var b=this;if(b.$checkBox)b.$checkBox[c?"show":"hide"]();else if(c){b.$checkBox=a("<div>");b.$checkBox.insertBefore(b.$navigateUrl);b.$checkBox.wijtreecheck()}b.$nodes&&b.$nodes.children("li").each(function(){var d=b._getNodeWidget(a(this));d!==null&&d._setCheckBoxes(c)})},_setHitArea:function(c){var b=this;if(b._hasChildren)if(c){b._initNodeClass();b.$hitArea&&b.$hitArea.show()}else{b._expanded=true;b.options.expanded=true;b.$nodeBody.attr("aria-expanded",true);b.$nodes&&b.$nodes.show();b._initNodeClass();b.$hitArea&&b.$hitArea.hide()}b.$nodes&&b.$nodes.children("li").each(function(){var d=b._getNodeWidget(a(this));d!==null&&d._setHitArea(c)})},_getOwner:function(){return this._getField("owner")},_getTree:function(){var a=this._getOwner();return a?a.element.is(":"+this.options.treeClass)?a:a._getTree():null},_getInitElement:function(){var b=a("<li>"),d=this,e=a("<ul>"),c=d._getField("nodes");b.append(d.$navigateUrl.clone());if(c.length){b.append(e);a.each(c,function(c,b){var a=b._getInitElement();e.append(a)})}return b},_getChildren:function(){return this.element.find(">ul:first>li").length>0&&this.element.children("ul:first")||!!(this.options.nodes&&this.options.nodes.length)},_getNodeWidget:function(c){var a=this._getNodeByDom(c),b;if(a.length>0){b=a.data(a.data("widgetName"));return b}return null},_createNodeWidget:function(c,b){if(a.fn.wijtreenode){c.data("owner",this);if(!!b&&a.isPlainObject(b)){a.extend(b,{treeClass:this.options.treeClass});c.wijtreenode(b)}else c.wijtreenode({treeClass:this.options.treeClass})}return c},_getNodeByDom:function(b){return a(b).closest(":"+this.widgetBaseClass)},_getCurrentLevel:function(){return this.element.parentsUntil(":"+this.options.treeClass).length-1},_getField:function(a){return this.element.data(a)},_setField:function(b,a){return this.element.data(b,a)}})})(jQuery);(function(a){var c="ui-icon ui-icon-check",b="ui-icon ui-icon-stop";a.widget("wijmo.wijtreecheck",{options:{checkState:"unCheck"},_create:function(){var b=this,c=this.options;if(b.element.is("div")){b.element.addClass("wijmo-checkbox ui-widget").attr("role","checkbox");b.$icon=a("<span>");b.$icon.addClass("wijmo-checkbox-icon");if(c.checkState==="check")b.$icon.addClass("ui-icon ui-icon-check");else c.checkState==="triState"&&b.$icon.addClass("ui-icon ui-icon-stop");b.$body=a("<div></div>").addClass("wijmo-checkbox-box ui-widget ui-corner-all ui-state-default").css({position:"relative"}).append(b.$icon);b.element.append(b.$body);b.element.bind("mouseover.wijtreecheck",function(){!b.options.disabled&&b.$body.removeClass("ui-state-default").addClass("ui-state-hover")}).bind("mouseout.wijtreecheck",function(){!b.options.disabled&&b.$body.removeClass("ui-state-hover").not(".ui-state-focus").addClass("ui-state-default")})}},_setOption:function(f,e){var d=this;if(f==="checkState")if(e==="unCheck"){d.$body.removeClass("ui-state-active");d.$icon.removeClass("ui-icon ui-icon-check ui-icon-stop ui-state-active")}else if(e==="check"){d.$body.addClass("ui-state-active");d.$icon.removeClass(b).addClass(c)}else if(e==="triState"){d.$body.addClass("ui-state-active");d.$icon.removeClass(c).addClass(b)}a.Widget.prototype._setOption.apply(d,arguments)},destory:function(){this.element.children().remove();this.element.removeClass("wijmo-checkbox ui-widget");a.Widget.prototype.destroy.apply(this)}})})(jQuery);
(function(a){"use strict";var r="wijmo-wijupload",j="wijmo-wijupload-fileRow",d="."+j,u="wijmo-wijupload-filesList",t="wijmo-wijupload-commandRow",i="wijmo-wijupload-uploadAll",h="wijmo-wijupload-cancelAll",s="wijmo-wijupload-buttonContainer",m="wijmo-wijupload-upload",e="."+m,l="wijmo-wijupload-cancel",n="."+l,v="wijmo-wijupload-file",f="wijmo-wijupload-progress",k="wijmo-wijupload-loading",w="ui-widget-content",o="ui-corner-all",x="ui-state-highlight",q,p,b=function(a){if(a.indexOf("\\")>-1)a=a.substring(a.lastIndexOf("\\")+1);return a},g=function(d){var e=d.files,c="";if(e){a.each(e,function(d,a){c+=b(a.name)+"; "});if(c.length)c=c.substring(0,c.lastIndexOf(";"))}else c=b(d.value);return c},c=function(d){var b=d.files,c=0;b&&b.length>0&&a.each(b,function(b,a){if(a.size)c+=a.size});return c};q=function(l,f,h){var e,d=a("input",f),k=function(a){if(a){a.abort();a=null}},j=function(a){if(a)a=null},i=function(){var e=this,l=d.get(0).files,m=[],i=0,n=0,p=function(j,h){var f=new XMLHttpRequest;f.open("POST",h,true);f.setRequestHeader("Wijmo-RequestType","XMLHttpRequest");f.setRequestHeader("Cache-Control","no-cache");f.setRequestHeader("Wijmo-FileName",j);f.setRequestHeader("Content-Type","application/octet-stream");f.upload.onprogress=function(h){if(h.lengthComputable){var f;if(a.isFunction(e.onProgress)){f={supportProgress:true,loaded:n+h.loaded,total:c(d[0]),fileName:b(e.currentFile.name),fileNameList:g(d[0]).split("; ")};e.onProgress(f)}}};f.onreadystatechange=function(d){if(this.readyState===4){var c=this.responseText,b;n+=l[i].size;i++;if(l.length>i)o(l[i]);else if(a.isFunction(e.onComplete)){b={e:d,response:c,supportProgress:true};e.onComplete(b)}}};m.push(f);return f},o=function(a){var c=b(a.name),d=p(c,h);e.currentFile=a;d.send(a)};e.fileRow=f;e.inputFile=d;e.upload=function(){o(l[i])};e.cancel=function(){a.each(m,function(b,a){k(a)});a.isFunction(e.onCancel)&&e.onCancel()};e.destroy=function(){a.each(m,function(b,a){j(a)})};e.updateAction=function(a){h=a};e.onCancel=null;e.onComplete=null;e.onProgress=null};e=new i;return e};p=function(n,j,l){var i,d=a("input",j),m=d.attr("id"),e="wijUploadForm_"+n,b=a("#"+e),g="wijUploadIfm_"+m,f=true,c=a('<iframe id="'+g+'" name="'+g+'">'),k=function(c,a){b.empty();b.attr("target",c.attr("name"));if(a){a.parent().append(a.clone());b.append(a)}b.submit()},p=function(a){a.attr("src","javascript".concat(":false;"))},o=function(a,c){if(c&&b){b.remove();b=null}if(a){a.remove();a=null}},h;if(b.length===0){b=a('<form method="post" enctype="multipart/form-data"></form>');b.attr("action",l).attr("id",e).attr("name",e).appendTo("body")}c.css("position","absolute").css("top","-1000px").css("left","-1000px");c.appendTo("body");h=function(){var e=this;e.fileRow=j;e.iframe=c;e.inputFile=d;e.upload=function(){var b;k(c,d);if(a.isFunction(e.onProgress)){b={supportProgress:false,loaded:1,total:1};e.onProgress(b)}};e.doPost=function(){k(c)};e.cancel=function(){p(c);a.isFunction(e.onCancel)&&e.onCancel()};e.updateAction=function(a){l=a;b.attr("action",a)};e.destroy=function(a){o(c,a)};e.onCancel=null;e.onComplete=null;e.onProgress=null;c.bind("load",function(i){if(!a.browser.safari)if(f&&!e.autoSubmit){f=false;return}if(c.attr("src")==="javascript".concat(":false;"))return;var g=i.target,d,b,h;try{b=g.contentDocument?g.contentDocument:window.frames[0].document;if(b.XMLDocument)d=b.XMLDocument;else if(b.body)d=b.body.innerHTML;else d=b;if(a.isFunction(e.onComplete)){h={e:i,response:d,supportProgress:false};e.onComplete(h)}}catch(j){d=""}})};i=new h;return i};a.widget("wijmo.wijupload",{options:{action:"",autoSubmit:false,change:null,upload:null,totalUpload:null,progress:null,totalProgress:null,complete:null,totalComplete:null,maximumFiles:0,multiple:false,accept:"",localization:{}},_create:function(){var b=this,e=b.options,d=+new Date,c=b.supportXhr();if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);b.filesLen=0;b.totalUploadFiles=0;b.useXhr=c;b.id=d;b._createContainers();b._createUploadButton();b._createFileInput();b._bindEvents();e.disabled&&b.disable();b.element.is(":hidden")&&b.element.wijAddVisibilityObserver&&b.element.wijAddVisibilityObserver(function(){b._applyInputPosition();b.element.wijRemoveVisibilityObserver&&b.element.wijRemoveVisibilityObserver()},"wijupload")},_setOption:function(d,c){var b=this;a.Widget.prototype._setOption.apply(this,arguments);if(d==="disabled")b._handleDisabledOption(c,b.upload);else if(d==="accept")b.input&&b.input.attr("accept",c)},_handleDisabledOption:function(b,c){var a=this;if(b){if(!a.disabledDiv)a.disabledDiv=a._createDisabledDiv(c);a.disabledDiv.appendTo("body")}else if(a.disabledDiv){a.disabledDiv.remove();a.disabledDiv=null}},_createDisabledDiv:function(d){var g=this,b=d?d:g.upload,c=b.offset(),f=b.outerWidth(),e=b.outerHeight();return a("<div></div>").addClass("ui-disabled").css({"z-index":"99999",position:"absolute",width:f,height:e,left:c.left,top:c.top})},destroy:function(){var b=this;b.upload.removeClass(r);b.upload.undelegate(b.widgetName).undelegate("."+b.widgetName);b.input.remove();b.addBtn.remove();b.filesList.remove();b.commandRow.remove();b.isCreateByInput===true&&b.element.css({display:""}).unwrap();if(b.uploaders){a.each(b.uploaders,function(b,a){a.destroy&&a.destroy(true);a=null});b.uploaders=null}if(b.disabledDiv){b.disabledDiv.remove();b.disabledDiv=null}},widget:function(){return this.upload},supportXhr:function(){var a=false;if(typeof(new XMLHttpRequest).upload==="undefined")a=false;else a=true;return a},_createContainers:function(){var b=this,e,d,c=b.element;if(c.is(":input")&&c.attr("type")==="file"){b.isCreateByInput=true;b.maxDisplay=c.attr("multiple")||b.options.multiple?0:1;b.upload=c.css({display:"none"}).wrap("<div>").parent()}else if(b.element.is("div"))b.upload=c;else throw'The initial markup must be "DIV", "INPUT[type=file]"';b.upload.addClass(r);e=a("<ul>").addClass(u).appendTo(b.upload);d=a("<div>").addClass(t).appendTo(b.upload);b.filesList=e;d.hide();b.commandRow=d;b._createCommandRow(d)},_createCommandRow:function(e){var b=this,d=a("<a>").attr("href","#").text("uploadAll").addClass(i).button({icons:{primary:"ui-icon-circle-arrow-n"},label:b._getLocalization("uploadAll","Upload All")}),c=a("<a>").attr("href","#").text("cancelAll").addClass(h).button({icons:{primary:"ui-icon-cancel"},label:b._getLocalization("cancelAll","Cancel All")});e.append(d).append(c)},_getLocalization:function(c,b){var a=this.options.localization;return a&&a[c]||b},_createUploadButton:function(){var b=this,c=a("<a>").attr("href","#").button({label:b._getLocalization("uploadFiles","Upload files")});c.mousemove(function(a){var d=c.data("button").options.disabled;if(b.input){var e=a.pageX,f=a.pageY;!d&&b.input.offset({left:e+10-b.input.width(),top:f+10-b.input.height()})}});b.addBtn=c;b.upload.prepend(c)},_applyInputPosition:function(){var d=this,a=d.addBtn,b=a.offset(),c=d.cuurentInput;c.offset({left:b.left+a.width()-c.width(),top:b.top}).height(a.height())},_createFileInput:function(){var b=this,d=b.addBtn,f=d.offset(),g=b.element.attr("accept")||b.options.accept,h="wijUpload_"+b.id+"_input"+b.filesLen,c=a("<input>").attr("type","file").prependTo(b.upload),i=b.options.maximumFiles||b.maxDisplay;i!==1&&b.maxDisplay===0&&c.attr("multiple","multiple");g&&c.attr("accept",g);b.cuurentInput=c;b.filesLen++;c.attr("id",h).attr("name",h).css("position","absolute").offset({left:f.left+d.width()-c.width(),top:f.top}).css("z-index","9999").css("opacity",0).height(d.height()).css("cursor","pointer");b.input=c;c.bind("change",function(g){var f,d;if(b._trigger("change",g,a(this))===false)return false;b._createFileInput();f=b._createFileRow(a(this));b._setAddBtnState();if(b.options.autoSubmit){d=a(e,f);d&&d.click()}c.unbind("change")});b.uploadAll=false},_setAddBtnState:function(){var b=this,d=b.options.maximumFiles||b.maxDisplay,c=b.addBtn,e;if(!d)return;if(!c)return;if(!b.maskDiv)b.maskDiv=a("<div></div>").css("position","absolute").css("z-index","9999").width(c.outerWidth()).height(c.outerHeight()).appendTo(b.upload).offset(c.offset());e=a("li",b.filesList);if(e.length>=d){c.button({disabled:true});b.maskDiv.show();b.input&&b.input.css("left","-1000px")}else{c.button({disabled:false});b.maskDiv.hide()}},_createFileRow:function(h){var c=this,b=a("<li>"),n,k,i,e=a("<span>").addClass(s),q=a("<a>").attr("href","#").text("upload").addClass(m).button({text:false,icons:{primary:"ui-icon-circle-arrow-n"},label:c._getLocalization("upload","upload")}),p=a("<a>").attr("href","#").text("cancel").addClass(l).button({text:false,icons:{primary:"ui-icon-cancel"},label:c._getLocalization("cancel","cancel")});b.addClass(j).addClass(w).addClass(o);b.append(h);h.hide();n=a("<span>"+g(h[0])+"</span>").addClass(v).addClass(x).addClass(o);b.append(n);b.append(e);k=a("<span />").addClass(f);e.append(k);e.append(q).append(p);b.appendTo(c.filesList);i=a(d,c.upload);if(i.length){c.commandRow.show();c._createUploader(b);c._resetProgressAll()}return b},_createUploader:function(e){var b=this,h=a("input",e),g=b.options.action,d;if(b.useXhr)d=q(b.id,e,g);else d=p(b.id,e,g);d.onCancel=function(){var a=this;b._trigger("cancel",null,a.inputFile);b.totalUploadFiles--;b.totalUploadFiles===0&&b.uploadAll&&b._trigger("totalComplete")};if(b._wijUpload()){d.onProgress=function(c){var d=a("."+f,this.fileRow),e={sender:c.fileName,loaded:c.loaded,total:c.total},g=this.inputFile.attr("id");if(c.supportProgress){d.html(Math.round(1e3*c.loaded/c.total)/10+"%");if(c.fileNameList)e.fileNameList=c.fileNameList;b._trigger("progress",null,e);b._progressTotal(g,c.loaded)}else d.addClass(k)};d.onComplete=function(e){var d=this,h=d.inputFile.attr("id"),j=b.uploaders[h],i=c(d.inputFile[0]),g=a("."+f,d.fileRow);b._trigger("complete",e.e,d.inputFile);g.removeClass(k);g.html("100%");b._removeFileRow(d.fileRow,j,true);b._progressTotal(h,i);b.totalUploadFiles--;b.totalUploadFiles===0&&b.uploadAll&&b._trigger("totalComplete",e.e,e)}}if(typeof b.uploaders==="undefined")b.uploaders={};b.uploaders[h.attr("id")]=d},_progressTotal:function(f,e){var b=this,a=b.progressAll,c,d;if(!b.uploadAll)return;if(a&&a.loadedSize){a.loadedSize[f]=e;c=b._getLoadedSize(a.loadedSize);d=a.totalSize}b._trigger("totalProgress",null,{loaded:c,total:d})},_getLoadedSize:function(c){var b=0;a.each(c,function(c,a){b+=a});return b},_getTotalSize:function(){var d=this,b=0;d.uploaders&&a.each(d.uploaders,function(d,a){b+=c(a.inputFile[0])});return b},_resetProgressAll:function(){this.progressAll={totalSize:0,loadedSize:{}}},_wijUpload:function(){return true},_wijcancel:function(){},_upload:function(){},_bindEvents:function(){var b=this,f=b.progressAll;b.upload.delegate(n,"click."+b.widgetName,function(){var i=a(this),h=i.parents(d),e=a("input",h[0]),g=b.uploaders[e.attr("id")];b._wijcancel(e);b._wijUpload()&&g&&g.cancel();if(f){f.totalSize-=c(e[0]);if(f.loadedSize[e.val()])delete f.loadedSize[e.val()]}b._removeFileRow(h,g,false)});b.upload.delegate(e,"click."+b.widgetName,function(g){var h=a(this),f=h.parents(d),e=a("input",f[0]),c=b.uploaders[e.attr("id")];if(b._trigger("upload",g,e)===false)return false;if(b.options.autoSubmit){c.autoSubmit=true;if(b._trigger("totalUpload",g,null)===false)return false}b.totalUploadFiles++;b._upload(f);c&&b._wijUpload()&&c.upload()});b.upload.delegate("."+i,"click."+b.widgetName,function(c){b.uploadAll=true;!b.progressAll&&b._resetProgressAll();if(b._trigger("totalUpload",c,null)===false)return false;b.progressAll.totalSize=b._getTotalSize();b._wijuploadAll(a(e,b.filesList[0]));b._wijUpload()&&a(e,b.filesList[0]).each(function(c,b){a(b).click()})});b.upload.delegate("."+h,"click."+b.widgetName,function(){b._resetProgressAll();a(n,b.filesList[0]).each(function(c,b){a(b).click()})})},_wijuploadAll:function(){},_wijFileRowRemoved:function(){this._setAddBtnState()},_removeFileRow:function(f,b,h){var c=this,e,g;if(b)e=b.inputFile.attr("id");f.fadeOut(1500,function(){f.remove();c._wijFileRowRemoved(f,b.inputFile,h);if(c.uploaders[e])delete c.uploaders[e];g=a(d,c.upload);if(g.length){c.commandRow.show();b&&b.destroy&&b.destroy()}else{c.commandRow.hide();c._resetProgressAll();b&&b.destroy&&b.destroy(true)}})},_getFileName:function(a){return b(a)},_getFileNameByInput:function(a){return g(a)},_getFileSize:function(a){return c(a)}})})(jQuery);
(function(a){"use strict";a.widget("wijmo.wijwizard",{options:{navButtons:"auto",autoPlay:false,delay:3e3,loop:false,hideOption:{fade:true},showOption:{fade:true,duration:400},ajaxOptions:null,cache:false,cookie:null,stepHeaderTemplate:"",panelTemplate:"",spinner:"",backBtnText:"back",nextBtnText:"next",add:null,remove:null,activeIndexChanged:null,show:null,load:null,validating:null},_defaults:{stepHeaderTemplate:"<li><h1>#{title}</h1>#{desc}</li>",panelTemplate:"<div></div>",spinner:"<em>Loading&#8230;</em>"},_create:function(){var b=this;if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);if(b.element.is(":hidden")&&b.element.wijAddVisibilityObserver){b.element.wijAddVisibilityObserver(function(){b._pageLize(true);b.element.wijRemoveVisibilityObserver&&b.element.wijRemoveVisibilityObserver()},"wijchart");return}b._pageLize(true)},_init:function(){var a=this.options,b=a.disabled;if(a.disabledState){this.disable();a.disabled=b}else a.autoPlay&&this.play()},_setOption:function(c,b){a.Widget.prototype._setOption.apply(this,arguments);switch(c){case"activeIndex":this.show(b);break;case"navButtons":this._createButtons();break;default:this._pageLize()}},play:function(){var b=this.options,a=this,c;if(!this.element.data("intId.wijwizard")){c=window.setInterval(function(){var c=b.activeIndex+1;if(c>=a.panels.length)if(b.loop)c=0;else{a.stop();return}a.show(c)},b.delay);this.element.data("intId.wijwizard",c)}},stop:function(){var a=this.element.data("intId.wijwizard");if(a){window.clearInterval(a);this.element.removeData("intId.wijwizard")}},_normalizeBlindOption:function(a){if(a.blind===undefined)a.blind=false;if(a.fade===undefined)a.fade=false;if(a.duration===undefined)a.duration=200;if(typeof a.duration==="string")try{a.duration=parseInt(a.duration,10)}catch(b){a.duration=200}},_createButtons:function(){var e=this,d=this.options,f,c,b,g=d.backBtnText,h=d.nextBtnText;this._removeButtons();if(d.navButtons==="none")return;if(!this.buttons){f=d.navButtons;if(f==="auto")f=this.list?"common":"edge";this.buttons=a("<div/>");this.buttons.addClass("wijmo-wijwizard-buttons");c=function(b,a){if(d.disabled)return;a.is(":not(.ui-state-disabled)")&&a.addClass("ui-state-"+b)};b=function(a,b){if(d.disabled)return;b.removeClass("ui-state-"+a)};if(f==="common"){this.backBtn=a("<a href='#'><span class='ui-button-text'>"+g+"</span></a>").addClass("ui-widget ui-button ui-button-text-only ui-state-default ui-corner-all").appendTo(this.buttons).bind({click:function(){e.back();return false},mouseover:function(){c("hover",a(this))},mouseout:function(){b("hover",a(this))},mousedown:function(){c("active",a(this))},mouseup:function(){b("active",a(this))}}).attr("role","button");this.nextBtn=a("<a href='#'><span class='ui-button-text'>"+h+"</span></a>").addClass("ui-widget ui-button ui-button-text-only ui-state-default ui-corner-all").appendTo(this.buttons).bind({click:function(){e.next();return false},mouseover:function(){c("hover",a(this))},mouseout:function(){b("hover",a(this))},mousedown:function(){c("active",a(this))},mouseup:function(){b("active",a(this))}}).attr("role","button")}else{this.backBtn=a("<a href='#'/>").addClass("wijmo-wijwizard-prev ui-state-default ui-corner-right").append("<span class='ui-icon ui-icon-triangle-1-w'></span>").appendTo(this.buttons).bind({click:function(){e.back();return false},mouseover:function(){c("hover",a(this))},mouseout:function(){b("hover",a(this))},mousedown:function(){c("active",a(this))},mouseup:function(){b("active",a(this))}}).attr("role","button");this.nextBtn=a("<a href='#'/>").addClass("wijmo-wijwizard-next ui-state-default ui-corner-left").append("<span class='ui-icon ui-icon-triangle-1-e'></span>").appendTo(this.buttons).bind({click:function(){e.next();return false},mouseover:function(){c("hover",a(this))},mouseout:function(){b("hover",a(this))},mousedown:function(){c("active",a(this))},mouseup:function(){b("active",a(this))}}).attr("role","button")}this.buttons.appendTo(this.element)}},_removeButtons:function(){if(this.buttons){this.buttons.remove();this.buttons=undefined}},_pageLize:function(d){var e=this,b=this.options,c=/^#.+/;this.list=this.element.children("ol,ul").eq(0);if(this.list&&this.list.length===0)this.list=null;if(this.list)this.lis=a("li",this.list);if(d){this.panels=a("> div",this.element);this.panels.each(function(e,d){var b=a(d).attr("src");b&&!c.test(b)&&a.data(d,"load.wijwizard",b.replace(/#.*$/,""))});this.element.addClass("wijmo-wijwizard ui-widget ui-helper-clearfix");if(this.list){this.list.addClass("ui-widget ui-helper-reset wijmo-wijwizard-steps ui-helper-clearfix").attr("role","tablist");this.lis.addClass("ui-widget-header ui-corner-all").attr("role","tab")}this.container=a("<div/>");this.container.addClass("wijmo-wijwizard-content ui-widget ui-widget-content ui-corner-all");this.container.append(this.panels);this.container.appendTo(this.element);this.panels.addClass("wijmo-wijwizard-panel ui-widget-content").attr("role","tabpanel");if(b.activeIndex===undefined){if(typeof b.activeIndex!=="number"&&b.cookie)b.activeIndex=parseInt(e._cookie(),10);if(typeof b.activeIndex!=="number"&&this.panels.filter(".wijmo-wijwizard-actived").length)b.activeIndex=this.panels.index(this.panels.filter(".wijmo-wijwizard-actived"));b.activeIndex=b.activeIndex||(this.panels.length?0:-1)}else if(b.activeIndex===null)b.activeIndex=-1;b.activeIndex=b.activeIndex>=0&&this.panels[b.activeIndex]||b.activeIndex<0?b.activeIndex:0;this.panels.addClass("wijmo-wijwizard-hide").attr("aria-hidden",true);if(b.activeIndex>=0&&this.panels.length){this.panels.eq(b.activeIndex).removeClass("wijmo-wijwizard-hide").addClass("wijmo-wijwizard-actived").attr("aria-hidden",false);this.load(b.activeIndex)}this._createButtons()}else{this.panels=a("> div",this.container);b.activeIndex=this.panels.index(this.panels.filter(".wijmo-wijwizard-actived"))}this._refreshStep();this._initScroller();b.cookie&&this._cookie(b.activeIndex,b.cookie);b.cache===false&&this.panels.removeData("cache.wijwizard");if(b.showOption===undefined||b.showOption===null)b.showOption={};this._normalizeBlindOption(b.showOption);if(b.hideOption===undefined||b.hideOption===null)b.hideOption={};this._normalizeBlindOption(b.hideOption);this.panels.unbind(".wijwizard")},_initScroller:function(){if(!this.lis)return;var b=0;this.lis.each(function(){b+=a(this).outerWidth(true)});if(this.element.innerWidth()<b){if(this.scrollWrap===undefined){this.list.wrap("<div class='scrollWrap'></div>");this.scrollWrap=this.list.parent();a.effects.save(this.list,["width","height","overflow"])}this.list.width(b+8);this.scrollWrap.height(this.list.outerHeight(true));this.scrollWrap.wijsuperpanel({allowResize:false,hScroller:{scrollBarVisibility:"hidden"},vScroller:{scrollBarVisibility:"hidden"}})}else this._removeScroller()},_removeScroller:function(){if(this.scrollWrap){this.scrollWrap.wijsuperpanel("destroy").replaceWith(this.scrollWrap.contents());this.scrollWrap=undefined;a.effects.restore(this.list,["width","height","overflow"])}},_refreshStep:function(){var a=this.options;if(this.lis){this.lis.removeClass("ui-priority-primary").addClass("ui-priority-secondary").attr("aria-selected",false);if(a.activeIndex>=0&&a.activeIndex<=this.lis.length-1){this.lis&&this.lis.eq(a.activeIndex).removeClass("ui-priority-secondary").addClass("ui-priority-primary").attr("aria-selected",true);this.scrollWrap&&this.scrollWrap.wijsuperpanel("scrollChildIntoView",this.lis.eq(a.activeIndex))}}if(this.buttons&&!a.loop){this.backBtn[a.activeIndex<=0?"addClass":"removeClass"]("ui-state-disabled").attr("aria-disabled",a.activeIndex===0);this.nextBtn[a.activeIndex>=this.panels.length-1?"addClass":"removeClass"]("ui-state-disabled").attr("aria-disabled",a.activeIndex>=this.panels.length-1)}},_sanitizeSelector:function(a){return a.replace(/:/g,"\\:")},_cookie:function(){var b=this.cookie||(this.cookie=this.options.cookie.name);return a.cookie.apply(null,[b].concat(a.makeArray(arguments)))},_ui:function(a){return{panel:a,index:this.panels.index(a)}},_removeSpinner:function(){this.element.removeClass("ui-state-processing");var a=this.element.data("spinner.wijwizard");if(a){this.element.removeData("spinner.wijwizard");a.remove()}},_resetStyle:function(b){b.css({display:""});!a.support.opacity&&b[0].style.removeAttribute("filter")},destroy:function(){var b=this.options;this.abort();this.stop();this._removeScroller();this._removeButtons();this.element.unbind(".wijwizard").removeClass(["wijmo-wijwizard","ui-widget","ui-helper-clearfix"].join(" ")).removeData("wijwizard");this.list&&this.list.removeClass("ui-widget ui-helper-reset wijmo-wijwizard-steps ui-helper-clearfix").removeAttr("role");if(this.lis){this.lis.removeClass("ui-widget-header ui-corner-all ui-priority-primary ui-priority-secondary").removeAttr("role");this.lis.each(function(){if(a.data(this,"destroy.wijwizard"))a(this).remove();else a(this).removeAttr("aria-selected")})}this.panels.each(function(){var b=a(this).unbind(".wijwizard");a.each(["load","cache"],function(c,a){b.removeData(a+".wijwizard")});if(a.data(this,"destroy.wijwizard"))a(this).remove();else a(this).removeClass(["ui-state-default","wijmo-wijwizard-actived","ui-state-active","ui-state-hover","ui-state-focus","ui-state-disabled","wijmo-wijwizard-panel","ui-widget-content","wijmo-wijwizard-hide"].join(" ")).css({position:"",left:"",top:""}).removeAttr("aria-hidden")});this.container.replaceWith(this.container.contents());b.cookie&&this._cookie(null,b.cookie);return this},add:function(b,f,h){if(b===undefined)b=this.panels.length;if(f===undefined)f="Step "+b;var d=this,g=this.options,c=a(g.panelTemplate||d._defaults.panelTemplate).data("destroy.wijwizard",true),e;c.addClass("wijmo-wijwizard-panel ui-widget-content ui-corner-all wijmo-wijwizard-hide").attr("aria-hidden",true);if(b>=this.panels.length)if(this.panels.length>0)c.insertAfter(this.panels[this.panels.length-1]);else c.appendTo(this.container);else c.insertBefore(this.panels[b]);if(this.list&&this.lis){e=a((g.stepHeaderTemplate||d._defaults.stepHeaderTemplate).replace(/#\{title\}/g,f).replace(/#\{desc\}/g,h));e.addClass("ui-widget-header ui-corner-all ui-priority-secondary").data("destroy.wijwizard",true);if(b>=this.lis.length)e.appendTo(this.list);else e.insertBefore(this.lis[b])}this._pageLize();if(this.panels.length===1){g.activeIndex=0;e.addClass("ui-priority-primary");c.removeClass("wijmo-wijwizard-hide").addClass("wijmo-wijwizard-actived").attr("aria-hidden",false);this.element.queue("wijwizard",function(){d._trigger("show",null,d._ui(d.panels[0]))});this._refreshStep();this.load(0)}this._trigger("add",null,this._ui(this.panels[b]));return this},remove:function(a){var c=this.options,b=this.panels.eq(a).remove();this.lis.eq(a).remove();if(a<c.activeIndex)c.activeIndex--;this._pageLize();b.hasClass("wijmo-wijwizard-actived")&&this.panels.length>=1&&this.show(a+(a<this.panels.length?0:-1));this._trigger("remove",null,this._ui(b[0]));return this},_showPanel:function(f){var c=this,d=this.options,b=a(f),e;b.addClass("wijmo-wijwizard-actived");if((d.showOption.blind||d.showOption.fade)&&d.showOption.duration>0){e={duration:d.showOption.duration};if(d.showOption.blind)e.height="toggle";if(d.showOption.fade)e.opacity="toggle";b.hide().removeClass("wijmo-wijwizard-hide").animate(e,d.showOption.duration||"normal",function(){c._resetStyle(b);b.wijTriggerVisibility&&b.wijTriggerVisibility();c._trigger("show",null,c._ui(b[0]));c._removeSpinner();b.attr("aria-hidden",false);c._trigger("activeIndexChanged",null,c._ui(b[0]))})}else{b.removeClass("wijmo-wijwizard-hide").attr("aria-hidden",false);b.wijTriggerVisibility&&b.wijTriggerVisibility();c._trigger("show",null,c._ui(b[0]));c._removeSpinner();c._trigger("activeIndexChanged",null,c._ui(b[0]))}},_hidePanel:function(f){var e=this,b=this.options,c=a(f),d;c.removeClass("wijmo-wijwizard-actived");if((b.hideOption.blind||b.hideOption.fade)&&b.hideOption.duration>0){d={duration:b.hideOption.duration};if(b.hideOption.blind)d.height="toggle";if(b.hideOption.fade)d.opacity="toggle";c.animate(d,b.hideOption.duration||"normal",function(){c.addClass("wijmo-wijwizard-hide").attr("aria-hidden",true);e._resetStyle(c);e.element.dequeue("wijwizard")})}else{c.addClass("wijmo-wijwizard-hide").attr("aria-hidden",true);this.element.dequeue("wijwizard")}},show:function(b){if(b<0||b>=this.panels.length)return this;if(this.element.queue("wijwizard").length>0)return this;var g=this,c=this.options,f=a.extend({},this._ui(this.panels[c.activeIndex])),d,e;f.nextIndex=b;f.nextPanel=this.panels[b];if(this._trigger("validating",null,f)===false)return this;d=this.panels.filter(":not(.wijmo-wijwizard-hide)");e=this.panels.eq(b);c.activeIndex=b;this.abort();c.cookie&&this._cookie(c.activeIndex,c.cookie);this._refreshStep();if(e.length){d.length&&this.element.queue("wijwizard",function(){g._hidePanel(d)});this.element.queue("wijwizard",function(){g._showPanel(e)});this.load(b)}else throw"jQuery UI wijwizard: Mismatching fragment identifier.";return this},next:function(){var b=this.options,a=b.activeIndex+1;if(b.disabled)return false;if(b.loop)a=a%this.panels.length;if(a<this.panels.length){this.show(a);return true}return false},back:function(){var b=this.options,a=b.activeIndex-1;if(b.disabled)return false;if(b.loop)a=a<0?this.panels.length-1:a;if(a>=0){this.show(a);return true}return false},load:function(f){var d=this,b=this.options,e=this.panels.eq(f)[0],g=a.data(e,"load.wijwizard"),c;this.abort();if(!g||this.element.queue("wijwizard").length!==0&&a.data(e,"cache.wijwizard")){this.element.dequeue("wijwizard");return}this.element.addClass("ui-state-processing");if(b.spinner){c=this.element.data("spinner.wijwizard");if(!c){c=a("<div/>");c.addClass("wijmo-wijwizard-spinner");c.html(b.spinner||d._defaults.spinner);c.appendTo(document.body);this.element.data("spinner.wijwizard",c);c.wijpopup({showEffect:"blind",hideEffect:"blind"})}c.wijpopup("show",{of:this.element,my:"center center",at:"center center"})}this.xhr=a.ajax(a.extend({},b.ajaxOptions,{url:g,dataType:"html",success:function(c,g){a(e).html(c);b.cache&&a.data(e,"cache.wijwizard",true);d._trigger("load",null,d._ui(d.panels[f]));try{b.ajaxOptions&&b.ajaxOptions.success&&b.ajaxOptions.success(c,g)}catch(h){}},error:function(a,c){d._trigger("load",null,d._ui(d.panels[f]));try{b.ajaxOptions&&b.ajaxOptions.error&&b.ajaxOptions.error(a,c,f,e)}catch(g){}}}));d.element.dequeue("wijwizard");return this},abort:function(){this.element.queue([]);this.panels.stop(false,true);this.element.queue("wijwizard",this.element.queue("wijwizard").splice(-2,2));if(this.xhr){this.xhr.abort();delete this.xhr}this._removeSpinner();return this},url:function(a,b){this.panels.eq(a).removeData("cache.wijwizard").data("load.wijwizard",b);return this},count:function(){return this.panels.length}})})(jQuery);
(function(a){"use strict";var b="wijmo-wijribbon",x=b+"-disabled",n=b+"-bigbutton",A=b+"-panel",q=b+"-groups",j=b+"-group",u=j+"-content",w=j+"-label",o=b+"-dropdown",g=b+"-dropdowngroup",p=b+"-abbrev",l=p+"group",B=b+"-text",s=b+"-icon",v=b+"-abbrevicon",z="ui-widget-content",i="ui-helper-reset",C="ui-tabs-nav",h="ui-helper-clearfix",f="ui-corner-all",c="ui-button-text",r="ui-state-default",e="ui-state-hover",d="ui-state-active",y="ui-state-disabled",t="ui-icon",m=t+"-triangle-1-s",k="ui-tabs-hide";a.widget("wijmo.wijribbon",{options:{click:null},_create:function(){var b=this;if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);b._ribbonify();b.element.is(":hidden")&&b.element.wijAddVisibilityObserver&&b.element.wijAddVisibilityObserver(function(){b.updateRibbonSize();b.options.disabled&&b._setDisabled(true);b.element.wijRemoveVisibilityObserver&&b.element.wijRemoveVisibilityObserver()},"wijribbon");b.options.disabled&&b._setDisabled(true)},_setOption:function(c,b){a.Widget.prototype._setOption.apply(this,arguments);c==="disabled"&&this._setDisabled(b)},_setDisabled:function(i){var c=this,b=c.element,g=b.offset(),h=g.top,f=g.left,e="body",d=c.disabledModal;b.wijtabs("option","disabled",i);if(b.closest(".wijmo-wijeditor").length!==0){h=0;f=0;e=b.parent()}if(i){if(!d){d=a("<div></div>").addClass(y+" "+x).css({top:h,left:f,"z-index":"10000","background-color":"lightgray",position:"absolute"}).appendTo(e).bind("click mousedown mouseup mouseover mouseout focus keydown keypress",function(a){a.stopPropagation();a.preventDefault();return false});c.disabledModal=d}c.disabledModal.width(b.width()).height(b.height()).show()}else c.disabledModal&&c.disabledModal.hide()},_ribbonify:function(){var b=this;b.buttons={};b.listUis={};b._getButtonSets();b._createButtons();b._createGroup();b._createSplit();b._createDropdwon();b._hideShowedList();b._createTab();a("."+i+":not(."+q+", ."+C+")",b.element).hover(function(){a(this).addClass(e)},function(){a(this).removeClass(e)});a(".ui-button",b.element).bind("mouseenter",function(){a("."+c,this).addClass(e)}).bind("mouseleave",function(){a("."+c,this).removeClass(e)});a("button.ui-button").bind("mousedown",function(){b._addActiveClassToButtonText(this)}).bind("mouseup",function(){b._addActiveClassToButtonText(this)});a("label.ui-button").bind("click",function(){b._addActiveClassToLabelButtonText(this)})},_addActiveClassToButtonText:function(b){if(b)if(a(b).hasClass(d))a("."+c,b).addClass(d);else a("."+c,b).removeClass(d)},_addActiveClassToLabelButtonText:function(d){var c=this,b,f,e;if(d){f=a(d).attr("for");b=a("#"+f,c.element);if(b.is(":checkbox"))c._addActiveClassToButtonText(d);else if(b.is(":radio")){e=c.element.find("[name='"+b.attr("name")+"']");a.each(e,function(){c._updateGroupElementTextState(this)})}}},_updateGroupElementTextState:function(e){var b;if(!e)return;b=a("[for='"+a(e).attr("id")+"']",a(e).parent());if(b)if(b.hasClass(d))b.children("."+c).addClass(d);else b.children("."+c).removeClass(d)},_getButtonSets:function(){var b=this,c;b.groups=[];b.splits=[];b.dropdowns=[];a("span>button, span>:checkbox, span>:radio, div>button, div>:checkbox, div>:radio",b.element).each(function(e,d){c=a(d).parent();if(a(">ul",c).length===0)b.groups.push(c);else if(a(">button",c).length===2)b.splits.push(c);else a(">button",c).length===1&&b.dropdowns.push(c)});b.groups=b._unique(b.groups);b.splits=b._unique(b.splits)},_unique:function(c){var b=a.map(c,function(a){return a.get(0)});return a.map(a.unique(b),function(b){return a(b)})},_createButtons:function(){var b=this,c=b.element;a(":checkbox",c).each(function(){b._createButton(a(this),"checkbox")});a(":radio",c).each(function(){b._createButton(a(this),"radio")});a("button",c).each(function(){b._createButton(a(this),"button")})},_createButton:function(b,h){var g=this,e=g._buildButtonOption(b,h),f=b.data("commandName"),d;b.button(e);if(!e.text)if(h==="button")b.children("."+c).text(f);else{d=a("[for='"+b.attr("id")+"']",b.parent());d&&d.children("."+c).text(f)}g._triggerEvent(b)},_createGroup:function(){a.each(this.groups,function(b,a){a.buttonset()})},_createSplit:function(){var d=this;a.each(d.splits,function(p,g){var e=g.children("ul"),j=g.children("button:eq(0)"),l=j.data("commandName"),k=g.children("button:eq(1)"),n;e.children("li").addClass(f);g.addClass(b+"-"+l);k.button({icons:{primary:m},text:false}).data("list",e).unbind("click").bind("click",function(a){a.stopPropagation();a.preventDefault()}).bind("mouseup",function(b){e=a(this).data("list");if(e.is(":visible")){d.showList.hide().css("z-index","");d.showList=null}else{e.show().position({my:"left top",at:"left bottom",of:g}).css("z-index",9999);d.showList=e}b.stopPropagation();b.preventDefault()});k.children("."+c).text("foo");g.after(e);e.css("position","absolute").addClass(i+" "+h+" "+f+" "+o).hide();g.buttonset();n={ui:j,defaultValue:j.button("option","label"),buttons:[],type:"split",trigger:k,list:e};a("button, :checkbox, :radio",e).bind("click",function(a){e.hide().css("z-index","");d.showList=null;a.preventDefault()});e.find(">li>button,>li>:radio,>li>:checkbox").each(function(e,c){var b=a(c).data("commandName");if(b!==""&&d.buttons[b]){d.buttons[b].parent=j;d.buttons[b].type="split"}n.buttons.push(a(c))});if(l!=="")d.listUis[l]=n})},_createDropdwon:function(){var d=this;d.dropdownLabels={};a.each(d.dropdowns,function(n,j){var g=j.children("ul"),e=j.children("button:eq(0)"),k=e.data("commandName"),l;g.children("li").addClass(f);j.addClass(b+"-"+k);e.button({icons:{secondary:m}}).unbind("click").bind("click",function(a){a.stopPropagation();a.preventDefault()}).bind("mouseup",function(a){if(g.is(":visible")){d.showList.hide().css("z-index","");d.showList=null}else{if(d.showList){d.showList.hide();d.showList=null}g.show().position({my:"left top",at:"left bottom",of:e}).css("z-index",9999);d.showList=g;d.isShow=true}a.stopPropagation();a.preventDefault()});l={ui:e,defaultValue:e.button("option","label"),buttons:[],type:"dropdown",list:g};a("button, :checkbox, :radio",g).bind("click",function(i){var b=a(this).data("commandName"),f,h=e.children("."+c).width();if(!d.dropdownLabels[b])d.dropdownLabels[b]=d._getDropdownLabelSubstr(a(this).button("option","label"),e.children("."+c),h);f=d.dropdownLabels[b];e.button("option","label",f);e.attr("title",a(this).button("option","label"));g.hide().css("z-index","");d.showList=null;i.preventDefault()});g.css("position","absolute").addClass(i+" "+h+" "+f+" "+o).hide();j.buttonset();g.find(">li>button,>li>:radio,>li>:checkbox").each(function(f,c){var b=a(c).data("commandName");if(b!==""&&d.buttons[b]){d.buttons[b].parent=e;d.buttons[b].type="dropdown"}l.buttons.push(a(c))});if(k!=="")d.listUis[k]=l})},_createTab:function(){var d=this,c=d.element;c.addClass(b);d.tabEle=c;if(a(">ul",c).length>0){c.wijtabs();d._createRibbonGroups();return true}else c.addClass(b+"-simple").addClass(r).addClass(h);return false},updateRibbonSize:function(){var e=this,c,d;e.tabEle.children("div").each(function(o,n){var f=a(n),i=f.is(":visible"),m=f.find(">ul>li"),j=[],h;h=f.width();if(!i){f.removeClass(k);h=f.width()}m.each(function(k,i){var e=a(i),f=e.find(">div:last"),h=f.attr("displayname")?f.attr("displayname"):a.trim(f.text());c=e.children("."+g);d=e.children("."+l);if(c){e.addClass(b+"-"+h.toLowerCase()).prepend(c.children());c.remove();d&&d.remove()}j.push({width:e.outerWidth(true),text:h})});e._adjustRibbonGroupIfNeeded(m,j,h);!i&&f.addClass(k)})},_createRibbonGroups:function(){var c=this;c.tabEle.children("div").each(function(p,o){var d=a(o),l=d.is(":visible"),n=d.find(">ul>li"),g=[],m;if(d.data("destroy.tabs")){d.remove();return}!l&&d.removeClass(k);m=d.width();d.addClass(A);d.find(">ul").addClass(i+" "+h+" "+z+" "+f+" "+q);n.each(function(k,i){var d=a(i),c=d.find(">div:last"),h=r+" "+j,f=c.attr("displayname")?c.attr("displayname"):a.trim(c.text());if(c)h+=" "+b+"-"+f.toLowerCase();d.addClass(h);c.addClass(w).bind("click",function(){return false});d.wrapInner("<div class = '"+u+"'></div>");d.children().bind("mouseover",function(){a(this).addClass(e)}).bind("mouseout",function(){a(this).removeClass(e)});c.appendTo(d);g.push({width:d.outerWidth(true),text:f})});c._originalGroupInfo=g;c._adjustRibbonGroupIfNeeded(n,g,m);!l&&d.addClass(k)})},_adjustRibbonGroupIfNeeded:function(d,f,n){for(var o=this,c=d.length-1,h=0,k=0,j=0,e,i,m;c>=0;c--){j=0;for(h=0;h<c;h++)j+=f[h].width;if(j+k+f[c].width<=n){e=a(d[c]).children("."+g);i=a(d[c]).children("."+l);if(e){a(d[c]).addClass(b+"-"+f[c].text.toLowerCase()).prepend(e.children());e.remove();i&&i.remove()}}else{m=f[c];k+=o._createDropDownRibbonGroup(m.text,d[c])}}},_createDropDownRibbonGroup:function(f,n){var c=this,h=b+"-"+f.toLowerCase(),d=a(n).removeClass(h),i=d.find(">div:last").text()||f,k;d.wrapInner("<div class='"+g+" "+j+"'></div>").children().hide().addClass(h).bind("mouseup."+c.widget,function(){if(c.showDrpDwnGroup!==null){c.showDrpDwnGroup.hide().css("z-index","");c.showDrpDwnGroup=null}});k=a("<div class='"+l+"'><span class='"+p+f.toLowerCase()+" "+s+" "+v+"'></span><span class='"+B+"'>"+i+"</span><span class='"+t+" "+m+" "+s+"'></span></div>").appendTo(d).unbind(c.widget).bind("mouseover."+c.widget,function(){a(this).addClass(e)}).bind("mouseout."+c.widget,function(){a(this).removeClass(e)}).bind("click."+c.widget,function(d){var b=a(this).siblings("."+g);if(b.is(":visible")){b.hide().css("z-index","");c.showDrpDwnGroup=null}else{c.showDrpDwnGroup&&c.showDrpDwnGroup.hide().css("z-index","");b.show().position({my:"left top",at:"left bottom",of:this}).css("z-index","10000");c.showDrpDwnGroup=b;d.stopPropagation()}});return d.outerWidth(true)},_hideShowedList:function(){var b=this;a(document).bind("mouseup",function(d){var c=d.target;if(b.showList)if(a(c).is(document)||!a.contains(b.showList.get(0),c)){b.showList.hide().css("z-index","");b.showList=null}if(b.showDrpDwnGroup)if(a(c).is(document)||!a.contains(b.showDrpDwnGroup.get(0),c)){b.showDrpDwnGroup.hide().css("z-index","");b.showDrpDwnGroup=null}})},_buildButtonOption:function(b,j){var k=true,m=this,d=b.attr("class"),c,f,i,l,g,e,h;if(d&&d!==""&&d!==n){f=d.split(" ")[0];b.removeClass(f);g=a.trim(b.text());if(g==="")k=false}else{if(j==="checkbox"||j==="radio"){if(a.trim(b.attr("id"))==="")return;e=a("[for='"+b.attr("id")+"']",b.parent());if(!e.is("label"))return;d=e.attr("class");if(d&&d!==""&&d!==n){f=d.split(" ")[0];e.removeClass(f);g=a.trim(e.text());if(g==="")k=false}else c=e.children("span,div")}else if(j==="button")c=b.children("span,div");if(c)if(c.length===1){if(c.eq(0).attr("class")!==""){i=c.eq(0);f=i.attr("class");k=false}}else if(c.length===2){if(c.eq(0).attr("class")){i=c.eq(0);f=i.attr("class");if(i.is("span"))l="left";else if(i.is("div"))l="top";g=c.eq(1).text()}}else if(j==="button"&&a.trim(b.text())!=="")g=a.trim(b.text())}if(j==="button"){b.empty();h=a.trim(b.attr("name"));h!==""&&b.removeAttr("name")}else{h=a.trim(e.attr("name"));h!==""&&e.removeAttr("name")}if(h!==""){b.data("commandName",h);m.buttons[h]={button:b}}return{label:g,icons:{primary:f},position:l,text:k}},_triggerEvent:function(a){var b=this;a.bind("click",function(e){var f=a.data("commandName"),c=b.buttons[f],d={};if(c&&c.parent)d.name=c.parent.data("commandName");d.commandName=f;b._trigger("click",e,d);if(a.is("button")){e.preventDefault();e.stopPropagation()}})},_getDropdownLabelSubstr:function(i,l,h){var j=this,k=i.length,e=0,f=k,c=Math.floor((e+f)/2),d=a("<span></span>"),g=i.substr(0,c),b;d.appendTo(l.parent());b=j._calculateWidth(g,d);while(b!==h&&f>e){g=i.substr(0,c+1);b=j._calculateWidth(g,d);if(b>h)f=c-1;else if(b<h)e=c+1;c=Math.floor((e+f)/2)}d.remove();return g},_calculateWidth:function(b,a){a.text(b);return a.width()},hideDropdown:function(b){var c=this,a=c.listUis[b];a&&a.list&&a.list.hide()},getDropdownList:function(d){var e=this,c=e.listUis[d],b={};c&&a.each(c.buttons,function(c,a){b[a.data("commandName")]=a.button("option","label")});return b},setButtonDisabled:function(b,h){var f=this.buttons[b],g=false,d,e;if(f&&f.button){d=f.button;g=d.is("button");d.button("option","disabled",h);if(g)b!=="save"&&d.children("."+c).text(b);else a("[for='"+d.attr("id")+"']",d.parent()).children("."+c).text(b);e=this.listUis[b];if(e&&e.type==="split"){e.trigger.button("option","disabled",h);e.trigger.children("."+c).text(b)}}},setButtonsDisabled:function(b){var c=this;a.each(b,function(b,a){c.setButtonDisabled(b,a)})},setButtonsChecked:function(c){var b=this;a.each(c,function(d,c){if(a.isPlainObject(c))b.setButtonChecked(d,c.checked,c.name);else b.setButtonChecked(d,c)})},setButtonChecked:function(h,i,l){var f=this,j,b=f.buttons[h],e,g,k;if(b&&b.button){e=b.button;if(e.is("button"))if(i)e.addClass(d);else e.removeClass(d);else{e.attr("checked",i);e.button("refresh")}if(b.parent){if(b.type==="dropdown")if(i){if(!f.dropdownLabels[h])f.dropdownLabels[h]=f._getDropdownLabelSubstr(e.button("option","label"),b.parent.children("."+c),b.parent.children("."+c).width());k=f.dropdownLabels[h];b.parent.button("option","label",k);b.parent.attr("title",e.button("option","label"));j=a(":radio",b.button.closest("ul"));j&&a.each(j,function(){f._updateGroupElementTextState(this)})}}else f._addActiveClassToButtonText(e.button("widget"))}else if(l){g=f.listUis[l];if(g){g.ui.button("option","label",g.defaultValue);g.buttons&&a.each(g.buttons,function(b,a){a.attr("checked",false);a.button("refresh");f._addActiveClassToButtonText(a.button("widget"))})}}}})})(jQuery);
(function(a){"use strict";var c=alert,j=window,zc=document,e=parseInt,wc,rc,Ed,Id=[],J=null,xc=true,Z=true,i=0,A=[],H=null,bc=null,C="setButtonDisabled",Jb="setButtonsDisabled",u="setButtonChecked",dd="setButtonsChecked",Kd="form",jd="imagebutton",wd="textarea",Fd="button",Cd="textbox",zd="list",ud="passwordfield",ed="dropdownlist",id="hiddenfield",Hd="radio",sd="checkbox",Nb="insertcol",ec="insertrow",Xb="insertcell",gc="splitcell",N="mergecell",Ob="deletecol",fc="deleterow",Zb="deletecell",fb="justifyleft",ab="justifycenter",bb="justifyright",eb="justifyfull",yd="borders",W="insertorderedlist",V="insertunorderedlist",Ad="outdent",Gd="indent",cc="backcolor",dc="fontcolor",rb="bold",lb="italic",ob="strikethrough",gb="underline",y="subscript",v="superscript",jc="template",Pb="removeformat",kd="insertbreak",Tc="insertparagraph",Oc="insertprintpagebreak",td="inserthorizontalrule",qc="tablebutton",Sb="inserttable",qd="edittable",Wb="wysiwyg",hc="split",ac="code",O="wordwrap",md="fullscreen",D="undo",I="redo",Bd="preview",lc="cleanup",yc="cut",sc="copy",pc="paste",rd="selectall",oc="media",Tb="specialchar",Jd="datetime",tc="find",mc="inspect",vc="save",vd="spelling",Mb="imagebrowser",uc="link",ib="xx-small",jb="x-small",qb="small",nb="medium",pb="large",mb="x-large",hb="xx-large",t="fontname",z="fontsize",ld="blockquote",Yb="insertcode",b="wijmo-wijribbon",Qc=b+"-bigbutton",ub=b+"-dropdownbutton",le=b+"-splitbutton",qf=b+"-list",sf=b+"-save",bf=b+"-save16",tf=b+"-undo",rf=b+"-redo",Te=b+"-preview",Pe=b+"-cleanup",Bf=b+"-cut",mf=b+"-copy",hf=b+"-paste",Be=b+"-selectall",Ne=b+"-bgcolor",ff=b+"-color",lf=b+"-bold",Ze=b+"-italic",De=b+"-underline",cf=b+"-strike",Cf=b+"-sub",Df=b+"-sup",Je=b+"-template",ae=b+"-removeformat",je=b+"-justifyleft",Td=b+"-justifycenter",Zd=b+"-justifyright",ie=b+"-justifyfull",Oe=b+"-borders",Ae=b+"-orderlist",me=b+"-unorderlist",Se=b+"-outdent",Ye=b+"-indent",Qe=b+"-inspect",nf=b+"-find",hd=b+"-table",Ic=b+"-inserttable",Rc=b+"-edittable",xe=b+"-insertcol",ye=b+"-insertrow",qe=b+"-insertcell",Ce=b+"-splitcell",ze=b+"-mergecell",ve=b+"-deletecol",we=b+"-deleterow",pe=b+"-deletecell",he=b+"-insertbreak",Pd=b+"-insertparagraph",Ld=b+"-insertprintpagebreak",He=b+"-inserthr",of=b+"-form",Ke=b+"-textarea",Ue=b+"-textbox",Ie=b+"-password",fe=b+"-hiddenfield",ge=b+"-imagebutton",Xe=b+"-button",Re=b+"-listbox",Xd=b+"-dropdownlist",jf=b+"-radio",Fe=b+"-checkbox",pf=b+"-link",af=b+"-link16",Yd=b+"-imagebrowser",gf=b+"-media",ke=b+"-specialchar",Ge=b+"-datetime",oe=b+"-blockquote",re=b+"-insertcode",gd=b+"-modes",Kc=b+"-designview",Mc=b+"-sourceview",Sc=b+"-splitview",Xc=b+"-wordwrap",Lc=b+"-fullscreen",d="wijmo-wijeditor",ue=d+"-container",bd=d+"-header",Zc=d+"-content",F=d+"-footer",Fc=d+"-pathselector",Jc=d+"-fullscreen",sb=d+"-dialog",If=sb+"-hr",w=sb+"-buttons",n=sb+"-button",g=sb+"-text",l=d+"-imagedlg",Le=l+"-content",Ve=l+"-fields",Qb=l+"-imagefield",kf=l+"-imagelist",Me=l+"-preview",db=l+"-imagesrc",nd=l+"-imagealt",X=l+"-imagewidth",T=l+"-imageheight",od=l+"-css",Ab=l+"-hideimagelist",f=d+"-templatedlg",Ff=f+"-toplabels",xf=f+"-topleftlabel",zf=f+"-toprightlabel",vf=f+"-content",Gf=f+"-templatelist",wf=f+"-preview",yf=f+"-templateinfo",Rb=f+"-nameinfo",Vb=f+"-descriptioninfo",Ef=f+"-fields",L=f+"-name",Y=f+"-description",uf=f+"-buttons",pd=f+"-delete",xd=f+"-save",h=d+"-linkdlg",K=h+"-address",Pc=h+"-linktype",Hb=h+"-anchor",G=h+"-text",S=h+"-target",Ub=h+"-css",M=h+"-src",U=h+"-width",R=h+"-height",tb=h+"-imagecontainer",Ec=h+"-linkicontype",Dd=d+"-codedlg",Yc=Dd+"-source",Wd=Dd+"-sourcelabel",s=d+"-taginsdlg",te=s+"-caption",ne=s+"-taglabel",Nc=s+"-tagtext",Sd=s+"-filterempty",se=s+"-attribs",Q=s+"-attriblist",zb=s+"-innerhtml",Lb=s+"-css",kc=d+"-colordlg",Eb=kc+"-picker",B=kc+"-color",p=d+"-tabledlg",Kb=p+"-rows",Cb=p+"-columns",Ib=p+"-width",Gb=p+"-height",Fb=p+"-border",xb=p+"-cellpadding",yb=p+"-cellspacing",Db=p+"-csstext",E=p+"-bgcolor",o=d+"-previewdlg",ee=o+"-caption",vb=o+"-navigator",Wc=o+"-prev",Vc=o+"-next",Gc=o+"-printall",Hc=o+"-printone",cd=o+"-ok",Ac=o+"-printdocument",Od=o+"-previewiframe",cb=d+"-cleanupdlg",de=cb+"-caption",Vd=cb+"-document",ce=cb+"-actions",nc=d+"-finddlg",ef=nc+"-find",Ee=nc+"-replace",P=d+"-mediadlg",We=P+"-type",fd=P+"-src",ad=P+"-width",Uc=P+"-height",r=d+"-specialchardlg",Ud=r+"-chars",Qd=r+"-preview",Bc=r+"-content",be=r+"-list",wb=r+"_label",Md=r+"-punctuation",Rd=r+"-symbols",Nd=r+"-diacritics",x="wijmo-formatspan",k="."+w+" input:first",q="."+w+" input:last",df="."+w+" input[value='OK']",Bb="."+w+" input[value='Cancel']",Af=["Bold","Italic","UnderLine","StrikeThrough","SubScript","SuperScript","JustifyLeft","JustifyCenter","JustifyRight","JustifyFull","Border","NumberedList","BulletedList","Outdent","Indent"],Dc=["Bold","Italic","Link","BlockQuote","StrikeThrough","InsertDate","InsertImage","NumberedList","BulletedList","InsertCode"],Cc=["Bold","Italic","StrikeThrough","UnderLine","ForeColor","FontSize","Link","InsertImage","NumberedList","BulletedList","BlockQuote"],m={Form:{name:"form",tip:"Form",css:of},Image:{name:"imagebutton",tip:"Image Button",css:ge},TextArea:{name:"textarea",tip:"TextArea",css:Ke},Button:{name:"button",tip:"Button",css:Xe},TextBox:{name:"textbox",tip:"TextBox",css:Ue},List:{name:"list",tip:"ListBox",css:Re},PasswordField:{name:"passwordfield",tip:"Password Field",css:Ie},DropDownList:{name:"dropdownlist",tip:"DropDownList",css:Xd},HiddenField:{name:"hiddenfield",tip:"Hidden Field",css:fe},Radio:{name:"radio",tip:"RadioButton",css:jf},CheckBox:{name:"checkbox",tip:"CheckBox",css:Fe},InsertColumn:{name:"insertcol",tip:"Insert Column",css:xe},InsertRow:{name:"insertrow",tip:"Insert Row",css:ye},InsertCell:{name:"insertcell",tip:"Insert Cell",css:qe},SplitCell:{name:"splitcell",tip:"Split Cell",css:Ce},MergeCell:{name:"mergecell",tip:"Merge Cell",css:ze},DeleteColumn:{name:"deletecol",tip:"Delete Column",css:ve},DeleteRow:{name:"deleterow",tip:"Delete Row",css:we},DeleteCell:{name:"deletecell",tip:"Delete Cell",css:pe},JustifyLeft:{name:"justifyleft",tip:"Justify Left",css:je,grpname:"alignment"},JustifyCenter:{name:"justifycenter",tip:"Justify Center",css:Td,grpname:"alignment"},JustifyRight:{name:"justifyright",tip:"Justify Right",css:Zd,grpname:"alignment"},JustifyFull:{name:"justifyfull",tip:"Justify Full",css:ie,grpname:"alignment"},Border:{name:"borders",tip:"Border",css:Oe},NumberedList:{name:"insertorderedlist",tip:"Numbered List",css:Ae,grpname:"list"},BulletedList:{name:"insertunorderedlist",tip:"Bulleted List",css:me,grpname:"list"},Outdent:{name:"outdent",tip:"Outdent",css:Se,grpname:"block"},Indent:{name:"indent",tip:"Indent",css:Ye,grpname:"block"},BackColor:{name:"backcolor",tip:"Background Color",css:Ne},ForeColor:{name:"fontcolor",tip:"Font Color",css:ff},Bold:{name:"bold",tip:"Bold",css:lf},Italic:{name:"italic",tip:"Italic",css:Ze},StrikeThrough:{name:"strikethrough",tip:"Strikethrough",css:cf},UnderLine:{name:"underline",tip:"Underline",css:De},SubScript:{name:"subscript",tip:"Subscript",css:Cf},SuperScript:{name:"superscript",tip:"Superscript",css:Df},Template:{name:"template",tip:"Template",css:Je},RemoveFormat:{name:"removeformat",tip:"RemoveFormat",css:ae},InsertBreak:{name:"insertbreak",tip:"Insert Break",css:he},InsertParagraph:{name:"insertparagraph",tip:"Insert Paragraph",css:Pd},InsertPrint:{name:"insertprintpagebreak",tip:"Insert Print Page Break",css:Ld},InsertHR:{name:"inserthorizontalrule",tip:"Insert Horizontal Line",css:He},Table:{name:"tablebutton",tip:"Table",css:hd},InsertTable:{name:"inserttable",tip:"Insert Table",css:Ic},EditTable:{name:"edittable",tip:"Edit Table",css:Rc},Wysiwyg:{name:"wysiwyg",tip:"Design View",css:Kc,grpname:"modes"},Split:{name:"split",tip:"Split View",css:Sc,grpname:"modes"},Code:{name:"code",tip:"Source View",css:Mc,grpname:"modes"},Wordwrap:{name:"wordwrap",tip:"Wordwrap",css:Xc},FullScreen:{name:"fullscreen",tip:"Fullscreen",css:Lc},Undo:{name:"undo",tip:"Undo",css:tf},Redo:{name:"redo",tip:"Redo",css:rf},Preview:{name:"preview",tip:"Preview",css:Te},Cleanup:{name:"cleanup",tip:"Clean up",css:Pe},Cut:{name:"cut",tip:"Cut",css:Bf},Copy:{name:"copy",tip:"Copy",css:mf},Paste:{name:"paste",tip:"Paste",css:hf},SelectAll:{name:"selectall",tip:"Select All",css:Be},Media:{name:"media",tip:"Media",css:gf},InsertSpecialChar:{name:"specialchar",tip:"Insert Special Character",css:ke},InsertDate:{name:"datetime",tip:"Insert Date Time",css:Ge},Find:{name:"find",tip:"Find And Replace",css:nf,text:"Find"},Inspect:{name:"inspect",tip:"Tag Inspect",css:Qe,text:"Inspect"},Save:{name:"save",tip:"Form",css:sf,text:"Save"},Spelling:{name:"spelling",tip:"Form",css:""},InsertImage:{name:"imagebrowser",tip:"Image Browser",css:Yd},Link:{name:"link",tip:"Link",css:pf,text:"Link"},FontName:{name:"fontname",tip:"Font Name",css:ub},FontSize:{name:"fontsize",tip:"Font Size",css:ub},BlockQuote:{name:"blockquote",tip:"Block Quote",css:oe},InsertCode:{name:"insertcode",tip:"Insert Code",css:re}},ic=function(){var a=this,b=[];a.append=function(a){b.push(a)};a.toString=function(){return b.join("")};a.dispose=function(){b=null}},Hf=function(a){this.text=a;this.render=function(){return this.text}},kb=function(f,c,d){var b=this,e={br:true,img:true,hr:true,input:true};b.tagName=f||"div";b.attributes=d||{};b.innerText=c||"";b.children=[];if(a.isPlainObject(c)){b.innerText="";b.attributes=c}b._isShortTag=false;if(e[b.tagName]===true)b._isShortTag=true;b.render=function(){var c=new ic,d="";c.append(b._renderBeginTag(b.tagName,b.attributes));b.innerText!==""&&c.append(b.innerText);b.children.length>0&&a.each(b.children,function(b,a){c.append(a.render())});c.append(b._renderEndTag(b.tagName));d=c.toString();c.dispose();return d};b.add=function(a){this.children.push(a)};b._renderBeginTag=function(e,d){var b=new ic,c="";b.append("<");b.append(e);a.each(d,function(c,a){b.append(" ");b.append(c);b.append("=");b.append('"');b.append(a.toString());b.append('"')});if(this._isShortTag)b.append(" ");else b.append(">");c=b.toString();b.dispose();return c};b._renderEndTag=function(c){var a=new ic,b="";if(this._isShortTag)a.append("/>");else{a.append("</");a.append(c);a.append(">")}b=a.toString();a.dispose();return b}};a.widget("wijmo.wijeditor",{options:{fullScreenContainerSelector:"",editorMode:"wysiwyg",fullScreenMode:false,showPathSelector:true,mode:"ribbon",commandButtonClick:null,simpleModeCommands:null,showFooter:true,customContextMenu:true,text:null,textChanged:null,localization:null},_create:function(){var b=this;if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);if(b.element.is("input"))return;b.id_prefix="wijeditor-"+b.element.attr("id")+"-";b.$ribbon=undefined;b.$modes=undefined;b._editorify();b._initElements();j.setTimeout(function(){b.options.disabled&&b._handleDisabledOption(true,b.editor)},40);b._continueSavingInputTextForUndo=false;b.element.is(":hidden")&&b.element.wijAddVisibilityObserver&&b.element.wijAddVisibilityObserver(function(){b.refresh();b.element.wijRemoveVisibilityObserver&&b.element.wijRemoveVisibilityObserver()},"wijeditor")},_createBigButton:function(f,e,c,d){var b=this,a=b._createElement("button",{title:f,name:c,"class":Qc});a.add(b._createDiv(e));a.add(b._createSpan("",d));return a},_createTextButton:function(c,a,b){return this._createElement("button",b,{title:c,name:a})},_createButton:function(f,e,c,d){var b=this,a;if(!d)return b._createElement("button",{title:f,name:c,"class":e});a=b._createElement("button",{title:f,name:c});a.add(b._createSpan(e));a.add(b._createSpan("",d));return a},_createTextRadioButton:function(g,c,b,e,f){var d=this,a=[];a.push(d._createElement("input",{id:c+b,type:"radio",name:e}));a.push(d._createElement("label",f,{"for":c+b,title:g,name:b}));return a},_createImageRadioButton:function(g,c,f,b,e){var d=this,a=[];a.push(d._createElement("input",{id:c+b,type:"radio",name:e}));a.push(d._createElement("label",{"for":c+b,title:g,name:b,"class":f}));return a},_createImageCheckButton:function(f,c,e,b){var d=this,a=[];a.push(d._createElement("input",{id:c+b,type:"checkbox"}));a.push(d._createElement("label",{"for":c+b,title:f,name:b,"class":e}));return a},_createRibbonList:function(){return this._createSpan(qf)},_createDropdownButton:function(f,e,i,h,g){var b=this,c=b._createElement("div",{title:f,"class":ub}),d=b._createElement("ul");c.add(b._createTextButton(f,e,i));c.add(d);a.each(h,function(i,c){var f=b._createElement("li"),h=b._createTextRadioButton(c.tip,g,c.name,e,c.text);a.each(h,function(b,a){f.add(a)});d.add(f)});return c},_createSplitButton:function(e,i,g,h,f){var b=this,c=b._createElement("div",{title:e,"class":le}),d=b._createElement("ul");c.add(b._createBigButton(e,i,g,h));c.add(b._createElement("button",{"class":Qc}));c.add(d);a.each(f,function(e,a){var c=b._createElement("li");c.add(b._createButton(a.tip,a.css,a.name,a.text));d.add(c)});return c},_createButtonByCommand:function(e){var b=this,c,a=m[e],d;if(!a)return;d=a.name;switch(d){case ld:case Kd:case jd:case wd:case Fd:case Cd:case zd:case ud:case ed:case id:case Hd:case sd:case Nb:case ec:case Xb:case gc:case N:case Ob:case fc:case Zb:case Pb:case kd:case Tc:case Oc:case md:case D:case I:case yc:case sc:case pc:case Jd:case O:case cc:case dc:case Bd:case lc:case oc:case Tb:case jc:case Mb:case Yb:case td:case rd:c=b._createButton(a.tip,a.css,d);break;case tc:case mc:c=b._createButton(a.tip,a.css,d,a.text);break;case yd:case y:case v:case rb:case lb:case gb:case ob:c=b._createImageCheckButton(a.tip,b.id_prefix,a.css,d);break;case Wb:case hc:case ac:case fb:case ab:case bb:case eb:case Ad:case Gd:case W:case V:c=b._createImageRadioButton(a.tip,b.id_prefix,a.css,d,a.grpname);break;case qc:c=b._createSplitButton("Table",hd,qc,"Table",[{tip:"Insert Table",css:Ic,name:Sb,text:"Insert"},{tip:"Edit Table",css:Rc,name:qd,text:"Edit"}]);break;case vc:if(b.options.mode==="ribbon")c=b._createBigButton(a.tip,a.css,d,a.text);else c=b._createButton(a.tip,bf,d);break;case uc:if(b.options.mode==="ribbon")c=b._createBigButton(a.tip,a.css,d,a.text);else c=b._createButton(a.tip,af,d);break;case t:c=b._createDropdownButton("Font Name",t,"Font Name",[{tip:"Arial",name:"fn1",text:"Arial"},{tip:"Courier New",name:"fn2",text:"Courier New"},{tip:"Garamond",name:"fn3",text:"Garamond"},{tip:"Tahoma",name:"fn4",text:"Tahoma"},{tip:"Times New Roman",name:"fn5",text:"Times New Roman"},{tip:"Verdana",name:"fn6",text:"Verdana"},{tip:"Wingdings",name:"fn7",text:"Wingdings"}],b.id_prefix);break;case z:c=b._createDropdownButton("Font Size",z,"Font Size",[{tip:"VerySmall",name:"xx-small",text:"VerySmall"},{tip:"Smaller",name:"x-small",text:"Smaller"},{tip:"Small",name:"small",text:"Small"},{tip:"Medium",name:"medium",text:"Medium"},{tip:"Large",name:"large",text:"Large"},{tip:"Larger",name:"x-large",text:"Larger"},{tip:"VeryLarge",name:"xx-large",text:"VeryLarge"}],b.id_prefix)}return c},_createActionGroup:function(){var a=this,c=a._createElement("li"),b=a._createRibbonList();c.add(a._createButtonByCommand("Save"));c.add(b);b.add(a._createButtonByCommand("Undo"));b.add(a._createButtonByCommand("Redo"));b=a._createRibbonList();c.add(b);b.add(a._createButtonByCommand("Preview"));b.add(a._createButtonByCommand("Cleanup"));b=a._createRibbonList();c.add(b);b.add(a._createButtonByCommand("Cut"));b.add(a._createButtonByCommand("Copy"));b.add(a._createButtonByCommand("Paste"));b.add(a._createButtonByCommand("SelectAll"));c.add(a._createElement("div","Actions"));return c},_createFontGroup:function(){var b=this,d=b._createElement("li"),c=b._createRibbonList();d.add(b._createButtonByCommand("FontName"));d.add(b._createButtonByCommand("FontSize"));d.add(c);c.add(b._createButtonByCommand("BackColor"));c.add(b._createButtonByCommand("ForeColor"));c=b._createRibbonList();d.add(c);a.each(b._createButtonByCommand("Bold"),function(b,a){c.add(a)});a.each(b._createButtonByCommand("Italic"),function(b,a){c.add(a)});a.each(b._createButtonByCommand("UnderLine"),function(b,a){c.add(a)});a.each(b._createButtonByCommand("StrikeThrough"),function(b,a){c.add(a)});a.each(b._createButtonByCommand("SubScript"),function(b,a){c.add(a)});a.each(b._createButtonByCommand("SuperScript"),function(b,a){c.add(a)});c=b._createRibbonList();d.add(c);c.add(b._createButtonByCommand("Template"));c=b._createRibbonList();d.add(c);c.add(b._createButtonByCommand("RemoveFormat"));d.add(b._createElement("div","Font"));return d},_createParaGroup:function(){var c=this,d=c._createElement("li"),b=c._createRibbonList();d.add(b);a.each(c._createButtonByCommand("JustifyLeft"),function(c,a){b.add(a)});a.each(c._createButtonByCommand("JustifyCenter"),function(c,a){b.add(a)});a.each(c._createButtonByCommand("JustifyRight"),function(c,a){b.add(a)});a.each(c._createButtonByCommand("JustifyFull"),function(c,a){b.add(a)});b=c._createRibbonList();d.add(b);a.each(c._createButtonByCommand("Border"),function(c,a){b.add(a)});b=c._createRibbonList();d.add(b);a.each(c._createButtonByCommand("NumberedList"),function(c,a){b.add(a)});a.each(c._createButtonByCommand("BulletedList"),function(c,a){b.add(a)});b=c._createRibbonList();d.add(b);a.each(c._createButtonByCommand("Outdent"),function(c,a){b.add(a)});a.each(c._createButtonByCommand("Indent"),function(c,a){b.add(a)});d.add(c._createElement("div","Paragraph"));return d},_createReviewGroup:function(){var b=this,a=b._createElement("li");a.add(b._createButtonByCommand("Inspect"));a.add(b._createButtonByCommand("Find"));a.add(b._createElement("div","Review"));return a},_createTablesGroup:function(){var a=this,c=a._createElement("li"),b=a._createRibbonList();c.add(a._createButtonByCommand("Table"));c.add(b);b.add(a._createButtonByCommand("InsertColumn"));b.add(a._createButtonByCommand("InsertRow"));b.add(a._createButtonByCommand("InsertCell"));b=a._createRibbonList();c.add(b);b.add(a._createButtonByCommand("SplitCell"));b.add(a._createButtonByCommand("MergeCell"));b=a._createRibbonList();c.add(b);b.add(a._createButtonByCommand("DeleteColumn"));b.add(a._createButtonByCommand("DeleteRow"));b.add(a._createButtonByCommand("DeleteCell"));c.add(a._createElement("div","Tables"));return c},_createBreaksGroup:function(){var b=this,a=b._createElement("li");a.add(b._createButtonByCommand("InsertBreak"));a.add(b._createButtonByCommand("InsertParagraph"));a.add(b._createButtonByCommand("InsertPrint"));a.add(b._createButtonByCommand("InsertHR"));a.add(b._createElement("div","Breaks"));return a},_createFormsGroup:function(){var b=this,c=b._createElement("li"),a=b._createRibbonList();c.add(a);a.add(b._createButtonByCommand("Form"));a=b._createRibbonList();c.add(a);a.add(b._createButtonByCommand("TextArea"));a.add(b._createButtonByCommand("TextBox"));a.add(b._createButtonByCommand("PasswordField"));a.add(b._createButtonByCommand("HiddenField"));a=b._createRibbonList();c.add(a);a.add(b._createButtonByCommand("Image"));a.add(b._createButtonByCommand("Button"));a=b._createRibbonList();c.add(a);a.add(b._createButtonByCommand("List"));a.add(b._createButtonByCommand("DropDownList"));a.add(b._createButtonByCommand("Radio"));a.add(b._createButtonByCommand("CheckBox"));c.add(b._createElement("div","Forms"));return c},_createSpecialGroup:function(){var b=this,a=b._createElement("li");a.add(b._createButtonByCommand("Link"));a.add(b._createButtonByCommand("InsertImage"));a.add(b._createButtonByCommand("Media"));a.add(b._createButtonByCommand("InsertSpecialChar"));a.add(b._createButtonByCommand("InsertDate"));a.add(b._createElement("div","Special"));return a},_getDefaultRibbonMarkup:function(){var a=this,d=a._createElement("div"),e=a._createElement("ul"),g=a._createElement("li"),i=a._createElement("li"),f=a._createElement("div",{id:a.id_prefix+"format"}),h=a._createElement("div",{id:a.id_prefix+"insert"}),b=a._createElement("ul"),c=a._createElement("ul");d.add(e);d.add(f);d.add(h);e.add(g);e.add(i);g.add(a._createElement("a","Format",{href:"#"+a.id_prefix+"format"}));i.add(a._createElement("a","Insert",{href:"#"+a.id_prefix+"insert"}));f.add(b);b.add(a._createActionGroup());b.add(a._createFontGroup());b.add(a._createParaGroup());b.add(a._createReviewGroup());h.add(c);c.add(a._createTablesGroup());c.add(a._createBreaksGroup());c.add(a._createFormsGroup());c.add(a._createSpecialGroup());return d.render()},_getRibbonModesMarkup:function(){var b=this,f=b._createDiv(gd),e=b._createRibbonList(),c=b.element.find(".wijeditor-footer"),d,g,h,j,i;if(c.length>0){d=a(c.find("."+Kc));if(d.length>0)m.Wysiwyg.tip=d.attr("title")||m.Wysiwyg.tip;g=a(c.find("."+Sc));if(g.length>0)m.Split.tip=g.attr("title")||m.Split.tip;h=a(c.find("."+Mc));if(h.length>0)m.Code.tip=h.attr("title")||m.Code.tip;j=a(c.find("."+Xc));if(d.length>0)m.Wordwrap.tip=j.attr("title")||m.Wordwrap.tip;i=a(c.find("."+Lc));if(d.length>0)m.FullScreen.tip=i.attr("title")||m.FullScreen.tip;c.remove()}f.add(e);a.each(b._createButtonByCommand("Wysiwyg"),function(b,a){e.add(a)});a.each(b._createButtonByCommand("Code"),function(b,a){e.add(a)});a.each(b._createButtonByCommand("Split"),function(b,a){e.add(a)});f.add(b._createButtonByCommand("Wordwrap"));f.add(b._createButtonByCommand("FullScreen"));return f.render()},_getSimpleToolBar:function(e){var d=this,b,c=d._createDiv("");a.each(e,function(f,e){b=d._createButtonByCommand(e);if(b)if(a.inArray(e,Af)!==-1)a.each(b,function(b,a){c.add(a)});else c.add(b)});return c.render()},_editorify:function(){var b=this,e=b.element,o=e.width(),n=e.height(),c=b.options,m=c.mode,g,i,l,j,h,f,k;b._oriStyle=e.attr("style");b._oriContent=e.html();if(e.is("textarea")){if(m==="ribbon")b.$ribbon=a(b._getDefaultRibbonMarkup());else if(m==="bbcode")b.$ribbon=a(b._getSimpleToolBar(Cc));else if(c.simpleModeCommands&&c.simpleModeCommands.length!==0){l=a.grep(c.simpleModeCommands,function(a){return a!=="Table"});b.$ribbon=a(b._getSimpleToolBar(l))}else b.$ribbon=a(b._getSimpleToolBar(Dc));c.text&&e.val(c.text);b.sourceView=e;b.editor=e.wrap("<div></div>").parent();b.editor.width(o).height(n)}else{b.editor=e;b.$ribbon=e.children(":eq(0)");f=e.children(":eq(1)");if(f.is("textarea")){c.text&&f.val(c.text);b.sourceView=f}else{if(c.text)k=c.text;else k=f.html();f.remove();b.sourceView=a("<textarea></textarea>").val(k)}}g=a("<div class='"+ue+"'></div>");b.dialog=a("<div class ='"+d+"'></div>");b.subDialog=a("<div class ='"+d+"'></div>");b.editor.addClass(d).append(g).append(b.dialog).append(b.subDialog);b._createMenuMarkUp(b,c);b.$ribbon.wrap("<a href='#'></a>").parent().appendTo("<div class='"+bd+" ui-widget-header ui-helper-clearfix ui-corner-top'></div>").parent().appendTo(g);i=a("<div class='"+Zc+"'></div>").appendTo(g);b.designView=a("<iframe frameborder='0'></iframe>");b.designView.wrap("<div></div>").parent().appendTo(i);b.sourceView.wrap("<div></div>").parent().appendTo(i);j=[b.$ribbon];b.$modes=a(b._getRibbonModesMarkup());if(c.showFooter){h=a("<div class='"+F+" ui-widget ui-widget-content ui-state-default'></div>");g.append(h);h.append("<div class='"+Fc+"'></div>");b.$modes.appendTo(h);j.push(b.$modes)}a.each(j,function(c,a){a.wijribbon({click:function(c,a){b._ribbonCommand(a.commandName,a.name);b._trigger("commandButtonClick",c,a)}})})},_createMenuMarkUp:function(b,c){if(c.customContextMenu&&!a.browser.webkit){b.contextMenu=a("<ul><li _c1buttoncmd='cut'><a>"+this.localizeString("contextMenuCut","Cut")+"</a></li><li _c1buttoncmd='copy'><a>"+this.localizeString("contextMenuCopy","Copy")+"</a></li><li _c1buttoncmd='paste'><a>"+this.localizeString("contextMenuPaste","Paste")+"</a></li></ul>");a("<a href='#'></a>").append(b.contextMenu).appendTo(b.editor)}},_handleDisabledOption:function(b,c){var a=this;if(b){if(!a.disabledDiv)a.disabledDiv=a._createDisabledDiv(c);a.disabledDiv.appendTo("body")}else if(a.disabledDiv){a.disabledDiv.remove();a.disabledDiv=null}},_createDisabledDiv:function(d){var g=this,b=d?d:g.element,c=b.offset(),f=b.outerWidth(),e=b.outerHeight();return a("<div></div>").addClass("ui-state-disabled").css({"z-index":"99999",position:"absolute","background-color":"lightgray",width:f,height:e,left:c.left,top:c.top})},_initElements:function(){var a=this,b=a.options,d=a.element.height()-a._getHeader().outerHeight(true)-a._getFooter().outerHeight(true),c={};a._getContent().height(d).wijsplitter({showExpander:false,orientation:"horizontal",panel1:{scrollBars:"none",collapsed:false},panel2:{scrollBars:"none",collapsed:true}});a._addHandlerToDesignView();a._addDefaultFontStyleToDesignView();a._createWijMenu();(!b.showPathSelector||a.options.mode==="bbcode")&&a._getPathSelector().hide();a._ribbonCommand(b.editorMode);b.fullScreenMode&&a._setFullScreen(b.fullScreenMode);c[I]=true;c[D]=true;a.$ribbon.wijribbon(Jb,c)},_setOption:function(d,c){var b=this,e=b.options,h=e.mode,g=b.$ribbon.parent(),f=e.customContextMenu;a.Widget.prototype._setOption.apply(b,arguments);if(d==="fullScreenMode"){e.fullScreenMode=c;b._setFullScreen(c)}else if(d==="showPathSelector"){e.showPathSelector=c;if(c)b._getPathSelector().show();else b._getPathSelector().hide()}else if(d==="editorMode"){e.editorMode=c;b._ribbonCommand(c)}else if(d==="fullScreenContainerSelector"){e.fullScreenContainerSelector=c;b.options.fullScreenMode&&b._setFullScreen(true)}else if(d==="disabled")b._handleDisabledOption(c,b.editor);else if(d==="showFooter")if(c)!a("."+F).is(":visible")&&a("."+F).show();else a("."+F).is(":visible")&&a("."+F).hide();else if(d==="commandButtonClick")e.commandButtonClick=c;else if(d==="text"){e.text=c;b.setText(c)}else if(d==="customContextMenu"){if(f===c)return;if(c){!b.contextMenu&&b._createMenuMarkUp(b,e);b._createWijMenu()}else{b.contextMenu.wijmenu("destroy").remove();b.contextMenu=undefined}}else if(d==="mode"&&c!==h){b.$ribbon.wijribbon("destroy");b.$ribbon.remove();if(c==="ribbon")b.$ribbon=a(b._getDefaultRibbonMarkup());else if(c==="bbcode")b.$ribbon=a(b._getSimpleToolBar(Cc));else b.$ribbon=a(b._getSimpleToolBar(Dc));g.append(b.$ribbon);b.$ribbon.wijribbon({click:function(c,a){b._ribbonCommand(a.commandName,a.name);b._trigger("commandButtonClick",c,a)}})}},_getHeader:function(){return a("."+bd,this.editor)},_getContent:function(){return a("."+Zc,this.editor)},_getFooter:function(){return a("."+F,this.editor)},_getPathSelector:function(){return a("."+Fc,this.editor)},_getModes:function(){return a("."+gd,this.editor)},_getDesignView:function(){return this.designView},_getDesignViewWindow:function(){var a=this.designView;return a&&a.length>0?a[0].contentWindow:null},_getDesignViewDocument:function(){var a=this._getDesignViewWindow();return a?a.document:null},_getDesignViewText:function(){var a=this._getDesignViewDocument();return a&&a.body&&a.body.innerHTML?a.body.innerHTML:""},_setDesignViewText:function(a){var c=this,b=this._getDesignViewDocument();if(this.options.mode==="bbcode")a=c._convertBBCodeToHtml(a);if(b&&b.body)b.body.innerHTML=a;c.options.text=a},_getDialog:function(){return this.dialog},_getSubDialog:function(){return this.subDialog},_initContentDocument:function(){var b=this,c=b.sourceView.val(),d=b._getDesignViewDocument();if(b.options.mode==="bbcode")c=b._convertBBCodeToHtml(a.trim(c));d.open();d.write('<html style="width:100%;height:100%;'+(b.options.enabled?"cursor:text;":"")+'"><head><title></title><style id="__wijStyle"  type="text/css" >table,td,tr{border: 1px #acacac dashed;}</style></head><body>'+c+"</body></html>");d.close();A=[];A.push(c);i=0},_addHandlerToDesignView:function(){var b=this,d=b._getDesignViewWindow(),c=d.document;b._initContentDocument();if(a.browser.mozilla)setTimeout(b._setDesignModeForFF,1e3,b);else b._setContentEditable(c,true);b.sourceView.bind("blur."+b.widgetName,function(){b._onSourceViewBlur()});b.sourceView.bind("keyup."+b.widgetName,function(){b._onSourceViewBlur()});if(!a.browser.mozilla)a(d).blur(function(a){b._onDesignViewBlur(a)});else a(c).bind("blur."+b.widgetName,function(a){b._onDesignViewBlur(a)});a(c).bind("mouseup."+b.widgetName,function(a){b._onDesignViewMouseUp(a)}).bind("keydown."+b.widgetName,function(a){b._onDesignViewKeyDown(a)}).bind("keyup."+b.widgetName,function(a){b._onDesignViewKeyUp(a);b._onDesignViewBlur(a)})},_addDefaultFontStyleToDesignView:function(){var e=this,f=e.options,g=e._getDesignViewDocument(),b=f.defaultFontName,d=f.defaultFontSize,c='<style type="text/css"> body {';if((b===""||b===null)&&(d===""||d===null))return;if(b!==""&&b!==null)c+="font-family: "+b+";";if(f.defaultFontSize!==""&&f.defaultFontSize!==null)c+=" font-size: "+d+";";c+="}</style>";window.setTimeout(function(){a(c).appendTo(a("head",g))},200);e._setFontStyleButtonState(b,t);e._setFontStyleButtonState(d,z)},_setFontStyleButtonState:function(b,d){var c="";if(!b||b===null)return;a.each(this.$ribbon.wijribbon("getDropdownList",d),function(d,a){if(a.toUpperCase()===b.toUpperCase()){c=d;return false}});this.$ribbon.wijribbon(u,c,true,d)},_setDesignModeForFF:function(a){a._getDesignViewDocument().designMode="on"},destroy:function(){var b=this;b.element.html(b._oriContent);b.element.removeAttr("tabindex");if(b._oriStyle===undefined)b.element.removeAttr("style");else b.element.attr("style",b._oriStyle);b.element.insertBefore(b.editor);b.element.unbind("."+b.widgetName);b.editor.remove();a.Widget.prototype.destroy.call(b)},showEditorDialog:function(a){switch(a){case Sb:case jc:case Mb:case mc:case tc:case Tb:case oc:case lc:case uc:case cc:case dc:case Yb:this._ribbonCommand(a);break;default:c("Cannot find the dialog with command name '"+a+"'!")}},executeEditorAction:function(b,a){this._ribbonCommand(b,a)},_isFontSizeCustomized:function(){if(J!==null)return J;var b=this.$ribbon.wijribbon("getDropdownList",z),c=[ib,jb,qb,nb,pb,mb,hb];J=false;a.each(b,function(b){if(a.inArray(b,c)===-1){J=true;return false}});return J},_fontSizeCommand:function(e){var c=this,d=c._getDesignViewDocument(),b=4,f="font-size",g=[];switch(e){case ib:b=1;break;case jb:b=2;break;case qb:b=3;break;case nb:b=4;break;case pb:b=5;break;case mb:b=6;break;case hb:b=7}if(!c._isFontSizeCustomized())d.execCommand("FontSize",false,b);else if(a.browser.msie)c._formatFontSpan(d,f,e);else{d.execCommand("FontSize",false,b);a.each(a("font[size]",d),function(d,b){g.push(c._replaceFontWithSpan(a(b),"size",f,e))});c._setSelection(g)}c.options.mode==="bbcode"&&!a.browser.msie&&c._convertFontStyleToStandTag();c._addtoUndoBuffer()},_fontNameCommand:function(f){var b=this,d=b._getDesignViewDocument(),e=b.$ribbon.wijribbon("getDropdownList",t),c;a.each(e,function(b,a){if(f===b){c=a;return false}});d.execCommand("FontName",false,c);b._isFontSizeCustomized()&&a.browser.msie&&b._formatFontSpan(d,"font-family",c);b._addtoUndoBuffer()},_formatFontSpan:function(h,b,f){var c=this,e=f,d="fontFamily",g=[];if(b!=="font-family"){e="c1-temp";d="fontSize"}h.execCommand("FontName",false,e);a.each(a("font[face='"+e+"']",h),function(k,j){var i=c._replaceFontWithSpan(a(j),"face",b,f),h,e;g.push(i);h=a("span."+x,i);for(e=h.length-1;e>=0;e--)c._removeSpecifiedStyleSpan(a(h[e]),d,b);a.each(i,function(f,e){a.each(a(e).parents("span."+x),function(h,g){var f=a(g);if(f.children().length>1)return false;f.text()===a(e).text()&&c._removeSpecifiedStyleSpan(f,d,b)})})});c._setSelection(g)},_setSelection:function(c,k,j){var i=this._getDesignViewWindow(),g=i.document,b,f,e,d,h=0;try{if(a.browser.msie){b=g.selection.createRange();if(c){a.each(c,function(b,a){h+=a.text().length});b.moveToElementText(c[0][0]);b.collapse(true);b.moveEnd("character",h)}else{b.moveStart("textedit",-1);b.collapse(true);b.moveStart("character",k);b.moveEnd("character",j)}b.select()}else{d=i.getSelection();b=g.createRange();f=c[0][0];e=c[c.length-1][0];b.setStart(f,0);b.setEnd(e,e.childNodes.length);d.removeAllRanges();d.addRange(b)}}catch(l){}},_replaceFontWithSpan:function(a,c,e,d){a.wrap("<span class = '"+x+"' style='"+e+":"+d+"'></span>");var b=a.parent();a.removeAttr(c);if(/<font\s*>/ig.test(b.html())){b.html(a.html());a.remove()}return b},_removeSpecifiedStyleSpan:function(b,f,e){var c,d=true;b[0].style[f]!==""&&b.css(e,"");c=b.attr("style");c&&a.each(c.split(";"),function(f,c){var b=a.trim(c).toLowerCase();if(b!==""&&b.indexOf(e)!==-1){d=false;return false}});d&&b.replaceWith(b.html())},_removeFormat:function(){var c=this,d=c._getDesignViewDocument(),b={};d.execCommand(Pb,false,null);c._isFontSizeCustomized()&&a.browser.msie&&c._removeFormatForIE(d);c._addtoUndoBuffer();b[rb]=false;b[lb]=false;b[ob]=false;b[gb]=false;b[y]=false;b[v]=false;b[W]=false;b[V]=false;b[fb]=false;b[ab]=false;b[bb]=false;b[eb]=false;c.$ribbon.wijribbon(dd,b)},_removeFormatForIE:function(g){var i=g.selection.createRange(),k=i.htmlText,s=i.text,p=0,r=a(i.parentElement()),m=a(g.body),o="",l="",h="__c1temp",j="c1-temp",q="<span class='"+j+"'>"+h+"</span>",b,f,e,d,c,n;r.addClass("c1-app-parent");i.pasteHTML(q);p=m.text().indexOf(h);b=a("span."+j,g);f=b;b.parentsUntil("body").each(function(){if(a(this).is(".c1-app-parent"))return false;f=a(this)});b.html(k);e=a("span."+x,b);for(c=e.length-1;c>=0;c--){d=a(e[c]);d.replaceWith(d.html())}!f.is("."+j)&&f.after(b);a.each(f.parents("span."+x),function(c,b){o+="</span>";l="<span class='"+x+"' style = '"+a(b).attr("style")+"'>"+l});k=b.html();b.replaceWith(h);n=m.html().split(h);m.html(n[0]+o+k+l+n[1]);e=a("span."+x,g);for(c=e.length-1;c>=0;c--){d=a(e[c]);d.text()===""&&d.replaceWith(d.html())}a(".c1-app-parent",g).removeClass("c1-app-parent");this._setSelection(null,p,s.length)},_toggleFullScreen:function(){var b=this,a=b.options;a.fullScreenMode=!a.fullScreenMode;b._setFullScreen(a.fullScreenMode)},_setFullScreen:function(k){var b=this,l=1,o=b._getHeader(),n=b._getFooter(),m=b._getContent(),d=b.options.fullScreenContainerSelector,c=a(d),i=b._getDesignViewText(),g,f,h;if(k){if(c.length===0){c=a(j);d="body";b._oriDocOverFlow=a(document.documentElement).css("overflow");a(document.documentElement).css({overflow:"hidden"});!a.browser.mozilla&&window.scrollTo(0,0);a(j).bind("resize.wijeditor",function(){b._fullscreenOnWindowResize()})}g=c.width();f=c.height()-2*l;wc=b.editor.width();rc=b.editor.height();if(!Ed)Ed=b.editor.parent();if(!b._replacedDiv)b._replacedDiv=a("<div />");b.editor.after(b._replacedDiv);a(d).append(b.editor);b.editor.css({width:g,height:f,position:""}).addClass(Jc);b.sourceView.css({width:g,height:f});b.$ribbon.wijribbon("updateRibbonSize")}else{b._replacedDiv.after(b.editor).remove();b.editor.css({width:wc,height:rc,position:"static"}).removeClass(Jc);b.sourceView.css({width:wc,height:rc});!b.options.fullScreenContainerSelector&&a(document.documentElement).css({overflow:b._oriDocOverFlow});a(j).unbind("resize.wijeditor");b.$ribbon.wijribbon("updateRibbonSize")}h=b.editor.height()-o.outerHeight(true)-n.outerHeight(true);m.height(h).wijsplitter("refresh");b._addHandlerToDesignView();b._addDefaultFontStyleToDesignView();b._createWijMenu();a.browser.msie&&window.setTimeout(function(){b._setDesignViewText(i);e(a.browser.version)>=9&&b.sourceView.val(i)},40)},_createWijMenu:function(){var b=this,c=b._getDesignViewDocument();b.contextMenu&&b.contextMenu.wijmenu({orientation:"vertical",trigger:b.designView,triggerEvent:"rtclick",showing:function(j,i){if(a.browser.msie)H=c.selection.createRange();var d=b.designView.offset(),e=a(a(b.designView)[0].contentWindow).scrollLeft(),f=a(a(b.designView)[0].contentWindow).scrollTop(),g=d.left+2-e,h=d.top-f;i.options.position={my:"left top",at:"right top",of:j,offset:g+" "+h,collision:"none none"}},animation:{animated:"fade"},select:function(c,a){b._setIESelection();b._contextMenuItemClick(c,a);b.contextMenu.wijmenu("deactivate")}})},_fullscreenOnWindowResize:function(){var b=this,h=b._getHeader(),f=b._getFooter(),d=b._getContent(),c,g=a(window).width(),e=a(window).height();b.editor.css({width:g,height:e});c=b.editor.height()-h.height()-f.height();d.height(c).wijsplitter("refresh")},_saveText:function(){},_doSpellCheck:function(){},_ribbonCommand:function(g,i){var b=this,d=b._getDesignViewDocument(),h=b._getContent(),c,f,e;if(i===t){b._fontNameCommand(g);b._onDesignViewBlur(null);return}if(i===z){b._fontSizeCommand(g);b._onDesignViewBlur(null);return}b._setIEFocus();switch(g){case ld:if(a.browser.msie){d.execCommand("FormatBlock",false,"<ADDRESS>");e=d.selection.createRange();e=a(e.parentElement()).closest("address");if(e.length){e.replaceWith("<blockquote>"+e.html()+"</blockquote>");d.body.innerHTML=d.body.innerHTML.replace(/<BLOCKQUOTE>\s*?<BLOCKQUOTE>/gi,"<BLOCKQUOTE>");d.body.innerHTML=d.body.innerHTML.replace(/<\/BLOCKQUOTE>\s*?<\/BLOCKQUOTE>/gi,"</BLOCKQUOTE>");d.body.innerHTML=d.body.innerHTML.replace(/<BLOCKQUOTE>\s*?<\/BLOCKQUOTE>/gi,"")}}else d.execCommand("FormatBlock",false,"<BLOCKQUOTE>");break;case Kd:c=b._generateUniqueName("form");b.insertHTML('<form id="'+c+'" name="'+c+'" method="post">'+c+"</form>");break;case jd:c=b._generateUniqueName("image");b.insertHTML('<input id="'+c+'" name="'+c+'" type="image" value="'+c+'"/>');break;case wd:c=b._generateUniqueName("textarea");b.insertHTML('<textarea id="'+c+'" name="'+c+'" rows="4" cols="48"></textarea>');break;case Fd:c=b._generateUniqueName("button");b.insertHTML('<input id="'+c+'" name="'+c+'" type="button" value="'+c+'"/>');break;case Cd:c=b._generateUniqueName("textbox");b.insertHTML('<input id="'+c+'" name="'+c+'" type="text" value="'+c+'"/>');break;case zd:c=b._generateUniqueName("list");b.insertHTML('<select id="'+c+'" name="'+c+'" style="width: 120px" size="8"></select>');break;case ud:c=b._generateUniqueName("password");b.insertHTML('<input id="'+c+'" name="'+c+'" type="password" value="'+c+'"/>');break;case ed:c=b._generateUniqueName("dropdown");b.insertHTML('<select id="'+c+'" name="'+c+'"></select>');break;case id:c=b._generateUniqueName("hidden");b.insertHTML('<input id="'+c+'" name="'+c+'" type="hidden" value="'+c+'" />');break;case Hd:c=b._generateUniqueName("radiobox");b.insertHTML('<input id="'+c+'" name="'+c+'" type="radio" value="'+c+'"><label for="'+c+'">'+c+"</label></input>");break;case sd:c=b._generateUniqueName("checkbox");b.insertHTML('<input id="'+c+'" name="'+c+'" type="checkbox" value="'+c+'"><label for="'+c+'">'+c+"</label></input>");break;case Nb:case ec:case Xb:case gc:case N:case Ob:case fc:case Zb:b._tableAction(g);break;case yd:b._toggleTableBorders();break;case y:try{if(d.queryCommandState(v)){d.execCommand(v,false,null);b.$ribbon.wijribbon(u,v,false)}}catch(k){}d.execCommand(y,false,null);b._addtoUndoBuffer();break;case v:try{if(d.queryCommandState(y)){d.execCommand(y,false,null);b.$ribbon.wijribbon(u,y,false)}}catch(j){}d.execCommand(v,false,null);b._addtoUndoBuffer();break;case Pb:b._removeFormat();break;case kd:b.insertHTML("<br/>");break;case Tc:f=b._getSelectedContent();if(!f||f==="")f="&nbsp;";b.insertHTML("<p>"+f+"</p>");break;case Oc:b.insertHTML('<div title="Print Page Break" style="font-size:1px;page-break-before:always;vertical-align:middle;height:1px;background-color:#c0c0c0">&nbsp;</div>');break;case md:b._toggleFullScreen();break;case D:b._undoAction();break;case I:b._redoAction();break;case yc:b._execCut();break;case sc:b._execCopy();break;case pc:b._execPaste();break;case Jd:b.insertDateAndTime();break;case Wb:b.$modes.wijribbon(C,O,true).wijribbon(u,Wb,true);b.$ribbon.wijribbon("option","disabled",false);h.wijsplitter("option","panel2",{collapsed:true});break;case hc:b.$modes.wijribbon(C,O,true).wijribbon(u,hc,true);b.$ribbon.wijribbon("option","disabled",false);h.wijsplitter("option",{panel1:{collapsed:false},panel2:{collapsed:false}});break;case ac:b.$modes.wijribbon(C,O,false).wijribbon(u,ac,true);b.$ribbon.wijribbon("option","disabled",true);h.wijsplitter("option","panel1",{collapsed:true});break;case O:h.wijsplitter("option","panel1").collapsed&&b._toggleWordWrap();break;case cc:b._saveSelectionForIE();b._createDialog(this.localizeString("backColorDialogTitle","Set BackColor"),b._getDialogRes_BackColor(),b.initBackColorDialog);break;case dc:b._saveSelectionForIE();b._createDialog(this.localizeString("foreColorDialogTitle","Set ForeColor"),b._getDialogRes_ForeColor(),b.initForeColorDialog);break;case Sb:b._saveSelectionForIE();b._createDialog(this.localizeString("insertTableDialogTitle","Insert Table"),b._getDialogRes_Table(false),b.initInsertTableDialog);break;case qd:b._getEditableTable()&&b._createDialog(this.localizeString("editTableDialogTitle","Edit Table"),b._getDialogRes_Table(true),b.initEditTableDialog);break;case Bd:b._createDialog(this.localizeString("previewDialogPreview","Preview"),b._getDialogRes_Preview(),b.initPreviewDialog);break;case lc:b._createDialog(this.localizeString("cleanUpDialogTitle","Clean up source HTML document"),b._getDialogRes_CleanUp(),b.initCleanUpDialog);break;case oc:b._saveSelectionForIE();b._createDialog(this.localizeString("mediaDialogTitle","Insert media"),b._getDialogRes_Media(),b.initMediaDialog);break;case Tb:b._saveSelectionForIE();b._createDialog(this.localizeString("specialCharacterDialogTitle","Insert special character"),b._getDialogRes_SpecialCharacter(),b.initSpecialCharacterDialog);break;case tc:b._createDialog(this.localizeString("findAndReplaceTitle","Find and replace"),b._getDialogRes_FindAndReplace(),b.initFindDialog);break;case mc:bc=b._getSelectedElement();b._createDialog(this.localizeString("tagInspectorDialogTitle","Tag Inspector"),b._getDialogRes_TagInspector(),b.initTagInspectorDialog);break;case jc:b._saveSelectionForIE();b._createDialog(this.localizeString("templateDialogApplyTemplate","Apply Template"),b._getDialogRes_Template(),b.initTemplateDialog);break;case Mb:b._saveSelectionForIE();b._createDialog(this.localizeString("imageEditorDialogImageBrowser","Image Browser"),b._getDialogRes_ImageBrowser(),b.initImageBrowserDialog);break;case uc:b._saveSelectionForIE();b._createDialog(this.localizeString("hyperLinkDialogInserthyperLink","Insert hyperLink"),b._getDialogRes_Link(),b.initHyperLinkDialog);break;case Yb:b._saveSelectionForIE();b._createDialog("Insert Code",b._getDialogRes_Code(),b.initInsertCodeDialog);break;case fb:case ab:case bb:case eb:case Ad:case Gd:case rb:case lb:case gb:case W:case V:case ob:case td:case rd:d.execCommand(g,false,null);b.options.mode==="bbcode"&&!a.browser.msie&&b._convertStyleToStandTag();b._addtoUndoBuffer();break;case vc:b._saveText();break;case vd:b._doSpellCheck()}b._onDesignViewBlur(null)},_saveSelectionForIE:function(){var c=this._getDesignViewWindow(),b;if(a.browser.msie){b=c.document.selection;H=b.createRange()}},_createDialog:function(d,e,c){var a=this,b=a.dialog;b.html("").undelegate(a.widgetName).undelegate("."+a.widgetName).append(e);a.subDialog&&a.subDialog.html("").undelegate(a.widgetName).undelegate("."+a.widgetName);if(!b.data("wijdialog"))b.wijdialog({width:"auto",height:"auto",modal:true,title:d,position:"center",resizable:false,captionButtons:{pin:{visible:false},refresh:{visible:false},toggle:{visible:false},minimize:{visible:false},maximize:{visible:false}}});else{b.wijdialog("reset");b.wijdialog("option",{width:"auto",height:"auto",title:d})}a._adjustDialogLayoutForIE7();c&&c.call(a);b.wijdialog("open")},_adjustDialogLayoutForIE7:function(){var b=this.dialog;a.browser.msie&&/^7\.[0-9]+/.test(a.browser.version)&&b.wijdialog("option","width",b.parent().width())},_contextMenuItemClick:function(e,b){var a=this,c=b.item.element.attr("_c1buttoncmd");switch(c){case yc:a._execCut();break;case sc:a._execCopy();break;case pc:a.focus();a._execPaste()}},_execCut:function(){var b=this,d=b._getDesignViewDocument();if(a.browser.safari)c(this.localizeString("errorMessageCutError","This function is not supported in current browser.  Plesse use (Ctrl + X)."));else if(a.browser.msie){d.execCommand("Cut",false,null);b._addtoUndoBuffer()}else{b._execCopy();b._deleteSelectionContent();b._addtoUndoBuffer()}},_execCopy:function(){var b=this,d=b._getDesignViewDocument();if(a.browser.safari)c(this.localizeString("errorMessageCopyError","This function is not supported in current browser. Plesse use (Ctrl + C)."));else if(a.browser.msie){d.execCommand("Copy",false,null);b._addtoUndoBuffer()}else b._copyToClipboard(b._getSelectedContent())},_execPaste:function(){var d=this,b,e=d._getDesignViewDocument();if(a.browser.safari)c(this.localizeString("errorMessagePasteError","This function is not supported in current browser. Plesse use (Ctrl + V)."));else if(a.browser.msie){e.execCommand("Paste",false,null);d._addtoUndoBuffer()}else try{b=d._copyFromClipboard();b&&b!==""&&d.insertHTML(b)}catch(f){}},_getFontSizeCollection:function(){return{"10px":ib,"13px":jb,"16px":qb,"18px":nb,"24px":pb,"32px":mb,"48px":hb,1:ib,2:jb,3:qb,4:nb,5:pb,6:mb,7:hb}},_updateButtonStates:function(k){var c=this,j=c._getDesignViewDocument(),d,b,g={},i=[rb,lb,ob,gb,y,v,W,V,fb,ab,bb,eb],f,h=k.target,e=a(h);a.each(i,function(b,a){g[a]=j.queryCommandState(a)});c.$ribbon.wijribbon(dd,g);d=c._queryCommandValue(t)||"";a.each(c.$ribbon.wijribbon("getDropdownList",t),function(c,a){if(a.toUpperCase()===d.toUpperCase()){b=c;return false}});c.$ribbon.wijribbon(u,b,true,t);if(c._isFontSizeCustomized()){if(e.is("span"))b=h.style.fontSize;else b="";if(b===""){f=e.parents("span."+x);a.each(f,function(c,a){b=a.style.fontSize;if(b&&b!=="")return false})}if(b==="")b=e.css("font-size")}else{d=c._queryCommandValue(z)||"";if(d==="")d=e.css("font-size");a.each(c._getFontSizeCollection(),function(c,a){if(c.toString()===d.toString()){b=a;return false}})}c.$ribbon.wijribbon(u,b,true,z)},_queryCommandValue:function(a){var b=this._getDesignViewDocument();try{if(!b.queryCommandEnabled(a))return null}catch(c){return null}try{return b.queryCommandValue(a)}catch(d){}return null},_escActionAssociated:function(){var b=this,a=b._getDesignViewWindow();a.document.selection!==undefined&&a.document.selection.empty();a.getSelection!==undefined&&a.getSelection().removeAllRanges();b._hideAllDropdownsMenus()},_hideAllDropdownsMenus:function(){var a=this;a.contextMenu&&a.contextMenu.wijmenu("hideAllMenus");a.$ribbon.wijribbon("hideDropdown",t).wijribbon("hideDropdown",z).wijribbon("hideDropdown",qc)},_onDesignViewKeyDown:function(b){var a=this,c;a._setSaveBtnEnabled();try{if(b.ctrlKey)c=String.fromCharCode(b.keyCode).toLowerCase();else switch(b.keyCode){case 27:a._escActionAssociated();break;case 13:case 46:a._addtoUndoBuffer();a._continueSavingInputTextForUndo=false;break;default:a._continueSavingInputTextForUndo=true}}catch(d){}},_onDesignViewKeyUp:function(a){var b=this,c;(a.keyCode===37||a.keyCode===38||a.keyCode===39||a.keyCode===40||a.keyCode===33||a.keyCode===34||a.keyCode===35||a.keyCode===36)&&b._updateButtonStates(a);if(a.ctrlKey){c=String.fromCharCode(a.keyCode).toLowerCase();switch(c){case"y":b._redoAction();a.preventDefault();a.stopPropagation();break;case"z":b._undoAction();a.preventDefault();a.stopPropagation();break;case"x":case"v":b._addtoUndoBuffer();b._continueSavingInputTextForUndo=false}}},_onDesignViewMouseUp:function(c){var d=this,b;if(c.button===2)return;d._updateButtonStates(c);d._refreshPathSelector();d._hideAllDropdownsMenus();a(document).mouseup();if(a.browser.msie){b=a(c.target).closest("a");if(c.ctrlKey&&b.length>0)try{b.focus();j.open(b[0].href,"_blank")}catch(e){}}},_onDesignViewBlur:function(e){var c=this,d=c.options,b;b=c._getDesignViewText();c._onTextChange(e);if(d.mode==="bbcode")b=c._convertHtmlToBBCode(a.trim(b));c.sourceView.val(b);d.text=b},_onTextChange:function(b){var a=this;if(a._continueSavingInputTextForUndo){a._addtoUndoBuffer();a._continueSavingInputTextForUndo=false}a._trigger("textChanged",b,{text:a.options.text})},_onSourceViewBlur:function(){var b=this,a;a=b.sourceView.val();b._setDesignViewText(a);b.options.text=a},_convertBBCodeToHtml:function(a){a=a.replace(/</g,"&lt;");a=a.replace(/>/g,"&gt;");a=a.replace(/(?:\r\n|\n|\r)/g,"<br>");a=a.replace(/\[EMAIL\]([\s\S]*?)\[\/EMAIL\]/gim,'<a href="mailto:$1">$1</a>');a=a.replace(/\[EMAIL\=([^\]]+)]([\s\S]*?)\[\/EMAIL\]/gim,'<a href="mailto:$1">$2</a>');a=a.replace(/\[URL\]([\s\S]*?)\[\/URL\]/gim,'<a href="$1">$1</a>');a=a.replace(/\[URL\=([^\]]+)]([\s\S]*?)\[\/URL\]/gim,'<a href="$1">$2</a>');a=a.replace(/\[B\]/gim,"<b>");a=a.replace(/\[\/B\]/gim,"</b>");a=a.replace(/\[I\]/gim,"<i>");a=a.replace(/\[\/I\]/gim,"</i>");a=a.replace(/\[S\]/gim,"<strike>");a=a.replace(/\[\/S\]/gim,"</strike>");a=a.replace(/\[U\]/gim,"<u>");a=a.replace(/\[\/U\]/gim,"</u>");a=a.replace(/\[IMG height=(.*?) width=(.*?)](.+?)\[\/IMG\]/gim,'<img height="$1" width = "$2" src="$3"/>');a=a.replace(/\[BLOCK\]/gim,"<blockquote>");a=a.replace(/\[\/BLOCK\]/gim,"</blockquote>");a=a.replace(/\[LIST\=1\]\[\*\]([\s\S]*?)\[\/LIST\]/gim,"<ol><li>$1</li></ol>");a=a.replace(/\[LIST\]\[\*\]([\s\S]*?)\[\/LIST\]/gim,"<ul><li>$1</li></ul>");a=a.replace(/\[\*\]/gim,"</li><li>");a=a.replace(/\[size=([^\]]*?)\]/gi,'<font size="$1">');a=a.replace(/\[\/size\]/gim,"</font>");a=a.replace(/\[color=([^\]]*?)\]/gi,'<font color="$1">');a=a.replace(/\[\/color\]/gim,"</font>");return a},_replaceComplexHtml:function(g){var f,c,d,b,e=a("<div/>").html(g);f=a("img",e);a.each(f,function(){d="[IMG height="+a(this).height()+" width="+a(this).width()+"]"+a(this).attr("src").toString()+"[/IMG]";a(this).replaceWith(d)});c=a("font",e);for(b=c.length-1;b>=0;b--){if(a(c[b]).attr("color")&&a(a(c[b])).attr("size"))d="[Color="+a(a(c[b])).attr("color")+"][Size="+a(a(c[b])).attr("size")+"]"+a(a(c[b])).html()+"[/Size][/Color]";else if(a(a(c[b])).attr("color")&&!a(a(c[b])).attr("size"))d="[Color="+a(a(c[b])).attr("color")+"] "+a(a(c[b])).html()+"[/Color]";else if(a(a(c[b])).attr("size")&&!a(a(c[b])).attr("color"))d="[Size="+a(a(c[b])).attr("size")+"]"+a(a(c[b])).html()+"[/Size]";a(a(c[b])).replaceWith(d)}return e.html()},_convertHtmlToBBCode:function(a){var b=this;if(a==="")return;a=b._replaceComplexHtml(a);a=a.replace(/<br(?=[ \/>]).*?>/gim,"\r\n");a=a.replace(/<a .*?href=(["'])(.+?)\1.*?>(.+?)<\/a>/gi,"[URL=$2]$3[/URL]");a=a.replace(/<a .*?href=(["'])mailto:(.+?)\1.*?>(.+?)<\/a>/gi,"[EMAIL=$2]$3[/EMAIL]");a=a.replace(/<(?:b|strong)>/gim,"[B]");a=a.replace(/<\/(?:b|strong)>/gim,"[/B]");a=a.replace(/<(?:i|em)>/gim,"[I]");a=a.replace(/<\/(?:i|em)>/gim,"[/I]");a=a.replace(/<(?:strike|s)>/gim,"[S]");a=a.replace(/<\/(?:strike|s)>/gim,"[/S]");a=a.replace(/<u>/gim,"[U]");a=a.replace(/<\/u>/gim,"[/U]");a=a.replace(/<blockquote.*?\>/gim,"[BLOCK]");a=a.replace(/\s{0,}<\/blockquote>/gim,"[/BLOCK]");a=a.replace(/(?:\r\n|\r|\n){0,1}<(?:ol)>[\s]*/gim,"[LIST=1]");a=a.replace(/<\/(?:ol)>/gim,"[/LIST]");a=a.replace(/(?:\r\n|\r|\n){0,1}\<(?:ul)>[\s]*/gim,"[LIST]");a=a.replace(/<\/(?:ul)>/gim,"[/LIST]");a=a.replace(/\s{0,}<li\s{0,1}.*?>([\s\S]*?)\n{0,}\s{0,}<\/li>/gim,"[*]$1");a=a.replace(/&nbsp;/gi," ");a=a.replace(/(<[^>]+>)/gm,"");return a},_convertFontStyleToStandTag:function(){var e=this,g=e._getDesignViewDocument(),f=a(g.body),b,c,d=a("[style*='color: ']",f);if(d.length!==0){b=d;c="<font color='"+e._getWebColorFromRgb(d.css("color"))+"'></font>"}b&&a.each(b,function(){if(a(this).is("span"))a(this).replaceWith(a(c).html(a(this).html()));else a(this).is("font")&&a(this).attr("size")&&a(this).removeAttr("style").html(a(c).html(a(this).html()))})},_convertStyleToStandTag:function(){var j=this,k=j._getDesignViewDocument(),d=a(k.body),b,c,e,i=a("[style*='font-weight: bold;']",d),g=a("[style*='font-style: italic;']",d),h=a("[style*='text-decoration: line-through;']",d),f=a("[style*='text-decoration: underline;']",d);if(i.length!==0){b=i;c="<b></b>";e="font-weight"}else if(g.length!==0){b=g;c="<i></i>";e="font-style"}else if(h.length!==0){b=h;c="<strike></strikes>";e="text-decoration"}else if(f.length!==0){b=f;c="<u></u>";e="text-decoration"}b&&a.each(b,function(){if(a(this).is("span")&&this.style.fontSize==="")a(this).replaceWith(a(c).html(a(this).html()));else a(this).removeAttr("style").html(a(c).html(a(this).html()))})},_getWebColorFromRgb:function(a){var c=this,b;if(a.indexOf("rgb(")===0){b=a.substring(4,a.length-1).split(",");a=c._convertToWebColor(e(b[0]),e(b[1]),e(b[2]))}return a},_updateList:function(d,c){var b;a("option",c).remove();for(b in d)d[b]&&c.append("<option>"+b+"</option>")},_triggerEvent:function(c,d){var b=this,a=b.options[c];return a&&typeof a==="function"?a.call(b,d):a},_closeDialog:function(){this.dialog.wijdialog("close")},_onTemplateList:function(a){return this._triggerEvent("templateList",a)},updateTemplateList:function(c,e){var b=this,d=e||a("select",b.dialog);b._updateList(c,d);b._templateList=c},initTemplateDialog:function(){var b=this,d=b.dialog,e=a("select",d),c=b._onTemplateList();d.delegate("select","change."+b.widgetName,function(){b.templateListOnChanged()}).delegate("."+pd,"click."+b.widgetName,function(){b.deleteTemplate()}).delegate("."+xd,"click."+b.widgetName,function(){b.saveTemplate()}).delegate(k,"click."+b.widgetName,function(){b.applyTemplate()}).delegate(q,"click."+b.widgetName,function(){b._closeDialog()});if(!c){c=b._templateList;if(!c)return}b.updateTemplateList(c,e)},templateListOnChanged:function(){var g=this,c=g.dialog,d=a("select",c).val(),e=a("iframe",c),f=g._templateList,b;if(!f)return;b=f[d];b.src&&e.attr("src",b.src+"?d="+(new Date).getMilliseconds().toString());b.text&&e.length>0&&e[0].contentWindow.document.write(b.text);if(d){a("."+Rb,c).html(d);a("."+L,c).val(d)}if(b.desc){a("."+Vb,c).html(b.desc);a("."+Y,c).val(b.desc)}},_onSaveTemplate:function(a){this._triggerEvent("saveTemplate",a)},saveTemplate:function(){var d=this,f=d.dialog,b=a("."+L,f).val(),g=a("."+Y,f).val(),e=d._templateList,h=this._getDesignViewText();if(a.trim(b)===""){c(this.localizeString("errorMessageTemplateNameError","Please input a template name!"));return}if(!e){d._templateList=[];e=d._templateList}!e[b]&&a("select",f).append("<option>"+b+"</option>");e[b]={desc:g,text:h};d._onSaveTemplate({name:b,desc:g,text:h})},_onDeleteTemplate:function(a){this._triggerEvent("deleteTemplate",a)},deleteTemplate:function(){var e=this,b=e.dialog,f=a("select",b),d=f.val(),g=e._templateList;if(a.trim(d)===""){c(this.localizeString("errorMessageTemplateFileError","Please select a template file."));return}a("option:selected",f).remove();a("iframe",b).attr("src","about:blank");a("."+Rb,b).empty();a("."+L,b).val("");a("."+Vb,b).empty();a("."+Y,b).val("");delete g[d];e._onDeleteTemplate(d)},applyTemplate:function(){var b=this,d=b.dialog,g=a("select",d),e=g.val(),f=a("iframe",d)[0],i=a("."+L,d).val(),h=f.contentWindow.document.body.innerHTML;if(a.trim(i)===""||a.trim(e)===""){c(this.localizeString("errorMessageValidTemplateFileError","Please select a valid template file."));return}b._setDesignViewText(h);b._addtoUndoBuffer();b._setSaveBtnEnabled();b._closeDialog()},_onImageList:function(){var b=this,a=b.options.imageList;return a&&typeof a==="function"?a.call(b):a},updateImageList:function(b,g){var c=this,e=c.dialog,f=g||a("select",e),d=a("."+Qb,e);c._updateList(b,f);c._imgList=b;if(!b){d.addClass(Ab);return}d.removeClass(Ab)},initImageBrowserDialog:function(){var b=this,c=b.dialog,d=b._onImageList();a("img",c).hide();c.delegate("select","change."+b.widgetName,function(){b.imageListOnChanged(this)}).delegate(k,"click."+b.widgetName,function(a){b.submitInsertImageDialog();b._onDesignViewBlur(a)}).delegate(q,"click."+b.widgetName,function(){b._closeDialog()});a("."+db+" input",c).bind("change."+b.widgetName,function(){b.imageUrlChanged(this)});if(!d){d=b._imgList;if(!d){a("."+Qb,c).addClass(Ab);return}}b.updateImageList(d,a("select",c))},imageUrlChanged:function(c){var d=this,b=d.dialog;a("img",this.dialog).attr("src",a(c).val()+"?"+ +new Date).show().bind("load",function(){a("."+X+" input",b).val(a("img",b).width());a("."+T+" input",b).val(a("img",b).height())})},imageListOnChanged:function(){var e=this,b=e.dialog,f=a("select",b).val(),d=e._imgList,c;if(!d)return;c=d[f];a("img",b).attr("src",c).show();a("."+db+" input",b).attr("value",c);j.setTimeout(function(){a("."+X+" input",b).val(a("img",b).width());a("."+T+" input",b).val(a("img",b).height())},200)},submitInsertImageDialog:function(){var b=this,e,d=b.dialog,g=a("."+db+" input",d).val(),i=a("."+nd+" input",d).val(),h=a("."+X+" input",d).val(),f=a("."+T+" input",d).val(),j=a("."+od+" input",d).val();if(a.trim(g)===""){c(this.localizeString("errorMessageSelectImageError","Please select a image."));return}if(!b._isNumeric(h)){c(this.localizeString("errorMessageImageWidthError","Please input a number for 'Image width' textbox."));return}if(!b._isNumeric(f)){c(this.localizeString("errorMessageImageHeightError","Please input a number for 'Image height' textbox."));return}b.focus();e='<img src="'+g+'" alt="'+i+'" width="'+h+'" height="'+f;if(b.options.mode!=="bbcode")e+='" style="'+j;e+='"/>';b.insertHTML(e);b._closeDialog()},initHyperLinkDialog:function(){var b=this,c=b.dialog,e=b.getLinkHrefField(),h=a("."+tb,c),g,d,f,i=a("."+K+" input",c);c.delegate(k,"click."+b.widgetName,function(a){b.submitHyperLinkDialog();b._onDesignViewBlur(a)}).delegate(q,"click."+b.widgetName,function(){b._closeDialog()}).delegate("."+Hb,"change."+b.widgetName,function(){b.anchorListOnChanged(this)}).delegate("."+Pc+">div","click."+b.widgetName,function(){b.radioListOnChanged()}).delegate("."+Ec+">div","click."+b.widgetName,function(){b.linkIconTypeOnChanged()}).delegate("."+M+" input","change."+b.widgetName,function(){b.tempImg=a('<img src="'+a("."+M+" input",c).val()+'">').appendTo("body");j.setTimeout(function(){a("."+U+" input",c).val(b.tempImg.width());a("."+R+" input",c).val(b.tempImg.height());b.tempImg.remove();b.tempImg=undefined},200)});try{i.val(e);d=b._getLinkInnerHTML()}catch(l){}f=a(d);if(d&&d.substring(0,3)==="<img")g=true;else g=false;if(!g){a("."+G+" input",c).show();h.hide();a("."+G+" input",c).val(d)}else{h.show();a("."+G+" input",c).hide();a("."+M+" input",c).val(f.attr("src"));a("."+U+" input",c).val(f.attr("width"));a("."+R+" input",c).val(f.attr("heigth"))}a("."+Ub+" input",c).val(b._getLinkCssField());a("."+S+" select",c).val(b._getLinkTarget());a("#radAnchor",c).attr("checked","checked");a("#radLinkTypeIsText",c).attr("checked","checked");if(e.length>6)if(e.substring(0,4)==="http")a("#radUrl",c).attr("checked","checked");else if(e.substring(0,6)==="mailto")a("#radMail",c).attr("checked","checked");else if(e.substring(0,1)==="#")a("#radAnchor",c).attr("checked","checked");else a("#radFile",c).attr("checked","checked");f=undefined},_getLinkInnerHTML:function(){var b=this,a;b.focus();a=b._getInspectElement();try{if(a&&a.tagName==="A")return a.innerHTML||""}catch(c){}return b.getSelectionHTMLContent()||""},getLinkHrefField:function(){var b=this,a;b.focus();a=b._getInspectElement();try{if(a&&a.tagName==="A")return b.fixAbsoluteUrlsIfNeeded(a.href||"")}catch(c){}return""},_getLinkTarget:function(){var b=this,a;b.focus();a=b._getInspectElement();try{if(a&&a.tagName==="A")return a.target||""}catch(c){}return""},_getLinkCssField:function(){var b=this,a;b.focus();a=b._getInspectElement();try{if(a&&a.tagName==="A")return a.style.cssText||""}catch(c){}return""},submitHyperLinkDialog:function(){var d=this,b=d.dialog,m=a("#radMail",b),l=a("."+K+" input",b),p=a("."+G+" input",b),q=a("."+Ub+" input",b),n=a("."+S+" select",b),g=l.val(),f=p.val(),o=n.val(),k=a("#radLinkTypeIsImage",b),e=k.attr("checked"),j=a("."+M+" input",b).val(),i=a("."+U+" input",b).val(),h=a("."+R+" input",b).val(),r=q.val();if(g===""){c(this.localizeString("errorMessageAddressError","Please input address!"));return}if(f===""&&!e){c(this.localizeString("errorMessageDisplayTextError","Please input display text!"));return}if(j===""&&e){c(this.localizeString("errorMessageHyperLinkImageUrlError","Please input image url!"));return}if(!d._isNumeric(i)&&e){c(this.localizeString("errorMessageHyperLinkImageWidthError","Please input correct image width!"));return}if(!d._isNumeric(h)&&e){c(this.localizeString("errorMessageHyperLinkImageHeightError","Please input correct image height!"));return}if(m.attr("checked")&&!d._isEmail(g)){c(this.localizeString("errorMessageHyperLinkEmail","Please input correct email!"));return}if(e){f='<img src="'+j+'" width="'+i+'" height="'+h;f+='"/>'}d._editLink(f,g,r,o);d._closeDialog()},_editLink:function(g,f,d,e){var b=this,a,c="";b.focus();a=b._getInspectElement();try{if(a&&a.tagName==="A"){a.innerHTML=g;a.href=f;a.target=e;if(d!==a.style.cssText)a.style.cssText=d;b._addtoUndoBuffer();b._setSaveBtnEnabled();return}}catch(h){}c='<a href="'+f+'" target="'+e+'"';if(d!=="")c+=' style="'+d+'"';c+=">"+g+"</a>";b._setIESelection();b.insertHTML(c)},anchorListOnChanged:function(d){var e=this,b=e.dialog,c=a(d).val();if(c!==""){a("."+K+" input",b).val(c);a("#radAnchor",b).attr("checked","checked")}},radioListOnChanged:function(){var e=this,b=e.dialog,c=a("."+Hb,b),d=a("."+K+" input",b);d.val("");if(a("#radUrl",b).is(":checked"))c.hide();else if(a("#radAnchor",b).is(":checked"))c.show();else if(a("#radMail",b).is(":checked")){c.hide();d.val("mailto:")}else a("#radFile",b).is(":checked")&&c.hide()},linkIconTypeOnChanged:function(){var e=this,b=e.dialog,c=a("."+tb,b),d=a("."+G,b);if(a("#radLinkTypeIsText",b).is(":checked")){d.show();c.hide()}else if(a("#radLinkTypeIsImage",b).is(":checked")){d.hide();c.show()}},_getDialogRes_Code:function(){var b=this,a=b._createDiv(h);a.add(b._createElement("div","Enter source code",{"class":Wd}));a.add(b._createElement("textarea","",{"class":Yc}));a.add(b._createSeparator());a.add(b._createOKCancelButtons());return a.render()},initInsertCodeDialog:function(){var a=this,b=a.dialog;b.delegate(k,"click."+a.widgetName,function(b){a.submitCodeDialog();a._onDesignViewBlur(b)}).delegate(q,"click."+a.widgetName,function(){a._closeDialog()})},submitCodeDialog:function(){var c=this,e=c.dialog,d=a("."+Yc,e),b=d.val();if(b==="")return;b=b.replace(/</g,"&lt;");b=b.replace(/>/g,"&gt;");b="<pre>"+b+"</pre>";c._setIESelection();c.insertHTML(b);c._closeDialog()},initTagInspectorDialog:function(){var b=this,c=b.dialog,d=a("."+zb);c.delegate(k,"click."+b.widgetName,function(a){b.submitTagInspectorDialog();b._onDesignViewBlur(a)}).delegate(q,"click."+b.widgetName,function(){b._closeDialog()}).delegate("#displayNoEmpty","click."+b.widgetName,function(){b.tagInspectorDialogSwitchAttList(this)});b._laySelectedElementAttributes(a("."+Q,c),a("."+Nc,c));a("."+Lb+" input",c).val(b._getSelectedElementStyle());if(b._selectedElementCanHaveChildren()){d.show();a("textarea",d).val(b._getSelectedElementInnerHTML())}else d.hide()},submitTagInspectorDialog:function(){var b=this,g=b.dialog,c=b._getInspectElement(),e=a("."+Q,g),d=a("."+Lb+" input").val(),f=a("."+zb+" textarea").val();try{a.each(a("input:checkbox",e),function(g,f){var b,e,d=a(f);if(d.is(":checked")){b=d.siblings("span").text();b=b.substring(0,b.length-1);e=d.siblings("input:text").val();a(c).attr(b,e)}});if(a.trim(d)!=="")c.style.cssText=d;b._selectedElementCanHaveChildren()&&a(c).html(f)}catch(h){}b._closeDialog();b._addtoUndoBuffer();b._setSaveBtnEnabled()},tagInspectorDialogSwitchAttList:function(c){var b=a("."+Q,this.dialog),d=!c.checked;a.each(a("input:text",b),function(c,b){a(b).val()===""&&a(b).parent("li")[d?"show":"hide"]()})},_laySelectedElementAttributes:function(j,k){var f=this,c=f._getInspectElement(),h,d,e,i=this.localizeString("tagInspectorDialogSave","Save"),b="";if(!c)return;k.html(c.tagName);h=f._getDictionaryDeclare();d=c.tagName.toLowerCase();e=h[d];switch(d){case"ul":case"u":case"textarea":case"tbody":case"tr":case"th":case"td":case"table":case"select":case"strong":case"span":case"p":case"option":case"ol":case"li":case"label":case"input":case"img":case"i":case"hr":case"form":case"font":case"em":case"div":case"code":case"button":case"body":case"b":case"a":b+="<ul class='ui-helper-reset'>";a.each(e,function(d,a){var e=c.getAttribute(a)||"";b+="<li><span class='"+g+"'>";b+=a+":</span>";b+="<input type='text' value='"+e+"'/>";b+="<input type='checkbox' id='save"+d+"'/>";b+="<label for='save"+d+"'>"+i+"</label></li>"})}j.html(b)},_getSelectedElementStyle:function(){var a=this._getInspectElement();return a&&a.style?a.style.cssText||"":""},_getSelectedElementInnerHTML:function(){var a=this._getInspectElement();return a?a.innerHTML:""},_selectedElementCanHaveChildren:function(){return!a(this._getInspectElement()).is("input,hr,br,img")},initBackColorDialog:function(){this._initColorDialog("BackColor")},initForeColorDialog:function(){this._initColorDialog("ForeColor")},_initColorDialog:function(h){var c=this,g=c.dialog,j=c._getDesignViewDocument(),i=j.queryCommandValue(h),f,d,b;g.delegate(k,"click."+c.widgetName,function(a){c.submitColorDialog(h);c._onDesignViewBlur(a)}).delegate(q,"click."+c.widgetName,function(){c._closeDialog()});if(i){b=i.toString();if(a.browser.msie){f=e(b);b="rgb("+(f&255)+", "+((f&65280)>>8)+", "+((f&16711680)>>16)+")"}if(b.indexOf("rgb(")===0){d=b.substring(4,b.length-1).split(",");b=c._convertToWebColor(e(d[0]),e(d[1]),e(d[2]))}else if(b.indexOf("rgba(")===0){d=b.substring(5,b.length-1).split(",");b=c._convertToWebColor(e(d[0]),e(d[1]),e(d[2]))}a("."+B+" input",g).attr("value",b)}a("."+Eb,g).wijeditorcolorcanvas("."+B+" input",b)},submitColorDialog:function(c){var b=this,d=a("."+B+" input",b.dialog);b.setColor(c,d.val());b._closeDialog()},setColor:function(d,e){var b=this,f=b._getDesignViewDocument(),g=b._getDesignViewWindow(),c;b._setIESelection();if(a.browser.mozilla&&d==="BackColor"){c=g.getSelection();b.insertHTML('<span style="background-color:'+e+';">'+c+"</span>")}else{f.execCommand(d,false,e);b.options.mode==="bbcode"&&!a.browser.msie&&b._convertFontStyleToStandTag()}b._addtoUndoBuffer();b._setSaveBtnEnabled()},initInsertTableDialog:function(){var a=this,b=a.dialog;b.delegate(k,"click."+a.widgetName,function(b){a.submitInsertTableDialog();a._onDesignViewBlur(b)}).delegate(Bb,"click."+a.widgetName,function(){a._closeDialog()}).delegate("."+E+" input:button","click."+a.widgetName,function(){a.showTableColorDialog(this)})},submitInsertTableDialog:function(){var a=this,b=a._getValuesFromTableDialog();if(!b)return;a._insertTable(b);a._closeDialog()},_insertTable:function(b){var g=this,c="",d,f;if(!b)return false;g._setIEFocus();c+='<table width="'+b.width+'" height="'+b.height+'" cellspacing="'+b.cspacing+'" cellpadding="'+b.cpadding+'" border="'+b.border+'" bgcolor="'+b.bgcolor+'" style="'+b.css+'">';for(d=0;d<b.rows;d++){c+="<tr>";for(f=0;f<b.cols;f++)c+="<td>Cell "+(d+1)+"-"+(f+1)+"</td>";c+="</tr>"}c+="</table>";if(a.browser.mozilla||a.browser.msie&&e(a.browser.version)>=9)c+="<br />";g.insertHTML(c)},initEditTableDialog:function(){var c=this,b=c.dialog,d=c._getInspectElement(),e,f;b.delegate(k,"click."+c.widgetName,function(a){c.submitEditTableDialog();c._onDesignViewBlur(a)}).delegate(Bb,"click."+c.widgetName,function(){c._closeDialog()}).delegate("."+E+" input:button","click."+c.widgetName,function(){c.showTableColorDialog(this)});if(!d)return;try{e=d.rows;if(e.length>0)f=e[0].cells.length;else f=0;e=e.length}catch(g){}a("."+Kb+" input",b).val(e);a("."+Cb+" input",b).val(f);a("."+Ib+" input",b).val(d.getAttribute("width"));a("."+Gb+" input",b).val(d.getAttribute("height"));a("."+Fb+" input",b).val(d.getAttribute("border"));a("."+xb+" input",b).val(d.getAttribute("cellPadding"));a("."+yb+" input",b).val(d.getAttribute("cellSpacing"));a("."+E+" input",b).val(d.getAttribute("bgcolor")||"#ffffff");a("."+Db+" input",b).val(d.style.cssText)},submitEditTableDialog:function(){var j=this,c=j._getInspectElement(),d=a(c),b=j._getValuesFromTableDialog(),h=b&&e(b.rows),f=b&&e(b.cols),i,g;if(!b)return;if(c){d.attr("width",b.width);d.attr("height",b.height);d.attr("bgcolor",b.bgcolor);d.attr("border",b.border);d.attr("cellSpacing",b.cspacing);d.attr("cellPadding",b.cpadding);c.style.cssText=b.css;if(!h||isNaN(h))return;if(!f||isNaN(f))return;while(c.rows.length>h)c.deleteRow(0);while(c.rows.length<h){i=c.insertRow(0);while(i.cells.length<f){g=i.insertCell(0);g.innerHTML="&nbsp;"}}a.each(c.rows,function(b,a){while(a.cells.length>f)a.deleteCell(0);while(a.cells.length<f){g=a.insertCell(0);g.innerHTML="&nbsp;"}})}j._closeDialog()},_getValuesFromTableDialog:function(){var d=this,b=d.dialog,l=a("."+Kb+" input",b).val(),k=a("."+Cb+" input",b).val(),j=a("."+Ib+" input",b).val(),i=a("."+Gb+" input",b).val(),h=a("."+Fb+" input",b).val(),f=a("."+xb+" input",b).val(),g=a("."+yb+" input",b).val(),n=a("."+Db+" input",b).val(),m=a("."+E+" input",b).val();if(!d._isNumeric(l)){c(this.localizeString("errorMessageRowsError","Please input a number for 'Rows' textbox."));return false}if(!d._isNumeric(k)){c(this.localizeString("errorMessageColumnsError","Please input a number for 'Columns' textbox."));return false}if(!d._isNumeric(j)){c(this.localizeString("errorMessageTableWidthError","Please input a number for 'Table Width ' textbox."));return false}if(!d._isNumeric(i)){c(this.localizeString("errorMessageTableHeightError","Please input a number for 'Table Height' textbox."));return false}if(!d._isNumeric(h)){c(this.localizeString("tableDialogBorderError","Please input a number for 'Border thickness' textbox."));return false}if(!d._isNumeric(f)){c(this.localizeString("tableDialogCellPaddingError","Please input a number for 'Cell Padding' textbox."));return false}if(!d._isNumeric(g)){c(this.localizeString("tableDialogCellSpacingError","Please input a number for 'Cell Spacing' textbox."));return false}return{rows:l,cols:k,width:e(j),height:e(i),border:h,cpadding:f,cspacing:g,css:n,bgcolor:m}},showTableColorDialog:function(f){var b=this,c=b.subDialog,d=a(f).prev().val(),e=b._getDialogRes_Color();c.empty().append(e).wijdialog({width:"auto",height:"auto",modal:true,title:"Set Background Color",position:"center",resizable:false,captionButtons:{pin:{visible:false},refresh:{visible:false},toggle:{visible:false},minimize:{visible:false},maximize:{visible:false}}});c.delegate(df,"click."+b.widgetName,function(){b.submitTableColorDialog()}).delegate(Bb,"click."+b.widgetName,function(){b.closeSubDialog()});d!==""&&a("."+B+" input",c).val(d);a("."+Eb,c).wijeditorcolorcanvas("."+B+" input",d);c.wijdialog("open")},submitTableColorDialog:function(){var b=this,c=b.subDialog,e=b.dialog,d=a("."+B+" input",c).val();a("."+E+" input:text",e).val(d);b.closeSubDialog()},closeSubDialog:function(){this.subDialog.wijdialog("close")},_getEditableTable:function(){var f=this,e,b,d;b=f._getSelectedElement();if(!b){c(this.localizeString("errorMessageSelectTableError","Please select a table!"));return false}d=a(b);if(d.is("td,tr,tbody"))b=d.parents("table:first")[0];else{e=d.find("table:only-child");if(a.browser.msie&&e.length)b=e[0];else{c(this.localizeString("errorMessageSelectTableError","Please select a table!"));return false}}bc=b;return true},initPreviewDialog:function(){var a=this,b=a.dialog;a._setPreviewContent(0);b.delegate("#rad640_480","click."+a.widgetName,function(){a._setPreviewDialogSize(640,480)}).delegate("#rad800_600","click."+a.widgetName,function(){a._setPreviewDialogSize(800,600)}).delegate("#rad1024_768","click."+a.widgetName,function(){a._setPreviewDialogSize(1024,768)}).delegate("#chkSplit","click."+a.widgetName,function(){a._splitPreviewPages(this.checked)}).delegate("."+Gc,"click."+a.widgetName,function(){a._printPreviewPage(true)}).delegate("."+Hc,"click."+a.widgetName,function(){a._printPreviewPage(false)}).delegate("."+cd,"click."+a.widgetName,function(){a._closeDialog()}).delegate("."+Wc,"click."+a.widgetName,function(){a._navigatePreviewPage(false)}).delegate("."+Vc,"click."+a.widgetName,function(){a._navigatePreviewPage(true)})},_setPreviewContent:function(d){var b=this,f=b.dialog,g=a("iframe",f),e=a("."+vb+" span",f),c=g[0].contentWindow.document;c.open();if(d===-1){c.write(b._getPreviewAllPageContent());e.html("1 / 1")}else{c.write(b._getPreviewPageContent(d));e.html(d+1+" / "+b._getPreviewPageCount())}c.close()},_setPreviewDialogSize:function(g,f){var h=this,b=h.dialog,c=a("iframe",b),e=b.wijdialog("option","width"),d=b.wijdialog("option","height");if(e==="auto")e=b.parent(".wijmo-wijdialog").width()-c.width();else e=e-c.width();if(d==="auto")d=b.parent(".wijmo-wijdialog").height()-c.height();else d=d-c.height();c.css("width",g).css("height",f);b.wijdialog("option",{width:g+e,height:f+d})},_getPreviewPageCount:function(){return this._getPreviewPages().length},_getPreviewPageContent:function(a){var b=this._getPreviewPages();return b.length>a?b[a]:null},_getPreviewAllPageContent:function(){return this._getDesignViewText()},_getPreviewPages:function(){var b=this._getPreviewAllPageContent(),c=new RegExp("<(DIV|div)[^>]*(page-break-before|PAGE-BREAK-BEFORE)[ ]*:[ ]*always[^>]*>(.*?)<\\/(DIV|div)>","g"),a=b.replace(c,"!-~U^n#i@q,P|.a=g~e+br!");return a.split("!-~U^n#i@q,P|.a=g~e+br!")},_curPageIdx:0,_splitPreviewPages:function(f){var b=this,e=b.dialog,c=a("."+Ac,e),d=a("."+vb,e);if(f){b._setPreviewContent(0);d.show();c.hide()}else{b._setPreviewContent(-1);d.hide();c.show()}b._curPageIdx=0},_navigatePreviewPage:function(f){var c=this,e=a("#chkSplit",c.dialog),b=c._curPageIdx,d=c._getPreviewPageCount();if(e.is(":checked")){if(f){b++;if(b<d)c._setPreviewContent(b);else b=d-1}else{b--;if(b>=0)c._setPreviewContent(b);else b=0}c._curPageIdx=b}},_printPreviewPage:function(f){var c=this,b=c.dialog,e=a("#chkSplit",b),d=a("iframe",b)[0].contentWindow;if(f){e.removeAttr("checked");c._setPreviewContent(-1)}d.focus();d.print()},initCleanUpDialog:function(){var b=this,c=b.dialog;a("textarea",c).val(b.sourceView.val());c.delegate(k,"click."+b.widgetName,function(a){b.submitCleanUpDialog();b._onDesignViewBlur(a)}).delegate(q,"click."+b.widgetName,function(){b._closeDialog()})},submitCleanUpDialog:function(){var e=this,d=e.dialog,f=e.sourceView,b=f.val(),c;if(a("#replaceSpans",d).is(":checked")){c=new RegExp("<\\/?SPAN[^>]*>","g");b=b.replace(c,"")}if(a("#replaceClass",d).is(":checked")){c=new RegExp("<(\\w[^>]*) class=([^ |>]*)([^>]*)","g");b=b.replace(c,"<$1$3")}if(a("#replaceStyle",d).is(":checked")){c=new RegExp('<(\\w[^>]*) style="([^"]*)"([^>]*)',"g");b=b.replace(c,"<$1$3");c=new RegExp("<(\\w[^>]*) lang=([^ |>]*)([^>]*)","g");b=b.replace(c,"<$1$3");c=new RegExp("<\\\\?\\?xml[^>]*>","g");b=b.replace(c,"");c=new RegExp("<\\/?\\w+:[^>]*>","g");b=b.replace(c,"")}if(a("#replaceNbsp",d).is(":checked")){c=new RegExp("&nbsp;","g");b=b.replace(c," ")}if(a("#transformPtoDiv",d).is(":checked")){c=new RegExp("(<P)([^>]*>.*?)(<\\/P>)","g");b=b.replace(c,"<div$2</div>")}f.val(b);e._setDesignViewText(b);e._addtoUndoBuffer();e._closeDialog()},initFindDialog:function(){var a=this,b=a.dialog;if(a.tRange)a.tRange=null;b.delegate(k,"click."+a.widgetName,function(){a.submitFindAction()}).delegate(q,"click."+a.widgetName,function(b){a.submitReplaceAction();a._onDesignViewBlur(b)})},submitFindAction:function(){var b=this,c=a("textarea:first",b.dialog).val();if(a.trim(c)==="")return;b._findAndReplaceString(c)},submitReplaceAction:function(){var f=this,e=f.dialog,b=a("textarea:first",e).val(),d=a("textarea:last",e).val();if(a.trim(b)==="")return;if(a.trim(d)===""){c(this.localizeString("errorMessageReplaceStringError","please input replace string!"));return}f._findAndReplaceString(b,d)},tRange:null,txtFoundInIE:false,txtFoundInNoneIE:false,_findAndReplaceString:function(e,f){var b=this,h=b._getDesignViewWindow(),d=0,g=false,i=f&&f!==e;if(!f)f=e;if(a.browser.msie){if(b.tRange)if(b.txtFoundInIE&&i){b.tRange.pasteHTML(f);b.tRange=null;g=true;b.txtFoundInIE=false}else{b.tRange.collapse(false);d=b.tRange.findText(e);d&&b.tRange.select()}if(!g&&(!b.tRange||!d)){b.tRange=h.document.body.createTextRange();d=b.tRange.findText(e);if(d){b.tRange.select();if(i){b.tRange.pasteHTML(f);b.tRange=null;g=true}}}}else{if(b.txtFoundInNoneIE&&i){b._replaceSelectionForNoneIE(f);g=true;b.txtFoundInNoneIE=false}else{d=h.find(e);if(!d){d=h.find(e,0,1);while(h.find(e,0,1))continue}}b.txtFoundInNoneIE=b.txtFoundInNoneIE||d;if(b.txtFoundInNoneIE&&i){b._replaceSelectionForNoneIE(f);g=true;b.txtFoundInNoneIE=false}}if(!d&&!g){c('"'+e+'" String Not Found');b.tRange=null;b.txtFoundInNoneIE=false;b.txtFoundInIE=false}else b.txtFoundInIE=true},_replaceSelectionForNoneIE:function(d){var a=this._getDesignViewDocument(),b="insert_html_"+Math.round(Math.random()*1e8),c=new RegExp("<[^<]*"+b+"[^>]*>");a.execCommand("insertimage",false,b);a.body.innerHTML=a.body.innerHTML.replace(c,d)},initMediaDialog:function(){var a=this,b=a.dialog;b.delegate(k,"click."+a.widgetName,function(b){a.submitMediaDialog();a._onDesignViewBlur(b)}).delegate(q,"click."+a.widgetName,function(){a._closeDialog()})},submitMediaDialog:function(){var b=this,d=b.dialog,h=a("select",d).val(),e=a("."+fd+" input",d).val(),g=a("."+ad+" input",d).val(),f=a("."+Uc+" input",d).val();if(e===""){c(this.localizeString("errorMessageUrlEmptyError","URL is empty!"));return}if(!b._isUrl(e)){c(this.localizeString("errorMessageUrlCorrectError","please input correct URL!"));return}if(!b._isNumeric(g)){c(this.localizeString("errorMessageMediaWidthError","please input width of the media!"));return}if(!b._isNumeric(f)){c(this.localizeString("errorMessageMediaHeightError","please input height of the media!"));return}b._insertMedia(h,e,g,f);b._closeDialog()},_insertMedia:function(f,d,c,b){var e=this,a="";e._setIESelection();switch(f){case"video":a+='<embed src="'+d+'" width="'+c+'" height="'+b+'" type=audio/x-pn-realaudio-plugin console="Clip1" controls="IMAGEWINDOW,ControlPanel,StatusBar" autostart="true"></embed>';break;case"flash":a+='<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,29,0" width="'+c+'" height="'+b+'">';a+='<param name="movie" value="'+d+'">';a+='<param name="quality" value="high">';a+='<embed src="'+d+'" quality="high" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash" width="'+c+'" height="'+b+'"></embed>';a+="</object>";break;case"applet":a+='<applet code="'+d+'" width="'+c+'" height="'+b+'"></applet>';break;case"other":a+='<embed src="'+d+'" width="'+c+'" height="'+b+'"></embed>'}e.insertHTML(a)},initSpecialCharacterDialog:function(){var b=this,d=b.dialog,c=a("."+Bc+" span",d);d.delegate("label","click."+b.widgetName,function(a){b.submitSpecialCharacterDialog(this);b._onDesignViewBlur(a)}).delegate(k,"click."+b.widgetName,function(){b._closeDialog()}).delegate("label","mouseover."+b.widgetName,function(){c.html(a(this).html())}).delegate("label","mouseout."+b.widgetName,function(){c.empty()})},submitSpecialCharacterDialog:function(c){var b=this;b._setIESelection();b.insertHTML(a(c).html());b._closeDialog()},_setSaveBtnEnabled:function(){this.$ribbon.wijribbon(C,vc,false)},_undoAction:function(){var b=this._getDesignViewDocument().body,a={};i--;if(i<=0)i=0;b.innerHTML=A[i];if(!i){a[D]=true;a[I]=false;this.$ribbon.wijribbon(Jb,a)}else this.$ribbon.wijribbon(C,I,false)},_redoAction:function(){var c=this._getDesignViewDocument().body,b=A.length,a={};i++;if(i>=b-1)i=b-1;c.innerHTML=A[i];if(i===b-1){a[D]=false;a[I]=true;this.$ribbon.wijribbon(Jb,a)}else this.$ribbon.wijribbon(C,D,false)},_addtoUndoBuffer:function(){for(var b=A.length-1-i,a=0;a<b;a++)A.pop();i++;A.push(this._getDesignViewText());this.$ribbon.wijribbon(C,D,false)},_deleteSelectionContent:function(){var e=this._getDesignViewWindow(),b,c,d,f="rangeCount";if(a.browser.msie){b=e.document.selection;b.type.toLowerCase()!=="none"&&b.clear()}else{b=e.getSelection();for(c=0;c<b[f];c++){d=b.getRangeAt(c);d.deleteContents()}}},_refreshPathSelector:function(){var e=this,d=e._getParentElement(e._getDesignViewWindow()),c=e._getPathSelector(),f=a(d).parents(),h=f.length,g="wijmo-wijeditor-label ui-state-default ui-corner-all",b;if(!d)return;c.empty();for(b=h-1;b>=0;b--)c.append("<label class='"+g+"'>&lt;"+f[b].tagName.toLowerCase()+"&gt;</label>");c.append("<label class='"+g+" wijmo-wijeditor-selectlabel ui-state-highlight ui-corner-all'>&lt;"+d.tagName.toLowerCase()+"&gt;</label>")},_toggleTableBorders:function(){var c=this._getDesignViewDocument(),b=a("#__wijStyle",c);Z=!Z;if(a.browser.safari)if(Z)b.html("table,td,tr{border: 1px #acacac dashed;}");else b.empty();else b.attr("disabled",!Z)},_tableAction:function(j){var b=this,o=b._getParentElement(b._getDesignViewWindow()),k=a(o).closest("td"),l,n,q,f,d,h,g,i,m,p,e=0;b._setSaveBtnEnabled();if(k.length===0&&j!==N)return false;else if(j!==N){l=k.parent();n=l.closest("table");q=k[0];f=l[0];d=n[0];h=f.rowIndex;g=q.cellIndex}try{switch(j){case ec:i=f.cells.length;p=d.insertRow(h);for(e=0;e<i;e++)b._insertCell(p,e);break;case fc:d.deleteRow(h);break;case Nb:m=d.rows.length;for(e=0;e<m;e++)b._insertCell(d.rows[e],g);break;case Ob:b._removeColumn(d,g);break;case Xb:b._insertCell(f,g+1);break;case Zb:i=f.cells.length;if(i===1)d.deleteRow(h);else f.deleteCell(g);break;case gc:b._splitCell(d,f,h,g);break;case N:b._mergeCell(b._getSelectedCells(o))}this._addtoUndoBuffer()}catch(r){c(r.message);return false}return true},_removeColumn:function(e,h){var i=e.rows.length,f=0,g,c,a,b,d;while(f<i){g=e.rows[f];c=g.cells;a=c.length;b=h>a-1?a-1:h;d=c[b].colSpan;if(d>1&&a>1)if(b+1<a)c[b+1].colSpan+=d-1;else c[b-1].colSpan+=d+1;if(a===1){e.deleteRow(f);i=e.rows.length}else{g.deleteCell(b);f++}}},_splitCell:function(j,h,l,e){var k=j.rows.length,a=0,i=0,f,d,b,g,c;while(a<=e){if(h.cells[a].colSpan>1)i+=h.cells[a].colSpan-1;a++}this._insertCell(h,e+1);for(b=0;b<k;b++){f=j.rows[b];if(b!==l){g=e;a=0;d=0;while(a<=g){if(f.cells[a].colSpan>1){d+=f.cells[a].colSpan-1;g-=d}a++}c=e+i-d;if(c<0)c=0;f.cells[c].colSpan++}}},_mergeCell:function(b){var e=b.length,c,a,f,d;if(e<2||b[0].parentNode!==b[e-1].parentNode)return false;c=b[0].parentNode;a=b[0].cellIndex;f=a+e;for(d=a+1;d<f;d++){c.cells[a].innerHTML+=c.cells[a+1].innerHTML;c.cells[a].colSpan++;c.deleteCell(a+1)}},_getSelectedCells:function(k){var j=this._getDesignViewWindow(),m=j.document,e=[],b,d,h,c,f,g,i,l;if(a.browser.msie){b=m.selection.createRange();d=a(k).closest("tr")[0];d&&a.each(d.cells,function(f,d){var a=m.selection.createRange(),c="compareEndPoints";a.moveToElementText(d);(b.inRange(a)||b[c]("StartToStart",a)>=0&&b[c]("StartToEnd",a)<=0||b[c]("EndToStart",a)>=0&&b[c]("EndToEnd",a)<=0)&&e.push(d)})}else if(a.browser.mozilla){h=j.getSelection();f=h.rangeCount;for(c=0;c<f;c++){b=h.getRangeAt(c);g=b.startContainer;i=g.nodeName.toLowerCase();if(i==="td"||i==="th")e.push(g);else if(i==="tr"){l=b.startOffset;e.push(g.cells[l])}}}else{h=j.getSelection();d=a(k).closest("tr")[0];if(d){f=d.cells.length;for(c=0;c<f;c++)e.push(d.cells[c])}}return e},insertDateAndTime:function(){var a=new Date;if(this.options.culture&&this.options.culture!=="")this.insertHTML(Globalize.format(a,"dddd ",Globalize.findClosestCulture(this.options.culture))+Globalize.format(a,"F",Globalize.findClosestCulture(this.options.culture)));else this.insertHTML(a.toDateString()+" "+a.toTimeString())},_toggleWordWrap:function(){var d=this,b=d.sourceView,e="wrap",c;xc=!xc;c=xc?"soft":"off";b.attr(e,c);b[0].focus();if(a.browser.mozilla){b.hide();j.setTimeout(function(){b.show()},40)}},insertHTML:function(d){var c=this,e=c._getDesignViewDocument(),b;try{if(a.browser.msie){b=e.selection.createRange();b.pasteHTML(d);b.collapse(false);b.select()}else e.execCommand("insertHTML",false,d)}catch(f){}c._addtoUndoBuffer();c._setSaveBtnEnabled()},_getSelectedContent:function(){var g=this._getDesignViewWindow(),f=g.document,c="",d="cloneContents",a,e,b;if(!f.selection){a=g.getSelection().getRangeAt(0);if(a)if(a[d]){e=a[d]();b=document.createElement("div");b.appendChild(e);c=b.innerHTML;b=null}}else{a=f.selection.createRange();return a.htmlText}return c||""},_setIESelection:function(){a.browser.msie&&H&&H.select()},_setIEFocus:function(){var b=this._getDesignViewDocument();if(a.browser.msie)try{b.body.focus()}catch(c){}},focus:function(){var b=this._getDesignViewWindow(),c=b.document;if(a.browser.msie)if(!H)c.body.focus();else H.select();else b.focus()},_getInspectElement:function(){return bc||this._getSelectedElement()},_getSelectedElement:function(){return this._getParentElement(this._getDesignViewWindow())},_createElement:function(c,a,b){return new kb(c,a,b)},_createDiv:function(a){return this._createElement("div",{"class":a})},_createSpan:function(a,b){var c=this;return!b?c._createElement("span",{"class":a}):a.length===0?c._createElement("span",b):this._createElement("span",b,{"class":a})},_createTextBox:function(c,b){var a={"class":c,type:"text"};if(b)a.value=b;return this._createElement("input",a)},_createLabel:function(b,a){return a?new kb("label",b,{"for":a}):new kb("label",b)},_createRadio:function(d,c,b){var a={name:c,id:d,value:b,type:"radio"};return this._createElement("input",a)},_createCheckbox:function(b){var a={type:"checkbox",id:b};return this._createElement("input","",a)},_createSelect:function(d,e){var c=this,f={"class":d},b=c._createElement("select",f);if(d==="")b=c._createElement("select");a.each(e,function(e,d){if(a.isPlainObject(d)&&d.selected)b.add(c._createElement("option",d.text,{selected:"selected"}));else b.add(c._createElement("option",d))});return b},_createInputButton:function(c,b){var a={"class":c,type:"button"};if(b)a.value=b;return this._createElement("input",a)},_createTextField:function(h,f,e,c){var b=this,a=b._createDiv(f),d={type:"text"};if(c)d.value=c;a.add(b._createSpan(g,h));a.add(b._createElement("input",d));e&&a.add(new Hf(e));return a},_createSeparator:function(){var b=this,a=b._createDiv(If);a.add(b._createElement("hr"));return a},_createOKCancelButtons:function(){var b=this,a=b._createDiv(w);a.add(b._createElement("input",{type:"button","class":n,value:this.localizeString("dialogOK","OK")}));a.add(b._createElement("input",{type:"button","class":n,value:this.localizeString("dialogCancel","Cancel")}));return a},_getDialogRes_Template:function(){var a=this,b=a._createDiv(f),e=a._createDiv(Ff),h=a._createDiv(vf),m=a._createDiv(Gf),l=a._createDiv(wf),i=a._createDiv(yf),j=a._createElement("div",this.localizeString("templateDialogName","Name :")),k=a._createElement("div",this.localizeString("templateDialogDescription","Description :")),c=a._createDiv(Ef),d=a._createDiv(uf);e.add(a._createElement("div",this.localizeString("templateDialogSelectTemplate","Select Template:"),{"class":xf}));e.add(a._createElement("div",this.localizeString("templateDialogTemplatePreview","Template Preview:"),{"class":zf}));b.add(e);m.add(a._createElement("select",{size:8}));l.add(a._createElement("iframe",{frameborder:0}));h.add(m);h.add(l);b.add(h);j.add(a._createSpan(Rb));k.add(a._createSpan(Vb));i.add(j);i.add(k);b.add(i);c.add(a._createSpan(g,this.localizeString("templateDialogName","Name :")));c.add(a._createTextBox(L));c.add(a._createSpan(g,this.localizeString("templateDialogDescription","Description :")));c.add(a._createTextBox(Y));b.add(c);d.add(a._createInputButton(n+" "+pd,this.localizeString("templateDialogDeleteSelected","Delete selected")));d.add(a._createInputButton(n+" "+xd,this.localizeString("templateDialogSaveCurrentPage","Save current page as template")));b.add(d);b.add(a._createSeparator());b.add(a._createOKCancelButtons());return b.render()},_getDialogRes_ImageBrowser:function(){var a=this,g=a._createDiv(l),c=a._createDiv(Le),b=a._createDiv(Ve),d=a._createDiv(Qb),f=a._createDiv(kf),e=a._createDiv(Me);b.add(a._createTextField(this.localizeString("imageEditorDialogImageSrc","Image Src:"),db));b.add(a._createTextField(this.localizeString("imageEditorDialogImageAltText","Image alt text:"),nd));b.add(a._createTextField(this.localizeString("imageEditorDialogImageWidth","Image width:"),X,this.localizeString("dialogPixel","px")));b.add(a._createTextField(this.localizeString("imageEditorDialogImageHeight","Image height:"),T,this.localizeString("dialogPixel","px")));b.add(a._createTextField(this.localizeString("imageEditorDialogCssText","Css text:"),od));c.add(b);d.add(f);f.add(a._createElement("select",{size:8}));d.add(e);e.add(a._createElement("img",{src:"",alt:""}));c.add(d);c.add(a._createSeparator());c.add(a._createOKCancelButtons());g.add(c);return g.render()},_getDialogRes_Link:function(){var b=this,c=b._createDiv(h),t=b._createTextField(this.localizeString("hyperLinkDialogAddress","Address :"),K),j=b._createDiv(Pc+" ui-helper-clearfix"),i=b._createElement("div"),e=b._createDiv(tb),l=b._createDiv(Ec),d=b._createElement("div"),s=[{id:"radUrl",value:"url",text:this.localizeString("hyperLinkDialogUrl","url")},{id:"radAnchor",value:"anchor",checked:true,text:this.localizeString("hyperLinkDialogAnchor","anchor")},{id:"radMail",value:"email",text:this.localizeString("hyperLinkDialogEmail","email")}],o=[{id:"radLinkTypeIsText",value:"text",checked:true,text:this.localizeString("hyperLinkDialogText","text")},{id:"radLinkTypeIsImage",value:"image",text:this.localizeString("hyperLinkDialogImage","image")}],m=[],u=b._createTextField(this.localizeString("hyperLinkDialogTextToDisplay","Text to display :"),G),n=b._createSpan(g,this.localizeString("hyperLinkDialogIconType","Icon Type :")),k=b._createDiv(S),r=b._createSpan(g,this.localizeString("hyperLinkDialogTarget","Target :")),p=[{text:"_blank",selected:true},"_parent","_self","_top"],q=b._createSelect(S,p),v=b._createTextField(this.localizeString("hyperLinkDialogCss","Css :"),Ub),f;e.add(b._createTextField(this.localizeString("imageEditorDialogImageSrc","Image Src:"),M));e.add(b._createTextField(this.localizeString("imageEditorDialogImageWidth","Image width:"),U,this.localizeString("dialogPixel","px")));e.add(b._createTextField(this.localizeString("imageEditorDialogImageHeight","Image height:"),R,this.localizeString("dialogPixel","px")));c.add(t);c.add(j);j.add(i);l.add(d);d.add(n);a.each(s,function(c,a){i.add(b._createRadio(a.id,"radioList",a.value));i.add(b._createLabel(a.text,a.id))});a.each(o,function(c,a){d.add(b._createRadio(a.id,"linkIconRadioList",a.value));d.add(b._createLabel(a.text,a.id))});for(f=1;f<8;f++)m.push("#anchor"+f.toString());j.add(b._createSelect(Hb,m));c.add(b._createSeparator());c.add(l);c.add(u);c.add(e);c.add(k);k.add(r);k.add(q);c.add(v);c.add(b._createSeparator());c.add(b._createOKCancelButtons());return c.render()},_getDialogRes_TagInspector:function(){var a=this,b=a._createDiv(s),f=a._createDiv(te),c=a._createDiv(Sd),e=a._createDiv(se),d=a._createDiv(zb);b.add(f);f.add(a._createSpan(ne,this.localizeString("tagInspectorDialogSelectedTag","Selected tag :")));f.add(a._createSpan(Nc,""));b.add(c);c.add(a._createCheckbox("displayNoEmpty"));c.add(a._createLabel(this.localizeString("tagInspectorDialogDisplayNotEmptyAttributes","Display not empty attributes only"),"displayNoEmpty"));b.add(e);e.add(a._createSpan(g,this.localizeString("tagInspectorDialogAttributes","Attributes:")));e.add(a._createDiv(Q));b.add(d);d.add(a._createSpan(g,this.localizeString("tagInspectorDialogInnerHTML","Inner HTML:")));d.add(a._createElement("textarea"));b.add(a._createTextField(this.localizeString("tagInspectorDialogCSSText","Css Text:"),Lb));b.add(a._createSeparator());b.add(a._createOKCancelButtons());return b.render()},_getDialogRes_Color:function(){return this._getDialogRes_CommonColor("#FFFFFF")},_getDialogRes_ForeColor:function(){return this._getDialogRes_CommonColor("#000000")},_getDialogRes_BackColor:function(){return this._getDialogRes_CommonColor("#FFFFFF")},_getDialogRes_CommonColor:function(d){var a=this,b=a._createDiv(kc),c=a._createDiv(B);b.add(a._createDiv(Eb));b.add(c);c.add(a._createSpan(g,this.localizeString("backColorDialogSelectedColor","Selected Color:")));c.add(a._createElement("input",{type:"text",value:d}));b.add(a._createSeparator());b.add(a._createOKCancelButtons());return b.render()},_getDialogRes_Table:function(){var a=this,b=a._createDiv(p),c=a._createDiv(E);b.add(a._createTextField(this.localizeString("tableDialogRows","Rows :"),Kb,"",3));b.add(a._createTextField(this.localizeString("tableDialogColumns","Columns :"),Cb,"",3));b.add(a._createTextField(this.localizeString("tableDialogTableWidth","Table Width :"),Ib,this.localizeString("tableDialogPixels","pixels"),200));b.add(a._createTextField(this.localizeString("tableDialogTableHeight","Table Height :"),Gb,this.localizeString("tableDialogPixels","pixels"),200));b.add(a._createTextField(this.localizeString("tableDialogBorder","Border thickness:"),Fb));b.add(a._createTextField(this.localizeString("tableDialogCellPadding","Cell Padding :"),xb));b.add(a._createTextField(this.localizeString("tableDialogCellSpacing","Cell Spacing :"),yb));b.add(a._createTextField(this.localizeString("tableDialogCssText","Css Text :"),Db));b.add(c);c.add(a._createSpan(g,this.localizeString("tableDialogBackgroundColor","Background Color:")));c.add(a._createElement("input",{type:"text"}));c.add(a._createElement("input",{type:"button",value:"..."}));b.add(a._createSeparator());b.add(a._createOKCancelButtons());return b.render()},_getDialogRes_Preview:function(){var a=this,c=a._createDiv(o),b=a._createDiv(ee),e=a._createDiv(w),d=a._createDiv(vb),f=a._createDiv(Od);c.add(b);b.add(a._createSpan(g,this.localizeString("previewDialogPreviewSize","Preview Size:")));b.add(a._createElement("input",{id:"rad640_480",name:"preview",type:"radio",checked:"checked"}));b.add(a._createLabel("640x480","rad640_480"));b.add(a._createElement("input",{id:"rad800_600",name:"preview",type:"radio"}));b.add(a._createLabel("800x600","rad800_600"));b.add(a._createElement("input",{id:"rad1024_768",name:"preview",type:"radio"}));b.add(a._createLabel("1024x768","rad1024_768"));b.add(a._createElement("input",{id:"chkSplit",type:"checkbox",checked:"checked"}));b.add(a._createLabel(this.localizeString("previewDialogSplit","Split pages"),"chkSplit"));c.add(a._createSeparator());c.add(e);e.add(a._createInputButton(n+" "+Gc,this.localizeString("previewDialogPrintAll","Print All")));e.add(a._createInputButton(n+" "+Hc,this.localizeString("previewDialogPrintPage","Print Page")));e.add(a._createInputButton(n+" "+cd,this.localizeString("dialogOK","OK")));c.add(a._createSeparator());c.add(d);d.add(a._createElement("a",this.localizeString("previewDialogPrevPage","Prev page"),{"class":Wc,href:"#"}));d.add(a._createElement("span","1 / 1"));d.add(a._createElement("a",this.localizeString("previewDialogNextPage","Next page"),{"class":Vc,href:"#"}));c.add(a._createDiv(Ac));c.add(f);f.add(a._createElement("iframe",{src:"about:blank"}));return c.render()},_getDialogRes_CleanUp:function(){var b=this,c=b._createDiv(cb),e=b._createDiv(de),f=b._createDiv(Vd),d=b._createDiv(ce),h=[{id:"replaceSpans",label:this.localizeString("cleanUpDialogStripSpanTag","Strip SPAN tag")},{id:"replaceClass",label:this.localizeString("cleanUpDialogStripClass","Strip CLASS tag")},{id:"replaceStyle",label:this.localizeString("cleanUpDialogStripStyle","Strip STYLE attribute")},{id:"replaceNbsp",label:this.localizeString("cleanUpDialogReplaceSymbol","Replace &amp;nbsp; symbol")},{id:"transformPtoDiv",label:this.localizeString("cleanUpDialogTransformParagraphToDIV","Transform Paragraph to DIV")}];c.add(e);e.add(b._createSpan(g,this.localizeString("cleanUpDialogDocumentSource","Document source :")));c.add(f);f.add(b._createElement("textarea",{readonly:"readonly"}));c.add(d);a.each(h,function(c,a){d.add(b._createCheckbox(a.id));d.add(b._createLabel(a.label,a.id))});c.add(b._createSeparator());c.add(b._createOKCancelButtons());return c.render()},_getDialogRes_FindAndReplace:function(){var a=this,b=a._createDiv(nc),e=a._createDiv(ef),d=a._createDiv(Ee),c=a._createDiv(w);b.add(e);e.add(a._createSpan(g,this.localizeString("findAndReplaceFind","Find:")));e.add(a._createElement("textarea","text"));b.add(d);d.add(a._createSpan(g,this.localizeString("findAndReplaceReplace","Replace:")));d.add(a._createElement("textarea"));b.add(a._createSeparator());b.add(c);c.add(a._createInputButton(n,this.localizeString("findAndReplaceFindButton","Find")));c.add(a._createInputButton(n,this.localizeString("findAndReplaceReplaceButton","Replace")));return b.render()},_getDialogRes_Media:function(){var a=this,b=a._createDiv(P),c=a._createDiv(We);b.add(c);c.add(a._createSpan(g,this.localizeString("mediaDialogMediaType","Media Type :")));c.add(a._createSelect("",["flash","video","applet","other"]));b.add(a._createTextField(this.localizeString("mediaDialogMediaUrl","Media Url :"),fd));b.add(a._createTextField(this.localizeString("mediaDialogWidth","Width :"),ad,this.localizeString("dialogPixel","px"),200));b.add(a._createTextField(this.localizeString("mediaDialogHeight","Height :"),Uc,this.localizeString("dialogPixel","px"),200));b.add(a._createSeparator());b.add(a._createOKCancelButtons());return b.render()},_getDialogRes_SpecialCharacter:function(){var b=this,c=b._createDiv(r),e=b._createDiv(Ud),m=b._createDiv(Qd),l=b._createDiv(Bc),d=b._createDiv(be),f=b._createDiv(wb,"Punctuation"),i=b._createDiv(Md),p=["&#8211;","&#8212;","&iexcl;","&iquest;","&quot;","&laquo;","&raquo;","&nbsp;"],h=b._createDiv(wb,"Symbols"),o=b._createDiv(Rd),s=["&amp;","&cent;","&copy;","&divide;","&gt;","&lt;","&micro;","&#8226;","&para;","&plusmn;","&#8364;","&pound;","&reg;","&sect;","&yen;"],g=b._createDiv(wb,"Diacritics"),j=b._createDiv(Nd),q=["&aacute;","&Aacute;","&agrave;","&Agrave;","&acirc;","&Acirc;","&aring;","&Aring;","&atilde;","&Atilde;","&auml;","&Auml;","&aelig;","&AElig;","&ccedil;","&Ccedil;","&eacute;","&Eacute;","&egrave;","&Egrave;","&ecirc;","&Ecirc;","&euml;","&Euml;","&iacute;","&Iacute;","&igrave;","&Igrave;","&icirc;","&Icirc;","&iuml;","&Iuml;","&ntilde;","&Ntilde;","&oacute;","&Oacute;","&ograve;","&Ograve;","&ocirc;","&Ocirc;","&oslash;","&Oslash;","&otilde;","&Otilde;","&ouml;","&Ouml;","&uacute;","&Uacute;","&ugrave;","&Ugrave;","&ucirc;","&Ucirc;","&uuml;","&Uuml;","&szlig;","&yuml;","&#8216;","&#8217;"],k=b._createDiv(w);c.add(e);e.add(m);m.add(l);l.add(new kb("span"));e.add(d);d.add(f);f.add(i);a.each(p,function(c,a){i.add(b._createLabel(a))});d.add(h);h.add(o);a.each(s,function(c,a){o.add(b._createLabel(a))});d.add(g);g.add(j);a.each(q,function(c,a){j.add(b._createLabel(a))});c.add(b._createSeparator());k.add(b._createInputButton(n,"Cancel"));c.add(k);return c.render()},_copyFromClipboard:function(){var d,c,b={},e={};if(j.clipboardData)return j.clipboardData.getData("Text");else if(a.browser.mozilla){try{netscape.security.PrivilegeManager.enablePrivilege&&netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect")}catch(f){}d=Components.classes["@mozilla.org/widget/clipboard;1"].getService(Components.interfaces.nsIClipboard);if(!d)return false;c=Components.classes["@mozilla.org/widget/transferable;1"].createInstance(Components.interfaces.nsITransferable);if(!c)return false;c.addDataFlavor("text/unicode");d.getData(c,d.kGlobalClipboard);c.getTransferData("text/unicode",b,e);if(b)b=b.value.QueryInterface(Components.interfaces.nsISupportsString);return b?b.data.substring(0,e.value/2):""}},_copyToClipboard:function(e){var f,d,g,b={},h={};if(j.clipboardData&&e)j.clipboardData.setData("Text",e);else if(a.browser.mozilla)try{netscape.security.PrivilegeManager.enablePrivilege&&netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");f=Components.classes["@mozilla.org/widget/clipboard;1"].createInstance(Components.interfaces.nsIClipboard);if(!f)return;d=Components.classes["@mozilla.org/widget/transferable;1"].createInstance(Components.interfaces.nsITransferable);if(!d)return;d.addDataFlavor("text/unicode");b={};h={};b=Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);b.data=e;d.setTransferData("text/unicode",b,e.length*2);g=Components.interfaces.nsIClipboard;if(!f)return false;f.setData(d,null,g.kGlobalClipboard)}catch(i){b="Copy text to Clipboard \n";b+="If you are using firefox please do the following :\n ";b+="1. Write in your url box : 'about:config'\n";b+="2. Change signed.applets.codebase_principal_support = true\n";c(this.localizeString("errorMessageCopyToClipboardError",b))}},fixAbsoluteUrlsIfNeeded:function(o){for(var g=this,n=zc.URL,b=zc.URL,f=zc.URL,i=false,p=b.length,a=o,d,j,k,c,l,m,h,e=p-1;e>0;e--){d=b.charAt(e);j=b.charAt(e-1);if(d==="/"||d==="\\"){if(d===j)break;f=b.substring(0,e)+d;if(!i){b=f;i=true}}}k=g._prepareLiteralRegexText(n+"?");c=new RegExp(k,"g");a=a.replace(c,"?");l=g._prepareLiteralRegexText(b);c=new RegExp(l,"g");a=a.replace(c,"");m=g._prepareLiteralRegexText(f);c=new RegExp(m,"g");a=a.replace(c,"/");h=a.indexOf("#");if(h>-1)a=a.substr(h);return a},_insertCell:function(c,b){var a=c.insertCell(b);a.innerHTML="&nbsp;";return a},_getDictionaryDeclare:function(){var a={};a.a=["accesskey","charset","class","coords","dir","href","hreflang","id","lang","name","rel","rev","shape","tabindex","target","title"];a.b=["class","dir","id","lang","title"];a.body=["alink","background","bgColor","bgproperties","bottommargin","class","dir","id","lang","leftmargin","link","marginheight","marginwidth","rightmargin","text","title","topmargin","vlink"];a.button=["accesskey","class","dir","disabled","id","lang","name","tabindex","title","type","value"];a.code=["class","dir","id","lang","title"];a.div=["align","class","dir","id","lang","title"];a.em=["class","dir","id","lang","title"];a.font=["class","color","dir","face","id","lang","pointsize","size","title"];a.form=["action","class","dir","enctype","id","lang","method","name","runat","target","title"];a.hr=["align","class","color","id","noshade","size","title","width"];a.i=["class","dir","id","lang","title"];a.img=["align","alt","border","class","controls","dir","dynsrc","height","hspace","id","ismap","lang","longdesc","loop","lowsrc","name","src","start","title","usemap","vspace","width"];a.input=["accept","accesskey","align","alt","border","checked","class","dir","disabled","height","hspace","id","lang","maxlength","name","readonly","size","src","tabindex","title","type","usemap","value","vspace","width"];a.label=["accesskey","class","dir","for","id","lang","title"];a.li=["class","dir","id","lang","title","type","value"];a.ol=["class","compact","dir","id","lang","start","title","type"];a.option=["class","dir","disabled","id","label","lang","selected","title","value"];a.p=["align","class","dir","id","lang","title"];a.span=["class","dir","id","lang","title"];a.strong=["class","dir","id","lang","title"];a.select=["accesskey","class","dir","disabled","id","lang","multiple","name","size","tabindex","title"];a.table=["align","background","bgColor","border","bordercolor","bordercolordark","bordercolorlight","cellpadding","cellspacing","class","cols","datapagesize","dir","frame","height","hspace","id","lang","rules","summary","title","vspace","width"];a.td=["abbr","align","axis","background","bgColor","bordercolor","bordercolordark","bordercolorlight","class","colspan","dir","headers","height","id","lang","nowrap","rowspan","scope","title","valign","width"];a.th=["abbr","align","axis","background","bgColor","bordercolor","bordercolordark","bordercolorlight","class","colspan","dir","headers","height","id","lang","nowrap","rowspan","scope","title","valign","width"];a.tr=["align","bgColor","bordercolor","bordercolordark","bordercolorlight","class","dir","height","id","lang","nowrap","title","valign"];a.tbody=["align","bgColor","class","dir","id","lang","title","valign"];a.textarea=["accesskey","class","cols","dir","disabled","id","label","lang","name","readonly","rows","tabindex","title","wrap"];a.u=["class","id","xml:lang"];a.ul=["class","compact","dir","id","lang","title","type"];return a},_getParentElement:function(e){var h=this,a=h._getRange(e),b,f,g,c,d;if(!a)return null;if(a.commonAncestorContainer){b=e.getSelection();f=a.startContainer||b.baseNode;g=a.endContainer||b.extentNode;c=a.startOffset;if(c===null)c=b.baseOffset;d=a.endOffset;if(d===null)d=b.extentOffset;return f===g&&d-c===1?b.anchorNode.childNodes[b.anchorOffset]:!a.commonAncestorContainer.tagName?e.document===a.commonAncestorContainer&&b.baseNode?b.baseNode.parentNode:a.commonAncestorContainer.parentNode:a.commonAncestorContainer}return a.length?a.item(0):a.parentElement?a.parentElement():null},_getRange:function(a){var b,c;if(a.document.selection&&!j.opera)return a.document.selection.createRange();if(a.getSelection){b=a.getSelection();if(!b||b.rangeCount<1)return null;if(b.getRangeAt)c=b.getRangeAt(0);else c=a.document.createRange();return c}},_generateUniqueName:function(b){var a=Id[b];if(!a)a=0;Id[b]=++a;return b+a},_setContentEditable:function(b,d){var c="designMode",e="contentEditable";try{if(b.body[e])b.body[e]=d.toString();if(b[c])if(!d&&b[c]!=="off")b[c]="off";else if(d&&b[c]!=="on")b[c]="on";d&&!a.browser.msie&&b.execCommand("useCSS",false,true)}catch(f){}},_formatString:function(a,d){for(var c=a.length,b=0;b<d-c;b++)a="0"+a;return a},_convertToWebColor:function(c,b,a){var d=this,i,h,g,f;if(isNaN(c)||255-c<0)c=0;if(isNaN(b)||255-b<0)b=0;if(isNaN(a)||255-a<0)a=0;i=d._formatString(e(c).toString(16),2);h=d._formatString(e(b).toString(16),2);g=d._formatString(e(a).toString(16),2);f="#"+i+h+g;return f},_prepareLiteralRegexText:function(b){var a=b;a=a.replace("\\","\\\\");a=a.replace(".","\\.");a=a.replace("?","\\?");return a},_isNumeric:function(a){return new RegExp("^\\d+$").test(a)},_isEmail:function(a){return new RegExp("mailto:(\\S)+[@]{1}(\\S)+[.]{1}(\\w)+").test(a)},_isUrl:function(a){return new RegExp("[a-zA-z]+://[^s]+").test(a)},refresh:function(){var a=this,c=a.element,f=a._getHeader(),e=a._getFooter(),h=c.width(),g=c.height(),d=a._getContent(),b;a.editor.width(h).height(g);this.$ribbon.wijribbon("updateRibbonSize");b=a.editor.height()-f.outerHeight(true)-e.outerHeight(true);d.height(b).wijsplitter("refresh")},getText:function(){var a=this;return a._getDesignViewText()},setText:function(a){var b=this;a&&b._setDesignViewText(a)},localizeString:function(b,c){var a=this.options;return a.localization&&a.localization[b]?a.localization[b]:c}})})(jQuery);(function(a){"use strict";var d=document,b=parseInt,c="wijmo-wijeditor",e=c+"-colorcanvas",g=c+"-color",h=c+"-wheel",i=c+"-overlay",f=c+"-marker";a.fn.wijeditorcolorcanvas=function(c,b){a.wijeditorcolorcanvas(this,c,b);return this};a.wijeditorcolorcanvas=function(c,e,d){var b=a(c).get(0);return b.wijeditorcolorcanvas||(b.wijeditorcolorcanvas=new a._wijeditorcolorcanvas(b,e,d))};a._wijeditorcolorcanvas=function(l,n,o){var c=this,j="",k,m;m="progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true, sizingMethod=crop, ";j+="<div class='"+e+"'>";j+="<div class='"+g+"'></div>";j+="<div class='"+h+"'></div>";j+="<div class='"+i+"'></div>";j+="<div class='h-marker "+f+"'></div>";j+="<div class='sl-marker "+f+"'></div></div>";a(l).html(j);k=a("."+e,l);c.wheel=a("."+h,l).get(0);c.radius=84;c.square=100;c.width=194;a.browser.msie&&a.browser.version<7&&a("*",k).each(function(){var c=this,b=c.currentStyle.backgroundImage;if(b!=="none"){b=b.substring(5,b.length-2);a(c).css({backgroundImage:"none",filter:m+"src='"+b+"')"})}});c.linkTo=function(b){typeof c.callback==="object"&&a(c.callback).unbind("keyup",c.updateValue);c.color=null;if(typeof b==="function")c.callback=b;else if(typeof b==="object"||typeof b==="string"){c.callback=a(b);c.callback.bind("keyup",c.updateValue);c.callback.get(0).value&&c.setColor(c.callback.get(0).value)}return this};c.updateValue=function(){var a=this;a.value&&a.value!==c.color&&c.setColor(a.value)};c.setColor=function(a){var b=c.unpack(a);if(c.color!==a&&b){c.color=a;c.rgb=b;c.hsl=c.RGBToHSL(c.rgb);c.updateDisplay()}return this};c.setHSL=function(a){c.hsl=a;c.rgb=c.HSLToRGB(a);c.color=c.pack(c.rgb);c.updateDisplay();return this};c.widgetCoords=function(b){var f,g,h,e,d;h=b.target||b.srcElement;e=c.wheel;d=c.absolutePosition(e);f=(b.pageX||0*(b.clientX+a("html").get(0).scrollLeft))-d.x;g=(b.pageY||0*(b.clientY+a("html").get(0).scrollTop))-d.y;return{x:f-c.width/2,y:g-c.width/2}};c.mousedown=function(b){if(!d.dragging){a(d).bind("mousemove",c.mousemove).bind("mouseup",c.mouseup);d.dragging=true}var e=c.widgetCoords(b);c.circleDrag=Math.max(Math.abs(e.x),Math.abs(e.y))*2>c.square;c.mousemove(b);return false};c.mousemove=function(f){var b=c.widgetCoords(f),a,e,d;if(c.circleDrag){a=Math.atan2(b.x,-b.y)/6.28;if(a<0)a+=1;c.setHSL([a,c.hsl[1],c.hsl[2]])}else{e=Math.max(0,Math.min(1,-(b.x/c.square)+.5));d=Math.max(0,Math.min(1,-(b.y/c.square)+.5));c.setHSL([c.hsl[0],e,d])}return false};c.mouseup=function(){a(d).unbind("mousemove",c.mousemove).unbind("mouseup",c.mouseup);d.dragging=false};c.updateDisplay=function(){var d=c.hsl[0]*6.28,b;a(".h-marker",k).css({left:Math.round(Math.sin(d)*c.radius+c.width/2)+"px",top:Math.round(-Math.cos(d)*c.radius+c.width/2)+"px"});a(".sl-marker",k).css({left:Math.round(c.square*(.5-c.hsl[1])+c.width/2)+"px",top:Math.round(c.square*(.5-c.hsl[2])+c.width/2)+"px"});a("."+g,k).css("backgroundColor",c.pack(c.HSLToRGB([c.hsl[0],1,.5])));if(typeof c.callback==="object"){a(c.callback).css({backgroundColor:c.color,color:c.hsl[2]>.5?"#000":"#fff"});a(c.callback).each(function(){b=this;if(b.value&&b.value!==c.color)b.value=c.color})}else typeof c.callback==="function"&&c.callback.call(c,c.color)};c.absolutePosition=function(a){var d={x:a.offsetLeft,y:a.offsetTop},b;if(a.offsetParent){b=c.absolutePosition(a.offsetParent);d.x+=b.x;d.y+=b.y}return d};c.pack=function(a){var d=Math.round(a[0]*255),c,b;c=Math.round(a[1]*255);b=Math.round(a[2]*255);return"#"+(d<16?"0":"")+d.toString(16)+(c<16?"0":"")+c.toString(16)+(b<16?"0":"")+b.toString(16)};c.unpack=function(a){return a.length===7?[b("0x"+a.substring(1,3))/255,b("0x"+a.substring(3,5))/255,b("0x"+a.substring(5,7))/255]:a.length===4?[b("0x"+a.substring(1,2))/15,b("0x"+a.substring(2,3))/15,b("0x"+a.substring(3,4))/15]:void 0};c.HSLToRGB=function(g){var c,b,d,e,a,f=this;d=g[0];e=g[1];a=g[2];b=a<=.5?a*(e+1):a+e-a*e;c=a*2-b;return[f.hueToRGB(c,b,d+.33333),f.hueToRGB(c,b,d),f.hueToRGB(c,b,d-.33333)]};c.hueToRGB=function(b,c,a){a=a<0?a+1:a>1?a-1:a;return a*6<1?b+(c-b)*a*6:a*2<1?c:a*3<2?b+(c-b)*(.66666-a)*6:b};c.RGBToHSL=function(i){var h,a,f,g,j,d,e,c,b;e=i[0];c=i[1];b=i[2];h=Math.min(e,Math.min(c,b));a=Math.max(e,Math.max(c,b));f=a-h;d=(h+a)/2;j=0;if(d>0&&d<1)j=f/(d<.5?2*d:2-2*d);g=0;if(f>0){if(a===e&&a!==c)g+=(c-b)/f;if(a===c&&a!==b)g+=2+(b-e)/f;if(a===b&&a!==e)g+=4+(e-c)/f;g/=6}return[g,j,d]};a("*",k).mousedown(c.mousedown);c.setColor(o||"#000000");n&&c.linkTo(n)}})(jQuery);
(function(a){"use strict";var j="wijmo-wijrating",h="wijmo-wijrating-starcontainer",c="wijmo-wijrating-reset",l="ui-corner-all",k="ui-state-default",i="ui-state-hover",g="wijmo-wijrating-resethover",m="wijmo-wijrating-star",b="wijmo-wijrating-normal",d="wijmo-wijrating-hover",e="wijmo-wijrating-rated",f="wijmo-wijrating-vertical";a.widget("wijmo.wijrating",{options:{disabled:false,count:5,split:1,totalValue:5,value:0,min:null,max:null,resetButton:{disabled:false,hint:"cancel this rating!",position:"leftOrTop",customizedClass:"",customizedHoverClass:""},hint:{disabled:false,content:null},orientation:"horizontal",direction:"normal",ratingMode:"continuous",icons:{iconsClass:null,hoverIconsClass:null,ratedIconsClass:null},iconWidth:16,iconHeight:16,animation:null,rating:null,rated:null,reset:null,hover:null},_setOption:function(g,e){var i=this,d=i.options,j=a("."+c,i.ratingElement[0]),k=a("."+h,i.ratingElement[0]),l=a("."+b,i.ratingElement[0]);if(a.isPlainObject(d[g])){switch(g){case"resetButton":if(typeof e.disabled!=="undefined")if(e.disabled!==d[g].disabled)if(e.disabled){j.hide();j.attr("aria-hidden",true)}else if(!d.disabled){j.show();j.attr("aria-hidden",false)}if(typeof e.hint!=="undefined")if(e.hint!==d[g].hint)if(e.hint===null)j.attr("title","");else j.attr("title",e.hint);if(e.position&&e.position.length)if(e.position!==d[g].position)if(e.position==="rightOrBottom")j.parent().append(j);else j.parent().prepend(j);if(typeof e.customizedClass!=="undefined")if(e.customizedClass!==d[g].customizedClass){d[g].customizedClass.length&&j.removeClass(d[g].customizedClass);e.customizedClass.length&&j.addClass(e.customizedClass)}break;case"hint":if(typeof e.disabled!=="undefined")if(e.disabled!==d[g].disabled)if(e.disabled)l.removeAttr("title");else i._resetHint(d.hint.content);if(typeof e.content!=="undefined")if(e.content!==d[g].content)!d[g].disabled&&i._resetHint(e.content);break;case"icons":if(typeof e.iconsClass!=="undefined"){d[g].iconsClass&&d[g].iconsClass.length&&i._removeCustomizedIconsClass(d[g].iconsClass);i._addCustomizedIconsClass(e.iconsClass,d.split)}if(typeof e.hoverIconsClass!=="undefined")d[g].hoverIconsClass&&d[g].hoverIconsClass.length&&i._removeCustomizedIconsClass(d[g].hoverIconsClass);if(typeof e.ratedIconsClass!=="undefined"){d[g].ratedIconsClass&&d[g].ratedIconsClass.length&&i._removeCustomizedIconsClass(d[g].ratedIconsClass);i._resetValue(d.value,d.ratingMode,e.ratedIconsClass)}}a.extend(true,d[g],e)}else{if(e===d[g])return;switch(g){case"disabled":if(e){i._unbindLiveEvents();j.hide();j.attr("aria-hidden",true)}else{i._bindLiveEvents();if(!d.resetButton.disabled){j.show();j.attr("aria-hidden",false)}}break;case"count":i._createStars(d.split,e,k);break;case"split":i._createStars(e,d.count,k);break;case"totalValue":i._resetTotalValue(e);break;case"orientation":if(e==="vertical")i.ratingElement.addClass(f);else i.ratingElement.removeClass(f);if(d.split>1){d[g]=e;i._createStars(d.split,d.count,k)}break;case"direction":d[g]=e;i._createStars(d.split,d.count,k);break;case"ratingMode":i._resetValue(d.value,e,d.icons.ratedIconsClass);break;case"value":if(d.min&&e<d.min)return;if(d.max&&e>d.max)return;i._resetValue(e,d.ratingMode,d.icons.ratedIconsClass);break;case"iconWidth":d[g]=e;i._createStars(d.split,d.count,k);break;case"iconHeight":d[g]=e;i._createStars(d.split,d.count,k)}a.Widget.prototype._setOption.apply(i,arguments)}},_create:function(){var b=this,d=b.options,c;if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);if(b.element.is("select")){b._parseSelect();b.element.hide();c=a("<div></div>");b.element.after(c)}else if(b.element.is("div"))if(b.element.children("input[type='radio']").length>0){b._parseRadio();b.element.hide();c=a("<div></div>");b.element.after(c)}else c=b.element;else return;b.ratingElement=c;b._createRating();!d.disabled&&b._bindLiveEvents()},destroy:function(){var b=this;b._unbindLiveEvents();if(b.element!==b.ratingElement){b.ratingElement.remove();b.element.show()}else{b.element.removeClass("ui-widget");b.element.removeClass(j);b.element.removeClass(f);b.element.empty()}a.Widget.prototype.destroy.apply(b,arguments)},_unbindLiveEvents:function(){a("."+b,this.ratingElement[0]).die("wijrating").die(".wijrating");a("."+c,this.ratingElement[0]).die("wijrating").die(".wijrating")},_bindLiveEvents:function(){var f=this,e=f.options,j="."+b,m="."+c,h,l={element:f.ratingElement,mouseover:function(c){var b=a(c.target),g=a(j,f.ratingElement[0]);if(b.is(j)){g.removeClass(d);b.addClass(d);if(e.ratingMode==="continuous")if(e.direction==="reversed")b.parent().nextAll().children().addClass(d);else b.parent().prevAll().children().addClass(d);f._addCustomizedHoverIconsClass(e.icons.hoverIconsClass,e.split,b);h={value:parseFloat(b.html()),target:b};f._trigger("hover",c,h)}},mouseout:function(g){var c=a(g.target),b=a(j,f.ratingElement[0]);if(c.is(j)){b.removeClass(d);f._removeCustomizedIconsClass(e.icons.hoverIconsClass)}},click:function(c){var k=a(c.target),b=parseFloat(k.html()),g=a(j,f.ratingElement[0]),m=a.extend({duration:500,easing:null,delay:250},e.animation),l=a.wijmo.wijrating.animations,i=m.animated;if(!k.is(j))return;if(e.max&&b>e.max)return;if(e.min&&b<e.min)return;h={oldValue:e.value,newValue:b,target:k};if(f._trigger("rating",c,h)===false)return false;e.value=b;f._resetValue(b,e.ratingMode,e.icons.ratedIconsClass);g.removeClass(d);f._removeCustomizedIconsClass(e.icons.hoverIconsClass);h={value:b,target:k};if(i)if(l&&l[i])l[i](e,g,function(){f._trigger("rated",c,h)});else if(a.effects&&a.effects[i])f._playJqueryAnimation(m,g,function(){a.browser.msie&&a.browser.version<9&&g.css("filter","");f._trigger("rated",c,h)});else f._trigger("rated",c,h);else f._trigger("rated",c,h)}},k={element:f.ratingElement,mouseover:function(d){var b=a(d.target);b=b.closest("."+c);b.addClass(g);b.addClass(i);e.resetButton.customizedHoverClass&&e.resetButton.customizedHoverClass.length&&b.addClass(e.resetButton.customizedHoverClass)},mouseout:function(d){var b=a(d.target);b=b.closest("."+c);b.removeClass(g);b.removeClass(i);e.resetButton.customizedHoverClass&&e.resetButton.customizedHoverClass.length&&b.removeClass(e.resetButton.customizedHoverClass)},click:function(b){var c=a(b.target);f._setOption("value",0);h={target:c};f._trigger("reset",b,h)}};a(j,this.ratingElement[0]).live("mouseover.wijrating",a.proxy(l.mouseover,l)).live("mouseout.wijrating",a.proxy(l.mouseout,l)).live("click.wijrating",a.proxy(l.click,l));a(m,this.ratingElement[0]).live("mouseover.wijrating",a.proxy(k.mouseover,k)).live("mouseout.wijrating",a.proxy(k.mouseout,k)).live("click.wijrating",a.proxy(k.click,k))},_clearIntentTimer:function(){var b=this;b.intentTimers&&b.intentTimers.length&&a.each(b.intentTimers,function(b,a){if(a){window.clearTimeout(a);a=null}});b.intentTimers=[]},_playJqueryAnimation:function(b,c,e){var d=this,h=d.options,f={easing:b.easing},g=b.animated;d._clearIntentTimer();c.each(function(j,l){var k=Math.floor(j/h.split)*b.delay,i;i=window.setTimeout(function(){a(l).hide(g,f,b.duration,function(){if(j!==c.length-1)return;c.each(function(j,l){var k=Math.floor(j/h.split)*b.delay,i;i=window.setTimeout(function(){a(l).show(g,f,b.duration,function(){if(j===c.length-1)e&&a.isFunction(e)&&e.call(this)})},k);d.intentTimers.push(i)})})},k);d.intentTimers.push(i)})},_addCustomizedIconsClass:function(c,h){var g=this,f,e=0,d=0;if(c&&c.length){f=a("."+b,g.ratingElement[0]);f.each(function(i,b){if(e===h){e=0;d++}if(typeof c==="string")a(b).addClass(c);else if(a.isArray(c)){var f=c.length;if(d<f)if(g.options.direction==="reversed")a(b).addClass(c[f-d-1]);else a(b).addClass(c[d])}e++})}},_addCustomizedHoverIconsClass:function(c,j,g){var l=this,m=l.options,i=m.direction,k=m.ratingMode,f=a("."+b,l.ratingElement[0]),h=f.index(g),e=0,d;if(c&&c.length)if(typeof c==="string"){g.addClass(c);if(k!=="single")if(i==="reversed")g.parent().nextAll().children().addClass(c);else g.parent().prevAll().children().addClass(c)}else if(a.isArray(c))if(k==="single"){if(i==="reversed")d=f.length-1-h;else d=h;e=Math.floor(d/j);c.length>e&&g.addClass(c[e])}else if(i==="reversed")for(d=f.length-1;d>=h;d--){e=Math.floor((f.length-1-d)/j);c.length>e&&a(f[d]).addClass(c[e])}else for(d=0;d<=h;d++){e=Math.floor(d/j);c.length>e&&a(f[d]).addClass(c[e])}},_removeCustomizedIconsClass:function(c){var e=this,d=a("."+b,e.ratingElement[0]);if(c&&c.length)if(typeof c==="string")d.removeClass(c);else a.isArray(c)&&a.each(c,function(b,a){d.removeClass(a)})},_resetValue:function(j,l,c){var k=this,g=k.options,i=a("."+b,k.ratingElement[0]),m=l||g.ratingMode,h=c&&c.length,f=0,d;i.each(function(k,n){var b=a(n),l=parseFloat(b.html());b.removeClass(e);b.parent().attr("aria-checked",false);if(h)if(typeof c==="string"){b.removeClass(c);d=c}else if(a.isArray(c)){a.each(c,function(c,a){b.removeClass(a)});if(g.direction==="reversed")f=Math.floor((i.length-1-k)/g.split);else f=Math.floor(k/g.split);if(c.length>f)d=c[f]}if(l===j){b.addClass(e);h&&b.addClass(d);b.parent().attr("aria-checked",true)}else if(m==="continuous")if(l<j){b.addClass(e);h&&b.addClass(d)}})},_resetTotalValue:function(l){var j=this,g=j.options,d=g.hint,i=a("."+b,j.ratingElement[0]),h=i.length,e,k,f,c=0;for(c;c<h;c++){f=Math.round((c+1)*l*100/h)/100;e=a(i[c]);k=parseFloat(e.html());if(k===g.value)g.value=f;e.html(f);if(d&&d.length&&d.length>=c&&d[c]&&d[c].length)e.attr("title",d[c]);else e.attr("title",f)}},_resetHint:function(d){var h=this,f=a("."+b,h.ratingElement[0]),e,g,c=0;for(c;c<f.length;c++){e=a(f[c]);g=parseFloat(e.html());if(d&&d.length&&d.length>=c&&d[c]&&d[c].length)e.attr("title",d[c]);else e.attr("title",g)}},_createRating:function(){var m=this,g=m.ratingElement,d=m.options,b,i,e;g.addClass(j+" ui-widget");d.orientation==="vertical"&&g.addClass(f);b=a("<div></div>");b.addClass(c);b.addClass(l);b.addClass(k);d.resetButton.customizedClass&&d.resetButton.customizedClass.length&&b.addClass(d.resetButton.customizedClass);b.appendTo(g);b.attr("role","button");b.attr("aria-label","reset");b.attr("aria-hidden",false);d.resetButton.hint&&d.resetButton.hint.length&&b.attr("title",d.resetButton.hint);if(d.resetButton.disabled||d.disabled){b.hide();b.attr("aria-hidden",true)}i=a("<span></span>");i.addClass("ui-icon ui-icon-close");b.append(i);e=a("<div></div>");e.attr("role","radiogroup");e.addClass(h);if(d.resetButton.position==="leftOrTop")e.appendTo(g);else e.prependTo(g);m._createStars(d.split,d.count,e)},_createStars:function(g,t,q){var u=this,c=u.options,k=c.hint,d,f,l,i=0,h=0,s=Math.ceil(c.iconWidth/g),r=Math.ceil(c.iconHeight/g),j=c.icons.ratedIconsClass,o,n,p=j&&j.length;q.empty();for(i;i<t*g;i++,h++){l=Math.round((i+1)*c.totalValue*100/t/g)/100;if(h===g)h=0;f=a("<div></div>");f.attr("role","radio");f.attr("aria-checked",false);if(c.orientation==="vertical"){f.width(c.iconWidth);f.height(r)}else{f.width(s);f.height(c.iconHeight)}f.addClass(m);d=a("<div>"+l+"</div>");d.addClass(b);d.width(c.iconWidth);d.height(c.iconHeight);f.attr("aria-label",l);if(h>0&&c.direction==="normal")if(c.orientation==="vertical")d.css({"margin-top":"-"+h*r+"px"});else d.css({"margin-left":"-"+h*s+"px"});else if(h<g-1&&c.direction==="reversed")if(c.orientation==="vertical")d.css({"margin-top":"-"+(g-1-h)*r+"px"});else d.css({"margin-left":"-"+(g-1-h)*s+"px"});if(!k.disabled)if(k.content&&k.content.length){if(i<=k.content.length){d.attr("title",k.content[i]);f.attr("aria-label",k.content[i])}}else d.attr("title",l);if(p)if(typeof j==="string")n=j;else if(a.isArray(j)){o=Math.floor(i/g);if(j.length>o)n=j[o]}if(l===c.value){d.addClass(e);p&&d.addClass(n);f.attr("aria-checked",true)}else if(l<c.value&&c.ratingMode==="continuous"){d.addClass(e);p&&d.addClass(n)}d.appendTo(f);if(c.direction==="reversed")f.prependTo(q);else f.appendTo(q)}u._addCustomizedIconsClass(c.icons.iconsClass,g)},_parseRadio:function(){var e=this,d=e.options,b=[],c=a("input[type='radio']",e.element);if(c.length){d.count=c.length;d.totalValue=c.length;c.each(function(i,h){var g=a(h),c=g.attr("id"),f;if(c&&c.length>0){f=a("label[for='"+c+"']",e.element);if(f.length)b.push(f.html());else b.push("")}else b.push("");if(g.is(":checked"))d.value=i+1});d.hint.content=b}},_parseSelect:function(){var e=this,c=e.options,d=[],b=a("option",e.element);if(b.length){c.count=b.length;c.totalValue=b.length;b.each(function(e,f){var b=a(f);d.push(b.html());if(b.is(":selected"))c.value=e+1});c.hint.content=d}}});a.extend(a.wijmo.wijrating,{animations:{scroll:function(i,c,b){var e=i,d=b,g=250,j=500,f=250,h=jQuery.makeArray(c);h.reverse();a.each(h,function(i,m){var l=Math.floor(i/e.split)*f,k={width:0},b,h;b=window.setTimeout(function(){a(m).animate(k,g,function(){window.clearTimeout(b);if(i!==c.length-1)return;h=window.setTimeout(function(){c.each(function(h,k){var j=Math.floor(h/e.split)*f,i={width:e.iconWidth},b;b=window.setTimeout(function(){a(k).animate(i,g,function(){window.clearTimeout(b);if(h===c.length-1)d&&a.isFunction(d)&&d.call(this)})},j)});window.clearTimeout(h)},j)})},l)});b&&a.isFunction(b)&&b.call(this)}}})})(jQuery);
(function(a){"use strict";if(!window.Raphael)return;a.widget("wijmo.wijscatterchart",a.wijmo.wijchartcore,{options:{animation:{enabled:true,duration:2e3,easing:">"},seriesTransition:{enabled:true,duration:2e3,easing:">"},zoomOnHover:true,mouseDown:null,mouseUp:null,mouseOver:null,mouseOut:null,mouseMove:null,click:null},_create:function(){var b=this;a.wijmo.wijchartcore.prototype._create.apply(b,arguments);b.chartElement.addClass("wijmo-wijscatterchart")},destroy:function(){var b=this;b.chartElement.removeClass("wijmo-wijscatterchart");a.wijmo.wijchartcore.prototype.destroy.apply(b,arguments)},getScatter:function(e,d){var h=this,f=h.chartElement.data("fields"),g,c,a,b;if(f&&f.chartElements){a=f.chartElements.scatters;if(a&&a.length){c=a.length;if(e<0||e>=c)return g;b=a[e];if(typeof d==="undefined")return b;c=b.length;if(b&&c)return d<0||d>=c?g:b[d]}return g}},_paintLegend:function(){var b=this,c=b.options,e=[].concat(c.seriesList),f=c.seriesStyles,d=0;a.extend(true,c,{legend:{size:{width:20,height:10}}});a.wijmo.wijchartcore.prototype._paintLegend.apply(b,arguments);if(c.legend.visible){b.legends.length&&b.legendIcons.length&&a.each(b.legendIcons,function(b,a){a.hide()});c.legend.reversed&&e.reverse();a.each(e,function(n,g){var k=g.markerType,m,j,o,p,q=c.legend.reversed?f[e.length-1-n]:f[n],i=a.extend(true,{},q),l=c.legend.textWidth?b.legends[d][0]:b.legends[d],h;if(i.stroke&&!i.fill)i.fill=i.stroke;if(g.legendEntry&&g.display!=="exclude"){if(g.data.x===undefined&&g.data.xy===undefined||g.data.y===undefined&&g.data.xy===undefined)return true;m=b.legendIcons[d];j=m.wijGetBBox();o=j.x+j.width/2;p=j.y+j.height/2;if(!k)k="circle";h=b.canvas.paintMarker(k,o,p,3);a.wijraphael.addClass(a(h.node),"wijchart-legend-dot wijchart-canvas-object wijchart-legend");h.attr(i);b.legendDots.push(h);a(h.node).data("legendIndex",a(l.node).data("legendIndex")).data("index",a(l.node).data("index"));b.legendEles.push(h);if(g.visible===false){a(l.node).data("dotOpacity",h.attr("opacity")||1);h.attr("opacity",.3)}d++}})}},_showSerieEles:function(b){a.each(b,function(b,a){a.show()})},_hideSerieEles:function(b){a.each(b,function(b,a){a.hide()})},_paintTooltip:function(){var c=this,d=c.chartElement,b=d.data("fields");a.wijmo.wijchartcore.prototype._paintTooltip.apply(this,arguments);if(c.tooltip)if(b&&b.chartElements&&b.chartElements.tooltipTars){c.tooltip.setTargets(b.chartElements.tooltipTars);c.tooltip.setOptions({mouseTrailing:false})}},_getTooltipText:function(d,c){var b=a(c).data("wijchartDataObj"),e={data:b,label:b.label,x:b.x,y:b.y,type:b.markerType,target:c,fmt:d};return a.proxy(d,e)()},_onBeforeTooltipShowing:function(f){var g=this,d=f.options,e=g.options.hint.style,b=f.target,h,c;if(b){if(a.browser.msie&&a.browser.version<9){h=a(b).data().wijchartDataObj;c=h.style;d.style.stroke=e.stroke||c.stroke||c.fill||"#ffffff"}else d.style.stroke=e.stroke||b.getAttribute("stroke")||b.getAttribute("fill")||"#ffffff";b.attrs={stroke:d.style.stroke}}a.wijmo.wijchartcore.prototype._onBeforeTooltipShowing.apply(g,arguments)},_clearChartElement:function(){var b=this,c=b.chartElement.data("fields");if(b.headerEles.length){a.each(b.headerEles,function(b,a){a.wijRemove();a=null});b.headerEles=[]}if(b.footerEles.length){a.each(b.footerEles,function(b,a){a.wijRemove();a=null});b.footerEles=[]}if(b.legendEles.length){a.each(b.legendEles,function(b,a){a.wijRemove();a=null});b.legendEles=[]}if(b.legends.length){a.each(b.legends,function(b,a){a.wijRemove();a=null});b.legends=[]}if(b.legendIcons.length){a.each(b.legendIcons,function(b,a){a.wijRemove();a=null});b.legendIcons=[]}if(b.legendDots.length){a.each(b.legendDots,function(b,a){a=null});b.legendDots=[]}if(b.axisEles.length){a.each(b.axisEles,function(b,a){a.wijRemove();a=null});b.axisEles=[]}if(b.chartLabelEles.length){a.each(b.chartLabelEles,function(b,a){a.wijRemove();a=null});b.chartLabelEles=[]}if(c&&c.chartElements){a.each(c.chartElements,function(d,b){b.length&&a.each(b,function(c,a){if(a[0]!==null){a.remove&&a.remove();b[c]=null}});c.chartElements[d]=null});c.chartElements={};a(c.clipRect.element).stop().remove();c.render.destroy();c.clipRect.destroy()}b.canvas.clear();b.innerState={}},_paintPlotArea:function(){var b=this,c=b.options;b.chartElement.wijscatter({bounds:b.canvasBounds,widgetName:b.widgetName,canvas:b.canvas,tooltip:b.tooltip,axis:c.axis,animation:c.animation,seriesTransition:c.seriesTransition,seriesList:c.seriesList,seriesStyles:c.seriesStyles,seriesHoverStyles:c.seriesHoverStyles,hint:c.hint,isXTime:b.axisInfo.x.isTime,isYTime:b.axisInfo.y[0].isTime,zoomOnHover:c.zoomOnHover,mouseDown:a.proxy(b._mouseDown,b),mouseUp:a.proxy(b._mouseUp,b),mouseOver:a.proxy(b._mouseOver,b),mouseOut:a.proxy(b._mouseOut,b),mouseMove:a.proxy(b._mouseMove,b),click:a.proxy(b._click,b)})}})})(jQuery);(function(a){"use strict";if(!window.Raphael)return;a.fn.extend({wijscatter:function(c){var b=this,g=c.bounds,z=g.endX-g.startX,x=g.endY-g.startY,C=c.axis.x.min,D=c.axis.y.min,A=c.axis.x.max,B=c.axis.y.max,i={minX:C,minY:D,maxX:A,maxY:B,width:z,height:x,kx:z/(A-C),ky:x/(B-D)},e=c.widgetName,M=c.canvas,j=c.animation,J=c.seriesList,k=c.seriesStyles,F=c.seriesHoverStyles,K=c.isXTime,L=c.isYTime,m=c.zoomOnHover,p=c.mouseDown,w=c.mouseUp,r=c.mouseOver,s=c.mouseOut,q=c.mouseMove,y=c.click,I=M.set(),t=[],l=[],o,f=b.data("fields")||{},v=b.css("background-color"),n=[],u=a.toOADate,h,d,E;if(b.find("svg").length>0)h=new a.chartRender(b.find("svg").get(0),b.width(),b.height());else h=new a.chartRender(b.children(":first").addClass("vmlcontainer").get(0),b.width(),b.height());d=h.clipRect(0,0,0,b.height());E=h.g().clip(d).add();f.render=h;f.clipRect=d;function H(){var c=a.isFunction;a(".wijscatterchart",b[0]).live("mousedown."+e,function(e){if(c(p)){var d=a(e.target).data("wijchartDataObj");if(!d)d=a(e.target.parentNode).data("wijchartDataObj");p.call(b,e,d)}}).live("mouseup."+e,function(e){if(c(w)){var d=a(e.target).data("wijchartDataObj");if(!d)d=a(e.target.parentNode).data("wijchartDataObj");w.call(b,e,d)}}).live("mouseover."+e,function(f){var d=a(f.target).data("wijchartDataObj"),g,h,e;if(!d)d=a(f.target.parentNode).data("wijchartDataObj");e=d.dot;if(m){g=d.seriesIndex;if(e.attr){h=a(true,{},F[g]);e.attr(h)}if(document.createElementNS)e.scale(1.5,1.5);else e.attr("stroke-width",5)}c(r)&&r.call(b,f,d)}).live("mouseout."+e,function(f){var d=a(f.target).data("wijchartDataObj"),g,e;if(!d)d=a(f.target.parentNode).data("wijchartDataObj");e=d.dot;if(m){g=d.seriesIndex;e.attr&&e.attr(a.extend(true,{},k[g]))}document.createElementNS&&e.scale(1,1);c(s)&&s.call(b,f,d)}).live("mousemove."+e,function(e){if(c(q)){var d=a(e.target).data("wijchartDataObj");if(!d)d=a(e.target.parentNode).data("wijchartDataObj");q.call(b,e,d)}}).live("click."+e,function(e){if(c(y)){var d=a(e.target).data("wijchartDataObj");if(!d)d=a(e.target.parentNode).data("wijchartDataObj");y.call(b,e,d)}})}function G(){a(".wijscatterchart",b).die(e).die("."+e)}a.each(J,function(p,c){var o=c.data,d,q=c.markerWidth||5,b=k[p],e=o.x,m=o.y,j=[],f=[];c=a.extend(true,{visible:true,markerType:"circle"},c);d=c.markerType;if(c.display==="exclude")return true;if(!b.fill&&b.stroke)b.fill=b.stroke;if(e===undefined)return true;a.each(m,function(o,r){var n=e[o],v=0,w=0,s,k,t={};if(K)n=u(n);if(L)r=u(r);if(typeof n==="undefined")return false;if(isNaN(n)||typeof n==="string")s=o;else s=n;v=g.startX+(s-i.minX)*i.kx;w=g.endY-(r-i.minY)*i.ky;if(b.opacity){b["fill-opacity"]=b.opacity;b["stroke-opacity"]=b.opacity;delete b.opacity}if(d==="cross"&&b["stroke-width"]!==undefined&&b["stroke-width"]===0)b["stroke-width"]=1;k=h.symbol(d,v,w,q).attr(b).add(E);k.attr({"class":"wijchart-canvas-object wijscatterchart"});t=a.extend(false,{dot:k,x:e[o],y:m[o],seriesIndex:p,index:o,markerType:d,type:"scatter",style:b},c);a(k.element).data("wijchartDataObj",t);j.push(k);l.push(a.extend({},k,{node:k.element}));f.push(k);c.visible===false&&k.hide()});t.push(j);n.push(f)});if(j.enabled){if(v==="transparent")v="white";if(d.getCSS)a(d.members[0].element).animate({width:b.width()},{duration:j.duration,step:function(c){d.width=c;var b=d.getCSS();a(this).css(b)}});else a(d.element).animate({width:b.width()},{duration:j.duration,step:function(a){d.attr("width",a)}})}else if(d.getCSS){a(d.members[0].element).css({width:b.width()});d.width=b.width();a(d.members[0].element).css(d.getCSS())}else{a(d.element).css({width:b.width()});d.attr("width",b.width())}G();H();o={animationSet:I,tooltipTars:l,scatters:t};if(!f.chartElements)f.chartElements={};f.seriesEles=n;a.extend(true,f.chartElements,o);b.data("fields",f)}})})(jQuery);(function(a){var c=document,t=a.each,u=a.browser.msie,h=c.documentMode===8,s="http://www.w3.org/2000/svg",D=!!c.createElementNS&&!!c.createElementNS(s,"svg").createSVGRect,C=0,g="div",A="absolute",n="hidden",j="scatterchart-",r="visible",p="visibility",w="px",v="none",e="M",b="L",l,o,q,y=/^r(?:\(([^,]+?)[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*,[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*([^\)]+?)\))?/,x=/^(\d{1,3})\-(?:((?:[a-zA-Z]+)|(?:\#[0-9a-fA-F]{6})|(?:\#[0-9a-fA-F]{3}))\-)(?:(?:((?:(?:[a-zA-Z]+)|(?:\#[0-9a-fA-F]{6})|(?:\#[0-9a-fA-F]{3}))(?:\:\d{1,3})?)\-)?)*((?:[a-zA-Z]+)|(?:\#[0-9a-fA-F]{6})|(?:\#[0-9a-fA-F]{3}))$/;function i(a){return typeof a==="string"}function B(a){return typeof a==="number"}function d(a){return a!==undefined&&a!==null}function f(c,b,f){var e="setAttribute",g;if(i(b)){if(d(f))c[e](b,f);else if(c&&c.getAttribute)g=c.getAttribute(b)}else d(b)&&a.isPlainObject(b)&&a.each(b,function(a,b){c[e](a,b)});return g}function k(c,b){if(u)if(b&&b.opacity!==undefined)b.filter="alpha(opacity="+b.opacity*100+")";a.extend(c.style,b)}function z(f,d,e){var b=c.createElement(f);d&&a.extend(b,d);e&&k(b,e);return b}function E(b){a.each(b,function(a){b[a]&&b[a].destroy&&b[a].destroy();delete b[a]})}function m(){}m.prototype={init:function(b,a){this.element=c.createElementNS(s,a);this.renderer=b},attr:function(c,l){var e,b,g=this.element,m=this.renderer,j=g.nodeName,k,h=this;if(c===undefined)return;if(i(c)&&d(l)){e=c;c={};c[e]=l}if(i(c)){e=c;if(j==="circle")e=({x:"cx",y:"cy"})[e]||e;h=f(g,e)||this[e]||0;if(e!=="d"&&e!==p)h=parseFloat(h)}else c&&a.each(c,function(a){k=false;b=c[a];if(a==="d"){if(b&&b.join)b=b.join(" ");if(/(NaN| {2}|^$)/.test(b))b="M 0 0";this.d=b}else if(a==="fill")b=m.color(b,g,a);else if(j==="circle"&&(a==="x"||a==="y"))a=({x:"cx",y:"cy"})[a]||a;if(jQuery.browser.safari&&a==="stroke-width"&&b===0)b=1e-6;!k&&f(g,a,b)});return h},scale:function(e,f){var b=this,a=b.getBBox(),c=-(a.x+a.width/2)/2,d=-(a.y+a.height/2)/2;if(e===1)c=0;if(f===1)d=0;b.attr("transform","matrix("+e+",0,0, "+f+","+c+","+d+")")},symbolAttr:function(b){var a=this;t(["x","y","r","start","end","width","height","innerR"],function(d,c){if(b[c])a[c]=b[c];else a[c]=a[c]});a.attr({d:a.renderer.symbols[a.symbolName](Math.round(a.x*2)/2,Math.round(a.y*2)/2,a.r,{start:a.start,end:a.end,width:a.width,height:a.height,innerR:a.innerR})})},clip:function(a){return this.attr("clip-path","url("+this.renderer.url+"#"+a.id+")")},crisp:function(e,i,j,h,g){var b=this,c,f={},a={},d;e=e||b.strokeWidth||0;d=e%2/2;a.x=Math.floor(i||b.x||0)+d;a.y=Math.floor(j||b.y||0)+d;a.width=Math.floor((h||b.width||0)-2*d);a.height=Math.floor((g||b.height||0)-2*d);a.strokeWidth=e;for(c in a)if(b[c]!==a[c])b[c]=f[c]=a[c];return f},css:function(b){var c=this,g=c.element,f=b&&b.width&&g.nodeName==="text",d="",e=function(b,a){return"-"+a.toLowerCase()};if(b&&b.color)b.fill=b.color;b=a.extend(c.styles,b);c.styles=b;if(u&&!D){if(f)delete b.width;k(c.element,b)}else{a.each(b,function(c,a){d+=a.replace(/([A-Z])/g,e)+":"+b[a]+";"});c.attr({style:d})}return c},getBBox:function(){var b,e,d,f=this.rotation,c=f*Math.PI/180;try{b=a.extend({},this.element.getBBox())}catch(g){b={width:0,height:0}}e=b.width;d=b.height;if(f){b.width=Math.abs(d*Math.sin(c))+Math.abs(e*Math.cos(c));b.height=Math.abs(d*Math.cos(c))+Math.abs(e*Math.sin(c))}return b},show:function(){return this.attr({visibility:r})},hide:function(){return this.attr({visibility:n})},add:function(b){var a=this,m=a.renderer,i=b||m,k=i.element||m.box,l=k.childNodes,g=a.element,c=f(g,"zIndex"),e,j,h;if(b&&a.htmlNode){if(!b.htmlNode)b.htmlNode=[];b.htmlNode.push(a)}if(c){i.handleZ=true;c=parseInt(c,10)}if(i.handleZ)for(h=0;h<l.length;h++){e=l[h];j=f(e,"zIndex");if(e!==g&&(parseInt(j,10)>c||!d(c)&&d(j))){k.insertBefore(g,e);return a}}k.appendChild(g);a.added=true;return a},safeRemoveChild:function(b){var a=b.parentNode;a&&a.removeChild(b)},destroy:function(){var b=this,c=b.element||{},e=b.shadows,f=b.box,d;c.onclick=c.onmouseout=c.onmouseover=c.onmousemove=null;if(b.clipPath)b.clipPath=b.clipPath.destroy();if(b.stops){for(d=0;d<b.stops.length;d++)b.stops[d]=b.stops[d].destroy();b.stops=null}b.safeRemoveChild(c);e&&t(e,function(a){b.safeRemoveChild(a)});f&&f.destroy();a.each(b,function(a){delete b[a]});return null},empty:function(){var d=this.element,b=d.childNodes,c=b.length;while(c--){d.removeChild(b[c]);a(b[c]).remove()}},remove:function(){var b=this.element,c=b.parentNode;c.removeChild(b);a(b).remove()}};l=function(){this.init.apply(this,arguments)};l.prototype={Element:m,init:function(e,g,f){var b=this,h=c.location,d;if(a(e).is("svg")){b.box=e;d=new b.Element;d.element=e;d.render=b;b.defs=a("defs",e).get(0);b.gradients={}}else{d=b.createElement("svg").attr({xmlns:s,version:"1.1"});e.appendChild(d.element);b.box=d.element;b.boxWrapper=d;b.defs=this.createElement("defs").add();b.gradients={};b.setSize(g,f)}b.url=u?"":h.href.replace(/#.*?$/,"")},destroy:function(){var a=this;a.box=null;E(a.gradients||{});a.gradients=null;return null},createElement:function(b){var a=new this.Element;a.init(this,b);return a},path:function(a){return this.createElement("path").attr({d:a,fill:v})},circle:function(b,e,d){var c=a.isPlainObject(b)?b:{x:b,y:e,r:d};return this.createElement("circle").attr(c)},rect:function(b,h,g,f,c,d){if(a.isPlainObject(b)){h=b.y;g=b.width;f=b.height;c=b.r;d=b.strokeWidth;b=b.x}var e=this.createElement("rect").attr({rx:c,ry:c,fill:v});return e.attr(e.crisp(d,b,h,Math.max(g,0),Math.max(f,0)))},setSize:function(c,b){var a=this;a.width=c;a.height=b;a.boxWrapper.attr({width:c,height:b})},g:function(b){var a=this.createElement("g");return d(b)?a.attr({"class":j+b}):a},symbol:function(i,f,g,d,c){var b,e=this,h=e.symbols[i],j=h&&h(Math.round(f),Math.round(g),d,c);if(j){b=e.path(j);a.extend(b,{symbolName:i,x:f,y:g,r:d});c&&a.extend(b,c)}else b=e.circle(f,g,d);return b},symbols:{box:function(c,d,f){var a=.707*f;return[e,c-a,d-a,b,c+a,d-a,c+a,d+a,c-a,d+a,"Z"]},tri:function(c,d,a){return[e,c,d-1.33*a,b,c+a,d+.67*a,c-a,d+.67*a,"Z"]},invertedTri:function(c,d,a){return[e,c,d+1.33*a,b,c-a,d-.67*a,c+a,d-.67*a,"Z"]},diamond:function(c,d,a){return[e,c,d-a,b,c+a,d,c,d+a,c-a,d,"Z"]},cross:function(c,d,f){var a=.707*f;return[e,c-a,d-a,b,c+a,d+a,e,c-a,d+a,b,c+a,d-a]},arc:function(f,g,c,d){var h=d.start,n=d.end-1e-6,a=d.innerR,i=Math.cos(h),j=Math.sin(h),l=Math.cos(n),m=Math.sin(n),k=d.end-h<Math.PI?0:1;return[e,f+c*i,g+c*j,"A",c,c,0,k,1,f+c*l,g+c*m,b,f+a*l,g+a*m,"A",a,a,0,k,0,f+a*i,g+a*j,"Z"]}},clipRect:function(g,h,f,e){var b,d=j+C++,c=this.createElement("clipPath").attr({id:d});a(this.defs).append(c.element);b=this.rect(g,h,f,e,0).add(c);b.id=d;b.clipPath=c;return b},gradientCache:{},_parsegradientcolor:function(g){var j=this,b=[],d,i,a,h,e,f,c,k;if(j.gradientCache[g])return j.gradientCache[g];for(a=0,f=g.length;a<f;a++){d={};i=g[a].match(/^([^:]*):?([\d\.]*)/);d.color=Raphael.getRGB(i[1]);if(d.color.error)return null;d.color=d.color.hex;if(i[2])d.offset=i[2]+"%";b.push(d)}for(a=1,f=b.length-1;a<f;a++)if(!b[a].offset){h=parseFloat(b[a-1].offset||0);e=0;for(c=a+1;c<f;c++)if(b[c].offset){e=b[c].offset;break}if(!e){e=100;c=f}e=parseFloat(e);k=(e-h)/(c-a+1);for(;a<c;a++){h+=k;b[a].offset=h+"%"}}j.gradientCache[g]=b;return b},color:function(d,z,A){var o=this,e="color",k=.5,c=.5,l=o.gradients,g,m,t,v,u,w,s,b,q,r,p=d,i,h,n;if(x.test(d))e="linear";else d=d.replace(y,function(f,b,d){e="radial";if(b&&d){k=parseFloat(b);c=parseFloat(d);var a=(c>.5)*2-1;if(Math.pow(k-.5,2)+Math.pow(c-.5,2)>.25&&(c=Math.sqrt(.25-Math.pow(k-.5,2))*a+.5)&&c!==.5)c=c.toFixed(5)-1e-5*a}return""});if(e==="linear"||e==="radial"){m=d.split(/\s*\-\s*/);if(e==="linear"){h=m.shift();h=-parseFloat(h);if(isNaN(h))return d;b=[0,0,Math.cos(Raphael.rad(h)),Math.sin(Raphael.rad(h))];q=1/(Math.max(Math.abs(b[2]),Math.abs(b[3]))||1);b[2]*=q;b[3]*=q;if(b[2]<0){b[0]=-b[2];b[2]=0}if(b[3]<0){b[1]=-b[3];b[3]=0}t=b[0];v=b[1];u=b[2];w=b[3]}if(l[p])i=f(l[p].element,"id");else{n=this._parsegradientcolor(m);a.each(n,function(b,a){a.offset=a.offset?a.offset:b?"100%":"0%"});i=j+C++;g=o.createElement(e+"Gradient").attr(e==="radial"?{id:i,fx:k,fy:c}:{id:i,x1:t,y1:v,x2:u,y2:w});a(this.defs).append(g.element);g.stops=[];a.each(n,function(c,b){var a;s=b.color;r=1;a=o.createElement("stop").attr({offset:b.offset,"stop-color":s,"stop-opacity":r}).add(g);g.stops.push(a)});l[p]=g}return"url(#"+i+")"}else{z.removeAttribute(A+"-opacity");return d}}};a.chartRender=l;if(!D){q=function(){};q.prototype=a.extend(true,{},m.prototype,{init:function(d,a){var b=["<",a,' filled="f" stroked="f"'],c=["position: ",A,";"];(a==="shape"||a===g)&&c.push("left:0;top:0;width:10px;height:10px;");h&&c.push("visibility: ",a===g?n:r);b.push(' style="',c.join(""),'"/>');if(a){b=a===g||a==="span"||a==="img"?b.join(""):d.prepVML(b);this.element=z(b)}this.renderer=d},add:function(a){var b=this,e=b.renderer,d=b.element,g=e.box,f=a&&a.inverted,c=a?a.element||a:g;f&&e.invertChild(d,c);h&&c.gVis===n&&k(d,{visibility:n});c.appendChild(d);b.added=true;return b},attr:function(j,z){var m,b,c,l=this,e=l.element||{},x=e.style,y=e.nodeName,A=l.symbolName,C=l.renderer,s,u,t=l.shadows,o,n,q=l;if(j===undefined)return q;if(i(j)&&d(z)){m=j;j={};j[m]=z}if(i(j)){m=j;if(m==="strokeWidth"||m==="stroke-width")q=l.strokeweight;else q=l[m]}else j&&a.each(j,function(a,d){b=d;o=false;if(A&&/^(x|y|r|start|end|width|height|innerR)/.test(a)){if(!u){l.symbolAttr(j);u=true}o=true}else if(a==="d"){b=b||[];l.d=b.join(" ");c=b.length;n=[];while(c--)if(B(b[c]))n[c]=Math.round(b[c]*10)-5;else if(b[c]==="Z")n[c]="x";else n[c]=b[c];b=n.join(" ")||"x";e.path=b;if(t){c=t.length;while(c--)t[c].path=b}o=true}else if(a==="zIndex"||a===p){if(h&&a===p&&y===g){e.gVis=b;s=e.childNodes;c=s.length;while(c--)k(s[c],{visibility:b});if(b===r)b=null}if(b)x[a]=b;o=true}else if(a==="class")e.className=b;else if(a==="stroke")a="strokecolor";else if(a==="stroke-width"||a==="strokeWidth"){e.stroked=b?true:false;a="strokeweight";l[a]=b;if(B(b))b+=w}else if(a==="fill")if(y==="SPAN")x.color=b;else{e.filled=b!==v?true:false;b=C.color(b,e,a);a="fillcolor"}if(!o){if(a==="opacity")a="fill-opacity";if(h)e[a]=b;else f(e,a,b)}});return q},scale:function(c,d){var a=this,b=a.attr("stroke-width")||0;a.css({filter:"progid:DXImageTransform.Microsoft.Matrix(M11="+c+",, M12=0, M21=0, M22="+d+", Dx=0, Dy=0, sizingmethod='auto expand')"}).attr("stroke-width",b)},clip:function(b){var a=this,c=b.members;c.push(a);return a.css(b.getCSS(a.inverted))},css:function(c){var b=this,e=b.element,d=c&&e.tagName==="SPAN"&&c.width;if(d){delete c.width;b.textWidth=d}b.styles=a.extend(b.styles,c);k(b.element,c);return b},destroy:function(){var a=this;a.destroyClip&&a.destroyClip();return m.prototype.destroy.apply(a)},empty:function(){var e=this.element,c=e.childNodes,d=c.length,b;while(d--){b=c[d];b.parentNode.removeChild(b);a(b).remove()}},getBBox:function(){var c=this,a=c.element,b=c.bBox;if(!b){if(a.nodeName==="text")a.style.position=A;b=c.bBox={x:a.offsetLeft,y:a.offsetTop,width:a.offsetWidth,height:a.offsetHeight}}return b}});o=function(){this.init.apply(this,arguments)};o.prototype=a.extend(true,{},l.prototype,{Element:q,isIE8:a.browser.msie&&a.browser.version===8,init:function(e,h,f){var d=this,b;if(a(e).hasClass("vmlcontainer")){d.box=e;b=new this.Element;b.element=e;b.render=this;d.boxWrapper=b}else{b=d.createElement(g);e.appendChild(b.element);d.box=b.element;d.boxWrapper=b;d.setSize(h,f)}if(!c.namespaces.v){c.namespaces.add("v","urn:schemas-microsoft-com:vml");c.createStyleSheet().cssText="v\\:fill, v\\:path, v\\:shape, v\\:stroke{ behavior:url(#default#VML); display: inline-block; } "}},clipRect:function(e,f,d,c){var b=this.createElement();return a.extend(b,{members:[],left:e,top:f,width:d,height:c,getCSS:function(b){var c=this,g=c.top,f=c.left,e=f+c.width,d=g+c.height,i={clip:"rect("+Math.round(b?f:g)+"px,"+Math.round(b?d:e)+"px,"+Math.round(b?e:d)+"px,"+Math.round(b?g:f)+"px)"};!b&&h&&a.extend(i,{width:e+w,height:d+w});return i},updateClipping:function(){t(b.members,function(c,a){a.css(b.getCSS(a.inverted))})}})},color:function(c,m,q){var i,o=this,b="color",g,f,j,k,h=[],p,e,n,l,d=0;if(x.test(c))b="linear";else{c=c.replace(y,function(d,c,a){b="radial";if(c&&a){c=parseFloat(c);a=parseFloat(a);if(Math.pow(c-.5,2)+Math.pow(a-.5,2)>.25)a=Math.sqrt(.25-Math.pow(c-.5,2))*((a>.5)*2-1)+.5;n=c+" "+a}return""});b="radial"}if(b==="linear"||b==="radial"){g=c.split(/\s*\-\s*/);if(b==="linear"){d=g.shift();d=-parseFloat(d)}l=o._parsegradientcolor(g);a.each(l,function(b,a){a.offset=a.offset?a.offset:b?"100%":"0%";h.push(a.offset+" "+a.color);f=a.color;if(!b)j=f;else k=f});if(b==="radial")i=['<fill colors="',h.join(),'" angle="0"','" focusposition="',n,'" color="',j,'" color2="',k,'" focussize="0 0"',' type="gradientTitle" focus="100%" method="none" />'];else i=['<fill colors="',h.join(),'" angle="',d,'" type="gradient" focus="100%" method="sigma" />'];p=z(o.prepVML(i));a(m).append(p)}else{e=m.getElementsByTagName(q);if(e.length)e[0].opacity=1;return c}},prepVML:function(a){var b="display:inline-block;behavior:url(#default#VML);",c=this.isIE8;a=a.join("");if(c){a=a.replace("/>",' xmlns="urn:schemas-microsoft-com:vml" />');if(a.indexOf('style="')===-1)a=a.replace("/>",' style="'+b+'" />');else a=a.replace('style="','style="'+b)}else a=a.replace("<","<v:");return a},path:function(a){return this.createElement("shape").attr({coordsize:"100 100",d:a})},g:function(a){var c,b;if(a)b={className:j+a,"class":j+a};c=this.createElement(g).attr(b);return c},symbols:{arc:function(c,d,b,h){var e=h.start,f=h.end,k=Math.cos(e),l=Math.sin(e),g=Math.cos(f),m=Math.sin(f),a=h.innerR,i=.07/b,j=a&&.1/a||0;if(f-e===0)return["x"];else if(2*Math.PI-f+e<i)g=-i;else if(f-e<j)g=Math.cos(e+j);return["wa",c-b,d-b,c+b,d+b,c+b*k,d+b*l,c+b*g,d+b*m,"at",c-a,d-a,c+a,d+a,c+a*g,d+a*m,c+a*k,d+a*l,"x","e"]},circle:function(b,c,a){return["wa",b-a,c-a,b+a,c+a,b+a,c,b+a,c,"e"]},rect:function(c,f,a,i){if(!d(i))return[];var k=i.width,j=i.height,h=c+k,g=f+j;a=Math.min(a,k,j);return[e,c+a,f,b,h-a,f,"wa",h-2*a,f,h,f+2*a,h-a,f,h,f+a,b,h,g-a,"wa",h-2*a,g-2*a,h,g,h,g-a,h-a,g,b,c+a,g,"wa",c,g-2*a,c+2*a,g,c+a,g,c,g-a,b,c,f+a,"wa",c,f,c+2*a,f+2*a,c,f+a,c+a,f,"x","e"]}}});a.chartRender=o}})(jQuery);
(function(a){"use strict";var d=0,c=0,b=0;a.widget("wijmo.wijbubblechart",a.wijmo.wijchartcore,{options:{minimumSize:5,maximumSize:20,sizingMethod:"diameter",animation:{enabled:true,duration:1e3,easing:">"},seriesTransition:{enabled:true,duration:400,easing:">"},seriesList:[],seriesHoverStyles:[{opacity:1,"stroke-width":5},{opacity:1,"stroke-width":5},{opacity:1,"stroke-width":5},{opacity:1,"stroke-width":5},{opacity:1,"stroke-width":5},{opacity:1,"stroke-width":5},{opacity:1,"stroke-width":5},{opacity:1,"stroke-width":5},{opacity:1,"stroke-width":5},{opacity:1,"stroke-width":5},{opacity:1,"stroke-width":5},{opacity:1,"stroke-width":5}],chartLabel:{position:"inside",compass:"north",visible:true,style:{},chartLabelFormatString:""},mouseDown:null,mouseUp:null,mouseOver:null,mouseOut:null,mouseMove:null,click:null},_setOption:function(d,c){var b=this,e=b.options;if(d==="minimumSize"||d==="minimumSize"){if(isNaN(c)||c<0)c=0;e[d]=c;b.redraw()}else if(d==="chartLabel"){a.extend(e.chartLabel,c);b.redraw()}else a.wijmo.wijchartcore.prototype._setOption.apply(b,arguments);if(d==="seriesList"){b.indexs=null;b.bubbleRadius=null}},_create:function(){var b=this,d=b.options,c=b._getDefFill();a.each(d.seriesStyles,function(b,a){if(!a.fill)a.fill=c[b]});b._setLabelOption();a.wijmo.wijchartcore.prototype._create.apply(b,arguments);b.chartElement.addClass("wijmo-wijbubblechart")},_setLabelOption:function(){var b=this.options;if(b.showChartLabels!==true&&b.chartLabel.visible===true)b.chartLabel.visible=false;if(!a.isPlainObject(b.chartLabel.style)&&a.isPlainObject(b.chartLabelStyle))b.chartLabel.style=b.chartLabelStyle},_clearChartElement:function(){var c=this,d=c.options,b=c.chartElement.data("fields");a.wijmo.wijchartcore.prototype._clearChartElement.apply(c,arguments);b&&b.bubbleInfos&&a.each(b.bubbleInfos,function(b,a){a.bubble&&a.bubble.wijRemove();a.dcl&&a.dcl.wijRemove();a.symbol&&a.symbol.wijRemove()});b&&b.bubbles&&c._destroyRaphaelArray(b.bubbles);c.element.removeData("plotInfos");if(!d.seriesTransition.enabled)if(b&&b.bubblesAnimationInfos)b.bubblesAnimationInfos=null},destroy:function(){var b=this;b.chartElement.removeClass("wijmo-wijbubblechart ui-helper-reset");b._destroyEles();a.wijmo.wijchartcore.prototype.destroy.apply(b,arguments)},_destroyEles:function(){var b=this,d=b.element,c=d.data("fields");c.bubbleInfos&&a.each(c.bubbleInfos,function(c,a){b._removeEle(a.bubble);b._removeEle(a.dcl);b._removeEle(a.symbol);a=null});d.removeData("fields");b.bubbleRadius=[]},_removeEle:function(b){if(b){b.node&&a(b.node).removeData();b.wijRemove();b=null}},_paintPlotArea:function(){var b=this,f=this.chartElement,c=b.options,e=c.seriesList,d=e.length,i=[].concat(c.seriesStyles.slice(0,d)),g=[].concat(c.seriesHoverStyles.slice(0,d)),h=b.canvasBounds,j=b.axisInfo.x,k=b.axisInfo.y[0];if(d===0)return;b._prepBubbleData();f.wijbubble({seriesList:e,seriesStyles:i,seriesHoverStyles:g,canvas:b.canvas,bounds:h,xAxisInfo:j,yAxisInfo:k,chartLabel:c.chartLabel,textStyle:c.textStyle,chartLabelStyle:c.chartLabelStyle,chartLabelFormatString:c.chartLabelFormatString,bubbleRadius:b.bubbleRadius,animation:c.animation,seriesTransition:c.seriesTransition,sizingMethod:c.sizingMethod,minimumSize:c.minimumSize,maximumSize:c.maximumSize,mouseDown:a.proxy(b._mouseDown,b),mouseUp:a.proxy(b._mouseUp,b),mouseOver:a.proxy(b._mouseOver,b),mouseOut:a.proxy(b._mouseOut,b),mouseMove:a.proxy(b._mouseMove,b),click:a.proxy(b._click,b),disabled:c.disabled,culture:b._getCulture()});b.tooltipbubbles=[];a.each(f.data("fields").bubbleInfos,function(c,a){b.tooltipbubbles.push(a.bubble);a.dcl&&b.tooltipbubbles.push(a.dcl);a.symbol&&b.tooltipbubbles.push(a.symbol)});b.tooltip&&b.tooltip.setTargets(b.tooltipbubbles)},_paintLegend:function(){var b=this,l=b.options,d=0,n=0,g=0,h=null,m=l.seriesList,q=l.seriesStyles,e=null,k=null,f=null,o=0,p=0,r=0,i=null,j=null,c=null;a.wijmo.wijchartcore.prototype._paintLegend.apply(b,arguments);if(l.legend.visible){if(b.legends.length&&b.legendIcons.length)for(d=0,n=b.legendIcons.length;d<n;d++){h=b.legendIcons[d];h.attr({fill:h.attr("stroke")})}if(!l.legend.reversed)for(d=0,n=m.length;d<n;d++){e=m[d];k=q[d];if(e.legendEntry){if(e.markers)j=e.markers.type;h=b.legendIcons[g];f=h.wijGetBBox();o=f.x+f.width/2;p=f.y+f.height/2;r=Math.min(f.width,f.height);i=e.markerStyle;i=a.extend({fill:k.stroke,stroke:k.stroke,opacity:1},i);if(!j)j="circle";c=b.canvas.paintMarker(j,o,p,r/2);a.wijraphael.addClass(a(c.node),"chart-legend-dot wijchart-canvas-object wijchart-legend");c.attr(i);a(c.node).data("index",d).data("legendIndex",g);h.remove();b.legendIcons[g]=c;if(!!e.visible){if(l.legend.textWidth)a(b.legends[g][0].node).data("dotOpacity",c.attr("opacity")||1);else a(b.legends[g].node).data("dotOpacity",c.attr("opacity")||1);c.attr("opacity",.3)}g++}}else for(d=m.length-1;d>=0;d--){e=m[d];k=q[m.length-1-d];if(e.legendEntry){if(e.markers)j=e.markers.type;h=b.legendIcons[g];f=h.wijGetBBox();o=f.x+f.width/2;p=f.y+f.height/2;i=e.markerStyle;i=a.extend({fill:k.stroke,stroke:k.stroke,opacity:1},i);if(!j)j="circle";c=b.canvas.paintMarker(j,o,p,7);a.wijraphael.addClass(a(c.node),"chart-legend-dot");c.attr(i);h.remove();b.legendIcons[g]=c;if(!!e.visible){if(l.legend.textWidth)a(b.legends[g][0].node).data("dotOpacity",c.attr("opacity")||1);else a(b.legends[g].node).data("dotOpacity",c.attr("opacity")||1);c.attr("opacity",.3)}g++}}}},_getbubbleIndexs:function(m,l){var d=this,e=d.options,o=e.axis.x.max,p=e.axis.x.min,t=e.axis.y.min,s=e.axis.y.max,q=[],u=[],n=[],r=[],f=[],g=[],i=-1,k=-1,h=-1,j=-1;d.bubbleRadius=[];d._prepBubbleData();a.each(e.seriesList,function(v,i){var h=i.data,k=i.markers||{},j=k.type||"circle";if(h.y1===undefined)return true;a.each(h.y1,function(k,x){var w=a.wijbubble.transform(x,e.maximumSize,e.minimumSize,d.canvasBounds,c,b,e.sizingMethod,j),v,i;if(d._isDate(h.x[k]))v=a.toOADate(h.x[k]);else if(isNaN(h.x[k]))v=k;else v=h.x[k];i=h.y[k];if(d._isDate(i))i=a.toOADate(i);q.push(v-w*(o-p)/m);u.push(i-w*(s-t)/l);n.push(v+w*(o-p)/m);r.push(i+w*(s-t)/l);f.push(v);g.push(i);d.bubbleRadius.push(w)})});i=d._getMinIndex(q);k=d._getMinIndex(u);h=d._getMaxIndex(n);j=d._getMaxIndex(r);d.indexs={xMin:{x:f[i],y:g[i],r:d.bubbleRadius[i]},xMax:{x:f[h],y:g[h],r:d.bubbleRadius[h]},yMin:{x:f[k],y:g[k],r:d.bubbleRadius[k]},yMax:{x:f[j],y:g[j],r:d.bubbleRadius[j]}}},_calculateParameters:function(c,b){a.wijmo.wijchartcore.prototype._calculateParameters.apply(this,arguments);var d=this;if(!b.autoMax&&!b.autoMin)return;d._adjust(b,c)},_adjust:function(e,b){var g=e.unitMinor,a=this,l=e.autoMin,k=e.autoMax,f=a.canvasBounds,j={x:f.startX,y:f.startY},i=f.endX-j.x,h=f.endY-j.y,c=b.max,d=b.min;!a.indexs&&a._getbubbleIndexs(i,h);if(b.id==="x"){if(l)d=a._getMinTick(a.indexs.xMin.x,a.indexs.xMin.r,d,c,i,g);if(k)c=a._getMaxTick(a.indexs.xMax.x,a.indexs.xMax.r,d,c,i,g)}else{if(l)d=a._getMinTick(a.indexs.yMin.y,a.indexs.yMin.r,d,c,h,g);if(k)c=a._getMaxTick(a.indexs.yMax.y,a.indexs.yMax.r,d,c,h,g)}if(c!==b.max||d!==b.min){b.min=d;b.max=c;this._calculateMajorMinor(e,b);a._adjust(e,b)}},_getMinTick:function(e,f,a,d,c,b){return(e-a)*c/(d-a)<f?a-b:a},_getMaxTick:function(e,f,c,a,b,d){return(e-c)*b/(a-c)+f>b?a+d:a},_getMinIndex:function(d){var c=-1,b=0;a.each(d,function(c,a){if(c===0)b=a;else if(a<b)b=a});a.each(d,function(a,d){if(d===b){c=a;return false}});return c},_getMaxIndex:function(d){var c=-1,b=0;a.each(d,function(c,a){if(c===0)b=a;else if(a>b)b=a});a.each(d,function(a,d){if(d===b){c=a;return false}});return c},_showSerieEles:function(b){a.each(b,function(b,a){if(a.bubble){a.bubble.show();a.bubble.tracker&&a.bubble.tracker.show()}a.dcl&&a.dcl.show();a.symbol&&a.symbol.show()})},_hideSerieEles:function(b){a.each(b,function(b,a){if(a.bubble){a.bubble.hide();a.bubble.tracker&&a.bubble.tracker.hide()}a.dcl&&a.dcl.hide();a.symbol&&a.symbol.hide()})},_parseTable:function(){if(!this.element.is("table"))return;var e=this,f=e.element,b=e.options,c=a("caption",f),m=a("thead th",f),g=[],n=a("tbody tr",f),l=null,k=null,i=[],j=[],h=[],d=function(b){var c=a.trim(b);if(!isNaN(b))c=parseFloat(b);return c};if(c.length){b.header=a.extend({visible:true,text:a.trim(a(c[0]).text())},b.header);if(c.length>1)b.footer=a.extend({visibel:true,text:a.trim(a(c[1]).text())},b.footer)}b.legend=a.extend({visible:true},b.legend);l=a.trim(m.eq(1).text());n.each(function(e,c){var b=a("td",c);if(b.length>=3){i.push(d(b.eq(0).text()));j.push(d(b.eq(1).text()));h.push(d(b.eq(2).text()))}});k={label:l,legendEntry:true,data:{x:i,y:j,y1:h}};g.push(k);e.options.seriesList=g},_unbindLiveEvents:function(){var b=this;a(".wijbubblechart-bubble",b.chartElement[0]).die(".wijbubblechart").die("wijbubblechart");if(b.tooltip){b.tooltip.destroy();b.tooltip=null}},_paintTooltip:function(){var c=this,b=c.chartElement.data("fields");a.wijmo.wijchartcore.prototype._paintTooltip.apply(this,arguments);if(c.tooltip)if(b&&b.trackers&&b.trackers.length){c.tooltip.setTargets(b.trackers);c.tooltip.setOptions({relatedElement:b.trackers[0]})}},_getTooltipText:function(e,d){var c=a(d.node),b,f;if(c.data("owner"))c=c.data("owner");b=c.data("wijchartDataObj");f={data:b,value:b.value,label:b.label,total:b.total,target:d,fmt:e,x:b.x,y:b.y,y1:b.y1};return a.proxy(e,f)()},_prepBubbleData:function(){var i=this,h=i.options.seriesList,f=-999999999999,g=9999999999999,e;a.each(h,function(c,b){e=b.data;e&&e.y1&&a.each(e.y1,function(b,a){f=Math.max(f,a);g=Math.min(g,a)})});d=f;c=g;b=f-g},getBubble:function(a){return this.chartElement.data("fields").bubbles[a]}});a.fn.extend({wijbubble:function(e){var l=this,d=e,f=l.data("fields")||{},n=0,g=d.bounds,h=d.canvas,C=a.arrayClone(d.seriesList),y=d.seriesStyles,t=d.seriesHoverStyles,H=d.xAxisInfo,I=d.yAxisInfo,j={x:g.startX,y:g.startY},P=g.endX-j.x,N=g.endY-j.y,i=d.chartLabel,p=[],q=[],E=d.mouseDown,M=d.mouseUp,G=d.mouseOver,K=d.mouseOut,F=d.mouseMove,O=d.click,o=[],J=d.disabled,k=h.set(),L=d.culture;function m(d,b){var a=d.bubble,e=d.symbol,c;if(a.type==="circle")a.attr({r:.0001,cx:b.startX,cy:b.endY});else{a.transform("s0.01");c=a.wijGetBBox();a.transform("t"+(b.startX-c.x)+","+(b.endY-c.y)+"s0.001")}e&&e.hide()}function w(){var b=d.animation,k=d.bounds,h=f.bubblesAnimationInfos,i=[],j=f.bubbleInfos,c=d.seriesTransition,e,g,l;if(b&&b.enabled){e=b.duration||400;g=b.easing;a.each(j,function(n,f){var a=f.bubble,j,b,d=a.wijGetBBox();if(a.type==="circle")j={r:a.attr("r"),cx:a.attr("cx"),cy:a.attr("cy")};else j={transform:"S1T0,0","stroke-width":a.attr("stroke-width"),width:d.width,x:d.x,y:d.y};if(h&&c.enabled){b=h[n];if(b){if(a.type==="circle")a.attr({cx:b.cx,cy:b.cy,r:b.r});else{d=a.wijGetBBox();l=b.width/d.width;a.transform("s"+l);d=a.wijGetBBox();a.transform("t"+(b.x-d.x)+","+(b.y-d.y)+"")}e=c.duration;g=c.easing}else m(f,k)}else m(f,k);i.push(j);a.wijAnimate(j,e,g,function(){f.dcl&&f.dcl.attr("opacity",1);f.symbol&&f.symbol.show()})});f.bubblesAnimationInfos=i}else a.each(j,function(b,a){a.dcl&&a.dcl.attr("opacity",1)})}function D(c,d){var b;a.each(c,function(a,c){if(a===d){b=c;return false}});return b}function u(c,d){var b=true;a.each(c,function(a){if(d===a){b=false;return false}});return b}function B(b,d,e,c){var a;if(h[b])a=h[b](d,e,c);return a}function z(d){var b=h.text(0,0,d),a=b.wijGetBBox(),c;c={width:a.width,height:a.height};b.remove();return c}function s(a,f){var d=e.chartLabel.compass||"north",b=z(f),c=a.r;switch(d){case"north":a.y-=c+b.height/2;break;case"south":a.y+=c+b.height/2;break;case"east":a.x+=c+b.width/2;break;case"west":a.x-=c+b.width/2}}function r(f,j){var g=a.extend(true,{},e.textStyle,e.chartLabelStyle,i.style),c=a.round(j,2),b=i.chartLabelFormatString===""?e.chartLabelFormatString:i.chartLabelFormatString,d;if(b&&b.length)c=Globalize.format(c,b,L);d=h.text(f.x,f.y,c).attr(g);return d}function A(l,x,v,m,t,G,F){var j=l.data,E=m.min,I=t.min,H=m.max,C=t.max,J=G/(H-E),K=F/(C-I),z=[],w=e.bubbleRadius,d,A,y;if(j.y1===undefined)return;a.each(j.y1,function(M,Q){if(j.x===undefined||j.y===undefined)return true;var N=j.x[M],R=j.y[M],V=l.markers||{},U=V.type||"circle",W=V.symbol,X=l.invisibleMarkLabels||[],T,S,I,p,O,P,H,L,G,F;if(w){G=w[n];n++}else G=a.wijbubble.transform(Q,e.maximumSize,e.minimumSize,e.bounds,c,b,e.sizingMethod,U);if(m.isTime)N=a.toOADate(N);else if(isNaN(N))N=M;if(t.isTime)R=a.toOADate(R);O=g.startX+(N-E)*J;P=g.startY+(C-R)*K;if(W)H=D(W,M);p=B(U,O,P,G);p.attr(x);if(H){A=H.width||G*2;y=H.height||G*2;L=h.image(H.url,O-G,P-G,A,y)}a.wijraphael.addClass(a(p.node),"wijchart-canvas-object wijbubblechart-bubble");H&&p.attr("opacity",.1);I=a.extend(false,{index:M,bubble:p,style:x,y1:Q,x:N,y:R,type:"bubble",hoverStyle:v},l);if(H){I.symbol=true;I.hoverStyle=a.extend({},v,{opacity:.1});a(L.node).data("wijchartDataObj",I);a.wijraphael.addClass(a(L.node),"wijbubblechart-symbol")}a(p.node).data("wijchartDataObj",I);F=p.clone();if(a.browser.msie&&a.browser.version<9)F.attr({opacity:.01,fill:"white","stroke-width":0,"fill-opacity":.01});else F.attr({opacity:.01,fill:"white","fill-opacity":.01});a(F.node).data("owner",a(p.node));a.wijraphael.addClass(a(F.node),"wijchart-canvas-object wijbubblechart-bubble bubbletracker");p.tracker=F;k.push(F);q.push(p);f.bubbles=q;T={x:O,y:P,r:G};if(i.visible&&u(X,M)){i.position==="outside"&&s(T,Q);d=r(T,Q);d.attr("opacity",0);a(d.node).data("wijchartDataObj",I);a.wijraphael.addClass(a(d.node),"wijbubblechart-label")}S={bubble:p,dcl:d,symbol:L};o.push(S);z.push(S);if(l.visible===false){p.hide();d&&d.hide();F.hide();L&&L.hide()}});f.bubbleInfos=o;p.push(z)}function x(){a.each(C,function(a,d){var c=y[a],b=t[a];A(d,c,b,H,I,P,N,j)})}function v(b,d,i,f,g,e,j,c){var h={mousedown:function(g){if(c)return;var e=a(g.target),f;if(e.data("owner"))e=e.data("owner");f=e.data("wijchartDataObj");d.call(b,g,f)},mouseup:function(f){if(c)return;var d=a(f.target),e;if(d.data("owner"))d=d.data("owner");e=d.data("wijchartDataObj");i.call(b,f,e)},mouseover:function(g){if(c)return;var d=a(g.target),e;if(d.data("owner"))d=d.data("owner");e=d.data("wijchartDataObj");f.call(b,g,e)},mouseout:function(h){if(c)return;var f=a(h.target),d,e;if(f.data("owner"))f=f.data("owner");d=f.data("wijchartDataObj");e=d.bubble;if(d.symbol)return;if(!d.hoverStyle)e&&e.attr({opacity:"1"});else{e.attr(d.style);d.style.opacity&&e.attr("opacity",d.style.opacity)}g.call(b,h,d)},mousemove:function(h){if(c)return;var g=a(h.target),d,f;if(g.data("owner"))g=g.data("owner");d=g.data("wijchartDataObj");f=d.bubble;if(!d.hoverStyle)f&&f.attr({opacity:"0.8"});else f.attr(d.hoverStyle);e.call(b,h,d)},click:function(f){if(c)return;var d=a(f.target),e;if(d.data("owner"))d=d.data("owner");e=d.data("wijchartDataObj");j.call(b,f,e)}};a.each(["click","mouseover","mouseout","mousemove","mousedown","mouseup"],function(d,c){a(".bubbletracker",b).bind(c+".wijbubblechart",h[c])})}x();f.seriesEles=p;w();k.toFront();f.trackers=k;v(l,E,M,G,K,F,O,J);l.data("fields",f)}});a.wijbubble={transform:function(n,k,e,c,o,j,g,i){var f,b=n,h=k-e,m=c.endX-c.startX,l=c.endY-c.startY;if(b<0)b=0;if(j===0)b=1;else b/=d;b=a.wijbubble.transformByArea(b,g,i);b*=h;b+=e;f=Math.min(m,l);b*=f/200;return b},transformByArea:function(d,b,c){var a=d;if(b==="area")switch(c){case"circle":a=Math.sqrt(a/Math.PI);break;case"tri":case"invertedTri":a=Math.sqrt(a/(3*Math.sin(Math.PI/6)*Math.cos(Math.PI/6)));break;case"box":a=Math.sqrt(a/2);break;case"diamond":case"cross":a=Math.sqrt(a/2);break;default:a=Math.sqrt(4*a/Math.PI)}return a}}})(jQuery);
(function(a){"use strict";var n="ui-helper-clearfix",y="ui-widget-content",l="ui-corner-",k=l+"all",c="ui-state-disabled",d="ui-state-hover",b="wijmo-wijcarousel-",B="wijmo-wijcarousel",w=B+" ui-widget ",F=b+"list",q=b+"item ",D=b+"clip",g=b+"current",t=b+"horizontal-multi",v=b+"horizontal",r=b+"button",u=b+"vertical-multi",x=b+"vertical",o=b+"button-next",p=b+"button-previous",z=b+"preview",e="ui-icon-triangle-1-",G=e+"n",H=e+"s",E=e+"e",I=e+"w",h="ui-icon-play",j="ui-icon-pause",C='<a class="ui-state-default"><span class="ui-icon"></span></a>',f=".wijmo-wijcarousel-pager,."+r+",."+o+",."+p,m='<div class="ui-helper-clearfix"></div>',A='<li class="ui-state-default wijmo-wijcarousel-page"><a></a></li>',s="li.wijmo-wijcarousel-page",i=1;a.widget("wijmo.wijcarousel",{options:{data:[],auto:false,interval:5e3,showTimer:false,buttonPosition:"inside",showPager:false,prevBtnClass:{defaultClass:"",hoverClass:"",disableClass:""},nextBtnClass:{defaultClass:"",hoverClass:"",disableClass:""},pagerType:"numbers",thumbnails:{mouseover:null,mouseout:null,mousedown:null,mouseup:null,click:null,imageWidth:58,imageHeight:74,images:[]},pagerPosition:{},orientation:"horizontal",sliderOrientation:"horizontal",loop:true,animation:{queue:true,disable:false,duration:1e3,easing:"easeOutCubic"},start:0,display:1,preview:false,step:1,showControls:false,control:"",controlPosition:{},showCaption:true,showControlsOnHover:false,itemClick:null,beforeScroll:null,afterScroll:null,loadCallback:null},_handleDisabledOption:function(d){var b=this;if(b.pager&&!b.pager.is(":hidden"))b.disabledEles=b.disabledEles.add(b.pager);if(d){b.element.addClass(c);!b.disabledDiv.length&&b._createDisabledDiv();b.disabledDiv.appendTo("body")}else if(b.disabledDiv){b.element.removeClass(c);b.disabledDiv.remove();b.disabledDiv=a()}},_createDisabledDiv:function(){var b=this;b.disabledEles.each(function(){var e=a(this),f=e.offset(),h=e.outerWidth(),g=e.outerHeight(),d=a("<div></div>").addClass(c).css({"z-index":"99999",position:"absolute",width:h,height:g,left:f.left,top:f.top});if(a.browser.msie){d.css("background-color","white");a.browser.version==="9.0"&&d.css("opacity","0.1")}b.disabledDiv=b.disabledDiv.add(d)})},_initStates:function(d,c){var b=this;b.count=0;b.currentIdx=d.start;b.timeout=null;b.isHorizontal=d.orientation==="horizontal";b.width=c.width()||640;b.height=c.height()||480;b.offset=0;b.disabledEles=c;b.disabledDiv=a()},_create:function(){var b=this,c=b.options,e=b.element;if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);b._initStates(c,e);b._createDom(b.isHorizontal);b.list.bind("click."+b.widgetName,a.proxy(b._itemClick,b));if(c.showControlsOnHover){b.container.bind("mouseenter."+b.widgetName,function(){b._showControls()}).bind("mouseleave."+b.widgetName,function(){b._hideControls()});b.container.find(f).hide()}c.loadCallback&&a.isFunction(c.loadCallback)&&b._trigger("loadCallback",null,b);if(c.disabledState){var d=c.disabled;b.disable();c.disabled=d}else c.auto&&b.play();b.element.is(":hidden")&&b.element.wijAddVisibilityObserver&&b.element.wijAddVisibilityObserver(function(){b.refresh();b.element.wijRemoveVisibilityObserver&&b.element.wijRemoveVisibilityObserver()},"wijcarousel")},_showControls:function(){this.container.find(f).stop(true,true).fadeIn(600,function(){a(this).css("opacity","")})},_hideControls:function(){this.container.find(f).stop(true,true).fadeOut(600)},_applyContainerStyle:function(d,j){var a=this,h=a.options,g={},b=a.list,k=0,e,m=0,n=d?"left":"top",c=0,f,l=d?"width":"height";e=a.itemBound[d?"w":"h"];a.count=a.list.children("li").length;k=a.count*e;a.list[l](k);a.clip[l](h.display*e);a.clip[d?"height":"width"](a.itemBound[d?"h":"w"]);if(!h.loop){g[n]=-e*a.currentIdx;b.css(g)}else{f=b.find(">li:first");if(h.preview&&!!j)f=f.next();c=f.data("itemIndex");for(c;c<a.currentIdx;c++)b.children("li:first").appendTo(b);if(h.preview){if(!j)for(c=0;c<i;c++)b.children("li:last").prependTo(b);m=-e*i}g[n]=m;b.css(g)}},_applyListStyle:function(){var a=this,f=a.options,b=f.orientation==="horizontal",c=0,d,e=b?"width":"height";a.itemBound=a._getItemBound();d=a.itemBound[b?"w":"h"];c=a.count*d;a.list[e](c)},_createButtons:function(g,f){var b=this,h=b.options,e,d=c;a.each(["prevBtn","nextBtn"],function(q,j){var i=h[j+"Class"],k=j==="nextBtn",n=k?"next":"previous",m=k?o:p,l=k?f:g;if(i&&i.defaultClass){d=i.disableClass||d;e=i.hoverClass;b[j]=a('<a class="ui-state-default"></a>').addClass(i.defaultClass).mouseover(function(){!a(this).hasClass(d)&&a(this).addClass(e)}).mouseout(function(){!a(this).hasClass(d)&&a(this).removeClass(e)})}else b[j]=a(b._createBtn(m,l));b[j].bind("click."+b.widgetName,function(){var d=a(this);if(d.hasClass(c))return;b[n].call(b)}).appendTo(b.container)})},_applyBtnClass:function(){var e=this,g=e.options,b=c,f=d;a.each(["prevBtn","nextBtn"],function(i,d){var c=g[d+"Class"],h,a=e[d];if(c){b=c.disableClass||b;f=c.hoverClass||f}h=d==="prevBtn"?e.currentIdx<=0:e.currentIdx+g.display>=e.count;if(h&&!g.loop)a.removeClass(f).addClass(b);else a.hasClass(b)&&a.removeClass(b)})},_applyBtnStyle:function(b){var c=this,i=0,d,k={collision:"none",of:c.container,my:b?"right center":"center bottom",at:b?"right center":"center bottom"},m={collision:"none",of:c.container,my:b?"left center":"center top",at:b?"left center":"center top"},g=c.options.buttonPosition==="inside",e,f,j=["bottom","top","right","left"],h=function(e,f,g,c,d){e.removeClass(f).addClass(g);!isNaN(c)&&c!==0&&a.extend(d,{offset:b?c+" 0":"0 "+c});e.position(d)};i=b?c.prevBtn.width():c.prevBtn.height();d=g?0:i;e=l+j[b*2+g];f=l+j[b*2+!g];h(c.nextBtn,f,e,d,k);h(c.prevBtn,e,f,-d,m);c._applyBtnClass()},_createDom:function(d){var b=this,c=b.options,e=b.element,f,g,h,i;if(e.is("div")){b.list=e.children("ul:eq(0)");b.container=b.element;if(!b.list.length)b.list=a("<ul></ul>").appendTo(b.container)}else if(e.is("ul")){b.list=e;b.container=e.parent()}else return;b.itemBound=b._getItemBound();if(d){f=c.display>1&&!c.preview?t:v;g=E;h=I}else{f=c.display>1&&!c.preview?u:x;g=H;h=G}b.list.addClass(F).addClass(n);i=w+" "+f+" "+(c.preview?z+" ":"")+(c.display>1?y+" "+k:"");b.container.addClass(i);b._createItems(d);b._createClip(d);b._applyContainerStyle(d);b._createButtons(h,g);b._applyBtnStyle(d);c.preview&&b._createPreview();c.showTimer&&b._createTimer();c.showPager&&b._createPager();c.showControls&&b._createControls()},_createPreview:function(){var a=this,g=a.options,b,d,c=g.orientation==="horizontal",e=c?"left":"top",h=c?"right":"bottom",f;d=a.itemBound[c?"w":"h"];b=a.offset=Math.round(d/4);f=g.display*d+b*2;a.clip[c?"width":"height"](f);a.list.css(e,function(c,a){return parseFloat(a)+b});a.clip.css(e,function(){return-b});a.container.css("margin-"+e,b+"px").css("margin-"+h,b+"px");a._getItemByIndex(a.currentIdx).siblings().find(".wijmo-wijcarousel-text,.wijmo-wijcarousel-caption").hide()},_createItemsFromData:function(b){var c=this;if(!a.isArray(b)||!b.length||!a.isPlainObject(b[0])||a.isEmptyObject(b[0]))return;c.list.empty();a.each(b,function(e,b){var d;if(!a.isPlainObject(b))return true;d=c._generateMarkup(b);c.list.append(d)})},_generateMarkup:function(b){var c,d;if(!a.isPlainObject(b))return;c=a("<li></li>");if(typeof b.linkUrl==="string"&&b.linkUrl){d=a("<a>").attr("src",b.linkUrl);d.appendTo(c)}typeof b.imageUrl==="string"&&b.imageUrl&&a("<img>").attr("src",b.imageUrl).appendTo(d||c);typeof b.caption==="string"&&b.caption&&a("<span>").html(b.caption).appendTo(c);return c},_createItems:function(){var b=this,c,f,e=b.options,h,d;if(b.list){b._createItemsFromData(e.data);b.list.children("li").each(function(d){var c=a(this);b._createItem(c,d)});h=b.list.children("li").eq(b.currentIdx).addClass(g);if(e.preview&&e.display>1){c=d=h;for(f=0;f<e.display-1;f++){d=d.next();c=c.add(d)}c.find("div.wijmo-wijcarousel-mask").css({opacity:0})}}},_createItem:function(b,f){var c=this,g=c.options,e,d;e=b.addClass(q).addClass(n).find("img:eq(0)").attr("role","img").addClass("wijmo-wijcarousel-image");c._applyItemBound(b);d=b.children("span:eq(0)").hide();c._createCaption(b,e,d);g.preview&&a('<div class="wijmo-wijcarousel-mask">').appendTo(b);b.data("itemIndex",f);return b},_applyItemBound:function(b){var a=this,d=a.itemBound.w,c=a.itemBound.h;if(!a.itemWidth||!a.itemHeight){b.width(d).height(c);a.itemWidth=d-(b.outerWidth(true)-d);a.itemHeight=c-(b.outerHeight(true)-c)}b.width(a.itemWidth).height(a.itemHeight)},_createCaption:function(e,i,h){var f=this,j=f.options,b,g,c,d,k;if(j.showCaption){b=h.html()||i.attr("title");if(b&&b.length){c=a("<span></span>").html(b);d=a(m).addClass("wijmo-wijcarousel-caption").appendTo(e);g=a(m).addClass("ui-widget-content wijmo-wijcarousel-text").append(c).appendTo(e);f._applyCaptionStyle(d,g)}}},_applyCaptionStyle:function(d,c){var a=d.add(c),b;a.width(this.itemWidth);b=c.children("span").height();a.height(b)},_showCaption:function(b,c){var e=this,d=e._getItemByIndex(b),f=d.find(".wijmo-wijcarousel-text"),a=d.find(".wijmo-wijcarousel-caption");f.length&&f.fadeIn(300,function(){b<c&&e._showCaption(b+1,c)});if(a.length){a.show();a.animate({opacity:.5},300)}},_hideCaption:function(){this.element.find(".wijmo-wijcarousel-text,.wijmo-wijcarousel-caption").hide()},_createClip:function(){this.clip=this.list.wrap("<div></div>").parent().addClass(D)},_createBtn:function(f,e){var b=a(C);b.addClass(f).attr("role","button").mouseover(function(){!a(this).hasClass(c)&&a(this).addClass(d)}).mouseout(function(){!a(this).hasClass(c)&&a(this).removeClass(d)}).children("span:eq(0)").addClass(e);return b},_createControls:function(){var b=this,c=b.options,d={collision:"none",of:b.container,my:"center bottom",at:"center bottom"};if(c.control){b.controls=a(c.control).css({position:"absolute"}).appendTo(b.container);a.extend(d,c.controlPosition);b.controls.position(d)}},_createTimer:function(){var b=this;b._createPausePlay();b.progressBar=a("<div></div>").addClass("wijmo-wijcarousel-timerbar-inner "+k).css({width:"0%"}).attr("role","progressbar");b.timer=a("<div></div>").addClass("wijmo-wijcarousel-timerbar "+k).appendTo(b.container).append(b.progressBar).append(b.playPauseBtn)},_createPausePlay:function(){var b=this,c=b.options;b.playPauseBtn=a(b._createBtn(r,c.auto?j:h)).bind("click."+b.widgetName,function(){var c=a(this).children("span:eq(0)");b[c.hasClass(h)?"play":"pause"]()})},_createPagingItem:function(g,b,h,d){var c=a(A).attr({role:"tab","aria-label":d+1,title:d+1}),f,e;if(g)c.addClass("wijmo-wijcarousel-dot");else if(b&&b.images&&b.images[d]){f=b.imageWidth;e=b.imageHeight;f&&e&&c.width(f).height(e);c.children("a").append(a("<img>").attr("src",b.images[d]))}else return;h.append(c)},_createPaging:function(i){var b=this,j=b.options,f,h,g,c=j.thumbnails,e=i==="dots";b.container.append(b.pager=a('<div><ul class="wijmo-list ui-corner-all ui-helper-clearfix" role="tablist"></ul></div>'));!e&&b.pager.addClass("wijmo-wijcarousel-thumbnails");h=b.pager.children("ul.wijmo-list");for(f=0;f<b.count;f++)b._createPagingItem(e,c,h,f);g=b.pager.find("li").eq(b.currentIdx);g.length&&b._activePagerItem(g);c&&a.each(["mousedown","mouseup","mouseover","mouseout","click"],function(d,b){var a=c[b];if(a&&typeof a==="string"&&window[a])c[b]=window[a]});b.pager.bind("mouseover."+b.widgetName,function(a){b._pageingEvents(a,"mouseover",c,e,function(a){a.addClass(d)})}).bind("mouseout."+b.widgetName,function(a){b._pageingEvents(a,"mouseout",c,e,function(a){a.removeClass(d)})}).bind("click."+b.widgetName,function(a){b._pageingEvents(a,"click",c,e,function(a){b.scrollTo(a.index());b._activePagerItem(a)})});!e&&a.each(["mousedown","mouseup"],function(e,d){a.isFunction(c[d])&&b.pager.bind(d,function(b){var e=a(b.target).closest(s);e.length&&c[d].call(e,b)})})},_pageingEvents:function(b,f,d,g,e){var c=a(b.target).closest(s);if(c.length){a.isFunction(e)&&e.call(b,c);!g&&a.isFunction(d[f])&&d[f].call(c,b)}},_activePagerItem:function(a){a.addClass("ui-state-active").attr("aria-selected","true").siblings("li").removeClass("ui-state-active").removeAttr("aria-selected")},_createWijSlider:function(){var b=this,c=b.options.sliderOrientation,d={orientation:c,range:false,min:0,max:b.count-1,step:1,value:b.currentIdx,buttonClick:function(d,c){var a=c.value;b.scrollTo(a)},slide:function(d,c){var a=c.value;b.scrollTo(a)}},e=a("<div></div>").css("margin-bottom","10px").css(c==="horizontal"?"width":"height","200px").appendTo(b.container);b.pager=e.wijslider(d).parent().wrap("<div>").parent().addClass("wijmo-wijcarousel-slider-wrapper")},_createWijPager:function(){var b=this,c={pageCount:b.count,pageIndex:b.currentIdx,pageButtonCount:b.count,mode:"numeric",pageIndexChanged:function(d,c){var a=c.newPageIndex;b.scrollTo(a)}},d=a("<div></div>").appendTo(b.container);b.pager=d.wijpager(c).css({position:"absolute"})},_createPager:function(){var b=this,c=b.options,d={collision:"none",of:b.container,my:"right top",at:"right bottom"};if(c.pagerType==="numbers")b._createWijPager();else if(c.pagerType==="dots"||c.pagerType==="thumbnails"){b._createPaging(c.pagerType);b.pager.css({position:"absolute"})}else if(a.wijmo.wijslider&&c.pagerType==="slider"){b._createWijSlider();if(c.sliderOrientation!=="horizontal"){d.my="left center";d.at="right center"}}else return;b.pager.width(b.pager.width()+1);a.extend(d,c.pagerPosition);c.pagerPosition=d;b.pager.addClass("wijmo-wijcarousel-pager").position(d)},_setOption:function(c,d){var b=this,h=b.options,e,i,g,f=h.orientation==="horizontal";if(c==="pagerPosition"||c==="animation"||c==="controlPosition")a.extend(true,h[c],d);else{g=h[c];a.Widget.prototype._setOption.apply(b,arguments);switch(c){case"showControls":case"showPager":case"showTimer":if(d===g)break;e=c.replace(/show/i,"").toLowerCase();i=c.replace(/show/i,"_create");if(d===true)if(!b[e])b[i]();else b[e].jquery&&b[e].show();else b[e].hide();break;case"loop":case"orientation":case"display":case"preview":if(d!==g){b._destroy();b._create()}break;case"data":b._createItems(f);b._applyContainerStyle(f);b._applyBtnClass();h.showPager&&b._createPager();break;case"showCaption":if(d)b._createItems(f);else b.element.find(".wijmo-wijcarousel-caption,.wijmo-wijcarousel-text").remove();break;case"buttonPosition":b._applyBtnStyle(f);break;case"pagerType":if(d!==g){if(b.pager&&b.pager.jquery){b.pager.remove();b.pager=null}b._createPager()}break;case"disabled":b._handleDisabledOption(d,b.element)}}},_getItemBound:function(){var b={},a=this,c=a.options;if(c.orientation==="horizontal")b={w:Math.round(a.width/c.display),h:a.height};else b={w:a.width,h:Math.round(a.height/c.display)};return b},_stopAnimation:function(){var a=this;a.isPlaying&&a.progressBar&&a.progressBar.stop().css({width:"0%"});a.list.stop(true,true)},_itemClick:function(g){var i=a(g.target),b=this,j=b.options,e=b.currentIdx,c=i.closest("li."+q,i),d=c.data("itemIndex"),h,f;if(c.length>0){if(j.preview&&d<e||d>e+j.display-1){h=b._getItemByIndex(e).index();f=c.index()>h?"next":"previous";b[f]()}b._trigger("itemClick",g,{index:d,el:c})}},_destroy:function(){var b=this;b.container.removeClass("wijmo-wijcarousel ui-widget").removeClass("wijmo-wijcarousel-horizontal").removeClass("wijmo-wijcarousel-vertical");b.list.unwrap().removeClass("wijmo-wijcarousel-list ui-helper-clearfix").unbind("."+b.widgetName).removeAttr("style").children("li").each(function(){var b=a(this);b.removeClass("wijmo-wijcarousel-item ui-helper-clearfix").removeClass(g);b.children("img").removeClass("wijmo-wijcarousel-image");b.children(".wijmo-wijcarousel-caption,.wijmo-wijcarousel-text").remove();b.css({width:"",height:""});b.removeData("itemIndex")});b.itemWidth=b.itemHeight=undefined;b.element.find(f+",.wijmo-wijcarousel-timerbar").remove();b.pager&&b.pager.wijpager("destroy").remove();b.element.find("li>span").css("display","");if(b.disabledDiv.length){b.disabledDiv.remove();b.disabledDiv=a()}},destroy:function(){this._destroy();a.Widget.prototype.destroy.apply(this)},_resetDom:function(){var b=this;b._applyListStyle();b.list.children("li").each(function(){var c=a(this),d=c.children("div.wijmo-wijcarousel-caption"),e=c.children("div.wijmo-wijcarousel-text");b._applyItemBound(c);b._setStyle(d.add(e),function(){b._applyCaptionStyle(d,e)})});b._applyContainerStyle(b.isHorizontal,true);b.options.preview&&b._createPreview();b._setStyle(b.prevBtn.add(b.nextBtn),function(){b._applyBtnStyle(b.isHorizontal)});b._setStyle(b.pager,function(){b.pager.position(b.options.pagerPosition)});b._setStyle(b.controls,function(){b.controls.position(b.options.controlPosition)})},_setStyle:function(a,c){var b=true;if(!a||a.length===0)return;if(a.css("display")=="none"){b=false;a.css("display","")}c.call(this);!b&&a.css("display","none")},refresh:function(){var a=this,c=a.options,b=a.element;a.width=b.width()||640;a.height=b.height()||480;a.itemWidth=a.itemHeight=0;a._resetDom();a.pause()},play:function(){var a=this,b=a.options;if(a.isPlaying)return;if(b.interval===0)return a.pause();if(b.showTimer&&a.progressBar){a.progressBar.css({width:"0%"});a.playPauseBtn.children("span:eq(0)").removeClass(h).addClass(j);a.progressBar.animate({width:"100%"},b.interval,function(){a._scroll("next",b.step)})}else{if(a.timeout)return;a.timeout=window.setTimeout(function(){a.next()},b.interval)}a.isPlaying=true},pause:function(){var a=this,b=a.options;if(b.showTimer&&a.progressBar){a.progressBar.stop().css({width:"0%"});a.playPauseBtn.children("span:eq(0)").removeClass(j).addClass(h)}else{if(a.timeout===null)return;window.clearTimeout(a.timeout);a.timeout=null}a.isPlaying=false},next:function(){var a=this,b=a.options.step;if(typeof b!=="number"||b<1)return;a._stopAnimation();a._scroll("next",b)},previous:function(){var a=this,b=a.options.step;if(typeof b!=="number"||b<1)return;a._stopAnimation();a._scroll("previous",b)},scrollTo:function(b){var a=this,c,d;a._stopAnimation();c=b>a.currentIdx?"next":"previous";d=Math.abs(b-a.currentIdx);b!==a.currentIdx&&a._scroll(c,d)},_scroll:function(m,k){var b=this,d=b.options,p=b.list,c=0,n,h,r=d.orientation==="horizontal",j={},e=b.itemBound[r?"w":"h"],l=r?"left":"top",f=k,s={},q=0,o=b.currentIdx*e;if(!d.loop){if(m==="next")if(b.currentIdx+d.display+k<=b.count)c=-o-e*f;else if(b.currentIdx+d.display<b.count){f=b.count-b.currentIdx-d.display;c=-o-e*f}else return;else if(b.currentIdx-k>=0)c=-o+e*f;else if(b.currentIdx>0){f=b.currentIdx;c=0}if(c!==undefined){j[l]=c+b.offset;b._doAnimation(m,j,f)}}else{if(d.preview)c=q=-e*i+b.offset;if(m==="next"){c+=-e*f;j[l]=c}else{for(h=0;h<k;h++){c-=e;p.children("li:last").prependTo(p)}s[l]=c;j[l]=q;p.css(s)}b._doAnimation(m,j,k,l,e)}if(d.preview){n=a();for(h=0;h<d.display;h++)n=n.add(b._getItemByIndex(b.currentIdx+h).find("div.wijmo-wijcarousel-mask:eq(0)"));n.stop(true).animate({opacity:.6},d.animation.duration/2,function(){b._getItemByIndex(b.currentIdx).removeClass(g)})}},_doAnimation:function(k,o,h,n,p){var b=this,e=b.list,d=b.options,l,j,g={},f,m={},c;if(!b.list.children().length)return;if(k==="next")c=b.currentIdx+h;else c=b.currentIdx-h;if(!d.loop)f=function(){b.currentIdx=c;b._setCurrentState(b.currentIdx)};else{c=c%b.count+(c<0?b.count:0);f=function(){var a=0;if(d.preview)a=b.offset-i*p;if(k==="next"){for(j=0;j<h;j++)e.children("li:first").appendTo(e);if(n){m[n]=a;e.css(m)}}b.currentIdx=c;b._setCurrentState(b.currentIdx)}}g.complete=f;l={index:b.currentIdx,to:c,el:b._getItemByIndex(b.currentIdx)};if(!b._trigger("beforeScroll",null,l))return;if(d.animation&&d.animation.complete)d.animation.complete=undefined;a.extend(g,d.animation);b._hideCaption();e.animate(o,g)},_setCurrentState:function(c){var b=this,d=b.options,i,l,k,h=c+d.display-1,j,e,f;if(!d.loop){k=c+d.display<b.count;if(b.isPlaying&&k){window.clearTimeout(b.timeout);b.timeout=null;b.isPlaying=false;b.play()}else b.progressBar&&b.pause();b._applyBtnClass()}else if(b.isPlaying){window.clearTimeout(b.timeout);b.timeout=null;b.isPlaying=false;b.play()}if(d.preview){e=a();j=b._getItemByIndex(c);for(f=0;f<d.display;f++)e=e.add(b._getItemByIndex(c+f).find("div.wijmo-wijcarousel-mask:eq(0)"));e.animate({opacity:0},d.animation.duration/2,function(){j.addClass(g);b._showCaption(c,h)})}else b._showCaption(c,h);if(b.pager)if(a.wijmo.wijslider&&b.pager.find(":wijmo-wijslider").length)b.pager.find(":wijmo-wijslider:eq(0)").wijslider("value",c);else if(a.wijmo.wijpager&&b.pager.is(":wijmo-wijpager"))b.pager.wijpager("option","pageIndex",c);else if(b.pager.jquery){i=b.pager.find(">ul:eq(0)>li").eq(c);i.length&&b._activePagerItem(i)}l={firstIndex:c,lastIndex:h};b._trigger("afterScroll",null,l)},_getItemByIndex:function(f){var b=this,e=b.list,d,c=f%b.count;if(!b.options.loop)return e.children("li").eq(c);e.children("li").each(function(){var b=a(this);if(b.data("itemIndex")===c){d=b;return false}});return d},widget:function(){return this.container},_collectionChanged:function(b){var a=this;a.count=a.count+(b==="add"?1:-1);a._applyListStyle();if(a.pager&&a.pager.jquery){a.pager.remove();a.pager=null;a._createPager()}a._applyBtnClass()},add:function(e,d){var b=this,c,f;if(typeof e==="string")c=a(e);else if(e.jquery)c=e;else if(a.isPlainObject(e))c=b._generateMarkup(e);else return;if(!c.is("li"))c=c.wrap("<li></li>").parent();f=c;if(typeof d==="number"&&d>=0&&d<b.count){f.insertBefore(b._getItemByIndex(d));b.list.children("li").each(function(){var b=a(this);b.data("itemIndex")>=d&&b.data("itemIndex",b.data("itemIndex")+1)})}else f.insertAfter(b._getItemByIndex(b.count-1));b._createItem(c,d!==undefined?d:b.count);b._collectionChanged("add")},remove:function(c){var b=this,d;if(typeof c==="number"&&c>=0&&c<b.count){d=b._getItemByIndex(c);b.list.children("li").each(function(){var b=a(this);b.data("itemIndex")>c&&b.data("itemIndex",b.data("itemIndex")-1)})}else d=b._getItemByIndex(b.count-1);d&&d.remove();b._collectionChanged("remove")}})})(jQuery);
(function(a){"use strict";var h="ui-helper-clearfix",m="ui-widget-content",i="ui-corner-all",b="ui-state-disabled",c="ui-state-hover",n="ui-state-default",j="wijmo-wijgallery-",k=j+"button-",v=j+"button",s="ui-icon-triangle-1-e",u="ui-icon-triangle-1-w",d="ui-icon-play",e="ui-icon-pause",o="ui-widget-content ui-state-default wijmo-wijgallery-thumbs-pointer-{0}",f="wijmo-wijgallery-flashwrapper",q='<div class="wijmo-wijgallery-frame  ui-widget-content '+h+'"><div class="wijmo-wijgallery-content"></div></div>',p='<div class="wijmo-wijgallery-thumbs"></div>',r='<a class="ui-state-default"><span class="ui-icon"></span></a>',t='<div class="wijmo-wijgallery-frame-{0}"><a href="#" class="wijmo-wijgallery-frame-link"></a></div>',g='<div class="ui-widget-content '+h+'"></div>',l="li.wijmo-wijcarousel-item";a.widget("wijmo.wijgallery",{options:{autoPlay:false,scrollWithSelection:false,showTimer:true,interval:5e3,showCaption:true,data:[],showControls:false,control:"",controlPosition:{},showCounter:true,counter:"[i] of [n]",showPager:false,pagingPosition:{},thumbnailOrientation:"horizontal",thumbnailDirection:"after",transitions:{animated:"slide",duration:1e3,easing:null},showControlsOnHover:true,thumbsDisplay:5,thumbsLength:100,beforeTransition:null,afterTransition:null,loadCallback:null,showMovieControls:false,autoPlayMovies:true,flashParams:{bgcolor:"#000000",allowfullscreen:true,wmode:"transparent"},flashVars:{},flashVersion:"9.0.115",flvPlayer:"player\\player.swf",flashInstall:"player\\expressInstall.swf",mode:"img"},_setOption:function(c,d){var b=this,i=b.options,e,f,h,g;if(c==="framePosition"||c==="thumbnailPosition"||c==="transitions"||c==="pagingPosition")a.extend(true,i[c],d);else{h=i[c];a.Widget.prototype._setOption.apply(b,arguments);switch(c){case"disabled":b._handleDisabledOption(d,b.element);break;case"thumbnailOrientation":b.thumbs[b.thumbWidgetName]({orientation:d});break;case"thumbsDisplay":b.thumbs[b.thumbWidgetName]({display:d});break;case"autoPlay":b[d?"play":"pause"]();break;case"showCounter":case"showTimer":case"showControls":e=c.replace(/show/i,"").toLowerCase();f=c.replace(/show/i,"_create");if(d!==h)if(d===true)if(!b[e])b[f]();else b[e].jquery&&b[e].show();else b[e].hide();break;case"showCaption":if(d){b._createCaption(b.size);g=b._loadCaption(b.images[b.currentIdx]);g.show()}else b.element.find(".wijmo-wijgallery-caption,.wijmo-wijgallery-text").remove();break;case"showPager":case"thumbsLength":case"thumbnailDirection":case"showControlsOnHover":case"mode":case"data":b._destroy();b._create()}}},thumbWidgetName:"wijcarousel",_handleDisabledOption:function(c){var b=this;if(b.pager&&!b.pager.is(":hidden"))b.disabledEles=b.disabledEles.add(b.pager);if(c){!b.disabledDiv.length&&b._createDisabledDiv();b.disabledDiv.appendTo("body")}else if(b.disabledDiv){b.disabledDiv.remove();b.disabledDiv=a()}},_createDisabledDiv:function(){var b=this;b.disabledEles.each(function(){var d=a(this),e=d.offset(),g=d.outerWidth(),f=d.outerHeight(),c=a("<div></div>").addClass("ui-state-disabled").css({"z-index":"99999",position:"absolute",width:g,height:f,left:e.left,top:e.top});if(a.browser.msie){c.css("background-color","white");a.browser.version==="9.0"&&c.css("opacity","0.1")}b.disabledDiv=b.disabledDiv.add(c)})},_initLi:function(e){var d=e.children("a:eq(0)"),c=e.find("img:eq(0)"),f=e.find("span:eq(0)"),b={title:c.attr("alt"),caption:null};if(d.length&&d.attr("href")){b.url=d.attr("href");if(!b.title)b.title=d.attr("title")}else if(c.length)b.url=c.attr("src");if(f.length)b.caption=f;else if(c.attr("title"))b.caption=a("<span>").html(c.attr("title"));b.thumbUrl=c.attr("src");return b},_initStatus:function(){var b=this,c;b.images=[];b.ul=b.element.children("ul");c=b.ul.children("li");b.count=c.length;c.each(function(){var c=b._initLi(a(this));b.images.push(c)})},_createMarkupFromData:function(){var b=this,f=b.options,d=f.data,e=b.element,c=e.children("ul:eq(0)");b.images=d;if(c.length)c.empty();else c=a("<ul>").appendTo(e);b.ul=c;a.each(d,function(g,b){var e=a("<a>"),f=a("<li>"),d=a("<img>");b.url&&e.attr("href",b.url);b.thumbUrl&&d.attr("src",b.thumbUrl);b.title&&d.attr("alt");e.append(d).appendTo(f);f.appendTo(c)});b.count=d.length},_create:function(){var b=this,c=b.options;b.container=b.element;b.container.addClass("wijmo-wijgallery ui-widget");b.currentThumbIdx=0;b.currentIdx=-1;b.disabledEles=b.element;b.disabledDiv=a();if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);if(c.showPager){c.pagingPosition=true;c.thumbnails=false}else c.thumbnails=true;if(c.data&&c.data.length)b._createMarkupFromData();else b._initStatus();c.loadCallback&&a.isFunction(c.loadCallback)&&b._trigger("loadCallback",null,b);b._createDom();c.autoPlay&&b.play();if(c.showControlsOnHover){b.frame.find(".wijmo-wijpager,.wijmo-wijgallery-button-next,.wijmo-wijgallery-counter,.wijmo-wijgallery-button-previous").hide();!b.isPlaying&&b.timer&&b.timer.hide()}c.disabled&&b.disable();b.element.is(":hidden")&&b.element.wijAddVisibilityObserver&&b.element.wijAddVisibilityObserver(function(){b.refresh();b.element.wijRemoveVisibilityObserver&&b.element.wijRemoveVisibilityObserver()},"wijgallery")},_createDom:function(){var a=this,b=a.options;if(b.thumbnails)a._createThumbnails();else a.ul.hide();a._createFrame();b.control&&a._createControls();b.showCounter&&a._createCounter();b.showTimer&&a._createTimer();b.showPager&&a._createPager()},_getFrameSize:function(){var a=this,d=a.options.thumbnailOrientation==="horizontal",b=a.element.height()-(d?a.thumbs?a.thumbs.outerHeight(true):0:0),c=a.element.width()-(d?0:a.thumbs?a.thumbs.outerWidth(true):0);return{w:c<2||!c?750:c,h:b<2||!b?300:b}},_createFrame:function(){var b=this,d=b.options,f,e,c=b._getFrameSize(),g=d.thumbnailDirection==="after";b.frame=a(q)[g?"prependTo":"appendTo"](b.container).setOutWidth(c.w-1).setOutHeight(c.h).wrap('<div class="wijmo-wijgallery-framewrapper">');b.size=c;f=b.frame.width();e=b.frame.height();b.frameWrapper=b.frame.parent();d.thumbnailOrientation==="vertical"&&b.frameWrapper.addClass("wijmo-wijgallery-framewrapper-vertical");d.showControlsOnHover&&b.frame.bind("mouseenter."+b.widgetName,function(){b._showControls("controls")}).bind("mouseleave."+b.widgetName,function(){b._hideControls("controls")});b.content=b.frame.children("div.wijmo-wijgallery-content");d.mode==="img"&&b._createFrameMask();b._createPrevNextBtn();b._createCaption(c);b._createLoading();b.last=a('<div class="ui-widget-overlay wijmo-wijgallery-last"></div>').appendTo(b.content).width(f).height(e).css({"line-height":c.h+"px"});b.current=a('<div class="ui-widget-overlay wijmo-wijgallery-current"></div>').appendTo(b.content).width(f).height(e).css({"line-height":c.h+"px"});b._show(0)},_createControls:function(){var b=this,c=b.options,d={collision:"none",of:b.container,my:"center bottom",at:"center bottom"};if(c.control){b.controls=a(c.control).css({position:"absolute"}).appendTo(b.container);a.extend(d,c.controlPosition);b.controls.position(d)}},_createLoading:function(){var b=this;b.loading=a("<div></div>").addClass("wijmo-wijgallery-loading").appendTo(b.content);b.loading.css({left:(b.content.width()-b.loading.width())/2,top:(b.content.height()-b.loading.height())/2});b.loading.hide()},_createFrameMask:function(){var b=this,c=b.options;a.each(["previous","next"],function(g,d){var e=a(t.replace(/\{0\}/,d)).appendTo(b.frame),f=e.children("a");c.showControlsOnHover&&e.bind("mouseenter."+b.widgetName,function(){b._showControls(d)}).bind("mouseleave."+b.widgetName,function(){b._hideControls(d)});f.bind("click."+b.widgetName,function(a){b[d]();a.preventDefault()})})},_createCounter:function(){var b=this,c=b.options;if(!c.showCounter){if(b.counter){b.counter.remove();b.counter=undefined}return}if(!b.counter)b.counter=a("<div></div>").addClass("wijmo-wijgallery-counter ui-state-default ui-corner-tl").appendTo(b.frame);b._refreshCounter()},_refreshCounter:function(){var b=this,d=b.options,c;if(!b.counter)return;b.counter.empty();if(d.counter){c=d.counter.replace(/\[i\]/,b.currentIdx+1);c=c.replace(/\[n\]/,b.count);a("<span></span>").text(c).appendTo(b.counter)}},_createPrevNextBtn:function(){var b=this;a.each(["next","previous"],function(f,c){var e=c==="next"?s:u,d;d=b.frame.find(".wijmo-wijgallery-frame-"+c);if(!d.length||b.options.mode!=="img")d=b.frame;b[c+"Btn"]=a(b._createBtn(k+c,e)).bind("click."+b.widgetName,a.proxy(b[c],b)).appendTo(d);b._applyBtnStyle(c)})},_applyBtnStyle:function(e){var a=this,f=e==="next",d=a[e+"Btn"],g=f?"right center":"left center",k=g,j="ui-corner-"+(f?"left":"right"),i=e==="next"?a.currentIdx>=a.count:a.currentIdx<=0,h={collision:"none",of:a.frame,my:k,at:g};d.addClass(j).position(h);if(i)d.removeClass(c).addClass(b);else d.hasClass(b)&&d.removeClass(b)},_createCaption:function(c){var b=this,d=b.options;if(d.showCaption){b.overlay=a(g).addClass("wijmo-wijgallery-caption").width(c.w).appendTo(b.content);b.caption=a(g).addClass("wijmo-wijgallery-text").width(c.w).appendTo(b.content)}},_loadCaption:function(g){var f=this,d=g.caption,e,c=a("<span></span>"),b=f.element.find(".wijmo-wijgallery-text,.wijmo-wijgallery-caption");if(d){b.show();d.jquery&&d.show();c.html(d);f.caption.empty().append(c);e=c.outerHeight(true);b.height(e);a.browser.msie&&b.height(c.css("display","block").outerHeight(true))}b.hide();return b},_showCaption:function(b){var a=this;if(b&&b.caption){a.caption.length&&a.caption.fadeIn(500);a.overlay.length&&a.overlay.show().animate({opacity:.5},500)}},_createTooltip:function(c){var b=this,d=c||"bottom";b.pointer=a("<div>").addClass(o.replace(/\{0\}/,d));b.pointer.appendTo(b.thumbsWrapper).hide()},_createThumbnails:function(){var b=this,d=b.options,h=d.thumbnailDirection==="after",g="wijmo-wijgallery-thumbs-{0}",e=d.thumbnailOrientation==="horizontal",f=h?e?"bottom":"right":e?"top":"left";b.thumbPosition=f;b.thumbs=a(p).appendTo(b.container).addClass(m).addClass(e?"wijmo-wijcarousel-horizontal-multi":"wijmo-wijcarousel-vertical-multi");if(e)b.thumbs.css({height:d.thumbsLength+"px"}).setOutWidth(b.element.width());else b.thumbs.css({width:d.thumbsLength+"px"}).setOutHeight(b.element.height());b.ul.appendTo(b.thumbs);b.ul.children("li").each(function(f){var c=a(this).children("a"),d=b.images[f],e=d.thumbUrl;if(!c.length){c=a(this).wrapInner("<a>").children("a");c.attr("href",e)}});if(a[b.namespace][b.thumbWidgetName]){b.thumbs.addClass(g.replace(/\{0\}/,f)).find("li").addClass(n).hover(function(){a(this).addClass(c)},function(){a(this).removeClass(c)});b.thumbsWrapper=b.thumbs[b.thumbWidgetName]({display:d.thumbsDisplay,step:d.thumbsDisplay-1,itemPadding:"0 10px",showCaption:false,orientation:d.thumbnailOrientation,loop:false,itemClick:function(a,d){var c=d.index;b.show(c);a.preventDefault()},afterScroll:function(c,a){b.currentThumbIdx=a.firstIndex;b.activeLi&&b.activeLi.is("li")&&b.activeLi.index()>=a.firstIndex&&b.activeLi.index()<=a.lastIndex&&b._highlightThumb(b.activeLi);b.isScrolling=false},beforeScroll:function(){b.isScrolling=true;if(d.mode==="swf"||d.mode==="flv")b.pointer.hide();else b.pointer.fadeOut(100)}}).wrap('<div class="wijmo-wijgallery-thumbswrapper">').parent();!e&&b.thumbsWrapper.addClass("wijmo-wijgallery-thumbswrapper-vertical");b._createTooltip(f)}},_calculatePosition:function(a,g,f,e,d,b){var c=this;if(c.thumbPosition==="bottom"){a.left=a.left+(e-g)/2+b;a.top=a.top-f}else if(c.thumbPosition==="top"){a.left=a.left+(e-g)/2+b;a.top=a.top+d+2*b}else if(c.thumbPosition==="left"){a.left=a.left+e+2*b;a.top=a.top+(d-f)/2+b}else if(c.thumbPosition==="right"){a.left=a.left-g;a.top=a.top+(d-f)/2+b}},_highlightThumb:function(a){var b=this,h,g,e,d,c,f;if(a&&a.length){a.siblings("li.wijmo-wijgallery-selected").removeClass("wijmo-wijgallery-selected ui-state-active");a.addClass("wijmo-wijgallery-selected ui-state-active");h=b.pointer.outerWidth(true);g=b.pointer.outerHeight(true);e=a.width();d=a.height();c=a.offset();f=5;b._calculatePosition(c,h,g,e,d,f);b.pointer.fadeIn(100);b.pointer.offset(c)}},_getSelector:function(b,e){var a,c=".wijmo-wijgallery-button-",d=".wijmo-wijpager,.wijmo-wijgallery-counter";if(e)d+=",.wijmo-wijgallery-timerbar";if(b==="next"||b==="previous")a=c+b;else if(b==="controls")a=d;else a=d+","+c+"next,"+c+"previous";return a},_showControls:function(d){var b=this,c;c=b._getSelector(d,!b.isPlaying&&b.timer);b.frame.find(c).stop(true,true).fadeIn(400,function(){a(this).css("opacity","")})},_hideControls:function(c){var a=this,b;b=a._getSelector(c,!a.isPlaying&&a.timer);this.frame.find(b).stop(true,true).fadeOut(600)},_createPager:function(){var b=this,f=b.options,d,c=f.thumbsDisplay,e=1,h=b.currentIdx,g=b.currentIdx,i={collision:"none",of:b.container,my:"right top",at:"right bottom"};if(f.thumbnails){d=a("<div></div>").appendTo(b.thumbs);if(c!==0){e=Math.ceil(b.count/c);h=Math.ceil(b.currentIdx/c)}b.pager=d.wijpager({pageCount:e,pageIndex:h,pageButtonCount:e,mode:"numeric",pageIndexChanged:function(d,e){var a=e.newPageIndex;(g<a*c||g>=(a+1)*c)&&b.thumbs[b.thumbWidgetName]("scrollTo",a*c);d.preventDefault()}}).css({position:"absolute"})}else{d=a("<div></div>").appendTo(b.container);b.pager=d.wijpager({pageCount:b.count,pageIndex:b.currentIdx,pageButtonCount:b.count,mode:"numeric",pageIndexChanged:function(d,c){var a=c.newPageIndex;b._show(a)}}).css({position:"absolute"});a.extend(i,f.pagingPosition);b.pager.addClass("wijmo-wijgallery-pager").position(i)}},_createBtn:function(f,e){var d=a(r);d.addClass(f).attr("role","button").bind("mouseover"+this.widgetName,function(){if(a(this).hasClass(b))return;a(this).addClass(c)}).bind("mouseout"+this.widgetName,function(){if(a(this).hasClass(b))return;a(this).removeClass(c)});d.children("span:eq(0)").addClass(e);return d},_createTimer:function(){var b=this;b._createPausePlay();b.progressBar=a("<div></div>").addClass("wijmo-wijgallery-timerbar-inner "+i).css({width:"0%"}).attr("role","progressbar");b.timer=a("<div></div>").addClass("wijmo-wijgallery-timerbar "+i).appendTo(b.frame).append(b.progressBar).append(b.playPauseBtn)},_createPausePlay:function(){var c=this,f=c.options;c.playPauseBtn=a(c._createBtn(v,f.autoPlay?e:d)).bind("click."+c.widgetName,function(){if(!a(this).hasClass(b)){var e=a(this).children("span:eq(0)");c[e.hasClass(d)?"play":"pause"]()}})},_show:function(c){var b=this,d=b.images[c],g,h,i,j=b._getFrameSize(),k=b.options,e=k.mode;if(b.currentIdx===c)return;if(d&&a.isPlainObject(d)){b.loading.delay(500).fadeIn(100);i=b.last.children("img,div."+f);i.length&&i.remove();if(e==="swf"||e==="flv"){b.last.hide();b.current.empty();b._wrapFlash(b.current,e,d.url);b.picture=b.current.children("div."+f);b._setCurrentStates(c);b.loading.stop().hide();b._thumbsScroll(c)}else if(e==="img"){b.picture&&b.picture.length&&b.last.append(b.picture.unbind("load"));b.current.hide();b.last.show();b.picture=a("<img>").attr({src:d.url,alt:d.title}).appendTo(b.current).data("itemIndex",c);if(b.picture[0].complete&&a.browser.msie)b._imageLoaded(b,j);else b.picture.bind("load",function(){b._imageLoaded(b,j)})}else if(e==="iframe"){if(b.current.is(":hidden")){g=b.current;h=b.last}else{g=b.last;h=b.current}b.picture=a("<iframe></iframe>").addClass("wijmo-wijgallery-iframe").attr({frameborder:"0",marginwidth:"0",marginheight:"0",scrolling:"auto",allowtransparency:"true",src:d.url}).hide().appendTo(g).data("itemIndex",c).bind("load",function(){var d=a(this),c=d.data("itemIndex");b.loading.stop().hide();b.pointer&&b.pointer.fadeOut(100);b._setCurrentStates(c);if(c!==undefined){d.show();h.fadeOut(function(){h.empty()});g.fadeIn()}})}}},_imageLoaded:function(a,c){var b=a.picture.attr("role","img"),d=b.data("itemIndex"),f=b[0].naturalWidth||b.width(),e=b[0].naturalHeight||b.height(),g=a.images[d];a.loading.stop().hide();a.pointer&&a.pointer.fadeOut(100);if(f>c.w||e>c.h)if(f/e>c.w/c.h)b.css({width:"100%"});else b.css({height:"100%"});else f<c.w&&e<c.h&&b.addClass("ui-state-default wijmo-wijgallery-small-image");if(d!==undefined){a.options.showCaption&&a.caption&&a._loadCaption(g);a._animate(d)}},_animate:function(d){var b=this,n=b.options,l=n.transitions,f=n.thumbnailOrientation==="horizontal",h,g,j,k,m,e,c=l.animated,i=l.duration;if(!b.last.children().length){b._setCurrentStates(d);b.last.hide();b.current.show();return}m={index:b.currentIdx,to:d,toImg:b.images[d]};if(!b._trigger("beforeTransition",null,m))return;if(c)if(c==="slide"){h=b.size.w;g=b.size.h;b.current.show();e=b.currentIdx>d?true:false;j=a.effects.createWrapper(b.last).css({overflow:"hidden",width:f?h*2:h,height:f?g:g*2,left:f?e?-h:0:0,top:f?0:e?-g:0});j[e?"prepend":"append"](b.current);j.animate({left:f?e?0:-h:0,top:f?0:e?0:-g},i,function(){b.last.parent().is(".ui-effects-wrapper")&&b.last.unwrap();b.last.hide();b._setCurrentStates(d)})}else if(c==="explode"||c==="scale"||c==="blind"||c==="fold"){b.current.css({position:"absolute"});b.current.stop(true,true).show(c,i,function(){b.last.hide();b._setCurrentStates(d)})}else if(c==="size"){b.last.hide();b.current.stop(true,true).show(c,i,function(){b.last.hide();b._setCurrentStates(d)})}else{k=i/2;b.last.hide(c,k,function(){b.last.hide();b.current.stop(true,true).show(c,k,function(){b._setCurrentStates(d)})})}else{b.last.hide();b.current.show();b._setCurrentStates(d)}b._thumbsScroll(d)},_thumbsScroll:function(b){var d,a=this,c=a.options;if(a.thumbs&&a.thumbs[a.thumbWidgetName])if(c.scrollWithSelection){d=b-Math.ceil(c.thumbsDisplay/2)+1;a.thumbs[a.thumbWidgetName]("scrollTo",d)}else if(b>c.thumbsDisplay+a.currentThumbIdx-1)a.thumbs[a.thumbWidgetName]("scrollTo",b-c.thumbsDisplay+1);else b<a.currentThumbIdx&&a.thumbs[a.thumbWidgetName]("scrollTo",b)},_setCurrentStates:function(d){var a=this,h=a.options,e,f,g;g=a.currentIdx;a.currentIdx=d;e=d+1<a.count;if(a.isPlaying&&e){a.timeout=null;a.isPlaying=false;a.play()}else a.progressBar&&a.pause();if(d+1>=a.count)a.nextBtn.add(a.playPauseBtn).removeClass(c).addClass(b);else a.nextBtn.add(a.playPauseBtn).removeClass(b);if(d<=0)a.previousBtn.removeClass(c).addClass(b);else a.previousBtn.removeClass(b);h.showCaption&&a._showCaption(a.images[d]);if(a.thumbs&&a.thumbs[a.thumbWidgetName]){a.activeLi=a.thumbs.find(l).eq(d);!a.isScrolling&&a._highlightThumb(a.activeLi)}else if(a.pager)a.pager.is(":wijmo-wijpager")&&a.pager.wijpager("option","pageIndex",d);a._refreshCounter();a._clearCss();f={last:g,index:a.currentIdx,toImg:a.images[a.currentIdx]};a._trigger("afterTransition",null,f)},_clearCss:function(){this.current.css({position:"",visibility:""})},_resetState:function(){var a=this;a._stopAnimation();if(a.isPlaying&&a.progressBar){a.progressBar.stop();a.progressBar.css({width:"0%"})}},_stopAnimation:function(){var b=this,a;a=b.content.find(".ui-effects-wrapper");a.length&&a.stop(true,true);b.current.stop(true,true);b.last.stop(true,true)},widget:function(){return this.element},count:function(){return this.count},_destroy:function(){var b=this;b.frame.unwrap().remove();if(b.options.thumbnails){if(a[b.namespace][b.thumbWidgetName]){b.thumbs[b.thumbWidgetName]("destroy");b.element.find("li").unbind().removeClass("ui-state-active").filter(".wijmo-wijgallery-selected").removeClass("wijmo-wijgallery-selected");b.thumbs.children("ul").unwrap().unwrap()}}else{b.pager&&b.pager.length&&b.pager.remove();b.element.find("ul").css({display:""})}b.pointer&&b.pointer.remove();b.element.removeClass("wijmo-wijgallery ui-widget ui-widget-content ui-corner-all");if(b.disabledDiv){b.disabledDiv.remove();b.disabledDiv=null}},destroy:function(){this._destroy();a.Widget.prototype.destroy.apply(this)},show:function(b){var a=this;a._resetState();a._show(b)},next:function(){var a=this,b;a._resetState();b=a.currentIdx+1;b<a.count&&a._show(b)},previous:function(){var a=this,b;a._resetState();b=a.currentIdx-1;b>=0&&a._show(b)},play:function(){var a=this,b=a.options;if(a.isPlaying)return;if(b.interval===0)return a.pause();if(b.showTimer&&a.progressBar){a.progressBar.css({width:"0%"});a.playPauseBtn.children("span:eq(0)").removeClass(d).addClass(e);a.progressBar.animate({width:"100%"},b.interval,function(){a._show(a.currentIdx+1)})}else{if(a.timeout)return;a.timeout=window.setTimeout(function(){a.next()},b.interval)}a.isPlaying=true},pause:function(){var a=this,b=a.options;if(b.showTimer&&a.progressBar){a.progressBar.stop();a.progressBar.css({width:"0%"});a.playPauseBtn.children("span:eq(0)").removeClass(e).addClass(d)}else{if(a.timeout===null)return;window.clearTimeout(a.timeout);a.timeout=null}a.isPlaying=false},add:function(c,d){var b=this,e,g,f;if(typeof c==="string"){e=a(c);f=b._initLi(e)}else if(c.jquery){e=c;f=b._initLi(e)}else if(a.isPlainObject(c))f=c;else return;if(!d||d>b.count)g=b.count;else if(d<0)g=0;else g=d;b.images.splice(g,0,f);b.count++;b.thumbs&&b.thumbs[b.thumbWidgetName]&&b.thumbs[b.thumbWidgetName]("add",e,d)},remove:function(b){var a=this,c;if(!b||b>a.count)c=a.count;else if(b<0)c=0;else c=b;a.images.splice(c,1);a.count--;a.thumbs&&a.thumbs[a.thumbWidgetName]&&a.thumbs[a.thumbWidgetName]("remove",b)},_getExt:function(a){var c,b,e=/[0-9a-z]+$/i,d=a.indexOf("?");if(d>-1)a=a.substring(0,d);b=a.match(e);if(b)c=b[0].toLowerCase();return c},_getPlayerName:function(c){if(c.indexOf("#")===0||c.indexOf("#")>0&&c.indexOf(document.location.href)===0)return"inline";var e=["bmp","gif","jpg","jpeg","png"],f=["swf"],d=["flv","m4v"],h=["dv","mov","moov","movie","mp4","avi","mpg","mpeg"],g=["asf","avi","mpg","mpeg","wm","wmv"],b=this._getExt(c);if(b){if(a.inArray(b,e)>=0)return"img";if(a.inArray(b,f)>=0)return"swf";if(a.inArray(b,d)>=0)return"flv";if(a.inArray(b,g)>=0)return"wmp";if(a.inArray(b,h)>=0)return"qt"}return"unknown"},_wrapFlash:function(m,p,k){var i=this,b=i.options,j=k,d,h="100%",e="100%",n=b.flashInstall,o=b.flashVersion,c=b.flashVars,g=b.flashParams,l=i._newId();if(p==="flv"){j=b.flvPlayer;c=a.extend({file:k,width:h,height:e,autostart:b.autoPlayMovies?"true":"false",controlbar:b.showMovieControls?"bottom":"none",backcolor:"0x000000",frontcolor:"0xCCCCCC",lightcolor:"0x557722"},b.flashVars);g=a.extend({autostart:b.autoPlayMovies?"true":"false",allowscriptaccess:"always"},b.flashParams)}d=a("<div/>").addClass(f).appendTo(m);a("<div/>").css({width:"100%",height:"100%",overflow:"hidden"}).attr("id",l).appendTo(d);S.flash.embedSWF(j,l,h,e,o,n,c,g)},_newId:function(){var d="a|b|c|d|e|f|g|h|i|j|k|l|m|n|o|p|q|r|s|t|u|v|w|x|y|z",b=[],c="",a;b=d.split("|");for(a=0;a<16;a++)c+=b[Math.round(Math.random()*25)];return c}})})(jQuery);
(function(a){"use strict";if(!window.Raphael)return;Raphael.fn.isoTri=function(a,b,d,c,l){var f=a,i=b+c/2,g=a+d,j=b,h=a+d,k=b+c,e;if(l==="north"){f=a;i=b;g=a-d/2;j=b+c;h=a+d/2;k=b+c}e=["M",f,i,"L",g,j,"L",h,k,"z"];return this.path(e.concat(" "))};a.wijgauge={math:{mod360:function(b){var a=b%360;if(b<0)a+=360;return a},getAngle:function(e,d,f){var a=this,b=a.distance(d,f),c=a.distance(d,e),g=a.distance(f,e),i=b*b,j=c*c,k=g*g,h=Math.acos((k-j-i)/(-2*c*b));return Math.round(180/Math.PI*h)},distance:function(a,b){return Math.sqrt(Math.pow(b.x-a.x,2)+Math.pow(b.y-a.y,2))},log:function(b,a){return b<=0?NaN:a===1||a<0?NaN:Math.log(b)/Math.log(a)}},decoratorUtils:{generateValues:function(b,f,a){var d=[],e,c;if(f>b&&a>0){e=parseInt((f-b)/a+1,10);for(c=0;c<e;c++)d.push(b+c*a)}else a===0&&d.push(b);return d},isInRange:function(a,c,b){return a>=c&&a<=b||a<=c&&a>=b}},paintMarker:function(a,c,f,g,b,d,h){var e;if(c==="rect")return a.rect(f-b/2,g-d/2,b,d);else{if(h)e=a.paintMarker(c,f,g,d);else e=a.paintMarker(c,f,g,b);return e}},formatString:function(c,b){if(a.isFunction(b))return b.call(this,c);else if(b!==""){var e=/\{0(?::((?:n|d|p|c)\d?))?\}/gi,f,d;if(e.test(b)){f=b.match(e);d=RegExp.$1;return b.replace(/\{0(?::(?:(?:n|d|p|c)\d?))?\}/gi,Globalize.format(c,d))}}return c}}})(jQuery);(function(a){"use strict";a.widget("wijmo.wijgauge",{options:{value:0,max:100,min:0,width:600,height:400,tickMajor:{position:"inside",style:{fill:"#1E395B",stroke:"none"},factor:2,visible:true,marker:"rect",offset:0,interval:10},tickMinor:{position:"inside",style:{fill:"#1E395B",stroke:"none"},factor:1,visible:false,marker:"rect",offset:0,interval:5},pointer:{length:1,style:{fill:"#1E395B",stroke:"#1E395B"},width:8,offset:0,shape:"tri",visible:true,template:null},islogarithmic:false,logarithmicBase:10,labels:{format:"",style:{fill:"#1E395B","font-size":12,"font-weight":"800"},visible:true,offset:0},animation:{enabled:true,duration:2e3,easing:">"},face:{style:{fill:"270-#FFFFFF-#D9E3F0",stroke:"#7BA0CC","stroke-width":4},template:null},marginTop:0,marginRight:0,marginBottom:0,marginLeft:0,ranges:[],beforeValueChanged:null,valueChanged:null,painted:null},_create:function(){var c=this,b=c.options;if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);c.element.is(":hidden")&&c.element.wijAddVisibilityObserver&&c.element.wijAddVisibilityObserver(function(){c.redraw();c.element.wijRemoveVisibilityObserver&&c.element.wijRemoveVisibilityObserver()},"wijgauge");isNaN(b.width)&&c._setDefaultWidth();isNaN(b.height)&&c._setDefaultHeight();c._setDefaultWidthHeight();b.disabled&&c.disable();if(b.face&&b.face.template&&typeof b.face.template==="string"&&window[b.face.template])b.face.template=window[b.face.template];if(b.pointer&&b.pointer.template&&typeof b.pointer.template==="string"&&window[b.pointer.template])b.pointer.template=window[b.pointer.template];if(b.cap&&b.cap.template&&typeof b.cap.template==="string"&&window[b.cap.template])b.cap.template=window[b.cap.template];c.element.addClass("ui-widget").toggleClass("ui-state-disabled",b.disabled);c.canvas=new Raphael(c.element[0],b.width,b.height);c._autoCalculate();c._draw()},_autoCalculate:function(){},_setDefaultWidth:function(){},_setDefaultHeight:function(){},_setDefaultWidthHeight:function(){var c=this,a=c.element,d=c.options,b=a.get(0).style,f=b.width,e=b.height;if(f!=="")d.width=a.width();if(e!=="")d.height=a.height()},_setOption:function(d,c){var b=this,f=b.options,e=f[d];if(d==="disabled")b._handleDisabledOption(c,b.element);else if(d==="value"){if(f.disabled)return;if(b._trigger("beforeValueChanged",null,{newValue:c,oldValue:e})){a.Widget.prototype._setOption.apply(b,arguments);b._set_value(c,e)}b._trigger("valueChanged",null,{newValue:c,oldValue:e})}else{if(f.disabled)return;a.Widget.prototype._setOption.apply(b,arguments);if(a.isPlainObject(c))f[d]=a.extend({},e,c);if(f.radius==="auto"){b._autoCalculate();b.redraw();return}b["_set_"+d]&&b["_set_"+d](c,e)}},_set_value:function(){this._setPointer()},_set_max:function(){this._redrawMarksAndLabels();this._set_ranges();this._setPointer()},_set_min:function(){this._redrawMarksAndLabels();this._set_ranges();this._setPointer()},_set_width:function(){this.redraw()},_set_height:function(){this.redraw()},_set_tickMajor:function(){this._redrawMarksAndLabels()},_set_tickMinor:function(){this._redrawMarksAndLabels()},_set_pointer:function(){var a=this;a.pointer&&a.pointer.wijRemove();a._paintPointer();a._setPointer()},_set_islogarithmic:function(){var a=this;a._redrawMarksAndLabels();a._setPointer()},_set_logarithmicBase:function(){var a=this;a._redrawMarksAndLabels();a._setPointer()},_set_labels:function(){this._redrawMarksAndLabels()},_set_margin:function(b,a){b!==a&&this.redraw()},_set_marginTop:function(b,a){this._set_margin(b,a)},_set_marginBottom:function(b,a){this._set_margin(b,a)},_set_marginLeft:function(b,a){this._set_margin(b,a)},_set_marginRight:function(b,a){this._set_margin(b,a)},_set_ranges:function(){var a=this;a._removeRanges();a._paintRanges()},_redrawMarksAndLabels:function(){var a=this;a._removeMarksAndLabels();a._drawMarksAndLabels()},_removeMarksAndLabels:function(){var b=this;a.each(b.labels,function(a,c){c.wijRemove();b.labels[a]=null});a.each(b.majorMarks,function(a,c){c.wijRemove();b.majorMarks[a]=null});a.each(b.minorMarks,function(a,c){c.wijRemove();b.minorMarks[a]=null})},_drawMarksAndLabels:function(){var a=this;a.labels=[];a.majorMarks=[];a.minorMarks=[];a._paintMarks()},_triggerPainted:function(){return this._trigger("painted")},_draw:function(){var b=this,c=b.options;b.pointer=null;b._innerBbox={width:c.width-c.marginLeft-c.marginRight,height:c.height-c.marginTop-c.marginBottom,left:c.marginLeft,top:c.marginTop};b._paintFace();b.ranges&&b._removeRanges();b._paintRanges();b._drawMarksAndLabels();b._paintPointer();if(b.pointer){b._setOffPointerValue();b._setPointer()}a.wijraphael.clearRaphaelCache();b._triggerPainted()},redraw:function(){var a=this,b=a.options;a.element.empty();a.canvas=new Raphael(a.element[0],b.width,b.height);a._draw()},destroy:function(){var b=this;b._unbindEvents(b.majorMarks);b._unbindEvents(b.minorMarks);b._unbindEvents(b.labels);b.element.removeClass("ui-widget").empty();if(b.disabledDiv){b.disabledDiv.remove();b.disabledDiv=null}a.Widget.prototype.destroy.apply(b,arguments)},getCanvas:function(){return this.canvas},_percentage:function(){var e=this,b=e.options,d=b.max,a=b.min,c=b.value;return isNaN(c)?0:d===a?1:(c-a)/(d-a)},_valueToLogical:function(e){var i=this,b=i.options,f=b.min,g=b.max,h=b.logarithmicBase,c,d;if(e<f)return 0;if(g<e)return 1;c=(e-f)/(g-f);if(!b.islogarithmic)d=c;else d=a.wijgauge.math.log(1+(h-1)*c,b.logarithmicBase);return d},_logicalToValue:function(b){var f=this,a=f.options,e=a.max,d=a.min,c;if(b<0)return d;if(1<=b)return e;if(!a.islogarithmic)c=b;else{if(a.logarithmicBase<=1)return a.min;c=(Math.pow(a.logarithmicBase,b)-1)/(a.logarithmicBase-1)}return d+(e-d)*c},_paintFace:function(){},_paintRanges:function(){var b=this,d=b.options,c=d.ranges||[];b.ranges=[];a.each(c,function(c,a){b._paintRange(a)})},_removeRanges:function(){var b=this;a.each(b.ranges,function(a,c){c.wijRemove();b.ranges[a]=null})},_paintMarks:function(){var b=this,c=b.options,d=a.wijgauge.decoratorUtils.generateValues,e=d(c.min,c.max,c.tickMajor.interval),g=d(c.min,c.max,c.tickMinor.interval),f=c.labels,h=f.visible;c.tickMajor.visible&&a.each(e,function(d,a){b.majorMarks.push(b._paintMark(a,c.tickMajor,true));h&&b.labels.push(b._paintLabel(a,f))});c.tickMinor.visible&&a.each(g,function(g,f){var d=false;a.each(e,function(b,a){if(f===a){d=true;return false}});!d&&b.minorMarks.push(b._paintMark(f,c.tickMinor,false))});b._bindClickEvents(b.majorMarks);b._bindClickEvents(b.minorMarks);b._bindClickEvents(b.labels)},_bindClickEvents:function(c){var b=this;a.each(c,function(d,c){a(c.node).bind("click."+b.widgetName,function(a){b._trigger("click",a,{ele:c})})})},_unbindEvents:function(b){var c=this;a.each(b,function(d,b){a(b.node).unbind("."+c.widgetName)})},_paintLabel:function(){},_paintMark:function(){},_paintPointer:function(){},_setPointer:function(){a.wijraphael.clearRaphaelCache()},_setOffPointerValue:function(){},_handleDisabledOption:function(b,c){var a=this;if(b){if(!a.disabledDiv)a.disabledDiv=a._createDisabledDiv(c);a.disabledDiv.appendTo("body")}else if(a.disabledDiv){a.disabledDiv.remove();a.disabledDiv=null}},_createDisabledDiv:function(h){var d=this,e=d.options,b=h||d.element,c=b.offset(),g=e.width||b.outerWidth(),f=e.height||b.outerHeight();return a("<div></div>").addClass("ui-disabled").css({"z-index":"99999",position:"absolute",width:g,height:f,left:c.left,top:c.top})}})})(jQuery);
(function(a){"use strict";a.widget("wijmo.wijlineargauge",a.wijmo.wijgauge,{options:{orientation:"horizontal",xAxisLocation:.1,xAxisLength:.8,yAxisLocation:.5,width:"auto",height:"auto",pointer:{length:.5,width:4,offset:0,visible:true,template:null},marginLeft:5,marginTop:5,marginRight:5,marginBottom:5},_setDefaultWidth:function(){var a=this.options;a.width=a.orientation==="horizontal"?310:70},_setDefaultHeight:function(){var a=this.options;a.height=a.orientation==="horizontal"?70:310},_set_orientation:function(){var a=this;a._setDefaultWidth();a._setDefaultHeight();a.markBbox=null;a.redraw()},_set_xAxisLocation:function(){this.redraw()},_set_xAxisLength:function(){this.redraw()},_set_yAxisLocation:function(){this.redraw()},_create:function(){a.wijmo.wijgauge.prototype._create.apply(this,arguments);this.element.addClass("wijmo-wijlineargauge")},_paintLabel:function(h,g){var d=this,o=d.options,k=g.format,n=g.style,l=g.offset,i=h,m=d.options.tickMajor,j=m.position||"inside",b,f,c,e;if(k!=="")i=a.wijgauge.formatString(h,k);c=d._getMarkerBbox();e=d._getLabelBBox(i);b=d._valueToPoint(h,0);if(o.orientation==="horizontal"){if(j==="inside")b.y=c.y-e.height;else b.y=c.y+c.width;b.y+=l}else{if(j==="inside")b.x=c.x-e.width/2;else b.x=c.x+c.width+e.width/2;b.x+=l}f=d.canvas.text(b.x,b.y,i);f.attr(n);a.wijraphael.addClass(a(f.node),"wijmo-wijlineargauge-label");return f},_getLabelBBox:function(d){var c=this,e=c.options,a,b;a=c.canvas.text(0,0,d);a.attr(e.gaugeLableStyle);b=a.wijGetBBox();a.remove();return b},_getMarkerBbox:function(){var a=this,d=a.options,c=d.tickMajor,b;if(!a.markBbox){b=a._paintMark(0,c);a.markBbox=b.wijGetBBox();b.remove()}return a.markBbox},_paintMark:function(i,f,n){var b=this,k=b.options,d=f.marker||"rect",l=d==="rect"?5:2,e=b._valueToPoint(i,0),m=f.position||"inside",o=f.offset||0,j=n?2:1,g,c,h=a.extend({},f.style);g=l*f.factor;if(a.isFunction(d))return d.call(b,b.canvas,e,k);else{if(d==="cross")h.stroke=h.fill;if(k.orientation==="horizontal")c=a.wijgauge.paintMarker(b.canvas,d,e.x,e.y,j,g,true);else c=a.wijgauge.paintMarker(b.canvas,d,e.x,e.y,g,j)}c.attr(h);a.wijraphael.addClass(a(c.node),"wijmo-wijlineargauge-mark");b._applyPosition(c,m,o,i);return c},_applyPosition:function(f,g,a){var c=0,d=0,h=this,e=h.options.orientation==="horizontal",b=f.wijGetBBox();switch(g){case"inside":if(e)d-=b.width/2+a;else c-=b.width/2+a;break;case"outside":if(e)d+=b.width/2+a;else c+=b.width/2+a;break;case"center":if(e)d-=a;else c-=a}f.attr("transform","t"+c+","+d)},_paintFace:function(){var b=this,d,c=b.options,f=b._innerBbox.width,e=b._innerBbox.height,g=b._innerBbox.left,h=b._innerBbox.top,i={width:f,height:e,x:g,y:h,canvas:b.canvas};if(c.face&&c.face.template&&a.isFunction(c.face.template))return c.face.template.call(b,i);d=b.canvas.rect(g,h,f,e,5);c.face&&c.face.style&&d.attr(c.face.style);a.wijraphael.addClass(a(d.node),"wijmo-wijlineargauge-face");return d},_paintPointer:function(){var c=this,h=c.options,g=c._valueToPoint(0,0),j=c._innerBbox.width,i=c._innerBbox.height,l=c._innerBbox.left,m=c._innerBbox.top,b=h.pointer,e,d,f,k;if(!b.visible)return;k=h.orientation==="horizontal"?i:j;f=k*b.offset;d=k*b.length;if(b.template&&a.isFunction(b.template))e=b.template.call(c.canvas,g,a.extend({},h.pointer,{offset:f,length:d,gaugeBBox:c._innerBbox}));else{if(h.orientation==="horizontal")if(b.shape==="rect")e=c.canvas.rect(g.x-b.width/2,i-d-f+m,b.width,d);else e=c.canvas.isoTri(g.x,i-d-f+m,b.width,d,"north");else if(b.shape==="rect")e=c.canvas.rect(j-d-f+l,g.y-b.width/2,d,b.width);else e=c.canvas.isoTri(j-d-f+l,g.y-b.width/2,d,b.width);e.attr(b.style)}a.wijraphael.addClass(a(e.node),"wijmo-wijlineargauge-pointer");c.pointer=e},_setPointer:function(){var b=this,c=b.options;if(!b.pointer)return;a.wijmo.wijgauge.prototype._setPointer.apply(this,arguments);b._setLinearPointer(c.value)},_setLinearPointer:function(g){var b=this,f=b.options,d=b._valueToPoint(0,0),e=b._valueToPoint(g,0),c=f.animation,a={x:0,y:0};if(f.orientation==="horizontal")a.x=e.x-d.x;else a.y=e.y-d.y;if(c.enabled)b.pointer.stop().wijAnimate({transform:"t"+a.x+","+a.y},c.duration,c.easing);else b.pointer.attr("transform","t"+a.x+","+a.y)},_minScreenPoint:function(h){var a=this,b=a.options,e=a._innerBbox.width,d=a._innerBbox.height,f=a._innerBbox.left,g=a._innerBbox.top,c=b.yAxisLocation+h;return b.orientation==="horizontal"?{x:e*b.xAxisLocation+f,y:d*c+g}:{x:e*c+f,y:d*(1-b.xAxisLocation)+g}},_maxScreenPoint:function(i){var a=this,b=a.options,e=a._innerBbox.width,d=a._innerBbox.height,f=a._innerBbox.left,h=a._innerBbox.top,c=b.yAxisLocation+i,g=b.xAxisLocation+b.xAxisLength;return b.orientation==="horizontal"?{x:e*g+f,y:d*c+h}:{x:e*c+f,y:d*(1-g)+h}},_paintRange:function(a){var g=this,d=g.options,b=isNaN(a.startValue)?0:a.startValue,c=isNaN(a.endValue)?0:a.endValue,h=isNaN(a.startWidth)?isNaN(a.width)?0:a.width:a.startWidth,i=isNaN(a.endWidth)?isNaN(a.width)?0:a.width:a.endWidth,j=a.startDistance||0,k=a.endDistance||0,e,f;if(b!==c){if(c>b){e=Math.max(b,d.min);f=Math.min(d.max,c)}else{e=Math.max(d.min,c);f=Math.min(d.max,b)}g._drawRange(e,f,j,k,h,i,a)}},_drawRange:function(s,u,e,f,n,o,v){var b=this,w=b.options,t=w.orientation,k=b._innerBbox.width,j=b._innerBbox.height,q=b._innerBbox.left,r=b._innerBbox.top,c=b._valueToPoint(s,0),d=b._valueToPoint(u,0),l,m,p,i,g,h;if(t==="horizontal"){g=n*j;h=o*j;if(e!==0)c.y=e*j+r;if(f!==0)d.y=f*j+r;l={x:c.x,y:c.y-g};m={x:d.x,y:d.y-h}}else{g=n*k;h=o*k;if(e!==0)c.x=e*k+q;if(f!==0)d.x=f*k+q;l={x:c.x-g,y:c.y};m={x:d.x-h,y:d.y}}p=["M",c.x,c.y,"L",d.x,d.y,"L",m.x,m.y,"L",l.x,l.y,"Z"];i=b.canvas.path(p.concat(" "));i.attr(v.style);a.wijraphael.addClass(a(i.node),"wijmo-wijlineargauge-range");b.ranges.push(i)},_valueToPoint:function(g,e){var b=this,f=b.options,a,d,c;if(f.max===f.min)return{x:0,y:0};a=b._valueToLogical(g);d=b._minScreenPoint(e);c=b._maxScreenPoint(e);return{x:d.x*(1-a)+c.x*a,y:d.y*(1-a)+c.y*a}}})})(jQuery);
(function(a){"use strict";var c=180,b=9,d=5;a.widget("wijmo.wijradialgauge",a.wijmo.wijgauge,{options:{radius:"auto",startAngle:0,sweepAngle:180,pointer:{length:.8,style:{fill:"#1E395B",stroke:"#1E395B"},width:8,offset:.15},origin:{x:.5,y:.5},labels:{style:{fill:"#1E395B","font-size":12,"font-weight":"800"},offset:30},tickMinor:{position:"inside",offset:30,style:{fill:"#1E395B"},visible:true},tickMajor:{position:"inside",offset:27,style:{fill:"#1E395B",stroke:"#1E395B","stroke-width":1},visible:true},cap:{radius:15,style:{fill:"#1E395B",stroke:"#1E395B"},behindPointer:false,visible:true,template:null},face:{style:{fill:"r(0.9, 0.60)#FFFFFF-#D9E3F0",stroke:"#7BA0CC","stroke-width":4}}},_create:function(){var b=this;a.wijmo.wijgauge.prototype._create.apply(b,arguments);b.element.addClass("wijmo-wijradialgauge")},_init:function(){var b=this;a.wijmo.wijgauge.prototype._init.apply(b,arguments)},_set_radius:function(){var a=this;a._redrawMarksAndLabels();a.pointer.wijRemove();a._paintPointer();a._setPointer()},_set_startAngle:function(){var a=this;a._redrawMarksAndLabels();a._setPointer()},_set_sweepAngle:function(b){var a=this;if(b>360)a.options.endAngle=360;a._redrawMarksAndLabels();a._setPointer()},_set_width:function(){var b=this;b._autoCalculate();a.wijmo.wijgauge.prototype._set_width.apply(b,arguments)},_set_height:function(){var b=this;b._autoCalculate();a.wijmo.wijgauge.prototype._set_width.apply(b,arguments)},_set_origin:function(){var b=this;b._autoCalculate();a.wijmo.wijgauge.prototype._set_width.apply(b,arguments)},_set_cap:function(){var a=this;a.pointer.wijRemove();a._paintPointer();a._setPointer()},_valueToAngleIncludeOffset:function(b){return a.wijgauge.math.mod360(this._valueToAngle(b)+c)},_valueToAngle:function(c){var a=this,b=a._valueToLogical(c);return a._logicalToAngle(b)},_angleToValue:function(c){var a=this,b=a._angleToLogical(c);return a._logicalToValue(b)},_logicalToAngle:function(b){var e=this,c=e.options,a=c.startAngle,d=c.sweepAngle;return a*(1-b)+(a+d)*b},_angleToLogical:function(h){var i=this,f=i.options,g=f.startAngle,c=a.wijgauge.math.mod360(h-g),b=f.sweepAngle,d,e;if(b===0||c===0)return 0;if(b<0){c=360-c;b=-b}d=c-b;if(d>0){e=360-c;return d<e?1:0}return c/b},_generatePoints:function(a,g,f,n){for(var l=this,m=parseInt(b+b*(Math.abs(parseInt(g-a,10))/(b*d)),10),i=[],c,h,k,j,e=0;e<m;e++){c=e/(m-1);h=f+(n-f)*c;j=a+(g-a)*c;k=l._angleToValue(j);i.push(l._valueToPoint(k,h))}return i},_valueToPoint:function(d,c){var e=this,b=e._valueToAngleIncludeOffset(d)*Math.PI/180,a=c;return{x:a*Math.cos(b),y:a*Math.sin(b)}},_pointToValue:function(b){var c=a.wijgauge.math.mod360(Math.atan2(b.x,-b.y)*180/Math.PI);return this._angleToValue(c)},_radiusScreen:function(a){var b=this,c=b.options;return Math.max(c.radius*a,0)},_autoCalculate:function(){var c=this,b=c.options,m=b.width,l=b.height,e,f,g,k=a.wijgauge.formatString(b.max,b.labels.format),d=0,i,h=l-b.marginTop-b.marginBottom,j=m-b.marginLeft-b.marginRight;c.centerPoint={x:b.marginLeft+j*b.origin.x,y:b.marginTop+h*b.origin.y};c.radius=b.radius;if(b.radius==="auto"){c.faceRadius=Math.min(j,h)/2;i=c._getFaceBorder();c.faceRadius-=i;if(b.tickMajor.position==="inside")c.faceRadius-=c._getMaxRangeWidth();e=c._getMarkerbbox(b.tickMajor).width;f=c._getMarkerbbox(b.tickMinor).width;g=c._getLabelBBox(k).width;if(b.tickMajor.position==="center"){d-=e/2;d-=g}else if(b.tickMajor.position==="outside"){d-=e;d-=g}if(b.tickMinor.position==="center")d=Math.min(d,-f/2);else if(b.tickMinor.position==="outside")d=Math.min(d,-f);c.radius=c.faceRadius+d}},_getMaxRangeWidth:function(){var c=this,d=c.options,b=0;a.each(d.ranges,function(c,a){b=Math.max(b,a.width||0);b=Math.max(b,a.startWidth||0);b=Math.max(b,a.endWidth||0)});return b},_getMarkerbbox:function(d){var c=this,b=c._paintMarkEle(d),a=b.wijGetBBox();b.wijRemove();return{width:a.width,height:a.height}},_getFaceBorder:function(){var c=this,a=c._paintFace(),b=a.attr("stroke-width")||1;if(a.type==="set")b=a[0].attr("stroke-width")||1;a.wijRemove();return b},_paintMarks:function(){var b=this;b.markBbox=null;a.wijmo.wijgauge.prototype._paintMarks.apply(b,arguments)},_paintMark:function(e,c){var d=this,b,f=c.position||"inside",g=c.offset||0;b=d._paintMarkEle(c);b.attr(c.style);a.wijraphael.addClass(a(b.node),"wijmo-wijradialgauge-mark");a(b.node).data("value",e);d._applyAlignment(b,f,g);d._setMarkValue(e,b);return b},_applyAlignment:function(b,e,d){if(!b)return;var f=b.wijGetBBox(),c=f.width/2,a=0;switch(e){case"outside":a-=c+d;break;case"inside":a+=c+d}b.transform("t"+a+",0")},_paintMarkEle:function(f){var b=this,i=b.options,d={x:b.centerPoint.x-b.radius,y:b.centerPoint.y},c=f.marker||"circle",g=c==="rect"?5:2,h=2,e;e=g*f.factor;return a.isFunction(c)?c.call(b,b.canvas,d,i):a.wijgauge.paintMarker(b.canvas,c,d.x,d.y,e,h)},_setMarkValue:function(c,d){var a=this,b=a._valueToAngle(c);d.transform(Raphael.format("r{0},{1},{2}...",b,a.centerPoint.x,a.centerPoint.y))},_paintLabel:function(i,g){var b=this,o=b._valueToAngle(i),k=g.format,p=g.style,n=g.offset,j=i,l=b.options.tickMajor,m=l.position||"inside",h,f,d,c,e;if(k!=="")j=a.wijgauge.formatString(i,k);d=b._getMarkerBbox();e=b._getLabelBBox(j);switch(m){case"inside":c=d.x+d.width+e.width/2;break;case"outside":c=d.x-e.width/2;break;default:c=d.x-e.width/2}c=b.centerPoint.x-c+n;h=a.wijmo.wijradialgauge.utility.getPositionByAngle(b.centerPoint.x,b.centerPoint.y,c,o);f=b.canvas.text(h.x,h.y,j);f.attr(p);a.wijraphael.addClass(a(f.node),"wijmo-wijradialgauge-label");return f},_getLabelBBox:function(d){var c=this,e=c.options,a,b;a=c.canvas.text(0,0,d);a.attr(e.gaugeLableStyle);b=a.wijGetBBox();a.wijRemove();return b},_getMarkerBbox:function(){var a=this,d=a.options,c=d.tickMajor,b;if(!a.markBbox){b=a._paintMarkEle(c,true);a._applyAlignment(b,c.position,c.offset||0);a.markBbox=b.wijGetBBox();b.wijRemove()}return a.markBbox},_paintFace:function(){var b=this,c=b.options,e=Math.min(c.width,c.height)/2,d,f;if(b.faceRadius)e=b.faceRadius;if(c.face&&c.face.template&&a.isFunction(c.face.template)){f={canvas:b.canvas,r:e,origin:{x:b.centerPoint.x,y:b.centerPoint.y}};return c.face.template.call(b,f)}d=b.canvas.circle(b.centerPoint.x,b.centerPoint.y,e);c.face&&c.face.style&&d.attr(c.face.style);a.wijraphael.addClass(a(d.node),"wijmo-wijradialgauge-face");return d},_paintPointer:function(){var c=this,d=c.options,b=d.pointer,g=c.radius*b.length,f={x:c.centerPoint.x-g+b.offset*c.radius,y:c.centerPoint.y-b.width/2},e;if(!b.visible)return;d.cap&&d.cap.behindPointer&&d.cap.visible&&c._paintCap();if(b.template&&a.isFunction(b.template))e=b.template.call(c.canvas,f,a.extend({},b,{length:g}));else{if(b.shape==="rect")e=c.canvas.rect(f.x-b.width/2,f.y,g,b.width);else e=c.canvas.isoTri(f.x-b.width/2,f.y,g,b.width);e.attr(b.style)}c.pointer=e;a.wijraphael.addClass(a(e.node),"wijmo-wijradialgauge-pointer");(!d.cap||!d.cap.behindPointer)&&d.cap.visible&&c._paintCap()},_paintCap:function(){var b=this,e=b.options,c=e.cap,d;if(c&&c.template&&a.isFunction(c.template)){d={canvas:b.canvas,origin:{x:b.centerPoint.x,y:b.centerPoint.y}};b.cap=c.template.call(b,d);return b.cap}b.cap=b.canvas.circle(b.centerPoint.x,b.centerPoint.y,c.radius);c&&c.style&&b.cap.attr(c.style);a.wijraphael.addClass(a(b.cap.node),"wijmo-wijradialgauge-cap");return b.cap},_paintRange:function(a){var d=this,e=d.options,b=isNaN(a.startValue)?0:a.startValue,c=isNaN(a.endValue)?0:a.endValue,j=isNaN(a.startWidth)?isNaN(a.width)?0:a.width:a.startWidth,k=isNaN(a.endWidth)?isNaN(a.width)?0:a.width:a.endWidth,f=a.startDistance||1,h=a.endDistance||1,g,i;if(b!==c){if(c>b){g=Math.max(b,e.min);i=Math.min(e.max,c)}else{g=Math.max(e.min,c);i=Math.min(e.max,b)}f=f*d.radius;h=h*d.radius;d._drawRange(g,i,f,h,j,k,a)}},_drawRange:function(o,p,g,h,l,m,n){var b=this,i=b._valueToAngle(o),j=b._valueToAngle(p),k=b._generatePoints(i,j,l+g,m+h),f=b._generatePoints(i,j,g,h),d,e,c="";a.each(k,function(d,a){if(d===0)c+="M"+(a.x+b.centerPoint.x)+" "+(a.y+b.centerPoint.y);else c+="L"+(a.x+b.centerPoint.x)+" "+(a.y+b.centerPoint.y)});for(d=f.length-1;d>=0;d--)c+="L"+(f[d].x+b.centerPoint.x)+" "+(f[d].y+b.centerPoint.y);c+="Z";e=b.canvas.path(c);e.attr(n.style);b.ranges.push(e);a.wijraphael.addClass(a(e.node),"wijmo-wijradialgauge-range")},_setOffPointerValue:function(){var a=this,b=a._valueToAngle(0);a.pointer.transform(Raphael.format("r{0},{1},{2}",b,a.centerPoint.x,a.centerPoint.y))},_setPointer:function(){var b=this,e=b.options,d=b._valueToAngle(e.value),c=e.animation;if(!b.pointer)return;a.wijmo.wijgauge.prototype._setPointer.apply(this,arguments);if(c.enabled)b.pointer.stop().wijAnimate({transform:"r"+d+","+b.centerPoint.x+","+b.centerPoint.y},c.duration,c.easing);else b.pointer.transform(Raphael.format("r{0},{1},{2}",d,b.centerPoint.x,b.centerPoint.y))}});a.wijmo.wijradialgauge.utility={pointers:{donut:function(k,c,d,b,h,f,g){var e=a.wijmo.wijradialgauge.utility.getPositionByAngle,i=e(c,d,b,f),n=e(c,d,b,g),m=e(c,d,h,f),l=e(c,d,h,g),j=g-f>180,o;if((g-f)%360!==0){o=["M",i.x,i.y,"A",b,b,0,+j,1,n.x,n.y,"L",l.x,l.y,"A",h,h,0,+j,1,m.x,m.y,"L",i.x,i.y,"z"];k.path(o)}else k.circle(c,d,b)}},getPositionByAngle:function(e,f,c,d){var a={},b=Raphael.rad(d);a.x=e-c*Math.cos(b);a.y=f-c*Math.sin(b);return a}}})(jQuery);
(function(a){"use strict";a.widget("wijmo.wijlightbox",{options:{textPosition:"overlay",width:600,height:400,autoSize:true,player:"",groupItems:[],rootUrl:"",ctrlButtons:"",dialogButtons:"close",counterType:"default",counterFormat:"[i] of [n]",counterLimit:10,showCounter:true,showNavButtons:true,showTimer:false,controlsPosition:"inside",showControlsOnHover:true,clickPause:false,keyNav:false,modal:false,position:{my:"center",at:"center",of:window,collision:"fit",using:function(c){var b=a(this).css(c).offset().top;b<0&&a(this).css("top",c.top-b)}},zIndex:1e3,closeOnEscape:true,closeOnOuterClick:true,autoPlay:false,delay:2e3,loop:true,cookie:null,transAnimation:{animated:"fade",duration:400,easing:"easeInQuad"},slideDirection:"horizontal",resizeAnimation:{animated:"sync",duration:400},textShowOption:{duration:300,easing:"easeInQuad"},textHideOption:{duration:300,easing:"easeInQuad"},showMovieControls:true,autoPlayMovies:true,flashParams:{bgcolor:"#000000",allowfullscreen:true},flashVars:{},flashVersion:"9.0.115",flvPlayer:"player\\player.swf",flashInstall:"player\\expressInstall.swf",beforeShow:null,show:null,open:null,beforeClose:null,close:null},_keyDownHandler:function(b){var d=this.options,c=this;if(b.keyCode&&b.keyCode===a.ui.keyCode.ESCAPE){if(c._isFullSize())c._toggleFullSize();else d.closeOnEscape&&c._close();b.preventDefault();return}if(d.keyNav)if(b.keyCode)switch(b.keyCode){case a.ui.keyCode.LEFT:case a.ui.keyCode.DOWN:c.back();b.preventDefault();break;case a.ui.keyCode.RIGHT:case a.ui.keyCode.UP:c.next();b.preventDefault();break;case a.ui.keyCode.HOME:d.groupItems.length>0&&c.show(0);b.preventDefault();break;case a.ui.keyCode.END:d.groupItems.length>0&&c.show(d.groupItems.length-1);b.preventDefault()}},_create:function(){var b=this.options,c=this;if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);this._defaults={transAnimation:{animated:"fade",duration:400,easing:"easeInQuad"},resizeAnimation:{animated:"sync",duration:400},textShowOption:{duration:300,easing:"easeInQuad"},textHideOption:{duration:300,easing:"easeInQuad"}};this._parse();this.container=a("<div/>").addClass("wijmo-wijlightbox ui-widget wijmo-wijlightbox-controls-"+b.controlsPosition).css("z-index",b.zIndex).attr({tabIndex:-1,role:"dialog"}).bind("keydown.wijlightbox",a.proxy(c,"_keyDownHandler")).appendTo(document.body).hide();this.frame=a("<div></div>").addClass("wijmo-wijlightbox-frame ui-widget-content ui-corner-all ui-helper-clearfix").appendTo(this.container);this.content=a("<div></div>").addClass("wijmo-wijlightbox-content").appendTo(this.frame);if(b.activeIndex===undefined){if(typeof b.activeIndex!=="number"&&b.cookie)b.activeIndex=parseInt(c._cookie(),10);b.activeIndex=b.activeIndex||(b.groupItems.length?0:-1)}else if(b.activeIndex===null)b.activeIndex=-1;b.activeIndex=b.activeIndex>=0&&b.groupItems[b.activeIndex]||b.activeIndex<0?b.activeIndex:0;this._initClickBehavior();this._createTimerBar();this._createDialogButtons();this._createCtrlButtons();this._createText();this._createCounter();this._refreshCounter();this.toolBox&&this.toolBox.find(".wijmo-wijlightbox-toolbox-button").bind({mouseover:function(){c._addState("hover",a(this))},mouseout:function(){c._removeState("hover",a(this))},mousedown:function(){c._addState("active",a(this))},mouseup:function(){c._removeState("active",a(this))}});this._groupMode()&&this._createNavButtons();this._initHoverBehavior();this.container.width(this.frame.outerWidth())},destroy:function(){var c=this.options,b=this;this._hideWaiting();this._hideOverlay();c.cookie&&this._cookie(null,c.cookie);this.container.remove();a.Widget.prototype.destroy.apply(b,arguments);return b},_setOption:function(c,b){a.Widget.prototype._setOption.apply(this,arguments);switch(c){case"groupItems":if(this.options.activeIndex>=b.length)this.show(b.length-1);else if(this.options.activeIndex<0&&b.length)this.show(0);else this.show(this.options.activeIndex);break;case"activeIndex":this.show(b);break;case"textPosition":this._resetText();break;case"clickPause":this._initClickBehavior();break;case"showNavButtons":this._createNavButtons();break;case"showControlsOnHover":this._initHoverBehavior()}},_initClickBehavior:function(){var c=this.options,b=this;this.content.unbind("click");if(c.clickPause)this._groupMode()&&this.content.click(function(){b[!b.isPlaying()?"play":"stop"]()});else this._groupMode()&&this.content.click(function(d){if(b.isPlaying())return false;var c=a.extend({},a(this).offset(),{width:a(this).outerWidth(true),height:a(this).outerHeight(true)});if(d.pageX>=c.left&&d.pageX<c.left+c.width/2)b.back();else b.next()})},_initHoverBehavior:function(){var b=this.options,a=this;this.frame.unbind(".wijlightbox");b.showControlsOnHover&&this.frame.bind({"mouseenter.wijlightbox":function(){if(a.container.data("moving.wijlightbox"))return false;a._showAccessories(true)},"mouseleave.wijlightbox":function(){if(a.container.data("moving.wijlightbox"))return false;a._hideAccessories(true)},"mousemove.wijlightbox":function(){a.container.data("moving.wijlightbox")===false&&a.container.data("accessvisible.wijlightbox")===false&&a.frame.trigger("mouseenter")}})},_getPlugins:function(){var c=this.container.data("plugins.wijlightbox"),b,d,e;if(!c){c={};if(window.navigator.plugins&&window.navigator.plugins.length){b=[];a.each(window.navigator.plugins,function(c,a){b.push(a.name)});b=b.join(",");e=b.indexOf("Flip4Mac")>-1;c={fla:b.indexOf("Shockwave Flash")>-1,qt:b.indexOf("QuickTime")>-1,wmp:!e&&b.indexOf("Windows Media")>-1,f4m:e}}else{d=function(b){var a;try{a=new ActiveXObject(b)}catch(c){}return!!a};c={fla:d("ShockwaveFlash.ShockwaveFlash"),qt:d("QuickTime.QuickTime"),wmp:d("wmplayer.ocx"),f4m:false}}this.container.data("plugins.wijlightbox",c)}return c},_sanitizeSelector:function(a){return a.replace(/:/g,"\\:")},_getFragmentId:function(d){var f=/^#.+/,b=a(d).attr("href")||"",c=b.split("#")[0],e=a("base")[0];if(c&&(c===window.location.toString().split("#")[0]||e&&c===e.href)){b=d.hash;d.href=b}return f.test(b)?this._sanitizeSelector(b):""},_parseLink:function(j){var f=this,e=this.options,d=a(j),b={},g,c,h,i,k=["href","player","title","alt","height","width","gallery","wijvideosrc"];if(d.length>0&&d[0].tagName.toLowerCase()==="a"){g=d.attr("rel");a.each(k,function(c,a){b[a]=d.attr(a)||""});if(!b.href)return;if(!b.player)b.player=e.player||f._getPlayerName(b.href);c=d.find("img");if(c&&c.length===0)c=d;if(c&&c.length>=1){a.each(["title","alt"],function(d,a){b[a]=c.attr(a)||b[a]});b.img=c}if(g){h=g.match(/\[(.*?)\]/);if(h)b.gallery=h[1]||b.gallery;a.each(g.split(";"),function(d,c){var a=c.match(/\s*([a-z_]*?)\s*=\s*(.+)\s*/);if(a)b[a[1]]=a[2]})}if(b.player==="inline")b.href=f._getFragmentId(j);if(!b.gallery)d.bind({click:function(a){a.stopPropagation();a.preventDefault();!e.disabled&&f._open(c,b);return false}});else{i=e.groupItems.length;e.groupItems[i]=b;d.bind({click:function(a){a.stopPropagation();a.preventDefault();!e.disabled&&f._open(c,i);return false}})}}},_parse:function(){var a=this;this._parseLink(this.element);this.element.find('a[rel^="wijlightbox"], a[rel^="lightbox"]').each(function(){a._parseLink(this)})},_showAccessories:function(a){this.container.data("accessvisible.wijlightbox",true);this._showNavButtons(a);this._showToolboxButtons(a);this._showCounter(a)},_hideAccessories:function(a){this.container.data("accessvisible.wijlightbox",false);this._hideNavButtons(a);this._hideToolboxButtons(a);this._hideCounter(a)},_groupMode:function(){var a=this.options;return a.groupItems&&a.groupItems.length>1},_resetText:function(){this._removeText();this._createText()},_createText:function(i){var g=this,c=g.options,e,b,d,f,h;if(c.textPosition==="none")return;if(this.container.find(".wijmo-wijlightbox-text").length)return;e=c.textPosition.toLowerCase();b=a("<div></div>").addClass("wijmo-wijlightbox-text wijmo-wijlightbox-text-"+e+" ui-widget-content ui-helper-clearfix");f=a("<h3></h3>").addClass("wijmo-wijlightbox-title wijmo-wijlightbox-title-"+e+" ui-helper-clearfix").appendTo(b);h=a("<p></p>").addClass("wijmo-wijlightbox-detail wijmo-wijlightbox-detail-"+e+" ui-helper-clearfix").appendTo(b);if(c.textPosition==="inside")b.addClass("ui-widget-content ui-helper-clearfix").width(this.frame.width()).appendTo(this.frame);else if(c.textPosition==="outside")b.addClass("ui-widget-content ui-corner-all ui-helper-clearfix").width(this.frame.width()).appendTo(this.container);else if(c.textPosition==="overlay"||c.textPosition==="titleOverlay"){d=a("<div></div>").addClass("wijmo-wijlightbox-mask wijmo-wijlightbox-mask-"+e+" ui-helper-clearfix").width(this.frame.width()).appendTo(this.frame);b.width(this.frame.width()).appendTo(this.frame);c.textPosition==="titleOverlay"&&b.bind({mouseenter:function(){d.stop();b.stop();var e=f.outerHeight(true)+h.outerHeight(true),i=a.extend({},g._defaults.textShowOption,c.textShowOption,{queue:false});d.animate({height:e},i);b.animate({height:e},i)},mouseleave:function(){d.stop();b.stop();var e=f.height(),h=a.extend({},g._defaults.textHideOption,c.textHideOption,{queue:false});d.animate({height:e},h);b.animate({height:e},h)}})}this._refreshText(i)},_removeText:function(){this.container.find(".wijmo-wijlightbox-text,.wijmo-wijlightbox-mask").remove()},_getActiveItem:function(){var a=this.options;return a.groupItems&&a.groupItems.length&&a.activeIndex>=0&&a.activeIndex<a.groupItems.length?a.groupItems[a.activeIndex]:null},_refreshText:function(l){var m=this,c=this.options,e,b,j,i,d;if(c.textPosition==="none")return;e=this.container.data("item.wijlightbox")||this._getActiveItem();if(!e)return;b=this.container.find(".wijmo-wijlightbox-text");j=this.container.find(".wijmo-wijlightbox-title");i=this.container.find(".wijmo-wijlightbox-detail");d=this.container.find(".wijmo-wijlightbox-mask");d.stop();b.stop();j.html(e.title);i.html(e.alt);c.textPosition==="outside"&&b.width(this.frame.width());var g=j.outerHeight(true),f=i.outerHeight(true),h=a.extend({},m._defaults.textShowOption,c.textShowOption,{queue:false});if(c.textPosition==="overlay"||c.textPosition==="titleOverlay"){var k=g+(c.textPosition==="overlay"?f:0);b.height(0);d.height(0);b.animate({height:k},h);d.animate({height:k},h)}else if(!!l)b.height(g+f);else{b.height(0);b.animate({height:g+f},h)}},_addState:function(b,a){a.is(":not(.ui-state-disabled)")&&a.addClass("ui-state-"+b)},_removeState:function(a,b){b.removeClass("ui-state-"+a)},_createNavButtons:function(){var b=this,c=this.options;if(!c.showNavButtons||!this._groupMode()){this._removeNavButtons();return}if(!this.backBtn)this.backBtn=a("<a href='#'/>").addClass("wijmo-wijlightbox-button wijmo-wijlightbox-button-prev ui-state-default"+(c.controlsPosition==="inside"?" ui-corner-right":" ui-corner-left")).append("<span class='ui-icon ui-icon-triangle-1-w'></span>").hide().appendTo(this.frame).bind({click:function(){!a(this).hasClass("ui-state-disabled")&&b.back();return false},mouseover:function(){b._addState("hover",a(this))},mouseout:function(){b._removeState("hover",a(this))},mousedown:function(){b._addState("active",a(this))},mouseup:function(){b._removeState("active",a(this))}});if(!this.nextBtn)this.nextBtn=a("<a href='#'/>").addClass("wijmo-wijlightbox-button wijmo-wijlightbox-button-next ui-state-default"+(c.controlsPosition==="inside"?" ui-corner-left":" ui-corner-right")).append("<span class='ui-icon ui-icon-triangle-1-e'></span>").hide().appendTo(this.frame).bind({click:function(){!a(this).hasClass("ui-state-disabled")&&b.next();return false},mouseover:function(){b._addState("hover",a(this))},mouseout:function(){b._removeState("hover",a(this))},mousedown:function(){b._addState("active",a(this))},mouseup:function(){b._removeState("active",a(this))}})},_removeNavButtons:function(){if(this.backBtn){this.backBtn.remove();this.backBtn=undefined}if(this.nextBtn){this.nextBtn.remove();this.nextBtn=undefined}},_refreshNavButtons:function(){var b=this.options,a;if(this.backBtn){a=b.activeIndex===0?"addClass":"removeClass";this.backBtn[a]("ui-state-disabled")}if(this.nextBtn){a=b.activeIndex>=b.groupItems.length-1?"addClass":"removeClass";this.nextBtn[a]("ui-state-disabled")}},_showNavButtons:function(b){if(this.isPlaying())return;this.container.find(".wijmo-wijlightbox-button").stop(true,true).fadeIn(b?600:0,function(){a(this).css("opacity","")})},_hideNavButtons:function(a){this.container.find(".wijmo-wijlightbox-button").stop(true,true).fadeOut(a?600:0)},_createToolbox:function(){if(!this.toolBox)this.toolBox=a("<div></div>").addClass("wijmo-wijlightbox-toolbox").appendTo(this.frame)},_showToolboxButtons:function(b){this.container.find(".wijmo-wijlightbox-toolbox-button").stop(true,true).fadeIn(b?600:0,function(){a(this).css("opacity","")})},_hideToolboxButtons:function(a){this.container.find(".wijmo-wijlightbox-toolbox-button").stop(true,true).fadeOut(a?600:0)},_createCtrlButtons:function(){var b=this,c=this.options;if(!c.ctrlButtons||c.ctrlButtons.length===0||!this._groupMode()){this._removeCtrlButtons();return}this._createToolbox();var d=c.ctrlButtons.split("|");if(d.length===1&&d[0]===c.ctrlButtons)d=c.ctrlButtons.split(",");a.each(d,function(e,d){d=a.trim(d);if(d==="play"&&!this.playBtn)b.playBtn=a("<a href='#'/>").addClass("wijmo-wijlightbox-toolbox-button wijmo-wijlightbox-toolbox-button-play ui-state-default ui-corner-all").append("<span class='ui-icon ui-icon-play'></span>").hide().click(function(){if(b.isPlaying())b.stop();else{c.activeIndex>=c.groupItems.length-1&&b.show(0);b.play()}return false});else if(d==="stop"&&!this.stopBtn)b.stopBtn=a("<a href='#'/>").addClass("wijmo-wijlightbox-toolbox-button wijmo-wijlightbox-toolbox-button-stop ui-state-default ui-state-disabled ui-corner-all").append("<span class='ui-icon ui-icon-stop'></span>").hide().click(function(){if(b.isPlaying()){b.stop();b.show(0)}return false})});this.stopBtn&&this.stopBtn.appendTo(this.toolBox);this.playBtn&&this.playBtn.appendTo(this.toolBox)},_removeCtrlButtons:function(){if(this.playBtn){this.playBtn.remove();this.playBtn=undefined}if(this.stopBtn){this.stopBtn.remove();this.stopBtn=undefined}},_refreshCtrlButtons:function(){if(this.playBtn){var a=this.playBtn.find(".ui-icon");if(a){a.removeClass("ui-icon-play ui-icon-pause");a.addClass(this.isPlaying()?"ui-icon-pause":"ui-icon-play")}}this.stopBtn&&this.stopBtn[!this.isPlaying()?"addClass":"removeClass"]("ui-state-disabled")},_createDialogButtons:function(){var d=this,c=this.options,b;if(!c.dialogButtons||c.dialogButtons.length===0){this._removeDialogButtons();return}this._createToolbox();b=c.dialogButtons.split("|");if(b.length===1&&b[0]===c.dialogButtons)b=c.dialogButtons.split(",");a.each(b,function(c,b){b=a.trim(b);if(b==="close"&&!this.closeBtn)d.closeBtn=a("<a href='#'/>").addClass("wijmo-wijlightbox-toolbox-button wijmo-wijlightbox-toolbox-button-close ui-state-default ui-corner-all").append("<span class='ui-icon ui-icon-close'></span>").hide().click(function(){d._close();return false});else if(b==="fullSize"&&!this.fullBtn)d.fullBtn=a("<a href='#'/>").addClass("wijmo-wijlightbox-toolbox-button wijmo-wijlightbox-toolbox-button-fullsize ui-state-default ui-corner-all").append("<span class='ui-icon ui-icon-arrow-4-diag'></span>").hide().click(function(){d._toggleFullSize();return false})});this.closeBtn&&this.closeBtn.appendTo(this.toolBox);this.fullBtn&&this.fullBtn.appendTo(this.toolBox);if(!this.btnSep)this.btnSep=a("<a href='#'/>").addClass("wijmo-wijlightbox-toolbox-separator").appendTo(this.toolBox)},_removeDialogButtons:function(){if(this.closeBtn){this.closeBtn.remove();this.closeBtn=undefined}if(this.fullBtn){this.fullBtn.remove();this.fullBtn=undefined}},_refreshDialogButtons:function(){if(this.fullBtn){var a=this.fullBtn.find(".ui-icon");if(a){a.removeClass("ui-icon-arrow-4-diag ui-icon-newwin");a.addClass(this._isFullSize()?"ui-icon-newwin":"ui-icon-arrow-4-diag")}}},_createTimerBar:function(){var b=this,c=b.options;if(!c.showTimer||!b._groupMode()){b._removeTimerBar();return}b._createToolbox();if(!b.timerBar){b.timerBar=a("<div></div>").addClass("wijmo-wijlightbox-timerbar ui-widget-content ui-priority-secondary ui-corner-all").appendTo(b.toolBox);b.timerMeter=a("<div></div>").addClass("wijmo-wijlightbox-timermeter ui-progressbar-value ui-widget-content ui-corner-all").appendTo(b.toolBox)}},_removeTimerBar:function(){if(this.timerMeter){this.timerMeter.remove();this.timerMeter=undefined}if(this.timerBar){this.timerBar.remove();this.timerBar=undefined}},_createCounter:function(){var b=this,c=b.options;if(!c.showCounter||!b._groupMode()){b._removeCounter();return}if(!b.counter)b.counter=a("<div></div>").addClass("wijmo-wijlightbox-counter ui-state-default"+(c.controlsPosition==="inside"?"  ui-corner-tl":" ui-corner-all")).hide().appendTo(b.frame)},_removeCounter:function(){if(this.counter){this.counter.remove();this.counter=undefined}},_refreshCounter:function(d){var i=this,b=this.options,f="";if(!this.counter||!this._groupMode())return;this.counter.empty();if(b.showCounter&&b.groupItems.length>1&&this.counter){if(d===undefined)d=b.activeIndex;var h=b.groupItems.length;if(b.counterType==="sequence"){var c=0,g=h,e=parseInt(b.counterLimit,10)||0;if(e>=2&&e<h){var k=Math.floor(e/2);c=Math.min(g-e,Math.max(c,d-k));g=Math.min(g,c+e)}while(c!==g)a("<a></a>").addClass("wijmo-wijlightbox-counter-item ui-corner-all ui-state-default"+(c===d?" wijmo-wijlightbox-counter-active ui-state-active":"")).text(++c).appendTo(this.counter);this.counter.find("a").click(function(){if(a(this).hasClass("wijmo-wijlightbox-counter-active"))return false;i.show(parseInt(a(this).text(),10)-1);return false})}else{var j=b.counterFormat||"[i] of [n]";f=j.replace("[i]",d+1);f=f.replace("[n]",h);a("<span></span>").text(f).appendTo(this.counter)}}},_showCounter:function(b){this.container.find(".wijmo-wijlightbox-counter").stop(true,true).fadeIn(b?600:0,function(){a(this).css("opacity","")})},_hideCounter:function(a){this.container.find(".wijmo-wijlightbox-counter").stop(true,true).fadeOut(a?600:0)},_cookie:function(){var b=this.cookie||(this.cookie=this.options.cookie.name);return a.cookie.apply(null,[b].concat(a.makeArray(arguments)))},_showOverlay:function(){if(this.container.data("overlay.wijlightbox"))return;this.container.data("overlay.wijlightbox",new a.wijmo.wijlightbox.overlay(this))},_hideOverlay:function(){var a=this.container.data("overlay.wijlightbox");if(!a)return;a.close();this.container.removeData("overlay.wijlightbox")},_hasOverlay:function(){return this.container.hasData("overlay.wijlightbox")},_showWaiting:function(){if(this.container.data("waiting.wijlightbox"))return;this.container.data("waiting.wijlightbox",new a.wijmo.wijlightbox.overlay(this,true))},_hideWaiting:function(){var a=this.container.data("waiting.wijlightbox");if(!a)return;a.close();this.container.removeData("waiting.wijlightbox")},_hasWaiting:function(){return this.container.hasData("waiting.wijlightbox")},_getUrl:function(c){var d=this.options,b=typeof c==="string"?c:c.href,a=d.rootUrl;if(a&&a.length>0){if(a.indexOf("//")===-1)a=window.location.protocol+"//"+window.location.host+(a.startsWith("/")?"":"/")+a;if(a.substr(a.length-1,1)!=="/")a+="/";b=a+(b.substr(0,1)==="/"?b.substr(1):b)}return b},_preload:function(){for(var a=this.options,b=Math.max(0,a.activeIndex);b<Math.min(a.activeIndex+5,a.groupItems.length);b++)if(!a.groupItems[b].image){a.groupItems[b].image=new Image;a.groupItems[b].image.src=this._getUrl(a.groupItems[b])}},_slideTo:function(o,m,l,e,j){var n=this.options,i=this,b=o.getElement(),c,h,g,d,f,k;if(b.parent().is(".wijmo-wijlightbox-aniwrapper"))c=b.parent();else{c=a.effects.createWrapper(b).css({overflow:"hidden"});c.removeClass("ui-effects-wrapper");c.addClass("wijmo-wijlightbox-aniwrapper")}if(c.parent().is(".wijmo-wijlightbox-aniwrapper"))h=c.parent();else{h=a.effects.createWrapper(c).css({overflow:"hidden"});h.removeClass("ui-effects-wrapper");h.addClass("wijmo-wijlightbox-aniwrapper")}g=n.slideDirection||"horizontal";d=b.outerWidth();f=b.outerHeight();if(g==="horizontal"){b.width(d).css("float",e?"left":"right");c.width(2*d).css({left:e?0:-1*d,position:"absolute"})}else{b.height(f);c.width(d).css({top:e?0:-1*f,position:"absolute"}).height(2*f)}m.appendTo(c);k=m.getElement();if(g==="horizontal")k.width(d).css("float",e?"left":"right");else k.height(f);this.container.data("animating.wijlightbox",true);c.effect("slide",{mode:"hide",direction:g==="horizontal"?e?"left":"right":e?"up":"down",easing:l.easing,distance:g==="horizontal"?d:f,duration:l.duration},function(){b=c.children(":last");while(b.parent().is(".wijmo-wijlightbox-aniwrapper"))b.parent().replaceWith(b);b.css({"float":"",width:"",height:""});if(n.autoSize&&!i._isFullSize())i._resize(j);else{a.isFunction(j)&&j.apply(i);i._refreshText()}})},_moveFrom:function(e,c,d){var b=this,g=this.options,f;if(a.isFunction(c)){d=c;c=a.extend({},b._defaults.resizeAnimation,g.resizeAnimation)}else c=a.extend({},b._defaults.resizeAnimation,g.resizeAnimation,c);b._removeText();if(c.animated==="none"||c.duration<=0){b._createText();a.isFunction(d)&&d.apply(b);this.container.data("moving.wijlightbox",false);return}f=a.extend({width:b.frame.width(),height:b.frame.height()},b.container.offset());b.frame.width(e.width).height(e.height);b.container.css({left:e.left,top:e.top,width:b.frame.outerWidth(),position:"absolute",opacity:""});b._moveTo(f,c,function(){b.frame.width(f.width);b.container.width(b.frame.outerWidth());b._createText();b.container.data("moving.wijlightbox",false);a.isFunction(d)&&d.apply(b)})},_moveTo:function(d,b,f){var c=this,i=this.options;if(a.isFunction(b)){f=b;b=a.extend({},c._defaults.resizeAnimation,i.resizeAnimation)}else b=a.extend({},c._defaults.resizeAnimation,i.resizeAnimation,b);var g=b.duration/2,e=b.animated,h=c._isOpen(),l=e==="wh"?{left:d.left}:{top:d.top},m=e==="wh"?{top:d.top}:{left:d.left},j=e==="wh"?{width:d.width}:{height:d.height},k=e==="wh"?{height:d.height}:{width:d.width};if(e==="wh"||e==="hw"){h&&c.container.animate(l,{duration:g,easing:b.easing,queue:true});c.frame.animate(j,{duration:g,easing:b.easing,complete:function(){h&&c.container.animate(m,{duration:g,easing:b.easing,queue:true});c.frame.animate(k,{duration:g,easing:b.easing,complete:function(){c.container.data("moving.wijlightbox",false);a.isFunction(f)&&f.apply(c)}})}});return}h&&c.container.animate({left:d.left,top:d.top},{duration:b.duration,easing:b.easing,queue:true});c.frame.animate({width:d.width,height:d.height,opacity:1},{duration:b.duration,easing:b.easing,complete:function(){c.container.data("moving.wijlightbox",false);a.isFunction(f)&&f.apply(c)}})},show:function(a){this._show(a);return this},_resize:function(c){var b=this,d=a.extend({},b.container.offset(),{width:b.frame.width(),height:b.frame.height()});b._size();b._isOpen()&&b._position();b._moveFrom(d,c)},_onAfterShow:function(){var a=this,b=this.options,c;a._refreshNavButtons();a.container.data("animating.wijlightbox",false);!b.modal&&a._hideOverlay();c={index:b.activeIndex,item:b.groupItems[b.activeIndex]};a._trigger("show",null,c);a._startTimer()},_show:function(f,g,i){var b=this,c=this.options,k,d;if(this.container.data("showing.wijlightbox")){k=[function(){b._show(f,g,i)}];this.container.queue("showqueue",k);return this}d=c.activeIndex;if(!a.isPlainObject(f)){d=f;if(d<0||d>=c.groupItems.length)return this;f=c.groupItems[d]}f&&this.container.data("item.wijlightbox",f);this._groupMode()&&this._preload();if(a.isFunction(g)){i=g;g=undefined}if(!i)i=b._onAfterShow;var m={index:d,item:f};if(b._trigger("beforeShow",null,m)===false)return this;this.container.data("showing.wijlightbox",true);var j=function(){a.isFunction(i)&&i.apply(b);b.container.data("showing.wijlightbox",false);b.container.dequeue("showqueue");b.container.clearQueue("showqueue")};b._refreshCounter(d);var h=this.container.data("player.wijlightbox"),e,l=function(){b.container.data("playerwidth.wijlightbox",e.width);b.container.data("playerheight.wijlightbox",e.height);var f=a.extend({},b._defaults.transAnimation,c.transAnimation);if(c.activeIndex===d||f.animated==="none"||f.duration<=0||!b._isOpen()){c.activeIndex=d;h&&h.remove();e.appendTo(b.content);b._refreshText();j();return}c.cookie&&b._cookie(c.activeIndex,c.cookie);if(f.animated==="slide"){g=g===undefined?d>c.activeIndex:g;b._slideTo(h,e,f,g,j);c.activeIndex=d}else{c.activeIndex=d;var k=function(){if(e){e.appendTo(b.content,true);e.fadeIn(f.duration,j)}};a.browser.msie&&b.frame.trigger("mouseleave");var i=function(){h&&h.remove();if(c.autoSize&&!b._isFullSize())b._resize(k);else{k();b._refreshText()}};if(h)h.fadeOut(f.duration*.4,i);else i()}};e=this._createPlayer(f,l);return this},next:function(){var b=this.options;if(!this._groupMode())return false;var a=b.activeIndex+1;if(b.loop)a=a%b.groupItems.length;if(a<b.groupItems.length){this._show(a,true);return true}return false},back:function(){var b=this.options;if(!this._groupMode())return false;var a=b.activeIndex-1;if(b.loop)a=a<0?b.groupItems.length-1:a;if(a>=0){this._show(a,false);return true}return false},isPlaying:function(){return!!this.container.data("playing.wijlightbox")},_startTimer:function(){if(!this.isPlaying()||!this._groupMode())return;var b=this.options,a=this,c;if(b.showTimer===true){!this.timerMeter&&this._createTimerBar();c=this.timerBar.width();a.timerMeter.width("0");a.timerMeter.animate({width:c},b.delay,function(){a.isPlaying()&&!a.next()&&a.stop()})}else window.setTimeout(function(){a.isPlaying()&&!a.next()&&a.stop()},b.delay)},play:function(){if(!this._groupMode())return false;!this.container.data("playing.wijlightbox")&&this.container.data("playing.wijlightbox",true);this._refreshCtrlButtons();this._hideNavButtons();this._startTimer()},stop:function(){this.container.removeData("playing.wijlightbox");this._refreshCtrlButtons();this._removeTimerBar()},_size:function(d,i){var g=this.options,c=g.width,b=g.height,f=g.autoSize?this.container.data("playerwidth.wijlightbox")||c:c,e=g.autoSize?this.container.data("playerheight.wijlightbox")||b:b,h,j=e/f;if(typeof d==="boolean")i=d;else if(a.isPlainObject(d)&&"width"in d&&"height"in d){c=d.width;b=d.height}else{h=this.container.data("player.wijlightbox");if(g.autoSize&&h&&h.name==="img"){if(f>c){f=c;e=Math.round(c*j)}if(e>b){e=b;f=Math.round(b/j)}}c=f;b=e;if(i)return{width:c,height:b}}this.frame.width(c).height(b);this.container.width(this.frame.outerWidth(true))},_position:function(){var f=this.options,c=[],e=[0,0],d,b=f.position;if(b){if(typeof b==="string"||typeof b==="object"&&"0"in b){c=b.split?b.split(" "):[b[0],b[1]];if(c.length===1)c[1]=c[0];a.each(["left","top"],function(a,b){if(+c[a]===c[a]){e[a]=c[a];c[a]=b}});b={my:c.join(" "),at:c.join(" "),offset:e.join(" ")}}b=a.extend({},f.position,b)}d=this.container.is(":visible");!d&&this.container.show();this.container.css({top:0,left:0}).position(b);!d&&this.container.hide()},_getRelRect:function(b){var c;if(b){if(a.isPlainObject(b)&&"left"in b&&"top"in b&&"width"in b&&"height"in b)c=a.merge({},b);else b=a(b);if(b.jquery&&b.length)c=a.extend({},b.offset(),{width:b.width(),height:b.height()})}return c},_close:function(d){var g=this.options,c=this,b,f,e;if(!this._isOpen())return;f={rel:d};if(false===this._trigger("beforeClose",null,f))return;d=f.rel;if(!d&&this._groupMode())d=g.groupItems[g.activeIndex].img;this.container.data("moving.wijlightbox",true);this._hideAccessories(false);this._hideWaiting();this._hideOverlay();this.stop();e=function(){c._removePlayer();c.container.hide();c._trigger("close");c.container.unbind("keypress.wijlightbox");c.container.removeData("open.wijlightbox").removeData("rect.wijlightbox").removeData("moving.wijlightbox").removeData("fullsize.wijlightbox");a(document).unbind("keydown.wijlightbox").unbind("click.wijlightbox")};b=this._getRelRect(d);if(!b)if(this.container.data("rect.wijlightbox"))b=this.container.data("rect.wijlightbox");this._removeText();if(b){this._moveTo(b,{animated:"sync",duration:200},e);return}e.call();return this},_isOpen:function(){return!!this.container.data("open.wijlightbox")},_open:function(d,f){if(this._isOpen())return;var c=this.options,b=this;if(this.toolBox)if(this._isFullSize())this.toolBox.css({top:"2px",right:"4px"});else this.toolBox.css({top:"",right:""});var e=function(){c.modal&&b._showOverlay();if(c.showControlsOnHover)this._hideAccessories(false);else this._showAccessories(false);var e=b._getRelRect(d);b.container.css("opacity",0);b.container.show();b._size();b._createText(true);b._refreshText(true);b._position();b.container.data("open.wijlightbox",true);if(d&&e){b.container.data("rect.wijlightbox",e);b._moveFrom(e,{animated:"sync"})}else{var f=a.extend({},b._defaults.transAnimation,c.transAnimation);if(f.animated==="fade"){b.container.hide();b.container.fadeIn(f.duration,function(){b._createText()})}else b._createText();this.container.data("moving.wijlightbox",false)}a(document).bind("keydown.wijlightbox",a.proxy(b,"_keyDownHandler")).bind("click.wijlightbox",function(e){var d=e.target||e.srcElement;if(b._isOpen()&&!!c.closeOnOuterClick)d!==b.container.get(0)&&a(d).parents().index(b.container)<0&&b._close()});c.autoPlay&&this.play();b._refreshNavButtons();b._refreshDialogButtons();var g={index:c.activeIndex,item:c.groupItems[c.activeIndex]};b._trigger("show",null,g);b._trigger("open")};this.container.data("moving.wijlightbox",true);this._show(f,true,e);return this},_getWinRect:function(){var b=a(window);return a.extend({width:b.width(),height:b.height()},b.offset()||{left:2,top:2})},_resizeHandler:function(){var a=this;a._removeText();a._size(a._getWinRect());a._createText()},_isFullSize:function(){return!!this.container.data("fullsize.wijlightbox")},_toggleFullSize:function(){var b=this,d=a(window);if(!b._isOpen())return;if(this._isFullSize()){b.toolBox&&b.toolBox.css({top:"",right:""});this.container.data("fullsize.wijlightbox",false);d.unbind("resize.wijlightbox",a.proxy(this,"_resizeHandler"));b._resize(function(){b._adjustPlayerSize(b.content.innerWidth(),b.content.innerHeight())})}else{this.container.data("fullsize.wijlightbox",true);d.bind("resize.wijlightbox",a.proxy(this,"_resizeHandler"));var c=b._getWinRect(),e=this.frame.borderSize();c.width-=e.width;c.height-=e.height;b._removeText();b._moveTo(c,{animated:"sync"},function(){b.toolBox&&b.toolBox.css({top:"2px",right:"4px"});b.frame.width(c.width);b.container.width(b.frame.outerWidth());b._createText();b._adjustPlayerSize(b.content.innerWidth(),b.content.innerHeight())})}this._refreshDialogButtons()},_getExt:function(a){var c,b,e=/[0-9a-z]+$/i,d=a.indexOf("?");if(d>-1)a=a.substring(0,d);b=a.match(e);if(b)c=b[0].toLowerCase();return c},_getPlayerName:function(c){if(c.indexOf("#")===0||c.indexOf("#")>0&&c.indexOf(document.location.href)===0)return"inline";var f=["bmp","gif","jpg","jpeg","png"],g=["swf"],e=["flv","m4v"],i=["dv","mov","moov","movie","mp4","avi","mpg","mpeg"],h=["asf","avi","mpg","mpeg","wm","wmv"],d=["mp4","mpg","mpeg","ogg","ogv"],b=this._getExt(c);if(b){if(a.inArray(b,f)>=0)return"img";if(a.inArray(b,g)>=0)return"swf";if(a.inArray(b,e)>=0)return"flv";if(a.inArray(b,h)>=0)return"wmp";if(a.inArray(b,i)>=0)return"qt";if(a.inArray(b,d)>=0)return"wijvideo"}return"iframe"},_adjustPlayerSize:function(c,b){var a=this.container.data("player.wijlightbox");a&&a.adjustSize&&a.adjustSize(c,b)},_removePlayer:function(){var a=this.container.data("player.wijlightbox");if(a){a.remove();this.container.data("player.wijlightbox",null)}},_createPlayer:function(h,g,e){var b=h.player;if(!a.isFunction(a.wijmo.wijlightbox[b]))throw"unknown player "+b;var d=this,f=false,c,j=function(){f=true;this._hideWaiting();a.isFunction(g)&&window.setTimeout(function(){g.apply(d)},1)},i=function(){this._hideWaiting();a.isFunction(e)&&e.apply(d)};c=new a.wijmo.wijlightbox[b](this,h,j,i);this.container.data("player.wijlightbox",c);window.setTimeout(function(){f===false&&d._showWaiting()},200);return c}});a.extend(a.wijmo.wijlightbox,{img:function(c,b,e,d){this.name="img";this.lightbox=c;this.item=b;this.url=this.lightbox._getUrl(b);var f=this;a("<img></img>").css({width:"auto",height:"auto",display:"none"}).appendTo(document.body).bind({load:function(){var d=a(this);f.width=b.width?parseInt(b.width,10):d.width();f.height=b.height?parseInt(b.height,10):d.height();d.remove();e&&a.isFunction(e)&&e.apply(c)},error:function(){a(this).remove();d&&a.isFunction(d)&&d.apply(c)}}).attr("src",this.url)},swf:function(c,b,d){this.name="swf";var e=c.options;this.id="flashhost";this.lightbox=c;this.item=b;this.url=this.lightbox._getUrl(b);this.width=b.width?parseInt(b.width,10):e.width;this.height=b.height?parseInt(b.height,10):e.height;d&&a.isFunction(d)&&d.apply(c)},iframe:function(c,b,d){this.name="swf";this.lightbox=c;this.item=b;this.url=this.lightbox._getUrl(b);if(b.width)this.width=parseInt(b.width,10);if(b.height)this.height=parseInt(b.height,10);this.$iframe=a("<iframe></iframe>").addClass("wijmo-wijlightbox-iframe").attr({frameborder:"0",marginwidth:"0",marginheight:"0",scrolling:"auto",allowtransparency:"true"}).hide().appendTo(c.content).bind("load",function(){d&&a.isFunction(d)&&d.apply(c)}).attr("src",this.url)},inline:function(c,b,d){this.name="inline";var f=c.options;this.lightbox=c;this.item=b;this.width=b.width?parseInt(b.width,10):f.width;if(b.height)this.height=parseInt(b.height,10);else{var e=a(this.item.href).clone().show().append('<br clear="all" />').wrap('<div class="wijmo-wijlightbox ui-widget"><div class="wijmo-wijlightbox-frame ui-widget-content ui-corner-all ui-helper-clearfix"><div class="wijmo-wijlightbox-frame ui-widget-content ui-corner-all ui-helper-clearfix"><div class="wijmo-wijlightbox-content"> </div></div></div></div>').appendTo(document.body).width(this.width);this.height=e.outerHeight(true)+10;e.unwrap();e.remove()}d&&a.isFunction(d)&&d.apply(c)},flv:function(c,b,d){this.name="flv";var e=c.options;this.id="flvhost";this.lightbox=c;this.item=b;this.url=this.lightbox._getUrl(b);var f=20;this.width=b.width?parseInt(b.width,10):e.width;this.height=b.height?parseInt(b.height,10):e.height;if(e.showMovieControls)this.height+=f;d&&a.isFunction(d)&&d.apply(c)},wmp:function(c,b,d){var e=c.options,f;this.name="wmp";this.id="wmphost";this.lightbox=c;this.item=b;this.url=this.lightbox._getUrl(b);f=a.browser.msie?70:45;this.width=b.width?parseInt(b.width,10):e.width;this.height=b.height?parseInt(b.height,10):e.height;if(e.showMovieControls)this.height+=f;d&&a.isFunction(d)&&d.apply(c)},qt:function(c,b,d){var e=c.options,f=16;this.name="qt";this.id="qthost";this.lightbox=c;this.item=b;this.url=this.lightbox._getUrl(b);this.width=b.width?parseInt(b.width,10):e.width;this.height=b.height?parseInt(b.height,10):e.height;if(e.showMovieControls)this.height+=f;d&&a.isFunction(d)&&d.apply(c)},wijvideo:function(c,b,d){var e=c.options;this.name="wijvideo";this.id="wijvideohost";this.lightbox=c;this.item=b;this.url=this.lightbox._getUrl(b);this.wijvideosrc=!!b.wijvideosrc&&b.wijvideosrc!==""?this.lightbox._getUrl(b.wijvideosrc):null;this.width=b.width?parseInt(b.width,10):e.width;this.height=b.height?parseInt(b.height,10):e.height;d&&a.isFunction(d)&&d.apply(c)}});a.extend(a.wijmo.wijlightbox.img.prototype,{appendTo:function(b,c){this.$element=a("<img></img>").addClass("wijmo-wijlightbox-image").attr("src",this.url);c&&this.$element.hide();if(this.lightbox.options.transAnimation&&this.lightbox.options.transAnimation.animated=="fade"){b.children().length&&b.empty();this.$element.prependTo(b)}else this.$element.appendTo(b)},remove:function(){this.$element&&this.$element.remove()},fadeOut:function(b,a){this.$element&&this.$element.fadeOut(b,a)},fadeIn:function(b,a){this.$element&&this.$element.fadeIn(b,a)},getElement:function(){return this.$element}});a.extend(a.wijmo.wijlightbox.swf.prototype,{appendTo:function(d){this.$container=a("<div/>").css({width:"100%",height:"100%",overflow:"hidden"}).attr("id",this.id).appendTo(d);var b=this.lightbox.options,e=b.flashInstall,f=b.flashVersion,c=b.flashVars,g=b.flashParams;S.flash.embedSWF(this.item.href,this.id,"100%","100%",f,e,c,g)},remove:function(){S.flash.expressInstallCallback();S.flash.removeSWF(this.id);this.$container.remove()},fadeOut:function(b,a){this.$container&&this.$container.fadeOut(b,a)},fadeIn:function(b,a){this.$container&&this.$container.fadeIn(b,a)},getElement:function(){return this.$container}});a.extend(a.wijmo.wijlightbox.iframe.prototype,{appendTo:function(b,a){!a&&this.$iframe.show()},remove:function(){this.$iframe&&this.$iframe.remove()},fadeOut:function(b,a){this.$iframe&&this.$iframe.fadeOut(b,a)},fadeIn:function(b,a){this.$iframe&&this.$iframe.fadeIn(b,a)},getElement:function(){return this.$iframe}});a.extend(a.wijmo.wijlightbox.inline.prototype,{appendTo:function(b,c){this.$element=a(this.item.href).clone().appendTo(b);!c&&this.$element.show()},remove:function(){this.$element&&this.$element.remove()},fadeOut:function(b,a){this.$element&&this.$element.fadeOut(b,a)},fadeIn:function(b,a){this.$element&&this.$element.fadeIn(b,a)},getElement:function(){return this.$element}});a.extend(a.wijmo.wijlightbox.flv.prototype,{appendTo:function(f){this.$container=a("<div/>").css({width:"100%",height:"100%",overflow:"hidden"}).attr("id",this.id).appendTo(f);var b=this.lightbox.options,d="100%",c="100%",j=b.flvPlayer,g=b.flashInstall,h=b.flashVersion,e=a.extend({file:this.url,width:d,height:c,autostart:b.autoPlayMovies?"true":"false",controlbar:b.showMovieControls?"bottom":"none",backcolor:"0x000000",frontcolor:"0xCCCCCC",lightcolor:"0x557722"},b.flashVars),i=a.extend({autostart:b.autoPlayMovies?"true":"false",allowscriptaccess:"always"},b.flashParams);S.flash.embedSWF(j,this.id,d,c,h,g,e,i)},remove:function(){S.flash.expressInstallCallback();S.flash.removeSWF(this.id);this.$container.remove()},fadeOut:function(b,a){this.$container&&this.$container.fadeOut(b,a)},fadeIn:function(b,a){this.$container&&this.$container.fadeIn(b,a)},getElement:function(){return this.$container}});a.extend(a.wijmo.wijlightbox.wmp.prototype,{appendTo:function(f){this.$container=a("<div/>").css({width:"100%",height:"100%",overflow:"hidden"}).appendTo(f);var d=this.lightbox.options,b='<object id="'+this.id+'" name="'+this.id+'" height="'+this.height+'" width="'+this.width+'"',c={autostart:d.autoPlayMovies?1:0},e;if(a.browser.msie){b+=' classid="clsid:6BF52A52-394A-11d3-B153-00C04F79FAA6"';c.url=this.url;c.uimode=d.showMovieControls?"full":"none"}else{b+=' type="video/x-ms-wmv"';b+=' data="'+this.url+'"';c.showcontrols=d.showMovieControls?1:0}b+=">";for(e in c)b+='<param name="'+e+'" value="'+c[e]+'">';b+="</object>";this.$container.html(b)},remove:function(){if(a.browser.msie)try{window[this.id].controls.stop();window[this.id].URL="movie"+now()+".wmv";window[this.id]=function(){}}catch(b){}this.$container.remove()},fadeOut:function(b,a){this.$container&&this.$container.fadeOut(b,a)},fadeIn:function(b,a){this.$container&&this.$container.fadeIn(b,a)},getElement:function(){return this.$container}});a.extend(a.wijmo.wijlightbox.qt.prototype,{appendTo:function(d,h){this.$container=a("<div/>").css({width:"100%",height:"100%",overflow:"hidden"}).appendTo(d);var i=this.lightbox.options,j=i.autoPlayMovies?"true":"false",k=i.showMovieControls?"true":"false",c="<object",b={id:this.id,name:this.id,width:this.width,height:this.height,kioskmode:"true"},e,f;if(a.browser.msie){b.classid="clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B";b.codebase="http://www.apple.com/qtactivex/qtplugin.cab#version=6,0,2,0"}else{b.type="video/quicktime";b.data=this.url}for(e in b)c+=" "+e+'="'+b[e]+'"';c+=">";var g={src:this.url,scale:"aspect",controller:k,autoplay:j};for(f in g)c+='<param name="'+f+'" value="'+g[f]+'">';c+="</object>";h&&d.hide();this.$container.html(c);h&&d.show()},remove:function(){try{document[this.id].Stop();document[this.id]=null}catch(a){}this.$container.remove()},fadeOut:function(b,a){a.call();return},fadeIn:function(b,a){a.call();return},getElement:function(){return this.$container}});a.extend(a.wijmo.wijlightbox.wijvideo.prototype,{appendTo:function(c){var b=this.lightbox.options;this.$container=a("<video/>").css({overflow:"hidden"}).attr({width:this.width,height:this.height,autoPlay:b.autoPlayMovies?"true":"false",controls:b.showMovieControls?"controls":""}).appendTo(c);!!this.url&&a("<source/>").attr({src:this.url}).appendTo(this.$container);!!this.wijvideosrc&&a("<source/>").attr({src:this.wijvideosrc}).appendTo(this.$container);this.$container.wijvideo({fullScreenButtonVisible:false})},remove:function(){this.$container.remove()},fadeOut:function(b,a){this.$container&&this.$container.fadeOut(b,a)},fadeIn:function(b,a){this.$container&&this.$container.fadeIn(b,a)},getElement:function(){return this.$container},adjustSize:function(b,a){this.$container.wijvideo("setWidth",b);this.$container.wijvideo("setHeight",a)}});a.extend(a.wijmo.wijlightbox,{overlay:function(d,c){this.mask=a("<div></div>").addClass("ui-widget-overlay wijmo-wijlightbox-overlay"+(c?" wijmo-wijlightbox-waitingoverlay":"")).appendTo(document.body).css({width:this.width(),height:this.height()}).bind("click",function(){d._close();return false});a.fn.bgiframe&&this.mask.bgiframe();if(c){this.mask.css("z-index",this.zIndex);var b=a("<div></div>").addClass("wijmo-wijlightbox-waiting").css("z-index",this.zIndex+1).appendTo(this.mask);b.css({left:(this.mask.width()-b.width())/2,top:(this.mask.height()-b.height())/2})}a(window).bind("resize.wijlightbox-overlay",a.proxy(this,"resize"));window.setTimeout(function(){var b;if(this.mask){b=a.wijmo.wijlightbox.overlay;a(document).bind(b.events,function(c){if(a(c.target).zIndex()<b.zIndex)return false})}},1)}});a.extend(a.wijmo.wijlightbox.overlay.prototype,{mask:null,zIndex:1e3,events:a.map("focus,mousedown,mouseup,keydown,keypress,click".split(","),function(a){return a+".wijlightbox-overlay"}).join(" "),close:function(){a([document,window]).unbind(".wijlightbox-overlay");this.mask.remove();this.mask=undefined},height:function(){var b,c;if(a.browser.msie&&a.browser.version<7){b=Math.max(document.documentElement.scrollHeight,document.body.scrollHeight);c=Math.max(document.documentElement.offsetHeight,document.body.offsetHeight);return b<c?a(window).height():b}else return a(document).height()},width:function(){var b,c;if(a.browser.msie&&a.browser.version<7){b=Math.max(document.documentElement.scrollWidth,document.body.scrollWidth);c=Math.max(document.documentElement.offsetWidth,document.body.offsetWidth);return b<c?a(window).width():b}else return a(document).width()},resize:function(){this.mask&&this.mask.css({width:this.width(),height:this.height()})}})})(jQuery);
(function(a){"use strict";a.widget("wijmo.wijcompositechart",a.wijmo.wijchartcore,{options:{stacked:false,clusterOverlap:0,clusterWidth:85,clusterRadius:0,clusterSpacing:0,seriesList:[],animation:{enabled:true,duration:400,easing:">"},seriesTransition:{enabled:true,duration:400,easing:">"},mouseDown:null,mouseUp:null,mouseOver:null,mouseOut:null,mouseMove:null,click:null},_create:function(){var c=this,b=c.options,d=c._getDefFill();a.each(b.seriesList,function(d,c){if(c.type==="bar"){a.extend(true,b.axis,{x:{compass:"west"},y:{compass:"south"}});return true}else if(c.type==="pie"&&c.pieSeriesList)c.data=c.pieSeriesList});a.extend(true,{compass:"east"},b.hint);if(b.is100Percent)b.is100Percent=false;a.each(b.seriesStyles,function(b,a){if(!a.fill)a.fill=d[b]});a.wijmo.wijchartcore.prototype._create.apply(c,arguments);c.chartElement.addClass("wijmo-wijcompositechart")},_setOption:function(b){b!=="is100Percent"&&a.wijmo.wijchartcore.prototype._setOption.apply(this,arguments)},destroy:function(){var d=this,b=d.chartElement,c=b.data("fields"),e=c&&c.aniBarsAttr;b.removeClass("wijmo-wijcompositechart");a.wijmo.wijchartcore.prototype.destroy.apply(this,arguments);d._destroyRaphaelArray(e);b.data("fields",null)},_isBarChart:function(){return true},_clearChartElement:function(){var c=this,e=c.options,d=c.chartElement,b=d.data("fields");if(b&&b.allElements){a.each(b.allElements,function(d,b){if(d==="scatters")b.length&&a.each(b,function(d,c){if(c.length){a.each(c,function(b,a){a&&a.remove&&a.remove();c[b]=null});b[d]=null}});c._destroyRaphaelArray(b)});b.allElements=null}a.wijmo.wijchartcore.prototype._clearChartElement.apply(c,arguments);if(b&&b.ctracers)b.ctracers=null;c.element.removeData("plotInfos");if(!e.seriesTransition.enabled)if(b&&b.aniBarsAttr)b.aniBarsAttr=null},_bindData:function(){var b=this,e=b.options,f=e.dataSource,g=e.seriesList,c=e.data,d;a.each(g,function(q,l){var e=l.data,m,n,k,j=l.dataSource||f,p=l.type,h,i,g,o=[];if(j&&e)if(p==="pie"){h=e.label;i=e.value;g=e.offset;if(h&&h.bind)h=b._getBindData(j,h.bind);if(i&&i.bind)i=b._getBindData(j,i.bind);if(g&&g.bind)g=b._getBindData(j,g.bind);if(h&&a.isArray(h)&&h.length&&i&&a.isArray(i)&&i.length){a.each(i,function(b,e){var d,c=0;if(b>=0&&b<h.length)d=h[b];if(g&&a.isArray(i)&&g.length&&b>=0&&b<g.length)c=typeof g[b]==="undefined"?0:g[b];o.push({data:e,label:d,offset:c,legendEntry:true})});l.data=o}}else{m=e.x;n=e.y;k=e.y1;if(m&&m.bind)e.x=b._getBindData(j,m.bind);else if(c&&c.x&&c.x.bind){if(d===undefined)d=b._getBindData(j,c.x.bind);e.x=d}if(n&&n.bind)e.y=b._getBindData(j,n.bind);if(k&&k.bind)e.y1=b._getBindData(j,k.bind)}})},getElement:function(f,b,c){var d=this.chartElement,e=d.data("fields"),a=e.chartElements;switch(f){case"bar":case"column":return a.bars[b];case"line":case"area":return a.paths[b];case"linemarkers":return a.markersSet[b];case"pie":return this._getPie(a,b,c)}return null},_getPie:function(b,e,d){if(d!==undefined)return b["sectors"+d]?b["sectors"+d][e]:null;else{var c=[];a.each(b,function(b,d){/sectors/.test(b)&&b!=="sectors"&&a.each(d,function(b,a){c.push(a)})});if(c.length===0)c=b.sectors;return c[e]}},_isSeriesDataEmpty:function(){var c=this,b=c.options.seriesList;if(!b||b.length===0)return true;a.each(b,function(b,a){return a.type==="pie"&&(!a.data||!a.label||a.label.length===0)?true:!a.data||(!a.data.x||!a.data.y)&&!a.data.xy?true:void 0});return false},_showSerieEles:function(d){var f=d.type,b=d.eles,e=this.options.showChartLabels,c;switch(f){case"pie":if(b.sector){b.sector.show();b.sector.shadow&&b.sector.shadow.show();b.sector.tracker&&b.sector.tracker.show()}b.label&&b.label.show();break;case"line":case"spline":case"bezier":case"area":b.markers&&a.each(b.markers,function(d,b){c=a(b.node).data("wijchartDataObj");if(c&&c.lineSeries&&c.lineSeries.markers)if(!c.lineSeries.markers.visible)return true;b.show()});b.dcl&&a.each(b.dcl,function(b,a){e&&a.show()});if(b.path){c=a(b.path.node).data("wijchartDataObj");if(c.visible){b.path.show();b.path.shadow&&b.path.shadow.show();b.path.area&&b.path.area.show();b.path.tracker&&b.path.tracker.show()}}break;case"bar":case"column":a.each(b,function(b,a){if(a.bar){a.bar.show();a.bar.shadow&&a.bar.shadow.show();a.bar.tracker&&a.bar.tracker.show()}a.dcl&&a.dcl.show();a.animatedBar&&!a.animatedBar.removed&&a.animatedBar.show()});break;case"scatter":a.each(b,function(b,a){a.show()})}},_hideSerieEles:function(c){var d=c.type,b=c.eles;switch(d){case"pie":if(b.sector){b.sector.hide();b.sector.shadow&&b.sector.shadow.hide();b.sector.tracker&&b.sector.tracker.hide()}b.label&&b.label.hide();break;case"line":case"spline":case"bezier":case"area":b.markers&&a.each(b.markers,function(b,a){a.hide()});b.dcl&&a.each(b.dcl,function(b,a){a.hide()});if(b.path){b.path.hide();b.path.shadow&&b.path.shadow.hide();b.path.area&&b.path.area.hide();b.path.tracker&&b.path.tracker.hide()}break;case"bar":case"column":a.each(b,function(b,a){if(a.bar){a.bar.hide();a.bar.shadow&&a.bar.shadow.hide();a.bar.tracker&&a.bar.tracker.hide()}a.dcl&&a.dcl.hide();a.animatedBar&&!a.animatedBar.removed&&a.animatedBar.hide()});break;case"scatter":a.each(b,function(b,a){a.hide()})}},_paintTooltip:function(){var b=this,d=b.chartElement,e=d.data("fields")||{},c=e.ctracers||[];a.wijmo.wijchartcore.prototype._paintTooltip.apply(this,arguments);b.tooltip&&a.each(c,function(c,a){if(a.trackers&&a.trackers.length)c===0&&b.tooltip.setOptions({relatedElement:a.trackers[0]})})},_paintPlotArea:function(){var b=this,c=b.options,g="seriesList",f="seriesStyles",e="seriesHoverStyles",o=c[f],m=c[e],i=b.canvasBounds,l={},h=0,p=a.isArray(c.axis.y),k={canvas:b.canvas,tooltip:b.tooltip,bounds:i,widgetName:b.widgetName,seriesTransition:c.seriesTransition,showChartLabels:c.showChartLabels,textStyle:c.textStyle,chartLabelStyle:c.chartLabelStyle,chartLabelFormatString:c.chartLabelFormatString,shadow:c.shadow,hint:c.hint,animation:c.animation,disabled:c.disabled,culture:b._getCulture(),mouseDown:function(c,a){b._trigger("mouseDown",c,a)},mouseUp:function(c,a){b._trigger("mouseUp",c,a)},mouseOver:function(c,a){b._trigger("mouseOver",c,a)},mouseOut:function(c,a){b._trigger("mouseOut",c,a)},mouseMove:function(c,a){b._trigger("mouseMove",c,a)},click:function(c,a){b._trigger("click",c,a)}},n=b.chartElement.data("fields"),d,j;if(n)n.ctracers=[];a.each(c[g],function(s,d){var j=d.type,b={},k=j,i={},q=a.extend({},o[h]),n=a.extend({},m[h]),r=d.yAxis;if(!j||j.length===0)return true;if(k==="spline"||k==="bezier")k="line";b=l[k];if(!b){if(j==="pie")b=[];else b={};l[k]=b;if(d.hint){b.hint=d.hint;if(!c.hint.content)c.hint.content=d.hint.content;if(!c.hint.title)c.hint.title=d.hint.title}}if(j==="pie"){a.each(d.data,function(c,b){q=a.extend({},o[h]);n=a.extend({},m[h]);if(!i[g])i[g]=[];if(!i[f])i[f]=[];if(!i[e])i[e]=[];b.pieID=s+1;i[g].push(b);i[f].push(q);i[e].push(n);h++});i.radius=d.radius;i.center=d.center;i.label=d.label;b.push(i);return true}else if(j==="column")b.horizontal=false;else if(j==="bar")b.horizontal=true;else if(j==="spline")d.fitType="spline";else if(j==="bezier")d.fitType="bezier";if(p)b.yAxis=r||0;if(j==="line"||j==="spline"||j==="bezier"){delete q.fill;delete n.fill}if(!b[g])b[g]=[];if(!b[f])b[f]=[];if(!b[e])b[e]=[];b[g].push(d);b[f].push(q);b[e].push(n);h++});a.each(l,function(e,f){var g=f.yAxis;switch(e){case"pie":a.each(f,function(j,g){var f=g.center,c=g.radius||50,h=f?{startX:f.x-c,startY:f.y-c,endX:f.x+c,endY:f.y+c}:{startX:i.startX+10,startY:i.startY+10,endX:i.startX+10+2*c,endY:i.startY+10+2*c};d=a.extend(true,{},k,{bounds:h,radius:c},g);b.chartElement.wijpie(d);b.chartElement.data("fields").aniSectorAttrs=null;b.chartElement.data("fields").aniLabelAttrs=null;b._savechartData(e)});break;case"bar":case"column":d=a.extend(true,{},k,{stacked:c.stacked,axis:c.axis,clusterOverlap:c.clusterOverlap,clusterWidth:c.clusterWidth,clusterSpacing:c.clusterSpacing,is100Percent:c.is100Percent,clusterRadius:c.clusterRadius,isYTime:b.axisInfo.y[0].isTime,isXTime:b.axisInfo.x.isTime,yAxisInfo:b.axisInfo.y,yAxisIndex:g},f);b.chartElement.wijbar(d);b._savechartData(e);break;case"line":case"spline":case"bezier":case"area":j=b._getyAxisGroup(f);a.each(j,function(g,f){if(!b.aniPathsAttr)b.aniPathsAttr=[];d=a.extend(true,{},k,{axis:c.axis,isXTime:b.axisInfo.x.isTime,isYTime:b.axisInfo.y[0].isTime,aniPathsAttr:b.aniPathsAttr,chartLabelEles:b.chartLabelEles,type:e==="area"?"area":"line",hole:c.hole},f);d.axis.y=c.axis.y[g]||c.axis.y;b.chartElement.wijline(d);b._savechartData(e,true)});break;case"scatter":j=b._getyAxisGroup(f);a.each(j,function(g,f){d=a.extend(true,{},k,{axis:c.axis,isXTime:b.axisInfo.x.isTime,isYTime:b.axisInfo.y[0].isTime,zoomOnHover:c.zoomOnHover},f);d.axis.y=c.axis.y[g]||c.axis.y;b.chartElement.wijscatter(d);b._savechartData(e)})}});b.chartElement.data("fields").seriesEles=null;b._bindtooltip()},_savechartData:function(f,g){var d=this,b=d.chartElement.data("fields"),h=b.seriesEles,e=b.allElements||{},c;a.each(h,function(b,a){d.seriesEles.push({eles:a,type:f})});if(g)b.ctracers=[];else{c=b.ctracers||[];c.push({trackers:b.trackers,type:f});b.ctracers=c}b&&b.chartElements&&a.each(b.chartElements,function(b,a){d._copyElements(e,b,a)});b.allElements=e},_copyElements:function(d,e,b){var c;if(b&&a.isArray(b)){c=d[e]||[];d[e]=c.concat(b)}else if(b){c=d[e]||[];c.concat([b])}},_getyAxisGroup:function(c){var b={};a.each(c.seriesList,function(e,d){var a=d.yAxis||0;if(!b[a])b[a]={seriesList:[],seriesStyles:[],seriesHoverStyles:[]};b[a].seriesList.push(d);b[a].seriesStyles.push(c.seriesStyles[e]);b[a].seriesHoverStyles.push(c.seriesHoverStyles[e])});return b},_bindtooltip:function(){var b=this,c=b.widgetName,d=b.chartElement.data("fields");d&&a.each(d.ctracers,function(b,a){a.trackers&&a.trackers.toFront()});b.chartElement.delegate(".linetracker, .bartracker, .pietracker, .wijscatterchart","mouseover."+c,a.proxy(b._tooltipMouseOver,b));b.chartElement.delegate(".linetracker, .bartracker, .pietracker, .wijscatterchart","mouseout."+c,a.proxy(b._tooltipMouseOut,b));b.chartElement.delegate(".linetracker, .bartracker, .pietracker, .wijscatterchart","mousemove."+c,a.proxy(b._tooltipMouseMove,b))},_tooltipMouseOver:function(f){var d=f.target,b=this,o=b.tooltip,i=b.options.hint,e=null,n=i.title,m=i.content,l=i.style,k=a.isFunction(n),j=a.isFunction(m),c,g,h;h=a(b.canvas.canvas.parentNode).offset();if(a(d).data("owner"))d=a(d).data("owner");d=a(d);c=d.data("wijchartDataObj");if(b.tooltip){e=o.getOptions();if(k||j){if(k)e.title=a.proxy(n,c);if(j)e.content=a.proxy(m,c)}if(c.type==="line"){if(c.path.removed)return;if(b.hoverLine!==c){b.isNewLine=true;if(b.hoverLine)if(!b.hoverLine.path.removed){b.hoverLine.path.wijAttr(b.hoverLine.lineStyle);if(b.hoverPoint&&!b.hoverPoint.isSymbol){b.hoverPoint.marker.wijAttr(b.hoverPoint.markerStyle);b.hoverPoint.marker.transform("s1")}}c.lineHoverStyle&&c.path.wijAttr(c.lineHoverStyle);b.hoverLine=c;b.hoverPoint=null;b.hoverVirtualPoint=null}}else if(c.type==="scatter"){b._clearHoverState();g=c.dot.getBBox();e.style.stroke=l.stroke||d.attr("stroke");b.tooltip.showAt({x:g.x+g.width/2,y:g.y},f)}else{b._clearHoverState();e.style.stroke=l.stroke||d.attr("stroke");b.tooltip.showAt({x:f.pageX-h.left,y:f.pageY-h.top},f)}}},_tooltipMouseMove:function(c){var e=this,b=c.target,d,f=a(e.canvas.canvas.parentNode).offset();if(a(b).data("owner"))b=a(b).data("owner");b=a(b);d=b.data("wijchartDataObj");if(e.tooltip)d.type!=="line"&&d.type!=="scatter"&&e.tooltip.showAt({x:c.pageX-f.left,y:c.pageY-f.top},c)},_tooltipMouseOut:function(e){var d=this,b=e.target,c;if(a(b).data("owner"))b=a(b).data("owner");b=a(b);c=b.data("wijchartDataObj");if(c.type!=="line")d.tooltip&&d.tooltip.hide()},_mouseMoveInsidePlotArea:function(v,r){var b=this,g=b.tooltip,k=b.options.hint,f,i,c=0,m,e,n,o,u=null,h=null,l=null,t=k.title,s=k.content,q=a.isFunction(t),p=a.isFunction(s),j=0,d;if(g)l=g.getOptions();if(b.hoverLine){d=b.hoverLine;if(b.isNewLine){k.enable&&g&&g.hide();b.isNewLine=false}f=d.lineMarkers;i=d.virtualMarkers;c=-1;m={x:0,y:0};if(f&&f.length){a.each(f,function(f,b){if(b.removed)return true;var a=b.wijGetBBox(),e=a.x+a.width/2,d=Math.abs(e-r.left);if(f===0||d<j){j=d;c=f;m={x:e,y:a.y+a.height/2}}});if(b.hoverPoint&&b.hoverPoint.index===c)return;if(c>-1){if(f[c].removed)return;e=a(f[c].node).data("wijchartDataObj");if(e){if(b.hoverPoint&&!b.hoverPoint.isSymbol)if(!b.hoverPoint.removed){b.hoverPoint.marker.wijAttr(b.hoverPoint.markerStyle);b.hoverPoint.marker.transform("s1")}if(!e.isSymbol)!e.marker.removed&&e.marker.wijAttr(e.markerHoverStyle)}b.hoverPoint=e;b.hoverVirtualPoint=i[c]}}else{a.each(i,function(d,a){var b=Math.abs(a.x-r.left);if(d===0||b<j){j=b;c=d;m={x:a.x,y:a.y}}});if(b.hoverVirtualPoint&&b.hoverVirtualPoint.index===c)return;if(c>-1){b.hoverPoint=null;b.hoverVirtualPoint=i[c]}}if(g){h=b.hoverVirtualPoint;n=h.valX;o=h.valY;if(q||p){if(q)l.title=function(){var b={pointIndex:c,lineIndex:d.index,x:n,y:o,label:d.label,data:h,fmt:t},e=a.proxy(b.fmt,b),f=e();return f};if(p)l.content=function(){var b={pointIndex:c,lineIndex:d.index,x:n,y:o,label:d.label,data:h,fmt:s},f=a.proxy(b.fmt,b),e=f();return e}}u=a.extend({stroke:d.path.attr("stroke")},k.style);l.style.stroke=u.stroke;g.showAt(m)}}a.wijmo.wijchartcore.prototype._mouseMoveInsidePlotArea.apply(b,arguments)},_mouseMoveOutsidePlotArea:function(){var b=this;b._clearHoverState();a.wijmo.wijchartcore.prototype._mouseMoveOutsidePlotArea.apply(b,arguments)},_clearHoverState:function(){var a=this,b=a.tooltip,c=a.options.hint;c.enable&&b&&b.hide();if(a.hoverLine)if(!a.hoverLine.path.removed){a.hoverLine.path.wijAttr(a.hoverLine.lineStyle);if(a.hoverPoint&&!a.hoverPoint.isSymbol){a.hoverPoint.marker.wijAttr(a.hoverPoint.markerStyle);a.hoverPoint.marker.transform("s1")}}a.hoverLine=null;a.hoverPoint=null;a.hoverVirtualPoint=null},_getTooltipText:function(){return""},_calculateParameters:function(d,g){var e=this,f=false,c,b;a.wijmo.wijchartcore.prototype._calculateParameters.apply(e,arguments);a.each(e.options.seriesList,function(b,a){if(a.type==="column"||a.type==="bar"){f=true;return false}});if(!f)return;if(d.id==="x"){c=g.unitMinor;b=e._getBarAdjustment(d);if(b===0)b=c;else if(c<b&&c!==0)b=Math.floor(b/c)*c;d.min-=b;d.max+=b;e._calculateMajorMinor(g,d)}},_getBarAdjustment:function(d){var b=0,g=this.options,f=d.max,c=d.min,e=0;a.each(g.seriesList,function(c,a){if(a.type==="pie")return true;if(a.data.x===undefined||a.data.y===undefined)return true;e=a.data.x.length;if(b<e)b=e});if(b>1)return(f-c)/b*g.clusterWidth*.0125;else if(b===1){if(c===0&&f===1){c=-1;d.min=c}return(f-c)*.0125}else return 0}})})(jQuery);
(function(a){"use strict";a.widget("wijmo.wijdatepager",{options:{culture:"",firstDayOfWeek:0,selectedDate:new Date,viewType:"day",nextTooltip:"right",prevTooltip:"left"},_setOption:function(c,b){a.Widget.prototype._setOption.apply(this,arguments);switch(c){case"culture":this.options.culture=b;this._initBackground();break;case"selectedDate":this.options.selectedDate=b;this._initBackground();break;case"disabled":if(b)this._disable();else this._enable();break;case"viewType":this.options.viewType=b;this._initBackground();break;case"nextTooltip":this.element.find(".wijmo-wijdatepager-increment").attr("title",b);break;case"prevTooltip":this.element.find(".wijmo-wijdatepager-decrement").attr("title",b)}return this},_disable:function(){this.element.addClass("ui-state-disabled");this.element.find(".wijmo-wijdatepager-decrement").button("option","disabled",true);this.element.find(".wijmo-wijdatepager-increment").button("option","disabled",true)},_enable:function(){this.element.removeClass("ui-state-disabled");this.element.find(".wijmo-wijdatepager-decrement").button("option","disabled",false);this.element.find(".wijmo-wijdatepager-increment").button("option","disabled",false)},_create:function(){var b=this.options,c;if(window.wijmoApplyWijTouchUtilEvents)a=window.wijmoApplyWijTouchUtilEvents(a);if(!b.selectedDate)b.selectedDate=new Date;this._dtpagernamespacekey="dtpager"+ +new Date;this.element.addClass("wijmo-wijdatepager ui-widget ui-helper-clearfix");c=a.proxy(this.invalidate,this);a(window).bind("resize."+this._dtpagernamespacekey,c);this.element.disableSelection();this.element.append(a('<a class="wijmo-wijdatepager-decrement"><span>'+b.prevTooltip+"</span></a>")).append('<div class="wijmo-wijdatepager-container ui-widget-content"><div class="wijmo-wijdatepager-pages"></div></div><a class="wijmo-wijdatepager-increment"><span>'+b.nextTooltip+"</span></a>");a.Widget.prototype._create.apply(this,arguments);this.element.find(".wijmo-wijdatepager-decrement").button({icons:{primary:"ui-icon-triangle-1-w"},text:false}).click(a.proxy(this.goLeft,this));this.element.find(".wijmo-wijdatepager-increment").button({icons:{primary:"ui-icon-triangle-1-e"},text:false}).click(a.proxy(this.goRight,this));this._initBackground();b.disabled&&this._disable()},destroy:function(){this.element.removeClass("wijmo-wijdatepager");a(window).unbind("."+this._dtpagernamespacekey)},refresh:function(){this.invalidate()},invalidate:function(){var g=a(this.element.find(".wijmo-wijdatepager-pagelabel")[this._index]),c=this.element.find(".wijmo-wijdatepager-container"),e=this.element.find(".wijmo-wijdatepager-decrement"),f=this.element.find(".wijmo-wijdatepager-increment"),b=this.element.innerWidth(),d=e.is(":visible")?e.outerWidth(true):0,h=f.is(":visible")?f.outerWidth(true):0;this.element.find(".wijmo-wijdatepager-pagelabel.ui-state-active").removeClass("ui-state-active");g.addClass("ui-state-active");c.css("left",d);this.element.removeClass("wijmo-wijdatepager-width-smallest wijmo-wijdatepager-width-small wijmo-wijdatepager-width-medium wijmo-wijdatepager-width-normal");if(b<300)this.element.addClass("wijmo-wijdatepager-width-smallest");else if(b<475)this.element.addClass("wijmo-wijdatepager-width-small");else if(b<600)this.element.addClass("wijmo-wijdatepager-width-medium");else this.element.addClass("wijmo-wijdatepager-width-normal");c.outerWidth(b-d-h)},goLeft:function(){var a=this.options;if(a.disabled)return;this._setSelectedIndex(this._index-1,true)},goRight:function(){var a=this.options;if(a.disabled)return;this._setSelectedIndex(this._index+1)},_getCulture:function(a){return Globalize.findClosestCulture(a||this.options.culture)},_isRTL:function(){return!!this._getCulture().isRTL},_initBackground:function(j,i){var f,d,c,b,g,h,e=this;if(this._isInAnimate)return;this._index=0;this._datesDef=this._getDatesDefinition();this._min=0;this._max=this._datesDef.length-1;f="";for(d=0;d<this._datesDef.length;d+=1)f+='<div class="wijmo-wijdatepager-pagelabel'+(d===0?" wijmo-wijdatepager-pagelabel-first":"")+(this._datesDef[d].range?" wijmo-wijdatepager-pagerange":"")+(this._datesDef[d].header?" wijmo-wijdatepager-pageheader ui-state-highlight":"")+(d===this._datesDef.length-1?" wijmo-wijdatepager-pagelabel-last":"")+'">'+this._datesDef[d].l+"</div>";b=this.element.find(".wijmo-wijdatepager-pages");if(j){this._isInAnimate=true;c=b.clone(true);b.html(f);g=b.find(".wijmo-wijdatepager-pagelabel");if(!i){c.insertBefore(b);h=a(g[this._index]).offset().left;b.css("opacity",0).css("left",c.outerWidth(true)).stop().animate({left:"0px",opacity:100});c.stop().animate({left:"-"+c.outerWidth(true)+"px",opacity:0},function(){c.remove();e._isInAnimate=false;e.invalidate()})}else{c.insertAfter(b);h=a(g[this._index]).offset().left;b.css("opacity",0).css("left",-c.outerWidth(true)).stop().animate({left:"0px",opacity:100});c.css("left",0).stop().animate({left:c.outerWidth(true)+"px",opacity:0},function(){c.remove();e._isInAnimate=false;e.invalidate()})}}else{b.html(f);this.invalidate()}b.find(".wijmo-wijdatepager-pagelabel").hover(a.proxy(this._pagelabelHover,this),a.proxy(this._pagelabelHout,this));b.find(".wijmo-wijdatepager-pagelabel").bind("mousedown",a.proxy(this._pagelabelMouseDown,this));b.find(".wijmo-wijdatepager-pagelabel").click(a.proxy(function(d){var c=a(d.target),b;b=this.element.find(".wijmo-wijdatepager-pagelabel").index(c);this._setSelectedIndex(b)},this))},_addDays:function(a,b){return new Date(a.getFullYear(),a.getMonth(),a.getDate()+b)},_getDatesDefinition:function(){var g=this.options,i=g.viewType.toLowerCase(),d,c,a,f,h,e=[],b=g.selectedDate;switch(i){case"week":a=new Date(b.getFullYear(),b.getMonth(),-6);d=g.firstDayOfWeek-a.getDay();if(Math.abs(d)>6)d=a.getDay()-g.firstDayOfWeek;a=this._addDays(a,d);h=new Date(b.getFullYear(),b.getMonth()+1,7);d=0;while(a<h||a.getMonth()===b.getMonth()){f=this._addDays(a,7);e.push({l:Globalize.format(a,"MMM",this._getCulture())+" "+Globalize.format(a,"dd",this._getCulture())+"-"+Globalize.format(this._addDays(a,6),"dd",this._getCulture()),d:a,d2:this._addDays(a,6)});if(b>=a&&b<=f)this._index=d;a=f;d+=1}break;case"month":c=new Date(b.getFullYear()-1,0,1);e.push({l:c.getFullYear(),d:c,range:true});c=new Date(b.getFullYear(),0,1);e.push({l:c.getFullYear(),d:c,header:true});for(d=0;d<12;d+=1){c=new Date(b.getFullYear(),d,1);e.push({l:Globalize.format(c,"MMM",this._getCulture()),d:c});f=new Date(b.getFullYear(),d+1,1);if(b>=c&&b<=f)this._index=d+2}c=new Date(b.getFullYear()+1,0,1);e.push({l:c.getFullYear(),d:c,range:true});break;default:c=new Date(b.getFullYear(),b.getMonth(),0);e.push({l:Globalize.format(c,"MMM",this._getCulture()),d:c,range:true});c=new Date(b.getFullYear(),b.getMonth(),1);e.push({l:Globalize.format(c,"MMM",this._getCulture()),d:c,header:true});a=c;d=2;while(a.getMonth()===b.getMonth()){f=new Date(a.getFullYear(),a.getMonth(),a.getDate()+1);e.push({l:Globalize.format(a,"d ",this._getCulture()),d:a});if(b>=a&&b<=f)this._index=d;a=f;d+=1}c=new Date(b.getFullYear(),b.getMonth()+1,1);e.push({l:Globalize.format(c,"MMM",this._getCulture()),d:c,range:true})}return e},_setSelectedIndex:function(a,c){var b=this.options;if(b.disabled)return;if(a>=this._min&&a<=this._max){this._dragActivated&&this._showTooltip(a);if(this._index!==a){if(this._datesDef[a].header)if(c)a=a-1;else return;this._index=a;b.selectedDate=this._datesDef[a].d;if(this._index===this._max)if(b.viewType==="week")b.selectedDate=new Date(b.selectedDate.getFullYear(),b.selectedDate.getMonth(),b.selectedDate.getDate()+7);if(this._max>2&&this._index===0)this._initBackground(true,true);else if(this._index===this._max)this._initBackground(true,false);else this.invalidate();this._trigger("selectedDateChanged",null,{selectedDate:b.selectedDate})}}},_pagelabelHover:function(c){var b=a(c.target);if(b.hasClass("wijmo-wijdatepager-pageheader"))return;b.addClass("ui-state-hover")},_showTooltip:function(d){var g=this.options,b=this._datesDef[d],e=g.viewType,c,f=this.element.find(".wijmo-wijdatepager-pagelabel")[d];if(!this._tooltip){this._tooltip=a('<div class="wijmo-wijdatepager-tooltip"><div class="wijmo-wijdatepager-tooltip-inner"></div><div class="wijmo-wijdatepager-triangle"></div></div>');this.element.append(this._tooltip);this._tooltip.wijpopup()}c="";switch(e){case"day":c=Globalize.format(b.d,"dddd, MMMM d, yyyy",this._getCulture());break;case"week":c=Globalize.format(b.d,"MMMM d - ",this._getCulture())+Globalize.format(b.d2,b.d.getMonth()!==b.d2.getMonth()?"MMMM d, yyyy":"d, yyyy",this._getCulture());break;case"month":c=Globalize.format(b.d,"MMMM yyyy",this._getCulture())}this._tooltip.wijpopup("show",{of:f,my:"center bottom",at:"center top",offset:"-10 -10"});this._tooltip.find(".wijmo-wijdatepager-tooltip-inner").html(c)},_hideTooltip:function(){this._tooltip.wijpopup("hide")},_pagelabelHout:function(b){a(b.target).removeClass("ui-state-hover")},_pagelabelMouseDown:function(c){this._dragActivated=false;if(this.options.disabled)return;c.preventDefault();var d=a(c.target),b;if(d.hasClass("wijmo-wijdatepager-pageheader"))return;b=this.element.find(".wijmo-wijdatepager-pagelabel").index(d);this._dragActivated=true;this._setSelectedIndex(b);this._mouseDownTimeFix20555=+new Date;this._startClientX=c.pageX;this._startInd=b;a(document).bind("mousemove."+this._dtpagernamespacekey,a.proxy(this._pageindicatorMouseMove,this));a(document).bind("mouseup."+this._dtpagernamespacekey,a.proxy(this._pageindicatorMouseUp,this))},_pageindicatorMouseMove:function(d){d.preventDefault();if(this._isInAnimate)return;var b=this.element.find(".wijmo-wijdatepager-pagelabel")[this._startInd],c,a;if(!b)return;c=b.offsetLeft+Math.round(b.offsetWidth/2)+(d.pageX-this._startClientX);a=this._findClosesPageIndexByPos(c);if(this._prevMoveInd===a)return;this._prevMoveInd=a;if(this._mouseDownTimeFix20555+150>+new Date)return;a!==-1&&a!==this._index&&this._setSelectedIndex(a)},_pageindicatorMouseUp:function(){this._dragActivated=false;a(document).unbind("."+this._dtpagernamespacekey);this._hideTooltip()},_findClosesPageIndexByPos:function(c){for(var b=this.element.find(".wijmo-wijdatepager-pages").find(".wijmo-wijdatepager-pagelabel"),a=0;a<b.length;a+=1)if(b[a].offsetLeft<c&&b[a].offsetLeft+b[a].offsetWidth>c)return a;return-1}})})(jQuery);
(function(a){"use strict";function b(a){return new Date(a.getFullYear(),a.getMonth(),a.getDate())}function h(){var b,c,a;b="";for(a=0;a<32;a+=1){if(a===8||a===12||a===16||a===20)b=b+"-";c=Math.floor(Math.random()*16).toString(16).toUpperCase();b=b+c}return b}var e,i="C1EventsCalendarDB",j="1.1",f=false,c;function g(b,d,a){if(f){c=amplify.store("wijevcal_tables1");if(!c)c={};if(!c[b]){c[b]={fields:d};amplify.store("wijevcal_tables1",c);amplify.store("wijevcal_tbl_"+b,{})}a&&a()}else e&&e.transaction(function(c){c.executeSql("SELECT COUNT(*) FROM "+b,[],function(){a&&a()},function(c){c.executeSql("CREATE TABLE "+b+" "+d,[],a,a)})})}function d(j,m,o,l){var n={rowsAffected:0,rows:[]},k,a,p,s,r,b,i,t,d,u,q,v,g,h;if(!m)m=[];if(!n.rows.item)n.rows.item=function(a){return this[a]};if(f)try{p=new RegExp("(SELECT) *(.*) *FROM (\\w+)");s=new RegExp("(INSERT OR REPLACE|INSERT) *(.*) *INTO *(\\w*) *\\(([\\w|,| ]*)\\)");r=new RegExp("(DELETE) *(.*) *FROM (\\w+) *(\\w*)WHERE (\\w+)='*([^']+)");if(j.match(s)){b=s.exec(j);if(b&&b.length>1){i=b[3];t=c[i];d=amplify.store("wijevcal_tbl_"+i);if(d){q=b[4].split(",");k={};for(a=0;a<q.length;a+=1)if(q[a]){if(a===0)d[m[a]]=k;v=q[a].replace(" ","");k[v]=m[a]}}amplify.store("wijevcal_tbl_"+i,d)}}else if(j.match(p)){b=p.exec(j);if(b&&b.length>1){i=b[3];t=c[i];d=amplify.store("wijevcal_tbl_"+i);if(d){g=j.replace(p,"");if(g.toUpperCase().indexOf(" WHERE ")===0){g=g.substr(7);h=g.split(" OR ");for(a=0;a<h.length;a+=1){h[a]=h[a].split("=");g=h[a][1];if(g.indexOf("'")===0){g=g.substring(1,g.length-1);h[a][1]=g}else h[a][1]=parseFloat(g)}}for(u in d)if(d.hasOwnProperty(u)){k=d[u];if(k)if(h)for(a=0;a<h.length;a+=1)k[h[a][0]]===h[a][1]&&n.rows.push(k);else n.rows.push(k)}}}}else if(j.match(r)){b=r.exec(j);if(b&&b.length>1){i=b[3];t=c[i];d=amplify.store("wijevcal_tbl_"+i);if(d)if(d[b[6]])delete d[b[6]];amplify.store("wijevcal_tbl_"+i,d)}}o&&o(n)}catch(w){l&&l(w)}else{if(!e){l("Local data storage not found.");return}e.transaction(function(a){a.executeSql(j,m,function(b,a){o&&o(a)},function(b,a){l&&l(a.message);return})})}}a.widget("wijmo.wijevcal",{options:{culture:"",localization:null,webServiceUrl:"",colors:null,dataStorage:{addEvent:null,updateEvent:null,deleteEvent:null,loadEvents:null,addCalendar:null,updateCalendar:null,deleteCalendar:null,loadCalendars:null},eventsData:[],appointments:[],calendars:[],disabled:false,editCalendarTemplate:"",enableLogs:false,eventTitleFormat:"{2}",titleFormat:{day:false,week:"_formatWeekTitle",month:"_formatMonthTitle",list:false},firstDayOfWeek:0,headerBarVisible:true,navigationBarVisible:true,rightPaneVisible:false,selectedDate:null,selectedDates:null,statusBarVisible:false,timeInterval:30,timeIntervalHeight:15,timeRulerInterval:60,timeRulerFormat:"{0:h tt}",dayHeaderFormat:"{0:d }",firstRowDayHeaderFormat:"{0:ddd d}",dayViewHeaderFormat:{day:"all-day events",week:"{0:d dddd}",list:"{0:d dddd}"},viewType:"day",visibleCalendars:["Default"]},_setOption:function(e,c){var d=this.options;switch(e){case"eventsData":d.eventsData=c;d.appointments=c;this._onEventsDataChanged();break;case"appointments":d.eventsData=c;d.appointments=c;this._onEventsDataChanged();break;case"culture":d.culture=c;this.element.find(".wijmo-wijdatepager").wijdatepager("option","culture",d.culture);this._editEventDialog&&this._editEventDialog.find(".wijmo-wijinput-date").wijinputdate("option","culture",d.culture);this.element.find(".wijmo-wijcalendar").wijcalendar("option","culture",d.culture);this._redrawActiveView();break;case"disabled":if(d.disabled!==c){d.disabled=c;this._ensureDisabled()}break;case"enableLogs":d.enableLogs=c;this._initLogPanel();break;case"selectedDate":if(c){c=b(c);if(d.selectedDates[0].getTime()!==c.getTime()){d.selectedDates[0]=c;this._onSelectedDatesChanged()}}return;case"selectedDates":if(c){d.selectedDates=c;this._onSelectedDatesChanged()}return;case"statusBarVisible":d.statusBarVisible=c;this._initStatusbar();this.invalidate();return;case"headerBarVisible":d.headerBarVisible=c;this._initHeaderbar();this.invalidate();return;case"navigationBarVisible":d.navigationBarVisible=c;this._initNavigationbar();this.invalidate();return;case"rightPaneVisible":d.rightPaneVisible=c;this._initRightPane();this.invalidate();return;case"timeInterval":if(d.timeInterval!==c){d.timeInterval=c;this._redrawActiveView()}break;case"timeIntervalHeight":if(d.timeIntervalHeight!==c){d.timeIntervalHeight=c;this._redrawActiveView()}break;case"timeRulerInterval":if(d.timeRulerInterval!==c){d.timeRulerInterval=c;this._redrawActiveView()}break;case"viewType":if(d.viewType!==c){d.viewType=c;this._onViewTypeChanged()}}a.Widget.prototype._setOption.apply(this,arguments)},_ensureDisabled:function(){var a=this.options;if(a.disabled){this.element.addClass("ui-state-disabled");this.element.find(".ui-button").button("option","disabled",true);this.element.find(".ui-buttonset").buttonset("option","disabled",true);this.element.find(".wijmo-wijcalendar").wijcalendar("option","disabled",true);this.element.find(".wijmo-wijsuperpanel").wijsuperpanel("option","disabled",true);this.element.find(".wijmo-wijdatepager").wijdatepager("option","disabled",true);this._unbindEvents()}else{this.element.removeClass("ui-state-disabled");this.element.find(".ui-button").button("option","disabled",false);this.element.find(".ui-buttonset").buttonset("option","disabled",false);this.element.find(".wijmo-wijcalendar").wijcalendar("option","disabled",false);this.element.find(".wijmo-wijsuperpanel").wijsuperpanel("option","disabled",false);this.element.find(".wijmo-wijdatepager").wijdatepager("option","disabled",false);this._bindEvents();this._updateTitleText()}},_onViewTypeChanged:function(){this._renderActiveView();this._updateTitleText();this._trigger("viewTypeChanged",null,this.options.viewType);this.element.find(".wijmo-wijev-datepager").wijdatepager("option","viewType",this.options.viewType)},_onSelectedDatesChanged:function(){var a=this.options;a.selectedDate=a.selectedDates[0];this.element.find(".wijmo-wijev-datepager").wijdatepager("option","selectedDate",a.selectedDate);this._trigger("selectedDatesChanged",null,{selectedDates:a.selectedDates});this._renderActiveView();this._updateTitleText()},_updateHeaderTitleText:function(){var a=this.options,b=a.titleFormat,c=a.selectedDates[0],d=a.selectedDates[a.selectedDates.length-1];if(b[a.viewType])b=b[a.viewType];else if(b[a.viewType]===false){this.element.find(".wijmo-wijev-view .wijmo-wijev-header-title").hide();return}else b=b.toString();if(a.viewType==="list")d=this._addDays(c,14);this.element.find(".wijmo-wijev-view .wijmo-wijev-header-title").show().html(this._formatString(b,c,d))},_updateTitleText:function(){var b=this.options,d=b.selectedDates[0],e=b.selectedDates[b.selectedDates.length-1],a=new Date,c=false;c=this._compareDayDates(d,a)===0||d<a&&e>a;this.element.find(".wijmo-wijev-navigationbar .wijmo-wijev-today").button("option","disabled",c);this._updateHeaderTitleText()},localizeString:function(b,c){var a=this.options;return a.localization&&a.localization[b]?a.localization[b]:c},_create:function(){if(a.isFunction(window.wijmoApplyWijTouchUtilEvents))a=window.wijmoApplyWijTouchUtilEvents(a);a.isFunction(window.wijmoASPNetParseOptions)&&wijmoASPNetParseOptions(this.options);var d,b,c=this.options;if(!c.colors)c.colors=["red","darkorchid","green","blue","cornflowerblue","yellow","bronze"];if(!this.wijevcalnamespacekey)this.wijevcalnamespacekey="wijevcal"+ +new Date;if(!this.element[0].id)this.element[0].id="wijevcal_dynid_"+ +new Date;this._uidPref=this.element[0].id+"evcdynid";this.element.addClass("wijmo-wijevcal wijmo-wijev ui-widget ui-helper-reset ui-state-default");a('<div class="wijmo-wijev-headerbar ui-widget-header ui-corner-top"><span class="wijmo-wijev-tools"><input id="'+this._uidPref+'_daybtn" name="viewselection" type="radio" class="wijmo-wijev-day" /><label for="'+this._uidPref+'_daybtn">'+this.localizeString("buttonDayView","Day")+'</label><input id="'+this._uidPref+'_weekbtn" name="viewselection" type="radio" class="wijmo-wijev-week" /><label for="'+this._uidPref+'_weekbtn">'+this.localizeString("buttonWeekView","Week")+'</label><input id="'+this._uidPref+'_monthbtn" name="viewselection" type="radio" class="wijmo-wijev-month" /><label for="'+this._uidPref+'_monthbtn">'+this.localizeString("buttonMonthView","Month")+'</label><input id="'+this._uidPref+'_listbtn" name="viewselection" type="radio" class="wijmo-wijev-list" /><label for="'+this._uidPref+'_listbtn">'+this.localizeString("buttonListView","List")+"</label></span></div>").appendTo(this.element);a('<div class="wijmo-wijev-view-container"><div class="wijmo-wijev-leftpane wijmo-wijev-viewdetails ui-widget-content wijmo-wijev-day-details"><div class="wijmo-wijev-leftpane-inner"><div class="wijmo-wijev-daycalendar"></div><div class="wijmo-wijev-monthday-container"><div class="wijmo-wijev-monthday-label">...</div><div class="wijmo-wijev-fulldate-label">'+this.localizeString("activityLoading","Loading...")+'</div><div class="wijmo-wijev-year-label">...</div></div><div class="wijmo-wijev-agenda-container ui-widget-content ui-corner-all ui-helper-clearfix"></div></div></div><div class="wijmo-wijev-leftpane wijmo-wijev-viewdetails ui-widget-content wijmo-wijev-list-details"><div class="wijmo-wijev-leftpane-inner"><div class="wijmo-wijev-agenda-container ui-widget-content ui-corner-all ui-helper-clearfix">&nbsp;</div></div></div><div class="wijmo-wijev-rightpane">&nbsp;</div></div>').appendTo(this.element);a('<div class="wijmo-wijev-loading-modal-frame"></div><div class="wijmo-wijev-loading"><div class="wijmo-wijev-loading-text">'+this.localizeString("activityLoading","Loading...")+"</div></div>").appendTo(this.element);a('<div class="wijmo-wijev-navigationbar ui-widget-header ui-corner-bottom ui-helper-clearfix"><a class="wijmo-wijev-today">'+this.localizeString("buttonToday","today")+'</a><div class="wijmo-wijev-datepager"></div></div>').appendTo(this.element);a('<div class="wijmo-wijev-statusbar ui-widget-header ui-corner-bottom"></div>').appendTo(this.element);d=this.element.find(".wijmo-wijev-navigationbar");b=this.element.find(".wijmo-wijev-headerbar .wijmo-wijev-tools");d.find(".wijmo-wijev-today").button({text:this.localizeString("buttonToday","today")}).click(a.proxy(this._onTodayClick,this));this.element.find(".wijmo-wijev-datepager").wijdatepager({selectedDate:c.selectedDate,culture:c.culture,viewType:c.viewType,nextTooltip:this.localizeString("navigatorBarNextTooltip","right"),prevTooltip:this.localizeString("navigatorBarPrevTooltip","left"),firstDayOfWeek:c.firstDayOfWeek,selectedDateChanged:a.proxy(function(b,a){this.goToDate(a.selectedDate)},this)});b.find(".wijmo-wijev-day").button().click(a.proxy(this._onDayViewClick,this));b.find(".wijmo-wijev-week").button().click(a.proxy(this._onWeekViewClick,this));b.find(".wijmo-wijev-month").button().click(a.proxy(this._onMonthViewClick,this));b.find(".wijmo-wijev-list").button().click(a.proxy(this._onListViewClick,this));b.buttonset();this.showLoadingLabel()},showLoadingLabel:function(a,b){if(a===false)this.element.find(".wijmo-wijev-loading-text").hide();else{this.element.find(".wijmo-wijev-loading-text").show();if(!a)a=this.localizeString("activityLoading","Loading...")}(b===undefined||b===true)&&this.element.find(".wijmo-wijev-loading-modal-frame").show();this.element.find(".wijmo-wijev-loading").show();this.element.find(".wijmo-wijev-loading-text").html(a)},hideLoadingLabel:function(){this.element.find(".wijmo-wijev-loading-modal-frame").hide();this.element.find(".wijmo-wijev-loading").hide()},_init:function(){var c=this.options;if(c.selectedDates&&c.selectedDates.length>0)c.selectedDate=c.selectedDates[0]=b(c.selectedDates[0]);else if(c.selectedDate){c.selectedDate=b(c.selectedDate);if(!c.selectedDates)c.selectedDates=[];c.selectedDates[0]=c.selectedDate}else{c.selectedDate=b(new Date);c.selectedDates=[c.selectedDate]}c.disabled&&this.element.addClass("ui-state-disabled");this._initHeaderbar();this._initNavigationbar();this._initStatusbar();this._initRightPane();c.fullScreen&&this._onFullScreenModeChanged(c.fullScreen);this._initLogPanel();this._initLocalDataStorage();this.element.ajaxError(jQuery.proxy(this._onAjaxError,this));a(window).resize(a.proxy(this._onWindowResize,this));this._renderActiveView();this._ensureDisabled()},_initLocalDataStorage:function(){try{if(window.amplify&&window.amplify.store)try{c=amplify.store("wijevcal_tables1");f=true;this.log("Using amplify.store for the local data storage")}catch(b){this.log("amplify.store exception:"+b);this._loadData();return}else if(window.openDatabase){try{e=window.openDatabase(i,j,"Wijmo Events Calendar Offline DB",2e5)}catch(h){this.log("web sql database error: "+h);this._loadData();return}if(!e){this.log("Failed to open the database on disk. This is probably because the version was bad or there is not enough space left in this domain's quota");this._loadData();return}this.log("Using Web SQL Database for the local data storage.")}else{this.log("Couldn't open built-in local data storage. Please, add amplify.store references.");this._loadData();return}g("calendars","(id TEXT PRIMARY KEY, name TEXT, location TEXT, description TEXT, color TEXT, tag TEXT)");g("events","(id TEXT PRIMARY KEY, calendar TEXT, subject TEXT, location TEXT, start TIMESTAMP, end TIMESTAMP, description TEXT, color TEXT, allday INTEGER, properties TEXT, tag TEXT)",a.proxy(this._loadData,this))}catch(d){this.log("local datastorage initialization error:"+d)}},_initStatusbar:function(){var a=this.element.find(".wijmo-wijev-statusbar");if(!this.options.statusBarVisible){a.hide();return}else a.show();if(this.statusbarEventsAdded)return true;this.statusbarEventsAdded=true},_initHeaderbar:function(){var a=this.element.find(".wijmo-wijev-headerbar");if(!this.options.headerBarVisible){a.hide();return}else a.show()},_initNavigationbar:function(){var a=this.element.find(".wijmo-wijev-navigationbar");if(!this.options.navigationBarVisible){a.hide();return}else a.show()},_initRightPane:function(){var a=this.element.find(".wijmo-wijev-rightpane");if(!this.options.rightPaneVisible){a.hide();return}else a.show()},_initLogPanel:function(){if(this.options.enableLogs){this._createLogPanel();this.log=this._log}else{this.logDialog&&this.logDialog.wijdialog("close");this.log=function(){}}},_handleServerError:function(a){if(a&&a.toString().indexOf("error:")===0){this.status(a.toString(),"error");return true}return false},_loadData:function(){var e=this.options,b=this,c,h,f,j,m,n,i,k,l,g;this.showLoadingLabel();g=function(){b.hideLoadingLabel()};e.calendars=[];m=this._calendarsById={};k=function(a){if(!a)return;if(typeof a==="string"){if(b._handleServerError(a)){g(a);return}try{a=b._jsonParse(a)}catch(d){b.status("Unable to parse received calendars data. "+d,"error");return}}if(a.calendars&&a.calendars.length)a=a.calendars;for(c=0;c<a.length;c+=1){f=b._cloneObj(a[c]);f.prevData=b._cloneObj(f);e.calendars.push(f);m[f.id]=f}b._onCalendarsChanged()};if(e.dataStorage.loadCalendars)e.dataStorage.loadCalendars(k,g);else if(e.webServiceUrl)a.getJSON(e.webServiceUrl+"?clientId="+this.element[0].id+"&command=loadCalendars&calendars="+e.calendars,k);else d("SELECT * FROM calendars",[],function(a){for(c=0,h=a.rows.length;c<h;c+=1){f=b._cloneObj(a.rows.item(c));f.prevData=b._cloneObj(f);e.calendars.push(f);m[f.id]=f}b._onCalendarsChanged()},g);e.eventsData=[];n=this._eventsDataById={};l=function(a){if(!a)return;if(typeof a==="string"){if(b._handleServerError(a)){g(a);return}try{a=b._jsonParse(a)}catch(d){b.log("Unable to parse received calendars data. "+d);return}}if(a.events&&a.events.length)a=a.events;for(c=0;c<a.length;c+=1){j=b._readEventData(a[c]);b._storeEventWithSort(j)}b._onEventsDataChanged();b._trigger("initialized");b.hideLoadingLabel()};if(e.dataStorage.loadEvents)e.dataStorage.loadEvents(e.visibleCalendars,l,g);else if(e.webServiceUrl)a.ajax({url:e.webServiceUrl+"?clientId="+this.element[0].id+"&command=loadEvents&timestamp="+ +new Date,dataType:"text",contentType:"application/json; charset=utf-8",type:"POST",data:"jsonData="+this._jsonStringify({visibleCalendars:e.visibleCalendars}),success:l,error:g});else{i="SELECT * FROM events where ";for(c=0;c<e.visibleCalendars.length;c+=1){if(c>0)i+=" OR ";i+="calendar='"+e.visibleCalendars[c]+"'"}d(i,[],function(a){for(c=0,h=a.rows.length;c<h;c+=1){j=b._readEventData(a.rows.item(c));b._storeEventWithSort(j)}b._onEventsDataChanged();b._trigger("initialized");b.hideLoadingLabel()},g)}},_readEventData:function(b){var a=this._cloneObj(b);a.start=new Date(a.start);a.end=new Date(a.end);if(typeof a.allday==="string"){if(a.allday==="false")a.allday=false;if(a.allday==="true")a.allday=true}if(a.start.getTime()>=a.end.getTime())a.end=this._addMinutes(a.start,this.options.timeInterval);this._deSerializeProperties(a.properties,a);a.prevData=this._cloneObj(a);return a},_prepareEventsForView:function(){this._eventsView=this.getOccurrences()},_cloneObj:function(b){var c={},a;for(a in b)if(b.hasOwnProperty(a))c[a]=b[a];return c},_onDayViewClick:function(){var a=this.options;if(a.viewType!=="day"){a.viewType="day";this._onViewTypeChanged()}a.selectedDates=[a.selectedDate];this._onSelectedDatesChanged()},_onWeekViewClick:function(){var b=this.options,c,d,a;if(b.viewType!=="week"){b.viewType="week";this._onViewTypeChanged()}c=b.selectedDate;a=b.firstDayOfWeek-c.getDay();if(Math.abs(a)>6)a=c.getDay()-b.firstDayOfWeek;c=this._addDays(c,a);b.selectedDates=[];for(a=0;a<7;a+=1){d=this._addDays(c,a);b.selectedDates.push(d)}this._onSelectedDatesChanged()},_onMonthViewClick:function(){var a=this.options;if(a.viewType!=="month"){a.viewType="month";this._onViewTypeChanged()}},_onListViewClick:function(){var a=this.options;if(a.viewType!=="list"){a.viewType="list";this._onViewTypeChanged()}a.selectedDates=[a.selectedDate];this._onSelectedDatesChanged()},_ensureEditCalendarDialogCreated:function(){var d=this.options,b,c={};if(!this._editCalendarDialog){b=d.editCalendarTemplate;if(!b)b="<p><label>"+this.localizeString("labelCalendarName","Calendar name")+'</label><input type="text" class="wijmo-wijev-name" value=""></p><p><label>'+this.localizeString("labelLocation","Location")+'</label><input type="text" class="wijmo-wijev-location" value=""></p><p><label>'+this.localizeString("labelDescription","Description")+'</label><textarea class="wijmo-wijev-description" /></p><p><label>'+this.localizeString("labelColor","Color")+'</label><select class="wijmo-wijev-color"></p>';this._editCalendarDialog=a('<div class="wijmo-wijev-editcalendar-dialog">'+b+"</div>");this.element.append(this._editCalendarDialog);c[this.localizeString("buttonSave","Save")]=a.proxy(function(){var b=this._editCalendarDialog,a=b.cal||{};a.name=b.find(".wijmo-wijev-name").val();a.location=b.find(".wijmo-wijev-location").val();a.description=b.find(".wijmo-wijev-description").val();a.color=b.find(".wijmo-wijev-color").val();if(a.prevData)this.updateCalendar(a);else this.addCalendar(a);b.wijdialog("close")},this);this._editCalendarDialog.wijdialog({autoOpen:true,height:600,width:700,modal:true,title:this.localizeString("titleEditCalendar","Edit calendar"),buttons:c,captionButtons:{pin:{visible:false},refresh:{visible:false},toggle:{visible:false},minimize:{visible:false},maximize:{visible:false}}})}},_ensureEditEventDialogCreated:function(){if(!this._editEventDialog){var b=this.options.editEventDialogTemplate;if(!b)b='<div class="wijmo-wijev-event-dialog ui-widget-content ui-corner-all"><ul class="wijmo-wijev-brief-content"><li><label>'+this.localizeString("labelName","name")+'</label><input type="text" name="subject" class="wijmo-wijev-subject" value=""><div class="wijmo-wijev-color-button"><div class="wijmo-wijev-color ui-wijmo-wijev-event-color-default">&nbsp;</div></div></li><li><label for="'+this._uidPref+'_alldaybtn">'+this.localizeString("labelAllDay","all-day")+'</label><input type="checkbox" class="wijmo-wijev-allday" id="'+this._uidPref+'_alldaybtn" /></li><li><label>'+this.localizeString("labelStarts","Starts")+'</label><input type="text" class="wijmo-wijev-start" value=""><input type="text" class="wijmo-wijev-start-time" value=""></li><li><label>'+this.localizeString("labelEnds","Ends")+'</label><input type="text" class="wijmo-wijev-end" value=""><input type="text" class="wijmo-wijev-end-time" value=""></li></ul><ul class="wijmo-wijev-detailed-content ui-corner-all"><li><label>'+this.localizeString("labelLocation","Location")+'</label><input type="text" class="wijmo-wijev-location" value=""></li><li><label>'+this.localizeString("labelRepeat","Repeat")+'</label><select class="wijmo-wijev-repeat"><option value="none">'+this.localizeString("repeatNone","None")+'</option><option value="daily">'+this.localizeString("repeatDaily","Every Day")+'</option><option value="workdays">'+this.localizeString("repeatWorkDays","Work days")+'</option><option value="weekly">'+this.localizeString("repeatWeekly","Every Week")+'</option><option value="monthly">'+this.localizeString("repeatMonthly","Every Month")+'</option><option value="yearly">'+this.localizeString("repeatYearly","Every Year")+"</option></select></li><li><label>"+this.localizeString("labelCalendar","Calendar")+'</label><select class="wijmo-wijev-calendar"></select></li><li class="wijmo-wijev-description-item"><label>'+this.localizeString("labelDescription","Description")+'</label><textarea class="wijmo-wijev-description" /></li></ul><div class="footer"><a href="#" class="wijmo-wijev-delete">'+this.localizeString("buttonDelete","Delete")+'</a><a href="#" class="wijmo-wijev-save">'+this.localizeString("buttonOK","OK")+'</a><a href="#" class="wijmo-wijev-cancel">'+this.localizeString("buttonCancel","Cancel")+'</a></div><div class="wijmo-wijev-angle"></div></div>';this._editEventDialog=a(b);this.element.append(this._editEventDialog);this._editEventDialog.find(".wijmo-wijev-color-button").button({icons:{primary:"ui-icon-triangle-1-s"}}).click(a.proxy(this._onColorButtonClick,this));this._editEventDialog.find(".wijmo-wijev-delete").button().click(a.proxy(function(){this.deleteEvent(this._editEventDialog.appt);this._editEventDialog.wijpopup("hide")},this));this._editEventDialog.find(".wijmo-wijev-cancel").button().click(a.proxy(function(){this._editEventDialog.wijpopup("hide")},this));this._editEventDialog.find(".wijmo-wijev-start").width(114).wijinputdate({culture:this.options.culture,titleFormat:this.localizeString("calendarTitleFormat","MMMM yyyy"),toolTipFormat:this.localizeString("calendarToolTipFormat","dddd, MMMM dd, yyyy"),nextTooltip:this.localizeString("calendarNextTooltip","Next"),prevTooltip:this.localizeString("calendarPrevTooltip","Previous"),showTrigger:true,dateFormat:"d",dateChanged:a.proxy(function(c,a){var b=this._editEventDialog.find(".wijmo-wijev-end").wijinputdate("option","date");a.date>b&&this._editEventDialog.find(".wijmo-wijev-end").wijinputdate("option","date",a.date)},this)});this._editEventDialog.find(".wijmo-wijev-start-time").width(80).wijinputdate({culture:this.options.culture,titleFormat:this.localizeString("calendarTitleFormat","MMMM yyyy"),toolTipFormat:this.localizeString("calendarToolTipFormat","dddd, MMMM dd, yyyy"),nextTooltip:this.localizeString("calendarNextTooltip","Next"),prevTooltip:this.localizeString("calendarPrevTooltip","Previous"),dateFormat:"t",dateChanged:a.proxy(function(d,a){var c=this._editEventDialog.find(".wijmo-wijev-end-time").wijinputdate("option","date"),b=this._editEventDialog.find(".wijmo-wijev-start").wijinputdate("option","date");if(a.date.getDate()!==b.getDate()){a.date.setDate(b.getDate());this._editEventDialog.find(".wijmo-wijev-start-time").wijinputdate("option","date",a.date)}a.date>c&&this._editEventDialog.find(".wijmo-wijev-end-time").wijinputdate("option","date",a.date)},this)});this._editEventDialog.find(".wijmo-wijev-end").width(114).wijinputdate({culture:this.options.culture,titleFormat:this.localizeString("calendarTitleFormat","MMMM yyyy"),toolTipFormat:this.localizeString("calendarToolTipFormat","dddd, MMMM dd, yyyy"),nextTooltip:this.localizeString("calendarNextTooltip","Next"),prevTooltip:this.localizeString("calendarPrevTooltip","Previous"),showTrigger:true,dateFormat:"d",dateChanged:a.proxy(function(c,a){var b=this._editEventDialog.find(".wijmo-wijev-start").wijinputdate("option","date");a.date<b&&this._editEventDialog.find(".wijmo-wijev-start").wijinputdate("option","date",a.date)},this)});this._editEventDialog.find(".wijmo-wijev-end-time").width(80).wijinputdate({culture:this.options.culture,titleFormat:this.localizeString("calendarTitleFormat","MMMM yyyy"),toolTipFormat:this.localizeString("calendarToolTipFormat","dddd, MMMM dd, yyyy"),nextTooltip:this.localizeString("calendarNextTooltip","Next"),prevTooltip:this.localizeString("calendarPrevTooltip","Previous"),dateFormat:"t"});this._editEventDialog.find(".wijmo-wijev-allday").wijcheckbox().change(a.proxy(this._eventDialogEnsureTimePartState,this));this._editEventDialog.find(".wijmo-wijev-subject,.wijmo-wijev-location,.wijmo-wijev-description").wijtextbox();this._editEventDialog.find(".wijmo-wijev-save").button().click(a.proxy(function(){var a=this._editEventDialog.appt;try{this._validateAndReadApptDialogFields(this._editEventDialog,a);if(a.prevData)this.updateEvent(a);else this.addEvent(a);this._editEventDialog.wijpopup("hide")}catch(b){alert(b)}},this));this._editEventDialog.wijpopup({autoHide:true,hiding:a.proxy(function(){this._colorMenu&&this._colorMenu.wijpopup("hide");this.element.find(".wijmo-wijev-dayview .ui-selected").removeClass("ui-selected")},this),shown:a.proxy(function(){var a=this;if(!this._dropDownInitialized){this._editEventDialog.find(".wijmo-wijev-calendar").wijdropdown().bind("change",function(){var b=a._calendarsById[this.value];if(b&&b.color)a._addColorClass(a._editEventDialog.find(".wijmo-wijev-color"),b.color);else a._editEventDialog.appt&&a._editEventDialog.appt.color&&a._addColorClass(a._editEventDialog.find(".wijmo-wijev-color"),a._editEventDialog.appt.color)});this._editEventDialog.find(".wijmo-wijev-repeat").wijdropdown().bind("change",function(){var c=this.value,b=a._editEventDialog.appt;switch(c){case"none":b.recurrenceState=null;b.recurrencePattern=null;break;case"daily":b.recurrenceState="master";b.recurrencePattern={parentRecurrenceId:b.id,recurrenceType:"daily"};break;case"workdays":b.recurrenceState="master";b.recurrencePattern={parentRecurrenceId:b.id,recurrenceType:"workdays"};break;case"weekly":b.recurrenceState="master";b.recurrencePattern={parentRecurrenceId:b.id,recurrenceType:"weekly"};break;case"monthly":b.recurrenceState="master";b.recurrencePattern={parentRecurrenceId:b.id,recurrenceType:"monthly"};break;case"yearly":b.recurrenceState="master";b.recurrencePattern={parentRecurrenceId:b.id,recurrenceType:"yearly"};break;case"custom":alert("show custom recurrence pattern.")}});this._dropDownInitialized=true}else{this._editEventDialog.find(".wijmo-wijev-calendar").wijdropdown("refresh");this._editEventDialog.find(".wijmo-wijev-repeat").wijdropdown("refresh")}this._editEventDialog.find(".wijmo-wijev-subject").focus();this._updateEditEventPopupCallout()},this)})}},_updateEditEventPopupCallout:function(){if(this._editEventDialog&&this._editEventDialog._arrowTarget){var b=this._editEventDialog,f=a(b._arrowTarget),c=f.offset(),e=b.offset(),d;if(c.left<e.left)b.removeClass("wijmo-wijev-rightangle").addClass("wijmo-wijev-leftangle");else b.removeClass("wijmo-wijev-leftangle").addClass("wijmo-wijev-rightangle");d=Math.round(c.top-e.top+f.outerHeight(true)/2);this._editEventDialog.find(".wijmo-wijev-angle").css("top",d)}},_onColorButtonClick:function(){var c,e=this.options,b=e.colors,d="";if(b&&b.length>0)for(c=0;c<b.length;c+=1)d+='<span class="wijmo-wijev-listcolor wijmo-wijev-event-color-'+b[c]+'">&nbsp;</span>';if(!this._colorMenu){this._colorMenu=a('<div class="wijmo-wijev-color-menu ui-widget-content ui-corner-all"></div>');this._editEventDialog.append(this._colorMenu);this._colorMenu.wijpopup({autoHide:true})}this._colorMenu.html(d);this._colorMenu.find(".wijmo-wijev-listcolor").click(a.proxy(function(b){this._addColorClass(this._editEventDialog.find(".wijmo-wijev-color"),this._readColorFromClass(a(b.target),"default"));this._colorMenu.wijpopup("hide")},this));this._colorMenu.wijpopup("show",{of:this._editEventDialog.find(".wijmo-wijev-color-button"),my:"left top",at:"left bottom"})},_validateAndReadApptDialogFields:function(c,a){var g,h,e,f,d;g=b(c.find(".wijmo-wijev-start").wijinputdate("option","date"));h=b(c.find(".wijmo-wijev-end").wijinputdate("option","date"));e=c.find(".wijmo-wijev-start-time").wijinputdate("option","date");f=c.find(".wijmo-wijev-end-time").wijinputdate("option","date");if(g.getTime()===h.getTime()&&e.getTime()>f.getTime())throw"The end date you entered occurs before the start date.";a.subject=c.find(".wijmo-wijev-subject").val();a.location=c.find(".wijmo-wijev-location").val();a.start=g;a.end=h;if(c.find(".wijmo-wijev-allday").length>0)a.allday=c.find(".wijmo-wijev-allday")[0].checked;if(!a.allday){a.start=new Date(a.start.getFullYear(),a.start.getMonth(),a.start.getDate(),e.getHours(),e.getMinutes(),e.getSeconds());a.end=new Date(a.end.getFullYear(),a.end.getMonth(),a.end.getDate(),f.getHours(),f.getMinutes(),f.getSeconds())}else if(a.start.getTime()>=a.end.getTime())a.end=this._addMinutes(a.start,this.options.timeInterval);a.calendar=c.find(".wijmo-wijev-calendar").val();a.description=c.find(".wijmo-wijev-description").val();a.color=this._readColorFromClass(c.find(".wijmo-wijev-color"),a.color);d=a.recurrencePattern;if(d&&a.recurrenceState==="master"){d.startTime=a.start;d.endTime=a.end;d.patternStartDate=a.start}},_bindApptToDialog:function(b){if(!b)return;var a=this._editEventDialog,d,c;a.appt=b;a.find(".wijmo-wijev-subject").val(b.subject||"");a.find(".wijmo-wijev-location").val(b.location||"");try{a.find(".wijmo-wijev-start").wijinputdate("option","date",b.start);a.find(".wijmo-wijev-start-time").wijinputdate("option","date",b.start);a.find(".wijmo-wijev-end").wijinputdate("option","date",b.end);a.find(".wijmo-wijev-end-time").wijinputdate("option","date",b.end)}catch(e){alert("[e0001a] wijinputdate/wijtextselection firefox error\n"+e)}if(a.find(".wijmo-wijev-allday").length>0)a.find(".wijmo-wijev-allday")[0].checked=b.allday;a.find(".wijmo-wijev-allday").wijcheckbox("refresh");this._fillCalendarsSelect(a.find(".wijmo-wijev-calendar"),b.calendar);this._loadRepeatValue(b,a.find(".wijmo-wijev-repeat"));if(b.recurrenceState==="exception")a.find(".wijmo-wijev-repeat").wijdropdown("option","disabled",true);else a.find(".wijmo-wijev-repeat").wijdropdown("option","disabled",false);a.find(".wijmo-wijev-description").val(b.description||"");if(!b.prevData)a.find(".wijmo-wijev-delete").hide();else a.find(".wijmo-wijev-delete").show();if(a.find(".wijmo-wijev-calendar").length>0)d=this._calendarsById[a.find(".wijmo-wijev-calendar")[0].value];c=b.color;if(!c&&d&&d.color)c=d.color;this._addColorClass(a.find(".wijmo-wijev-color"),c);this._eventDialogEnsureTimePartState()},_eventDialogEnsureTimePartState:function(){var a=this._editEventDialog;if(a.find(".wijmo-wijev-allday").length>0)if(a.find(".wijmo-wijev-allday")[0].checked){a.find(".wijmo-wijev-start-time").wijinputdate("option","disabled",true);a.find(".wijmo-wijev-end-time").wijinputdate("option","disabled",true)}else{a.find(".wijmo-wijev-start-time").wijinputdate("option","disabled",false);a.find(".wijmo-wijev-end-time").wijinputdate("option","disabled",false)}},_loadRepeatValue:function(b,c){var a="none";if(b.recurrencePattern)switch(b.recurrencePattern.recurrenceType){case"daily":a="daily";break;case"workdays":a="workdays";break;case"weekly":a="weekly";break;case"monthly":a="monthly";break;case"yearly":a="yearly";break;default:a="custom"}c.val(a)},_addColorClass:function(a,d){var b,c=new RegExp("wijmo-wijev-event-color-(\\w+)\\s*");if(a.length>0){b=a[0].className;a[0].className=b.replace(c,"");a.addClass("wijmo-wijev-event-color-"+(d||"default"))}},_readColorFromClass:function(b,c){var d=new RegExp("wijmo-wijev-event-color-(\\w+)\\s*"),a;if(b.length>0){a=d.exec(b[0].className);if(a&&a.length>1)return a[1]}return c},_fillCalendarsSelect:function(f,i){var h="",g=this.options,a,d,e,b=g.calendars.slice(0),c=g.visibleCalendars;if(c&&c.length>0)for(a=0;a<c.length;a+=1){e=false;for(d=0;d<b.length;d+=1)if(b[d].name===c[a])e=true;!e&&b.push({id:c[a],name:c[a]})}if(b.length===0){f.html("");return}for(a=0;a<b.length;a+=1)h+='<option value="'+b[a].id+'">'+b[a].name+"</option>";f.html(h).val(i)},_fillColorSelect:function(e,d){var c="",f=this.options,b=f.colors,a;if(b)for(a=0;a<b.length;a+=1)c+="<option"+(d===b[a]?' selected="selected"':"")+' value="'+b[a]+'">'+b[a]+"</option>";e.html(c)},_bindCalendarToDialog:function(a){if(!a)return;this._editCalendarDialog.cal=a;this._editCalendarDialog.find(".wijmo-wijev-name").val(a.name||"");this._editCalendarDialog.find(".wijmo-wijev-location").val(a.location||"");this._editCalendarDialog.find(".wijmo-wijev-description").val(a.description||"");this._fillColorSelect(this._editCalendarDialog.find(".wijmo-wijev-color"),a.color)},_onTodayClick:function(){this.goToday();return false},_bindEvents:function(){if(!this._eventsAttached){a(this.element).find(".wijmo-wijev-appointment").live("click."+this.wijevcalnamespacekey,a.proxy(this._onAppointmentClick,this));a(this.element).find(".wijmo-wijev-dayview .wijmo-wijev-appointment").live("mousedown."+this.wijevcalnamespacekey,a.proxy(this._onDayViewAppointmentMouseDown,this));a(this.element).find(".wijmo-wijev-monthview .wijmo-wijev-appointment").live("mousedown."+this.wijevcalnamespacekey,a.proxy(this._onMonthViewAppointmentMouseDown,this));a(this.element).find(".wijmo-wijev-dayview .wijmo-wijev-timeinterval").live("click."+this.wijevcalnamespacekey,a.proxy(this._onDayViewTimeIntervalClick,this));a(this.element).find(".wijmo-wijev-dayview .wijmo-wijev-allday-cell").live("click."+this.wijevcalnamespacekey,a.proxy(this._onDayViewAllDayCellClick,this));a(this.element).find(".wijmo-wijev-monthview .wijmo-wijev-monthcellheader").live("click."+this.wijevcalnamespacekey,a.proxy(this._onMonthViewDayLabelClick,this));a(this.element).find(".wijmo-wijev-monthview .wijmo-wijev-monthcell-showmore").live("click."+this.wijevcalnamespacekey,a.proxy(this._onMonthViewDayLabelClick,this));a(this.element).find(".wijmo-wijev-weekview .wijmo-wijev-daylabel").live("click."+this.wijevcalnamespacekey,a.proxy(this._onMonthViewDayLabelClick,this));a(this.element).find(".wijmo-wijev-monthview .wijmo-wijev-monthcell").live("click."+this.wijevcalnamespacekey,a.proxy(this._onMonthViewCellClick,this));this._eventsAttached=true}},_unbindEvents:function(){if(this._eventsAttached){a(this.element).find(".wijmo-wijev-appointment").die("click."+this.wijevcalnamespacekey);a(this.element).find(".wijmo-wijev-dayview .wijmo-wijev-daycolumn .wijmo-wijev-appointment").die("mousedown."+this.wijevcalnamespacekey);a(this.element).find(".wijmo-wijev-dayview .wijmo-wijev-dayheadercolumn .wijmo-wijev-daylabel").die("click."+this.wijevcalnamespacekey);a(this.element).find(".wijmo-wijev-dayview .wijmo-wijev-timeinterval").die("click."+this.wijevcalnamespacekey);a(this.element).find(".wijmo-wijev-dayview .wijmo-wijev-allday-cell").die("click."+this.wijevcalnamespacekey);a(this.element).find(".wijmo-wijev-monthview .wijmo-wijev-monthcellheader").die("click."+this.wijevcalnamespacekey);a(this.element).find(".wijmo-wijev-monthview .wijmo-wijev-monthcell-showmore").die("click."+this.wijevcalnamespacekey);a(this.element).find(".wijmo-wijev-weekview .wijmo-wijev-daylabel").die("click."+this.wijevcalnamespacekey);a(this.element).find(".wijmo-wijev-monthview .wijmo-wijev-monthcell").die("click."+this.wijevcalnamespacekey);this._eventsAttached=false}},destroy:function(){this.element.removeClass("wijmo-wijev wijmo-wijevcal ui-widget ui-helper-reset");this._unbindEvents();a.Widget.prototype.destroy.apply(this,arguments)},deleteCalendar:function(b,j,k){for(var h=this.options.calendars,i=b.name||b,l=false,g,c,m,e=this,f=0;f<h.length;f+=1)if(h[f].name===i){l=true;b=h[f];if(!this._trigger("beforeDeleteCalendar",null,{data:b}))return false;delete this._calendarsById[b.id];h.splice(f,1);break}if(!l){this.status("Calendar with name '"+i+"' not found.");return false}this.showLoadingLabel(this.localizeString("activityDeletingCalendar","Deleting calendar..."));g=function(a){e.status("Calendar '"+b.name+"' deleted.");e._onCalendarsChanged();e.hideLoadingLabel();j&&j(a)};c=function(a){e.status("Unable to delete calendar '"+b.name+"': "+a);e.hideLoadingLabel();k&&k(a)};if(this.options.dataStorage.deleteCalendar)this.options.dataStorage.deleteCalendar(b,g,c);else if(this.options.webServiceUrl){try{m=this._jsonStringify(b)}catch(n){this.status("Unable to prepare calendar data for server. "+n,"error");c("Unable to prepare calendar data for server. "+n);return}a.ajax({url:this.options.webServiceUrl+"?clientId="+this.element[0].id+"&command=deleteCalendar&timestamp="+ +new Date,dataType:"text",contentType:"application/json; charset=utf-8",type:"POST",data:"jsonData="+m,success:g,error:c})}else d("DELETE FROM calendars WHERE name='"+i+"'",[],g,c)},addCalendar:function(b,h,i){var g,f,e,c=this;if(!this._trigger("beforeAddCalendar",null,{data:b,prevData:b.prevData||{}})){if(b.prevData)for(f in b.prevData)if(b.prevData.hasOwnProperty(f))b[f]=b.prevData[f];return false}if(!b.id){if(!this._dynIdCounter)this._dynIdCounter=0;this._dynIdCounter+=1;b.id="dynid"+this._dynIdCounter+"ts"+ +new Date}this.showLoadingLabel(this.localizeString("activityCreatingCalendar","Creating calendar..."));g=function(a){if(c._handleServerError(a)){e(a);return}c._readUpdatedServerDataIfAny(a,b);if(!c._calendarsById[b.id]){c.options.calendars.push(b);c._calendarsById[b.id]=b;c.status("Calendar '"+b.name+"' added.")}else c.status("Calendar '"+b.name+"' added.");b.prevData=c._cloneObj(b);c._onCalendarsChanged();c.hideLoadingLabel();h&&h(a)};e=function(a){c.status("Unable to add calendar '"+b.name+"': "+a);c.hideLoadingLabel();i&&i(a)};if(this.options.dataStorage.addCalendar)this.options.dataStorage.addCalendar(b,g,e);else if(this.options.webServiceUrl){try{f=this._jsonStringify(b)}catch(j){this.status("Unable prepare calendar data for server."+j,"error");e("Unable to prepare calendar data for server."+j);return}a.ajax({url:this.options.webServiceUrl+"?clientId="+this.element[0].id+"&command=addCalendar&timestamp="+ +new Date,dataType:"text",contentType:"application/json; charset=utf-8",type:"POST",data:"jsonData="+f,success:g,error:e})}else d("INSERT OR REPLACE INTO calendars (id, name, location, description, color, tag) VALUES(?,?,?,?,?,?);",[b.id,b.name,b.location,b.description,b.color,b.tag],g,e)},updateCalendar:function(b,h,i){var g,f,e,c=this;if(!this._trigger("beforeUpdateCalendar",null,{data:b,prevData:b.prevData||{}})){if(b.prevData)for(f in b.prevData)if(b.prevData.hasOwnProperty(f))b[f]=b.prevData[f];return false}if(!b.id){if(!this._dynIdCounter)this._dynIdCounter=0;this._dynIdCounter+=1;b.id="dynid"+this._dynIdCounter+"ts"+ +new Date}this.showLoadingLabel(this.localizeString("activityUpdatingCalendar","Updating calendar..."));g=function(a){if(c._handleServerError(a)){e(a);return}c._readUpdatedServerDataIfAny(a,b);if(!c._calendarsById[b.id]){c.options.calendars.push(b);c._calendarsById[b.id]=b;c.status("Calendar '"+b.name+"' added.")}else c.status("Calendar '"+b.name+"' updated.");b.prevData=c._cloneObj(b);c._onCalendarsChanged();c.hideLoadingLabel();h&&h(a)};e=function(a){c.status("Unable to update calendar '"+b.name+"': "+a);c.hideLoadingLabel();i&&i(a)};if(this.options.dataStorage.updateCalendar)this.options.dataStorage.updateCalendar(b,g,e);else if(this.options.webServiceUrl){try{f=this._jsonStringify(b)}catch(j){this.status("Unable prepare calendar data for server. "+j,"error");e("Unable to prepare calendar data for server. "+j);return}a.ajax({url:this.options.webServiceUrl+"?clientId="+this.element[0].id+"&command=updateCalendar&timestamp="+ +new Date,dataType:"text",contentType:"application/json; charset=utf-8",type:"POST",data:"jsonData="+f,success:g,error:e})}else d("INSERT OR REPLACE INTO calendars (id, name, location, description, color, tag) VALUES(?,?,?,?,?,?);",[b.id,b.name,b.location,b.description,b.color,b.tag],g,e)},addEvent:function(b,i,j){var g,f,e,c=this;if(!this._trigger("beforeAddEvent",null,{data:b,prevData:b.prevData||{}})){if(b.prevData)for(e in b.prevData)if(b.prevData.hasOwnProperty(e))b[e]=b.prevData[e];return false}if(!b.id){if(!this._dynIdCounter)this._dynIdCounter=0;this._dynIdCounter+=1;b.id=h()}if(!b.calendar)b.calendar="Default";this.showLoadingLabel(this.localizeString("activityCreatingEvent","Creating event..."));f=function(a){c.hideLoadingLabel();c.status("Unable to add event '"+b.subject+"': "+a,"error");if(b.prevData)for(e in b.prevData)if(b.prevData.hasOwnProperty(e))b[e]=b.prevData[e];j&&j(a)};g=function(a){if(c._handleServerError(a)){f(a);return}c._readUpdatedServerDataIfAny(a,b);if(!c._eventsDataById[b.id]||b.recurrenceState==="exception"){c._storeEventWithSort(b);c.status("Event '"+b.subject+"' added.")}else c.status("Event '"+b.subject+"' added.");b.prevData=c._cloneObj(b);c._onEventsDataChanged();c.hideLoadingLabel();i&&i(a)};if(this.options.dataStorage.addEvent)this.options.dataStorage.addEvent(b,g,f);else if(this.options.webServiceUrl){try{e=this._jsonStringify(b)}catch(k){this.status("Unable prepare event data for server. "+k,"error");f("Unable to prepare event data for server. "+k);return}a.ajax({url:this.options.webServiceUrl+"?clientId="+this.element[0].id+"&command=addEvent&timestamp="+ +new Date,dataType:"text",contentType:"application/json; charset=utf-8",type:"POST",data:"jsonData="+e,success:g,error:f})}else d("INSERT OR REPLACE INTO events (id, calendar, subject, location, start, end, description, color, allday, properties, tag) VALUES(?,?,?,?,?,?,?,?,?,?,?);",[b.id,b.calendar,b.subject,b.location,b.start.getTime(),b.end.getTime(),b.description,b.color,b.allday,this._serializeProperties(b),b.tag],g,f)},_storeEventWithSort:function(b){var c=this.options.eventsData,a,d;this._eventsDataById[b.id]=b;for(a=0,d=c.length;a<d;a+=1)if(c[a].start>b.start){c.splice(a,0,b);return}else if(c[a].start.getTime()===b.start.getTime())if(c[a].subject>b.subject){c.splice(a,0,b);return}c.push(b)},_readUpdatedServerDataIfAny:function(a,d){var b=null,c;if(typeof a==="string"&&a.indexOf("update:")===0){a=a.toString().substr("update:".length);try{b=this._jsonParse(a)}catch(e){this.status("Unable to read updated server data. "+e,"warning")}if(b)for(c in b)if(b[c])d[c]=b[c]}},updateEvent:function(b,h,i){var g,f,e,c=this;if(!this._trigger("beforeUpdateEvent",null,{data:b,prevData:b.prevData||{}})){if(b.prevData)for(e in b.prevData)if(b.prevData.hasOwnProperty(e))b[e]=b.prevData[e];this._updateAppointmentVisual(b);return false}if(!b.calendar)b.calendar="Default";this.showLoadingLabel(this.localizeString("activityUpdatingEvent","Updating event..."));f=function(a){c.hideLoadingLabel();c.status("Unable to update event '"+b.subject+"': "+a,"error");if(b.prevData)for(e in b.prevData)if(b.prevData.hasOwnProperty(e))b[e]=b.prevData[e];c._updateAppointmentVisual(b);i&&i(a)};if(!b.id){f("id is empty");return}if(b.recurrenceState==="exception"||b.recurrenceState==="occurrence"){if(!this._eventsDataById[b.parentRecurrenceId]){f("Unable to find master event for event with id:"+b.id);return}if(b.recurrenceState==="occurrence"){this.log(this._formatString("[updateEvent->addEvent] recurrenceState for event {0} changed to 'exception'.",b.id));b.recurrenceState="exception";return this.addEvent(b,h,i)}}g=function(a){if(c._handleServerError(a)){f(a);return}c._readUpdatedServerDataIfAny(a,b);if(!c._eventsDataById[b.id]){c._storeEventWithSort(b);c.status("Event '"+b.subject+"' added.")}else c.status("Event '"+b.subject+"' updated.");b.prevData=c._cloneObj(b);c._onEventsDataChanged();c.hideLoadingLabel();h&&h(a)};if(this.options.dataStorage.updateEvent)this.options.dataStorage.updateEvent(b,g,f);else if(this.options.webServiceUrl){try{e=this._jsonStringify(b)}catch(j){this.status("Unable prepare event data for server. "+j,"error");f("Unable to prepare event data for server. "+j);return}a.ajax({url:this.options.webServiceUrl+"?clientId="+this.element[0].id+"&command=updateEvent&timestamp="+ +new Date,dataType:"text",contentType:"application/json; charset=utf-8",type:"POST",data:"jsonData="+e,success:g,error:f})}else d("INSERT OR REPLACE INTO events (id, calendar, subject, location, start, end, description, color, allday, properties, tag) VALUES(?,?,?,?,?,?,?,?,?,?,?);",[b.id,b.calendar,b.subject,b.location,b.start.getTime(),b.end.getTime(),b.description,b.color,b.allday,this._serializeProperties(b),b.tag],g,f)},_serializeProperties:function(b){var c="",a={};a.parentRecurrenceId=b.parentRecurrenceId;a.recurrenceState=b.recurrenceState;a.recurrencePattern=b.recurrencePattern;a.color=b.color;a.allday=b.allday;try{c=this._jsonStringify(a)}catch(d){this.status("Unable save additional event properties. "+d,"error")}return c},_deSerializeProperties:function(d,c){var b={},a;if(d){if(typeof d==="string")try{b=this._jsonParse(d)}catch(e){this.status("Unable to load additional event properties. "+e,"error");return}else b=d;if(b.parentRecurrenceId)c.parentRecurrenceId=b.parentRecurrenceId;if(b.recurrenceState)c.recurrenceState=b.recurrenceState;if(b.recurrencePattern)c.recurrencePattern=b.recurrencePattern;if(b.color)c.color=b.color;if(b.allday)c.allday=b.allday}if(c&&c.recurrencePattern){a=c.recurrencePattern;a.patternStartDate=a.patternStartDate?new Date(a.patternStartDate):a.patternStartDate;a.startTime=a.startTime?new Date(a.startTime):a.startTime;a.endTime=a.endTime?new Date(a.endTime):a.endTime;if(a.startTime.getTime()>=a.endTime.getTime())a.endTime=this._addMinutes(a.startTime,this.options.timeInterval)}},_jsonStringify:function(b){var a;if(window.__JSONC1)a=window.__JSONC1.stringify(b);else if(window.JSON)a=JSON.stringify(b);else throw"JSON not found.";return a},_jsonParse:function(d){var a,c,b;if(window.__JSONC1)a=window.__JSONC1.parse(d);else if(window.JSON){c=/^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2}(?:\.\d*)?)Z$/;b=/^\/Date\((d|-|.*)\)\/$/;a=window.JSON.parse(d,function(f,d){if(typeof d==="string"){var a=c.exec(d),e;if(a)return new Date(Date.UTC(+a[1],+a[2]-1,+a[3],+a[4],+a[5],+a[6]));a=b.exec(d);if(a){e=a[1].split(/[-,.]/);return new Date(+e[0])}}return d})}else throw"JSON variable not found.";return a},getOccurrences:function(l,o){var t=this.options,r=t.eventsData,b,a,i,g,d,c,m,n,s=100,j,e,h,p=[],q=[],k=[],f={};for(d=0,m=r.length;d<m;d+=1){b=r[d];this._eventsDataById[b.id]=b;if(b.recurrenceState==="master"){g=b.recurrencePattern;if(g.removedOccurrences)k=k.concat(g.removedOccurrences);n=g.occurrences||s;j=g.patternStartDate||b.start;e=g.startTime||b.start;h=g.endTime||b.end;switch(g.recurrenceType){case"daily":for(c=0;c<n;c+=1){a=this._cloneObj(b);a.parentRecurrenceId=b.id;a.recurrenceState="occurrence";a.start=this._setTime(this._addDays(j,c),e);a.end=this._setTime(a.start,h,e);a.recurrencePattern=null;if(this._testIsEventInTimeInterval(a,l,o)){a.id=this._formatString("{0}_OCCR_{1:yyyy_MM_dd}",b.id,a.start);f[a.id]=a}}break;case"workdays":for(c=0;c<n;c+=1){a=this._cloneObj(b);a.parentRecurrenceId=b.id;a.recurrenceState="occurrence";a.start=this._setTime(this._addDays(j,c),e);if(a.start.getDay()===0||a.start.getDay()===6)continue;a.end=this._setTime(a.start,h,e);a.recurrencePattern=null;if(this._testIsEventInTimeInterval(a,l,o)){a.id=this._formatString("{0}_OCCR_{1:yyyy_MM_dd}",b.id,a.start);f[a.id]=a}}break;case"weekly":for(c=0;c<n;c+=1){a=this._cloneObj(b);a.parentRecurrenceId=b.id;a.recurrenceState="occurrence";a.start=this._setTime(this._addDays(j,c*7),e);a.end=this._setTime(a.start,h,e);a.recurrencePattern=null;if(this._testIsEventInTimeInterval(a,l,o)){a.id=this._formatString("{0}_OCCR_{1:yyyy_MM_dd}",b.id,a.start);f[a.id]=a}}break;case"monthly":for(c=0;c<n;c+=1){a=this._cloneObj(b);a.parentRecurrenceId=b.id;a.recurrenceState="occurrence";a.start=this._setTime(new Date(j),e);a.start.setMonth(a.start.getMonth()+c);a.end=this._setTime(a.start,h,e);a.recurrencePattern=null;if(this._testIsEventInTimeInterval(a,l,o)){a.id=this._formatString("{0}_OCCR_{1:yyyy_MM_dd}",b.id,a.start);f[a.id]=a}}break;case"yearly":for(c=0;c<n;c+=1){a=this._cloneObj(b);a.parentRecurrenceId=b.id;a.recurrenceState="occurrence";a.start=this._setTime(new Date(j),e);a.start.setYear(a.start.getFullYear()+c);a.end=this._setTime(a.start,h,e);a.recurrencePattern=null;if(this._testIsEventInTimeInterval(a,l,o)){a.id=this._formatString("{0}_OCCR_{1:yyyy_MM_dd}",b.id,a.start);f[a.id]=a}}}}else if(this._testIsEventInTimeInterval(b,l,o))if(b.recurrenceState==="exception")q.push(b);else if(b.recurrenceState==="removed"){k.push(b.id);this.log("[warning] Seems we found removed event inside events storage, id:"+b.id)}else p.push(b)}for(d=0,m=q.length;d<m;d+=1){i=q[d];if(f[i.id])delete f[i.id];p.push(i);this._eventsDataById[i.id]=i}for(d=0,m=k.length;d<m;d+=1)if(f[k[d]])delete f[k[d]];for(d in f){a=f[d];p.push(a);this._eventsDataById[a.id]=a}return p},_testIsEventInTimeInterval:function(b,a,c){return!a||!c?true:b.start<c&&b.end>a?true:false},deleteEvent:function(g,k,l){if(g.id)g=g.id;var b=this._eventsDataById[g],h,j,i,e,c=this,m,f;if(!this._trigger("beforeDeleteEvent",null,{data:b}))return false;this.showLoadingLabel(this.localizeString("activityDeletingEvent","Deleting event..."));e=function(a){c.status("Unable to delete event '"+(b?b.subject:"undefined")+"': "+a);c.hideLoadingLabel();l&&l(a)};if(b.recurrenceState==="exception"||b.recurrenceState==="occurrence"){f=this._eventsDataById[b.parentRecurrenceId];if(f){this.log(this._formatString("[deleteEvent] removing {0} with id {1}. Updating master event with id {2}",b.recurrenceState,b.id,f.id));if(!f.recurrencePattern.removedOccurrences)f.recurrencePattern.removedOccurrences=[];f.recurrencePattern.removedOccurrences.push(b.id);this.updateEvent(f,k,l);if(b.recurrenceState==="occurrence"){this.log("No need to delete occurrence from store. Master event should be updated.");return}}else if(b.recurrenceState!=="exception"){e("Unable to find master event with id "+b.parentRecurrenceId);return false}}b.recurrenceState==="master";i=function(a){if(c._handleServerError(a)){e(a);return}if(c._eventsDataById[b.id]){j=c.options.eventsData;for(h=0;h<j.length;h=h+1)j[h].id===g&&j.splice(h,1);delete c._eventsDataById[b.id];c.status("Event '"+b.subject+"' deleted.")}else c.status("Event '"+b.subject+"' deleted.");b.prevData=c._cloneObj(b);c._onEventsDataChanged();c.hideLoadingLabel();k&&k(a)};if(this.options.dataStorage.deleteEvent)this.options.dataStorage.deleteEvent(b,i,e);else if(this.options.webServiceUrl){try{m=this._jsonStringify(b)}catch(n){this.status("Unable prepare event data for server. "+n,"error");e("Unable prepare event data for server. "+n);return}a.ajax({url:this.options.webServiceUrl+"?clientId="+this.element[0].id+"&command=deleteEvent&timestamp="+ +new Date,dataType:"text",contentType:"application/json; charset=utf-8",type:"POST",data:"jsonData="+m,success:i,error:e})}else d("DELETE FROM events WHERE id='"+g+"'",[],i,e)},beginUpdate:function(){this._isUpdating=true;this.showLoadingLabel("Updating...")},endUpdate:function(){this._isUpdating=false;this._pendingRedrawActiveView&&this._redrawActiveView();this.hideLoadingLabel()},goToEvent:function(a){if(a.id)a=a.id;var d=this.options,b,c=this.findEventById(a);switch(d.viewType){case"day":case"week":case"list":b=this.element.find(".wijmo-wijev-dayview .wijmo-wijev-daycolumn ."+this._eventIdToCssClass(a));if(b.length>0)this.element.find(".wijmo-wijev-scrollpanel").wijsuperpanel("scrollChildIntoView",b);else{this._dayViewScrollToEvent=c;this.goToDate(c.start)}break;case"month":this.goToDate(c.start)}},isAllDayEvent:function(b){var a=b;if(!b.id)a=this.findEventById(b);return a.allday?(a.end.getTime()-a.start.getTime())/864e5>=1?true:true:false},goToDate:function(d){d=b(d);var f=this.options,g=d.getDay(),a,e,c=f.selectedDates;if(c&&c.length>0)if(this._isContainsDayDate(c,d))return;else{e=(d-c[0].getTime())/864e5;if(f.viewType==="week")for(a=0;a<c.length;a+=1)if(c[a].getDay()===g){e=e-a;break}for(a=0;a<c.length;a+=1)c[a]=this._addDays(c[a],e);this._onSelectedDatesChanged()}else{f.selectedDates=[d];this._onSelectedDatesChanged()}},goToday:function(){this.goToDate(new Date)},goLeft:function(){var b,c=this.options,d=c.viewType,a=c.selectedDates;if(d==="month")this.goToDate(this._addMonths(a[0],-1));else{b=-7;if(a.length===1)b=-1;this.goToDate(this._addDays(a[0],b))}},goRight:function(){var b,c=this.options,d=c.viewType,a=c.selectedDates;if(d==="month")this.goToDate(this._addMonths(a[0],1));else{b=7;if(a.length===1)b=1;this.goToDate(this._addDays(a[0],b))}},refresh:function(){this.invalidate()},invalidate:function(){var a=this.options;switch(a.viewType.toLowerCase()){case"list":case"day":case"week":this._invalidateDayView();break;case"month":this._invalidateMonthView()}},showEditCalendarDialog:function(a){var d=this.options,c=d.calendars,b;if(!a)a={name:"",description:"",location:"",color:""};else if(!a.name)for(b=0;b<c.length;b+=1)if(c[b].name===a){a=c[b];break}this._ensureEditCalendarDialogCreated();this._bindCalendarToDialog(a);this._editCalendarDialog.wijdialog("open")},showEditEventDialog:function(b,g,e){var f=this.options,h,d,i,c=g?a(g):e?a(e.target):null;this._ensureEditEventDialogCreated();this.element.find(".wijmo-wijev-dayview .ui-selected").removeClass("ui-selected");if(c&&c.hasClass("wijmo-wijev-daylabel"))c=c.parent(".wijmo-wijev-allday-cell");if(!b){b={subject:this.localizeString("textNewEvent","New event")};b.isNewEvent=true;if(c&&c.length>0){this._editEventDialog._arrowTarget=c;c.addClass("ui-selected");d=c.parent(".wijmo-wijev-daycolumn");if(d.length<1)d=c.parent(".wijmo-wijev-dayheadercolumn");d=d[0];if(c.hasClass("wijmo-wijev-allday-cell"))b.allday=true;else if(c.hasClass("wijmo-wijev-monthcellcontainer")){d=c[0];b.allday=true}else b.allday=false;if(d){i=this._parseDateFromClass(d.className,b.allday?null:c[0].className);b.start=i;if(b.allday)b.end=this._addMinutes(b.start,1440);else b.end=this._addMinutes(b.start,f.timeInterval)}}else{b.start=new Date(f.selectedDates[0]);b.end=this._addMinutes(b.start,f.timeInterval)}}else{this._editEventDialog._arrowTarget=c;if(b.recurrenceState==="occurrence"){h=this._eventsDataById[b.parentRecurrenceId];if(!window.confirm(this._formatString(this.localizeString("promptOpenOccurrenceFormat","{2}  is recurring event. Do you want to open only this occurrence?"),b.start,b.end,b.subject,b.location)))b=h}}if(this._trigger("beforeEditEventDialogShow",null,{data:b,targetCell:c})){this._bindApptToDialog(b);this._editEventDialog.wijpopup("show",{of:c,my:"left center",at:"right center",offset:(c&&e?Math.round(e.offsetX-c.width()):10)+" 0",collision:"fit"})}},_renderActiveView:function(){var a=this.options,b=this.element.find(".wijmo-wijev-headerbar .wijmo-wijev-tools");this.element.find(".wijmo-wijev-view").hide();this.element.find(".wijmo-wijev-viewdetails").hide();this.element.find(".wijmo-wijev-"+a.viewType.toLowerCase()+"-details").show();switch(a.viewType.toLowerCase()){case"day":case"week":case"list":this.element.find(".wijmo-wijev-view.wijmo-wijev-dayview").show();this._renderDayView();break;case"month":this.element.find(".wijmo-wijev-view.wijmo-wijev-monthview").show();this._renderMonthView()}b.find(".wijmo-wijev-"+a.viewType.toLowerCase())[0].checked=true;b.buttonset("refresh")},_redrawActiveView:function(){if(this._isUpdating){this._pendingRedrawActiveView=true;return}switch(this.options.viewType.toLowerCase()){case"day":case"week":this._clearDayViewCache();this._templateDayColumn=null}this._renderActiveView()},_getDayColumnDates:function(f){var d=this.options,b=d.selectedDates,c,e,a;if(!b)b=[new Date];if(d.viewType==="week"){c=d.selectedDate||b[0];a=d.firstDayOfWeek-c.getDay();if(Math.abs(a)>6)a=c.getDay()-d.firstDayOfWeek;c=this._addDays(c,a);b=[];for(a=0;a<7;a+=1){e=this._addDays(c,a);b.push(e)}}if(f)d.selectedDates=b;return b},_renderDayView:function(){var e=this.options,h=0,u=1440,n,k,o,t=this._getDayColumnDates(true),f,b,c,d,l=new Date,r,q=false,i=this.element.find(".wijmo-wijev-dayview"),p,j,s,g=0,m;if(i.length===0){i=a('<div class="wijmo-wijev-view wijmo-wijev-dayview ui-widget-content"><h3 class="wijmo-wijev-header-title">title</h3><div class="wijmo-wijev-dayview-inner"><div class="wijmo-wijev-headercontainer"><div class="wijmo-wijev-sizer"><div class="wijmo-wijev-gmtlabel">'+this.localizeString("labelAllDay","all-day")+'</div></div></div><div class="wijmo-wijev-scrollpanel"><div class="wijmo-wijev-scrollcontent"><div class="wijmo-wijev-timeruler"><div class="wijmo-wijev-currenttime-indicator"><div class="wijmo-wijev-currenttime-indicator-arrow ui-state-error"></div><div class="wijmo-wijev-currenttime-indicator-line ui-state-error"></div></div></div></div></div></div></div>');i.appendTo(this.element.find(".wijmo-wijev-view-container"));this.element.find(".wijmo-wijev-scrollpanel").wijsuperpanel({hScroller:{scrollBarVisibility:"hidden"},animationOptions:{disabled:true}})}i.removeClass("wijmo-wijev-weekview wijmo-wijev-listview");i.addClass("wijmo-wijev-"+e.viewType.toLowerCase()+"view");p=this.element.find(".wijmo-wijev-headercontainer");j=this.element.find(".wijmo-wijev-scrollcontent");s=j.find(".wijmo-wijev-timeruler");if(!this._templateDayColumn){s.find(".wijmo-wijev-timerulerinterval").remove();n='<div class="wijmo-wijev-daycolumn">';m=true;while(h<u){k="wijmo-wijev-timeinterval ui-widget-content wijmo-wijev-minute-"+h;if(m)k+=" wijmo-wijev-oddrow";m=!m;o="wijmo-wijev-timerulerinterval ui-widget-content wijmo-wijev-minute-"+h;n+='<div class="'+k+'" style="height: '+e.timeIntervalHeight+'px"></div>';h+=e.timeInterval;g+=e.timeInterval;if(g>=e.timeRulerInterval){k+=" wijmo-wijev-timeinterval-hourstart";o+=" wijmo-wijev-timerulerinterval-hourstart";s.append(a('<div class="'+o+'" style="height:'+g/e.timeInterval*e.timeIntervalHeight+'px">'+this._formatString(e.timeRulerFormat,new Date(l.getFullYear(),l.getMonth(),l.getDate(),0,h-g))+"</div>"));g=0}}n+="</div>";this._templateDayColumn=a(n);this._templateDayHeader=a('<div class="wijmo-wijev-dayheadercolumn ui-widget-content"><div class="wijmo-wijev-allday-cell ui-widget-content"><div class="wijmo-wijev-daylabel">3 Monday</div></div></div>')}p.find(".wijmo-wijev-dayheadercolumn").remove();j.find(".wijmo-wijev-daycolumn").remove();for(f=0,r=t.length;f<r;f=f+1){d=t[f];b=this._getCachedDayHeader(d);c=this._getCachedDayColumn(d);if(!b){b=this._templateDayHeader.clone(true);c=this._templateDayColumn.clone(true);b.addClass(this._dayDateToCssClass(d));b.find(".wijmo-wijev-daylabel").html(this._formatDayHeaderDate(d));c.addClass(this._dayDateToCssClass(d));if(q)q=false;else{c.addClass("wijmo-wijev-leftborder");b.addClass("wijmo-wijev-leftborder")}if(this._compareDayDates(d,l)===0){c.addClass("wijmo-wijev-today ui-state-highlight");c.addClass("wijmo-wijev-leftborder");c.addClass("wijmo-wijev-rightborder");b.addClass("wijmo-wijev-today").find(".wijmo-wijev-allday-cell").addClass("ui-state-highlight");b.addClass("wijmo-wijev-leftborder");b.addClass("wijmo-wijev-rightborder");q=true}if(f===r-1){c.addClass("wijmo-wijev-rightborder");b.addClass("wijmo-wijev-rightborder")}}else{b=a(b);b.find(".wijmo-wijev-daylabel").html(this._formatDayHeaderDate(d))}p.append(b);j.append(c)}this._invalidateDayView();this._renderDayViewAppointments()},_getCachedDayHeader:function(a){var b=null;if(this._dayViewCache)if(this._dayViewCache[a])b=this._dayViewCache[a].h;return b},_getCachedDayColumn:function(a){var b=null;if(this._dayViewCache)if(this._dayViewCache[a])b=this._dayViewCache[a].c;return b},_storeDayCache:function(a,c,b){if(!this._dayViewCache)this._dayViewCache={};this._dayViewCache[a]={h:c,c:b}},_clearViewsCache:function(){this._clearDayViewCache();this._clearListViewCache()},_clearDayViewCache:function(){this._dayViewCache={}},_clearListViewCache:function(){var a=this.element.find(".wijmo-wijev-list-details .wijmo-wijev-agenda-container .wijmo-wijsuperpanel-templateouterwrapper");a.data("wijevcal_agenda_initialized",false);a.data("wijevcal_agenda_loadedeventscount",0)},_invalidateDayView:function(){var b=this.element.find(".wijmo-wijev-headercontainer"),k=this.element.find(".wijmo-wijev-scrollcontent"),s=k.find(".wijmo-wijev-timeruler"),j=b.find(".wijmo-wijev-dayheadercolumn"),p=k.find(".wijmo-wijev-daycolumn"),q=this.element.find(".wijmo-wijev-view .wijmo-wijev-header-title"),o,d,l,c,n,f,h,r=s.outerWidth(),g,e,m,i;this._updateHeaderTitleText();o=q.is(":visible")?q.outerHeight(true):0;this._invalidateView();if(!this._maxAllDayEventCount)this._maxAllDayEventCount=0;c=b.find(".wijmo-wijev-dayheadercolumn .wijmo-wijev-appointment").outerHeight(true);if(!c)c=17;n=b.find(".wijmo-wijev-daylabel").outerHeight(true);f=0;for(g=0;g<j.length;g+=1){h=a(j[g]).find(".wijmo-wijev-allday-cell .wijmo-wijev-appointment").length;if(h>f)f=h}l=c*f+n+c;b.outerHeight(l+Math.round(c/2));b.find(".wijmo-wijev-allday-cell").outerHeight(l);d=this.element.find(".wijmo-wijev-view").innerWidth();e=d-r;e=e-18;m=this.element.find(".wijmo-wijev-view").innerHeight()-b.outerHeight(true)-o;i=Math.floor(e/p.length);b.outerWidth(d);k.outerWidth(d);j.outerWidth(i);p.outerWidth(i);this._invalidateCurrentTimeIndicator();this.element.find(".wijmo-wijev-scrollpanel").outerWidth(d).outerHeight(m).wijsuperpanel("refresh");switch(this.options.viewType.toLowerCase()){case"day":this._updateDayViewDetails();break;case"list":this._updateListViewDetails()}},_updateDayViewDetails:function(){var c=this.options,b=c.selectedDate;if(!this._dayViewDetailsInit){this._dayViewDetailsInit=true;this.element.find(".wijmo-wijev-day-details .wijmo-wijev-daycalendar").wijcalendar({culture:c.culture,titleFormat:this.localizeString("calendarTitleFormat","MMMM yyyy"),toolTipFormat:this.localizeString("calendarToolTipFormat","dddd, MMMM dd, yyyy"),showTitle:false,showOtherMonthDays:false,showWeekNumbers:false,selectionMode:{day:true,days:false},selectedDatesChanged:a.proxy(function(b,a){a.dates&&!c.disabled&&this.goToDate(a.dates[0])},this),nextTooltip:this.localizeString("calendarNextTooltip","Next"),prevTooltip:this.localizeString("calendarPrevTooltip","Previous")});this.element.find(".wijmo-wijev-day-details .wijmo-wijev-agenda-container").wijsuperpanel()}this.element.find(".wijmo-wijev-day-details .wijmo-wijev-daycalendar").wijcalendar("option","displayDate",b).wijcalendar("unSelectAll").wijcalendar("selectDate",b);this.element.find(".wijmo-wijev-day-details .wijmo-wijev-daycalendar").wijcalendar("refresh");this.element.find(".wijmo-wijev-day-details .wijmo-wijev-monthday-label").html(b.getDate());this.element.find(".wijmo-wijev-day-details .wijmo-wijev-fulldate-label").html(this._formatString(this.localizeString("dayDetailsLabelFulldateFormat","{0:dddd, MMMM d}"),b));this.element.find(".wijmo-wijev-day-details .wijmo-wijev-year-label").html(this._formatString(this.localizeString("dayDetailsLabelYearFormat","{0:yyyy}"),b));this._updateAgendaList(this.element.find(".wijmo-wijev-day-details  .wijmo-wijev-agenda-container"),b,b,false)},_listViewAgendaScrolled:function(){var d=this.element.find(".wijmo-wijev-list-details .wijmo-wijev-agenda-container"),c=d.wijsuperpanel("option","vScroller"),b,e=c.scrollValue,f=c.scrollMax-c.scrollLargeChange*2;if(e>=f){b=d.find(".wijmo-wijsuperpanel-templateouterwrapper");if(b.data("wijevcal_agenda_loadnextpage")){b.data("wijevcal_agenda_loadnextpage",false);b.find(".wijmo-wijev-agenda-more-events").show().html(this.localizeString("agendaLoadingMoreEvents","Loading more events..."));setTimeout(a.proxy(function(){this._renderAgendaEvents(b,null,null,true)},this),100)}}},_updateListViewDetails:function(){if(!this._listViewDetailsInit){this._listViewDetailsInit=true;this.element.find(".wijmo-wijev-list-details .wijmo-wijev-agenda-container").wijsuperpanel({scrolled:a.proxy(this._listViewAgendaScrolled,this)})}this._updateAgendaList(this.element.find(".wijmo-wijev-list-details  .wijmo-wijev-agenda-container"),null,null,true)},_updateAgendaList:function(a,c,d,b){if(a.find(".wijmo-wijsuperpanel-templateouterwrapper").length>0)a=a.find(".wijmo-wijsuperpanel-templateouterwrapper");if(b&&a.data("wijevcal_agenda_initialized")){a.parents(".wijmo-wijsuperpanel").wijsuperpanel("refresh");return}a.data("wijevcal_agenda_initialized",true);a.data("wijevcal_agenda_loadedeventscount",0);a.html("");this._renderAgendaEvents(a,c,d,b)},_renderAgendaEvents:function(h,t,u,n){var j=this._eventsView,f,e,i,s,p=0,m,d="",g="",l=null,o=null,v=this.options,c,r,q=100,k=h.data("wijevcal_agenda_loadedeventscount");if(t){l=b(t);o=this._addDays(b(u),1);s=(o.getTime()-l.getTime())/864e5}if(j){i=j.length<q+k||!n?j.length:q+k;h.data("wijevcal_agenda_loadedeventscount",i);if(!l){g="";for(e=k;e<i;e+=1){f=j[e];if(e===k||c.getDate()!==f.start.getDate()){c=f.start;if(e!==0){d+='<ul class="wijmo-wijev-agenda-list">'+g+"</ul>";d+="</div>"}d+='<div class="wijmo-wijev-agenda-day-container '+this._dayDateToCssClass(c)+'">';if(n)d+=this._renderAgendaDayHeader(c);g=""}g+=this._renderAgendaAppointmentVisual(f);m+=1;if(e===i-1){d+='<ul class="wijmo-wijev-agenda-list">'+g+"</ul>";d+="</div>";if(i<j.length){d+='<div class="wijmo-wijev-agenda-more-events">';d+=this._formatString(this.localizeString("agendaMoreEventsFormat","More events ({0})..."),j.length-i);d+="<div>";h.data("wijevcal_agenda_loadnextpage",true)}else h.data("wijevcal_agenda_loadnextpage",false)}}}else while(p<s){c=this._addDays(l,p);c=new Date(c.getFullYear(),c.getMonth(),c.getDate());r=new Date(c.getFullYear(),c.getMonth(),c.getDate(),23,59,59);m=0;g="";for(e=k;e<i;e+=1){f=j[e];if(f.start<o&&f.end>l&&f.start<r&&f.start>=c){g+=this._renderAgendaAppointmentVisual(f);m+=1}}if(g!==""){d+='<div class="wijmo-wijev-agenda-day-container '+this._dayDateToCssClass(c)+'">';if(n)d+=this._renderAgendaDayHeader(c);d+='<ul class="wijmo-wijev-agenda-list">'+g+"</ul>";d+="</div>"}p+=1}a(d).appendTo(h)}h.find(".wijmo-wijev-agenda-event").live("click",a.proxy(this._onAgendaEventClick,this)).hover(function(){a(this).addClass("ui-state-hover")},function(){a(this).removeClass("ui-state-hover").removeClass("ui-state-active")}).mousedown(function(){a(this).addClass("ui-state-active")}).mouseup(function(){a(this).removeClass("ui-state-active")});h.parents(".wijmo-wijsuperpanel").wijsuperpanel("refresh")},_renderAgendaDayHeader:function(a){return'<div class="wijmo-wijev-agenda-header ui-widget-header"><div class="wijmo-wijev-weekday">'+this._formatString("{0:dddd}",a)+'</div><div class="wijmo-wijev-date">'+this._formatString(this.localizeString("agendaHeaderFullDateFormat","{0:MMMM d, yyyy}"),a)+"</div></div>"},_onAgendaEventClick:function(c){var b=a(c.target);if(!b.hasClass("wijmo-wijev-agenda-event"))b=b.parent(".wijmo-wijev-agenda-event");b.length>0&&this.goToEvent(this._parseEventIdFromClass(b[0].className))},_renderAgendaAppointmentVisual:function(a){return'<li class="wijmo-wijev-agenda-event '+this._dayDateToCssClass(a.start)+" "+this._eventIdToCssClass(a.id)+' ui-state-default ui-helper-clearfix"><div class="wijmo-wijev-agenda-event-color wijmo-wijev-event-color-'+(a.color||"default")+'"><div></div></div><div class="wijmo-wijev-agenda-event-title">'+a.subject+'</div><div class="wijmo-wijev-agenda-event-time">'+(this.isAllDayEvent(a)?this.localizeString("labelAllDay","all-day"):this._formatString(this.localizeString("agendaTimeFormat","{0:hh:mm tt} to {1:hh:mm tt}"),a.start,a.end))+"</div></li>"},_invalidateCurrentTimeIndicator:function(){var c=this.element.find(".wijmo-wijev-timeruler .wijmo-wijev-currenttime-indicator"),a=new Date,b=this.options;a=a.getMinutes()+a.getHours()*60;c.css("top",a/b.timeInterval*b.timeIntervalHeight)},_onEventsDataChanged:function(){this._clearViewsCache();this._prepareEventsForView();this._renderActiveView();this._trigger("eventsDataChanged",null,{eventsData:this.options.eventsData})},_onCalendarsChanged:function(){this._trigger("calendarsChanged",null,{calendars:this.options.calendars})},_renderDayViewAppointments:function(){var o=this._eventsView,d,l,c,v,w,x=this.element.find(".wijmo-wijev-headercontainer"),y=this.element.find(".wijmo-wijev-scrollcontent"),q=x.find(".wijmo-wijev-dayheadercolumn"),h=y.find(".wijmo-wijev-daycolumn"),b,k,m=this.options,f=this._getDayColumnDates(),z=f[0],g,p,e,i,j,s,t,n,u,r=[];g=f[f.length-1];g=new Date(g.getFullYear(),g.getMonth(),g.getDate(),23,59,59);if(o)for(c=0,w=f.length;c<w;c+=1)if(!h[c]._cached){b=f[c];b=new Date(b.getFullYear(),b.getMonth(),b.getDate());k=new Date(b.getFullYear(),b.getMonth(),b.getDate(),23,59,59);for(l=0,v=o.length;l<v;l+=1){d=o[l];if(d.start<g&&d.end>z&&d.start<k&&d.end>b)if(this.isAllDayEvent(d)){p=true;e=a(this._getAllDayEventMarkup(d));a(q[c]).find(".wijmo-wijev-allday-cell").append(e)}else{i=d.start;j=d.end;if(i<b)i=b;if(j>k)j=k;s=(i-b)/6e4;t=(j-b)/6e4;n=Math.round(s*m.timeIntervalHeight/m.timeInterval);u=Math.round(t*m.timeIntervalHeight/m.timeInterval);e=a(this._getEventMarkup(d));e.css("top",n);e.outerHeight(u-n);a(h[c]).append(e)}}this._storeDayCache(f[c],q[c],h[c]);h[c]._cached=true;r.push(h[c])}this._dayColumnsToResolve=r;this._dayColumnResolveIdx=0;if(!this._resolveDayApptConflictsTimeout){clearTimeout(this._resolveDayApptConflictsTimeout);this._resolveDayApptConflictsTimeout=null}this._resolveDayApptConflictsTimeout=setTimeout(a.proxy(this._resolveDayViewAppointmentConflictsCb1,this),1);p&&this._invalidateDayView(true);if(this._dayViewScrollToEvent){e=this.element.find(".wijmo-wijev-dayview .wijmo-wijev-daycolumn ."+this._eventIdToCssClass(this._dayViewScrollToEvent.id));e.length>0&&this.element.find(".wijmo-wijev-scrollpanel").wijsuperpanel("scrollChildIntoView",e)}},_getAllDayEventMarkup:function(a){return'<div class="wijmo-wijev-appointment '+this._eventIdToCssClass(a.id)+'"><div class=" wijmo-wijev-colordot wijmo-wijev-event-color-'+(a.color||"default")+'"></div><div class="wijmo-wijev-event-title">'+a.subject+"</div></div>"},_getEventMarkup:function(a){return'<div class="wijmo-wijev-appointment wijmo-wijev-event-color-'+(a.color||"default")+" "+this._eventIdToCssClass(a.id)+'"><div class="wijmo-wijev-content"><div class="wijmo-wijev-title">'+this._formatString(this.options.eventTitleFormat,a.start,a.end,a.subject,a.location,"")+'</div></div><div class="wijmo-wijev-resizer"><div class="ui-icon ui-icon-grip-solid-horizontal">&nbsp;</div></div></div>'},_resolveDayViewAppointmentConflictsCb1:function(){this._resolveDayApptConflictsTimeout=null;if(!this._dayColumnsToResolve||this._dayColumnResolveIdx>=this._dayColumnsToResolve.length)return;this._resolveDayViewAppointmentConflicts(this._dayColumnsToResolve[this._dayColumnResolveIdx]);this._dayColumnResolveIdx=this._dayColumnResolveIdx+1;setTimeout(a.proxy(this._resolveDayViewAppointmentConflictsCb1,this),1)},_resolveDayViewAppointmentConflicts:function(l){var j=a(l).find(".wijmo-wijev-appointment"),f=[],e,b,d,c,h,g,i,k;for(b=0,g=j.length;b<g;b+=1){c=j[b];for(d=0;d<g;d+=1)if(d!==b){h=j[d];if(c.offsetTop<h.offsetTop+h.offsetHeight&&c.offsetTop+c.offsetHeight>h.offsetTop){if(!f[b])f[b]=[c];f[b].push(h)}}}for(b=0,g=f.length;b<g;b+=1){e=f[b];if(e){c=e[0];i=e.length;c.style.width=Math.ceil(100/i)+"%";e.sort(this._sortOffsetTop);for(d=0;d<i;d+=1){c=e[d];k=Math.floor(100*d/i);c.style.marginLeft=k+"%";c.style.zIndex=k}}}},_sortOffsetTop:function(a,b){return a.offsetTop<b.offsetTop?-1:a.offsetTop>b.offsetTop?1:0},_onDayViewTimeIntervalClick:function(a){this.showEditEventDialog(null,a.target,a)},_onDayViewAllDayCellClick:function(c){var b=a(c.target);if(b.hasClass("wijmo-wijev-appointment")||b.parents(".wijmo-wijev-appointment").length>0)return;if(b.hasClass("wijmo-wijev-daylabel")||b.parents(".wijmo-wijev-daylabel").length>0)return;this.showEditEventDialog(null,c.target,c)},_onMonthViewDayLabelClick:function(e){var b=a(e.target).parents(".wijmo-wijev-monthcellcontainer"),c=this.options,d;if(b.length<1)b=a(e.target).parents(".wijmo-wijev-dayheadercolumn");if(b[0]){d=this._parseDateFromClass(b[0].className);if(c.viewType!=="day"){c.viewType="day";this._onViewTypeChanged()}c.selectedDates=[new Date(d)];this._onSelectedDatesChanged()}},_onMonthViewCellClick:function(c){var b=a(c.target).parent(".wijmo-wijev-monthcellcontainer");if(b.length<1)return;this.showEditEventDialog(null,b,c)},_onAppointmentClick:function(d){var b=a(d.target),c;if(this._apptDragResizeFlag)return;if(!b.hasClass("wijmo-wijev-appointment"))b=b.parents(".wijmo-wijev-appointment");if(b.length>0){c=this.findEventById(b[0].className);this.showEditEventDialog(c,b,d)}},findEventById:function(a){var b;if(a){b=a.indexOf("apptid_");if(b!==-1)a=this._parseEventIdFromClass(a);if(this._eventsDataById)return this._eventsDataById[a]}return null},_onMonthViewAppointmentMouseDown:function(c){var b=a(c.target),d=b.hasClass("wijmo-wijev-appointment")?b:b.parents(".wijmo-wijev-appointment");c.preventDefault();this.__targetAppt=d;a(document).bind("mouseup.tmp_wijevcal",a.proxy(this._onMonthViewAppointmentMouseUp,this));this.element.find(".wijmo-wijev-monthview .wijmo-wijev-monthcellcontainer").bind("mouseover.tmp_wijevcal",a.proxy(this._onMonthViewCellMouseOver,this))},_onDayViewAppointmentMouseDown:function(d){var b=a(d.target),c=b.hasClass("wijmo-wijev-appointment")?b:b.parents(".wijmo-wijev-appointment"),e=b.hasClass("wijmo-wijev-resizer")||b.parents(".wijmo-wijev-resizer").length>0;if(this.options.disabled)return;this._isApptResize=e;d.preventDefault();if(this._isApptResize){this.__startApptH=c[0].offsetHeight;this.__startApptY=c[0].offsetTop}else this.__startApptY=c[0].offsetTop;this.__startClientY=d.clientY;this.__targetAppt=c;a(document).bind("mousemove.tmp_wijevcal",a.proxy(this._onDayViewAppointmentMouseMove,this));a(document).bind("mouseup.tmp_wijevcal",a.proxy(this._onDayViewAppointmentMouseUp,this));a(this.element).find(".wijmo-wijev-dayview .wijmo-wijev-daycolumn").bind("mouseover.tmp_wijevcal",a.proxy(this._onDayViewColumnMouseOver,this));a(this.element).find(".wijmo-wijev-dayview .wijmo-wijev-allday-cell").bind("mouseover.tmp_wijevcal",a.proxy(this._onDayViewAllDayMouseOver,this))},_onDayViewAppointmentMouseMove:function(d){d.preventDefault();var c=d.clientY-this.__startClientY,b,f=this.options,a,e;if(!d.ctrlKey)c=Math.round(c/f.timeIntervalHeight)*f.timeIntervalHeight;if(c!==0&&!this._apptDragResizeFlag){this._apptDragResizeFlag=true;this.__targetAppt.addClass("wijmo-wijev-dragging");this.__targetAppt.css("width","100%").css("margin-left","0").css("z-index","1000")}if(this._apptDragResizeFlag){if(this._isApptResize){a=this.__startApptH+c;if(a<0){a=Math.abs(a);b=this.__startApptY-a;if(b>=0){this.__targetAppt.css("height",a);this.__targetAppt.css("top",b)}}else this.__targetAppt.css("height",a)}else{b=this.__startApptY+c;if(b<0)b=0;this.__targetAppt.css("top",b);e=this.__targetAppt.offset().top;this.element.find(".wijmo-wijev-scrollpanel").wijsuperpanel("scrollChildIntoView",this.__targetAppt);this.__startApptY=this.__startApptY-(this.__targetAppt.offset().top-e)}this._onApptVisualDargOrResize(this.__targetAppt,this.findEventById(this.__targetAppt[0].className))}},_onDayViewAppointmentMouseUp:function(){this.__targetAppt&&this.__targetAppt.removeClass("wijmo-wijev-dragging");a(document).unbind(".tmp_wijevcal");a(this.element).find(".wijmo-wijev-dayview .wijmo-wijev-daycolumn").unbind(".tmp_wijevcal");a(this.element).find(".wijmo-wijev-dayview .wijmo-wijev-allday-cell").unbind(".tmp_wijevcal");this._resolveDayViewAppointmentConflicts(this.__targetAppt.parents(".wijmo-wijev-daycolumn"));if(this._apptDragResizeFlag||this._apptMovedFlag){var b=this.findEventById(this.__targetAppt[0].className);this._onApptVisualDargOrResize(this.__targetAppt,b);this._apptMovedFlag=false;this._movedFromTimeInervalApptElem=null;this.updateEvent(b);window.setTimeout(a.proxy(function(){if(this.__targetAppt&&!this.__targetAppt.hasClass("wijmo-wijev-dragging"))this._apptDragResizeFlag=false},this),1)}},_updateAppointmentVisual:function(c){var a=this.element.find(".wijmo-wijev-dayview ."+this._eventIdToCssClass(c.id)),d=this.options,h,i,g,j,e,f,k,l;if(a.length===1){this._addColorClass(a,c.color);a.find(".wijmo-wijev-title").html(this._formatString(d.eventTitleFormat,c.start,c.end,c.subject,c.location,""));e=b(c.start);h=(c.start-e)/6e4;i=(c.end-e)/6e4;g=Math.round(h*d.timeIntervalHeight/d.timeInterval);j=Math.round(i*d.timeIntervalHeight/d.timeInterval);a.css("top",g);a.css("height",j-g);f=this._dayDateToCssClass(e);if(a.parents(".wijmo-wijev-daycolumn."+f).length!==1){k=a[0].parentNode;l=this.element.find(".wijmo-wijev-daycolumn."+f);k.removeChild(a[0]);a.appendTo(l)}}},_onApptVisualDargOrResize:function(b,a){var c=this.options,h=b[0].offsetTop,k=h+b[0].offsetHeight,f,i,g,j,d,e;if(b.parents(".wijmo-wijev-dayheadercolumn").length>0)e=b.parents(".wijmo-wijev-dayheadercolumn")[0];else e=b.parents(".wijmo-wijev-daycolumn")[0];d=this._parseDateFromClass(e.className,null);f=Math.round(h*c.timeInterval/c.timeIntervalHeight);i=Math.round(k*c.timeInterval/c.timeIntervalHeight);g=new Date(f*6e4+d.getTime());j=new Date(i*6e4+d.getTime());if(a){a.allday=b.parents(".wijmo-wijev-dayheadercolumn").length>0;a.start=g;a.end=j;b.find(".wijmo-wijev-title").html(this._formatString(c.eventTitleFormat,a.start,a.end,a.subject,a.location,""))}},_onDayViewColumnMouseOver:function(d){var c=a(d.target).parents(".wijmo-wijev-daycolumn"),b=this.__targetAppt.parents(".wijmo-wijev-daycolumn");if(c.length<1)return;if(b.length<1){b=this.__targetAppt.parents(".wijmo-wijev-dayheadercolumn");if(b.length<1)return;else if(this._movedFromTimeInervalApptElem){this.__targetAppt.replaceWith(this._movedFromTimeInervalApptElem);this.__targetAppt=a(this._movedFromTimeInervalApptElem);this._movedFromTimeInervalApptElem=null}else this.__targetAppt.html(this._getEventMarkup(this.findEventById(this.__targetAppt[0].className),true))}if(c[0].className!==b[0].className){this.__targetAppt[0].parentNode.removeChild(this.__targetAppt[0]);this._resolveDayViewAppointmentConflicts(b);this.__targetAppt.appendTo(c);this._apptMovedFlag=true}},_onMonthViewCellMouseOver:function(e){var c=a(e.target),b=c.hasClass("wijmo-wijev-monthcellcontainer")?c:c.parents(".wijmo-wijev-monthcellcontainer"),d=this.__targetAppt.parents(".wijmo-wijev-monthcellcontainer");if(b.length<1||d.length<1)return;if(b[0].className!==d[0].className){this.__targetAppt[0].parentNode.removeChild(this.__targetAppt[0]);this.__targetAppt.appendTo(b.find(".wijmo-wijev-monthcell"));this.__targetApptChanged=true}},_onMonthViewAppointmentMouseUp:function(){var c,f=this.__targetAppt.parents(".wijmo-wijev-monthcellcontainer")[0],e=this._parseDateFromClass(f.className,null),d;a(document).unbind(".tmp_wijevcal");this.element.find(".wijmo-wijev-monthview .wijmo-wijev-monthcellcontainer").unbind(".tmp_wijevcal");if(this.__targetApptChanged){this.__targetApptChanged=false;c=this.findEventById(this.__targetAppt[0].className);d=(e.getTime()-b(c.start).getTime())/864e5;c.start=this._addDays(c.start,d);c.end=this._addDays(c.end,d);this.updateEvent(c)}},_onDayViewAllDayMouseOver:function(e){var d=a(e.target).parents(".wijmo-wijev-dayheadercolumn"),b=this.__targetAppt.parents(".wijmo-wijev-daycolumn"),c;if(d.length<1)return;if(b.length>0){c=a(this._getAllDayEventMarkup(this.findEventById(this.__targetAppt[0].className)));this._movedFromTimeInervalApptElem=this.__targetAppt[0].cloneNode(true);this.__targetAppt.replaceWith(c);this.__targetAppt=c}else b=this.__targetAppt.parents(".wijmo-wijev-dayheadercolumn");if(b.length<1)return;if(d[0].className!==b[0].className){this.__targetAppt[0].parentNode.removeChild(this.__targetAppt[0]);this._resolveDayViewAppointmentConflicts(b);this.__targetAppt.appendTo(a(d).find(".wijmo-wijev-allday-cell"));this._apptMovedFlag=true}},_renderMonthView:function(){var m=this.options,d=m.selectedDate,t=m.firstDayOfWeek,i=false,j=false,c,g,h,u=new Date,e,p,o=false,f,q=["","","","","","",""],b,l,k=this.element.find(".wijmo-wijev-view.wijmo-wijev-monthview"),n,s=m.dayHeaderFormat,r=m.firstRowDayHeaderFormat;if(!d)d=new Date;g=new Date(d.getFullYear(),d.getMonth(),1);while(g.getDay()!==t)g=this._addDays(g,-1);h=new Date(d.getFullYear(),d.getMonth(),this._daysInMonth(d.getMonth(),d.getFullYear()));c=g;e=0;p=0;while(c<h||e<7){if(c>h)h=c;b="";f="wijmo-wijev-monthcellcontainer ui-widget-content "+this._dayDateToCssClass(c);j=c.getMonth()!==d.getMonth();if(j)f+=" wijmo-wijev-othermonth";if(o)o=false;else{f+=" wijmo-wijev-leftborder";if(e===6)f+=" wijmo-wijev-rightborder"}i=this._compareDayDates(c,u)===0;if(i){f+=" wijmo-wijev-today";f+=" wijmo-wijev-rightborder";o=true}b+='<div class="'+f+'">';b+='<div class="wijmo-wijev-monthcellheader';if(j)b+=" ui-priority-secondary";if(i)b+=" ui-state-highlight";b+='">';if(i)b+='<span class="wijmo-wijev-todaylabel">'+this.localizeString("labelToday","Today")+"</span>";if(p===0)b+=this._formatString(r,c);else b+=this._formatString(s,c);b+="</div>";b+='<div class="wijmo-wijev-monthcell';if(j)b+=" ui-priority-secondary";if(i)b+=" ui-state-highlight";b+='"></div>';b+="</div>";q[e]=q[e]+b;e+=1;c=this._addDays(c,1);if(e>6){if(c>h)break;e=0;p+=1}}if(k.length===0){k=a('<div class="wijmo-wijev-view wijmo-wijev-monthview ui-widget-content"><h3 class="wijmo-wijev-header-title">title</h3><div class="wijmo-wijev-monthview-inner"></div></div>');k.appendTo(this.element.find(".wijmo-wijev-view-container"))}n=k.find(".wijmo-wijev-monthview-inner");n.find(".wijmo-wijev-monthcolumn").remove();c=g;for(l=0;l<7;l+=1){n.append('<div class="wijmo-wijev-monthcolumn">'+q[l]+"</div>");c=this._addDays(c,1)}this._invalidateMonthView();this._renderMonthViewAppointments()},_invalidateMonthView:function(){var f=this.element.find(".wijmo-wijev-monthview"),c=f.find(".wijmo-wijev-monthview-inner"),b=f.find(".wijmo-wijev-monthcolumn"),i=f.find(".wijmo-wijev-monthcellcontainer"),n=this.element.find(".wijmo-wijev-monthview .wijmo-wijev-header-title"),d,e,g,h,k,m,l,j;this._invalidateView();if(b.length<1)return;d=f.innerWidth();e=f.innerHeight()-n.outerHeight(true);c.outerWidth(d);c.outerHeight(e);d=d-(c.outerWidth(true)-c.innerWidth());e=e-(c.outerHeight(true)-c.innerHeight());g=Math.floor(d/b.length);b.outerWidth(g);j=d-g*b.length;j>0&&a(b[b.length-1]).outerWidth(g+j);l=a(b[0]).find(".wijmo-wijev-weekdayname").outerHeight(true);h=Math.floor((e-l)/a(b[0]).find(".wijmo-wijev-monthcellcontainer").length);i.height(h);k=a(i[0]).find(".wijmo-wijev-monthcellheader").outerHeight(true);m=h-k;i.find(".wijmo-wijev-monthcell").outerHeight(m)},_renderMonthViewAppointments:function(){var h=this._eventsView,b,d,e,i,l,f=this.element.find(".wijmo-wijev-monthcellcontainer"),g,c,k,j;if(h)for(e=0,l=f.length;e<l;e+=1){g=f[e];c=this._parseDateFromClass(g.className);k=new Date(c.getFullYear(),c.getMonth(),c.getDate(),23,59,59);for(d=0,i=h.length;d<i;d+=1){b=h[d];if(b.start<k&&b.end>c){j=a('<div class="wijmo-wijev-appointment '+this._eventIdToCssClass(b.id)+'"><div class=" wijmo-wijev-colordot wijmo-wijev-event-color-'+(b.color||"default")+'"></div><div class="wijmo-wijev-event-title">'+b.subject+"</div></div>");a(g).find(".wijmo-wijev-monthcell").append(j)}}}f.find(".wijmo-wijev-monthcell").each(a.proxy(function(i,h){var b=a(h),e=b.find(".wijmo-wijev-appointment"),f=b.outerHeight(),d=e.outerHeight(),g=e.length*d,c=0;if(g>f){e.each(function(b,a){if(b*d+d>f){a.style.display="none";c+=1}});if(c>0)b.find(".wijmo-wijev-monthcell-showmore").length<1&&b.append(a('<div class="wijmo-wijev-monthcell-showmore">'+this._formatString(this.localizeString("monthCellMoreEventsFormat","{0}  more..."),c)+"</div>"))}},this))},log:function(){},_log:function(d,c){var b;if(this.logPanel){b=new Date;this.logPanel.prepend(a('<span class="'+(c?c:"wijmo-wijev-information")+'">['+b.getHours()+":"+b.getMinutes()+":"+b.getSeconds()+"] "+d+"</span><br/>"))}},_createLogPanel:function(){if(!this.logPanel){this.logDialog=a('<div title="Log"><div class="wijmo-wijev-log"></div></div>');this.logDialog.appendTo(this.element);this.logPanel=this.logDialog.wijdialog({captionButtons:{},buttons:{"Clear All":function(){a(this).find(".wijmo-wijev-log").html("")},Close:function(){a(this).wijdialog("close")}},width:600,height:420,position:["right","top"]}).find(".wijmo-wijev-log")}this.logDialog.wijdialog("open")},status:function(b,a){this.element.find(".wijmo-wijev-statusbar").html("<span class='"+(a?a:"wijmo-wijev-status")+"'>"+b+"</span>");this.log(b,a?a:"wijmo-wijev-status")},_invalidateView:function(){var n=this.element.find(".wijmo-wijev-rightpane"),c=this.element.find(".wijmo-wijev-leftpane"),q=c.find(".wijmo-wijev-agenda-container"),p=this.element.find(".wijmo-wijev-headerbar"),k=this.element.find(".wijmo-wijev-navigationbar"),o=this.element.find(".wijmo-wijev-statusbar"),b=this.element.find(".wijmo-wijev-view-container"),s=this.element.find(".wijmo-wijev-view"),l,d,j,g,i,r,h,e,m,f;l=this.element.innerWidth()-(b.outerWidth(true)-b.innerWidth());d=this.element.innerHeight()-(b.outerHeight(true)-b.innerHeight());j=p.is(":visible")?p.outerHeight(true):0;g=k.is(":visible")?k.outerHeight(true):0;i=o.is(":visible")?o.outerHeight(true):0;b.outerWidth(l);b.outerHeight(d-j-g-i);e=0;for(f=0;f<c.length;f+=1)if(a(c[f]).is(":visible"))e+=a(c[f]).outerWidth();m=n.is(":visible")?n.outerWidth():0;r=d-j-g-i;h=l-m-e;s.outerHeight(r);s.outerWidth(h);p.outerWidth(h+e);k.outerWidth(this.element.innerWidth());o.outerWidth(h+e+m);c.outerHeight(d-j-g-i);q.outerHeight(c.innerHeight()-q[0].offsetTop);n.outerHeight(d+100);this.element.find(".wijmo-wijev-datepager").wijdatepager("refresh")},_daysInMonth:function(a,b){var c=new Date(b,a+1,0);return c.getDate()},_addMinutes:function(a,b){return new Date(a.getFullYear(),a.getMonth(),a.getDate(),a.getHours(),a.getMinutes()+b)},_addDays:function(a,b){return new Date(a.getFullYear(),a.getMonth(),a.getDate()+b,a.getHours(),a.getMinutes(),a.getSeconds(),a.getMilliseconds())},_setTime:function(a,b,d){var c;a=new Date(a);a.setHours(b.getHours());a.setMinutes(b.getMinutes());a.setSeconds(b.getSeconds());a.setMilliseconds(b.getMilliseconds());if(d){c=Math.floor((b.getTime()-d.getTime())/864e5);if(c>0)a=this._addDays(a,c)}return a},_addMonths:function(a,b){return new Date(a.getFullYear(),a.getMonth()+b,a.getDate())},_compareDayDates:function(a,b){a=new Date(a.getFullYear(),a.getMonth(),a.getDate());b=new Date(b.getFullYear(),b.getMonth(),b.getDate());return a<b?-1:a>b?1:0},_dayDateToCssClass:function(a){return"wijmo-wijev-date_"+a.getFullYear()+"_"+a.getMonth()+"_"+a.getDate()},_parseDateFromClass:function(e,d,g){var c,a,b,h=new RegExp("wijmo-wijev-minute-(\\d+)\\s"),f=new RegExp("wijmo-wijev-date_(\\d+_\\d+_\\d+)\\s");if(e){b=f.exec(e+" ")[1].split("_");c=new Date(parseInt(b[0],10),parseInt(b[1],10),parseInt(b[2],10));if(d){a=h.exec(d+" ");if(a){a=parseInt(a[1],10);c.setMinutes(a)}}return c}else return g||null},_eventIdToCssClass:function(a){return"apptid_"+a},_parseEventIdFromClass:function(d){var c="",b,a;b=new RegExp("apptid_(\\S+)");a=b.exec(d);if(a&&a.length>1)c=a[1];return c},_isContainsDayDate:function(b,c){var a;if(b){for(a=0;a<b.length;a+=1)if(this._compareDayDates(b[a],c)===0)return true}else return false},_formatString:function(a){var e,b=arguments,c,d,f=this;if(b.length<=1)return Globalize.format(b);if(typeof a==="string")if(a==="_formatWeekTitle")a=this._formatWeekTitle;else if(a==="_formatMonthTitle")a=this._formatMonthTitle;else if(typeof window[a]==="function")a=window[a];if(typeof a==="function"){d=[];for(c=1;c<b.length;c+=1)d[c-1]=b[c];return a.apply(this,d)}e=new RegExp("\\{(\\d+)(?:,([-+]?\\d+))?(?:\\:([^(^}]+)(?:\\(((?:\\\\\\)|[^)])+)\\)){0,1}){0,1}\\}","g");return a.replace(e,function(a,d,g,c){a=b[Number(d)+1];return c?Globalize.format(a,c,f._getCulture()):a})},_formatMonthTitle:function(a){return this._formatString(this.localizeString("monthViewHeaderFormat","{0:MMMM yyyy}"),a)},_formatWeekTitle:function(a,b){return a.getMonth()!==b.getMonth()?this._formatString(this.localizeString("weekViewHeaderFormat2Months","{0:MMMM} - {1:MMMM yyyy}"),a,b):this._formatString(this.localizeString("weekViewHeaderFormat","{0:MMMM yyyy}"),a)},_formatDayHeaderDate:function(c){var d=this.options,b=d.viewType.toLowerCase(),a=this.options.dayViewHeaderFormat;if(a[b])a=a[b];else if(!a[b])return"";return this._formatString(a,c)},_getCulture:function(a){return Globalize.findClosestCulture(a||this.options.culture)},_isRTL:function(){return!!this._getCulture().isRTL},_onAjaxError:function(d,a,b){if(a){this.status("Ajax error "+a.status+" ("+a.statusText+")","error");this.log("Error, requested url: "+b.url,"error");a.responseText&&this.log("Error, response text: "+a.responseText,"error")}else{this.status("Ajax error detected.","error");this.log("Error, requested url: "+b.url,"error")}},_onWindowResize:function(){this.invalidate()}})})(jQuery);
