(ns pipes.demo
  (:require [pipes.core :refer [pipe-> ->pipe-> ->job->]]
            [pipes.shell :refer [exec]]
            [clojure.java.io :as io]
            [clojure.string :as str])
  (:import [java.io ByteArrayInputStream
            ByteArrayOutputStream
            InputStream
            OutputStream]))

(defn read-stream
  [^InputStream input]
  (let [buffer (make-array Byte/TYPE 100)]
    (loop [total-size 0]
            (println total-size)
            (let [size (.read input buffer)]
              (when (pos? size)
                (do (prn "Still pos")
                    (recur (+ total-size size))))))))

(defn copy-stream
  "Copy `input` to `output` using a buffer of size `buffer-size`.
   The optional `progress-fn` callback will be invoked roughly every `buffer-size`
   bytes with the number of total bytes copied so far."
  [^InputStream input ^OutputStream output buffer-size & [progress-fn]]
  (let [on-progress (or progress-fn identity)
        buffer (make-array Byte/TYPE buffer-size)]
    (loop [total-size 0]
      (prn total-size)
      (let [size (.read input buffer)]
        (on-progress total-size)
        (when (pos? size)
          (do (.write output buffer 0 size)
              (recur (+ total-size size))))))))

(def identity-job
  (->job-> [in out] (io/copy in out)))

#_(def identity-job
  (->job-> [in out] (io/copy in out)))

(defn test-works-1 []
  (with-open [in  (ByteArrayInputStream. (.getBytes "yes yes yes\nno no no"))
              out (ByteArrayOutputStream.)]
    @(->pipe-> in
               [identity-job
                (exec ["grep" "no"])]
               out)
    (str out)))

(defn test-works-2 []
  (with-open [in  (ByteArrayInputStream. (.getBytes "yes yes yes\nno no no"))
              out (ByteArrayOutputStream.)]
    @(->pipe-> in
               [(exec ["grep" "no"])]
               out)
    (str out)))



(defn test-fails []
  (with-open [in  (ByteArrayInputStream. (.getBytes "yes yes yes\nno no no"))
              out (ByteArrayOutputStream.)]
    @(->pipe-> in
               [(exec ["grep" "no"])
                (exec ["grep" "no"])
                (fn [in out]
                  (pipes.job/job
                   (io/copy in out )
                    (prn in)
                    (prn out)
                    #_(.write out 5)
                    ))]
               out)
    (str out)))


(defn foo
  "I don't do a whole lot."
  [x]
  (println x "Hello, World!"))

(test-fails)
