(ns auth.header
  (:require [medley.core :as medley]
            [clojure.string :as str]))

(defn parse-authorization-header
  [s]
  (when s
    (let [re-auth-scheme #"([!#$%&'*+\-.\^_`|~0-9a-zA-Z]+)\s+(.*)"
          re-auth-params #"([-._~+/0-9a-zA-Z]+)=\"([^\"]+)\""
          [auth-scheme auth-params] (->> s
                                         (re-find re-auth-scheme)
                                         rest)
          params (->> auth-params
                      (re-seq re-auth-params)
                      (mapv (comp vec rest))
                      (into {})
                      (medley/map-keys keyword))]
      (merge params {:auth-scheme auth-scheme}))))

(defn make-authorization-header
  [auth-scheme auth-params]
  (str auth-scheme
       " "
       (->> auth-params
            (medley/map-keys name)
            (map (fn [[k v]] (str k "=" "\"" v "\"")))
            (str/join ", "))))


(comment
  (parse-authorization-header
    "DLY-TOKEN apikey=\"0PN5J17HBGZHT7JJ3X82\", hash=\"frJIUN8DYpKDtOLCwo//yllqDzg=\"")
  (parse-authorization-header nil)
  (parse-authorization-header (make-authorization "DLY-TOKEN" {:foo "bar" :aa 123}))
  (make-authorization-header "DLY-TOKEN" {:foo "bar" :aa 123}))