(defproject bilus/auth "0.9.7-SNAPSHOT"
  :description "FIXME: write description"
  :url "http://example.com/FIXME"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}

  ;; Most dependencies below are 'provided' because proton-auth is also used as a library (auth.api-conn).
  ;; Esp. pulling in buddy causes conflicts with BouncyCastle because it uses 1.52.
  :dependencies [[org.clojure/clojure "1.7.0" :scope "provided"]
                 [ring "1.4.0" :exclusions [ring/ring-jetty-adapter] :scope "provided"]
                 [compojure "1.4.0" :scope "provided"]
                 [ring/ring-json "0.3.1" :scope "provided"]
                 [prismatic/schema "0.4.3" :scope "provided"]
                 [cheshire "5.5.0" :scope "provided"]
                 [yesql "0.4.2" :scope "provided"]
                 [org.postgresql/postgresql "9.4-1201-jdbc41" :scope "provided"]
                 [migratus "0.8.2" :scope "provided"]
                 [environ "1.0.0" :scope "provided"]
                 [http-kit "2.1.19" :scope "provided"]
                 [buddy "0.6.0"]
                 [clj-http "2.0.0"]
                 [medley "0.7.0"]
                 [ring-cors "0.1.7"]]
  :plugins [[lein-ring "0.9.6"]
            [com.jakemccrary/lein-test-refresh "0.10.0"]
            [migratus-lein "0.1.5"]
            [lein-environ "1.0.0"]
            [s3-wagon-private "1.1.2"]]
  :repositories {"s3private" {:url        "s3p://clj.repo/releases/"
                              :username   :env
                              :passphrase :env}}
  :min-lein-version "2.5.0"
  :source-paths ["src"]
  :main auth.core
  :uberjar-name "auth-server.jar"
  :aliases {"quickie" ["with-profile" "dev" "quickie"]}
  :migratus {:store          :database
             :migrations-dir "migrations"}
  :profiles {:dev     {:dependencies [[ring/ring-mock "0.2.0"]]
                       :source-paths ["test"]}
             :uberjar {:aot :all}})
