# auth

Authentication server.

## Development mode

1. Start REPL.
2. Type:

```clojure
(use 'auth.core)
(start-server 3000)
```

Or:

```
> lein run
```

## Dokku production/staging configuration

### Required files

1. Public key
2. Private key

Simply generate/copy them to the host to /opt/auth/secrets and mount it:

> dokku docker-options:add auth run "-v /opt/auth/secrets:/app/resources/secrets"
> dokku docker-options:add auth deploy "-v /opt/auth/secrets:/app/resources/secrets"

http://shincoding.com/docker/tutorial-deploying-wordpress-with-dokku/

Then set PRIVKEY_PATH PRIVKEY_PASSPHRASE and PUBKEY_PATH (below).

### Required config variables

DATABASE_URL - postgres db url
LEIN_USERNAME - AWS key for s3wagon bucket with private clojure libraries
LEIN_PASSPHRASE - AWS secret key for s3wagon bucket
PRIVKEY_PATH - path to the private key
PRIVKEY_PASSPHRASE - private key passphrase keVb92ugYshMMy
PUBKEY_PATH - path to the public key

### Optional config variables

PORT - port to bind to

## Deploying to staging

> ./deploy-staging

## Deploying to production

> ./deploy

## Preparing database

Ssh to production/staging server:

> dokku run auth lein run migrate
> dokku run auth lein seed ADMIN-USERNAME ADMIN-PASSWORD

## License

Copyright © 2015 Designed.ly

Distributed under the Eclipse Public License either version 1.0 or (at your option) any later version.

## User stories

- Multitenancy.
- User can authenticate and receive tokens.
- JavaScript auth client + permission checking.
- ClojureScript wrapper.
- User can sign up.


## IDEAS

1. Way to create limited administrators, esp. ensuring that someone with auth:CreateUser cannot create
   other users who can create users.

https://blogs.aws.amazon.com/security/post/Tx27Y2HY1GGPVTQ/How-to-Create-a-Limited-IAM-Administrator-by-Using-Managed-Policies
- Either:
    - User with auth:CreateUsers cannot create users who can create users.
    - User with auth:CreatePrivilegedUsers can create users who can create users.
- Or:
    - {:policy {:actions {:$nin ["auth:CreateUsers"]}}}
- Or:
    - Managed policies:
      -  {:actions ["auth:AttachPolicy"]
         :resources ["*"]
         :condition {:policy ["puri:auth:S3Access"]}}
      - auth:CreatePolicy and auth:DestroyPolicy

## NOTES

Cookies or local storage for a token?
https://stormpath.com/blog/where-to-store-your-jwts-cookies-vs-html5-web-storage/

JWT for various languages
http://jwt.io/