(ns pubsub
  (:require
    [cljs.core.async :refer [chan close! timeout put!]]
    [logger :as l]
    [conf]
    )
  (:require-macros [cljs.core.async.macros :as m :refer [go]]
                   [util :as a :refer [fun c debug ac]]
                   )
  )
(def pubsubChannel (chan))




(def subscriptions (js-obj))
(defn sub [subscriptionName subscriptionHandler]

  (if (aget subscriptions subscriptionName)
    (aset subscriptions subscriptionName (conj  (aget subscriptions subscriptionName) subscriptionHandler))

    (aset subscriptions subscriptionName  [subscriptionHandler])

    )
  )
(defn trig [subscriptionName message]
  (-> "body"
      (js/$)
      (.trigger subscriptionName message)

      )
  )
(fun pub [subscriptionName message]

     (if  (aget (aget  js/window "messages") subscriptionName )

       (trig subscriptionName message)
       (>! pubsubChannel (js-obj "typ" subscriptionName "msg" message)))

     )
(fun startpubsub []


     (-> js/document
         (js/$)
         (.on "pubsub" (fn [ev message]
                         (go
                           (>! pubsubChannel message)
                           )))
         )

     (-> js/document
         (js/$)
         (.on "call" (fn [ev message](go
                                 (l/og :callfromevent ev  message)
                                 (def argx (into [(aget message "typ" ) ]
                                                 (aget message "msg" )))
                                 (l/og :callfromevent "argx=" argx)
                                 (<! (apply pubsub.call
                                            argx
                                            )
                                     )
                                 ))))


     (loop []

       (def messageFromPubSub (<! pubsubChannel))

       (loop [col (aget subscriptions (aget messageFromPubSub "typ"))]
         (if col
           ((first col) (aget messageFromPubSub "msg"))

           (def remainingsubs (rest col))

           (if (> (count remainingsubs) 0)
             (recur remainingsubs)
             )
           )
         )
       (recur ))
     )
(defn makeMsg [typ m pchannel]
  (js-obj "typ" typ "msg" m)
  )

(fun functionThatKnowsHowToRouteInSyncWay [channelThatGetsResultOfACall channelThatGetsWhatFunctionToCall & functionName_FunctionPairsFromRouter]


     (if  (aget (aget  js/window "hook") functionName_FunctionPairsFromRouter )
       (do
         ((aget (aget  js/window "hook") functionName_FunctionPairsFromRouter ) msg)
         )

       (do

         ;;loop until all messages have been checked
         ;;similar to the way erlang process checks its mailbox
         (loop []
           (def whatShouldBeTheNextCall (<! channelThatGetsWhatFunctionToCall))
           (if (== (aget whatShouldBeTheNextCall "typ") 0)
             (do
               ;;if we looked at all return 0
               0
               )


             (do
               (l/og :receive "now looking at " whatShouldBeTheNextCall)
               ;; out of all messages we are waitin for
               ;; check if the one extracted from "mailbox" is among them
               ;;
               (def result (loop [howManyPairsDidWeCheck 0]

                             (if (< cnt  (count functionName_FunctionPairsFromRouter) )
                               (do
                                 (if (== (aget whatShouldBeTheNextCall "typ") (nth functionName_FunctionPairsFromRouter howManyPairsDidWeCheck ))
                                   (do
                                     ;;yay we found one now execute the function associated with it
                                     (def returnValueOfDesiredFunction (<! (apply (nth  typ (+ howManyPairsDidWeCheck 1)) (aget  whatShouldBeTheNextCall "msg"))))

                                     (>! channelThatGetsResultOfACall returnValueOfDesiredFunction)
                                     )
                                   (do

                                     (recur (+ howManyPairsDidWeCheck 2)))
                                   )
                                 )
                               )
                             ))
               )
             )
           (recur)))
       ))
(fun functionThatKnowsHowToRouteInAsyncWay [ channelThatGetsWhatFunctionToCall   & functionName_FunctionPairsFromRouter]


       (if  (aget (aget  js/window "hook") functionName_FunctionPairsFromRouter )
         (do
           ((aget (aget  js/window "hook") functionName_FunctionPairsFromRouter ) msg)
           )

         (do

           ;;loop until all messages have been checked
           ;;similar to the way erlang process checks its mailbox
           (loop []
             (def whatShouldBeTheNextCall (<! channelThatGetsWhatFunctionToCall))
             (if (== (aget whatShouldBeTheNextCall "typ") 0)
               (do
                 ;;if we looked at all return 0
                 0
                 )


               (do
                 (l/og :receive "now looking at " whatShouldBeTheNextCall)
                 ;; out of all messages we are waitin for
                 ;; check if the one extracted from "mailbox" is among them
                 ;;
                 (def result (loop [howManyPairsDidWeCheck 0]

                               (if (< cnt  (count functionName_FunctionPairsFromRouter) )
                                 (do
                                   (if (== (aget whatShouldBeTheNextCall "typ") (nth functionName_FunctionPairsFromRouter howManyPairsDidWeCheck ))
                                     (do
                                       ;;yay we found one now execute the function associated with it
                                        (apply (nth  typ (+ howManyPairsDidWeCheck 1)) (aget  whatShouldBeTheNextCall "msg"))


                                       )
                                     (do

                                       (recur (+ howManyPairsDidWeCheck 2)))
                                     )
                                   )
                                 )
                               ))
                 )
               )
             (recur)))
         ))

(fun call [whatFunctionToCall & argumentsForFunctionToBeCalledFromBuyan]



     (if  (aget (aget  js/window "preroutinghook") whatFunctionToCall )
       (do

         (def argumentsForFunctionToBeCalled (js-obj "arr" (apply (aget (aget  js/window "preroutinghook") whatFunctionToCall ) argumentsForFunctionToBeCalledFromBuyan)))

         )
       (def argumentsForFunctionToBeCalled argumentsForFunctionToBeCalledFromBuyan)
       )


     (def channelThatGetsResultOfACall (chan 1))
     (def channelThatGetsWhatFunctionToCall (chan 1))

     (aset channelThatGetsResultOfACall "typ" whatFunctionToCall)
     (>! channelThatGetsWhatFunctionToCall (js-obj "typ" whatFunctionToCall "msg" argumentsForFunctionToBeCalled))

     (routing.route pubsub/functionThatKnowsHowToRouteInSyncWay channelThatGetsResultOfACall channelThatGetsWhatFunctionToCall)

     (if  (aget (aget  js/window "postroutinghook") whatFunctionToCall )
       (do
         (<! (l/og :send "done routing2" ((aget (aget  js/window "postroutinghook") whatFunctionToCall )
                                          (<! channelThatGetsResultOfACall))))


         )

       (<! (l/og :send "done routing2" (<! channelThatGetsResultOfACall)))
       )

     )
(fun asyncCall [typ & m]

     (l/og :invoke  typ m)
     (def pchannel (chan 1))
     (def sch (chan 1))

     (aset pchannel "typ" typ)
     (>! sch (js-obj "typ" typ "msg" (if m  (into [] (.-arr m)) [])))
     (l/og :send "about to route" )
     (routing.route pubsub/functionThatKnowsHowToRouteInAsyncWay pchannel sch)
     (l/og :send "done routing" order)





     )
