(ns leiningen.buyan
    (:require [clojure.java.io :refer [file]]
              [leiningen.new.templates :refer [renderer name-to-path ->files]]
              [leiningen.core.main :as main]
              [clojure.string :as string]
              )
    )
(def render (renderer "bframeworkapp"))

(defn bframeworkapp
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' bframeworkapp project.")
    (->files data
             ["src/{{sanitized}}/conf.cljs" (render "conf.cljs" data)]
             ["src/buaynFramework/interop.cljs" (render "interop.cljs" data)]
             ["src/buaynFramework/logger.cljs" (render "logger.cljs" data)]
             ["src/{{sanitized}}/main.cljs" (render "main.cljs" data)]
             ["src/buaynFramework/pubsub.cljs" (render "pubsub.cljs" data)]
             ["src/buaynFramework/routing.cljs" (render "routing.cljs" data)]
             ["src/buaynFramework/util.clj" (render "util.clj" data)]
             ["project.clj" (render "project.clj" data)]
             
             )))
(defn help[]
      (->> ["buyan Framework scaffolding plugin."
        ""
        "Usage: lein buyan action options name"
        ""
        "Options:"
        "module    generate or delete module"
        ""
        "Actions:"
        "  g or generate    generate component"
        "  d or delete     delete component"
        "  help   print this"
        ""
        "example"
        "lein buyan g module mymodule"
        ""
        "Please refer to the github page for more information."]
       (string/join \newline)
           println)
    )
(defn projectName[]
     (-> "./project.clj" slurp  (string/split  #"\ ") second )
    )
(defn ggenerate [name content]
    (println (projectName))
  (doto (file (projectName) "src" (str name ".cljs"))
    (-> (#(.getParentFile %1)) (#(.mkdirs %1)))
    (spit content)))
(defn generateModule[name]
    
    (case name
        nil (help)
        (do
    (main/info "Generating fresh 'lein new' bframeworkapp project.")
    (let [data {:fname name
                
              }]
    
             (ggenerate name (render "module.cljs" data))
             
             
          )
    ) ))


(defn deleteModule[name]
    (delete-file (file (projectName) "src" (str name ".cljs")))
    )

(defn generate [args]
    
    (case (first args)
      "module" (-> args rest first generateModule  )
      (help))
    )

(defn delete [args]
    (case (first args)
      "module" (-> args rest deleteModule )
      (help))
    )
(defn buyan
  "I don't do a lot."
  [project & args]
    (case (first args)
      "g" (-> args rest generate )
      "generate" (-> args rest generate )
      "d" (-> args rest delete )
      "delete" (-> args rest delete )
      (help))
    (println args)
  )
