// Compiled by ClojureScript 0.0-3308 {}
goog.provide('om_widgets.core');
goog.require('cljs.core');
goog.require('om.core');
goog.require('om.dom');
goog.require('cljsjs.react_widgets');
om_widgets.core.__GT_seq = (function om_widgets$core$__GT_seq(korks){
if(cljs.core.coll_QMARK_.call(null,korks)){
return korks;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [korks], null);
}
});
om_widgets.core._get = (function om_widgets$core$_get(m,korks){
return cljs.core.get_in.call(null,m,om_widgets.core.__GT_seq.call(null,korks));
});
om_widgets.core.find_by_key = (function om_widgets$core$find_by_key(menu,k,v){
return cljs.core.first.call(null,cljs.core.filter.call(null,(function (p1__19816_SHARP_){
return cljs.core._EQ_.call(null,v,om_widgets.core._get.call(null,p1__19816_SHARP_,k));
}),menu));
});
/**
 * Creates a dropdown component from data. Takes an opts maps with:
 * :menu-key - The korks path to the menu in data
 * :val-key - The korks path to the value in data
 * :id-key - The korks path to the id of each item in the menu
 * :label-key - The korks path to the label of each item in the menu
 * :props - A map with Js Objects to be directly fed into the React Component.
 * 
 * Ex:
 * 
 * (let [data {:colors [{:id 1 :name "red"} {:id 2 :name "blue"}]
 * :color-id 1}]
 * (om/build dropdown-list
 * data
 * {:opts {:val-key :color-id
 * :id-key :id
 * :label-key :name
 * :menu-key :colors
 * :props {:open true}}}))
 */
om_widgets.core.dropdown_list = (function om_widgets$core$dropdown_list(data,owner,p__19818){
var map__19823 = p__19818;
var map__19823__$1 = ((cljs.core.seq_QMARK_.call(null,map__19823))?cljs.core.apply.call(null,cljs.core.hash_map,map__19823):map__19823);
var val_key = cljs.core.get.call(null,map__19823__$1,new cljs.core.Keyword(null,"val-key","val-key",1135580325));
var menu_key = cljs.core.get.call(null,map__19823__$1,new cljs.core.Keyword(null,"menu-key","menu-key",1372711907));
var id_key = cljs.core.get.call(null,map__19823__$1,new cljs.core.Keyword(null,"id-key","id-key",-1881730044));
var label_key = cljs.core.get.call(null,map__19823__$1,new cljs.core.Keyword(null,"label-key","label-key",1868394642));
var props = cljs.core.get.call(null,map__19823__$1,new cljs.core.Keyword(null,"props","props",453281727));
if(typeof om_widgets.core.t19824 !== 'undefined'){
} else {

/**
* @constructor
*/
om_widgets.core.t19824 = (function (map__19823,owner,p__19818,data,props,menu_key,id_key,val_key,dropdown_list,label_key,meta19825){
this.map__19823 = map__19823;
this.owner = owner;
this.p__19818 = p__19818;
this.data = data;
this.props = props;
this.menu_key = menu_key;
this.id_key = id_key;
this.val_key = val_key;
this.dropdown_list = dropdown_list;
this.label_key = label_key;
this.meta19825 = meta19825;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
om_widgets.core.t19824.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props){
return (function (_19826,meta19825__$1){
var self__ = this;
var _19826__$1 = this;
return (new om_widgets.core.t19824(self__.map__19823,self__.owner,self__.p__19818,self__.data,self__.props,self__.menu_key,self__.id_key,self__.val_key,self__.dropdown_list,self__.label_key,meta19825__$1));
});})(map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props))
;

om_widgets.core.t19824.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props){
return (function (_19826){
var self__ = this;
var _19826__$1 = this;
return self__.meta19825;
});})(map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props))
;

om_widgets.core.t19824.prototype.om$core$IRender$ = true;

om_widgets.core.t19824.prototype.om$core$IRender$render$arity$1 = ((function (map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props){
return (function (_){
var self__ = this;
var ___$1 = this;
var menu = om_widgets.core._get.call(null,self__.data,self__.menu_key);
return React.createElement(ReactWidgets.DropdownList,cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"defaultValue","defaultValue",-586131910),om_widgets.core._get.call(null,om_widgets.core.find_by_key.call(null,menu,self__.id_key,om_widgets.core._get.call(null,self__.data,self__.val_key)),self__.label_key),new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.mapv.call(null,((function (menu,___$1,map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props){
return (function (p1__19817_SHARP_){
return om_widgets.core._get.call(null,p1__19817_SHARP_,self__.label_key);
});})(menu,___$1,map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props))
,menu),new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (menu,___$1,map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props){
return (function (new_val){
var new_id = om_widgets.core._get.call(null,om_widgets.core.find_by_key.call(null,menu,self__.label_key,new_val),self__.id_key);
return om.core.update_BANG_.call(null,self__.data,self__.val_key,new_id);
});})(menu,___$1,map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props))
], null),self__.props)));
});})(map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props))
;

om_widgets.core.t19824.getBasis = ((function (map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"map__19823","map__19823",828964513,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__19818","p__19818",-2103808379,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"props","props",2093813254,null),new cljs.core.Symbol(null,"menu-key","menu-key",-1281723862,null),new cljs.core.Symbol(null,"id-key","id-key",-241198517,null),new cljs.core.Symbol(null,"val-key","val-key",-1518855444,null),new cljs.core.Symbol(null,"dropdown-list","dropdown-list",1540932053,null),new cljs.core.Symbol(null,"label-key","label-key",-786041127,null),new cljs.core.Symbol(null,"meta19825","meta19825",-1699044547,null)], null);
});})(map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props))
;

om_widgets.core.t19824.cljs$lang$type = true;

om_widgets.core.t19824.cljs$lang$ctorStr = "om-widgets.core/t19824";

om_widgets.core.t19824.cljs$lang$ctorPrWriter = ((function (map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props){
return (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"om-widgets.core/t19824");
});})(map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props))
;

om_widgets.core.__GT_t19824 = ((function (map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props){
return (function om_widgets$core$dropdown_list_$___GT_t19824(map__19823__$2,owner__$1,p__19818__$1,data__$1,props__$1,menu_key__$1,id_key__$1,val_key__$1,dropdown_list__$1,label_key__$1,meta19825){
return (new om_widgets.core.t19824(map__19823__$2,owner__$1,p__19818__$1,data__$1,props__$1,menu_key__$1,id_key__$1,val_key__$1,dropdown_list__$1,label_key__$1,meta19825));
});})(map__19823,map__19823__$1,val_key,menu_key,id_key,label_key,props))
;

}

return (new om_widgets.core.t19824(map__19823__$1,owner,p__19818,data,props,menu_key,id_key,val_key,om_widgets$core$dropdown_list,label_key,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Creates a date picker. Takes an opts maps with:
 * :date-key - The korks path to where the selected date (a native inst)
 * should be stored.
 * :props - A map with Js Objects to be directly fed into the React Component.
 * 
 * Ex:
 * 
 * (let [data {:date {:inst (js/Date.)}}]
 * (om/build date-time-picker data {:opts {:date-key [:date :inst]}
 * :props {:time true}}))
 */
om_widgets.core.date_time_picker = (function om_widgets$core$date_time_picker(data,owner,p__19827){
var map__19832 = p__19827;
var map__19832__$1 = ((cljs.core.seq_QMARK_.call(null,map__19832))?cljs.core.apply.call(null,cljs.core.hash_map,map__19832):map__19832);
var date_key = cljs.core.get.call(null,map__19832__$1,new cljs.core.Keyword(null,"date-key","date-key",-282138560));
var props = cljs.core.get.call(null,map__19832__$1,new cljs.core.Keyword(null,"props","props",453281727));
if(typeof om_widgets.core.t19833 !== 'undefined'){
} else {

/**
* @constructor
*/
om_widgets.core.t19833 = (function (date_time_picker,data,owner,p__19827,map__19832,date_key,props,meta19834){
this.date_time_picker = date_time_picker;
this.data = data;
this.owner = owner;
this.p__19827 = p__19827;
this.map__19832 = map__19832;
this.date_key = date_key;
this.props = props;
this.meta19834 = meta19834;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
om_widgets.core.t19833.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__19832,map__19832__$1,date_key,props){
return (function (_19835,meta19834__$1){
var self__ = this;
var _19835__$1 = this;
return (new om_widgets.core.t19833(self__.date_time_picker,self__.data,self__.owner,self__.p__19827,self__.map__19832,self__.date_key,self__.props,meta19834__$1));
});})(map__19832,map__19832__$1,date_key,props))
;

om_widgets.core.t19833.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__19832,map__19832__$1,date_key,props){
return (function (_19835){
var self__ = this;
var _19835__$1 = this;
return self__.meta19834;
});})(map__19832,map__19832__$1,date_key,props))
;

om_widgets.core.t19833.prototype.om$core$IRender$ = true;

om_widgets.core.t19833.prototype.om$core$IRender$render$arity$1 = ((function (map__19832,map__19832__$1,date_key,props){
return (function (_){
var self__ = this;
var ___$1 = this;
return React.createElement(ReactWidgets.DateTimePicker,cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"time","time",1385887882),false,new cljs.core.Keyword(null,"value","value",305978217),om_widgets.core._get.call(null,self__.data,self__.date_key),new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (___$1,map__19832,map__19832__$1,date_key,props){
return (function (d,s){
return om.core.update_BANG_.call(null,self__.data,self__.date_key,d);
});})(___$1,map__19832,map__19832__$1,date_key,props))
], null),self__.props)));
});})(map__19832,map__19832__$1,date_key,props))
;

om_widgets.core.t19833.getBasis = ((function (map__19832,map__19832__$1,date_key,props){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"date-time-picker","date-time-picker",4165603,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__19827","p__19827",956887848,null),new cljs.core.Symbol(null,"map__19832","map__19832",-1760965624,null),new cljs.core.Symbol(null,"date-key","date-key",1358392967,null),new cljs.core.Symbol(null,"props","props",2093813254,null),new cljs.core.Symbol(null,"meta19834","meta19834",-1609896544,null)], null);
});})(map__19832,map__19832__$1,date_key,props))
;

om_widgets.core.t19833.cljs$lang$type = true;

om_widgets.core.t19833.cljs$lang$ctorStr = "om-widgets.core/t19833";

om_widgets.core.t19833.cljs$lang$ctorPrWriter = ((function (map__19832,map__19832__$1,date_key,props){
return (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"om-widgets.core/t19833");
});})(map__19832,map__19832__$1,date_key,props))
;

om_widgets.core.__GT_t19833 = ((function (map__19832,map__19832__$1,date_key,props){
return (function om_widgets$core$date_time_picker_$___GT_t19833(date_time_picker__$1,data__$1,owner__$1,p__19827__$1,map__19832__$2,date_key__$1,props__$1,meta19834){
return (new om_widgets.core.t19833(date_time_picker__$1,data__$1,owner__$1,p__19827__$1,map__19832__$2,date_key__$1,props__$1,meta19834));
});})(map__19832,map__19832__$1,date_key,props))
;

}

return (new om_widgets.core.t19833(om_widgets$core$date_time_picker,data,owner,p__19827,map__19832__$1,date_key,props,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Creates an autocomplete component from data. Takes an opts maps with:
 * :menu-key - The korks path to the menu in data
 * :val-key - The korks path to the value in data
 * :id-key - The korks path to the id of each item in the menu
 * :label-key - The korks path to the label of each item in the menu
 * :props - A map with Js Objects to be directly fed into the React Component.
 * 
 * Ex:
 * 
 * (let [data {:colors [{:id 1 :name "red"} {:id 2 :name "blue"}]
 * :color-id 1}]
 * (om/build autocomplete-list
 * data
 * {:opts {:val-key :color-id
 * :id-key :id
 * :label-key :name
 * :menu-key :colors
 * :props {:open true}}}))
 */
om_widgets.core.autocomplete = (function om_widgets$core$autocomplete(data,owner,p__19837){
var map__19842 = p__19837;
var map__19842__$1 = ((cljs.core.seq_QMARK_.call(null,map__19842))?cljs.core.apply.call(null,cljs.core.hash_map,map__19842):map__19842);
var menu_key = cljs.core.get.call(null,map__19842__$1,new cljs.core.Keyword(null,"menu-key","menu-key",1372711907));
var val_key = cljs.core.get.call(null,map__19842__$1,new cljs.core.Keyword(null,"val-key","val-key",1135580325));
var label_key = cljs.core.get.call(null,map__19842__$1,new cljs.core.Keyword(null,"label-key","label-key",1868394642));
var id_key = cljs.core.get.call(null,map__19842__$1,new cljs.core.Keyword(null,"id-key","id-key",-1881730044));
var props = cljs.core.get.call(null,map__19842__$1,new cljs.core.Keyword(null,"props","props",453281727));
if(typeof om_widgets.core.t19843 !== 'undefined'){
} else {

/**
* @constructor
*/
om_widgets.core.t19843 = (function (autocomplete,owner,data,map__19842,props,menu_key,id_key,val_key,p__19837,label_key,meta19844){
this.autocomplete = autocomplete;
this.owner = owner;
this.data = data;
this.map__19842 = map__19842;
this.props = props;
this.menu_key = menu_key;
this.id_key = id_key;
this.val_key = val_key;
this.p__19837 = p__19837;
this.label_key = label_key;
this.meta19844 = meta19844;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
om_widgets.core.t19843.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props){
return (function (_19845,meta19844__$1){
var self__ = this;
var _19845__$1 = this;
return (new om_widgets.core.t19843(self__.autocomplete,self__.owner,self__.data,self__.map__19842,self__.props,self__.menu_key,self__.id_key,self__.val_key,self__.p__19837,self__.label_key,meta19844__$1));
});})(map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props))
;

om_widgets.core.t19843.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props){
return (function (_19845){
var self__ = this;
var _19845__$1 = this;
return self__.meta19844;
});})(map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props))
;

om_widgets.core.t19843.prototype.om$core$IRender$ = true;

om_widgets.core.t19843.prototype.om$core$IRender$render$arity$1 = ((function (map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props){
return (function (_){
var self__ = this;
var ___$1 = this;
var menu = om_widgets.core._get.call(null,self__.data,self__.menu_key);
var labels = cljs.core.mapv.call(null,((function (menu,___$1,map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props){
return (function (p1__19836_SHARP_){
return om_widgets.core._get.call(null,p1__19836_SHARP_,self__.label_key);
});})(menu,___$1,map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props))
,menu);
return React.createElement(ReactWidgets.Combobox,cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data","data",-232669377),labels,new cljs.core.Keyword(null,"suggest","suggest",-1452198509),true,new cljs.core.Keyword(null,"onSelect","onSelect",251862405),((function (menu,labels,___$1,map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props){
return (function (new_val){
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,labels),new_val)){
var id = om_widgets.core._get.call(null,om_widgets.core.find_by_key.call(null,menu,self__.label_key,new_val),self__.id_key);
return om.core.update_BANG_.call(null,self__.data,self__.val_key,id);
} else {
return null;
}
});})(menu,labels,___$1,map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props))
], null),self__.props)));
});})(map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props))
;

om_widgets.core.t19843.getBasis = ((function (map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"autocomplete","autocomplete",-1613301856,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"map__19842","map__19842",-693040666,null),new cljs.core.Symbol(null,"props","props",2093813254,null),new cljs.core.Symbol(null,"menu-key","menu-key",-1281723862,null),new cljs.core.Symbol(null,"id-key","id-key",-241198517,null),new cljs.core.Symbol(null,"val-key","val-key",-1518855444,null),new cljs.core.Symbol(null,"p__19837","p__19837",798944499,null),new cljs.core.Symbol(null,"label-key","label-key",-786041127,null),new cljs.core.Symbol(null,"meta19844","meta19844",906223831,null)], null);
});})(map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props))
;

om_widgets.core.t19843.cljs$lang$type = true;

om_widgets.core.t19843.cljs$lang$ctorStr = "om-widgets.core/t19843";

om_widgets.core.t19843.cljs$lang$ctorPrWriter = ((function (map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props){
return (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"om-widgets.core/t19843");
});})(map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props))
;

om_widgets.core.__GT_t19843 = ((function (map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props){
return (function om_widgets$core$autocomplete_$___GT_t19843(autocomplete__$1,owner__$1,data__$1,map__19842__$2,props__$1,menu_key__$1,id_key__$1,val_key__$1,p__19837__$1,label_key__$1,meta19844){
return (new om_widgets.core.t19843(autocomplete__$1,owner__$1,data__$1,map__19842__$2,props__$1,menu_key__$1,id_key__$1,val_key__$1,p__19837__$1,label_key__$1,meta19844));
});})(map__19842,map__19842__$1,menu_key,val_key,label_key,id_key,props))
;

}

return (new om_widgets.core.t19843(om_widgets$core$autocomplete,owner,data,map__19842__$1,props,menu_key,id_key,val_key,p__19837,label_key,cljs.core.PersistentArrayMap.EMPTY));
});

//# sourceMappingURL=core.js.map?rel=1437582087238