// Compiled by ClojureScript 0.0-3308 {}
goog.provide('om_widgets.core');
goog.require('cljs.core');
goog.require('om.core');
goog.require('om.dom');
goog.require('cljsjs.react_widgets');
om_widgets.core.__GT_seq = (function om_widgets$core$__GT_seq(korks){
if(cljs.core.coll_QMARK_.call(null,korks)){
return korks;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [korks], null);
}
});
om_widgets.core._get = (function om_widgets$core$_get(m,korks){
return cljs.core.get_in.call(null,m,om_widgets.core.__GT_seq.call(null,korks));
});
om_widgets.core.find_by_key = (function om_widgets$core$find_by_key(menu,k,label){
return cljs.core.first.call(null,cljs.core.filter.call(null,(function (p1__20766_SHARP_){
return cljs.core._EQ_.call(null,label,om_widgets.core._get.call(null,p1__20766_SHARP_,k));
}),menu));
});
/**
 * Creates a dropdown component from data. Takes an opts maps with:
 * :menu-key - The korks path to the menu in data
 * :val-key - The korks path to the value in data
 * :id-key - The korks path to the id of each item in the menu
 * :label-key - The korks path to the label of each item in the menu
 * :props - A map with Js Objects to be directly fed into the React Component.
 * 
 * Ex:
 * 
 * (let [data {:colors [{:id 1 :name "red"} {:id 2 :name "blue"}]
 * :color-id 1}]
 * (om/build dropdown-list
 * data
 * {:opts {:val-key :color-id
 * :id-key :id
 * :label-key :name
 * :menu-key :colors
 * :props {:open true}}}))
 */
om_widgets.core.dropdown_list = (function om_widgets$core$dropdown_list(data,owner,p__20768){
var map__20773 = p__20768;
var map__20773__$1 = ((cljs.core.seq_QMARK_.call(null,map__20773))?cljs.core.apply.call(null,cljs.core.hash_map,map__20773):map__20773);
var val_key = cljs.core.get.call(null,map__20773__$1,new cljs.core.Keyword(null,"val-key","val-key",1135580325));
var menu_key = cljs.core.get.call(null,map__20773__$1,new cljs.core.Keyword(null,"menu-key","menu-key",1372711907));
var id_key = cljs.core.get.call(null,map__20773__$1,new cljs.core.Keyword(null,"id-key","id-key",-1881730044));
var label_key = cljs.core.get.call(null,map__20773__$1,new cljs.core.Keyword(null,"label-key","label-key",1868394642));
var props = cljs.core.get.call(null,map__20773__$1,new cljs.core.Keyword(null,"props","props",453281727));
if(typeof om_widgets.core.t20774 !== 'undefined'){
} else {

/**
* @constructor
*/
om_widgets.core.t20774 = (function (owner,data,props,map__20773,menu_key,id_key,val_key,p__20768,dropdown_list,label_key,meta20775){
this.owner = owner;
this.data = data;
this.props = props;
this.map__20773 = map__20773;
this.menu_key = menu_key;
this.id_key = id_key;
this.val_key = val_key;
this.p__20768 = p__20768;
this.dropdown_list = dropdown_list;
this.label_key = label_key;
this.meta20775 = meta20775;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
om_widgets.core.t20774.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props){
return (function (_20776,meta20775__$1){
var self__ = this;
var _20776__$1 = this;
return (new om_widgets.core.t20774(self__.owner,self__.data,self__.props,self__.map__20773,self__.menu_key,self__.id_key,self__.val_key,self__.p__20768,self__.dropdown_list,self__.label_key,meta20775__$1));
});})(map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props))
;

om_widgets.core.t20774.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props){
return (function (_20776){
var self__ = this;
var _20776__$1 = this;
return self__.meta20775;
});})(map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props))
;

om_widgets.core.t20774.prototype.om$core$IRender$ = true;

om_widgets.core.t20774.prototype.om$core$IRender$render$arity$1 = ((function (map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props){
return (function (_){
var self__ = this;
var ___$1 = this;
var menu = om_widgets.core._get.call(null,self__.data,self__.menu_key);
return React.createElement(ReactWidgets.DropdownList,cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"defaultValue","defaultValue",-586131910),om_widgets.core._get.call(null,om_widgets.core.find_by_key.call(null,menu,self__.id_key,om_widgets.core._get.call(null,self__.data,self__.val_key)),self__.label_key),new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.mapv.call(null,((function (menu,___$1,map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props){
return (function (p1__20767_SHARP_){
return om_widgets.core._get.call(null,p1__20767_SHARP_,self__.label_key);
});})(menu,___$1,map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props))
,menu),new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (menu,___$1,map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props){
return (function (new_val){
var new_id = om_widgets.core._get.call(null,om_widgets.core.find_by_key.call(null,menu,self__.label_key,new_val),self__.id_key);
return om.core.update_BANG_.call(null,self__.data,self__.val_key,new_id);
});})(menu,___$1,map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props))
], null),self__.props)));
});})(map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props))
;

om_widgets.core.t20774.getBasis = ((function (map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"props","props",2093813254,null),new cljs.core.Symbol(null,"map__20773","map__20773",-26928410,null),new cljs.core.Symbol(null,"menu-key","menu-key",-1281723862,null),new cljs.core.Symbol(null,"id-key","id-key",-241198517,null),new cljs.core.Symbol(null,"val-key","val-key",-1518855444,null),new cljs.core.Symbol(null,"p__20768","p__20768",-10651213,null),new cljs.core.Symbol(null,"dropdown-list","dropdown-list",1540932053,null),new cljs.core.Symbol(null,"label-key","label-key",-786041127,null),new cljs.core.Symbol(null,"meta20775","meta20775",-80056580,null)], null);
});})(map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props))
;

om_widgets.core.t20774.cljs$lang$type = true;

om_widgets.core.t20774.cljs$lang$ctorStr = "om-widgets.core/t20774";

om_widgets.core.t20774.cljs$lang$ctorPrWriter = ((function (map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props){
return (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"om-widgets.core/t20774");
});})(map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props))
;

om_widgets.core.__GT_t20774 = ((function (map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props){
return (function om_widgets$core$dropdown_list_$___GT_t20774(owner__$1,data__$1,props__$1,map__20773__$2,menu_key__$1,id_key__$1,val_key__$1,p__20768__$1,dropdown_list__$1,label_key__$1,meta20775){
return (new om_widgets.core.t20774(owner__$1,data__$1,props__$1,map__20773__$2,menu_key__$1,id_key__$1,val_key__$1,p__20768__$1,dropdown_list__$1,label_key__$1,meta20775));
});})(map__20773,map__20773__$1,val_key,menu_key,id_key,label_key,props))
;

}

return (new om_widgets.core.t20774(owner,data,props,map__20773__$1,menu_key,id_key,val_key,p__20768,om_widgets$core$dropdown_list,label_key,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Creates a date picker. Takes an opts maps with:
 * :date-key - The korks path to where the selected date (a native inst)
 * should be stored.
 * :props - A map with Js Objects to be directly fed into the React Component.
 * 
 * Ex:
 * 
 * (let [data {:date {:inst (js/Date.)}}]
 * (om/build date-time-picker data {:opts {:date-key [:date :inst]}
 * :props {:time true}}))
 */
om_widgets.core.date_time_picker = (function om_widgets$core$date_time_picker(data,owner,p__20777){
var map__20782 = p__20777;
var map__20782__$1 = ((cljs.core.seq_QMARK_.call(null,map__20782))?cljs.core.apply.call(null,cljs.core.hash_map,map__20782):map__20782);
var date_key = cljs.core.get.call(null,map__20782__$1,new cljs.core.Keyword(null,"date-key","date-key",-282138560));
var props = cljs.core.get.call(null,map__20782__$1,new cljs.core.Keyword(null,"props","props",453281727));
if(typeof om_widgets.core.t20783 !== 'undefined'){
} else {

/**
* @constructor
*/
om_widgets.core.t20783 = (function (date_time_picker,data,owner,p__20777,map__20782,date_key,props,meta20784){
this.date_time_picker = date_time_picker;
this.data = data;
this.owner = owner;
this.p__20777 = p__20777;
this.map__20782 = map__20782;
this.date_key = date_key;
this.props = props;
this.meta20784 = meta20784;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
om_widgets.core.t20783.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__20782,map__20782__$1,date_key,props){
return (function (_20785,meta20784__$1){
var self__ = this;
var _20785__$1 = this;
return (new om_widgets.core.t20783(self__.date_time_picker,self__.data,self__.owner,self__.p__20777,self__.map__20782,self__.date_key,self__.props,meta20784__$1));
});})(map__20782,map__20782__$1,date_key,props))
;

om_widgets.core.t20783.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__20782,map__20782__$1,date_key,props){
return (function (_20785){
var self__ = this;
var _20785__$1 = this;
return self__.meta20784;
});})(map__20782,map__20782__$1,date_key,props))
;

om_widgets.core.t20783.prototype.om$core$IRender$ = true;

om_widgets.core.t20783.prototype.om$core$IRender$render$arity$1 = ((function (map__20782,map__20782__$1,date_key,props){
return (function (_){
var self__ = this;
var ___$1 = this;
return React.createElement(ReactWidgets.DateTimePicker,cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"time","time",1385887882),false,new cljs.core.Keyword(null,"value","value",305978217),om_widgets.core._get.call(null,self__.data,self__.date_key),new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (___$1,map__20782,map__20782__$1,date_key,props){
return (function (d,s){
return om.core.update_BANG_.call(null,self__.data,self__.date_key,d);
});})(___$1,map__20782,map__20782__$1,date_key,props))
], null),self__.props)));
});})(map__20782,map__20782__$1,date_key,props))
;

om_widgets.core.t20783.getBasis = ((function (map__20782,map__20782__$1,date_key,props){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"date-time-picker","date-time-picker",4165603,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__20777","p__20777",1657990329,null),new cljs.core.Symbol(null,"map__20782","map__20782",-1599194519,null),new cljs.core.Symbol(null,"date-key","date-key",1358392967,null),new cljs.core.Symbol(null,"props","props",2093813254,null),new cljs.core.Symbol(null,"meta20784","meta20784",114509685,null)], null);
});})(map__20782,map__20782__$1,date_key,props))
;

om_widgets.core.t20783.cljs$lang$type = true;

om_widgets.core.t20783.cljs$lang$ctorStr = "om-widgets.core/t20783";

om_widgets.core.t20783.cljs$lang$ctorPrWriter = ((function (map__20782,map__20782__$1,date_key,props){
return (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"om-widgets.core/t20783");
});})(map__20782,map__20782__$1,date_key,props))
;

om_widgets.core.__GT_t20783 = ((function (map__20782,map__20782__$1,date_key,props){
return (function om_widgets$core$date_time_picker_$___GT_t20783(date_time_picker__$1,data__$1,owner__$1,p__20777__$1,map__20782__$2,date_key__$1,props__$1,meta20784){
return (new om_widgets.core.t20783(date_time_picker__$1,data__$1,owner__$1,p__20777__$1,map__20782__$2,date_key__$1,props__$1,meta20784));
});})(map__20782,map__20782__$1,date_key,props))
;

}

return (new om_widgets.core.t20783(om_widgets$core$date_time_picker,data,owner,p__20777,map__20782__$1,date_key,props,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Creates an autocomplete component from data. Takes an opts maps with:
 * :menu-key - The korks path to the menu in data
 * :val-key - The korks path to the value in data
 * :id-key - The korks path to the id of each item in the menu
 * :label-key - The korks path to the label of each item in the menu
 * :props - A map with Js Objects to be directly fed into the React Component.
 * 
 * Ex:
 * 
 * (let [data {:colors [{:id 1 :name "red"} {:id 2 :name "blue"}]
 * :color-id 1}]
 * (om/build autocomplete-list
 * data
 * {:opts {:val-key :color-id
 * :id-key :id
 * :label-key :name
 * :menu-key :colors
 * :props {:open true}}}))
 */
om_widgets.core.autocomplete = (function om_widgets$core$autocomplete(data,owner,p__20787){
var map__20792 = p__20787;
var map__20792__$1 = ((cljs.core.seq_QMARK_.call(null,map__20792))?cljs.core.apply.call(null,cljs.core.hash_map,map__20792):map__20792);
var menu_key = cljs.core.get.call(null,map__20792__$1,new cljs.core.Keyword(null,"menu-key","menu-key",1372711907));
var val_key = cljs.core.get.call(null,map__20792__$1,new cljs.core.Keyword(null,"val-key","val-key",1135580325));
var label_key = cljs.core.get.call(null,map__20792__$1,new cljs.core.Keyword(null,"label-key","label-key",1868394642));
var id_key = cljs.core.get.call(null,map__20792__$1,new cljs.core.Keyword(null,"id-key","id-key",-1881730044));
var props = cljs.core.get.call(null,map__20792__$1,new cljs.core.Keyword(null,"props","props",453281727));
if(typeof om_widgets.core.t20793 !== 'undefined'){
} else {

/**
* @constructor
*/
om_widgets.core.t20793 = (function (autocomplete,owner,p__20787,data,props,menu_key,id_key,val_key,label_key,map__20792,meta20794){
this.autocomplete = autocomplete;
this.owner = owner;
this.p__20787 = p__20787;
this.data = data;
this.props = props;
this.menu_key = menu_key;
this.id_key = id_key;
this.val_key = val_key;
this.label_key = label_key;
this.map__20792 = map__20792;
this.meta20794 = meta20794;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
om_widgets.core.t20793.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props){
return (function (_20795,meta20794__$1){
var self__ = this;
var _20795__$1 = this;
return (new om_widgets.core.t20793(self__.autocomplete,self__.owner,self__.p__20787,self__.data,self__.props,self__.menu_key,self__.id_key,self__.val_key,self__.label_key,self__.map__20792,meta20794__$1));
});})(map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props))
;

om_widgets.core.t20793.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props){
return (function (_20795){
var self__ = this;
var _20795__$1 = this;
return self__.meta20794;
});})(map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props))
;

om_widgets.core.t20793.prototype.om$core$IRender$ = true;

om_widgets.core.t20793.prototype.om$core$IRender$render$arity$1 = ((function (map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props){
return (function (_){
var self__ = this;
var ___$1 = this;
var menu = om_widgets.core._get.call(null,self__.data,self__.menu_key);
var labels = cljs.core.mapv.call(null,((function (menu,___$1,map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props){
return (function (p1__20786_SHARP_){
return om_widgets.core._get.call(null,p1__20786_SHARP_,self__.label_key);
});})(menu,___$1,map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props))
,menu);
return React.createElement(ReactWidgets.Combobox,cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data","data",-232669377),labels,new cljs.core.Keyword(null,"suggest","suggest",-1452198509),true,new cljs.core.Keyword(null,"onSelect","onSelect",251862405),((function (menu,labels,___$1,map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props){
return (function (new_val){
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,labels),new_val)){
var id = om_widgets.core._get.call(null,om_widgets.core.find_by_key.call(null,menu,self__.label_key,new_val),self__.id_key);
return om.core.update_BANG_.call(null,self__.data,self__.val_key,id);
} else {
return null;
}
});})(menu,labels,___$1,map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props))
], null),self__.props)));
});})(map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props))
;

om_widgets.core.t20793.getBasis = ((function (map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"autocomplete","autocomplete",-1613301856,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__20787","p__20787",715675621,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"props","props",2093813254,null),new cljs.core.Symbol(null,"menu-key","menu-key",-1281723862,null),new cljs.core.Symbol(null,"id-key","id-key",-241198517,null),new cljs.core.Symbol(null,"val-key","val-key",-1518855444,null),new cljs.core.Symbol(null,"label-key","label-key",-786041127,null),new cljs.core.Symbol(null,"map__20792","map__20792",-307172902,null),new cljs.core.Symbol(null,"meta20794","meta20794",385836927,null)], null);
});})(map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props))
;

om_widgets.core.t20793.cljs$lang$type = true;

om_widgets.core.t20793.cljs$lang$ctorStr = "om-widgets.core/t20793";

om_widgets.core.t20793.cljs$lang$ctorPrWriter = ((function (map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props){
return (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"om-widgets.core/t20793");
});})(map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props))
;

om_widgets.core.__GT_t20793 = ((function (map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props){
return (function om_widgets$core$autocomplete_$___GT_t20793(autocomplete__$1,owner__$1,p__20787__$1,data__$1,props__$1,menu_key__$1,id_key__$1,val_key__$1,label_key__$1,map__20792__$2,meta20794){
return (new om_widgets.core.t20793(autocomplete__$1,owner__$1,p__20787__$1,data__$1,props__$1,menu_key__$1,id_key__$1,val_key__$1,label_key__$1,map__20792__$2,meta20794));
});})(map__20792,map__20792__$1,menu_key,val_key,label_key,id_key,props))
;

}

return (new om_widgets.core.t20793(om_widgets$core$autocomplete,owner,p__20787,data,props,menu_key,id_key,val_key,label_key,map__20792__$1,cljs.core.PersistentArrayMap.EMPTY));
});

//# sourceMappingURL=core.js.map?rel=1437498750646