// Compiled by ClojureScript 0.0-3308 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t28081 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t28081 = (function (fn_handler,f,meta28082){
this.fn_handler = fn_handler;
this.f = f;
this.meta28082 = meta28082;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t28081.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28083,meta28082__$1){
var self__ = this;
var _28083__$1 = this;
return (new cljs.core.async.t28081(self__.fn_handler,self__.f,meta28082__$1));
});

cljs.core.async.t28081.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28083){
var self__ = this;
var _28083__$1 = this;
return self__.meta28082;
});

cljs.core.async.t28081.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t28081.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t28081.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t28081.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta28082","meta28082",-82583147,null)], null);
});

cljs.core.async.t28081.cljs$lang$type = true;

cljs.core.async.t28081.cljs$lang$ctorStr = "cljs.core.async/t28081";

cljs.core.async.t28081.cljs$lang$ctorPrWriter = (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"cljs.core.async/t28081");
});

cljs.core.async.__GT_t28081 = (function cljs$core$async$fn_handler_$___GT_t28081(fn_handler__$1,f__$1,meta28082){
return (new cljs.core.async.t28081(fn_handler__$1,f__$1,meta28082));
});

}

return (new cljs.core.async.t28081(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
var G__28089 = buff;
if(G__28089){
var bit__16783__auto__ = null;
if(cljs.core.truth_((function (){var or__16109__auto__ = bit__16783__auto__;
if(cljs.core.truth_(or__16109__auto__)){
return or__16109__auto__;
} else {
return G__28089.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})())){
return true;
} else {
if((!G__28089.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__28089);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__28089);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var G__28091 = arguments.length;
switch (G__28091) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var G__28100 = arguments.length;
switch (G__28100) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_28102 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_28102);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_28102,ret){
return (function (){
return fn1.call(null,val_28102);
});})(val_28102,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var G__28106 = arguments.length;
switch (G__28106) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__16994__auto___28113 = n;
var x_28114 = (0);
while(true){
if((x_28114 < n__16994__auto___28113)){
(a[x_28114] = (0));

var G__28115 = (x_28114 + (1));
x_28114 = G__28115;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__28116 = (i + (1));
i = G__28116;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t28120 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t28120 = (function (alt_flag,flag,meta28121){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta28121 = meta28121;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t28120.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_28122,meta28121__$1){
var self__ = this;
var _28122__$1 = this;
return (new cljs.core.async.t28120(self__.alt_flag,self__.flag,meta28121__$1));
});})(flag))
;

cljs.core.async.t28120.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_28122){
var self__ = this;
var _28122__$1 = this;
return self__.meta28121;
});})(flag))
;

cljs.core.async.t28120.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t28120.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t28120.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t28120.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta28121","meta28121",-894546281,null)], null);
});})(flag))
;

cljs.core.async.t28120.cljs$lang$type = true;

cljs.core.async.t28120.cljs$lang$ctorStr = "cljs.core.async/t28120";

cljs.core.async.t28120.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"cljs.core.async/t28120");
});})(flag))
;

cljs.core.async.__GT_t28120 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t28120(alt_flag__$1,flag__$1,meta28121){
return (new cljs.core.async.t28120(alt_flag__$1,flag__$1,meta28121));
});})(flag))
;

}

return (new cljs.core.async.t28120(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t28138 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t28138 = (function (alt_handler,flag,cb,meta28139){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta28139 = meta28139;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t28138.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28140,meta28139__$1){
var self__ = this;
var _28140__$1 = this;
return (new cljs.core.async.t28138(self__.alt_handler,self__.flag,self__.cb,meta28139__$1));
});

cljs.core.async.t28138.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28140){
var self__ = this;
var _28140__$1 = this;
return self__.meta28139;
});

cljs.core.async.t28138.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t28138.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t28138.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t28138.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta28139","meta28139",-1139488066,null)], null);
});

cljs.core.async.t28138.cljs$lang$type = true;

cljs.core.async.t28138.cljs$lang$ctorStr = "cljs.core.async/t28138";

cljs.core.async.t28138.cljs$lang$ctorPrWriter = (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"cljs.core.async/t28138");
});

cljs.core.async.__GT_t28138 = (function cljs$core$async$alt_handler_$___GT_t28138(alt_handler__$1,flag__$1,cb__$1,meta28139){
return (new cljs.core.async.t28138(alt_handler__$1,flag__$1,cb__$1,meta28139));
});

}

return (new cljs.core.async.t28138(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28153_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28153_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28154_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28154_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__16109__auto__ = wport;
if(cljs.core.truth_(or__16109__auto__)){
return or__16109__auto__;
} else {
return port;
}
})()], null));
} else {
var G__28174 = (i + (1));
i = G__28174;
continue;
}
} else {
return null;
}
break;
}
})();
var or__16109__auto__ = ret;
if(cljs.core.truth_(or__16109__auto__)){
return or__16109__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__16097__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__16097__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__16097__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var argseq__17149__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17149__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__28179){
var map__28180 = p__28179;
var map__28180__$1 = ((cljs.core.seq_QMARK_.call(null,map__28180))?cljs.core.apply.call(null,cljs.core.hash_map,map__28180):map__28180);
var opts = map__28180__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq28175){
var G__28176 = cljs.core.first.call(null,seq28175);
var seq28175__$1 = cljs.core.next.call(null,seq28175);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28176,seq28175__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var G__28185 = arguments.length;
switch (G__28185) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__20380__auto___28244 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto___28244){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto___28244){
return (function (state_28209){
var state_val_28210 = (state_28209[(1)]);
if((state_val_28210 === (7))){
var inst_28205 = (state_28209[(2)]);
var state_28209__$1 = state_28209;
var statearr_28211_28245 = state_28209__$1;
(statearr_28211_28245[(2)] = inst_28205);

(statearr_28211_28245[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28210 === (1))){
var state_28209__$1 = state_28209;
var statearr_28212_28246 = state_28209__$1;
(statearr_28212_28246[(2)] = null);

(statearr_28212_28246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28210 === (4))){
var inst_28188 = (state_28209[(7)]);
var inst_28188__$1 = (state_28209[(2)]);
var inst_28189 = (inst_28188__$1 == null);
var state_28209__$1 = (function (){var statearr_28215 = state_28209;
(statearr_28215[(7)] = inst_28188__$1);

return statearr_28215;
})();
if(cljs.core.truth_(inst_28189)){
var statearr_28216_28250 = state_28209__$1;
(statearr_28216_28250[(1)] = (5));

} else {
var statearr_28217_28252 = state_28209__$1;
(statearr_28217_28252[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28210 === (13))){
var state_28209__$1 = state_28209;
var statearr_28218_28253 = state_28209__$1;
(statearr_28218_28253[(2)] = null);

(statearr_28218_28253[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28210 === (6))){
var inst_28188 = (state_28209[(7)]);
var state_28209__$1 = state_28209;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28209__$1,(11),to,inst_28188);
} else {
if((state_val_28210 === (3))){
var inst_28207 = (state_28209[(2)]);
var state_28209__$1 = state_28209;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28209__$1,inst_28207);
} else {
if((state_val_28210 === (12))){
var state_28209__$1 = state_28209;
var statearr_28221_28255 = state_28209__$1;
(statearr_28221_28255[(2)] = null);

(statearr_28221_28255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28210 === (2))){
var state_28209__$1 = state_28209;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28209__$1,(4),from);
} else {
if((state_val_28210 === (11))){
var inst_28198 = (state_28209[(2)]);
var state_28209__$1 = state_28209;
if(cljs.core.truth_(inst_28198)){
var statearr_28222_28256 = state_28209__$1;
(statearr_28222_28256[(1)] = (12));

} else {
var statearr_28223_28257 = state_28209__$1;
(statearr_28223_28257[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28210 === (9))){
var state_28209__$1 = state_28209;
var statearr_28224_28258 = state_28209__$1;
(statearr_28224_28258[(2)] = null);

(statearr_28224_28258[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28210 === (5))){
var state_28209__$1 = state_28209;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28227_28259 = state_28209__$1;
(statearr_28227_28259[(1)] = (8));

} else {
var statearr_28228_28260 = state_28209__$1;
(statearr_28228_28260[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28210 === (14))){
var inst_28203 = (state_28209[(2)]);
var state_28209__$1 = state_28209;
var statearr_28229_28261 = state_28209__$1;
(statearr_28229_28261[(2)] = inst_28203);

(statearr_28229_28261[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28210 === (10))){
var inst_28195 = (state_28209[(2)]);
var state_28209__$1 = state_28209;
var statearr_28231_28262 = state_28209__$1;
(statearr_28231_28262[(2)] = inst_28195);

(statearr_28231_28262[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28210 === (8))){
var inst_28192 = cljs.core.async.close_BANG_.call(null,to);
var state_28209__$1 = state_28209;
var statearr_28232_28263 = state_28209__$1;
(statearr_28232_28263[(2)] = inst_28192);

(statearr_28232_28263[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto___28244))
;
return ((function (switch__20318__auto__,c__20380__auto___28244){
return (function() {
var cljs$core$async$state_machine__20319__auto__ = null;
var cljs$core$async$state_machine__20319__auto____0 = (function (){
var statearr_28237 = [null,null,null,null,null,null,null,null];
(statearr_28237[(0)] = cljs$core$async$state_machine__20319__auto__);

(statearr_28237[(1)] = (1));

return statearr_28237;
});
var cljs$core$async$state_machine__20319__auto____1 = (function (state_28209){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_28209);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e28238){if((e28238 instanceof Object)){
var ex__20322__auto__ = e28238;
var statearr_28239_28264 = state_28209;
(statearr_28239_28264[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28209);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28238;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28267 = state_28209;
state_28209 = G__28267;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$state_machine__20319__auto__ = function(state_28209){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20319__auto____1.call(this,state_28209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20319__auto____0;
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20319__auto____1;
return cljs$core$async$state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto___28244))
})();
var state__20382__auto__ = (function (){var statearr_28242 = f__20381__auto__.call(null);
(statearr_28242[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___28244);

return statearr_28242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto___28244))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__28496){
var vec__28497 = p__28496;
var v = cljs.core.nth.call(null,vec__28497,(0),null);
var p = cljs.core.nth.call(null,vec__28497,(1),null);
var job = vec__28497;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__20380__auto___28711 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto___28711,res,vec__28497,v,p,job,jobs,results){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto___28711,res,vec__28497,v,p,job,jobs,results){
return (function (state_28502){
var state_val_28503 = (state_28502[(1)]);
if((state_val_28503 === (1))){
var state_28502__$1 = state_28502;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28502__$1,(2),res,v);
} else {
if((state_val_28503 === (2))){
var inst_28499 = (state_28502[(2)]);
var inst_28500 = cljs.core.async.close_BANG_.call(null,res);
var state_28502__$1 = (function (){var statearr_28504 = state_28502;
(statearr_28504[(7)] = inst_28499);

return statearr_28504;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28502__$1,inst_28500);
} else {
return null;
}
}
});})(c__20380__auto___28711,res,vec__28497,v,p,job,jobs,results))
;
return ((function (switch__20318__auto__,c__20380__auto___28711,res,vec__28497,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____0 = (function (){
var statearr_28510 = [null,null,null,null,null,null,null,null];
(statearr_28510[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__);

(statearr_28510[(1)] = (1));

return statearr_28510;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____1 = (function (state_28502){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_28502);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e28512){if((e28512 instanceof Object)){
var ex__20322__auto__ = e28512;
var statearr_28513_28720 = state_28502;
(statearr_28513_28720[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28502);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28512;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28722 = state_28502;
state_28502 = G__28722;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__ = function(state_28502){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____1.call(this,state_28502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto___28711,res,vec__28497,v,p,job,jobs,results))
})();
var state__20382__auto__ = (function (){var statearr_28515 = f__20381__auto__.call(null);
(statearr_28515[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___28711);

return statearr_28515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto___28711,res,vec__28497,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__28516){
var vec__28517 = p__28516;
var v = cljs.core.nth.call(null,vec__28517,(0),null);
var p = cljs.core.nth.call(null,vec__28517,(1),null);
var job = vec__28517;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__16994__auto___28726 = n;
var __28730 = (0);
while(true){
if((__28730 < n__16994__auto___28726)){
var G__28518_28731 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__28518_28731) {
case "compute":
var c__20380__auto___28735 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__28730,c__20380__auto___28735,G__28518_28731,n__16994__auto___28726,jobs,results,process,async){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (__28730,c__20380__auto___28735,G__28518_28731,n__16994__auto___28726,jobs,results,process,async){
return (function (state_28534){
var state_val_28535 = (state_28534[(1)]);
if((state_val_28535 === (1))){
var state_28534__$1 = state_28534;
var statearr_28538_28736 = state_28534__$1;
(statearr_28538_28736[(2)] = null);

(statearr_28538_28736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (2))){
var state_28534__$1 = state_28534;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28534__$1,(4),jobs);
} else {
if((state_val_28535 === (3))){
var inst_28532 = (state_28534[(2)]);
var state_28534__$1 = state_28534;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28534__$1,inst_28532);
} else {
if((state_val_28535 === (4))){
var inst_28521 = (state_28534[(2)]);
var inst_28522 = process.call(null,inst_28521);
var state_28534__$1 = state_28534;
if(cljs.core.truth_(inst_28522)){
var statearr_28539_28742 = state_28534__$1;
(statearr_28539_28742[(1)] = (5));

} else {
var statearr_28540_28743 = state_28534__$1;
(statearr_28540_28743[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (5))){
var state_28534__$1 = state_28534;
var statearr_28541_28744 = state_28534__$1;
(statearr_28541_28744[(2)] = null);

(statearr_28541_28744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (6))){
var state_28534__$1 = state_28534;
var statearr_28542_28745 = state_28534__$1;
(statearr_28542_28745[(2)] = null);

(statearr_28542_28745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (7))){
var inst_28530 = (state_28534[(2)]);
var state_28534__$1 = state_28534;
var statearr_28543_28746 = state_28534__$1;
(statearr_28543_28746[(2)] = inst_28530);

(statearr_28543_28746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__28730,c__20380__auto___28735,G__28518_28731,n__16994__auto___28726,jobs,results,process,async))
;
return ((function (__28730,switch__20318__auto__,c__20380__auto___28735,G__28518_28731,n__16994__auto___28726,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____0 = (function (){
var statearr_28550 = [null,null,null,null,null,null,null];
(statearr_28550[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__);

(statearr_28550[(1)] = (1));

return statearr_28550;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____1 = (function (state_28534){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_28534);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e28551){if((e28551 instanceof Object)){
var ex__20322__auto__ = e28551;
var statearr_28552_28749 = state_28534;
(statearr_28552_28749[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28534);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28551;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28751 = state_28534;
state_28534 = G__28751;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__ = function(state_28534){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____1.call(this,state_28534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__;
})()
;})(__28730,switch__20318__auto__,c__20380__auto___28735,G__28518_28731,n__16994__auto___28726,jobs,results,process,async))
})();
var state__20382__auto__ = (function (){var statearr_28555 = f__20381__auto__.call(null);
(statearr_28555[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___28735);

return statearr_28555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(__28730,c__20380__auto___28735,G__28518_28731,n__16994__auto___28726,jobs,results,process,async))
);


break;
case "async":
var c__20380__auto___28754 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__28730,c__20380__auto___28754,G__28518_28731,n__16994__auto___28726,jobs,results,process,async){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (__28730,c__20380__auto___28754,G__28518_28731,n__16994__auto___28726,jobs,results,process,async){
return (function (state_28568){
var state_val_28569 = (state_28568[(1)]);
if((state_val_28569 === (1))){
var state_28568__$1 = state_28568;
var statearr_28570_28757 = state_28568__$1;
(statearr_28570_28757[(2)] = null);

(statearr_28570_28757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28569 === (2))){
var state_28568__$1 = state_28568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28568__$1,(4),jobs);
} else {
if((state_val_28569 === (3))){
var inst_28566 = (state_28568[(2)]);
var state_28568__$1 = state_28568;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28568__$1,inst_28566);
} else {
if((state_val_28569 === (4))){
var inst_28558 = (state_28568[(2)]);
var inst_28559 = async.call(null,inst_28558);
var state_28568__$1 = state_28568;
if(cljs.core.truth_(inst_28559)){
var statearr_28571_28760 = state_28568__$1;
(statearr_28571_28760[(1)] = (5));

} else {
var statearr_28572_28762 = state_28568__$1;
(statearr_28572_28762[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28569 === (5))){
var state_28568__$1 = state_28568;
var statearr_28573_28764 = state_28568__$1;
(statearr_28573_28764[(2)] = null);

(statearr_28573_28764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28569 === (6))){
var state_28568__$1 = state_28568;
var statearr_28574_28765 = state_28568__$1;
(statearr_28574_28765[(2)] = null);

(statearr_28574_28765[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28569 === (7))){
var inst_28564 = (state_28568[(2)]);
var state_28568__$1 = state_28568;
var statearr_28575_28766 = state_28568__$1;
(statearr_28575_28766[(2)] = inst_28564);

(statearr_28575_28766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__28730,c__20380__auto___28754,G__28518_28731,n__16994__auto___28726,jobs,results,process,async))
;
return ((function (__28730,switch__20318__auto__,c__20380__auto___28754,G__28518_28731,n__16994__auto___28726,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____0 = (function (){
var statearr_28579 = [null,null,null,null,null,null,null];
(statearr_28579[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__);

(statearr_28579[(1)] = (1));

return statearr_28579;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____1 = (function (state_28568){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_28568);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e28580){if((e28580 instanceof Object)){
var ex__20322__auto__ = e28580;
var statearr_28581_28774 = state_28568;
(statearr_28581_28774[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28568);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28580;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28778 = state_28568;
state_28568 = G__28778;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__ = function(state_28568){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____1.call(this,state_28568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__;
})()
;})(__28730,switch__20318__auto__,c__20380__auto___28754,G__28518_28731,n__16994__auto___28726,jobs,results,process,async))
})();
var state__20382__auto__ = (function (){var statearr_28582 = f__20381__auto__.call(null);
(statearr_28582[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___28754);

return statearr_28582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(__28730,c__20380__auto___28754,G__28518_28731,n__16994__auto___28726,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__28781 = (__28730 + (1));
__28730 = G__28781;
continue;
} else {
}
break;
}

var c__20380__auto___28784 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto___28784,jobs,results,process,async){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto___28784,jobs,results,process,async){
return (function (state_28606){
var state_val_28607 = (state_28606[(1)]);
if((state_val_28607 === (1))){
var state_28606__$1 = state_28606;
var statearr_28608_28787 = state_28606__$1;
(statearr_28608_28787[(2)] = null);

(statearr_28608_28787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28607 === (2))){
var state_28606__$1 = state_28606;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28606__$1,(4),from);
} else {
if((state_val_28607 === (3))){
var inst_28604 = (state_28606[(2)]);
var state_28606__$1 = state_28606;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28606__$1,inst_28604);
} else {
if((state_val_28607 === (4))){
var inst_28585 = (state_28606[(7)]);
var inst_28585__$1 = (state_28606[(2)]);
var inst_28588 = (inst_28585__$1 == null);
var state_28606__$1 = (function (){var statearr_28610 = state_28606;
(statearr_28610[(7)] = inst_28585__$1);

return statearr_28610;
})();
if(cljs.core.truth_(inst_28588)){
var statearr_28611_28790 = state_28606__$1;
(statearr_28611_28790[(1)] = (5));

} else {
var statearr_28612_28791 = state_28606__$1;
(statearr_28612_28791[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28607 === (5))){
var inst_28590 = cljs.core.async.close_BANG_.call(null,jobs);
var state_28606__$1 = state_28606;
var statearr_28613_28792 = state_28606__$1;
(statearr_28613_28792[(2)] = inst_28590);

(statearr_28613_28792[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28607 === (6))){
var inst_28592 = (state_28606[(8)]);
var inst_28585 = (state_28606[(7)]);
var inst_28592__$1 = cljs.core.async.chan.call(null,(1));
var inst_28593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28594 = [inst_28585,inst_28592__$1];
var inst_28595 = (new cljs.core.PersistentVector(null,2,(5),inst_28593,inst_28594,null));
var state_28606__$1 = (function (){var statearr_28615 = state_28606;
(statearr_28615[(8)] = inst_28592__$1);

return statearr_28615;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28606__$1,(8),jobs,inst_28595);
} else {
if((state_val_28607 === (7))){
var inst_28602 = (state_28606[(2)]);
var state_28606__$1 = state_28606;
var statearr_28617_28797 = state_28606__$1;
(statearr_28617_28797[(2)] = inst_28602);

(statearr_28617_28797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28607 === (8))){
var inst_28592 = (state_28606[(8)]);
var inst_28597 = (state_28606[(2)]);
var state_28606__$1 = (function (){var statearr_28618 = state_28606;
(statearr_28618[(9)] = inst_28597);

return statearr_28618;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28606__$1,(9),results,inst_28592);
} else {
if((state_val_28607 === (9))){
var inst_28599 = (state_28606[(2)]);
var state_28606__$1 = (function (){var statearr_28619 = state_28606;
(statearr_28619[(10)] = inst_28599);

return statearr_28619;
})();
var statearr_28620_28800 = state_28606__$1;
(statearr_28620_28800[(2)] = null);

(statearr_28620_28800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__20380__auto___28784,jobs,results,process,async))
;
return ((function (switch__20318__auto__,c__20380__auto___28784,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____0 = (function (){
var statearr_28624 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28624[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__);

(statearr_28624[(1)] = (1));

return statearr_28624;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____1 = (function (state_28606){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_28606);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e28625){if((e28625 instanceof Object)){
var ex__20322__auto__ = e28625;
var statearr_28626_28804 = state_28606;
(statearr_28626_28804[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28606);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28625;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28807 = state_28606;
state_28606 = G__28807;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__ = function(state_28606){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____1.call(this,state_28606);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto___28784,jobs,results,process,async))
})();
var state__20382__auto__ = (function (){var statearr_28628 = f__20381__auto__.call(null);
(statearr_28628[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___28784);

return statearr_28628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto___28784,jobs,results,process,async))
);


var c__20380__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto__,jobs,results,process,async){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto__,jobs,results,process,async){
return (function (state_28668){
var state_val_28669 = (state_28668[(1)]);
if((state_val_28669 === (7))){
var inst_28664 = (state_28668[(2)]);
var state_28668__$1 = state_28668;
var statearr_28670_28810 = state_28668__$1;
(statearr_28670_28810[(2)] = inst_28664);

(statearr_28670_28810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28669 === (20))){
var state_28668__$1 = state_28668;
var statearr_28671_28813 = state_28668__$1;
(statearr_28671_28813[(2)] = null);

(statearr_28671_28813[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28669 === (1))){
var state_28668__$1 = state_28668;
var statearr_28672_28814 = state_28668__$1;
(statearr_28672_28814[(2)] = null);

(statearr_28672_28814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28669 === (4))){
var inst_28632 = (state_28668[(7)]);
var inst_28632__$1 = (state_28668[(2)]);
var inst_28633 = (inst_28632__$1 == null);
var state_28668__$1 = (function (){var statearr_28673 = state_28668;
(statearr_28673[(7)] = inst_28632__$1);

return statearr_28673;
})();
if(cljs.core.truth_(inst_28633)){
var statearr_28674_28820 = state_28668__$1;
(statearr_28674_28820[(1)] = (5));

} else {
var statearr_28675_28821 = state_28668__$1;
(statearr_28675_28821[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28669 === (15))){
var inst_28646 = (state_28668[(8)]);
var state_28668__$1 = state_28668;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28668__$1,(18),to,inst_28646);
} else {
if((state_val_28669 === (21))){
var inst_28659 = (state_28668[(2)]);
var state_28668__$1 = state_28668;
var statearr_28677_28827 = state_28668__$1;
(statearr_28677_28827[(2)] = inst_28659);

(statearr_28677_28827[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28669 === (13))){
var inst_28661 = (state_28668[(2)]);
var state_28668__$1 = (function (){var statearr_28678 = state_28668;
(statearr_28678[(9)] = inst_28661);

return statearr_28678;
})();
var statearr_28679_28828 = state_28668__$1;
(statearr_28679_28828[(2)] = null);

(statearr_28679_28828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28669 === (6))){
var inst_28632 = (state_28668[(7)]);
var state_28668__$1 = state_28668;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28668__$1,(11),inst_28632);
} else {
if((state_val_28669 === (17))){
var inst_28654 = (state_28668[(2)]);
var state_28668__$1 = state_28668;
if(cljs.core.truth_(inst_28654)){
var statearr_28681_28831 = state_28668__$1;
(statearr_28681_28831[(1)] = (19));

} else {
var statearr_28682_28832 = state_28668__$1;
(statearr_28682_28832[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28669 === (3))){
var inst_28666 = (state_28668[(2)]);
var state_28668__$1 = state_28668;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28668__$1,inst_28666);
} else {
if((state_val_28669 === (12))){
var inst_28642 = (state_28668[(10)]);
var state_28668__$1 = state_28668;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28668__$1,(14),inst_28642);
} else {
if((state_val_28669 === (2))){
var state_28668__$1 = state_28668;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28668__$1,(4),results);
} else {
if((state_val_28669 === (19))){
var state_28668__$1 = state_28668;
var statearr_28684_28837 = state_28668__$1;
(statearr_28684_28837[(2)] = null);

(statearr_28684_28837[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28669 === (11))){
var inst_28642 = (state_28668[(2)]);
var state_28668__$1 = (function (){var statearr_28686 = state_28668;
(statearr_28686[(10)] = inst_28642);

return statearr_28686;
})();
var statearr_28687_28838 = state_28668__$1;
(statearr_28687_28838[(2)] = null);

(statearr_28687_28838[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28669 === (9))){
var state_28668__$1 = state_28668;
var statearr_28689_28841 = state_28668__$1;
(statearr_28689_28841[(2)] = null);

(statearr_28689_28841[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28669 === (5))){
var state_28668__$1 = state_28668;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28691_28842 = state_28668__$1;
(statearr_28691_28842[(1)] = (8));

} else {
var statearr_28692_28843 = state_28668__$1;
(statearr_28692_28843[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28669 === (14))){
var inst_28648 = (state_28668[(11)]);
var inst_28646 = (state_28668[(8)]);
var inst_28646__$1 = (state_28668[(2)]);
var inst_28647 = (inst_28646__$1 == null);
var inst_28648__$1 = cljs.core.not.call(null,inst_28647);
var state_28668__$1 = (function (){var statearr_28694 = state_28668;
(statearr_28694[(11)] = inst_28648__$1);

(statearr_28694[(8)] = inst_28646__$1);

return statearr_28694;
})();
if(inst_28648__$1){
var statearr_28695_28849 = state_28668__$1;
(statearr_28695_28849[(1)] = (15));

} else {
var statearr_28696_28850 = state_28668__$1;
(statearr_28696_28850[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28669 === (16))){
var inst_28648 = (state_28668[(11)]);
var state_28668__$1 = state_28668;
var statearr_28697_28851 = state_28668__$1;
(statearr_28697_28851[(2)] = inst_28648);

(statearr_28697_28851[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28669 === (10))){
var inst_28639 = (state_28668[(2)]);
var state_28668__$1 = state_28668;
var statearr_28698_28855 = state_28668__$1;
(statearr_28698_28855[(2)] = inst_28639);

(statearr_28698_28855[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28669 === (18))){
var inst_28651 = (state_28668[(2)]);
var state_28668__$1 = state_28668;
var statearr_28699_28858 = state_28668__$1;
(statearr_28699_28858[(2)] = inst_28651);

(statearr_28699_28858[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28669 === (8))){
var inst_28636 = cljs.core.async.close_BANG_.call(null,to);
var state_28668__$1 = state_28668;
var statearr_28700_28859 = state_28668__$1;
(statearr_28700_28859[(2)] = inst_28636);

(statearr_28700_28859[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto__,jobs,results,process,async))
;
return ((function (switch__20318__auto__,c__20380__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____0 = (function (){
var statearr_28705 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28705[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__);

(statearr_28705[(1)] = (1));

return statearr_28705;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____1 = (function (state_28668){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_28668);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e28706){if((e28706 instanceof Object)){
var ex__20322__auto__ = e28706;
var statearr_28707_28864 = state_28668;
(statearr_28707_28864[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28668);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28706;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28868 = state_28668;
state_28668 = G__28868;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__ = function(state_28668){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____1.call(this,state_28668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20319__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto__,jobs,results,process,async))
})();
var state__20382__auto__ = (function (){var statearr_28709 = f__20381__auto__.call(null);
(statearr_28709[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto__);

return statearr_28709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto__,jobs,results,process,async))
);

return c__20380__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var G__28872 = arguments.length;
switch (G__28872) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var G__28881 = arguments.length;
switch (G__28881) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var G__28892 = arguments.length;
switch (G__28892) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__20380__auto___28959 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto___28959,tc,fc){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto___28959,tc,fc){
return (function (state_28919){
var state_val_28920 = (state_28919[(1)]);
if((state_val_28920 === (7))){
var inst_28915 = (state_28919[(2)]);
var state_28919__$1 = state_28919;
var statearr_28923_28960 = state_28919__$1;
(statearr_28923_28960[(2)] = inst_28915);

(statearr_28923_28960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (1))){
var state_28919__$1 = state_28919;
var statearr_28924_28961 = state_28919__$1;
(statearr_28924_28961[(2)] = null);

(statearr_28924_28961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (4))){
var inst_28896 = (state_28919[(7)]);
var inst_28896__$1 = (state_28919[(2)]);
var inst_28897 = (inst_28896__$1 == null);
var state_28919__$1 = (function (){var statearr_28925 = state_28919;
(statearr_28925[(7)] = inst_28896__$1);

return statearr_28925;
})();
if(cljs.core.truth_(inst_28897)){
var statearr_28928_28962 = state_28919__$1;
(statearr_28928_28962[(1)] = (5));

} else {
var statearr_28929_28963 = state_28919__$1;
(statearr_28929_28963[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (13))){
var state_28919__$1 = state_28919;
var statearr_28930_28965 = state_28919__$1;
(statearr_28930_28965[(2)] = null);

(statearr_28930_28965[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (6))){
var inst_28896 = (state_28919[(7)]);
var inst_28902 = p.call(null,inst_28896);
var state_28919__$1 = state_28919;
if(cljs.core.truth_(inst_28902)){
var statearr_28931_28966 = state_28919__$1;
(statearr_28931_28966[(1)] = (9));

} else {
var statearr_28932_28967 = state_28919__$1;
(statearr_28932_28967[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (3))){
var inst_28917 = (state_28919[(2)]);
var state_28919__$1 = state_28919;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28919__$1,inst_28917);
} else {
if((state_val_28920 === (12))){
var state_28919__$1 = state_28919;
var statearr_28933_28969 = state_28919__$1;
(statearr_28933_28969[(2)] = null);

(statearr_28933_28969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (2))){
var state_28919__$1 = state_28919;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28919__$1,(4),ch);
} else {
if((state_val_28920 === (11))){
var inst_28896 = (state_28919[(7)]);
var inst_28906 = (state_28919[(2)]);
var state_28919__$1 = state_28919;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28919__$1,(8),inst_28906,inst_28896);
} else {
if((state_val_28920 === (9))){
var state_28919__$1 = state_28919;
var statearr_28936_28972 = state_28919__$1;
(statearr_28936_28972[(2)] = tc);

(statearr_28936_28972[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (5))){
var inst_28899 = cljs.core.async.close_BANG_.call(null,tc);
var inst_28900 = cljs.core.async.close_BANG_.call(null,fc);
var state_28919__$1 = (function (){var statearr_28937 = state_28919;
(statearr_28937[(8)] = inst_28899);

return statearr_28937;
})();
var statearr_28938_28973 = state_28919__$1;
(statearr_28938_28973[(2)] = inst_28900);

(statearr_28938_28973[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (14))){
var inst_28913 = (state_28919[(2)]);
var state_28919__$1 = state_28919;
var statearr_28939_28974 = state_28919__$1;
(statearr_28939_28974[(2)] = inst_28913);

(statearr_28939_28974[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (10))){
var state_28919__$1 = state_28919;
var statearr_28940_28975 = state_28919__$1;
(statearr_28940_28975[(2)] = fc);

(statearr_28940_28975[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28920 === (8))){
var inst_28908 = (state_28919[(2)]);
var state_28919__$1 = state_28919;
if(cljs.core.truth_(inst_28908)){
var statearr_28945_28976 = state_28919__$1;
(statearr_28945_28976[(1)] = (12));

} else {
var statearr_28946_28977 = state_28919__$1;
(statearr_28946_28977[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto___28959,tc,fc))
;
return ((function (switch__20318__auto__,c__20380__auto___28959,tc,fc){
return (function() {
var cljs$core$async$state_machine__20319__auto__ = null;
var cljs$core$async$state_machine__20319__auto____0 = (function (){
var statearr_28950 = [null,null,null,null,null,null,null,null,null];
(statearr_28950[(0)] = cljs$core$async$state_machine__20319__auto__);

(statearr_28950[(1)] = (1));

return statearr_28950;
});
var cljs$core$async$state_machine__20319__auto____1 = (function (state_28919){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_28919);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e28951){if((e28951 instanceof Object)){
var ex__20322__auto__ = e28951;
var statearr_28952_28978 = state_28919;
(statearr_28952_28978[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28919);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28951;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28979 = state_28919;
state_28919 = G__28979;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$state_machine__20319__auto__ = function(state_28919){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20319__auto____1.call(this,state_28919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20319__auto____0;
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20319__auto____1;
return cljs$core$async$state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto___28959,tc,fc))
})();
var state__20382__auto__ = (function (){var statearr_28953 = f__20381__auto__.call(null);
(statearr_28953[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___28959);

return statearr_28953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto___28959,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__20380__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto__){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto__){
return (function (state_29026){
var state_val_29027 = (state_29026[(1)]);
if((state_val_29027 === (1))){
var inst_29012 = init;
var state_29026__$1 = (function (){var statearr_29028 = state_29026;
(statearr_29028[(7)] = inst_29012);

return statearr_29028;
})();
var statearr_29029_29044 = state_29026__$1;
(statearr_29029_29044[(2)] = null);

(statearr_29029_29044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29027 === (2))){
var state_29026__$1 = state_29026;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29026__$1,(4),ch);
} else {
if((state_val_29027 === (3))){
var inst_29024 = (state_29026[(2)]);
var state_29026__$1 = state_29026;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29026__$1,inst_29024);
} else {
if((state_val_29027 === (4))){
var inst_29015 = (state_29026[(8)]);
var inst_29015__$1 = (state_29026[(2)]);
var inst_29016 = (inst_29015__$1 == null);
var state_29026__$1 = (function (){var statearr_29030 = state_29026;
(statearr_29030[(8)] = inst_29015__$1);

return statearr_29030;
})();
if(cljs.core.truth_(inst_29016)){
var statearr_29031_29055 = state_29026__$1;
(statearr_29031_29055[(1)] = (5));

} else {
var statearr_29032_29056 = state_29026__$1;
(statearr_29032_29056[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29027 === (5))){
var inst_29012 = (state_29026[(7)]);
var state_29026__$1 = state_29026;
var statearr_29033_29059 = state_29026__$1;
(statearr_29033_29059[(2)] = inst_29012);

(statearr_29033_29059[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29027 === (6))){
var inst_29015 = (state_29026[(8)]);
var inst_29012 = (state_29026[(7)]);
var inst_29019 = f.call(null,inst_29012,inst_29015);
var inst_29012__$1 = inst_29019;
var state_29026__$1 = (function (){var statearr_29034 = state_29026;
(statearr_29034[(7)] = inst_29012__$1);

return statearr_29034;
})();
var statearr_29035_29066 = state_29026__$1;
(statearr_29035_29066[(2)] = null);

(statearr_29035_29066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29027 === (7))){
var inst_29022 = (state_29026[(2)]);
var state_29026__$1 = state_29026;
var statearr_29036_29067 = state_29026__$1;
(statearr_29036_29067[(2)] = inst_29022);

(statearr_29036_29067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__20380__auto__))
;
return ((function (switch__20318__auto__,c__20380__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__20319__auto__ = null;
var cljs$core$async$reduce_$_state_machine__20319__auto____0 = (function (){
var statearr_29040 = [null,null,null,null,null,null,null,null,null];
(statearr_29040[(0)] = cljs$core$async$reduce_$_state_machine__20319__auto__);

(statearr_29040[(1)] = (1));

return statearr_29040;
});
var cljs$core$async$reduce_$_state_machine__20319__auto____1 = (function (state_29026){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_29026);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e29041){if((e29041 instanceof Object)){
var ex__20322__auto__ = e29041;
var statearr_29042_29069 = state_29026;
(statearr_29042_29069[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29026);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29041;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29070 = state_29026;
state_29026 = G__29070;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__20319__auto__ = function(state_29026){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__20319__auto____1.call(this,state_29026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__20319__auto____0;
cljs$core$async$reduce_$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__20319__auto____1;
return cljs$core$async$reduce_$_state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto__))
})();
var state__20382__auto__ = (function (){var statearr_29043 = f__20381__auto__.call(null);
(statearr_29043[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto__);

return statearr_29043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto__))
);

return c__20380__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var G__29072 = arguments.length;
switch (G__29072) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__20380__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto__){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto__){
return (function (state_29097){
var state_val_29098 = (state_29097[(1)]);
if((state_val_29098 === (7))){
var inst_29079 = (state_29097[(2)]);
var state_29097__$1 = state_29097;
var statearr_29099_29136 = state_29097__$1;
(statearr_29099_29136[(2)] = inst_29079);

(statearr_29099_29136[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29098 === (1))){
var inst_29073 = cljs.core.seq.call(null,coll);
var inst_29074 = inst_29073;
var state_29097__$1 = (function (){var statearr_29101 = state_29097;
(statearr_29101[(7)] = inst_29074);

return statearr_29101;
})();
var statearr_29102_29137 = state_29097__$1;
(statearr_29102_29137[(2)] = null);

(statearr_29102_29137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29098 === (4))){
var inst_29074 = (state_29097[(7)]);
var inst_29077 = cljs.core.first.call(null,inst_29074);
var state_29097__$1 = state_29097;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29097__$1,(7),ch,inst_29077);
} else {
if((state_val_29098 === (13))){
var inst_29091 = (state_29097[(2)]);
var state_29097__$1 = state_29097;
var statearr_29103_29138 = state_29097__$1;
(statearr_29103_29138[(2)] = inst_29091);

(statearr_29103_29138[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29098 === (6))){
var inst_29082 = (state_29097[(2)]);
var state_29097__$1 = state_29097;
if(cljs.core.truth_(inst_29082)){
var statearr_29104_29139 = state_29097__$1;
(statearr_29104_29139[(1)] = (8));

} else {
var statearr_29105_29140 = state_29097__$1;
(statearr_29105_29140[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29098 === (3))){
var inst_29095 = (state_29097[(2)]);
var state_29097__$1 = state_29097;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29097__$1,inst_29095);
} else {
if((state_val_29098 === (12))){
var state_29097__$1 = state_29097;
var statearr_29106_29141 = state_29097__$1;
(statearr_29106_29141[(2)] = null);

(statearr_29106_29141[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29098 === (2))){
var inst_29074 = (state_29097[(7)]);
var state_29097__$1 = state_29097;
if(cljs.core.truth_(inst_29074)){
var statearr_29107_29142 = state_29097__$1;
(statearr_29107_29142[(1)] = (4));

} else {
var statearr_29108_29143 = state_29097__$1;
(statearr_29108_29143[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29098 === (11))){
var inst_29088 = cljs.core.async.close_BANG_.call(null,ch);
var state_29097__$1 = state_29097;
var statearr_29109_29144 = state_29097__$1;
(statearr_29109_29144[(2)] = inst_29088);

(statearr_29109_29144[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29098 === (9))){
var state_29097__$1 = state_29097;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29110_29145 = state_29097__$1;
(statearr_29110_29145[(1)] = (11));

} else {
var statearr_29111_29146 = state_29097__$1;
(statearr_29111_29146[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29098 === (5))){
var inst_29074 = (state_29097[(7)]);
var state_29097__$1 = state_29097;
var statearr_29112_29147 = state_29097__$1;
(statearr_29112_29147[(2)] = inst_29074);

(statearr_29112_29147[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29098 === (10))){
var inst_29093 = (state_29097[(2)]);
var state_29097__$1 = state_29097;
var statearr_29113_29148 = state_29097__$1;
(statearr_29113_29148[(2)] = inst_29093);

(statearr_29113_29148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29098 === (8))){
var inst_29074 = (state_29097[(7)]);
var inst_29084 = cljs.core.next.call(null,inst_29074);
var inst_29074__$1 = inst_29084;
var state_29097__$1 = (function (){var statearr_29114 = state_29097;
(statearr_29114[(7)] = inst_29074__$1);

return statearr_29114;
})();
var statearr_29115_29149 = state_29097__$1;
(statearr_29115_29149[(2)] = null);

(statearr_29115_29149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto__))
;
return ((function (switch__20318__auto__,c__20380__auto__){
return (function() {
var cljs$core$async$state_machine__20319__auto__ = null;
var cljs$core$async$state_machine__20319__auto____0 = (function (){
var statearr_29119 = [null,null,null,null,null,null,null,null];
(statearr_29119[(0)] = cljs$core$async$state_machine__20319__auto__);

(statearr_29119[(1)] = (1));

return statearr_29119;
});
var cljs$core$async$state_machine__20319__auto____1 = (function (state_29097){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_29097);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e29120){if((e29120 instanceof Object)){
var ex__20322__auto__ = e29120;
var statearr_29121_29150 = state_29097;
(statearr_29121_29150[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29097);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29120;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29151 = state_29097;
state_29097 = G__29151;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$state_machine__20319__auto__ = function(state_29097){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20319__auto____1.call(this,state_29097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20319__auto____0;
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20319__auto____1;
return cljs$core$async$state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto__))
})();
var state__20382__auto__ = (function (){var statearr_29122 = f__20381__auto__.call(null);
(statearr_29122[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto__);

return statearr_29122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto__))
);

return c__20380__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

cljs.core.async.Mux = (function (){var obj29153 = {};
return obj29153;
})();

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((function (){var and__16097__auto__ = _;
if(and__16097__auto__){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else {
return and__16097__auto__;
}
})()){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__16745__auto__ = (((_ == null))?null:_);
return (function (){var or__16109__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__16745__auto__)]);
if(or__16109__auto__){
return or__16109__auto__;
} else {
var or__16109__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(or__16109__auto____$1){
return or__16109__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});


cljs.core.async.Mult = (function (){var obj29155 = {};
return obj29155;
})();

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((function (){var and__16097__auto__ = m;
if(and__16097__auto__){
return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else {
return and__16097__auto__;
}
})()){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__16745__auto__ = (((m == null))?null:m);
return (function (){var or__16109__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__16745__auto__)]);
if(or__16109__auto__){
return or__16109__auto__;
} else {
var or__16109__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(or__16109__auto____$1){
return or__16109__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((function (){var and__16097__auto__ = m;
if(and__16097__auto__){
return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else {
return and__16097__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__16745__auto__ = (((m == null))?null:m);
return (function (){var or__16109__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__16745__auto__)]);
if(or__16109__auto__){
return or__16109__auto__;
} else {
var or__16109__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(or__16109__auto____$1){
return or__16109__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((function (){var and__16097__auto__ = m;
if(and__16097__auto__){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else {
return and__16097__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__16745__auto__ = (((m == null))?null:m);
return (function (){var or__16109__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__16745__auto__)]);
if(or__16109__auto__){
return or__16109__auto__;
} else {
var or__16109__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(or__16109__auto____$1){
return or__16109__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t29377 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29377 = (function (mult,ch,cs,meta29378){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta29378 = meta29378;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29377.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_29379,meta29378__$1){
var self__ = this;
var _29379__$1 = this;
return (new cljs.core.async.t29377(self__.mult,self__.ch,self__.cs,meta29378__$1));
});})(cs))
;

cljs.core.async.t29377.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_29379){
var self__ = this;
var _29379__$1 = this;
return self__.meta29378;
});})(cs))
;

cljs.core.async.t29377.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t29377.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t29377.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t29377.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t29377.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t29377.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t29377.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta29378","meta29378",1600301496,null)], null);
});})(cs))
;

cljs.core.async.t29377.cljs$lang$type = true;

cljs.core.async.t29377.cljs$lang$ctorStr = "cljs.core.async/t29377";

cljs.core.async.t29377.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"cljs.core.async/t29377");
});})(cs))
;

cljs.core.async.__GT_t29377 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t29377(mult__$1,ch__$1,cs__$1,meta29378){
return (new cljs.core.async.t29377(mult__$1,ch__$1,cs__$1,meta29378));
});})(cs))
;

}

return (new cljs.core.async.t29377(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__20380__auto___29598 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto___29598,cs,m,dchan,dctr,done){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto___29598,cs,m,dchan,dctr,done){
return (function (state_29510){
var state_val_29511 = (state_29510[(1)]);
if((state_val_29511 === (7))){
var inst_29506 = (state_29510[(2)]);
var state_29510__$1 = state_29510;
var statearr_29512_29599 = state_29510__$1;
(statearr_29512_29599[(2)] = inst_29506);

(statearr_29512_29599[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (20))){
var inst_29411 = (state_29510[(7)]);
var inst_29421 = cljs.core.first.call(null,inst_29411);
var inst_29422 = cljs.core.nth.call(null,inst_29421,(0),null);
var inst_29423 = cljs.core.nth.call(null,inst_29421,(1),null);
var state_29510__$1 = (function (){var statearr_29513 = state_29510;
(statearr_29513[(8)] = inst_29422);

return statearr_29513;
})();
if(cljs.core.truth_(inst_29423)){
var statearr_29514_29600 = state_29510__$1;
(statearr_29514_29600[(1)] = (22));

} else {
var statearr_29515_29601 = state_29510__$1;
(statearr_29515_29601[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (27))){
var inst_29453 = (state_29510[(9)]);
var inst_29382 = (state_29510[(10)]);
var inst_29451 = (state_29510[(11)]);
var inst_29458 = (state_29510[(12)]);
var inst_29458__$1 = cljs.core._nth.call(null,inst_29451,inst_29453);
var inst_29459 = cljs.core.async.put_BANG_.call(null,inst_29458__$1,inst_29382,done);
var state_29510__$1 = (function (){var statearr_29516 = state_29510;
(statearr_29516[(12)] = inst_29458__$1);

return statearr_29516;
})();
if(cljs.core.truth_(inst_29459)){
var statearr_29517_29602 = state_29510__$1;
(statearr_29517_29602[(1)] = (30));

} else {
var statearr_29518_29603 = state_29510__$1;
(statearr_29518_29603[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (1))){
var state_29510__$1 = state_29510;
var statearr_29519_29604 = state_29510__$1;
(statearr_29519_29604[(2)] = null);

(statearr_29519_29604[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (24))){
var inst_29411 = (state_29510[(7)]);
var inst_29428 = (state_29510[(2)]);
var inst_29429 = cljs.core.next.call(null,inst_29411);
var inst_29391 = inst_29429;
var inst_29392 = null;
var inst_29393 = (0);
var inst_29394 = (0);
var state_29510__$1 = (function (){var statearr_29520 = state_29510;
(statearr_29520[(13)] = inst_29393);

(statearr_29520[(14)] = inst_29391);

(statearr_29520[(15)] = inst_29428);

(statearr_29520[(16)] = inst_29394);

(statearr_29520[(17)] = inst_29392);

return statearr_29520;
})();
var statearr_29521_29605 = state_29510__$1;
(statearr_29521_29605[(2)] = null);

(statearr_29521_29605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (39))){
var state_29510__$1 = state_29510;
var statearr_29525_29606 = state_29510__$1;
(statearr_29525_29606[(2)] = null);

(statearr_29525_29606[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (4))){
var inst_29382 = (state_29510[(10)]);
var inst_29382__$1 = (state_29510[(2)]);
var inst_29383 = (inst_29382__$1 == null);
var state_29510__$1 = (function (){var statearr_29526 = state_29510;
(statearr_29526[(10)] = inst_29382__$1);

return statearr_29526;
})();
if(cljs.core.truth_(inst_29383)){
var statearr_29527_29607 = state_29510__$1;
(statearr_29527_29607[(1)] = (5));

} else {
var statearr_29528_29608 = state_29510__$1;
(statearr_29528_29608[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (15))){
var inst_29393 = (state_29510[(13)]);
var inst_29391 = (state_29510[(14)]);
var inst_29394 = (state_29510[(16)]);
var inst_29392 = (state_29510[(17)]);
var inst_29407 = (state_29510[(2)]);
var inst_29408 = (inst_29394 + (1));
var tmp29522 = inst_29393;
var tmp29523 = inst_29391;
var tmp29524 = inst_29392;
var inst_29391__$1 = tmp29523;
var inst_29392__$1 = tmp29524;
var inst_29393__$1 = tmp29522;
var inst_29394__$1 = inst_29408;
var state_29510__$1 = (function (){var statearr_29529 = state_29510;
(statearr_29529[(18)] = inst_29407);

(statearr_29529[(13)] = inst_29393__$1);

(statearr_29529[(14)] = inst_29391__$1);

(statearr_29529[(16)] = inst_29394__$1);

(statearr_29529[(17)] = inst_29392__$1);

return statearr_29529;
})();
var statearr_29530_29609 = state_29510__$1;
(statearr_29530_29609[(2)] = null);

(statearr_29530_29609[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (21))){
var inst_29432 = (state_29510[(2)]);
var state_29510__$1 = state_29510;
var statearr_29534_29610 = state_29510__$1;
(statearr_29534_29610[(2)] = inst_29432);

(statearr_29534_29610[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (31))){
var inst_29458 = (state_29510[(12)]);
var inst_29462 = done.call(null,null);
var inst_29463 = cljs.core.async.untap_STAR_.call(null,m,inst_29458);
var state_29510__$1 = (function (){var statearr_29535 = state_29510;
(statearr_29535[(19)] = inst_29462);

return statearr_29535;
})();
var statearr_29536_29611 = state_29510__$1;
(statearr_29536_29611[(2)] = inst_29463);

(statearr_29536_29611[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (32))){
var inst_29453 = (state_29510[(9)]);
var inst_29450 = (state_29510[(20)]);
var inst_29451 = (state_29510[(11)]);
var inst_29452 = (state_29510[(21)]);
var inst_29465 = (state_29510[(2)]);
var inst_29466 = (inst_29453 + (1));
var tmp29531 = inst_29450;
var tmp29532 = inst_29451;
var tmp29533 = inst_29452;
var inst_29450__$1 = tmp29531;
var inst_29451__$1 = tmp29532;
var inst_29452__$1 = tmp29533;
var inst_29453__$1 = inst_29466;
var state_29510__$1 = (function (){var statearr_29537 = state_29510;
(statearr_29537[(22)] = inst_29465);

(statearr_29537[(9)] = inst_29453__$1);

(statearr_29537[(20)] = inst_29450__$1);

(statearr_29537[(11)] = inst_29451__$1);

(statearr_29537[(21)] = inst_29452__$1);

return statearr_29537;
})();
var statearr_29538_29612 = state_29510__$1;
(statearr_29538_29612[(2)] = null);

(statearr_29538_29612[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (40))){
var inst_29478 = (state_29510[(23)]);
var inst_29482 = done.call(null,null);
var inst_29483 = cljs.core.async.untap_STAR_.call(null,m,inst_29478);
var state_29510__$1 = (function (){var statearr_29539 = state_29510;
(statearr_29539[(24)] = inst_29482);

return statearr_29539;
})();
var statearr_29540_29613 = state_29510__$1;
(statearr_29540_29613[(2)] = inst_29483);

(statearr_29540_29613[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (33))){
var inst_29469 = (state_29510[(25)]);
var inst_29471 = cljs.core.chunked_seq_QMARK_.call(null,inst_29469);
var state_29510__$1 = state_29510;
if(inst_29471){
var statearr_29541_29614 = state_29510__$1;
(statearr_29541_29614[(1)] = (36));

} else {
var statearr_29542_29615 = state_29510__$1;
(statearr_29542_29615[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (13))){
var inst_29401 = (state_29510[(26)]);
var inst_29404 = cljs.core.async.close_BANG_.call(null,inst_29401);
var state_29510__$1 = state_29510;
var statearr_29543_29616 = state_29510__$1;
(statearr_29543_29616[(2)] = inst_29404);

(statearr_29543_29616[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (22))){
var inst_29422 = (state_29510[(8)]);
var inst_29425 = cljs.core.async.close_BANG_.call(null,inst_29422);
var state_29510__$1 = state_29510;
var statearr_29544_29617 = state_29510__$1;
(statearr_29544_29617[(2)] = inst_29425);

(statearr_29544_29617[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (36))){
var inst_29469 = (state_29510[(25)]);
var inst_29473 = cljs.core.chunk_first.call(null,inst_29469);
var inst_29474 = cljs.core.chunk_rest.call(null,inst_29469);
var inst_29475 = cljs.core.count.call(null,inst_29473);
var inst_29450 = inst_29474;
var inst_29451 = inst_29473;
var inst_29452 = inst_29475;
var inst_29453 = (0);
var state_29510__$1 = (function (){var statearr_29545 = state_29510;
(statearr_29545[(9)] = inst_29453);

(statearr_29545[(20)] = inst_29450);

(statearr_29545[(11)] = inst_29451);

(statearr_29545[(21)] = inst_29452);

return statearr_29545;
})();
var statearr_29546_29618 = state_29510__$1;
(statearr_29546_29618[(2)] = null);

(statearr_29546_29618[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (41))){
var inst_29469 = (state_29510[(25)]);
var inst_29485 = (state_29510[(2)]);
var inst_29486 = cljs.core.next.call(null,inst_29469);
var inst_29450 = inst_29486;
var inst_29451 = null;
var inst_29452 = (0);
var inst_29453 = (0);
var state_29510__$1 = (function (){var statearr_29547 = state_29510;
(statearr_29547[(27)] = inst_29485);

(statearr_29547[(9)] = inst_29453);

(statearr_29547[(20)] = inst_29450);

(statearr_29547[(11)] = inst_29451);

(statearr_29547[(21)] = inst_29452);

return statearr_29547;
})();
var statearr_29548_29619 = state_29510__$1;
(statearr_29548_29619[(2)] = null);

(statearr_29548_29619[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (43))){
var state_29510__$1 = state_29510;
var statearr_29549_29620 = state_29510__$1;
(statearr_29549_29620[(2)] = null);

(statearr_29549_29620[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (29))){
var inst_29494 = (state_29510[(2)]);
var state_29510__$1 = state_29510;
var statearr_29550_29621 = state_29510__$1;
(statearr_29550_29621[(2)] = inst_29494);

(statearr_29550_29621[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (44))){
var inst_29503 = (state_29510[(2)]);
var state_29510__$1 = (function (){var statearr_29551 = state_29510;
(statearr_29551[(28)] = inst_29503);

return statearr_29551;
})();
var statearr_29552_29622 = state_29510__$1;
(statearr_29552_29622[(2)] = null);

(statearr_29552_29622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (6))){
var inst_29442 = (state_29510[(29)]);
var inst_29441 = cljs.core.deref.call(null,cs);
var inst_29442__$1 = cljs.core.keys.call(null,inst_29441);
var inst_29443 = cljs.core.count.call(null,inst_29442__$1);
var inst_29444 = cljs.core.reset_BANG_.call(null,dctr,inst_29443);
var inst_29449 = cljs.core.seq.call(null,inst_29442__$1);
var inst_29450 = inst_29449;
var inst_29451 = null;
var inst_29452 = (0);
var inst_29453 = (0);
var state_29510__$1 = (function (){var statearr_29553 = state_29510;
(statearr_29553[(9)] = inst_29453);

(statearr_29553[(20)] = inst_29450);

(statearr_29553[(29)] = inst_29442__$1);

(statearr_29553[(11)] = inst_29451);

(statearr_29553[(21)] = inst_29452);

(statearr_29553[(30)] = inst_29444);

return statearr_29553;
})();
var statearr_29554_29623 = state_29510__$1;
(statearr_29554_29623[(2)] = null);

(statearr_29554_29623[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (28))){
var inst_29450 = (state_29510[(20)]);
var inst_29469 = (state_29510[(25)]);
var inst_29469__$1 = cljs.core.seq.call(null,inst_29450);
var state_29510__$1 = (function (){var statearr_29555 = state_29510;
(statearr_29555[(25)] = inst_29469__$1);

return statearr_29555;
})();
if(inst_29469__$1){
var statearr_29556_29624 = state_29510__$1;
(statearr_29556_29624[(1)] = (33));

} else {
var statearr_29557_29625 = state_29510__$1;
(statearr_29557_29625[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (25))){
var inst_29453 = (state_29510[(9)]);
var inst_29452 = (state_29510[(21)]);
var inst_29455 = (inst_29453 < inst_29452);
var inst_29456 = inst_29455;
var state_29510__$1 = state_29510;
if(cljs.core.truth_(inst_29456)){
var statearr_29558_29626 = state_29510__$1;
(statearr_29558_29626[(1)] = (27));

} else {
var statearr_29559_29627 = state_29510__$1;
(statearr_29559_29627[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (34))){
var state_29510__$1 = state_29510;
var statearr_29560_29628 = state_29510__$1;
(statearr_29560_29628[(2)] = null);

(statearr_29560_29628[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (17))){
var state_29510__$1 = state_29510;
var statearr_29561_29629 = state_29510__$1;
(statearr_29561_29629[(2)] = null);

(statearr_29561_29629[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (3))){
var inst_29508 = (state_29510[(2)]);
var state_29510__$1 = state_29510;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29510__$1,inst_29508);
} else {
if((state_val_29511 === (12))){
var inst_29437 = (state_29510[(2)]);
var state_29510__$1 = state_29510;
var statearr_29562_29630 = state_29510__$1;
(statearr_29562_29630[(2)] = inst_29437);

(statearr_29562_29630[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (2))){
var state_29510__$1 = state_29510;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29510__$1,(4),ch);
} else {
if((state_val_29511 === (23))){
var state_29510__$1 = state_29510;
var statearr_29563_29631 = state_29510__$1;
(statearr_29563_29631[(2)] = null);

(statearr_29563_29631[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (35))){
var inst_29492 = (state_29510[(2)]);
var state_29510__$1 = state_29510;
var statearr_29564_29632 = state_29510__$1;
(statearr_29564_29632[(2)] = inst_29492);

(statearr_29564_29632[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (19))){
var inst_29411 = (state_29510[(7)]);
var inst_29415 = cljs.core.chunk_first.call(null,inst_29411);
var inst_29416 = cljs.core.chunk_rest.call(null,inst_29411);
var inst_29417 = cljs.core.count.call(null,inst_29415);
var inst_29391 = inst_29416;
var inst_29392 = inst_29415;
var inst_29393 = inst_29417;
var inst_29394 = (0);
var state_29510__$1 = (function (){var statearr_29565 = state_29510;
(statearr_29565[(13)] = inst_29393);

(statearr_29565[(14)] = inst_29391);

(statearr_29565[(16)] = inst_29394);

(statearr_29565[(17)] = inst_29392);

return statearr_29565;
})();
var statearr_29566_29633 = state_29510__$1;
(statearr_29566_29633[(2)] = null);

(statearr_29566_29633[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (11))){
var inst_29391 = (state_29510[(14)]);
var inst_29411 = (state_29510[(7)]);
var inst_29411__$1 = cljs.core.seq.call(null,inst_29391);
var state_29510__$1 = (function (){var statearr_29567 = state_29510;
(statearr_29567[(7)] = inst_29411__$1);

return statearr_29567;
})();
if(inst_29411__$1){
var statearr_29568_29634 = state_29510__$1;
(statearr_29568_29634[(1)] = (16));

} else {
var statearr_29569_29635 = state_29510__$1;
(statearr_29569_29635[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (9))){
var inst_29439 = (state_29510[(2)]);
var state_29510__$1 = state_29510;
var statearr_29570_29636 = state_29510__$1;
(statearr_29570_29636[(2)] = inst_29439);

(statearr_29570_29636[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (5))){
var inst_29389 = cljs.core.deref.call(null,cs);
var inst_29390 = cljs.core.seq.call(null,inst_29389);
var inst_29391 = inst_29390;
var inst_29392 = null;
var inst_29393 = (0);
var inst_29394 = (0);
var state_29510__$1 = (function (){var statearr_29571 = state_29510;
(statearr_29571[(13)] = inst_29393);

(statearr_29571[(14)] = inst_29391);

(statearr_29571[(16)] = inst_29394);

(statearr_29571[(17)] = inst_29392);

return statearr_29571;
})();
var statearr_29572_29637 = state_29510__$1;
(statearr_29572_29637[(2)] = null);

(statearr_29572_29637[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (14))){
var state_29510__$1 = state_29510;
var statearr_29573_29638 = state_29510__$1;
(statearr_29573_29638[(2)] = null);

(statearr_29573_29638[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (45))){
var inst_29500 = (state_29510[(2)]);
var state_29510__$1 = state_29510;
var statearr_29574_29639 = state_29510__$1;
(statearr_29574_29639[(2)] = inst_29500);

(statearr_29574_29639[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (26))){
var inst_29442 = (state_29510[(29)]);
var inst_29496 = (state_29510[(2)]);
var inst_29497 = cljs.core.seq.call(null,inst_29442);
var state_29510__$1 = (function (){var statearr_29575 = state_29510;
(statearr_29575[(31)] = inst_29496);

return statearr_29575;
})();
if(inst_29497){
var statearr_29576_29640 = state_29510__$1;
(statearr_29576_29640[(1)] = (42));

} else {
var statearr_29577_29641 = state_29510__$1;
(statearr_29577_29641[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (16))){
var inst_29411 = (state_29510[(7)]);
var inst_29413 = cljs.core.chunked_seq_QMARK_.call(null,inst_29411);
var state_29510__$1 = state_29510;
if(inst_29413){
var statearr_29578_29642 = state_29510__$1;
(statearr_29578_29642[(1)] = (19));

} else {
var statearr_29579_29643 = state_29510__$1;
(statearr_29579_29643[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (38))){
var inst_29489 = (state_29510[(2)]);
var state_29510__$1 = state_29510;
var statearr_29580_29644 = state_29510__$1;
(statearr_29580_29644[(2)] = inst_29489);

(statearr_29580_29644[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (30))){
var state_29510__$1 = state_29510;
var statearr_29581_29645 = state_29510__$1;
(statearr_29581_29645[(2)] = null);

(statearr_29581_29645[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (10))){
var inst_29394 = (state_29510[(16)]);
var inst_29392 = (state_29510[(17)]);
var inst_29400 = cljs.core._nth.call(null,inst_29392,inst_29394);
var inst_29401 = cljs.core.nth.call(null,inst_29400,(0),null);
var inst_29402 = cljs.core.nth.call(null,inst_29400,(1),null);
var state_29510__$1 = (function (){var statearr_29582 = state_29510;
(statearr_29582[(26)] = inst_29401);

return statearr_29582;
})();
if(cljs.core.truth_(inst_29402)){
var statearr_29583_29646 = state_29510__$1;
(statearr_29583_29646[(1)] = (13));

} else {
var statearr_29584_29647 = state_29510__$1;
(statearr_29584_29647[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (18))){
var inst_29435 = (state_29510[(2)]);
var state_29510__$1 = state_29510;
var statearr_29585_29648 = state_29510__$1;
(statearr_29585_29648[(2)] = inst_29435);

(statearr_29585_29648[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (42))){
var state_29510__$1 = state_29510;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29510__$1,(45),dchan);
} else {
if((state_val_29511 === (37))){
var inst_29382 = (state_29510[(10)]);
var inst_29469 = (state_29510[(25)]);
var inst_29478 = (state_29510[(23)]);
var inst_29478__$1 = cljs.core.first.call(null,inst_29469);
var inst_29479 = cljs.core.async.put_BANG_.call(null,inst_29478__$1,inst_29382,done);
var state_29510__$1 = (function (){var statearr_29586 = state_29510;
(statearr_29586[(23)] = inst_29478__$1);

return statearr_29586;
})();
if(cljs.core.truth_(inst_29479)){
var statearr_29587_29649 = state_29510__$1;
(statearr_29587_29649[(1)] = (39));

} else {
var statearr_29588_29650 = state_29510__$1;
(statearr_29588_29650[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29511 === (8))){
var inst_29393 = (state_29510[(13)]);
var inst_29394 = (state_29510[(16)]);
var inst_29396 = (inst_29394 < inst_29393);
var inst_29397 = inst_29396;
var state_29510__$1 = state_29510;
if(cljs.core.truth_(inst_29397)){
var statearr_29589_29651 = state_29510__$1;
(statearr_29589_29651[(1)] = (10));

} else {
var statearr_29590_29652 = state_29510__$1;
(statearr_29590_29652[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto___29598,cs,m,dchan,dctr,done))
;
return ((function (switch__20318__auto__,c__20380__auto___29598,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__20319__auto__ = null;
var cljs$core$async$mult_$_state_machine__20319__auto____0 = (function (){
var statearr_29594 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29594[(0)] = cljs$core$async$mult_$_state_machine__20319__auto__);

(statearr_29594[(1)] = (1));

return statearr_29594;
});
var cljs$core$async$mult_$_state_machine__20319__auto____1 = (function (state_29510){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_29510);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e29595){if((e29595 instanceof Object)){
var ex__20322__auto__ = e29595;
var statearr_29596_29653 = state_29510;
(statearr_29596_29653[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29510);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29595;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29654 = state_29510;
state_29510 = G__29654;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__20319__auto__ = function(state_29510){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__20319__auto____1.call(this,state_29510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__20319__auto____0;
cljs$core$async$mult_$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__20319__auto____1;
return cljs$core$async$mult_$_state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto___29598,cs,m,dchan,dctr,done))
})();
var state__20382__auto__ = (function (){var statearr_29597 = f__20381__auto__.call(null);
(statearr_29597[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___29598);

return statearr_29597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto___29598,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var G__29656 = arguments.length;
switch (G__29656) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

cljs.core.async.Mix = (function (){var obj29659 = {};
return obj29659;
})();

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((function (){var and__16097__auto__ = m;
if(and__16097__auto__){
return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else {
return and__16097__auto__;
}
})()){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__16745__auto__ = (((m == null))?null:m);
return (function (){var or__16109__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__16745__auto__)]);
if(or__16109__auto__){
return or__16109__auto__;
} else {
var or__16109__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(or__16109__auto____$1){
return or__16109__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((function (){var and__16097__auto__ = m;
if(and__16097__auto__){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else {
return and__16097__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__16745__auto__ = (((m == null))?null:m);
return (function (){var or__16109__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__16745__auto__)]);
if(or__16109__auto__){
return or__16109__auto__;
} else {
var or__16109__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(or__16109__auto____$1){
return or__16109__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((function (){var and__16097__auto__ = m;
if(and__16097__auto__){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else {
return and__16097__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__16745__auto__ = (((m == null))?null:m);
return (function (){var or__16109__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__16745__auto__)]);
if(or__16109__auto__){
return or__16109__auto__;
} else {
var or__16109__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(or__16109__auto____$1){
return or__16109__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((function (){var and__16097__auto__ = m;
if(and__16097__auto__){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else {
return and__16097__auto__;
}
})()){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__16745__auto__ = (((m == null))?null:m);
return (function (){var or__16109__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__16745__auto__)]);
if(or__16109__auto__){
return or__16109__auto__;
} else {
var or__16109__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(or__16109__auto____$1){
return or__16109__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((function (){var and__16097__auto__ = m;
if(and__16097__auto__){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else {
return and__16097__auto__;
}
})()){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__16745__auto__ = (((m == null))?null:m);
return (function (){var or__16109__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__16745__auto__)]);
if(or__16109__auto__){
return or__16109__auto__;
} else {
var or__16109__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(or__16109__auto____$1){
return or__16109__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var argseq__17149__auto__ = ((((3) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__17149__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__29665){
var map__29666 = p__29665;
var map__29666__$1 = ((cljs.core.seq_QMARK_.call(null,map__29666))?cljs.core.apply.call(null,cljs.core.hash_map,map__29666):map__29666);
var opts = map__29666__$1;
var statearr_29667_29670 = state;
(statearr_29667_29670[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__29666,map__29666__$1,opts){
return (function (val){
var statearr_29668_29671 = state;
(statearr_29668_29671[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__29666,map__29666__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_29669_29672 = state;
(statearr_29669_29672[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq29661){
var G__29662 = cljs.core.first.call(null,seq29661);
var seq29661__$1 = cljs.core.next.call(null,seq29661);
var G__29663 = cljs.core.first.call(null,seq29661__$1);
var seq29661__$2 = cljs.core.next.call(null,seq29661__$1);
var G__29664 = cljs.core.first.call(null,seq29661__$2);
var seq29661__$3 = cljs.core.next.call(null,seq29661__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29662,G__29663,G__29664,seq29661__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t29792 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29792 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta29793){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta29793 = meta29793;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29792.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_29794,meta29793__$1){
var self__ = this;
var _29794__$1 = this;
return (new cljs.core.async.t29792(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta29793__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29792.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_29794){
var self__ = this;
var _29794__$1 = this;
return self__.meta29793;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29792.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t29792.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29792.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t29792.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29792.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29792.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29792.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29792.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29792.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta29793","meta29793",1357374531,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t29792.cljs$lang$type = true;

cljs.core.async.t29792.cljs$lang$ctorStr = "cljs.core.async/t29792";

cljs.core.async.t29792.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"cljs.core.async/t29792");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t29792 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t29792(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29793){
return (new cljs.core.async.t29792(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29793));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t29792(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20380__auto___29911 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto___29911,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto___29911,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_29864){
var state_val_29865 = (state_29864[(1)]);
if((state_val_29865 === (7))){
var inst_29808 = (state_29864[(7)]);
var inst_29813 = cljs.core.apply.call(null,cljs.core.hash_map,inst_29808);
var state_29864__$1 = state_29864;
var statearr_29866_29912 = state_29864__$1;
(statearr_29866_29912[(2)] = inst_29813);

(statearr_29866_29912[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (20))){
var inst_29823 = (state_29864[(8)]);
var state_29864__$1 = state_29864;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29864__$1,(23),out,inst_29823);
} else {
if((state_val_29865 === (1))){
var inst_29798 = (state_29864[(9)]);
var inst_29798__$1 = calc_state.call(null);
var inst_29799 = cljs.core.seq_QMARK_.call(null,inst_29798__$1);
var state_29864__$1 = (function (){var statearr_29867 = state_29864;
(statearr_29867[(9)] = inst_29798__$1);

return statearr_29867;
})();
if(inst_29799){
var statearr_29868_29913 = state_29864__$1;
(statearr_29868_29913[(1)] = (2));

} else {
var statearr_29869_29914 = state_29864__$1;
(statearr_29869_29914[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (24))){
var inst_29816 = (state_29864[(10)]);
var inst_29808 = inst_29816;
var state_29864__$1 = (function (){var statearr_29870 = state_29864;
(statearr_29870[(7)] = inst_29808);

return statearr_29870;
})();
var statearr_29871_29915 = state_29864__$1;
(statearr_29871_29915[(2)] = null);

(statearr_29871_29915[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (4))){
var inst_29798 = (state_29864[(9)]);
var inst_29804 = (state_29864[(2)]);
var inst_29805 = cljs.core.get.call(null,inst_29804,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29806 = cljs.core.get.call(null,inst_29804,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29807 = cljs.core.get.call(null,inst_29804,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_29808 = inst_29798;
var state_29864__$1 = (function (){var statearr_29872 = state_29864;
(statearr_29872[(7)] = inst_29808);

(statearr_29872[(11)] = inst_29805);

(statearr_29872[(12)] = inst_29807);

(statearr_29872[(13)] = inst_29806);

return statearr_29872;
})();
var statearr_29873_29916 = state_29864__$1;
(statearr_29873_29916[(2)] = null);

(statearr_29873_29916[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (15))){
var state_29864__$1 = state_29864;
var statearr_29874_29917 = state_29864__$1;
(statearr_29874_29917[(2)] = null);

(statearr_29874_29917[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (21))){
var inst_29816 = (state_29864[(10)]);
var inst_29808 = inst_29816;
var state_29864__$1 = (function (){var statearr_29875 = state_29864;
(statearr_29875[(7)] = inst_29808);

return statearr_29875;
})();
var statearr_29876_29918 = state_29864__$1;
(statearr_29876_29918[(2)] = null);

(statearr_29876_29918[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (13))){
var inst_29860 = (state_29864[(2)]);
var state_29864__$1 = state_29864;
var statearr_29877_29919 = state_29864__$1;
(statearr_29877_29919[(2)] = inst_29860);

(statearr_29877_29919[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (22))){
var inst_29858 = (state_29864[(2)]);
var state_29864__$1 = state_29864;
var statearr_29878_29920 = state_29864__$1;
(statearr_29878_29920[(2)] = inst_29858);

(statearr_29878_29920[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (6))){
var inst_29862 = (state_29864[(2)]);
var state_29864__$1 = state_29864;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29864__$1,inst_29862);
} else {
if((state_val_29865 === (25))){
var state_29864__$1 = state_29864;
var statearr_29879_29921 = state_29864__$1;
(statearr_29879_29921[(2)] = null);

(statearr_29879_29921[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (17))){
var inst_29838 = (state_29864[(14)]);
var state_29864__$1 = state_29864;
var statearr_29880_29922 = state_29864__$1;
(statearr_29880_29922[(2)] = inst_29838);

(statearr_29880_29922[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (3))){
var inst_29798 = (state_29864[(9)]);
var state_29864__$1 = state_29864;
var statearr_29881_29923 = state_29864__$1;
(statearr_29881_29923[(2)] = inst_29798);

(statearr_29881_29923[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (12))){
var inst_29838 = (state_29864[(14)]);
var inst_29824 = (state_29864[(15)]);
var inst_29817 = (state_29864[(16)]);
var inst_29838__$1 = inst_29817.call(null,inst_29824);
var state_29864__$1 = (function (){var statearr_29882 = state_29864;
(statearr_29882[(14)] = inst_29838__$1);

return statearr_29882;
})();
if(cljs.core.truth_(inst_29838__$1)){
var statearr_29883_29924 = state_29864__$1;
(statearr_29883_29924[(1)] = (17));

} else {
var statearr_29884_29925 = state_29864__$1;
(statearr_29884_29925[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (2))){
var inst_29798 = (state_29864[(9)]);
var inst_29801 = cljs.core.apply.call(null,cljs.core.hash_map,inst_29798);
var state_29864__$1 = state_29864;
var statearr_29885_29926 = state_29864__$1;
(statearr_29885_29926[(2)] = inst_29801);

(statearr_29885_29926[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (23))){
var inst_29849 = (state_29864[(2)]);
var state_29864__$1 = state_29864;
if(cljs.core.truth_(inst_29849)){
var statearr_29886_29927 = state_29864__$1;
(statearr_29886_29927[(1)] = (24));

} else {
var statearr_29887_29928 = state_29864__$1;
(statearr_29887_29928[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (19))){
var inst_29846 = (state_29864[(2)]);
var state_29864__$1 = state_29864;
if(cljs.core.truth_(inst_29846)){
var statearr_29888_29929 = state_29864__$1;
(statearr_29888_29929[(1)] = (20));

} else {
var statearr_29889_29930 = state_29864__$1;
(statearr_29889_29930[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (11))){
var inst_29823 = (state_29864[(8)]);
var inst_29829 = (inst_29823 == null);
var state_29864__$1 = state_29864;
if(cljs.core.truth_(inst_29829)){
var statearr_29890_29931 = state_29864__$1;
(statearr_29890_29931[(1)] = (14));

} else {
var statearr_29891_29932 = state_29864__$1;
(statearr_29891_29932[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (9))){
var inst_29816 = (state_29864[(10)]);
var inst_29816__$1 = (state_29864[(2)]);
var inst_29817 = cljs.core.get.call(null,inst_29816__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29818 = cljs.core.get.call(null,inst_29816__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29819 = cljs.core.get.call(null,inst_29816__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_29864__$1 = (function (){var statearr_29892 = state_29864;
(statearr_29892[(10)] = inst_29816__$1);

(statearr_29892[(17)] = inst_29818);

(statearr_29892[(16)] = inst_29817);

return statearr_29892;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_29864__$1,(10),inst_29819);
} else {
if((state_val_29865 === (5))){
var inst_29808 = (state_29864[(7)]);
var inst_29811 = cljs.core.seq_QMARK_.call(null,inst_29808);
var state_29864__$1 = state_29864;
if(inst_29811){
var statearr_29893_29933 = state_29864__$1;
(statearr_29893_29933[(1)] = (7));

} else {
var statearr_29894_29934 = state_29864__$1;
(statearr_29894_29934[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (14))){
var inst_29824 = (state_29864[(15)]);
var inst_29831 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_29824);
var state_29864__$1 = state_29864;
var statearr_29895_29935 = state_29864__$1;
(statearr_29895_29935[(2)] = inst_29831);

(statearr_29895_29935[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (26))){
var inst_29854 = (state_29864[(2)]);
var state_29864__$1 = state_29864;
var statearr_29896_29936 = state_29864__$1;
(statearr_29896_29936[(2)] = inst_29854);

(statearr_29896_29936[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (16))){
var inst_29834 = (state_29864[(2)]);
var inst_29835 = calc_state.call(null);
var inst_29808 = inst_29835;
var state_29864__$1 = (function (){var statearr_29897 = state_29864;
(statearr_29897[(7)] = inst_29808);

(statearr_29897[(18)] = inst_29834);

return statearr_29897;
})();
var statearr_29898_29937 = state_29864__$1;
(statearr_29898_29937[(2)] = null);

(statearr_29898_29937[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (10))){
var inst_29823 = (state_29864[(8)]);
var inst_29824 = (state_29864[(15)]);
var inst_29822 = (state_29864[(2)]);
var inst_29823__$1 = cljs.core.nth.call(null,inst_29822,(0),null);
var inst_29824__$1 = cljs.core.nth.call(null,inst_29822,(1),null);
var inst_29825 = (inst_29823__$1 == null);
var inst_29826 = cljs.core._EQ_.call(null,inst_29824__$1,change);
var inst_29827 = (inst_29825) || (inst_29826);
var state_29864__$1 = (function (){var statearr_29899 = state_29864;
(statearr_29899[(8)] = inst_29823__$1);

(statearr_29899[(15)] = inst_29824__$1);

return statearr_29899;
})();
if(cljs.core.truth_(inst_29827)){
var statearr_29900_29938 = state_29864__$1;
(statearr_29900_29938[(1)] = (11));

} else {
var statearr_29901_29939 = state_29864__$1;
(statearr_29901_29939[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (18))){
var inst_29818 = (state_29864[(17)]);
var inst_29824 = (state_29864[(15)]);
var inst_29817 = (state_29864[(16)]);
var inst_29841 = cljs.core.empty_QMARK_.call(null,inst_29817);
var inst_29842 = inst_29818.call(null,inst_29824);
var inst_29843 = cljs.core.not.call(null,inst_29842);
var inst_29844 = (inst_29841) && (inst_29843);
var state_29864__$1 = state_29864;
var statearr_29902_29940 = state_29864__$1;
(statearr_29902_29940[(2)] = inst_29844);

(statearr_29902_29940[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29865 === (8))){
var inst_29808 = (state_29864[(7)]);
var state_29864__$1 = state_29864;
var statearr_29903_29941 = state_29864__$1;
(statearr_29903_29941[(2)] = inst_29808);

(statearr_29903_29941[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto___29911,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__20318__auto__,c__20380__auto___29911,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__20319__auto__ = null;
var cljs$core$async$mix_$_state_machine__20319__auto____0 = (function (){
var statearr_29907 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29907[(0)] = cljs$core$async$mix_$_state_machine__20319__auto__);

(statearr_29907[(1)] = (1));

return statearr_29907;
});
var cljs$core$async$mix_$_state_machine__20319__auto____1 = (function (state_29864){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_29864);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e29908){if((e29908 instanceof Object)){
var ex__20322__auto__ = e29908;
var statearr_29909_29942 = state_29864;
(statearr_29909_29942[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29864);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29908;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29943 = state_29864;
state_29864 = G__29943;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__20319__auto__ = function(state_29864){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__20319__auto____1.call(this,state_29864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__20319__auto____0;
cljs$core$async$mix_$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__20319__auto____1;
return cljs$core$async$mix_$_state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto___29911,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__20382__auto__ = (function (){var statearr_29910 = f__20381__auto__.call(null);
(statearr_29910[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___29911);

return statearr_29910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto___29911,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

cljs.core.async.Pub = (function (){var obj29945 = {};
return obj29945;
})();

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((function (){var and__16097__auto__ = p;
if(and__16097__auto__){
return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else {
return and__16097__auto__;
}
})()){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__16745__auto__ = (((p == null))?null:p);
return (function (){var or__16109__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__16745__auto__)]);
if(or__16109__auto__){
return or__16109__auto__;
} else {
var or__16109__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(or__16109__auto____$1){
return or__16109__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((function (){var and__16097__auto__ = p;
if(and__16097__auto__){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else {
return and__16097__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__16745__auto__ = (((p == null))?null:p);
return (function (){var or__16109__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__16745__auto__)]);
if(or__16109__auto__){
return or__16109__auto__;
} else {
var or__16109__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(or__16109__auto____$1){
return or__16109__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var G__29947 = arguments.length;
switch (G__29947) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((function (){var and__16097__auto__ = p;
if(and__16097__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else {
return and__16097__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__16745__auto__ = (((p == null))?null:p);
return (function (){var or__16109__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__16745__auto__)]);
if(or__16109__auto__){
return or__16109__auto__;
} else {
var or__16109__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__16109__auto____$1){
return or__16109__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((function (){var and__16097__auto__ = p;
if(and__16097__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else {
return and__16097__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__16745__auto__ = (((p == null))?null:p);
return (function (){var or__16109__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__16745__auto__)]);
if(or__16109__auto__){
return or__16109__auto__;
} else {
var or__16109__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__16109__auto____$1){
return or__16109__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var G__29951 = arguments.length;
switch (G__29951) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__16109__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__16109__auto__)){
return or__16109__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__16109__auto__,mults){
return (function (p1__29949_SHARP_){
if(cljs.core.truth_(p1__29949_SHARP_.call(null,topic))){
return p1__29949_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__29949_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__16109__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t29952 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29952 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta29953){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta29953 = meta29953;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29952.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_29954,meta29953__$1){
var self__ = this;
var _29954__$1 = this;
return (new cljs.core.async.t29952(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta29953__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t29952.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_29954){
var self__ = this;
var _29954__$1 = this;
return self__.meta29953;
});})(mults,ensure_mult))
;

cljs.core.async.t29952.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t29952.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t29952.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t29952.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t29952.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t29952.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t29952.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t29952.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta29953","meta29953",2098493533,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t29952.cljs$lang$type = true;

cljs.core.async.t29952.cljs$lang$ctorStr = "cljs.core.async/t29952";

cljs.core.async.t29952.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"cljs.core.async/t29952");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t29952 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t29952(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29953){
return (new cljs.core.async.t29952(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29953));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t29952(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20380__auto___30075 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto___30075,mults,ensure_mult,p){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto___30075,mults,ensure_mult,p){
return (function (state_30026){
var state_val_30027 = (state_30026[(1)]);
if((state_val_30027 === (7))){
var inst_30022 = (state_30026[(2)]);
var state_30026__$1 = state_30026;
var statearr_30028_30076 = state_30026__$1;
(statearr_30028_30076[(2)] = inst_30022);

(statearr_30028_30076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (20))){
var state_30026__$1 = state_30026;
var statearr_30029_30077 = state_30026__$1;
(statearr_30029_30077[(2)] = null);

(statearr_30029_30077[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (1))){
var state_30026__$1 = state_30026;
var statearr_30030_30078 = state_30026__$1;
(statearr_30030_30078[(2)] = null);

(statearr_30030_30078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (24))){
var inst_30005 = (state_30026[(7)]);
var inst_30014 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_30005);
var state_30026__$1 = state_30026;
var statearr_30031_30079 = state_30026__$1;
(statearr_30031_30079[(2)] = inst_30014);

(statearr_30031_30079[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (4))){
var inst_29957 = (state_30026[(8)]);
var inst_29957__$1 = (state_30026[(2)]);
var inst_29958 = (inst_29957__$1 == null);
var state_30026__$1 = (function (){var statearr_30032 = state_30026;
(statearr_30032[(8)] = inst_29957__$1);

return statearr_30032;
})();
if(cljs.core.truth_(inst_29958)){
var statearr_30033_30080 = state_30026__$1;
(statearr_30033_30080[(1)] = (5));

} else {
var statearr_30034_30081 = state_30026__$1;
(statearr_30034_30081[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (15))){
var inst_29999 = (state_30026[(2)]);
var state_30026__$1 = state_30026;
var statearr_30035_30082 = state_30026__$1;
(statearr_30035_30082[(2)] = inst_29999);

(statearr_30035_30082[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (21))){
var inst_30019 = (state_30026[(2)]);
var state_30026__$1 = (function (){var statearr_30036 = state_30026;
(statearr_30036[(9)] = inst_30019);

return statearr_30036;
})();
var statearr_30037_30083 = state_30026__$1;
(statearr_30037_30083[(2)] = null);

(statearr_30037_30083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (13))){
var inst_29981 = (state_30026[(10)]);
var inst_29983 = cljs.core.chunked_seq_QMARK_.call(null,inst_29981);
var state_30026__$1 = state_30026;
if(inst_29983){
var statearr_30038_30084 = state_30026__$1;
(statearr_30038_30084[(1)] = (16));

} else {
var statearr_30039_30085 = state_30026__$1;
(statearr_30039_30085[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (22))){
var inst_30011 = (state_30026[(2)]);
var state_30026__$1 = state_30026;
if(cljs.core.truth_(inst_30011)){
var statearr_30040_30086 = state_30026__$1;
(statearr_30040_30086[(1)] = (23));

} else {
var statearr_30041_30087 = state_30026__$1;
(statearr_30041_30087[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (6))){
var inst_30005 = (state_30026[(7)]);
var inst_30007 = (state_30026[(11)]);
var inst_29957 = (state_30026[(8)]);
var inst_30005__$1 = topic_fn.call(null,inst_29957);
var inst_30006 = cljs.core.deref.call(null,mults);
var inst_30007__$1 = cljs.core.get.call(null,inst_30006,inst_30005__$1);
var state_30026__$1 = (function (){var statearr_30042 = state_30026;
(statearr_30042[(7)] = inst_30005__$1);

(statearr_30042[(11)] = inst_30007__$1);

return statearr_30042;
})();
if(cljs.core.truth_(inst_30007__$1)){
var statearr_30043_30088 = state_30026__$1;
(statearr_30043_30088[(1)] = (19));

} else {
var statearr_30044_30089 = state_30026__$1;
(statearr_30044_30089[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (25))){
var inst_30016 = (state_30026[(2)]);
var state_30026__$1 = state_30026;
var statearr_30045_30090 = state_30026__$1;
(statearr_30045_30090[(2)] = inst_30016);

(statearr_30045_30090[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (17))){
var inst_29981 = (state_30026[(10)]);
var inst_29990 = cljs.core.first.call(null,inst_29981);
var inst_29991 = cljs.core.async.muxch_STAR_.call(null,inst_29990);
var inst_29992 = cljs.core.async.close_BANG_.call(null,inst_29991);
var inst_29993 = cljs.core.next.call(null,inst_29981);
var inst_29967 = inst_29993;
var inst_29968 = null;
var inst_29969 = (0);
var inst_29970 = (0);
var state_30026__$1 = (function (){var statearr_30046 = state_30026;
(statearr_30046[(12)] = inst_29970);

(statearr_30046[(13)] = inst_29992);

(statearr_30046[(14)] = inst_29968);

(statearr_30046[(15)] = inst_29969);

(statearr_30046[(16)] = inst_29967);

return statearr_30046;
})();
var statearr_30047_30091 = state_30026__$1;
(statearr_30047_30091[(2)] = null);

(statearr_30047_30091[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (3))){
var inst_30024 = (state_30026[(2)]);
var state_30026__$1 = state_30026;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30026__$1,inst_30024);
} else {
if((state_val_30027 === (12))){
var inst_30001 = (state_30026[(2)]);
var state_30026__$1 = state_30026;
var statearr_30048_30092 = state_30026__$1;
(statearr_30048_30092[(2)] = inst_30001);

(statearr_30048_30092[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (2))){
var state_30026__$1 = state_30026;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30026__$1,(4),ch);
} else {
if((state_val_30027 === (23))){
var state_30026__$1 = state_30026;
var statearr_30049_30093 = state_30026__$1;
(statearr_30049_30093[(2)] = null);

(statearr_30049_30093[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (19))){
var inst_30007 = (state_30026[(11)]);
var inst_29957 = (state_30026[(8)]);
var inst_30009 = cljs.core.async.muxch_STAR_.call(null,inst_30007);
var state_30026__$1 = state_30026;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30026__$1,(22),inst_30009,inst_29957);
} else {
if((state_val_30027 === (11))){
var inst_29981 = (state_30026[(10)]);
var inst_29967 = (state_30026[(16)]);
var inst_29981__$1 = cljs.core.seq.call(null,inst_29967);
var state_30026__$1 = (function (){var statearr_30050 = state_30026;
(statearr_30050[(10)] = inst_29981__$1);

return statearr_30050;
})();
if(inst_29981__$1){
var statearr_30051_30094 = state_30026__$1;
(statearr_30051_30094[(1)] = (13));

} else {
var statearr_30052_30095 = state_30026__$1;
(statearr_30052_30095[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (9))){
var inst_30003 = (state_30026[(2)]);
var state_30026__$1 = state_30026;
var statearr_30053_30096 = state_30026__$1;
(statearr_30053_30096[(2)] = inst_30003);

(statearr_30053_30096[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (5))){
var inst_29964 = cljs.core.deref.call(null,mults);
var inst_29965 = cljs.core.vals.call(null,inst_29964);
var inst_29966 = cljs.core.seq.call(null,inst_29965);
var inst_29967 = inst_29966;
var inst_29968 = null;
var inst_29969 = (0);
var inst_29970 = (0);
var state_30026__$1 = (function (){var statearr_30054 = state_30026;
(statearr_30054[(12)] = inst_29970);

(statearr_30054[(14)] = inst_29968);

(statearr_30054[(15)] = inst_29969);

(statearr_30054[(16)] = inst_29967);

return statearr_30054;
})();
var statearr_30055_30097 = state_30026__$1;
(statearr_30055_30097[(2)] = null);

(statearr_30055_30097[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (14))){
var state_30026__$1 = state_30026;
var statearr_30059_30098 = state_30026__$1;
(statearr_30059_30098[(2)] = null);

(statearr_30059_30098[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (16))){
var inst_29981 = (state_30026[(10)]);
var inst_29985 = cljs.core.chunk_first.call(null,inst_29981);
var inst_29986 = cljs.core.chunk_rest.call(null,inst_29981);
var inst_29987 = cljs.core.count.call(null,inst_29985);
var inst_29967 = inst_29986;
var inst_29968 = inst_29985;
var inst_29969 = inst_29987;
var inst_29970 = (0);
var state_30026__$1 = (function (){var statearr_30060 = state_30026;
(statearr_30060[(12)] = inst_29970);

(statearr_30060[(14)] = inst_29968);

(statearr_30060[(15)] = inst_29969);

(statearr_30060[(16)] = inst_29967);

return statearr_30060;
})();
var statearr_30061_30099 = state_30026__$1;
(statearr_30061_30099[(2)] = null);

(statearr_30061_30099[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (10))){
var inst_29970 = (state_30026[(12)]);
var inst_29968 = (state_30026[(14)]);
var inst_29969 = (state_30026[(15)]);
var inst_29967 = (state_30026[(16)]);
var inst_29975 = cljs.core._nth.call(null,inst_29968,inst_29970);
var inst_29976 = cljs.core.async.muxch_STAR_.call(null,inst_29975);
var inst_29977 = cljs.core.async.close_BANG_.call(null,inst_29976);
var inst_29978 = (inst_29970 + (1));
var tmp30056 = inst_29968;
var tmp30057 = inst_29969;
var tmp30058 = inst_29967;
var inst_29967__$1 = tmp30058;
var inst_29968__$1 = tmp30056;
var inst_29969__$1 = tmp30057;
var inst_29970__$1 = inst_29978;
var state_30026__$1 = (function (){var statearr_30062 = state_30026;
(statearr_30062[(12)] = inst_29970__$1);

(statearr_30062[(14)] = inst_29968__$1);

(statearr_30062[(15)] = inst_29969__$1);

(statearr_30062[(17)] = inst_29977);

(statearr_30062[(16)] = inst_29967__$1);

return statearr_30062;
})();
var statearr_30063_30100 = state_30026__$1;
(statearr_30063_30100[(2)] = null);

(statearr_30063_30100[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (18))){
var inst_29996 = (state_30026[(2)]);
var state_30026__$1 = state_30026;
var statearr_30064_30101 = state_30026__$1;
(statearr_30064_30101[(2)] = inst_29996);

(statearr_30064_30101[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (8))){
var inst_29970 = (state_30026[(12)]);
var inst_29969 = (state_30026[(15)]);
var inst_29972 = (inst_29970 < inst_29969);
var inst_29973 = inst_29972;
var state_30026__$1 = state_30026;
if(cljs.core.truth_(inst_29973)){
var statearr_30065_30102 = state_30026__$1;
(statearr_30065_30102[(1)] = (10));

} else {
var statearr_30066_30103 = state_30026__$1;
(statearr_30066_30103[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto___30075,mults,ensure_mult,p))
;
return ((function (switch__20318__auto__,c__20380__auto___30075,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__20319__auto__ = null;
var cljs$core$async$state_machine__20319__auto____0 = (function (){
var statearr_30070 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30070[(0)] = cljs$core$async$state_machine__20319__auto__);

(statearr_30070[(1)] = (1));

return statearr_30070;
});
var cljs$core$async$state_machine__20319__auto____1 = (function (state_30026){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_30026);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e30071){if((e30071 instanceof Object)){
var ex__20322__auto__ = e30071;
var statearr_30072_30104 = state_30026;
(statearr_30072_30104[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30026);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30071;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30105 = state_30026;
state_30026 = G__30105;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$state_machine__20319__auto__ = function(state_30026){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20319__auto____1.call(this,state_30026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20319__auto____0;
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20319__auto____1;
return cljs$core$async$state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto___30075,mults,ensure_mult,p))
})();
var state__20382__auto__ = (function (){var statearr_30073 = f__20381__auto__.call(null);
(statearr_30073[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___30075);

return statearr_30073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto___30075,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var G__30107 = arguments.length;
switch (G__30107) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var G__30110 = arguments.length;
switch (G__30110) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var G__30113 = arguments.length;
switch (G__30113) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__20380__auto___30183 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto___30183,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto___30183,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_30152){
var state_val_30153 = (state_30152[(1)]);
if((state_val_30153 === (7))){
var state_30152__$1 = state_30152;
var statearr_30154_30184 = state_30152__$1;
(statearr_30154_30184[(2)] = null);

(statearr_30154_30184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30153 === (1))){
var state_30152__$1 = state_30152;
var statearr_30155_30185 = state_30152__$1;
(statearr_30155_30185[(2)] = null);

(statearr_30155_30185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30153 === (4))){
var inst_30116 = (state_30152[(7)]);
var inst_30118 = (inst_30116 < cnt);
var state_30152__$1 = state_30152;
if(cljs.core.truth_(inst_30118)){
var statearr_30156_30186 = state_30152__$1;
(statearr_30156_30186[(1)] = (6));

} else {
var statearr_30157_30187 = state_30152__$1;
(statearr_30157_30187[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30153 === (15))){
var inst_30148 = (state_30152[(2)]);
var state_30152__$1 = state_30152;
var statearr_30158_30188 = state_30152__$1;
(statearr_30158_30188[(2)] = inst_30148);

(statearr_30158_30188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30153 === (13))){
var inst_30141 = cljs.core.async.close_BANG_.call(null,out);
var state_30152__$1 = state_30152;
var statearr_30159_30189 = state_30152__$1;
(statearr_30159_30189[(2)] = inst_30141);

(statearr_30159_30189[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30153 === (6))){
var state_30152__$1 = state_30152;
var statearr_30160_30190 = state_30152__$1;
(statearr_30160_30190[(2)] = null);

(statearr_30160_30190[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30153 === (3))){
var inst_30150 = (state_30152[(2)]);
var state_30152__$1 = state_30152;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30152__$1,inst_30150);
} else {
if((state_val_30153 === (12))){
var inst_30138 = (state_30152[(8)]);
var inst_30138__$1 = (state_30152[(2)]);
var inst_30139 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_30138__$1);
var state_30152__$1 = (function (){var statearr_30161 = state_30152;
(statearr_30161[(8)] = inst_30138__$1);

return statearr_30161;
})();
if(cljs.core.truth_(inst_30139)){
var statearr_30162_30191 = state_30152__$1;
(statearr_30162_30191[(1)] = (13));

} else {
var statearr_30163_30192 = state_30152__$1;
(statearr_30163_30192[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30153 === (2))){
var inst_30115 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_30116 = (0);
var state_30152__$1 = (function (){var statearr_30164 = state_30152;
(statearr_30164[(9)] = inst_30115);

(statearr_30164[(7)] = inst_30116);

return statearr_30164;
})();
var statearr_30165_30193 = state_30152__$1;
(statearr_30165_30193[(2)] = null);

(statearr_30165_30193[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30153 === (11))){
var inst_30116 = (state_30152[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_30152,(10),Object,null,(9));
var inst_30125 = chs__$1.call(null,inst_30116);
var inst_30126 = done.call(null,inst_30116);
var inst_30127 = cljs.core.async.take_BANG_.call(null,inst_30125,inst_30126);
var state_30152__$1 = state_30152;
var statearr_30166_30194 = state_30152__$1;
(statearr_30166_30194[(2)] = inst_30127);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30152__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30153 === (9))){
var inst_30116 = (state_30152[(7)]);
var inst_30129 = (state_30152[(2)]);
var inst_30130 = (inst_30116 + (1));
var inst_30116__$1 = inst_30130;
var state_30152__$1 = (function (){var statearr_30167 = state_30152;
(statearr_30167[(10)] = inst_30129);

(statearr_30167[(7)] = inst_30116__$1);

return statearr_30167;
})();
var statearr_30168_30195 = state_30152__$1;
(statearr_30168_30195[(2)] = null);

(statearr_30168_30195[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30153 === (5))){
var inst_30136 = (state_30152[(2)]);
var state_30152__$1 = (function (){var statearr_30169 = state_30152;
(statearr_30169[(11)] = inst_30136);

return statearr_30169;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30152__$1,(12),dchan);
} else {
if((state_val_30153 === (14))){
var inst_30138 = (state_30152[(8)]);
var inst_30143 = cljs.core.apply.call(null,f,inst_30138);
var state_30152__$1 = state_30152;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30152__$1,(16),out,inst_30143);
} else {
if((state_val_30153 === (16))){
var inst_30145 = (state_30152[(2)]);
var state_30152__$1 = (function (){var statearr_30170 = state_30152;
(statearr_30170[(12)] = inst_30145);

return statearr_30170;
})();
var statearr_30171_30196 = state_30152__$1;
(statearr_30171_30196[(2)] = null);

(statearr_30171_30196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30153 === (10))){
var inst_30120 = (state_30152[(2)]);
var inst_30121 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_30152__$1 = (function (){var statearr_30172 = state_30152;
(statearr_30172[(13)] = inst_30120);

return statearr_30172;
})();
var statearr_30173_30197 = state_30152__$1;
(statearr_30173_30197[(2)] = inst_30121);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30152__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30153 === (8))){
var inst_30134 = (state_30152[(2)]);
var state_30152__$1 = state_30152;
var statearr_30174_30198 = state_30152__$1;
(statearr_30174_30198[(2)] = inst_30134);

(statearr_30174_30198[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto___30183,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__20318__auto__,c__20380__auto___30183,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__20319__auto__ = null;
var cljs$core$async$state_machine__20319__auto____0 = (function (){
var statearr_30178 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30178[(0)] = cljs$core$async$state_machine__20319__auto__);

(statearr_30178[(1)] = (1));

return statearr_30178;
});
var cljs$core$async$state_machine__20319__auto____1 = (function (state_30152){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_30152);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e30179){if((e30179 instanceof Object)){
var ex__20322__auto__ = e30179;
var statearr_30180_30199 = state_30152;
(statearr_30180_30199[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30152);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30179;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30200 = state_30152;
state_30152 = G__30200;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$state_machine__20319__auto__ = function(state_30152){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20319__auto____1.call(this,state_30152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20319__auto____0;
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20319__auto____1;
return cljs$core$async$state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto___30183,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__20382__auto__ = (function (){var statearr_30181 = f__20381__auto__.call(null);
(statearr_30181[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___30183);

return statearr_30181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto___30183,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var G__30203 = arguments.length;
switch (G__30203) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20380__auto___30258 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto___30258,out){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto___30258,out){
return (function (state_30233){
var state_val_30234 = (state_30233[(1)]);
if((state_val_30234 === (7))){
var inst_30212 = (state_30233[(7)]);
var inst_30213 = (state_30233[(8)]);
var inst_30212__$1 = (state_30233[(2)]);
var inst_30213__$1 = cljs.core.nth.call(null,inst_30212__$1,(0),null);
var inst_30214 = cljs.core.nth.call(null,inst_30212__$1,(1),null);
var inst_30215 = (inst_30213__$1 == null);
var state_30233__$1 = (function (){var statearr_30235 = state_30233;
(statearr_30235[(7)] = inst_30212__$1);

(statearr_30235[(9)] = inst_30214);

(statearr_30235[(8)] = inst_30213__$1);

return statearr_30235;
})();
if(cljs.core.truth_(inst_30215)){
var statearr_30236_30259 = state_30233__$1;
(statearr_30236_30259[(1)] = (8));

} else {
var statearr_30237_30260 = state_30233__$1;
(statearr_30237_30260[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30234 === (1))){
var inst_30204 = cljs.core.vec.call(null,chs);
var inst_30205 = inst_30204;
var state_30233__$1 = (function (){var statearr_30238 = state_30233;
(statearr_30238[(10)] = inst_30205);

return statearr_30238;
})();
var statearr_30239_30261 = state_30233__$1;
(statearr_30239_30261[(2)] = null);

(statearr_30239_30261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30234 === (4))){
var inst_30205 = (state_30233[(10)]);
var state_30233__$1 = state_30233;
return cljs.core.async.ioc_alts_BANG_.call(null,state_30233__$1,(7),inst_30205);
} else {
if((state_val_30234 === (6))){
var inst_30229 = (state_30233[(2)]);
var state_30233__$1 = state_30233;
var statearr_30240_30262 = state_30233__$1;
(statearr_30240_30262[(2)] = inst_30229);

(statearr_30240_30262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30234 === (3))){
var inst_30231 = (state_30233[(2)]);
var state_30233__$1 = state_30233;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30233__$1,inst_30231);
} else {
if((state_val_30234 === (2))){
var inst_30205 = (state_30233[(10)]);
var inst_30207 = cljs.core.count.call(null,inst_30205);
var inst_30208 = (inst_30207 > (0));
var state_30233__$1 = state_30233;
if(cljs.core.truth_(inst_30208)){
var statearr_30242_30263 = state_30233__$1;
(statearr_30242_30263[(1)] = (4));

} else {
var statearr_30243_30264 = state_30233__$1;
(statearr_30243_30264[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30234 === (11))){
var inst_30205 = (state_30233[(10)]);
var inst_30222 = (state_30233[(2)]);
var tmp30241 = inst_30205;
var inst_30205__$1 = tmp30241;
var state_30233__$1 = (function (){var statearr_30244 = state_30233;
(statearr_30244[(10)] = inst_30205__$1);

(statearr_30244[(11)] = inst_30222);

return statearr_30244;
})();
var statearr_30245_30265 = state_30233__$1;
(statearr_30245_30265[(2)] = null);

(statearr_30245_30265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30234 === (9))){
var inst_30213 = (state_30233[(8)]);
var state_30233__$1 = state_30233;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30233__$1,(11),out,inst_30213);
} else {
if((state_val_30234 === (5))){
var inst_30227 = cljs.core.async.close_BANG_.call(null,out);
var state_30233__$1 = state_30233;
var statearr_30246_30266 = state_30233__$1;
(statearr_30246_30266[(2)] = inst_30227);

(statearr_30246_30266[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30234 === (10))){
var inst_30225 = (state_30233[(2)]);
var state_30233__$1 = state_30233;
var statearr_30247_30267 = state_30233__$1;
(statearr_30247_30267[(2)] = inst_30225);

(statearr_30247_30267[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30234 === (8))){
var inst_30212 = (state_30233[(7)]);
var inst_30214 = (state_30233[(9)]);
var inst_30205 = (state_30233[(10)]);
var inst_30213 = (state_30233[(8)]);
var inst_30217 = (function (){var cs = inst_30205;
var vec__30210 = inst_30212;
var v = inst_30213;
var c = inst_30214;
return ((function (cs,vec__30210,v,c,inst_30212,inst_30214,inst_30205,inst_30213,state_val_30234,c__20380__auto___30258,out){
return (function (p1__30201_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__30201_SHARP_);
});
;})(cs,vec__30210,v,c,inst_30212,inst_30214,inst_30205,inst_30213,state_val_30234,c__20380__auto___30258,out))
})();
var inst_30218 = cljs.core.filterv.call(null,inst_30217,inst_30205);
var inst_30205__$1 = inst_30218;
var state_30233__$1 = (function (){var statearr_30248 = state_30233;
(statearr_30248[(10)] = inst_30205__$1);

return statearr_30248;
})();
var statearr_30249_30268 = state_30233__$1;
(statearr_30249_30268[(2)] = null);

(statearr_30249_30268[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto___30258,out))
;
return ((function (switch__20318__auto__,c__20380__auto___30258,out){
return (function() {
var cljs$core$async$state_machine__20319__auto__ = null;
var cljs$core$async$state_machine__20319__auto____0 = (function (){
var statearr_30253 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30253[(0)] = cljs$core$async$state_machine__20319__auto__);

(statearr_30253[(1)] = (1));

return statearr_30253;
});
var cljs$core$async$state_machine__20319__auto____1 = (function (state_30233){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_30233);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e30254){if((e30254 instanceof Object)){
var ex__20322__auto__ = e30254;
var statearr_30255_30269 = state_30233;
(statearr_30255_30269[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30233);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30254;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30270 = state_30233;
state_30233 = G__30270;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$state_machine__20319__auto__ = function(state_30233){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20319__auto____1.call(this,state_30233);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20319__auto____0;
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20319__auto____1;
return cljs$core$async$state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto___30258,out))
})();
var state__20382__auto__ = (function (){var statearr_30256 = f__20381__auto__.call(null);
(statearr_30256[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___30258);

return statearr_30256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto___30258,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var G__30272 = arguments.length;
switch (G__30272) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20380__auto___30320 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto___30320,out){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto___30320,out){
return (function (state_30296){
var state_val_30297 = (state_30296[(1)]);
if((state_val_30297 === (7))){
var inst_30278 = (state_30296[(7)]);
var inst_30278__$1 = (state_30296[(2)]);
var inst_30279 = (inst_30278__$1 == null);
var inst_30280 = cljs.core.not.call(null,inst_30279);
var state_30296__$1 = (function (){var statearr_30298 = state_30296;
(statearr_30298[(7)] = inst_30278__$1);

return statearr_30298;
})();
if(inst_30280){
var statearr_30299_30321 = state_30296__$1;
(statearr_30299_30321[(1)] = (8));

} else {
var statearr_30300_30322 = state_30296__$1;
(statearr_30300_30322[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30297 === (1))){
var inst_30273 = (0);
var state_30296__$1 = (function (){var statearr_30301 = state_30296;
(statearr_30301[(8)] = inst_30273);

return statearr_30301;
})();
var statearr_30302_30323 = state_30296__$1;
(statearr_30302_30323[(2)] = null);

(statearr_30302_30323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30297 === (4))){
var state_30296__$1 = state_30296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30296__$1,(7),ch);
} else {
if((state_val_30297 === (6))){
var inst_30291 = (state_30296[(2)]);
var state_30296__$1 = state_30296;
var statearr_30303_30324 = state_30296__$1;
(statearr_30303_30324[(2)] = inst_30291);

(statearr_30303_30324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30297 === (3))){
var inst_30293 = (state_30296[(2)]);
var inst_30294 = cljs.core.async.close_BANG_.call(null,out);
var state_30296__$1 = (function (){var statearr_30304 = state_30296;
(statearr_30304[(9)] = inst_30293);

return statearr_30304;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30296__$1,inst_30294);
} else {
if((state_val_30297 === (2))){
var inst_30273 = (state_30296[(8)]);
var inst_30275 = (inst_30273 < n);
var state_30296__$1 = state_30296;
if(cljs.core.truth_(inst_30275)){
var statearr_30305_30325 = state_30296__$1;
(statearr_30305_30325[(1)] = (4));

} else {
var statearr_30306_30326 = state_30296__$1;
(statearr_30306_30326[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30297 === (11))){
var inst_30273 = (state_30296[(8)]);
var inst_30283 = (state_30296[(2)]);
var inst_30284 = (inst_30273 + (1));
var inst_30273__$1 = inst_30284;
var state_30296__$1 = (function (){var statearr_30307 = state_30296;
(statearr_30307[(8)] = inst_30273__$1);

(statearr_30307[(10)] = inst_30283);

return statearr_30307;
})();
var statearr_30308_30327 = state_30296__$1;
(statearr_30308_30327[(2)] = null);

(statearr_30308_30327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30297 === (9))){
var state_30296__$1 = state_30296;
var statearr_30309_30328 = state_30296__$1;
(statearr_30309_30328[(2)] = null);

(statearr_30309_30328[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30297 === (5))){
var state_30296__$1 = state_30296;
var statearr_30310_30329 = state_30296__$1;
(statearr_30310_30329[(2)] = null);

(statearr_30310_30329[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30297 === (10))){
var inst_30288 = (state_30296[(2)]);
var state_30296__$1 = state_30296;
var statearr_30311_30330 = state_30296__$1;
(statearr_30311_30330[(2)] = inst_30288);

(statearr_30311_30330[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30297 === (8))){
var inst_30278 = (state_30296[(7)]);
var state_30296__$1 = state_30296;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30296__$1,(11),out,inst_30278);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto___30320,out))
;
return ((function (switch__20318__auto__,c__20380__auto___30320,out){
return (function() {
var cljs$core$async$state_machine__20319__auto__ = null;
var cljs$core$async$state_machine__20319__auto____0 = (function (){
var statearr_30315 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30315[(0)] = cljs$core$async$state_machine__20319__auto__);

(statearr_30315[(1)] = (1));

return statearr_30315;
});
var cljs$core$async$state_machine__20319__auto____1 = (function (state_30296){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_30296);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e30316){if((e30316 instanceof Object)){
var ex__20322__auto__ = e30316;
var statearr_30317_30331 = state_30296;
(statearr_30317_30331[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30296);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30316;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30332 = state_30296;
state_30296 = G__30332;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$state_machine__20319__auto__ = function(state_30296){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20319__auto____1.call(this,state_30296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20319__auto____0;
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20319__auto____1;
return cljs$core$async$state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto___30320,out))
})();
var state__20382__auto__ = (function (){var statearr_30318 = f__20381__auto__.call(null);
(statearr_30318[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___30320);

return statearr_30318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto___30320,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t30340 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30340 = (function (map_LT_,f,ch,meta30341){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta30341 = meta30341;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30340.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30342,meta30341__$1){
var self__ = this;
var _30342__$1 = this;
return (new cljs.core.async.t30340(self__.map_LT_,self__.f,self__.ch,meta30341__$1));
});

cljs.core.async.t30340.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30342){
var self__ = this;
var _30342__$1 = this;
return self__.meta30341;
});

cljs.core.async.t30340.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t30340.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t30340.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t30340.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t30340.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t30343 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30343 = (function (map_LT_,f,ch,meta30341,_,fn1,meta30344){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta30341 = meta30341;
this._ = _;
this.fn1 = fn1;
this.meta30344 = meta30344;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30343.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_30345,meta30344__$1){
var self__ = this;
var _30345__$1 = this;
return (new cljs.core.async.t30343(self__.map_LT_,self__.f,self__.ch,self__.meta30341,self__._,self__.fn1,meta30344__$1));
});})(___$1))
;

cljs.core.async.t30343.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_30345){
var self__ = this;
var _30345__$1 = this;
return self__.meta30344;
});})(___$1))
;

cljs.core.async.t30343.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t30343.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t30343.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__30333_SHARP_){
return f1.call(null,(((p1__30333_SHARP_ == null))?null:self__.f.call(null,p1__30333_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t30343.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30341","meta30341",-93325933,null),new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta30344","meta30344",1858074460,null)], null);
});})(___$1))
;

cljs.core.async.t30343.cljs$lang$type = true;

cljs.core.async.t30343.cljs$lang$ctorStr = "cljs.core.async/t30343";

cljs.core.async.t30343.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"cljs.core.async/t30343");
});})(___$1))
;

cljs.core.async.__GT_t30343 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t30343(map_LT___$1,f__$1,ch__$1,meta30341__$1,___$2,fn1__$1,meta30344){
return (new cljs.core.async.t30343(map_LT___$1,f__$1,ch__$1,meta30341__$1,___$2,fn1__$1,meta30344));
});})(___$1))
;

}

return (new cljs.core.async.t30343(self__.map_LT_,self__.f,self__.ch,self__.meta30341,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__16097__auto__ = ret;
if(cljs.core.truth_(and__16097__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__16097__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t30340.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t30340.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t30340.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30341","meta30341",-93325933,null)], null);
});

cljs.core.async.t30340.cljs$lang$type = true;

cljs.core.async.t30340.cljs$lang$ctorStr = "cljs.core.async/t30340";

cljs.core.async.t30340.cljs$lang$ctorPrWriter = (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"cljs.core.async/t30340");
});

cljs.core.async.__GT_t30340 = (function cljs$core$async$map_LT__$___GT_t30340(map_LT___$1,f__$1,ch__$1,meta30341){
return (new cljs.core.async.t30340(map_LT___$1,f__$1,ch__$1,meta30341));
});

}

return (new cljs.core.async.t30340(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t30349 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30349 = (function (map_GT_,f,ch,meta30350){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta30350 = meta30350;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30349.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30351,meta30350__$1){
var self__ = this;
var _30351__$1 = this;
return (new cljs.core.async.t30349(self__.map_GT_,self__.f,self__.ch,meta30350__$1));
});

cljs.core.async.t30349.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30351){
var self__ = this;
var _30351__$1 = this;
return self__.meta30350;
});

cljs.core.async.t30349.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t30349.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t30349.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t30349.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t30349.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t30349.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t30349.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30350","meta30350",-1400752912,null)], null);
});

cljs.core.async.t30349.cljs$lang$type = true;

cljs.core.async.t30349.cljs$lang$ctorStr = "cljs.core.async/t30349";

cljs.core.async.t30349.cljs$lang$ctorPrWriter = (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"cljs.core.async/t30349");
});

cljs.core.async.__GT_t30349 = (function cljs$core$async$map_GT__$___GT_t30349(map_GT___$1,f__$1,ch__$1,meta30350){
return (new cljs.core.async.t30349(map_GT___$1,f__$1,ch__$1,meta30350));
});

}

return (new cljs.core.async.t30349(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t30355 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30355 = (function (filter_GT_,p,ch,meta30356){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta30356 = meta30356;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30355.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30357,meta30356__$1){
var self__ = this;
var _30357__$1 = this;
return (new cljs.core.async.t30355(self__.filter_GT_,self__.p,self__.ch,meta30356__$1));
});

cljs.core.async.t30355.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30357){
var self__ = this;
var _30357__$1 = this;
return self__.meta30356;
});

cljs.core.async.t30355.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t30355.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t30355.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t30355.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t30355.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t30355.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t30355.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t30355.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30356","meta30356",-1818201696,null)], null);
});

cljs.core.async.t30355.cljs$lang$type = true;

cljs.core.async.t30355.cljs$lang$ctorStr = "cljs.core.async/t30355";

cljs.core.async.t30355.cljs$lang$ctorPrWriter = (function (this__16688__auto__,writer__16689__auto__,opt__16690__auto__){
return cljs.core._write.call(null,writer__16689__auto__,"cljs.core.async/t30355");
});

cljs.core.async.__GT_t30355 = (function cljs$core$async$filter_GT__$___GT_t30355(filter_GT___$1,p__$1,ch__$1,meta30356){
return (new cljs.core.async.t30355(filter_GT___$1,p__$1,ch__$1,meta30356));
});

}

return (new cljs.core.async.t30355(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var G__30359 = arguments.length;
switch (G__30359) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20380__auto___30402 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto___30402,out){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto___30402,out){
return (function (state_30380){
var state_val_30381 = (state_30380[(1)]);
if((state_val_30381 === (7))){
var inst_30376 = (state_30380[(2)]);
var state_30380__$1 = state_30380;
var statearr_30382_30403 = state_30380__$1;
(statearr_30382_30403[(2)] = inst_30376);

(statearr_30382_30403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30381 === (1))){
var state_30380__$1 = state_30380;
var statearr_30383_30404 = state_30380__$1;
(statearr_30383_30404[(2)] = null);

(statearr_30383_30404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30381 === (4))){
var inst_30362 = (state_30380[(7)]);
var inst_30362__$1 = (state_30380[(2)]);
var inst_30363 = (inst_30362__$1 == null);
var state_30380__$1 = (function (){var statearr_30384 = state_30380;
(statearr_30384[(7)] = inst_30362__$1);

return statearr_30384;
})();
if(cljs.core.truth_(inst_30363)){
var statearr_30385_30405 = state_30380__$1;
(statearr_30385_30405[(1)] = (5));

} else {
var statearr_30386_30406 = state_30380__$1;
(statearr_30386_30406[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30381 === (6))){
var inst_30362 = (state_30380[(7)]);
var inst_30367 = p.call(null,inst_30362);
var state_30380__$1 = state_30380;
if(cljs.core.truth_(inst_30367)){
var statearr_30387_30407 = state_30380__$1;
(statearr_30387_30407[(1)] = (8));

} else {
var statearr_30388_30408 = state_30380__$1;
(statearr_30388_30408[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30381 === (3))){
var inst_30378 = (state_30380[(2)]);
var state_30380__$1 = state_30380;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30380__$1,inst_30378);
} else {
if((state_val_30381 === (2))){
var state_30380__$1 = state_30380;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30380__$1,(4),ch);
} else {
if((state_val_30381 === (11))){
var inst_30370 = (state_30380[(2)]);
var state_30380__$1 = state_30380;
var statearr_30389_30409 = state_30380__$1;
(statearr_30389_30409[(2)] = inst_30370);

(statearr_30389_30409[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30381 === (9))){
var state_30380__$1 = state_30380;
var statearr_30390_30410 = state_30380__$1;
(statearr_30390_30410[(2)] = null);

(statearr_30390_30410[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30381 === (5))){
var inst_30365 = cljs.core.async.close_BANG_.call(null,out);
var state_30380__$1 = state_30380;
var statearr_30391_30411 = state_30380__$1;
(statearr_30391_30411[(2)] = inst_30365);

(statearr_30391_30411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30381 === (10))){
var inst_30373 = (state_30380[(2)]);
var state_30380__$1 = (function (){var statearr_30392 = state_30380;
(statearr_30392[(8)] = inst_30373);

return statearr_30392;
})();
var statearr_30393_30412 = state_30380__$1;
(statearr_30393_30412[(2)] = null);

(statearr_30393_30412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30381 === (8))){
var inst_30362 = (state_30380[(7)]);
var state_30380__$1 = state_30380;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30380__$1,(11),out,inst_30362);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto___30402,out))
;
return ((function (switch__20318__auto__,c__20380__auto___30402,out){
return (function() {
var cljs$core$async$state_machine__20319__auto__ = null;
var cljs$core$async$state_machine__20319__auto____0 = (function (){
var statearr_30397 = [null,null,null,null,null,null,null,null,null];
(statearr_30397[(0)] = cljs$core$async$state_machine__20319__auto__);

(statearr_30397[(1)] = (1));

return statearr_30397;
});
var cljs$core$async$state_machine__20319__auto____1 = (function (state_30380){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_30380);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e30398){if((e30398 instanceof Object)){
var ex__20322__auto__ = e30398;
var statearr_30399_30413 = state_30380;
(statearr_30399_30413[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30380);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30398;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30414 = state_30380;
state_30380 = G__30414;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$state_machine__20319__auto__ = function(state_30380){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20319__auto____1.call(this,state_30380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20319__auto____0;
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20319__auto____1;
return cljs$core$async$state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto___30402,out))
})();
var state__20382__auto__ = (function (){var statearr_30400 = f__20381__auto__.call(null);
(statearr_30400[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___30402);

return statearr_30400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto___30402,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var G__30416 = arguments.length;
switch (G__30416) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__20380__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto__){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto__){
return (function (state_30583){
var state_val_30584 = (state_30583[(1)]);
if((state_val_30584 === (7))){
var inst_30579 = (state_30583[(2)]);
var state_30583__$1 = state_30583;
var statearr_30585_30626 = state_30583__$1;
(statearr_30585_30626[(2)] = inst_30579);

(statearr_30585_30626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (20))){
var inst_30549 = (state_30583[(7)]);
var inst_30560 = (state_30583[(2)]);
var inst_30561 = cljs.core.next.call(null,inst_30549);
var inst_30535 = inst_30561;
var inst_30536 = null;
var inst_30537 = (0);
var inst_30538 = (0);
var state_30583__$1 = (function (){var statearr_30586 = state_30583;
(statearr_30586[(8)] = inst_30535);

(statearr_30586[(9)] = inst_30537);

(statearr_30586[(10)] = inst_30536);

(statearr_30586[(11)] = inst_30538);

(statearr_30586[(12)] = inst_30560);

return statearr_30586;
})();
var statearr_30587_30627 = state_30583__$1;
(statearr_30587_30627[(2)] = null);

(statearr_30587_30627[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (1))){
var state_30583__$1 = state_30583;
var statearr_30588_30628 = state_30583__$1;
(statearr_30588_30628[(2)] = null);

(statearr_30588_30628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (4))){
var inst_30524 = (state_30583[(13)]);
var inst_30524__$1 = (state_30583[(2)]);
var inst_30525 = (inst_30524__$1 == null);
var state_30583__$1 = (function (){var statearr_30589 = state_30583;
(statearr_30589[(13)] = inst_30524__$1);

return statearr_30589;
})();
if(cljs.core.truth_(inst_30525)){
var statearr_30590_30629 = state_30583__$1;
(statearr_30590_30629[(1)] = (5));

} else {
var statearr_30591_30630 = state_30583__$1;
(statearr_30591_30630[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (15))){
var state_30583__$1 = state_30583;
var statearr_30595_30631 = state_30583__$1;
(statearr_30595_30631[(2)] = null);

(statearr_30595_30631[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (21))){
var state_30583__$1 = state_30583;
var statearr_30596_30632 = state_30583__$1;
(statearr_30596_30632[(2)] = null);

(statearr_30596_30632[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (13))){
var inst_30535 = (state_30583[(8)]);
var inst_30537 = (state_30583[(9)]);
var inst_30536 = (state_30583[(10)]);
var inst_30538 = (state_30583[(11)]);
var inst_30545 = (state_30583[(2)]);
var inst_30546 = (inst_30538 + (1));
var tmp30592 = inst_30535;
var tmp30593 = inst_30537;
var tmp30594 = inst_30536;
var inst_30535__$1 = tmp30592;
var inst_30536__$1 = tmp30594;
var inst_30537__$1 = tmp30593;
var inst_30538__$1 = inst_30546;
var state_30583__$1 = (function (){var statearr_30597 = state_30583;
(statearr_30597[(8)] = inst_30535__$1);

(statearr_30597[(9)] = inst_30537__$1);

(statearr_30597[(14)] = inst_30545);

(statearr_30597[(10)] = inst_30536__$1);

(statearr_30597[(11)] = inst_30538__$1);

return statearr_30597;
})();
var statearr_30598_30633 = state_30583__$1;
(statearr_30598_30633[(2)] = null);

(statearr_30598_30633[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (22))){
var state_30583__$1 = state_30583;
var statearr_30599_30634 = state_30583__$1;
(statearr_30599_30634[(2)] = null);

(statearr_30599_30634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (6))){
var inst_30524 = (state_30583[(13)]);
var inst_30533 = f.call(null,inst_30524);
var inst_30534 = cljs.core.seq.call(null,inst_30533);
var inst_30535 = inst_30534;
var inst_30536 = null;
var inst_30537 = (0);
var inst_30538 = (0);
var state_30583__$1 = (function (){var statearr_30600 = state_30583;
(statearr_30600[(8)] = inst_30535);

(statearr_30600[(9)] = inst_30537);

(statearr_30600[(10)] = inst_30536);

(statearr_30600[(11)] = inst_30538);

return statearr_30600;
})();
var statearr_30601_30635 = state_30583__$1;
(statearr_30601_30635[(2)] = null);

(statearr_30601_30635[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (17))){
var inst_30549 = (state_30583[(7)]);
var inst_30553 = cljs.core.chunk_first.call(null,inst_30549);
var inst_30554 = cljs.core.chunk_rest.call(null,inst_30549);
var inst_30555 = cljs.core.count.call(null,inst_30553);
var inst_30535 = inst_30554;
var inst_30536 = inst_30553;
var inst_30537 = inst_30555;
var inst_30538 = (0);
var state_30583__$1 = (function (){var statearr_30602 = state_30583;
(statearr_30602[(8)] = inst_30535);

(statearr_30602[(9)] = inst_30537);

(statearr_30602[(10)] = inst_30536);

(statearr_30602[(11)] = inst_30538);

return statearr_30602;
})();
var statearr_30603_30636 = state_30583__$1;
(statearr_30603_30636[(2)] = null);

(statearr_30603_30636[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (3))){
var inst_30581 = (state_30583[(2)]);
var state_30583__$1 = state_30583;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30583__$1,inst_30581);
} else {
if((state_val_30584 === (12))){
var inst_30569 = (state_30583[(2)]);
var state_30583__$1 = state_30583;
var statearr_30604_30637 = state_30583__$1;
(statearr_30604_30637[(2)] = inst_30569);

(statearr_30604_30637[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (2))){
var state_30583__$1 = state_30583;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30583__$1,(4),in$);
} else {
if((state_val_30584 === (23))){
var inst_30577 = (state_30583[(2)]);
var state_30583__$1 = state_30583;
var statearr_30605_30638 = state_30583__$1;
(statearr_30605_30638[(2)] = inst_30577);

(statearr_30605_30638[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (19))){
var inst_30564 = (state_30583[(2)]);
var state_30583__$1 = state_30583;
var statearr_30606_30639 = state_30583__$1;
(statearr_30606_30639[(2)] = inst_30564);

(statearr_30606_30639[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (11))){
var inst_30535 = (state_30583[(8)]);
var inst_30549 = (state_30583[(7)]);
var inst_30549__$1 = cljs.core.seq.call(null,inst_30535);
var state_30583__$1 = (function (){var statearr_30607 = state_30583;
(statearr_30607[(7)] = inst_30549__$1);

return statearr_30607;
})();
if(inst_30549__$1){
var statearr_30608_30640 = state_30583__$1;
(statearr_30608_30640[(1)] = (14));

} else {
var statearr_30609_30641 = state_30583__$1;
(statearr_30609_30641[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (9))){
var inst_30571 = (state_30583[(2)]);
var inst_30572 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_30583__$1 = (function (){var statearr_30610 = state_30583;
(statearr_30610[(15)] = inst_30571);

return statearr_30610;
})();
if(cljs.core.truth_(inst_30572)){
var statearr_30611_30642 = state_30583__$1;
(statearr_30611_30642[(1)] = (21));

} else {
var statearr_30612_30643 = state_30583__$1;
(statearr_30612_30643[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (5))){
var inst_30527 = cljs.core.async.close_BANG_.call(null,out);
var state_30583__$1 = state_30583;
var statearr_30613_30644 = state_30583__$1;
(statearr_30613_30644[(2)] = inst_30527);

(statearr_30613_30644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (14))){
var inst_30549 = (state_30583[(7)]);
var inst_30551 = cljs.core.chunked_seq_QMARK_.call(null,inst_30549);
var state_30583__$1 = state_30583;
if(inst_30551){
var statearr_30614_30645 = state_30583__$1;
(statearr_30614_30645[(1)] = (17));

} else {
var statearr_30615_30646 = state_30583__$1;
(statearr_30615_30646[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (16))){
var inst_30567 = (state_30583[(2)]);
var state_30583__$1 = state_30583;
var statearr_30616_30647 = state_30583__$1;
(statearr_30616_30647[(2)] = inst_30567);

(statearr_30616_30647[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (10))){
var inst_30536 = (state_30583[(10)]);
var inst_30538 = (state_30583[(11)]);
var inst_30543 = cljs.core._nth.call(null,inst_30536,inst_30538);
var state_30583__$1 = state_30583;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30583__$1,(13),out,inst_30543);
} else {
if((state_val_30584 === (18))){
var inst_30549 = (state_30583[(7)]);
var inst_30558 = cljs.core.first.call(null,inst_30549);
var state_30583__$1 = state_30583;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30583__$1,(20),out,inst_30558);
} else {
if((state_val_30584 === (8))){
var inst_30537 = (state_30583[(9)]);
var inst_30538 = (state_30583[(11)]);
var inst_30540 = (inst_30538 < inst_30537);
var inst_30541 = inst_30540;
var state_30583__$1 = state_30583;
if(cljs.core.truth_(inst_30541)){
var statearr_30617_30648 = state_30583__$1;
(statearr_30617_30648[(1)] = (10));

} else {
var statearr_30618_30649 = state_30583__$1;
(statearr_30618_30649[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto__))
;
return ((function (switch__20318__auto__,c__20380__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__20319__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__20319__auto____0 = (function (){
var statearr_30622 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30622[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__20319__auto__);

(statearr_30622[(1)] = (1));

return statearr_30622;
});
var cljs$core$async$mapcat_STAR__$_state_machine__20319__auto____1 = (function (state_30583){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_30583);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e30623){if((e30623 instanceof Object)){
var ex__20322__auto__ = e30623;
var statearr_30624_30650 = state_30583;
(statearr_30624_30650[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30583);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30623;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30651 = state_30583;
state_30583 = G__30651;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__20319__auto__ = function(state_30583){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__20319__auto____1.call(this,state_30583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__20319__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__20319__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto__))
})();
var state__20382__auto__ = (function (){var statearr_30625 = f__20381__auto__.call(null);
(statearr_30625[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto__);

return statearr_30625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto__))
);

return c__20380__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var G__30653 = arguments.length;
switch (G__30653) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var G__30656 = arguments.length;
switch (G__30656) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var G__30659 = arguments.length;
switch (G__30659) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20380__auto___30709 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto___30709,out){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto___30709,out){
return (function (state_30683){
var state_val_30684 = (state_30683[(1)]);
if((state_val_30684 === (7))){
var inst_30678 = (state_30683[(2)]);
var state_30683__$1 = state_30683;
var statearr_30685_30710 = state_30683__$1;
(statearr_30685_30710[(2)] = inst_30678);

(statearr_30685_30710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30684 === (1))){
var inst_30660 = null;
var state_30683__$1 = (function (){var statearr_30686 = state_30683;
(statearr_30686[(7)] = inst_30660);

return statearr_30686;
})();
var statearr_30687_30711 = state_30683__$1;
(statearr_30687_30711[(2)] = null);

(statearr_30687_30711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30684 === (4))){
var inst_30663 = (state_30683[(8)]);
var inst_30663__$1 = (state_30683[(2)]);
var inst_30664 = (inst_30663__$1 == null);
var inst_30665 = cljs.core.not.call(null,inst_30664);
var state_30683__$1 = (function (){var statearr_30688 = state_30683;
(statearr_30688[(8)] = inst_30663__$1);

return statearr_30688;
})();
if(inst_30665){
var statearr_30689_30712 = state_30683__$1;
(statearr_30689_30712[(1)] = (5));

} else {
var statearr_30690_30713 = state_30683__$1;
(statearr_30690_30713[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30684 === (6))){
var state_30683__$1 = state_30683;
var statearr_30691_30714 = state_30683__$1;
(statearr_30691_30714[(2)] = null);

(statearr_30691_30714[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30684 === (3))){
var inst_30680 = (state_30683[(2)]);
var inst_30681 = cljs.core.async.close_BANG_.call(null,out);
var state_30683__$1 = (function (){var statearr_30692 = state_30683;
(statearr_30692[(9)] = inst_30680);

return statearr_30692;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30683__$1,inst_30681);
} else {
if((state_val_30684 === (2))){
var state_30683__$1 = state_30683;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30683__$1,(4),ch);
} else {
if((state_val_30684 === (11))){
var inst_30663 = (state_30683[(8)]);
var inst_30672 = (state_30683[(2)]);
var inst_30660 = inst_30663;
var state_30683__$1 = (function (){var statearr_30693 = state_30683;
(statearr_30693[(7)] = inst_30660);

(statearr_30693[(10)] = inst_30672);

return statearr_30693;
})();
var statearr_30694_30715 = state_30683__$1;
(statearr_30694_30715[(2)] = null);

(statearr_30694_30715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30684 === (9))){
var inst_30663 = (state_30683[(8)]);
var state_30683__$1 = state_30683;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30683__$1,(11),out,inst_30663);
} else {
if((state_val_30684 === (5))){
var inst_30663 = (state_30683[(8)]);
var inst_30660 = (state_30683[(7)]);
var inst_30667 = cljs.core._EQ_.call(null,inst_30663,inst_30660);
var state_30683__$1 = state_30683;
if(inst_30667){
var statearr_30696_30716 = state_30683__$1;
(statearr_30696_30716[(1)] = (8));

} else {
var statearr_30697_30717 = state_30683__$1;
(statearr_30697_30717[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30684 === (10))){
var inst_30675 = (state_30683[(2)]);
var state_30683__$1 = state_30683;
var statearr_30698_30718 = state_30683__$1;
(statearr_30698_30718[(2)] = inst_30675);

(statearr_30698_30718[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30684 === (8))){
var inst_30660 = (state_30683[(7)]);
var tmp30695 = inst_30660;
var inst_30660__$1 = tmp30695;
var state_30683__$1 = (function (){var statearr_30699 = state_30683;
(statearr_30699[(7)] = inst_30660__$1);

return statearr_30699;
})();
var statearr_30700_30719 = state_30683__$1;
(statearr_30700_30719[(2)] = null);

(statearr_30700_30719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto___30709,out))
;
return ((function (switch__20318__auto__,c__20380__auto___30709,out){
return (function() {
var cljs$core$async$state_machine__20319__auto__ = null;
var cljs$core$async$state_machine__20319__auto____0 = (function (){
var statearr_30704 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30704[(0)] = cljs$core$async$state_machine__20319__auto__);

(statearr_30704[(1)] = (1));

return statearr_30704;
});
var cljs$core$async$state_machine__20319__auto____1 = (function (state_30683){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_30683);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e30705){if((e30705 instanceof Object)){
var ex__20322__auto__ = e30705;
var statearr_30706_30720 = state_30683;
(statearr_30706_30720[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30683);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30705;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30721 = state_30683;
state_30683 = G__30721;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$state_machine__20319__auto__ = function(state_30683){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20319__auto____1.call(this,state_30683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20319__auto____0;
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20319__auto____1;
return cljs$core$async$state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto___30709,out))
})();
var state__20382__auto__ = (function (){var statearr_30707 = f__20381__auto__.call(null);
(statearr_30707[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___30709);

return statearr_30707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto___30709,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var G__30723 = arguments.length;
switch (G__30723) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20380__auto___30792 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto___30792,out){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto___30792,out){
return (function (state_30761){
var state_val_30762 = (state_30761[(1)]);
if((state_val_30762 === (7))){
var inst_30757 = (state_30761[(2)]);
var state_30761__$1 = state_30761;
var statearr_30763_30793 = state_30761__$1;
(statearr_30763_30793[(2)] = inst_30757);

(statearr_30763_30793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30762 === (1))){
var inst_30724 = (new Array(n));
var inst_30725 = inst_30724;
var inst_30726 = (0);
var state_30761__$1 = (function (){var statearr_30764 = state_30761;
(statearr_30764[(7)] = inst_30726);

(statearr_30764[(8)] = inst_30725);

return statearr_30764;
})();
var statearr_30765_30794 = state_30761__$1;
(statearr_30765_30794[(2)] = null);

(statearr_30765_30794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30762 === (4))){
var inst_30729 = (state_30761[(9)]);
var inst_30729__$1 = (state_30761[(2)]);
var inst_30730 = (inst_30729__$1 == null);
var inst_30731 = cljs.core.not.call(null,inst_30730);
var state_30761__$1 = (function (){var statearr_30766 = state_30761;
(statearr_30766[(9)] = inst_30729__$1);

return statearr_30766;
})();
if(inst_30731){
var statearr_30767_30795 = state_30761__$1;
(statearr_30767_30795[(1)] = (5));

} else {
var statearr_30768_30796 = state_30761__$1;
(statearr_30768_30796[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30762 === (15))){
var inst_30751 = (state_30761[(2)]);
var state_30761__$1 = state_30761;
var statearr_30769_30797 = state_30761__$1;
(statearr_30769_30797[(2)] = inst_30751);

(statearr_30769_30797[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30762 === (13))){
var state_30761__$1 = state_30761;
var statearr_30770_30798 = state_30761__$1;
(statearr_30770_30798[(2)] = null);

(statearr_30770_30798[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30762 === (6))){
var inst_30726 = (state_30761[(7)]);
var inst_30747 = (inst_30726 > (0));
var state_30761__$1 = state_30761;
if(cljs.core.truth_(inst_30747)){
var statearr_30771_30799 = state_30761__$1;
(statearr_30771_30799[(1)] = (12));

} else {
var statearr_30772_30800 = state_30761__$1;
(statearr_30772_30800[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30762 === (3))){
var inst_30759 = (state_30761[(2)]);
var state_30761__$1 = state_30761;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30761__$1,inst_30759);
} else {
if((state_val_30762 === (12))){
var inst_30725 = (state_30761[(8)]);
var inst_30749 = cljs.core.vec.call(null,inst_30725);
var state_30761__$1 = state_30761;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30761__$1,(15),out,inst_30749);
} else {
if((state_val_30762 === (2))){
var state_30761__$1 = state_30761;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30761__$1,(4),ch);
} else {
if((state_val_30762 === (11))){
var inst_30741 = (state_30761[(2)]);
var inst_30742 = (new Array(n));
var inst_30725 = inst_30742;
var inst_30726 = (0);
var state_30761__$1 = (function (){var statearr_30773 = state_30761;
(statearr_30773[(7)] = inst_30726);

(statearr_30773[(8)] = inst_30725);

(statearr_30773[(10)] = inst_30741);

return statearr_30773;
})();
var statearr_30774_30801 = state_30761__$1;
(statearr_30774_30801[(2)] = null);

(statearr_30774_30801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30762 === (9))){
var inst_30725 = (state_30761[(8)]);
var inst_30739 = cljs.core.vec.call(null,inst_30725);
var state_30761__$1 = state_30761;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30761__$1,(11),out,inst_30739);
} else {
if((state_val_30762 === (5))){
var inst_30726 = (state_30761[(7)]);
var inst_30734 = (state_30761[(11)]);
var inst_30725 = (state_30761[(8)]);
var inst_30729 = (state_30761[(9)]);
var inst_30733 = (inst_30725[inst_30726] = inst_30729);
var inst_30734__$1 = (inst_30726 + (1));
var inst_30735 = (inst_30734__$1 < n);
var state_30761__$1 = (function (){var statearr_30775 = state_30761;
(statearr_30775[(11)] = inst_30734__$1);

(statearr_30775[(12)] = inst_30733);

return statearr_30775;
})();
if(cljs.core.truth_(inst_30735)){
var statearr_30776_30802 = state_30761__$1;
(statearr_30776_30802[(1)] = (8));

} else {
var statearr_30777_30803 = state_30761__$1;
(statearr_30777_30803[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30762 === (14))){
var inst_30754 = (state_30761[(2)]);
var inst_30755 = cljs.core.async.close_BANG_.call(null,out);
var state_30761__$1 = (function (){var statearr_30779 = state_30761;
(statearr_30779[(13)] = inst_30754);

return statearr_30779;
})();
var statearr_30780_30804 = state_30761__$1;
(statearr_30780_30804[(2)] = inst_30755);

(statearr_30780_30804[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30762 === (10))){
var inst_30745 = (state_30761[(2)]);
var state_30761__$1 = state_30761;
var statearr_30781_30805 = state_30761__$1;
(statearr_30781_30805[(2)] = inst_30745);

(statearr_30781_30805[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30762 === (8))){
var inst_30734 = (state_30761[(11)]);
var inst_30725 = (state_30761[(8)]);
var tmp30778 = inst_30725;
var inst_30725__$1 = tmp30778;
var inst_30726 = inst_30734;
var state_30761__$1 = (function (){var statearr_30782 = state_30761;
(statearr_30782[(7)] = inst_30726);

(statearr_30782[(8)] = inst_30725__$1);

return statearr_30782;
})();
var statearr_30783_30806 = state_30761__$1;
(statearr_30783_30806[(2)] = null);

(statearr_30783_30806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto___30792,out))
;
return ((function (switch__20318__auto__,c__20380__auto___30792,out){
return (function() {
var cljs$core$async$state_machine__20319__auto__ = null;
var cljs$core$async$state_machine__20319__auto____0 = (function (){
var statearr_30787 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30787[(0)] = cljs$core$async$state_machine__20319__auto__);

(statearr_30787[(1)] = (1));

return statearr_30787;
});
var cljs$core$async$state_machine__20319__auto____1 = (function (state_30761){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_30761);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e30788){if((e30788 instanceof Object)){
var ex__20322__auto__ = e30788;
var statearr_30789_30807 = state_30761;
(statearr_30789_30807[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30761);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30788;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30808 = state_30761;
state_30761 = G__30808;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$state_machine__20319__auto__ = function(state_30761){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20319__auto____1.call(this,state_30761);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20319__auto____0;
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20319__auto____1;
return cljs$core$async$state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto___30792,out))
})();
var state__20382__auto__ = (function (){var statearr_30790 = f__20381__auto__.call(null);
(statearr_30790[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___30792);

return statearr_30790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto___30792,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var G__30810 = arguments.length;
switch (G__30810) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20380__auto___30883 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto___30883,out){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto___30883,out){
return (function (state_30852){
var state_val_30853 = (state_30852[(1)]);
if((state_val_30853 === (7))){
var inst_30848 = (state_30852[(2)]);
var state_30852__$1 = state_30852;
var statearr_30854_30884 = state_30852__$1;
(statearr_30854_30884[(2)] = inst_30848);

(statearr_30854_30884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30853 === (1))){
var inst_30811 = [];
var inst_30812 = inst_30811;
var inst_30813 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_30852__$1 = (function (){var statearr_30855 = state_30852;
(statearr_30855[(7)] = inst_30812);

(statearr_30855[(8)] = inst_30813);

return statearr_30855;
})();
var statearr_30856_30885 = state_30852__$1;
(statearr_30856_30885[(2)] = null);

(statearr_30856_30885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30853 === (4))){
var inst_30816 = (state_30852[(9)]);
var inst_30816__$1 = (state_30852[(2)]);
var inst_30817 = (inst_30816__$1 == null);
var inst_30818 = cljs.core.not.call(null,inst_30817);
var state_30852__$1 = (function (){var statearr_30857 = state_30852;
(statearr_30857[(9)] = inst_30816__$1);

return statearr_30857;
})();
if(inst_30818){
var statearr_30858_30886 = state_30852__$1;
(statearr_30858_30886[(1)] = (5));

} else {
var statearr_30859_30887 = state_30852__$1;
(statearr_30859_30887[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30853 === (15))){
var inst_30842 = (state_30852[(2)]);
var state_30852__$1 = state_30852;
var statearr_30860_30888 = state_30852__$1;
(statearr_30860_30888[(2)] = inst_30842);

(statearr_30860_30888[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30853 === (13))){
var state_30852__$1 = state_30852;
var statearr_30861_30889 = state_30852__$1;
(statearr_30861_30889[(2)] = null);

(statearr_30861_30889[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30853 === (6))){
var inst_30812 = (state_30852[(7)]);
var inst_30837 = inst_30812.length;
var inst_30838 = (inst_30837 > (0));
var state_30852__$1 = state_30852;
if(cljs.core.truth_(inst_30838)){
var statearr_30862_30890 = state_30852__$1;
(statearr_30862_30890[(1)] = (12));

} else {
var statearr_30863_30891 = state_30852__$1;
(statearr_30863_30891[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30853 === (3))){
var inst_30850 = (state_30852[(2)]);
var state_30852__$1 = state_30852;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30852__$1,inst_30850);
} else {
if((state_val_30853 === (12))){
var inst_30812 = (state_30852[(7)]);
var inst_30840 = cljs.core.vec.call(null,inst_30812);
var state_30852__$1 = state_30852;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30852__$1,(15),out,inst_30840);
} else {
if((state_val_30853 === (2))){
var state_30852__$1 = state_30852;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30852__$1,(4),ch);
} else {
if((state_val_30853 === (11))){
var inst_30816 = (state_30852[(9)]);
var inst_30820 = (state_30852[(10)]);
var inst_30830 = (state_30852[(2)]);
var inst_30831 = [];
var inst_30832 = inst_30831.push(inst_30816);
var inst_30812 = inst_30831;
var inst_30813 = inst_30820;
var state_30852__$1 = (function (){var statearr_30864 = state_30852;
(statearr_30864[(11)] = inst_30830);

(statearr_30864[(7)] = inst_30812);

(statearr_30864[(8)] = inst_30813);

(statearr_30864[(12)] = inst_30832);

return statearr_30864;
})();
var statearr_30865_30892 = state_30852__$1;
(statearr_30865_30892[(2)] = null);

(statearr_30865_30892[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30853 === (9))){
var inst_30812 = (state_30852[(7)]);
var inst_30828 = cljs.core.vec.call(null,inst_30812);
var state_30852__$1 = state_30852;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30852__$1,(11),out,inst_30828);
} else {
if((state_val_30853 === (5))){
var inst_30816 = (state_30852[(9)]);
var inst_30813 = (state_30852[(8)]);
var inst_30820 = (state_30852[(10)]);
var inst_30820__$1 = f.call(null,inst_30816);
var inst_30821 = cljs.core._EQ_.call(null,inst_30820__$1,inst_30813);
var inst_30822 = cljs.core.keyword_identical_QMARK_.call(null,inst_30813,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_30823 = (inst_30821) || (inst_30822);
var state_30852__$1 = (function (){var statearr_30866 = state_30852;
(statearr_30866[(10)] = inst_30820__$1);

return statearr_30866;
})();
if(cljs.core.truth_(inst_30823)){
var statearr_30867_30893 = state_30852__$1;
(statearr_30867_30893[(1)] = (8));

} else {
var statearr_30868_30894 = state_30852__$1;
(statearr_30868_30894[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30853 === (14))){
var inst_30845 = (state_30852[(2)]);
var inst_30846 = cljs.core.async.close_BANG_.call(null,out);
var state_30852__$1 = (function (){var statearr_30870 = state_30852;
(statearr_30870[(13)] = inst_30845);

return statearr_30870;
})();
var statearr_30871_30895 = state_30852__$1;
(statearr_30871_30895[(2)] = inst_30846);

(statearr_30871_30895[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30853 === (10))){
var inst_30835 = (state_30852[(2)]);
var state_30852__$1 = state_30852;
var statearr_30872_30896 = state_30852__$1;
(statearr_30872_30896[(2)] = inst_30835);

(statearr_30872_30896[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30853 === (8))){
var inst_30812 = (state_30852[(7)]);
var inst_30816 = (state_30852[(9)]);
var inst_30820 = (state_30852[(10)]);
var inst_30825 = inst_30812.push(inst_30816);
var tmp30869 = inst_30812;
var inst_30812__$1 = tmp30869;
var inst_30813 = inst_30820;
var state_30852__$1 = (function (){var statearr_30873 = state_30852;
(statearr_30873[(14)] = inst_30825);

(statearr_30873[(7)] = inst_30812__$1);

(statearr_30873[(8)] = inst_30813);

return statearr_30873;
})();
var statearr_30874_30897 = state_30852__$1;
(statearr_30874_30897[(2)] = null);

(statearr_30874_30897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto___30883,out))
;
return ((function (switch__20318__auto__,c__20380__auto___30883,out){
return (function() {
var cljs$core$async$state_machine__20319__auto__ = null;
var cljs$core$async$state_machine__20319__auto____0 = (function (){
var statearr_30878 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30878[(0)] = cljs$core$async$state_machine__20319__auto__);

(statearr_30878[(1)] = (1));

return statearr_30878;
});
var cljs$core$async$state_machine__20319__auto____1 = (function (state_30852){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_30852);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e30879){if((e30879 instanceof Object)){
var ex__20322__auto__ = e30879;
var statearr_30880_30898 = state_30852;
(statearr_30880_30898[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30852);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30879;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30899 = state_30852;
state_30852 = G__30899;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
cljs$core$async$state_machine__20319__auto__ = function(state_30852){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20319__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20319__auto____1.call(this,state_30852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20319__auto____0;
cljs$core$async$state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20319__auto____1;
return cljs$core$async$state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto___30883,out))
})();
var state__20382__auto__ = (function (){var statearr_30881 = f__20381__auto__.call(null);
(statearr_30881[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___30883);

return statearr_30881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto___30883,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1437410071071