// Compiled by ClojureScript 0.0-3308 {:static-fns true}
goog.provide('cljs.core');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.array');
goog.require('goog.string.StringBuffer');
cljs.core._STAR_clojurescript_version_STAR_ = "0.0-3308";
cljs.core._STAR_unchecked_if_STAR_ = false;
/**
 * Var bound to the name value of the compiler build :target option.
 * For example, if the compiler build :target is :nodejs, *target* will be bound
 * to "nodejs". *target* is a Google Closure define and can be set by compiler
 * :closure-defines option.
 * @define {string}
 */
cljs.core._STAR_target_STAR_ = "default";
if(typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print output.
 * Whatever function *print-fn* is bound to will be passed any
 * Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = (function cljs$core$_STAR_print_fn_STAR_(_){
throw (new Error("No *print-fn* fn set for evaluation environment"));
});
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return cljs.core._STAR_print_fn_STAR_ = f;
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 * Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 * This is to work around the implicit newlines emitted by standard JavaScript
 * console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 * non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 * Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 * be printed in a form that can be read back by the reader.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 * their type when read in later.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 * their type when read in later.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 * print nested objects. If it is bound to logical false, there is no
 * limit. Otherwise, it must be bound to an integer indicating the maximum
 * level to print. Each argument to print is at level 0; if an argument is a
 * collection, its items are at level 1; and so on. If an object is a
 * collection and is at a level greater than or equal to the value bound to
 * *print-level*, the printer prints '#' to represent it. The root binding
 * is nil indicating no limit.
 */
cljs.core._STAR_print_level_STAR_ = null;
if(typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined'){
} else {
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__5955__delegate = function (args){
return console.log.apply(console,(function (){var G__5954 = args;
return (cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(G__5954) : cljs.core.into_array.call(null,G__5954));
})());
};
var G__5955 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__5956__i = 0, G__5956__a = new Array(arguments.length -  0);
while (G__5956__i < G__5956__a.length) {G__5956__a[G__5956__i] = arguments[G__5956__i + 0]; ++G__5956__i;}
  args = new cljs.core.IndexedSeq(G__5956__a,0);
} 
return G__5955__delegate.call(this,args);};
G__5955.cljs$lang$maxFixedArity = 0;
G__5955.cljs$lang$applyTo = (function (arglist__5957){
var args = cljs.core.seq(arglist__5957);
return G__5955__delegate(args);
});
G__5955.cljs$core$IFn$_invoke$arity$variadic = G__5955__delegate;
return G__5955;
})()
;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(n){
return typeof n === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if(cljs.core.truth_(x)){
return false;
} else {
return true;
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return !((x == null));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if(!((x == null))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
var G__5959 = x;
return goog.isString(G__5959);
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[(function (){var G__5961 = x__$1;
return goog.typeOf(G__5961);
})()])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever
 * function *main-fn* is set to will be called with the command-line
 * argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__3913__auto__ = ty;
if(cljs.core.truth_(and__3913__auto__)){
return ty.cljs$lang$type;
} else {
return and__3913__auto__;
}
})())?ty.cljs$lang$ctorStr:(function (){var G__5963 = obj;
return goog.typeOf(G__5963);
})());
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__4421__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__4421__auto__)){
var s = temp__4421__auto__;
return s;
} else {
return [cljs.core.str(ty)].join('');
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((typeof Symbol !== 'undefined') && (((function (){var G__5965 = Symbol;
return goog.typeOf(G__5965);
})() === "function"))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * Construct a JavaScript array of specified size. Accepts ignored type
 * argument for compatibility with Clojure.
 */
cljs.core.make_array = (function cljs$core$make_array(){
var G__5967 = arguments.length;
switch (G__5967) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function (size){
return (new Array(size));
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function (type,size){
return (new Array(size));
});

cljs.core.make_array.cljs$lang$maxFixedArity = 2;
/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__4810__auto___5969 = len;
var i_5970 = (0);
while(true){
if((i_5970 < n__4810__auto___5969)){
(new_arr[i_5970] = (arr[i_5970]));

var G__5971 = (i_5970 + (1));
i_5970 = G__5971;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__5972 = (i + (1));
i = G__5972;
continue;
} else {
return a;
}
break;
}
});
/**
 * Returns the value at the index.
 */
cljs.core.aget = (function cljs$core$aget(){
var G__5977 = arguments.length;
switch (G__5977) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return (array[i]);
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,i,idxs){
var G__5978 = cljs.core.aget;
var G__5979 = (array[i]);
var G__5980 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__5978,G__5979,G__5980) : cljs.core.apply.call(null,G__5978,G__5979,G__5980));
});

cljs.core.aget.cljs$lang$applyTo = (function (seq5973){
var G__5974 = cljs.core.first(seq5973);
var seq5973__$1 = cljs.core.next(seq5973);
var G__5975 = cljs.core.first(seq5973__$1);
var seq5973__$2 = cljs.core.next(seq5973__$1);
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__5974,G__5975,seq5973__$2);
});

cljs.core.aget.cljs$lang$maxFixedArity = (2);
/**
 * Sets the value at the index.
 */
cljs.core.aset = (function cljs$core$aset(){
var G__5987 = arguments.length;
switch (G__5987) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0)));
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4976__auto__);

}
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function (array,i,val){
return (array[i] = val);
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
var G__5988 = cljs.core.aset;
var G__5989 = (array[idx]);
var G__5990 = idx2;
var G__5991 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__5988,G__5989,G__5990,G__5991) : cljs.core.apply.call(null,G__5988,G__5989,G__5990,G__5991));
});

cljs.core.aset.cljs$lang$applyTo = (function (seq5982){
var G__5983 = cljs.core.first(seq5982);
var seq5982__$1 = cljs.core.next(seq5982);
var G__5984 = cljs.core.first(seq5982__$1);
var seq5982__$2 = cljs.core.next(seq5982__$1);
var G__5985 = cljs.core.first(seq5982__$2);
var seq5982__$3 = cljs.core.next(seq5982__$2);
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__5983,G__5984,G__5985,seq5982__$3);
});

cljs.core.aset.cljs$lang$maxFixedArity = (3);
/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 * argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(){
var G__5994 = arguments.length;
switch (G__5994) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function (aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function (type,aseq){
var G__5995 = (function (a,x){
a.push(x);

return a;
});
var G__5996 = [];
var G__5997 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__5995,G__5996,G__5997) : cljs.core.reduce.call(null,G__5995,G__5996,G__5997));
});

cljs.core.into_array.cljs$lang$maxFixedArity = 2;
/**
 * Invoke JavaScript object method via string. Needed when the
 * string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(){
var argseq__4965__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4965__auto__);
});

cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
});

cljs.core.js_invoke.cljs$lang$maxFixedArity = (2);

cljs.core.js_invoke.cljs$lang$applyTo = (function (seq5999){
var G__6000 = cljs.core.first(seq5999);
var seq5999__$1 = cljs.core.next(seq5999);
var G__6001 = cljs.core.first(seq5999__$1);
var seq5999__$2 = cljs.core.next(seq5999__$1);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__6000,G__6001,seq5999__$2);
});

/**
 * Marker protocol
 */
cljs.core.Fn = (function (){var obj6003 = {};
return obj6003;
})();


/**
 * Protocol for adding the ability to invoke an object as a function.
 * For example, a vector can also be used to look up a value:
 * ([1 2 3 4] 1) => 2
 */
cljs.core.IFn = (function (){var obj6005 = {};
return obj6005;
})();

cljs.core._invoke = (function cljs$core$_invoke(){
var G__6007 = arguments.length;
switch (G__6007) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$1;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6009 = x__4561__auto__;
return goog.typeOf(G__6009);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function (this$,a){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$2;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6011 = x__4561__auto__;
return goog.typeOf(G__6011);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function (this$,a,b){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$3;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6013 = x__4561__auto__;
return goog.typeOf(G__6013);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function (this$,a,b,c){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$4;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6015 = x__4561__auto__;
return goog.typeOf(G__6015);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function (this$,a,b,c,d){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$5;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6017 = x__4561__auto__;
return goog.typeOf(G__6017);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function (this$,a,b,c,d,e){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$6;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6019 = x__4561__auto__;
return goog.typeOf(G__6019);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function (this$,a,b,c,d,e,f){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$7;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6021 = x__4561__auto__;
return goog.typeOf(G__6021);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function (this$,a,b,c,d,e,f,g){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$8;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6023 = x__4561__auto__;
return goog.typeOf(G__6023);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function (this$,a,b,c,d,e,f,g,h){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$9;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6025 = x__4561__auto__;
return goog.typeOf(G__6025);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$10;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6027 = x__4561__auto__;
return goog.typeOf(G__6027);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$11;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6029 = x__4561__auto__;
return goog.typeOf(G__6029);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$12;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6031 = x__4561__auto__;
return goog.typeOf(G__6031);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$13;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6033 = x__4561__auto__;
return goog.typeOf(G__6033);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$14;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6035 = x__4561__auto__;
return goog.typeOf(G__6035);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$15;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6037 = x__4561__auto__;
return goog.typeOf(G__6037);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$16;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6039 = x__4561__auto__;
return goog.typeOf(G__6039);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$17;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6041 = x__4561__auto__;
return goog.typeOf(G__6041);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$18;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6043 = x__4561__auto__;
return goog.typeOf(G__6043);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$19;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6045 = x__4561__auto__;
return goog.typeOf(G__6045);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$20;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6047 = x__4561__auto__;
return goog.typeOf(G__6047);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$21;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6049 = x__4561__auto__;
return goog.typeOf(G__6049);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IFn$_invoke$arity$22;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._invoke[(function (){var G__6051 = x__4561__auto__;
return goog.typeOf(G__6051);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._invoke["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
});

cljs.core._invoke.cljs$lang$maxFixedArity = 22;


/**
 * Protocol for cloning a value.
 */
cljs.core.ICloneable = (function (){var obj6054 = {};
return obj6054;
})();

/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((function (){var and__3913__auto__ = value;
if(and__3913__auto__){
return value.cljs$core$ICloneable$_clone$arity$1;
} else {
return and__3913__auto__;
}
})()){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
var x__4561__auto__ = (((value == null))?null:value);
return (function (){var or__3925__auto__ = (cljs.core._clone[(function (){var G__6058 = x__4561__auto__;
return goog.typeOf(G__6058);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._clone["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
})().call(null,value);
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 */
cljs.core.ICounted = (function (){var obj6060 = {};
return obj6060;
})();

/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$ICounted$_count$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._count[(function (){var G__6064 = x__4561__auto__;
return goog.typeOf(G__6064);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._count["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for creating an empty collection.
 */
cljs.core.IEmptyableCollection = (function (){var obj6066 = {};
return obj6066;
})();

/**
 * Returns an empty collection of the same category as coll. Used
 * by cljs.core/count.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._empty[(function (){var G__6070 = x__4561__auto__;
return goog.typeOf(G__6070);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._empty["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding to a collection.
 */
cljs.core.ICollection = (function (){var obj6072 = {};
return obj6072;
})();

/**
 * Returns a new collection of coll with o added to it. The new item
 * should be added to the most efficient place, e.g.
 * (conj [1 2 3 4] 5) => [1 2 3 4 5]
 * (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$ICollection$_conj$arity$2;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._conj[(function (){var G__6076 = x__4561__auto__;
return goog.typeOf(G__6076);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._conj["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
})().call(null,coll,o);
}
});


/**
 * Protocol for collections to provide idexed-based access to their items.
 */
cljs.core.IIndexed = (function (){var obj6078 = {};
return obj6078;
})();

/**
 * Returns the value at the index n in the collection coll.
 * Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(){
var G__6080 = arguments.length;
switch (G__6080) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IIndexed$_nth$arity$2;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._nth[(function (){var G__6082 = x__4561__auto__;
return goog.typeOf(G__6082);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._nth["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n);
}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IIndexed$_nth$arity$3;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._nth[(function (){var G__6084 = x__4561__auto__;
return goog.typeOf(G__6084);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._nth["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n,not_found);
}
});

cljs.core._nth.cljs$lang$maxFixedArity = 3;


/**
 * Marker protocol indicating an array sequence.
 */
cljs.core.ASeq = (function (){var obj6087 = {};
return obj6087;
})();


/**
 * Protocol for collections to provide access to their items as sequences.
 */
cljs.core.ISeq = (function (){var obj6089 = {};
return obj6089;
})();

/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$ISeq$_first$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._first[(function (){var G__6093 = x__4561__auto__;
return goog.typeOf(G__6093);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._first["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns a new collection of coll without the first item. It should
 * always return a seq, e.g.
 * (rest []) => ()
 * (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$ISeq$_rest$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._rest[(function (){var G__6097 = x__4561__auto__;
return goog.typeOf(G__6097);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._rest["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing the next items of a collection.
 */
cljs.core.INext = (function (){var obj6099 = {};
return obj6099;
})();

/**
 * Returns a new collection of coll without the first item. In contrast to
 * rest, it should return nil if there are no more items, e.g.
 * (next []) => nil
 * (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$INext$_next$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._next[(function (){var G__6103 = x__4561__auto__;
return goog.typeOf(G__6103);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._next["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for looking up a value in a data structure.
 */
cljs.core.ILookup = (function (){var obj6105 = {};
return obj6105;
})();

/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 * a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(){
var G__6107 = arguments.length;
switch (G__6107) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$ILookup$_lookup$arity$2;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._lookup[(function (){var G__6109 = x__4561__auto__;
return goog.typeOf(G__6109);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._lookup["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k);
}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$ILookup$_lookup$arity$3;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._lookup[(function (){var G__6111 = x__4561__auto__;
return goog.typeOf(G__6111);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._lookup["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k,not_found);
}
});

cljs.core._lookup.cljs$lang$maxFixedArity = 3;


/**
 * Protocol for adding associativity to collections.
 */
cljs.core.IAssociative = (function (){var obj6114 = {};
return obj6114;
})();

/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._contains_key_QMARK_[(function (){var G__6118 = x__4561__auto__;
return goog.typeOf(G__6118);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._contains_key_QMARK_["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
})().call(null,coll,k);
}
});

/**
 * Returns a new collection of coll with a mapping from key k to
 * value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IAssociative$_assoc$arity$3;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._assoc[(function (){var G__6122 = x__4561__auto__;
return goog.typeOf(G__6122);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._assoc["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
})().call(null,coll,k,v);
}
});


/**
 * Protocol for adding mapping functionality to collections.
 */
cljs.core.IMap = (function (){var obj6124 = {};
return obj6124;
})();

/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IMap$_dissoc$arity$2;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._dissoc[(function (){var G__6128 = x__4561__auto__;
return goog.typeOf(G__6128);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._dissoc["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
})().call(null,coll,k);
}
});


/**
 * Protocol for examining a map entry.
 */
cljs.core.IMapEntry = (function (){var obj6130 = {};
return obj6130;
})();

/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IMapEntry$_key$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._key[(function (){var G__6134 = x__4561__auto__;
return goog.typeOf(G__6134);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._key["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IMapEntry$_val$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._val[(function (){var G__6138 = x__4561__auto__;
return goog.typeOf(G__6138);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._val["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding set functionality to a collection.
 */
cljs.core.ISet = (function (){var obj6140 = {};
return obj6140;
})();

/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$ISet$_disjoin$arity$2;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._disjoin[(function (){var G__6144 = x__4561__auto__;
return goog.typeOf(G__6144);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._disjoin["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
})().call(null,coll,v);
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 * of the stack should be accessed in the most efficient way for the different
 * data structures.
 */
cljs.core.IStack = (function (){var obj6146 = {};
return obj6146;
})();

/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IStack$_peek$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._peek[(function (){var G__6150 = x__4561__auto__;
return goog.typeOf(G__6150);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._peek["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns a new stack without the item on top of the stack. Is used
 * by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IStack$_pop$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._pop[(function (){var G__6154 = x__4561__auto__;
return goog.typeOf(G__6154);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._pop["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding vector functionality to collections.
 */
cljs.core.IVector = (function (){var obj6156 = {};
return obj6156;
})();

/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IVector$_assoc_n$arity$3;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._assoc_n[(function (){var G__6160 = x__4561__auto__;
return goog.typeOf(G__6160);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._assoc_n["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
})().call(null,coll,n,val);
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 */
cljs.core.IDeref = (function (){var obj6162 = {};
return obj6162;
})();

/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$IDeref$_deref$arity$1;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._deref[(function (){var G__6166 = x__4561__auto__;
return goog.typeOf(G__6166);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._deref["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
})().call(null,o);
}
});


cljs.core.IDerefWithTimeout = (function (){var obj6168 = {};
return obj6168;
})();

cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._deref_with_timeout[(function (){var G__6172 = x__4561__auto__;
return goog.typeOf(G__6172);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._deref_with_timeout["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
})().call(null,o,msec,timeout_val);
}
});


/**
 * Protocol for accessing the metadata of an object.
 */
cljs.core.IMeta = (function (){var obj6174 = {};
return obj6174;
})();

/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$IMeta$_meta$arity$1;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._meta[(function (){var G__6178 = x__4561__auto__;
return goog.typeOf(G__6178);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._meta["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
})().call(null,o);
}
});


/**
 * Protocol for adding metadata to an object.
 */
cljs.core.IWithMeta = (function (){var obj6180 = {};
return obj6180;
})();

/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$IWithMeta$_with_meta$arity$2;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._with_meta[(function (){var G__6184 = x__4561__auto__;
return goog.typeOf(G__6184);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._with_meta["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
})().call(null,o,meta);
}
});


/**
 * Protocol for seq types that can reduce themselves.
 * Called by cljs.core/reduce.
 */
cljs.core.IReduce = (function (){var obj6186 = {};
return obj6186;
})();

/**
 * f should be a function of 2 arguments. If start is not supplied,
 * returns the result of applying f to the first 2 items in coll, then
 * applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(){
var G__6188 = arguments.length;
switch (G__6188) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IReduce$_reduce$arity$2;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._reduce[(function (){var G__6190 = x__4561__auto__;
return goog.typeOf(G__6190);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._reduce["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f);
}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,start){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IReduce$_reduce$arity$3;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._reduce[(function (){var G__6192 = x__4561__auto__;
return goog.typeOf(G__6192);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._reduce["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f,start);
}
});

cljs.core._reduce.cljs$lang$maxFixedArity = 3;


/**
 * Protocol for associative types that can reduce themselves
 * via a function of key and val. Called by cljs.core/reduce-kv.
 */
cljs.core.IKVReduce = (function (){var obj6195 = {};
return obj6195;
})();

/**
 * Reduces an associative collection and returns the result. f should be
 * a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._kv_reduce[(function (){var G__6199 = x__4561__auto__;
return goog.typeOf(G__6199);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._kv_reduce["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
})().call(null,coll,f,init);
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 */
cljs.core.IEquiv = (function (){var obj6201 = {};
return obj6201;
})();

/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$IEquiv$_equiv$arity$2;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._equiv[(function (){var G__6205 = x__4561__auto__;
return goog.typeOf(G__6205);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._equiv["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
})().call(null,o,other);
}
});


/**
 * Protocol for adding hashing functionality to a type.
 */
cljs.core.IHash = (function (){var obj6207 = {};
return obj6207;
})();

/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$IHash$_hash$arity$1;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._hash[(function (){var G__6211 = x__4561__auto__;
return goog.typeOf(G__6211);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._hash["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
})().call(null,o);
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 */
cljs.core.ISeqable = (function (){var obj6213 = {};
return obj6213;
})();

/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$ISeqable$_seq$arity$1;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._seq[(function (){var G__6217 = x__4561__auto__;
return goog.typeOf(G__6217);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._seq["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
})().call(null,o);
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 */
cljs.core.ISequential = (function (){var obj6219 = {};
return obj6219;
})();


/**
 * Marker interface indicating a persistent list
 */
cljs.core.IList = (function (){var obj6221 = {};
return obj6221;
})();


/**
 * Marker interface indicating a record object
 */
cljs.core.IRecord = (function (){var obj6223 = {};
return obj6223;
})();


/**
 * Protocol for reversing a seq.
 */
cljs.core.IReversible = (function (){var obj6225 = {};
return obj6225;
})();

/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IReversible$_rseq$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._rseq[(function (){var G__6229 = x__4561__auto__;
return goog.typeOf(G__6229);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._rseq["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for a collection which can represent their items
 * in a sorted manner.
 */
cljs.core.ISorted = (function (){var obj6231 = {};
return obj6231;
})();

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$ISorted$_sorted_seq$arity$2;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._sorted_seq[(function (){var G__6235 = x__4561__auto__;
return goog.typeOf(G__6235);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._sorted_seq["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
})().call(null,coll,ascending_QMARK_);
}
});

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 * If ascending is true, the result should contain all items which are > or >=
 * than k. If ascending is false, the result should contain all items which
 * are < or <= than k, e.g.
 * (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 * (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._sorted_seq_from[(function (){var G__6239 = x__4561__auto__;
return goog.typeOf(G__6239);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._sorted_seq_from["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
})().call(null,coll,k,ascending_QMARK_);
}
});

/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$ISorted$_entry_key$arity$2;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._entry_key[(function (){var G__6243 = x__4561__auto__;
return goog.typeOf(G__6243);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._entry_key["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
})().call(null,coll,entry);
}
});

/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$ISorted$_comparator$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._comparator[(function (){var G__6247 = x__4561__auto__;
return goog.typeOf(G__6247);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._comparator["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 */
cljs.core.IWriter = (function (){var obj6249 = {};
return obj6249;
})();

/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((function (){var and__3913__auto__ = writer;
if(and__3913__auto__){
return writer.cljs$core$IWriter$_write$arity$2;
} else {
return and__3913__auto__;
}
})()){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
var x__4561__auto__ = (((writer == null))?null:writer);
return (function (){var or__3925__auto__ = (cljs.core._write[(function (){var G__6253 = x__4561__auto__;
return goog.typeOf(G__6253);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._write["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
})().call(null,writer,s);
}
});

/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((function (){var and__3913__auto__ = writer;
if(and__3913__auto__){
return writer.cljs$core$IWriter$_flush$arity$1;
} else {
return and__3913__auto__;
}
})()){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
var x__4561__auto__ = (((writer == null))?null:writer);
return (function (){var or__3925__auto__ = (cljs.core._flush[(function (){var G__6257 = x__4561__auto__;
return goog.typeOf(G__6257);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._flush["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
})().call(null,writer);
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 */
cljs.core.IPrintWithWriter = (function (){var obj6259 = {};
return obj6259;
})();

cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._pr_writer[(function (){var G__6263 = x__4561__auto__;
return goog.typeOf(G__6263);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._pr_writer["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
})().call(null,o,writer,opts);
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 * implemented by Delay.
 */
cljs.core.IPending = (function (){var obj6265 = {};
return obj6265;
})();

/**
 * Returns true if a value for d has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(d){
if((function (){var and__3913__auto__ = d;
if(and__3913__auto__){
return d.cljs$core$IPending$_realized_QMARK_$arity$1;
} else {
return and__3913__auto__;
}
})()){
return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);
} else {
var x__4561__auto__ = (((d == null))?null:d);
return (function (){var or__3925__auto__ = (cljs.core._realized_QMARK_[(function (){var G__6269 = x__4561__auto__;
return goog.typeOf(G__6269);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._realized_QMARK_["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IPending.-realized?",d);
}
}
})().call(null,d);
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 */
cljs.core.IWatchable = (function (){var obj6271 = {};
return obj6271;
})();

/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IWatchable$_notify_watches$arity$3;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._notify_watches[(function (){var G__6275 = x__4561__auto__;
return goog.typeOf(G__6275);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._notify_watches["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
})().call(null,this$,oldval,newval);
}
});

/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 * and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IWatchable$_add_watch$arity$3;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._add_watch[(function (){var G__6279 = x__4561__auto__;
return goog.typeOf(G__6279);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._add_watch["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
})().call(null,this$,key,f);
}
});

/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((function (){var and__3913__auto__ = this$;
if(and__3913__auto__){
return this$.cljs$core$IWatchable$_remove_watch$arity$2;
} else {
return and__3913__auto__;
}
})()){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
var x__4561__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3925__auto__ = (cljs.core._remove_watch[(function (){var G__6283 = x__4561__auto__;
return goog.typeOf(G__6283);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._remove_watch["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
})().call(null,this$,key);
}
});


/**
 * Protocol for collections which can transformed to transients.
 */
cljs.core.IEditableCollection = (function (){var obj6285 = {};
return obj6285;
})();

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._as_transient[(function (){var G__6289 = x__4561__auto__;
return goog.typeOf(G__6289);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._as_transient["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 */
cljs.core.ITransientCollection = (function (){var obj6291 = {};
return obj6291;
})();

/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((function (){var and__3913__auto__ = tcoll;
if(and__3913__auto__){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2;
} else {
return and__3913__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
var x__4561__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3925__auto__ = (cljs.core._conj_BANG_[(function (){var G__6295 = x__4561__auto__;
return goog.typeOf(G__6295);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._conj_BANG_["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
})().call(null,tcoll,val);
}
});

/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((function (){var and__3913__auto__ = tcoll;
if(and__3913__auto__){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1;
} else {
return and__3913__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
var x__4561__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3925__auto__ = (cljs.core._persistent_BANG_[(function (){var G__6299 = x__4561__auto__;
return goog.typeOf(G__6299);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._persistent_BANG_["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
})().call(null,tcoll);
}
});


/**
 * Protocol for adding associativity to transient collections.
 */
cljs.core.ITransientAssociative = (function (){var obj6301 = {};
return obj6301;
})();

/**
 * Returns a new transient collection of tcoll with a mapping from key to
 * val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((function (){var and__3913__auto__ = tcoll;
if(and__3913__auto__){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3;
} else {
return and__3913__auto__;
}
})()){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
var x__4561__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3925__auto__ = (cljs.core._assoc_BANG_[(function (){var G__6305 = x__4561__auto__;
return goog.typeOf(G__6305);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._assoc_BANG_["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
})().call(null,tcoll,key,val);
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 */
cljs.core.ITransientMap = (function (){var obj6307 = {};
return obj6307;
})();

/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((function (){var and__3913__auto__ = tcoll;
if(and__3913__auto__){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2;
} else {
return and__3913__auto__;
}
})()){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
var x__4561__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3925__auto__ = (cljs.core._dissoc_BANG_[(function (){var G__6311 = x__4561__auto__;
return goog.typeOf(G__6311);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._dissoc_BANG_["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
})().call(null,tcoll,key);
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 */
cljs.core.ITransientVector = (function (){var obj6313 = {};
return obj6313;
})();

/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((function (){var and__3913__auto__ = tcoll;
if(and__3913__auto__){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3;
} else {
return and__3913__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
var x__4561__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3925__auto__ = (cljs.core._assoc_n_BANG_[(function (){var G__6317 = x__4561__auto__;
return goog.typeOf(G__6317);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._assoc_n_BANG_["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
})().call(null,tcoll,n,val);
}
});

/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((function (){var and__3913__auto__ = tcoll;
if(and__3913__auto__){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1;
} else {
return and__3913__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
var x__4561__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3925__auto__ = (cljs.core._pop_BANG_[(function (){var G__6321 = x__4561__auto__;
return goog.typeOf(G__6321);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._pop_BANG_["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
})().call(null,tcoll);
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 */
cljs.core.ITransientSet = (function (){var obj6323 = {};
return obj6323;
})();

/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((function (){var and__3913__auto__ = tcoll;
if(and__3913__auto__){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2;
} else {
return and__3913__auto__;
}
})()){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
var x__4561__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3925__auto__ = (cljs.core._disjoin_BANG_[(function (){var G__6327 = x__4561__auto__;
return goog.typeOf(G__6327);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._disjoin_BANG_["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
})().call(null,tcoll,v);
}
});


/**
 * Protocol for values that can be compared.
 */
cljs.core.IComparable = (function (){var obj6329 = {};
return obj6329;
})();

/**
 * Returns a negative number, zero, or a positive number when x is logically
 * 'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((function (){var and__3913__auto__ = x;
if(and__3913__auto__){
return x.cljs$core$IComparable$_compare$arity$2;
} else {
return and__3913__auto__;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
var x__4561__auto__ = (((x == null))?null:x);
return (function (){var or__3925__auto__ = (cljs.core._compare[(function (){var G__6333 = x__4561__auto__;
return goog.typeOf(G__6333);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._compare["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
})().call(null,x,y);
}
});


/**
 * Protocol for accessing the items of a chunk.
 */
cljs.core.IChunk = (function (){var obj6335 = {};
return obj6335;
})();

/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IChunk$_drop_first$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._drop_first[(function (){var G__6339 = x__4561__auto__;
return goog.typeOf(G__6339);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._drop_first["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 */
cljs.core.IChunkedSeq = (function (){var obj6341 = {};
return obj6341;
})();

/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._chunked_first[(function (){var G__6345 = x__4561__auto__;
return goog.typeOf(G__6345);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._chunked_first["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
})().call(null,coll);
}
});

/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._chunked_rest[(function (){var G__6349 = x__4561__auto__;
return goog.typeOf(G__6349);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._chunked_rest["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing the chunks of a collection.
 */
cljs.core.IChunkedNext = (function (){var obj6351 = {};
return obj6351;
})();

/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._chunked_next[(function (){var G__6355 = x__4561__auto__;
return goog.typeOf(G__6355);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._chunked_next["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding a name.
 */
cljs.core.INamed = (function (){var obj6357 = {};
return obj6357;
})();

/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((function (){var and__3913__auto__ = x;
if(and__3913__auto__){
return x.cljs$core$INamed$_name$arity$1;
} else {
return and__3913__auto__;
}
})()){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
var x__4561__auto__ = (((x == null))?null:x);
return (function (){var or__3925__auto__ = (cljs.core._name[(function (){var G__6361 = x__4561__auto__;
return goog.typeOf(G__6361);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._name["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
})().call(null,x);
}
});

/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((function (){var and__3913__auto__ = x;
if(and__3913__auto__){
return x.cljs$core$INamed$_namespace$arity$1;
} else {
return and__3913__auto__;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
var x__4561__auto__ = (((x == null))?null:x);
return (function (){var or__3925__auto__ = (cljs.core._namespace[(function (){var G__6365 = x__4561__auto__;
return goog.typeOf(G__6365);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._namespace["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
})().call(null,x);
}
});


/**
 * Marker protocol indicating an atom.
 */
cljs.core.IAtom = (function (){var obj6367 = {};
return obj6367;
})();


/**
 * Protocol for adding resetting functionality.
 */
cljs.core.IReset = (function (){var obj6369 = {};
return obj6369;
})();

/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$IReset$_reset_BANG_$arity$2;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._reset_BANG_[(function (){var G__6373 = x__4561__auto__;
return goog.typeOf(G__6373);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._reset_BANG_["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
})().call(null,o,new_value);
}
});


/**
 * Protocol for adding swapping functionality.
 */
cljs.core.ISwap = (function (){var obj6375 = {};
return obj6375;
})();

/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(){
var G__6377 = arguments.length;
switch (G__6377) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (o,f){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$2;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._swap_BANG_[(function (){var G__6379 = x__4561__auto__;
return goog.typeOf(G__6379);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f);
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (o,f,a){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$3;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._swap_BANG_[(function (){var G__6381 = x__4561__auto__;
return goog.typeOf(G__6381);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a);
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (o,f,a,b){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$4;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._swap_BANG_[(function (){var G__6383 = x__4561__auto__;
return goog.typeOf(G__6383);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b);
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (o,f,a,b,xs){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$5;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._swap_BANG_[(function (){var G__6385 = x__4561__auto__;
return goog.typeOf(G__6385);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b,xs);
}
});

cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;


/**
 * Protocol for adding volatile functionality.
 */
cljs.core.IVolatile = (function (){var obj6388 = {};
return obj6388;
})();

/**
 * Sets the value of volatile o to new-value without regard for the
 * current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((function (){var and__3913__auto__ = o;
if(and__3913__auto__){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2;
} else {
return and__3913__auto__;
}
})()){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
var x__4561__auto__ = (((o == null))?null:o);
return (function (){var or__3925__auto__ = (cljs.core._vreset_BANG_[(function (){var G__6392 = x__4561__auto__;
return goog.typeOf(G__6392);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._vreset_BANG_["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
})().call(null,o,new_value);
}
});


/**
 * Protocol for iterating over a collection.
 */
cljs.core.IIterable = (function (){var obj6394 = {};
return obj6394;
})();

/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((function (){var and__3913__auto__ = coll;
if(and__3913__auto__){
return coll.cljs$core$IIterable$_iterator$arity$1;
} else {
return and__3913__auto__;
}
})()){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
var x__4561__auto__ = (((coll == null))?null:coll);
return (function (){var or__3925__auto__ = (cljs.core._iterator[(function (){var G__6398 = x__4561__auto__;
return goog.typeOf(G__6398);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._iterator["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
})().call(null,coll);
}
});


/**
* @constructor
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
});

cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

cljs.core.StringBufferWriter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sb","sb",-1249746442,null)], null);
});

cljs.core.StringBufferWriter.cljs$lang$type = true;

cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";

cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/StringBufferWriter");
});

cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return [cljs.core.str(sb)].join('');
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((typeof Math.imul !== 'undefined') && (!(((function (){var G__6401 = (4294967295);
var G__6402 = (5);
return Math.imul(G__6401,G__6402);
})() === (0))))){
cljs.core.imul = (function cljs$core$imul(a,b){
var G__6405 = a;
var G__6406 = b;
return Math.imul(G__6405,G__6406);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
var h1__$7 = (h1__$6 ^ (h1__$6 >>> (16)));
return h1__$7;
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__6407 = (i + (2));
var G__6408 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__6407;
h1 = G__6408;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = (function (){var obj6410 = {};
return obj6410;
})();
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if(!((s == null))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__6411 = (i + (1));
var G__6412 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__6411;
hash = G__6412;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
(cljs.core.string_hash_cache[k] = h);

cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
cljs.core.string_hash_cache = (function (){var obj6416 = {};
return obj6416;
})();

cljs.core.string_hash_cache_count = (0);
} else {
}

var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((function (){var G__6419 = o;
if(G__6419){
var bit__4592__auto__ = (G__6419.cljs$lang$protocol_mask$partition0$ & (4194304));
if((bit__4592__auto__) || (G__6419.cljs$core$IHash$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(null);
} else {
if(typeof o === 'number'){
return ((function (){var G__6420 = o;
return Math.floor(G__6420);
})() % (2147483647));
} else {
if(o === true){
return (1);
} else {
if(o === false){
return (0);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return o.valueOf();
} else {
if((o == null)){
return (0);
} else {
return cljs.core._hash(o);

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 * c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(t,o){
return (o instanceof t);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__3913__auto__ = cljs.core.not(a.ns);
if(and__3913__auto__){
return b.ns;
} else {
return and__3913__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__6427 = a.ns;
var G__6428 = b.ns;
return goog.array.defaultCompare(G__6427,G__6428);
})();
if(((0) === nsc)){
var G__6429 = a.name;
var G__6430 = b.name;
return goog.array.defaultCompare(G__6429,G__6430);
} else {
return nsc;
}
}
} else {
var G__6431 = a.name;
var G__6432 = b.name;
return goog.array.defaultCompare(G__6431,G__6432);

}
}
}
});

/**
* @constructor
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
});

cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
});

cljs.core.Symbol.prototype.call = (function() {
var G__6434 = null;
var G__6434__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});
var G__6434__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
G__6434 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__6434__2.call(this,self__,coll);
case 3:
return G__6434__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__6434.cljs$core$IFn$_invoke$arity$2 = G__6434__2;
G__6434.cljs$core$IFn$_invoke$arity$3 = G__6434__3;
return G__6434;
})()
;

cljs.core.Symbol.prototype.apply = (function (self__,args6433){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6433)));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});

cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
});

cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__4341__auto__ = self__._hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_symbol(sym__$1);
self__._hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
});

cljs.core.Symbol.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

cljs.core.Symbol.cljs$lang$type = true;

cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";

cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/Symbol");
});

cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

cljs.core.symbol = (function cljs$core$symbol(){
var G__6436 = arguments.length;
switch (G__6436) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var sym_str = ((!((ns == null)))?[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
});

cljs.core.symbol.cljs$lang$maxFixedArity = 2;

/**
* @constructor
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 163841;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
});

cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Var.prototype.cljs$core$Fn$ = true;

cljs.core.Var.prototype.call = (function() {
var G__6483 = null;
var G__6483__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});
var G__6483__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});
var G__6483__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});
var G__6483__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});
var G__6483__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});
var G__6483__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});
var G__6483__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});
var G__6483__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});
var G__6483__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});
var G__6483__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});
var G__6483__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__6483__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__6483__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__6483__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__6483__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__6483__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__6483__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__6483__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__6483__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__6483__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__6483__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__6483__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6439 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__6440 = a;
var G__6441 = b;
var G__6442 = c;
var G__6443 = d;
var G__6444 = e;
var G__6445 = f;
var G__6446 = g;
var G__6447 = h;
var G__6448 = i;
var G__6449 = j;
var G__6450 = k;
var G__6451 = l;
var G__6452 = m;
var G__6453 = n;
var G__6454 = o;
var G__6455 = p;
var G__6456 = q;
var G__6457 = r;
var G__6458 = s;
var G__6459 = t;
var G__6460 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__6439,G__6440,G__6441,G__6442,G__6443,G__6444,G__6445,G__6446,G__6447,G__6448,G__6449,G__6450,G__6451,G__6452,G__6453,G__6454,G__6455,G__6456,G__6457,G__6458,G__6459,G__6460) : cljs.core.apply.call(null,G__6439,G__6440,G__6441,G__6442,G__6443,G__6444,G__6445,G__6446,G__6447,G__6448,G__6449,G__6450,G__6451,G__6452,G__6453,G__6454,G__6455,G__6456,G__6457,G__6458,G__6459,G__6460));
});
G__6483 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__6483__1.call(this,self__);
case 2:
return G__6483__2.call(this,self__,a);
case 3:
return G__6483__3.call(this,self__,a,b);
case 4:
return G__6483__4.call(this,self__,a,b,c);
case 5:
return G__6483__5.call(this,self__,a,b,c,d);
case 6:
return G__6483__6.call(this,self__,a,b,c,d,e);
case 7:
return G__6483__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__6483__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__6483__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__6483__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__6483__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__6483__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__6483__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__6483__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__6483__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__6483__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__6483__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__6483__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__6483__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__6483__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__6483__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__6483__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__6483.cljs$core$IFn$_invoke$arity$1 = G__6483__1;
G__6483.cljs$core$IFn$_invoke$arity$2 = G__6483__2;
G__6483.cljs$core$IFn$_invoke$arity$3 = G__6483__3;
G__6483.cljs$core$IFn$_invoke$arity$4 = G__6483__4;
G__6483.cljs$core$IFn$_invoke$arity$5 = G__6483__5;
G__6483.cljs$core$IFn$_invoke$arity$6 = G__6483__6;
G__6483.cljs$core$IFn$_invoke$arity$7 = G__6483__7;
G__6483.cljs$core$IFn$_invoke$arity$8 = G__6483__8;
G__6483.cljs$core$IFn$_invoke$arity$9 = G__6483__9;
G__6483.cljs$core$IFn$_invoke$arity$10 = G__6483__10;
G__6483.cljs$core$IFn$_invoke$arity$11 = G__6483__11;
G__6483.cljs$core$IFn$_invoke$arity$12 = G__6483__12;
G__6483.cljs$core$IFn$_invoke$arity$13 = G__6483__13;
G__6483.cljs$core$IFn$_invoke$arity$14 = G__6483__14;
G__6483.cljs$core$IFn$_invoke$arity$15 = G__6483__15;
G__6483.cljs$core$IFn$_invoke$arity$16 = G__6483__16;
G__6483.cljs$core$IFn$_invoke$arity$17 = G__6483__17;
G__6483.cljs$core$IFn$_invoke$arity$18 = G__6483__18;
G__6483.cljs$core$IFn$_invoke$arity$19 = G__6483__19;
G__6483.cljs$core$IFn$_invoke$arity$20 = G__6483__20;
G__6483.cljs$core$IFn$_invoke$arity$21 = G__6483__21;
G__6483.cljs$core$IFn$_invoke$arity$22 = G__6483__22;
return G__6483;
})()
;

cljs.core.Var.prototype.apply = (function (self__,args6438){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6438)));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__6461 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__6462 = a;
var G__6463 = b;
var G__6464 = c;
var G__6465 = d;
var G__6466 = e;
var G__6467 = f;
var G__6468 = g;
var G__6469 = h;
var G__6470 = i;
var G__6471 = j;
var G__6472 = k;
var G__6473 = l;
var G__6474 = m;
var G__6475 = n;
var G__6476 = o;
var G__6477 = p;
var G__6478 = q;
var G__6479 = r;
var G__6480 = s;
var G__6481 = t;
var G__6482 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__6461,G__6462,G__6463,G__6464,G__6465,G__6466,G__6467,G__6468,G__6469,G__6470,G__6471,G__6472,G__6473,G__6474,G__6475,G__6476,G__6477,G__6478,G__6479,G__6480,G__6481,G__6482) : cljs.core.apply.call(null,G__6461,G__6462,G__6463,G__6464,G__6465,G__6466,G__6467,G__6468,G__6469,G__6470,G__6471,G__6472,G__6473,G__6474,G__6475,G__6476,G__6477,G__6478,G__6479,G__6480,G__6481,G__6482));
});

cljs.core.Var.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"sym","sym",195671222,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

cljs.core.Var.cljs$lang$type = true;

cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";

cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/Var");
});

cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});


/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
var G__6485 = x;
if(G__6485){
var bit__4599__auto__ = null;
if(cljs.core.truth_((function (){var or__3925__auto__ = bit__4599__auto__;
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return G__6485.cljs$core$IIterable$;
}
})())){
return true;
} else {
if((!G__6485.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__6485);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__6485);
}
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
var G__6487 = value;
if(G__6487){
var bit__4599__auto__ = (G__6487.cljs$lang$protocol_mask$partition1$ & (8192));
if((bit__4599__auto__) || (G__6487.cljs$core$ICloneable$)){
return true;
} else {
if((!G__6487.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__6487);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__6487);
}
});
/**
 * Returns a seq on the collection. If the collection is
 * empty, returns nil.  (seq nil) returns nil. seq also works on
 * Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__6489 = coll;
if(G__6489){
var bit__4592__auto__ = (G__6489.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4592__auto__) || (G__6489.cljs$core$ISeqable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str(coll),cljs.core.str(" is not ISeqable")].join('')));

}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 * argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__6491 = coll;
if(G__6491){
var bit__4592__auto__ = (G__6491.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4592__auto__) || (G__6491.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 * argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if(!((coll == null))){
if((function (){var G__6493 = coll;
if(G__6493){
var bit__4592__auto__ = (G__6493.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4592__auto__) || (G__6493.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return cljs.core._rest(s);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 * argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__6495 = coll;
if(G__6495){
var bit__4592__auto__ = (G__6495.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4592__auto__) || (G__6495.cljs$core$INext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 * numbers and collections in a type-independent manner.  Clojure's immutable data
 * structures define -equiv (and thus =) as a value, not an identity,
 * comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(){
var G__6500 = arguments.length;
switch (G__6500) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return ((x === y)) || (cljs.core._equiv(x,y));
}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__6502 = y;
var G__6503 = cljs.core.first(more);
var G__6504 = cljs.core.next(more);
x = G__6502;
y = G__6503;
more = G__6504;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ_.cljs$lang$applyTo = (function (seq6496){
var G__6497 = cljs.core.first(seq6496);
var seq6496__$1 = cljs.core.next(seq6496);
var G__6498 = cljs.core.first(seq6496__$1);
var seq6496__$2 = cljs.core.next(seq6496__$1);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__6497,G__6498,seq6496__$2);
});

cljs.core._EQ_.cljs$lang$maxFixedArity = (2);

/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
})
cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"value": x, "done": false};
} else {
return {"value": null, "done": true};
}
});

cljs.core.ES6Iterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null);
});

cljs.core.ES6Iterator.cljs$lang$type = true;

cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";

cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/ES6Iterator");
});

cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
self__._rest = (function (){var G__6505 = self__.iter;
return (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__6505) : cljs.core.es6_iterator_seq.call(null,G__6505));
})();
} else {
}

return self__._rest;
});

cljs.core.ES6IteratorSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null),new cljs.core.Symbol(null,"_rest","_rest",-2100466189,null)], null);
});

cljs.core.ES6IteratorSeq.cljs$lang$type = true;

cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";

cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/ES6IteratorSeq");
});

cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__6506 = (n + (1));
var G__6507 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__6508 = cljs.core.next(coll__$1);
n = G__6506;
hash_code = G__6507;
coll__$1 = G__6508;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 * (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__6509 = (n + (1));
var G__6510 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__6511 = cljs.core.next(coll__$1);
n = G__6509;
hash_code = G__6510;
coll__$1 = G__6511;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
Date.prototype.cljs$core$IEquiv$ = true;

Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return ((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf()));
});

Date.prototype.cljs$core$IComparable$ = true;

Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof Date)){
var G__6512 = this$__$1.valueOf();
var G__6513 = other.valueOf();
return goog.array.defaultCompare(G__6512,G__6513);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.Fn["function"] = true);

(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
var G__6514 = o;
return goog.getUid(G__6514);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
});

cljs.core.Reduced.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null)], null);
});

cljs.core.Reduced.cljs$lang$type = true;

cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";

cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/Reduced");
});

cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
var G__6516 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__6516) : cljs.core.deref.call(null,G__6516));
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(){
var G__6518 = arguments.length;
switch (G__6518) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function (cicoll,f){
var cnt = cljs.core._count(cicoll);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__6519 = val;
var G__6520 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6519,G__6520) : f.call(null,G__6519,G__6520));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__6526 = nval;
var G__6527 = (n + (1));
val = G__6526;
n = G__6527;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function (cicoll,f,val){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__6521 = val__$1;
var G__6522 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6521,G__6522) : f.call(null,G__6521,G__6522));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__6528 = nval;
var G__6529 = (n + (1));
val__$1 = G__6528;
n = G__6529;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = (function (cicoll,f,val,idx){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__6523 = val__$1;
var G__6524 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6523,G__6524) : f.call(null,G__6523,G__6524));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__6530 = nval;
var G__6531 = (n + (1));
val__$1 = G__6530;
n = G__6531;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.array_reduce = (function cljs$core$array_reduce(){
var G__6533 = arguments.length;
switch (G__6533) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__6534 = val;
var G__6535 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6534,G__6535) : f.call(null,G__6534,G__6535));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__6541 = nval;
var G__6542 = (n + (1));
val = G__6541;
n = G__6542;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__6536 = val__$1;
var G__6537 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6536,G__6537) : f.call(null,G__6536,G__6537));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__6543 = nval;
var G__6544 = (n + (1));
val__$1 = G__6543;
n = G__6544;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__6538 = val__$1;
var G__6539 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6538,G__6539) : f.call(null,G__6538,G__6539));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__6545 = nval;
var G__6546 = (n + (1));
val__$1 = G__6545;
n = G__6546;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;



/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
var G__6548 = x;
if(G__6548){
var bit__4599__auto__ = (G__6548.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4599__auto__) || (G__6548.cljs$core$ICounted$)){
return true;
} else {
if((!G__6548.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__6548);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__6548);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
var G__6550 = x;
if(G__6550){
var bit__4599__auto__ = (G__6550.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4599__auto__) || (G__6550.cljs$core$IIndexed$)){
return true;
} else {
if((!G__6550.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__6550);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__6550);
}
});

/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.IndexedSeqIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null);
});

cljs.core.IndexedSeqIterator.cljs$lang$type = true;

cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";

cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/IndexedSeqIterator");
});

cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
*/
cljs.core.IndexedSeq = (function (arr,i){
this.arr = arr;
this.i = i;
this.cljs$lang$protocol_mask$partition0$ = 166199550;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return not_found;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var x__4237__auto__ = (0);
var y__4238__auto__ = (self__.arr.length - self__.i);
return ((x__4237__auto__ > y__4238__auto__) ? x__4237__auto__ : y__4238__auto__);
});

cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = cljs.core._count(coll__$1);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__6551 = coll__$1;
var G__6552 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__6551,G__6552) : cljs.core.equiv_sequential.call(null,G__6551,G__6552));
});

cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__6553 = o;
var G__6554 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__6553,G__6554) : cljs.core.cons.call(null,G__6553,G__6554));
});

cljs.core.IndexedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null);
});

cljs.core.IndexedSeq.cljs$lang$type = true;

cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";

cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/IndexedSeq");
});

cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i){
return (new cljs.core.IndexedSeq(arr,i));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(){
var G__6556 = arguments.length;
switch (G__6556) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function (prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i));
} else {
return null;
}
});

cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;
/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(){
var G__6559 = arguments.length;
switch (G__6559) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
});

cljs.core.array_seq.cljs$lang$maxFixedArity = 2;


/**
* @constructor
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
});

cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
});

cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
});

cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__6561 = coll__$1;
var G__6562 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__6561,G__6562) : cljs.core.equiv_sequential.call(null,G__6561,G__6562));
});

cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__6563 = cljs.core.List.EMPTY;
var G__6564 = self__.meta;
return (cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__6563,G__6564) : cljs.core.with_meta.call(null,G__6563,G__6564));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
var G__6565 = f;
var G__6566 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(G__6565,G__6566) : cljs.core.seq_reduce.call(null,G__6565,G__6566));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
var G__6567 = f;
var G__6568 = start;
var G__6569 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(G__6567,G__6568,G__6569) : cljs.core.seq_reduce.call(null,G__6567,G__6568,G__6569));
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
});

cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__6570 = o;
var G__6571 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__6570,G__6571) : cljs.core.cons.call(null,G__6570,G__6571));
});

cljs.core.RSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ci","ci",2049808339,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
});

cljs.core.RSeq.cljs$lang$type = true;

cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";

cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/RSeq");
});

cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if(!((sn == null))){
var G__6572 = sn;
s = G__6572;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 * 'added'. (conj nil item) returns (item).  The 'addition' may
 * happen at different 'places' depending on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(){
var G__6577 = arguments.length;
switch (G__6577) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if(!((coll == null))){
return cljs.core._conj(coll,x);
} else {
return cljs.core._conj(cljs.core.List.EMPTY,x);
}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__6579 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__6580 = cljs.core.first(xs);
var G__6581 = cljs.core.next(xs);
coll = G__6579;
x = G__6580;
xs = G__6581;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
});

cljs.core.conj.cljs$lang$applyTo = (function (seq6573){
var G__6574 = cljs.core.first(seq6573);
var seq6573__$1 = cljs.core.next(seq6573);
var G__6575 = cljs.core.first(seq6573__$1);
var seq6573__$2 = cljs.core.next(seq6573__$1);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__6574,G__6575,seq6573__$2);
});

cljs.core.conj.cljs$lang$maxFixedArity = (2);
/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
return cljs.core._empty(coll);
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__6582 = cljs.core.next(s);
var G__6583 = (acc + (1));
s = G__6582;
acc = G__6583;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 * 0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if(!((coll == null))){
if((function (){var G__6585 = coll;
if(G__6585){
var bit__4592__auto__ = (G__6585.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4592__auto__) || (G__6585.cljs$core$ICounted$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll)){
return cljs.core._count(coll);
} else {
return cljs.core.accumulating_seq_count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(){
var G__6587 = arguments.length;
switch (G__6587) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__6589 = cljs.core.next(coll);
var G__6590 = (n - (1));
coll = G__6589;
n = G__6590;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__6591 = cljs.core.next(coll);
var G__6592 = (n - (1));
var G__6593 = not_found;
coll = G__6591;
n = G__6592;
not_found = G__6593;
continue;
} else {
return not_found;

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;
/**
 * Returns the value at the index. get returns nil if index out of
 * bounds, nth throws an exception unless not-found is supplied.  nth
 * also works for strings, arrays, regex Matchers and Lists, and,
 * in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(){
var G__6595 = arguments.length;
switch (G__6595) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((function (){var G__6596 = coll;
if(G__6596){
var bit__4592__auto__ = (G__6596.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4592__auto__) || (G__6596.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__6597 = coll;
if(G__6597){
var bit__4599__auto__ = (G__6597.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4599__auto__) || (G__6597.cljs$core$ISeq$)){
return true;
} else {
if((!G__6597.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__6597);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__6597);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((function (){var G__6598 = coll;
if(G__6598){
var bit__4592__auto__ = (G__6598.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4592__auto__) || (G__6598.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__6599 = coll;
if(G__6599){
var bit__4599__auto__ = (G__6599.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4599__auto__) || (G__6599.cljs$core$ISeq$)){
return true;
} else {
if((!G__6599.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__6599);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__6599);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$lang$maxFixedArity = 3;
/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
if(((n__$1 > (0))) && (cljs.core.seq(xs))){
var G__6601 = (n__$1 - (1));
var G__6602 = cljs.core.rest(xs);
n__$1 = G__6601;
xs = G__6602;
continue;
} else {
return xs;
}
break;
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present.
 */
cljs.core.get = (function cljs$core$get(){
var G__6604 = arguments.length;
switch (G__6604) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((o == null)){
return null;
} else {
if((function (){var G__6605 = o;
if(G__6605){
var bit__4592__auto__ = (G__6605.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4592__auto__) || (G__6605.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if(!((o == null))){
if((function (){var G__6606 = o;
if(G__6606){
var bit__4592__auto__ = (G__6606.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4592__auto__) || (G__6606.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
});

cljs.core.get.cljs$lang$maxFixedArity = 3;
/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index.
 */
cljs.core.assoc = (function cljs$core$assoc(){
var G__6613 = arguments.length;
switch (G__6613) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4976__auto__);

}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function (coll,k,v){
if(!((coll == null))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentHashMap.fromArrays([k],[v]);
}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__6615 = ret;
var G__6616 = cljs.core.first(kvs);
var G__6617 = cljs.core.second(kvs);
var G__6618 = cljs.core.nnext(kvs);
coll = G__6615;
k = G__6616;
v = G__6617;
kvs = G__6618;
continue;
} else {
return ret;
}
break;
}
});

cljs.core.assoc.cljs$lang$applyTo = (function (seq6608){
var G__6609 = cljs.core.first(seq6608);
var seq6608__$1 = cljs.core.next(seq6608);
var G__6610 = cljs.core.first(seq6608__$1);
var seq6608__$2 = cljs.core.next(seq6608__$1);
var G__6611 = cljs.core.first(seq6608__$2);
var seq6608__$3 = cljs.core.next(seq6608__$2);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__6609,G__6610,G__6611,seq6608__$3);
});

cljs.core.assoc.cljs$lang$maxFixedArity = (3);
/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 * that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(){
var G__6623 = arguments.length;
switch (G__6623) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__6625 = ret;
var G__6626 = cljs.core.first(ks);
var G__6627 = cljs.core.next(ks);
coll = G__6625;
k = G__6626;
ks = G__6627;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.dissoc.cljs$lang$applyTo = (function (seq6619){
var G__6620 = cljs.core.first(seq6619);
var seq6619__$1 = cljs.core.next(seq6619);
var G__6621 = cljs.core.first(seq6619__$1);
var seq6619__$2 = cljs.core.next(seq6619__$1);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__6620,G__6621,seq6619__$2);
});

cljs.core.dissoc.cljs$lang$maxFixedArity = (2);
/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__3925__auto__ = (function (){var G__6632 = f;
return goog.isFunction(G__6632);
})();
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
var G__6633 = f;
if(G__6633){
var bit__4599__auto__ = null;
if(cljs.core.truth_((function (){var or__3925__auto____$1 = bit__4599__auto__;
if(cljs.core.truth_(or__3925__auto____$1)){
return or__3925__auto____$1;
} else {
return G__6633.cljs$core$Fn$;
}
})())){
return true;
} else {
if((!G__6633.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__6633);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__6633);
}
}
});

/**
* @constructor
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
});

cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;

cljs.core.MetaFn.prototype.call = (function() {
var G__7099 = null;
var G__7099__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__7099__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6635 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__6635) : self__.afn.call(null,G__6635));
});
var G__7099__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6636 = a;
var G__6637 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__6636,G__6637) : self__.afn.call(null,G__6636,G__6637));
});
var G__7099__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6638 = a;
var G__6639 = b;
var G__6640 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__6638,G__6639,G__6640) : self__.afn.call(null,G__6638,G__6639,G__6640));
});
var G__7099__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6641 = a;
var G__6642 = b;
var G__6643 = c;
var G__6644 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__6641,G__6642,G__6643,G__6644) : self__.afn.call(null,G__6641,G__6642,G__6643,G__6644));
});
var G__7099__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6645 = a;
var G__6646 = b;
var G__6647 = c;
var G__6648 = d;
var G__6649 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__6645,G__6646,G__6647,G__6648,G__6649) : self__.afn.call(null,G__6645,G__6646,G__6647,G__6648,G__6649));
});
var G__7099__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6650 = a;
var G__6651 = b;
var G__6652 = c;
var G__6653 = d;
var G__6654 = e;
var G__6655 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__6650,G__6651,G__6652,G__6653,G__6654,G__6655) : self__.afn.call(null,G__6650,G__6651,G__6652,G__6653,G__6654,G__6655));
});
var G__7099__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6656 = a;
var G__6657 = b;
var G__6658 = c;
var G__6659 = d;
var G__6660 = e;
var G__6661 = f;
var G__6662 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__6656,G__6657,G__6658,G__6659,G__6660,G__6661,G__6662) : self__.afn.call(null,G__6656,G__6657,G__6658,G__6659,G__6660,G__6661,G__6662));
});
var G__7099__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6663 = a;
var G__6664 = b;
var G__6665 = c;
var G__6666 = d;
var G__6667 = e;
var G__6668 = f;
var G__6669 = g;
var G__6670 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__6663,G__6664,G__6665,G__6666,G__6667,G__6668,G__6669,G__6670) : self__.afn.call(null,G__6663,G__6664,G__6665,G__6666,G__6667,G__6668,G__6669,G__6670));
});
var G__7099__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6671 = a;
var G__6672 = b;
var G__6673 = c;
var G__6674 = d;
var G__6675 = e;
var G__6676 = f;
var G__6677 = g;
var G__6678 = h;
var G__6679 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__6671,G__6672,G__6673,G__6674,G__6675,G__6676,G__6677,G__6678,G__6679) : self__.afn.call(null,G__6671,G__6672,G__6673,G__6674,G__6675,G__6676,G__6677,G__6678,G__6679));
});
var G__7099__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6680 = a;
var G__6681 = b;
var G__6682 = c;
var G__6683 = d;
var G__6684 = e;
var G__6685 = f;
var G__6686 = g;
var G__6687 = h;
var G__6688 = i;
var G__6689 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__6680,G__6681,G__6682,G__6683,G__6684,G__6685,G__6686,G__6687,G__6688,G__6689) : self__.afn.call(null,G__6680,G__6681,G__6682,G__6683,G__6684,G__6685,G__6686,G__6687,G__6688,G__6689));
});
var G__7099__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6690 = a;
var G__6691 = b;
var G__6692 = c;
var G__6693 = d;
var G__6694 = e;
var G__6695 = f;
var G__6696 = g;
var G__6697 = h;
var G__6698 = i;
var G__6699 = j;
var G__6700 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__6690,G__6691,G__6692,G__6693,G__6694,G__6695,G__6696,G__6697,G__6698,G__6699,G__6700) : self__.afn.call(null,G__6690,G__6691,G__6692,G__6693,G__6694,G__6695,G__6696,G__6697,G__6698,G__6699,G__6700));
});
var G__7099__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6701 = a;
var G__6702 = b;
var G__6703 = c;
var G__6704 = d;
var G__6705 = e;
var G__6706 = f;
var G__6707 = g;
var G__6708 = h;
var G__6709 = i;
var G__6710 = j;
var G__6711 = k;
var G__6712 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__6701,G__6702,G__6703,G__6704,G__6705,G__6706,G__6707,G__6708,G__6709,G__6710,G__6711,G__6712) : self__.afn.call(null,G__6701,G__6702,G__6703,G__6704,G__6705,G__6706,G__6707,G__6708,G__6709,G__6710,G__6711,G__6712));
});
var G__7099__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6713 = a;
var G__6714 = b;
var G__6715 = c;
var G__6716 = d;
var G__6717 = e;
var G__6718 = f;
var G__6719 = g;
var G__6720 = h;
var G__6721 = i;
var G__6722 = j;
var G__6723 = k;
var G__6724 = l;
var G__6725 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__6713,G__6714,G__6715,G__6716,G__6717,G__6718,G__6719,G__6720,G__6721,G__6722,G__6723,G__6724,G__6725) : self__.afn.call(null,G__6713,G__6714,G__6715,G__6716,G__6717,G__6718,G__6719,G__6720,G__6721,G__6722,G__6723,G__6724,G__6725));
});
var G__7099__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6726 = a;
var G__6727 = b;
var G__6728 = c;
var G__6729 = d;
var G__6730 = e;
var G__6731 = f;
var G__6732 = g;
var G__6733 = h;
var G__6734 = i;
var G__6735 = j;
var G__6736 = k;
var G__6737 = l;
var G__6738 = m;
var G__6739 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__6726,G__6727,G__6728,G__6729,G__6730,G__6731,G__6732,G__6733,G__6734,G__6735,G__6736,G__6737,G__6738,G__6739) : self__.afn.call(null,G__6726,G__6727,G__6728,G__6729,G__6730,G__6731,G__6732,G__6733,G__6734,G__6735,G__6736,G__6737,G__6738,G__6739));
});
var G__7099__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6740 = a;
var G__6741 = b;
var G__6742 = c;
var G__6743 = d;
var G__6744 = e;
var G__6745 = f;
var G__6746 = g;
var G__6747 = h;
var G__6748 = i;
var G__6749 = j;
var G__6750 = k;
var G__6751 = l;
var G__6752 = m;
var G__6753 = n;
var G__6754 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__6740,G__6741,G__6742,G__6743,G__6744,G__6745,G__6746,G__6747,G__6748,G__6749,G__6750,G__6751,G__6752,G__6753,G__6754) : self__.afn.call(null,G__6740,G__6741,G__6742,G__6743,G__6744,G__6745,G__6746,G__6747,G__6748,G__6749,G__6750,G__6751,G__6752,G__6753,G__6754));
});
var G__7099__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6755 = a;
var G__6756 = b;
var G__6757 = c;
var G__6758 = d;
var G__6759 = e;
var G__6760 = f;
var G__6761 = g;
var G__6762 = h;
var G__6763 = i;
var G__6764 = j;
var G__6765 = k;
var G__6766 = l;
var G__6767 = m;
var G__6768 = n;
var G__6769 = o;
var G__6770 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__6755,G__6756,G__6757,G__6758,G__6759,G__6760,G__6761,G__6762,G__6763,G__6764,G__6765,G__6766,G__6767,G__6768,G__6769,G__6770) : self__.afn.call(null,G__6755,G__6756,G__6757,G__6758,G__6759,G__6760,G__6761,G__6762,G__6763,G__6764,G__6765,G__6766,G__6767,G__6768,G__6769,G__6770));
});
var G__7099__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6771 = a;
var G__6772 = b;
var G__6773 = c;
var G__6774 = d;
var G__6775 = e;
var G__6776 = f;
var G__6777 = g;
var G__6778 = h;
var G__6779 = i;
var G__6780 = j;
var G__6781 = k;
var G__6782 = l;
var G__6783 = m;
var G__6784 = n;
var G__6785 = o;
var G__6786 = p;
var G__6787 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__6771,G__6772,G__6773,G__6774,G__6775,G__6776,G__6777,G__6778,G__6779,G__6780,G__6781,G__6782,G__6783,G__6784,G__6785,G__6786,G__6787) : self__.afn.call(null,G__6771,G__6772,G__6773,G__6774,G__6775,G__6776,G__6777,G__6778,G__6779,G__6780,G__6781,G__6782,G__6783,G__6784,G__6785,G__6786,G__6787));
});
var G__7099__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6788 = a;
var G__6789 = b;
var G__6790 = c;
var G__6791 = d;
var G__6792 = e;
var G__6793 = f;
var G__6794 = g;
var G__6795 = h;
var G__6796 = i;
var G__6797 = j;
var G__6798 = k;
var G__6799 = l;
var G__6800 = m;
var G__6801 = n;
var G__6802 = o;
var G__6803 = p;
var G__6804 = q;
var G__6805 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__6788,G__6789,G__6790,G__6791,G__6792,G__6793,G__6794,G__6795,G__6796,G__6797,G__6798,G__6799,G__6800,G__6801,G__6802,G__6803,G__6804,G__6805) : self__.afn.call(null,G__6788,G__6789,G__6790,G__6791,G__6792,G__6793,G__6794,G__6795,G__6796,G__6797,G__6798,G__6799,G__6800,G__6801,G__6802,G__6803,G__6804,G__6805));
});
var G__7099__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6806 = a;
var G__6807 = b;
var G__6808 = c;
var G__6809 = d;
var G__6810 = e;
var G__6811 = f;
var G__6812 = g;
var G__6813 = h;
var G__6814 = i;
var G__6815 = j;
var G__6816 = k;
var G__6817 = l;
var G__6818 = m;
var G__6819 = n;
var G__6820 = o;
var G__6821 = p;
var G__6822 = q;
var G__6823 = r;
var G__6824 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__6806,G__6807,G__6808,G__6809,G__6810,G__6811,G__6812,G__6813,G__6814,G__6815,G__6816,G__6817,G__6818,G__6819,G__6820,G__6821,G__6822,G__6823,G__6824) : self__.afn.call(null,G__6806,G__6807,G__6808,G__6809,G__6810,G__6811,G__6812,G__6813,G__6814,G__6815,G__6816,G__6817,G__6818,G__6819,G__6820,G__6821,G__6822,G__6823,G__6824));
});
var G__7099__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6825 = a;
var G__6826 = b;
var G__6827 = c;
var G__6828 = d;
var G__6829 = e;
var G__6830 = f;
var G__6831 = g;
var G__6832 = h;
var G__6833 = i;
var G__6834 = j;
var G__6835 = k;
var G__6836 = l;
var G__6837 = m;
var G__6838 = n;
var G__6839 = o;
var G__6840 = p;
var G__6841 = q;
var G__6842 = r;
var G__6843 = s;
var G__6844 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__6825,G__6826,G__6827,G__6828,G__6829,G__6830,G__6831,G__6832,G__6833,G__6834,G__6835,G__6836,G__6837,G__6838,G__6839,G__6840,G__6841,G__6842,G__6843,G__6844) : self__.afn.call(null,G__6825,G__6826,G__6827,G__6828,G__6829,G__6830,G__6831,G__6832,G__6833,G__6834,G__6835,G__6836,G__6837,G__6838,G__6839,G__6840,G__6841,G__6842,G__6843,G__6844));
});
var G__7099__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6845 = self__.afn;
var G__6846 = a;
var G__6847 = b;
var G__6848 = c;
var G__6849 = d;
var G__6850 = e;
var G__6851 = f;
var G__6852 = g;
var G__6853 = h;
var G__6854 = i;
var G__6855 = j;
var G__6856 = k;
var G__6857 = l;
var G__6858 = m;
var G__6859 = n;
var G__6860 = o;
var G__6861 = p;
var G__6862 = q;
var G__6863 = r;
var G__6864 = s;
var G__6865 = t;
var G__6866 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__6845,G__6846,G__6847,G__6848,G__6849,G__6850,G__6851,G__6852,G__6853,G__6854,G__6855,G__6856,G__6857,G__6858,G__6859,G__6860,G__6861,G__6862,G__6863,G__6864,G__6865,G__6866) : cljs.core.apply.call(null,G__6845,G__6846,G__6847,G__6848,G__6849,G__6850,G__6851,G__6852,G__6853,G__6854,G__6855,G__6856,G__6857,G__6858,G__6859,G__6860,G__6861,G__6862,G__6863,G__6864,G__6865,G__6866));
});
G__7099 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__7099__1.call(this,self__);
case 2:
return G__7099__2.call(this,self__,a);
case 3:
return G__7099__3.call(this,self__,a,b);
case 4:
return G__7099__4.call(this,self__,a,b,c);
case 5:
return G__7099__5.call(this,self__,a,b,c,d);
case 6:
return G__7099__6.call(this,self__,a,b,c,d,e);
case 7:
return G__7099__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__7099__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__7099__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__7099__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__7099__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__7099__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__7099__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__7099__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__7099__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__7099__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__7099__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__7099__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__7099__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__7099__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__7099__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__7099__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7099.cljs$core$IFn$_invoke$arity$1 = G__7099__1;
G__7099.cljs$core$IFn$_invoke$arity$2 = G__7099__2;
G__7099.cljs$core$IFn$_invoke$arity$3 = G__7099__3;
G__7099.cljs$core$IFn$_invoke$arity$4 = G__7099__4;
G__7099.cljs$core$IFn$_invoke$arity$5 = G__7099__5;
G__7099.cljs$core$IFn$_invoke$arity$6 = G__7099__6;
G__7099.cljs$core$IFn$_invoke$arity$7 = G__7099__7;
G__7099.cljs$core$IFn$_invoke$arity$8 = G__7099__8;
G__7099.cljs$core$IFn$_invoke$arity$9 = G__7099__9;
G__7099.cljs$core$IFn$_invoke$arity$10 = G__7099__10;
G__7099.cljs$core$IFn$_invoke$arity$11 = G__7099__11;
G__7099.cljs$core$IFn$_invoke$arity$12 = G__7099__12;
G__7099.cljs$core$IFn$_invoke$arity$13 = G__7099__13;
G__7099.cljs$core$IFn$_invoke$arity$14 = G__7099__14;
G__7099.cljs$core$IFn$_invoke$arity$15 = G__7099__15;
G__7099.cljs$core$IFn$_invoke$arity$16 = G__7099__16;
G__7099.cljs$core$IFn$_invoke$arity$17 = G__7099__17;
G__7099.cljs$core$IFn$_invoke$arity$18 = G__7099__18;
G__7099.cljs$core$IFn$_invoke$arity$19 = G__7099__19;
G__7099.cljs$core$IFn$_invoke$arity$20 = G__7099__20;
G__7099.cljs$core$IFn$_invoke$arity$21 = G__7099__21;
G__7099.cljs$core$IFn$_invoke$arity$22 = G__7099__22;
return G__7099;
})()
;

cljs.core.MetaFn.prototype.apply = (function (self__,args6634){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6634)));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
var G__6867 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__6867) : self__.afn.call(null,G__6867));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
var G__6868 = a;
var G__6869 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__6868,G__6869) : self__.afn.call(null,G__6868,G__6869));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
var G__6870 = a;
var G__6871 = b;
var G__6872 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__6870,G__6871,G__6872) : self__.afn.call(null,G__6870,G__6871,G__6872));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
var G__6873 = a;
var G__6874 = b;
var G__6875 = c;
var G__6876 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__6873,G__6874,G__6875,G__6876) : self__.afn.call(null,G__6873,G__6874,G__6875,G__6876));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
var G__6877 = a;
var G__6878 = b;
var G__6879 = c;
var G__6880 = d;
var G__6881 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__6877,G__6878,G__6879,G__6880,G__6881) : self__.afn.call(null,G__6877,G__6878,G__6879,G__6880,G__6881));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
var G__6882 = a;
var G__6883 = b;
var G__6884 = c;
var G__6885 = d;
var G__6886 = e;
var G__6887 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__6882,G__6883,G__6884,G__6885,G__6886,G__6887) : self__.afn.call(null,G__6882,G__6883,G__6884,G__6885,G__6886,G__6887));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var G__6888 = a;
var G__6889 = b;
var G__6890 = c;
var G__6891 = d;
var G__6892 = e;
var G__6893 = f;
var G__6894 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__6888,G__6889,G__6890,G__6891,G__6892,G__6893,G__6894) : self__.afn.call(null,G__6888,G__6889,G__6890,G__6891,G__6892,G__6893,G__6894));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var G__6895 = a;
var G__6896 = b;
var G__6897 = c;
var G__6898 = d;
var G__6899 = e;
var G__6900 = f;
var G__6901 = g;
var G__6902 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__6895,G__6896,G__6897,G__6898,G__6899,G__6900,G__6901,G__6902) : self__.afn.call(null,G__6895,G__6896,G__6897,G__6898,G__6899,G__6900,G__6901,G__6902));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var G__6903 = a;
var G__6904 = b;
var G__6905 = c;
var G__6906 = d;
var G__6907 = e;
var G__6908 = f;
var G__6909 = g;
var G__6910 = h;
var G__6911 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__6903,G__6904,G__6905,G__6906,G__6907,G__6908,G__6909,G__6910,G__6911) : self__.afn.call(null,G__6903,G__6904,G__6905,G__6906,G__6907,G__6908,G__6909,G__6910,G__6911));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var G__6912 = a;
var G__6913 = b;
var G__6914 = c;
var G__6915 = d;
var G__6916 = e;
var G__6917 = f;
var G__6918 = g;
var G__6919 = h;
var G__6920 = i;
var G__6921 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__6912,G__6913,G__6914,G__6915,G__6916,G__6917,G__6918,G__6919,G__6920,G__6921) : self__.afn.call(null,G__6912,G__6913,G__6914,G__6915,G__6916,G__6917,G__6918,G__6919,G__6920,G__6921));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var G__6922 = a;
var G__6923 = b;
var G__6924 = c;
var G__6925 = d;
var G__6926 = e;
var G__6927 = f;
var G__6928 = g;
var G__6929 = h;
var G__6930 = i;
var G__6931 = j;
var G__6932 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__6922,G__6923,G__6924,G__6925,G__6926,G__6927,G__6928,G__6929,G__6930,G__6931,G__6932) : self__.afn.call(null,G__6922,G__6923,G__6924,G__6925,G__6926,G__6927,G__6928,G__6929,G__6930,G__6931,G__6932));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var G__6933 = a;
var G__6934 = b;
var G__6935 = c;
var G__6936 = d;
var G__6937 = e;
var G__6938 = f;
var G__6939 = g;
var G__6940 = h;
var G__6941 = i;
var G__6942 = j;
var G__6943 = k;
var G__6944 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__6933,G__6934,G__6935,G__6936,G__6937,G__6938,G__6939,G__6940,G__6941,G__6942,G__6943,G__6944) : self__.afn.call(null,G__6933,G__6934,G__6935,G__6936,G__6937,G__6938,G__6939,G__6940,G__6941,G__6942,G__6943,G__6944));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var G__6945 = a;
var G__6946 = b;
var G__6947 = c;
var G__6948 = d;
var G__6949 = e;
var G__6950 = f;
var G__6951 = g;
var G__6952 = h;
var G__6953 = i;
var G__6954 = j;
var G__6955 = k;
var G__6956 = l;
var G__6957 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__6945,G__6946,G__6947,G__6948,G__6949,G__6950,G__6951,G__6952,G__6953,G__6954,G__6955,G__6956,G__6957) : self__.afn.call(null,G__6945,G__6946,G__6947,G__6948,G__6949,G__6950,G__6951,G__6952,G__6953,G__6954,G__6955,G__6956,G__6957));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var G__6958 = a;
var G__6959 = b;
var G__6960 = c;
var G__6961 = d;
var G__6962 = e;
var G__6963 = f;
var G__6964 = g;
var G__6965 = h;
var G__6966 = i;
var G__6967 = j;
var G__6968 = k;
var G__6969 = l;
var G__6970 = m;
var G__6971 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__6958,G__6959,G__6960,G__6961,G__6962,G__6963,G__6964,G__6965,G__6966,G__6967,G__6968,G__6969,G__6970,G__6971) : self__.afn.call(null,G__6958,G__6959,G__6960,G__6961,G__6962,G__6963,G__6964,G__6965,G__6966,G__6967,G__6968,G__6969,G__6970,G__6971));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var G__6972 = a;
var G__6973 = b;
var G__6974 = c;
var G__6975 = d;
var G__6976 = e;
var G__6977 = f;
var G__6978 = g;
var G__6979 = h;
var G__6980 = i;
var G__6981 = j;
var G__6982 = k;
var G__6983 = l;
var G__6984 = m;
var G__6985 = n;
var G__6986 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__6972,G__6973,G__6974,G__6975,G__6976,G__6977,G__6978,G__6979,G__6980,G__6981,G__6982,G__6983,G__6984,G__6985,G__6986) : self__.afn.call(null,G__6972,G__6973,G__6974,G__6975,G__6976,G__6977,G__6978,G__6979,G__6980,G__6981,G__6982,G__6983,G__6984,G__6985,G__6986));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var G__6987 = a;
var G__6988 = b;
var G__6989 = c;
var G__6990 = d;
var G__6991 = e;
var G__6992 = f;
var G__6993 = g;
var G__6994 = h;
var G__6995 = i;
var G__6996 = j;
var G__6997 = k;
var G__6998 = l;
var G__6999 = m;
var G__7000 = n;
var G__7001 = o;
var G__7002 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__6987,G__6988,G__6989,G__6990,G__6991,G__6992,G__6993,G__6994,G__6995,G__6996,G__6997,G__6998,G__6999,G__7000,G__7001,G__7002) : self__.afn.call(null,G__6987,G__6988,G__6989,G__6990,G__6991,G__6992,G__6993,G__6994,G__6995,G__6996,G__6997,G__6998,G__6999,G__7000,G__7001,G__7002));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var G__7003 = a;
var G__7004 = b;
var G__7005 = c;
var G__7006 = d;
var G__7007 = e;
var G__7008 = f;
var G__7009 = g;
var G__7010 = h;
var G__7011 = i;
var G__7012 = j;
var G__7013 = k;
var G__7014 = l;
var G__7015 = m;
var G__7016 = n;
var G__7017 = o;
var G__7018 = p;
var G__7019 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__7003,G__7004,G__7005,G__7006,G__7007,G__7008,G__7009,G__7010,G__7011,G__7012,G__7013,G__7014,G__7015,G__7016,G__7017,G__7018,G__7019) : self__.afn.call(null,G__7003,G__7004,G__7005,G__7006,G__7007,G__7008,G__7009,G__7010,G__7011,G__7012,G__7013,G__7014,G__7015,G__7016,G__7017,G__7018,G__7019));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var G__7020 = a;
var G__7021 = b;
var G__7022 = c;
var G__7023 = d;
var G__7024 = e;
var G__7025 = f;
var G__7026 = g;
var G__7027 = h;
var G__7028 = i;
var G__7029 = j;
var G__7030 = k;
var G__7031 = l;
var G__7032 = m;
var G__7033 = n;
var G__7034 = o;
var G__7035 = p;
var G__7036 = q;
var G__7037 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__7020,G__7021,G__7022,G__7023,G__7024,G__7025,G__7026,G__7027,G__7028,G__7029,G__7030,G__7031,G__7032,G__7033,G__7034,G__7035,G__7036,G__7037) : self__.afn.call(null,G__7020,G__7021,G__7022,G__7023,G__7024,G__7025,G__7026,G__7027,G__7028,G__7029,G__7030,G__7031,G__7032,G__7033,G__7034,G__7035,G__7036,G__7037));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var G__7038 = a;
var G__7039 = b;
var G__7040 = c;
var G__7041 = d;
var G__7042 = e;
var G__7043 = f;
var G__7044 = g;
var G__7045 = h;
var G__7046 = i;
var G__7047 = j;
var G__7048 = k;
var G__7049 = l;
var G__7050 = m;
var G__7051 = n;
var G__7052 = o;
var G__7053 = p;
var G__7054 = q;
var G__7055 = r;
var G__7056 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__7038,G__7039,G__7040,G__7041,G__7042,G__7043,G__7044,G__7045,G__7046,G__7047,G__7048,G__7049,G__7050,G__7051,G__7052,G__7053,G__7054,G__7055,G__7056) : self__.afn.call(null,G__7038,G__7039,G__7040,G__7041,G__7042,G__7043,G__7044,G__7045,G__7046,G__7047,G__7048,G__7049,G__7050,G__7051,G__7052,G__7053,G__7054,G__7055,G__7056));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var G__7057 = a;
var G__7058 = b;
var G__7059 = c;
var G__7060 = d;
var G__7061 = e;
var G__7062 = f;
var G__7063 = g;
var G__7064 = h;
var G__7065 = i;
var G__7066 = j;
var G__7067 = k;
var G__7068 = l;
var G__7069 = m;
var G__7070 = n;
var G__7071 = o;
var G__7072 = p;
var G__7073 = q;
var G__7074 = r;
var G__7075 = s;
var G__7076 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__7057,G__7058,G__7059,G__7060,G__7061,G__7062,G__7063,G__7064,G__7065,G__7066,G__7067,G__7068,G__7069,G__7070,G__7071,G__7072,G__7073,G__7074,G__7075,G__7076) : self__.afn.call(null,G__7057,G__7058,G__7059,G__7060,G__7061,G__7062,G__7063,G__7064,G__7065,G__7066,G__7067,G__7068,G__7069,G__7070,G__7071,G__7072,G__7073,G__7074,G__7075,G__7076));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__7077 = self__.afn;
var G__7078 = a;
var G__7079 = b;
var G__7080 = c;
var G__7081 = d;
var G__7082 = e;
var G__7083 = f;
var G__7084 = g;
var G__7085 = h;
var G__7086 = i;
var G__7087 = j;
var G__7088 = k;
var G__7089 = l;
var G__7090 = m;
var G__7091 = n;
var G__7092 = o;
var G__7093 = p;
var G__7094 = q;
var G__7095 = r;
var G__7096 = s;
var G__7097 = t;
var G__7098 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__7077,G__7078,G__7079,G__7080,G__7081,G__7082,G__7083,G__7084,G__7085,G__7086,G__7087,G__7088,G__7089,G__7090,G__7091,G__7092,G__7093,G__7094,G__7095,G__7096,G__7097,G__7098) : cljs.core.apply.call(null,G__7077,G__7078,G__7079,G__7080,G__7081,G__7082,G__7083,G__7084,G__7085,G__7086,G__7087,G__7088,G__7089,G__7090,G__7091,G__7092,G__7093,G__7094,G__7095,G__7096,G__7097,G__7098));
});

cljs.core.MetaFn.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
});

cljs.core.MetaFn.cljs$lang$type = true;

cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";

cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/MetaFn");
});

cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 * map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if((cljs.core.fn_QMARK_(o)) && (!((function (){var G__7103 = o;
if(G__7103){
var bit__4599__auto__ = (G__7103.cljs$lang$protocol_mask$partition0$ & (262144));
if((bit__4599__auto__) || (G__7103.cljs$core$IWithMeta$)){
return true;
} else {
if((!G__7103.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__7103);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__7103);
}
})()))){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__3913__auto__ = !((o == null));
if(and__3913__auto__){
var G__7107 = o;
if(G__7107){
var bit__4599__auto__ = (G__7107.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4599__auto__) || (G__7107.cljs$core$IMeta$)){
return true;
} else {
if((!G__7107.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__7107);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__7107);
}
} else {
return and__3913__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 * more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 * item, for a vector, returns a new vector without the last item.
 * Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 * does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(){
var G__7112 = arguments.length;
switch (G__7112) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__7114 = ret;
var G__7115 = cljs.core.first(ks);
var G__7116 = cljs.core.next(ks);
coll = G__7114;
k = G__7115;
ks = G__7116;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.disj.cljs$lang$applyTo = (function (seq7108){
var G__7109 = cljs.core.first(seq7108);
var seq7108__$1 = cljs.core.next(seq7108);
var G__7110 = cljs.core.first(seq7108__$1);
var seq7108__$2 = cljs.core.next(seq7108__$1);
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__7109,G__7110,seq7108__$2);
});

cljs.core.disj.cljs$lang$maxFixedArity = (2);
/**
 * Returns true if coll has no items - same as (not (seq coll)).
 * Please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
return ((coll == null)) || (cljs.core.not(cljs.core.seq(coll)));
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
var G__7118 = x;
if(G__7118){
var bit__4599__auto__ = (G__7118.cljs$lang$protocol_mask$partition0$ & (8));
if((bit__4599__auto__) || (G__7118.cljs$core$ICollection$)){
return true;
} else {
if((!G__7118.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__7118);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__7118);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
var G__7120 = x;
if(G__7120){
var bit__4599__auto__ = (G__7120.cljs$lang$protocol_mask$partition0$ & (4096));
if((bit__4599__auto__) || (G__7120.cljs$core$ISet$)){
return true;
} else {
if((!G__7120.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__7120);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__7120);
}
}
});
/**
 * Returns true if coll implements Associative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
var G__7122 = x;
if(G__7122){
var bit__4599__auto__ = (G__7122.cljs$lang$protocol_mask$partition0$ & (512));
if((bit__4599__auto__) || (G__7122.cljs$core$IAssociative$)){
return true;
} else {
if((!G__7122.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__7122);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__7122);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
var G__7124 = x;
if(G__7124){
var bit__4599__auto__ = (G__7124.cljs$lang$protocol_mask$partition0$ & (16777216));
if((bit__4599__auto__) || (G__7124.cljs$core$ISequential$)){
return true;
} else {
if((!G__7124.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__7124);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__7124);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
var G__7126 = x;
if(G__7126){
var bit__4599__auto__ = (G__7126.cljs$lang$protocol_mask$partition0$ & (268435456));
if((bit__4599__auto__) || (G__7126.cljs$core$ISorted$)){
return true;
} else {
if((!G__7126.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__7126);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__7126);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
var G__7128 = x;
if(G__7128){
var bit__4599__auto__ = (G__7128.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4599__auto__) || (G__7128.cljs$core$IReduce$)){
return true;
} else {
if((!G__7128.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__7128);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__7128);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
var G__7130 = x;
if(G__7130){
var bit__4599__auto__ = (G__7130.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4599__auto__) || (G__7130.cljs$core$IMap$)){
return true;
} else {
if((!G__7130.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__7130);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__7130);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
var G__7132 = x;
if(G__7132){
var bit__4599__auto__ = (G__7132.cljs$lang$protocol_mask$partition0$ & (67108864));
if((bit__4599__auto__) || (G__7132.cljs$core$IRecord$)){
return true;
} else {
if((!G__7132.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,G__7132);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,G__7132);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
var G__7134 = x;
if(G__7134){
var bit__4599__auto__ = (G__7134.cljs$lang$protocol_mask$partition0$ & (16384));
if((bit__4599__auto__) || (G__7134.cljs$core$IVector$)){
return true;
} else {
if((!G__7134.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__7134);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__7134);
}
});

/**
 * Return true if x is satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
var G__7136 = x;
if(G__7136){
var bit__4592__auto__ = (G__7136.cljs$lang$protocol_mask$partition1$ & (512));
if((bit__4592__auto__) || (G__7136.cljs$core$IChunkedSeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 * interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(){
var G__7139 = arguments.length;
switch (G__7139) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0)));
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__4976__auto__);

}
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function (){
var obj7141 = {};
return obj7141;
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var G__7142 = goog.object.create;
var G__7143 = keyvals;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(G__7142,G__7143) : cljs.core.apply.call(null,G__7142,G__7143));
});

cljs.core.js_obj.cljs$lang$applyTo = (function (seq7137){
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq7137));
});

cljs.core.js_obj.cljs$lang$maxFixedArity = (0);
/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
var keys = [];
var G__7147_7149 = obj;
var G__7148_7150 = ((function (G__7147_7149,keys){
return (function (val,key,obj__$1){
return keys.push(key);
});})(G__7147_7149,keys))
;
goog.object.forEach(G__7147_7149,G__7148_7150);

return keys;
});
/**
 * Delete a property from a JavaScript object.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__7151 = (i__$1 + (1));
var G__7152 = (j__$1 + (1));
var G__7153 = (len__$1 - (1));
i__$1 = G__7151;
j__$1 = G__7152;
len__$1 = G__7153;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__7154 = (i__$1 - (1));
var G__7155 = (j__$1 - (1));
var G__7156 = (len__$1 - (1));
i__$1 = G__7154;
j__$1 = G__7155;
len__$1 = G__7156;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = (function (){var obj7158 = {};
return obj7158;
})();
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
var G__7160 = s;
if(G__7160){
var bit__4599__auto__ = (G__7160.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4599__auto__) || (G__7160.cljs$core$ISeq$)){
return true;
} else {
if((!G__7160.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__7160);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__7160);
}
}
});
/**
 * Return true if s satisfies ISeqable
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var G__7162 = s;
if(G__7162){
var bit__4599__auto__ = (G__7162.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4599__auto__) || (G__7162.cljs$core$ISeqable$)){
return true;
} else {
if((!G__7162.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__7162);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__7162);
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if(cljs.core.truth_(x)){
return true;
} else {
return false;
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__3925__auto__ = cljs.core.fn_QMARK_(f);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var G__7166 = f;
if(G__7166){
var bit__4599__auto__ = (G__7166.cljs$lang$protocol_mask$partition0$ & (1));
if((bit__4599__auto__) || (G__7166.cljs$core$IFn$)){
return true;
} else {
if((!G__7166.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__7166);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__7166);
}
}
});
/**
 * Returns true if n is an integer.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return (typeof n === 'number') && (cljs.core.not((function (){var G__7179 = n;
return isNaN(G__7179);
})())) && (!((n === Infinity))) && (((function (){var G__7180 = n;
return parseFloat(G__7180);
})() === (function (){var G__7181 = n;
var G__7182 = (10);
return parseInt(G__7181,G__7182);
})()));
});
/**
 * Returns true if key is present in the given collection, otherwise
 * returns false.  Note that for numerically indexed collections like
 * vectors and arrays, this tests if the numeric key is within the
 * range of indexes. 'contains?' operates constant or logarithmic time;
 * it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if((!((coll == null))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k)], null);
} else {
return null;
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(){
var G__7187 = arguments.length;
switch (G__7187) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
if(!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))){
var s = cljs.core.PersistentHashSet.fromArray([x,y], true);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__7189 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__7190 = etc;
s = G__7189;
xs = G__7190;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
});

cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function (seq7183){
var G__7184 = cljs.core.first(seq7183);
var seq7183__$1 = cljs.core.next(seq7183);
var G__7185 = cljs.core.first(seq7183__$1);
var seq7183__$2 = cljs.core.next(seq7183__$1);
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__7184,G__7185,seq7183__$2);
});

cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2);
/**
 * Comparator. Returns a negative number, zero, or a positive number
 * when x is logically 'less than', 'equal to', or 'greater than'
 * y. Uses IComparable if available and google.array.defaultCompare for objects
 * of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
var G__7196 = x;
var G__7197 = y;
return goog.array.defaultCompare(G__7196,G__7197);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
} else {
if((function (){var G__7198 = x;
if(G__7198){
var bit__4599__auto__ = (G__7198.cljs$lang$protocol_mask$partition1$ & (2048));
if((bit__4599__auto__) || (G__7198.cljs$core$IComparable$)){
return true;
} else {
if((!G__7198.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,G__7198);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,G__7198);
}
})()){
return cljs.core._compare(x,y);
} else {
if(((typeof x === 'string') || (cljs.core.array_QMARK_(x)) || (x === true) || (x === false)) && ((cljs.core.type(x) === cljs.core.type(y)))){
var G__7199 = x;
var G__7200 = y;
return goog.array.defaultCompare(G__7199,G__7200);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(){
var G__7202 = arguments.length;
switch (G__7202) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if(((d === (0))) && (((n + (1)) < len))){
var G__7204 = xs;
var G__7205 = ys;
var G__7206 = len;
var G__7207 = (n + (1));
xs = G__7204;
ys = G__7205;
len = G__7206;
n = G__7207;
continue;
} else {
return d;
}
break;
}
});

cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;
/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (function (){var G__7212 = x;
var G__7213 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7212,G__7213) : f.call(null,G__7212,G__7213));
})();
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((function (){var G__7214 = y;
var G__7215 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7214,G__7215) : f.call(null,G__7214,G__7215));
})())){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(){
var G__7217 = arguments.length;
switch (G__7217) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (function (){var G__7218 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__7218) : cljs.core.to_array.call(null,G__7218));
})();
var G__7219_7222 = a;
var G__7220_7223 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__7219_7222,G__7220_7223);

return cljs.core.seq(a);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.sort.cljs$lang$maxFixedArity = 2;
/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison funcion, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(){
var G__7225 = arguments.length;
switch (G__7225) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
return cljs.core.fn__GT_comparator(comp).call(null,(function (){var G__7226 = x;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__7226) : keyfn.call(null,G__7226));
})(),(function (){var G__7227 = y;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__7227) : keyfn.call(null,G__7227));
})());
}),coll);
});

cljs.core.sort_by.cljs$lang$maxFixedArity = 3;
cljs.core.seq_reduce = (function cljs$core$seq_reduce(){
var G__7230 = arguments.length;
switch (G__7230) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var temp__4421__auto__ = cljs.core.seq(coll);
if(temp__4421__auto__){
var s = temp__4421__auto__;
var G__7231 = f;
var G__7232 = cljs.core.first(s);
var G__7233 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__7231,G__7232,G__7233) : cljs.core.reduce.call(null,G__7231,G__7232,G__7233));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__7234 = val__$1;
var G__7235 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7234,G__7235) : f.call(null,G__7234,G__7235));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__7237 = nval;
var G__7238 = cljs.core.next(coll__$1);
val__$1 = G__7237;
coll__$1 = G__7238;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;
/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = (function (){var G__7242 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__7242) : cljs.core.to_array.call(null,G__7242));
})();
var G__7243_7245 = a;
goog.array.shuffle(G__7243_7245);

var G__7244 = a;
return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(G__7244) : cljs.core.vec.call(null,G__7244));
});
/**
 * f should be a function of 2 arguments. If val is not supplied,
 * returns the result of applying f to the first 2 items in coll, then
 * applying f to that result and the 3rd item, etc. If coll contains no
 * items, f must accept no arguments as well, and reduce returns the
 * result of calling f with no arguments.  If coll has only 1 item, it
 * is returned and f is not called.  If val is supplied, returns the
 * result of applying f to val and the first item in coll, then
 * applying f to that result and the 2nd item, etc. If coll contains no
 * items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(){
var G__7247 = arguments.length;
switch (G__7247) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
if((function (){var G__7248 = coll;
if(G__7248){
var bit__4592__auto__ = (G__7248.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4592__auto__) || (G__7248.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
if((function (){var G__7249 = coll;
if(G__7249){
var bit__4592__auto__ = (G__7249.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4592__auto__) || (G__7249.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
});

cljs.core.reduce.cljs$lang$maxFixedArity = 3;
/**
 * Reduces an associative collection. f should be a function of 3
 * arguments. Returns the result of applying f to init, the first key
 * and the first value in coll, then applying f to that result and the
 * 2nd key and value, etc. If coll contains no entries, returns init
 * and f is not called. Note that reduce-kv is supported on vectors,
 * where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if(!((coll == null))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 * transduce by adding an arity-1 signature that calls cf (default -
 * identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(){
var G__7252 = arguments.length;
switch (G__7252) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function (f,cf){
return (function() {
var G__7257 = null;
var G__7257__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__7257__1 = (function (x){
var G__7253 = x;
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(G__7253) : cf.call(null,G__7253));
});
var G__7257__2 = (function (x,y){
var G__7254 = x;
var G__7255 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7254,G__7255) : f.call(null,G__7254,G__7255));
});
G__7257 = function(x,y){
switch(arguments.length){
case 0:
return G__7257__0.call(this);
case 1:
return G__7257__1.call(this,x);
case 2:
return G__7257__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7257.cljs$core$IFn$_invoke$arity$0 = G__7257__0;
G__7257.cljs$core$IFn$_invoke$arity$1 = G__7257__1;
G__7257.cljs$core$IFn$_invoke$arity$2 = G__7257__2;
return G__7257;
})()
});

cljs.core.completing.cljs$lang$maxFixedArity = 2;
/**
 * reduce with a transformation of f (xf). If init is not
 * supplied, (f) will be called to produce it. f should be a reducing
 * step function that accepts both 1 and 2 arguments, if it accepts
 * only 2 you can add the arity-1 with 'completing'. Returns the result
 * of applying (the transformed) xf to init and the first item in coll,
 * then applying xf to that result and the 2nd item, etc. If coll
 * contains no items, returns init and f is not called. Note that
 * certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(){
var G__7259 = arguments.length;
switch (G__7259) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function (xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),coll);
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function (xform,f,init,coll){
var f__$1 = (function (){var G__7260 = f;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__7260) : xform.call(null,G__7260));
})();
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
var G__7261 = ret;
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(G__7261) : f__$1.call(null,G__7261));
});

cljs.core.transduce.cljs$lang$maxFixedArity = 4;
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(){
var G__7267 = arguments.length;
switch (G__7267) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
});

cljs.core._PLUS_.cljs$lang$applyTo = (function (seq7263){
var G__7264 = cljs.core.first(seq7263);
var seq7263__$1 = cljs.core.next(seq7263);
var G__7265 = cljs.core.first(seq7263__$1);
var seq7263__$2 = cljs.core.next(seq7263__$1);
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__7264,G__7265,seq7263__$2);
});

cljs.core._PLUS_.cljs$lang$maxFixedArity = (2);
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(){
var G__7273 = arguments.length;
switch (G__7273) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
});

cljs.core._.cljs$lang$applyTo = (function (seq7269){
var G__7270 = cljs.core.first(seq7269);
var seq7269__$1 = cljs.core.next(seq7269);
var G__7271 = cljs.core.first(seq7269__$1);
var seq7269__$2 = cljs.core.next(seq7269__$1);
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__7270,G__7271,seq7269__$2);
});

cljs.core._.cljs$lang$maxFixedArity = (2);
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(){
var G__7279 = arguments.length;
switch (G__7279) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
});

cljs.core._STAR_.cljs$lang$applyTo = (function (seq7275){
var G__7276 = cljs.core.first(seq7275);
var seq7275__$1 = cljs.core.next(seq7275);
var G__7277 = cljs.core.first(seq7275__$1);
var seq7275__$2 = cljs.core.next(seq7275__$1);
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__7276,G__7277,seq7275__$2);
});

cljs.core._STAR_.cljs$lang$maxFixedArity = (2);
/**
 * If no denominators are supplied, returns 1/numerator,
 * else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(){
var G__7285 = arguments.length;
switch (G__7285) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
});

cljs.core._SLASH_.cljs$lang$applyTo = (function (seq7281){
var G__7282 = cljs.core.first(seq7281);
var seq7281__$1 = cljs.core.next(seq7281);
var G__7283 = cljs.core.first(seq7281__$1);
var seq7281__$2 = cljs.core.next(seq7281__$1);
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__7282,G__7283,seq7281__$2);
});

cljs.core._SLASH_.cljs$lang$maxFixedArity = (2);
/**
 * Returns non-nil if nums are in monotonically increasing order,
 * otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(){
var G__7291 = arguments.length;
switch (G__7291) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x < y);
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__7293 = y;
var G__7294 = cljs.core.first(more);
var G__7295 = cljs.core.next(more);
x = G__7293;
y = G__7294;
more = G__7295;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT_.cljs$lang$applyTo = (function (seq7287){
var G__7288 = cljs.core.first(seq7287);
var seq7287__$1 = cljs.core.next(seq7287);
var G__7289 = cljs.core.first(seq7287__$1);
var seq7287__$2 = cljs.core.next(seq7287__$1);
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__7288,G__7289,seq7287__$2);
});

cljs.core._LT_.cljs$lang$maxFixedArity = (2);
/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(){
var G__7300 = arguments.length;
switch (G__7300) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x <= y);
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__7302 = y;
var G__7303 = cljs.core.first(more);
var G__7304 = cljs.core.next(more);
x = G__7302;
y = G__7303;
more = G__7304;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT__EQ_.cljs$lang$applyTo = (function (seq7296){
var G__7297 = cljs.core.first(seq7296);
var seq7296__$1 = cljs.core.next(seq7296);
var G__7298 = cljs.core.first(seq7296__$1);
var seq7296__$2 = cljs.core.next(seq7296__$1);
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__7297,G__7298,seq7296__$2);
});

cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2);
/**
 * Returns non-nil if nums are in monotonically decreasing order,
 * otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(){
var G__7309 = arguments.length;
switch (G__7309) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x > y);
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__7311 = y;
var G__7312 = cljs.core.first(more);
var G__7313 = cljs.core.next(more);
x = G__7311;
y = G__7312;
more = G__7313;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT_.cljs$lang$applyTo = (function (seq7305){
var G__7306 = cljs.core.first(seq7305);
var seq7305__$1 = cljs.core.next(seq7305);
var G__7307 = cljs.core.first(seq7305__$1);
var seq7305__$2 = cljs.core.next(seq7305__$1);
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__7306,G__7307,seq7305__$2);
});

cljs.core._GT_.cljs$lang$maxFixedArity = (2);
/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(){
var G__7318 = arguments.length;
switch (G__7318) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x >= y);
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__7320 = y;
var G__7321 = cljs.core.first(more);
var G__7322 = cljs.core.next(more);
x = G__7320;
y = G__7321;
more = G__7322;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT__EQ_.cljs$lang$applyTo = (function (seq7314){
var G__7315 = cljs.core.first(seq7314);
var seq7314__$1 = cljs.core.next(seq7314);
var G__7316 = cljs.core.first(seq7314__$1);
var seq7314__$2 = cljs.core.next(seq7314__$1);
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__7315,G__7316,seq7314__$2);
});

cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2);
/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(){
var G__7327 = arguments.length;
switch (G__7327) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__4237__auto__ = x;
var y__4238__auto__ = y;
return ((x__4237__auto__ > y__4238__auto__) ? x__4237__auto__ : y__4238__auto__);
});

cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__4237__auto__ = x;
var y__4238__auto__ = y;
return ((x__4237__auto__ > y__4238__auto__) ? x__4237__auto__ : y__4238__auto__);
})(),more);
});

cljs.core.max.cljs$lang$applyTo = (function (seq7323){
var G__7324 = cljs.core.first(seq7323);
var seq7323__$1 = cljs.core.next(seq7323);
var G__7325 = cljs.core.first(seq7323__$1);
var seq7323__$2 = cljs.core.next(seq7323__$1);
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__7324,G__7325,seq7323__$2);
});

cljs.core.max.cljs$lang$maxFixedArity = (2);
/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(){
var G__7333 = arguments.length;
switch (G__7333) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__4244__auto__ = x;
var y__4245__auto__ = y;
return ((x__4244__auto__ < y__4245__auto__) ? x__4244__auto__ : y__4245__auto__);
});

cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__4244__auto__ = x;
var y__4245__auto__ = y;
return ((x__4244__auto__ < y__4245__auto__) ? x__4244__auto__ : y__4245__auto__);
})(),more);
});

cljs.core.min.cljs$lang$applyTo = (function (seq7329){
var G__7330 = cljs.core.first(seq7329);
var seq7329__$1 = cljs.core.next(seq7329);
var G__7331 = cljs.core.first(seq7329__$1);
var seq7329__$2 = cljs.core.next(seq7329__$1);
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__7330,G__7331,seq7329__$2);
});

cljs.core.min.cljs$lang$maxFixedArity = (2);
cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if((typeof x === 'string') && ((x.length === (1)))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(){
var G__7339 = arguments.length;
switch (G__7339) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
});

cljs.core.unchecked_add.cljs$lang$applyTo = (function (seq7335){
var G__7336 = cljs.core.first(seq7335);
var seq7335__$1 = cljs.core.next(seq7335);
var G__7337 = cljs.core.first(seq7335__$1);
var seq7335__$2 = cljs.core.next(seq7335__$1);
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__7336,G__7337,seq7335__$2);
});

cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2);
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(){
var G__7345 = arguments.length;
switch (G__7345) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
});

cljs.core.unchecked_add_int.cljs$lang$applyTo = (function (seq7341){
var G__7342 = cljs.core.first(seq7341);
var seq7341__$1 = cljs.core.next(seq7341);
var G__7343 = cljs.core.first(seq7341__$1);
var seq7341__$2 = cljs.core.next(seq7341__$1);
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__7342,G__7343,seq7341__$2);
});

cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2);
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 * else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(){
var G__7351 = arguments.length;
switch (G__7351) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
});

cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function (seq7347){
var G__7348 = cljs.core.first(seq7347);
var seq7347__$1 = cljs.core.next(seq7347);
var G__7349 = cljs.core.first(seq7347__$1);
var seq7347__$2 = cljs.core.next(seq7347__$1);
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__7348,G__7349,seq7347__$2);
});

cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2);
cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(){
var G__7357 = arguments.length;
switch (G__7357) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
});

cljs.core.unchecked_multiply.cljs$lang$applyTo = (function (seq7353){
var G__7354 = cljs.core.first(seq7353);
var seq7353__$1 = cljs.core.next(seq7353);
var G__7355 = cljs.core.first(seq7353__$1);
var seq7353__$2 = cljs.core.next(seq7353__$1);
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__7354,G__7355,seq7353__$2);
});

cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2);
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(){
var G__7363 = arguments.length;
switch (G__7363) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
});

cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function (seq7359){
var G__7360 = cljs.core.first(seq7359);
var seq7359__$1 = cljs.core.next(seq7359);
var G__7361 = cljs.core.first(seq7359__$1);
var seq7359__$2 = cljs.core.next(seq7359__$1);
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__7360,G__7361,seq7359__$2);
});

cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2);
cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
var G__7367 = x;
var G__7368 = n;
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(G__7367,G__7368) : cljs.core.mod.call(null,G__7367,G__7368));
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(){
var G__7373 = arguments.length;
switch (G__7373) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
});

cljs.core.unchecked_subtract.cljs$lang$applyTo = (function (seq7369){
var G__7370 = cljs.core.first(seq7369);
var seq7369__$1 = cljs.core.next(seq7369);
var G__7371 = cljs.core.first(seq7369__$1);
var seq7369__$2 = cljs.core.next(seq7369__$1);
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__7370,G__7371,seq7369__$2);
});

cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2);
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(){
var G__7379 = arguments.length;
switch (G__7379) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
});

cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function (seq7375){
var G__7376 = cljs.core.first(seq7375);
var seq7375__$1 = cljs.core.next(seq7375);
var G__7377 = cljs.core.first(seq7375__$1);
var seq7375__$2 = cljs.core.next(seq7375__$1);
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__7376,G__7377,seq7375__$2);
});

cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2);
cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
var G__7383 = q;
return Math.floor(G__7383);
} else {
var G__7384 = q;
return Math.ceil(G__7384);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(){
var G__7389 = arguments.length;
switch (G__7389) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x ^ y);
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
});

cljs.core.bit_xor.cljs$lang$applyTo = (function (seq7385){
var G__7386 = cljs.core.first(seq7385);
var seq7385__$1 = cljs.core.next(seq7385);
var G__7387 = cljs.core.first(seq7385__$1);
var seq7385__$2 = cljs.core.next(seq7385__$1);
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__7386,G__7387,seq7385__$2);
});

cljs.core.bit_xor.cljs$lang$maxFixedArity = (2);
/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(){
var G__7395 = arguments.length;
switch (G__7395) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & y);
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
});

cljs.core.bit_and.cljs$lang$applyTo = (function (seq7391){
var G__7392 = cljs.core.first(seq7391);
var seq7391__$1 = cljs.core.next(seq7391);
var G__7393 = cljs.core.first(seq7391__$1);
var seq7391__$2 = cljs.core.next(seq7391__$1);
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__7392,G__7393,seq7391__$2);
});

cljs.core.bit_and.cljs$lang$maxFixedArity = (2);
/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(){
var G__7401 = arguments.length;
switch (G__7401) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x | y);
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
});

cljs.core.bit_or.cljs$lang$applyTo = (function (seq7397){
var G__7398 = cljs.core.first(seq7397);
var seq7397__$1 = cljs.core.next(seq7397);
var G__7399 = cljs.core.first(seq7397__$1);
var seq7397__$2 = cljs.core.next(seq7397__$1);
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__7398,G__7399,seq7397__$2);
});

cljs.core.bit_or.cljs$lang$maxFixedArity = (2);
/**
 * Bitwise and
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(){
var G__7407 = arguments.length;
switch (G__7407) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & ~y);
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
});

cljs.core.bit_and_not.cljs$lang$applyTo = (function (seq7403){
var G__7404 = cljs.core.first(seq7403);
var seq7403__$1 = cljs.core.next(seq7403);
var G__7405 = cljs.core.first(seq7403__$1);
var seq7403__$2 = cljs.core.next(seq7403__$1);
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__7404,G__7405,seq7403__$2);
});

cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2);
/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 * value, otherwise false. Behavior on non nums is
 * undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(){
var G__7413 = arguments.length;
switch (G__7413) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return cljs.core._equiv(x,y);
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__7415 = y;
var G__7416 = cljs.core.first(more);
var G__7417 = cljs.core.next(more);
x = G__7415;
y = G__7416;
more = G__7417;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ__EQ_.cljs$lang$applyTo = (function (seq7409){
var G__7410 = cljs.core.first(seq7409);
var seq7409__$1 = cljs.core.next(seq7409);
var G__7411 = cljs.core.first(seq7409__$1);
var seq7409__$2 = cljs.core.next(seq7409__$1);
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__7410,G__7411,seq7409__$2);
});

cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2);
/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(n){
return (n > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(n){
return (n === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if((xs) && ((n__$1 > (0)))){
var G__7418 = (n__$1 - (1));
var G__7419 = cljs.core.next(xs);
n__$1 = G__7418;
xs = G__7419;
continue;
} else {
return xs;
}
break;
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 * x.toString().  (str nil) returns the empty string. With more than
 * one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(){
var G__7423 = arguments.length;
switch (G__7423) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0)));
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4976__auto__);

}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function (){
return "";
});

cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function (x){
if((x == null)){
return "";
} else {
var G__7424 = x;
return goog.string.buildString(G__7424);
}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function (x,ys){
var sb = (new goog.string.StringBuffer([cljs.core.str(x)].join('')));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__7426 = sb.append([cljs.core.str(cljs.core.first(more))].join(''));
var G__7427 = cljs.core.next(more);
sb = G__7426;
more = G__7427;
continue;
} else {
return sb.toString();
}
break;
}
});

cljs.core.str.cljs$lang$applyTo = (function (seq7420){
var G__7421 = cljs.core.first(seq7420);
var seq7420__$1 = cljs.core.next(seq7420);
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__7421,seq7420__$1);
});

cljs.core.str.cljs$lang$maxFixedArity = (1);
/**
 * Returns the substring of s beginning at start inclusive, and ending
 * at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(){
var G__7429 = arguments.length;
switch (G__7429) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function (s,start){
return s.substring(start);
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function (s,start,end){
return s.substring(start,end);
});

cljs.core.subs.cljs$lang$maxFixedArity = 3;

/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 * returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?(((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && (!((cljs.core.count(x) === cljs.core.count(y)))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__7431 = cljs.core.next(xs);
var G__7432 = cljs.core.next(ys);
xs = G__7431;
ys = G__7432;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__7433 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__7434 = cljs.core.next(s);
res = G__7433;
s = G__7434;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__7439 = ((h + (cljs.core.hash((function (){var G__7437 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__7437) : cljs.core.key.call(null,G__7437));
})()) ^ cljs.core.hash((function (){var G__7438 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__7438) : cljs.core.val.call(null,G__7438));
})()))) % (4503599627370496));
var G__7440 = cljs.core.next(s);
h = G__7439;
s = G__7440;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__7441 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__7442 = cljs.core.next(s__$1);
h = G__7441;
s__$1 = G__7442;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 * attaches said functions as methods on the object.  Any references to
 * JavaScript's implicit this (via the this-as macro) will resolve to the
 * object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__7453_7463 = cljs.core.seq(fn_map);
var chunk__7454_7464 = null;
var count__7455_7465 = (0);
var i__7456_7466 = (0);
while(true){
if((i__7456_7466 < count__7455_7465)){
var vec__7457_7467 = chunk__7454_7464.cljs$core$IIndexed$_nth$arity$2(null,i__7456_7466);
var key_name_7468 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7457_7467,(0),null);
var f_7469 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7457_7467,(1),null);
var str_name_7470 = (function (){var G__7458 = key_name_7468;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__7458) : cljs.core.name.call(null,G__7458));
})();
(obj[str_name_7470] = f_7469);

var G__7471 = seq__7453_7463;
var G__7472 = chunk__7454_7464;
var G__7473 = count__7455_7465;
var G__7474 = (i__7456_7466 + (1));
seq__7453_7463 = G__7471;
chunk__7454_7464 = G__7472;
count__7455_7465 = G__7473;
i__7456_7466 = G__7474;
continue;
} else {
var temp__4423__auto___7475 = cljs.core.seq(seq__7453_7463);
if(temp__4423__auto___7475){
var seq__7453_7476__$1 = temp__4423__auto___7475;
if(cljs.core.chunked_seq_QMARK_(seq__7453_7476__$1)){
var c__4710__auto___7477 = (function (){var G__7459 = seq__7453_7476__$1;
return (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(G__7459) : cljs.core.chunk_first.call(null,G__7459));
})();
var G__7478 = (function (){var G__7460 = seq__7453_7476__$1;
return (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(G__7460) : cljs.core.chunk_rest.call(null,G__7460));
})();
var G__7479 = c__4710__auto___7477;
var G__7480 = cljs.core.count(c__4710__auto___7477);
var G__7481 = (0);
seq__7453_7463 = G__7478;
chunk__7454_7464 = G__7479;
count__7455_7465 = G__7480;
i__7456_7466 = G__7481;
continue;
} else {
var vec__7461_7482 = cljs.core.first(seq__7453_7476__$1);
var key_name_7483 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7461_7482,(0),null);
var f_7484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7461_7482,(1),null);
var str_name_7485 = (function (){var G__7462 = key_name_7483;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__7462) : cljs.core.name.call(null,G__7462));
})();
(obj[str_name_7485] = f_7484);

var G__7486 = cljs.core.next(seq__7453_7476__$1);
var G__7487 = null;
var G__7488 = (0);
var G__7489 = (0);
seq__7453_7463 = G__7486;
chunk__7454_7464 = G__7487;
count__7455_7465 = G__7488;
i__7456_7466 = G__7489;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest(coll__$1);
});

cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
});

cljs.core.List.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.List.cljs$lang$type = true;

cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";

cljs.core.List.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/List");
});

cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));

/**
* @constructor
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
});

cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
});

cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
});

cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.EmptyList(meta__$1));
});

cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
});

cljs.core.EmptyList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
});

cljs.core.EmptyList.cljs$lang$type = true;

cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";

cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/EmptyList");
});

cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
var G__7491 = coll;
if(G__7491){
var bit__4599__auto__ = (G__7491.cljs$lang$protocol_mask$partition0$ & (134217728));
if((bit__4599__auto__) || (G__7491.cljs$core$IReversible$)){
return true;
} else {
if((!G__7491.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__7491);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__7491);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 * can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(coll){
return cljs.core._rseq(coll);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
return cljs.core.rseq(coll);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var arr = ((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if(!((xs__$1 == null))){
arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));

var G__7493 = xs__$1.cljs$core$INext$_next$arity$1(null);
xs__$1 = G__7493;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__7494 = (i - (1));
var G__7495 = r.cljs$core$ICollection$_conj$arity$2(null,(arr[(i - (1))]));
i = G__7494;
r = G__7495;
continue;
} else {
return r;
}
break;
}
});

cljs.core.list.cljs$lang$maxFixedArity = (0);

cljs.core.list.cljs$lang$applyTo = (function (seq7492){
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq7492));
});

/**
* @constructor
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
});

cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,self__.__hash));
});

cljs.core.Cons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.Cons.cljs$lang$type = true;

cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";

cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/Cons");
});

cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
/**
 * Returns a new seq where x is the first element and seq is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((function (){var or__3925__auto__ = (coll == null);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var G__7499 = coll;
if(G__7499){
var bit__4592__auto__ = (G__7499.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4592__auto__) || (G__7499.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));
}
});
/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
var G__7501 = x;
if(G__7501){
var bit__4599__auto__ = (G__7501.cljs$lang$protocol_mask$partition0$ & (33554432));
if((bit__4599__auto__) || (G__7501.cljs$core$IList$)){
return true;
} else {
if((!G__7501.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__7501);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__7501);
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__3913__auto__ = cljs.core.not(a.ns);
if(and__3913__auto__){
return b.ns;
} else {
return and__3913__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__7508 = a.ns;
var G__7509 = b.ns;
return goog.array.defaultCompare(G__7508,G__7509);
})();
if(((0) === nsc)){
var G__7510 = a.name;
var G__7511 = b.name;
return goog.array.defaultCompare(G__7510,G__7511);
} else {
return nsc;
}
}
} else {
var G__7512 = a.name;
var G__7513 = b.name;
return goog.array.defaultCompare(G__7512,G__7513);

}
}
}
});

/**
* @constructor
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str(":"),cljs.core.str(self__.fqn)].join('');
});

cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
});

cljs.core.Keyword.prototype.call = (function() {
var G__7515 = null;
var G__7515__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__7515__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__7515 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__7515__2.call(this,self__,coll);
case 3:
return G__7515__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7515.cljs$core$IFn$_invoke$arity$2 = G__7515__2;
G__7515.cljs$core$IFn$_invoke$arity$3 = G__7515__3;
return G__7515;
})()
;

cljs.core.Keyword.prototype.apply = (function (self__,args7514){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args7514)));
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});

cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4341__auto__ = self__._hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_keyword(this$__$1);
self__._hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[cljs.core.str(":"),cljs.core.str(self__.fqn)].join(''));
});

cljs.core.Keyword.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"fqn","fqn",-1749334463,null),new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null)], null);
});

cljs.core.Keyword.cljs$lang$type = true;

cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";

cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/Keyword");
});

cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((function (){var G__7517 = x;
if(G__7517){
var bit__4592__auto__ = (G__7517.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4592__auto__) || (G__7517.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error([cljs.core.str("Doesn't support namespace: "),cljs.core.str(x)].join('')));
}
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 * in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(){
var G__7519 = arguments.length;
switch (G__7519) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(function (){var G__7520 = name;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__7520) : cljs.core.name.call(null,G__7520));
})(),name.str,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
return (new cljs.core.Keyword(ns,name,[cljs.core.str((cljs.core.truth_(ns)?[cljs.core.str(ns),cljs.core.str("/")].join(''):null)),cljs.core.str(name)].join(''),null));
});

cljs.core.keyword.cljs$lang$maxFixedArity = 2;

/**
* @constructor
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
self__.s = (function (){return (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));
})();

self__.fn = null;

return self__.s;
}
});

cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if(!((self__.s == null))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__7522 = ls.sval();
ls = G__7522;
continue;
} else {
self__.s = ls;

return cljs.core.seq(self__.s);
}
break;
}
}
});

cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.LazySeq(meta__$1,self__.fn,self__.s,self__.__hash));
});

cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.LazySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"fn","fn",465265323,null),new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.LazySeq.cljs$lang$type = true;

cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";

cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/LazySeq");
});

cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));

/**
* @constructor
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return self__.end = (self__.end + (1));
});

cljs.core.ChunkBuffer.prototype.chunk = (function (o){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
self__.buf = null;

return ret;
});

cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
});

cljs.core.ChunkBuffer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"buf","buf",1426618187,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
});

cljs.core.ChunkBuffer.cljs$lang$type = true;

cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";

cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/ChunkBuffer");
});

cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if(((i >= (0))) && ((i < (self__.end - self__.off)))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
});

cljs.core.ArrayChunk.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
});

cljs.core.ArrayChunk.cljs$lang$type = true;

cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";

cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/ArrayChunk");
});

cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(){
var G__7524 = arguments.length;
switch (G__7524) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;

/**
* @constructor
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
var more__$1 = cljs.core._seq(self__.more);
if((more__$1 == null)){
return null;
} else {
return more__$1;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash));
});

cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"chunk","chunk",449371907,null),new cljs.core.Symbol(null,"more","more",-418290273,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.ChunkedCons.cljs$lang$type = true;

cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";

cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/ChunkedCons");
});

cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((function (){var G__7527 = s;
if(G__7527){
var bit__4592__auto__ = (G__7527.cljs$lang$protocol_mask$partition1$ & (1024));
if((bit__4592__auto__) || (G__7527.cljs$core$IChunkedNext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core._chunked_next(s);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Naive impl of to-array as a start.
 */
cljs.core.to_array = (function cljs$core$to_array(s){
var ary = [];
var s__$1 = s;
while(true){
if(cljs.core.seq(s__$1)){
ary.push(cljs.core.first(s__$1));

var G__7528 = cljs.core.next(s__$1);
s__$1 = G__7528;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 * containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_7529 = (0);
var xs_7530 = cljs.core.seq(coll);
while(true){
if(xs_7530){
(ret[i_7529] = cljs.core.to_array(cljs.core.first(xs_7530)));

var G__7531 = (i_7529 + (1));
var G__7532 = cljs.core.next(xs_7530);
i_7529 = G__7531;
xs_7530 = G__7532;
continue;
} else {
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(){
var G__7534 = arguments.length;
switch (G__7534) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__7536 = (i + (1));
var G__7537 = cljs.core.next(s__$1);
i = G__7536;
s__$1 = G__7537;
continue;
} else {
return a;
}
break;
}
} else {
var n__4810__auto___7538 = size;
var i_7539 = (0);
while(true){
if((i_7539 < n__4810__auto___7538)){
(a[i_7539] = init_val_or_seq);

var G__7540 = (i_7539 + (1));
i_7539 = G__7540;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.int_array.cljs$lang$maxFixedArity = 2;
/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(){
var G__7542 = arguments.length;
switch (G__7542) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__7544 = (i + (1));
var G__7545 = cljs.core.next(s__$1);
i = G__7544;
s__$1 = G__7545;
continue;
} else {
return a;
}
break;
}
} else {
var n__4810__auto___7546 = size;
var i_7547 = (0);
while(true){
if((i_7547 < n__4810__auto___7546)){
(a[i_7547] = init_val_or_seq);

var G__7548 = (i_7547 + (1));
i_7547 = G__7548;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.long_array.cljs$lang$maxFixedArity = 2;
/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(){
var G__7550 = arguments.length;
switch (G__7550) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__7552 = (i + (1));
var G__7553 = cljs.core.next(s__$1);
i = G__7552;
s__$1 = G__7553;
continue;
} else {
return a;
}
break;
}
} else {
var n__4810__auto___7554 = size;
var i_7555 = (0);
while(true){
if((i_7555 < n__4810__auto___7554)){
(a[i_7555] = init_val_or_seq);

var G__7556 = (i_7555 + (1));
i_7555 = G__7556;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.double_array.cljs$lang$maxFixedArity = 2;
/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(){
var G__7558 = arguments.length;
switch (G__7558) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__7560 = (i + (1));
var G__7561 = cljs.core.next(s__$1);
i = G__7560;
s__$1 = G__7561;
continue;
} else {
return a;
}
break;
}
} else {
var n__4810__auto___7562 = size;
var i_7563 = (0);
while(true){
if((i_7563 < n__4810__auto___7562)){
(a[i_7563] = init_val_or_seq);

var G__7564 = (i_7563 + (1));
i_7563 = G__7564;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.object_array.cljs$lang$maxFixedArity = 2;
cljs.core.bounded_count = (function cljs$core$bounded_count(s,n){
if(cljs.core.counted_QMARK_(s)){
return cljs.core.count(s);
} else {
var s__$1 = s;
var i = n;
var sum = (0);
while(true){
if(((i > (0))) && (cljs.core.seq(s__$1))){
var G__7565 = cljs.core.next(s__$1);
var G__7566 = (i - (1));
var G__7567 = (sum + (1));
s__$1 = G__7565;
i = G__7566;
sum = G__7567;
continue;
} else {
return sum;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
if((cljs.core.next(arglist) == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),cljs$core$spread(cljs.core.next(arglist)));

}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(){
var G__7573 = arguments.length;
switch (G__7573) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,zs){
var cat = (function cljs$core$cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
});

cljs.core.concat.cljs$lang$applyTo = (function (seq7569){
var G__7570 = cljs.core.first(seq7569);
var seq7569__$1 = cljs.core.next(seq7569);
var G__7571 = cljs.core.first(seq7569__$1);
var seq7569__$2 = cljs.core.next(seq7569__$1);
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__7570,G__7571,seq7569__$2);
});

cljs.core.concat.cljs$lang$maxFixedArity = (2);
/**
 * Creates a new list containing the items prepended to the rest, the
 * last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(){
var G__7587 = arguments.length;
switch (G__7587) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(4)),(0)));
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4976__auto__);

}
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (args){
return cljs.core.seq(args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (a,args){
return cljs.core.cons(a,args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
});

cljs.core.list_STAR_.cljs$lang$applyTo = (function (seq7581){
var G__7582 = cljs.core.first(seq7581);
var seq7581__$1 = cljs.core.next(seq7581);
var G__7583 = cljs.core.first(seq7581__$1);
var seq7581__$2 = cljs.core.next(seq7581__$1);
var G__7584 = cljs.core.first(seq7581__$2);
var seq7581__$3 = cljs.core.next(seq7581__$2);
var G__7585 = cljs.core.first(seq7581__$3);
var seq7581__$4 = cljs.core.next(seq7581__$3);
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__7582,G__7583,G__7584,G__7585,seq7581__$4);
});

cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4);
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 * constant time. The transient collection cannot be used after this
 * call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds x to the transient collection, and return coll. The 'addition'
 * may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(){
var G__7593 = arguments.length;
switch (G__7593) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__7595 = ntcoll;
var G__7596 = cljs.core.first(vals);
var G__7597 = cljs.core.next(vals);
tcoll = G__7595;
val = G__7596;
vals = G__7597;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.conj_BANG_.cljs$lang$applyTo = (function (seq7589){
var G__7590 = cljs.core.first(seq7589);
var seq7589__$1 = cljs.core.next(seq7589);
var G__7591 = cljs.core.first(seq7589__$1);
var seq7589__$2 = cljs.core.next(seq7589__$1);
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__7590,G__7591,seq7589__$2);
});

cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2);
/**
 * When applied to a transient map, adds mapping of key(s) to
 * val(s). When applied to a transient vector, sets the val at index.
 * Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(){
var G__7603 = arguments.length;
switch (G__7603) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0)));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4976__auto__);

}
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__7605 = ntcoll;
var G__7606 = cljs.core.first(kvs);
var G__7607 = cljs.core.second(kvs);
var G__7608 = cljs.core.nnext(kvs);
tcoll = G__7605;
key = G__7606;
val = G__7607;
kvs = G__7608;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.assoc_BANG_.cljs$lang$applyTo = (function (seq7598){
var G__7599 = cljs.core.first(seq7598);
var seq7598__$1 = cljs.core.next(seq7598);
var G__7600 = cljs.core.first(seq7598__$1);
var seq7598__$2 = cljs.core.next(seq7598__$1);
var G__7601 = cljs.core.first(seq7598__$2);
var seq7598__$3 = cljs.core.next(seq7598__$2);
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__7599,G__7600,G__7601,seq7598__$3);
});

cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3);
/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(){
var G__7613 = arguments.length;
switch (G__7613) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__7615 = ntcoll;
var G__7616 = cljs.core.first(ks);
var G__7617 = cljs.core.next(ks);
tcoll = G__7615;
key = G__7616;
ks = G__7617;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function (seq7609){
var G__7610 = cljs.core.first(seq7609);
var seq7609__$1 = cljs.core.next(seq7609);
var G__7611 = cljs.core.first(seq7609__$1);
var seq7609__$2 = cljs.core.next(seq7609__$1);
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__7610,G__7611,seq7609__$2);
});

cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2);
/**
 * Removes the last item from a transient vector. If
 * the collection is empty, throws an exception. Returns coll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 * does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(){
var G__7622 = arguments.length;
switch (G__7622) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__7624 = ntcoll;
var G__7625 = cljs.core.first(vals);
var G__7626 = cljs.core.next(vals);
tcoll = G__7624;
val = G__7625;
vals = G__7626;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.disj_BANG_.cljs$lang$applyTo = (function (seq7618){
var G__7619 = cljs.core.first(seq7618);
var seq7618__$1 = cljs.core.next(seq7618);
var G__7620 = cljs.core.first(seq7618__$1);
var seq7618__$2 = cljs.core.next(seq7618__$1);
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__7619,G__7620,seq7618__$2);
});

cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2);

cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a4854 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a4854);
} else {
var G__7837 = a4854;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7837) : f.call(null,G__7837));
}
} else {
var b4855 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a4854,b4855);
} else {
var G__7838 = a4854;
var G__7839 = b4855;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7838,G__7839) : f.call(null,G__7838,G__7839));
}
} else {
var c4856 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a4854,b4855,c4856);
} else {
var G__7840 = a4854;
var G__7841 = b4855;
var G__7842 = c4856;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7840,G__7841,G__7842) : f.call(null,G__7840,G__7841,G__7842));
}
} else {
var d4857 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a4854,b4855,c4856,d4857);
} else {
var G__7843 = a4854;
var G__7844 = b4855;
var G__7845 = c4856;
var G__7846 = d4857;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7843,G__7844,G__7845,G__7846) : f.call(null,G__7843,G__7844,G__7845,G__7846));
}
} else {
var e4858 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a4854,b4855,c4856,d4857,e4858);
} else {
var G__7847 = a4854;
var G__7848 = b4855;
var G__7849 = c4856;
var G__7850 = d4857;
var G__7851 = e4858;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__7847,G__7848,G__7849,G__7850,G__7851) : f.call(null,G__7847,G__7848,G__7849,G__7850,G__7851));
}
} else {
var f4859 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a4854,b4855,c4856,d4857,e4858,f4859);
} else {
var G__7852 = a4854;
var G__7853 = b4855;
var G__7854 = c4856;
var G__7855 = d4857;
var G__7856 = e4858;
var G__7857 = f4859;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__7852,G__7853,G__7854,G__7855,G__7856,G__7857) : f.call(null,G__7852,G__7853,G__7854,G__7855,G__7856,G__7857));
}
} else {
var g4860 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a4854,b4855,c4856,d4857,e4858,f4859,g4860);
} else {
var G__7858 = a4854;
var G__7859 = b4855;
var G__7860 = c4856;
var G__7861 = d4857;
var G__7862 = e4858;
var G__7863 = f4859;
var G__7864 = g4860;
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(G__7858,G__7859,G__7860,G__7861,G__7862,G__7863,G__7864) : f.call(null,G__7858,G__7859,G__7860,G__7861,G__7862,G__7863,G__7864));
}
} else {
var h4861 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a4854,b4855,c4856,d4857,e4858,f4859,g4860,h4861);
} else {
var G__7865 = a4854;
var G__7866 = b4855;
var G__7867 = c4856;
var G__7868 = d4857;
var G__7869 = e4858;
var G__7870 = f4859;
var G__7871 = g4860;
var G__7872 = h4861;
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(G__7865,G__7866,G__7867,G__7868,G__7869,G__7870,G__7871,G__7872) : f.call(null,G__7865,G__7866,G__7867,G__7868,G__7869,G__7870,G__7871,G__7872));
}
} else {
var i4862 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a4854,b4855,c4856,d4857,e4858,f4859,g4860,h4861,i4862);
} else {
var G__7873 = a4854;
var G__7874 = b4855;
var G__7875 = c4856;
var G__7876 = d4857;
var G__7877 = e4858;
var G__7878 = f4859;
var G__7879 = g4860;
var G__7880 = h4861;
var G__7881 = i4862;
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(G__7873,G__7874,G__7875,G__7876,G__7877,G__7878,G__7879,G__7880,G__7881) : f.call(null,G__7873,G__7874,G__7875,G__7876,G__7877,G__7878,G__7879,G__7880,G__7881));
}
} else {
var j4863 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a4854,b4855,c4856,d4857,e4858,f4859,g4860,h4861,i4862,j4863);
} else {
var G__7882 = a4854;
var G__7883 = b4855;
var G__7884 = c4856;
var G__7885 = d4857;
var G__7886 = e4858;
var G__7887 = f4859;
var G__7888 = g4860;
var G__7889 = h4861;
var G__7890 = i4862;
var G__7891 = j4863;
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(G__7882,G__7883,G__7884,G__7885,G__7886,G__7887,G__7888,G__7889,G__7890,G__7891) : f.call(null,G__7882,G__7883,G__7884,G__7885,G__7886,G__7887,G__7888,G__7889,G__7890,G__7891));
}
} else {
var k4864 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a4854,b4855,c4856,d4857,e4858,f4859,g4860,h4861,i4862,j4863,k4864);
} else {
var G__7892 = a4854;
var G__7893 = b4855;
var G__7894 = c4856;
var G__7895 = d4857;
var G__7896 = e4858;
var G__7897 = f4859;
var G__7898 = g4860;
var G__7899 = h4861;
var G__7900 = i4862;
var G__7901 = j4863;
var G__7902 = k4864;
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(G__7892,G__7893,G__7894,G__7895,G__7896,G__7897,G__7898,G__7899,G__7900,G__7901,G__7902) : f.call(null,G__7892,G__7893,G__7894,G__7895,G__7896,G__7897,G__7898,G__7899,G__7900,G__7901,G__7902));
}
} else {
var l4865 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a4854,b4855,c4856,d4857,e4858,f4859,g4860,h4861,i4862,j4863,k4864,l4865);
} else {
var G__7903 = a4854;
var G__7904 = b4855;
var G__7905 = c4856;
var G__7906 = d4857;
var G__7907 = e4858;
var G__7908 = f4859;
var G__7909 = g4860;
var G__7910 = h4861;
var G__7911 = i4862;
var G__7912 = j4863;
var G__7913 = k4864;
var G__7914 = l4865;
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(G__7903,G__7904,G__7905,G__7906,G__7907,G__7908,G__7909,G__7910,G__7911,G__7912,G__7913,G__7914) : f.call(null,G__7903,G__7904,G__7905,G__7906,G__7907,G__7908,G__7909,G__7910,G__7911,G__7912,G__7913,G__7914));
}
} else {
var m4866 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a4854,b4855,c4856,d4857,e4858,f4859,g4860,h4861,i4862,j4863,k4864,l4865,m4866);
} else {
var G__7915 = a4854;
var G__7916 = b4855;
var G__7917 = c4856;
var G__7918 = d4857;
var G__7919 = e4858;
var G__7920 = f4859;
var G__7921 = g4860;
var G__7922 = h4861;
var G__7923 = i4862;
var G__7924 = j4863;
var G__7925 = k4864;
var G__7926 = l4865;
var G__7927 = m4866;
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(G__7915,G__7916,G__7917,G__7918,G__7919,G__7920,G__7921,G__7922,G__7923,G__7924,G__7925,G__7926,G__7927) : f.call(null,G__7915,G__7916,G__7917,G__7918,G__7919,G__7920,G__7921,G__7922,G__7923,G__7924,G__7925,G__7926,G__7927));
}
} else {
var n4867 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a4854,b4855,c4856,d4857,e4858,f4859,g4860,h4861,i4862,j4863,k4864,l4865,m4866,n4867);
} else {
var G__7928 = a4854;
var G__7929 = b4855;
var G__7930 = c4856;
var G__7931 = d4857;
var G__7932 = e4858;
var G__7933 = f4859;
var G__7934 = g4860;
var G__7935 = h4861;
var G__7936 = i4862;
var G__7937 = j4863;
var G__7938 = k4864;
var G__7939 = l4865;
var G__7940 = m4866;
var G__7941 = n4867;
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(G__7928,G__7929,G__7930,G__7931,G__7932,G__7933,G__7934,G__7935,G__7936,G__7937,G__7938,G__7939,G__7940,G__7941) : f.call(null,G__7928,G__7929,G__7930,G__7931,G__7932,G__7933,G__7934,G__7935,G__7936,G__7937,G__7938,G__7939,G__7940,G__7941));
}
} else {
var o4868 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a4854,b4855,c4856,d4857,e4858,f4859,g4860,h4861,i4862,j4863,k4864,l4865,m4866,n4867,o4868);
} else {
var G__7942 = a4854;
var G__7943 = b4855;
var G__7944 = c4856;
var G__7945 = d4857;
var G__7946 = e4858;
var G__7947 = f4859;
var G__7948 = g4860;
var G__7949 = h4861;
var G__7950 = i4862;
var G__7951 = j4863;
var G__7952 = k4864;
var G__7953 = l4865;
var G__7954 = m4866;
var G__7955 = n4867;
var G__7956 = o4868;
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(G__7942,G__7943,G__7944,G__7945,G__7946,G__7947,G__7948,G__7949,G__7950,G__7951,G__7952,G__7953,G__7954,G__7955,G__7956) : f.call(null,G__7942,G__7943,G__7944,G__7945,G__7946,G__7947,G__7948,G__7949,G__7950,G__7951,G__7952,G__7953,G__7954,G__7955,G__7956));
}
} else {
var p4869 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a4854,b4855,c4856,d4857,e4858,f4859,g4860,h4861,i4862,j4863,k4864,l4865,m4866,n4867,o4868,p4869);
} else {
var G__7957 = a4854;
var G__7958 = b4855;
var G__7959 = c4856;
var G__7960 = d4857;
var G__7961 = e4858;
var G__7962 = f4859;
var G__7963 = g4860;
var G__7964 = h4861;
var G__7965 = i4862;
var G__7966 = j4863;
var G__7967 = k4864;
var G__7968 = l4865;
var G__7969 = m4866;
var G__7970 = n4867;
var G__7971 = o4868;
var G__7972 = p4869;
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(G__7957,G__7958,G__7959,G__7960,G__7961,G__7962,G__7963,G__7964,G__7965,G__7966,G__7967,G__7968,G__7969,G__7970,G__7971,G__7972) : f.call(null,G__7957,G__7958,G__7959,G__7960,G__7961,G__7962,G__7963,G__7964,G__7965,G__7966,G__7967,G__7968,G__7969,G__7970,G__7971,G__7972));
}
} else {
var q4870 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a4854,b4855,c4856,d4857,e4858,f4859,g4860,h4861,i4862,j4863,k4864,l4865,m4866,n4867,o4868,p4869,q4870);
} else {
var G__7973 = a4854;
var G__7974 = b4855;
var G__7975 = c4856;
var G__7976 = d4857;
var G__7977 = e4858;
var G__7978 = f4859;
var G__7979 = g4860;
var G__7980 = h4861;
var G__7981 = i4862;
var G__7982 = j4863;
var G__7983 = k4864;
var G__7984 = l4865;
var G__7985 = m4866;
var G__7986 = n4867;
var G__7987 = o4868;
var G__7988 = p4869;
var G__7989 = q4870;
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(G__7973,G__7974,G__7975,G__7976,G__7977,G__7978,G__7979,G__7980,G__7981,G__7982,G__7983,G__7984,G__7985,G__7986,G__7987,G__7988,G__7989) : f.call(null,G__7973,G__7974,G__7975,G__7976,G__7977,G__7978,G__7979,G__7980,G__7981,G__7982,G__7983,G__7984,G__7985,G__7986,G__7987,G__7988,G__7989));
}
} else {
var r4871 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a4854,b4855,c4856,d4857,e4858,f4859,g4860,h4861,i4862,j4863,k4864,l4865,m4866,n4867,o4868,p4869,q4870,r4871);
} else {
var G__7990 = a4854;
var G__7991 = b4855;
var G__7992 = c4856;
var G__7993 = d4857;
var G__7994 = e4858;
var G__7995 = f4859;
var G__7996 = g4860;
var G__7997 = h4861;
var G__7998 = i4862;
var G__7999 = j4863;
var G__8000 = k4864;
var G__8001 = l4865;
var G__8002 = m4866;
var G__8003 = n4867;
var G__8004 = o4868;
var G__8005 = p4869;
var G__8006 = q4870;
var G__8007 = r4871;
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(G__7990,G__7991,G__7992,G__7993,G__7994,G__7995,G__7996,G__7997,G__7998,G__7999,G__8000,G__8001,G__8002,G__8003,G__8004,G__8005,G__8006,G__8007) : f.call(null,G__7990,G__7991,G__7992,G__7993,G__7994,G__7995,G__7996,G__7997,G__7998,G__7999,G__8000,G__8001,G__8002,G__8003,G__8004,G__8005,G__8006,G__8007));
}
} else {
var s4872 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a4854,b4855,c4856,d4857,e4858,f4859,g4860,h4861,i4862,j4863,k4864,l4865,m4866,n4867,o4868,p4869,q4870,r4871,s4872);
} else {
var G__8008 = a4854;
var G__8009 = b4855;
var G__8010 = c4856;
var G__8011 = d4857;
var G__8012 = e4858;
var G__8013 = f4859;
var G__8014 = g4860;
var G__8015 = h4861;
var G__8016 = i4862;
var G__8017 = j4863;
var G__8018 = k4864;
var G__8019 = l4865;
var G__8020 = m4866;
var G__8021 = n4867;
var G__8022 = o4868;
var G__8023 = p4869;
var G__8024 = q4870;
var G__8025 = r4871;
var G__8026 = s4872;
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(G__8008,G__8009,G__8010,G__8011,G__8012,G__8013,G__8014,G__8015,G__8016,G__8017,G__8018,G__8019,G__8020,G__8021,G__8022,G__8023,G__8024,G__8025,G__8026) : f.call(null,G__8008,G__8009,G__8010,G__8011,G__8012,G__8013,G__8014,G__8015,G__8016,G__8017,G__8018,G__8019,G__8020,G__8021,G__8022,G__8023,G__8024,G__8025,G__8026));
}
} else {
var t4873 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a4854,b4855,c4856,d4857,e4858,f4859,g4860,h4861,i4862,j4863,k4864,l4865,m4866,n4867,o4868,p4869,q4870,r4871,s4872,t4873);
} else {
var G__8027 = a4854;
var G__8028 = b4855;
var G__8029 = c4856;
var G__8030 = d4857;
var G__8031 = e4858;
var G__8032 = f4859;
var G__8033 = g4860;
var G__8034 = h4861;
var G__8035 = i4862;
var G__8036 = j4863;
var G__8037 = k4864;
var G__8038 = l4865;
var G__8039 = m4866;
var G__8040 = n4867;
var G__8041 = o4868;
var G__8042 = p4869;
var G__8043 = q4870;
var G__8044 = r4871;
var G__8045 = s4872;
var G__8046 = t4873;
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(G__8027,G__8028,G__8029,G__8030,G__8031,G__8032,G__8033,G__8034,G__8035,G__8036,G__8037,G__8038,G__8039,G__8040,G__8041,G__8042,G__8043,G__8044,G__8045,G__8046) : f.call(null,G__8027,G__8028,G__8029,G__8030,G__8031,G__8032,G__8033,G__8034,G__8035,G__8036,G__8037,G__8038,G__8039,G__8040,G__8041,G__8042,G__8043,G__8044,G__8045,G__8046));
}
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(){
var G__8054 = arguments.length;
switch (G__8054) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(5)),(0)));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4976__auto__);

}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(args,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return f.apply(f,cljs.core.to_array(args));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function (f,x,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function (f,x,y,z,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function (f,a,b,c,d,args){
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(args)))));
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$lang$applyTo = (function (seq8047){
var G__8048 = cljs.core.first(seq8047);
var seq8047__$1 = cljs.core.next(seq8047);
var G__8049 = cljs.core.first(seq8047__$1);
var seq8047__$2 = cljs.core.next(seq8047__$1);
var G__8050 = cljs.core.first(seq8047__$2);
var seq8047__$3 = cljs.core.next(seq8047__$2);
var G__8051 = cljs.core.first(seq8047__$3);
var seq8047__$4 = cljs.core.next(seq8047__$3);
var G__8052 = cljs.core.first(seq8047__$4);
var seq8047__$5 = cljs.core.next(seq8047__$4);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__8048,G__8049,G__8050,G__8051,G__8052,seq8047__$5);
});

cljs.core.apply.cljs$lang$maxFixedArity = (5);
/**
 * Returns an object of the same type and value as obj, with
 * (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(){
var G__8064 = arguments.length;
switch (G__8064) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(6)),(0)));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__4976__auto__);

}
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__8065 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8065) : f.call(null,G__8065));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__8066 = cljs.core.meta(obj);
var G__8067 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8066,G__8067) : f.call(null,G__8066,G__8067));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__8068 = cljs.core.meta(obj);
var G__8069 = a;
var G__8070 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8068,G__8069,G__8070) : f.call(null,G__8068,G__8069,G__8070));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__8071 = cljs.core.meta(obj);
var G__8072 = a;
var G__8073 = b;
var G__8074 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8071,G__8072,G__8073,G__8074) : f.call(null,G__8071,G__8072,G__8073,G__8074));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__8075 = cljs.core.meta(obj);
var G__8076 = a;
var G__8077 = b;
var G__8078 = c;
var G__8079 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__8075,G__8076,G__8077,G__8078,G__8079) : f.call(null,G__8075,G__8076,G__8077,G__8078,G__8079));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.array_seq([d,args], 0)));
});

cljs.core.vary_meta.cljs$lang$applyTo = (function (seq8056){
var G__8057 = cljs.core.first(seq8056);
var seq8056__$1 = cljs.core.next(seq8056);
var G__8058 = cljs.core.first(seq8056__$1);
var seq8056__$2 = cljs.core.next(seq8056__$1);
var G__8059 = cljs.core.first(seq8056__$2);
var seq8056__$3 = cljs.core.next(seq8056__$2);
var G__8060 = cljs.core.first(seq8056__$3);
var seq8056__$4 = cljs.core.next(seq8056__$3);
var G__8061 = cljs.core.first(seq8056__$4);
var seq8056__$5 = cljs.core.next(seq8056__$4);
var G__8062 = cljs.core.first(seq8056__$5);
var seq8056__$6 = cljs.core.next(seq8056__$5);
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__8057,G__8058,G__8059,G__8060,G__8061,G__8062,seq8056__$6);
});

cljs.core.vary_meta.cljs$lang$maxFixedArity = (6);
/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(){
var G__8085 = arguments.length;
switch (G__8085) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return false;
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
});

cljs.core.not_EQ_.cljs$lang$applyTo = (function (seq8081){
var G__8082 = cljs.core.first(seq8081);
var seq8081__$1 = cljs.core.next(seq8081);
var G__8083 = cljs.core.first(seq8081__$1);
var seq8081__$2 = cljs.core.next(seq8081__$1);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__8082,G__8083,seq8081__$2);
});

cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2);
/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if(typeof cljs.core.t8090 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.t8090 = (function (nil_iter,meta8091){
this.nil_iter = nil_iter;
this.meta8091 = meta8091;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.t8090.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8092,meta8091__$1){
var self__ = this;
var _8092__$1 = this;
return (new cljs.core.t8090(self__.nil_iter,meta8091__$1));
});

cljs.core.t8090.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8092){
var self__ = this;
var _8092__$1 = this;
return self__.meta8091;
});

cljs.core.t8090.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
});

cljs.core.t8090.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
});

cljs.core.t8090.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.t8090.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nil-iter","nil-iter",1101030523,null),new cljs.core.Symbol(null,"meta8091","meta8091",-1138373433,null)], null);
});

cljs.core.t8090.cljs$lang$type = true;

cljs.core.t8090.cljs$lang$ctorStr = "cljs.core/t8090";

cljs.core.t8090.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/t8090");
});

cljs.core.__GT_t8090 = (function cljs$core$nil_iter_$___GT_t8090(nil_iter__$1,meta8091){
return (new cljs.core.t8090(nil_iter__$1,meta8091));
});

}

return (new cljs.core.t8090(cljs$core$nil_iter,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
})
cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
});

cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.StringIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null);
});

cljs.core.StringIter.cljs$lang$type = true;

cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";

cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/StringIter");
});

cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null);
});

cljs.core.ArrayIter.cljs$lang$type = true;

cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";

cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/ArrayIter");
});

cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = {};
cljs.core.START = {};

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
})
cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
self__._seq = cljs.core.START;

self__._next = cljs.core.seq(self__._next);
} else {
if((self__._seq === self__._next)){
self__._next = cljs.core.next(self__._seq);
} else {
}
}

return !((self__._next == null));
});

cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.not(this$.hasNext())){
throw (new Error("No such element"));
} else {
self__._seq = self__._next;

return cljs.core.first(self__._next);
}
});

cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.SeqIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_seq","_seq",-449557847,null),new cljs.core.Symbol(null,"_next","_next",101877036,null)], null);
});

cljs.core.SeqIter.cljs$lang$type = true;

cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";

cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/SeqIter");
});

cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.truth_(cljs.core.iterable_QMARK_(coll))){
return cljs.core._iterator(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error([cljs.core.str("Cannot create iterator from "),cljs.core.str(coll)].join('')));

}
}
}
}
}
});
cljs.core.lazy_transformer = (function cljs$core$lazy_transformer(stepper){
return (new cljs.core.LazyTransformer(stepper,null,null,null));
});

/**
* @constructor
*/
cljs.core.Stepper = (function (xform,iter){
this.xform = xform;
this.iter = iter;
})
cljs.core.Stepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__3913__auto__ = !((lt.stepper == null));
if(and__3913__auto__){
return self__.iter.hasNext();
} else {
return and__3913__auto__;
}
})())){
if(cljs.core.reduced_QMARK_((function (){var G__8093 = lt;
var G__8094 = self__.iter.next();
return (self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__8093,G__8094) : self__.xform.call(null,G__8093,G__8094));
})())){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__8095 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__8095) : self__.xform.call(null,G__8095));
}
});

cljs.core.Stepper.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xform","xform",-85179481,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null)], null);
});

cljs.core.Stepper.cljs$lang$type = true;

cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";

cljs.core.Stepper.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/Stepper");
});

cljs.core.__GT_Stepper = (function cljs$core$__GT_Stepper(xform,iter){
return (new cljs.core.Stepper(xform,iter));
});

cljs.core.stepper = (function cljs$core$stepper(xform,iter){
var stepfn = (function() {
var cljs$core$stepper_$_stepfn = null;
var cljs$core$stepper_$_stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return result;
});
var cljs$core$stepper_$_stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepper_$_stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepper_$_stepfn__1.call(this,result);
case 2:
return cljs$core$stepper_$_stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
return cljs$core$stepper_$_stepfn;
})()
;
return (new cljs.core.Stepper((function (){var G__8097 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__8097) : xform.call(null,G__8097));
})(),iter));
});

/**
* @constructor
*/
cljs.core.MultiStepper = (function (xform,iters,nexts){
this.xform = xform;
this.iters = iters;
this.nexts = nexts;
})
cljs.core.MultiStepper.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if(!((iters__$1 == null))){
var iter = cljs.core.first(iters__$1);
if(cljs.core.not(iter.hasNext())){
return false;
} else {
var G__8099 = cljs.core.next(iters__$1);
iters__$1 = G__8099;
continue;
}
} else {
return true;
}
break;
}
});

cljs.core.MultiStepper.prototype.next = (function (){
var self__ = this;
var _ = this;
var n__4810__auto___8100 = self__.iters.length;
var i_8101 = (0);
while(true){
if((i_8101 < n__4810__auto___8100)){
(self__.nexts[i_8101] = (self__.iters[i_8101]).next());

var G__8102 = (i_8101 + (1));
i_8101 = G__8102;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts,(0));
});

cljs.core.MultiStepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__3913__auto__ = !((lt.stepper == null));
if(and__3913__auto__){
return this$.hasNext();
} else {
return and__3913__auto__;
}
})())){
if(cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform,cljs.core.cons(lt,this$.next())))){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__8098 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__8098) : self__.xform.call(null,G__8098));
}
});

cljs.core.MultiStepper.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xform","xform",-85179481,null),new cljs.core.Symbol(null,"iters","iters",719353031,null),new cljs.core.Symbol(null,"nexts","nexts",-1683579407,null)], null);
});

cljs.core.MultiStepper.cljs$lang$type = true;

cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";

cljs.core.MultiStepper.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/MultiStepper");
});

cljs.core.__GT_MultiStepper = (function cljs$core$__GT_MultiStepper(xform,iters,nexts){
return (new cljs.core.MultiStepper(xform,iters,nexts));
});

cljs.core.multi_stepper = (function cljs$core$multi_stepper(){
var G__8104 = arguments.length;
switch (G__8104) {
case 2:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = (function (xform,iters){
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length)));
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = (function (xform,iters,nexts){
var stepfn = (function() {
var cljs$core$stepfn = null;
var cljs$core$stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return lt;
});
var cljs$core$stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepfn__1.call(this,result);
case 2:
return cljs$core$stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
return cljs$core$stepfn;
})()
;
return (new cljs.core.MultiStepper((function (){var G__8105 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__8105) : xform.call(null,G__8105));
})(),iters,nexts));
});

cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;

/**
* @constructor
*/
cljs.core.LazyTransformer = (function (stepper,first,rest,meta){
this.stepper = stepper;
this.first = first;
this.rest = rest;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 31719628;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,new_meta){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.LazyTransformer(self__.stepper,self__.first,self__.rest,new_meta));
});

cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,cljs.core._seq(this$__$1));
});

cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
var s = cljs.core._seq(this$__$1);
if(!((s == null))){
return cljs.core.equiv_sequential(this$__$1,other);
} else {
return (cljs.core.sequential_QMARK_(other)) && ((cljs.core.seq(other) == null));
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash_ordered_coll(this$__$1);
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
self__.stepper.step(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return this$__$1;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return self__.first;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return cljs.core._seq(self__.rest);
}
});

cljs.core.LazyTransformer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"stepper","stepper",1159163296,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
});

cljs.core.LazyTransformer.cljs$lang$type = true;

cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";

cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/LazyTransformer");
});

cljs.core.__GT_LazyTransformer = (function cljs$core$__GT_LazyTransformer(stepper,first,rest,meta){
return (new cljs.core.LazyTransformer(stepper,first,rest,meta));
});

(cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
cljs.core.LazyTransformer.create = (function (xform,coll){
return (new cljs.core.LazyTransformer(cljs.core.stepper(xform,cljs.core.iter(coll)),null,null,null));
});
cljs.core.LazyTransformer.createMulti = (function (xform,colls){
var iters = [];
var seq__8107_8111 = cljs.core.seq(colls);
var chunk__8108_8112 = null;
var count__8109_8113 = (0);
var i__8110_8114 = (0);
while(true){
if((i__8110_8114 < count__8109_8113)){
var coll_8115 = chunk__8108_8112.cljs$core$IIndexed$_nth$arity$2(null,i__8110_8114);
iters.push(cljs.core.iter(coll_8115));

var G__8116 = seq__8107_8111;
var G__8117 = chunk__8108_8112;
var G__8118 = count__8109_8113;
var G__8119 = (i__8110_8114 + (1));
seq__8107_8111 = G__8116;
chunk__8108_8112 = G__8117;
count__8109_8113 = G__8118;
i__8110_8114 = G__8119;
continue;
} else {
var temp__4423__auto___8120 = cljs.core.seq(seq__8107_8111);
if(temp__4423__auto___8120){
var seq__8107_8121__$1 = temp__4423__auto___8120;
if(cljs.core.chunked_seq_QMARK_(seq__8107_8121__$1)){
var c__4710__auto___8122 = cljs.core.chunk_first(seq__8107_8121__$1);
var G__8123 = cljs.core.chunk_rest(seq__8107_8121__$1);
var G__8124 = c__4710__auto___8122;
var G__8125 = cljs.core.count(c__4710__auto___8122);
var G__8126 = (0);
seq__8107_8111 = G__8123;
chunk__8108_8112 = G__8124;
count__8109_8113 = G__8125;
i__8110_8114 = G__8126;
continue;
} else {
var coll_8127 = cljs.core.first(seq__8107_8121__$1);
iters.push(cljs.core.iter(coll_8127));

var G__8128 = cljs.core.next(seq__8107_8121__$1);
var G__8129 = null;
var G__8130 = (0);
var G__8131 = (0);
seq__8107_8111 = G__8128;
chunk__8108_8112 = G__8129;
count__8109_8113 = G__8130;
i__8110_8114 = G__8131;
continue;
}
} else {
}
}
break;
}

return (new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length))),null,null,null));
});
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 * one. Will not force a lazy seq. (sequence nil) yields (), When a
 * transducer is supplied, returns a lazy sequence of applications of
 * the transform to the items in coll(s), i.e. to the set of first
 * items of each coll, followed by the set of second
 * items in each coll, until any one of the colls is exhausted.  Any
 * remaining items in other colls are ignored. The transform should accept
 * number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(){
var G__8136 = arguments.length;
switch (G__8136) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__3925__auto__ = cljs.core.seq(coll);
if(or__3925__auto__){
return or__3925__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function (xform,coll){
return cljs.core.LazyTransformer.create(xform,coll);
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function (xform,coll,colls){
return cljs.core.LazyTransformer.createMulti(xform,cljs.core.to_array(cljs.core.cons(coll,colls)));
});

cljs.core.sequence.cljs$lang$applyTo = (function (seq8132){
var G__8133 = cljs.core.first(seq8132);
var seq8132__$1 = cljs.core.next(seq8132);
var G__8134 = cljs.core.first(seq8132__$1);
var seq8132__$2 = cljs.core.next(seq8132__$1);
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__8133,G__8134,seq8132__$2);
});

cljs.core.sequence.cljs$lang$maxFixedArity = (2);
/**
 * Returns true if (pred x) is logical true for every x in coll, else
 * false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__8139 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8139) : pred.call(null,G__8139));
})())){
var G__8140 = pred;
var G__8141 = cljs.core.next(coll);
pred = G__8140;
coll = G__8141;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 * coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return !(cljs.core.every_QMARK_(pred,coll));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 * else nil.  One common idiom is to use a set as pred, for example
 * this will return :fred if :fred is in the sequence, otherwise nil:
 * (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
if(cljs.core.seq(coll)){
var or__3925__auto__ = (function (){var G__8145 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8145) : pred.call(null,G__8145));
})();
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
var G__8146 = pred;
var G__8147 = cljs.core.next(coll);
pred = G__8146;
coll = G__8147;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 * else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error([cljs.core.str("Argument must be an integer: "),cljs.core.str(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return !(cljs.core.even_QMARK_(n));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 * has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__8154 = null;
var G__8154__0 = (function (){
return cljs.core.not((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
});
var G__8154__1 = (function (x){
return cljs.core.not((function (){var G__8151 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8151) : f.call(null,G__8151));
})());
});
var G__8154__2 = (function (x,y){
return cljs.core.not((function (){var G__8152 = x;
var G__8153 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8152,G__8153) : f.call(null,G__8152,G__8153));
})());
});
var G__8154__3 = (function() { 
var G__8155__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__8155 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__8156__i = 0, G__8156__a = new Array(arguments.length -  2);
while (G__8156__i < G__8156__a.length) {G__8156__a[G__8156__i] = arguments[G__8156__i + 2]; ++G__8156__i;}
  zs = new cljs.core.IndexedSeq(G__8156__a,0);
} 
return G__8155__delegate.call(this,x,y,zs);};
G__8155.cljs$lang$maxFixedArity = 2;
G__8155.cljs$lang$applyTo = (function (arglist__8157){
var x = cljs.core.first(arglist__8157);
arglist__8157 = cljs.core.next(arglist__8157);
var y = cljs.core.first(arglist__8157);
var zs = cljs.core.rest(arglist__8157);
return G__8155__delegate(x,y,zs);
});
G__8155.cljs$core$IFn$_invoke$arity$variadic = G__8155__delegate;
return G__8155;
})()
;
G__8154 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__8154__0.call(this);
case 1:
return G__8154__1.call(this,x);
case 2:
return G__8154__2.call(this,x,y);
default:
var G__8158 = null;
if (arguments.length > 2) {
var G__8159__i = 0, G__8159__a = new Array(arguments.length -  2);
while (G__8159__i < G__8159__a.length) {G__8159__a[G__8159__i] = arguments[G__8159__i + 2]; ++G__8159__i;}
G__8158 = new cljs.core.IndexedSeq(G__8159__a,0);
}
return G__8154__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8154.cljs$lang$maxFixedArity = 2;
G__8154.cljs$lang$applyTo = G__8154__3.cljs$lang$applyTo;
G__8154.cljs$core$IFn$_invoke$arity$0 = G__8154__0;
G__8154.cljs$core$IFn$_invoke$arity$1 = G__8154__1;
G__8154.cljs$core$IFn$_invoke$arity$2 = G__8154__2;
G__8154.cljs$core$IFn$_invoke$arity$variadic = G__8154__3.cljs$core$IFn$_invoke$arity$variadic;
return G__8154;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__8160__delegate = function (args){
return x;
};
var G__8160 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__8161__i = 0, G__8161__a = new Array(arguments.length -  0);
while (G__8161__i < G__8161__a.length) {G__8161__a[G__8161__i] = arguments[G__8161__i + 0]; ++G__8161__i;}
  args = new cljs.core.IndexedSeq(G__8161__a,0);
} 
return G__8160__delegate.call(this,args);};
G__8160.cljs$lang$maxFixedArity = 0;
G__8160.cljs$lang$applyTo = (function (arglist__8162){
var args = cljs.core.seq(arglist__8162);
return G__8160__delegate(args);
});
G__8160.cljs$core$IFn$_invoke$arity$variadic = G__8160__delegate;
return G__8160;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 * of those fns.  The returned fn takes a variable number of args,
 * applies the rightmost of fns to the args, the next
 * fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(){
var G__8168 = arguments.length;
switch (G__8168) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0)));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4976__auto__);

}
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.identity;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__8197 = null;
var G__8197__0 = (function (){
var G__8169 = (function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8169) : f.call(null,G__8169));
});
var G__8197__1 = (function (x){
var G__8170 = (function (){var G__8171 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8171) : g.call(null,G__8171));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8170) : f.call(null,G__8170));
});
var G__8197__2 = (function (x,y){
var G__8172 = (function (){var G__8173 = x;
var G__8174 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__8173,G__8174) : g.call(null,G__8173,G__8174));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8172) : f.call(null,G__8172));
});
var G__8197__3 = (function (x,y,z){
var G__8175 = (function (){var G__8176 = x;
var G__8177 = y;
var G__8178 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__8176,G__8177,G__8178) : g.call(null,G__8176,G__8177,G__8178));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8175) : f.call(null,G__8175));
});
var G__8197__4 = (function() { 
var G__8198__delegate = function (x,y,z,args){
var G__8179 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8179) : f.call(null,G__8179));
};
var G__8198 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8199__i = 0, G__8199__a = new Array(arguments.length -  3);
while (G__8199__i < G__8199__a.length) {G__8199__a[G__8199__i] = arguments[G__8199__i + 3]; ++G__8199__i;}
  args = new cljs.core.IndexedSeq(G__8199__a,0);
} 
return G__8198__delegate.call(this,x,y,z,args);};
G__8198.cljs$lang$maxFixedArity = 3;
G__8198.cljs$lang$applyTo = (function (arglist__8200){
var x = cljs.core.first(arglist__8200);
arglist__8200 = cljs.core.next(arglist__8200);
var y = cljs.core.first(arglist__8200);
arglist__8200 = cljs.core.next(arglist__8200);
var z = cljs.core.first(arglist__8200);
var args = cljs.core.rest(arglist__8200);
return G__8198__delegate(x,y,z,args);
});
G__8198.cljs$core$IFn$_invoke$arity$variadic = G__8198__delegate;
return G__8198;
})()
;
G__8197 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8197__0.call(this);
case 1:
return G__8197__1.call(this,x);
case 2:
return G__8197__2.call(this,x,y);
case 3:
return G__8197__3.call(this,x,y,z);
default:
var G__8201 = null;
if (arguments.length > 3) {
var G__8202__i = 0, G__8202__a = new Array(arguments.length -  3);
while (G__8202__i < G__8202__a.length) {G__8202__a[G__8202__i] = arguments[G__8202__i + 3]; ++G__8202__i;}
G__8201 = new cljs.core.IndexedSeq(G__8202__a,0);
}
return G__8197__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8197.cljs$lang$maxFixedArity = 3;
G__8197.cljs$lang$applyTo = G__8197__4.cljs$lang$applyTo;
G__8197.cljs$core$IFn$_invoke$arity$0 = G__8197__0;
G__8197.cljs$core$IFn$_invoke$arity$1 = G__8197__1;
G__8197.cljs$core$IFn$_invoke$arity$2 = G__8197__2;
G__8197.cljs$core$IFn$_invoke$arity$3 = G__8197__3;
G__8197.cljs$core$IFn$_invoke$arity$variadic = G__8197__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8197;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__8203 = null;
var G__8203__0 = (function (){
var G__8180 = (function (){var G__8181 = (function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8181) : g.call(null,G__8181));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8180) : f.call(null,G__8180));
});
var G__8203__1 = (function (x){
var G__8182 = (function (){var G__8183 = (function (){var G__8184 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__8184) : h.call(null,G__8184));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8183) : g.call(null,G__8183));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8182) : f.call(null,G__8182));
});
var G__8203__2 = (function (x,y){
var G__8185 = (function (){var G__8186 = (function (){var G__8187 = x;
var G__8188 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__8187,G__8188) : h.call(null,G__8187,G__8188));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8186) : g.call(null,G__8186));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8185) : f.call(null,G__8185));
});
var G__8203__3 = (function (x,y,z){
var G__8189 = (function (){var G__8190 = (function (){var G__8191 = x;
var G__8192 = y;
var G__8193 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__8191,G__8192,G__8193) : h.call(null,G__8191,G__8192,G__8193));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8190) : g.call(null,G__8190));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8189) : f.call(null,G__8189));
});
var G__8203__4 = (function() { 
var G__8204__delegate = function (x,y,z,args){
var G__8194 = (function (){var G__8195 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8195) : g.call(null,G__8195));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8194) : f.call(null,G__8194));
};
var G__8204 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8205__i = 0, G__8205__a = new Array(arguments.length -  3);
while (G__8205__i < G__8205__a.length) {G__8205__a[G__8205__i] = arguments[G__8205__i + 3]; ++G__8205__i;}
  args = new cljs.core.IndexedSeq(G__8205__a,0);
} 
return G__8204__delegate.call(this,x,y,z,args);};
G__8204.cljs$lang$maxFixedArity = 3;
G__8204.cljs$lang$applyTo = (function (arglist__8206){
var x = cljs.core.first(arglist__8206);
arglist__8206 = cljs.core.next(arglist__8206);
var y = cljs.core.first(arglist__8206);
arglist__8206 = cljs.core.next(arglist__8206);
var z = cljs.core.first(arglist__8206);
var args = cljs.core.rest(arglist__8206);
return G__8204__delegate(x,y,z,args);
});
G__8204.cljs$core$IFn$_invoke$arity$variadic = G__8204__delegate;
return G__8204;
})()
;
G__8203 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8203__0.call(this);
case 1:
return G__8203__1.call(this,x);
case 2:
return G__8203__2.call(this,x,y);
case 3:
return G__8203__3.call(this,x,y,z);
default:
var G__8207 = null;
if (arguments.length > 3) {
var G__8208__i = 0, G__8208__a = new Array(arguments.length -  3);
while (G__8208__i < G__8208__a.length) {G__8208__a[G__8208__i] = arguments[G__8208__i + 3]; ++G__8208__i;}
G__8207 = new cljs.core.IndexedSeq(G__8208__a,0);
}
return G__8203__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8203.cljs$lang$maxFixedArity = 3;
G__8203.cljs$lang$applyTo = G__8203__4.cljs$lang$applyTo;
G__8203.cljs$core$IFn$_invoke$arity$0 = G__8203__0;
G__8203.cljs$core$IFn$_invoke$arity$1 = G__8203__1;
G__8203.cljs$core$IFn$_invoke$arity$2 = G__8203__2;
G__8203.cljs$core$IFn$_invoke$arity$3 = G__8203__3;
G__8203.cljs$core$IFn$_invoke$arity$variadic = G__8203__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8203;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return ((function (fs__$1){
return (function() { 
var G__8209__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__8210 = cljs.core.first(fs__$2).call(null,ret);
var G__8211 = cljs.core.next(fs__$2);
ret = G__8210;
fs__$2 = G__8211;
continue;
} else {
return ret;
}
break;
}
};
var G__8209 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__8212__i = 0, G__8212__a = new Array(arguments.length -  0);
while (G__8212__i < G__8212__a.length) {G__8212__a[G__8212__i] = arguments[G__8212__i + 0]; ++G__8212__i;}
  args = new cljs.core.IndexedSeq(G__8212__a,0);
} 
return G__8209__delegate.call(this,args);};
G__8209.cljs$lang$maxFixedArity = 0;
G__8209.cljs$lang$applyTo = (function (arglist__8213){
var args = cljs.core.seq(arglist__8213);
return G__8209__delegate(args);
});
G__8209.cljs$core$IFn$_invoke$arity$variadic = G__8209__delegate;
return G__8209;
})()
;
;})(fs__$1))
});

cljs.core.comp.cljs$lang$applyTo = (function (seq8163){
var G__8164 = cljs.core.first(seq8163);
var seq8163__$1 = cljs.core.next(seq8163);
var G__8165 = cljs.core.first(seq8163__$1);
var seq8163__$2 = cljs.core.next(seq8163__$1);
var G__8166 = cljs.core.first(seq8163__$2);
var seq8163__$3 = cljs.core.next(seq8163__$2);
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__8164,G__8165,G__8166,seq8163__$3);
});

cljs.core.comp.cljs$lang$maxFixedArity = (3);
/**
 * Takes a function f and fewer than the normal arguments to f, and
 * returns a fn that takes a variable number of additional args. When
 * called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(){
var G__8220 = arguments.length;
switch (G__8220) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(4)),(0)));
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4976__auto__);

}
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function (f,arg1){
return (function() {
var G__8264 = null;
var G__8264__0 = (function (){
var G__8221 = arg1;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8221) : f.call(null,G__8221));
});
var G__8264__1 = (function (x){
var G__8222 = arg1;
var G__8223 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8222,G__8223) : f.call(null,G__8222,G__8223));
});
var G__8264__2 = (function (x,y){
var G__8224 = arg1;
var G__8225 = x;
var G__8226 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8224,G__8225,G__8226) : f.call(null,G__8224,G__8225,G__8226));
});
var G__8264__3 = (function (x,y,z){
var G__8227 = arg1;
var G__8228 = x;
var G__8229 = y;
var G__8230 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8227,G__8228,G__8229,G__8230) : f.call(null,G__8227,G__8228,G__8229,G__8230));
});
var G__8264__4 = (function() { 
var G__8265__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.array_seq([args], 0));
};
var G__8265 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8266__i = 0, G__8266__a = new Array(arguments.length -  3);
while (G__8266__i < G__8266__a.length) {G__8266__a[G__8266__i] = arguments[G__8266__i + 3]; ++G__8266__i;}
  args = new cljs.core.IndexedSeq(G__8266__a,0);
} 
return G__8265__delegate.call(this,x,y,z,args);};
G__8265.cljs$lang$maxFixedArity = 3;
G__8265.cljs$lang$applyTo = (function (arglist__8267){
var x = cljs.core.first(arglist__8267);
arglist__8267 = cljs.core.next(arglist__8267);
var y = cljs.core.first(arglist__8267);
arglist__8267 = cljs.core.next(arglist__8267);
var z = cljs.core.first(arglist__8267);
var args = cljs.core.rest(arglist__8267);
return G__8265__delegate(x,y,z,args);
});
G__8265.cljs$core$IFn$_invoke$arity$variadic = G__8265__delegate;
return G__8265;
})()
;
G__8264 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8264__0.call(this);
case 1:
return G__8264__1.call(this,x);
case 2:
return G__8264__2.call(this,x,y);
case 3:
return G__8264__3.call(this,x,y,z);
default:
var G__8268 = null;
if (arguments.length > 3) {
var G__8269__i = 0, G__8269__a = new Array(arguments.length -  3);
while (G__8269__i < G__8269__a.length) {G__8269__a[G__8269__i] = arguments[G__8269__i + 3]; ++G__8269__i;}
G__8268 = new cljs.core.IndexedSeq(G__8269__a,0);
}
return G__8264__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8268);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8264.cljs$lang$maxFixedArity = 3;
G__8264.cljs$lang$applyTo = G__8264__4.cljs$lang$applyTo;
G__8264.cljs$core$IFn$_invoke$arity$0 = G__8264__0;
G__8264.cljs$core$IFn$_invoke$arity$1 = G__8264__1;
G__8264.cljs$core$IFn$_invoke$arity$2 = G__8264__2;
G__8264.cljs$core$IFn$_invoke$arity$3 = G__8264__3;
G__8264.cljs$core$IFn$_invoke$arity$variadic = G__8264__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8264;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function (f,arg1,arg2){
return (function() {
var G__8270 = null;
var G__8270__0 = (function (){
var G__8231 = arg1;
var G__8232 = arg2;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8231,G__8232) : f.call(null,G__8231,G__8232));
});
var G__8270__1 = (function (x){
var G__8233 = arg1;
var G__8234 = arg2;
var G__8235 = x;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8233,G__8234,G__8235) : f.call(null,G__8233,G__8234,G__8235));
});
var G__8270__2 = (function (x,y){
var G__8236 = arg1;
var G__8237 = arg2;
var G__8238 = x;
var G__8239 = y;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8236,G__8237,G__8238,G__8239) : f.call(null,G__8236,G__8237,G__8238,G__8239));
});
var G__8270__3 = (function (x,y,z){
var G__8240 = arg1;
var G__8241 = arg2;
var G__8242 = x;
var G__8243 = y;
var G__8244 = z;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__8240,G__8241,G__8242,G__8243,G__8244) : f.call(null,G__8240,G__8241,G__8242,G__8243,G__8244));
});
var G__8270__4 = (function() { 
var G__8271__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.array_seq([z,args], 0));
};
var G__8271 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8272__i = 0, G__8272__a = new Array(arguments.length -  3);
while (G__8272__i < G__8272__a.length) {G__8272__a[G__8272__i] = arguments[G__8272__i + 3]; ++G__8272__i;}
  args = new cljs.core.IndexedSeq(G__8272__a,0);
} 
return G__8271__delegate.call(this,x,y,z,args);};
G__8271.cljs$lang$maxFixedArity = 3;
G__8271.cljs$lang$applyTo = (function (arglist__8273){
var x = cljs.core.first(arglist__8273);
arglist__8273 = cljs.core.next(arglist__8273);
var y = cljs.core.first(arglist__8273);
arglist__8273 = cljs.core.next(arglist__8273);
var z = cljs.core.first(arglist__8273);
var args = cljs.core.rest(arglist__8273);
return G__8271__delegate(x,y,z,args);
});
G__8271.cljs$core$IFn$_invoke$arity$variadic = G__8271__delegate;
return G__8271;
})()
;
G__8270 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8270__0.call(this);
case 1:
return G__8270__1.call(this,x);
case 2:
return G__8270__2.call(this,x,y);
case 3:
return G__8270__3.call(this,x,y,z);
default:
var G__8274 = null;
if (arguments.length > 3) {
var G__8275__i = 0, G__8275__a = new Array(arguments.length -  3);
while (G__8275__i < G__8275__a.length) {G__8275__a[G__8275__i] = arguments[G__8275__i + 3]; ++G__8275__i;}
G__8274 = new cljs.core.IndexedSeq(G__8275__a,0);
}
return G__8270__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8270.cljs$lang$maxFixedArity = 3;
G__8270.cljs$lang$applyTo = G__8270__4.cljs$lang$applyTo;
G__8270.cljs$core$IFn$_invoke$arity$0 = G__8270__0;
G__8270.cljs$core$IFn$_invoke$arity$1 = G__8270__1;
G__8270.cljs$core$IFn$_invoke$arity$2 = G__8270__2;
G__8270.cljs$core$IFn$_invoke$arity$3 = G__8270__3;
G__8270.cljs$core$IFn$_invoke$arity$variadic = G__8270__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8270;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__8276 = null;
var G__8276__0 = (function (){
var G__8245 = arg1;
var G__8246 = arg2;
var G__8247 = arg3;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8245,G__8246,G__8247) : f.call(null,G__8245,G__8246,G__8247));
});
var G__8276__1 = (function (x){
var G__8248 = arg1;
var G__8249 = arg2;
var G__8250 = arg3;
var G__8251 = x;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8248,G__8249,G__8250,G__8251) : f.call(null,G__8248,G__8249,G__8250,G__8251));
});
var G__8276__2 = (function (x,y){
var G__8252 = arg1;
var G__8253 = arg2;
var G__8254 = arg3;
var G__8255 = x;
var G__8256 = y;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__8252,G__8253,G__8254,G__8255,G__8256) : f.call(null,G__8252,G__8253,G__8254,G__8255,G__8256));
});
var G__8276__3 = (function (x,y,z){
var G__8257 = arg1;
var G__8258 = arg2;
var G__8259 = arg3;
var G__8260 = x;
var G__8261 = y;
var G__8262 = z;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__8257,G__8258,G__8259,G__8260,G__8261,G__8262) : f.call(null,G__8257,G__8258,G__8259,G__8260,G__8261,G__8262));
});
var G__8276__4 = (function() { 
var G__8277__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.array_seq([y,z,args], 0));
};
var G__8277 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8278__i = 0, G__8278__a = new Array(arguments.length -  3);
while (G__8278__i < G__8278__a.length) {G__8278__a[G__8278__i] = arguments[G__8278__i + 3]; ++G__8278__i;}
  args = new cljs.core.IndexedSeq(G__8278__a,0);
} 
return G__8277__delegate.call(this,x,y,z,args);};
G__8277.cljs$lang$maxFixedArity = 3;
G__8277.cljs$lang$applyTo = (function (arglist__8279){
var x = cljs.core.first(arglist__8279);
arglist__8279 = cljs.core.next(arglist__8279);
var y = cljs.core.first(arglist__8279);
arglist__8279 = cljs.core.next(arglist__8279);
var z = cljs.core.first(arglist__8279);
var args = cljs.core.rest(arglist__8279);
return G__8277__delegate(x,y,z,args);
});
G__8277.cljs$core$IFn$_invoke$arity$variadic = G__8277__delegate;
return G__8277;
})()
;
G__8276 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8276__0.call(this);
case 1:
return G__8276__1.call(this,x);
case 2:
return G__8276__2.call(this,x,y);
case 3:
return G__8276__3.call(this,x,y,z);
default:
var G__8280 = null;
if (arguments.length > 3) {
var G__8281__i = 0, G__8281__a = new Array(arguments.length -  3);
while (G__8281__i < G__8281__a.length) {G__8281__a[G__8281__i] = arguments[G__8281__i + 3]; ++G__8281__i;}
G__8280 = new cljs.core.IndexedSeq(G__8281__a,0);
}
return G__8276__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8276.cljs$lang$maxFixedArity = 3;
G__8276.cljs$lang$applyTo = G__8276__4.cljs$lang$applyTo;
G__8276.cljs$core$IFn$_invoke$arity$0 = G__8276__0;
G__8276.cljs$core$IFn$_invoke$arity$1 = G__8276__1;
G__8276.cljs$core$IFn$_invoke$arity$2 = G__8276__2;
G__8276.cljs$core$IFn$_invoke$arity$3 = G__8276__3;
G__8276.cljs$core$IFn$_invoke$arity$variadic = G__8276__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8276;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg1,arg2,arg3,more){
return (function() { 
var G__8282__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__8282 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__8283__i = 0, G__8283__a = new Array(arguments.length -  0);
while (G__8283__i < G__8283__a.length) {G__8283__a[G__8283__i] = arguments[G__8283__i + 0]; ++G__8283__i;}
  args = new cljs.core.IndexedSeq(G__8283__a,0);
} 
return G__8282__delegate.call(this,args);};
G__8282.cljs$lang$maxFixedArity = 0;
G__8282.cljs$lang$applyTo = (function (arglist__8284){
var args = cljs.core.seq(arglist__8284);
return G__8282__delegate(args);
});
G__8282.cljs$core$IFn$_invoke$arity$variadic = G__8282__delegate;
return G__8282;
})()
;
});

cljs.core.partial.cljs$lang$applyTo = (function (seq8214){
var G__8215 = cljs.core.first(seq8214);
var seq8214__$1 = cljs.core.next(seq8214);
var G__8216 = cljs.core.first(seq8214__$1);
var seq8214__$2 = cljs.core.next(seq8214__$1);
var G__8217 = cljs.core.first(seq8214__$2);
var seq8214__$3 = cljs.core.next(seq8214__$2);
var G__8218 = cljs.core.first(seq8214__$3);
var seq8214__$4 = cljs.core.next(seq8214__$3);
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__8215,G__8216,G__8217,G__8218,seq8214__$4);
});

cljs.core.partial.cljs$lang$maxFixedArity = (4);
/**
 * Takes a function f, and returns a function that calls f, replacing
 * a nil first argument to f with the supplied value x. Higher arity
 * versions can replace arguments in the second and third
 * positions (y, z). Note that the function f can take any number of
 * arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(){
var G__8286 = arguments.length;
switch (G__8286) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function (f,x){
return (function() {
var G__8304 = null;
var G__8304__1 = (function (a){
var G__8287 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8287) : f.call(null,G__8287));
});
var G__8304__2 = (function (a,b){
var G__8288 = (((a == null))?x:a);
var G__8289 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8288,G__8289) : f.call(null,G__8288,G__8289));
});
var G__8304__3 = (function (a,b,c){
var G__8290 = (((a == null))?x:a);
var G__8291 = b;
var G__8292 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8290,G__8291,G__8292) : f.call(null,G__8290,G__8291,G__8292));
});
var G__8304__4 = (function() { 
var G__8305__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__8305 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__8306__i = 0, G__8306__a = new Array(arguments.length -  3);
while (G__8306__i < G__8306__a.length) {G__8306__a[G__8306__i] = arguments[G__8306__i + 3]; ++G__8306__i;}
  ds = new cljs.core.IndexedSeq(G__8306__a,0);
} 
return G__8305__delegate.call(this,a,b,c,ds);};
G__8305.cljs$lang$maxFixedArity = 3;
G__8305.cljs$lang$applyTo = (function (arglist__8307){
var a = cljs.core.first(arglist__8307);
arglist__8307 = cljs.core.next(arglist__8307);
var b = cljs.core.first(arglist__8307);
arglist__8307 = cljs.core.next(arglist__8307);
var c = cljs.core.first(arglist__8307);
var ds = cljs.core.rest(arglist__8307);
return G__8305__delegate(a,b,c,ds);
});
G__8305.cljs$core$IFn$_invoke$arity$variadic = G__8305__delegate;
return G__8305;
})()
;
G__8304 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__8304__1.call(this,a);
case 2:
return G__8304__2.call(this,a,b);
case 3:
return G__8304__3.call(this,a,b,c);
default:
var G__8308 = null;
if (arguments.length > 3) {
var G__8309__i = 0, G__8309__a = new Array(arguments.length -  3);
while (G__8309__i < G__8309__a.length) {G__8309__a[G__8309__i] = arguments[G__8309__i + 3]; ++G__8309__i;}
G__8308 = new cljs.core.IndexedSeq(G__8309__a,0);
}
return G__8304__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__8308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8304.cljs$lang$maxFixedArity = 3;
G__8304.cljs$lang$applyTo = G__8304__4.cljs$lang$applyTo;
G__8304.cljs$core$IFn$_invoke$arity$1 = G__8304__1;
G__8304.cljs$core$IFn$_invoke$arity$2 = G__8304__2;
G__8304.cljs$core$IFn$_invoke$arity$3 = G__8304__3;
G__8304.cljs$core$IFn$_invoke$arity$variadic = G__8304__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8304;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function (f,x,y){
return (function() {
var G__8310 = null;
var G__8310__2 = (function (a,b){
var G__8293 = (((a == null))?x:a);
var G__8294 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8293,G__8294) : f.call(null,G__8293,G__8294));
});
var G__8310__3 = (function (a,b,c){
var G__8295 = (((a == null))?x:a);
var G__8296 = (((b == null))?y:b);
var G__8297 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8295,G__8296,G__8297) : f.call(null,G__8295,G__8296,G__8297));
});
var G__8310__4 = (function() { 
var G__8311__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__8311 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__8312__i = 0, G__8312__a = new Array(arguments.length -  3);
while (G__8312__i < G__8312__a.length) {G__8312__a[G__8312__i] = arguments[G__8312__i + 3]; ++G__8312__i;}
  ds = new cljs.core.IndexedSeq(G__8312__a,0);
} 
return G__8311__delegate.call(this,a,b,c,ds);};
G__8311.cljs$lang$maxFixedArity = 3;
G__8311.cljs$lang$applyTo = (function (arglist__8313){
var a = cljs.core.first(arglist__8313);
arglist__8313 = cljs.core.next(arglist__8313);
var b = cljs.core.first(arglist__8313);
arglist__8313 = cljs.core.next(arglist__8313);
var c = cljs.core.first(arglist__8313);
var ds = cljs.core.rest(arglist__8313);
return G__8311__delegate(a,b,c,ds);
});
G__8311.cljs$core$IFn$_invoke$arity$variadic = G__8311__delegate;
return G__8311;
})()
;
G__8310 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__8310__2.call(this,a,b);
case 3:
return G__8310__3.call(this,a,b,c);
default:
var G__8314 = null;
if (arguments.length > 3) {
var G__8315__i = 0, G__8315__a = new Array(arguments.length -  3);
while (G__8315__i < G__8315__a.length) {G__8315__a[G__8315__i] = arguments[G__8315__i + 3]; ++G__8315__i;}
G__8314 = new cljs.core.IndexedSeq(G__8315__a,0);
}
return G__8310__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__8314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8310.cljs$lang$maxFixedArity = 3;
G__8310.cljs$lang$applyTo = G__8310__4.cljs$lang$applyTo;
G__8310.cljs$core$IFn$_invoke$arity$2 = G__8310__2;
G__8310.cljs$core$IFn$_invoke$arity$3 = G__8310__3;
G__8310.cljs$core$IFn$_invoke$arity$variadic = G__8310__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8310;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,z){
return (function() {
var G__8316 = null;
var G__8316__2 = (function (a,b){
var G__8298 = (((a == null))?x:a);
var G__8299 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8298,G__8299) : f.call(null,G__8298,G__8299));
});
var G__8316__3 = (function (a,b,c){
var G__8300 = (((a == null))?x:a);
var G__8301 = (((b == null))?y:b);
var G__8302 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8300,G__8301,G__8302) : f.call(null,G__8300,G__8301,G__8302));
});
var G__8316__4 = (function() { 
var G__8317__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__8317 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__8318__i = 0, G__8318__a = new Array(arguments.length -  3);
while (G__8318__i < G__8318__a.length) {G__8318__a[G__8318__i] = arguments[G__8318__i + 3]; ++G__8318__i;}
  ds = new cljs.core.IndexedSeq(G__8318__a,0);
} 
return G__8317__delegate.call(this,a,b,c,ds);};
G__8317.cljs$lang$maxFixedArity = 3;
G__8317.cljs$lang$applyTo = (function (arglist__8319){
var a = cljs.core.first(arglist__8319);
arglist__8319 = cljs.core.next(arglist__8319);
var b = cljs.core.first(arglist__8319);
arglist__8319 = cljs.core.next(arglist__8319);
var c = cljs.core.first(arglist__8319);
var ds = cljs.core.rest(arglist__8319);
return G__8317__delegate(a,b,c,ds);
});
G__8317.cljs$core$IFn$_invoke$arity$variadic = G__8317__delegate;
return G__8317;
})()
;
G__8316 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__8316__2.call(this,a,b);
case 3:
return G__8316__3.call(this,a,b,c);
default:
var G__8320 = null;
if (arguments.length > 3) {
var G__8321__i = 0, G__8321__a = new Array(arguments.length -  3);
while (G__8321__i < G__8321__a.length) {G__8321__a[G__8321__i] = arguments[G__8321__i + 3]; ++G__8321__i;}
G__8320 = new cljs.core.IndexedSeq(G__8321__a,0);
}
return G__8316__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__8320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8316.cljs$lang$maxFixedArity = 3;
G__8316.cljs$lang$applyTo = G__8316__4.cljs$lang$applyTo;
G__8316.cljs$core$IFn$_invoke$arity$2 = G__8316__2;
G__8316.cljs$core$IFn$_invoke$arity$3 = G__8316__3;
G__8316.cljs$core$IFn$_invoke$arity$variadic = G__8316__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8316;
})()
});

cljs.core.fnil.cljs$lang$maxFixedArity = 4;
/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 * and the first item of coll, followed by applying f to 1 and the second
 * item in coll, etc, until coll is exhausted. Thus function f should
 * accept 2 arguments, index and item.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(){
var G__8323 = arguments.length;
switch (G__8323) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var i = (function (){var G__8324 = (-1);
return (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(G__8324) : cljs.core.volatile_BANG_.call(null,G__8324));
})();
return ((function (i){
return (function() {
var G__8355 = null;
var G__8355__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8355__1 = (function (result){
var G__8325 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8325) : rf.call(null,G__8325));
});
var G__8355__2 = (function (result,input){
var G__8326 = result;
var G__8327 = (function (){var G__8328 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__8329 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8328,G__8329) : f.call(null,G__8328,G__8329));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8326,G__8327) : rf.call(null,G__8326,G__8327));
});
G__8355 = function(result,input){
switch(arguments.length){
case 0:
return G__8355__0.call(this);
case 1:
return G__8355__1.call(this,result);
case 2:
return G__8355__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8355.cljs$core$IFn$_invoke$arity$0 = G__8355__0;
G__8355.cljs$core$IFn$_invoke$arity$1 = G__8355__1;
G__8355.cljs$core$IFn$_invoke$arity$2 = G__8355__2;
return G__8355;
})()
;})(i))
});
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var mapi = (function cljs$core$mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4423__auto__ = cljs.core.seq(coll__$1);
if(temp__4423__auto__){
var s = temp__4423__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4810__auto___8356 = size;
var i_8357 = (0);
while(true){
if((i_8357 < n__4810__auto___8356)){
cljs.core.chunk_append(b,(function (){var G__8350 = (idx + i_8357);
var G__8351 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8357);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8350,G__8351) : f.call(null,G__8350,G__8351));
})());

var G__8358 = (i_8357 + (1));
i_8357 = G__8358;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__8352 = idx;
var G__8353 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8352,G__8353) : f.call(null,G__8352,G__8353));
})(),cljs$core$mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
});

cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 * this means false return values will be included.  f must be free of
 * side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(){
var G__8360 = arguments.length;
switch (G__8360) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__8368 = null;
var G__8368__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8368__1 = (function (result){
var G__8361 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8361) : rf.call(null,G__8361));
});
var G__8368__2 = (function (result,input){
var v = (function (){var G__8362 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8362) : f.call(null,G__8362));
})();
if((v == null)){
return result;
} else {
var G__8363 = result;
var G__8364 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8363,G__8364) : rf.call(null,G__8363,G__8364));
}
});
G__8368 = function(result,input){
switch(arguments.length){
case 0:
return G__8368__0.call(this);
case 1:
return G__8368__1.call(this,result);
case 2:
return G__8368__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8368.cljs$core$IFn$_invoke$arity$0 = G__8368__0;
G__8368.cljs$core$IFn$_invoke$arity$1 = G__8368__1;
G__8368.cljs$core$IFn$_invoke$arity$2 = G__8368__2;
return G__8368;
})()
});
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4423__auto__ = cljs.core.seq(coll);
if(temp__4423__auto__){
var s = temp__4423__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4810__auto___8369 = size;
var i_8370 = (0);
while(true){
if((i_8370 < n__4810__auto___8369)){
var x_8371 = (function (){var G__8365 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8370);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8365) : f.call(null,G__8365));
})();
if((x_8371 == null)){
} else {
cljs.core.chunk_append(b,x_8371);
}

var G__8372 = (i_8370 + (1));
i_8370 = G__8372;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__8366 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8366) : f.call(null,G__8366));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.keep.cljs$lang$maxFixedArity = 2;

/**
* @constructor
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
})
cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
});

cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__8373 = cljs.core.seq(self__.watches);
var chunk__8374 = null;
var count__8375 = (0);
var i__8376 = (0);
while(true){
if((i__8376 < count__8375)){
var vec__8377 = chunk__8374.cljs$core$IIndexed$_nth$arity$2(null,i__8376);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8377,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8377,(1),null);
var G__8378_8388 = key;
var G__8379_8389 = this$__$1;
var G__8380_8390 = oldval;
var G__8381_8391 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8378_8388,G__8379_8389,G__8380_8390,G__8381_8391) : f.call(null,G__8378_8388,G__8379_8389,G__8380_8390,G__8381_8391));

var G__8392 = seq__8373;
var G__8393 = chunk__8374;
var G__8394 = count__8375;
var G__8395 = (i__8376 + (1));
seq__8373 = G__8392;
chunk__8374 = G__8393;
count__8375 = G__8394;
i__8376 = G__8395;
continue;
} else {
var temp__4423__auto__ = cljs.core.seq(seq__8373);
if(temp__4423__auto__){
var seq__8373__$1 = temp__4423__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__8373__$1)){
var c__4710__auto__ = cljs.core.chunk_first(seq__8373__$1);
var G__8396 = cljs.core.chunk_rest(seq__8373__$1);
var G__8397 = c__4710__auto__;
var G__8398 = cljs.core.count(c__4710__auto__);
var G__8399 = (0);
seq__8373 = G__8396;
chunk__8374 = G__8397;
count__8375 = G__8398;
i__8376 = G__8399;
continue;
} else {
var vec__8382 = cljs.core.first(seq__8373__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8382,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8382,(1),null);
var G__8383_8400 = key;
var G__8384_8401 = this$__$1;
var G__8385_8402 = oldval;
var G__8386_8403 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8383_8400,G__8384_8401,G__8385_8402,G__8386_8403) : f.call(null,G__8383_8400,G__8384_8401,G__8385_8402,G__8386_8403));

var G__8404 = cljs.core.next(seq__8373__$1);
var G__8405 = null;
var G__8406 = (0);
var G__8407 = (0);
seq__8373 = G__8404;
chunk__8374 = G__8405;
count__8375 = G__8406;
i__8376 = G__8407;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);

return this$__$1;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key);
});

cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__8387 = this$__$1;
return goog.getUid(G__8387);
});

cljs.core.Atom.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null),new cljs.core.Symbol(null,"watches","watches",1367433992,null)], null);
});

cljs.core.Atom.cljs$lang$type = true;

cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";

cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/Atom");
});

cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 * more options (in any order):
 * 
 * :meta metadata-map
 * 
 * :validator validate-fn
 * 
 * If metadata-map is supplied, it will be come the metadata on the
 * atom. validate-fn must be nil or a side-effect-free fn of one
 * argument, which will be passed the intended new state on any state
 * change. If the new state is unacceptable, the validate-fn should
 * return false or throw an Error.  If either of these error conditions
 * occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(){
var G__8411 = arguments.length;
switch (G__8411) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0)));
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4976__auto__);

}
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__8412){
var map__8413 = p__8412;
var map__8413__$1 = ((cljs.core.seq_QMARK_(map__8413))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__8413):map__8413);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8413__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8413__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
return (new cljs.core.Atom(x,meta,validator,null));
});

cljs.core.atom.cljs$lang$applyTo = (function (seq8408){
var G__8409 = cljs.core.first(seq8408);
var seq8408__$1 = cljs.core.next(seq8408);
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__8409,seq8408__$1);
});

cljs.core.atom.cljs$lang$maxFixedArity = (1);
/**
 * Sets the value of atom to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((function (){var G__8417 = new_value;
return (validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(G__8417) : validate.call(null,G__8417));
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Validator rejected reference state"),cljs.core.str("\n"),cljs.core.str((function (){var G__8418 = cljs.core.list(new cljs.core.Symbol(null,"validate","validate",1439230700,null),new cljs.core.Symbol(null,"new-value","new-value",-1567397401,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__8418) : cljs.core.pr_str.call(null,G__8418));
})())].join('')));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Atomically swaps the value of atom to be:
 * (apply f current-value-of-atom args). Note that f may be called
 * multiple times, and thus should be free of side effects.  Returns
 * the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(){
var G__8425 = arguments.length;
switch (G__8425) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(4)),(0)));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4976__auto__);

}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__8426 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8426) : f.call(null,G__8426));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__8427 = a.state;
var G__8428 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8427,G__8428) : f.call(null,G__8427,G__8428));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__8429 = a.state;
var G__8430 = x;
var G__8431 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8429,G__8430,G__8431) : f.call(null,G__8429,G__8430,G__8431));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
});

cljs.core.swap_BANG_.cljs$lang$applyTo = (function (seq8419){
var G__8420 = cljs.core.first(seq8419);
var seq8419__$1 = cljs.core.next(seq8419);
var G__8421 = cljs.core.first(seq8419__$1);
var seq8419__$2 = cljs.core.next(seq8419__$1);
var G__8422 = cljs.core.first(seq8419__$2);
var seq8419__$3 = cljs.core.next(seq8419__$2);
var G__8423 = cljs.core.first(seq8419__$3);
var seq8419__$4 = cljs.core.next(seq8419__$3);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__8420,G__8421,G__8422,G__8423,seq8419__$4);
});

cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4);
/**
 * Atomically sets the value of atom to newval if and only if the
 * current value of the atom is equal to oldval. Returns true if
 * set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 * side-effect-free fn of one argument, which will be passed the intended
 * new state on any state change. If the new state is unacceptable, the
 * validator-fn should return false or throw an Error. If the current state
 * is not acceptable to the new validator, an Error will be thrown and the
 * validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
return iref.validator = val;
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;

cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return self__.state = new_state;
});

cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Volatile.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null)], null);
});

cljs.core.Volatile.cljs$lang$type = true;

cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";

cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/Volatile");
});

cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 * this means false return values will be included.  f must be free of
 * side-effects.  Returns a stateful transducer when no collection is
 * provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(){
var G__8434 = arguments.length;
switch (G__8434) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__8469 = null;
var G__8469__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8469__1 = (function (result){
var G__8435 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8435) : rf.call(null,G__8435));
});
var G__8469__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
var v = (function (){var G__8436 = i;
var G__8437 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8436,G__8437) : f.call(null,G__8436,G__8437));
})();
if((v == null)){
return result;
} else {
var G__8438 = result;
var G__8439 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8438,G__8439) : rf.call(null,G__8438,G__8439));
}
});
G__8469 = function(result,input){
switch(arguments.length){
case 0:
return G__8469__0.call(this);
case 1:
return G__8469__1.call(this,result);
case 2:
return G__8469__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8469.cljs$core$IFn$_invoke$arity$0 = G__8469__0;
G__8469.cljs$core$IFn$_invoke$arity$1 = G__8469__1;
G__8469.cljs$core$IFn$_invoke$arity$2 = G__8469__2;
return G__8469;
})()
;})(ia))
});
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var keepi = (function cljs$core$keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4423__auto__ = cljs.core.seq(coll__$1);
if(temp__4423__auto__){
var s = temp__4423__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4810__auto___8470 = size;
var i_8471 = (0);
while(true){
if((i_8471 < n__4810__auto___8470)){
var x_8472 = (function (){var G__8464 = (idx + i_8471);
var G__8465 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8471);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8464,G__8465) : f.call(null,G__8464,G__8465));
})();
if((x_8472 == null)){
} else {
cljs.core.chunk_append(b,x_8472);
}

var G__8473 = (i_8471 + (1));
i_8471 = G__8473;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__8466 = idx;
var G__8467 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8466,G__8467) : f.call(null,G__8466,G__8467));
})();
if((x == null)){
return cljs$core$keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
});

cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;
/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 * composing predicates return a logical true value against all of its arguments, else it returns
 * false. Note that f is short-circuiting in that it will stop execution on the first
 * argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(){
var G__8485 = arguments.length;
switch (G__8485) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0)));
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4976__auto__);

}
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$ep1 = null;
var cljs$core$ep1__0 = (function (){
return true;
});
var cljs$core$ep1__1 = (function (x){
return cljs.core.boolean$((function (){var G__8501 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8501) : p.call(null,G__8501));
})());
});
var cljs$core$ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3913__auto__ = (function (){var G__8503 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8503) : p.call(null,G__8503));
})();
if(cljs.core.truth_(and__3913__auto__)){
var G__8504 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8504) : p.call(null,G__8504));
} else {
return and__3913__auto__;
}
})());
});
var cljs$core$ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3913__auto__ = (function (){var G__8506 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8506) : p.call(null,G__8506));
})();
if(cljs.core.truth_(and__3913__auto__)){
var and__3913__auto____$1 = (function (){var G__8508 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8508) : p.call(null,G__8508));
})();
if(cljs.core.truth_(and__3913__auto____$1)){
var G__8509 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8509) : p.call(null,G__8509));
} else {
return and__3913__auto____$1;
}
} else {
return and__3913__auto__;
}
})());
});
var cljs$core$ep1__4 = (function() { 
var G__8671__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__3913__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__3913__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__3913__auto__;
}
})());
};
var G__8671 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8672__i = 0, G__8672__a = new Array(arguments.length -  3);
while (G__8672__i < G__8672__a.length) {G__8672__a[G__8672__i] = arguments[G__8672__i + 3]; ++G__8672__i;}
  args = new cljs.core.IndexedSeq(G__8672__a,0);
} 
return G__8671__delegate.call(this,x,y,z,args);};
G__8671.cljs$lang$maxFixedArity = 3;
G__8671.cljs$lang$applyTo = (function (arglist__8673){
var x = cljs.core.first(arglist__8673);
arglist__8673 = cljs.core.next(arglist__8673);
var y = cljs.core.first(arglist__8673);
arglist__8673 = cljs.core.next(arglist__8673);
var z = cljs.core.first(arglist__8673);
var args = cljs.core.rest(arglist__8673);
return G__8671__delegate(x,y,z,args);
});
G__8671.cljs$core$IFn$_invoke$arity$variadic = G__8671__delegate;
return G__8671;
})()
;
cljs$core$ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep1__0.call(this);
case 1:
return cljs$core$ep1__1.call(this,x);
case 2:
return cljs$core$ep1__2.call(this,x,y);
case 3:
return cljs$core$ep1__3.call(this,x,y,z);
default:
var G__8674 = null;
if (arguments.length > 3) {
var G__8675__i = 0, G__8675__a = new Array(arguments.length -  3);
while (G__8675__i < G__8675__a.length) {G__8675__a[G__8675__i] = arguments[G__8675__i + 3]; ++G__8675__i;}
G__8674 = new cljs.core.IndexedSeq(G__8675__a,0);
}
return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep1.cljs$lang$maxFixedArity = 3;
cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep1;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$ep2 = null;
var cljs$core$ep2__0 = (function (){
return true;
});
var cljs$core$ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__3913__auto__ = (function (){var G__8541 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8541) : p1.call(null,G__8541));
})();
if(cljs.core.truth_(and__3913__auto__)){
var G__8542 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8542) : p2.call(null,G__8542));
} else {
return and__3913__auto__;
}
})());
});
var cljs$core$ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3913__auto__ = (function (){var G__8544 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8544) : p1.call(null,G__8544));
})();
if(cljs.core.truth_(and__3913__auto__)){
var and__3913__auto____$1 = (function (){var G__8546 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8546) : p1.call(null,G__8546));
})();
if(cljs.core.truth_(and__3913__auto____$1)){
var and__3913__auto____$2 = (function (){var G__8548 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8548) : p2.call(null,G__8548));
})();
if(cljs.core.truth_(and__3913__auto____$2)){
var G__8549 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8549) : p2.call(null,G__8549));
} else {
return and__3913__auto____$2;
}
} else {
return and__3913__auto____$1;
}
} else {
return and__3913__auto__;
}
})());
});
var cljs$core$ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3913__auto__ = (function (){var G__8551 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8551) : p1.call(null,G__8551));
})();
if(cljs.core.truth_(and__3913__auto__)){
var and__3913__auto____$1 = (function (){var G__8553 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8553) : p1.call(null,G__8553));
})();
if(cljs.core.truth_(and__3913__auto____$1)){
var and__3913__auto____$2 = (function (){var G__8555 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8555) : p1.call(null,G__8555));
})();
if(cljs.core.truth_(and__3913__auto____$2)){
var and__3913__auto____$3 = (function (){var G__8557 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8557) : p2.call(null,G__8557));
})();
if(cljs.core.truth_(and__3913__auto____$3)){
var and__3913__auto____$4 = (function (){var G__8559 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8559) : p2.call(null,G__8559));
})();
if(cljs.core.truth_(and__3913__auto____$4)){
var G__8560 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8560) : p2.call(null,G__8560));
} else {
return and__3913__auto____$4;
}
} else {
return and__3913__auto____$3;
}
} else {
return and__3913__auto____$2;
}
} else {
return and__3913__auto____$1;
}
} else {
return and__3913__auto__;
}
})());
});
var cljs$core$ep2__4 = (function() { 
var G__8676__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__3913__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__3913__auto__)){
return cljs.core.every_QMARK_(((function (and__3913__auto__){
return (function (p1__8474_SHARP_){
var and__3913__auto____$1 = (function (){var G__8562 = p1__8474_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8562) : p1.call(null,G__8562));
})();
if(cljs.core.truth_(and__3913__auto____$1)){
var G__8563 = p1__8474_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8563) : p2.call(null,G__8563));
} else {
return and__3913__auto____$1;
}
});})(and__3913__auto__))
,args);
} else {
return and__3913__auto__;
}
})());
};
var G__8676 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8677__i = 0, G__8677__a = new Array(arguments.length -  3);
while (G__8677__i < G__8677__a.length) {G__8677__a[G__8677__i] = arguments[G__8677__i + 3]; ++G__8677__i;}
  args = new cljs.core.IndexedSeq(G__8677__a,0);
} 
return G__8676__delegate.call(this,x,y,z,args);};
G__8676.cljs$lang$maxFixedArity = 3;
G__8676.cljs$lang$applyTo = (function (arglist__8678){
var x = cljs.core.first(arglist__8678);
arglist__8678 = cljs.core.next(arglist__8678);
var y = cljs.core.first(arglist__8678);
arglist__8678 = cljs.core.next(arglist__8678);
var z = cljs.core.first(arglist__8678);
var args = cljs.core.rest(arglist__8678);
return G__8676__delegate(x,y,z,args);
});
G__8676.cljs$core$IFn$_invoke$arity$variadic = G__8676__delegate;
return G__8676;
})()
;
cljs$core$ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep2__0.call(this);
case 1:
return cljs$core$ep2__1.call(this,x);
case 2:
return cljs$core$ep2__2.call(this,x,y);
case 3:
return cljs$core$ep2__3.call(this,x,y,z);
default:
var G__8679 = null;
if (arguments.length > 3) {
var G__8680__i = 0, G__8680__a = new Array(arguments.length -  3);
while (G__8680__i < G__8680__a.length) {G__8680__a[G__8680__i] = arguments[G__8680__i + 3]; ++G__8680__i;}
G__8679 = new cljs.core.IndexedSeq(G__8680__a,0);
}
return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep2.cljs$lang$maxFixedArity = 3;
cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep2;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$ep3 = null;
var cljs$core$ep3__0 = (function (){
return true;
});
var cljs$core$ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__3913__auto__ = (function (){var G__8609 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8609) : p1.call(null,G__8609));
})();
if(cljs.core.truth_(and__3913__auto__)){
var and__3913__auto____$1 = (function (){var G__8611 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8611) : p2.call(null,G__8611));
})();
if(cljs.core.truth_(and__3913__auto____$1)){
var G__8612 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8612) : p3.call(null,G__8612));
} else {
return and__3913__auto____$1;
}
} else {
return and__3913__auto__;
}
})());
});
var cljs$core$ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3913__auto__ = (function (){var G__8614 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8614) : p1.call(null,G__8614));
})();
if(cljs.core.truth_(and__3913__auto__)){
var and__3913__auto____$1 = (function (){var G__8616 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8616) : p2.call(null,G__8616));
})();
if(cljs.core.truth_(and__3913__auto____$1)){
var and__3913__auto____$2 = (function (){var G__8618 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8618) : p3.call(null,G__8618));
})();
if(cljs.core.truth_(and__3913__auto____$2)){
var and__3913__auto____$3 = (function (){var G__8620 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8620) : p1.call(null,G__8620));
})();
if(cljs.core.truth_(and__3913__auto____$3)){
var and__3913__auto____$4 = (function (){var G__8622 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8622) : p2.call(null,G__8622));
})();
if(cljs.core.truth_(and__3913__auto____$4)){
var G__8623 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8623) : p3.call(null,G__8623));
} else {
return and__3913__auto____$4;
}
} else {
return and__3913__auto____$3;
}
} else {
return and__3913__auto____$2;
}
} else {
return and__3913__auto____$1;
}
} else {
return and__3913__auto__;
}
})());
});
var cljs$core$ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3913__auto__ = (function (){var G__8625 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8625) : p1.call(null,G__8625));
})();
if(cljs.core.truth_(and__3913__auto__)){
var and__3913__auto____$1 = (function (){var G__8627 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8627) : p2.call(null,G__8627));
})();
if(cljs.core.truth_(and__3913__auto____$1)){
var and__3913__auto____$2 = (function (){var G__8629 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8629) : p3.call(null,G__8629));
})();
if(cljs.core.truth_(and__3913__auto____$2)){
var and__3913__auto____$3 = (function (){var G__8631 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8631) : p1.call(null,G__8631));
})();
if(cljs.core.truth_(and__3913__auto____$3)){
var and__3913__auto____$4 = (function (){var G__8633 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8633) : p2.call(null,G__8633));
})();
if(cljs.core.truth_(and__3913__auto____$4)){
var and__3913__auto____$5 = (function (){var G__8635 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8635) : p3.call(null,G__8635));
})();
if(cljs.core.truth_(and__3913__auto____$5)){
var and__3913__auto____$6 = (function (){var G__8637 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8637) : p1.call(null,G__8637));
})();
if(cljs.core.truth_(and__3913__auto____$6)){
var and__3913__auto____$7 = (function (){var G__8639 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8639) : p2.call(null,G__8639));
})();
if(cljs.core.truth_(and__3913__auto____$7)){
var G__8640 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8640) : p3.call(null,G__8640));
} else {
return and__3913__auto____$7;
}
} else {
return and__3913__auto____$6;
}
} else {
return and__3913__auto____$5;
}
} else {
return and__3913__auto____$4;
}
} else {
return and__3913__auto____$3;
}
} else {
return and__3913__auto____$2;
}
} else {
return and__3913__auto____$1;
}
} else {
return and__3913__auto__;
}
})());
});
var cljs$core$ep3__4 = (function() { 
var G__8681__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__3913__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__3913__auto__)){
return cljs.core.every_QMARK_(((function (and__3913__auto__){
return (function (p1__8475_SHARP_){
var and__3913__auto____$1 = (function (){var G__8642 = p1__8475_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8642) : p1.call(null,G__8642));
})();
if(cljs.core.truth_(and__3913__auto____$1)){
var and__3913__auto____$2 = (function (){var G__8644 = p1__8475_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8644) : p2.call(null,G__8644));
})();
if(cljs.core.truth_(and__3913__auto____$2)){
var G__8645 = p1__8475_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8645) : p3.call(null,G__8645));
} else {
return and__3913__auto____$2;
}
} else {
return and__3913__auto____$1;
}
});})(and__3913__auto__))
,args);
} else {
return and__3913__auto__;
}
})());
};
var G__8681 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8682__i = 0, G__8682__a = new Array(arguments.length -  3);
while (G__8682__i < G__8682__a.length) {G__8682__a[G__8682__i] = arguments[G__8682__i + 3]; ++G__8682__i;}
  args = new cljs.core.IndexedSeq(G__8682__a,0);
} 
return G__8681__delegate.call(this,x,y,z,args);};
G__8681.cljs$lang$maxFixedArity = 3;
G__8681.cljs$lang$applyTo = (function (arglist__8683){
var x = cljs.core.first(arglist__8683);
arglist__8683 = cljs.core.next(arglist__8683);
var y = cljs.core.first(arglist__8683);
arglist__8683 = cljs.core.next(arglist__8683);
var z = cljs.core.first(arglist__8683);
var args = cljs.core.rest(arglist__8683);
return G__8681__delegate(x,y,z,args);
});
G__8681.cljs$core$IFn$_invoke$arity$variadic = G__8681__delegate;
return G__8681;
})()
;
cljs$core$ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep3__0.call(this);
case 1:
return cljs$core$ep3__1.call(this,x);
case 2:
return cljs$core$ep3__2.call(this,x,y);
case 3:
return cljs$core$ep3__3.call(this,x,y,z);
default:
var G__8684 = null;
if (arguments.length > 3) {
var G__8685__i = 0, G__8685__a = new Array(arguments.length -  3);
while (G__8685__i < G__8685__a.length) {G__8685__a[G__8685__i] = arguments[G__8685__i + 3]; ++G__8685__i;}
G__8684 = new cljs.core.IndexedSeq(G__8685__a,0);
}
return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8684);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep3.cljs$lang$maxFixedArity = 3;
cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep3;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$epn = null;
var cljs$core$epn__0 = (function (){
return true;
});
var cljs$core$epn__1 = (function (x){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__8476_SHARP_){
var G__8661 = x;
return (p1__8476_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8476_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8661) : p1__8476_SHARP_.call(null,G__8661));
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__2 = (function (x,y){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__8477_SHARP_){
var and__3913__auto__ = (function (){var G__8663 = x;
return (p1__8477_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8477_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8663) : p1__8477_SHARP_.call(null,G__8663));
})();
if(cljs.core.truth_(and__3913__auto__)){
var G__8664 = y;
return (p1__8477_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8477_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8664) : p1__8477_SHARP_.call(null,G__8664));
} else {
return and__3913__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__8478_SHARP_){
var and__3913__auto__ = (function (){var G__8666 = x;
return (p1__8478_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8478_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8666) : p1__8478_SHARP_.call(null,G__8666));
})();
if(cljs.core.truth_(and__3913__auto__)){
var and__3913__auto____$1 = (function (){var G__8668 = y;
return (p1__8478_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8478_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8668) : p1__8478_SHARP_.call(null,G__8668));
})();
if(cljs.core.truth_(and__3913__auto____$1)){
var G__8669 = z;
return (p1__8478_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8478_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8669) : p1__8478_SHARP_.call(null,G__8669));
} else {
return and__3913__auto____$1;
}
} else {
return and__3913__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__4 = (function() { 
var G__8686__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__3913__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__3913__auto__)){
return cljs.core.every_QMARK_(((function (and__3913__auto__,ps__$1){
return (function (p1__8479_SHARP_){
return cljs.core.every_QMARK_(p1__8479_SHARP_,args);
});})(and__3913__auto__,ps__$1))
,ps__$1);
} else {
return and__3913__auto__;
}
})());
};
var G__8686 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8687__i = 0, G__8687__a = new Array(arguments.length -  3);
while (G__8687__i < G__8687__a.length) {G__8687__a[G__8687__i] = arguments[G__8687__i + 3]; ++G__8687__i;}
  args = new cljs.core.IndexedSeq(G__8687__a,0);
} 
return G__8686__delegate.call(this,x,y,z,args);};
G__8686.cljs$lang$maxFixedArity = 3;
G__8686.cljs$lang$applyTo = (function (arglist__8688){
var x = cljs.core.first(arglist__8688);
arglist__8688 = cljs.core.next(arglist__8688);
var y = cljs.core.first(arglist__8688);
arglist__8688 = cljs.core.next(arglist__8688);
var z = cljs.core.first(arglist__8688);
var args = cljs.core.rest(arglist__8688);
return G__8686__delegate(x,y,z,args);
});
G__8686.cljs$core$IFn$_invoke$arity$variadic = G__8686__delegate;
return G__8686;
})()
;
cljs$core$epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$epn__0.call(this);
case 1:
return cljs$core$epn__1.call(this,x);
case 2:
return cljs$core$epn__2.call(this,x,y);
case 3:
return cljs$core$epn__3.call(this,x,y,z);
default:
var G__8689 = null;
if (arguments.length > 3) {
var G__8690__i = 0, G__8690__a = new Array(arguments.length -  3);
while (G__8690__i < G__8690__a.length) {G__8690__a[G__8690__i] = arguments[G__8690__i + 3]; ++G__8690__i;}
G__8689 = new cljs.core.IndexedSeq(G__8690__a,0);
}
return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$epn.cljs$lang$maxFixedArity = 3;
cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$epn;
})()
;})(ps__$1))
});

cljs.core.every_pred.cljs$lang$applyTo = (function (seq8480){
var G__8481 = cljs.core.first(seq8480);
var seq8480__$1 = cljs.core.next(seq8480);
var G__8482 = cljs.core.first(seq8480__$1);
var seq8480__$2 = cljs.core.next(seq8480__$1);
var G__8483 = cljs.core.first(seq8480__$2);
var seq8480__$3 = cljs.core.next(seq8480__$2);
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__8481,G__8482,G__8483,seq8480__$3);
});

cljs.core.every_pred.cljs$lang$maxFixedArity = (3);
/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 * returned by one of its composing predicates against any of its arguments, else it returns
 * logical false. Note that f is short-circuiting in that it will stop execution on the first
 * argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(){
var G__8702 = arguments.length;
switch (G__8702) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0)));
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4976__auto__);

}
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$sp1 = null;
var cljs$core$sp1__0 = (function (){
return null;
});
var cljs$core$sp1__1 = (function (x){
var G__8718 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8718) : p.call(null,G__8718));
});
var cljs$core$sp1__2 = (function (x,y){
var or__3925__auto__ = (function (){var G__8720 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8720) : p.call(null,G__8720));
})();
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
var G__8721 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8721) : p.call(null,G__8721));
}
});
var cljs$core$sp1__3 = (function (x,y,z){
var or__3925__auto__ = (function (){var G__8723 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8723) : p.call(null,G__8723));
})();
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (function (){var G__8725 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8725) : p.call(null,G__8725));
})();
if(cljs.core.truth_(or__3925__auto____$1)){
return or__3925__auto____$1;
} else {
var G__8726 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8726) : p.call(null,G__8726));
}
}
});
var cljs$core$sp1__4 = (function() { 
var G__8888__delegate = function (x,y,z,args){
var or__3925__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__8888 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8889__i = 0, G__8889__a = new Array(arguments.length -  3);
while (G__8889__i < G__8889__a.length) {G__8889__a[G__8889__i] = arguments[G__8889__i + 3]; ++G__8889__i;}
  args = new cljs.core.IndexedSeq(G__8889__a,0);
} 
return G__8888__delegate.call(this,x,y,z,args);};
G__8888.cljs$lang$maxFixedArity = 3;
G__8888.cljs$lang$applyTo = (function (arglist__8890){
var x = cljs.core.first(arglist__8890);
arglist__8890 = cljs.core.next(arglist__8890);
var y = cljs.core.first(arglist__8890);
arglist__8890 = cljs.core.next(arglist__8890);
var z = cljs.core.first(arglist__8890);
var args = cljs.core.rest(arglist__8890);
return G__8888__delegate(x,y,z,args);
});
G__8888.cljs$core$IFn$_invoke$arity$variadic = G__8888__delegate;
return G__8888;
})()
;
cljs$core$sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp1__0.call(this);
case 1:
return cljs$core$sp1__1.call(this,x);
case 2:
return cljs$core$sp1__2.call(this,x,y);
case 3:
return cljs$core$sp1__3.call(this,x,y,z);
default:
var G__8891 = null;
if (arguments.length > 3) {
var G__8892__i = 0, G__8892__a = new Array(arguments.length -  3);
while (G__8892__i < G__8892__a.length) {G__8892__a[G__8892__i] = arguments[G__8892__i + 3]; ++G__8892__i;}
G__8891 = new cljs.core.IndexedSeq(G__8892__a,0);
}
return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp1.cljs$lang$maxFixedArity = 3;
cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp1;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$sp2 = null;
var cljs$core$sp2__0 = (function (){
return null;
});
var cljs$core$sp2__1 = (function (x){
var or__3925__auto__ = (function (){var G__8758 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8758) : p1.call(null,G__8758));
})();
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
var G__8759 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8759) : p2.call(null,G__8759));
}
});
var cljs$core$sp2__2 = (function (x,y){
var or__3925__auto__ = (function (){var G__8761 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8761) : p1.call(null,G__8761));
})();
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (function (){var G__8763 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8763) : p1.call(null,G__8763));
})();
if(cljs.core.truth_(or__3925__auto____$1)){
return or__3925__auto____$1;
} else {
var or__3925__auto____$2 = (function (){var G__8765 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8765) : p2.call(null,G__8765));
})();
if(cljs.core.truth_(or__3925__auto____$2)){
return or__3925__auto____$2;
} else {
var G__8766 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8766) : p2.call(null,G__8766));
}
}
}
});
var cljs$core$sp2__3 = (function (x,y,z){
var or__3925__auto__ = (function (){var G__8768 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8768) : p1.call(null,G__8768));
})();
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (function (){var G__8770 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8770) : p1.call(null,G__8770));
})();
if(cljs.core.truth_(or__3925__auto____$1)){
return or__3925__auto____$1;
} else {
var or__3925__auto____$2 = (function (){var G__8772 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8772) : p1.call(null,G__8772));
})();
if(cljs.core.truth_(or__3925__auto____$2)){
return or__3925__auto____$2;
} else {
var or__3925__auto____$3 = (function (){var G__8774 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8774) : p2.call(null,G__8774));
})();
if(cljs.core.truth_(or__3925__auto____$3)){
return or__3925__auto____$3;
} else {
var or__3925__auto____$4 = (function (){var G__8776 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8776) : p2.call(null,G__8776));
})();
if(cljs.core.truth_(or__3925__auto____$4)){
return or__3925__auto____$4;
} else {
var G__8777 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8777) : p2.call(null,G__8777));
}
}
}
}
}
});
var cljs$core$sp2__4 = (function() { 
var G__8893__delegate = function (x,y,z,args){
var or__3925__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return cljs.core.some(((function (or__3925__auto__){
return (function (p1__8691_SHARP_){
var or__3925__auto____$1 = (function (){var G__8779 = p1__8691_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8779) : p1.call(null,G__8779));
})();
if(cljs.core.truth_(or__3925__auto____$1)){
return or__3925__auto____$1;
} else {
var G__8780 = p1__8691_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8780) : p2.call(null,G__8780));
}
});})(or__3925__auto__))
,args);
}
};
var G__8893 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8894__i = 0, G__8894__a = new Array(arguments.length -  3);
while (G__8894__i < G__8894__a.length) {G__8894__a[G__8894__i] = arguments[G__8894__i + 3]; ++G__8894__i;}
  args = new cljs.core.IndexedSeq(G__8894__a,0);
} 
return G__8893__delegate.call(this,x,y,z,args);};
G__8893.cljs$lang$maxFixedArity = 3;
G__8893.cljs$lang$applyTo = (function (arglist__8895){
var x = cljs.core.first(arglist__8895);
arglist__8895 = cljs.core.next(arglist__8895);
var y = cljs.core.first(arglist__8895);
arglist__8895 = cljs.core.next(arglist__8895);
var z = cljs.core.first(arglist__8895);
var args = cljs.core.rest(arglist__8895);
return G__8893__delegate(x,y,z,args);
});
G__8893.cljs$core$IFn$_invoke$arity$variadic = G__8893__delegate;
return G__8893;
})()
;
cljs$core$sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp2__0.call(this);
case 1:
return cljs$core$sp2__1.call(this,x);
case 2:
return cljs$core$sp2__2.call(this,x,y);
case 3:
return cljs$core$sp2__3.call(this,x,y,z);
default:
var G__8896 = null;
if (arguments.length > 3) {
var G__8897__i = 0, G__8897__a = new Array(arguments.length -  3);
while (G__8897__i < G__8897__a.length) {G__8897__a[G__8897__i] = arguments[G__8897__i + 3]; ++G__8897__i;}
G__8896 = new cljs.core.IndexedSeq(G__8897__a,0);
}
return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp2.cljs$lang$maxFixedArity = 3;
cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp2;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$sp3 = null;
var cljs$core$sp3__0 = (function (){
return null;
});
var cljs$core$sp3__1 = (function (x){
var or__3925__auto__ = (function (){var G__8826 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8826) : p1.call(null,G__8826));
})();
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (function (){var G__8828 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8828) : p2.call(null,G__8828));
})();
if(cljs.core.truth_(or__3925__auto____$1)){
return or__3925__auto____$1;
} else {
var G__8829 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8829) : p3.call(null,G__8829));
}
}
});
var cljs$core$sp3__2 = (function (x,y){
var or__3925__auto__ = (function (){var G__8831 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8831) : p1.call(null,G__8831));
})();
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (function (){var G__8833 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8833) : p2.call(null,G__8833));
})();
if(cljs.core.truth_(or__3925__auto____$1)){
return or__3925__auto____$1;
} else {
var or__3925__auto____$2 = (function (){var G__8835 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8835) : p3.call(null,G__8835));
})();
if(cljs.core.truth_(or__3925__auto____$2)){
return or__3925__auto____$2;
} else {
var or__3925__auto____$3 = (function (){var G__8837 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8837) : p1.call(null,G__8837));
})();
if(cljs.core.truth_(or__3925__auto____$3)){
return or__3925__auto____$3;
} else {
var or__3925__auto____$4 = (function (){var G__8839 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8839) : p2.call(null,G__8839));
})();
if(cljs.core.truth_(or__3925__auto____$4)){
return or__3925__auto____$4;
} else {
var G__8840 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8840) : p3.call(null,G__8840));
}
}
}
}
}
});
var cljs$core$sp3__3 = (function (x,y,z){
var or__3925__auto__ = (function (){var G__8842 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8842) : p1.call(null,G__8842));
})();
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (function (){var G__8844 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8844) : p2.call(null,G__8844));
})();
if(cljs.core.truth_(or__3925__auto____$1)){
return or__3925__auto____$1;
} else {
var or__3925__auto____$2 = (function (){var G__8846 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8846) : p3.call(null,G__8846));
})();
if(cljs.core.truth_(or__3925__auto____$2)){
return or__3925__auto____$2;
} else {
var or__3925__auto____$3 = (function (){var G__8848 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8848) : p1.call(null,G__8848));
})();
if(cljs.core.truth_(or__3925__auto____$3)){
return or__3925__auto____$3;
} else {
var or__3925__auto____$4 = (function (){var G__8850 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8850) : p2.call(null,G__8850));
})();
if(cljs.core.truth_(or__3925__auto____$4)){
return or__3925__auto____$4;
} else {
var or__3925__auto____$5 = (function (){var G__8852 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8852) : p3.call(null,G__8852));
})();
if(cljs.core.truth_(or__3925__auto____$5)){
return or__3925__auto____$5;
} else {
var or__3925__auto____$6 = (function (){var G__8854 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8854) : p1.call(null,G__8854));
})();
if(cljs.core.truth_(or__3925__auto____$6)){
return or__3925__auto____$6;
} else {
var or__3925__auto____$7 = (function (){var G__8856 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8856) : p2.call(null,G__8856));
})();
if(cljs.core.truth_(or__3925__auto____$7)){
return or__3925__auto____$7;
} else {
var G__8857 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8857) : p3.call(null,G__8857));
}
}
}
}
}
}
}
}
});
var cljs$core$sp3__4 = (function() { 
var G__8898__delegate = function (x,y,z,args){
var or__3925__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return cljs.core.some(((function (or__3925__auto__){
return (function (p1__8692_SHARP_){
var or__3925__auto____$1 = (function (){var G__8859 = p1__8692_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8859) : p1.call(null,G__8859));
})();
if(cljs.core.truth_(or__3925__auto____$1)){
return or__3925__auto____$1;
} else {
var or__3925__auto____$2 = (function (){var G__8861 = p1__8692_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8861) : p2.call(null,G__8861));
})();
if(cljs.core.truth_(or__3925__auto____$2)){
return or__3925__auto____$2;
} else {
var G__8862 = p1__8692_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8862) : p3.call(null,G__8862));
}
}
});})(or__3925__auto__))
,args);
}
};
var G__8898 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8899__i = 0, G__8899__a = new Array(arguments.length -  3);
while (G__8899__i < G__8899__a.length) {G__8899__a[G__8899__i] = arguments[G__8899__i + 3]; ++G__8899__i;}
  args = new cljs.core.IndexedSeq(G__8899__a,0);
} 
return G__8898__delegate.call(this,x,y,z,args);};
G__8898.cljs$lang$maxFixedArity = 3;
G__8898.cljs$lang$applyTo = (function (arglist__8900){
var x = cljs.core.first(arglist__8900);
arglist__8900 = cljs.core.next(arglist__8900);
var y = cljs.core.first(arglist__8900);
arglist__8900 = cljs.core.next(arglist__8900);
var z = cljs.core.first(arglist__8900);
var args = cljs.core.rest(arglist__8900);
return G__8898__delegate(x,y,z,args);
});
G__8898.cljs$core$IFn$_invoke$arity$variadic = G__8898__delegate;
return G__8898;
})()
;
cljs$core$sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp3__0.call(this);
case 1:
return cljs$core$sp3__1.call(this,x);
case 2:
return cljs$core$sp3__2.call(this,x,y);
case 3:
return cljs$core$sp3__3.call(this,x,y,z);
default:
var G__8901 = null;
if (arguments.length > 3) {
var G__8902__i = 0, G__8902__a = new Array(arguments.length -  3);
while (G__8902__i < G__8902__a.length) {G__8902__a[G__8902__i] = arguments[G__8902__i + 3]; ++G__8902__i;}
G__8901 = new cljs.core.IndexedSeq(G__8902__a,0);
}
return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp3.cljs$lang$maxFixedArity = 3;
cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp3;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$spn = null;
var cljs$core$spn__0 = (function (){
return null;
});
var cljs$core$spn__1 = (function (x){
return cljs.core.some(((function (ps__$1){
return (function (p1__8693_SHARP_){
var G__8878 = x;
return (p1__8693_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8693_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8878) : p1__8693_SHARP_.call(null,G__8878));
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__2 = (function (x,y){
return cljs.core.some(((function (ps__$1){
return (function (p1__8694_SHARP_){
var or__3925__auto__ = (function (){var G__8880 = x;
return (p1__8694_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8694_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8880) : p1__8694_SHARP_.call(null,G__8880));
})();
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
var G__8881 = y;
return (p1__8694_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8694_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8881) : p1__8694_SHARP_.call(null,G__8881));
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__3 = (function (x,y,z){
return cljs.core.some(((function (ps__$1){
return (function (p1__8695_SHARP_){
var or__3925__auto__ = (function (){var G__8883 = x;
return (p1__8695_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8695_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8883) : p1__8695_SHARP_.call(null,G__8883));
})();
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (function (){var G__8885 = y;
return (p1__8695_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8695_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8885) : p1__8695_SHARP_.call(null,G__8885));
})();
if(cljs.core.truth_(or__3925__auto____$1)){
return or__3925__auto____$1;
} else {
var G__8886 = z;
return (p1__8695_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8695_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8886) : p1__8695_SHARP_.call(null,G__8886));
}
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__4 = (function() { 
var G__8903__delegate = function (x,y,z,args){
var or__3925__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return cljs.core.some(((function (or__3925__auto__,ps__$1){
return (function (p1__8696_SHARP_){
return cljs.core.some(p1__8696_SHARP_,args);
});})(or__3925__auto__,ps__$1))
,ps__$1);
}
};
var G__8903 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8904__i = 0, G__8904__a = new Array(arguments.length -  3);
while (G__8904__i < G__8904__a.length) {G__8904__a[G__8904__i] = arguments[G__8904__i + 3]; ++G__8904__i;}
  args = new cljs.core.IndexedSeq(G__8904__a,0);
} 
return G__8903__delegate.call(this,x,y,z,args);};
G__8903.cljs$lang$maxFixedArity = 3;
G__8903.cljs$lang$applyTo = (function (arglist__8905){
var x = cljs.core.first(arglist__8905);
arglist__8905 = cljs.core.next(arglist__8905);
var y = cljs.core.first(arglist__8905);
arglist__8905 = cljs.core.next(arglist__8905);
var z = cljs.core.first(arglist__8905);
var args = cljs.core.rest(arglist__8905);
return G__8903__delegate(x,y,z,args);
});
G__8903.cljs$core$IFn$_invoke$arity$variadic = G__8903__delegate;
return G__8903;
})()
;
cljs$core$spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$spn__0.call(this);
case 1:
return cljs$core$spn__1.call(this,x);
case 2:
return cljs$core$spn__2.call(this,x,y);
case 3:
return cljs$core$spn__3.call(this,x,y,z);
default:
var G__8906 = null;
if (arguments.length > 3) {
var G__8907__i = 0, G__8907__a = new Array(arguments.length -  3);
while (G__8907__i < G__8907__a.length) {G__8907__a[G__8907__i] = arguments[G__8907__i + 3]; ++G__8907__i;}
G__8906 = new cljs.core.IndexedSeq(G__8907__a,0);
}
return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$spn.cljs$lang$maxFixedArity = 3;
cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$spn;
})()
;})(ps__$1))
});

cljs.core.some_fn.cljs$lang$applyTo = (function (seq8697){
var G__8698 = cljs.core.first(seq8697);
var seq8697__$1 = cljs.core.next(seq8697);
var G__8699 = cljs.core.first(seq8697__$1);
var seq8697__$2 = cljs.core.next(seq8697__$1);
var G__8700 = cljs.core.first(seq8697__$2);
var seq8697__$3 = cljs.core.next(seq8697__$2);
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__8698,G__8699,G__8700,seq8697__$3);
});

cljs.core.some_fn.cljs$lang$maxFixedArity = (3);
/**
 * Returns a lazy sequence consisting of the result of applying f to
 * the set of first items of each coll, followed by applying f to the
 * set of second items in each coll, until any one of the colls is
 * exhausted.  Any remaining items in other colls are ignored. Function
 * f should accept number-of-colls arguments. Returns a transducer when
 * no collection is provided.
 */
cljs.core.map = (function cljs$core$map(){
var G__8915 = arguments.length;
switch (G__8915) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(4)),(0)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4976__auto__);

}
});

cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__8931 = null;
var G__8931__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8931__1 = (function (result){
var G__8916 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8916) : rf.call(null,G__8916));
});
var G__8931__2 = (function (result,input){
var G__8917 = result;
var G__8918 = (function (){var G__8919 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8919) : f.call(null,G__8919));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8917,G__8918) : rf.call(null,G__8917,G__8918));
});
var G__8931__3 = (function() { 
var G__8932__delegate = function (result,input,inputs){
var G__8920 = result;
var G__8921 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8920,G__8921) : rf.call(null,G__8920,G__8921));
};
var G__8932 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__8933__i = 0, G__8933__a = new Array(arguments.length -  2);
while (G__8933__i < G__8933__a.length) {G__8933__a[G__8933__i] = arguments[G__8933__i + 2]; ++G__8933__i;}
  inputs = new cljs.core.IndexedSeq(G__8933__a,0);
} 
return G__8932__delegate.call(this,result,input,inputs);};
G__8932.cljs$lang$maxFixedArity = 2;
G__8932.cljs$lang$applyTo = (function (arglist__8934){
var result = cljs.core.first(arglist__8934);
arglist__8934 = cljs.core.next(arglist__8934);
var input = cljs.core.first(arglist__8934);
var inputs = cljs.core.rest(arglist__8934);
return G__8932__delegate(result,input,inputs);
});
G__8932.cljs$core$IFn$_invoke$arity$variadic = G__8932__delegate;
return G__8932;
})()
;
G__8931 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__8931__0.call(this);
case 1:
return G__8931__1.call(this,result);
case 2:
return G__8931__2.call(this,result,input);
default:
var G__8935 = null;
if (arguments.length > 2) {
var G__8936__i = 0, G__8936__a = new Array(arguments.length -  2);
while (G__8936__i < G__8936__a.length) {G__8936__a[G__8936__i] = arguments[G__8936__i + 2]; ++G__8936__i;}
G__8935 = new cljs.core.IndexedSeq(G__8936__a,0);
}
return G__8931__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__8935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8931.cljs$lang$maxFixedArity = 2;
G__8931.cljs$lang$applyTo = G__8931__3.cljs$lang$applyTo;
G__8931.cljs$core$IFn$_invoke$arity$0 = G__8931__0;
G__8931.cljs$core$IFn$_invoke$arity$1 = G__8931__1;
G__8931.cljs$core$IFn$_invoke$arity$2 = G__8931__2;
G__8931.cljs$core$IFn$_invoke$arity$variadic = G__8931__3.cljs$core$IFn$_invoke$arity$variadic;
return G__8931;
})()
});
});

cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4423__auto__ = cljs.core.seq(coll);
if(temp__4423__auto__){
var s = temp__4423__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4810__auto___8937 = size;
var i_8938 = (0);
while(true){
if((i_8938 < n__4810__auto___8937)){
cljs.core.chunk_append(b,(function (){var G__8922 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8938);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8922) : f.call(null,G__8922));
})());

var G__8939 = (i_8938 + (1));
i_8938 = G__8939;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__8923 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8923) : f.call(null,G__8923));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons((function (){var G__8924 = cljs.core.first(s1);
var G__8925 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8924,G__8925) : f.call(null,G__8924,G__8925));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if((s1) && (s2) && (s3)){
return cljs.core.cons((function (){var G__8926 = cljs.core.first(s1);
var G__8927 = cljs.core.first(s2);
var G__8928 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8926,G__8927,G__8928) : f.call(null,G__8926,G__8927,G__8928));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
var step = (function cljs$core$step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (step){
return (function (p1__8908_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__8908_SHARP_);
});})(step))
,step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.array_seq([c2,c1], 0))));
});

cljs.core.map.cljs$lang$applyTo = (function (seq8909){
var G__8910 = cljs.core.first(seq8909);
var seq8909__$1 = cljs.core.next(seq8909);
var G__8911 = cljs.core.first(seq8909__$1);
var seq8909__$2 = cljs.core.next(seq8909__$1);
var G__8912 = cljs.core.first(seq8909__$2);
var seq8909__$3 = cljs.core.next(seq8909__$2);
var G__8913 = cljs.core.first(seq8909__$3);
var seq8909__$4 = cljs.core.next(seq8909__$3);
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__8910,G__8911,G__8912,G__8913,seq8909__$4);
});

cljs.core.map.cljs$lang$maxFixedArity = (4);
/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 * there are fewer than n.  Returns a stateful transducer when
 * no collection is provided.
 */
cljs.core.take = (function cljs$core$take(){
var G__8941 = arguments.length;
switch (G__8941) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__8946 = null;
var G__8946__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8946__1 = (function (result){
var G__8942 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8942) : rf.call(null,G__8942));
});
var G__8946__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));
var result__$1 = (((n__$1 > (0)))?(function (){var G__8943 = result;
var G__8944 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8943,G__8944) : rf.call(null,G__8943,G__8944));
})():result);
if(!((nn > (0)))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__8946 = function(result,input){
switch(arguments.length){
case 0:
return G__8946__0.call(this);
case 1:
return G__8946__1.call(this,result);
case 2:
return G__8946__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8946.cljs$core$IFn$_invoke$arity$0 = G__8946__0;
G__8946.cljs$core$IFn$_invoke$arity$1 = G__8946__1;
G__8946.cljs$core$IFn$_invoke$arity$2 = G__8946__2;
return G__8946;
})()
;})(na))
});
});

cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__4423__auto__ = cljs.core.seq(coll);
if(temp__4423__auto__){
var s = temp__4423__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of all but the first n items in coll.
 * Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(){
var G__8948 = arguments.length;
switch (G__8948) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__8953 = null;
var G__8953__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8953__1 = (function (result){
var G__8949 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8949) : rf.call(null,G__8949));
});
var G__8953__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));

if((n__$1 > (0))){
return result;
} else {
var G__8950 = result;
var G__8951 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8950,G__8951) : rf.call(null,G__8950,G__8951));
}
});
G__8953 = function(result,input){
switch(arguments.length){
case 0:
return G__8953__0.call(this);
case 1:
return G__8953__1.call(this,result);
case 2:
return G__8953__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8953.cljs$core$IFn$_invoke$arity$0 = G__8953__0;
G__8953.cljs$core$IFn$_invoke$arity$1 = G__8953__1;
G__8953.cljs$core$IFn$_invoke$arity$2 = G__8953__2;
return G__8953;
})()
;})(na))
});
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(((n__$1 > (0))) && (s)){
var G__8954 = (n__$1 - (1));
var G__8955 = cljs.core.rest(s);
n__$1 = G__8954;
coll__$1 = G__8955;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(n,coll);
});})(step))
,null,null));
});

cljs.core.drop.cljs$lang$maxFixedArity = 2;
/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(){
var G__8957 = arguments.length;
switch (G__8957) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});

cljs.core.drop_last.cljs$lang$maxFixedArity = 2;
/**
 * Returns a seq of the last n items in coll.  Depending on the type
 * of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__8959 = cljs.core.next(s);
var G__8960 = cljs.core.next(lead);
s = G__8959;
lead = G__8960;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 * first item for which (pred item) returns logical false.  Returns a
 * stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(){
var G__8962 = arguments.length;
switch (G__8962) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return ((function (da){
return (function() {
var G__8970 = null;
var G__8970__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8970__1 = (function (result){
var G__8963 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8963) : rf.call(null,G__8963));
});
var G__8970__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__3913__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__3913__auto__)){
var G__8964 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8964) : pred.call(null,G__8964));
} else {
return and__3913__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

var G__8965 = result;
var G__8966 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8965,G__8966) : rf.call(null,G__8965,G__8966));
}
});
G__8970 = function(result,input){
switch(arguments.length){
case 0:
return G__8970__0.call(this);
case 1:
return G__8970__1.call(this,result);
case 2:
return G__8970__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8970.cljs$core$IFn$_invoke$arity$0 = G__8970__0;
G__8970.cljs$core$IFn$_invoke$arity$1 = G__8970__1;
G__8970.cljs$core$IFn$_invoke$arity$2 = G__8970__2;
return G__8970;
})()
;})(da))
});
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__3913__auto__ = s;
if(and__3913__auto__){
var G__8968 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__8968) : pred__$1.call(null,G__8968));
} else {
return and__3913__auto__;
}
})())){
var G__8971 = pred__$1;
var G__8972 = cljs.core.rest(s);
pred__$1 = G__8971;
coll__$1 = G__8972;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(pred,coll);
});})(step))
,null,null));
});

cljs.core.drop_while.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4423__auto__ = cljs.core.seq(coll);
if(temp__4423__auto__){
var s = temp__4423__auto__;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s,cljs$core$cycle(s));
} else {
return null;
}
}),null,null));
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});
/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(){
var G__8975 = arguments.length;
switch (G__8975) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(x,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
}),null,null));
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function (n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});

cljs.core.repeat.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 * returns an infinite (or length n if supplied) lazy sequence of calls
 * to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(){
var G__8978 = arguments.length;
switch (G__8978) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
});

cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return cljs.core.cons(x,(new cljs.core.LazySeq(null,(function (){
return cljs$core$iterate(f,(function (){var G__8983 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8983) : f.call(null,G__8983));
})());
}),null,null)));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(){
var G__8988 = arguments.length;
switch (G__8988) {
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4976__auto__);

}
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$lang$applyTo = (function (seq8984){
var G__8985 = cljs.core.first(seq8984);
var seq8984__$1 = cljs.core.next(seq8984);
var G__8986 = cljs.core.first(seq8984__$1);
var seq8984__$2 = cljs.core.next(seq8984__$1);
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__8985,G__8986,seq8984__$2);
});

cljs.core.interleave.cljs$lang$maxFixedArity = (2);
/**
 * Returns a lazy seq of the elements of coll separated by sep
 */
cljs.core.interpose = (function cljs$core$interpose(){
var G__8991 = arguments.length;
switch (G__8991) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return ((function (started){
return (function() {
var G__9000 = null;
var G__9000__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9000__1 = (function (result){
var G__8992 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8992) : rf.call(null,G__8992));
});
var G__9000__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (function (){var G__8993 = result;
var G__8994 = sep;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8993,G__8994) : rf.call(null,G__8993,G__8994));
})();
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
var G__8995 = sepr;
var G__8996 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8995,G__8996) : rf.call(null,G__8995,G__8996));
}
} else {
cljs.core.vreset_BANG_(started,true);

var G__8997 = result;
var G__8998 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8997,G__8998) : rf.call(null,G__8997,G__8998));
}
});
G__9000 = function(result,input){
switch(arguments.length){
case 0:
return G__9000__0.call(this);
case 1:
return G__9000__1.call(this,result);
case 2:
return G__9000__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9000.cljs$core$IFn$_invoke$arity$0 = G__9000__0;
G__9000.cljs$core$IFn$_invoke$arity$1 = G__9000__1;
G__9000.cljs$core$IFn$_invoke$arity$2 = G__9000__2;
return G__9000;
})()
;})(started))
});
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
});

cljs.core.interpose.cljs$lang$maxFixedArity = 2;
/**
 * Take a collection of collections, and return a lazy seq
 * of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4421__auto__ = cljs.core.seq(coll);
if(temp__4421__auto__){
var coll__$1 = temp__4421__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 * to f and colls.  Thus function f should return a collection. Returns
 * a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(){
var G__9012 = arguments.length;
switch (G__9012) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0)));
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4976__auto__);

}
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
});

cljs.core.mapcat.cljs$lang$applyTo = (function (seq9009){
var G__9010 = cljs.core.first(seq9009);
var seq9009__$1 = cljs.core.next(seq9009);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__9010,seq9009__$1);
});

cljs.core.mapcat.cljs$lang$maxFixedArity = (1);
/**
 * Returns a lazy sequence of the items in coll for which
 * (pred item) returns true. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(){
var G__9015 = arguments.length;
switch (G__9015) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__9023 = null;
var G__9023__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9023__1 = (function (result){
var G__9016 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9016) : rf.call(null,G__9016));
});
var G__9023__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__9017 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9017) : pred.call(null,G__9017));
})())){
var G__9018 = result;
var G__9019 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9018,G__9019) : rf.call(null,G__9018,G__9019));
} else {
return result;
}
});
G__9023 = function(result,input){
switch(arguments.length){
case 0:
return G__9023__0.call(this);
case 1:
return G__9023__1.call(this,result);
case 2:
return G__9023__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9023.cljs$core$IFn$_invoke$arity$0 = G__9023__0;
G__9023.cljs$core$IFn$_invoke$arity$1 = G__9023__1;
G__9023.cljs$core$IFn$_invoke$arity$2 = G__9023__2;
return G__9023;
})()
});
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4423__auto__ = cljs.core.seq(coll);
if(temp__4423__auto__){
var s = temp__4423__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4810__auto___9024 = size;
var i_9025 = (0);
while(true){
if((i_9025 < n__4810__auto___9024)){
if(cljs.core.truth_((function (){var G__9020 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_9025);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9020) : pred.call(null,G__9020));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_9025));
} else {
}

var G__9026 = (i_9025 + (1));
i_9025 = G__9026;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((function (){var G__9021 = f;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9021) : pred.call(null,G__9021));
})())){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.filter.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the items in coll for which
 * (pred item) returns false. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(){
var G__9028 = arguments.length;
switch (G__9028) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
});

cljs.core.remove.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 * branch? must be a fn of one arg that returns true if passed a node
 * that can have children (but may not).  children must be a fn of one
 * arg that returns a sequence of the children. Will only be called on
 * nodes for which branch? returns true. Root is the root node of the
 * tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((function (){var G__9036 = node;
return (branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(G__9036) : branch_QMARK_.call(null,G__9036));
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.array_seq([(function (){var G__9037 = node;
return (children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(G__9037) : children.call(null,G__9037));
})()], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 * etc.) and returns their contents as a single, flat sequence.
 * (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__9038_SHARP_){
return !(cljs.core.sequential_QMARK_(p1__9038_SHARP_));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 * from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(){
var G__9040 = arguments.length;
switch (G__9040) {
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
if(!((to == null))){
if((function (){var G__9041 = to;
if(G__9041){
var bit__4592__auto__ = (G__9041.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4592__auto__) || (G__9041.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,from);
}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function (to,xform,from){
if((function (){var G__9042 = to;
if(G__9042){
var bit__4592__auto__ = (G__9042.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4592__auto__) || (G__9042.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
});

cljs.core.into.cljs$lang$maxFixedArity = 3;
/**
 * Returns a vector consisting of the result of applying f to the
 * set of first items of each coll, followed by applying f to the set
 * of second items in each coll, until any one of the colls is
 * exhausted.  Any remaining items in other colls are ignored. Function
 * f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(){
var G__9050 = arguments.length;
switch (G__9050) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(4)),(0)));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4976__auto__);

}
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(function (){var G__9051 = o;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9051) : f.call(null,G__9051));
})());
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.array_seq([colls], 0)));
});

cljs.core.mapv.cljs$lang$applyTo = (function (seq9044){
var G__9045 = cljs.core.first(seq9044);
var seq9044__$1 = cljs.core.next(seq9044);
var G__9046 = cljs.core.first(seq9044__$1);
var seq9044__$2 = cljs.core.next(seq9044__$1);
var G__9047 = cljs.core.first(seq9044__$2);
var seq9044__$3 = cljs.core.next(seq9044__$2);
var G__9048 = cljs.core.first(seq9044__$3);
var seq9044__$4 = cljs.core.next(seq9044__$3);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__9045,G__9046,G__9047,G__9048,seq9044__$4);
});

cljs.core.mapv.cljs$lang$maxFixedArity = (4);
/**
 * Returns a vector of the items in coll for which
 * (pred item) returns true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((function (){var G__9054 = o;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9054) : pred.call(null,G__9054));
})())){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 * apart. If step is not supplied, defaults to n, i.e. the partitions
 * do not overlap. If a pad collection is supplied, use its elements as
 * necessary to complete last partition up to n items. In case there are
 * not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(){
var G__9056 = arguments.length;
switch (G__9056) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4423__auto__ = cljs.core.seq(coll);
if(temp__4423__auto__){
var s = temp__4423__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4423__auto__ = cljs.core.seq(coll);
if(temp__4423__auto__){
var s = temp__4423__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)));
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$lang$maxFixedArity = 4;
/**
 * Returns the value in a nested associative structure,
 * where ks is a sequence of keys. Returns nil if the key is not present,
 * or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(){
var G__9059 = arguments.length;
switch (G__9059) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function (m,ks){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(m,ks,null);
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if(ks__$1){
if(!((function (){var G__9060 = m__$1;
if(G__9060){
var bit__4599__auto__ = (G__9060.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4599__auto__) || (G__9060.cljs$core$ILookup$)){
return true;
} else {
if((!G__9060.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__9060);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__9060);
}
})())){
return not_found;
} else {
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__9062 = sentinel;
var G__9063 = m__$2;
var G__9064 = cljs.core.next(ks__$1);
sentinel = G__9062;
m__$1 = G__9063;
ks__$1 = G__9064;
continue;
}
}
} else {
return m__$1;
}
break;
}
});

cljs.core.get_in.cljs$lang$maxFixedArity = 3;
/**
 * Associates a value in a nested associative structure, where ks is a
 * sequence of keys and v is the new value and returns a new nested structure.
 * If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__9065,v){
var vec__9070 = p__9065;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9070,(0),null);
var ks = cljs.core.nthnext(vec__9070,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,v));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 * sequence of keys and f is a function that will take the old value
 * and any supplied args and return the new value, and returns a new
 * nested structure.  If any levels do not exist, hash-maps will be
 * created.
 */
cljs.core.update_in = (function cljs$core$update_in(){
var G__9079 = arguments.length;
switch (G__9079) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(6)),(0)));
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__4976__auto__);

}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function (m,p__9080,f){
var vec__9081 = p__9080;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9081,(0),null);
var ks = cljs.core.nthnext(vec__9081,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9082 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9082) : f.call(null,G__9082));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function (m,p__9083,f,a){
var vec__9084 = p__9083;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9084,(0),null);
var ks = cljs.core.nthnext(vec__9084,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9085 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9086 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9085,G__9086) : f.call(null,G__9085,G__9086));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function (m,p__9087,f,a,b){
var vec__9088 = p__9087;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9088,(0),null);
var ks = cljs.core.nthnext(vec__9088,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9089 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9090 = a;
var G__9091 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9089,G__9090,G__9091) : f.call(null,G__9089,G__9090,G__9091));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function (m,p__9092,f,a,b,c){
var vec__9093 = p__9092;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9093,(0),null);
var ks = cljs.core.nthnext(vec__9093,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9094 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9095 = a;
var G__9096 = b;
var G__9097 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9094,G__9095,G__9096,G__9097) : f.call(null,G__9094,G__9095,G__9096,G__9097));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__9098,f,a,b,c,args){
var vec__9099 = p__9098;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9099,(0),null);
var ks = cljs.core.nthnext(vec__9099,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.array_seq([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.array_seq([args], 0)));
}
});

cljs.core.update_in.cljs$lang$applyTo = (function (seq9071){
var G__9072 = cljs.core.first(seq9071);
var seq9071__$1 = cljs.core.next(seq9071);
var G__9073 = cljs.core.first(seq9071__$1);
var seq9071__$2 = cljs.core.next(seq9071__$1);
var G__9074 = cljs.core.first(seq9071__$2);
var seq9071__$3 = cljs.core.next(seq9071__$2);
var G__9075 = cljs.core.first(seq9071__$3);
var seq9071__$4 = cljs.core.next(seq9071__$3);
var G__9076 = cljs.core.first(seq9071__$4);
var seq9071__$5 = cljs.core.next(seq9071__$4);
var G__9077 = cljs.core.first(seq9071__$5);
var seq9071__$6 = cljs.core.next(seq9071__$5);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__9072,G__9073,G__9074,G__9075,G__9076,G__9077,seq9071__$6);
});

cljs.core.update_in.cljs$lang$maxFixedArity = (6);
/**
 * 'Updates' a value in an associative structure, where k is a
 * key and f is a function that will take the old value
 * and any supplied args and return the new value, and returns a new
 * structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(){
var G__9109 = arguments.length;
switch (G__9109) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(6)),(0)));
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__4976__auto__);

}
});

cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9110 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9110) : f.call(null,G__9110));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9111 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9112 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9111,G__9112) : f.call(null,G__9111,G__9112));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9113 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9114 = x;
var G__9115 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9113,G__9114,G__9115) : f.call(null,G__9113,G__9114,G__9115));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9116 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9117 = x;
var G__9118 = y;
var G__9119 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9116,G__9117,G__9118,G__9119) : f.call(null,G__9116,G__9117,G__9118,G__9119));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.array_seq([more], 0)));
});

cljs.core.update.cljs$lang$applyTo = (function (seq9101){
var G__9102 = cljs.core.first(seq9101);
var seq9101__$1 = cljs.core.next(seq9101);
var G__9103 = cljs.core.first(seq9101__$1);
var seq9101__$2 = cljs.core.next(seq9101__$1);
var G__9104 = cljs.core.first(seq9101__$2);
var seq9101__$3 = cljs.core.next(seq9101__$2);
var G__9105 = cljs.core.first(seq9101__$3);
var seq9101__$4 = cljs.core.next(seq9101__$3);
var G__9106 = cljs.core.first(seq9101__$4);
var seq9101__$5 = cljs.core.next(seq9101__$4);
var G__9107 = cljs.core.first(seq9101__$5);
var seq9101__$6 = cljs.core.next(seq9101__$5);
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__9102,G__9103,G__9104,G__9105,G__9106,G__9107,seq9101__$6);
});

cljs.core.update.cljs$lang$maxFixedArity = (6);

/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
})

cljs.core.VectorNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
});

cljs.core.VectorNode.cljs$lang$type = true;

cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";

cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/VectorNode");
});

cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__9121 = (ll - (5));
var G__9122 = r;
ll = G__9121;
ret = G__9122;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if(!((child == null))){
var node_to_insert = cljs$core$push_tail(pv,(level - (5)),child,tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error([cljs.core.str("No item "),cljs.core.str(i),cljs.core.str(" in vector of length "),cljs.core.str(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__9127 = cljs.core.pv_aget(node,(0));
var G__9128 = (level - (5));
node = G__9127;
level = G__9128;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__9129 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__9130 = (level - (5));
node = G__9129;
level = G__9130;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if((((0) <= i)) && ((i < pv.cnt))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,cljs$core$do_assoc(pv,(level - (5)),cljs.core.pv_aget(node,subidx),i,val));

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$pop_tail(pv,(level - (5)),cljs.core.pv_aget(node,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
})
cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
});

cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i);

self__.base = (self__.base + (32));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.RangedIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"base","base",1825810849,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
});

cljs.core.RangedIterator.cljs$lang$type = true;

cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";

cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/RangedIterator");
});

cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});







/**
* @constructor
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167668511;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__9140 = init__$2;
var G__9141 = (j + i);
var G__9142 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9140,G__9141,G__9142) : f.call(null,G__9140,G__9141,G__9142));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__9153 = (j + (1));
var G__9154 = init__$3;
j = G__9153;
init__$2 = G__9154;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9143 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9143) : cljs.core.deref.call(null,G__9143));
} else {
var G__9155 = (i + len);
var G__9156 = init__$2;
i = G__9155;
init__$1 = G__9156;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return cljs.core._conj(coll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds  [0,"),cljs.core.str(self__.cnt),cljs.core.str("]")].join('')));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(0));
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(1));
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(self__.cnt - (1)));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = cljs.core._iterator(coll__$1);
var you_iter = cljs.core._iterator(other);
while(true){
if(cljs.core.truth_(me_iter.hasNext())){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(function (){var G__9144 = self__.root;
return (cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(G__9144) : cljs.core.tv_editable_root.call(null,G__9144));
})(),(function (){var G__9145 = self__.tail;
return (cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(G__9145) : cljs.core.tv_editable_tail.call(null,G__9145));
})()));
});

cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1,f);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__9146 = init__$2;
var G__9147 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9146,G__9147) : f.call(null,G__9146,G__9147));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__9157 = (j + (1));
var G__9158 = init__$3;
j = G__9157;
init__$2 = G__9158;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9148 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9148) : cljs.core.deref.call(null,G__9148));
} else {
var G__9159 = (i + len);
var G__9160 = init__$2;
i = G__9159;
init__$1 = G__9160;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._assoc_n(coll__$1,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
});

cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0)));
} else {
var G__9149 = coll__$1;
var G__9150 = cljs.core.first_array_for_longvec(coll__$1);
var G__9151 = (0);
var G__9152 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9149,G__9150,G__9151,G__9152) : cljs.core.chunked_seq.call(null,G__9149,G__9150,G__9151,G__9152));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentVector(meta__$1,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__4810__auto___9161 = len;
var i_9162 = (0);
while(true){
if((i_9162 < n__4810__auto___9161)){
(new_tail[i_9162] = (self__.tail[i_9162]));

var G__9163 = (i_9162 + (1));
i_9162 = G__9163;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
});

cljs.core.PersistentVector.prototype.call = (function() {
var G__9164 = null;
var G__9164__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__9164__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__9164 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9164__2.call(this,self__,k);
case 3:
return G__9164__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9164.cljs$core$IFn$_invoke$arity$2 = G__9164__2;
G__9164.cljs$core$IFn$_invoke$arity$3 = G__9164__3;
return G__9164;
})()
;

cljs.core.PersistentVector.prototype.apply = (function (self__,args9139){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9139)));
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.PersistentVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"tail","tail",494507963,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.PersistentVector.cljs$lang$type = true;

cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";

cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/PersistentVector");
});

cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__9165 = (i + (1));
var G__9166 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__9165;
out = G__9166;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 * will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0)))){
return cljs.core.PersistentVector.fromArray(args.arr,true);
} else {
return cljs.core.vec(args);
}
});

cljs.core.vector.cljs$lang$maxFixedArity = (0);

cljs.core.vector.cljs$lang$applyTo = (function (seq9167){
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9167));
});

/**
* @constructor
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__9168 = self__.vec;
var G__9169 = self__.node;
var G__9170 = self__.i;
var G__9171 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9168,G__9169,G__9170,G__9171) : cljs.core.chunked_seq.call(null,G__9168,G__9169,G__9170,G__9171));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return cljs.core._chunked_next(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((function (){var G__9172 = self__.vec;
var G__9173 = (self__.i + self__.off);
var G__9174 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__9172,G__9173,G__9174) : cljs.core.subvec.call(null,G__9172,G__9173,G__9174));
})(),f);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((function (){var G__9175 = self__.vec;
var G__9176 = (self__.i + self__.off);
var G__9177 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__9175,G__9176,G__9177) : cljs.core.subvec.call(null,G__9175,G__9176,G__9177));
})(),f,start);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__9178 = self__.vec;
var G__9179 = self__.node;
var G__9180 = self__.i;
var G__9181 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9178,G__9179,G__9180,G__9181) : cljs.core.chunked_seq.call(null,G__9178,G__9179,G__9180,G__9181));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return cljs.core._chunked_rest(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__9182 = self__.vec;
var G__9183 = cljs.core.unchecked_array_for(self__.vec,end);
var G__9184 = end;
var G__9185 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9182,G__9183,G__9184,G__9185) : cljs.core.chunked_seq.call(null,G__9182,G__9183,G__9184,G__9185));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
var G__9186 = self__.vec;
var G__9187 = self__.node;
var G__9188 = self__.i;
var G__9189 = self__.off;
var G__9190 = m;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(G__9186,G__9187,G__9188,G__9189,G__9190) : cljs.core.chunked_seq.call(null,G__9186,G__9187,G__9188,G__9189,G__9190));
});

cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__9191 = self__.vec;
var G__9192 = cljs.core.unchecked_array_for(self__.vec,end);
var G__9193 = end;
var G__9194 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9191,G__9192,G__9193,G__9194) : cljs.core.chunked_seq.call(null,G__9191,G__9192,G__9193,G__9194));
} else {
return null;
}
});

cljs.core.ChunkedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vec","vec",982683596,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.ChunkedSeq.cljs$lang$type = true;

cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";

cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/ChunkedSeq");
});

cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(){
var G__9196 = arguments.length;
switch (G__9196) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
});

cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;

/**
* @constructor
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__9199 = init__$1;
var G__9200 = j;
var G__9201 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9199,G__9200,G__9201) : f.call(null,G__9199,G__9200,G__9201));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9202 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9202) : cljs.core.deref.call(null,G__9202));
} else {
var G__9224 = (i + (1));
var G__9225 = (j + (1));
var G__9226 = init__$2;
i = G__9224;
j = G__9225;
init__$1 = G__9226;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
});

cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
var G__9203 = self__.meta;
var G__9204 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__9205 = self__.start;
var G__9206 = (function (){var x__4237__auto__ = self__.end;
var y__4238__auto__ = (v_pos + (1));
return ((x__4237__auto__ > y__4238__auto__) ? x__4237__auto__ : y__4238__auto__);
})();
var G__9207 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9203,G__9204,G__9205,G__9206,G__9207) : cljs.core.build_subvec.call(null,G__9203,G__9204,G__9205,G__9206,G__9207));
});

cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
});

cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__9208 = self__.meta;
var G__9209 = self__.v;
var G__9210 = self__.start;
var G__9211 = (self__.end - (1));
var G__9212 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9208,G__9209,G__9210,G__9211,G__9212) : cljs.core.build_subvec.call(null,G__9208,G__9209,G__9210,G__9211,G__9212));
}
});

cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(!((self__.start === self__.end))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
});

cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start__$1){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start__$1);
});

cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n(coll__$1,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
});

cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = ((function (coll__$1){
return (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
return cljs$core$subvec_seq((i + (1)));
});})(coll__$1))
,null,null)));
}
});})(coll__$1))
;
return subvec_seq(self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
var G__9214 = meta__$1;
var G__9215 = self__.v;
var G__9216 = self__.start;
var G__9217 = self__.end;
var G__9218 = self__.__hash;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9214,G__9215,G__9216,G__9217,G__9218) : cljs.core.build_subvec.call(null,G__9214,G__9215,G__9216,G__9217,G__9218));
});

cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__9219 = self__.meta;
var G__9220 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__9221 = self__.start;
var G__9222 = (self__.end + (1));
var G__9223 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9219,G__9220,G__9221,G__9222,G__9223) : cljs.core.build_subvec.call(null,G__9219,G__9220,G__9221,G__9222,G__9223));
});

cljs.core.Subvec.prototype.call = (function() {
var G__9227 = null;
var G__9227__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__9227__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__9227 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9227__2.call(this,self__,k);
case 3:
return G__9227__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9227.cljs$core$IFn$_invoke$arity$2 = G__9227__2;
G__9227.cljs$core$IFn$_invoke$arity$3 = G__9227__3;
return G__9227;
})()
;

cljs.core.Subvec.prototype.apply = (function (self__,args9198){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9198)));
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.Subvec.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.Subvec.cljs$lang$type = true;

cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";

cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/Subvec");
});

cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__9228 = meta;
var G__9229 = v.v;
var G__9230 = (v.start + start);
var G__9231 = (v.start + end);
var G__9232 = __hash;
meta = G__9228;
v = G__9229;
start = G__9230;
end = G__9231;
__hash = G__9232;
continue;
} else {
var c = cljs.core.count(v);
if(((start < (0))) || ((end < (0))) || ((start > c)) || ((end > c))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 * start (inclusive) to end (exclusive).  If end is not supplied,
 * defaults to (count vector). This operation is O(1) and very fast, as
 * the resulting vector shares structure with the original and no
 * trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(){
var G__9234 = arguments.length;
switch (G__9234) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function (v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function (v,start,end){
return cljs.core.build_subvec(null,v,start,end,null);
});

cljs.core.subvec.cljs$lang$maxFixedArity = 3;
cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode((function (){var obj9239 = {};
return obj9239;
})(),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if(!((child == null))){
return cljs$core$tv_push_tail(tv,(level - (5)),child,tail_node);
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$tv_pop_tail(tv,(level - (5)),cljs.core.pv_aget(node__$1,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__9247 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__9248 = (level - (5));
node = G__9247;
level = G__9248;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
})
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

self__.tail = new_tail;

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array));

self__.shift = new_shift;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
self__.root = new_root;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
self__.root.edit = null;

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n_BANG_(tcoll__$1,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = ((function (tcoll__$1){
return (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});})(tcoll__$1))
.call(null,self__.shift,self__.root);
self__.root = new_root;

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return cljs.core._conj_BANG_(tcoll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds for TransientVector of length"),cljs.core.str(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
self__.cnt = (0);

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
self__.cnt = (self__.cnt - (1));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if(!((nr == null))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
self__.root = new_root__$1;

self__.shift = (self__.shift - (5));

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
} else {
self__.root = new_root;

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,n);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.call = (function() {
var G__9252 = null;
var G__9252__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9252__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9252 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9252__2.call(this,self__,k);
case 3:
return G__9252__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9252.cljs$core$IFn$_invoke$arity$2 = G__9252__2;
G__9252.cljs$core$IFn$_invoke$arity$3 = G__9252__3;
return G__9252;
})()
;

cljs.core.TransientVector.prototype.apply = (function (self__,args9249){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9249)));
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.TransientVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"tail","tail",494507963,null)], null);
});

cljs.core.TransientVector.cljs$lang$type = true;

cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";

cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/TransientVector");
});

cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__4421__auto__ = cljs.core.next(self__.front);
if(temp__4421__auto__){
var f1 = temp__4421__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return cljs.core._empty(coll__$1);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueSeq(meta__$1,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentQueueSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.PersistentQueueSeq.cljs$lang$type = true;

cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";

cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/PersistentQueueSeq");
});

cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));

/**
* @constructor
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__4421__auto__ = cljs.core.next(self__.front);
if(temp__4421__auto__){
var f1 = temp__4421__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__3925__auto__ = self__.front;
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(meta__$1,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__3925__auto__ = self__.rear;
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});

cljs.core.PersistentQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.PersistentQueue.cljs$lang$type = true;

cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";

cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/PersistentQueue");
});

cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));

/**
* @constructor
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
});

cljs.core.NeverEquiv.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.NeverEquiv.cljs$lang$type = true;

cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";

cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/NeverEquiv");
});

cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Assumes y is a map. Returns true if x equals y, otherwise returns
 * false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((cljs.core.map_QMARK_(y))?(((cljs.core.count(x) === cljs.core.count(y)))?cljs.core.every_QMARK_(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__9253 = (i + incr);
i = G__9253;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__9254 = (i + (1));
var G__9255 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,(so[k__$1]));
i = G__9254;
out = G__9255;
continue;
} else {
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = (function (){var obj9259 = {};
return obj9259;
})();
var l = ks.length;
var i_9260 = (0);
while(true){
if((i_9260 < l)){
var k_9261 = (ks[i_9260]);
(new_obj[k_9261] = (obj[k_9261]));

var G__9262 = (i_9260 + (1));
i_9260 = G__9262;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
})
cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3913__auto__ = (function (){var G__9266 = k;
return goog.isString(G__9266);
})();
if(cljs.core.truth_(and__3913__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3913__auto__;
}
})())){
return (self__.strobj[k]);
} else {
return not_found;
}
});

cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__9267 = init__$1;
var G__9268 = k;
var G__9269 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9267,G__9268,G__9269) : f.call(null,G__9267,G__9268,G__9269));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9270 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9270) : cljs.core.deref.call(null,G__9270));
} else {
var G__9276 = cljs.core.rest(keys__$1);
var G__9277 = init__$2;
keys__$1 = G__9276;
init__$1 = G__9277;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
});

cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
});

cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
});

cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3913__auto__ = (function (){var G__9272 = k;
return goog.isString(G__9272);
})();
if(cljs.core.truth_(and__3913__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3913__auto__;
}
})())){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var G__9273 = k;
return goog.isString(G__9273);
})())){
if(((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if(!((cljs.core.scan_array((1),k,self__.keys) == null))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
(new_strobj[k] = v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
(new_strobj[k] = v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3913__auto__ = (function (){var G__9275 = k;
return goog.isString(G__9275);
})();
if(cljs.core.truth_(and__3913__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3913__auto__;
}
})())){
return true;
} else {
return false;
}
});

cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (coll__$1){
return (function (p1__9263_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__9263_SHARP_,(self__.strobj[p1__9263_SHARP_])],null));
});})(coll__$1))
,self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ObjMap(meta__$1,self__.keys,self__.strobj,self__.update_count,self__.__hash));
});

cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
});

cljs.core.ObjMap.prototype.call = (function() {
var G__9278 = null;
var G__9278__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9278__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9278 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9278__2.call(this,self__,k);
case 3:
return G__9278__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9278.cljs$core$IFn$_invoke$arity$2 = G__9278__2;
G__9278.cljs$core$IFn$_invoke$arity$3 = G__9278__3;
return G__9278;
})()
;

cljs.core.ObjMap.prototype.apply = (function (self__,args9264){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9264)));
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.ObjMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keys","keys",-1586012071,null),new cljs.core.Symbol(null,"strobj","strobj",1088091283,null),new cljs.core.Symbol(null,"update-count","update-count",-411982269,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.ObjMap.cljs$lang$type = true;

cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";

cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/ObjMap");
});

cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],(function (){var obj9280 = {};
return obj9280;
})(),(0),cljs.core.empty_unordered_hash));
cljs.core.ObjMap.HASHMAP_THRESHOLD = (8);
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
});

/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var vec__9281 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9281,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9281,(1),null);
self__.s = cljs.core.next(self__.s);

return {"value": [k,v], "done": false};
} else {
return {"value": null, "done": true};
}
});

cljs.core.ES6EntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null);
});

cljs.core.ES6EntriesIterator.cljs$lang$type = true;

cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";

cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/ES6EntriesIterator");
});

cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"value": [x,x], "done": false};
} else {
return {"value": null, "done": true};
}
});

cljs.core.ES6SetEntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null)], null);
});

cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/ES6SetEntriesIterator");
});

cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__9282 = (i + (2));
i = G__9282;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Keyword)) && ((kstr === k_SINGLEQUOTE_.fqn));
})()){
return i;
} else {
var G__9283 = (i + (2));
i = G__9283;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Symbol)) && ((kstr === k_SINGLEQUOTE_.str));
})()){
return i;
} else {
var G__9284 = (i + (2));
i = G__9284;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__9285 = (i + (2));
i = G__9285;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__9286 = (i + (2));
i = G__9286;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if(cljs.core.truth_((function (){var or__3925__auto__ = (function (){var G__9290 = k;
return goog.isString(G__9290);
})();
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return typeof k === 'number';
}
})())){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_9291 = (0);
while(true){
if((i_9291 < l)){
(narr[i_9291] = (arr[i_9291]));

var G__9292 = (i_9291 + (1));
i_9291 = G__9292;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return null;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentArrayMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/PersistentArrayMapSeq");
});

cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
})
cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
});

cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
self__.i = (self__.i + (2));

return ret;
});

cljs.core.PersistentArrayMapIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null)], null);
});

cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/PersistentArrayMapIterator");
});

cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9294 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__9294) : cljs.core.keys.call(null,G__9294));
})());
});

cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9295 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__9295) : cljs.core.vals.call(null,G__9295));
})());
});

cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9296 = cljs.core.seq(coll);
var chunk__9297 = null;
var count__9298 = (0);
var i__9299 = (0);
while(true){
if((i__9299 < count__9298)){
var vec__9300 = chunk__9297.cljs$core$IIndexed$_nth$arity$2(null,i__9299);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9300,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9300,(1),null);
var G__9301_9314 = v;
var G__9302_9315 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9301_9314,G__9302_9315) : f.call(null,G__9301_9314,G__9302_9315));

var G__9316 = seq__9296;
var G__9317 = chunk__9297;
var G__9318 = count__9298;
var G__9319 = (i__9299 + (1));
seq__9296 = G__9316;
chunk__9297 = G__9317;
count__9298 = G__9318;
i__9299 = G__9319;
continue;
} else {
var temp__4423__auto__ = cljs.core.seq(seq__9296);
if(temp__4423__auto__){
var seq__9296__$1 = temp__4423__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9296__$1)){
var c__4710__auto__ = cljs.core.chunk_first(seq__9296__$1);
var G__9320 = cljs.core.chunk_rest(seq__9296__$1);
var G__9321 = c__4710__auto__;
var G__9322 = cljs.core.count(c__4710__auto__);
var G__9323 = (0);
seq__9296 = G__9320;
chunk__9297 = G__9321;
count__9298 = G__9322;
i__9299 = G__9323;
continue;
} else {
var vec__9303 = cljs.core.first(seq__9296__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9303,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9303,(1),null);
var G__9304_9324 = v;
var G__9305_9325 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9304_9324,G__9305_9325) : f.call(null,G__9304_9324,G__9305_9325));

var G__9326 = cljs.core.next(seq__9296__$1);
var G__9327 = null;
var G__9328 = (0);
var G__9329 = (0);
seq__9296 = G__9326;
chunk__9297 = G__9327;
count__9298 = G__9328;
i__9299 = G__9329;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__9306 = init__$1;
var G__9307 = (self__.arr[i]);
var G__9308 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9306,G__9307,G__9308) : f.call(null,G__9306,G__9307,G__9308));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9309 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9309) : cljs.core.deref.call(null,G__9309));
} else {
var G__9330 = (i + (2));
var G__9331 = init__$2;
i = G__9330;
init__$1 = G__9331;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((function (){var G__9310 = other;
if(G__9310){
var bit__4592__auto__ = (G__9310.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4592__auto__) || (G__9310.cljs$core$IMap$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if(!((v === cljs.core.lookup_sentinel))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__9332 = (i + (2));
i = G__9332;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_map(coll__$1,other);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap((function (){var obj9312 = {};
return obj9312;
})(),self__.arr.length,cljs.core.aclone(self__.arr)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return cljs.core._empty(coll__$1);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__9333 = (s + (2));
var G__9334 = d;
s = G__9333;
d = G__9334;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__9335 = (s + (2));
var G__9336 = (d + (2));
s = G__9335;
d = G__9336;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__9313 = cljs.core.aclone(self__.arr);
(G__9313[(idx + (1))] = v);

return G__9313;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((cljs.core.array_map_index_of(coll__$1,k) === (-1)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMap(meta__$1,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9337 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__9338 = cljs.core.next(es);
ret = G__9337;
es = G__9338;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__9339 = null;
var G__9339__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9339__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9339 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9339__2.call(this,self__,k);
case 3:
return G__9339__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9339.cljs$core$IFn$_invoke$arity$2 = G__9339__2;
G__9339.cljs$core$IFn$_invoke$arity$3 = G__9339__3;
return G__9339;
})()
;

cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args9293){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9293)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.PersistentArrayMap.cljs$lang$type = true;

cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";

cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/PersistentArrayMap");
});

cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8);
cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_9340 = (0);
while(true){
if((i_9340 < arr__$1.length)){
var k_9341 = (arr__$1[i_9340]);
var v_9342 = (arr__$1[(i_9340 + (1))]);
var idx_9343 = cljs.core.array_index_of(ret,k_9341);
if((idx_9343 === (-1))){
ret.push(k_9341);

ret.push(v_9342);
} else {
}

var G__9344 = (i_9340 + (2));
i_9340 = G__9344;
continue;
} else {
}
break;
}

return ret;
})());
var arr__$3 = (function (){var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
})();
return arr__$3;
});
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 258;
this.cljs$lang$protocol_mask$partition1$ = 56;
})
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,k,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
if((function (){var G__9345 = o;
if(G__9345){
var bit__4599__auto__ = (G__9345.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4599__auto__) || (G__9345.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__9345.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9345);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9345);
}
})()){
return cljs.core._assoc_BANG_(tcoll__$1,(function (){var G__9346 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9346) : cljs.core.key.call(null,G__9346));
})(),(function (){var G__9347 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9347) : cljs.core.val.call(null,G__9347));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__4421__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4421__auto__)){
var e = temp__4421__auto__;
var G__9353 = cljs.core.next(es);
var G__9354 = cljs.core._assoc_BANG_(tcoll__$2,(function (){var G__9348 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9348) : cljs.core.key.call(null,G__9348));
})(),(function (){var G__9349 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9349) : cljs.core.val.call(null,G__9349));
})());
es = G__9353;
tcoll__$2 = G__9354;
continue;
} else {
return tcoll__$2;
}
break;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
self__.editable_QMARK_ = false;

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
self__.len = (self__.len + (2));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((function (){var G__9350 = self__.len;
var G__9351 = self__.arr;
return (cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(G__9350,G__9351) : cljs.core.array__GT_transient_hash_map.call(null,G__9350,G__9351));
})(),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__9352_9355 = self__.arr;
G__9352_9355.pop();

G__9352_9355.pop();


self__.len = (self__.len - (2));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"editable?","editable?",-164945806,null),new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
});

cljs.core.TransientArrayMap.cljs$lang$type = true;

cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";

cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/TransientArrayMap");
});

cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});


cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__9356 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__9357 = (i + (2));
out = G__9356;
i = G__9357;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
})

cljs.core.Box.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null)], null);
});

cljs.core.Box.cljs$lang$type = true;

cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";

cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/Box");
});

cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(){
var G__9359 = arguments.length;
switch (G__9359) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function (arr,i,a){
var G__9360 = cljs.core.aclone(arr);
(G__9360[i] = a);

return G__9360;
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function (arr,i,a,j,b){
var G__9361 = cljs.core.aclone(arr);
(G__9361[i] = a);

(G__9361[j] = b);

return G__9361;
});

cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;
cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(){
var G__9364 = arguments.length;
switch (G__9364) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
});

cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;
cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if(!((k == null))){
var G__9370 = init__$1;
var G__9371 = k;
var G__9372 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9370,G__9371,G__9372) : f.call(null,G__9370,G__9371,G__9372));
} else {
var node = (arr[(i + (1))]);
if(!((node == null))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9373 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9373) : cljs.core.deref.call(null,G__9373));
} else {
var G__9374 = (i + (2));
var G__9375 = init__$2;
i = G__9374;
init__$1 = G__9375;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
})
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_[(0)] = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
editable.bitmap = (bit ^ editable.bitmap);

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
});

cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__9376 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__9376) : cljs.core.create_inode_seq.call(null,G__9376));
});

cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
added_leaf_QMARK_.val = true;

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

editable.bitmap = (editable.bitmap | bit);

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_9390 = (0);
var j_9391 = (0);
while(true){
if((i_9390 < (32))){
if((((self__.bitmap >>> i_9390) & (1)) === (0))){
var G__9392 = (i_9390 + (1));
var G__9393 = j_9391;
i_9390 = G__9392;
j_9391 = G__9393;
continue;
} else {
(nodes[i_9390] = ((!(((self__.arr[j_9391]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_9391])),(self__.arr[j_9391]),(self__.arr[(j_9391 + (1))]),added_leaf_QMARK_):(self__.arr[(j_9391 + (1))])));

var G__9394 = (i_9390 + (1));
var G__9395 = (j_9391 + (2));
i_9390 = G__9394;
j_9391 = G__9395;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

var editable = inode.ensure_editable(edit__$1);
editable.arr = new_arr;

editable.bitmap = (editable.bitmap | bit);

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
added_leaf_QMARK_.val = true;

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__9377 = edit__$1;
var G__9378 = (shift + (5));
var G__9379 = key_or_nil;
var G__9380 = val_or_node;
var G__9381 = hash;
var G__9382 = key;
var G__9383 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__9377,G__9378,G__9379,G__9380,G__9381,G__9382,G__9383) : cljs.core.create_node.call(null,G__9377,G__9378,G__9379,G__9380,G__9381,G__9382,G__9383));
})());

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_9396 = (0);
var j_9397 = (0);
while(true){
if((i_9396 < (32))){
if((((self__.bitmap >>> i_9396) & (1)) === (0))){
var G__9398 = (i_9396 + (1));
var G__9399 = j_9397;
i_9396 = G__9398;
j_9397 = G__9399;
continue;
} else {
(nodes[i_9396] = ((!(((self__.arr[j_9397]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_9397])),(self__.arr[j_9397]),(self__.arr[(j_9397 + (1))]),added_leaf_QMARK_):(self__.arr[(j_9397 + (1))])));

var G__9400 = (i_9396 + (1));
var G__9401 = (j_9397 + (2));
i_9396 = G__9400;
j_9397 = G__9401;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__9384 = (shift + (5));
var G__9385 = key_or_nil;
var G__9386 = val_or_node;
var G__9387 = hash;
var G__9388 = key;
var G__9389 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__9384,G__9385,G__9386,G__9387,G__9388,G__9389) : cljs.core.create_node.call(null,G__9384,G__9385,G__9386,G__9387,G__9388,G__9389));
})())));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil,val_or_node], null);
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"bitmap","bitmap",501334601,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
});

cljs.core.BitmapIndexedNode.cljs$lang$type = true;

cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";

cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/BitmapIndexedNode");
});

cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[]));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((!((i === idx))) && (!(((arr[i]) == null)))){
(new_arr[j] = (arr[i]));

var G__9402 = (i + (1));
var G__9403 = (j + (2));
var G__9404 = (bitmap | ((1) << i));
i = G__9402;
j = G__9403;
bitmap = G__9404;
continue;
} else {
var G__9405 = (i + (1));
var G__9406 = j;
var G__9407 = bitmap;
i = G__9405;
j = G__9406;
bitmap = G__9407;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
});

cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
editable.cnt = (editable.cnt - (1));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
});

cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__9408 = self__.arr;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(G__9408) : cljs.core.create_array_node_seq.call(null,G__9408));
});

cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if(!((node == null))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9409 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9409) : cljs.core.deref.call(null,G__9409));
} else {
var G__9410 = (i + (1));
var G__9411 = init__$2;
i = G__9410;
init__$1 = G__9411;
continue;
}
} else {
var G__9412 = (i + (1));
var G__9413 = init__$1;
i = G__9412;
init__$1 = G__9413;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
editable.cnt = (editable.cnt + (1));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
});

cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
});

cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
});

cljs.core.ArrayNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
});

cljs.core.ArrayNode.cljs$lang$type = true;

cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";

cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/ArrayNode");
});

cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__9414 = (i + (2));
i = G__9414;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
});

cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_[(0)] = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

editable.cnt = (editable.cnt - (1));

return editable;
}
}
});

cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__9415 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__9415) : cljs.core.create_inode_seq.call(null,G__9415));
});

cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
added_leaf_QMARK_.val = true;

editable.cnt = (editable.cnt + (1));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[idx]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
self__.arr = array;

self__.cnt = count;

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
});

cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[idx]),(self__.arr[(idx + (1))])], null);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
});

cljs.core.HashCollisionNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"collision-hash","collision-hash",-35831342,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
});

cljs.core.HashCollisionNode.cljs$lang$type = true;

cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";

cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/HashCollisionNode");
});

cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(){
var G__9417 = arguments.length;
switch (G__9417) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$lang$maxFixedArity = 7;

/**
* @constructor
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))])], null);
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
var G__9419 = self__.nodes;
var G__9420 = (self__.i + (2));
var G__9421 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__9419,G__9420,G__9421) : cljs.core.create_inode_seq.call(null,G__9419,G__9420,G__9421));
} else {
var G__9422 = self__.nodes;
var G__9423 = self__.i;
var G__9424 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__9422,G__9423,G__9424) : cljs.core.create_inode_seq.call(null,G__9422,G__9423,G__9424));
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.NodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.NodeSeq.cljs$lang$type = true;

cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";

cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/NodeSeq");
});

cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(){
var G__9426 = arguments.length;
switch (G__9426) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if(!(((nodes[j]) == null))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__4421__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__4421__auto__)){
var node = temp__4421__auto__;
var temp__4421__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__4421__auto____$1)){
var node_seq = temp__4421__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__9428 = (j + (2));
j = G__9428;
continue;
}
} else {
var G__9429 = (j + (2));
j = G__9429;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});

cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;

/**
* @constructor
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__9430 = null;
var G__9431 = self__.nodes;
var G__9432 = self__.i;
var G__9433 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__9430,G__9431,G__9432,G__9433) : cljs.core.create_array_node_seq.call(null,G__9430,G__9431,G__9432,G__9433));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ArrayNodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.ArrayNodeSeq.cljs$lang$type = true;

cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";

cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/ArrayNodeSeq");
});

cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(){
var G__9435 = arguments.length;
switch (G__9435) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null,nodes,(0),null);
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = (function (meta,nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__4421__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__4421__auto__)){
var nj = temp__4421__auto__;
var temp__4421__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__4421__auto____$1)){
var ns = temp__4421__auto____$1;
return (new cljs.core.ArrayNodeSeq(meta,nodes,(j + (1)),ns,null));
} else {
var G__9437 = (j + (1));
j = G__9437;
continue;
}
} else {
var G__9438 = (j + (1));
j = G__9438;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,null));
}
});

cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;

/**
* @constructor
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9440 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__9440) : cljs.core.keys.call(null,G__9440));
})());
});

cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9441 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__9441) : cljs.core.vals.call(null,G__9441));
})());
});

cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9442 = cljs.core.seq(coll);
var chunk__9443 = null;
var count__9444 = (0);
var i__9445 = (0);
while(true){
if((i__9445 < count__9444)){
var vec__9446 = chunk__9443.cljs$core$IIndexed$_nth$arity$2(null,i__9445);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9446,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9446,(1),null);
var G__9447_9458 = v;
var G__9448_9459 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9447_9458,G__9448_9459) : f.call(null,G__9447_9458,G__9448_9459));

var G__9460 = seq__9442;
var G__9461 = chunk__9443;
var G__9462 = count__9444;
var G__9463 = (i__9445 + (1));
seq__9442 = G__9460;
chunk__9443 = G__9461;
count__9444 = G__9462;
i__9445 = G__9463;
continue;
} else {
var temp__4423__auto__ = cljs.core.seq(seq__9442);
if(temp__4423__auto__){
var seq__9442__$1 = temp__4423__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9442__$1)){
var c__4710__auto__ = cljs.core.chunk_first(seq__9442__$1);
var G__9464 = cljs.core.chunk_rest(seq__9442__$1);
var G__9465 = c__4710__auto__;
var G__9466 = cljs.core.count(c__4710__auto__);
var G__9467 = (0);
seq__9442 = G__9464;
chunk__9443 = G__9465;
count__9444 = G__9466;
i__9445 = G__9467;
continue;
} else {
var vec__9449 = cljs.core.first(seq__9442__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9449,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9449,(1),null);
var G__9450_9468 = v;
var G__9451_9469 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9450_9468,G__9451_9469) : f.call(null,G__9450_9468,G__9451_9469));

var G__9470 = cljs.core.next(seq__9442__$1);
var G__9471 = null;
var G__9472 = (0);
var G__9473 = (0);
seq__9442 = G__9470;
chunk__9443 = G__9471;
count__9444 = G__9472;
i__9445 = G__9473;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(function (){var G__9452 = init;
var G__9453 = null;
var G__9454 = self__.nil_val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9452,G__9453,G__9454) : f.call(null,G__9452,G__9453,G__9454));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__9455 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9455) : cljs.core.deref.call(null,G__9455));
} else {
if(!((self__.root == null))){
return self__.root.kv_reduce(f,init__$1);
} else {
return init__$1;

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap((function (){var obj9457 = {};
return obj9457;
})(),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if((self__.has_nil_QMARK_) && ((v === self__.nil_val))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return !((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel));

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = ((!((self__.root == null)))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null),s);
} else {
return s;
}
} else {
return null;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashMap(meta__$1,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9474 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__9475 = cljs.core.next(es);
ret = G__9474;
es = G__9475;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentHashMap.prototype.call = (function() {
var G__9476 = null;
var G__9476__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9476__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9476 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9476__2.call(this,self__,k);
case 3:
return G__9476__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9476.cljs$core$IFn$_invoke$arity$2 = G__9476__2;
G__9476.cljs$core$IFn$_invoke$arity$3 = G__9476__3;
return G__9476;
})()
;

cljs.core.PersistentHashMap.prototype.apply = (function (self__,args9439){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9439)));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.PersistentHashMap.cljs$lang$type = true;

cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";

cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/PersistentHashMap");
});

cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__9477 = (i + (2));
var G__9478 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__9477;
ret = G__9478;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
});
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__9479 = (i + (1));
var G__9480 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(ks[i]),(vs[i]));
i = G__9479;
out = G__9480;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 258;
this.cljs$lang$protocol_mask$partition1$ = 56;
})
cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((function (){var G__9481 = o;
if(G__9481){
var bit__4599__auto__ = (G__9481.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4599__auto__) || (G__9481.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__9481.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9481);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9481);
}
})()){
return tcoll.assoc_BANG_((function (){var G__9482 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9482) : cljs.core.key.call(null,G__9482));
})(),(function (){var G__9483 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9483) : cljs.core.val.call(null,G__9483));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__4421__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4421__auto__)){
var e = temp__4421__auto__;
var G__9486 = cljs.core.next(es);
var G__9487 = tcoll__$1.assoc_BANG_((function (){var G__9484 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9484) : cljs.core.key.call(null,G__9484));
})(),(function (){var G__9485 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9485) : cljs.core.val.call(null,G__9485));
})());
es = G__9486;
tcoll__$1 = G__9487;
continue;
} else {
return tcoll__$1;
}
break;
}
}
} else {
throw (new Error("conj! after persistent"));
}
});

cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
self__.nil_val = v;
}

if(self__.has_nil_QMARK_){
} else {
self__.count = (self__.count + (1));

self__.has_nil_QMARK_ = true;
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(added_leaf_QMARK_.val){
self__.count = (self__.count + (1));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
self__.has_nil_QMARK_ = false;

self__.nil_val = null;

self__.count = (self__.count - (1));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(cljs.core.truth_((removed_leaf_QMARK_[(0)]))){
self__.count = (self__.count - (1));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
self__.edit = null;

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
});

cljs.core.TransientHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null)], null);
});

cljs.core.TransientHashMap.cljs$lang$type = true;

cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";

cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/TransientHashMap");
});

cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if(!((t == null))){
var G__9488 = ((ascending_QMARK_)?t.left:t.right);
var G__9489 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__9488;
stack__$1 = G__9489;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374862;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if(!((next_stack == null))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMapSeq(meta__$1,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentTreeMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"stack","stack",847125597,null),new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/PersistentTreeMapSeq");
});

cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if(((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if(((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = ((!((node.left == null)))?cljs$core$tree_map_kv_reduce(node.left,f,init):init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__9502 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9502) : cljs.core.deref.call(null,G__9502));
} else {
var init__$2 = (function (){var G__9503 = init__$1;
var G__9504 = node.key;
var G__9505 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9503,G__9504,G__9505) : f.call(null,G__9503,G__9504,G__9505));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9506 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9506) : cljs.core.deref.call(null,G__9506));
} else {
var init__$3 = ((!((node.right == null)))?cljs$core$tree_map_kv_reduce(node.right,f,init__$2):init__$2);
if(cljs.core.reduced_QMARK_(init__$3)){
var G__9507 = init__$3;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9507) : cljs.core.deref.call(null,G__9507));
} else {
return init__$3;
}
}
}
});

/**
* @constructor
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
});

cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
});

cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
});

cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
});

cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
});

cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
});

cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.BlackNode.prototype.call = (function() {
var G__9509 = null;
var G__9509__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9509__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9509 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9509__2.call(this,self__,k);
case 3:
return G__9509__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9509.cljs$core$IFn$_invoke$arity$2 = G__9509__2;
G__9509.cljs$core$IFn$_invoke$arity$3 = G__9509__3;
return G__9509;
})()
;

cljs.core.BlackNode.prototype.apply = (function (self__,args9508){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9508)));
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.BlackNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.BlackNode.cljs$lang$type = true;

cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";

cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/BlackNode");
});

cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));

/**
* @constructor
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
});

cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
});

cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
});

cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
});

cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
});

cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
});

cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.RedNode.prototype.call = (function() {
var G__9511 = null;
var G__9511__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9511__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9511 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9511__2.call(this,self__,k);
case 3:
return G__9511__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9511.cljs$core$IFn$_invoke$arity$2 = G__9511__2;
G__9511.cljs$core$IFn$_invoke$arity$3 = G__9511__3;
return G__9511;
})()
;

cljs.core.RedNode.prototype.apply = (function (self__,args9510){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9510)));
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.RedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.RedNode.cljs$lang$type = true;

cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";

cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/RedNode");
});

cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__9524 = k;
var G__9525 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9524,G__9525) : comp.call(null,G__9524,G__9525));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = cljs$core$tree_map_add(comp,tree.left,k,v,found);
if(!((ins == null))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = cljs$core$tree_map_add(comp,tree.right,k,v,found);
if(!((ins == null))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,cljs$core$tree_map_append(left.right,right),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,cljs$core$tree_map_append(left,right.left),right.right,null));
} else {
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if(!((tree == null))){
var c = (function (){var G__9544 = k;
var G__9545 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9544,G__9545) : comp.call(null,G__9544,G__9545));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = cljs$core$tree_map_remove(comp,tree.left,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = cljs$core$tree_map_remove(comp,tree.right,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (function (){var G__9556 = k;
var G__9557 = tk;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9556,G__9557) : comp.call(null,G__9556,G__9557));
})();
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,cljs$core$tree_map_replace(comp,tree.left,k,v),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,cljs$core$tree_map_replace(comp,tree.right,k,v));

}
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9559 = cljs.core.seq(coll);
var chunk__9560 = null;
var count__9561 = (0);
var i__9562 = (0);
while(true){
if((i__9562 < count__9561)){
var vec__9563 = chunk__9560.cljs$core$IIndexed$_nth$arity$2(null,i__9562);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9563,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9563,(1),null);
var G__9564_9576 = v;
var G__9565_9577 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9564_9576,G__9565_9577) : f.call(null,G__9564_9576,G__9565_9577));

var G__9578 = seq__9559;
var G__9579 = chunk__9560;
var G__9580 = count__9561;
var G__9581 = (i__9562 + (1));
seq__9559 = G__9578;
chunk__9560 = G__9579;
count__9561 = G__9580;
i__9562 = G__9581;
continue;
} else {
var temp__4423__auto__ = cljs.core.seq(seq__9559);
if(temp__4423__auto__){
var seq__9559__$1 = temp__4423__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9559__$1)){
var c__4710__auto__ = cljs.core.chunk_first(seq__9559__$1);
var G__9582 = cljs.core.chunk_rest(seq__9559__$1);
var G__9583 = c__4710__auto__;
var G__9584 = cljs.core.count(c__4710__auto__);
var G__9585 = (0);
seq__9559 = G__9582;
chunk__9560 = G__9583;
count__9561 = G__9584;
i__9562 = G__9585;
continue;
} else {
var vec__9566 = cljs.core.first(seq__9559__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9566,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9566,(1),null);
var G__9567_9586 = v;
var G__9568_9587 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9567_9586,G__9568_9587) : f.call(null,G__9567_9586,G__9568_9587));

var G__9588 = cljs.core.next(seq__9559__$1);
var G__9589 = null;
var G__9590 = (0);
var G__9591 = (0);
seq__9559 = G__9588;
chunk__9560 = G__9589;
count__9561 = G__9590;
i__9562 = G__9591;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9569 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__9569) : cljs.core.keys.call(null,G__9569));
})());
});

cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9570 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__9570) : cljs.core.vals.call(null,G__9570));
})());
});

cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__9571 = k;
var G__9572 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__9571,G__9572) : self__.comp.call(null,G__9571,G__9572));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__9592 = t.left;
t = G__9592;
continue;
} else {
var G__9593 = t.right;
t = G__9593;
continue;

}
}
} else {
return null;
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if(!((n == null))){
return n.val;
} else {
return not_found;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if(!((self__.tree == null))){
return cljs.core.tree_map_kv_reduce(self__.tree,f,init);
} else {
return init;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((coll__$1.entry_at(k) == null));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,meta__$1,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9594 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__9595 = cljs.core.next(es);
ret = G__9594;
es = G__9595;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__9596 = null;
var G__9596__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9596__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9596 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9596__2.call(this,self__,k);
case 3:
return G__9596__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9596.cljs$core$IFn$_invoke$arity$2 = G__9596__2;
G__9596.cljs$core$IFn$_invoke$arity$3 = G__9596__3;
return G__9596;
})()
;

cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args9558){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9558)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__9573 = k;
var G__9574 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__9573,G__9574) : self__.comp.call(null,G__9573,G__9574));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__9597 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__9598 = t.left;
stack = G__9597;
t = G__9598;
continue;
} else {
var G__9599 = stack;
var G__9600 = t.right;
stack = G__9599;
t = G__9600;
continue;
}
} else {
if((c > (0))){
var G__9601 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__9602 = t.right;
stack = G__9601;
t = G__9602;
continue;
} else {
var G__9603 = stack;
var G__9604 = t.left;
stack = G__9603;
t = G__9604;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
var G__9575 = entry;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9575) : cljs.core.key.call(null,G__9575));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
});

cljs.core.PersistentTreeMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"tree","tree",1444219499,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.PersistentTreeMap.cljs$lang$type = true;

cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";

cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/PersistentTreeMap");
});

cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
/**
 * keyval => key val
 * Returns a new hash map with supplied mappings.
 */
cljs.core.hash_map = (function cljs$core$hash_map(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__9606 = cljs.core.nnext(in$);
var G__9607 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9606;
out = G__9607;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});

cljs.core.hash_map.cljs$lang$maxFixedArity = (0);

cljs.core.hash_map.cljs$lang$applyTo = (function (seq9605){
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9605));
});
/**
 * keyval => key val
 * Returns a new array map with supplied mappings.
 */
cljs.core.array_map = (function cljs$core$array_map(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var arr = ((((keyvals instanceof cljs.core.IndexedSeq)) && ((keyvals.i === (0))))?keyvals.arr:cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals));
return cljs.core.PersistentArrayMap.fromArray(arr,true,false);
});

cljs.core.array_map.cljs$lang$maxFixedArity = (0);

cljs.core.array_map.cljs$lang$applyTo = (function (seq9608){
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9608));
});
/**
 * keyval => key val
 * Returns a new object map with supplied mappings.
 */
cljs.core.obj_map = (function cljs$core$obj_map(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var ks = [];
var obj = (function (){var obj9611 = {};
return obj9611;
})();
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

(obj[cljs.core.first(kvs)] = cljs.core.second(kvs));

var G__9612 = cljs.core.nnext(kvs);
kvs = G__9612;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
});

cljs.core.obj_map.cljs$lang$maxFixedArity = (0);

cljs.core.obj_map.cljs$lang$applyTo = (function (seq9609){
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9609));
});
/**
 * keyval => key val
 * Returns a new sorted map with supplied mappings.
 */
cljs.core.sorted_map = (function cljs$core$sorted_map(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__9614 = cljs.core.nnext(in$);
var G__9615 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9614;
out = G__9615;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_map.cljs$lang$applyTo = (function (seq9613){
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9613));
});
/**
 * keyval => key val
 * Returns a new sorted map with supplied mappings, using the supplied comparator.
 */
cljs.core.sorted_map_by = (function cljs$core$sorted_map_by(){
var argseq__4965__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4965__auto__);
});

cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__9618 = cljs.core.nnext(in$);
var G__9619 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9618;
out = G__9619;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_map_by.cljs$lang$applyTo = (function (seq9616){
var G__9617 = cljs.core.first(seq9616);
var seq9616__$1 = cljs.core.next(seq9616);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(G__9617,seq9616__$1);
});

/**
* @constructor
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9620 = self__.mseq;
if(G__9620){
var bit__4599__auto__ = (G__9620.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4599__auto__) || (G__9620.cljs$core$INext$)){
return true;
} else {
if((!G__9620.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9620);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9620);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,self__._meta));
}
});

cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9621 = self__.mseq;
if(G__9621){
var bit__4599__auto__ = (G__9621.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4599__auto__) || (G__9621.cljs$core$INext$)){
return true;
} else {
if((!G__9621.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9621);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9621);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.KeySeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.KeySeq(self__.mseq,new_meta));
});

cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.KeySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"mseq","mseq",1602647196,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

cljs.core.KeySeq.cljs$lang$type = true;

cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";

cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/KeySeq");
});

cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
/**
 * Returns a sequence of the map's keys.
 */
cljs.core.keys = (function cljs$core$keys(hash_map){
var temp__4423__auto__ = cljs.core.seq(hash_map);
if(temp__4423__auto__){
var mseq = temp__4423__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9622 = self__.mseq;
if(G__9622){
var bit__4599__auto__ = (G__9622.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4599__auto__) || (G__9622.cljs$core$INext$)){
return true;
} else {
if((!G__9622.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9622);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9622);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,self__._meta));
}
});

cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9623 = self__.mseq;
if(G__9623){
var bit__4599__auto__ = (G__9623.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4599__auto__) || (G__9623.cljs$core$INext$)){
return true;
} else {
if((!G__9623.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9623);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9623);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.ValSeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ValSeq(self__.mseq,new_meta));
});

cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ValSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"mseq","mseq",1602647196,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

cljs.core.ValSeq.cljs$lang$type = true;

cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";

cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/ValSeq");
});

cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
/**
 * Returns a sequence of the map's values.
 */
cljs.core.vals = (function cljs$core$vals(hash_map){
var temp__4423__auto__ = cljs.core.seq(hash_map);
if(temp__4423__auto__){
var mseq = temp__4423__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val(map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 * the first.  If a key occurs in more than one map, the mapping from
 * the latter (left-to-right) will be the mapping in the result.
 */
cljs.core.merge = (function cljs$core$merge(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__9624_SHARP_,p2__9625_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__3925__auto__ = p1__9624_SHARP_;
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__9625_SHARP_);
}),maps);
} else {
return null;
}
});

cljs.core.merge.cljs$lang$maxFixedArity = (0);

cljs.core.merge.cljs$lang$applyTo = (function (seq9626){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9626));
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 * the first.  If a key occurs in more than one map, the mapping(s)
 * from the latter (left-to-right) will be combined with the mapping in
 * the result by calling (f val-in-result val-in-latter).
 */
cljs.core.merge_with = (function cljs$core$merge_with(){
var argseq__4965__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4965__auto__);
});

cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.first(e);
var v = cljs.core.second(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9629 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9630 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9629,G__9630) : f.call(null,G__9629,G__9630));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__3925__auto__ = m1;
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
});

cljs.core.merge_with.cljs$lang$maxFixedArity = (1);

cljs.core.merge_with.cljs$lang$applyTo = (function (seq9627){
var G__9628 = cljs.core.first(seq9627);
var seq9627__$1 = cljs.core.next(seq9627);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(G__9628,seq9627__$1);
});
/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185));
var G__9631 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__9632 = cljs.core.next(keys);
ret = G__9631;
keys = G__9632;
continue;
} else {
return cljs.core.with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9635 = cljs.core.seq(coll);
var chunk__9636 = null;
var count__9637 = (0);
var i__9638 = (0);
while(true){
if((i__9638 < count__9637)){
var vec__9639 = chunk__9636.cljs$core$IIndexed$_nth$arity$2(null,i__9638);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9639,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9639,(1),null);
var G__9640_9645 = v;
var G__9641_9646 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9640_9645,G__9641_9646) : f.call(null,G__9640_9645,G__9641_9646));

var G__9647 = seq__9635;
var G__9648 = chunk__9636;
var G__9649 = count__9637;
var G__9650 = (i__9638 + (1));
seq__9635 = G__9647;
chunk__9636 = G__9648;
count__9637 = G__9649;
i__9638 = G__9650;
continue;
} else {
var temp__4423__auto__ = cljs.core.seq(seq__9635);
if(temp__4423__auto__){
var seq__9635__$1 = temp__4423__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9635__$1)){
var c__4710__auto__ = cljs.core.chunk_first(seq__9635__$1);
var G__9651 = cljs.core.chunk_rest(seq__9635__$1);
var G__9652 = c__4710__auto__;
var G__9653 = cljs.core.count(c__4710__auto__);
var G__9654 = (0);
seq__9635 = G__9651;
chunk__9636 = G__9652;
count__9637 = G__9653;
i__9638 = G__9654;
continue;
} else {
var vec__9642 = cljs.core.first(seq__9635__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9642,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9642,(1),null);
var G__9643_9655 = v;
var G__9644_9656 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9643_9655,G__9644_9656) : f.call(null,G__9643_9655,G__9644_9656));

var G__9657 = cljs.core.next(seq__9635__$1);
var G__9658 = null;
var G__9659 = (0);
var G__9660 = (0);
seq__9635 = G__9657;
chunk__9636 = G__9658;
count__9637 = G__9659;
i__9638 = G__9660;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core._contains_key_QMARK_(self__.hash_map,v)){
return v;
} else {
return not_found;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__9633_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__9633_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(meta__$1,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
});

cljs.core.PersistentHashSet.prototype.call = (function() {
var G__9661 = null;
var G__9661__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9661__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9661 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9661__2.call(this,self__,k);
case 3:
return G__9661__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9661.cljs$core$IFn$_invoke$arity$2 = G__9661__2;
G__9661.cljs$core$IFn$_invoke$arity$3 = G__9661__3;
return G__9661;
})()
;

cljs.core.PersistentHashSet.prototype.apply = (function (self__,args9634){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9634)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"hash-map","hash-map",-439030950,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.PersistentHashSet.cljs$lang$type = true;

cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";

cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/PersistentHashSet");
});

cljs.core.__GT_PersistentHashSet = (function cljs$core$__GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__9662 = (i + (1));
var G__9663 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__9662;
out = G__9663;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__9664 = (i + (1));
var G__9665 = cljs.core._conj_BANG_(out,(items[i]));
i = G__9664;
out = G__9665;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition1$ = 136;
this.cljs$lang$protocol_mask$partition0$ = 259;
})
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,v,null);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
});

cljs.core.TransientHashSet.prototype.call = (function() {
var G__9667 = null;
var G__9667__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__9667__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__9667 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9667__2.call(this,self__,k);
case 3:
return G__9667__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9667.cljs$core$IFn$_invoke$arity$2 = G__9667__2;
G__9667.cljs$core$IFn$_invoke$arity$3 = G__9667__3;
return G__9667;
})()
;

cljs.core.TransientHashSet.prototype.apply = (function (self__,args9666){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9666)));
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

cljs.core.TransientHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"transient-map","transient-map",351764893,null)], null);
});

cljs.core.TransientHashSet.cljs$lang$type = true;

cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";

cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/TransientHashSet");
});

cljs.core.__GT_TransientHashSet = (function cljs$core$__GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9670 = cljs.core.seq(coll);
var chunk__9671 = null;
var count__9672 = (0);
var i__9673 = (0);
while(true){
if((i__9673 < count__9672)){
var vec__9674 = chunk__9671.cljs$core$IIndexed$_nth$arity$2(null,i__9673);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9674,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9674,(1),null);
var G__9675_9680 = v;
var G__9676_9681 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9675_9680,G__9676_9681) : f.call(null,G__9675_9680,G__9676_9681));

var G__9682 = seq__9670;
var G__9683 = chunk__9671;
var G__9684 = count__9672;
var G__9685 = (i__9673 + (1));
seq__9670 = G__9682;
chunk__9671 = G__9683;
count__9672 = G__9684;
i__9673 = G__9685;
continue;
} else {
var temp__4423__auto__ = cljs.core.seq(seq__9670);
if(temp__4423__auto__){
var seq__9670__$1 = temp__4423__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9670__$1)){
var c__4710__auto__ = cljs.core.chunk_first(seq__9670__$1);
var G__9686 = cljs.core.chunk_rest(seq__9670__$1);
var G__9687 = c__4710__auto__;
var G__9688 = cljs.core.count(c__4710__auto__);
var G__9689 = (0);
seq__9670 = G__9686;
chunk__9671 = G__9687;
count__9672 = G__9688;
i__9673 = G__9689;
continue;
} else {
var vec__9677 = cljs.core.first(seq__9670__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9677,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9677,(1),null);
var G__9678_9690 = v;
var G__9679_9691 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9678_9690,G__9679_9691) : f.call(null,G__9678_9690,G__9679_9691));

var G__9692 = cljs.core.next(seq__9670__$1);
var G__9693 = null;
var G__9694 = (0);
var G__9695 = (0);
seq__9670 = G__9692;
chunk__9671 = G__9693;
count__9672 = G__9694;
i__9673 = G__9695;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if(!((n == null))){
return n.key;
} else {
return not_found;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__9668_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__9668_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(meta__$1,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
});

cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__9696 = null;
var G__9696__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9696__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9696 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9696__2.call(this,self__,k);
case 3:
return G__9696__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9696.cljs$core$IFn$_invoke$arity$2 = G__9696__2;
G__9696.cljs$core$IFn$_invoke$arity$3 = G__9696__3;
return G__9696;
})()
;

cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args9669){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9669)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
});

cljs.core.PersistentTreeSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"tree-map","tree-map",1373073049,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.PersistentTreeSet.cljs$lang$type = true;

cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";

cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/PersistentTreeSet");
});

cljs.core.__GT_PersistentTreeSet = (function cljs$core$__GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
cljs.core.set_from_indexed_seq = (function cljs$core$set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__4804__auto__ = arr;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < a__4804__auto__.length)){
var G__9697 = (i + (1));
var G__9698 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,(arr[i]));
i = G__9697;
res = G__9698;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
 * Returns a set of the distinct elements of coll.
 */
cljs.core.set = (function cljs$core$set(coll){
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if(((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0)))){
return cljs.core.set_from_indexed_seq(in$);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if(!((in$__$1 == null))){
var G__9699 = cljs.core.next(in$__$1);
var G__9700 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,in$__$1.cljs$core$ISeq$_first$arity$1(null));
in$__$1 = G__9699;
out = G__9700;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}

}
}
});
/**
 * Returns a new hash set with supplied keys.  Any equal keys are
 * handled as if by repeated uses of conj.
 */
cljs.core.hash_set = (function cljs$core$hash_set(){
var G__9703 = arguments.length;
switch (G__9703) {
case 0:
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0)));
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4976__auto__);

}
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.set(keys);
});

cljs.core.hash_set.cljs$lang$applyTo = (function (seq9701){
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9701));
});

cljs.core.hash_set.cljs$lang$maxFixedArity = (0);
/**
 * Returns a new sorted set with supplied keys.
 */
cljs.core.sorted_set = (function cljs$core$sorted_set(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
});

cljs.core.sorted_set.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_set.cljs$lang$applyTo = (function (seq9705){
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9705));
});
/**
 * Returns a new sorted set with supplied keys, using the supplied comparator.
 */
cljs.core.sorted_set_by = (function cljs$core$sorted_set_by(){
var argseq__4965__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4965__auto__);
});

cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
});

cljs.core.sorted_set_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_set_by.cljs$lang$applyTo = (function (seq9706){
var G__9707 = cljs.core.first(seq9706);
var seq9706__$1 = cljs.core.next(seq9706);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(G__9707,seq9706__$1);
});
/**
 * Given a map of replacement pairs and a vector/collection, returns a
 * vector/seq with any elements = a key in smap replaced with the
 * corresponding val in smap.  Returns a transducer when no collection
 * is provided.
 */
cljs.core.replace = (function cljs$core$replace(){
var G__9711 = arguments.length;
switch (G__9711) {
case 1:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__9708_SHARP_){
var temp__4421__auto__ = cljs.core.find(smap,p1__9708_SHARP_);
if(cljs.core.truth_(temp__4421__auto__)){
var e = temp__4421__auto__;
return cljs.core.val(e);
} else {
return p1__9708_SHARP_;
}
}));
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (n){
return (function (v,i){
var temp__4421__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__4421__auto__)){
var e = temp__4421__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
});})(n))
,coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__9709_SHARP_){
var temp__4421__auto__ = cljs.core.find(smap,p1__9709_SHARP_);
if(cljs.core.truth_(temp__4421__auto__)){
var e = temp__4421__auto__;
return cljs.core.second(e);
} else {
return p1__9709_SHARP_;
}
}),coll);
}
});

cljs.core.replace.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the elements of coll with duplicates removed
 */
cljs.core.distinct = (function cljs$core$distinct(){
var G__9714 = arguments.length;
switch (G__9714) {
case 0:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__9726 = null;
var G__9726__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9726__1 = (function (result){
var G__9715 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9715) : rf.call(null,G__9715));
});
var G__9726__2 = (function (result,input){
if(cljs.core.contains_QMARK_((function (){var G__9716 = seen;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9716) : cljs.core.deref.call(null,G__9716));
})(),input)){
return result;
} else {
cljs.core._vreset_BANG_(seen,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(seen),input));

var G__9717 = result;
var G__9718 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9717,G__9718) : rf.call(null,G__9717,G__9718));
}
});
G__9726 = function(result,input){
switch(arguments.length){
case 0:
return G__9726__0.call(this);
case 1:
return G__9726__1.call(this,result);
case 2:
return G__9726__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9726.cljs$core$IFn$_invoke$arity$0 = G__9726__0;
G__9726.cljs$core$IFn$_invoke$arity$1 = G__9726__1;
G__9726.cljs$core$IFn$_invoke$arity$2 = G__9726__2;
return G__9726;
})()
;})(seen))
});
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var step = (function cljs$core$step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__9723,seen__$1){
while(true){
var vec__9724 = p__9723;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9724,(0),null);
var xs__$1 = vec__9724;
var temp__4423__auto__ = cljs.core.seq(xs__$1);
if(temp__4423__auto__){
var s = temp__4423__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__9727 = cljs.core.rest(s);
var G__9728 = seen__$1;
p__9723 = G__9727;
seen__$1 = G__9728;
continue;
} else {
return cljs.core.cons(f,cljs$core$step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});

cljs.core.distinct.cljs$lang$maxFixedArity = 1;
/**
 * Return a seq of all but the last item in coll, in linear time
 */
cljs.core.butlast = (function cljs$core$butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__9729 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__9730 = cljs.core.next(s__$1);
ret = G__9729;
s__$1 = G__9730;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
 * Returns the name String of a string, symbol or keyword.
 */
cljs.core.name = (function cljs$core$name(x){
if((function (){var G__9732 = x;
if(G__9732){
var bit__4592__auto__ = (G__9732.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4592__auto__) || (G__9732.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_name$arity$1(null);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error([cljs.core.str("Doesn't support name: "),cljs.core.str(x)].join('')));
}
}
});
/**
 * Returns a map with the keys mapped to the corresponding vals.
 */
cljs.core.zipmap = (function cljs$core$zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if((ks) && (vs)){
var G__9733 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__9734 = cljs.core.next(ks);
var G__9735 = cljs.core.next(vs);
map = G__9733;
ks = G__9734;
vs = G__9735;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
 * Returns the x for which (k x), a number, is greatest.
 */
cljs.core.max_key = (function cljs$core$max_key(){
var G__9743 = arguments.length;
switch (G__9743) {
case 2:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0)));
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4976__auto__);

}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((function (){var G__9744 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9744) : k.call(null,G__9744));
})() > (function (){var G__9745 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9745) : k.call(null,G__9745));
})())){
return x;
} else {
return y;
}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__9736_SHARP_,p2__9737_SHARP_){
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,p1__9736_SHARP_,p2__9737_SHARP_);
}),cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.max_key.cljs$lang$applyTo = (function (seq9738){
var G__9739 = cljs.core.first(seq9738);
var seq9738__$1 = cljs.core.next(seq9738);
var G__9740 = cljs.core.first(seq9738__$1);
var seq9738__$2 = cljs.core.next(seq9738__$1);
var G__9741 = cljs.core.first(seq9738__$2);
var seq9738__$3 = cljs.core.next(seq9738__$2);
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(G__9739,G__9740,G__9741,seq9738__$3);
});

cljs.core.max_key.cljs$lang$maxFixedArity = (3);
/**
 * Returns the x for which (k x), a number, is least.
 */
cljs.core.min_key = (function cljs$core$min_key(){
var G__9754 = arguments.length;
switch (G__9754) {
case 2:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0)));
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4976__auto__);

}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((function (){var G__9755 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9755) : k.call(null,G__9755));
})() < (function (){var G__9756 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9756) : k.call(null,G__9756));
})())){
return x;
} else {
return y;
}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__9747_SHARP_,p2__9748_SHARP_){
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,p1__9747_SHARP_,p2__9748_SHARP_);
}),cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.min_key.cljs$lang$applyTo = (function (seq9749){
var G__9750 = cljs.core.first(seq9749);
var seq9749__$1 = cljs.core.next(seq9749);
var G__9751 = cljs.core.first(seq9749__$1);
var seq9749__$2 = cljs.core.next(seq9749__$1);
var G__9752 = cljs.core.first(seq9749__$2);
var seq9749__$3 = cljs.core.next(seq9749__$2);
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(G__9750,G__9751,G__9752,seq9749__$3);
});

cljs.core.min_key.cljs$lang$maxFixedArity = (3);

/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
})
cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
});

cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
});

cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return self__.arr = [];
});

cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
});

cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
});

cljs.core.ArrayList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
});

cljs.core.ArrayList.cljs$lang$type = true;

cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";

cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/ArrayList");
});

cljs.core.__GT_ArrayList = (function cljs$core$__GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function cljs$core$array_list(){
return (new cljs.core.ArrayList([]));
});
/**
 * Returns a lazy sequence of lists like partition, but may include
 * partitions with fewer than n items at the end.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_all = (function cljs$core$partition_all(){
var G__9759 = arguments.length;
switch (G__9759) {
case 1:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var a = cljs.core.array_list();
return ((function (a){
return (function() {
var G__9766 = null;
var G__9766__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9766__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__9760 = result;
var G__9761 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9760,G__9761) : rf.call(null,G__9760,G__9761));
})());
})());
var G__9762 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9762) : rf.call(null,G__9762));
});
var G__9766__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec(a.toArray());
a.clear();

var G__9763 = result;
var G__9764 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9763,G__9764) : rf.call(null,G__9763,G__9764));
} else {
return result;
}
});
G__9766 = function(result,input){
switch(arguments.length){
case 0:
return G__9766__0.call(this);
case 1:
return G__9766__1.call(this,result);
case 2:
return G__9766__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9766.cljs$core$IFn$_invoke$arity$0 = G__9766__0;
G__9766.cljs$core$IFn$_invoke$arity$1 = G__9766__1;
G__9766.cljs$core$IFn$_invoke$arity$2 = G__9766__2;
return G__9766;
})()
;})(a))
});
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4423__auto__ = cljs.core.seq(coll);
if(temp__4423__auto__){
var s = temp__4423__auto__;
return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s),cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_all.cljs$lang$maxFixedArity = 3;
/**
 * Returns a lazy sequence of successive items from coll while
 * (pred item) returns true. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.take_while = (function cljs$core$take_while(){
var G__9768 = arguments.length;
switch (G__9768) {
case 1:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__9775 = null;
var G__9775__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9775__1 = (function (result){
var G__9769 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9769) : rf.call(null,G__9769));
});
var G__9775__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__9770 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9770) : pred.call(null,G__9770));
})())){
var G__9771 = result;
var G__9772 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9771,G__9772) : rf.call(null,G__9771,G__9772));
} else {
return cljs.core.reduced(result);
}
});
G__9775 = function(result,input){
switch(arguments.length){
case 0:
return G__9775__0.call(this);
case 1:
return G__9775__1.call(this,result);
case 2:
return G__9775__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9775.cljs$core$IFn$_invoke$arity$0 = G__9775__0;
G__9775.cljs$core$IFn$_invoke$arity$1 = G__9775__1;
G__9775.cljs$core$IFn$_invoke$arity$2 = G__9775__2;
return G__9775;
})()
});
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4423__auto__ = cljs.core.seq(coll);
if(temp__4423__auto__){
var s = temp__4423__auto__;
if(cljs.core.truth_((function (){var G__9773 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9773) : pred.call(null,G__9773));
})())){
return cljs.core.cons(cljs.core.first(s),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take_while.cljs$lang$maxFixedArity = 2;
cljs.core.mk_bound_fn = (function cljs$core$mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator(sc);
var G__9780 = (function (){var G__9782 = cljs.core._entry_key(sc,e);
var G__9783 = key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9782,G__9783) : comp.call(null,G__9782,G__9783));
})();
var G__9781 = (0);
return (test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__9780,G__9781) : test.call(null,G__9780,G__9781));
});
});
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 * >=. Returns a seq of those entries with keys ek for
 * which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.subseq = (function cljs$core$subseq(){
var G__9785 = arguments.length;
switch (G__9785) {
case 3:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_,cljs.core._GT__EQ_], true).call(null,test))){
var temp__4423__auto__ = cljs.core._sorted_seq_from(sc,key,true);
if(cljs.core.truth_(temp__4423__auto__)){
var vec__9786 = temp__4423__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9786,(0),null);
var s = vec__9786;
if(cljs.core.truth_((function (){var G__9787 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__9787) : include.call(null,G__9787));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,true));
}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4423__auto__ = cljs.core._sorted_seq_from(sc,start_key,true);
if(cljs.core.truth_(temp__4423__auto__)){
var vec__9788 = temp__4423__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9788,(0),null);
var s = vec__9788;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,start_test,start_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.subseq.cljs$lang$maxFixedArity = 5;
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 * >=. Returns a reverse seq of those entries with keys ek for
 * which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.rsubseq = (function cljs$core$rsubseq(){
var G__9791 = arguments.length;
switch (G__9791) {
case 3:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_,cljs.core._LT__EQ_], true).call(null,test))){
var temp__4423__auto__ = cljs.core._sorted_seq_from(sc,key,false);
if(cljs.core.truth_(temp__4423__auto__)){
var vec__9792 = temp__4423__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9792,(0),null);
var s = vec__9792;
if(cljs.core.truth_((function (){var G__9793 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__9793) : include.call(null,G__9793));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,false));
}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4423__auto__ = cljs.core._sorted_seq_from(sc,end_key,false);
if(cljs.core.truth_(temp__4423__auto__)){
var vec__9794 = temp__4423__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9794,(0),null);
var s = vec__9794;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,end_test,end_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.rsubseq.cljs$lang$maxFixedArity = 5;

/**
* @constructor
*/
cljs.core.RangeIterator = (function (i,end,step){
this.i = i;
this.end = end;
this.step = step;
})
cljs.core.RangeIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__.step > (0))){
return (self__.i < self__.end);
} else {
return (self__.i > self__.end);
}
});

cljs.core.RangeIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.i;
self__.i = (self__.i + self__.step);

return ret;
});

cljs.core.RangeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"step","step",-1365547645,null)], null);
});

cljs.core.RangeIterator.cljs$lang$type = true;

cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";

cljs.core.RangeIterator.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/RangeIterator");
});

cljs.core.__GT_RangeIterator = (function cljs$core$__GT_RangeIterator(i,end,step){
return (new cljs.core.RangeIterator(i,end,step));
});


/**
* @constructor
*/
cljs.core.Range = (function (meta,start,end,step,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Range.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Range.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
throw (new Error("Index out of bounds"));
}
}
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
return not_found;
}
}
});

cljs.core.Range.prototype.cljs$core$IIterable$ = true;

cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RangeIterator(self__.start,self__.end,self__.step));
});

cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.meta;
});

cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Range(self__.meta,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if(((self__.start + self__.step) < self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
} else {
if(((self__.start + self__.step) > self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(cljs.core.not(cljs.core._seq(rng__$1))){
return (0);
} else {
var G__9796 = ((self__.end - self__.start) / self__.step);
return Math.ceil(G__9796);
}
});

cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var h__4341__auto__ = self__.__hash;
if(!((h__4341__auto__ == null))){
return h__4341__auto__;
} else {
var h__4341__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
self__.__hash = h__4341__auto____$1;

return h__4341__auto____$1;
}
});

cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var self__ = this;
var rng__$1 = this;
return cljs.core.equiv_sequential(rng__$1,other);
});

cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var self__ = this;
var rng__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1,f);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,init){
var self__ = this;
var rng__$1 = this;
var i = self__.start;
var ret = init;
while(true){
if((((self__.step > (0)))?(i < self__.end):(i > self__.end))){
var ret__$1 = (function (){var G__9797 = ret;
var G__9798 = i;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9797,G__9798) : f.call(null,G__9797,G__9798));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
var G__9799 = ret__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9799) : cljs.core.deref.call(null,G__9799));
} else {
var G__9800 = (i + self__.step);
var G__9801 = ret__$1;
i = G__9800;
ret = G__9801;
continue;
}
} else {
return ret;
}
break;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((cljs.core._seq(rng__$1) == null)){
return null;
} else {
return self__.start;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(!((cljs.core._seq(rng__$1) == null))){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if((self__.start < self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.start > self__.end)){
return rng__$1;
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,meta__$1){
var self__ = this;
var rng__$1 = this;
return (new cljs.core.Range(meta__$1,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var self__ = this;
var rng__$1 = this;
return cljs.core.cons(o,rng__$1);
});

cljs.core.Range.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"step","step",-1365547645,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null);
});

cljs.core.Range.cljs$lang$type = true;

cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";

cljs.core.Range.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/Range");
});

cljs.core.__GT_Range = (function cljs$core$__GT_Range(meta,start,end,step,__hash){
return (new cljs.core.Range(meta,start,end,step,__hash));
});

(cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
/**
 * Returns a lazy seq of nums from start (inclusive) to end
 * (exclusive), by step, where start defaults to 0, step to 1,
 * and end to infinity.
 */
cljs.core.range = (function cljs$core$range(){
var G__9803 = arguments.length;
switch (G__9803) {
case 0:
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.range.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.range.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),Number.MAX_VALUE,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$1 = (function (end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3(start,end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
return (new cljs.core.Range(null,start,end,step,null));
});

cljs.core.range.cljs$lang$maxFixedArity = 3;
/**
 * Returns a lazy seq of every nth item in coll.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.take_nth = (function cljs$core$take_nth(){
var G__9806 = arguments.length;
switch (G__9806) {
case 1:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__9811 = null;
var G__9811__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9811__1 = (function (result){
var G__9807 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9807) : rf.call(null,G__9807));
});
var G__9811__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
if((cljs.core.rem(i,n) === (0))){
var G__9808 = result;
var G__9809 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9808,G__9809) : rf.call(null,G__9808,G__9809));
} else {
return result;
}
});
G__9811 = function(result,input){
switch(arguments.length){
case 0:
return G__9811__0.call(this);
case 1:
return G__9811__1.call(this,result);
case 2:
return G__9811__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9811.cljs$core$IFn$_invoke$arity$0 = G__9811__0;
G__9811.cljs$core$IFn$_invoke$arity$1 = G__9811__1;
G__9811.cljs$core$IFn$_invoke$arity$2 = G__9811__2;
return G__9811;
})()
;})(ia))
});
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4423__auto__ = cljs.core.seq(coll);
if(temp__4423__auto__){
var s = temp__4423__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2(n,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.take_nth.cljs$lang$maxFixedArity = 2;
/**
 * Returns a vector of [(take-while pred coll) (drop-while pred coll)]
 */
cljs.core.split_with = (function cljs$core$split_with(pred,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,coll),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred,coll)], null);
});
/**
 * Applies f to each value in coll, splitting it each time f returns a
 * new value.  Returns a lazy seq of partitions.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_by = (function cljs$core$partition_by(){
var G__9814 = arguments.length;
switch (G__9814) {
case 1:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var a = cljs.core.array_list();
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (a,pa){
return (function() {
var G__9825 = null;
var G__9825__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9825__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__9815 = result;
var G__9816 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9815,G__9816) : rf.call(null,G__9815,G__9816));
})());
})());
var G__9817 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9817) : rf.call(null,G__9817));
});
var G__9825__2 = (function (result,input){
var pval = (function (){var G__9818 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9818) : cljs.core.deref.call(null,G__9818));
})();
var val = (function (){var G__9819 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9819) : f.call(null,G__9819));
})();
cljs.core.vreset_BANG_(pa,val);

if((cljs.core.keyword_identical_QMARK_(pval,new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,pval))){
a.add(input);

return result;
} else {
var v = cljs.core.vec(a.toArray());
a.clear();

var ret = (function (){var G__9820 = result;
var G__9821 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9820,G__9821) : rf.call(null,G__9820,G__9821));
})();
if(cljs.core.reduced_QMARK_(ret)){
} else {
a.add(input);
}

return ret;
}
});
G__9825 = function(result,input){
switch(arguments.length){
case 0:
return G__9825__0.call(this);
case 1:
return G__9825__1.call(this,result);
case 2:
return G__9825__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9825.cljs$core$IFn$_invoke$arity$0 = G__9825__0;
G__9825.cljs$core$IFn$_invoke$arity$1 = G__9825__1;
G__9825.cljs$core$IFn$_invoke$arity$2 = G__9825__2;
return G__9825;
})()
;})(a,pa))
});
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4423__auto__ = cljs.core.seq(coll);
if(temp__4423__auto__){
var s = temp__4423__auto__;
var fst = cljs.core.first(s);
var fv = (function (){var G__9822 = fst;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9822) : f.call(null,G__9822));
})();
var run = cljs.core.cons(fst,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (fst,fv,s,temp__4423__auto__){
return (function (p1__9812_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fv,(function (){var G__9823 = p1__9812_SHARP_;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9823) : f.call(null,G__9823));
})());
});})(fst,fv,s,temp__4423__auto__))
,cljs.core.next(s)));
return cljs.core.cons(run,cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(cljs.core.count(run),s))));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_by.cljs$lang$maxFixedArity = 2;
/**
 * Returns a map from distinct items in coll to the number of times
 * they appear.
 */
cljs.core.frequencies = (function cljs$core$frequencies(coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (counts,x){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(counts,x,(cljs.core.get.cljs$core$IFn$_invoke$arity$3(counts,x,(0)) + (1)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Returns a lazy seq of the intermediate values of the reduction (as
 * per reduce) of coll by f, starting with init.
 */
cljs.core.reductions = (function cljs$core$reductions(){
var G__9827 = arguments.length;
switch (G__9827) {
case 2:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4421__auto__ = cljs.core.seq(coll);
if(temp__4421__auto__){
var s = temp__4421__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.rest(s));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
}
}),null,null));
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$3 = (function (f,init,coll){
return cljs.core.cons(init,(new cljs.core.LazySeq(null,(function (){
var temp__4423__auto__ = cljs.core.seq(coll);
if(temp__4423__auto__){
var s = temp__4423__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,(function (){var G__9828 = init;
var G__9829 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9828,G__9829) : f.call(null,G__9828,G__9829));
})(),cljs.core.rest(s));
} else {
return null;
}
}),null,null)));
});

cljs.core.reductions.cljs$lang$maxFixedArity = 3;
/**
 * Takes a set of functions and returns a fn that is the juxtaposition
 * of those fns.  The returned fn takes a variable number of args, and
 * returns a vector containing the result of applying each fn to the
 * args (left-to-right).
 * ((juxt a b c) x) => [(a x) (b x) (c x)]
 */
cljs.core.juxt = (function cljs$core$juxt(){
var G__9846 = arguments.length;
switch (G__9846) {
case 1:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0)));
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4976__auto__);

}
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function() {
var G__9890 = null;
var G__9890__0 = (function (){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})()],null));
});
var G__9890__1 = (function (x){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9847 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9847) : f.call(null,G__9847));
})()],null));
});
var G__9890__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9848 = x;
var G__9849 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9848,G__9849) : f.call(null,G__9848,G__9849));
})()],null));
});
var G__9890__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9850 = x;
var G__9851 = y;
var G__9852 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9850,G__9851,G__9852) : f.call(null,G__9850,G__9851,G__9852));
})()],null));
});
var G__9890__4 = (function() { 
var G__9891__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args)],null));
};
var G__9891 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9892__i = 0, G__9892__a = new Array(arguments.length -  3);
while (G__9892__i < G__9892__a.length) {G__9892__a[G__9892__i] = arguments[G__9892__i + 3]; ++G__9892__i;}
  args = new cljs.core.IndexedSeq(G__9892__a,0);
} 
return G__9891__delegate.call(this,x,y,z,args);};
G__9891.cljs$lang$maxFixedArity = 3;
G__9891.cljs$lang$applyTo = (function (arglist__9893){
var x = cljs.core.first(arglist__9893);
arglist__9893 = cljs.core.next(arglist__9893);
var y = cljs.core.first(arglist__9893);
arglist__9893 = cljs.core.next(arglist__9893);
var z = cljs.core.first(arglist__9893);
var args = cljs.core.rest(arglist__9893);
return G__9891__delegate(x,y,z,args);
});
G__9891.cljs$core$IFn$_invoke$arity$variadic = G__9891__delegate;
return G__9891;
})()
;
G__9890 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9890__0.call(this);
case 1:
return G__9890__1.call(this,x);
case 2:
return G__9890__2.call(this,x,y);
case 3:
return G__9890__3.call(this,x,y,z);
default:
var G__9894 = null;
if (arguments.length > 3) {
var G__9895__i = 0, G__9895__a = new Array(arguments.length -  3);
while (G__9895__i < G__9895__a.length) {G__9895__a[G__9895__i] = arguments[G__9895__i + 3]; ++G__9895__i;}
G__9894 = new cljs.core.IndexedSeq(G__9895__a,0);
}
return G__9890__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9890.cljs$lang$maxFixedArity = 3;
G__9890.cljs$lang$applyTo = G__9890__4.cljs$lang$applyTo;
G__9890.cljs$core$IFn$_invoke$arity$0 = G__9890__0;
G__9890.cljs$core$IFn$_invoke$arity$1 = G__9890__1;
G__9890.cljs$core$IFn$_invoke$arity$2 = G__9890__2;
G__9890.cljs$core$IFn$_invoke$arity$3 = G__9890__3;
G__9890.cljs$core$IFn$_invoke$arity$variadic = G__9890__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9890;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__9896 = null;
var G__9896__0 = (function (){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})()],null));
});
var G__9896__1 = (function (x){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9853 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9853) : f.call(null,G__9853));
})(),(function (){var G__9854 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9854) : g.call(null,G__9854));
})()],null));
});
var G__9896__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9855 = x;
var G__9856 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9855,G__9856) : f.call(null,G__9855,G__9856));
})(),(function (){var G__9857 = x;
var G__9858 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__9857,G__9858) : g.call(null,G__9857,G__9858));
})()],null));
});
var G__9896__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9859 = x;
var G__9860 = y;
var G__9861 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9859,G__9860,G__9861) : f.call(null,G__9859,G__9860,G__9861));
})(),(function (){var G__9862 = x;
var G__9863 = y;
var G__9864 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__9862,G__9863,G__9864) : g.call(null,G__9862,G__9863,G__9864));
})()],null));
});
var G__9896__4 = (function() { 
var G__9897__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args)],null));
};
var G__9897 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9898__i = 0, G__9898__a = new Array(arguments.length -  3);
while (G__9898__i < G__9898__a.length) {G__9898__a[G__9898__i] = arguments[G__9898__i + 3]; ++G__9898__i;}
  args = new cljs.core.IndexedSeq(G__9898__a,0);
} 
return G__9897__delegate.call(this,x,y,z,args);};
G__9897.cljs$lang$maxFixedArity = 3;
G__9897.cljs$lang$applyTo = (function (arglist__9899){
var x = cljs.core.first(arglist__9899);
arglist__9899 = cljs.core.next(arglist__9899);
var y = cljs.core.first(arglist__9899);
arglist__9899 = cljs.core.next(arglist__9899);
var z = cljs.core.first(arglist__9899);
var args = cljs.core.rest(arglist__9899);
return G__9897__delegate(x,y,z,args);
});
G__9897.cljs$core$IFn$_invoke$arity$variadic = G__9897__delegate;
return G__9897;
})()
;
G__9896 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9896__0.call(this);
case 1:
return G__9896__1.call(this,x);
case 2:
return G__9896__2.call(this,x,y);
case 3:
return G__9896__3.call(this,x,y,z);
default:
var G__9900 = null;
if (arguments.length > 3) {
var G__9901__i = 0, G__9901__a = new Array(arguments.length -  3);
while (G__9901__i < G__9901__a.length) {G__9901__a[G__9901__i] = arguments[G__9901__i + 3]; ++G__9901__i;}
G__9900 = new cljs.core.IndexedSeq(G__9901__a,0);
}
return G__9896__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9896.cljs$lang$maxFixedArity = 3;
G__9896.cljs$lang$applyTo = G__9896__4.cljs$lang$applyTo;
G__9896.cljs$core$IFn$_invoke$arity$0 = G__9896__0;
G__9896.cljs$core$IFn$_invoke$arity$1 = G__9896__1;
G__9896.cljs$core$IFn$_invoke$arity$2 = G__9896__2;
G__9896.cljs$core$IFn$_invoke$arity$3 = G__9896__3;
G__9896.cljs$core$IFn$_invoke$arity$variadic = G__9896__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9896;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__9902 = null;
var G__9902__0 = (function (){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})(),(function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})()],null));
});
var G__9902__1 = (function (x){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9865 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9865) : f.call(null,G__9865));
})(),(function (){var G__9866 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9866) : g.call(null,G__9866));
})(),(function (){var G__9867 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__9867) : h.call(null,G__9867));
})()],null));
});
var G__9902__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9868 = x;
var G__9869 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9868,G__9869) : f.call(null,G__9868,G__9869));
})(),(function (){var G__9870 = x;
var G__9871 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__9870,G__9871) : g.call(null,G__9870,G__9871));
})(),(function (){var G__9872 = x;
var G__9873 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__9872,G__9873) : h.call(null,G__9872,G__9873));
})()],null));
});
var G__9902__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9874 = x;
var G__9875 = y;
var G__9876 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9874,G__9875,G__9876) : f.call(null,G__9874,G__9875,G__9876));
})(),(function (){var G__9877 = x;
var G__9878 = y;
var G__9879 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__9877,G__9878,G__9879) : g.call(null,G__9877,G__9878,G__9879));
})(),(function (){var G__9880 = x;
var G__9881 = y;
var G__9882 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__9880,G__9881,G__9882) : h.call(null,G__9880,G__9881,G__9882));
})()],null));
});
var G__9902__4 = (function() { 
var G__9903__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args)],null));
};
var G__9903 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9904__i = 0, G__9904__a = new Array(arguments.length -  3);
while (G__9904__i < G__9904__a.length) {G__9904__a[G__9904__i] = arguments[G__9904__i + 3]; ++G__9904__i;}
  args = new cljs.core.IndexedSeq(G__9904__a,0);
} 
return G__9903__delegate.call(this,x,y,z,args);};
G__9903.cljs$lang$maxFixedArity = 3;
G__9903.cljs$lang$applyTo = (function (arglist__9905){
var x = cljs.core.first(arglist__9905);
arglist__9905 = cljs.core.next(arglist__9905);
var y = cljs.core.first(arglist__9905);
arglist__9905 = cljs.core.next(arglist__9905);
var z = cljs.core.first(arglist__9905);
var args = cljs.core.rest(arglist__9905);
return G__9903__delegate(x,y,z,args);
});
G__9903.cljs$core$IFn$_invoke$arity$variadic = G__9903__delegate;
return G__9903;
})()
;
G__9902 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9902__0.call(this);
case 1:
return G__9902__1.call(this,x);
case 2:
return G__9902__2.call(this,x,y);
case 3:
return G__9902__3.call(this,x,y,z);
default:
var G__9906 = null;
if (arguments.length > 3) {
var G__9907__i = 0, G__9907__a = new Array(arguments.length -  3);
while (G__9907__i < G__9907__a.length) {G__9907__a[G__9907__i] = arguments[G__9907__i + 3]; ++G__9907__i;}
G__9906 = new cljs.core.IndexedSeq(G__9907__a,0);
}
return G__9902__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9902.cljs$lang$maxFixedArity = 3;
G__9902.cljs$lang$applyTo = G__9902__4.cljs$lang$applyTo;
G__9902.cljs$core$IFn$_invoke$arity$0 = G__9902__0;
G__9902.cljs$core$IFn$_invoke$arity$1 = G__9902__1;
G__9902.cljs$core$IFn$_invoke$arity$2 = G__9902__2;
G__9902.cljs$core$IFn$_invoke$arity$3 = G__9902__3;
G__9902.cljs$core$IFn$_invoke$arity$variadic = G__9902__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9902;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic = (function (f,g,h,fs){
var fs__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f,g,h,fs);
return ((function (fs__$1){
return (function() {
var G__9908 = null;
var G__9908__0 = (function (){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9831_SHARP_,p2__9832_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9831_SHARP_,(function (){return (p2__9832_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p2__9832_SHARP_.cljs$core$IFn$_invoke$arity$0() : p2__9832_SHARP_.call(null));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9908__1 = (function (x){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9833_SHARP_,p2__9834_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9833_SHARP_,(function (){var G__9883 = x;
return (p2__9834_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p2__9834_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9883) : p2__9834_SHARP_.call(null,G__9883));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9908__2 = (function (x,y){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9835_SHARP_,p2__9836_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9835_SHARP_,(function (){var G__9884 = x;
var G__9885 = y;
return (p2__9836_SHARP_.cljs$core$IFn$_invoke$arity$2 ? p2__9836_SHARP_.cljs$core$IFn$_invoke$arity$2(G__9884,G__9885) : p2__9836_SHARP_.call(null,G__9884,G__9885));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9908__3 = (function (x,y,z){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9837_SHARP_,p2__9838_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9837_SHARP_,(function (){var G__9886 = x;
var G__9887 = y;
var G__9888 = z;
return (p2__9838_SHARP_.cljs$core$IFn$_invoke$arity$3 ? p2__9838_SHARP_.cljs$core$IFn$_invoke$arity$3(G__9886,G__9887,G__9888) : p2__9838_SHARP_.call(null,G__9886,G__9887,G__9888));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9908__4 = (function() { 
var G__9909__delegate = function (x,y,z,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9839_SHARP_,p2__9840_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9839_SHARP_,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(p2__9840_SHARP_,x,y,z,args));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
};
var G__9909 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9910__i = 0, G__9910__a = new Array(arguments.length -  3);
while (G__9910__i < G__9910__a.length) {G__9910__a[G__9910__i] = arguments[G__9910__i + 3]; ++G__9910__i;}
  args = new cljs.core.IndexedSeq(G__9910__a,0);
} 
return G__9909__delegate.call(this,x,y,z,args);};
G__9909.cljs$lang$maxFixedArity = 3;
G__9909.cljs$lang$applyTo = (function (arglist__9911){
var x = cljs.core.first(arglist__9911);
arglist__9911 = cljs.core.next(arglist__9911);
var y = cljs.core.first(arglist__9911);
arglist__9911 = cljs.core.next(arglist__9911);
var z = cljs.core.first(arglist__9911);
var args = cljs.core.rest(arglist__9911);
return G__9909__delegate(x,y,z,args);
});
G__9909.cljs$core$IFn$_invoke$arity$variadic = G__9909__delegate;
return G__9909;
})()
;
G__9908 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9908__0.call(this);
case 1:
return G__9908__1.call(this,x);
case 2:
return G__9908__2.call(this,x,y);
case 3:
return G__9908__3.call(this,x,y,z);
default:
var G__9912 = null;
if (arguments.length > 3) {
var G__9913__i = 0, G__9913__a = new Array(arguments.length -  3);
while (G__9913__i < G__9913__a.length) {G__9913__a[G__9913__i] = arguments[G__9913__i + 3]; ++G__9913__i;}
G__9912 = new cljs.core.IndexedSeq(G__9913__a,0);
}
return G__9908__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9908.cljs$lang$maxFixedArity = 3;
G__9908.cljs$lang$applyTo = G__9908__4.cljs$lang$applyTo;
G__9908.cljs$core$IFn$_invoke$arity$0 = G__9908__0;
G__9908.cljs$core$IFn$_invoke$arity$1 = G__9908__1;
G__9908.cljs$core$IFn$_invoke$arity$2 = G__9908__2;
G__9908.cljs$core$IFn$_invoke$arity$3 = G__9908__3;
G__9908.cljs$core$IFn$_invoke$arity$variadic = G__9908__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9908;
})()
;})(fs__$1))
});

cljs.core.juxt.cljs$lang$applyTo = (function (seq9841){
var G__9842 = cljs.core.first(seq9841);
var seq9841__$1 = cljs.core.next(seq9841);
var G__9843 = cljs.core.first(seq9841__$1);
var seq9841__$2 = cljs.core.next(seq9841__$1);
var G__9844 = cljs.core.first(seq9841__$2);
var seq9841__$3 = cljs.core.next(seq9841__$2);
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic(G__9842,G__9843,G__9844,seq9841__$3);
});

cljs.core.juxt.cljs$lang$maxFixedArity = (3);
/**
 * When lazy sequences are produced via functions that have side
 * effects, any effects other than those needed to produce the first
 * element in the seq do not occur until the seq is consumed. dorun can
 * be used to force any effects. Walks through the successive nexts of
 * the seq, does not retain the head and returns nil.
 */
cljs.core.dorun = (function cljs$core$dorun(){
var G__9915 = arguments.length;
switch (G__9915) {
case 1:
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.dorun.cljs$core$IFn$_invoke$arity$1 = (function (coll){
while(true){
if(cljs.core.seq(coll)){
var G__9917 = cljs.core.next(coll);
coll = G__9917;
continue;
} else {
return null;
}
break;
}
});

cljs.core.dorun.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
while(true){
if((cljs.core.seq(coll)) && ((n > (0)))){
var G__9918 = (n - (1));
var G__9919 = cljs.core.next(coll);
n = G__9918;
coll = G__9919;
continue;
} else {
return null;
}
break;
}
});

cljs.core.dorun.cljs$lang$maxFixedArity = 2;
/**
 * When lazy sequences are produced via functions that have side
 * effects, any effects other than those needed to produce the first
 * element in the seq do not occur until the seq is consumed. doall can
 * be used to force any effects. Walks through the successive nexts of
 * the seq, retains the head and returns it, thus causing the entire
 * seq to reside in memory at one time.
 */
cljs.core.doall = (function cljs$core$doall(){
var G__9921 = arguments.length;
switch (G__9921) {
case 1:
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.doall.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.doall.cljs$core$IFn$_invoke$arity$1 = (function (coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(coll);

return coll;
});

cljs.core.doall.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$2(n,coll);

return coll;
});

cljs.core.doall.cljs$lang$maxFixedArity = 2;
/**
 * Returns true if x is a JavaScript RegExp instance.
 */
cljs.core.regexp_QMARK_ = (function cljs$core$regexp_QMARK_(x){
return (x instanceof RegExp);
});
/**
 * Returns the result of (re-find re s) if re fully matches s.
 */
cljs.core.re_matches = (function cljs$core$re_matches(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(matches),s)){
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
} else {
return null;
}
} else {
throw (new TypeError("re-matches must match against a string."));
}
});
/**
 * Returns the first regex match, if any, of s to re, using
 * re.exec(s). Returns a vector, containing first the matching
 * substring, then any capturing groups if the regular expression contains
 * capturing groups.
 */
cljs.core.re_find = (function cljs$core$re_find(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if((matches == null)){
return null;
} else {
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
}
} else {
throw (new TypeError("re-find must match against a string."));
}
});
/**
 * Returns a lazy sequence of successive matches of re in s.
 */
cljs.core.re_seq = (function cljs$core$re_seq(re,s){
var match_data = cljs.core.re_find(re,s);
var match_idx = s.search(re);
var match_str = ((cljs.core.coll_QMARK_(match_data))?cljs.core.first(match_data):match_data);
var post_match = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(match_idx + cljs.core.count(match_str)));
if(cljs.core.truth_(match_data)){
return (new cljs.core.LazySeq(null,((function (match_data,match_idx,match_str,post_match){
return (function (){
return cljs.core.cons(match_data,((cljs.core.seq(post_match))?cljs$core$re_seq(re,post_match):null));
});})(match_data,match_idx,match_str,post_match))
,null,null));
} else {
return null;
}
});
/**
 * Returns an instance of RegExp which has compiled the provided string.
 */
cljs.core.re_pattern = (function cljs$core$re_pattern(s){
if((s instanceof RegExp)){
return s;
} else {
var vec__9926 = cljs.core.re_find(/^\(\?([idmsux]*)\)/,s);
var prefix = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9926,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9926,(1),null);
var pattern = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,cljs.core.count(prefix));
return (new RegExp(pattern,(function (){var or__3925__auto__ = flags;
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return "";
}
})()));
}
});
cljs.core.pr_sequential_writer = (function cljs$core$pr_sequential_writer(writer,print_one,begin,sep,end,opts,coll){
var _STAR_print_level_STAR_9934 = cljs.core._STAR_print_level_STAR_;
cljs.core._STAR_print_level_STAR_ = (((cljs.core._STAR_print_level_STAR_ == null))?null:(cljs.core._STAR_print_level_STAR_ - (1)));

try{if((!((cljs.core._STAR_print_level_STAR_ == null))) && ((cljs.core._STAR_print_level_STAR_ < (0)))){
return cljs.core._write(writer,"#");
} else {
cljs.core._write(writer,begin);

if((new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) === (0))){
if(cljs.core.seq(coll)){
cljs.core._write(writer,(function (){var or__3925__auto__ = new cljs.core.Keyword(null,"more-marker","more-marker",-14717935).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return "...";
}
})());
} else {
}
} else {
if(cljs.core.seq(coll)){
var G__9935_9941 = cljs.core.first(coll);
var G__9936_9942 = writer;
var G__9937_9943 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__9935_9941,G__9936_9942,G__9937_9943) : print_one.call(null,G__9935_9941,G__9936_9942,G__9937_9943));
} else {
}

var coll_9944__$1 = cljs.core.next(coll);
var n_9945 = (new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) - (1));
while(true){
if((coll_9944__$1) && (((n_9945 == null)) || (!((n_9945 === (0)))))){
cljs.core._write(writer,sep);

var G__9938_9946 = cljs.core.first(coll_9944__$1);
var G__9939_9947 = writer;
var G__9940_9948 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__9938_9946,G__9939_9947,G__9940_9948) : print_one.call(null,G__9938_9946,G__9939_9947,G__9940_9948));

var G__9949 = cljs.core.next(coll_9944__$1);
var G__9950 = (n_9945 - (1));
coll_9944__$1 = G__9949;
n_9945 = G__9950;
continue;
} else {
if((cljs.core.seq(coll_9944__$1)) && ((n_9945 === (0)))){
cljs.core._write(writer,sep);

cljs.core._write(writer,(function (){var or__3925__auto__ = new cljs.core.Keyword(null,"more-marker","more-marker",-14717935).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return "...";
}
})());
} else {
}
}
break;
}
}

return cljs.core._write(writer,end);
}
}finally {cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_9934;
}});
cljs.core.write_all = (function cljs$core$write_all(){
var argseq__4965__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4965__auto__);
});

cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic = (function (writer,ss){
var seq__9953 = cljs.core.seq(ss);
var chunk__9954 = null;
var count__9955 = (0);
var i__9956 = (0);
while(true){
if((i__9956 < count__9955)){
var s = chunk__9954.cljs$core$IIndexed$_nth$arity$2(null,i__9956);
cljs.core._write(writer,s);

var G__9957 = seq__9953;
var G__9958 = chunk__9954;
var G__9959 = count__9955;
var G__9960 = (i__9956 + (1));
seq__9953 = G__9957;
chunk__9954 = G__9958;
count__9955 = G__9959;
i__9956 = G__9960;
continue;
} else {
var temp__4423__auto__ = cljs.core.seq(seq__9953);
if(temp__4423__auto__){
var seq__9953__$1 = temp__4423__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9953__$1)){
var c__4710__auto__ = cljs.core.chunk_first(seq__9953__$1);
var G__9961 = cljs.core.chunk_rest(seq__9953__$1);
var G__9962 = c__4710__auto__;
var G__9963 = cljs.core.count(c__4710__auto__);
var G__9964 = (0);
seq__9953 = G__9961;
chunk__9954 = G__9962;
count__9955 = G__9963;
i__9956 = G__9964;
continue;
} else {
var s = cljs.core.first(seq__9953__$1);
cljs.core._write(writer,s);

var G__9965 = cljs.core.next(seq__9953__$1);
var G__9966 = null;
var G__9967 = (0);
var G__9968 = (0);
seq__9953 = G__9965;
chunk__9954 = G__9966;
count__9955 = G__9967;
i__9956 = G__9968;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.write_all.cljs$lang$maxFixedArity = (1);

cljs.core.write_all.cljs$lang$applyTo = (function (seq9951){
var G__9952 = cljs.core.first(seq9951);
var seq9951__$1 = cljs.core.next(seq9951);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(G__9952,seq9951__$1);
});
cljs.core.string_print = (function cljs$core$string_print(x){
(cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.core._STAR_print_fn_STAR_.call(null,x));

return null;
});
cljs.core.flush = (function cljs$core$flush(){
return null;
});
cljs.core.char_escapes = (function (){var obj9970 = {"\"":"\\\"","\\":"\\\\","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};
return obj9970;
})();
cljs.core.quote_string = (function cljs$core$quote_string(s){
return [cljs.core.str("\""),cljs.core.str(s.replace((function (){var G__9973 = "[\\\\\"\b\f\n\r\t]";
var G__9974 = "g";
return RegExp(G__9973,G__9974);
})(),(function (match){
return (cljs.core.char_escapes[match]);
}))),cljs.core.str("\"")].join('');
});
cljs.core.pr_writer_impl = (function cljs$core$pr_writer_impl(obj,writer,opts){
if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if((void 0 === obj)){
return cljs.core._write(writer,"#<undefined>");
} else {
if(cljs.core.truth_((function (){var and__3913__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.core.truth_(and__3913__auto__)){
var and__3913__auto____$1 = (function (){var G__9988 = obj;
if(G__9988){
var bit__4599__auto__ = (G__9988.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4599__auto__) || (G__9988.cljs$core$IMeta$)){
return true;
} else {
if((!G__9988.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__9988);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__9988);
}
})();
if(and__3913__auto____$1){
return cljs.core.meta(obj);
} else {
return and__3913__auto____$1;
}
} else {
return and__3913__auto__;
}
})())){
cljs.core._write(writer,"^");

var G__9989_9999 = cljs.core.meta(obj);
var G__9990_10000 = writer;
var G__9991_10001 = opts;
(cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3(G__9989_9999,G__9990_10000,G__9991_10001) : cljs.core.pr_writer.call(null,G__9989_9999,G__9990_10000,G__9991_10001));

cljs.core._write(writer," ");
} else {
}

if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if(obj.cljs$lang$type){
return obj.cljs$lang$ctorPrWriter(obj,writer,opts);
} else {
if((function (){var G__9992 = obj;
if(G__9992){
var bit__4592__auto__ = (G__9992.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4592__auto__) || (G__9992.cljs$core$IPrintWithWriter$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,opts);
} else {
if(((cljs.core.type(obj) === Boolean)) || (typeof obj === 'number')){
return cljs.core._write(writer,[cljs.core.str(obj)].join(''));
} else {
if(cljs.core.object_QMARK_(obj)){
cljs.core._write(writer,"#js ");

var G__9993 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (k){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),(obj[k])], null);
}),cljs.core.js_keys(obj));
var G__9994 = cljs.core.pr_writer;
var G__9995 = writer;
var G__9996 = opts;
return (cljs.core.print_map.cljs$core$IFn$_invoke$arity$4 ? cljs.core.print_map.cljs$core$IFn$_invoke$arity$4(G__9993,G__9994,G__9995,G__9996) : cljs.core.print_map.call(null,G__9993,G__9994,G__9995,G__9996));
} else {
if(cljs.core.array_QMARK_(obj)){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#js ["," ","]",opts,obj);
} else {
if(cljs.core.truth_((function (){var G__9997 = obj;
return goog.isString(G__9997);
})())){
if(cljs.core.truth_(new cljs.core.Keyword(null,"readably","readably",1129599760).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core._write(writer,cljs.core.quote_string(obj));
} else {
return cljs.core._write(writer,obj);
}
} else {
if(cljs.core.fn_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));
} else {
if((obj instanceof Date)){
var normalize = (function (n,len){
var ns = [cljs.core.str(n)].join('');
while(true){
if((cljs.core.count(ns) < len)){
var G__10002 = [cljs.core.str("0"),cljs.core.str(ns)].join('');
ns = G__10002;
continue;
} else {
return ns;
}
break;
}
});
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#inst \"",[cljs.core.str(obj.getUTCFullYear())].join(''),"-",normalize((obj.getUTCMonth() + (1)),(2)),"-",normalize(obj.getUTCDate(),(2)),"T",normalize(obj.getUTCHours(),(2)),":",normalize(obj.getUTCMinutes(),(2)),":",normalize(obj.getUTCSeconds(),(2)),".",normalize(obj.getUTCMilliseconds(),(3)),"-","00:00\""], 0));
} else {
if(cljs.core.truth_(cljs.core.regexp_QMARK_(obj))){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#\"",obj.source,"\""], 0));
} else {
if((function (){var G__9998 = obj;
if(G__9998){
var bit__4599__auto__ = (G__9998.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4599__auto__) || (G__9998.cljs$core$IPrintWithWriter$)){
return true;
} else {
if((!G__9998.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__9998);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__9998);
}
})()){
return cljs.core._pr_writer(obj,writer,opts);
} else {
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));

}
}
}
}
}
}
}
}
}
}
}

}
}
});
/**
 * Prefer this to pr-seq, because it makes the printing function
 * configurable, allowing efficient implementations such as appending
 * to a StringBuffer.
 */
cljs.core.pr_writer = (function cljs$core$pr_writer(obj,writer,opts){
var temp__4421__auto__ = new cljs.core.Keyword(null,"alt-impl","alt-impl",670969595).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4421__auto__)){
var alt_impl = temp__4421__auto__;
var G__10006 = obj;
var G__10007 = writer;
var G__10008 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"fallback-impl","fallback-impl",-1501286995),cljs.core.pr_writer_impl);
return (alt_impl.cljs$core$IFn$_invoke$arity$3 ? alt_impl.cljs$core$IFn$_invoke$arity$3(G__10006,G__10007,G__10008) : alt_impl.call(null,G__10006,G__10007,G__10008));
} else {
return cljs.core.pr_writer_impl(obj,writer,opts);
}
});
cljs.core.pr_seq_writer = (function cljs$core$pr_seq_writer(objs,writer,opts){
cljs.core.pr_writer(cljs.core.first(objs),writer,opts);

var seq__10013 = cljs.core.seq(cljs.core.next(objs));
var chunk__10014 = null;
var count__10015 = (0);
var i__10016 = (0);
while(true){
if((i__10016 < count__10015)){
var obj = chunk__10014.cljs$core$IIndexed$_nth$arity$2(null,i__10016);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__10017 = seq__10013;
var G__10018 = chunk__10014;
var G__10019 = count__10015;
var G__10020 = (i__10016 + (1));
seq__10013 = G__10017;
chunk__10014 = G__10018;
count__10015 = G__10019;
i__10016 = G__10020;
continue;
} else {
var temp__4423__auto__ = cljs.core.seq(seq__10013);
if(temp__4423__auto__){
var seq__10013__$1 = temp__4423__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10013__$1)){
var c__4710__auto__ = cljs.core.chunk_first(seq__10013__$1);
var G__10021 = cljs.core.chunk_rest(seq__10013__$1);
var G__10022 = c__4710__auto__;
var G__10023 = cljs.core.count(c__4710__auto__);
var G__10024 = (0);
seq__10013 = G__10021;
chunk__10014 = G__10022;
count__10015 = G__10023;
i__10016 = G__10024;
continue;
} else {
var obj = cljs.core.first(seq__10013__$1);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__10025 = cljs.core.next(seq__10013__$1);
var G__10026 = null;
var G__10027 = (0);
var G__10028 = (0);
seq__10013 = G__10025;
chunk__10014 = G__10026;
count__10015 = G__10027;
i__10016 = G__10028;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.core.pr_sb_with_opts = (function cljs$core$pr_sb_with_opts(objs,opts){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
cljs.core.pr_seq_writer(objs,writer,opts);

writer.cljs$core$IWriter$_flush$arity$1(null);

return sb;
});
/**
 * Prints a sequence of objects to a string, observing all the
 * options given in opts
 */
cljs.core.pr_str_with_opts = (function cljs$core$pr_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "";
} else {
return [cljs.core.str(cljs.core.pr_sb_with_opts(objs,opts))].join('');
}
});
/**
 * Same as pr-str-with-opts followed by (newline)
 */
cljs.core.prn_str_with_opts = (function cljs$core$prn_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "\n";
} else {
var sb = cljs.core.pr_sb_with_opts(objs,opts);
sb.append("\n");

return [cljs.core.str(sb)].join('');
}
});
/**
 * Prints a sequence of objects using string-print, observing all
 * the options given in opts
 */
cljs.core.pr_with_opts = (function cljs$core$pr_with_opts(objs,opts){
return cljs.core.string_print(cljs.core.pr_str_with_opts(objs,opts));
});
cljs.core.newline = (function cljs$core$newline(){
var G__10030 = arguments.length;
switch (G__10030) {
case 0:
return cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.newline.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.newline.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.newline.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.newline.cljs$core$IFn$_invoke$arity$1 = (function (opts){
cljs.core.string_print("\n");

if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939)))){
return cljs.core.flush();
} else {
return null;
}
});

cljs.core.newline.cljs$lang$maxFixedArity = 1;
/**
 * pr to a string, returning it. Fundamental entrypoint to IPrintWithWriter.
 */
cljs.core.pr_str = (function cljs$core$pr_str(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.pr_opts());
});

cljs.core.pr_str.cljs$lang$maxFixedArity = (0);

cljs.core.pr_str.cljs$lang$applyTo = (function (seq10032){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10032));
});
/**
 * Same as pr-str followed by (newline)
 */
cljs.core.prn_str = (function cljs$core$prn_str(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.prn_str.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.prn_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.pr_opts());
});

cljs.core.prn_str.cljs$lang$maxFixedArity = (0);

cljs.core.prn_str.cljs$lang$applyTo = (function (seq10033){
return cljs.core.prn_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10033));
});
/**
 * Prints the object(s) using string-print.  Prints the
 * object(s), separated by spaces if there is more than one.
 * By default, pr and prn print in a way that objects can be
 * read by the reader
 */
cljs.core.pr = (function cljs$core$pr(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.pr_opts());
});

cljs.core.pr.cljs$lang$maxFixedArity = (0);

cljs.core.pr.cljs$lang$applyTo = (function (seq10034){
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10034));
});
/**
 * Prints the object(s) using string-print.
 * print and println produce output for human consumption.
 * @param {...*} var_args
 */
cljs.core.print = (function() { 
var cljs$core$cljs_core_print__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs$core$cljs_core_print = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10035__i = 0, G__10035__a = new Array(arguments.length -  0);
while (G__10035__i < G__10035__a.length) {G__10035__a[G__10035__i] = arguments[G__10035__i + 0]; ++G__10035__i;}
  objs = new cljs.core.IndexedSeq(G__10035__a,0);
} 
return cljs$core$cljs_core_print__delegate.call(this,objs);};
cljs$core$cljs_core_print.cljs$lang$maxFixedArity = 0;
cljs$core$cljs_core_print.cljs$lang$applyTo = (function (arglist__10036){
var objs = cljs.core.seq(arglist__10036);
return cljs$core$cljs_core_print__delegate(objs);
});
cljs$core$cljs_core_print.cljs$core$IFn$_invoke$arity$variadic = cljs$core$cljs_core_print__delegate;
return cljs$core$cljs_core_print;
})()
;
/**
 * print to a string, returning it
 */
cljs.core.print_str = (function cljs$core$print_str(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
});

cljs.core.print_str.cljs$lang$maxFixedArity = (0);

cljs.core.print_str.cljs$lang$applyTo = (function (seq10037){
return cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10037));
});
/**
 * Same as print followed by (newline)
 */
cljs.core.println = (function cljs$core$println(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_opts());
} else {
return null;
}
});

cljs.core.println.cljs$lang$maxFixedArity = (0);

cljs.core.println.cljs$lang$applyTo = (function (seq10038){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10038));
});
/**
 * println to a string, returning it
 */
cljs.core.println_str = (function cljs$core$println_str(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.println_str.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.println_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
});

cljs.core.println_str.cljs$lang$maxFixedArity = (0);

cljs.core.println_str.cljs$lang$applyTo = (function (seq10039){
return cljs.core.println_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10039));
});
/**
 * Same as pr followed by (newline).
 */
cljs.core.prn = (function cljs$core$prn(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
cljs.core.pr_with_opts(objs,cljs.core.pr_opts());

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_opts());
} else {
return null;
}
});

cljs.core.prn.cljs$lang$maxFixedArity = (0);

cljs.core.prn.cljs$lang$applyTo = (function (seq10040){
return cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10040));
});
cljs.core.print_map = (function cljs$core$print_map(m,print_one,writer,opts){
return cljs.core.pr_sequential_writer(writer,(function (e,w,opts__$1){
var G__10047_10053 = cljs.core.key(e);
var G__10048_10054 = w;
var G__10049_10055 = opts__$1;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__10047_10053,G__10048_10054,G__10049_10055) : print_one.call(null,G__10047_10053,G__10048_10054,G__10049_10055));

cljs.core._write(w," ");

var G__10050 = cljs.core.val(e);
var G__10051 = w;
var G__10052 = opts__$1;
return (print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__10050,G__10051,G__10052) : print_one.call(null,G__10050,G__10051,G__10052));
}),"{",", ","}",opts,cljs.core.seq(m));
});
cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Volatile: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#'");

return cljs.core.pr_writer(a__$1.sym,writer,opts);
});

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Atom: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core._write(writer,"()");
});

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#queue ["," ","]",opts,cljs.core.seq(coll__$1));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.List.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.List.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});
cljs.core.Symbol.prototype.cljs$core$IComparable$ = true;

cljs.core.Symbol.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
if((y instanceof cljs.core.Symbol)){
return cljs.core.compare_symbols(x__$1,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x__$1),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
});

cljs.core.Keyword.prototype.cljs$core$IComparable$ = true;

cljs.core.Keyword.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
if((y instanceof cljs.core.Keyword)){
return cljs.core.compare_keywords(x__$1,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x__$1),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
});

cljs.core.Subvec.prototype.cljs$core$IComparable$ = true;

cljs.core.Subvec.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
if(cljs.core.vector_QMARK_(y)){
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x__$1),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
});

cljs.core.PersistentVector.prototype.cljs$core$IComparable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
if(cljs.core.vector_QMARK_(y)){
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x__$1),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
});
/**
 * Atomically sets the metadata for a namespace/var/ref/agent/atom to be:
 * 
 * (apply f its-current-meta args)
 * 
 * f must be free of side-effects
 */
cljs.core.alter_meta_BANG_ = (function cljs$core$alter_meta_BANG_(){
var argseq__4965__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4965__auto__);
});

cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (iref,f,args){
return iref.meta = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,iref.meta,args);
});

cljs.core.alter_meta_BANG_.cljs$lang$maxFixedArity = (2);

cljs.core.alter_meta_BANG_.cljs$lang$applyTo = (function (seq10056){
var G__10057 = cljs.core.first(seq10056);
var seq10056__$1 = cljs.core.next(seq10056);
var G__10058 = cljs.core.first(seq10056__$1);
var seq10056__$2 = cljs.core.next(seq10056__$1);
return cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10057,G__10058,seq10056__$2);
});
/**
 * Atomically resets the metadata for an atom
 */
cljs.core.reset_meta_BANG_ = (function cljs$core$reset_meta_BANG_(iref,m){
return iref.meta = m;
});
/**
 * Alpha - subject to change.
 * 
 * Adds a watch function to an atom reference. The watch fn must be a
 * fn of 4 args: a key, the reference, its old-state, its
 * new-state. Whenever the reference's state might have been changed,
 * any registered watches will have their functions called. The watch
 * fn will be called synchronously. Note that an atom's state
 * may have changed again prior to the fn call, so use old/new-state
 * rather than derefing the reference. Keys must be unique per
 * reference, and can be used to remove the watch with remove-watch,
 * but are otherwise considered opaque by the watch mechanism.  Bear in
 * mind that regardless of the result or action of the watch fns the
 * atom's value will change.  Example:
 * 
 * (def a (atom 0))
 * (add-watch a :inc (fn [k r o n] (assert (== 0 n))))
 * (swap! a inc)
 * ;; Assertion Error
 * (deref a)
 * ;=> 1
 */
cljs.core.add_watch = (function cljs$core$add_watch(iref,key,f){
cljs.core._add_watch(iref,key,f);

return iref;
});
/**
 * Alpha - subject to change.
 * 
 * Removes a watch (set by add-watch) from a reference
 */
cljs.core.remove_watch = (function cljs$core$remove_watch(iref,key){
cljs.core._remove_watch(iref,key);

return iref;
});
cljs.core.gensym_counter = null;
/**
 * Returns a new symbol with a unique name. If a prefix string is
 * supplied, the name is prefix# where # is some unique number. If
 * prefix is not supplied, the prefix is 'G__'.
 */
cljs.core.gensym = (function cljs$core$gensym(){
var G__10060 = arguments.length;
switch (G__10060) {
case 0:
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.gensym.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("G__");
});

cljs.core.gensym.cljs$core$IFn$_invoke$arity$1 = (function (prefix_string){
if((cljs.core.gensym_counter == null)){
cljs.core.gensym_counter = (function (){var G__10061 = (0);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__10061) : cljs.core.atom.call(null,G__10061));
})();
} else {
}

return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str(prefix_string),cljs.core.str(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.gensym_counter,cljs.core.inc))].join(''));
});

cljs.core.gensym.cljs$lang$maxFixedArity = 1;
cljs.core.fixture1 = (1);
cljs.core.fixture2 = (2);

/**
* @constructor
*/
cljs.core.Delay = (function (f,value){
this.f = f;
this.value = value;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 1;
})
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.f)){
self__.value = (function (){return (self__.f.cljs$core$IFn$_invoke$arity$0 ? self__.f.cljs$core$IFn$_invoke$arity$0() : self__.f.call(null));
})();

self__.f = null;
} else {
}

return self__.value;
});

cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (d){
var self__ = this;
var d__$1 = this;
return cljs.core.not(self__.f);
});

cljs.core.Delay.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"value","value",1946509744,null)], null);
});

cljs.core.Delay.cljs$lang$type = true;

cljs.core.Delay.cljs$lang$ctorStr = "cljs.core/Delay";

cljs.core.Delay.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/Delay");
});

cljs.core.__GT_Delay = (function cljs$core$__GT_Delay(f,value){
return (new cljs.core.Delay(f,value));
});

/**
 * returns true if x is a Delay created with delay
 */
cljs.core.delay_QMARK_ = (function cljs$core$delay_QMARK_(x){
return (x instanceof cljs.core.Delay);
});
/**
 * If x is a Delay, returns the (possibly cached) value of its expression, else returns x
 */
cljs.core.force = (function cljs$core$force(x){
if(cljs.core.delay_QMARK_(x)){
var G__10064 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10064) : cljs.core.deref.call(null,G__10064));
} else {
return x;
}
});
/**
 * Returns true if a value has been produced for a delay or lazy sequence.
 */
cljs.core.realized_QMARK_ = (function cljs$core$realized_QMARK_(d){
return cljs.core._realized_QMARK_(d);
});
cljs.core.preserving_reduced = (function cljs$core$preserving_reduced(rf){
return (function (p1__10065_SHARP_,p2__10066_SHARP_){
var ret = (function (){var G__10069 = p1__10065_SHARP_;
var G__10070 = p2__10066_SHARP_;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10069,G__10070) : rf.call(null,G__10069,G__10070));
})();
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.reduced(ret);
} else {
return ret;
}
});
});
/**
 * A transducer which concatenates the contents of each input, which must be a
 * collection, into the reduction.
 */
cljs.core.cat = (function cljs$core$cat(rf){
var rf1 = cljs.core.preserving_reduced(rf);
return ((function (rf1){
return (function() {
var G__10073 = null;
var G__10073__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10073__1 = (function (result){
var G__10072 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10072) : rf.call(null,G__10072));
});
var G__10073__2 = (function (result,input){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf1,result,input);
});
G__10073 = function(result,input){
switch(arguments.length){
case 0:
return G__10073__0.call(this);
case 1:
return G__10073__1.call(this,result);
case 2:
return G__10073__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10073.cljs$core$IFn$_invoke$arity$0 = G__10073__0;
G__10073.cljs$core$IFn$_invoke$arity$1 = G__10073__1;
G__10073.cljs$core$IFn$_invoke$arity$2 = G__10073__2;
return G__10073;
})()
;})(rf1))
});
/**
 * Returns a lazy sequence removing consecutive duplicates in coll.
 * Returns a transducer when no collection is provided.
 */
cljs.core.dedupe = (function cljs$core$dedupe(){
var G__10075 = arguments.length;
switch (G__10075) {
case 0:
return cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.dedupe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (pa){
return (function() {
var G__10081 = null;
var G__10081__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10081__1 = (function (result){
var G__10076 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10076) : rf.call(null,G__10076));
});
var G__10081__2 = (function (result,input){
var prior = (function (){var G__10077 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10077) : cljs.core.deref.call(null,G__10077));
})();
cljs.core.vreset_BANG_(pa,input);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(prior,input)){
return result;
} else {
var G__10078 = result;
var G__10079 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10078,G__10079) : rf.call(null,G__10078,G__10079));
}
});
G__10081 = function(result,input){
switch(arguments.length){
case 0:
return G__10081__0.call(this);
case 1:
return G__10081__1.call(this,result);
case 2:
return G__10081__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10081.cljs$core$IFn$_invoke$arity$0 = G__10081__0;
G__10081.cljs$core$IFn$_invoke$arity$1 = G__10081__1;
G__10081.cljs$core$IFn$_invoke$arity$2 = G__10081__2;
return G__10081;
})()
;})(pa))
});
});

cljs.core.dedupe.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0(),coll);
});

cljs.core.dedupe.cljs$lang$maxFixedArity = 1;
/**
 * Returns items from coll with random probability of prob (0.0 -
 * 1.0).  Returns a transducer when no collection is provided.
 */
cljs.core.random_sample = (function cljs$core$random_sample(){
var G__10083 = arguments.length;
switch (G__10083) {
case 1:
return cljs.core.random_sample.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.random_sample.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.random_sample.cljs$core$IFn$_invoke$arity$1 = (function (prob){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}));
});

cljs.core.random_sample.cljs$core$IFn$_invoke$arity$2 = (function (prob,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}),coll);
});

cljs.core.random_sample.cljs$lang$maxFixedArity = 2;

/**
* @constructor
*/
cljs.core.Eduction = (function (xform,coll){
this.xform = xform;
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 2173173760;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Eduction.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.seq(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(self__.xform,self__.coll));
});

cljs.core.Eduction.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (_,f){
var self__ = this;
var ___$1 = this;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3(self__.xform,cljs.core.completing.cljs$core$IFn$_invoke$arity$1(f),self__.coll);
});

cljs.core.Eduction.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f,init){
var self__ = this;
var ___$1 = this;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(self__.xform,cljs.core.completing.cljs$core$IFn$_invoke$arity$1(f),init,self__.coll);
});

cljs.core.Eduction.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll__$1,writer,opts){
var self__ = this;
var coll__$2 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$2);
});

cljs.core.Eduction.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xform","xform",-85179481,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
});

cljs.core.Eduction.cljs$lang$type = true;

cljs.core.Eduction.cljs$lang$ctorStr = "cljs.core/Eduction";

cljs.core.Eduction.cljs$lang$ctorPrWriter = (function (this__4504__auto__,writer__4505__auto__,opt__4506__auto__){
return cljs.core._write(writer__4505__auto__,"cljs.core/Eduction");
});

cljs.core.__GT_Eduction = (function cljs$core$__GT_Eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});

(cljs.core.Eduction.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4901__auto__ = this;
return cljs.core.es6_iterator(this__4901__auto__);
}));
/**
 * Returns a reducible/iterable application of the transducers
 * to the items in coll. Transducers are applied in order as if
 * combined with comp. Note that these applications will be
 * performed every time reduce/iterator is called.
 */
cljs.core.eduction = (function cljs$core$eduction(){
var argseq__4965__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.eduction.cljs$core$IFn$_invoke$arity$variadic(argseq__4965__auto__);
});

cljs.core.eduction.cljs$core$IFn$_invoke$arity$variadic = (function (xforms){
return (new cljs.core.Eduction(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,cljs.core.butlast(xforms)),cljs.core.last(xforms)));
});

cljs.core.eduction.cljs$lang$maxFixedArity = (0);

cljs.core.eduction.cljs$lang$applyTo = (function (seq10085){
return cljs.core.eduction.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10085));
});
/**
 * Runs the supplied procedure (via reduce), for purposes of side
 * effects, on successive items in the collection. Returns nil
 */
cljs.core.run_BANG_ = (function cljs$core$run_BANG_(proc,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__10087_SHARP_,p2__10086_SHARP_){
var G__10089 = p2__10086_SHARP_;
return (proc.cljs$core$IFn$_invoke$arity$1 ? proc.cljs$core$IFn$_invoke$arity$1(G__10089) : proc.call(null,G__10089));
}),null,coll);
});

cljs.core.IEncodeJS = (function (){var obj10091 = {};
return obj10091;
})();

/**
 * Recursively transforms clj values to JavaScript
 */
cljs.core._clj__GT_js = (function cljs$core$_clj__GT_js(x){
if((function (){var and__3913__auto__ = x;
if(and__3913__auto__){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1;
} else {
return and__3913__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1(x);
} else {
var x__4561__auto__ = (((x == null))?null:x);
return (function (){var or__3925__auto__ = (cljs.core._clj__GT_js[(function (){var G__10095 = x__4561__auto__;
return goog.typeOf(G__10095);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._clj__GT_js["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-clj->js",x);
}
}
})().call(null,x);
}
});

/**
 * Transforms map keys to valid JavaScript keys. Arbitrary keys are
 * encoded to their string representation via (pr-str x)
 */
cljs.core._key__GT_js = (function cljs$core$_key__GT_js(x){
if((function (){var and__3913__auto__ = x;
if(and__3913__auto__){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1;
} else {
return and__3913__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1(x);
} else {
var x__4561__auto__ = (((x == null))?null:x);
return (function (){var or__3925__auto__ = (cljs.core._key__GT_js[(function (){var G__10099 = x__4561__auto__;
return goog.typeOf(G__10099);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._key__GT_js["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-key->js",x);
}
}
})().call(null,x);
}
});

cljs.core.key__GT_js = (function cljs$core$key__GT_js(k){
if((function (){var G__10102 = k;
if(G__10102){
var bit__4599__auto__ = null;
if(cljs.core.truth_((function (){var or__3925__auto__ = bit__4599__auto__;
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return G__10102.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__10102.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10102);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10102);
}
})()){
return cljs.core._clj__GT_js(k);
} else {
if((typeof k === 'string') || (typeof k === 'number') || ((k instanceof cljs.core.Keyword)) || ((k instanceof cljs.core.Symbol))){
var G__10103 = k;
return (cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1 ? cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1(G__10103) : cljs.core.clj__GT_js.call(null,G__10103));
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([k], 0));
}
}
});
/**
 * Recursively transforms ClojureScript values to JavaScript.
 * sets/vectors/lists become Arrays, Keywords and Symbol become Strings,
 * Maps become Objects. Arbitrary keys are encoded to by key->js.
 */
cljs.core.clj__GT_js = (function cljs$core$clj__GT_js(x){
if((x == null)){
return null;
} else {
if((function (){var G__10119 = x;
if(G__10119){
var bit__4599__auto__ = null;
if(cljs.core.truth_((function (){var or__3925__auto__ = bit__4599__auto__;
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return G__10119.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__10119.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10119);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10119);
}
})()){
return cljs.core._clj__GT_js(x);
} else {
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
if((x instanceof cljs.core.Symbol)){
return [cljs.core.str(x)].join('');
} else {
if(cljs.core.map_QMARK_(x)){
var m = (function (){var obj10121 = {};
return obj10121;
})();
var seq__10122_10132 = cljs.core.seq(x);
var chunk__10123_10133 = null;
var count__10124_10134 = (0);
var i__10125_10135 = (0);
while(true){
if((i__10125_10135 < count__10124_10134)){
var vec__10126_10136 = chunk__10123_10133.cljs$core$IIndexed$_nth$arity$2(null,i__10125_10135);
var k_10137 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10126_10136,(0),null);
var v_10138 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10126_10136,(1),null);
(m[cljs.core.key__GT_js(k_10137)] = cljs$core$clj__GT_js(v_10138));

var G__10139 = seq__10122_10132;
var G__10140 = chunk__10123_10133;
var G__10141 = count__10124_10134;
var G__10142 = (i__10125_10135 + (1));
seq__10122_10132 = G__10139;
chunk__10123_10133 = G__10140;
count__10124_10134 = G__10141;
i__10125_10135 = G__10142;
continue;
} else {
var temp__4423__auto___10143 = cljs.core.seq(seq__10122_10132);
if(temp__4423__auto___10143){
var seq__10122_10144__$1 = temp__4423__auto___10143;
if(cljs.core.chunked_seq_QMARK_(seq__10122_10144__$1)){
var c__4710__auto___10145 = cljs.core.chunk_first(seq__10122_10144__$1);
var G__10146 = cljs.core.chunk_rest(seq__10122_10144__$1);
var G__10147 = c__4710__auto___10145;
var G__10148 = cljs.core.count(c__4710__auto___10145);
var G__10149 = (0);
seq__10122_10132 = G__10146;
chunk__10123_10133 = G__10147;
count__10124_10134 = G__10148;
i__10125_10135 = G__10149;
continue;
} else {
var vec__10127_10150 = cljs.core.first(seq__10122_10144__$1);
var k_10151 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10127_10150,(0),null);
var v_10152 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10127_10150,(1),null);
(m[cljs.core.key__GT_js(k_10151)] = cljs$core$clj__GT_js(v_10152));

var G__10153 = cljs.core.next(seq__10122_10144__$1);
var G__10154 = null;
var G__10155 = (0);
var G__10156 = (0);
seq__10122_10132 = G__10153;
chunk__10123_10133 = G__10154;
count__10124_10134 = G__10155;
i__10125_10135 = G__10156;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x)){
var arr = [];
var seq__10128_10157 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$clj__GT_js,x));
var chunk__10129_10158 = null;
var count__10130_10159 = (0);
var i__10131_10160 = (0);
while(true){
if((i__10131_10160 < count__10130_10159)){
var x_10161__$1 = chunk__10129_10158.cljs$core$IIndexed$_nth$arity$2(null,i__10131_10160);
arr.push(x_10161__$1);

var G__10162 = seq__10128_10157;
var G__10163 = chunk__10129_10158;
var G__10164 = count__10130_10159;
var G__10165 = (i__10131_10160 + (1));
seq__10128_10157 = G__10162;
chunk__10129_10158 = G__10163;
count__10130_10159 = G__10164;
i__10131_10160 = G__10165;
continue;
} else {
var temp__4423__auto___10166 = cljs.core.seq(seq__10128_10157);
if(temp__4423__auto___10166){
var seq__10128_10167__$1 = temp__4423__auto___10166;
if(cljs.core.chunked_seq_QMARK_(seq__10128_10167__$1)){
var c__4710__auto___10168 = cljs.core.chunk_first(seq__10128_10167__$1);
var G__10169 = cljs.core.chunk_rest(seq__10128_10167__$1);
var G__10170 = c__4710__auto___10168;
var G__10171 = cljs.core.count(c__4710__auto___10168);
var G__10172 = (0);
seq__10128_10157 = G__10169;
chunk__10129_10158 = G__10170;
count__10130_10159 = G__10171;
i__10131_10160 = G__10172;
continue;
} else {
var x_10173__$1 = cljs.core.first(seq__10128_10167__$1);
arr.push(x_10173__$1);

var G__10174 = cljs.core.next(seq__10128_10167__$1);
var G__10175 = null;
var G__10176 = (0);
var G__10177 = (0);
seq__10128_10157 = G__10174;
chunk__10129_10158 = G__10175;
count__10130_10159 = G__10176;
i__10131_10160 = G__10177;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x;

}
}
}
}
}
}
});

cljs.core.IEncodeClojure = (function (){var obj10179 = {};
return obj10179;
})();

/**
 * Transforms JavaScript values to Clojure
 */
cljs.core._js__GT_clj = (function cljs$core$_js__GT_clj(x,options){
if((function (){var and__3913__auto__ = x;
if(and__3913__auto__){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2;
} else {
return and__3913__auto__;
}
})()){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2(x,options);
} else {
var x__4561__auto__ = (((x == null))?null:x);
return (function (){var or__3925__auto__ = (cljs.core._js__GT_clj[(function (){var G__10183 = x__4561__auto__;
return goog.typeOf(G__10183);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._js__GT_clj["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeClojure.-js->clj",x);
}
}
})().call(null,x,options);
}
});

/**
 * Recursively transforms JavaScript arrays into ClojureScript
 * vectors, and JavaScript objects into ClojureScript maps.  With
 * option ':keywordize-keys true' will convert object fields from
 * strings to keywords.
 */
cljs.core.js__GT_clj = (function cljs$core$js__GT_clj(){
var G__10187 = arguments.length;
switch (G__10187) {
case 1:
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0)));
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4976__auto__);

}
});

cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1 = (function (x){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),false], null)], 0));
});

cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic = (function (x,opts){
var map__10188 = opts;
var map__10188__$1 = ((cljs.core.seq_QMARK_(map__10188))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10188):map__10188);
var keywordize_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10188__$1,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252));
var keyfn = (cljs.core.truth_(keywordize_keys)?cljs.core.keyword:cljs.core.str);
var f = ((function (map__10188,map__10188__$1,keywordize_keys,keyfn){
return (function cljs$core$thisfn(x__$1){
if((function (){var G__10204 = x__$1;
if(G__10204){
var bit__4599__auto__ = null;
if(cljs.core.truth_((function (){var or__3925__auto__ = bit__4599__auto__;
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return G__10204.cljs$core$IEncodeClojure$;
}
})())){
return true;
} else {
if((!G__10204.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__10204);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__10204);
}
})()){
return cljs.core._js__GT_clj(x__$1,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array_map,opts));
} else {
if(cljs.core.seq_QMARK_(x__$1)){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$thisfn,x__$1));
} else {
if(cljs.core.coll_QMARK_(x__$1)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.empty(x__$1),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$thisfn,x__$1));
} else {
if(cljs.core.array_QMARK_(x__$1)){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$thisfn,x__$1));
} else {
if((cljs.core.type(x__$1) === Object)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4679__auto__ = ((function (map__10188,map__10188__$1,keywordize_keys,keyfn){
return (function cljs$core$thisfn_$_iter__10205(s__10206){
return (new cljs.core.LazySeq(null,((function (map__10188,map__10188__$1,keywordize_keys,keyfn){
return (function (){
var s__10206__$1 = s__10206;
while(true){
var temp__4423__auto__ = cljs.core.seq(s__10206__$1);
if(temp__4423__auto__){
var s__10206__$2 = temp__4423__auto__;
if(cljs.core.chunked_seq_QMARK_(s__10206__$2)){
var c__4677__auto__ = cljs.core.chunk_first(s__10206__$2);
var size__4678__auto__ = cljs.core.count(c__4677__auto__);
var b__10208 = cljs.core.chunk_buffer(size__4678__auto__);
if((function (){var i__10207 = (0);
while(true){
if((i__10207 < size__4678__auto__)){
var k = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4677__auto__,i__10207);
cljs.core.chunk_append(b__10208,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__10213 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__10213) : keyfn.call(null,G__10213));
})(),cljs$core$thisfn((x__$1[k]))], null));

var G__10216 = (i__10207 + (1));
i__10207 = G__10216;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__10208),cljs$core$thisfn_$_iter__10205(cljs.core.chunk_rest(s__10206__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__10208),null);
}
} else {
var k = cljs.core.first(s__10206__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__10214 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__10214) : keyfn.call(null,G__10214));
})(),cljs$core$thisfn((x__$1[k]))], null),cljs$core$thisfn_$_iter__10205(cljs.core.rest(s__10206__$2)));
}
} else {
return null;
}
break;
}
});})(map__10188,map__10188__$1,keywordize_keys,keyfn))
,null,null));
});})(map__10188,map__10188__$1,keywordize_keys,keyfn))
;
return iter__4679__auto__(cljs.core.js_keys(x__$1));
})());
} else {
return x__$1;

}
}
}
}
}
});})(map__10188,map__10188__$1,keywordize_keys,keyfn))
;
return f(x);
});

cljs.core.js__GT_clj.cljs$lang$applyTo = (function (seq10184){
var G__10185 = cljs.core.first(seq10184);
var seq10184__$1 = cljs.core.next(seq10184);
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(G__10185,seq10184__$1);
});

cljs.core.js__GT_clj.cljs$lang$maxFixedArity = (1);
/**
 * Returns a memoized version of a referentially transparent function. The
 * memoized version of the function keeps a cache of the mapping from arguments
 * to results and, when calls with the same arguments are repeated often, has
 * higher performance at the expense of higher memory use.
 */
cljs.core.memoize = (function cljs$core$memoize(f){
var mem = (function (){var G__10219 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__10219) : cljs.core.atom.call(null,G__10219));
})();
return ((function (mem){
return (function() { 
var G__10221__delegate = function (args){
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$3((function (){var G__10220 = mem;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10220) : cljs.core.deref.call(null,G__10220));
})(),args,cljs.core.lookup_sentinel);
if((v === cljs.core.lookup_sentinel)){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(mem,cljs.core.assoc,args,ret);

return ret;
} else {
return v;
}
};
var G__10221 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__10222__i = 0, G__10222__a = new Array(arguments.length -  0);
while (G__10222__i < G__10222__a.length) {G__10222__a[G__10222__i] = arguments[G__10222__i + 0]; ++G__10222__i;}
  args = new cljs.core.IndexedSeq(G__10222__a,0);
} 
return G__10221__delegate.call(this,args);};
G__10221.cljs$lang$maxFixedArity = 0;
G__10221.cljs$lang$applyTo = (function (arglist__10223){
var args = cljs.core.seq(arglist__10223);
return G__10221__delegate(args);
});
G__10221.cljs$core$IFn$_invoke$arity$variadic = G__10221__delegate;
return G__10221;
})()
;
;})(mem))
});
/**
 * trampoline can be used to convert algorithms requiring mutual
 * recursion without stack consumption. Calls f with supplied args, if
 * any. If f returns a fn, calls that fn with no arguments, and
 * continues to repeat, until the return value is not a fn, then
 * returns that non-fn value. Note that if you want to return a fn as a
 * final value, you must wrap it in some data structure and unpack it
 * after trampoline returns.
 */
cljs.core.trampoline = (function cljs$core$trampoline(){
var G__10227 = arguments.length;
switch (G__10227) {
case 1:
return cljs.core.trampoline.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__4976__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0)));
return cljs.core.trampoline.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4976__auto__);

}
});

cljs.core.trampoline.cljs$core$IFn$_invoke$arity$1 = (function (f){
while(true){
var ret = (function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})();
if(cljs.core.fn_QMARK_(ret)){
var G__10229 = ret;
f = G__10229;
continue;
} else {
return ret;
}
break;
}
});

cljs.core.trampoline.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.trampoline.cljs$core$IFn$_invoke$arity$1((function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}));
});

cljs.core.trampoline.cljs$lang$applyTo = (function (seq10224){
var G__10225 = cljs.core.first(seq10224);
var seq10224__$1 = cljs.core.next(seq10224);
return cljs.core.trampoline.cljs$core$IFn$_invoke$arity$variadic(G__10225,seq10224__$1);
});

cljs.core.trampoline.cljs$lang$maxFixedArity = (1);
/**
 * Returns a random floating point number between 0 (inclusive) and
 * n (default 1) (exclusive).
 */
cljs.core.rand = (function cljs$core$rand(){
var G__10231 = arguments.length;
switch (G__10231) {
case 0:
return cljs.core.rand.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.rand.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.rand.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.rand.cljs$core$IFn$_invoke$arity$1((1));
});

cljs.core.rand.cljs$core$IFn$_invoke$arity$1 = (function (n){
return ((function (){return Math.random();
})() * n);
});

cljs.core.rand.cljs$lang$maxFixedArity = 1;
/**
 * Returns a random integer between 0 (inclusive) and n (exclusive).
 */
cljs.core.rand_int = (function cljs$core$rand_int(n){
var G__10234 = ((function (){return Math.random();
})() * n);
return Math.floor(G__10234);
});
/**
 * Return a random element of the (sequential) collection. Will have
 * the same performance characteristics as nth for the given
 * collection.
 */
cljs.core.rand_nth = (function cljs$core$rand_nth(coll){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.rand_int(cljs.core.count(coll)));
});
/**
 * Returns a map of the elements of coll keyed by the result of
 * f on each element. The value at each key will be a vector of the
 * corresponding elements, in the order they appeared in coll.
 */
cljs.core.group_by = (function cljs$core$group_by(f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret,x){
var k = (function (){var G__10236 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10236) : f.call(null,G__10236));
})();
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.PersistentVector.EMPTY),x));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Creates a hierarchy object for use with derive, isa? etc.
 */
cljs.core.make_hierarchy = (function cljs$core$make_hierarchy(){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"descendants","descendants",1824886031),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ancestors","ancestors",-776045424),cljs.core.PersistentArrayMap.EMPTY], null);
});
cljs.core._global_hierarchy = null;
cljs.core.get_global_hierarchy = (function cljs$core$get_global_hierarchy(){
if((cljs.core._global_hierarchy == null)){
cljs.core._global_hierarchy = (function (){var G__10238 = cljs.core.make_hierarchy();
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__10238) : cljs.core.atom.call(null,G__10238));
})();
} else {
}

return cljs.core._global_hierarchy;
});
cljs.core.swap_global_hierarchy_BANG_ = (function cljs$core$swap_global_hierarchy_BANG_(){
var argseq__4965__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4965__auto__);
});

cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.swap_BANG_,cljs.core.get_global_hierarchy(),f,args);
});

cljs.core.swap_global_hierarchy_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.swap_global_hierarchy_BANG_.cljs$lang$applyTo = (function (seq10239){
var G__10240 = cljs.core.first(seq10239);
var seq10239__$1 = cljs.core.next(seq10239);
return cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10240,seq10239__$1);
});
/**
 * Returns true if (= child parent), or child is directly or indirectly derived from
 * parent, either via a JavaScript type inheritance relationship or a
 * relationship established via derive. h must be a hierarchy obtained
 * from make-hierarchy, if not supplied defaults to the global
 * hierarchy
 */
cljs.core.isa_QMARK_ = (function cljs$core$isa_QMARK_(){
var G__10242 = arguments.length;
switch (G__10242) {
case 2:
return cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (child,parent){
return cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3((function (){var G__10243 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10243) : cljs.core.deref.call(null,G__10243));
})(),child,parent);
});

cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (h,child,parent){
var or__3925__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(child,parent);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h).call(null,child),parent);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
var and__3913__auto__ = cljs.core.vector_QMARK_(parent);
if(and__3913__auto__){
var and__3913__auto____$1 = cljs.core.vector_QMARK_(child);
if(and__3913__auto____$1){
var and__3913__auto____$2 = (cljs.core.count(parent) === cljs.core.count(child));
if(and__3913__auto____$2){
var ret = true;
var i = (0);
while(true){
if((!(ret)) || ((i === cljs.core.count(parent)))){
return ret;
} else {
var G__10269 = cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3(h,(function (){var G__10266 = i;
return (child.cljs$core$IFn$_invoke$arity$1 ? child.cljs$core$IFn$_invoke$arity$1(G__10266) : child.call(null,G__10266));
})(),(function (){var G__10267 = i;
return (parent.cljs$core$IFn$_invoke$arity$1 ? parent.cljs$core$IFn$_invoke$arity$1(G__10267) : parent.call(null,G__10267));
})());
var G__10270 = (i + (1));
ret = G__10269;
i = G__10270;
continue;
}
break;
}
} else {
return and__3913__auto____$2;
}
} else {
return and__3913__auto____$1;
}
} else {
return and__3913__auto__;
}
}
}
});

cljs.core.isa_QMARK_.cljs$lang$maxFixedArity = 3;
/**
 * Returns the immediate parents of tag, either via a JavaScript type
 * inheritance relationship or a relationship established via derive. h
 * must be a hierarchy obtained from make-hierarchy, if not supplied
 * defaults to the global hierarchy
 */
cljs.core.parents = (function cljs$core$parents(){
var G__10272 = arguments.length;
switch (G__10272) {
case 1:
return cljs.core.parents.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.parents.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.parents.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return cljs.core.parents.cljs$core$IFn$_invoke$arity$2((function (){var G__10273 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10273) : cljs.core.deref.call(null,G__10273));
})(),tag);
});

cljs.core.parents.cljs$core$IFn$_invoke$arity$2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h),tag));
});

cljs.core.parents.cljs$lang$maxFixedArity = 2;
/**
 * Returns the immediate and indirect parents of tag, either via a JavaScript type
 * inheritance relationship or a relationship established via derive. h
 * must be a hierarchy obtained from make-hierarchy, if not supplied
 * defaults to the global hierarchy
 */
cljs.core.ancestors = (function cljs$core$ancestors(){
var G__10276 = arguments.length;
switch (G__10276) {
case 1:
return cljs.core.ancestors.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.ancestors.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.ancestors.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return cljs.core.ancestors.cljs$core$IFn$_invoke$arity$2((function (){var G__10277 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10277) : cljs.core.deref.call(null,G__10277));
})(),tag);
});

cljs.core.ancestors.cljs$core$IFn$_invoke$arity$2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h),tag));
});

cljs.core.ancestors.cljs$lang$maxFixedArity = 2;
/**
 * Returns the immediate and indirect children of tag, through a
 * relationship established via derive. h must be a hierarchy obtained
 * from make-hierarchy, if not supplied defaults to the global
 * hierarchy. Note: does not work on JavaScript type inheritance
 * relationships.
 */
cljs.core.descendants = (function cljs$core$descendants(){
var G__10280 = arguments.length;
switch (G__10280) {
case 1:
return cljs.core.descendants.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.descendants.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.descendants.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return cljs.core.descendants.cljs$core$IFn$_invoke$arity$2((function (){var G__10281 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10281) : cljs.core.deref.call(null,G__10281));
})(),tag);
});

cljs.core.descendants.cljs$core$IFn$_invoke$arity$2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h),tag));
});

cljs.core.descendants.cljs$lang$maxFixedArity = 2;
/**
 * Establishes a parent/child relationship between parent and
 * tag. Parent must be a namespace-qualified symbol or keyword and
 * child can be either a namespace-qualified symbol or keyword or a
 * class. h must be a hierarchy obtained from make-hierarchy, if not
 * supplied defaults to, and modifies, the global hierarchy.
 */
cljs.core.derive = (function cljs$core$derive(){
var G__10284 = arguments.length;
switch (G__10284) {
case 2:
return cljs.core.derive.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.derive.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.derive.cljs$core$IFn$_invoke$arity$2 = (function (tag,parent){
if(cljs.core.truth_(cljs.core.namespace(parent))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"namespace","namespace",1263021155,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.derive,cljs.core.array_seq([tag,parent], 0));

return null;
});

cljs.core.derive.cljs$core$IFn$_invoke$arity$3 = (function (h,tag,parent){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(tag,parent)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"tag","tag",350170304,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

var tp = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h);
var td = new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h);
var ta = new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h);
var tf = ((function (tp,td,ta){
return (function (m,source,sources,target,targets){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (tp,td,ta){
return (function (ret,k){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.get.cljs$core$IFn$_invoke$arity$3(targets,k,cljs.core.PersistentHashSet.EMPTY),cljs.core.cons(target,(function (){var G__10285 = target;
return (targets.cljs$core$IFn$_invoke$arity$1 ? targets.cljs$core$IFn$_invoke$arity$1(G__10285) : targets.call(null,G__10285));
})())));
});})(tp,td,ta))
,m,cljs.core.cons(source,(function (){var G__10286 = source;
return (sources.cljs$core$IFn$_invoke$arity$1 ? sources.cljs$core$IFn$_invoke$arity$1(G__10286) : sources.call(null,G__10286));
})()));
});})(tp,td,ta))
;
var or__3925__auto__ = ((cljs.core.contains_QMARK_((function (){var G__10290 = tag;
return (tp.cljs$core$IFn$_invoke$arity$1 ? tp.cljs$core$IFn$_invoke$arity$1(G__10290) : tp.call(null,G__10290));
})(),parent))?null:(function (){
if(cljs.core.contains_QMARK_((function (){var G__10291 = tag;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__10291) : ta.call(null,G__10291));
})(),parent)){
throw (new Error([cljs.core.str(tag),cljs.core.str("already has"),cljs.core.str(parent),cljs.core.str("as ancestor")].join('')));
} else {
}

if(cljs.core.contains_QMARK_((function (){var G__10292 = parent;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__10292) : ta.call(null,G__10292));
})(),tag)){
throw (new Error([cljs.core.str("Cyclic derivation:"),cljs.core.str(parent),cljs.core.str("has"),cljs.core.str(tag),cljs.core.str("as ancestor")].join('')));
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h),tag,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(tp,tag,cljs.core.PersistentHashSet.EMPTY),parent)),new cljs.core.Keyword(null,"ancestors","ancestors",-776045424),tf(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h),tag,td,parent,ta),new cljs.core.Keyword(null,"descendants","descendants",1824886031),tf(new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h),parent,ta,tag,td)], null);
})()
);
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return h;
}
});

cljs.core.derive.cljs$lang$maxFixedArity = 3;
/**
 * Removes a parent/child relationship between parent and
 * tag. h must be a hierarchy obtained from make-hierarchy, if not
 * supplied defaults to, and modifies, the global hierarchy.
 */
cljs.core.underive = (function cljs$core$underive(){
var G__10298 = arguments.length;
switch (G__10298) {
case 2:
return cljs.core.underive.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.underive.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.underive.cljs$core$IFn$_invoke$arity$2 = (function (tag,parent){
cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.underive,cljs.core.array_seq([tag,parent], 0));

return null;
});

cljs.core.underive.cljs$core$IFn$_invoke$arity$3 = (function (h,tag,parent){
var parentMap = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h);
var childsParents = (cljs.core.truth_((function (){var G__10299 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__10299) : parentMap.call(null,G__10299));
})())?cljs.core.disj.cljs$core$IFn$_invoke$arity$2((function (){var G__10300 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__10300) : parentMap.call(null,G__10300));
})(),parent):cljs.core.PersistentHashSet.EMPTY);
var newParents = (cljs.core.truth_(cljs.core.not_empty(childsParents))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(parentMap,tag,childsParents):cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(parentMap,tag));
var deriv_seq = cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (parentMap,childsParents,newParents){
return (function (p1__10294_SHARP_){
return cljs.core.cons(cljs.core.first(p1__10294_SHARP_),cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(cljs.core.first(p1__10294_SHARP_),cljs.core.second(p1__10294_SHARP_)));
});})(parentMap,childsParents,newParents))
,cljs.core.seq(newParents)));
if(cljs.core.contains_QMARK_((function (){var G__10301 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__10301) : parentMap.call(null,G__10301));
})(),parent)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (parentMap,childsParents,newParents,deriv_seq){
return (function (p1__10295_SHARP_,p2__10296_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.derive,p1__10295_SHARP_,p2__10296_SHARP_);
});})(parentMap,childsParents,newParents,deriv_seq))
,cljs.core.make_hierarchy(),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),deriv_seq));
} else {
return h;
}
});

cljs.core.underive.cljs$lang$maxFixedArity = 3;
cljs.core.reset_cache = (function cljs$core$reset_cache(method_cache,method_table,cached_hierarchy,hierarchy){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(method_cache,(function (_){
var G__10305 = method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10305) : cljs.core.deref.call(null,G__10305));
}));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cached_hierarchy,(function (_){
var G__10306 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10306) : cljs.core.deref.call(null,G__10306));
}));
});
cljs.core.prefers_STAR_ = (function cljs$core$prefers_STAR_(x,y,prefer_table){
var xprefs = (function (){var G__10322 = prefer_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10322) : cljs.core.deref.call(null,G__10322));
})().call(null,x);
var or__3925__auto__ = (cljs.core.truth_((function (){var and__3913__auto__ = xprefs;
if(cljs.core.truth_(and__3913__auto__)){
var G__10324 = y;
return (xprefs.cljs$core$IFn$_invoke$arity$1 ? xprefs.cljs$core$IFn$_invoke$arity$1(G__10324) : xprefs.call(null,G__10324));
} else {
return and__3913__auto__;
}
})())?true:null);
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (function (){var ps = cljs.core.parents.cljs$core$IFn$_invoke$arity$1(y);
while(true){
if((cljs.core.count(ps) > (0))){
if(cljs.core.truth_(cljs$core$prefers_STAR_(x,cljs.core.first(ps),prefer_table))){
} else {
}

var G__10325 = cljs.core.rest(ps);
ps = G__10325;
continue;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(or__3925__auto____$1)){
return or__3925__auto____$1;
} else {
var or__3925__auto____$2 = (function (){var ps = cljs.core.parents.cljs$core$IFn$_invoke$arity$1(x);
while(true){
if((cljs.core.count(ps) > (0))){
if(cljs.core.truth_(cljs$core$prefers_STAR_(cljs.core.first(ps),y,prefer_table))){
} else {
}

var G__10326 = cljs.core.rest(ps);
ps = G__10326;
continue;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(or__3925__auto____$2)){
return or__3925__auto____$2;
} else {
return false;
}
}
}
});
cljs.core.dominates = (function cljs$core$dominates(x,y,prefer_table){
var or__3925__auto__ = cljs.core.prefers_STAR_(x,y,prefer_table);
if(cljs.core.truth_(or__3925__auto__)){
return or__3925__auto__;
} else {
return cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$2(x,y);
}
});
cljs.core.find_and_cache_best_method = (function cljs$core$find_and_cache_best_method(name,dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy){
var best_entry = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (be,p__10340){
var vec__10341 = p__10340;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10341,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10341,(1),null);
var e = vec__10341;
if(cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3((function (){var G__10342 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10342) : cljs.core.deref.call(null,G__10342));
})(),dispatch_val,k)){
var be2 = (cljs.core.truth_((function (){var or__3925__auto__ = (be == null);
if(or__3925__auto__){
return or__3925__auto__;
} else {
return cljs.core.dominates(k,cljs.core.first(be),prefer_table);
}
})())?e:be);
if(cljs.core.truth_(cljs.core.dominates(cljs.core.first(be2),k,prefer_table))){
} else {
throw (new Error([cljs.core.str("Multiple methods in multimethod '"),cljs.core.str(name),cljs.core.str("' match dispatch value: "),cljs.core.str(dispatch_val),cljs.core.str(" -> "),cljs.core.str(k),cljs.core.str(" and "),cljs.core.str(cljs.core.first(be2)),cljs.core.str(", and neither is preferred")].join('')));
}

return be2;
} else {
return be;
}
}),null,(function (){var G__10343 = method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10343) : cljs.core.deref.call(null,G__10343));
})());
if(cljs.core.truth_(best_entry)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var G__10344 = cached_hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10344) : cljs.core.deref.call(null,G__10344));
})(),(function (){var G__10345 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10345) : cljs.core.deref.call(null,G__10345));
})())){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(method_cache,cljs.core.assoc,dispatch_val,cljs.core.second(best_entry));

return cljs.core.second(best_entry);
} else {
cljs.core.reset_cache(method_cache,method_table,cached_hierarchy,hierarchy);

return cljs$core$find_and_cache_best_method(name,dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy);
}
} else {
return null;
}
});

cljs.core.IMultiFn = (function (){var obj10347 = {};
return obj10347;
})();

cljs.core._reset = (function cljs$core$_reset(mf){
if((function (){var and__3913__auto__ = mf;
if(and__3913__auto__){
return mf.cljs$core$IMultiFn$_reset$arity$1;
} else {
return and__3913__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_reset$arity$1(mf);
} else {
var x__4561__auto__ = (((mf == null))?null:mf);
return (function (){var or__3925__auto__ = (cljs.core._reset[(function (){var G__10351 = x__4561__auto__;
return goog.typeOf(G__10351);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._reset["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-reset",mf);
}
}
})().call(null,mf);
}
});

cljs.core._add_method = (function cljs$core$_add_method(mf,dispatch_val,method){
if((function (){var and__3913__auto__ = mf;
if(and__3913__auto__){
return mf.cljs$core$IMultiFn$_add_method$arity$3;
} else {
return and__3913__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_add_method$arity$3(mf,dispatch_val,method);
} else {
var x__4561__auto__ = (((mf == null))?null:mf);
return (function (){var or__3925__auto__ = (cljs.core._add_method[(function (){var G__10355 = x__4561__auto__;
return goog.typeOf(G__10355);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._add_method["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-add-method",mf);
}
}
})().call(null,mf,dispatch_val,method);
}
});

cljs.core._remove_method = (function cljs$core$_remove_method(mf,dispatch_val){
if((function (){var and__3913__auto__ = mf;
if(and__3913__auto__){
return mf.cljs$core$IMultiFn$_remove_method$arity$2;
} else {
return and__3913__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf,dispatch_val);
} else {
var x__4561__auto__ = (((mf == null))?null:mf);
return (function (){var or__3925__auto__ = (cljs.core._remove_method[(function (){var G__10359 = x__4561__auto__;
return goog.typeOf(G__10359);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._remove_method["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-remove-method",mf);
}
}
})().call(null,mf,dispatch_val);
}
});

cljs.core._prefer_method = (function cljs$core$_prefer_method(mf,dispatch_val,dispatch_val_y){
if((function (){var and__3913__auto__ = mf;
if(and__3913__auto__){
return mf.cljs$core$IMultiFn$_prefer_method$arity$3;
} else {
return and__3913__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf,dispatch_val,dispatch_val_y);
} else {
var x__4561__auto__ = (((mf == null))?null:mf);
return (function (){var or__3925__auto__ = (cljs.core._prefer_method[(function (){var G__10363 = x__4561__auto__;
return goog.typeOf(G__10363);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._prefer_method["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-prefer-method",mf);
}
}
})().call(null,mf,dispatch_val,dispatch_val_y);
}
});

cljs.core._get_method = (function cljs$core$_get_method(mf,dispatch_val){
if((function (){var and__3913__auto__ = mf;
if(and__3913__auto__){
return mf.cljs$core$IMultiFn$_get_method$arity$2;
} else {
return and__3913__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_get_method$arity$2(mf,dispatch_val);
} else {
var x__4561__auto__ = (((mf == null))?null:mf);
return (function (){var or__3925__auto__ = (cljs.core._get_method[(function (){var G__10367 = x__4561__auto__;
return goog.typeOf(G__10367);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._get_method["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-get-method",mf);
}
}
})().call(null,mf,dispatch_val);
}
});

cljs.core._methods = (function cljs$core$_methods(mf){
if((function (){var and__3913__auto__ = mf;
if(and__3913__auto__){
return mf.cljs$core$IMultiFn$_methods$arity$1;
} else {
return and__3913__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_methods$arity$1(mf);
} else {
var x__4561__auto__ = (((mf == null))?null:mf);
return (function (){var or__3925__auto__ = (cljs.core._methods[(function (){var G__10371 = x__4561__auto__;
return goog.typeOf(G__10371);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._methods["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-methods",mf);
}
}
})().call(null,mf);
}
});

cljs.core._prefers = (function cljs$core$_prefers(mf){
if((function (){var and__3913__auto__ = mf;
if(and__3913__auto__){
return mf.cljs$core$IMultiFn$_prefers$arity$1;
} else {
return and__3913__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_prefers$arity$1(mf);
} else {
var x__4561__auto__ = (((mf == null))?null:mf);
return (function (){var or__3925__auto__ = (cljs.core._prefers[(function (){var G__10375 = x__4561__auto__;
return goog.typeOf(G__10375);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._prefers["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-prefers",mf);
}
}
})().call(null,mf);
}
});

cljs.core._default_dispatch_val = (function cljs$core$_default_dispatch_val(mf){
if((function (){var and__3913__auto__ = mf;
if(and__3913__auto__){
return mf.cljs$core$IMultiFn$_default_dispatch_val$arity$1;
} else {
return and__3913__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_default_dispatch_val$arity$1(mf);
} else {
var x__4561__auto__ = (((mf == null))?null:mf);
return (function (){var or__3925__auto__ = (cljs.core._default_dispatch_val[(function (){var G__10379 = x__4561__auto__;
return goog.typeOf(G__10379);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._default_dispatch_val["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-default-dispatch-val",mf);
}
}
})().call(null,mf);
}
});

cljs.core._dispatch_fn = (function cljs$core$_dispatch_fn(mf){
if((function (){var and__3913__auto__ = mf;
if(and__3913__auto__){
return mf.cljs$core$IMultiFn$_dispatch_fn$arity$1;
} else {
return and__3913__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_dispatch_fn$arity$1(mf);
} else {
var x__4561__auto__ = (((mf == null))?null:mf);
return (function (){var or__3925__auto__ = (cljs.core._dispatch_fn[(function (){var G__10383 = x__4561__auto__;
return goog.typeOf(G__10383);
})()]);
if(or__3925__auto__){
return or__3925__auto__;
} else {
var or__3925__auto____$1 = (cljs.core._dispatch_fn["_"]);
if(or__3925__auto____$1){
return or__3925__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-dispatch-fn",mf);
}
}
})().call(null,mf);
}
});

cljs.core.throw_no_method_error = (function cljs$core$throw_no_method_error(name,dispatch_val){
throw (new Error([cljs.core.str("No method in multimethod '"),cljs.core.str(name),cljs.core.str("' for dispatch value: "),cljs.core.str(dispatch_val)].join('')));
});

/**
* @constructor
*/
cljs.core.MultiFn = (function (name,dispatch_fn,default_dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy){
this.name = name;
this.dispatch_fn = dispatch_fn;
this.default_dispatch_val = default_dispatch_val;
this.hierarchy = hierarchy;
this.method_table = method_table;
this.prefer_table = prefer_table;
this.method_cache = method_cache;
this.cached_hierarchy = cached_hierarchy;
this.cljs$lang$protocol_mask$partition0$ = 4194305;
this.cljs$lang$protocol_mask$partition1$ = 4352;
})
cljs.core.MultiFn.prototype.call = (function() {
var G__11232 = null;
var G__11232__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$0 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$0() : self__.dispatch_fn.call(null));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

return (target_fn.cljs$core$IFn$_invoke$arity$0 ? target_fn.cljs$core$IFn$_invoke$arity$0() : target_fn.call(null));
});
var G__11232__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10385 = a;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$1 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$1(G__10385) : self__.dispatch_fn.call(null,G__10385));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10386 = a;
return (target_fn.cljs$core$IFn$_invoke$arity$1 ? target_fn.cljs$core$IFn$_invoke$arity$1(G__10386) : target_fn.call(null,G__10386));
});
var G__11232__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10387 = a;
var G__10388 = b;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$2 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$2(G__10387,G__10388) : self__.dispatch_fn.call(null,G__10387,G__10388));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10389 = a;
var G__10390 = b;
return (target_fn.cljs$core$IFn$_invoke$arity$2 ? target_fn.cljs$core$IFn$_invoke$arity$2(G__10389,G__10390) : target_fn.call(null,G__10389,G__10390));
});
var G__11232__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10391 = a;
var G__10392 = b;
var G__10393 = c;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$3 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$3(G__10391,G__10392,G__10393) : self__.dispatch_fn.call(null,G__10391,G__10392,G__10393));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10394 = a;
var G__10395 = b;
var G__10396 = c;
return (target_fn.cljs$core$IFn$_invoke$arity$3 ? target_fn.cljs$core$IFn$_invoke$arity$3(G__10394,G__10395,G__10396) : target_fn.call(null,G__10394,G__10395,G__10396));
});
var G__11232__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10397 = a;
var G__10398 = b;
var G__10399 = c;
var G__10400 = d;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$4 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$4(G__10397,G__10398,G__10399,G__10400) : self__.dispatch_fn.call(null,G__10397,G__10398,G__10399,G__10400));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10401 = a;
var G__10402 = b;
var G__10403 = c;
var G__10404 = d;
return (target_fn.cljs$core$IFn$_invoke$arity$4 ? target_fn.cljs$core$IFn$_invoke$arity$4(G__10401,G__10402,G__10403,G__10404) : target_fn.call(null,G__10401,G__10402,G__10403,G__10404));
});
var G__11232__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10405 = a;
var G__10406 = b;
var G__10407 = c;
var G__10408 = d;
var G__10409 = e;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$5 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$5(G__10405,G__10406,G__10407,G__10408,G__10409) : self__.dispatch_fn.call(null,G__10405,G__10406,G__10407,G__10408,G__10409));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10410 = a;
var G__10411 = b;
var G__10412 = c;
var G__10413 = d;
var G__10414 = e;
return (target_fn.cljs$core$IFn$_invoke$arity$5 ? target_fn.cljs$core$IFn$_invoke$arity$5(G__10410,G__10411,G__10412,G__10413,G__10414) : target_fn.call(null,G__10410,G__10411,G__10412,G__10413,G__10414));
});
var G__11232__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10415 = a;
var G__10416 = b;
var G__10417 = c;
var G__10418 = d;
var G__10419 = e;
var G__10420 = f;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$6 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$6(G__10415,G__10416,G__10417,G__10418,G__10419,G__10420) : self__.dispatch_fn.call(null,G__10415,G__10416,G__10417,G__10418,G__10419,G__10420));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10421 = a;
var G__10422 = b;
var G__10423 = c;
var G__10424 = d;
var G__10425 = e;
var G__10426 = f;
return (target_fn.cljs$core$IFn$_invoke$arity$6 ? target_fn.cljs$core$IFn$_invoke$arity$6(G__10421,G__10422,G__10423,G__10424,G__10425,G__10426) : target_fn.call(null,G__10421,G__10422,G__10423,G__10424,G__10425,G__10426));
});
var G__11232__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10427 = a;
var G__10428 = b;
var G__10429 = c;
var G__10430 = d;
var G__10431 = e;
var G__10432 = f;
var G__10433 = g;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$7 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$7(G__10427,G__10428,G__10429,G__10430,G__10431,G__10432,G__10433) : self__.dispatch_fn.call(null,G__10427,G__10428,G__10429,G__10430,G__10431,G__10432,G__10433));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10434 = a;
var G__10435 = b;
var G__10436 = c;
var G__10437 = d;
var G__10438 = e;
var G__10439 = f;
var G__10440 = g;
return (target_fn.cljs$core$IFn$_invoke$arity$7 ? target_fn.cljs$core$IFn$_invoke$arity$7(G__10434,G__10435,G__10436,G__10437,G__10438,G__10439,G__10440) : target_fn.call(null,G__10434,G__10435,G__10436,G__10437,G__10438,G__10439,G__10440));
});
var G__11232__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10441 = a;
var G__10442 = b;
var G__10443 = c;
var G__10444 = d;
var G__10445 = e;
var G__10446 = f;
var G__10447 = g;
var G__10448 = h;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$8 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$8(G__10441,G__10442,G__10443,G__10444,G__10445,G__10446,G__10447,G__10448) : self__.dispatch_fn.call(null,G__10441,G__10442,G__10443,G__10444,G__10445,G__10446,G__10447,G__10448));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10449 = a;
var G__10450 = b;
var G__10451 = c;
var G__10452 = d;
var G__10453 = e;
var G__10454 = f;
var G__10455 = g;
var G__10456 = h;
return (target_fn.cljs$core$IFn$_invoke$arity$8 ? target_fn.cljs$core$IFn$_invoke$arity$8(G__10449,G__10450,G__10451,G__10452,G__10453,G__10454,G__10455,G__10456) : target_fn.call(null,G__10449,G__10450,G__10451,G__10452,G__10453,G__10454,G__10455,G__10456));
});
var G__11232__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10457 = a;
var G__10458 = b;
var G__10459 = c;
var G__10460 = d;
var G__10461 = e;
var G__10462 = f;
var G__10463 = g;
var G__10464 = h;
var G__10465 = i;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$9 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$9(G__10457,G__10458,G__10459,G__10460,G__10461,G__10462,G__10463,G__10464,G__10465) : self__.dispatch_fn.call(null,G__10457,G__10458,G__10459,G__10460,G__10461,G__10462,G__10463,G__10464,G__10465));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10466 = a;
var G__10467 = b;
var G__10468 = c;
var G__10469 = d;
var G__10470 = e;
var G__10471 = f;
var G__10472 = g;
var G__10473 = h;
var G__10474 = i;
return (target_fn.cljs$core$IFn$_invoke$arity$9 ? target_fn.cljs$core$IFn$_invoke$arity$9(G__10466,G__10467,G__10468,G__10469,G__10470,G__10471,G__10472,G__10473,G__10474) : target_fn.call(null,G__10466,G__10467,G__10468,G__10469,G__10470,G__10471,G__10472,G__10473,G__10474));
});
var G__11232__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10475 = a;
var G__10476 = b;
var G__10477 = c;
var G__10478 = d;
var G__10479 = e;
var G__10480 = f;
var G__10481 = g;
var G__10482 = h;
var G__10483 = i;
var G__10484 = j;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$10 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$10(G__10475,G__10476,G__10477,G__10478,G__10479,G__10480,G__10481,G__10482,G__10483,G__10484) : self__.dispatch_fn.call(null,G__10475,G__10476,G__10477,G__10478,G__10479,G__10480,G__10481,G__10482,G__10483,G__10484));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10485 = a;
var G__10486 = b;
var G__10487 = c;
var G__10488 = d;
var G__10489 = e;
var G__10490 = f;
var G__10491 = g;
var G__10492 = h;
var G__10493 = i;
var G__10494 = j;
return (target_fn.cljs$core$IFn$_invoke$arity$10 ? target_fn.cljs$core$IFn$_invoke$arity$10(G__10485,G__10486,G__10487,G__10488,G__10489,G__10490,G__10491,G__10492,G__10493,G__10494) : target_fn.call(null,G__10485,G__10486,G__10487,G__10488,G__10489,G__10490,G__10491,G__10492,G__10493,G__10494));
});
var G__11232__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10495 = a;
var G__10496 = b;
var G__10497 = c;
var G__10498 = d;
var G__10499 = e;
var G__10500 = f;
var G__10501 = g;
var G__10502 = h;
var G__10503 = i;
var G__10504 = j;
var G__10505 = k;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$11 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$11(G__10495,G__10496,G__10497,G__10498,G__10499,G__10500,G__10501,G__10502,G__10503,G__10504,G__10505) : self__.dispatch_fn.call(null,G__10495,G__10496,G__10497,G__10498,G__10499,G__10500,G__10501,G__10502,G__10503,G__10504,G__10505));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10506 = a;
var G__10507 = b;
var G__10508 = c;
var G__10509 = d;
var G__10510 = e;
var G__10511 = f;
var G__10512 = g;
var G__10513 = h;
var G__10514 = i;
var G__10515 = j;
var G__10516 = k;
return (target_fn.cljs$core$IFn$_invoke$arity$11 ? target_fn.cljs$core$IFn$_invoke$arity$11(G__10506,G__10507,G__10508,G__10509,G__10510,G__10511,G__10512,G__10513,G__10514,G__10515,G__10516) : target_fn.call(null,G__10506,G__10507,G__10508,G__10509,G__10510,G__10511,G__10512,G__10513,G__10514,G__10515,G__10516));
});
var G__11232__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10517 = a;
var G__10518 = b;
var G__10519 = c;
var G__10520 = d;
var G__10521 = e;
var G__10522 = f;
var G__10523 = g;
var G__10524 = h;
var G__10525 = i;
var G__10526 = j;
var G__10527 = k;
var G__10528 = l;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$12 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$12(G__10517,G__10518,G__10519,G__10520,G__10521,G__10522,G__10523,G__10524,G__10525,G__10526,G__10527,G__10528) : self__.dispatch_fn.call(null,G__10517,G__10518,G__10519,G__10520,G__10521,G__10522,G__10523,G__10524,G__10525,G__10526,G__10527,G__10528));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10529 = a;
var G__10530 = b;
var G__10531 = c;
var G__10532 = d;
var G__10533 = e;
var G__10534 = f;
var G__10535 = g;
var G__10536 = h;
var G__10537 = i;
var G__10538 = j;
var G__10539 = k;
var G__10540 = l;
return (target_fn.cljs$core$IFn$_invoke$arity$12 ? target_fn.cljs$core$IFn$_invoke$arity$12(G__10529,G__10530,G__10531,G__10532,G__10533,G__10534,G__10535,G__10536,G__10537,G__10538,G__10539,G__10540) : target_fn.call(null,G__10529,G__10530,G__10531,G__10532,G__10533,G__10534,G__10535,G__10536,G__10537,G__10538,G__10539,G__10540));
});
var G__11232__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10541 = a;
var G__10542 = b;
var G__10543 = c;
var G__10544 = d;
var G__10545 = e;
var G__10546 = f;
var G__10547 = g;
var G__10548 = h;
var G__10549 = i;
var G__10550 = j;
var G__10551 = k;
var G__10552 = l;
var G__10553 = m;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$13 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$13(G__10541,G__10542,G__10543,G__10544,G__10545,G__10546,G__10547,G__10548,G__10549,G__10550,G__10551,G__10552,G__10553) : self__.dispatch_fn.call(null,G__10541,G__10542,G__10543,G__10544,G__10545,G__10546,G__10547,G__10548,G__10549,G__10550,G__10551,G__10552,G__10553));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10554 = a;
var G__10555 = b;
var G__10556 = c;
var G__10557 = d;
var G__10558 = e;
var G__10559 = f;
var G__10560 = g;
var G__10561 = h;
var G__10562 = i;
var G__10563 = j;
var G__10564 = k;
var G__10565 = l;
var G__10566 = m;
return (target_fn.cljs$core$IFn$_invoke$arity$13 ? target_fn.cljs$core$IFn$_invoke$arity$13(G__10554,G__10555,G__10556,G__10557,G__10558,G__10559,G__10560,G__10561,G__10562,G__10563,G__10564,G__10565,G__10566) : target_fn.call(null,G__10554,G__10555,G__10556,G__10557,G__10558,G__10559,G__10560,G__10561,G__10562,G__10563,G__10564,G__10565,G__10566));
});
var G__11232__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
va