(defproject bensu/json-html "0.4.0-SNAPSHOT"
  :description "Provide JSON and get a DOM node with a human representation of that JSON"
  :url "https://github.com/yogthos/json-html"
  :license {:name "MIT License"
            :url "http://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.7.0"]
                 [org.clojure/clojurescript "1.8.51" :scope "provided"]
                 [hiccup "1.0.5"]
                 [hiccups "0.3.0"]
                 [cheshire "5.6.1"]]

  :clojurescript? true
  :jar-exclusions [#"\.swp|\.swo|\.DS_Store"]
  :plugins [[lein-cljsbuild "1.1.3"]
            [lein-figwheel "0.5.8" :exclusions [org.clojure/clojure]]]
  :hooks [leiningen.cljsbuild]
  :cljsbuild
  {:builds
     {:main
      {:jar true
       :figwheel true
       :compiler {:output-to "playground/main.js"
                  :output-dir "playground/out"
                  :asset-path "out"
                  :optimizations :none
                  :main playground.test}
       :source-paths ["src-cljs"]}}})
