(ns playground.test
  (:require [json-html.core :as json-html]
            [goog.dom :as dom]))


(extend-protocol json-html/IRenderHTML
  cljs.core/UUID
  (render-html [u]
    [:span.jh-type-string (str u)]))

(let [root (dom/getElement "container")]
  (set! (.-innerHTML root) (json-html/edn->html {:a 1
                                                 :b "asfd"
                                                 :f 3
                                                 :h (random-uuid)
                                                 [:a :c] #{:a}})))
