(ns dropblog.post.io
 (:require [dropblog.settings :as settings]
           [clojure.java.io :as io]))

(defn get-post-name [p]
 (if (string? p)
  p
  (.getName p)))

(defn get-post-path [pname]
 (let [is-html (re-find #"\.html$" pname)
       is-markdown (re-find #"\.(md|markdown)$" pname)
       prefix (cond
               is-html settings/posts-directory-html
               is-markdown settings/posts-directory-markdown
               :else "")]
  (str prefix pname)))

(defn file [f]
 (let [-f (io/file f)]
  (if (.exists -f)
   -f
   (io/file (get-post-path f)))))

(defmacro file-operation [op args & body]
 `(defn ~op [post# & content#]
   (let [post-name# (get-post-name post#)
         post-agent# (agent nil)
         post-path# (get-post-path post-name#)]
    (send post-agent# (fn [_#]
                       (let [~args (concat [post-path#] content#)]
                        ~@body)))
    (await post-agent#)
    (agent-error post-agent#)
    @post-agent#)))

(file-operation slurp [post-path]
 (clojure.core/slurp post-path))

(file-operation spit [post-path c]
 (clojure.core/spit post-path c))