(ns devcards.boundary
  (:require [helix.core :as hx :refer [defnc $]]
            [helix.dom :as d]))

(defonce epoch (atom 0))

(defn ^:dev/after-load inc-epoch
  "The epoch is increased every time after a reload, to avoid the error
  boundary ui being shown even after the error is fixed."
  []
  (swap! epoch inc))

(hx/defcomponent error-boundary
  (constructor [this]
    (set! (.-state this) #js {:error nil}))

  ^:static
  (getDerivedStateFromError [this error]
    #js {:error error
         :epoch @epoch})

  (hasError [this]
    (and (.. this -state -error)
         (= (.. this -state -epoch) @epoch)))

  (render [this]
    (set! (.-eb1 js/window) this)
    ;; (js/console.log "devcards/error-boundary rendering")
    (if (.hasError this)
      (d/div
       (d/pre (.. this -state -error -stack)))
      (.. this -props -children))))
