/*
 * Decompiled with CFR 0.152.
 */
package bcbio.variation.annotate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ExperimentalAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class ReadPosEndDist
extends InfoFieldAnnotation
implements ExperimentalAnnotation {
    public List<String> getKeyNames() {
        return Arrays.asList("ReadPosEndDist");
    }

    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("ReadPosEndDist", 1, VCFHeaderLineType.Float, "Parameters indicating incorrect local alignments: 1. Mean distance from either end of read "));
    }

    public Map<String, Object> annotate(RefMetaDataTracker refMetaDataTracker, AnnotatorCompatible annotatorCompatible, ReferenceContext referenceContext, Map<String, AlignmentContext> map2, VariantContext variantContext) {
        if (map2.size() == 0) {
            return null;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (Map.Entry<String, AlignmentContext> entry2 : map2.entrySet()) {
            for (PileupElement pileupElement : entry2.getValue().getBasePileup()) {
                int n;
                int n2 = AlignmentUtils.calcAlignmentByteArrayOffset((Cigar)pileupElement.getRead().getCigar(), (PileupElement)pileupElement, (int)0, (int)0);
                if (n2 > (n = AlignmentUtils.getNumAlignedBases((SAMRecord)pileupElement.getRead())) / 2) {
                    n2 = n - (n2 + 1);
                }
                d += (double)n2;
                d2 += 1.0;
            }
        }
        HashMap hashMap = new HashMap();
        hashMap.put(this.getKeyNames().get(0), String.format("%.01f", d / d2));
        return hashMap;
    }

    int getNumClippedBasesAtStart(SAMRecord sAMRecord) {
        Cigar cigar = sAMRecord.getCigar();
        CigarElement cigarElement = cigar.getCigarElement(0);
        int n = 0;
        if (cigarElement.getOperator() == CigarOperator.H) {
            n = cigarElement.getLength();
        }
        byte[] byArray = sAMRecord.getReadBases();
        byte[] byArray2 = sAMRecord.getBaseQualities();
        for (int i = n; i < byArray.length && byArray2[i] < 20; ++i) {
            ++n;
        }
        return n;
    }

    int getNumAlignedBases(SAMRecord sAMRecord) {
        return sAMRecord.getReadLength() - this.getNumClippedBasesAtStart(sAMRecord) - this.getNumClippedBasesAtEnd(sAMRecord);
    }

    int getNumClippedBasesAtEnd(SAMRecord sAMRecord) {
        Cigar cigar = sAMRecord.getCigar();
        CigarElement cigarElement = cigar.getCigarElement(cigar.numCigarElements() - 1);
        int n = 0;
        if (cigarElement.getOperator() == CigarOperator.H) {
            n = cigarElement.getLength();
        }
        byte[] byArray = sAMRecord.getReadBases();
        byte[] byArray2 = sAMRecord.getBaseQualities();
        for (int i = byArray.length - n - 1; i >= 0 && byArray2[i] < 20; --i) {
            ++n;
        }
        return n;
    }

    int getOffsetFromClippedReadStart(SAMRecord sAMRecord, int n) {
        return n - this.getNumClippedBasesAtStart(sAMRecord);
    }
}

