/*
 * Decompiled with CFR 0.152.
 */
package bcbio.variation.annotate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ExperimentalAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.genotyper.IndelGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class MostProbableGenotype
extends InfoFieldAnnotation
implements ExperimentalAnnotation {
    private static final String MPG = "MPG";

    public Map<String, Object> annotate(RefMetaDataTracker refMetaDataTracker, AnnotatorCompatible annotatorCompatible, ReferenceContext referenceContext, Map<String, AlignmentContext> map2, VariantContext variantContext) {
        if (!variantContext.isBiallelic() || !variantContext.isSNP()) {
            return null;
        }
        double[] dArray = MostProbableGenotype.calcSNPMPGs(map2, variantContext.getReference(), variantContext.getAlternateAllele(0));
        if (dArray == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("MPGHomRef", dArray[0]);
        hashMap.put("MPGHetRef", dArray[1]);
        hashMap.put("MPGHomVar", dArray[2]);
        hashMap.put("MPGLikHomRef", dArray[3]);
        hashMap.put("MPGLikHetRef", dArray[4]);
        hashMap.put("MPGLikHomVar", dArray[5]);
        return hashMap;
    }

    public List<String> getKeyNames() {
        return Arrays.asList("MPGHomRef", "MPGHetRef", "MPGHomVar", "MPGLikHomRef", "MPGLikHetRef", "MPGLikHomVar");
    }

    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("MPGHomRef", 1, VCFHeaderLineType.Float, "Most Probable Genotype likelihood ratio for Hom Ref"), new VCFInfoHeaderLine("MPGHetRef", 1, VCFHeaderLineType.Float, "Most Probable Genotype likelihood ratio for Het Ref"), new VCFInfoHeaderLine("MPGHomVar", 1, VCFHeaderLineType.Float, "Most Probable Genotype likelihood ratio for Hom Var"), new VCFInfoHeaderLine("MPGLikHomRef", 1, VCFHeaderLineType.Float, "Raw likelihood for Hom Ref"), new VCFInfoHeaderLine("MPGLikHetRef", 1, VCFHeaderLineType.Float, "Raw likelihood for Het Ref"), new VCFInfoHeaderLine("MPGLikHomVar", 1, VCFHeaderLineType.Float, "Raw likelihood for Hom Var"));
    }

    private static double[] calcSNPMPGs(Map<String, AlignmentContext> map2, Allele allele, Allele allele2) {
        int n = 2;
        double[] dArray = new double[n + 1];
        double[] dArray2 = new double[6];
        Arrays.fill(dArray, 0.0);
        Arrays.fill(dArray2, 0.0);
        for (Map.Entry<String, AlignmentContext> entry2 : map2.entrySet()) {
            for (PileupElement pileupElement : entry2.getValue().getBasePileup()) {
                if (pileupElement.isDeletion()) continue;
                Allele allele3 = Allele.create((byte)pileupElement.getBase(), (boolean)false);
                boolean bl = allele.equals(allele3, true);
                boolean bl2 = allele2.equals(allele3, true);
                double d = Math.pow(10.0, -1.0 * ((double)pileupElement.getQual() / 10.0));
                int n2 = 0;
                double[] dArray3 = new double[n + 1];
                if (bl) {
                    for (n2 = 0; n2 <= n; ++n2) {
                        dArray3[n2] = Math.log10((double)n2 / (double)n * (1.0 - d) + (1.0 - (double)n2 / (double)n) * d);
                    }
                } else {
                    for (n2 = 0; n2 <= n; ++n2) {
                        dArray3[n2] = Math.log10(1.0 - ((double)n2 / (double)n * (1.0 - d) + (1.0 - (double)n2 / (double)n) * d));
                    }
                }
                for (n2 = 0; n2 <= n; ++n2) {
                    int n3 = n2;
                    dArray[n3] = dArray[n3] + dArray3[n2];
                }
            }
        }
        boolean bl = false;
        dArray2[0] = dArray[0] < dArray[1] ? dArray[2] - dArray[1] : dArray[2] - dArray[0];
        dArray2[1] = dArray[0] < dArray[2] ? dArray[1] - dArray[2] : dArray[1] - dArray[0];
        dArray2[2] = dArray[2] < dArray[1] ? dArray[0] - dArray[1] : dArray[0] - dArray[2];
        dArray2[3] = -1.0 * dArray[2];
        dArray2[4] = -1.0 * dArray[1];
        dArray2[5] = -1.0 * dArray[0];
        return dArray2;
    }

    private static int[][] getIndelContingencyTable(Map<String, AlignmentContext> map2, VariantContext variantContext) {
        HashMap hashMap = IndelGenotypeLikelihoodsCalculationModel.getIndelLikelihoodMap();
        if (hashMap == null) {
            return null;
        }
        int[][] nArray = new int[2][2];
        for (String string : map2.keySet()) {
            ReadBackedPileup readBackedPileup;
            AlignmentContext alignmentContext = map2.get(string);
            if (alignmentContext == null || (readBackedPileup = alignmentContext.getBasePileup()) == null) continue;
            for (PileupElement pileupElement : readBackedPileup) {
                boolean bl;
                if (pileupElement.getRead().getMappingQuality() < 20 || !hashMap.containsKey(pileupElement)) continue;
                LinkedHashMap linkedHashMap = (LinkedHashMap)hashMap.get(pileupElement);
                boolean bl2 = !pileupElement.getRead().getReadNegativeStrandFlag();
                double d = 0.0;
                double d2 = Double.NEGATIVE_INFINITY;
                for (Allele allele : linkedHashMap.keySet()) {
                    if (allele.isReference()) {
                        d = (Double)linkedHashMap.get(allele);
                        continue;
                    }
                    double d3 = (Double)linkedHashMap.get(allele);
                    if (!(d3 >= d2)) continue;
                    d2 = d3;
                }
                boolean bl3 = d > d2 + 0.3;
                boolean bl4 = bl = d2 > d + 0.3;
                if (!bl3 && !bl) continue;
                int n = bl3 ? 0 : 1;
                int n2 = bl2 ? 0 : 1;
                int[] nArray2 = nArray[n];
                int n3 = n2;
                nArray2[n3] = nArray2[n3] + 1;
            }
        }
        return nArray;
    }
}

