/*
 * Decompiled with CFR 0.152.
 */
package bcbio.variation.annotate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ExperimentalAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.genotyper.IndelGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class AlleleBalanceConfidenceInterval
extends InfoFieldAnnotation
implements ExperimentalAnnotation {
    private static final String ABCI = "ABCI";

    public Map<String, Object> annotate(RefMetaDataTracker refMetaDataTracker, AnnotatorCompatible annotatorCompatible, ReferenceContext referenceContext, Map<String, AlignmentContext> map2, VariantContext variantContext) {
        if (!variantContext.isBiallelic() || !variantContext.isSNP()) {
            return null;
        }
        double[] dArray = AlleleBalanceConfidenceInterval.calcSNPCIs(map2, variantContext.getReference(), variantContext.getAlternateAllele(0));
        if (dArray == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ABCI5", dArray[0]);
        hashMap.put("ABCI50", dArray[1]);
        hashMap.put("ABCI95", dArray[2]);
        return hashMap;
    }

    public List<String> getKeyNames() {
        return Arrays.asList("ABCI5", "ABCI50", "ABCI95");
    }

    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("ABCI5", 1, VCFHeaderLineType.Float, "Allele Balance lower 5% confidence interval"), new VCFInfoHeaderLine("ABCI50", 1, VCFHeaderLineType.Float, "Allele Balance middle 50% confidence interval"), new VCFInfoHeaderLine("ABCI95", 1, VCFHeaderLineType.Float, "Allele Balance upper 5% confidence interval"));
    }

    private static double[] calcSNPCIs(Map<String, AlignmentContext> map2, Allele allele, Allele allele2) {
        int n = 100;
        double[] dArray = new double[n + 1];
        double[] dArray2 = new double[3];
        Arrays.fill(dArray, 0.0);
        Arrays.fill(dArray2, 0.0);
        for (Map.Entry<String, AlignmentContext> entry2 : map2.entrySet()) {
            for (PileupElement pileupElement : entry2.getValue().getBasePileup()) {
                if (pileupElement.isDeletion()) continue;
                Allele allele3 = Allele.create((byte)pileupElement.getBase(), (boolean)false);
                boolean bl = allele.equals(allele3, true);
                boolean bl2 = allele2.equals(allele3, true);
                double d = Math.pow(10.0, -1.0 * ((double)pileupElement.getQual() / 10.0));
                int n2 = 0;
                double[] dArray3 = new double[n + 1];
                if (bl) {
                    for (n2 = 0; n2 <= n; ++n2) {
                        dArray3[n2] = Math.log10((double)n2 / (double)n * (1.0 - d) + (1.0 - (double)n2 / (double)n) * d);
                    }
                } else {
                    for (n2 = 0; n2 <= n; ++n2) {
                        dArray3[n2] = Math.log10(1.0 - ((double)n2 / (double)n * (1.0 - d) + (1.0 - (double)n2 / (double)n) * d));
                    }
                }
                for (n2 = 0; n2 <= n; ++n2) {
                    int n3 = n2;
                    dArray[n3] = dArray[n3] + dArray3[n2];
                }
            }
        }
        for (int i = 0; i <= n; ++i) {
            if (dArray[i] == 0.0) continue;
            dArray[i] = Math.pow(10.0, dArray[i]);
        }
        AlleleBalanceConfidenceInterval.calcCIsFromProb(dArray2, dArray, n, 1);
        return dArray2;
    }

    private static void calcCIsFromProb(double[] dArray, double[] dArray2, int n, int n2) {
        int n3;
        double d = 0.0;
        for (n3 = 0; n3 <= n; ++n3) {
            d += dArray2[n3];
        }
        if (d <= 0.0) {
            dArray[n2 * 3 - 3] = 2.0;
            dArray[n2 * 3 - 2] = 2.0;
            dArray[n2 * 3 - 1] = 2.0;
        } else {
            double d2 = 0.0;
            double d3 = d * 0.05;
            double d4 = d * 0.5;
            double d5 = d * 0.95;
            n3 = 0;
            while (d2 <= d3) {
                d2 += dArray2[n3];
                ++n3;
            }
            dArray[n2 * 3 - 3] = n3 == 0 ? 0.0 : ((double)n3 - 1.0 - (d2 - d3) / dArray2[n3 - 1]) / (double)n;
            while (d2 <= d4) {
                d2 += dArray2[n3];
                ++n3;
            }
            dArray[n2 * 3 - 2] = n3 == 0 ? 0.0 : ((double)n3 - 1.0 - (d2 - d4) / dArray2[n3 - 1]) / (double)n;
            while (d2 <= d5) {
                d2 += dArray2[n3];
                ++n3;
            }
            dArray[n2 * 3 - 1] = n3 == 0 ? 0.0 : ((double)n3 - 1.0 - (d2 - d5) / dArray2[n3 - 1]) / (double)n;
        }
    }

    private static int[][] getIndelContingencyTable(Map<String, AlignmentContext> map2, VariantContext variantContext) {
        HashMap hashMap = IndelGenotypeLikelihoodsCalculationModel.getIndelLikelihoodMap();
        if (hashMap == null) {
            return null;
        }
        int[][] nArray = new int[2][2];
        for (String string : map2.keySet()) {
            ReadBackedPileup readBackedPileup;
            AlignmentContext alignmentContext = map2.get(string);
            if (alignmentContext == null || (readBackedPileup = alignmentContext.getBasePileup()) == null) continue;
            for (PileupElement pileupElement : readBackedPileup) {
                boolean bl;
                if (pileupElement.getRead().getMappingQuality() < 20 || !hashMap.containsKey(pileupElement)) continue;
                LinkedHashMap linkedHashMap = (LinkedHashMap)hashMap.get(pileupElement);
                boolean bl2 = !pileupElement.getRead().getReadNegativeStrandFlag();
                double d = 0.0;
                double d2 = Double.NEGATIVE_INFINITY;
                for (Allele allele : linkedHashMap.keySet()) {
                    if (allele.isReference()) {
                        d = (Double)linkedHashMap.get(allele);
                        continue;
                    }
                    double d3 = (Double)linkedHashMap.get(allele);
                    if (!(d3 >= d2)) continue;
                    d2 = d3;
                }
                boolean bl3 = d > d2 + 0.3;
                boolean bl4 = bl = d2 > d + 0.3;
                if (!bl3 && !bl) continue;
                int n = bl3 ? 0 : 1;
                int n2 = bl2 ? 0 : 1;
                int[] nArray2 = nArray[n];
                int n3 = n2;
                nArray2[n3] = nArray2[n3] + 1;
            }
        }
        return nArray;
    }
}

