(ns simple.core
  (:require [clue.core :as c]
            [clue.template :as ct]))

(def count
  {:data {:count 0}
   :methods {:increment #(swap! (c/data %) update :count inc)
             :decrement #(swap! (c/data %) update :count dec)}
   :template [:div
              [:div
               [:button {(ct/on :click) :increment} "+"]]
              [:div
               [:span (ct/interpolate :count)]]
              [:div
               [:button {(ct/on :click) :decrement} "-"]]]})

(def testing
  {:components {:count count}
   :data {:list [0]}
   :methods {:push #(swap! (c/data %1) update :list conj 1)
             :pop #(swap! (c/data %) update :list pop)}
   :template [:div
              [:count]
              [:div (ct/interpolate :list)]
              [:div
               [:button {(ct/on :click) (ct/with-params :push)} "push"]]
              [:div
               [:button {(ct/on :click) :pop} "pop"]]
              (ct/for [:elem :list]
                [:div (ct/interpolate :elem)])]})

(defn start! []
  (c/render! c/Vue testing "#app"))