(ns clue.vue
  (:require [clue.adapters :as ca]
            [clue.protocols.vue :as p.vue]))

(defn with-adapter [vue key adapter]
  (update vue :adapters assoc key adapter))

(defn render* [vue component]
  (fn [h]
    (-> vue
        (ca/adapt-opts component)
        h)))

(defn render! [vue component el]
  (-> {:el el :render (render* vue component)}
      clj->js
      (js/Vue.)))

(defn use! [plugin]
  (js/Vue.use plugin))

(defrecord Vue []
  p.vue/IVue
  (with-adapter [this key adapter]
    (with-adapter this key adapter))
  (render! [this component el]
    (render! this component el))
  (component! [this comp-name opts]
    (.component js/Vue (name comp-name) (ca/adapt-opts this opts))))

(defn new-vue []
  (map->Vue {:adapters ca/adapters}))
