(ns clue.misc)

(declare ->js-str*)

(defn tap [val]
  (println val)
  val)

(defn map-values [m f]
  (into {} (for [[k v] m] [k (f v)])))

(defn map-keys [m f]
  (into {} (for [[k v] m] [(f k) v])))

(defn keywordize-keys [value]
  (map-keys value keyword))

(defn vec->js-str* [v]
  (let [str-values (->> v
                        (map ->js-str*)
                        (clojure.string/join ", "))]
    (str "[" str-values "]")))

(defn ->js-str* [v]
  (cond
    (nil? v) "null"
    (keyword? v) (name v)
    (or (seq? v) (vector? v)) (vec->js-str* v)
    :else (str v)))

(defn ->js-str [& vs]
  (->> vs
       (map ->js-str*)
       (apply str)))

(defn keywords? [map]
  (->> map
       keys
       (every? keyword?)))