(ns clue.adapters
  (:require [clue.misc :as misc]
            [clue.vue-instance :as cvi]
            [hiccups.runtime :as hiccupsrt]))

(declare adapt-opts)

(defn data->js [_ data]
  (fn [] (-> data misc/keywordize-keys clj->js)))

(defn method->js [_ method]
  (fn [& args]
    (let [instance (cvi/new-vue-instance (js-this))]
      (apply method instance args))))

(defn methods->js [vue methods]
  (-> methods
      (misc/map-values (partial method->js vue))
      clj->js))

(defn template->js [_ template]
  (hiccupsrt/render-html template))

(defn components->js [vue components]
  (-> components
      (misc/map-values (partial adapt-opts vue))
      clj->js))

(def adapters {:data       data->js
               :methods    methods->js
               :template   template->js
               :components components->js})

(defn adapt [vue opts key]
  (let [adapter (get (:adapters vue) key)]
    (if (nil? (get opts key))
      opts
      (update opts key (partial adapter vue)))))

(defn adapt-opts [vue opts]
  (->> vue
       :adapters
       keys
       (reduce (partial adapt vue) opts)
       clj->js))
