(defproject bbromero/clue "0.1.0"
  :dependencies
  [[thheller/shadow-cljs "1.0.20170629"]
   [org.clojure/clojure "1.10.0"]
   [org.clojure/clojurescript "1.10.520"]
   [hiccups "0.3.0"]
   [cljsjs/vue "2.5.2-0"]
   [com.cognitect/transit-clj "0.8.313"]
   [org.clojure/core.rrb-vector "0.0.14"]]

  :plugins
  [[lein-cljsbuild "1.1.7"]
   [lein-doo "0.1.10"]
   [lein-cljfmt "0.6.4"]
   [jonase/eastwood "0.3.5"]
   [lein-nsorg "0.3.0"]]

  :source-paths
  ["src" "test" "examples"]

  :doo {:build "test"
        :alias {:default [:chrome]}}

  :aliases {"lint"     ["do" ["cljfmt" "check"] ["nsorg"] ["eastwood" "{:namespaces [:source-paths]}"]]
            "lint-fix" ["do" ["cljfmt" "fix"] ["nsorg" "--replace"]]}
  :cljsbuild
  {:builds {:minify {:source-paths ["src"]
                     :compiler {:optimizations :advanced
                                :pretty-print false}}
            :test {:source-paths ["src" "test"]
                   :compiler {:main runner
                              :optimizations :none
                              :output-to "public/js/testable.js"}}}})